=begin comment

PeakForest REST API

API specification to support \"PeakForest - REST API\" operations

The version of the OpenAPI document: 2.3.4
Contact: contact@peakforest.org
Generated by: https://openapi-generator.tech

=end comment

=cut

#
# NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
# Do not edit the class manually.
# Ref: https://openapi-generator.tech
#
package PeakForest::REST_Client::CompoundsApi;

require 5.6.0;
use strict;
use warnings;
use utf8;
use Exporter;
use Carp qw( croak );
use Log::Any qw($log);

use PeakForest::REST_Client::ApiClient;

use base "Class::Data::Inheritable";

our $VERSION = '2.3.0';

__PACKAGE__->mk_classdata('method_documentation' => {});

sub new {
    my $class = shift;
    my $api_client;

    if ($_[0] && ref $_[0] && ref $_[0] eq 'PeakForest::REST_Client::ApiClient' ) {
        $api_client = $_[0];
    } else {
        $api_client = PeakForest::REST_Client::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}


#
# get_compound
#
# Get a compound by its PeakForest ID or its InChIKey
#
# @param string $id The compound PeakForest ID or its InChIKey. (required)
{
    my $params = {
    'id' => {
        data_type => 'string',
        description => 'The compound PeakForest ID or its InChIKey.',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_compound' } = {
        summary => 'Get a compound by its PeakForest ID or its InChIKey',
        params => $params,
        returns => 'Compound',
        };
}
# @return Compound
#
sub get_compound {
    my ($self, %args) = @_;

    # verify the required parameter 'id' is set
    unless (exists $args{'id'}) {
      croak("Missing the required parameter 'id' when calling get_compound");
    }

    # parse inputs
    my $_resource_path = '/compound/{id}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'id'}) {
        my $_base_variable = "{" . "id" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(ApiKeyToken ApiKeyAuth )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Compound', $response);
    return $_response_object;
}

#
# get_compound_by_ext_id
#
# Get a compound by its external database ID
#
# @param string $ext_id The compound PeakForest ID or its InChIKey. (required)
# @param string $id The compound&#39;s external database ID. (required)
{
    my $params = {
    'ext_id' => {
        data_type => 'string',
        description => 'The compound PeakForest ID or its InChIKey.',
        required => '1',
    },
    'id' => {
        data_type => 'string',
        description => 'The compound&#39;s external database ID.',
        required => '1',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_compound_by_ext_id' } = {
        summary => 'Get a compound by its external database ID',
        params => $params,
        returns => 'Compound',
        };
}
# @return Compound
#
sub get_compound_by_ext_id {
    my ($self, %args) = @_;

    # verify the required parameter 'ext_id' is set
    unless (exists $args{'ext_id'}) {
      croak("Missing the required parameter 'ext_id' when calling get_compound_by_ext_id");
    }

    # verify the required parameter 'id' is set
    unless (exists $args{'id'}) {
      croak("Missing the required parameter 'id' when calling get_compound_by_ext_id");
    }

    # parse inputs
    my $_resource_path = '/compound/{extId}/{id}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'ext_id'}) {
        my $_base_variable = "{" . "extId" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'ext_id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    # path params
    if ( exists $args{'id'}) {
        my $_base_variable = "{" . "id" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'id'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(ApiKeyToken ApiKeyAuth )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('Compound', $response);
    return $_response_object;
}

#
# get_compounds
#
# Get / search compounds
#
# @param string $query the optional search query (name like, formula, ...) (optional)
# @param string $query_filter the optional search query filter (optional)
# @param double $mass_average The average mass to match (optional)
# @param double $mass_exact The exact mass to match (also known as \&quot;Monoisotopic Mass\&quot;) (optional)
# @param double $logp The LogP to match (optional)
# @param double $delta The number value matching tolerance (search \&quot;value ± delta\&quot;, only if either &#39;mass_average&#39;, &#39;mass_delta&#39; or &#39;logp&#39; is setted) (optional, default to 0.001)
# @param int $stars The minimal number of stars of compounds to filter (comounds curation level; optional) (optional)
# @param boolean $is_bioactive \&quot;Filter compound on &#39;biological activity&#39; flag. (optional; warning: do not process compounds that could not be determine as bioactive or not)\&quot;  (optional)
# @param int $offset The number of items to skip before starting to collect the result set. (optional, default to 0)
# @param int $limit The numbers of items to return. (optional, default to 20)
{
    my $params = {
    'query' => {
        data_type => 'string',
        description => 'the optional search query (name like, formula, ...)',
        required => '0',
    },
    'query_filter' => {
        data_type => 'string',
        description => 'the optional search query filter',
        required => '0',
    },
    'mass_average' => {
        data_type => 'double',
        description => 'The average mass to match',
        required => '0',
    },
    'mass_exact' => {
        data_type => 'double',
        description => 'The exact mass to match (also known as \&quot;Monoisotopic Mass\&quot;)',
        required => '0',
    },
    'logp' => {
        data_type => 'double',
        description => 'The LogP to match',
        required => '0',
    },
    'delta' => {
        data_type => 'double',
        description => 'The number value matching tolerance (search \&quot;value ± delta\&quot;, only if either &#39;mass_average&#39;, &#39;mass_delta&#39; or &#39;logp&#39; is setted)',
        required => '0',
    },
    'stars' => {
        data_type => 'int',
        description => 'The minimal number of stars of compounds to filter (comounds curation level; optional)',
        required => '0',
    },
    'is_bioactive' => {
        data_type => 'boolean',
        description => '\&quot;Filter compound on &#39;biological activity&#39; flag. (optional; warning: do not process compounds that could not be determine as bioactive or not)\&quot; ',
        required => '0',
    },
    'offset' => {
        data_type => 'int',
        description => 'The number of items to skip before starting to collect the result set.',
        required => '0',
    },
    'limit' => {
        data_type => 'int',
        description => 'The numbers of items to return.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_compounds' } = {
        summary => 'Get / search compounds',
        params => $params,
        returns => 'ARRAY[Compound]',
        };
}
# @return ARRAY[Compound]
#
sub get_compounds {
    my ($self, %args) = @_;

    # parse inputs
    my $_resource_path = '/compounds';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'query'}) {
        $query_params->{'query'} = $self->{api_client}->to_query_value($args{'query'});
    }

    # query params
    if ( exists $args{'query_filter'}) {
        $query_params->{'query_filter'} = $self->{api_client}->to_query_value($args{'query_filter'});
    }

    # query params
    if ( exists $args{'mass_average'}) {
        $query_params->{'mass_average'} = $self->{api_client}->to_query_value($args{'mass_average'});
    }

    # query params
    if ( exists $args{'mass_exact'}) {
        $query_params->{'mass_exact'} = $self->{api_client}->to_query_value($args{'mass_exact'});
    }

    # query params
    if ( exists $args{'logp'}) {
        $query_params->{'logp'} = $self->{api_client}->to_query_value($args{'logp'});
    }

    # query params
    if ( exists $args{'delta'}) {
        $query_params->{'delta'} = $self->{api_client}->to_query_value($args{'delta'});
    }

    # query params
    if ( exists $args{'stars'}) {
        $query_params->{'stars'} = $self->{api_client}->to_query_value($args{'stars'});
    }

    # query params
    if ( exists $args{'is_bioactive'}) {
        $query_params->{'is_bioactive'} = $self->{api_client}->to_query_value($args{'is_bioactive'});
    }

    # query params
    if ( exists $args{'offset'}) {
        $query_params->{'offset'} = $self->{api_client}->to_query_value($args{'offset'});
    }

    # query params
    if ( exists $args{'limit'}) {
        $query_params->{'limit'} = $self->{api_client}->to_query_value($args{'limit'});
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(ApiKeyToken ApiKeyAuth )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('ARRAY[Compound]', $response);
    return $_response_object;
}

#
# get_compounds_properties
#
# Get / search compounds, and return custum objects
#
# @param ARRAY[string] $properties  (required)
# @param string $query the optional search query (name like, formula, ...) (optional)
# @param string $query_filter the optional search query filter (optional)
# @param double $mass_average The average mass to match (optional)
# @param double $mass_exact The exact mass to match (also known as \&quot;Monoisotopic Mass\&quot;) (optional)
# @param double $logp The LogP to match (optional)
# @param double $delta The value matching tolerance (search \&quot;value ± delta\&quot;, only if either &#39;mass_average&#39;, &#39;mass_delta&#39; or &#39;logp&#39; is setted) (optional, default to 0.001)
# @param int $stars The minimal number of stars of compounds to filter (comounds curation level; optional) (optional)
# @param boolean $is_bioactive \&quot;Filter compound on &#39;biological activity&#39; flag. (optional; warning: do not process compounds that could not be determine as bioactive or not)\&quot;  (optional)
# @param int $offset The number of items to skip before starting to collect the result set. (optional, default to 0)
# @param int $limit The numbers of items to return. (optional, default to 20)
{
    my $params = {
    'properties' => {
        data_type => 'ARRAY[string]',
        description => '',
        required => '1',
    },
    'query' => {
        data_type => 'string',
        description => 'the optional search query (name like, formula, ...)',
        required => '0',
    },
    'query_filter' => {
        data_type => 'string',
        description => 'the optional search query filter',
        required => '0',
    },
    'mass_average' => {
        data_type => 'double',
        description => 'The average mass to match',
        required => '0',
    },
    'mass_exact' => {
        data_type => 'double',
        description => 'The exact mass to match (also known as \&quot;Monoisotopic Mass\&quot;)',
        required => '0',
    },
    'logp' => {
        data_type => 'double',
        description => 'The LogP to match',
        required => '0',
    },
    'delta' => {
        data_type => 'double',
        description => 'The value matching tolerance (search \&quot;value ± delta\&quot;, only if either &#39;mass_average&#39;, &#39;mass_delta&#39; or &#39;logp&#39; is setted)',
        required => '0',
    },
    'stars' => {
        data_type => 'int',
        description => 'The minimal number of stars of compounds to filter (comounds curation level; optional)',
        required => '0',
    },
    'is_bioactive' => {
        data_type => 'boolean',
        description => '\&quot;Filter compound on &#39;biological activity&#39; flag. (optional; warning: do not process compounds that could not be determine as bioactive or not)\&quot; ',
        required => '0',
    },
    'offset' => {
        data_type => 'int',
        description => 'The number of items to skip before starting to collect the result set.',
        required => '0',
    },
    'limit' => {
        data_type => 'int',
        description => 'The numbers of items to return.',
        required => '0',
    },
    };
    __PACKAGE__->method_documentation->{ 'get_compounds_properties' } = {
        summary => 'Get / search compounds, and return custum objects',
        params => $params,
        returns => 'object',
        };
}
# @return object
#
sub get_compounds_properties {
    my ($self, %args) = @_;

    # verify the required parameter 'properties' is set
    unless (exists $args{'properties'}) {
      croak("Missing the required parameter 'properties' when calling get_compounds_properties");
    }

    # parse inputs
    my $_resource_path = '/compounds/{properties}';

    my $_method = 'GET';
    my $query_params = {};
    my $header_params = {};
    my $form_params = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept('application/json');
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'query'}) {
        $query_params->{'query'} = $self->{api_client}->to_query_value($args{'query'});
    }

    # query params
    if ( exists $args{'query_filter'}) {
        $query_params->{'query_filter'} = $self->{api_client}->to_query_value($args{'query_filter'});
    }

    # query params
    if ( exists $args{'mass_average'}) {
        $query_params->{'mass_average'} = $self->{api_client}->to_query_value($args{'mass_average'});
    }

    # query params
    if ( exists $args{'mass_exact'}) {
        $query_params->{'mass_exact'} = $self->{api_client}->to_query_value($args{'mass_exact'});
    }

    # query params
    if ( exists $args{'logp'}) {
        $query_params->{'logp'} = $self->{api_client}->to_query_value($args{'logp'});
    }

    # query params
    if ( exists $args{'delta'}) {
        $query_params->{'delta'} = $self->{api_client}->to_query_value($args{'delta'});
    }

    # query params
    if ( exists $args{'stars'}) {
        $query_params->{'stars'} = $self->{api_client}->to_query_value($args{'stars'});
    }

    # query params
    if ( exists $args{'is_bioactive'}) {
        $query_params->{'is_bioactive'} = $self->{api_client}->to_query_value($args{'is_bioactive'});
    }

    # query params
    if ( exists $args{'offset'}) {
        $query_params->{'offset'} = $self->{api_client}->to_query_value($args{'offset'});
    }

    # query params
    if ( exists $args{'limit'}) {
        $query_params->{'limit'} = $self->{api_client}->to_query_value($args{'limit'});
    }

    # path params
    if ( exists $args{'properties'}) {
        my $_base_variable = "{" . "properties" . "}";
        my $_base_value = $self->{api_client}->to_path_value($args{'properties'});
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;
    # authentication setting, if any
    my $auth_settings = [qw(ApiKeyToken ApiKeyAuth )];

    # make the API Call
    my $response = $self->{api_client}->call_api($_resource_path, $_method,
                                           $query_params, $form_params,
                                           $header_params, $_body_data, $auth_settings);
    if (!$response) {
        return;
    }
    my $_response_object = $self->{api_client}->deserialize('object', $response);
    return $_response_object;
}

1;
