package App::Manoc::Form::Group;

use HTML::FormHandler::Moose;

our $VERSION = '2.99.3'; ##TRIAL VERSION

use namespace::autoclean;

extends 'App::Manoc::Form::BaseDBIC';
with 'App::Manoc::Form::TraitFor::SaveButton';

has '+name' => ( default => 'form-user' );

has '+item_class' => ( default => 'Group' );

has_field 'name' => (
    type     => 'Text',
    required => 1,
    label    => 'Name',
);

has_field 'description' => (
    type  => 'TextArea',
    label => 'description',
);

has_field 'roles' => (
    type         => 'Multiple',
    label        => 'Roles',
    label_column => 'role',
);

has_field 'users' => (
    type         => 'Multiple',
    label        => 'Users',
    label_column => 'username',
);

__PACKAGE__->meta->make_immutable;
no HTML::FormHandler::Moose;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Form::Group

=head1 VERSION

version 2.99.3

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
