package App::Manoc::DB::Result::SoftwarePkg;
#ABSTRACT: A model object representing a software package name the system.

use strict;
use warnings;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use parent 'App::Manoc::DB::Result';

__PACKAGE__->table('software_pkg');

__PACKAGE__->add_columns(
    id => {
        data_type         => 'int',
        is_nullable       => 0,
        is_auto_increment => 1,
    },
    name => {
        data_type   => 'varchar',
        size        => 255,
        is_nullable => 0
    },
);
__PACKAGE__->set_primary_key('id');
__PACKAGE__->add_unique_constraint( ['name'] );

__PACKAGE__->has_many(
    server_swpkg => 'App::Manoc::DB::Result::ServerSWPkg',
    'software_pkg_id'
);

__PACKAGE__->many_to_many( servers => 'server_swpkg', 'server' );


sub count_servers_by_version {
    my $self = shift;

    my $rs = $self->server_swpkg->search(
        {},
        {
            select => [
                'version',
                {
                    count => 'server_id',
                }
            ],
            as       => [qw/ version n_servers /],
            group_by => ['version'],
        }
    );
    return wantarray ? $rs->all : $rs;
}

1;

__END__

=pod

=head1 NAME

App::Manoc::DB::Result::SoftwarePkg - A model object representing a software package name the system.

=head1 VERSION

version 2.99.4

=head1 METHODS

=head2 count_servers_by_version

Return the number of server using this software, grouped by version.
Returned columns are version and n_servers.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
