package App::Manoc::DB::Result::VServerNIC;
#ABSTRACT: A model object for virtual server additional network interfaces

use strict;
use warnings;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use parent 'App::Manoc::DB::Result';

__PACKAGE__->table('v_server_nic');
__PACKAGE__->add_columns(
    id => {
        data_type         => 'int',
        is_nullable       => 0,
        is_auto_increment => 1,
    },

    vm_id => {
        data_type      => 'int',
        is_foreign_key => 1,
        is_nullable    => 0,
    },

    name => {
        data_type   => 'varchar',
        is_nullable => 0,
        size        => 32
    },

    macaddr => {
        data_type   => 'varchar',
        is_nullable => 1,
        size        => 17
    },

);

__PACKAGE__->set_primary_key('id');

__PACKAGE__->add_unique_constraints( [ 'vm_id', 'name' ], ['macaddr'] );

__PACKAGE__->belongs_to(
    vm => 'App::Manoc::DB::Result::VirtualMachine',
    { 'foreign.id' => 'self.vm_id' }
);

sub insert {
    my ( $self, @args ) = @_;

    my $guard = $self->result_source->schema->txn_scope_guard;

    if ( !defined( $self->name ) ) {
        my $rs = $self->result_source->resultset;
        my $count = $rs->search( { vm_id => $self->vm_id } )->count();
        $self->name("nic$count");
    }

    $self->next::method(@args);

    $guard->commit;
}
1;

__END__

=pod

=head1 NAME

App::Manoc::DB::Result::VServerNIC - A model object for virtual server additional network interfaces

=head1 VERSION

version 2.99.4

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
