package App::Manoc::Support;

use strict;
use warnings;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use FindBin;

BEGIN {
    local $^W = 0;

    my @paths = ( "$FindBin::Bin/../perl5", "$FindBin::Bin/../../perl5", "/opt/manoc/perl5" );

    foreach my $support_dir (@paths) {

        next unless -d $support_dir;

        eval "use local::lib '$support_dir'";
        unless ($@) {
            delete $INC{"File/Path.pm"};
            require "File/Path.pm";    ## no critic
        }

        last;
    }
}

1;

__END__

=pod

=head1 NAME

App::Manoc::Support

=head1 VERSION

version 2.99.4

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
