/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.commandhandler;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.Zip;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.ActiveSession;
import org.openqa.selenium.remote.server.CommandHandler;

public class UploadFile
implements CommandHandler {
    private final JsonToBeanConverter toBean;
    private final ActiveSession session;

    public UploadFile(JsonToBeanConverter toBean, ActiveSession session) {
        this.toBean = Objects.requireNonNull(toBean);
        this.session = Objects.requireNonNull(session);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        Map args = this.toBean.convert(Map.class, req.getContentString());
        String file = (String)args.get("file");
        File tempDir = this.session.getFileSystem().createTempDir("upload", "file");
        Zip.unzip(file, tempDir);
        File[] allFiles = tempDir.listFiles();
        Response response = new Response(this.session.getId());
        if (allFiles == null || allFiles.length != 1) {
            response.setStatus(13);
            response.setValue(new WebDriverException("Expected there to be only 1 file. There were: " + (allFiles == null ? 0 : allFiles.length)));
        } else {
            response.setStatus(0);
            response.setValue(allFiles[0].getAbsolutePath());
        }
        this.session.getDownstreamDialect().getResponseCodec().encode(() -> resp, response);
    }
}

