######################################################################
#
# 5073_cp932x_by_jipsj_RT_DBCS.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x21\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x40"],
        ["\x81\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x21"],

        ["\x21\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x41"],
        ["\x81\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x22"],

        ["\x21\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x42"],
        ["\x81\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x23"],

        ["\x21\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x43"],
        ["\x81\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x24"],

        ["\x21\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x44"],
        ["\x81\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x25"],

        ["\x21\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x45"],
        ["\x81\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x26"],

        ["\x21\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x46"],
        ["\x81\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x27"],

        ["\x21\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x47"],
        ["\x81\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x28"],

        ["\x21\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x48"],
        ["\x81\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x29"],

        ["\x21\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x49"],
        ["\x81\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x2A"],

        ["\x21\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x4A"],
        ["\x81\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x2B"],

        ["\x21\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x4B"],
        ["\x81\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x2C"],

        ["\x21\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x4C"],
        ["\x81\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x2D"],

        ["\x21\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x4D"],
        ["\x81\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x2E"],

        ["\x21\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x4E"],
        ["\x81\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x2F"],

        ["\x21\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x4F"],
        ["\x81\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x30"],

        ["\x21\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x50"],
        ["\x81\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x31"],

        ["\x21\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x51"],
        ["\x81\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x32"],

        ["\x21\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x52"],
        ["\x81\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x33"],

        ["\x21\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x53"],
        ["\x81\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x34"],

        ["\x21\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x54"],
        ["\x81\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x35"],

        ["\x21\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x55"],
        ["\x81\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x36"],

        ["\x21\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x56"],
        ["\x81\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x37"],

        ["\x21\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x57"],
        ["\x81\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x38"],

        ["\x21\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x58"],
        ["\x81\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x39"],

        ["\x21\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x59"],
        ["\x81\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x3A"],

        ["\x21\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x5A"],
        ["\x81\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x3B"],

        ["\x21\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x5B"],
        ["\x81\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x3C"],

        ["\x21\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x5C"],
        ["\x81\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x3D"],

        ["\x21\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x5D"],
        ["\x81\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x3E"],

        ["\x21\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x5E"],
        ["\x81\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x3F"],

        ["\x21\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x5F"],
        ["\x81\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x40"],

        ["\x21\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x60"],
        ["\x81\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x41"],

        ["\x21\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x61"],
        ["\x81\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x42"],

        ["\x21\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x62"],
        ["\x81\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x43"],

        ["\x21\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x63"],
        ["\x81\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x44"],

        ["\x21\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x64"],
        ["\x81\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x45"],

        ["\x21\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x65"],
        ["\x81\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x46"],

        ["\x21\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x66"],
        ["\x81\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x47"],

        ["\x21\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x67"],
        ["\x81\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x48"],

        ["\x21\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x68"],
        ["\x81\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x49"],

        ["\x21\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x69"],
        ["\x81\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x4A"],

        ["\x21\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x6A"],
        ["\x81\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x4B"],

        ["\x21\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x6B"],
        ["\x81\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x4C"],

        ["\x21\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x6C"],
        ["\x81\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x4D"],

        ["\x21\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x6D"],
        ["\x81\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x4E"],

        ["\x21\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x6E"],
        ["\x81\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x4F"],

        ["\x21\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x6F"],
        ["\x81\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x50"],

        ["\x21\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x70"],
        ["\x81\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x51"],

        ["\x21\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x71"],
        ["\x81\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x52"],

        ["\x21\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x72"],
        ["\x81\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x53"],

        ["\x21\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x73"],
        ["\x81\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x54"],

        ["\x21\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x74"],
        ["\x81\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x55"],

        ["\x21\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x75"],
        ["\x81\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x56"],

        ["\x21\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x76"],
        ["\x81\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x57"],

        ["\x21\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x77"],
        ["\x81\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x58"],

        ["\x21\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x78"],
        ["\x81\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x59"],

        ["\x21\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x79"],
        ["\x81\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x5A"],

        ["\x21\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x7A"],
        ["\x81\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x5B"],

        ["\x21\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x7B"],
        ["\x81\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x5C"],

        ["\x21\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x7C"],
        ["\x81\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x5D"],

        ["\x21\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x7D"],
        ["\x81\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x5E"],

        ["\x21\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x7E"],
        ["\x81\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x5F"],

        ["\x21\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x80"],
        ["\x81\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x60"],

        ["\x21\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x81"],
        ["\x81\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x61"],

        ["\x21\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x82"],
        ["\x81\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x62"],

        ["\x21\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x83"],
        ["\x81\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x63"],

        ["\x21\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x84"],
        ["\x81\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x64"],

        ["\x21\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x85"],
        ["\x81\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x65"],

        ["\x21\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x86"],
        ["\x81\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x66"],

        ["\x21\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x87"],
        ["\x81\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x67"],

        ["\x21\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x88"],
        ["\x81\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x68"],

        ["\x21\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x89"],
        ["\x81\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x69"],

        ["\x21\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x8A"],
        ["\x81\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x6A"],

        ["\x21\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x8B"],
        ["\x81\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x6B"],

        ["\x21\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x8C"],
        ["\x81\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x6C"],

        ["\x21\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x8D"],
        ["\x81\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x6D"],

        ["\x21\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x8E"],
        ["\x81\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x6E"],

        ["\x21\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x8F"],
        ["\x81\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x6F"],

        ["\x21\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x90"],
        ["\x81\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x70"],

        ["\x21\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x91"],
        ["\x81\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x71"],

        ["\x21\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x92"],
        ["\x81\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x72"],

        ["\x21\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x93"],
        ["\x81\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x73"],

        ["\x21\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x94"],
        ["\x81\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x74"],

        ["\x21\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x95"],
        ["\x81\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x75"],

        ["\x21\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x96"],
        ["\x81\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x76"],

        ["\x21\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x97"],
        ["\x81\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x77"],

        ["\x21\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x98"],
        ["\x81\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x78"],

        ["\x21\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x99"],
        ["\x81\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x79"],

        ["\x21\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x9A"],
        ["\x81\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x7A"],

        ["\x21\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x9B"],
        ["\x81\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x7B"],

        ["\x21\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x9C"],
        ["\x81\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x7C"],

        ["\x21\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x9D"],
        ["\x81\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x7D"],

        ["\x21\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x9E"],
        ["\x81\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x21\x7E"],

        ["\x22\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\x9F"],
        ["\x81\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x22\x21"],

        ["\x22\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xA0"],
        ["\x81\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x22\x22"],

        ["\x22\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xA1"],
        ["\x81\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x22\x23"],

        ["\x22\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xA2"],
        ["\x81\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x22\x24"],

        ["\x22\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xA3"],
        ["\x81\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x22\x25"],

        ["\x22\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xA4"],
        ["\x81\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x22\x26"],

        ["\x22\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xA5"],
        ["\x81\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x22\x27"],

        ["\x22\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xA6"],
        ["\x81\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x22\x28"],

        ["\x22\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xA7"],
        ["\x81\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x22\x29"],

        ["\x22\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xA8"],
        ["\x81\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x22\x2A"],

        ["\x22\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xA9"],
        ["\x81\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x22\x2B"],

        ["\x22\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xAA"],
        ["\x81\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x22\x2C"],

        ["\x22\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xAB"],
        ["\x81\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x22\x2D"],

        ["\x22\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xAC"],
        ["\x81\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x22\x2E"],

        ["\xA5\xD4",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xB8"],
        ["\x81\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xD4"],

        ["\xA5\xD5",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xB9"],
        ["\x81\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xD5"],

        ["\xA6\xF4",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xBA"],
        ["\x81\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xF4"],

        ["\xA6\xF5",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xBB"],
        ["\x81\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xF5"],

        ["\xA5\xD2",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xBC"],
        ["\x81\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xD2"],

        ["\xA5\xD3",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xBD"],
        ["\x81\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xD3"],

        ["\x2D\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xBE"],
        ["\x81\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x7C"],

        ["\x2D\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xBF"],
        ["\x81\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x7B"],

        ["\xA5\xD0",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xC8"],
        ["\x81\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xD0"],

        ["\xA5\xD1",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xC9"],
        ["\x81\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xD1"],

        ["\x74\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xCA"],
        ["\x81\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x74\x21"],

        ["\xA6\xF6",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xCB"],
        ["\x81\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xF6"],

        ["\xA6\xF7",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xCC"],
        ["\x81\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xF7"],

        ["\xA5\xE7",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xCD"],
        ["\x81\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xE7"],

        ["\xA5\xE8",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xCE"],
        ["\x81\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xE8"],

        ["\x2D\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xDA"],
        ["\x81\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x77"],

        ["\x2D\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xDB"],
        ["\x81\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x76"],

        ["\xA6\xF8",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xDC"],
        ["\x81\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xF8"],

        ["\xA5\xCA",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xDD"],
        ["\x81\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xCA"],

        ["\xA6\xF9",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xDE"],
        ["\x81\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xF9"],

        ["\x2D\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xDF"],
        ["\x81\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x71"],

        ["\x2D\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xE0"],
        ["\x81\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x70"],

        ["\xA5\xE1",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xE1"],
        ["\x81\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xE1"],

        ["\xA5\xE2",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xE2"],
        ["\x81\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xE2"],

        ["\x2D\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xE3"],
        ["\x81\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x75"],

        ["\xA5\xDD",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xE4"],
        ["\x81\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xDD"],

        ["\xA5\xDC",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xE5"],
        ["\x81\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xDC"],

        ["\x2D\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xE6"],
        ["\x81\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x7A"],

        ["\x2D\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xE7"],
        ["\x81\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x72"],

        ["\xA6\xFA",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xE8"],
        ["\x81\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xFA"],

        ["\xA4\xDF",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xF0"],
        ["\x81\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xDF"],

        ["\xA4\xFE",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xF1"],
        ["\x81\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA4\xFE"],

        ["\xA6\xFB",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xF2"],
        ["\x81\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xFB"],

        ["\xA6\xFC",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xF3"],
        ["\x81\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xFC"],

        ["\xA6\xFD",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xF4"],
        ["\x81\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xFD"],

        ["\xA5\xEE",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xF5"],
        ["\x81\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xEE"],

        ["\xA5\xEF",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xF6"],
        ["\x81\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xEF"],

        ["\xA5\xF0",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xF7"],
        ["\x81\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA5\xF0"],

        ["\xA6\xFE",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x81\xFC"],
        ["\x81\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xA6\xFE"],

        ["\x23\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x4F"],
        ["\x82\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x30"],

        ["\x23\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x50"],
        ["\x82\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x31"],

        ["\x23\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x51"],
        ["\x82\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x32"],

        ["\x23\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x52"],
        ["\x82\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x33"],

        ["\x23\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x53"],
        ["\x82\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x34"],

        ["\x23\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x54"],
        ["\x82\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x35"],

        ["\x23\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x55"],
        ["\x82\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x36"],

        ["\x23\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x56"],
        ["\x82\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x37"],

        ["\x23\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x57"],
        ["\x82\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x38"],

        ["\x23\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x58"],
        ["\x82\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x39"],

        ["\x23\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x60"],
        ["\x82\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x41"],

        ["\x23\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x61"],
        ["\x82\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x42"],

        ["\x23\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x62"],
        ["\x82\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x43"],

        ["\x23\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x63"],
        ["\x82\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x44"],

        ["\x23\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x64"],
        ["\x82\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x45"],

        ["\x23\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x65"],
        ["\x82\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x46"],

        ["\x23\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x66"],
        ["\x82\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x47"],

        ["\x23\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x67"],
        ["\x82\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x48"],

        ["\x23\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x68"],
        ["\x82\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x49"],

        ["\x23\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x69"],
        ["\x82\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x4A"],

        ["\x23\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x6A"],
        ["\x82\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x4B"],

        ["\x23\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x6B"],
        ["\x82\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x4C"],

        ["\x23\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x6C"],
        ["\x82\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x4D"],

        ["\x23\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x6D"],
        ["\x82\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x4E"],

        ["\x23\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x6E"],
        ["\x82\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x4F"],

        ["\x23\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x6F"],
        ["\x82\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x50"],

        ["\x23\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x70"],
        ["\x82\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x51"],

        ["\x23\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x71"],
        ["\x82\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x52"],

        ["\x23\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x72"],
        ["\x82\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x53"],

        ["\x23\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x73"],
        ["\x82\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x54"],

        ["\x23\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x74"],
        ["\x82\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x55"],

        ["\x23\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x75"],
        ["\x82\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x56"],

        ["\x23\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x76"],
        ["\x82\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x57"],

        ["\x23\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x77"],
        ["\x82\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x58"],

        ["\x23\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x78"],
        ["\x82\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x59"],

        ["\x23\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x79"],
        ["\x82\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x5A"],

        ["\x23\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x81"],
        ["\x82\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x61"],

        ["\x23\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x82"],
        ["\x82\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x62"],

        ["\x23\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x83"],
        ["\x82\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x63"],

        ["\x23\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x84"],
        ["\x82\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x64"],

        ["\x23\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x85"],
        ["\x82\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x65"],

        ["\x23\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x86"],
        ["\x82\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x66"],

        ["\x23\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x87"],
        ["\x82\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x67"],

        ["\x23\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x88"],
        ["\x82\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x68"],

        ["\x23\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x89"],
        ["\x82\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x69"],

        ["\x23\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x8A"],
        ["\x82\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x6A"],

        ["\x23\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x8B"],
        ["\x82\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x6B"],

        ["\x23\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x8C"],
        ["\x82\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x6C"],

        ["\x23\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x8D"],
        ["\x82\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x6D"],

        ["\x23\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x8E"],
        ["\x82\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x6E"],

        ["\x23\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x8F"],
        ["\x82\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x6F"],

        ["\x23\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x90"],
        ["\x82\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x70"],

        ["\x23\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x91"],
        ["\x82\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x71"],

        ["\x23\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x92"],
        ["\x82\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x72"],

        ["\x23\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x93"],
        ["\x82\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x73"],

        ["\x23\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x94"],
        ["\x82\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x74"],

        ["\x23\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x95"],
        ["\x82\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x75"],

        ["\x23\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x96"],
        ["\x82\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x76"],

        ["\x23\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x97"],
        ["\x82\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x77"],

        ["\x23\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x98"],
        ["\x82\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x78"],

        ["\x23\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x99"],
        ["\x82\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x79"],

        ["\x23\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x9A"],
        ["\x82\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x23\x7A"],

        ["\x24\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\x9F"],
        ["\x82\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x21"],

        ["\x24\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xA0"],
        ["\x82\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x22"],

        ["\x24\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xA1"],
        ["\x82\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x23"],

        ["\x24\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xA2"],
        ["\x82\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x24"],

        ["\x24\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xA3"],
        ["\x82\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x25"],

        ["\x24\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xA4"],
        ["\x82\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x26"],

        ["\x24\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xA5"],
        ["\x82\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x27"],

        ["\x24\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xA6"],
        ["\x82\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x28"],

        ["\x24\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xA7"],
        ["\x82\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x29"],

        ["\x24\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xA8"],
        ["\x82\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x2A"],

        ["\x24\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xA9"],
        ["\x82\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x2B"],

        ["\x24\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xAA"],
        ["\x82\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x2C"],

        ["\x24\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xAB"],
        ["\x82\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x2D"],

        ["\x24\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xAC"],
        ["\x82\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x2E"],

        ["\x24\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xAD"],
        ["\x82\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x2F"],

        ["\x24\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xAE"],
        ["\x82\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x30"],

        ["\x24\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xAF"],
        ["\x82\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x31"],

        ["\x24\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xB0"],
        ["\x82\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x32"],

        ["\x24\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xB1"],
        ["\x82\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x33"],

        ["\x24\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xB2"],
        ["\x82\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x34"],

        ["\x24\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xB3"],
        ["\x82\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x35"],

        ["\x24\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xB4"],
        ["\x82\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x36"],

        ["\x24\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xB5"],
        ["\x82\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x37"],

        ["\x24\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xB6"],
        ["\x82\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x38"],

        ["\x24\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xB7"],
        ["\x82\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x39"],

        ["\x24\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xB8"],
        ["\x82\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x3A"],

        ["\x24\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xB9"],
        ["\x82\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x3B"],

        ["\x24\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xBA"],
        ["\x82\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x3C"],

        ["\x24\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xBB"],
        ["\x82\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x3D"],

        ["\x24\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xBC"],
        ["\x82\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x3E"],

        ["\x24\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xBD"],
        ["\x82\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x3F"],

        ["\x24\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xBE"],
        ["\x82\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x40"],

        ["\x24\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xBF"],
        ["\x82\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x41"],

        ["\x24\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xC0"],
        ["\x82\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x42"],

        ["\x24\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xC1"],
        ["\x82\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x43"],

        ["\x24\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xC2"],
        ["\x82\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x44"],

        ["\x24\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xC3"],
        ["\x82\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x45"],

        ["\x24\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xC4"],
        ["\x82\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x46"],

        ["\x24\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xC5"],
        ["\x82\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x47"],

        ["\x24\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xC6"],
        ["\x82\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x48"],

        ["\x24\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xC7"],
        ["\x82\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x49"],

        ["\x24\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xC8"],
        ["\x82\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x4A"],

        ["\x24\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xC9"],
        ["\x82\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x4B"],

        ["\x24\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xCA"],
        ["\x82\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x4C"],

        ["\x24\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xCB"],
        ["\x82\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x4D"],

        ["\x24\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xCC"],
        ["\x82\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x4E"],

        ["\x24\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xCD"],
        ["\x82\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x4F"],

        ["\x24\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xCE"],
        ["\x82\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x50"],

        ["\x24\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xCF"],
        ["\x82\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x51"],

        ["\x24\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xD0"],
        ["\x82\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x52"],

        ["\x24\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xD1"],
        ["\x82\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x53"],

        ["\x24\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xD2"],
        ["\x82\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x54"],

        ["\x24\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xD3"],
        ["\x82\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x55"],

        ["\x24\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xD4"],
        ["\x82\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x56"],

        ["\x24\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xD5"],
        ["\x82\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x57"],

        ["\x24\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xD6"],
        ["\x82\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x58"],

        ["\x24\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xD7"],
        ["\x82\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x59"],

        ["\x24\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xD8"],
        ["\x82\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x5A"],

        ["\x24\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xD9"],
        ["\x82\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x5B"],

        ["\x24\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xDA"],
        ["\x82\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x5C"],

        ["\x24\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xDB"],
        ["\x82\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x5D"],

        ["\x24\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xDC"],
        ["\x82\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x5E"],

        ["\x24\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xDD"],
        ["\x82\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x5F"],

        ["\x24\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xDE"],
        ["\x82\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x60"],

        ["\x24\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xDF"],
        ["\x82\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x61"],

        ["\x24\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xE0"],
        ["\x82\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x62"],

        ["\x24\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xE1"],
        ["\x82\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x63"],

        ["\x24\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xE2"],
        ["\x82\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x64"],

        ["\x24\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xE3"],
        ["\x82\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x65"],

        ["\x24\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xE4"],
        ["\x82\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x66"],

        ["\x24\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xE5"],
        ["\x82\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x67"],

        ["\x24\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xE6"],
        ["\x82\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x68"],

        ["\x24\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xE7"],
        ["\x82\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x69"],

        ["\x24\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xE8"],
        ["\x82\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x6A"],

        ["\x24\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xE9"],
        ["\x82\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x6B"],

        ["\x24\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xEA"],
        ["\x82\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x6C"],

        ["\x24\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xEB"],
        ["\x82\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x6D"],

        ["\x24\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xEC"],
        ["\x82\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x6E"],

        ["\x24\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xED"],
        ["\x82\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x6F"],

        ["\x24\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xEE"],
        ["\x82\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x70"],

        ["\x24\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xEF"],
        ["\x82\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x71"],

        ["\x24\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xF0"],
        ["\x82\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x72"],

        ["\x24\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x82\xF1"],
        ["\x82\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x24\x73"],

        ["\x25\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x40"],
        ["\x83\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x21"],

        ["\x25\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x41"],
        ["\x83\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x22"],

        ["\x25\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x42"],
        ["\x83\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x23"],

        ["\x25\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x43"],
        ["\x83\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x24"],

        ["\x25\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x44"],
        ["\x83\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x25"],

        ["\x25\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x45"],
        ["\x83\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x26"],

        ["\x25\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x46"],
        ["\x83\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x27"],

        ["\x25\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x47"],
        ["\x83\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x28"],

        ["\x25\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x48"],
        ["\x83\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x29"],

        ["\x25\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x49"],
        ["\x83\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x2A"],

        ["\x25\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x4A"],
        ["\x83\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x2B"],

        ["\x25\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x4B"],
        ["\x83\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x2C"],

        ["\x25\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x4C"],
        ["\x83\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x2D"],

        ["\x25\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x4D"],
        ["\x83\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x2E"],

        ["\x25\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x4E"],
        ["\x83\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x2F"],

        ["\x25\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x4F"],
        ["\x83\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x30"],

        ["\x25\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x50"],
        ["\x83\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x31"],

        ["\x25\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x51"],
        ["\x83\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x32"],

        ["\x25\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x52"],
        ["\x83\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x33"],

        ["\x25\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x53"],
        ["\x83\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x34"],

        ["\x25\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x54"],
        ["\x83\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x35"],

        ["\x25\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x55"],
        ["\x83\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x36"],

        ["\x25\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x56"],
        ["\x83\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x37"],

        ["\x25\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x57"],
        ["\x83\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x38"],

        ["\x25\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x58"],
        ["\x83\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x39"],

        ["\x25\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x59"],
        ["\x83\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x3A"],

        ["\x25\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x5A"],
        ["\x83\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x3B"],

        ["\x25\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x5B"],
        ["\x83\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x3C"],

        ["\x25\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x5C"],
        ["\x83\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x3D"],

        ["\x25\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x5D"],
        ["\x83\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x3E"],

        ["\x25\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x5E"],
        ["\x83\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x3F"],

        ["\x25\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x5F"],
        ["\x83\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x40"],

        ["\x25\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x60"],
        ["\x83\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x41"],

        ["\x25\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x61"],
        ["\x83\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x42"],

        ["\x25\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x62"],
        ["\x83\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x43"],

        ["\x25\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x63"],
        ["\x83\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x44"],

        ["\x25\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x64"],
        ["\x83\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x45"],

        ["\x25\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x65"],
        ["\x83\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x46"],

        ["\x25\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x66"],
        ["\x83\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x47"],

        ["\x25\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x67"],
        ["\x83\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x48"],

        ["\x25\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x68"],
        ["\x83\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x49"],

        ["\x25\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x69"],
        ["\x83\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x4A"],

        ["\x25\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x6A"],
        ["\x83\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x4B"],

        ["\x25\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x6B"],
        ["\x83\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x4C"],

        ["\x25\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x6C"],
        ["\x83\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x4D"],

        ["\x25\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x6D"],
        ["\x83\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x4E"],

        ["\x25\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x6E"],
        ["\x83\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x4F"],

        ["\x25\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x6F"],
        ["\x83\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x50"],

        ["\x25\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x70"],
        ["\x83\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x51"],

        ["\x25\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x71"],
        ["\x83\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x52"],

        ["\x25\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x72"],
        ["\x83\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x53"],

        ["\x25\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x73"],
        ["\x83\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x54"],

        ["\x25\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x74"],
        ["\x83\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x55"],

        ["\x25\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x75"],
        ["\x83\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x56"],

        ["\x25\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x76"],
        ["\x83\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x57"],

        ["\x25\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x77"],
        ["\x83\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x58"],

        ["\x25\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x78"],
        ["\x83\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x59"],

        ["\x25\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x79"],
        ["\x83\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x5A"],

        ["\x25\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x7A"],
        ["\x83\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x5B"],

        ["\x25\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x7B"],
        ["\x83\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x5C"],

        ["\x25\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x7C"],
        ["\x83\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x5D"],

        ["\x25\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x7D"],
        ["\x83\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x5E"],

        ["\x25\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x7E"],
        ["\x83\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x5F"],

        ["\x25\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x80"],
        ["\x83\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x60"],

        ["\x25\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x81"],
        ["\x83\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x61"],

        ["\x25\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x82"],
        ["\x83\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x62"],

        ["\x25\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x83"],
        ["\x83\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x63"],

        ["\x25\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x84"],
        ["\x83\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x64"],

        ["\x25\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x85"],
        ["\x83\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x65"],

        ["\x25\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x86"],
        ["\x83\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x66"],

        ["\x25\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x87"],
        ["\x83\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x67"],

        ["\x25\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x88"],
        ["\x83\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x68"],

        ["\x25\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x89"],
        ["\x83\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x69"],

        ["\x25\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x8A"],
        ["\x83\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x6A"],

        ["\x25\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x8B"],
        ["\x83\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x6B"],

        ["\x25\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x8C"],
        ["\x83\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x6C"],

        ["\x25\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x8D"],
        ["\x83\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x6D"],

        ["\x25\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x8E"],
        ["\x83\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x6E"],

        ["\x25\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x8F"],
        ["\x83\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x6F"],

        ["\x25\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x90"],
        ["\x83\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x70"],

        ["\x25\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x91"],
        ["\x83\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x71"],

        ["\x25\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x92"],
        ["\x83\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x72"],

        ["\x25\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x93"],
        ["\x83\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x73"],

        ["\x25\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x94"],
        ["\x83\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x74"],

        ["\x25\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x95"],
        ["\x83\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x75"],

        ["\x25\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x96"],
        ["\x83\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x25\x76"],

        ["\x26\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\x9F"],
        ["\x83\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x21"],

        ["\x26\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xA0"],
        ["\x83\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x22"],

        ["\x26\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xA1"],
        ["\x83\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x23"],

        ["\x26\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xA2"],
        ["\x83\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x24"],

        ["\x26\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xA3"],
        ["\x83\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x25"],

        ["\x26\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xA4"],
        ["\x83\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x26"],

        ["\x26\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xA5"],
        ["\x83\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x27"],

        ["\x26\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xA6"],
        ["\x83\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x28"],

        ["\x26\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xA7"],
        ["\x83\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x29"],

        ["\x26\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xA8"],
        ["\x83\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x2A"],

        ["\x26\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xA9"],
        ["\x83\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x2B"],

        ["\x26\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xAA"],
        ["\x83\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x2C"],

        ["\x26\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xAB"],
        ["\x83\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x2D"],

        ["\x26\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xAC"],
        ["\x83\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x2E"],

        ["\x26\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xAD"],
        ["\x83\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x2F"],

        ["\x26\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xAE"],
        ["\x83\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x30"],

        ["\x26\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xAF"],
        ["\x83\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x31"],

        ["\x26\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xB0"],
        ["\x83\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x32"],

        ["\x26\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xB1"],
        ["\x83\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x33"],

        ["\x26\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xB2"],
        ["\x83\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x34"],

        ["\x26\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xB3"],
        ["\x83\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x35"],

        ["\x26\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xB4"],
        ["\x83\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x36"],

        ["\x26\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xB5"],
        ["\x83\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x37"],

        ["\x26\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xB6"],
        ["\x83\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x38"],

        ["\x26\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xBF"],
        ["\x83\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x41"],

        ["\x26\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xC0"],
        ["\x83\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x42"],

        ["\x26\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xC1"],
        ["\x83\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x43"],

        ["\x26\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xC2"],
        ["\x83\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x44"],

        ["\x26\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xC3"],
        ["\x83\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x45"],

        ["\x26\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xC4"],
        ["\x83\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x46"],

        ["\x26\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xC5"],
        ["\x83\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x47"],

        ["\x26\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xC6"],
        ["\x83\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x48"],

        ["\x26\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xC7"],
        ["\x83\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x49"],

        ["\x26\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xC8"],
        ["\x83\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x4A"],

        ["\x26\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xC9"],
        ["\x83\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x4B"],

        ["\x26\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xCA"],
        ["\x83\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x4C"],

        ["\x26\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xCB"],
        ["\x83\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x4D"],

        ["\x26\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xCC"],
        ["\x83\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x4E"],

        ["\x26\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xCD"],
        ["\x83\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x4F"],

        ["\x26\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xCE"],
        ["\x83\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x50"],

        ["\x26\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xCF"],
        ["\x83\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x51"],

        ["\x26\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xD0"],
        ["\x83\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x52"],

        ["\x26\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xD1"],
        ["\x83\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x53"],

        ["\x26\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xD2"],
        ["\x83\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x54"],

        ["\x26\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xD3"],
        ["\x83\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x55"],

        ["\x26\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xD4"],
        ["\x83\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x56"],

        ["\x26\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xD5"],
        ["\x83\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x57"],

        ["\x26\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x83\xD6"],
        ["\x83\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x26\x58"],

        ["\x27\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x40"],
        ["\x84\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x21"],

        ["\x27\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x41"],
        ["\x84\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x22"],

        ["\x27\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x42"],
        ["\x84\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x23"],

        ["\x27\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x43"],
        ["\x84\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x24"],

        ["\x27\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x44"],
        ["\x84\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x25"],

        ["\x27\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x45"],
        ["\x84\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x26"],

        ["\x27\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x46"],
        ["\x84\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x27"],

        ["\x27\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x47"],
        ["\x84\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x28"],

        ["\x27\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x48"],
        ["\x84\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x29"],

        ["\x27\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x49"],
        ["\x84\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x2A"],

        ["\x27\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x4A"],
        ["\x84\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x2B"],

        ["\x27\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x4B"],
        ["\x84\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x2C"],

        ["\x27\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x4C"],
        ["\x84\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x2D"],

        ["\x27\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x4D"],
        ["\x84\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x2E"],

        ["\x27\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x4E"],
        ["\x84\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x2F"],

        ["\x27\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x4F"],
        ["\x84\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x30"],

        ["\x27\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x50"],
        ["\x84\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x31"],

        ["\x27\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x51"],
        ["\x84\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x32"],

        ["\x27\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x52"],
        ["\x84\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x33"],

        ["\x27\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x53"],
        ["\x84\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x34"],

        ["\x27\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x54"],
        ["\x84\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x35"],

        ["\x27\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x55"],
        ["\x84\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x36"],

        ["\x27\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x56"],
        ["\x84\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x37"],

        ["\x27\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x57"],
        ["\x84\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x38"],

        ["\x27\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x58"],
        ["\x84\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x39"],

        ["\x27\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x59"],
        ["\x84\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x3A"],

        ["\x27\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x5A"],
        ["\x84\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x3B"],

        ["\x27\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x5B"],
        ["\x84\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x3C"],

        ["\x27\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x5C"],
        ["\x84\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x3D"],

        ["\x27\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x5D"],
        ["\x84\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x3E"],

        ["\x27\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x5E"],
        ["\x84\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x3F"],

        ["\x27\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x5F"],
        ["\x84\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x40"],

        ["\x27\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x60"],
        ["\x84\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x41"],

        ["\x27\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x70"],
        ["\x84\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x51"],

        ["\x27\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x71"],
        ["\x84\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x52"],

        ["\x27\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x72"],
        ["\x84\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x53"],

        ["\x27\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x73"],
        ["\x84\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x54"],

        ["\x27\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x74"],
        ["\x84\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x55"],

        ["\x27\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x75"],
        ["\x84\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x56"],

        ["\x27\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x76"],
        ["\x84\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x57"],

        ["\x27\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x77"],
        ["\x84\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x58"],

        ["\x27\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x78"],
        ["\x84\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x59"],

        ["\x27\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x79"],
        ["\x84\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x5A"],

        ["\x27\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x7A"],
        ["\x84\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x5B"],

        ["\x27\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x7B"],
        ["\x84\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x5C"],

        ["\x27\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x7C"],
        ["\x84\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x5D"],

        ["\x27\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x7D"],
        ["\x84\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x5E"],

        ["\x27\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x7E"],
        ["\x84\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x5F"],

        ["\x27\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x80"],
        ["\x84\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x60"],

        ["\x27\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x81"],
        ["\x84\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x61"],

        ["\x27\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x82"],
        ["\x84\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x62"],

        ["\x27\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x83"],
        ["\x84\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x63"],

        ["\x27\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x84"],
        ["\x84\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x64"],

        ["\x27\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x85"],
        ["\x84\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x65"],

        ["\x27\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x86"],
        ["\x84\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x66"],

        ["\x27\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x87"],
        ["\x84\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x67"],

        ["\x27\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x88"],
        ["\x84\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x68"],

        ["\x27\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x89"],
        ["\x84\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x69"],

        ["\x27\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x8A"],
        ["\x84\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x6A"],

        ["\x27\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x8B"],
        ["\x84\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x6B"],

        ["\x27\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x8C"],
        ["\x84\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x6C"],

        ["\x27\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x8D"],
        ["\x84\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x6D"],

        ["\x27\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x8E"],
        ["\x84\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x6E"],

        ["\x27\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x8F"],
        ["\x84\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x6F"],

        ["\x27\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x90"],
        ["\x84\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x70"],

        ["\x27\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x91"],
        ["\x84\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x27\x71"],

        ["\x2C\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\x9F"],
        ["\x84\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x24"],

        ["\x2C\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xA0"],
        ["\x84\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x26"],

        ["\x2C\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xA1"],
        ["\x84\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x30"],

        ["\x2C\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xA2"],
        ["\x84\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x34"],

        ["\x2C\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xA3"],
        ["\x84\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x3C"],

        ["\x2C\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xA4"],
        ["\x84\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x38"],

        ["\x2C\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xA5"],
        ["\x84\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x40"],

        ["\x2C\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xA6"],
        ["\x84\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x50"],

        ["\x2C\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xA7"],
        ["\x84\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x48"],

        ["\x2C\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xA8"],
        ["\x84\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x58"],

        ["\x2C\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xA9"],
        ["\x84\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x60"],

        ["\x2C\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xAA"],
        ["\x84\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x25"],

        ["\x2C\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xAB"],
        ["\x84\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x27"],

        ["\x2C\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xAC"],
        ["\x84\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x33"],

        ["\x2C\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xAD"],
        ["\x84\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x37"],

        ["\x2C\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xAE"],
        ["\x84\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x3F"],

        ["\x2C\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xAF"],
        ["\x84\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x3B"],

        ["\x2C\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xB0"],
        ["\x84\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x47"],

        ["\x2C\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xB1"],
        ["\x84\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x57"],

        ["\x2C\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xB2"],
        ["\x84\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x4F"],

        ["\x2C\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xB3"],
        ["\x84\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x5F"],

        ["\x2C\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xB4"],
        ["\x84\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x6F"],

        ["\x2C\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xB5"],
        ["\x84\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x44"],

        ["\x2C\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xB6"],
        ["\x84\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x53"],

        ["\x2C\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xB7"],
        ["\x84\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x4C"],

        ["\x2C\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xB8"],
        ["\x84\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x5B"],

        ["\x2C\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xB9"],
        ["\x84\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x63"],

        ["\x2C\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xBA"],
        ["\x84\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x41"],

        ["\x2C\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xBB"],
        ["\x84\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x54"],

        ["\x2C\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xBC"],
        ["\x84\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x49"],

        ["\x2C\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xBD"],
        ["\x84\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x5C"],

        ["\x2C\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x84\xBE"],
        ["\x84\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2C\x66"],

        ["\x2D\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x40"],
        ["\x87\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x21"],

        ["\x2D\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x41"],
        ["\x87\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x22"],

        ["\x2D\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x42"],
        ["\x87\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x23"],

        ["\x2D\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x43"],
        ["\x87\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x24"],

        ["\x2D\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x44"],
        ["\x87\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x25"],

        ["\x2D\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x45"],
        ["\x87\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x26"],

        ["\x2D\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x46"],
        ["\x87\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x27"],

        ["\x2D\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x47"],
        ["\x87\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x28"],

        ["\x2D\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x48"],
        ["\x87\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x29"],

        ["\x2D\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x49"],
        ["\x87\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x2A"],

        ["\x2D\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x4A"],
        ["\x87\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x2B"],

        ["\x2D\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x4B"],
        ["\x87\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x2C"],

        ["\x2D\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x4C"],
        ["\x87\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x2D"],

        ["\x2D\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x4D"],
        ["\x87\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x2E"],

        ["\x2D\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x4E"],
        ["\x87\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x2F"],

        ["\x2D\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x4F"],
        ["\x87\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x30"],

        ["\x2D\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x50"],
        ["\x87\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x31"],

        ["\x2D\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x51"],
        ["\x87\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x32"],

        ["\x2D\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x52"],
        ["\x87\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x33"],

        ["\x2D\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x53"],
        ["\x87\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x34"],

        ["\x2D\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x54"],
        ["\x87\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x35"],

        ["\x2D\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x55"],
        ["\x87\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x36"],

        ["\x2D\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x56"],
        ["\x87\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x37"],

        ["\x2D\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x57"],
        ["\x87\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x38"],

        ["\x2D\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x58"],
        ["\x87\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x39"],

        ["\x2D\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x59"],
        ["\x87\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x3A"],

        ["\x2D\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x5A"],
        ["\x87\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x3B"],

        ["\x2D\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x5B"],
        ["\x87\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x3C"],

        ["\x2D\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x5C"],
        ["\x87\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x3D"],

        ["\x2D\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x5D"],
        ["\x87\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x3E"],

        ["\x2D\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x5F"],
        ["\x87\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x40"],

        ["\x2D\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x60"],
        ["\x87\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x41"],

        ["\x2D\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x61"],
        ["\x87\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x42"],

        ["\x2D\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x62"],
        ["\x87\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x43"],

        ["\x2D\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x63"],
        ["\x87\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x44"],

        ["\x2D\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x64"],
        ["\x87\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x45"],

        ["\x2D\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x65"],
        ["\x87\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x46"],

        ["\x2D\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x66"],
        ["\x87\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x47"],

        ["\x2D\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x67"],
        ["\x87\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x48"],

        ["\x2D\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x68"],
        ["\x87\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x49"],

        ["\x2D\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x69"],
        ["\x87\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x4A"],

        ["\x2D\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x6A"],
        ["\x87\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x4B"],

        ["\x2D\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x6B"],
        ["\x87\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x4C"],

        ["\x2D\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x6C"],
        ["\x87\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x4D"],

        ["\x2D\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x6D"],
        ["\x87\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x4E"],

        ["\x2D\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x6E"],
        ["\x87\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x4F"],

        ["\x2D\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x6F"],
        ["\x87\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x50"],

        ["\x2D\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x70"],
        ["\x87\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x51"],

        ["\x2D\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x71"],
        ["\x87\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x52"],

        ["\x2D\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x72"],
        ["\x87\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x53"],

        ["\x2D\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x73"],
        ["\x87\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x54"],

        ["\x2D\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x74"],
        ["\x87\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x55"],

        ["\x2D\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x75"],
        ["\x87\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x56"],

        ["\x2D\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x7E"],
        ["\x87\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x5F"],

        ["\x2D\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x80"],
        ["\x87\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x60"],

        ["\x2D\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x81"],
        ["\x87\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x61"],

        ["\x2D\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x82"],
        ["\x87\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x62"],

        ["\x2D\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x83"],
        ["\x87\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x63"],

        ["\x2D\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x84"],
        ["\x87\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x64"],

        ["\x2D\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x85"],
        ["\x87\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x65"],

        ["\x2D\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x86"],
        ["\x87\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x66"],

        ["\x2D\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x87"],
        ["\x87\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x67"],

        ["\x2D\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x88"],
        ["\x87\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x68"],

        ["\x2D\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x89"],
        ["\x87\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x69"],

        ["\x2D\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x8A"],
        ["\x87\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x6A"],

        ["\x2D\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x8B"],
        ["\x87\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x6B"],

        ["\x2D\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x8C"],
        ["\x87\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x6C"],

        ["\x2D\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x8D"],
        ["\x87\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x6D"],

        ["\x2D\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x8E"],
        ["\x87\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x6E"],

        ["\x2D\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x8F"],
        ["\x87\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x6F"],

        ["\x2D\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x93"],
        ["\x87\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x73"],

        ["\x2D\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x94"],
        ["\x87\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x74"],

        ["\x2D\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x98"],
        ["\x87\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x78"],

        ["\x2D\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x87\x99"],
        ["\x87\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x2D\x79"],

        ["\x30\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\x9F"],
        ["\x88\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x21"],

        ["\x30\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xA0"],
        ["\x88\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x22"],

        ["\x30\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xA1"],
        ["\x88\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x23"],

        ["\x30\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xA2"],
        ["\x88\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x24"],

        ["\x30\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xA3"],
        ["\x88\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x25"],

        ["\x30\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xA4"],
        ["\x88\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x26"],

        ["\x30\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xA5"],
        ["\x88\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x27"],

        ["\x30\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xA6"],
        ["\x88\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x28"],

        ["\x30\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xA7"],
        ["\x88\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x29"],

        ["\x30\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xA8"],
        ["\x88\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x2A"],

        ["\x30\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xA9"],
        ["\x88\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x2B"],

        ["\x30\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xAA"],
        ["\x88\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x2C"],

        ["\x30\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xAB"],
        ["\x88\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x2D"],

        ["\x30\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xAC"],
        ["\x88\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x2E"],

        ["\x30\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xAD"],
        ["\x88\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x2F"],

        ["\x30\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xAE"],
        ["\x88\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x30"],

        ["\x30\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xAF"],
        ["\x88\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x31"],

        ["\x30\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xB0"],
        ["\x88\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x32"],

        ["\x72\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xB1"],
        ["\x88\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x4D"],

        ["\x30\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xB2"],
        ["\x88\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x34"],

        ["\x30\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xB3"],
        ["\x88\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x35"],

        ["\x30\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xB4"],
        ["\x88\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x36"],

        ["\x30\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xB5"],
        ["\x88\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x37"],

        ["\x30\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xB6"],
        ["\x88\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x38"],

        ["\x30\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xB7"],
        ["\x88\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x39"],

        ["\x30\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xB8"],
        ["\x88\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x3A"],

        ["\x30\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xB9"],
        ["\x88\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x3B"],

        ["\x30\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xBA"],
        ["\x88\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x3C"],

        ["\x30\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xBB"],
        ["\x88\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x3D"],

        ["\x30\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xBC"],
        ["\x88\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x3E"],

        ["\x30\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xBD"],
        ["\x88\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x3F"],

        ["\x30\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xBE"],
        ["\x88\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x40"],

        ["\x30\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xBF"],
        ["\x88\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x41"],

        ["\x30\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xC0"],
        ["\x88\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x42"],

        ["\x30\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xC1"],
        ["\x88\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x43"],

        ["\x30\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xC2"],
        ["\x88\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x44"],

        ["\x30\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xC3"],
        ["\x88\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x45"],

        ["\x30\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xC4"],
        ["\x88\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x46"],

        ["\x30\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xC5"],
        ["\x88\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x47"],

        ["\x30\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xC6"],
        ["\x88\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x48"],

        ["\x30\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xC7"],
        ["\x88\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x49"],

        ["\x30\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xC8"],
        ["\x88\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x4A"],

        ["\x30\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xC9"],
        ["\x88\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x4B"],

        ["\x30\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xCA"],
        ["\x88\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x4C"],

        ["\x30\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xCB"],
        ["\x88\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x4D"],

        ["\x30\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xCC"],
        ["\x88\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x4E"],

        ["\x30\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xCD"],
        ["\x88\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x4F"],

        ["\x30\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xCE"],
        ["\x88\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x50"],

        ["\x30\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xCF"],
        ["\x88\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x51"],

        ["\x30\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xD0"],
        ["\x88\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x52"],

        ["\x30\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xD1"],
        ["\x88\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x53"],

        ["\x30\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xD2"],
        ["\x88\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x54"],

        ["\x30\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xD3"],
        ["\x88\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x55"],

        ["\x30\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xD4"],
        ["\x88\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x56"],

        ["\x30\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xD5"],
        ["\x88\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x57"],

        ["\x30\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xD6"],
        ["\x88\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x58"],

        ["\x30\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xD7"],
        ["\x88\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x59"],

        ["\x30\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xD8"],
        ["\x88\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x5A"],

        ["\x30\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xD9"],
        ["\x88\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x5B"],

        ["\x30\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xDA"],
        ["\x88\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x5C"],

        ["\x30\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xDB"],
        ["\x88\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x5D"],

        ["\x30\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xDC"],
        ["\x88\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x5E"],

        ["\x30\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xDD"],
        ["\x88\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x5F"],

        ["\x30\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xDE"],
        ["\x88\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x60"],

        ["\x30\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xDF"],
        ["\x88\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x61"],

        ["\x30\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xE0"],
        ["\x88\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x62"],

        ["\x30\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xE1"],
        ["\x88\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x63"],

        ["\x30\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xE2"],
        ["\x88\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x64"],

        ["\x30\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xE3"],
        ["\x88\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x65"],

        ["\x30\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xE4"],
        ["\x88\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x66"],

        ["\x30\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xE5"],
        ["\x88\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x67"],

        ["\x30\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xE6"],
        ["\x88\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x68"],

        ["\x30\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xE7"],
        ["\x88\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x69"],

        ["\x30\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xE8"],
        ["\x88\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x6A"],

        ["\x30\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xE9"],
        ["\x88\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x6B"],

        ["\x30\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xEA"],
        ["\x88\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x6C"],

        ["\x30\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xEB"],
        ["\x88\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x6D"],

        ["\x30\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xEC"],
        ["\x88\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x6E"],

        ["\x30\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xED"],
        ["\x88\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x6F"],

        ["\x30\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xEE"],
        ["\x88\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x70"],

        ["\x30\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xEF"],
        ["\x88\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x71"],

        ["\x30\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xF0"],
        ["\x88\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x72"],

        ["\x30\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xF1"],
        ["\x88\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x73"],

        ["\x30\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xF2"],
        ["\x88\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x74"],

        ["\x30\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xF3"],
        ["\x88\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x75"],

        ["\x30\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xF4"],
        ["\x88\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x76"],

        ["\x30\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xF5"],
        ["\x88\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x77"],

        ["\x30\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xF6"],
        ["\x88\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x78"],

        ["\x30\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xF7"],
        ["\x88\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x79"],

        ["\x30\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xF8"],
        ["\x88\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x7A"],

        ["\x30\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xF9"],
        ["\x88\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x7B"],

        ["\x30\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xFA"],
        ["\x88\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x7C"],

        ["\x30\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xFB"],
        ["\x88\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x7D"],

        ["\x30\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x88\xFC"],
        ["\x88\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x7E"],

        ["\x31\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x40"],
        ["\x89\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x21"],

        ["\x31\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x41"],
        ["\x89\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x22"],

        ["\x31\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x42"],
        ["\x89\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x23"],

        ["\x31\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x43"],
        ["\x89\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x24"],

        ["\x31\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x44"],
        ["\x89\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x25"],

        ["\x31\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x45"],
        ["\x89\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x26"],

        ["\x31\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x46"],
        ["\x89\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x27"],

        ["\x31\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x47"],
        ["\x89\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x28"],

        ["\x31\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x48"],
        ["\x89\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x29"],

        ["\x31\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x49"],
        ["\x89\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x2A"],

        ["\x31\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x4A"],
        ["\x89\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x2B"],

        ["\x31\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x4B"],
        ["\x89\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x2C"],

        ["\x31\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x4C"],
        ["\x89\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x2D"],

        ["\x31\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x4D"],
        ["\x89\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x2E"],

        ["\x31\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x4E"],
        ["\x89\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x2F"],

        ["\x31\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x4F"],
        ["\x89\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x30"],

        ["\x31\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x50"],
        ["\x89\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x31"],

        ["\x31\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x51"],
        ["\x89\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x32"],

        ["\x31\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x52"],
        ["\x89\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x33"],

        ["\x31\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x53"],
        ["\x89\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x34"],

        ["\x31\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x54"],
        ["\x89\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x35"],

        ["\x31\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x55"],
        ["\x89\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x36"],

        ["\x31\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x56"],
        ["\x89\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x37"],

        ["\x31\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x57"],
        ["\x89\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x38"],

        ["\x31\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x58"],
        ["\x89\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x39"],

        ["\x31\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x59"],
        ["\x89\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x3A"],

        ["\x31\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x5A"],
        ["\x89\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x3B"],

        ["\x31\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x5B"],
        ["\x89\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x3C"],

        ["\x31\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x5C"],
        ["\x89\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x3D"],

        ["\x31\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x5D"],
        ["\x89\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x3E"],

        ["\x31\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x5E"],
        ["\x89\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x3F"],

        ["\x31\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x5F"],
        ["\x89\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x40"],

        ["\x31\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x60"],
        ["\x89\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x41"],

        ["\x31\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x61"],
        ["\x89\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x42"],

        ["\x31\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x62"],
        ["\x89\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x43"],

        ["\x31\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x63"],
        ["\x89\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x44"],

        ["\x31\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x64"],
        ["\x89\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x45"],

        ["\x31\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x65"],
        ["\x89\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x46"],

        ["\x31\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x66"],
        ["\x89\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x47"],

        ["\x31\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x67"],
        ["\x89\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x48"],

        ["\x31\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x68"],
        ["\x89\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x49"],

        ["\x31\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x69"],
        ["\x89\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x4A"],

        ["\x31\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x6A"],
        ["\x89\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x4B"],

        ["\x31\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x6B"],
        ["\x89\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x4C"],

        ["\x31\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x6C"],
        ["\x89\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x4D"],

        ["\x31\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x6D"],
        ["\x89\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x4E"],

        ["\x31\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x6E"],
        ["\x89\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x4F"],

        ["\x31\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x6F"],
        ["\x89\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x50"],

        ["\x31\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x70"],
        ["\x89\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x51"],

        ["\x31\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x71"],
        ["\x89\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x52"],

        ["\x31\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x72"],
        ["\x89\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x53"],

        ["\x31\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x73"],
        ["\x89\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x54"],

        ["\x31\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x74"],
        ["\x89\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x55"],

        ["\x31\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x75"],
        ["\x89\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x56"],

        ["\x31\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x76"],
        ["\x89\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x57"],

        ["\x31\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x77"],
        ["\x89\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x58"],

        ["\x31\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x78"],
        ["\x89\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x59"],

        ["\x31\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x79"],
        ["\x89\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x5A"],

        ["\x31\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x7A"],
        ["\x89\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x5B"],

        ["\x31\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x7B"],
        ["\x89\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x5C"],

        ["\x31\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x7C"],
        ["\x89\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x5D"],

        ["\x31\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x7D"],
        ["\x89\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x5E"],

        ["\x31\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x7E"],
        ["\x89\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x5F"],

        ["\x31\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x80"],
        ["\x89\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x60"],

        ["\x31\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x81"],
        ["\x89\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x61"],

        ["\x31\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x82"],
        ["\x89\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x62"],

        ["\x31\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x83"],
        ["\x89\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x63"],

        ["\x31\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x84"],
        ["\x89\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x64"],

        ["\x31\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x85"],
        ["\x89\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x65"],

        ["\x31\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x86"],
        ["\x89\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x66"],

        ["\x31\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x87"],
        ["\x89\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x67"],

        ["\x31\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x88"],
        ["\x89\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x68"],

        ["\x31\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x89"],
        ["\x89\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x69"],

        ["\x31\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x8A"],
        ["\x89\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x6A"],

        ["\x31\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x8B"],
        ["\x89\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x6B"],

        ["\x31\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x8C"],
        ["\x89\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x6C"],

        ["\x31\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x8D"],
        ["\x89\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x6D"],

        ["\x31\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x8E"],
        ["\x89\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x6E"],

        ["\x31\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x8F"],
        ["\x89\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x6F"],

        ["\x31\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x90"],
        ["\x89\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x70"],

        ["\x31\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x91"],
        ["\x89\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x71"],

        ["\x31\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x92"],
        ["\x89\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x72"],

        ["\x31\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x93"],
        ["\x89\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x73"],

        ["\x31\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x94"],
        ["\x89\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x74"],

        ["\x31\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x95"],
        ["\x89\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x75"],

        ["\x31\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x96"],
        ["\x89\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x76"],

        ["\x31\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x97"],
        ["\x89\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x77"],

        ["\x31\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x98"],
        ["\x89\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x78"],

        ["\x31\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x99"],
        ["\x89\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x79"],

        ["\x31\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x9A"],
        ["\x89\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x7A"],

        ["\x31\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x9B"],
        ["\x89\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x7B"],

        ["\x31\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x9C"],
        ["\x89\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x7C"],

        ["\x31\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x9D"],
        ["\x89\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x7D"],

        ["\x31\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x9E"],
        ["\x89\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x31\x7E"],

        ["\x32\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\x9F"],
        ["\x89\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x21"],

        ["\x32\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xA0"],
        ["\x89\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x22"],

        ["\x32\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xA1"],
        ["\x89\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x23"],

        ["\x32\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xA2"],
        ["\x89\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x24"],

        ["\x32\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xA3"],
        ["\x89\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x25"],

        ["\x32\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xA4"],
        ["\x89\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x26"],

        ["\x32\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xA5"],
        ["\x89\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x27"],

        ["\x32\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xA6"],
        ["\x89\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x28"],

        ["\x72\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xA7"],
        ["\x89\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x74"],

        ["\x32\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xA8"],
        ["\x89\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x2A"],

        ["\x32\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xA9"],
        ["\x89\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x2B"],

        ["\x32\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xAA"],
        ["\x89\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x2C"],

        ["\x32\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xAB"],
        ["\x89\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x2D"],

        ["\x32\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xAC"],
        ["\x89\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x2E"],

        ["\x32\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xAD"],
        ["\x89\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x2F"],

        ["\x32\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xAE"],
        ["\x89\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x30"],

        ["\x32\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xAF"],
        ["\x89\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x31"],

        ["\x32\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xB0"],
        ["\x89\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x32"],

        ["\x32\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xB1"],
        ["\x89\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x33"],

        ["\x32\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xB2"],
        ["\x89\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x34"],

        ["\x32\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xB3"],
        ["\x89\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x35"],

        ["\x32\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xB4"],
        ["\x89\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x36"],

        ["\x32\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xB5"],
        ["\x89\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x37"],

        ["\x32\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xB6"],
        ["\x89\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x38"],

        ["\x32\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xB7"],
        ["\x89\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x39"],

        ["\x32\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xB8"],
        ["\x89\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x3A"],

        ["\x32\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xB9"],
        ["\x89\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x3B"],

        ["\x32\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xBA"],
        ["\x89\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x3C"],

        ["\x32\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xBB"],
        ["\x89\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x3D"],

        ["\x32\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xBC"],
        ["\x89\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x3E"],

        ["\x32\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xBD"],
        ["\x89\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x3F"],

        ["\x32\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xBE"],
        ["\x89\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x40"],

        ["\x32\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xBF"],
        ["\x89\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x41"],

        ["\x32\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xC0"],
        ["\x89\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x42"],

        ["\x32\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xC1"],
        ["\x89\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x43"],

        ["\x32\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xC2"],
        ["\x89\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x44"],

        ["\x32\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xC3"],
        ["\x89\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x45"],

        ["\x32\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xC4"],
        ["\x89\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x46"],

        ["\x32\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xC5"],
        ["\x89\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x47"],

        ["\x32\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xC6"],
        ["\x89\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x48"],

        ["\x32\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xC7"],
        ["\x89\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x49"],

        ["\x32\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xC8"],
        ["\x89\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x4A"],

        ["\x32\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xC9"],
        ["\x89\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x4B"],

        ["\x32\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xCA"],
        ["\x89\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x4C"],

        ["\x32\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xCB"],
        ["\x89\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x4D"],

        ["\x32\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xCC"],
        ["\x89\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x4E"],

        ["\x32\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xCD"],
        ["\x89\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x4F"],

        ["\x32\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xCE"],
        ["\x89\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x50"],

        ["\x32\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xCF"],
        ["\x89\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x51"],

        ["\x32\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xD0"],
        ["\x89\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x52"],

        ["\x32\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xD1"],
        ["\x89\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x53"],

        ["\x32\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xD2"],
        ["\x89\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x54"],

        ["\x32\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xD3"],
        ["\x89\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x55"],

        ["\x32\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xD4"],
        ["\x89\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x56"],

        ["\x32\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xD5"],
        ["\x89\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x57"],

        ["\x32\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xD6"],
        ["\x89\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x58"],

        ["\x32\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xD7"],
        ["\x89\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x59"],

        ["\x32\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xD8"],
        ["\x89\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x5A"],

        ["\x32\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xD9"],
        ["\x89\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x5B"],

        ["\x32\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xDA"],
        ["\x89\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x5C"],

        ["\x32\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xDB"],
        ["\x89\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x5D"],

        ["\x32\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xDC"],
        ["\x89\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x5E"],

        ["\x32\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xDD"],
        ["\x89\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x5F"],

        ["\x32\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xDE"],
        ["\x89\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x60"],

        ["\x32\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xDF"],
        ["\x89\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x61"],

        ["\x32\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xE0"],
        ["\x89\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x62"],

        ["\x32\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xE1"],
        ["\x89\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x63"],

        ["\x32\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xE2"],
        ["\x89\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x64"],

        ["\x32\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xE3"],
        ["\x89\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x65"],

        ["\x32\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xE4"],
        ["\x89\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x66"],

        ["\x32\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xE5"],
        ["\x89\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x67"],

        ["\x32\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xE6"],
        ["\x89\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x68"],

        ["\x32\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xE7"],
        ["\x89\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x69"],

        ["\x32\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xE8"],
        ["\x89\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x6A"],

        ["\x32\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xE9"],
        ["\x89\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x6B"],

        ["\x32\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xEA"],
        ["\x89\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x6C"],

        ["\x32\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xEB"],
        ["\x89\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x6D"],

        ["\x32\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xEC"],
        ["\x89\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x6E"],

        ["\x32\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xED"],
        ["\x89\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x6F"],

        ["\x32\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xEE"],
        ["\x89\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x70"],

        ["\x32\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xEF"],
        ["\x89\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x71"],

        ["\x32\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xF0"],
        ["\x89\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x72"],

        ["\x32\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xF1"],
        ["\x89\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x73"],

        ["\x32\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xF2"],
        ["\x89\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x74"],

        ["\x32\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xF3"],
        ["\x89\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x75"],

        ["\x32\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xF4"],
        ["\x89\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x76"],

        ["\x32\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xF5"],
        ["\x89\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x77"],

        ["\x32\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xF6"],
        ["\x89\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x78"],

        ["\x32\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xF7"],
        ["\x89\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x79"],

        ["\x32\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xF8"],
        ["\x89\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x7A"],

        ["\x32\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xF9"],
        ["\x89\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x7B"],

        ["\x32\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xFA"],
        ["\x89\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x7C"],

        ["\x32\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xFB"],
        ["\x89\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x7D"],

        ["\x32\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x89\xFC"],
        ["\x89\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x7E"],

        ["\x33\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x40"],
        ["\x8A\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x21"],

        ["\x33\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x41"],
        ["\x8A\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x22"],

        ["\x33\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x42"],
        ["\x8A\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x23"],

        ["\x33\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x43"],
        ["\x8A\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x24"],

        ["\x33\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x44"],
        ["\x8A\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x25"],

        ["\x33\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x45"],
        ["\x8A\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x26"],

        ["\x33\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x46"],
        ["\x8A\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x27"],

        ["\x33\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x47"],
        ["\x8A\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x28"],

        ["\x33\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x48"],
        ["\x8A\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x29"],

        ["\x33\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x49"],
        ["\x8A\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x2A"],

        ["\x33\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x4A"],
        ["\x8A\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x2B"],

        ["\x33\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x4B"],
        ["\x8A\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x2C"],

        ["\x33\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x4C"],
        ["\x8A\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x2D"],

        ["\x33\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x4D"],
        ["\x8A\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x2E"],

        ["\x33\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x4E"],
        ["\x8A\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x2F"],

        ["\x33\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x4F"],
        ["\x8A\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x30"],

        ["\x33\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x50"],
        ["\x8A\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x31"],

        ["\x33\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x51"],
        ["\x8A\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x32"],

        ["\x33\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x52"],
        ["\x8A\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x33"],

        ["\x33\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x53"],
        ["\x8A\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x34"],

        ["\x33\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x54"],
        ["\x8A\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x35"],

        ["\x33\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x55"],
        ["\x8A\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x36"],

        ["\x33\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x56"],
        ["\x8A\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x37"],

        ["\x33\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x57"],
        ["\x8A\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x38"],

        ["\x33\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x58"],
        ["\x8A\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x39"],

        ["\x33\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x59"],
        ["\x8A\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x3A"],

        ["\x33\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x5A"],
        ["\x8A\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x3B"],

        ["\x33\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x5B"],
        ["\x8A\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x3C"],

        ["\x33\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x5C"],
        ["\x8A\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x3D"],

        ["\x33\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x5D"],
        ["\x8A\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x3E"],

        ["\x33\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x5E"],
        ["\x8A\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x3F"],

        ["\x33\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x5F"],
        ["\x8A\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x40"],

        ["\x33\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x60"],
        ["\x8A\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x41"],

        ["\x69\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x61"],
        ["\x8A\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x5A"],

        ["\x33\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x62"],
        ["\x8A\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x43"],

        ["\x33\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x63"],
        ["\x8A\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x44"],

        ["\x33\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x64"],
        ["\x8A\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x45"],

        ["\x33\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x65"],
        ["\x8A\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x46"],

        ["\x33\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x66"],
        ["\x8A\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x47"],

        ["\x33\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x67"],
        ["\x8A\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x48"],

        ["\x59\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x68"],
        ["\x8A\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x78"],

        ["\x33\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x69"],
        ["\x8A\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x4A"],

        ["\x33\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x6A"],
        ["\x8A\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x4B"],

        ["\x33\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x6B"],
        ["\x8A\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x4C"],

        ["\x33\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x6C"],
        ["\x8A\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x4D"],

        ["\x33\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x6D"],
        ["\x8A\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x4E"],

        ["\x33\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x6E"],
        ["\x8A\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x4F"],

        ["\x33\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x6F"],
        ["\x8A\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x50"],

        ["\x33\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x70"],
        ["\x8A\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x51"],

        ["\x33\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x71"],
        ["\x8A\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x52"],

        ["\x33\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x72"],
        ["\x8A\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x53"],

        ["\x33\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x73"],
        ["\x8A\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x54"],

        ["\x33\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x74"],
        ["\x8A\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x55"],

        ["\x33\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x75"],
        ["\x8A\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x56"],

        ["\x33\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x76"],
        ["\x8A\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x57"],

        ["\x33\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x77"],
        ["\x8A\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x58"],

        ["\x33\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x78"],
        ["\x8A\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x59"],

        ["\x33\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x79"],
        ["\x8A\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x5A"],

        ["\x33\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x7A"],
        ["\x8A\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x5B"],

        ["\x33\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x7B"],
        ["\x8A\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x5C"],

        ["\x33\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x7C"],
        ["\x8A\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x5D"],

        ["\x33\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x7D"],
        ["\x8A\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x5E"],

        ["\x33\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x7E"],
        ["\x8A\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x5F"],

        ["\x33\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x80"],
        ["\x8A\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x60"],

        ["\x33\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x81"],
        ["\x8A\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x61"],

        ["\x33\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x82"],
        ["\x8A\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x62"],

        ["\x33\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x83"],
        ["\x8A\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x63"],

        ["\x33\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x84"],
        ["\x8A\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x64"],

        ["\x33\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x85"],
        ["\x8A\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x65"],

        ["\x33\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x86"],
        ["\x8A\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x66"],

        ["\x33\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x87"],
        ["\x8A\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x67"],

        ["\x33\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x88"],
        ["\x8A\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x68"],

        ["\x33\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x89"],
        ["\x8A\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x69"],

        ["\x33\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x8A"],
        ["\x8A\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x6A"],

        ["\x33\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x8B"],
        ["\x8A\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x6B"],

        ["\x33\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x8C"],
        ["\x8A\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x6C"],

        ["\x33\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x8D"],
        ["\x8A\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x6D"],

        ["\x33\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x8E"],
        ["\x8A\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x6E"],

        ["\x33\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x8F"],
        ["\x8A\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x6F"],

        ["\x33\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x90"],
        ["\x8A\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x70"],

        ["\x33\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x91"],
        ["\x8A\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x71"],

        ["\x33\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x92"],
        ["\x8A\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x72"],

        ["\x33\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x93"],
        ["\x8A\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x73"],

        ["\x33\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x94"],
        ["\x8A\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x74"],

        ["\x33\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x95"],
        ["\x8A\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x75"],

        ["\x63\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x96"],
        ["\x8A\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x5E"],

        ["\x33\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x97"],
        ["\x8A\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x77"],

        ["\x33\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x98"],
        ["\x8A\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x78"],

        ["\x33\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x99"],
        ["\x8A\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x79"],

        ["\x33\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x9A"],
        ["\x8A\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x7A"],

        ["\x33\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x9B"],
        ["\x8A\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x7B"],

        ["\x33\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x9C"],
        ["\x8A\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x7C"],

        ["\x33\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x9D"],
        ["\x8A\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x7D"],

        ["\x33\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x9E"],
        ["\x8A\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x7E"],

        ["\x34\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\x9F"],
        ["\x8A\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x21"],

        ["\x34\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xA0"],
        ["\x8A\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x22"],

        ["\x34\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xA1"],
        ["\x8A\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x23"],

        ["\x34\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xA2"],
        ["\x8A\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x24"],

        ["\x34\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xA3"],
        ["\x8A\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x25"],

        ["\x34\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xA4"],
        ["\x8A\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x26"],

        ["\x34\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xA5"],
        ["\x8A\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x27"],

        ["\x34\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xA6"],
        ["\x8A\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x28"],

        ["\x34\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xA7"],
        ["\x8A\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x29"],

        ["\x34\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xA8"],
        ["\x8A\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x2A"],

        ["\x34\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xA9"],
        ["\x8A\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x2B"],

        ["\x34\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xAA"],
        ["\x8A\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x2C"],

        ["\x34\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xAB"],
        ["\x8A\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x2D"],

        ["\x34\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xAC"],
        ["\x8A\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x2E"],

        ["\x34\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xAD"],
        ["\x8A\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x2F"],

        ["\x34\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xAE"],
        ["\x8A\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x30"],

        ["\x34\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xAF"],
        ["\x8A\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x31"],

        ["\x34\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xB0"],
        ["\x8A\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x32"],

        ["\x34\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xB1"],
        ["\x8A\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x33"],

        ["\x34\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xB2"],
        ["\x8A\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x34"],

        ["\x34\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xB3"],
        ["\x8A\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x35"],

        ["\x34\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xB4"],
        ["\x8A\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x36"],

        ["\x34\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xB5"],
        ["\x8A\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x37"],

        ["\x34\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xB6"],
        ["\x8A\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x38"],

        ["\x34\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xB7"],
        ["\x8A\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x39"],

        ["\x34\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xB8"],
        ["\x8A\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x3A"],

        ["\x34\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xB9"],
        ["\x8A\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x3B"],

        ["\x34\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xBA"],
        ["\x8A\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x3C"],

        ["\x34\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xBB"],
        ["\x8A\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x3D"],

        ["\x34\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xBC"],
        ["\x8A\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x3E"],

        ["\x34\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xBD"],
        ["\x8A\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x3F"],

        ["\x34\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xBE"],
        ["\x8A\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x40"],

        ["\x34\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xBF"],
        ["\x8A\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x41"],

        ["\x34\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xC0"],
        ["\x8A\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x42"],

        ["\x5E\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xC1"],
        ["\x8A\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x75"],

        ["\x34\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xC2"],
        ["\x8A\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x44"],

        ["\x34\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xC3"],
        ["\x8A\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x45"],

        ["\x34\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xC4"],
        ["\x8A\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x46"],

        ["\x34\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xC5"],
        ["\x8A\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x47"],

        ["\x34\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xC6"],
        ["\x8A\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x48"],

        ["\x34\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xC7"],
        ["\x8A\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x49"],

        ["\x34\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xC8"],
        ["\x8A\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x4A"],

        ["\x34\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xC9"],
        ["\x8A\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x4B"],

        ["\x34\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xCA"],
        ["\x8A\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x4C"],

        ["\x34\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xCB"],
        ["\x8A\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x4D"],

        ["\x34\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xCC"],
        ["\x8A\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x4E"],

        ["\x34\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xCD"],
        ["\x8A\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x4F"],

        ["\x34\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xCE"],
        ["\x8A\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x50"],

        ["\x34\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xCF"],
        ["\x8A\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x51"],

        ["\x6B\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xD0"],
        ["\x8A\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x5D"],

        ["\x34\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xD1"],
        ["\x8A\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x53"],

        ["\x34\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xD2"],
        ["\x8A\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x54"],

        ["\x34\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xD3"],
        ["\x8A\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x55"],

        ["\x34\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xD4"],
        ["\x8A\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x56"],

        ["\x34\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xD5"],
        ["\x8A\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x57"],

        ["\x34\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xD6"],
        ["\x8A\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x58"],

        ["\x34\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xD7"],
        ["\x8A\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x59"],

        ["\x34\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xD8"],
        ["\x8A\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x5A"],

        ["\x34\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xD9"],
        ["\x8A\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x5B"],

        ["\x34\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xDA"],
        ["\x8A\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x5C"],

        ["\x34\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xDB"],
        ["\x8A\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x5D"],

        ["\x34\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xDC"],
        ["\x8A\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x5E"],

        ["\x34\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xDD"],
        ["\x8A\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x5F"],

        ["\x34\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xDE"],
        ["\x8A\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x60"],

        ["\x34\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xDF"],
        ["\x8A\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x61"],

        ["\x34\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xE0"],
        ["\x8A\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x62"],

        ["\x34\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xE1"],
        ["\x8A\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x63"],

        ["\x34\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xE2"],
        ["\x8A\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x64"],

        ["\x34\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xE3"],
        ["\x8A\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x65"],

        ["\x34\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xE4"],
        ["\x8A\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x66"],

        ["\x34\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xE5"],
        ["\x8A\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x67"],

        ["\x34\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xE6"],
        ["\x8A\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x68"],

        ["\x34\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xE7"],
        ["\x8A\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x69"],

        ["\x34\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xE8"],
        ["\x8A\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x6A"],

        ["\x34\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xE9"],
        ["\x8A\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x6B"],

        ["\x34\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xEA"],
        ["\x8A\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x6C"],

        ["\x34\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xEB"],
        ["\x8A\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x6D"],

        ["\x34\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xEC"],
        ["\x8A\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x6E"],

        ["\x34\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xED"],
        ["\x8A\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x6F"],

        ["\x34\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xEE"],
        ["\x8A\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x70"],

        ["\x34\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xEF"],
        ["\x8A\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x71"],

        ["\x34\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xF0"],
        ["\x8A\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x72"],

        ["\x34\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xF1"],
        ["\x8A\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x73"],

        ["\x34\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xF2"],
        ["\x8A\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x74"],

        ["\x34\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xF3"],
        ["\x8A\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x75"],

        ["\x34\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xF4"],
        ["\x8A\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x76"],

        ["\x34\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xF5"],
        ["\x8A\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x77"],

        ["\x34\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xF6"],
        ["\x8A\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x78"],

        ["\x34\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xF7"],
        ["\x8A\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x79"],

        ["\x34\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xF8"],
        ["\x8A\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x7A"],

        ["\x34\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xF9"],
        ["\x8A\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x7B"],

        ["\x34\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xFA"],
        ["\x8A\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x7C"],

        ["\x34\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xFB"],
        ["\x8A\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x7D"],

        ["\x34\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8A\xFC"],
        ["\x8A\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x7E"],

        ["\x35\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x40"],
        ["\x8B\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x21"],

        ["\x35\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x41"],
        ["\x8B\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x22"],

        ["\x35\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x42"],
        ["\x8B\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x23"],

        ["\x35\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x43"],
        ["\x8B\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x24"],

        ["\x35\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x44"],
        ["\x8B\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x25"],

        ["\x35\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x45"],
        ["\x8B\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x26"],

        ["\x35\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x46"],
        ["\x8B\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x27"],

        ["\x35\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x47"],
        ["\x8B\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x28"],

        ["\x35\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x48"],
        ["\x8B\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x29"],

        ["\x35\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x49"],
        ["\x8B\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x2A"],

        ["\x35\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x4A"],
        ["\x8B\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x2B"],

        ["\x35\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x4B"],
        ["\x8B\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x2C"],

        ["\x35\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x4C"],
        ["\x8B\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x2D"],

        ["\x35\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x4D"],
        ["\x8B\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x2E"],

        ["\x35\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x4E"],
        ["\x8B\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x2F"],

        ["\x35\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x4F"],
        ["\x8B\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x30"],

        ["\x35\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x50"],
        ["\x8B\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x31"],

        ["\x35\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x51"],
        ["\x8B\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x32"],

        ["\x35\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x52"],
        ["\x8B\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x33"],

        ["\x35\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x53"],
        ["\x8B\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x34"],

        ["\x35\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x54"],
        ["\x8B\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x35"],

        ["\x35\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x55"],
        ["\x8B\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x36"],

        ["\x35\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x56"],
        ["\x8B\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x37"],

        ["\x35\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x57"],
        ["\x8B\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x38"],

        ["\x35\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x58"],
        ["\x8B\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x39"],

        ["\x35\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x59"],
        ["\x8B\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x3A"],

        ["\x35\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x5A"],
        ["\x8B\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x3B"],

        ["\x35\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x5B"],
        ["\x8B\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x3C"],

        ["\x35\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x5C"],
        ["\x8B\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x3D"],

        ["\x35\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x5D"],
        ["\x8B\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x3E"],

        ["\x35\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x5E"],
        ["\x8B\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x3F"],

        ["\x35\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x5F"],
        ["\x8B\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x40"],

        ["\x35\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x60"],
        ["\x8B\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x41"],

        ["\x35\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x61"],
        ["\x8B\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x42"],

        ["\x35\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x62"],
        ["\x8B\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x43"],

        ["\x35\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x63"],
        ["\x8B\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x44"],

        ["\x35\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x64"],
        ["\x8B\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x45"],

        ["\x35\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x65"],
        ["\x8B\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x46"],

        ["\x35\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x66"],
        ["\x8B\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x47"],

        ["\x35\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x67"],
        ["\x8B\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x48"],

        ["\x35\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x68"],
        ["\x8B\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x49"],

        ["\x35\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x69"],
        ["\x8B\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x4A"],

        ["\x35\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x6A"],
        ["\x8B\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x4B"],

        ["\x35\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x6B"],
        ["\x8B\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x4C"],

        ["\x35\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x6C"],
        ["\x8B\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x4D"],

        ["\x35\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x6D"],
        ["\x8B\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x4E"],

        ["\x35\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x6E"],
        ["\x8B\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x4F"],

        ["\x35\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x6F"],
        ["\x8B\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x50"],

        ["\x35\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x70"],
        ["\x8B\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x51"],

        ["\x35\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x71"],
        ["\x8B\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x52"],

        ["\x35\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x72"],
        ["\x8B\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x53"],

        ["\x35\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x73"],
        ["\x8B\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x54"],

        ["\x35\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x74"],
        ["\x8B\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x55"],

        ["\x35\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x75"],
        ["\x8B\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x56"],

        ["\x35\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x76"],
        ["\x8B\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x57"],

        ["\x35\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x77"],
        ["\x8B\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x58"],

        ["\x35\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x78"],
        ["\x8B\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x59"],

        ["\x35\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x79"],
        ["\x8B\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x5A"],

        ["\x35\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x7A"],
        ["\x8B\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x5B"],

        ["\x35\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x7B"],
        ["\x8B\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x5C"],

        ["\x35\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x7C"],
        ["\x8B\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x5D"],

        ["\x35\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x7D"],
        ["\x8B\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x5E"],

        ["\x35\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x7E"],
        ["\x8B\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x5F"],

        ["\x35\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x80"],
        ["\x8B\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x60"],

        ["\x35\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x81"],
        ["\x8B\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x61"],

        ["\x35\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x82"],
        ["\x8B\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x62"],

        ["\x35\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x83"],
        ["\x8B\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x63"],

        ["\x35\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x84"],
        ["\x8B\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x64"],

        ["\x35\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x85"],
        ["\x8B\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x65"],

        ["\x35\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x86"],
        ["\x8B\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x66"],

        ["\x35\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x87"],
        ["\x8B\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x67"],

        ["\x35\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x88"],
        ["\x8B\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x68"],

        ["\x35\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x89"],
        ["\x8B\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x69"],

        ["\x35\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x8A"],
        ["\x8B\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x6A"],

        ["\x35\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x8B"],
        ["\x8B\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x6B"],

        ["\x35\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x8C"],
        ["\x8B\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x6C"],

        ["\x35\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x8D"],
        ["\x8B\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x6D"],

        ["\x35\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x8E"],
        ["\x8B\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x6E"],

        ["\x35\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x8F"],
        ["\x8B\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x6F"],

        ["\x35\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x90"],
        ["\x8B\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x70"],

        ["\x35\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x91"],
        ["\x8B\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x71"],

        ["\x35\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x92"],
        ["\x8B\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x72"],

        ["\x35\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x93"],
        ["\x8B\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x73"],

        ["\x35\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x94"],
        ["\x8B\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x74"],

        ["\x35\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x95"],
        ["\x8B\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x75"],

        ["\x35\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x96"],
        ["\x8B\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x76"],

        ["\x35\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x97"],
        ["\x8B\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x77"],

        ["\x35\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x98"],
        ["\x8B\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x78"],

        ["\x35\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x99"],
        ["\x8B\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x79"],

        ["\x35\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x9A"],
        ["\x8B\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x7A"],

        ["\x35\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x9B"],
        ["\x8B\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x7B"],

        ["\x35\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x9C"],
        ["\x8B\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x7C"],

        ["\x35\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x9D"],
        ["\x8B\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x7D"],

        ["\x35\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x9E"],
        ["\x8B\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x35\x7E"],

        ["\x36\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\x9F"],
        ["\x8B\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x21"],

        ["\x36\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xA0"],
        ["\x8B\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x22"],

        ["\x36\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xA1"],
        ["\x8B\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x23"],

        ["\x36\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xA2"],
        ["\x8B\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x24"],

        ["\x36\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xA3"],
        ["\x8B\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x25"],

        ["\x36\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xA4"],
        ["\x8B\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x26"],

        ["\x36\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xA5"],
        ["\x8B\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x27"],

        ["\x36\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xA6"],
        ["\x8B\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x28"],

        ["\x36\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xA7"],
        ["\x8B\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x29"],

        ["\x36\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xA8"],
        ["\x8B\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x2A"],

        ["\x36\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xA9"],
        ["\x8B\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x2B"],

        ["\x36\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xAA"],
        ["\x8B\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x2C"],

        ["\x36\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xAB"],
        ["\x8B\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x2D"],

        ["\x36\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xAC"],
        ["\x8B\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x2E"],

        ["\x36\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xAD"],
        ["\x8B\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x2F"],

        ["\x36\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xAE"],
        ["\x8B\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x30"],

        ["\x36\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xAF"],
        ["\x8B\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x31"],

        ["\x36\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xB0"],
        ["\x8B\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x32"],

        ["\x36\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xB1"],
        ["\x8B\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x33"],

        ["\x36\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xB2"],
        ["\x8B\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x34"],

        ["\x36\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xB3"],
        ["\x8B\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x35"],

        ["\x36\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xB4"],
        ["\x8B\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x36"],

        ["\x36\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xB5"],
        ["\x8B\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x37"],

        ["\x36\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xB6"],
        ["\x8B\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x38"],

        ["\x36\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xB7"],
        ["\x8B\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x39"],

        ["\x36\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xB8"],
        ["\x8B\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x3A"],

        ["\x36\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xB9"],
        ["\x8B\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x3B"],

        ["\x36\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xBA"],
        ["\x8B\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x3C"],

        ["\x36\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xBB"],
        ["\x8B\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x3D"],

        ["\x36\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xBC"],
        ["\x8B\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x3E"],

        ["\x36\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xBD"],
        ["\x8B\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x3F"],

        ["\x36\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xBE"],
        ["\x8B\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x40"],

        ["\x36\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xBF"],
        ["\x8B\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x41"],

        ["\x36\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xC0"],
        ["\x8B\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x42"],

        ["\x36\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xC1"],
        ["\x8B\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x43"],

        ["\x36\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xC2"],
        ["\x8B\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x44"],

        ["\x36\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xC3"],
        ["\x8B\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x45"],

        ["\xB6\xDA",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xC4"],
        ["\x8B\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xDA"],

        ["\x36\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xC5"],
        ["\x8B\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x47"],

        ["\x36\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xC6"],
        ["\x8B\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x48"],

        ["\x36\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xC7"],
        ["\x8B\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x49"],

        ["\x36\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xC8"],
        ["\x8B\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x4A"],

        ["\x36\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xC9"],
        ["\x8B\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x4B"],

        ["\x36\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xCA"],
        ["\x8B\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x4C"],

        ["\x36\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xCB"],
        ["\x8B\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x4D"],

        ["\x36\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xCC"],
        ["\x8B\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x4E"],

        ["\x36\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xCD"],
        ["\x8B\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x4F"],

        ["\x36\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xCE"],
        ["\x8B\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x50"],

        ["\x36\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xCF"],
        ["\x8B\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x51"],

        ["\x36\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xD0"],
        ["\x8B\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x52"],

        ["\x36\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xD1"],
        ["\x8B\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x53"],

        ["\x36\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xD2"],
        ["\x8B\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x54"],

        ["\x36\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xD3"],
        ["\x8B\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x55"],

        ["\x36\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xD4"],
        ["\x8B\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x56"],

        ["\x36\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xD5"],
        ["\x8B\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x57"],

        ["\x36\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xD6"],
        ["\x8B\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x58"],

        ["\x36\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xD7"],
        ["\x8B\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x59"],

        ["\x36\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xD8"],
        ["\x8B\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x5A"],

        ["\x36\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xD9"],
        ["\x8B\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x5B"],

        ["\x36\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xDA"],
        ["\x8B\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x5C"],

        ["\x36\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xDB"],
        ["\x8B\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x5D"],

        ["\x36\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xDC"],
        ["\x8B\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x5E"],

        ["\x36\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xDD"],
        ["\x8B\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x5F"],

        ["\x36\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xDE"],
        ["\x8B\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x60"],

        ["\x36\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xDF"],
        ["\x8B\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x61"],

        ["\x36\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xE0"],
        ["\x8B\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x62"],

        ["\x36\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xE1"],
        ["\x8B\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x63"],

        ["\x36\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xE2"],
        ["\x8B\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x64"],

        ["\x36\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xE3"],
        ["\x8B\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x65"],

        ["\x36\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xE4"],
        ["\x8B\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x66"],

        ["\x36\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xE5"],
        ["\x8B\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x67"],

        ["\x36\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xE6"],
        ["\x8B\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x68"],

        ["\x36\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xE7"],
        ["\x8B\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x69"],

        ["\x36\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xE8"],
        ["\x8B\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x6A"],

        ["\x36\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xE9"],
        ["\x8B\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x6B"],

        ["\x36\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xEA"],
        ["\x8B\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x6C"],

        ["\x36\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xEB"],
        ["\x8B\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x6D"],

        ["\x36\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xEC"],
        ["\x8B\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x6E"],

        ["\x36\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xED"],
        ["\x8B\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x6F"],

        ["\x36\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xEE"],
        ["\x8B\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x70"],

        ["\x36\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xEF"],
        ["\x8B\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x71"],

        ["\x36\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xF0"],
        ["\x8B\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x72"],

        ["\x36\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xF1"],
        ["\x8B\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x73"],

        ["\x36\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xF2"],
        ["\x8B\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x74"],

        ["\x36\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xF3"],
        ["\x8B\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x75"],

        ["\x36\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xF4"],
        ["\x8B\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x76"],

        ["\x36\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xF5"],
        ["\x8B\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x77"],

        ["\x36\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xF6"],
        ["\x8B\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x78"],

        ["\x36\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xF7"],
        ["\x8B\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x79"],

        ["\x36\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xF8"],
        ["\x8B\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x7A"],

        ["\x36\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xF9"],
        ["\x8B\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x7B"],

        ["\x36\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xFA"],
        ["\x8B\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x7C"],

        ["\x36\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xFB"],
        ["\x8B\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x7D"],

        ["\x36\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8B\xFC"],
        ["\x8B\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x36\x7E"],

        ["\x37\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x40"],
        ["\x8C\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x21"],

        ["\x37\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x41"],
        ["\x8C\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x22"],

        ["\x37\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x42"],
        ["\x8C\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x23"],

        ["\x37\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x43"],
        ["\x8C\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x24"],

        ["\x37\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x44"],
        ["\x8C\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x25"],

        ["\x37\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x45"],
        ["\x8C\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x26"],

        ["\x37\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x46"],
        ["\x8C\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x27"],

        ["\x37\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x47"],
        ["\x8C\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x28"],

        ["\x37\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x48"],
        ["\x8C\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x29"],

        ["\x37\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x49"],
        ["\x8C\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x2A"],

        ["\x37\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x4A"],
        ["\x8C\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x2B"],

        ["\x37\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x4B"],
        ["\x8C\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x2C"],

        ["\x37\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x4C"],
        ["\x8C\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x2D"],

        ["\x37\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x4D"],
        ["\x8C\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x2E"],

        ["\x37\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x4E"],
        ["\x8C\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x2F"],

        ["\x37\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x4F"],
        ["\x8C\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x30"],

        ["\x37\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x50"],
        ["\x8C\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x31"],

        ["\x37\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x51"],
        ["\x8C\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x32"],

        ["\x37\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x52"],
        ["\x8C\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x33"],

        ["\x37\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x53"],
        ["\x8C\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x34"],

        ["\x37\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x54"],
        ["\x8C\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x35"],

        ["\x37\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x55"],
        ["\x8C\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x36"],

        ["\x37\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x56"],
        ["\x8C\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x37"],

        ["\x37\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x57"],
        ["\x8C\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x38"],

        ["\x37\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x58"],
        ["\x8C\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x39"],

        ["\x37\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x59"],
        ["\x8C\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x3A"],

        ["\x37\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x5A"],
        ["\x8C\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x3B"],

        ["\x37\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x5B"],
        ["\x8C\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x3C"],

        ["\x37\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x5C"],
        ["\x8C\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x3D"],

        ["\x37\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x5D"],
        ["\x8C\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x3E"],

        ["\x37\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x5E"],
        ["\x8C\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x3F"],

        ["\x37\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x5F"],
        ["\x8C\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x40"],

        ["\x37\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x60"],
        ["\x8C\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x41"],

        ["\x37\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x61"],
        ["\x8C\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x42"],

        ["\x37\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x62"],
        ["\x8C\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x43"],

        ["\x37\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x63"],
        ["\x8C\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x44"],

        ["\x37\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x64"],
        ["\x8C\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x45"],

        ["\x37\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x65"],
        ["\x8C\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x46"],

        ["\x37\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x66"],
        ["\x8C\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x47"],

        ["\x37\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x67"],
        ["\x8C\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x48"],

        ["\x37\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x68"],
        ["\x8C\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x49"],

        ["\x37\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x69"],
        ["\x8C\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x4A"],

        ["\x37\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x6A"],
        ["\x8C\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x4B"],

        ["\x37\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x6B"],
        ["\x8C\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x4C"],

        ["\x37\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x6C"],
        ["\x8C\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x4D"],

        ["\x37\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x6D"],
        ["\x8C\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x4E"],

        ["\x37\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x6E"],
        ["\x8C\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x4F"],

        ["\x37\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x6F"],
        ["\x8C\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x50"],

        ["\x37\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x70"],
        ["\x8C\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x51"],

        ["\x37\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x71"],
        ["\x8C\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x52"],

        ["\x37\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x72"],
        ["\x8C\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x53"],

        ["\x37\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x73"],
        ["\x8C\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x54"],

        ["\x37\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x74"],
        ["\x8C\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x55"],

        ["\x37\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x75"],
        ["\x8C\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x56"],

        ["\x37\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x76"],
        ["\x8C\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x57"],

        ["\x37\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x77"],
        ["\x8C\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x58"],

        ["\x37\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x78"],
        ["\x8C\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x59"],

        ["\x37\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x79"],
        ["\x8C\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x5A"],

        ["\x70\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x7A"],
        ["\x8C\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x74"],

        ["\x37\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x7B"],
        ["\x8C\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x5C"],

        ["\x37\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x7C"],
        ["\x8C\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x5D"],

        ["\x37\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x7D"],
        ["\x8C\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x5E"],

        ["\x37\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x7E"],
        ["\x8C\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x5F"],

        ["\x37\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x80"],
        ["\x8C\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x60"],

        ["\x37\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x81"],
        ["\x8C\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x61"],

        ["\x37\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x82"],
        ["\x8C\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x62"],

        ["\x37\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x83"],
        ["\x8C\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x63"],

        ["\x37\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x84"],
        ["\x8C\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x64"],

        ["\x37\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x85"],
        ["\x8C\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x65"],

        ["\x37\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x86"],
        ["\x8C\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x66"],

        ["\x37\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x87"],
        ["\x8C\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x67"],

        ["\x37\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x88"],
        ["\x8C\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x68"],

        ["\x37\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x89"],
        ["\x8C\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x69"],

        ["\x37\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x8A"],
        ["\x8C\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x6A"],

        ["\x37\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x8B"],
        ["\x8C\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x6B"],

        ["\x37\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x8C"],
        ["\x8C\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x6C"],

        ["\x37\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x8D"],
        ["\x8C\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x6D"],

        ["\x37\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x8E"],
        ["\x8C\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x6E"],

        ["\x37\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x8F"],
        ["\x8C\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x6F"],

        ["\x37\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x90"],
        ["\x8C\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x70"],

        ["\x37\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x91"],
        ["\x8C\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x71"],

        ["\x37\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x92"],
        ["\x8C\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x72"],

        ["\x37\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x93"],
        ["\x8C\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x73"],

        ["\x37\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x94"],
        ["\x8C\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x74"],

        ["\x37\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x95"],
        ["\x8C\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x75"],

        ["\x37\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x96"],
        ["\x8C\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x76"],

        ["\x37\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x97"],
        ["\x8C\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x77"],

        ["\x37\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x98"],
        ["\x8C\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x78"],

        ["\x37\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x99"],
        ["\x8C\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x79"],

        ["\x37\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x9A"],
        ["\x8C\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x7A"],

        ["\x37\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x9B"],
        ["\x8C\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x7B"],

        ["\x37\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x9C"],
        ["\x8C\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x7C"],

        ["\x37\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x9D"],
        ["\x8C\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x7D"],

        ["\x37\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x9E"],
        ["\x8C\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x7E"],

        ["\x38\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\x9F"],
        ["\x8C\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x21"],

        ["\x38\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xA0"],
        ["\x8C\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x22"],

        ["\x38\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xA1"],
        ["\x8C\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x23"],

        ["\x38\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xA2"],
        ["\x8C\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x24"],

        ["\x38\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xA3"],
        ["\x8C\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x25"],

        ["\x38\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xA4"],
        ["\x8C\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x26"],

        ["\x38\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xA5"],
        ["\x8C\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x27"],

        ["\x38\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xA6"],
        ["\x8C\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x28"],

        ["\x38\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xA7"],
        ["\x8C\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x29"],

        ["\x38\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xA8"],
        ["\x8C\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x2A"],

        ["\x38\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xA9"],
        ["\x8C\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x2B"],

        ["\x38\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xAA"],
        ["\x8C\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x2C"],

        ["\x38\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xAB"],
        ["\x8C\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x2D"],

        ["\x38\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xAC"],
        ["\x8C\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x2E"],

        ["\x38\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xAD"],
        ["\x8C\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x2F"],

        ["\x38\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xAE"],
        ["\x8C\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x30"],

        ["\x38\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xAF"],
        ["\x8C\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x31"],

        ["\x38\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xB0"],
        ["\x8C\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x32"],

        ["\x38\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xB1"],
        ["\x8C\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x33"],

        ["\x38\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xB2"],
        ["\x8C\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x34"],

        ["\x38\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xB3"],
        ["\x8C\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x35"],

        ["\x38\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xB4"],
        ["\x8C\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x36"],

        ["\x38\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xB5"],
        ["\x8C\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x37"],

        ["\x38\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xB6"],
        ["\x8C\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x38"],

        ["\x38\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xB7"],
        ["\x8C\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x39"],

        ["\x38\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xB8"],
        ["\x8C\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x3A"],

        ["\x38\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xB9"],
        ["\x8C\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x3B"],

        ["\x38\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xBA"],
        ["\x8C\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x3C"],

        ["\x38\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xBB"],
        ["\x8C\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x3D"],

        ["\x38\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xBC"],
        ["\x8C\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x3E"],

        ["\x38\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xBD"],
        ["\x8C\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x3F"],

        ["\x38\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xBE"],
        ["\x8C\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x40"],

        ["\x38\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xBF"],
        ["\x8C\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x41"],

        ["\x38\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xC0"],
        ["\x8C\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x42"],

        ["\x38\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xC1"],
        ["\x8C\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x43"],

        ["\x38\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xC2"],
        ["\x8C\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x44"],

        ["\x38\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xC3"],
        ["\x8C\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x45"],

        ["\x38\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xC4"],
        ["\x8C\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x46"],

        ["\x38\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xC5"],
        ["\x8C\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x47"],

        ["\x38\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xC6"],
        ["\x8C\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x48"],

        ["\x38\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xC7"],
        ["\x8C\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x49"],

        ["\x38\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xC8"],
        ["\x8C\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x4A"],

        ["\x38\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xC9"],
        ["\x8C\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x4B"],

        ["\x38\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xCA"],
        ["\x8C\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x4C"],

        ["\x38\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xCB"],
        ["\x8C\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x4D"],

        ["\x38\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xCC"],
        ["\x8C\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x4E"],

        ["\x38\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xCD"],
        ["\x8C\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x4F"],

        ["\x38\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xCE"],
        ["\x8C\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x50"],

        ["\x38\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xCF"],
        ["\x8C\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x51"],

        ["\x38\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xD0"],
        ["\x8C\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x52"],

        ["\x38\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xD1"],
        ["\x8C\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x53"],

        ["\x38\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xD2"],
        ["\x8C\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x54"],

        ["\x38\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xD3"],
        ["\x8C\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x55"],

        ["\x38\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xD4"],
        ["\x8C\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x56"],

        ["\x38\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xD5"],
        ["\x8C\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x57"],

        ["\x38\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xD6"],
        ["\x8C\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x58"],

        ["\x38\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xD7"],
        ["\x8C\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x59"],

        ["\x38\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xD8"],
        ["\x8C\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x5A"],

        ["\x38\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xD9"],
        ["\x8C\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x5B"],

        ["\x38\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xDA"],
        ["\x8C\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x5C"],

        ["\x38\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xDB"],
        ["\x8C\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x5D"],

        ["\x38\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xDC"],
        ["\x8C\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x5E"],

        ["\x38\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xDD"],
        ["\x8C\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x5F"],

        ["\x38\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xDE"],
        ["\x8C\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x60"],

        ["\x38\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xDF"],
        ["\x8C\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x61"],

        ["\x38\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xE0"],
        ["\x8C\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x62"],

        ["\x38\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xE1"],
        ["\x8C\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x63"],

        ["\x38\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xE2"],
        ["\x8C\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x64"],

        ["\x38\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xE3"],
        ["\x8C\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x65"],

        ["\x38\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xE4"],
        ["\x8C\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x66"],

        ["\x38\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xE5"],
        ["\x8C\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x67"],

        ["\x38\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xE6"],
        ["\x8C\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x68"],

        ["\x38\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xE7"],
        ["\x8C\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x69"],

        ["\x38\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xE8"],
        ["\x8C\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x6A"],

        ["\x38\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xE9"],
        ["\x8C\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x6B"],

        ["\x38\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xEA"],
        ["\x8C\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x6C"],

        ["\x38\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xEB"],
        ["\x8C\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x6D"],

        ["\x38\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xEC"],
        ["\x8C\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x6E"],

        ["\x38\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xED"],
        ["\x8C\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x6F"],

        ["\x38\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xEE"],
        ["\x8C\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x70"],

        ["\x38\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xEF"],
        ["\x8C\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x71"],

        ["\x38\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xF0"],
        ["\x8C\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x72"],

        ["\x38\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xF1"],
        ["\x8C\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x73"],

        ["\x38\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xF2"],
        ["\x8C\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x74"],

        ["\x38\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xF3"],
        ["\x8C\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x75"],

        ["\x38\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xF4"],
        ["\x8C\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x76"],

        ["\x38\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xF5"],
        ["\x8C\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x77"],

        ["\x38\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xF6"],
        ["\x8C\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x78"],

        ["\x38\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xF7"],
        ["\x8C\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x79"],

        ["\x38\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xF8"],
        ["\x8C\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x7A"],

        ["\x38\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xF9"],
        ["\x8C\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x7B"],

        ["\x38\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xFA"],
        ["\x8C\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x7C"],

        ["\x38\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xFB"],
        ["\x8C\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x7D"],

        ["\x38\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8C\xFC"],
        ["\x8C\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x38\x7E"],

        ["\x39\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x40"],
        ["\x8D\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x21"],

        ["\x39\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x41"],
        ["\x8D\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x22"],

        ["\x39\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x42"],
        ["\x8D\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x23"],

        ["\x39\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x43"],
        ["\x8D\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x24"],

        ["\x39\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x44"],
        ["\x8D\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x25"],

        ["\x39\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x45"],
        ["\x8D\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x26"],

        ["\x39\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x46"],
        ["\x8D\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x27"],

        ["\x39\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x47"],
        ["\x8D\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x28"],

        ["\x39\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x48"],
        ["\x8D\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x29"],

        ["\x39\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x49"],
        ["\x8D\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x2A"],

        ["\x39\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x4A"],
        ["\x8D\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x2B"],

        ["\x39\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x4B"],
        ["\x8D\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x2C"],

        ["\x39\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x4C"],
        ["\x8D\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x2D"],

        ["\x39\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x4D"],
        ["\x8D\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x2E"],

        ["\x39\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x4E"],
        ["\x8D\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x2F"],

        ["\x39\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x4F"],
        ["\x8D\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x30"],

        ["\x39\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x50"],
        ["\x8D\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x31"],

        ["\x39\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x51"],
        ["\x8D\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x32"],

        ["\x39\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x52"],
        ["\x8D\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x33"],

        ["\x39\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x53"],
        ["\x8D\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x34"],

        ["\x39\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x54"],
        ["\x8D\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x35"],

        ["\x39\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x55"],
        ["\x8D\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x36"],

        ["\xBD\xB6",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x56"],
        ["\x8D\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBD\xB6"],

        ["\x39\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x57"],
        ["\x8D\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x38"],

        ["\x39\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x58"],
        ["\x8D\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x39"],

        ["\x39\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x59"],
        ["\x8D\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x3A"],

        ["\x39\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x5A"],
        ["\x8D\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x3B"],

        ["\x39\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x5B"],
        ["\x8D\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x3C"],

        ["\x39\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x5C"],
        ["\x8D\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x3D"],

        ["\x39\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x5D"],
        ["\x8D\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x3E"],

        ["\x39\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x5E"],
        ["\x8D\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x3F"],

        ["\x39\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x5F"],
        ["\x8D\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x40"],

        ["\x39\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x60"],
        ["\x8D\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x41"],

        ["\x39\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x61"],
        ["\x8D\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x42"],

        ["\x39\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x62"],
        ["\x8D\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x43"],

        ["\x39\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x63"],
        ["\x8D\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x44"],

        ["\x39\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x64"],
        ["\x8D\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x45"],

        ["\x39\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x65"],
        ["\x8D\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x46"],

        ["\x39\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x66"],
        ["\x8D\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x47"],

        ["\x39\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x67"],
        ["\x8D\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x48"],

        ["\x39\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x68"],
        ["\x8D\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x49"],

        ["\x39\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x69"],
        ["\x8D\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x4A"],

        ["\x39\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x6A"],
        ["\x8D\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x4B"],

        ["\x39\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x6B"],
        ["\x8D\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x4C"],

        ["\x39\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x6C"],
        ["\x8D\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x4D"],

        ["\x39\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x6D"],
        ["\x8D\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x4E"],

        ["\x39\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x6E"],
        ["\x8D\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x4F"],

        ["\x39\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x6F"],
        ["\x8D\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x50"],

        ["\x39\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x70"],
        ["\x8D\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x51"],

        ["\x39\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x71"],
        ["\x8D\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x52"],

        ["\x39\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x72"],
        ["\x8D\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x53"],

        ["\x39\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x73"],
        ["\x8D\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x54"],

        ["\x39\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x74"],
        ["\x8D\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x55"],

        ["\x39\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x75"],
        ["\x8D\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x56"],

        ["\x39\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x76"],
        ["\x8D\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x57"],

        ["\x39\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x77"],
        ["\x8D\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x58"],

        ["\x39\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x78"],
        ["\x8D\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x59"],

        ["\x39\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x79"],
        ["\x8D\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x5A"],

        ["\x39\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x7A"],
        ["\x8D\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x5B"],

        ["\x62\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x7B"],
        ["\x8D\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x68"],

        ["\x39\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x7C"],
        ["\x8D\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x5D"],

        ["\x39\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x7D"],
        ["\x8D\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x5E"],

        ["\x39\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x7E"],
        ["\x8D\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x5F"],

        ["\x39\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x80"],
        ["\x8D\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x60"],

        ["\x39\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x81"],
        ["\x8D\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x61"],

        ["\x39\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x82"],
        ["\x8D\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x62"],

        ["\x39\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x83"],
        ["\x8D\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x63"],

        ["\x39\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x84"],
        ["\x8D\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x64"],

        ["\x39\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x85"],
        ["\x8D\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x65"],

        ["\x39\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x86"],
        ["\x8D\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x66"],

        ["\x39\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x87"],
        ["\x8D\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x67"],

        ["\x39\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x88"],
        ["\x8D\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x68"],

        ["\x39\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x89"],
        ["\x8D\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x69"],

        ["\x39\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x8A"],
        ["\x8D\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x6A"],

        ["\x39\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x8B"],
        ["\x8D\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x6B"],

        ["\x39\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x8C"],
        ["\x8D\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x6C"],

        ["\xD6\xBB",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x8D"],
        ["\x8D\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xBB"],

        ["\x39\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x8E"],
        ["\x8D\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x6E"],

        ["\x39\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x8F"],
        ["\x8D\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x6F"],

        ["\x39\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x90"],
        ["\x8D\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x70"],

        ["\x39\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x91"],
        ["\x8D\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x71"],

        ["\x39\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x92"],
        ["\x8D\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x72"],

        ["\x39\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x93"],
        ["\x8D\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x73"],

        ["\x39\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x94"],
        ["\x8D\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x74"],

        ["\x39\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x95"],
        ["\x8D\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x75"],

        ["\x39\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x96"],
        ["\x8D\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x76"],

        ["\x39\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x97"],
        ["\x8D\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x77"],

        ["\x39\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x98"],
        ["\x8D\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x78"],

        ["\x39\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x99"],
        ["\x8D\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x79"],

        ["\x39\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x9A"],
        ["\x8D\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x7A"],

        ["\x39\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x9B"],
        ["\x8D\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x7B"],

        ["\x39\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x9C"],
        ["\x8D\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x7C"],

        ["\x39\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x9D"],
        ["\x8D\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x7D"],

        ["\x39\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x9E"],
        ["\x8D\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x7E"],

        ["\x3A\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\x9F"],
        ["\x8D\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x21"],

        ["\x3A\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xA0"],
        ["\x8D\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x22"],

        ["\x3A\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xA1"],
        ["\x8D\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x23"],

        ["\x3A\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xA2"],
        ["\x8D\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x24"],

        ["\x3A\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xA3"],
        ["\x8D\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x25"],

        ["\x3A\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xA4"],
        ["\x8D\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x26"],

        ["\x3A\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xA5"],
        ["\x8D\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x27"],

        ["\x3A\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xA6"],
        ["\x8D\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x28"],

        ["\x3A\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xA7"],
        ["\x8D\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x29"],

        ["\x3A\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xA8"],
        ["\x8D\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x2A"],

        ["\x3A\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xA9"],
        ["\x8D\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x2B"],

        ["\x3A\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xAA"],
        ["\x8D\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x2C"],

        ["\x3A\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xAB"],
        ["\x8D\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x2D"],

        ["\x3A\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xAC"],
        ["\x8D\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x2E"],

        ["\x3A\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xAD"],
        ["\x8D\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x2F"],

        ["\x3A\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xAE"],
        ["\x8D\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x30"],

        ["\x3A\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xAF"],
        ["\x8D\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x31"],

        ["\x3A\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xB0"],
        ["\x8D\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x32"],

        ["\x3A\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xB1"],
        ["\x8D\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x33"],

        ["\x3A\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xB2"],
        ["\x8D\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x34"],

        ["\x3A\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xB3"],
        ["\x8D\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x35"],

        ["\x3A\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xB4"],
        ["\x8D\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x36"],

        ["\x3A\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xB5"],
        ["\x8D\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x37"],

        ["\x3A\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xB6"],
        ["\x8D\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x38"],

        ["\x3A\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xB7"],
        ["\x8D\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x39"],

        ["\x3A\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xB8"],
        ["\x8D\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x3A"],

        ["\x3A\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xB9"],
        ["\x8D\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x3B"],

        ["\x3A\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xBA"],
        ["\x8D\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x3C"],

        ["\x3A\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xBB"],
        ["\x8D\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x3D"],

        ["\x3A\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xBC"],
        ["\x8D\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x3E"],

        ["\x3A\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xBD"],
        ["\x8D\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x3F"],

        ["\x3A\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xBE"],
        ["\x8D\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x40"],

        ["\x3A\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xBF"],
        ["\x8D\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x41"],

        ["\x3A\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xC0"],
        ["\x8D\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x42"],

        ["\x3A\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xC1"],
        ["\x8D\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x43"],

        ["\x3A\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xC2"],
        ["\x8D\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x44"],

        ["\x3A\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xC3"],
        ["\x8D\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x45"],

        ["\x3A\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xC4"],
        ["\x8D\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x46"],

        ["\x3A\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xC5"],
        ["\x8D\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x47"],

        ["\x3A\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xC6"],
        ["\x8D\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x48"],

        ["\x3A\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xC7"],
        ["\x8D\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x49"],

        ["\x3A\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xC8"],
        ["\x8D\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x4A"],

        ["\x3A\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xC9"],
        ["\x8D\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x4B"],

        ["\x3A\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xCA"],
        ["\x8D\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x4C"],

        ["\x3A\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xCB"],
        ["\x8D\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x4D"],

        ["\x3A\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xCC"],
        ["\x8D\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x4E"],

        ["\x3A\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xCD"],
        ["\x8D\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x4F"],

        ["\x3A\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xCE"],
        ["\x8D\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x50"],

        ["\x3A\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xCF"],
        ["\x8D\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x51"],

        ["\x3A\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xD0"],
        ["\x8D\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x52"],

        ["\x3A\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xD1"],
        ["\x8D\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x53"],

        ["\x3A\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xD2"],
        ["\x8D\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x54"],

        ["\x3A\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xD3"],
        ["\x8D\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x55"],

        ["\x3A\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xD4"],
        ["\x8D\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x56"],

        ["\x3A\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xD5"],
        ["\x8D\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x57"],

        ["\x3A\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xD6"],
        ["\x8D\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x58"],

        ["\x3A\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xD7"],
        ["\x8D\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x59"],

        ["\x3A\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xD8"],
        ["\x8D\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x5A"],

        ["\x3A\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xD9"],
        ["\x8D\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x5B"],

        ["\x3A\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xDA"],
        ["\x8D\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x5C"],

        ["\x3A\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xDB"],
        ["\x8D\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x5D"],

        ["\x3A\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xDC"],
        ["\x8D\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x5E"],

        ["\x3A\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xDD"],
        ["\x8D\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x5F"],

        ["\x3A\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xDE"],
        ["\x8D\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x60"],

        ["\x3A\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xDF"],
        ["\x8D\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x61"],

        ["\x3A\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xE0"],
        ["\x8D\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x62"],

        ["\x3A\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xE1"],
        ["\x8D\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x63"],

        ["\x3A\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xE2"],
        ["\x8D\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x64"],

        ["\x3A\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xE3"],
        ["\x8D\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x65"],

        ["\x3A\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xE4"],
        ["\x8D\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x66"],

        ["\x3A\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xE5"],
        ["\x8D\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x67"],

        ["\x3A\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xE6"],
        ["\x8D\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x68"],

        ["\x3A\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xE7"],
        ["\x8D\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x69"],

        ["\x3A\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xE8"],
        ["\x8D\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x6A"],

        ["\x3A\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xE9"],
        ["\x8D\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x6B"],

        ["\x3A\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xEA"],
        ["\x8D\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x6C"],

        ["\x3A\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xEB"],
        ["\x8D\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x6D"],

        ["\x3A\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xEC"],
        ["\x8D\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x6E"],

        ["\x3A\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xED"],
        ["\x8D\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x6F"],

        ["\x3A\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xEE"],
        ["\x8D\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x70"],

        ["\x3A\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xEF"],
        ["\x8D\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x71"],

        ["\x3A\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xF0"],
        ["\x8D\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x72"],

        ["\x3A\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xF1"],
        ["\x8D\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x73"],

        ["\x3A\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xF2"],
        ["\x8D\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x74"],

        ["\x3A\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xF3"],
        ["\x8D\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x75"],

        ["\x3A\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xF4"],
        ["\x8D\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x76"],

        ["\x3A\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xF5"],
        ["\x8D\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x77"],

        ["\x3A\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xF6"],
        ["\x8D\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x78"],

        ["\x3A\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xF7"],
        ["\x8D\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x79"],

        ["\x3A\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xF8"],
        ["\x8D\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x7A"],

        ["\x3A\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xF9"],
        ["\x8D\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x7B"],

        ["\x3A\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xFA"],
        ["\x8D\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x7C"],

        ["\x3A\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xFB"],
        ["\x8D\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x7D"],

        ["\x3A\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8D\xFC"],
        ["\x8D\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3A\x7E"],

        ["\x3B\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x40"],
        ["\x8E\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x21"],

        ["\x3B\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x41"],
        ["\x8E\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x22"],

        ["\x3B\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x42"],
        ["\x8E\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x23"],

        ["\x3B\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x43"],
        ["\x8E\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x24"],

        ["\x3B\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x44"],
        ["\x8E\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x25"],

        ["\x3B\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x45"],
        ["\x8E\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x26"],

        ["\x3B\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x46"],
        ["\x8E\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x27"],

        ["\x3B\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x47"],
        ["\x8E\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x28"],

        ["\x3B\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x48"],
        ["\x8E\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x29"],

        ["\x3B\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x49"],
        ["\x8E\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x2A"],

        ["\x3B\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x4A"],
        ["\x8E\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x2B"],

        ["\x3B\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x4B"],
        ["\x8E\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x2C"],

        ["\x3B\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x4C"],
        ["\x8E\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x2D"],

        ["\x3B\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x4D"],
        ["\x8E\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x2E"],

        ["\x3B\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x4E"],
        ["\x8E\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x2F"],

        ["\x3B\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x4F"],
        ["\x8E\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x30"],

        ["\x3B\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x50"],
        ["\x8E\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x31"],

        ["\x3B\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x51"],
        ["\x8E\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x32"],

        ["\x3B\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x52"],
        ["\x8E\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x33"],

        ["\x3B\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x53"],
        ["\x8E\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x34"],

        ["\x3B\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x54"],
        ["\x8E\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x35"],

        ["\x3B\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x55"],
        ["\x8E\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x36"],

        ["\x3B\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x56"],
        ["\x8E\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x37"],

        ["\x3B\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x57"],
        ["\x8E\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x38"],

        ["\x3B\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x58"],
        ["\x8E\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x39"],

        ["\x3B\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x59"],
        ["\x8E\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x3A"],

        ["\x3B\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x5A"],
        ["\x8E\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x3B"],

        ["\x3B\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x5B"],
        ["\x8E\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x3C"],

        ["\x3B\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x5C"],
        ["\x8E\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x3D"],

        ["\x3B\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x5D"],
        ["\x8E\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x3E"],

        ["\x3B\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x5E"],
        ["\x8E\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x3F"],

        ["\x3B\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x5F"],
        ["\x8E\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x40"],

        ["\x3B\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x60"],
        ["\x8E\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x41"],

        ["\x3B\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x61"],
        ["\x8E\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x42"],

        ["\x3B\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x62"],
        ["\x8E\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x43"],

        ["\x3B\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x63"],
        ["\x8E\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x44"],

        ["\x3B\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x64"],
        ["\x8E\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x45"],

        ["\x3B\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x65"],
        ["\x8E\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x46"],

        ["\x3B\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x66"],
        ["\x8E\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x47"],

        ["\x3B\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x67"],
        ["\x8E\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x48"],

        ["\x3B\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x68"],
        ["\x8E\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x49"],

        ["\x3B\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x69"],
        ["\x8E\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x4A"],

        ["\x3B\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x6A"],
        ["\x8E\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x4B"],

        ["\x3B\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x6B"],
        ["\x8E\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x4C"],

        ["\x3B\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x6C"],
        ["\x8E\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x4D"],

        ["\x3B\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x6D"],
        ["\x8E\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x4E"],

        ["\x3B\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x6E"],
        ["\x8E\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x4F"],

        ["\x3B\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x6F"],
        ["\x8E\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x50"],

        ["\x3B\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x70"],
        ["\x8E\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x51"],

        ["\x3B\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x71"],
        ["\x8E\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x52"],

        ["\x3B\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x72"],
        ["\x8E\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x53"],

        ["\x3B\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x73"],
        ["\x8E\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x54"],

        ["\x3B\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x74"],
        ["\x8E\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x55"],

        ["\x3B\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x75"],
        ["\x8E\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x56"],

        ["\x3B\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x76"],
        ["\x8E\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x57"],

        ["\x3B\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x77"],
        ["\x8E\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x58"],

        ["\x3B\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x78"],
        ["\x8E\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x59"],

        ["\x3B\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x79"],
        ["\x8E\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x5A"],

        ["\x3B\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x7A"],
        ["\x8E\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x5B"],

        ["\x3B\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x7B"],
        ["\x8E\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x5C"],

        ["\x3B\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x7C"],
        ["\x8E\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x5D"],

        ["\x3B\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x7D"],
        ["\x8E\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x5E"],

        ["\x3B\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x7E"],
        ["\x8E\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x5F"],

        ["\x3B\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x80"],
        ["\x8E\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x60"],

        ["\x3B\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x81"],
        ["\x8E\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x61"],

        ["\x3B\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x82"],
        ["\x8E\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x62"],

        ["\x3B\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x83"],
        ["\x8E\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x63"],

        ["\x3B\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x84"],
        ["\x8E\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x64"],

        ["\x3B\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x85"],
        ["\x8E\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x65"],

        ["\x3B\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x86"],
        ["\x8E\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x66"],

        ["\x3B\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x87"],
        ["\x8E\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x67"],

        ["\x3B\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x88"],
        ["\x8E\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x68"],

        ["\x3B\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x89"],
        ["\x8E\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x69"],

        ["\x3B\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x8A"],
        ["\x8E\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x6A"],

        ["\x3B\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x8B"],
        ["\x8E\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x6B"],

        ["\x3B\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x8C"],
        ["\x8E\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x6C"],

        ["\x3B\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x8D"],
        ["\x8E\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x6D"],

        ["\x3B\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x8E"],
        ["\x8E\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x6E"],

        ["\x3B\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x8F"],
        ["\x8E\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x6F"],

        ["\x3B\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x90"],
        ["\x8E\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x70"],

        ["\x3B\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x91"],
        ["\x8E\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x71"],

        ["\x3B\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x92"],
        ["\x8E\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x72"],

        ["\x3B\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x93"],
        ["\x8E\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x73"],

        ["\x3B\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x94"],
        ["\x8E\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x74"],

        ["\x3B\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x95"],
        ["\x8E\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x75"],

        ["\x3B\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x96"],
        ["\x8E\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x76"],

        ["\x3B\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x97"],
        ["\x8E\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x77"],

        ["\x3B\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x98"],
        ["\x8E\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x78"],

        ["\x3B\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x99"],
        ["\x8E\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x79"],

        ["\x3B\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x9A"],
        ["\x8E\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x7A"],

        ["\x3B\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x9B"],
        ["\x8E\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x7B"],

        ["\x3B\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x9C"],
        ["\x8E\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x7C"],

        ["\x3B\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x9D"],
        ["\x8E\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x7D"],

        ["\x3B\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x9E"],
        ["\x8E\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3B\x7E"],

        ["\x3C\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\x9F"],
        ["\x8E\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x21"],

        ["\x3C\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xA0"],
        ["\x8E\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x22"],

        ["\x3C\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xA1"],
        ["\x8E\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x23"],

        ["\x3C\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xA2"],
        ["\x8E\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x24"],

        ["\x3C\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xA3"],
        ["\x8E\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x25"],

        ["\x3C\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xA4"],
        ["\x8E\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x26"],

        ["\x3C\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xA5"],
        ["\x8E\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x27"],

        ["\x3C\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xA6"],
        ["\x8E\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x28"],

        ["\x3C\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xA7"],
        ["\x8E\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x29"],

        ["\x3C\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xA8"],
        ["\x8E\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x2A"],

        ["\x3C\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xA9"],
        ["\x8E\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x2B"],

        ["\x3C\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xAA"],
        ["\x8E\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x2C"],

        ["\x3C\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xAB"],
        ["\x8E\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x2D"],

        ["\x3C\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xAC"],
        ["\x8E\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x2E"],

        ["\x3C\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xAD"],
        ["\x8E\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x2F"],

        ["\x3C\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xAE"],
        ["\x8E\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x30"],

        ["\x3C\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xAF"],
        ["\x8E\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x31"],

        ["\x3C\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xB0"],
        ["\x8E\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x32"],

        ["\x3C\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xB1"],
        ["\x8E\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x33"],

        ["\x3C\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xB2"],
        ["\x8E\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x34"],

        ["\x3C\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xB3"],
        ["\x8E\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x35"],

        ["\x3C\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xB4"],
        ["\x8E\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x36"],

        ["\x3C\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xB5"],
        ["\x8E\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x37"],

        ["\x3C\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xB6"],
        ["\x8E\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x38"],

        ["\x3C\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xB7"],
        ["\x8E\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x39"],

        ["\x3C\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xB8"],
        ["\x8E\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x3A"],

        ["\x3C\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xB9"],
        ["\x8E\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x3B"],

        ["\x3C\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xBA"],
        ["\x8E\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x3C"],

        ["\x3C\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xBB"],
        ["\x8E\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x3D"],

        ["\x3C\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xBC"],
        ["\x8E\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x3E"],

        ["\x3C\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xBD"],
        ["\x8E\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x3F"],

        ["\x3C\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xBE"],
        ["\x8E\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x40"],

        ["\x3C\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xBF"],
        ["\x8E\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x41"],

        ["\x3C\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xC0"],
        ["\x8E\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x42"],

        ["\x3C\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xC1"],
        ["\x8E\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x43"],

        ["\x3C\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xC2"],
        ["\x8E\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x44"],

        ["\x3C\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xC3"],
        ["\x8E\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x45"],

        ["\x3C\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xC4"],
        ["\x8E\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x46"],

        ["\x3C\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xC5"],
        ["\x8E\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x47"],

        ["\x3C\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xC6"],
        ["\x8E\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x48"],

        ["\x69\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xC7"],
        ["\x8E\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x22"],

        ["\x3C\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xC8"],
        ["\x8E\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x4A"],

        ["\x3C\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xC9"],
        ["\x8E\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x4B"],

        ["\x3C\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xCA"],
        ["\x8E\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x4C"],

        ["\x3C\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xCB"],
        ["\x8E\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x4D"],

        ["\x3C\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xCC"],
        ["\x8E\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x4E"],

        ["\x3C\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xCD"],
        ["\x8E\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x4F"],

        ["\x3C\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xCE"],
        ["\x8E\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x50"],

        ["\x3C\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xCF"],
        ["\x8E\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x51"],

        ["\x3C\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xD0"],
        ["\x8E\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x52"],

        ["\x3C\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xD1"],
        ["\x8E\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x53"],

        ["\x3C\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xD2"],
        ["\x8E\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x54"],

        ["\x3C\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xD3"],
        ["\x8E\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x55"],

        ["\x3C\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xD4"],
        ["\x8E\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x56"],

        ["\x3C\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xD5"],
        ["\x8E\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x57"],

        ["\x3C\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xD6"],
        ["\x8E\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x58"],

        ["\x3C\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xD7"],
        ["\x8E\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x59"],

        ["\x3C\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xD8"],
        ["\x8E\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x5A"],

        ["\x3C\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xD9"],
        ["\x8E\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x5B"],

        ["\x3C\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xDA"],
        ["\x8E\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x5C"],

        ["\x3C\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xDB"],
        ["\x8E\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x5D"],

        ["\x3C\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xDC"],
        ["\x8E\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x5E"],

        ["\x3C\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xDD"],
        ["\x8E\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x5F"],

        ["\x3C\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xDE"],
        ["\x8E\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x60"],

        ["\x3C\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xDF"],
        ["\x8E\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x61"],

        ["\x3C\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xE0"],
        ["\x8E\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x62"],

        ["\x3C\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xE1"],
        ["\x8E\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x63"],

        ["\x3C\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xE2"],
        ["\x8E\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x64"],

        ["\x3C\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xE3"],
        ["\x8E\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x65"],

        ["\x3C\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xE4"],
        ["\x8E\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x66"],

        ["\x3C\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xE5"],
        ["\x8E\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x67"],

        ["\x3C\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xE6"],
        ["\x8E\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x68"],

        ["\x3C\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xE7"],
        ["\x8E\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x69"],

        ["\x3C\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xE8"],
        ["\x8E\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x6A"],

        ["\x3C\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xE9"],
        ["\x8E\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x6B"],

        ["\x3C\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xEA"],
        ["\x8E\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x6C"],

        ["\x3C\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xEB"],
        ["\x8E\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x6D"],

        ["\x3C\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xEC"],
        ["\x8E\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x6E"],

        ["\x3C\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xED"],
        ["\x8E\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x6F"],

        ["\x3C\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xEE"],
        ["\x8E\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x70"],

        ["\x3C\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xEF"],
        ["\x8E\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x71"],

        ["\x3C\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xF0"],
        ["\x8E\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x72"],

        ["\x3C\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xF1"],
        ["\x8E\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x73"],

        ["\x3C\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xF2"],
        ["\x8E\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x74"],

        ["\x3C\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xF3"],
        ["\x8E\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x75"],

        ["\x3C\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xF4"],
        ["\x8E\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x76"],

        ["\x3C\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xF5"],
        ["\x8E\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x77"],

        ["\x3C\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xF6"],
        ["\x8E\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x78"],

        ["\x3C\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xF7"],
        ["\x8E\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x79"],

        ["\x3C\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xF8"],
        ["\x8E\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x7A"],

        ["\x3C\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xF9"],
        ["\x8E\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x7B"],

        ["\x3C\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xFA"],
        ["\x8E\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x7C"],

        ["\x3C\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xFB"],
        ["\x8E\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x7D"],

        ["\x3C\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8E\xFC"],
        ["\x8E\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x7E"],

        ["\x3D\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x40"],
        ["\x8F\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x21"],

        ["\x3D\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x41"],
        ["\x8F\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x22"],

        ["\x3D\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x42"],
        ["\x8F\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x23"],

        ["\x3D\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x43"],
        ["\x8F\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x24"],

        ["\x3D\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x44"],
        ["\x8F\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x25"],

        ["\x3D\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x45"],
        ["\x8F\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x26"],

        ["\x3D\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x46"],
        ["\x8F\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x27"],

        ["\x3D\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x47"],
        ["\x8F\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x28"],

        ["\x3D\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x48"],
        ["\x8F\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x29"],

        ["\x3D\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x49"],
        ["\x8F\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x2A"],

        ["\x3D\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x4A"],
        ["\x8F\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x2B"],

        ["\x3D\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x4B"],
        ["\x8F\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x2C"],

        ["\x3D\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x4C"],
        ["\x8F\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x2D"],

        ["\x3D\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x4D"],
        ["\x8F\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x2E"],

        ["\x3D\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x4E"],
        ["\x8F\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x2F"],

        ["\x3D\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x4F"],
        ["\x8F\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x30"],

        ["\x3D\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x50"],
        ["\x8F\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x31"],

        ["\x3D\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x51"],
        ["\x8F\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x32"],

        ["\x3D\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x52"],
        ["\x8F\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x33"],

        ["\x3D\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x53"],
        ["\x8F\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x34"],

        ["\x3D\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x54"],
        ["\x8F\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x35"],

        ["\x3D\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x55"],
        ["\x8F\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x36"],

        ["\x3D\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x56"],
        ["\x8F\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x37"],

        ["\x3D\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x57"],
        ["\x8F\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x38"],

        ["\x3D\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x58"],
        ["\x8F\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x39"],

        ["\x3D\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x59"],
        ["\x8F\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x3A"],

        ["\x3D\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x5A"],
        ["\x8F\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x3B"],

        ["\x3D\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x5B"],
        ["\x8F\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x3C"],

        ["\x3D\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x5C"],
        ["\x8F\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x3D"],

        ["\x3D\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x5D"],
        ["\x8F\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x3E"],

        ["\x3D\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x5E"],
        ["\x8F\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x3F"],

        ["\x3D\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x5F"],
        ["\x8F\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x40"],

        ["\x3D\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x60"],
        ["\x8F\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x41"],

        ["\x3D\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x61"],
        ["\x8F\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x42"],

        ["\x3D\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x62"],
        ["\x8F\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x43"],

        ["\x3D\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x63"],
        ["\x8F\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x44"],

        ["\x3D\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x64"],
        ["\x8F\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x45"],

        ["\x3D\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x65"],
        ["\x8F\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x46"],

        ["\x3D\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x66"],
        ["\x8F\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x47"],

        ["\x3D\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x67"],
        ["\x8F\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x48"],

        ["\x3D\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x68"],
        ["\x8F\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x49"],

        ["\x3D\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x69"],
        ["\x8F\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x4A"],

        ["\x3D\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x6A"],
        ["\x8F\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x4B"],

        ["\x3D\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x6B"],
        ["\x8F\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x4C"],

        ["\x3D\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x6C"],
        ["\x8F\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x4D"],

        ["\x3D\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x6D"],
        ["\x8F\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x4E"],

        ["\x3D\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x6E"],
        ["\x8F\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x4F"],

        ["\x3D\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x6F"],
        ["\x8F\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x50"],

        ["\x3D\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x70"],
        ["\x8F\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x51"],

        ["\x3D\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x71"],
        ["\x8F\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x52"],

        ["\x3D\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x72"],
        ["\x8F\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x53"],

        ["\x3D\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x73"],
        ["\x8F\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x54"],

        ["\x3D\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x74"],
        ["\x8F\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x55"],

        ["\x3D\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x75"],
        ["\x8F\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x56"],

        ["\x3D\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x76"],
        ["\x8F\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x57"],

        ["\x3D\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x77"],
        ["\x8F\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x58"],

        ["\x3D\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x78"],
        ["\x8F\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x59"],

        ["\x3D\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x79"],
        ["\x8F\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x5A"],

        ["\x3D\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x7A"],
        ["\x8F\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x5B"],

        ["\x3D\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x7B"],
        ["\x8F\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x5C"],

        ["\x3D\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x7C"],
        ["\x8F\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x5D"],

        ["\x3D\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x7D"],
        ["\x8F\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x5E"],

        ["\x3D\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x7E"],
        ["\x8F\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x5F"],

        ["\x3D\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x80"],
        ["\x8F\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x60"],

        ["\x3D\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x81"],
        ["\x8F\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x61"],

        ["\x3D\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x82"],
        ["\x8F\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x62"],

        ["\x3D\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x83"],
        ["\x8F\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x63"],

        ["\x3D\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x84"],
        ["\x8F\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x64"],

        ["\x3D\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x85"],
        ["\x8F\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x65"],

        ["\x3D\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x86"],
        ["\x8F\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x66"],

        ["\x3D\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x87"],
        ["\x8F\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x67"],

        ["\x3D\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x88"],
        ["\x8F\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x68"],

        ["\x3D\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x89"],
        ["\x8F\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x69"],

        ["\x3D\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x8A"],
        ["\x8F\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x6A"],

        ["\x3D\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x8B"],
        ["\x8F\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x6B"],

        ["\x3D\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x8C"],
        ["\x8F\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x6C"],

        ["\x3D\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x8D"],
        ["\x8F\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x6D"],

        ["\x3D\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x8E"],
        ["\x8F\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x6E"],

        ["\x3D\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x8F"],
        ["\x8F\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x6F"],

        ["\x3D\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x90"],
        ["\x8F\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x70"],

        ["\x3D\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x91"],
        ["\x8F\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x71"],

        ["\x3D\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x92"],
        ["\x8F\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x72"],

        ["\x3D\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x93"],
        ["\x8F\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x73"],

        ["\x3D\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x94"],
        ["\x8F\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x74"],

        ["\x3D\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x95"],
        ["\x8F\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x75"],

        ["\x3D\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x96"],
        ["\x8F\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x76"],

        ["\x3D\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x97"],
        ["\x8F\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x77"],

        ["\x3D\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x98"],
        ["\x8F\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x78"],

        ["\x3D\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x99"],
        ["\x8F\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x79"],

        ["\x3D\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x9A"],
        ["\x8F\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x7A"],

        ["\x3D\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x9B"],
        ["\x8F\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x7B"],

        ["\x3D\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x9C"],
        ["\x8F\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x7C"],

        ["\x3D\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x9D"],
        ["\x8F\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x7D"],

        ["\x3D\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x9E"],
        ["\x8F\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3D\x7E"],

        ["\x3E\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\x9F"],
        ["\x8F\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x21"],

        ["\x3E\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xA0"],
        ["\x8F\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x22"],

        ["\x3E\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xA1"],
        ["\x8F\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x23"],

        ["\x3E\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xA2"],
        ["\x8F\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x24"],

        ["\x3E\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xA3"],
        ["\x8F\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x25"],

        ["\x3E\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xA4"],
        ["\x8F\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x26"],

        ["\x3E\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xA5"],
        ["\x8F\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x27"],

        ["\x3E\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xA6"],
        ["\x8F\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x28"],

        ["\x3E\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xA7"],
        ["\x8F\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x29"],

        ["\x3E\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xA8"],
        ["\x8F\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x2A"],

        ["\x3E\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xA9"],
        ["\x8F\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x2B"],

        ["\x3E\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xAA"],
        ["\x8F\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x2C"],

        ["\x3E\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xAB"],
        ["\x8F\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x2D"],

        ["\x3E\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xAC"],
        ["\x8F\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x2E"],

        ["\x3E\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xAD"],
        ["\x8F\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x2F"],

        ["\x3E\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xAE"],
        ["\x8F\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x30"],

        ["\x3E\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xAF"],
        ["\x8F\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x31"],

        ["\x3E\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xB0"],
        ["\x8F\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x32"],

        ["\x3E\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xB1"],
        ["\x8F\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x33"],

        ["\x3E\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xB2"],
        ["\x8F\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x34"],

        ["\x3E\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xB3"],
        ["\x8F\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x35"],

        ["\x3E\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xB4"],
        ["\x8F\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x36"],

        ["\x3E\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xB5"],
        ["\x8F\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x37"],

        ["\x3E\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xB6"],
        ["\x8F\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x38"],

        ["\x3E\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xB7"],
        ["\x8F\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x39"],

        ["\x3E\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xB8"],
        ["\x8F\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x3A"],

        ["\x3E\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xB9"],
        ["\x8F\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x3B"],

        ["\x3E\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xBA"],
        ["\x8F\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x3C"],

        ["\x3E\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xBB"],
        ["\x8F\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x3D"],

        ["\x3E\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xBC"],
        ["\x8F\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x3E"],

        ["\x3E\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xBD"],
        ["\x8F\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x3F"],

        ["\x3E\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xBE"],
        ["\x8F\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x40"],

        ["\x3E\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xBF"],
        ["\x8F\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x41"],

        ["\x3E\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xC0"],
        ["\x8F\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x42"],

        ["\x3E\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xC1"],
        ["\x8F\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x43"],

        ["\x3E\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xC2"],
        ["\x8F\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x44"],

        ["\x3E\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xC3"],
        ["\x8F\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x45"],

        ["\x3E\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xC4"],
        ["\x8F\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x46"],

        ["\x3E\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xC5"],
        ["\x8F\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x47"],

        ["\x3E\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xC6"],
        ["\x8F\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x48"],

        ["\x3E\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xC7"],
        ["\x8F\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x49"],

        ["\x3E\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xC8"],
        ["\x8F\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x4A"],

        ["\x3E\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xC9"],
        ["\x8F\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x4B"],

        ["\x3E\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xCA"],
        ["\x8F\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x4C"],

        ["\x3E\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xCB"],
        ["\x8F\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x4D"],

        ["\x3E\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xCC"],
        ["\x8F\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x4E"],

        ["\x3E\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xCD"],
        ["\x8F\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x4F"],

        ["\x3E\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xCE"],
        ["\x8F\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x50"],

        ["\x3E\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xCF"],
        ["\x8F\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x51"],

        ["\x3E\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xD0"],
        ["\x8F\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x52"],

        ["\x3E\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xD1"],
        ["\x8F\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x53"],

        ["\x3E\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xD2"],
        ["\x8F\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x54"],

        ["\x3E\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xD3"],
        ["\x8F\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x55"],

        ["\x3E\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xD4"],
        ["\x8F\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x56"],

        ["\x3E\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xD5"],
        ["\x8F\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x57"],

        ["\x3E\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xD6"],
        ["\x8F\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x58"],

        ["\x3E\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xD7"],
        ["\x8F\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x59"],

        ["\x3E\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xD8"],
        ["\x8F\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x5A"],

        ["\x3E\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xD9"],
        ["\x8F\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x5B"],

        ["\x3E\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xDA"],
        ["\x8F\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x5C"],

        ["\x3E\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xDB"],
        ["\x8F\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x5D"],

        ["\x3E\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xDC"],
        ["\x8F\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x5E"],

        ["\x3E\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xDD"],
        ["\x8F\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x5F"],

        ["\x3E\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xDE"],
        ["\x8F\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x60"],

        ["\x3E\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xDF"],
        ["\x8F\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x61"],

        ["\x3E\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xE0"],
        ["\x8F\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x62"],

        ["\x3E\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xE1"],
        ["\x8F\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x63"],

        ["\x3E\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xE2"],
        ["\x8F\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x64"],

        ["\x3E\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xE3"],
        ["\x8F\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x65"],

        ["\x3E\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xE4"],
        ["\x8F\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x66"],

        ["\x3E\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xE5"],
        ["\x8F\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x67"],

        ["\x3E\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xE6"],
        ["\x8F\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x68"],

        ["\x3E\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xE7"],
        ["\x8F\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x69"],

        ["\x3E\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xE8"],
        ["\x8F\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x6A"],

        ["\x3E\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xE9"],
        ["\x8F\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x6B"],

        ["\x3E\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xEA"],
        ["\x8F\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x6C"],

        ["\x3E\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xEB"],
        ["\x8F\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x6D"],

        ["\x3E\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xEC"],
        ["\x8F\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x6E"],

        ["\x3E\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xED"],
        ["\x8F\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x6F"],

        ["\x3E\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xEE"],
        ["\x8F\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x70"],

        ["\x3E\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xEF"],
        ["\x8F\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x71"],

        ["\x3E\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xF0"],
        ["\x8F\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x72"],

        ["\x3E\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xF1"],
        ["\x8F\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x73"],

        ["\x3E\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xF2"],
        ["\x8F\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x74"],

        ["\x3E\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xF3"],
        ["\x8F\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x75"],

        ["\x3E\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xF4"],
        ["\x8F\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x76"],

        ["\x3E\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xF5"],
        ["\x8F\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x77"],

        ["\x3E\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xF6"],
        ["\x8F\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x78"],

        ["\x3E\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xF7"],
        ["\x8F\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x79"],

        ["\x3E\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xF8"],
        ["\x8F\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x7A"],

        ["\x3E\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xF9"],
        ["\x8F\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x7B"],

        ["\x3E\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xFA"],
        ["\x8F\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x7C"],

        ["\x3E\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xFB"],
        ["\x8F\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x7D"],

        ["\x3E\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x8F\xFC"],
        ["\x8F\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3E\x7E"],

        ["\x3F\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x40"],
        ["\x90\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x21"],

        ["\x3F\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x41"],
        ["\x90\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x22"],

        ["\x3F\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x42"],
        ["\x90\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x23"],

        ["\x3F\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x43"],
        ["\x90\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x24"],

        ["\x3F\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x44"],
        ["\x90\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x25"],

        ["\x3F\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x45"],
        ["\x90\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x26"],

        ["\x3F\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x46"],
        ["\x90\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x27"],

        ["\x3F\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x47"],
        ["\x90\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x28"],

        ["\x3F\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x48"],
        ["\x90\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x29"],

        ["\x3F\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x49"],
        ["\x90\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x2A"],

        ["\x3F\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x4A"],
        ["\x90\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x2B"],

        ["\x3F\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x4B"],
        ["\x90\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x2C"],

        ["\x3F\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x4C"],
        ["\x90\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x2D"],

        ["\x3F\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x4D"],
        ["\x90\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x2E"],

        ["\x3F\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x4E"],
        ["\x90\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x2F"],

        ["\x3F\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x4F"],
        ["\x90\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x30"],

        ["\x3F\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x50"],
        ["\x90\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x31"],

        ["\x3F\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x51"],
        ["\x90\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x32"],

        ["\x3F\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x52"],
        ["\x90\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x33"],

        ["\x3F\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x53"],
        ["\x90\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x34"],

        ["\x3F\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x54"],
        ["\x90\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x35"],

        ["\x3F\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x55"],
        ["\x90\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x36"],

        ["\x3F\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x56"],
        ["\x90\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x37"],

        ["\x3F\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x57"],
        ["\x90\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x38"],

        ["\x3F\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x58"],
        ["\x90\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x39"],

        ["\x3F\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x59"],
        ["\x90\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x3A"],

        ["\x3F\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x5A"],
        ["\x90\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x3B"],

        ["\x3F\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x5B"],
        ["\x90\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x3C"],

        ["\x3F\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x5C"],
        ["\x90\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x3D"],

        ["\x3F\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x5D"],
        ["\x90\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x3E"],

        ["\x3F\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x5E"],
        ["\x90\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x3F"],

        ["\x3F\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x5F"],
        ["\x90\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x40"],

        ["\x3F\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x60"],
        ["\x90\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x41"],

        ["\x3F\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x61"],
        ["\x90\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x42"],

        ["\x3F\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x62"],
        ["\x90\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x43"],

        ["\x3F\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x63"],
        ["\x90\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x44"],

        ["\x3F\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x64"],
        ["\x90\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x45"],

        ["\x3F\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x65"],
        ["\x90\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x46"],

        ["\x3F\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x66"],
        ["\x90\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x47"],

        ["\x3F\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x67"],
        ["\x90\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x48"],

        ["\x3F\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x68"],
        ["\x90\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x49"],

        ["\x3F\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x69"],
        ["\x90\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x4A"],

        ["\x3F\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x6A"],
        ["\x90\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x4B"],

        ["\x3F\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x6B"],
        ["\x90\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x4C"],

        ["\x3F\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x6C"],
        ["\x90\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x4D"],

        ["\x3F\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x6D"],
        ["\x90\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x4E"],

        ["\x3F\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x6E"],
        ["\x90\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x4F"],

        ["\x3F\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x6F"],
        ["\x90\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x50"],

        ["\x3F\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x70"],
        ["\x90\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x51"],

        ["\x3F\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x71"],
        ["\x90\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x52"],

        ["\x3F\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x72"],
        ["\x90\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x53"],

        ["\x3F\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x73"],
        ["\x90\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x54"],

        ["\x3F\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x74"],
        ["\x90\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x55"],

        ["\x3F\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x75"],
        ["\x90\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x56"],

        ["\x3F\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x76"],
        ["\x90\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x57"],

        ["\x3F\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x77"],
        ["\x90\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x58"],

        ["\x70\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x78"],
        ["\x90\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x57"],

        ["\x3F\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x79"],
        ["\x90\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x5A"],

        ["\x3F\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x7A"],
        ["\x90\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x5B"],

        ["\x3F\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x7B"],
        ["\x90\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x5C"],

        ["\x3F\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x7C"],
        ["\x90\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x5D"],

        ["\x3F\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x7D"],
        ["\x90\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x5E"],

        ["\x3F\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x7E"],
        ["\x90\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x5F"],

        ["\x3F\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x80"],
        ["\x90\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x60"],

        ["\x3F\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x81"],
        ["\x90\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x61"],

        ["\x3F\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x82"],
        ["\x90\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x62"],

        ["\x3F\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x83"],
        ["\x90\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x63"],

        ["\x3F\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x84"],
        ["\x90\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x64"],

        ["\x3F\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x85"],
        ["\x90\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x65"],

        ["\x3F\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x86"],
        ["\x90\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x66"],

        ["\x3F\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x87"],
        ["\x90\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x67"],

        ["\x3F\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x88"],
        ["\x90\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x68"],

        ["\x3F\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x89"],
        ["\x90\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x69"],

        ["\x3F\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x8A"],
        ["\x90\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x6A"],

        ["\x3F\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x8B"],
        ["\x90\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x6B"],

        ["\x3F\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x8C"],
        ["\x90\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x6C"],

        ["\x3F\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x8D"],
        ["\x90\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x6D"],

        ["\x3F\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x8E"],
        ["\x90\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x6E"],

        ["\x3F\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x8F"],
        ["\x90\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x6F"],

        ["\x3F\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x90"],
        ["\x90\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x70"],

        ["\x3F\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x91"],
        ["\x90\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x71"],

        ["\x3F\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x92"],
        ["\x90\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x72"],

        ["\x3F\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x93"],
        ["\x90\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x73"],

        ["\x3F\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x94"],
        ["\x90\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x74"],

        ["\x3F\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x95"],
        ["\x90\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x75"],

        ["\x3F\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x96"],
        ["\x90\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x76"],

        ["\x3F\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x97"],
        ["\x90\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x77"],

        ["\x3F\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x98"],
        ["\x90\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x78"],

        ["\x3F\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x99"],
        ["\x90\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x79"],

        ["\x3F\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x9A"],
        ["\x90\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x7A"],

        ["\x3F\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x9B"],
        ["\x90\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x7B"],

        ["\x3F\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x9C"],
        ["\x90\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x7C"],

        ["\x3F\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x9D"],
        ["\x90\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x7D"],

        ["\x3F\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x9E"],
        ["\x90\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x7E"],

        ["\x40\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\x9F"],
        ["\x90\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x21"],

        ["\x40\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xA0"],
        ["\x90\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x22"],

        ["\x40\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xA1"],
        ["\x90\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x23"],

        ["\x40\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xA2"],
        ["\x90\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x24"],

        ["\x40\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xA3"],
        ["\x90\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x25"],

        ["\x40\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xA4"],
        ["\x90\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x26"],

        ["\x40\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xA5"],
        ["\x90\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x27"],

        ["\x40\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xA6"],
        ["\x90\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x28"],

        ["\x40\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xA7"],
        ["\x90\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x29"],

        ["\x40\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xA8"],
        ["\x90\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x2A"],

        ["\x40\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xA9"],
        ["\x90\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x2B"],

        ["\x40\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xAA"],
        ["\x90\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x2C"],

        ["\x40\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xAB"],
        ["\x90\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x2D"],

        ["\x40\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xAC"],
        ["\x90\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x2E"],

        ["\x40\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xAD"],
        ["\x90\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x2F"],

        ["\x40\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xAE"],
        ["\x90\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x30"],

        ["\x40\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xAF"],
        ["\x90\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x31"],

        ["\x40\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xB0"],
        ["\x90\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x32"],

        ["\x40\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xB1"],
        ["\x90\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x33"],

        ["\x40\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xB2"],
        ["\x90\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x34"],

        ["\x40\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xB3"],
        ["\x90\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x35"],

        ["\x40\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xB4"],
        ["\x90\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x36"],

        ["\x40\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xB5"],
        ["\x90\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x37"],

        ["\x40\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xB6"],
        ["\x90\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x38"],

        ["\x40\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xB7"],
        ["\x90\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x39"],

        ["\x40\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xB8"],
        ["\x90\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x3A"],

        ["\x40\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xB9"],
        ["\x90\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x3B"],

        ["\x40\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xBA"],
        ["\x90\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x3C"],

        ["\x40\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xBB"],
        ["\x90\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x3D"],

        ["\x40\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xBC"],
        ["\x90\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x3E"],

        ["\x40\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xBD"],
        ["\x90\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x3F"],

        ["\x40\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xBE"],
        ["\x90\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x40"],

        ["\x40\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xBF"],
        ["\x90\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x41"],

        ["\x40\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xC0"],
        ["\x90\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x42"],

        ["\x40\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xC1"],
        ["\x90\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x43"],

        ["\x40\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xC2"],
        ["\x90\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x44"],

        ["\x40\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xC3"],
        ["\x90\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x45"],

        ["\x40\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xC4"],
        ["\x90\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x46"],

        ["\x40\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xC5"],
        ["\x90\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x47"],

        ["\x40\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xC6"],
        ["\x90\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x48"],

        ["\x40\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xC7"],
        ["\x90\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x49"],

        ["\x40\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xC8"],
        ["\x90\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x4A"],

        ["\x40\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xC9"],
        ["\x90\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x4B"],

        ["\x40\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xCA"],
        ["\x90\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x4C"],

        ["\x40\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xCB"],
        ["\x90\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x4D"],

        ["\x40\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xCC"],
        ["\x90\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x4E"],

        ["\x40\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xCD"],
        ["\x90\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x4F"],

        ["\x40\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xCE"],
        ["\x90\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x50"],

        ["\x40\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xCF"],
        ["\x90\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x51"],

        ["\x40\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xD0"],
        ["\x90\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x52"],

        ["\x40\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xD1"],
        ["\x90\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x53"],

        ["\x40\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xD2"],
        ["\x90\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x54"],

        ["\x40\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xD3"],
        ["\x90\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x55"],

        ["\x40\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xD4"],
        ["\x90\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x56"],

        ["\x40\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xD5"],
        ["\x90\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x57"],

        ["\x40\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xD6"],
        ["\x90\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x58"],

        ["\x40\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xD7"],
        ["\x90\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x59"],

        ["\x40\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xD8"],
        ["\x90\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x5A"],

        ["\x40\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xD9"],
        ["\x90\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x5B"],

        ["\x40\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xDA"],
        ["\x90\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x5C"],

        ["\x40\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xDB"],
        ["\x90\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x5D"],

        ["\x40\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xDC"],
        ["\x90\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x5E"],

        ["\x40\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xDD"],
        ["\x90\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x5F"],

        ["\x40\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xDE"],
        ["\x90\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x60"],

        ["\x40\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xDF"],
        ["\x90\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x61"],

        ["\x40\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xE0"],
        ["\x90\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x62"],

        ["\x40\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xE1"],
        ["\x90\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x63"],

        ["\x40\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xE2"],
        ["\x90\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x64"],

        ["\x40\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xE3"],
        ["\x90\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x65"],

        ["\x40\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xE4"],
        ["\x90\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x66"],

        ["\x40\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xE5"],
        ["\x90\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x67"],

        ["\x40\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xE6"],
        ["\x90\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x68"],

        ["\x40\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xE7"],
        ["\x90\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x69"],

        ["\x40\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xE8"],
        ["\x90\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x6A"],

        ["\x40\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xE9"],
        ["\x90\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x6B"],

        ["\x40\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xEA"],
        ["\x90\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x6C"],

        ["\x40\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xEB"],
        ["\x90\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x6D"],

        ["\x40\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xEC"],
        ["\x90\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x6E"],

        ["\x40\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xED"],
        ["\x90\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x6F"],

        ["\x40\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xEE"],
        ["\x90\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x70"],

        ["\x40\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xEF"],
        ["\x90\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x71"],

        ["\x40\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xF0"],
        ["\x90\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x72"],

        ["\x40\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xF1"],
        ["\x90\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x73"],

        ["\x40\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xF2"],
        ["\x90\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x74"],

        ["\x40\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xF3"],
        ["\x90\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x75"],

        ["\x40\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xF4"],
        ["\x90\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x76"],

        ["\x40\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xF5"],
        ["\x90\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x77"],

        ["\x40\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xF6"],
        ["\x90\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x78"],

        ["\x40\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xF7"],
        ["\x90\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x79"],

        ["\x40\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xF8"],
        ["\x90\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x7A"],

        ["\x40\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xF9"],
        ["\x90\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x7B"],

        ["\x40\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xFA"],
        ["\x90\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x7C"],

        ["\x40\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xFB"],
        ["\x90\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x7D"],

        ["\x40\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x90\xFC"],
        ["\x90\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x40\x7E"],

        ["\x41\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x40"],
        ["\x91\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x21"],

        ["\x41\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x41"],
        ["\x91\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x22"],

        ["\x41\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x42"],
        ["\x91\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x23"],

        ["\x41\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x43"],
        ["\x91\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x24"],

        ["\x41\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x44"],
        ["\x91\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x25"],

        ["\x41\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x45"],
        ["\x91\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x26"],

        ["\x41\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x46"],
        ["\x91\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x27"],

        ["\x6C\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x47"],
        ["\x91\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x4D"],

        ["\x41\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x48"],
        ["\x91\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x29"],

        ["\x41\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x49"],
        ["\x91\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x2A"],

        ["\x41\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x4A"],
        ["\x91\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x2B"],

        ["\x41\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x4B"],
        ["\x91\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x2C"],

        ["\x41\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x4C"],
        ["\x91\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x2D"],

        ["\x41\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x4D"],
        ["\x91\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x2E"],

        ["\x41\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x4E"],
        ["\x91\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x2F"],

        ["\x41\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x4F"],
        ["\x91\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x30"],

        ["\x41\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x50"],
        ["\x91\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x31"],

        ["\x41\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x51"],
        ["\x91\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x32"],

        ["\x41\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x52"],
        ["\x91\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x33"],

        ["\x41\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x53"],
        ["\x91\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x34"],

        ["\x41\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x54"],
        ["\x91\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x35"],

        ["\x41\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x55"],
        ["\x91\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x36"],

        ["\x41\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x56"],
        ["\x91\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x37"],

        ["\x41\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x57"],
        ["\x91\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x38"],

        ["\x41\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x58"],
        ["\x91\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x39"],

        ["\x41\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x59"],
        ["\x91\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x3A"],

        ["\x41\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x5A"],
        ["\x91\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x3B"],

        ["\x41\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x5B"],
        ["\x91\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x3C"],

        ["\x41\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x5C"],
        ["\x91\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x3D"],

        ["\x41\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x5D"],
        ["\x91\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x3E"],

        ["\x41\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x5E"],
        ["\x91\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x3F"],

        ["\x41\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x5F"],
        ["\x91\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x40"],

        ["\x41\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x60"],
        ["\x91\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x41"],

        ["\x41\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x61"],
        ["\x91\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x42"],

        ["\x41\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x62"],
        ["\x91\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x43"],

        ["\x41\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x63"],
        ["\x91\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x44"],

        ["\x41\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x64"],
        ["\x91\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x45"],

        ["\x41\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x65"],
        ["\x91\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x46"],

        ["\x41\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x66"],
        ["\x91\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x47"],

        ["\x41\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x67"],
        ["\x91\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x48"],

        ["\x41\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x68"],
        ["\x91\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x49"],

        ["\x41\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x69"],
        ["\x91\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x4A"],

        ["\x41\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x6A"],
        ["\x91\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x4B"],

        ["\x41\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x6B"],
        ["\x91\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x4C"],

        ["\x41\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x6C"],
        ["\x91\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x4D"],

        ["\x41\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x6D"],
        ["\x91\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x4E"],

        ["\x41\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x6E"],
        ["\x91\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x4F"],

        ["\x41\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x6F"],
        ["\x91\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x50"],

        ["\x41\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x70"],
        ["\x91\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x51"],

        ["\x41\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x71"],
        ["\x91\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x52"],

        ["\x41\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x72"],
        ["\x91\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x53"],

        ["\x41\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x73"],
        ["\x91\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x54"],

        ["\x41\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x74"],
        ["\x91\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x55"],

        ["\x41\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x75"],
        ["\x91\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x56"],

        ["\x41\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x76"],
        ["\x91\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x57"],

        ["\x41\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x77"],
        ["\x91\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x58"],

        ["\x41\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x78"],
        ["\x91\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x59"],

        ["\x41\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x79"],
        ["\x91\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x5A"],

        ["\x41\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x7A"],
        ["\x91\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x5B"],

        ["\x41\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x7B"],
        ["\x91\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x5C"],

        ["\x41\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x7C"],
        ["\x91\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x5D"],

        ["\x41\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x7D"],
        ["\x91\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x5E"],

        ["\x41\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x7E"],
        ["\x91\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x5F"],

        ["\x41\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x80"],
        ["\x91\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x60"],

        ["\x41\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x81"],
        ["\x91\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x61"],

        ["\x41\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x82"],
        ["\x91\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x62"],

        ["\x41\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x83"],
        ["\x91\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x63"],

        ["\x41\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x84"],
        ["\x91\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x64"],

        ["\x41\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x85"],
        ["\x91\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x65"],

        ["\x41\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x86"],
        ["\x91\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x66"],

        ["\x41\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x87"],
        ["\x91\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x67"],

        ["\x41\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x88"],
        ["\x91\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x68"],

        ["\x41\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x89"],
        ["\x91\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x69"],

        ["\x41\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x8A"],
        ["\x91\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x6A"],

        ["\x41\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x8B"],
        ["\x91\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x6B"],

        ["\x41\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x8C"],
        ["\x91\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x6C"],

        ["\x41\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x8D"],
        ["\x91\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x6D"],

        ["\x41\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x8E"],
        ["\x91\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x6E"],

        ["\x41\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x8F"],
        ["\x91\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x6F"],

        ["\x41\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x90"],
        ["\x91\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x70"],

        ["\x41\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x91"],
        ["\x91\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x71"],

        ["\x41\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x92"],
        ["\x91\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x72"],

        ["\x41\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x93"],
        ["\x91\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x73"],

        ["\x41\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x94"],
        ["\x91\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x74"],

        ["\x41\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x95"],
        ["\x91\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x75"],

        ["\x41\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x96"],
        ["\x91\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x76"],

        ["\x41\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x97"],
        ["\x91\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x77"],

        ["\x41\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x98"],
        ["\x91\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x78"],

        ["\x41\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x99"],
        ["\x91\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x79"],

        ["\x41\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x9A"],
        ["\x91\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x7A"],

        ["\x41\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x9B"],
        ["\x91\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x7B"],

        ["\x41\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x9C"],
        ["\x91\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x7C"],

        ["\x41\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x9D"],
        ["\x91\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x7D"],

        ["\x41\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x9E"],
        ["\x91\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x7E"],

        ["\x42\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\x9F"],
        ["\x91\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x21"],

        ["\x42\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xA0"],
        ["\x91\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x22"],

        ["\x42\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xA1"],
        ["\x91\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x23"],

        ["\x42\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xA2"],
        ["\x91\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x24"],

        ["\x42\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xA3"],
        ["\x91\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x25"],

        ["\x42\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xA4"],
        ["\x91\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x26"],

        ["\x42\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xA5"],
        ["\x91\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x27"],

        ["\x42\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xA6"],
        ["\x91\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x28"],

        ["\x42\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xA7"],
        ["\x91\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x29"],

        ["\x42\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xA8"],
        ["\x91\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x2A"],

        ["\x42\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xA9"],
        ["\x91\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x2B"],

        ["\x42\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xAA"],
        ["\x91\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x2C"],

        ["\x42\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xAB"],
        ["\x91\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x2D"],

        ["\x42\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xAC"],
        ["\x91\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x2E"],

        ["\x42\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xAD"],
        ["\x91\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x2F"],

        ["\x42\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xAE"],
        ["\x91\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x30"],

        ["\x42\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xAF"],
        ["\x91\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x31"],

        ["\x42\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xB0"],
        ["\x91\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x32"],

        ["\x42\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xB1"],
        ["\x91\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x33"],

        ["\x42\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xB2"],
        ["\x91\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x34"],

        ["\x42\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xB3"],
        ["\x91\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x35"],

        ["\x42\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xB4"],
        ["\x91\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x36"],

        ["\x42\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xB5"],
        ["\x91\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x37"],

        ["\x42\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xB6"],
        ["\x91\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x38"],

        ["\x42\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xB7"],
        ["\x91\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x39"],

        ["\x42\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xB8"],
        ["\x91\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x3A"],

        ["\x42\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xB9"],
        ["\x91\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x3B"],

        ["\x42\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xBA"],
        ["\x91\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x3C"],

        ["\x42\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xBB"],
        ["\x91\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x3D"],

        ["\x42\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xBC"],
        ["\x91\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x3E"],

        ["\x42\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xBD"],
        ["\x91\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x3F"],

        ["\x42\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xBE"],
        ["\x91\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x40"],

        ["\x42\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xBF"],
        ["\x91\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x41"],

        ["\x42\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xC0"],
        ["\x91\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x42"],

        ["\x42\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xC1"],
        ["\x91\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x43"],

        ["\x42\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xC2"],
        ["\x91\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x44"],

        ["\x42\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xC3"],
        ["\x91\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x45"],

        ["\x42\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xC4"],
        ["\x91\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x46"],

        ["\x42\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xC5"],
        ["\x91\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x47"],

        ["\x42\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xC6"],
        ["\x91\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x48"],

        ["\x42\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xC7"],
        ["\x91\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x49"],

        ["\x42\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xC8"],
        ["\x91\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x4A"],

        ["\x42\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xC9"],
        ["\x91\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x4B"],

        ["\x42\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xCA"],
        ["\x91\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x4C"],

        ["\x42\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xCB"],
        ["\x91\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x4D"],

        ["\x42\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xCC"],
        ["\x91\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x4E"],

        ["\x42\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xCD"],
        ["\x91\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x4F"],

        ["\x42\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xCE"],
        ["\x91\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x50"],

        ["\x42\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xCF"],
        ["\x91\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x51"],

        ["\x42\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xD0"],
        ["\x91\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x52"],

        ["\x42\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xD1"],
        ["\x91\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x53"],

        ["\x42\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xD2"],
        ["\x91\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x54"],

        ["\x42\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xD3"],
        ["\x91\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x55"],

        ["\x42\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xD4"],
        ["\x91\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x56"],

        ["\x42\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xD5"],
        ["\x91\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x57"],

        ["\x42\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xD6"],
        ["\x91\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x58"],

        ["\x42\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xD7"],
        ["\x91\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x59"],

        ["\x42\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xD8"],
        ["\x91\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x5A"],

        ["\x42\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xD9"],
        ["\x91\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x5B"],

        ["\x42\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xDA"],
        ["\x91\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x5C"],

        ["\x42\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xDB"],
        ["\x91\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x5D"],

        ["\x42\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xDC"],
        ["\x91\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x5E"],

        ["\x42\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xDD"],
        ["\x91\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x5F"],

        ["\x42\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xDE"],
        ["\x91\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x60"],

        ["\x42\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xDF"],
        ["\x91\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x61"],

        ["\x42\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xE0"],
        ["\x91\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x62"],

        ["\x42\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xE1"],
        ["\x91\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x63"],

        ["\x42\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xE2"],
        ["\x91\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x64"],

        ["\x42\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xE3"],
        ["\x91\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x65"],

        ["\x42\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xE4"],
        ["\x91\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x66"],

        ["\x42\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xE5"],
        ["\x91\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x67"],

        ["\x42\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xE6"],
        ["\x91\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x68"],

        ["\x42\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xE7"],
        ["\x91\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x69"],

        ["\x42\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xE8"],
        ["\x91\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x6A"],

        ["\x42\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xE9"],
        ["\x91\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x6B"],

        ["\x42\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xEA"],
        ["\x91\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x6C"],

        ["\x42\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xEB"],
        ["\x91\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x6D"],

        ["\x42\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xEC"],
        ["\x91\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x6E"],

        ["\x42\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xED"],
        ["\x91\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x6F"],

        ["\x42\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xEE"],
        ["\x91\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x70"],

        ["\x42\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xEF"],
        ["\x91\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x71"],

        ["\x42\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xF0"],
        ["\x91\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x72"],

        ["\x42\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xF1"],
        ["\x91\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x73"],

        ["\x42\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xF2"],
        ["\x91\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x74"],

        ["\x42\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xF3"],
        ["\x91\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x75"],

        ["\x42\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xF4"],
        ["\x91\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x76"],

        ["\x42\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xF5"],
        ["\x91\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x77"],

        ["\x42\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xF6"],
        ["\x91\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x78"],

        ["\x42\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xF7"],
        ["\x91\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x79"],

        ["\x42\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xF8"],
        ["\x91\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x7A"],

        ["\x42\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xF9"],
        ["\x91\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x7B"],

        ["\x42\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xFA"],
        ["\x91\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x7C"],

        ["\x42\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xFB"],
        ["\x91\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x7D"],

        ["\x42\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x91\xFC"],
        ["\x91\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x42\x7E"],

        ["\x43\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x40"],
        ["\x92\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x21"],

        ["\x43\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x41"],
        ["\x92\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x22"],

        ["\x43\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x42"],
        ["\x92\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x23"],

        ["\x43\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x43"],
        ["\x92\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x24"],

        ["\x43\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x44"],
        ["\x92\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x25"],

        ["\x43\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x45"],
        ["\x92\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x26"],

        ["\x43\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x46"],
        ["\x92\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x27"],

        ["\x43\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x47"],
        ["\x92\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x28"],

        ["\x43\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x48"],
        ["\x92\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x29"],

        ["\x43\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x49"],
        ["\x92\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x2A"],

        ["\x43\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x4A"],
        ["\x92\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x2B"],

        ["\x43\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x4B"],
        ["\x92\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x2C"],

        ["\x43\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x4C"],
        ["\x92\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x2D"],

        ["\x43\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x4D"],
        ["\x92\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x2E"],

        ["\x43\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x4E"],
        ["\x92\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x2F"],

        ["\x43\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x4F"],
        ["\x92\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x30"],

        ["\x43\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x50"],
        ["\x92\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x31"],

        ["\x43\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x51"],
        ["\x92\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x32"],

        ["\x43\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x52"],
        ["\x92\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x33"],

        ["\x43\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x53"],
        ["\x92\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x34"],

        ["\x43\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x54"],
        ["\x92\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x35"],

        ["\x43\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x55"],
        ["\x92\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x36"],

        ["\x43\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x56"],
        ["\x92\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x37"],

        ["\x43\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x57"],
        ["\x92\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x38"],

        ["\x43\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x58"],
        ["\x92\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x39"],

        ["\x43\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x59"],
        ["\x92\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x3A"],

        ["\x43\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x5A"],
        ["\x92\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x3B"],

        ["\x43\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x5B"],
        ["\x92\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x3C"],

        ["\x43\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x5C"],
        ["\x92\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x3D"],

        ["\x43\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x5D"],
        ["\x92\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x3E"],

        ["\x43\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x5E"],
        ["\x92\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x3F"],

        ["\x43\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x5F"],
        ["\x92\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x40"],

        ["\x43\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x60"],
        ["\x92\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x41"],

        ["\x43\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x61"],
        ["\x92\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x42"],

        ["\x43\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x62"],
        ["\x92\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x43"],

        ["\x43\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x63"],
        ["\x92\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x44"],

        ["\x43\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x64"],
        ["\x92\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x45"],

        ["\x43\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x65"],
        ["\x92\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x46"],

        ["\x43\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x66"],
        ["\x92\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x47"],

        ["\x43\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x67"],
        ["\x92\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x48"],

        ["\x43\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x68"],
        ["\x92\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x49"],

        ["\x43\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x69"],
        ["\x92\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x4A"],

        ["\x43\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x6A"],
        ["\x92\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x4B"],

        ["\x43\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x6B"],
        ["\x92\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x4C"],

        ["\x43\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x6C"],
        ["\x92\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x4D"],

        ["\x43\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x6D"],
        ["\x92\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x4E"],

        ["\x43\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x6E"],
        ["\x92\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x4F"],

        ["\x43\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x6F"],
        ["\x92\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x50"],

        ["\x43\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x70"],
        ["\x92\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x51"],

        ["\x43\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x71"],
        ["\x92\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x52"],

        ["\x43\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x72"],
        ["\x92\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x53"],

        ["\x43\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x73"],
        ["\x92\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x54"],

        ["\x43\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x74"],
        ["\x92\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x55"],

        ["\x43\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x75"],
        ["\x92\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x56"],

        ["\x43\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x76"],
        ["\x92\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x57"],

        ["\x43\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x77"],
        ["\x92\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x58"],

        ["\x43\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x78"],
        ["\x92\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x59"],

        ["\x43\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x79"],
        ["\x92\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x5A"],

        ["\x43\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x7A"],
        ["\x92\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x5B"],

        ["\x43\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x7B"],
        ["\x92\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x5C"],

        ["\x43\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x7C"],
        ["\x92\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x5D"],

        ["\x43\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x7D"],
        ["\x92\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x5E"],

        ["\x43\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x7E"],
        ["\x92\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x5F"],

        ["\x43\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x80"],
        ["\x92\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x60"],

        ["\x43\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x81"],
        ["\x92\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x61"],

        ["\x43\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x82"],
        ["\x92\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x62"],

        ["\x43\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x83"],
        ["\x92\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x63"],

        ["\x43\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x84"],
        ["\x92\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x64"],

        ["\x43\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x85"],
        ["\x92\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x65"],

        ["\x43\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x86"],
        ["\x92\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x66"],

        ["\x43\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x87"],
        ["\x92\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x67"],

        ["\x43\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x88"],
        ["\x92\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x68"],

        ["\x43\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x89"],
        ["\x92\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x69"],

        ["\x43\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x8A"],
        ["\x92\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x6A"],

        ["\x43\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x8B"],
        ["\x92\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x6B"],

        ["\x43\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x8C"],
        ["\x92\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x6C"],

        ["\x43\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x8D"],
        ["\x92\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x6D"],

        ["\x43\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x8E"],
        ["\x92\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x6E"],

        ["\x43\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x8F"],
        ["\x92\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x6F"],

        ["\x43\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x90"],
        ["\x92\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x70"],

        ["\x43\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x91"],
        ["\x92\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x71"],

        ["\x43\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x92"],
        ["\x92\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x72"],

        ["\x43\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x93"],
        ["\x92\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x73"],

        ["\x43\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x94"],
        ["\x92\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x74"],

        ["\x43\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x95"],
        ["\x92\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x75"],

        ["\x43\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x96"],
        ["\x92\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x76"],

        ["\x43\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x97"],
        ["\x92\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x77"],

        ["\x43\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x98"],
        ["\x92\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x78"],

        ["\x43\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x99"],
        ["\x92\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x79"],

        ["\x43\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x9A"],
        ["\x92\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x7A"],

        ["\x43\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x9B"],
        ["\x92\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x7B"],

        ["\x43\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x9C"],
        ["\x92\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x7C"],

        ["\x43\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x9D"],
        ["\x92\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x7D"],

        ["\x43\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x9E"],
        ["\x92\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x43\x7E"],

        ["\x44\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\x9F"],
        ["\x92\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x21"],

        ["\x44\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xA0"],
        ["\x92\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x22"],

        ["\x44\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xA1"],
        ["\x92\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x23"],

        ["\x44\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xA2"],
        ["\x92\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x24"],

        ["\x44\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xA3"],
        ["\x92\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x25"],

        ["\x44\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xA4"],
        ["\x92\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x26"],

        ["\x44\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xA5"],
        ["\x92\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x27"],

        ["\x44\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xA6"],
        ["\x92\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x28"],

        ["\x44\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xA7"],
        ["\x92\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x29"],

        ["\x44\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xA8"],
        ["\x92\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x2A"],

        ["\x44\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xA9"],
        ["\x92\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x2B"],

        ["\x44\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xAA"],
        ["\x92\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x2C"],

        ["\x44\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xAB"],
        ["\x92\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x2D"],

        ["\x44\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xAC"],
        ["\x92\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x2E"],

        ["\x44\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xAD"],
        ["\x92\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x2F"],

        ["\x44\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xAE"],
        ["\x92\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x30"],

        ["\x44\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xAF"],
        ["\x92\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x31"],

        ["\x44\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xB0"],
        ["\x92\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x32"],

        ["\x44\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xB1"],
        ["\x92\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x33"],

        ["\x44\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xB2"],
        ["\x92\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x34"],

        ["\x44\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xB3"],
        ["\x92\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x35"],

        ["\x44\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xB4"],
        ["\x92\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x36"],

        ["\x44\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xB5"],
        ["\x92\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x37"],

        ["\x44\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xB6"],
        ["\x92\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x38"],

        ["\x44\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xB7"],
        ["\x92\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x39"],

        ["\x44\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xB8"],
        ["\x92\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x3A"],

        ["\x44\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xB9"],
        ["\x92\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x3B"],

        ["\x44\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xBA"],
        ["\x92\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x3C"],

        ["\x44\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xBB"],
        ["\x92\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x3D"],

        ["\x44\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xBC"],
        ["\x92\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x3E"],

        ["\x44\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xBD"],
        ["\x92\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x3F"],

        ["\x44\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xBE"],
        ["\x92\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x40"],

        ["\x44\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xBF"],
        ["\x92\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x41"],

        ["\x44\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xC0"],
        ["\x92\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x42"],

        ["\x44\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xC1"],
        ["\x92\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x43"],

        ["\x44\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xC2"],
        ["\x92\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x44"],

        ["\x44\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xC3"],
        ["\x92\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x45"],

        ["\x44\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xC4"],
        ["\x92\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x46"],

        ["\x44\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xC5"],
        ["\x92\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x47"],

        ["\x44\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xC6"],
        ["\x92\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x48"],

        ["\x44\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xC7"],
        ["\x92\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x49"],

        ["\x44\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xC8"],
        ["\x92\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x4A"],

        ["\x44\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xC9"],
        ["\x92\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x4B"],

        ["\x44\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xCA"],
        ["\x92\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x4C"],

        ["\xB6\xF5",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xCB"],
        ["\x92\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xB6\xF5"],

        ["\x44\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xCC"],
        ["\x92\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x4E"],

        ["\x44\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xCD"],
        ["\x92\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x4F"],

        ["\x44\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xCE"],
        ["\x92\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x50"],

        ["\x44\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xCF"],
        ["\x92\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x51"],

        ["\x44\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xD0"],
        ["\x92\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x52"],

        ["\x44\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xD1"],
        ["\x92\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x53"],

        ["\x44\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xD2"],
        ["\x92\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x54"],

        ["\x44\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xD3"],
        ["\x92\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x55"],

        ["\x44\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xD4"],
        ["\x92\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x56"],

        ["\x44\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xD5"],
        ["\x92\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x57"],

        ["\x44\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xD6"],
        ["\x92\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x58"],

        ["\x44\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xD7"],
        ["\x92\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x59"],

        ["\x44\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xD8"],
        ["\x92\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x5A"],

        ["\x54\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xD9"],
        ["\x92\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x64"],

        ["\x44\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xDA"],
        ["\x92\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x5C"],

        ["\x44\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xDB"],
        ["\x92\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x5D"],

        ["\x44\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xDC"],
        ["\x92\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x5E"],

        ["\x44\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xDD"],
        ["\x92\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x5F"],

        ["\x44\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xDE"],
        ["\x92\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x60"],

        ["\x44\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xDF"],
        ["\x92\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x61"],

        ["\x44\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xE0"],
        ["\x92\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x62"],

        ["\x44\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xE1"],
        ["\x92\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x63"],

        ["\x44\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xE2"],
        ["\x92\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x64"],

        ["\x44\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xE3"],
        ["\x92\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x65"],

        ["\x44\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xE4"],
        ["\x92\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x66"],

        ["\x44\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xE5"],
        ["\x92\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x67"],

        ["\x44\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xE6"],
        ["\x92\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x68"],

        ["\x44\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xE7"],
        ["\x92\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x69"],

        ["\x44\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xE8"],
        ["\x92\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x6A"],

        ["\x44\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xE9"],
        ["\x92\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x6B"],

        ["\x44\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xEA"],
        ["\x92\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x6C"],

        ["\x44\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xEB"],
        ["\x92\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x6D"],

        ["\x44\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xEC"],
        ["\x92\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x6E"],

        ["\x44\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xED"],
        ["\x92\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x6F"],

        ["\x44\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xEE"],
        ["\x92\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x70"],

        ["\x44\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xEF"],
        ["\x92\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x71"],

        ["\x44\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xF0"],
        ["\x92\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x72"],

        ["\x44\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xF1"],
        ["\x92\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x73"],

        ["\x44\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xF2"],
        ["\x92\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x74"],

        ["\x44\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xF3"],
        ["\x92\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x75"],

        ["\x44\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xF4"],
        ["\x92\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x76"],

        ["\x44\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xF5"],
        ["\x92\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x77"],

        ["\x44\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xF6"],
        ["\x92\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x78"],

        ["\x44\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xF7"],
        ["\x92\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x79"],

        ["\x44\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xF8"],
        ["\x92\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x7A"],

        ["\x44\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xF9"],
        ["\x92\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x7B"],

        ["\x44\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xFA"],
        ["\x92\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x7C"],

        ["\x44\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xFB"],
        ["\x92\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],

        ["\x44\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x92\xFC"],
        ["\x92\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x7E"],

        ["\x45\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x40"],
        ["\x93\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x21"],

        ["\x45\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x41"],
        ["\x93\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x22"],

        ["\x45\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x42"],
        ["\x93\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x23"],

        ["\x45\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x43"],
        ["\x93\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x24"],

        ["\x45\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x44"],
        ["\x93\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x25"],

        ["\x45\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x45"],
        ["\x93\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x26"],

        ["\x45\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x46"],
        ["\x93\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x27"],

        ["\x45\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x47"],
        ["\x93\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x28"],

        ["\x45\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x48"],
        ["\x93\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x29"],

        ["\x45\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x49"],
        ["\x93\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x2A"],

        ["\x45\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x4A"],
        ["\x93\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x2B"],

        ["\x45\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x4B"],
        ["\x93\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x2C"],

        ["\x45\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x4C"],
        ["\x93\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x2D"],

        ["\x45\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x4D"],
        ["\x93\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x2E"],

        ["\x45\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x4E"],
        ["\x93\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x2F"],

        ["\x45\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x4F"],
        ["\x93\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x30"],

        ["\x45\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x50"],
        ["\x93\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x31"],

        ["\x45\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x51"],
        ["\x93\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x32"],

        ["\x45\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x52"],
        ["\x93\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x33"],

        ["\x45\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x53"],
        ["\x93\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x34"],

        ["\x45\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x54"],
        ["\x93\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x35"],

        ["\xD6\xE6",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x55"],
        ["\x93\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD6\xE6"],

        ["\x45\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x56"],
        ["\x93\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x37"],

        ["\x45\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x57"],
        ["\x93\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x38"],

        ["\x45\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x58"],
        ["\x93\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x39"],

        ["\x45\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x59"],
        ["\x93\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x3A"],

        ["\x45\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x5A"],
        ["\x93\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x3B"],

        ["\x45\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x5B"],
        ["\x93\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x3C"],

        ["\x45\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x5C"],
        ["\x93\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x3D"],

        ["\x45\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x5D"],
        ["\x93\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x3E"],

        ["\xD4\xA3",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x5E"],
        ["\x93\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD4\xA3"],

        ["\x45\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x5F"],
        ["\x93\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x40"],

        ["\x45\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x60"],
        ["\x93\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x41"],

        ["\x45\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x61"],
        ["\x93\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x42"],

        ["\x45\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x62"],
        ["\x93\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x43"],

        ["\x45\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x63"],
        ["\x93\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x44"],

        ["\x45\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x64"],
        ["\x93\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x45"],

        ["\x45\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x65"],
        ["\x93\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x46"],

        ["\x45\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x66"],
        ["\x93\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x47"],

        ["\x45\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x67"],
        ["\x93\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x48"],

        ["\x45\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x68"],
        ["\x93\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x49"],

        ["\x45\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x69"],
        ["\x93\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x4A"],

        ["\x45\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x6A"],
        ["\x93\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x4B"],

        ["\x45\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x6B"],
        ["\x93\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x4C"],

        ["\x45\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x6C"],
        ["\x93\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x4D"],

        ["\x45\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x6D"],
        ["\x93\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x4E"],

        ["\x45\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x6E"],
        ["\x93\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x4F"],

        ["\x45\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x6F"],
        ["\x93\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x50"],

        ["\x45\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x70"],
        ["\x93\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x51"],

        ["\x45\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x71"],
        ["\x93\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x52"],

        ["\x45\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x72"],
        ["\x93\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x53"],

        ["\x45\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x73"],
        ["\x93\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x54"],

        ["\x45\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x74"],
        ["\x93\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x55"],

        ["\x45\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x75"],
        ["\x93\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x56"],

        ["\x62\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x76"],
        ["\x93\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x6A"],

        ["\x45\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x77"],
        ["\x93\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x58"],

        ["\x45\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x78"],
        ["\x93\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x59"],

        ["\x45\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x79"],
        ["\x93\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x5A"],

        ["\x45\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x7A"],
        ["\x93\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x5B"],

        ["\x45\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x7B"],
        ["\x93\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x5C"],

        ["\x45\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x7C"],
        ["\x93\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x5D"],

        ["\x45\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x7D"],
        ["\x93\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x5E"],

        ["\x45\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x7E"],
        ["\x93\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x5F"],

        ["\x45\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x80"],
        ["\x93\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x60"],

        ["\x45\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x81"],
        ["\x93\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x61"],

        ["\x45\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x82"],
        ["\x93\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x62"],

        ["\x45\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x83"],
        ["\x93\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x63"],

        ["\x45\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x84"],
        ["\x93\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x64"],

        ["\x45\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x85"],
        ["\x93\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x65"],

        ["\x45\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x86"],
        ["\x93\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x66"],

        ["\x45\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x87"],
        ["\x93\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x67"],

        ["\x45\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x88"],
        ["\x93\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x68"],

        ["\x45\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x89"],
        ["\x93\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x69"],

        ["\x45\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x8A"],
        ["\x93\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x6A"],

        ["\x45\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x8B"],
        ["\x93\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x6B"],

        ["\x45\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x8C"],
        ["\x93\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x6C"],

        ["\x45\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x8D"],
        ["\x93\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x6D"],

        ["\x5B\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x8E"],
        ["\x93\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x6D"],

        ["\x45\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x8F"],
        ["\x93\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x6F"],

        ["\x45\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x90"],
        ["\x93\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x70"],

        ["\x45\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x91"],
        ["\x93\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x71"],

        ["\x45\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x92"],
        ["\x93\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x72"],

        ["\x5E\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x93"],
        ["\x93\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x39"],

        ["\x45\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x94"],
        ["\x93\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x74"],

        ["\x45\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x95"],
        ["\x93\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x75"],

        ["\x45\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x96"],
        ["\x93\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x76"],

        ["\x45\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x97"],
        ["\x93\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x77"],

        ["\x45\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x98"],
        ["\x93\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x78"],

        ["\x45\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x99"],
        ["\x93\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x79"],

        ["\x45\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x9A"],
        ["\x93\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x7A"],

        ["\x45\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x9B"],
        ["\x93\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x7B"],

        ["\x45\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x9C"],
        ["\x93\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x7C"],

        ["\x45\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x9D"],
        ["\x93\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x7D"],

        ["\x45\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x9E"],
        ["\x93\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x7E"],

        ["\x46\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\x9F"],
        ["\x93\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x21"],

        ["\x46\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xA0"],
        ["\x93\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x22"],

        ["\x46\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xA1"],
        ["\x93\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x23"],

        ["\x46\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xA2"],
        ["\x93\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x24"],

        ["\x46\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xA3"],
        ["\x93\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x25"],

        ["\x46\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xA4"],
        ["\x93\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x26"],

        ["\x46\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xA5"],
        ["\x93\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x27"],

        ["\x46\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xA6"],
        ["\x93\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x28"],

        ["\x46\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xA7"],
        ["\x93\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x29"],

        ["\x46\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xA8"],
        ["\x93\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x2A"],

        ["\x46\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xA9"],
        ["\x93\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x2B"],

        ["\x46\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xAA"],
        ["\x93\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x2C"],

        ["\x46\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xAB"],
        ["\x93\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x2D"],

        ["\x46\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xAC"],
        ["\x93\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x2E"],

        ["\x46\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xAD"],
        ["\x93\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x2F"],

        ["\x46\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xAE"],
        ["\x93\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x30"],

        ["\x46\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xAF"],
        ["\x93\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x31"],

        ["\x46\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xB0"],
        ["\x93\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x32"],

        ["\x46\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xB1"],
        ["\x93\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x33"],

        ["\x46\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xB2"],
        ["\x93\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x34"],

        ["\x46\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xB3"],
        ["\x93\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x35"],

        ["\x46\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xB4"],
        ["\x93\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x36"],

        ["\x46\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xB5"],
        ["\x93\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x37"],

        ["\x46\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xB6"],
        ["\x93\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x38"],

        ["\x46\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xB7"],
        ["\x93\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x39"],

        ["\x46\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xB8"],
        ["\x93\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x3A"],

        ["\x46\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xB9"],
        ["\x93\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x3B"],

        ["\x46\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xBA"],
        ["\x93\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x3C"],

        ["\x46\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xBB"],
        ["\x93\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x3D"],

        ["\x46\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xBC"],
        ["\x93\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x3E"],

        ["\x46\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xBD"],
        ["\x93\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x3F"],

        ["\x46\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xBE"],
        ["\x93\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x40"],

        ["\x46\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xBF"],
        ["\x93\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x41"],

        ["\x46\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xC0"],
        ["\x93\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x42"],

        ["\x46\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xC1"],
        ["\x93\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x43"],

        ["\x46\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xC2"],
        ["\x93\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x44"],

        ["\x46\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xC3"],
        ["\x93\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x45"],

        ["\x46\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xC4"],
        ["\x93\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x46"],

        ["\x46\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xC5"],
        ["\x93\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x47"],

        ["\x46\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xC6"],
        ["\x93\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x48"],

        ["\x46\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xC7"],
        ["\x93\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x49"],

        ["\x46\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xC8"],
        ["\x93\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x4A"],

        ["\x46\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xC9"],
        ["\x93\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x4B"],

        ["\x46\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xCA"],
        ["\x93\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x4C"],

        ["\x46\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xCB"],
        ["\x93\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x4D"],

        ["\x46\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xCC"],
        ["\x93\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x4E"],

        ["\x46\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xCD"],
        ["\x93\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x4F"],

        ["\x46\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xCE"],
        ["\x93\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x50"],

        ["\x46\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xCF"],
        ["\x93\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x51"],

        ["\x46\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xD0"],
        ["\x93\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x52"],

        ["\x46\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xD1"],
        ["\x93\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x53"],

        ["\x46\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xD2"],
        ["\x93\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x54"],

        ["\x46\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xD3"],
        ["\x93\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x55"],

        ["\x46\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xD4"],
        ["\x93\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x56"],

        ["\x46\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xD5"],
        ["\x93\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x57"],

        ["\x46\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xD6"],
        ["\x93\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x58"],

        ["\x46\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xD7"],
        ["\x93\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x59"],

        ["\x46\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xD8"],
        ["\x93\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x5A"],

        ["\x46\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xD9"],
        ["\x93\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x5B"],

        ["\x46\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xDA"],
        ["\x93\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x5C"],

        ["\x46\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xDB"],
        ["\x93\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x5D"],

        ["\x46\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xDC"],
        ["\x93\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x5E"],

        ["\x46\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xDD"],
        ["\x93\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x5F"],

        ["\x46\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xDE"],
        ["\x93\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x60"],

        ["\x46\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xDF"],
        ["\x93\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x61"],

        ["\x46\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xE0"],
        ["\x93\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x62"],

        ["\x46\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xE1"],
        ["\x93\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x63"],

        ["\x46\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xE2"],
        ["\x93\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x64"],

        ["\x46\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xE3"],
        ["\x93\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x65"],

        ["\x46\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xE4"],
        ["\x93\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x66"],

        ["\x46\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xE5"],
        ["\x93\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x67"],

        ["\x46\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xE6"],
        ["\x93\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x68"],

        ["\x46\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xE7"],
        ["\x93\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x69"],

        ["\x46\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xE8"],
        ["\x93\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x6A"],

        ["\x46\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xE9"],
        ["\x93\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x6B"],

        ["\x46\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xEA"],
        ["\x93\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x6C"],

        ["\x46\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xEB"],
        ["\x93\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x6D"],

        ["\x46\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xEC"],
        ["\x93\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x6E"],

        ["\x46\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xED"],
        ["\x93\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x6F"],

        ["\x46\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xEE"],
        ["\x93\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x70"],

        ["\x46\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xEF"],
        ["\x93\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x71"],

        ["\x46\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xF0"],
        ["\x93\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x72"],

        ["\x46\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xF1"],
        ["\x93\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x73"],

        ["\x46\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xF2"],
        ["\x93\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x74"],

        ["\x46\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xF3"],
        ["\x93\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x75"],

        ["\x6D\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xF4"],
        ["\x93\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x6E"],

        ["\x46\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xF5"],
        ["\x93\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x77"],

        ["\x46\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xF6"],
        ["\x93\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x78"],

        ["\x46\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xF7"],
        ["\x93\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x79"],

        ["\x46\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xF8"],
        ["\x93\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x7A"],

        ["\x46\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xF9"],
        ["\x93\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x7B"],

        ["\x46\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xFA"],
        ["\x93\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x7C"],

        ["\x46\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xFB"],
        ["\x93\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x7D"],

        ["\x46\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x93\xFC"],
        ["\x93\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x7E"],

        ["\x47\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x40"],
        ["\x94\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x21"],

        ["\x47\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x41"],
        ["\x94\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x22"],

        ["\x47\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x42"],
        ["\x94\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x23"],

        ["\x47\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x43"],
        ["\x94\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x24"],

        ["\x47\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x44"],
        ["\x94\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x25"],

        ["\x47\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x45"],
        ["\x94\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x26"],

        ["\x47\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x46"],
        ["\x94\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x27"],

        ["\x47\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x47"],
        ["\x94\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x28"],

        ["\x47\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x48"],
        ["\x94\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x29"],

        ["\x47\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x49"],
        ["\x94\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x2A"],

        ["\x47\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x4A"],
        ["\x94\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x2B"],

        ["\x47\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x4B"],
        ["\x94\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x2C"],

        ["\x47\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x4C"],
        ["\x94\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x2D"],

        ["\x47\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x4D"],
        ["\x94\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x2E"],

        ["\x47\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x4E"],
        ["\x94\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x2F"],

        ["\x47\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x4F"],
        ["\x94\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x30"],

        ["\x47\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x50"],
        ["\x94\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x31"],

        ["\x47\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x51"],
        ["\x94\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x32"],

        ["\x47\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x52"],
        ["\x94\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x33"],

        ["\x47\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x53"],
        ["\x94\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x34"],

        ["\x47\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x54"],
        ["\x94\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x35"],

        ["\x47\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x55"],
        ["\x94\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x36"],

        ["\x47\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x56"],
        ["\x94\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x37"],

        ["\x47\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x57"],
        ["\x94\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x38"],

        ["\x47\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x58"],
        ["\x94\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x39"],

        ["\x47\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x59"],
        ["\x94\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x3A"],

        ["\x47\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x5A"],
        ["\x94\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x3B"],

        ["\x47\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x5B"],
        ["\x94\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x3C"],

        ["\x47\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x5C"],
        ["\x94\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x3D"],

        ["\x47\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x5D"],
        ["\x94\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x3E"],

        ["\x47\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x5E"],
        ["\x94\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x3F"],

        ["\x47\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x5F"],
        ["\x94\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x40"],

        ["\x47\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x60"],
        ["\x94\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x41"],

        ["\x47\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x61"],
        ["\x94\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x42"],

        ["\x47\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x62"],
        ["\x94\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x43"],

        ["\x47\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x63"],
        ["\x94\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x44"],

        ["\x47\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x64"],
        ["\x94\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x45"],

        ["\x47\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x65"],
        ["\x94\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x46"],

        ["\x47\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x66"],
        ["\x94\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x47"],

        ["\x47\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x67"],
        ["\x94\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x48"],

        ["\x47\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x68"],
        ["\x94\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x49"],

        ["\x47\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x69"],
        ["\x94\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x4A"],

        ["\x47\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x6A"],
        ["\x94\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x4B"],

        ["\x47\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x6B"],
        ["\x94\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x4C"],

        ["\x47\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x6C"],
        ["\x94\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x4D"],

        ["\x47\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x6D"],
        ["\x94\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x4E"],

        ["\x47\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x6E"],
        ["\x94\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x4F"],

        ["\x47\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x6F"],
        ["\x94\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x50"],

        ["\x47\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x70"],
        ["\x94\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x51"],

        ["\x47\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x71"],
        ["\x94\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x52"],

        ["\x47\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x72"],
        ["\x94\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x53"],

        ["\x47\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x73"],
        ["\x94\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x54"],

        ["\x47\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x74"],
        ["\x94\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x55"],

        ["\x47\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x75"],
        ["\x94\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x56"],

        ["\x47\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x76"],
        ["\x94\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x57"],

        ["\x47\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x77"],
        ["\x94\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x58"],

        ["\x47\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x78"],
        ["\x94\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x59"],

        ["\x47\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x79"],
        ["\x94\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x5A"],

        ["\x47\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x7A"],
        ["\x94\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x5B"],

        ["\x47\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x7B"],
        ["\x94\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x5C"],

        ["\x47\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x7C"],
        ["\x94\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x5D"],

        ["\x47\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x7D"],
        ["\x94\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x5E"],

        ["\x47\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x7E"],
        ["\x94\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x5F"],

        ["\x47\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x80"],
        ["\x94\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x60"],

        ["\x47\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x81"],
        ["\x94\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x61"],

        ["\x47\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x82"],
        ["\x94\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x62"],

        ["\x47\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x83"],
        ["\x94\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x63"],

        ["\x47\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x84"],
        ["\x94\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x64"],

        ["\x47\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x85"],
        ["\x94\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x65"],

        ["\x47\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x86"],
        ["\x94\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x66"],

        ["\x47\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x87"],
        ["\x94\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x67"],

        ["\x6A\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x88"],
        ["\x94\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x24"],

        ["\x47\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x89"],
        ["\x94\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x69"],

        ["\x47\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x8A"],
        ["\x94\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x6A"],

        ["\x47\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x8B"],
        ["\x94\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x6B"],

        ["\x47\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x8C"],
        ["\x94\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x6C"],

        ["\x47\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x8D"],
        ["\x94\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x6D"],

        ["\x47\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x8E"],
        ["\x94\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x6E"],

        ["\x47\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x8F"],
        ["\x94\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x6F"],

        ["\x47\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x90"],
        ["\x94\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x70"],

        ["\x47\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x91"],
        ["\x94\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x71"],

        ["\x47\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x92"],
        ["\x94\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x72"],

        ["\x47\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x93"],
        ["\x94\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x73"],

        ["\x47\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x94"],
        ["\x94\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x74"],

        ["\x47\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x95"],
        ["\x94\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x75"],

        ["\x47\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x96"],
        ["\x94\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x76"],

        ["\x47\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x97"],
        ["\x94\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x77"],

        ["\x47\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x98"],
        ["\x94\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x78"],

        ["\x47\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x99"],
        ["\x94\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x79"],

        ["\x47\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x9A"],
        ["\x94\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x7A"],

        ["\x47\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x9B"],
        ["\x94\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x7B"],

        ["\x47\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x9C"],
        ["\x94\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x7C"],

        ["\x47\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x9D"],
        ["\x94\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x7D"],

        ["\x47\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x9E"],
        ["\x94\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x7E"],

        ["\x48\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\x9F"],
        ["\x94\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x21"],

        ["\x48\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xA0"],
        ["\x94\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x22"],

        ["\x48\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xA1"],
        ["\x94\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x23"],

        ["\x48\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xA2"],
        ["\x94\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x24"],

        ["\x48\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xA3"],
        ["\x94\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x25"],

        ["\x48\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xA4"],
        ["\x94\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x26"],

        ["\x48\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xA5"],
        ["\x94\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x27"],

        ["\x48\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xA6"],
        ["\x94\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x28"],

        ["\x48\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xA7"],
        ["\x94\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x29"],

        ["\x48\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xA8"],
        ["\x94\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x2A"],

        ["\x48\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xA9"],
        ["\x94\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x2B"],

        ["\x48\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xAA"],
        ["\x94\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x2C"],

        ["\x48\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xAB"],
        ["\x94\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x2D"],

        ["\x48\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xAC"],
        ["\x94\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x2E"],

        ["\x48\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xAD"],
        ["\x94\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x2F"],

        ["\x48\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xAE"],
        ["\x94\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x30"],

        ["\x48\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xAF"],
        ["\x94\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x31"],

        ["\x48\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xB0"],
        ["\x94\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x32"],

        ["\x48\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xB1"],
        ["\x94\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x33"],

        ["\x48\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xB2"],
        ["\x94\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x34"],

        ["\x48\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xB3"],
        ["\x94\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x35"],

        ["\x48\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xB4"],
        ["\x94\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x36"],

        ["\x48\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xB5"],
        ["\x94\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x37"],

        ["\x48\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xB6"],
        ["\x94\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x38"],

        ["\x48\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xB7"],
        ["\x94\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x39"],

        ["\x48\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xB8"],
        ["\x94\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x3A"],

        ["\x48\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xB9"],
        ["\x94\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x3B"],

        ["\x48\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xBA"],
        ["\x94\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x3C"],

        ["\x48\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xBB"],
        ["\x94\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x3D"],

        ["\x48\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xBC"],
        ["\x94\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x3E"],

        ["\x48\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xBD"],
        ["\x94\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x3F"],

        ["\x48\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xBE"],
        ["\x94\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x40"],

        ["\x48\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xBF"],
        ["\x94\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x41"],

        ["\x48\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xC0"],
        ["\x94\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x42"],

        ["\x48\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xC1"],
        ["\x94\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x43"],

        ["\x48\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xC2"],
        ["\x94\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x44"],

        ["\x48\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xC3"],
        ["\x94\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x45"],

        ["\x48\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xC4"],
        ["\x94\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x46"],

        ["\x48\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xC5"],
        ["\x94\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x47"],

        ["\x48\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xC6"],
        ["\x94\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x48"],

        ["\x48\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xC7"],
        ["\x94\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x49"],

        ["\x48\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xC8"],
        ["\x94\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x4A"],

        ["\x48\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xC9"],
        ["\x94\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x4B"],

        ["\x48\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xCA"],
        ["\x94\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x4C"],

        ["\x48\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xCB"],
        ["\x94\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x4D"],

        ["\x48\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xCC"],
        ["\x94\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x4E"],

        ["\x48\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xCD"],
        ["\x94\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x4F"],

        ["\x48\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xCE"],
        ["\x94\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x50"],

        ["\x48\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xCF"],
        ["\x94\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x51"],

        ["\x48\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xD0"],
        ["\x94\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x52"],

        ["\x48\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xD1"],
        ["\x94\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x53"],

        ["\x48\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xD2"],
        ["\x94\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x54"],

        ["\x48\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xD3"],
        ["\x94\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x55"],

        ["\x48\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xD4"],
        ["\x94\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x56"],

        ["\x48\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xD5"],
        ["\x94\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x57"],

        ["\x48\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xD6"],
        ["\x94\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x58"],

        ["\x48\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xD7"],
        ["\x94\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x59"],

        ["\x48\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xD8"],
        ["\x94\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x5A"],

        ["\x48\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xD9"],
        ["\x94\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x5B"],

        ["\x48\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xDA"],
        ["\x94\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x5C"],

        ["\x48\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xDB"],
        ["\x94\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x5D"],

        ["\x48\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xDC"],
        ["\x94\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x5E"],

        ["\x48\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xDD"],
        ["\x94\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x5F"],

        ["\x48\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xDE"],
        ["\x94\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x60"],

        ["\x48\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xDF"],
        ["\x94\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x61"],

        ["\x48\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xE0"],
        ["\x94\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x62"],

        ["\x48\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xE1"],
        ["\x94\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x63"],

        ["\x48\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xE2"],
        ["\x94\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x64"],

        ["\x48\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xE3"],
        ["\x94\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x65"],

        ["\x48\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xE4"],
        ["\x94\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x66"],

        ["\x48\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xE5"],
        ["\x94\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x67"],

        ["\x48\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xE6"],
        ["\x94\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x68"],

        ["\x48\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xE7"],
        ["\x94\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x69"],

        ["\x48\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xE8"],
        ["\x94\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x6A"],

        ["\x48\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xE9"],
        ["\x94\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x6B"],

        ["\x48\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xEA"],
        ["\x94\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x6C"],

        ["\x48\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xEB"],
        ["\x94\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x6D"],

        ["\x48\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xEC"],
        ["\x94\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x6E"],

        ["\x48\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xED"],
        ["\x94\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x6F"],

        ["\x48\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xEE"],
        ["\x94\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x70"],

        ["\x48\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xEF"],
        ["\x94\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x71"],

        ["\x48\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xF0"],
        ["\x94\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x72"],

        ["\x48\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xF1"],
        ["\x94\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x73"],

        ["\x48\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xF2"],
        ["\x94\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x74"],

        ["\x48\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xF3"],
        ["\x94\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x75"],

        ["\x48\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xF4"],
        ["\x94\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x76"],

        ["\x48\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xF5"],
        ["\x94\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x77"],

        ["\x48\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xF6"],
        ["\x94\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x78"],

        ["\x48\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xF7"],
        ["\x94\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x79"],

        ["\x48\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xF8"],
        ["\x94\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x7A"],

        ["\x48\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xF9"],
        ["\x94\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x7B"],

        ["\x48\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xFA"],
        ["\x94\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x7C"],

        ["\x48\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xFB"],
        ["\x94\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x7D"],

        ["\x48\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x94\xFC"],
        ["\x94\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x48\x7E"],

        ["\x49\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x40"],
        ["\x95\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x21"],

        ["\x49\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x41"],
        ["\x95\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x22"],

        ["\x49\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x42"],
        ["\x95\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x23"],

        ["\x49\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x43"],
        ["\x95\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x24"],

        ["\x49\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x44"],
        ["\x95\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x25"],

        ["\x49\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x45"],
        ["\x95\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x26"],

        ["\x49\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x46"],
        ["\x95\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x27"],

        ["\x49\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x47"],
        ["\x95\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x28"],

        ["\x49\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x48"],
        ["\x95\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x29"],

        ["\x49\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x49"],
        ["\x95\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x2A"],

        ["\x49\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x4A"],
        ["\x95\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x2B"],

        ["\x49\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x4B"],
        ["\x95\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x2C"],

        ["\x49\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x4C"],
        ["\x95\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x2D"],

        ["\x49\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x4D"],
        ["\x95\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x2E"],

        ["\x49\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x4E"],
        ["\x95\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x2F"],

        ["\x5B\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x4F"],
        ["\x95\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x58"],

        ["\x49\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x50"],
        ["\x95\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x31"],

        ["\x49\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x51"],
        ["\x95\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x32"],

        ["\x49\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x52"],
        ["\x95\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x33"],

        ["\x49\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x53"],
        ["\x95\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x34"],

        ["\x49\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x54"],
        ["\x95\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x35"],

        ["\x49\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x55"],
        ["\x95\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x36"],

        ["\x49\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x56"],
        ["\x95\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x37"],

        ["\x49\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x57"],
        ["\x95\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x38"],

        ["\x49\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x58"],
        ["\x95\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x39"],

        ["\x49\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x59"],
        ["\x95\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x3A"],

        ["\x49\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x5A"],
        ["\x95\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x3B"],

        ["\x49\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x5B"],
        ["\x95\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x3C"],

        ["\x49\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x5C"],
        ["\x95\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x3D"],

        ["\x49\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x5D"],
        ["\x95\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x3E"],

        ["\x49\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x5E"],
        ["\x95\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x3F"],

        ["\x49\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x5F"],
        ["\x95\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x40"],

        ["\x49\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x60"],
        ["\x95\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x41"],

        ["\x49\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x61"],
        ["\x95\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x42"],

        ["\x49\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x62"],
        ["\x95\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x43"],

        ["\x49\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x63"],
        ["\x95\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x44"],

        ["\x49\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x64"],
        ["\x95\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x45"],

        ["\x49\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x65"],
        ["\x95\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x46"],

        ["\x49\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x66"],
        ["\x95\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x47"],

        ["\x49\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x67"],
        ["\x95\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x48"],

        ["\x49\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x68"],
        ["\x95\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x49"],

        ["\x49\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x69"],
        ["\x95\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x4A"],

        ["\x49\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x6A"],
        ["\x95\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x4B"],

        ["\x49\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x6B"],
        ["\x95\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x4C"],

        ["\x49\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x6C"],
        ["\x95\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x4D"],

        ["\x49\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x6D"],
        ["\x95\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x4E"],

        ["\x49\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x6E"],
        ["\x95\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x4F"],

        ["\x49\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x6F"],
        ["\x95\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x50"],

        ["\x49\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x70"],
        ["\x95\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x51"],

        ["\x49\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x71"],
        ["\x95\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x52"],

        ["\x49\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x72"],
        ["\x95\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x53"],

        ["\x49\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x73"],
        ["\x95\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x54"],

        ["\x49\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x74"],
        ["\x95\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x55"],

        ["\x49\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x75"],
        ["\x95\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x56"],

        ["\x49\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x76"],
        ["\x95\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x57"],

        ["\x49\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x77"],
        ["\x95\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x58"],

        ["\x49\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x78"],
        ["\x95\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x59"],

        ["\x49\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x79"],
        ["\x95\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x5A"],

        ["\x49\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x7A"],
        ["\x95\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x5B"],

        ["\x49\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x7B"],
        ["\x95\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x5C"],

        ["\x49\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x7C"],
        ["\x95\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x5D"],

        ["\x49\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x7D"],
        ["\x95\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x5E"],

        ["\x49\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x7E"],
        ["\x95\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x5F"],

        ["\x49\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x80"],
        ["\x95\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x60"],

        ["\x49\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x81"],
        ["\x95\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x61"],

        ["\x49\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x82"],
        ["\x95\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x62"],

        ["\x49\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x83"],
        ["\x95\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x63"],

        ["\x49\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x84"],
        ["\x95\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x64"],

        ["\x49\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x85"],
        ["\x95\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x65"],

        ["\x49\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x86"],
        ["\x95\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x66"],

        ["\x49\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x87"],
        ["\x95\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x67"],

        ["\x49\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x88"],
        ["\x95\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x68"],

        ["\x49\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x89"],
        ["\x95\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x69"],

        ["\x49\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x8A"],
        ["\x95\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x6A"],

        ["\x49\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x8B"],
        ["\x95\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x6B"],

        ["\x49\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x8C"],
        ["\x95\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x6C"],

        ["\x49\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x8D"],
        ["\x95\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x6D"],

        ["\x49\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x8E"],
        ["\x95\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x6E"],

        ["\x49\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x8F"],
        ["\x95\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x6F"],

        ["\x49\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x90"],
        ["\x95\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x70"],

        ["\x49\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x91"],
        ["\x95\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x71"],

        ["\x49\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x92"],
        ["\x95\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x72"],

        ["\x49\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x93"],
        ["\x95\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x73"],

        ["\x49\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x94"],
        ["\x95\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x74"],

        ["\x49\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x95"],
        ["\x95\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x75"],

        ["\x49\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x96"],
        ["\x95\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x76"],

        ["\x49\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x97"],
        ["\x95\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x77"],

        ["\x49\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x98"],
        ["\x95\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x78"],

        ["\x49\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x99"],
        ["\x95\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x79"],

        ["\x49\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x9A"],
        ["\x95\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x7A"],

        ["\x49\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x9B"],
        ["\x95\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x7B"],

        ["\x49\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x9C"],
        ["\x95\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x7C"],

        ["\x49\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x9D"],
        ["\x95\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x7D"],

        ["\x49\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x9E"],
        ["\x95\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x7E"],

        ["\x4A\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\x9F"],
        ["\x95\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x21"],

        ["\x4A\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xA0"],
        ["\x95\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x22"],

        ["\x4A\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xA1"],
        ["\x95\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x23"],

        ["\x4A\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xA2"],
        ["\x95\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x24"],

        ["\x4A\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xA3"],
        ["\x95\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x25"],

        ["\x4A\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xA4"],
        ["\x95\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x26"],

        ["\x4A\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xA5"],
        ["\x95\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x27"],

        ["\x4A\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xA6"],
        ["\x95\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x28"],

        ["\x4A\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xA7"],
        ["\x95\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x29"],

        ["\x4A\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xA8"],
        ["\x95\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x2A"],

        ["\x4A\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xA9"],
        ["\x95\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x2B"],

        ["\x4A\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xAA"],
        ["\x95\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x2C"],

        ["\x4A\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xAB"],
        ["\x95\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x2D"],

        ["\x4A\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xAC"],
        ["\x95\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x2E"],

        ["\x4A\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xAD"],
        ["\x95\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x2F"],

        ["\x4A\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xAE"],
        ["\x95\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x30"],

        ["\x4A\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xAF"],
        ["\x95\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x31"],

        ["\x4A\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xB0"],
        ["\x95\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x32"],

        ["\x4A\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xB1"],
        ["\x95\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x33"],

        ["\x4A\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xB2"],
        ["\x95\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x34"],

        ["\x4A\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xB3"],
        ["\x95\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x35"],

        ["\x4A\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xB4"],
        ["\x95\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x36"],

        ["\x4A\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xB5"],
        ["\x95\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x37"],

        ["\x4A\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xB6"],
        ["\x95\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x38"],

        ["\x4A\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xB7"],
        ["\x95\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x39"],

        ["\x4A\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xB8"],
        ["\x95\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x3A"],

        ["\x4A\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xB9"],
        ["\x95\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x3B"],

        ["\x4A\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xBA"],
        ["\x95\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x3C"],

        ["\x4A\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xBB"],
        ["\x95\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x3D"],

        ["\x4A\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xBC"],
        ["\x95\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x3E"],

        ["\x4A\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xBD"],
        ["\x95\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x3F"],

        ["\x4A\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xBE"],
        ["\x95\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x40"],

        ["\x4A\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xBF"],
        ["\x95\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x41"],

        ["\x4A\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xC0"],
        ["\x95\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x42"],

        ["\x4A\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xC1"],
        ["\x95\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x43"],

        ["\x4A\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xC2"],
        ["\x95\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x44"],

        ["\x4A\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xC3"],
        ["\x95\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x45"],

        ["\x4A\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xC4"],
        ["\x95\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x46"],

        ["\x4A\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xC5"],
        ["\x95\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x47"],

        ["\x4A\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xC6"],
        ["\x95\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x48"],

        ["\x4A\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xC7"],
        ["\x95\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x49"],

        ["\x4A\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xC8"],
        ["\x95\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x4A"],

        ["\x4A\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xC9"],
        ["\x95\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x4B"],

        ["\x4A\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xCA"],
        ["\x95\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x4C"],

        ["\x4A\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xCB"],
        ["\x95\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x4D"],

        ["\x4A\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xCC"],
        ["\x95\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x4E"],

        ["\x4A\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xCD"],
        ["\x95\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x4F"],

        ["\x4A\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xCE"],
        ["\x95\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x50"],

        ["\x4A\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xCF"],
        ["\x95\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x51"],

        ["\x4A\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xD0"],
        ["\x95\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x52"],

        ["\x4A\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xD1"],
        ["\x95\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x53"],

        ["\x4A\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xD2"],
        ["\x95\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x54"],

        ["\x4A\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xD3"],
        ["\x95\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x55"],

        ["\x4A\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xD4"],
        ["\x95\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x56"],

        ["\x4A\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xD5"],
        ["\x95\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x57"],

        ["\x4A\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xD6"],
        ["\x95\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x58"],

        ["\x4A\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xD7"],
        ["\x95\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x59"],

        ["\x4A\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xD8"],
        ["\x95\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x5A"],

        ["\x4A\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xD9"],
        ["\x95\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x5B"],

        ["\x4A\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xDA"],
        ["\x95\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x5C"],

        ["\x4A\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xDB"],
        ["\x95\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x5D"],

        ["\x4A\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xDC"],
        ["\x95\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x5E"],

        ["\x4A\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xDD"],
        ["\x95\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x5F"],

        ["\x4A\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xDE"],
        ["\x95\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x60"],

        ["\x4A\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xDF"],
        ["\x95\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x61"],

        ["\x4A\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xE0"],
        ["\x95\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x62"],

        ["\x4A\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xE1"],
        ["\x95\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x63"],

        ["\x4A\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xE2"],
        ["\x95\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x64"],

        ["\x4A\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xE3"],
        ["\x95\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x65"],

        ["\x4A\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xE4"],
        ["\x95\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x66"],

        ["\x4A\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xE5"],
        ["\x95\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x67"],

        ["\x4A\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xE6"],
        ["\x95\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x68"],

        ["\x4A\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xE7"],
        ["\x95\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x69"],

        ["\x4A\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xE8"],
        ["\x95\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x6A"],

        ["\x4A\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xE9"],
        ["\x95\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x6B"],

        ["\x4A\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xEA"],
        ["\x95\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x6C"],

        ["\x4A\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xEB"],
        ["\x95\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x6D"],

        ["\x4A\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xEC"],
        ["\x95\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x6E"],

        ["\x4A\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xED"],
        ["\x95\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x6F"],

        ["\x4A\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xEE"],
        ["\x95\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x70"],

        ["\x4A\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xEF"],
        ["\x95\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x71"],

        ["\x4A\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xF0"],
        ["\x95\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x72"],

        ["\x4A\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xF1"],
        ["\x95\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x73"],

        ["\x4A\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xF2"],
        ["\x95\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x74"],

        ["\x4A\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xF3"],
        ["\x95\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x75"],

        ["\x4A\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xF4"],
        ["\x95\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x76"],

        ["\x4A\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xF5"],
        ["\x95\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x77"],

        ["\x4A\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xF6"],
        ["\x95\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x78"],

        ["\x4A\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xF7"],
        ["\x95\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x79"],

        ["\x4A\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xF8"],
        ["\x95\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x7A"],

        ["\x4A\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xF9"],
        ["\x95\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x7B"],

        ["\x4A\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xFA"],
        ["\x95\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x7C"],

        ["\x4A\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xFB"],
        ["\x95\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x7D"],

        ["\x4A\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x95\xFC"],
        ["\x95\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4A\x7E"],

        ["\x4B\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x40"],
        ["\x96\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x21"],

        ["\x4B\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x41"],
        ["\x96\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x22"],

        ["\x4B\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x42"],
        ["\x96\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x23"],

        ["\x4B\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x43"],
        ["\x96\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x24"],

        ["\x4B\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x44"],
        ["\x96\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x25"],

        ["\x4B\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x45"],
        ["\x96\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x26"],

        ["\x4B\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x46"],
        ["\x96\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x27"],

        ["\x4B\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x47"],
        ["\x96\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x28"],

        ["\x4B\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x48"],
        ["\x96\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x29"],

        ["\x4B\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x49"],
        ["\x96\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x2A"],

        ["\x4B\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x4A"],
        ["\x96\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x2B"],

        ["\x4B\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x4B"],
        ["\x96\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x2C"],

        ["\x4B\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x4C"],
        ["\x96\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x2D"],

        ["\x4B\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x4D"],
        ["\x96\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x2E"],

        ["\x4B\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x4E"],
        ["\x96\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x2F"],

        ["\x4B\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x4F"],
        ["\x96\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x30"],

        ["\x4B\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x50"],
        ["\x96\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x31"],

        ["\x4B\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x51"],
        ["\x96\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x32"],

        ["\x4B\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x52"],
        ["\x96\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x33"],

        ["\x4B\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x53"],
        ["\x96\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x34"],

        ["\x4B\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x54"],
        ["\x96\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x35"],

        ["\x4B\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x55"],
        ["\x96\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x36"],

        ["\x4B\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x56"],
        ["\x96\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x37"],

        ["\x4B\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x57"],
        ["\x96\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x38"],

        ["\x4B\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x58"],
        ["\x96\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x39"],

        ["\x4B\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x59"],
        ["\x96\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x3A"],

        ["\x4B\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x5A"],
        ["\x96\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x3B"],

        ["\x4B\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x5B"],
        ["\x96\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x3C"],

        ["\x4B\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x5C"],
        ["\x96\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x3D"],

        ["\x4B\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x5D"],
        ["\x96\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x3E"],

        ["\x4B\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x5E"],
        ["\x96\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x3F"],

        ["\x4B\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x5F"],
        ["\x96\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x40"],

        ["\x4B\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x60"],
        ["\x96\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x41"],

        ["\x4B\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x61"],
        ["\x96\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x42"],

        ["\x4B\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x62"],
        ["\x96\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x43"],

        ["\x4B\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x63"],
        ["\x96\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x44"],

        ["\x4B\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x64"],
        ["\x96\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x45"],

        ["\x4B\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x65"],
        ["\x96\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x46"],

        ["\x4B\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x66"],
        ["\x96\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x47"],

        ["\x4B\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x67"],
        ["\x96\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x48"],

        ["\x4B\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x68"],
        ["\x96\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x49"],

        ["\x4B\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x69"],
        ["\x96\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x4A"],

        ["\x4B\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x6A"],
        ["\x96\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x4B"],

        ["\x4B\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x6B"],
        ["\x96\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x4C"],

        ["\x4B\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x6C"],
        ["\x96\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x4D"],

        ["\x4B\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x6D"],
        ["\x96\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x4E"],

        ["\x4B\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x6E"],
        ["\x96\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x4F"],

        ["\x4B\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x6F"],
        ["\x96\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x50"],

        ["\x4B\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x70"],
        ["\x96\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x51"],

        ["\x4B\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x71"],
        ["\x96\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x52"],

        ["\x4B\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x72"],
        ["\x96\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x53"],

        ["\x4B\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x73"],
        ["\x96\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x54"],

        ["\x4B\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x74"],
        ["\x96\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x55"],

        ["\x4B\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x75"],
        ["\x96\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x56"],

        ["\x4B\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x76"],
        ["\x96\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x57"],

        ["\x4B\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x77"],
        ["\x96\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x58"],

        ["\x4B\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x78"],
        ["\x96\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x59"],

        ["\x4B\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x79"],
        ["\x96\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x5A"],

        ["\x4B\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x7A"],
        ["\x96\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x5B"],

        ["\x4B\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x7B"],
        ["\x96\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x5C"],

        ["\x4B\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x7C"],
        ["\x96\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x5D"],

        ["\x4B\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x7D"],
        ["\x96\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x5E"],

        ["\x4B\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x7E"],
        ["\x96\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x5F"],

        ["\x4B\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x80"],
        ["\x96\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x60"],

        ["\x4B\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x81"],
        ["\x96\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x61"],

        ["\x4B\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x82"],
        ["\x96\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x62"],

        ["\x4B\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x83"],
        ["\x96\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x63"],

        ["\x4B\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x84"],
        ["\x96\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x64"],

        ["\x4B\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x85"],
        ["\x96\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x65"],

        ["\x4B\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x86"],
        ["\x96\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x66"],

        ["\x4B\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x87"],
        ["\x96\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x67"],

        ["\x4B\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x88"],
        ["\x96\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x68"],

        ["\x4B\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x89"],
        ["\x96\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x69"],

        ["\xBF\xCE",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x8A"],
        ["\x96\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xBF\xCE"],

        ["\x4B\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x8B"],
        ["\x96\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x6B"],

        ["\x4B\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x8C"],
        ["\x96\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x6C"],

        ["\x4B\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x8D"],
        ["\x96\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x6D"],

        ["\x4B\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x8E"],
        ["\x96\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x6E"],

        ["\x4B\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x8F"],
        ["\x96\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x6F"],

        ["\x4B\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x90"],
        ["\x96\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x70"],

        ["\x4B\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x91"],
        ["\x96\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x71"],

        ["\x4B\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x92"],
        ["\x96\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x72"],

        ["\x4B\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x93"],
        ["\x96\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x73"],

        ["\x4B\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x94"],
        ["\x96\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x74"],

        ["\x4B\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x95"],
        ["\x96\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x75"],

        ["\x4B\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x96"],
        ["\x96\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x76"],

        ["\x4B\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x97"],
        ["\x96\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x77"],

        ["\x4B\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x98"],
        ["\x96\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x78"],

        ["\x50\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x99"],
        ["\x96\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x56"],

        ["\x4B\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x9A"],
        ["\x96\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x7A"],

        ["\x4B\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x9B"],
        ["\x96\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x7B"],

        ["\x4B\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x9C"],
        ["\x96\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x7C"],

        ["\x4B\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x9D"],
        ["\x96\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x7D"],

        ["\x4B\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x9E"],
        ["\x96\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x7E"],

        ["\x4C\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\x9F"],
        ["\x96\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x21"],

        ["\x4C\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xA0"],
        ["\x96\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x22"],

        ["\x4C\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xA1"],
        ["\x96\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x23"],

        ["\x4C\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xA2"],
        ["\x96\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x24"],

        ["\x4C\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xA3"],
        ["\x96\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x25"],

        ["\x4C\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xA4"],
        ["\x96\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x26"],

        ["\x4C\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xA5"],
        ["\x96\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x27"],

        ["\x4C\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xA6"],
        ["\x96\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x28"],

        ["\x4C\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xA7"],
        ["\x96\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x29"],

        ["\x4C\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xA8"],
        ["\x96\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x2A"],

        ["\x4C\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xA9"],
        ["\x96\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x2B"],

        ["\x4C\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xAA"],
        ["\x96\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x2C"],

        ["\x4C\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xAB"],
        ["\x96\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x2D"],

        ["\x4C\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xAC"],
        ["\x96\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x2E"],

        ["\x4C\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xAD"],
        ["\x96\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x2F"],

        ["\x4C\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xAE"],
        ["\x96\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x30"],

        ["\x4C\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xAF"],
        ["\x96\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x31"],

        ["\x4C\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xB0"],
        ["\x96\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x32"],

        ["\x4C\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xB1"],
        ["\x96\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x33"],

        ["\x4C\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xB2"],
        ["\x96\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x34"],

        ["\x4C\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xB3"],
        ["\x96\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x35"],

        ["\x4C\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xB4"],
        ["\x96\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x36"],

        ["\x4C\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xB5"],
        ["\x96\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x37"],

        ["\x4C\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xB6"],
        ["\x96\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x38"],

        ["\x4C\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xB7"],
        ["\x96\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x39"],

        ["\x4C\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xB8"],
        ["\x96\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x3A"],

        ["\x4C\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xB9"],
        ["\x96\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x3B"],

        ["\x4C\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xBA"],
        ["\x96\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x3C"],

        ["\x4C\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xBB"],
        ["\x96\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x3D"],

        ["\x4C\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xBC"],
        ["\x96\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x3E"],

        ["\x4C\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xBD"],
        ["\x96\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x3F"],

        ["\x4C\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xBE"],
        ["\x96\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x40"],

        ["\x4C\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xBF"],
        ["\x96\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x41"],

        ["\x4C\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xC0"],
        ["\x96\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x42"],

        ["\x4C\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xC1"],
        ["\x96\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x43"],

        ["\x4C\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xC2"],
        ["\x96\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x44"],

        ["\x4C\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xC3"],
        ["\x96\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x45"],

        ["\x4C\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xC4"],
        ["\x96\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x46"],

        ["\x4C\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xC5"],
        ["\x96\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x47"],

        ["\x4C\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xC6"],
        ["\x96\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x48"],

        ["\x4C\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xC7"],
        ["\x96\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x49"],

        ["\x4C\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xC8"],
        ["\x96\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x4A"],

        ["\x4C\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xC9"],
        ["\x96\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x4B"],

        ["\x4C\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xCA"],
        ["\x96\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x4C"],

        ["\x4C\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xCB"],
        ["\x96\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x4D"],

        ["\x4C\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xCC"],
        ["\x96\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x4E"],

        ["\x4C\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xCD"],
        ["\x96\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x4F"],

        ["\x4C\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xCE"],
        ["\x96\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x50"],

        ["\x4C\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xCF"],
        ["\x96\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x51"],

        ["\x4C\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xD0"],
        ["\x96\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x52"],

        ["\x4C\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xD1"],
        ["\x96\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x53"],

        ["\x4C\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xD2"],
        ["\x96\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x54"],

        ["\x4C\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xD3"],
        ["\x96\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x55"],

        ["\x4C\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xD4"],
        ["\x96\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x56"],

        ["\x4C\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xD5"],
        ["\x96\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x57"],

        ["\x4C\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xD6"],
        ["\x96\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x58"],

        ["\x4C\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xD7"],
        ["\x96\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x59"],

        ["\x4C\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xD8"],
        ["\x96\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x5A"],

        ["\x4C\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xD9"],
        ["\x96\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x5B"],

        ["\x4C\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xDA"],
        ["\x96\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x5C"],

        ["\x4C\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xDB"],
        ["\x96\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x5D"],

        ["\x4C\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xDC"],
        ["\x96\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x5E"],

        ["\x4C\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xDD"],
        ["\x96\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x5F"],

        ["\x4C\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xDE"],
        ["\x96\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x60"],

        ["\x4C\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xDF"],
        ["\x96\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x61"],

        ["\x4C\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xE0"],
        ["\x96\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x62"],

        ["\x4C\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xE1"],
        ["\x96\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x63"],

        ["\x4C\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xE2"],
        ["\x96\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x64"],

        ["\x4C\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xE3"],
        ["\x96\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x65"],

        ["\x4C\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xE4"],
        ["\x96\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x66"],

        ["\x4C\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xE5"],
        ["\x96\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x67"],

        ["\x4C\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xE6"],
        ["\x96\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x68"],

        ["\x4C\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xE7"],
        ["\x96\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x69"],

        ["\x4C\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xE8"],
        ["\x96\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x6A"],

        ["\x4C\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xE9"],
        ["\x96\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x6B"],

        ["\x4C\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xEA"],
        ["\x96\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x6C"],

        ["\x4C\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xEB"],
        ["\x96\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x6D"],

        ["\x4C\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xEC"],
        ["\x96\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x6E"],

        ["\x4C\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xED"],
        ["\x96\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x6F"],

        ["\x4C\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xEE"],
        ["\x96\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x70"],

        ["\x4C\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xEF"],
        ["\x96\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x71"],

        ["\x4C\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xF0"],
        ["\x96\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x72"],

        ["\x4C\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xF1"],
        ["\x96\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x73"],

        ["\x4C\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xF2"],
        ["\x96\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x74"],

        ["\x4C\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xF3"],
        ["\x96\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x75"],

        ["\x4C\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xF4"],
        ["\x96\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x76"],

        ["\x4C\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xF5"],
        ["\x96\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x77"],

        ["\x4C\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xF6"],
        ["\x96\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x78"],

        ["\x69\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xF7"],
        ["\x96\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x2E"],

        ["\x4C\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xF8"],
        ["\x96\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x7A"],

        ["\x4C\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xF9"],
        ["\x96\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x7B"],

        ["\x4C\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xFA"],
        ["\x96\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x7C"],

        ["\x4C\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xFB"],
        ["\x96\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x7D"],

        ["\x4C\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x96\xFC"],
        ["\x96\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x7E"],

        ["\x4D\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x40"],
        ["\x97\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x21"],

        ["\x4D\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x41"],
        ["\x97\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x22"],

        ["\x4D\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x42"],
        ["\x97\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x23"],

        ["\x4D\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x43"],
        ["\x97\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x24"],

        ["\x4D\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x44"],
        ["\x97\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x25"],

        ["\x4D\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x45"],
        ["\x97\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x26"],

        ["\x4D\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x46"],
        ["\x97\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x27"],

        ["\x4D\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x47"],
        ["\x97\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x28"],

        ["\x4D\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x48"],
        ["\x97\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x29"],

        ["\x4D\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x49"],
        ["\x97\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x2A"],

        ["\x4D\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x4A"],
        ["\x97\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x2B"],

        ["\x4D\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x4B"],
        ["\x97\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x2C"],

        ["\x4D\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x4C"],
        ["\x97\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x2D"],

        ["\x4D\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x4D"],
        ["\x97\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x2E"],

        ["\x4D\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x4E"],
        ["\x97\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x2F"],

        ["\x4D\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x4F"],
        ["\x97\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x30"],

        ["\x4D\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x50"],
        ["\x97\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x31"],

        ["\x4D\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x51"],
        ["\x97\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x32"],

        ["\x4D\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x52"],
        ["\x97\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x33"],

        ["\x4D\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x53"],
        ["\x97\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x34"],

        ["\x4D\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x54"],
        ["\x97\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x35"],

        ["\x4D\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x55"],
        ["\x97\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x36"],

        ["\x4D\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x56"],
        ["\x97\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x37"],

        ["\x4D\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x57"],
        ["\x97\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x38"],

        ["\x4D\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x58"],
        ["\x97\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x39"],

        ["\x4D\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x59"],
        ["\x97\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x3A"],

        ["\x4D\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x5A"],
        ["\x97\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x3B"],

        ["\x4D\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x5B"],
        ["\x97\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x3C"],

        ["\x4D\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x5C"],
        ["\x97\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x3D"],

        ["\x4D\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x5D"],
        ["\x97\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x3E"],

        ["\x4D\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x5E"],
        ["\x97\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x3F"],

        ["\x4D\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x5F"],
        ["\x97\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x40"],

        ["\x4D\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x60"],
        ["\x97\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x41"],

        ["\x4D\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x61"],
        ["\x97\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x42"],

        ["\x4D\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x62"],
        ["\x97\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x43"],

        ["\x4D\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x63"],
        ["\x97\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x44"],

        ["\x4D\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x64"],
        ["\x97\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x45"],

        ["\x4D\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x65"],
        ["\x97\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x46"],

        ["\x4D\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x66"],
        ["\x97\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x47"],

        ["\x4D\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x67"],
        ["\x97\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x48"],

        ["\x4D\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x68"],
        ["\x97\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x49"],

        ["\x4D\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x69"],
        ["\x97\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x4A"],

        ["\x4D\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x6A"],
        ["\x97\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x4B"],

        ["\x4D\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x6B"],
        ["\x97\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x4C"],

        ["\x4D\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x6C"],
        ["\x97\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x4D"],

        ["\x4D\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x6D"],
        ["\x97\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x4E"],

        ["\x4D\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x6E"],
        ["\x97\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x4F"],

        ["\x4D\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x6F"],
        ["\x97\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x50"],

        ["\x4D\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x70"],
        ["\x97\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x51"],

        ["\x4D\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x71"],
        ["\x97\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x52"],

        ["\x4D\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x72"],
        ["\x97\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x53"],

        ["\x4D\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x73"],
        ["\x97\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x54"],

        ["\x4D\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x74"],
        ["\x97\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x55"],

        ["\x4D\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x75"],
        ["\x97\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x56"],

        ["\x4D\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x76"],
        ["\x97\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x57"],

        ["\x4D\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x77"],
        ["\x97\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x58"],

        ["\x4D\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x78"],
        ["\x97\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x59"],

        ["\xD0\xC4",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x79"],
        ["\x97\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xD0\xC4"],

        ["\x4D\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x7A"],
        ["\x97\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x5B"],

        ["\x4D\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x7B"],
        ["\x97\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x5C"],

        ["\x4D\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x7C"],
        ["\x97\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x5D"],

        ["\x4D\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x7D"],
        ["\x97\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x5E"],

        ["\x4D\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x7E"],
        ["\x97\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x5F"],

        ["\x4D\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x80"],
        ["\x97\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x60"],

        ["\x4D\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x81"],
        ["\x97\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x61"],

        ["\x4D\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x82"],
        ["\x97\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x62"],

        ["\x4D\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x83"],
        ["\x97\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x63"],

        ["\x4D\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x84"],
        ["\x97\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x64"],

        ["\x4D\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x85"],
        ["\x97\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x65"],

        ["\x4D\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x86"],
        ["\x97\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x66"],

        ["\x4D\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x87"],
        ["\x97\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x67"],

        ["\x4D\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x88"],
        ["\x97\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x68"],

        ["\x4D\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x89"],
        ["\x97\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x69"],

        ["\x4D\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x8A"],
        ["\x97\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x6A"],

        ["\x4D\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x8B"],
        ["\x97\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x6B"],

        ["\x4D\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x8C"],
        ["\x97\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x6C"],

        ["\x4D\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x8D"],
        ["\x97\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x6D"],

        ["\x4D\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x8E"],
        ["\x97\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x6E"],

        ["\x4D\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x8F"],
        ["\x97\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x6F"],

        ["\x4D\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x90"],
        ["\x97\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x70"],

        ["\x4D\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x91"],
        ["\x97\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x71"],

        ["\x4D\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x92"],
        ["\x97\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x72"],

        ["\x4D\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x93"],
        ["\x97\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x73"],

        ["\x4D\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x94"],
        ["\x97\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x74"],

        ["\x4D\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x95"],
        ["\x97\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x75"],

        ["\x4D\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x96"],
        ["\x97\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x76"],

        ["\x4D\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x97"],
        ["\x97\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x77"],

        ["\x4D\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x98"],
        ["\x97\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x78"],

        ["\x4D\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x99"],
        ["\x97\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x79"],

        ["\x4D\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x9A"],
        ["\x97\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x7A"],

        ["\x4D\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x9B"],
        ["\x97\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x7B"],

        ["\x4D\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x9C"],
        ["\x97\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x7C"],

        ["\x4D\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x9D"],
        ["\x97\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x7D"],

        ["\x4D\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x9E"],
        ["\x97\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4D\x7E"],

        ["\x4E\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\x9F"],
        ["\x97\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x21"],

        ["\x4E\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xA0"],
        ["\x97\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x22"],

        ["\x4E\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xA1"],
        ["\x97\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x23"],

        ["\x4E\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xA2"],
        ["\x97\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x24"],

        ["\x4E\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xA3"],
        ["\x97\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x25"],

        ["\x4E\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xA4"],
        ["\x97\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x26"],

        ["\x4E\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xA5"],
        ["\x97\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x27"],

        ["\x4E\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xA6"],
        ["\x97\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x28"],

        ["\x4E\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xA7"],
        ["\x97\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x29"],

        ["\x4E\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xA8"],
        ["\x97\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x2A"],

        ["\x4E\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xA9"],
        ["\x97\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x2B"],

        ["\x4E\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xAA"],
        ["\x97\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x2C"],

        ["\x4E\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xAB"],
        ["\x97\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x2D"],

        ["\x4E\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xAC"],
        ["\x97\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x2E"],

        ["\x4E\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xAD"],
        ["\x97\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x2F"],

        ["\x4E\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xAE"],
        ["\x97\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x30"],

        ["\x4E\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xAF"],
        ["\x97\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x31"],

        ["\x4E\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xB0"],
        ["\x97\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x32"],

        ["\x4E\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xB1"],
        ["\x97\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x33"],

        ["\x4E\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xB2"],
        ["\x97\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x34"],

        ["\x4E\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xB3"],
        ["\x97\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x35"],

        ["\x4E\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xB4"],
        ["\x97\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x36"],

        ["\x4E\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xB5"],
        ["\x97\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x37"],

        ["\x4E\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xB6"],
        ["\x97\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x38"],

        ["\x4E\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xB7"],
        ["\x97\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x39"],

        ["\x4E\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xB8"],
        ["\x97\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x3A"],

        ["\x4E\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xB9"],
        ["\x97\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x3B"],

        ["\x4E\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xBA"],
        ["\x97\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x3C"],

        ["\x4E\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xBB"],
        ["\x97\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x3D"],

        ["\x4E\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xBC"],
        ["\x97\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x3E"],

        ["\x4E\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xBD"],
        ["\x97\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x3F"],

        ["\x4E\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xBE"],
        ["\x97\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x40"],

        ["\x4E\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xBF"],
        ["\x97\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x41"],

        ["\x4E\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xC0"],
        ["\x97\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x42"],

        ["\x4E\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xC1"],
        ["\x97\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x43"],

        ["\x4E\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xC2"],
        ["\x97\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x44"],

        ["\x4E\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xC3"],
        ["\x97\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x45"],

        ["\x4E\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xC4"],
        ["\x97\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x46"],

        ["\x4E\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xC5"],
        ["\x97\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x47"],

        ["\x4E\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xC6"],
        ["\x97\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x48"],

        ["\x4E\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xC7"],
        ["\x97\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x49"],

        ["\x4E\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xC8"],
        ["\x97\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x4A"],

        ["\x4E\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xC9"],
        ["\x97\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x4B"],

        ["\x4E\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xCA"],
        ["\x97\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x4C"],

        ["\x4E\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xCB"],
        ["\x97\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x4D"],

        ["\x4E\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xCC"],
        ["\x97\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x4E"],

        ["\x4E\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xCD"],
        ["\x97\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x4F"],

        ["\x4E\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xCE"],
        ["\x97\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x50"],

        ["\x4E\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xCF"],
        ["\x97\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x51"],

        ["\x4E\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xD0"],
        ["\x97\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x52"],

        ["\x4E\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xD1"],
        ["\x97\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x53"],

        ["\x4E\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xD2"],
        ["\x97\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x54"],

        ["\x4E\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xD3"],
        ["\x97\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x55"],

        ["\x4E\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xD4"],
        ["\x97\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x56"],

        ["\x4E\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xD5"],
        ["\x97\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x57"],

        ["\x4E\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xD6"],
        ["\x97\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x58"],

        ["\x4E\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xD7"],
        ["\x97\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x59"],

        ["\x4E\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xD8"],
        ["\x97\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x5A"],

        ["\x4E\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xD9"],
        ["\x97\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x5B"],

        ["\x4E\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xDA"],
        ["\x97\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x5C"],

        ["\x4E\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xDB"],
        ["\x97\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x5D"],

        ["\x4E\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xDC"],
        ["\x97\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x5E"],

        ["\x4E\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xDD"],
        ["\x97\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x5F"],

        ["\x4E\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xDE"],
        ["\x97\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x60"],

        ["\x4E\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xDF"],
        ["\x97\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x61"],

        ["\x4E\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xE0"],
        ["\x97\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x62"],

        ["\x4E\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xE1"],
        ["\x97\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x63"],

        ["\x4E\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xE2"],
        ["\x97\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x64"],

        ["\x4E\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xE3"],
        ["\x97\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x65"],

        ["\x4E\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xE4"],
        ["\x97\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x66"],

        ["\x4E\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xE5"],
        ["\x97\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x67"],

        ["\x4E\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xE6"],
        ["\x97\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x68"],

        ["\x4E\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xE7"],
        ["\x97\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x69"],

        ["\x4E\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xE8"],
        ["\x97\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x6A"],

        ["\x4E\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xE9"],
        ["\x97\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x6B"],

        ["\x4E\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xEA"],
        ["\x97\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x6C"],

        ["\x4E\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xEB"],
        ["\x97\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x6D"],

        ["\x4E\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xEC"],
        ["\x97\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x6E"],

        ["\x4E\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xED"],
        ["\x97\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x6F"],

        ["\x4E\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xEE"],
        ["\x97\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x70"],

        ["\x4E\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xEF"],
        ["\x97\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x71"],

        ["\x4E\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xF0"],
        ["\x97\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x72"],

        ["\x4E\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xF1"],
        ["\x97\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x73"],

        ["\x4E\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xF2"],
        ["\x97\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x74"],

        ["\x4E\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xF3"],
        ["\x97\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x75"],

        ["\x4E\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xF4"],
        ["\x97\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x76"],

        ["\x4E\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xF5"],
        ["\x97\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x77"],

        ["\x4E\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xF6"],
        ["\x97\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x78"],

        ["\x4E\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xF7"],
        ["\x97\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x79"],

        ["\x4E\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xF8"],
        ["\x97\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x7A"],

        ["\x4E\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xF9"],
        ["\x97\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x7B"],

        ["\x4E\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xFA"],
        ["\x97\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x7C"],

        ["\x4E\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xFB"],
        ["\x97\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x7D"],

        ["\x4E\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x97\xFC"],
        ["\x97\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4E\x7E"],

        ["\x4F\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x40"],
        ["\x98\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x21"],

        ["\x4F\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x41"],
        ["\x98\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x22"],

        ["\x4F\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x42"],
        ["\x98\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x23"],

        ["\x4F\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x43"],
        ["\x98\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x24"],

        ["\x4F\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x44"],
        ["\x98\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x25"],

        ["\x4F\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x45"],
        ["\x98\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x26"],

        ["\x4F\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x46"],
        ["\x98\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x27"],

        ["\x4F\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x47"],
        ["\x98\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x28"],

        ["\x4F\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x48"],
        ["\x98\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x29"],

        ["\x4F\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x49"],
        ["\x98\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x2A"],

        ["\x4F\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x4A"],
        ["\x98\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x2B"],

        ["\x4F\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x4B"],
        ["\x98\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x2C"],

        ["\x4F\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x4C"],
        ["\x98\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x2D"],

        ["\x4F\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x4D"],
        ["\x98\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x2E"],

        ["\x4F\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x4E"],
        ["\x98\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x2F"],

        ["\x4F\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x4F"],
        ["\x98\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x30"],

        ["\x4F\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x50"],
        ["\x98\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x31"],

        ["\x4F\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x51"],
        ["\x98\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x32"],

        ["\x4F\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x52"],
        ["\x98\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x33"],

        ["\x4F\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x53"],
        ["\x98\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x34"],

        ["\x4F\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x54"],
        ["\x98\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x35"],

        ["\x64\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x55"],
        ["\x98\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x46"],

        ["\x4F\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x56"],
        ["\x98\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x37"],

        ["\x4F\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x57"],
        ["\x98\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x38"],

        ["\x4F\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x58"],
        ["\x98\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x39"],

        ["\x4F\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x59"],
        ["\x98\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x3A"],

        ["\x4F\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x5A"],
        ["\x98\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x3B"],

        ["\x4F\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x5B"],
        ["\x98\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x3C"],

        ["\x4F\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x5C"],
        ["\x98\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x3D"],

        ["\x4F\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x5D"],
        ["\x98\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x3E"],

        ["\x4F\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x5E"],
        ["\x98\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x3F"],

        ["\x4F\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x5F"],
        ["\x98\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x40"],

        ["\x4F\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x60"],
        ["\x98\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x41"],

        ["\x4F\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x61"],
        ["\x98\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x42"],

        ["\x4F\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x62"],
        ["\x98\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x43"],

        ["\x4F\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x63"],
        ["\x98\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x44"],

        ["\x4F\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x64"],
        ["\x98\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x45"],

        ["\x4F\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x65"],
        ["\x98\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x46"],

        ["\x4F\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x66"],
        ["\x98\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x47"],

        ["\x4F\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x67"],
        ["\x98\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x48"],

        ["\x4F\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x68"],
        ["\x98\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x49"],

        ["\x4F\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x69"],
        ["\x98\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x4A"],

        ["\x4F\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x6A"],
        ["\x98\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x4B"],

        ["\x4F\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x6B"],
        ["\x98\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x4C"],

        ["\x4F\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x6C"],
        ["\x98\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x4D"],

        ["\x4F\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x6D"],
        ["\x98\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x4E"],

        ["\x4F\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x6E"],
        ["\x98\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x4F"],

        ["\x4F\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x6F"],
        ["\x98\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x50"],

        ["\x4F\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x70"],
        ["\x98\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x51"],

        ["\x4F\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x71"],
        ["\x98\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x52"],

        ["\x4F\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x72"],
        ["\x98\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x53"],

        ["\x50\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\x9F"],
        ["\x98\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x21"],

        ["\x50\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xA0"],
        ["\x98\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x22"],

        ["\x50\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xA1"],
        ["\x98\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x23"],

        ["\x50\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xA2"],
        ["\x98\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x24"],

        ["\x50\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xA3"],
        ["\x98\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x25"],

        ["\x50\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xA4"],
        ["\x98\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x26"],

        ["\x50\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xA5"],
        ["\x98\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x27"],

        ["\x50\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xA6"],
        ["\x98\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x28"],

        ["\x50\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xA7"],
        ["\x98\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x29"],

        ["\x50\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xA8"],
        ["\x98\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x2A"],

        ["\x50\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xA9"],
        ["\x98\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x2B"],

        ["\x50\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xAA"],
        ["\x98\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x2C"],

        ["\x50\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xAB"],
        ["\x98\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x2D"],

        ["\x50\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xAC"],
        ["\x98\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x2E"],

        ["\x50\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xAD"],
        ["\x98\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x2F"],

        ["\x50\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xAE"],
        ["\x98\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x30"],

        ["\x50\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xAF"],
        ["\x98\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x31"],

        ["\x50\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xB0"],
        ["\x98\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x32"],

        ["\x50\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xB1"],
        ["\x98\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x33"],

        ["\x50\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xB2"],
        ["\x98\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x34"],

        ["\x50\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xB3"],
        ["\x98\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x35"],

        ["\x50\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xB4"],
        ["\x98\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x36"],

        ["\x50\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xB5"],
        ["\x98\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x37"],

        ["\x50\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xB6"],
        ["\x98\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x38"],

        ["\x50\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xB7"],
        ["\x98\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x39"],

        ["\x50\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xB8"],
        ["\x98\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x3A"],

        ["\x50\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xB9"],
        ["\x98\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x3B"],

        ["\x50\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xBA"],
        ["\x98\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x3C"],

        ["\x50\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xBB"],
        ["\x98\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x3D"],

        ["\x50\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xBC"],
        ["\x98\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x3E"],

        ["\x50\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xBD"],
        ["\x98\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x3F"],

        ["\x50\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xBE"],
        ["\x98\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x40"],

        ["\x50\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xBF"],
        ["\x98\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x41"],

        ["\x50\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xC0"],
        ["\x98\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x42"],

        ["\x50\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xC1"],
        ["\x98\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x43"],

        ["\x50\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xC2"],
        ["\x98\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x44"],

        ["\x50\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xC3"],
        ["\x98\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x45"],

        ["\x50\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xC4"],
        ["\x98\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x46"],

        ["\x50\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xC5"],
        ["\x98\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x47"],

        ["\x50\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xC6"],
        ["\x98\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x48"],

        ["\x50\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xC7"],
        ["\x98\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x49"],

        ["\x50\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xC8"],
        ["\x98\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x4A"],

        ["\x50\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xC9"],
        ["\x98\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x4B"],

        ["\x50\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xCA"],
        ["\x98\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x4C"],

        ["\x50\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xCB"],
        ["\x98\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x4D"],

        ["\x50\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xCC"],
        ["\x98\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x4E"],

        ["\x50\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xCD"],
        ["\x98\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x4F"],

        ["\x50\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xCE"],
        ["\x98\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x50"],

        ["\x50\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xCF"],
        ["\x98\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x51"],

        ["\x50\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xD0"],
        ["\x98\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x52"],

        ["\x50\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xD1"],
        ["\x98\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x53"],

        ["\x50\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xD2"],
        ["\x98\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x54"],

        ["\x50\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xD3"],
        ["\x98\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x55"],

        ["\x4B\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xD4"],
        ["\x98\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4B\x79"],

        ["\x50\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xD5"],
        ["\x98\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x57"],

        ["\x50\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xD6"],
        ["\x98\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x58"],

        ["\x50\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xD7"],
        ["\x98\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x59"],

        ["\x50\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xD8"],
        ["\x98\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x5A"],

        ["\x50\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xD9"],
        ["\x98\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x5B"],

        ["\x50\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xDA"],
        ["\x98\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x5C"],

        ["\x50\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xDB"],
        ["\x98\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x5D"],

        ["\x50\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xDC"],
        ["\x98\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x5E"],

        ["\x50\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xDD"],
        ["\x98\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x5F"],

        ["\x50\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xDE"],
        ["\x98\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x60"],

        ["\x50\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xDF"],
        ["\x98\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x61"],

        ["\x50\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xE0"],
        ["\x98\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x62"],

        ["\x50\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xE1"],
        ["\x98\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x63"],

        ["\x50\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xE2"],
        ["\x98\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x64"],

        ["\x50\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xE3"],
        ["\x98\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x65"],

        ["\x50\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xE4"],
        ["\x98\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x66"],

        ["\x50\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xE5"],
        ["\x98\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x67"],

        ["\x50\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xE6"],
        ["\x98\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x68"],

        ["\x50\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xE7"],
        ["\x98\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x69"],

        ["\x50\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xE8"],
        ["\x98\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x6A"],

        ["\x50\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xE9"],
        ["\x98\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x6B"],

        ["\x50\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xEA"],
        ["\x98\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x6C"],

        ["\x50\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xEB"],
        ["\x98\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x6D"],

        ["\x50\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xEC"],
        ["\x98\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x6E"],

        ["\x50\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xED"],
        ["\x98\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x6F"],

        ["\x50\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xEE"],
        ["\x98\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x70"],

        ["\x50\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xEF"],
        ["\x98\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x71"],

        ["\x50\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xF0"],
        ["\x98\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x72"],

        ["\x50\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xF1"],
        ["\x98\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x73"],

        ["\x50\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xF2"],
        ["\x98\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x74"],

        ["\x50\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xF3"],
        ["\x98\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x75"],

        ["\x50\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xF4"],
        ["\x98\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x76"],

        ["\x50\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xF5"],
        ["\x98\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x77"],

        ["\x50\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xF6"],
        ["\x98\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x78"],

        ["\x50\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xF7"],
        ["\x98\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x79"],

        ["\x50\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xF8"],
        ["\x98\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x7A"],

        ["\x50\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xF9"],
        ["\x98\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x7B"],

        ["\x50\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xFA"],
        ["\x98\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x7C"],

        ["\x50\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xFB"],
        ["\x98\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x7D"],

        ["\x50\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x98\xFC"],
        ["\x98\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x50\x7E"],

        ["\x51\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x40"],
        ["\x99\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x21"],

        ["\x51\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x41"],
        ["\x99\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x22"],

        ["\x51\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x42"],
        ["\x99\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x23"],

        ["\x51\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x43"],
        ["\x99\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x24"],

        ["\x51\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x44"],
        ["\x99\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x25"],

        ["\x51\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x45"],
        ["\x99\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x26"],

        ["\x51\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x46"],
        ["\x99\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x27"],

        ["\x51\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x47"],
        ["\x99\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x28"],

        ["\x51\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x48"],
        ["\x99\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x29"],

        ["\x51\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x49"],
        ["\x99\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x2A"],

        ["\x51\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x4A"],
        ["\x99\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x2B"],

        ["\x51\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x4B"],
        ["\x99\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x2C"],

        ["\x51\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x4C"],
        ["\x99\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x2D"],

        ["\x51\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x4D"],
        ["\x99\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x2E"],

        ["\x51\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x4E"],
        ["\x99\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x2F"],

        ["\x51\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x4F"],
        ["\x99\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x30"],

        ["\x51\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x50"],
        ["\x99\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x31"],

        ["\x51\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x51"],
        ["\x99\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x32"],

        ["\x51\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x52"],
        ["\x99\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x33"],

        ["\x51\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x53"],
        ["\x99\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x34"],

        ["\x51\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x54"],
        ["\x99\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x35"],

        ["\x51\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x55"],
        ["\x99\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x36"],

        ["\x51\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x56"],
        ["\x99\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x37"],

        ["\x51\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x57"],
        ["\x99\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x38"],

        ["\x51\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x58"],
        ["\x99\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x39"],

        ["\x51\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x59"],
        ["\x99\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x3A"],

        ["\x51\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x5A"],
        ["\x99\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x3B"],

        ["\x51\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x5B"],
        ["\x99\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x3C"],

        ["\x51\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x5C"],
        ["\x99\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x3D"],

        ["\x51\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x5D"],
        ["\x99\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x3E"],

        ["\x51\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x5E"],
        ["\x99\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x3F"],

        ["\x51\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x5F"],
        ["\x99\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x40"],

        ["\x51\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x60"],
        ["\x99\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x41"],

        ["\x51\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x61"],
        ["\x99\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x42"],

        ["\x51\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x62"],
        ["\x99\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x43"],

        ["\x51\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x63"],
        ["\x99\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x44"],

        ["\x51\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x64"],
        ["\x99\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x45"],

        ["\x51\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x65"],
        ["\x99\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x46"],

        ["\x51\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x66"],
        ["\x99\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x47"],

        ["\x51\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x67"],
        ["\x99\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x48"],

        ["\x51\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x68"],
        ["\x99\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x49"],

        ["\x51\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x69"],
        ["\x99\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x4A"],

        ["\x51\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x6A"],
        ["\x99\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x4B"],

        ["\x51\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x6B"],
        ["\x99\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x4C"],

        ["\x51\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x6C"],
        ["\x99\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x4D"],

        ["\x51\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x6D"],
        ["\x99\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x4E"],

        ["\x51\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x6E"],
        ["\x99\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x4F"],

        ["\x51\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x6F"],
        ["\x99\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x50"],

        ["\x51\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x70"],
        ["\x99\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x51"],

        ["\x51\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x71"],
        ["\x99\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x52"],

        ["\x51\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x72"],
        ["\x99\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x53"],

        ["\x51\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x73"],
        ["\x99\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x54"],

        ["\x51\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x74"],
        ["\x99\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x55"],

        ["\x51\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x75"],
        ["\x99\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x56"],

        ["\x51\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x76"],
        ["\x99\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x57"],

        ["\x51\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x77"],
        ["\x99\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x58"],

        ["\x51\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x78"],
        ["\x99\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x59"],

        ["\x51\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x79"],
        ["\x99\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x5A"],

        ["\x51\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x7A"],
        ["\x99\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x5B"],

        ["\x51\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x7B"],
        ["\x99\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x5C"],

        ["\x51\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x7C"],
        ["\x99\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x5D"],

        ["\x51\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x7D"],
        ["\x99\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x5E"],

        ["\x51\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x7E"],
        ["\x99\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x5F"],

        ["\x51\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x80"],
        ["\x99\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x60"],

        ["\x51\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x81"],
        ["\x99\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x61"],

        ["\x51\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x82"],
        ["\x99\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x62"],

        ["\x51\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x83"],
        ["\x99\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x63"],

        ["\x51\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x84"],
        ["\x99\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x64"],

        ["\x51\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x85"],
        ["\x99\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x65"],

        ["\x51\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x86"],
        ["\x99\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x66"],

        ["\x51\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x87"],
        ["\x99\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x67"],

        ["\x51\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x88"],
        ["\x99\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x68"],

        ["\x51\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x89"],
        ["\x99\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x69"],

        ["\x51\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x8A"],
        ["\x99\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x6A"],

        ["\x51\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x8B"],
        ["\x99\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x6B"],

        ["\x51\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x8C"],
        ["\x99\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x6C"],

        ["\x51\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x8D"],
        ["\x99\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x6D"],

        ["\x51\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x8E"],
        ["\x99\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x6E"],

        ["\x51\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x8F"],
        ["\x99\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x6F"],

        ["\x51\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x90"],
        ["\x99\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x70"],

        ["\x51\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x91"],
        ["\x99\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x71"],

        ["\x51\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x92"],
        ["\x99\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x72"],

        ["\x51\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x93"],
        ["\x99\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x73"],

        ["\x51\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x94"],
        ["\x99\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x74"],

        ["\x51\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x95"],
        ["\x99\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x75"],

        ["\x51\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x96"],
        ["\x99\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x76"],

        ["\x51\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x97"],
        ["\x99\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x77"],

        ["\x51\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x98"],
        ["\x99\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x78"],

        ["\x51\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x99"],
        ["\x99\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x79"],

        ["\x51\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x9A"],
        ["\x99\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x7A"],

        ["\x51\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x9B"],
        ["\x99\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x7B"],

        ["\x51\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x9C"],
        ["\x99\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x7C"],

        ["\x51\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x9D"],
        ["\x99\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x7D"],

        ["\x51\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x9E"],
        ["\x99\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x51\x7E"],

        ["\x52\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\x9F"],
        ["\x99\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x21"],

        ["\x52\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xA0"],
        ["\x99\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x22"],

        ["\x52\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xA1"],
        ["\x99\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x23"],

        ["\x52\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xA2"],
        ["\x99\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x24"],

        ["\x52\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xA3"],
        ["\x99\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x25"],

        ["\x52\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xA4"],
        ["\x99\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x26"],

        ["\x52\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xA5"],
        ["\x99\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x27"],

        ["\x52\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xA6"],
        ["\x99\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x28"],

        ["\x52\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xA7"],
        ["\x99\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x29"],

        ["\x52\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xA8"],
        ["\x99\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x2A"],

        ["\x52\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xA9"],
        ["\x99\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x2B"],

        ["\x52\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xAA"],
        ["\x99\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x2C"],

        ["\x52\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xAB"],
        ["\x99\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x2D"],

        ["\x52\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xAC"],
        ["\x99\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x2E"],

        ["\x52\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xAD"],
        ["\x99\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x2F"],

        ["\x52\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xAE"],
        ["\x99\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x30"],

        ["\x52\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xAF"],
        ["\x99\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x31"],

        ["\x52\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xB0"],
        ["\x99\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x32"],

        ["\x52\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xB1"],
        ["\x99\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x33"],

        ["\x52\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xB2"],
        ["\x99\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x34"],

        ["\x52\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xB3"],
        ["\x99\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x35"],

        ["\x52\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xB4"],
        ["\x99\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x36"],

        ["\x52\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xB5"],
        ["\x99\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x37"],

        ["\x52\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xB6"],
        ["\x99\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x38"],

        ["\x52\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xB7"],
        ["\x99\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x39"],

        ["\x52\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xB8"],
        ["\x99\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x3A"],

        ["\x52\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xB9"],
        ["\x99\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x3B"],

        ["\x52\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xBA"],
        ["\x99\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x3C"],

        ["\x52\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xBB"],
        ["\x99\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x3D"],

        ["\x52\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xBC"],
        ["\x99\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x3E"],

        ["\x52\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xBD"],
        ["\x99\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x3F"],

        ["\x52\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xBE"],
        ["\x99\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x40"],

        ["\x52\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xBF"],
        ["\x99\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x41"],

        ["\x52\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xC0"],
        ["\x99\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x42"],

        ["\x52\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xC1"],
        ["\x99\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x43"],

        ["\x52\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xC2"],
        ["\x99\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x44"],

        ["\x52\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xC3"],
        ["\x99\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x45"],

        ["\x52\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xC4"],
        ["\x99\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x46"],

        ["\x52\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xC5"],
        ["\x99\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x47"],

        ["\x52\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xC6"],
        ["\x99\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x48"],

        ["\x52\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xC7"],
        ["\x99\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x49"],

        ["\x52\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xC8"],
        ["\x99\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x4A"],

        ["\x52\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xC9"],
        ["\x99\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x4B"],

        ["\x52\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xCA"],
        ["\x99\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x4C"],

        ["\x52\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xCB"],
        ["\x99\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x4D"],

        ["\x52\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xCC"],
        ["\x99\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x4E"],

        ["\x52\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xCD"],
        ["\x99\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x4F"],

        ["\x52\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xCE"],
        ["\x99\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x50"],

        ["\x52\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xCF"],
        ["\x99\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x51"],

        ["\x52\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xD0"],
        ["\x99\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x52"],

        ["\x52\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xD1"],
        ["\x99\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x53"],

        ["\x52\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xD2"],
        ["\x99\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x54"],

        ["\x52\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xD3"],
        ["\x99\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x55"],

        ["\x52\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xD4"],
        ["\x99\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x56"],

        ["\x52\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xD5"],
        ["\x99\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x57"],

        ["\x52\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xD6"],
        ["\x99\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x58"],

        ["\x52\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xD7"],
        ["\x99\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x59"],

        ["\x52\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xD8"],
        ["\x99\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x5A"],

        ["\x52\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xD9"],
        ["\x99\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x5B"],

        ["\x52\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xDA"],
        ["\x99\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x5C"],

        ["\x52\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xDB"],
        ["\x99\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x5D"],

        ["\x52\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xDC"],
        ["\x99\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x5E"],

        ["\x52\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xDD"],
        ["\x99\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x5F"],

        ["\x52\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xDE"],
        ["\x99\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x60"],

        ["\x52\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xDF"],
        ["\x99\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x61"],

        ["\x52\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xE0"],
        ["\x99\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x62"],

        ["\x52\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xE1"],
        ["\x99\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x63"],

        ["\x52\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xE2"],
        ["\x99\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x64"],

        ["\x52\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xE3"],
        ["\x99\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x65"],

        ["\x52\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xE4"],
        ["\x99\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x66"],

        ["\x52\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xE5"],
        ["\x99\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x67"],

        ["\x52\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xE6"],
        ["\x99\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x68"],

        ["\x52\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xE7"],
        ["\x99\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x69"],

        ["\x52\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xE8"],
        ["\x99\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x6A"],

        ["\x52\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xE9"],
        ["\x99\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x6B"],

        ["\x52\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xEA"],
        ["\x99\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x6C"],

        ["\x52\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xEB"],
        ["\x99\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x6D"],

        ["\x52\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xEC"],
        ["\x99\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x6E"],

        ["\x52\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xED"],
        ["\x99\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x6F"],

        ["\x52\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xEE"],
        ["\x99\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x70"],

        ["\x52\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xEF"],
        ["\x99\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x71"],

        ["\x52\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xF0"],
        ["\x99\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x72"],

        ["\x52\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xF1"],
        ["\x99\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x73"],

        ["\x52\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xF2"],
        ["\x99\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x74"],

        ["\x52\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xF3"],
        ["\x99\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x75"],

        ["\x52\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xF4"],
        ["\x99\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x76"],

        ["\x52\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xF5"],
        ["\x99\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x77"],

        ["\x52\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xF6"],
        ["\x99\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x78"],

        ["\x52\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xF7"],
        ["\x99\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x79"],

        ["\x52\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xF8"],
        ["\x99\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x7A"],

        ["\x52\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xF9"],
        ["\x99\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x7B"],

        ["\x52\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xFA"],
        ["\x99\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x7C"],

        ["\x52\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xFB"],
        ["\x99\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x7D"],

        ["\x52\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x99\xFC"],
        ["\x99\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x52\x7E"],

        ["\x53\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x40"],
        ["\x9A\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x21"],

        ["\x53\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x41"],
        ["\x9A\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x22"],

        ["\x53\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x42"],
        ["\x9A\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x23"],

        ["\x53\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x43"],
        ["\x9A\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x24"],

        ["\x53\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x44"],
        ["\x9A\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x25"],

        ["\x53\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x45"],
        ["\x9A\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x26"],

        ["\x53\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x46"],
        ["\x9A\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x27"],

        ["\x53\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x47"],
        ["\x9A\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x28"],

        ["\x53\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x48"],
        ["\x9A\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x29"],

        ["\x53\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x49"],
        ["\x9A\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x2A"],

        ["\x53\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x4A"],
        ["\x9A\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x2B"],

        ["\x53\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x4B"],
        ["\x9A\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x2C"],

        ["\x53\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x4C"],
        ["\x9A\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x2D"],

        ["\x53\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x4D"],
        ["\x9A\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x2E"],

        ["\x53\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x4E"],
        ["\x9A\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x2F"],

        ["\x53\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x4F"],
        ["\x9A\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x30"],

        ["\x53\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x50"],
        ["\x9A\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x31"],

        ["\x53\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x51"],
        ["\x9A\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x32"],

        ["\x53\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x52"],
        ["\x9A\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x33"],

        ["\x53\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x53"],
        ["\x9A\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x34"],

        ["\x53\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x54"],
        ["\x9A\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x35"],

        ["\x53\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x55"],
        ["\x9A\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x36"],

        ["\x53\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x56"],
        ["\x9A\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x37"],

        ["\x53\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x57"],
        ["\x9A\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x38"],

        ["\x53\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x58"],
        ["\x9A\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x39"],

        ["\x53\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x59"],
        ["\x9A\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x3A"],

        ["\x53\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x5A"],
        ["\x9A\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x3B"],

        ["\x53\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x5B"],
        ["\x9A\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x3C"],

        ["\x53\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x5C"],
        ["\x9A\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x3D"],

        ["\x53\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x5D"],
        ["\x9A\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x3E"],

        ["\x53\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x5E"],
        ["\x9A\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x3F"],

        ["\x53\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x5F"],
        ["\x9A\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x40"],

        ["\x53\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x60"],
        ["\x9A\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x41"],

        ["\x53\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x61"],
        ["\x9A\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x42"],

        ["\x53\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x62"],
        ["\x9A\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x43"],

        ["\x53\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x63"],
        ["\x9A\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x44"],

        ["\x53\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x64"],
        ["\x9A\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x45"],

        ["\x53\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x65"],
        ["\x9A\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x46"],

        ["\x53\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x66"],
        ["\x9A\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x47"],

        ["\x53\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x67"],
        ["\x9A\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x48"],

        ["\x53\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x68"],
        ["\x9A\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x49"],

        ["\x53\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x69"],
        ["\x9A\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x4A"],

        ["\x53\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x6A"],
        ["\x9A\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x4B"],

        ["\x53\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x6B"],
        ["\x9A\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x4C"],

        ["\x53\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x6C"],
        ["\x9A\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x4D"],

        ["\x53\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x6D"],
        ["\x9A\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x4E"],

        ["\x53\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x6E"],
        ["\x9A\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x4F"],

        ["\x53\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x6F"],
        ["\x9A\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x50"],

        ["\x53\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x70"],
        ["\x9A\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x51"],

        ["\x53\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x71"],
        ["\x9A\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x52"],

        ["\x53\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x72"],
        ["\x9A\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x53"],

        ["\x53\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x73"],
        ["\x9A\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x54"],

        ["\x53\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x74"],
        ["\x9A\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x55"],

        ["\x53\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x75"],
        ["\x9A\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x56"],

        ["\x53\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x76"],
        ["\x9A\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x57"],

        ["\x53\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x77"],
        ["\x9A\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x58"],

        ["\x53\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x78"],
        ["\x9A\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x59"],

        ["\x53\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x79"],
        ["\x9A\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x5A"],

        ["\x53\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x7A"],
        ["\x9A\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x5B"],

        ["\x53\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x7B"],
        ["\x9A\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x5C"],

        ["\x53\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x7C"],
        ["\x9A\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x5D"],

        ["\x53\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x7D"],
        ["\x9A\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x5E"],

        ["\x53\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x7E"],
        ["\x9A\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x5F"],

        ["\x53\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x80"],
        ["\x9A\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x60"],

        ["\x53\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x81"],
        ["\x9A\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x61"],

        ["\x53\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x82"],
        ["\x9A\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x62"],

        ["\x53\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x83"],
        ["\x9A\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x63"],

        ["\x53\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x84"],
        ["\x9A\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x64"],

        ["\x53\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x85"],
        ["\x9A\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x65"],

        ["\x53\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x86"],
        ["\x9A\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x66"],

        ["\x53\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x87"],
        ["\x9A\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x67"],

        ["\x53\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x88"],
        ["\x9A\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x68"],

        ["\x53\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x89"],
        ["\x9A\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x69"],

        ["\x53\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x8A"],
        ["\x9A\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x6A"],

        ["\x53\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x8B"],
        ["\x9A\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x6B"],

        ["\x53\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x8C"],
        ["\x9A\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x6C"],

        ["\x53\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x8D"],
        ["\x9A\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x6D"],

        ["\x53\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x8E"],
        ["\x9A\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x6E"],

        ["\x53\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x8F"],
        ["\x9A\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x6F"],

        ["\x53\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x90"],
        ["\x9A\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x70"],

        ["\x53\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x91"],
        ["\x9A\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x71"],

        ["\x53\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x92"],
        ["\x9A\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x72"],

        ["\x53\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x93"],
        ["\x9A\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x73"],

        ["\x53\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x94"],
        ["\x9A\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x74"],

        ["\x53\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x95"],
        ["\x9A\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x75"],

        ["\x53\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x96"],
        ["\x9A\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x76"],

        ["\x53\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x97"],
        ["\x9A\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x77"],

        ["\x53\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x98"],
        ["\x9A\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x78"],

        ["\x53\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x99"],
        ["\x9A\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x79"],

        ["\x53\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x9A"],
        ["\x9A\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x7A"],

        ["\x53\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x9B"],
        ["\x9A\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x7B"],

        ["\x53\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x9C"],
        ["\x9A\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x7C"],

        ["\x53\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x9D"],
        ["\x9A\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x7D"],

        ["\x53\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x9E"],
        ["\x9A\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x53\x7E"],

        ["\x54\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\x9F"],
        ["\x9A\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x21"],

        ["\x54\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xA0"],
        ["\x9A\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x22"],

        ["\x54\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xA1"],
        ["\x9A\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x23"],

        ["\x54\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xA2"],
        ["\x9A\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x24"],

        ["\x54\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xA3"],
        ["\x9A\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x25"],

        ["\x54\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xA4"],
        ["\x9A\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x26"],

        ["\x54\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xA5"],
        ["\x9A\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x27"],

        ["\x54\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xA6"],
        ["\x9A\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x28"],

        ["\x54\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xA7"],
        ["\x9A\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x29"],

        ["\x54\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xA8"],
        ["\x9A\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x2A"],

        ["\x54\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xA9"],
        ["\x9A\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x2B"],

        ["\x54\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xAA"],
        ["\x9A\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x2C"],

        ["\x54\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xAB"],
        ["\x9A\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x2D"],

        ["\x54\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xAC"],
        ["\x9A\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x2E"],

        ["\x54\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xAD"],
        ["\x9A\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x2F"],

        ["\x54\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xAE"],
        ["\x9A\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x30"],

        ["\x54\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xAF"],
        ["\x9A\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x31"],

        ["\x54\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xB0"],
        ["\x9A\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x32"],

        ["\x54\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xB1"],
        ["\x9A\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x33"],

        ["\x54\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xB2"],
        ["\x9A\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x34"],

        ["\x54\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xB3"],
        ["\x9A\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x35"],

        ["\x54\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xB4"],
        ["\x9A\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x36"],

        ["\x54\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xB5"],
        ["\x9A\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x37"],

        ["\x54\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xB6"],
        ["\x9A\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x38"],

        ["\x54\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xB7"],
        ["\x9A\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x39"],

        ["\x54\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xB8"],
        ["\x9A\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x3A"],

        ["\x54\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xB9"],
        ["\x9A\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x3B"],

        ["\x54\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xBA"],
        ["\x9A\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x3C"],

        ["\x54\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xBB"],
        ["\x9A\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x3D"],

        ["\x54\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xBC"],
        ["\x9A\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x3E"],

        ["\x54\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xBD"],
        ["\x9A\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x3F"],

        ["\x54\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xBE"],
        ["\x9A\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x40"],

        ["\x54\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xBF"],
        ["\x9A\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x41"],

        ["\x54\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xC0"],
        ["\x9A\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x42"],

        ["\x54\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xC1"],
        ["\x9A\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x43"],

        ["\x54\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xC2"],
        ["\x9A\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x44"],

        ["\x54\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xC3"],
        ["\x9A\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x45"],

        ["\x54\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xC4"],
        ["\x9A\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x46"],

        ["\x54\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xC5"],
        ["\x9A\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x47"],

        ["\x54\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xC6"],
        ["\x9A\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x48"],

        ["\x54\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xC7"],
        ["\x9A\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x49"],

        ["\x54\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xC8"],
        ["\x9A\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x4A"],

        ["\x54\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xC9"],
        ["\x9A\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x4B"],

        ["\x54\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xCA"],
        ["\x9A\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x4C"],

        ["\x54\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xCB"],
        ["\x9A\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x4D"],

        ["\x54\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xCC"],
        ["\x9A\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x4E"],

        ["\x54\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xCD"],
        ["\x9A\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x4F"],

        ["\x54\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xCE"],
        ["\x9A\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x50"],

        ["\x54\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xCF"],
        ["\x9A\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x51"],

        ["\x54\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xD0"],
        ["\x9A\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x52"],

        ["\x54\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xD1"],
        ["\x9A\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x53"],

        ["\x54\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xD2"],
        ["\x9A\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x54"],

        ["\x54\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xD3"],
        ["\x9A\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x55"],

        ["\x54\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xD4"],
        ["\x9A\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x56"],

        ["\x54\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xD5"],
        ["\x9A\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x57"],

        ["\x54\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xD6"],
        ["\x9A\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x58"],

        ["\x54\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xD7"],
        ["\x9A\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x59"],

        ["\x54\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xD8"],
        ["\x9A\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x5A"],

        ["\x54\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xD9"],
        ["\x9A\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x5B"],

        ["\x54\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xDA"],
        ["\x9A\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x5C"],

        ["\x54\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xDB"],
        ["\x9A\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x5D"],

        ["\x54\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xDC"],
        ["\x9A\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x5E"],

        ["\x54\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xDD"],
        ["\x9A\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x5F"],

        ["\x54\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xDE"],
        ["\x9A\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x60"],

        ["\x54\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xDF"],
        ["\x9A\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x61"],

        ["\x54\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xE0"],
        ["\x9A\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x62"],

        ["\x54\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xE1"],
        ["\x9A\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x63"],

        ["\x44\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xE2"],
        ["\x9A\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x44\x5B"],

        ["\x54\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xE3"],
        ["\x9A\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x65"],

        ["\x54\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xE4"],
        ["\x9A\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x66"],

        ["\x54\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xE5"],
        ["\x9A\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x67"],

        ["\x54\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xE6"],
        ["\x9A\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x68"],

        ["\x54\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xE7"],
        ["\x9A\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x69"],

        ["\x54\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xE8"],
        ["\x9A\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x6A"],

        ["\x54\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xE9"],
        ["\x9A\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x6B"],

        ["\x54\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xEA"],
        ["\x9A\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x6C"],

        ["\x54\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xEB"],
        ["\x9A\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x6D"],

        ["\x54\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xEC"],
        ["\x9A\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x6E"],

        ["\x54\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xED"],
        ["\x9A\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x6F"],

        ["\x54\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xEE"],
        ["\x9A\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x70"],

        ["\x54\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xEF"],
        ["\x9A\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x71"],

        ["\x54\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xF0"],
        ["\x9A\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x72"],

        ["\x54\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xF1"],
        ["\x9A\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x73"],

        ["\x54\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xF2"],
        ["\x9A\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x74"],

        ["\x54\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xF3"],
        ["\x9A\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x75"],

        ["\x54\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xF4"],
        ["\x9A\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x76"],

        ["\x54\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xF5"],
        ["\x9A\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x77"],

        ["\x54\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xF6"],
        ["\x9A\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x78"],

        ["\x54\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xF7"],
        ["\x9A\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x79"],

        ["\x54\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xF8"],
        ["\x9A\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x7A"],

        ["\x54\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xF9"],
        ["\x9A\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x7B"],

        ["\x54\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xFA"],
        ["\x9A\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x7C"],

        ["\x54\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xFB"],
        ["\x9A\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x7D"],

        ["\x54\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9A\xFC"],
        ["\x9A\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x54\x7E"],

        ["\x55\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x40"],
        ["\x9B\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x21"],

        ["\x55\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x41"],
        ["\x9B\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x22"],

        ["\x55\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x42"],
        ["\x9B\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x23"],

        ["\x55\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x43"],
        ["\x9B\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x24"],

        ["\x55\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x44"],
        ["\x9B\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x25"],

        ["\x55\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x45"],
        ["\x9B\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x26"],

        ["\x55\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x46"],
        ["\x9B\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x27"],

        ["\x55\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x47"],
        ["\x9B\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x28"],

        ["\x55\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x48"],
        ["\x9B\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x29"],

        ["\x55\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x49"],
        ["\x9B\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x2A"],

        ["\x55\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x4A"],
        ["\x9B\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x2B"],

        ["\x55\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x4B"],
        ["\x9B\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x2C"],

        ["\x55\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x4C"],
        ["\x9B\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x2D"],

        ["\x55\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x4D"],
        ["\x9B\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x2E"],

        ["\x55\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x4E"],
        ["\x9B\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x2F"],

        ["\x55\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x4F"],
        ["\x9B\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x30"],

        ["\x55\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x50"],
        ["\x9B\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x31"],

        ["\x55\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x51"],
        ["\x9B\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x32"],

        ["\x55\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x52"],
        ["\x9B\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x33"],

        ["\x55\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x53"],
        ["\x9B\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x34"],

        ["\x55\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x54"],
        ["\x9B\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x35"],

        ["\x55\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x55"],
        ["\x9B\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x36"],

        ["\x55\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x56"],
        ["\x9B\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x37"],

        ["\x55\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x57"],
        ["\x9B\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x38"],

        ["\x55\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x58"],
        ["\x9B\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x39"],

        ["\x55\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x59"],
        ["\x9B\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x3A"],

        ["\x55\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x5A"],
        ["\x9B\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x3B"],

        ["\x55\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x5B"],
        ["\x9B\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x3C"],

        ["\x55\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x5C"],
        ["\x9B\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x3D"],

        ["\x55\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x5D"],
        ["\x9B\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x3E"],

        ["\x55\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x5E"],
        ["\x9B\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x3F"],

        ["\x55\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x5F"],
        ["\x9B\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x40"],

        ["\x55\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x60"],
        ["\x9B\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x41"],

        ["\x55\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x61"],
        ["\x9B\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x42"],

        ["\x55\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x62"],
        ["\x9B\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x43"],

        ["\x55\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x63"],
        ["\x9B\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x44"],

        ["\x55\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x64"],
        ["\x9B\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x45"],

        ["\x55\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x65"],
        ["\x9B\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x46"],

        ["\x55\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x66"],
        ["\x9B\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x47"],

        ["\x55\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x67"],
        ["\x9B\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x48"],

        ["\x55\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x68"],
        ["\x9B\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x49"],

        ["\x55\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x69"],
        ["\x9B\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x4A"],

        ["\x55\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x6A"],
        ["\x9B\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x4B"],

        ["\x55\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x6B"],
        ["\x9B\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x4C"],

        ["\x55\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x6C"],
        ["\x9B\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x4D"],

        ["\x55\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x6D"],
        ["\x9B\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x4E"],

        ["\x55\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x6E"],
        ["\x9B\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x4F"],

        ["\x55\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x6F"],
        ["\x9B\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x50"],

        ["\x55\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x70"],
        ["\x9B\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x51"],

        ["\x55\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x71"],
        ["\x9B\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x52"],

        ["\x55\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x72"],
        ["\x9B\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x53"],

        ["\x55\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x73"],
        ["\x9B\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x54"],

        ["\x55\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x74"],
        ["\x9B\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x55"],

        ["\x55\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x75"],
        ["\x9B\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x56"],

        ["\x55\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x76"],
        ["\x9B\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x57"],

        ["\x55\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x77"],
        ["\x9B\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x58"],

        ["\x55\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x78"],
        ["\x9B\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x59"],

        ["\x55\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x79"],
        ["\x9B\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x5A"],

        ["\x55\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x7A"],
        ["\x9B\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x5B"],

        ["\x55\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x7B"],
        ["\x9B\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x5C"],

        ["\x55\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x7C"],
        ["\x9B\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x5D"],

        ["\x55\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x7D"],
        ["\x9B\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x5E"],

        ["\x55\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x7E"],
        ["\x9B\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x5F"],

        ["\x55\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x80"],
        ["\x9B\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x60"],

        ["\x55\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x81"],
        ["\x9B\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x61"],

        ["\x55\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x82"],
        ["\x9B\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x62"],

        ["\x55\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x83"],
        ["\x9B\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x63"],

        ["\x55\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x84"],
        ["\x9B\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x64"],

        ["\x55\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x85"],
        ["\x9B\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x65"],

        ["\x55\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x86"],
        ["\x9B\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x66"],

        ["\x55\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x87"],
        ["\x9B\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x67"],

        ["\x55\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x88"],
        ["\x9B\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x68"],

        ["\x55\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x89"],
        ["\x9B\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x69"],

        ["\x55\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x8A"],
        ["\x9B\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x6A"],

        ["\x55\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x8B"],
        ["\x9B\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x6B"],

        ["\x55\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x8C"],
        ["\x9B\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x6C"],

        ["\x55\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x8D"],
        ["\x9B\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x6D"],

        ["\x55\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x8E"],
        ["\x9B\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x6E"],

        ["\x55\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x8F"],
        ["\x9B\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x6F"],

        ["\x55\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x90"],
        ["\x9B\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x70"],

        ["\x55\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x91"],
        ["\x9B\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x71"],

        ["\x55\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x92"],
        ["\x9B\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x72"],

        ["\x55\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x93"],
        ["\x9B\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x73"],

        ["\x55\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x94"],
        ["\x9B\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x74"],

        ["\x55\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x95"],
        ["\x9B\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x75"],

        ["\x55\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x96"],
        ["\x9B\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x76"],

        ["\x55\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x97"],
        ["\x9B\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x77"],

        ["\x55\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x98"],
        ["\x9B\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x78"],

        ["\x55\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x99"],
        ["\x9B\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x79"],

        ["\x55\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x9A"],
        ["\x9B\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x7A"],

        ["\x55\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x9B"],
        ["\x9B\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x7B"],

        ["\x55\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x9C"],
        ["\x9B\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x7C"],

        ["\x55\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x9D"],
        ["\x9B\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x7D"],

        ["\x55\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x9E"],
        ["\x9B\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x55\x7E"],

        ["\x56\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\x9F"],
        ["\x9B\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x21"],

        ["\x56\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xA0"],
        ["\x9B\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x22"],

        ["\x56\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xA1"],
        ["\x9B\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x23"],

        ["\x56\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xA2"],
        ["\x9B\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x24"],

        ["\x56\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xA3"],
        ["\x9B\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x25"],

        ["\x56\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xA4"],
        ["\x9B\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x26"],

        ["\x56\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xA5"],
        ["\x9B\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x27"],

        ["\x56\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xA6"],
        ["\x9B\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x28"],

        ["\x56\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xA7"],
        ["\x9B\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x29"],

        ["\x56\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xA8"],
        ["\x9B\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x2A"],

        ["\x56\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xA9"],
        ["\x9B\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x2B"],

        ["\x56\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xAA"],
        ["\x9B\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x2C"],

        ["\x56\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xAB"],
        ["\x9B\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x2D"],

        ["\x56\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xAC"],
        ["\x9B\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x2E"],

        ["\x56\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xAD"],
        ["\x9B\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x2F"],

        ["\x56\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xAE"],
        ["\x9B\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x30"],

        ["\x56\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xAF"],
        ["\x9B\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x31"],

        ["\x56\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xB0"],
        ["\x9B\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x32"],

        ["\x56\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xB1"],
        ["\x9B\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x33"],

        ["\x56\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xB2"],
        ["\x9B\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x34"],

        ["\x56\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xB3"],
        ["\x9B\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x35"],

        ["\x56\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xB4"],
        ["\x9B\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x36"],

        ["\x56\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xB5"],
        ["\x9B\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x37"],

        ["\x56\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xB6"],
        ["\x9B\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x38"],

        ["\x56\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xB7"],
        ["\x9B\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x39"],

        ["\x56\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xB8"],
        ["\x9B\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x3A"],

        ["\x56\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xB9"],
        ["\x9B\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x3B"],

        ["\x56\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xBA"],
        ["\x9B\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x3C"],

        ["\x56\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xBB"],
        ["\x9B\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x3D"],

        ["\x56\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xBC"],
        ["\x9B\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x3E"],

        ["\x56\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xBD"],
        ["\x9B\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x3F"],

        ["\x56\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xBE"],
        ["\x9B\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x40"],

        ["\x56\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xBF"],
        ["\x9B\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x41"],

        ["\x56\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xC0"],
        ["\x9B\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x42"],

        ["\x56\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xC1"],
        ["\x9B\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x43"],

        ["\x56\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xC2"],
        ["\x9B\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x44"],

        ["\x56\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xC3"],
        ["\x9B\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x45"],

        ["\x56\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xC4"],
        ["\x9B\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x46"],

        ["\x56\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xC5"],
        ["\x9B\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x47"],

        ["\x56\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xC6"],
        ["\x9B\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x48"],

        ["\x56\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xC7"],
        ["\x9B\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x49"],

        ["\x56\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xC8"],
        ["\x9B\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x4A"],

        ["\x56\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xC9"],
        ["\x9B\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x4B"],

        ["\x56\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xCA"],
        ["\x9B\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x4C"],

        ["\x56\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xCB"],
        ["\x9B\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x4D"],

        ["\x56\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xCC"],
        ["\x9B\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x4E"],

        ["\x56\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xCD"],
        ["\x9B\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x4F"],

        ["\x56\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xCE"],
        ["\x9B\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x50"],

        ["\x56\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xCF"],
        ["\x9B\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x51"],

        ["\x56\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xD0"],
        ["\x9B\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x52"],

        ["\x56\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xD1"],
        ["\x9B\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x53"],

        ["\x56\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xD2"],
        ["\x9B\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x54"],

        ["\x56\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xD3"],
        ["\x9B\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x55"],

        ["\x56\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xD4"],
        ["\x9B\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x56"],

        ["\x56\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xD5"],
        ["\x9B\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x57"],

        ["\x56\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xD6"],
        ["\x9B\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x58"],

        ["\x56\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xD7"],
        ["\x9B\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x59"],

        ["\x56\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xD8"],
        ["\x9B\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x5A"],

        ["\x56\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xD9"],
        ["\x9B\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x5B"],

        ["\x56\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xDA"],
        ["\x9B\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x5C"],

        ["\x56\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xDB"],
        ["\x9B\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x5D"],

        ["\x56\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xDC"],
        ["\x9B\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x5E"],

        ["\x56\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xDD"],
        ["\x9B\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x5F"],

        ["\x56\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xDE"],
        ["\x9B\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x60"],

        ["\x56\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xDF"],
        ["\x9B\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x61"],

        ["\x56\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xE0"],
        ["\x9B\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x62"],

        ["\x56\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xE1"],
        ["\x9B\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x63"],

        ["\x56\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xE2"],
        ["\x9B\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x64"],

        ["\x56\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xE3"],
        ["\x9B\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x65"],

        ["\x56\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xE4"],
        ["\x9B\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x66"],

        ["\x56\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xE5"],
        ["\x9B\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x67"],

        ["\x56\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xE6"],
        ["\x9B\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x68"],

        ["\x56\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xE7"],
        ["\x9B\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x69"],

        ["\x56\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xE8"],
        ["\x9B\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x6A"],

        ["\x56\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xE9"],
        ["\x9B\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x6B"],

        ["\x56\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xEA"],
        ["\x9B\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x6C"],

        ["\x56\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xEB"],
        ["\x9B\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x6D"],

        ["\x56\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xEC"],
        ["\x9B\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x6E"],

        ["\x56\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xED"],
        ["\x9B\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x6F"],

        ["\x56\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xEE"],
        ["\x9B\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x70"],

        ["\x56\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xEF"],
        ["\x9B\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x71"],

        ["\x56\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xF0"],
        ["\x9B\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x72"],

        ["\x56\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xF1"],
        ["\x9B\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x73"],

        ["\x56\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xF2"],
        ["\x9B\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x74"],

        ["\x56\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xF3"],
        ["\x9B\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x75"],

        ["\x56\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xF4"],
        ["\x9B\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x76"],

        ["\x56\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xF5"],
        ["\x9B\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x77"],

        ["\x56\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xF6"],
        ["\x9B\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x78"],

        ["\x56\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xF7"],
        ["\x9B\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x79"],

        ["\x56\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xF8"],
        ["\x9B\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x7A"],

        ["\x56\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xF9"],
        ["\x9B\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x7B"],

        ["\x56\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xFA"],
        ["\x9B\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x7C"],

        ["\x56\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xFB"],
        ["\x9B\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x7D"],

        ["\x56\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9B\xFC"],
        ["\x9B\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x56\x7E"],

        ["\x57\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x40"],
        ["\x9C\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x21"],

        ["\x57\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x41"],
        ["\x9C\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x22"],

        ["\x57\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x42"],
        ["\x9C\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x23"],

        ["\x57\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x43"],
        ["\x9C\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x24"],

        ["\x57\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x44"],
        ["\x9C\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x25"],

        ["\x57\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x45"],
        ["\x9C\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x26"],

        ["\x57\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x46"],
        ["\x9C\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x27"],

        ["\x57\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x47"],
        ["\x9C\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x28"],

        ["\x57\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x48"],
        ["\x9C\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x29"],

        ["\x57\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x49"],
        ["\x9C\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x2A"],

        ["\x57\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x4A"],
        ["\x9C\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x2B"],

        ["\x57\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x4B"],
        ["\x9C\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x2C"],

        ["\x57\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x4C"],
        ["\x9C\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x2D"],

        ["\x57\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x4D"],
        ["\x9C\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x2E"],

        ["\x57\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x4E"],
        ["\x9C\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x2F"],

        ["\x57\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x4F"],
        ["\x9C\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x30"],

        ["\x57\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x50"],
        ["\x9C\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x31"],

        ["\x57\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x51"],
        ["\x9C\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x32"],

        ["\x57\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x52"],
        ["\x9C\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x33"],

        ["\x57\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x53"],
        ["\x9C\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x34"],

        ["\x57\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x54"],
        ["\x9C\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x35"],

        ["\x57\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x55"],
        ["\x9C\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x36"],

        ["\x57\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x56"],
        ["\x9C\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x37"],

        ["\x57\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x57"],
        ["\x9C\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x38"],

        ["\x57\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x58"],
        ["\x9C\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x39"],

        ["\x57\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x59"],
        ["\x9C\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x3A"],

        ["\x57\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x5B"],
        ["\x9C\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x3C"],

        ["\x57\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x5C"],
        ["\x9C\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x3D"],

        ["\x57\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x5D"],
        ["\x9C\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x3E"],

        ["\x57\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x5E"],
        ["\x9C\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x3F"],

        ["\x57\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x5F"],
        ["\x9C\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x40"],

        ["\x57\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x60"],
        ["\x9C\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x41"],

        ["\x57\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x61"],
        ["\x9C\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x42"],

        ["\x57\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x62"],
        ["\x9C\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x43"],

        ["\x57\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x63"],
        ["\x9C\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x44"],

        ["\x57\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x64"],
        ["\x9C\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x45"],

        ["\x57\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x65"],
        ["\x9C\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x46"],

        ["\x57\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x66"],
        ["\x9C\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x47"],

        ["\x57\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x67"],
        ["\x9C\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x48"],

        ["\x57\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x68"],
        ["\x9C\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x49"],

        ["\x57\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x69"],
        ["\x9C\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x4A"],

        ["\x57\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x6A"],
        ["\x9C\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x4B"],

        ["\x57\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x6B"],
        ["\x9C\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x4C"],

        ["\x57\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x6C"],
        ["\x9C\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x4D"],

        ["\x57\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x6D"],
        ["\x9C\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x4E"],

        ["\x57\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x6E"],
        ["\x9C\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x4F"],

        ["\x57\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x6F"],
        ["\x9C\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x50"],

        ["\x57\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x70"],
        ["\x9C\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x51"],

        ["\x57\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x71"],
        ["\x9C\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x52"],

        ["\x57\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x72"],
        ["\x9C\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x53"],

        ["\x57\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x73"],
        ["\x9C\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x54"],

        ["\x57\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x74"],
        ["\x9C\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x55"],

        ["\x57\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x75"],
        ["\x9C\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x56"],

        ["\x57\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x76"],
        ["\x9C\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x57"],

        ["\x57\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x77"],
        ["\x9C\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x58"],

        ["\x57\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x78"],
        ["\x9C\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x59"],

        ["\x57\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x79"],
        ["\x9C\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x5A"],

        ["\x57\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x7A"],
        ["\x9C\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x5B"],

        ["\x57\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x7B"],
        ["\x9C\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x5C"],

        ["\x57\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x7C"],
        ["\x9C\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x5D"],

        ["\x57\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x7D"],
        ["\x9C\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x5E"],

        ["\x57\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x7E"],
        ["\x9C\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x5F"],

        ["\x57\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x80"],
        ["\x9C\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x60"],

        ["\x57\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x81"],
        ["\x9C\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x61"],

        ["\x57\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x82"],
        ["\x9C\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x62"],

        ["\x57\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x83"],
        ["\x9C\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x63"],

        ["\x57\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x84"],
        ["\x9C\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x64"],

        ["\x57\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x85"],
        ["\x9C\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x65"],

        ["\x57\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x86"],
        ["\x9C\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x66"],

        ["\x57\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x87"],
        ["\x9C\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x67"],

        ["\x57\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x88"],
        ["\x9C\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x68"],

        ["\x57\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x89"],
        ["\x9C\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x69"],

        ["\x57\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x8A"],
        ["\x9C\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x6A"],

        ["\x57\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x8B"],
        ["\x9C\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x6B"],

        ["\x57\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x8C"],
        ["\x9C\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x6C"],

        ["\x57\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x8D"],
        ["\x9C\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x6D"],

        ["\x57\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x8E"],
        ["\x9C\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x6E"],

        ["\x57\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x8F"],
        ["\x9C\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x6F"],

        ["\x57\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x90"],
        ["\x9C\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x70"],

        ["\x57\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x91"],
        ["\x9C\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x71"],

        ["\x57\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x92"],
        ["\x9C\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x72"],

        ["\x57\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x93"],
        ["\x9C\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x73"],

        ["\x57\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x94"],
        ["\x9C\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x74"],

        ["\x57\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x95"],
        ["\x9C\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x75"],

        ["\x57\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x96"],
        ["\x9C\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x76"],

        ["\x57\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x97"],
        ["\x9C\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x77"],

        ["\x57\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x98"],
        ["\x9C\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x78"],

        ["\x57\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x99"],
        ["\x9C\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x79"],

        ["\x57\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x9A"],
        ["\x9C\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x7A"],

        ["\x57\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x9B"],
        ["\x9C\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x7B"],

        ["\x57\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x9C"],
        ["\x9C\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x7C"],

        ["\x57\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x9D"],
        ["\x9C\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x7D"],

        ["\x57\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x9E"],
        ["\x9C\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x57\x7E"],

        ["\x58\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\x9F"],
        ["\x9C\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x21"],

        ["\x58\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xA0"],
        ["\x9C\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x22"],

        ["\x58\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xA1"],
        ["\x9C\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x23"],

        ["\x58\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xA2"],
        ["\x9C\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x24"],

        ["\x58\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xA3"],
        ["\x9C\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x25"],

        ["\x58\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xA4"],
        ["\x9C\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x26"],

        ["\x58\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xA5"],
        ["\x9C\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x27"],

        ["\x58\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xA6"],
        ["\x9C\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x28"],

        ["\x58\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xA7"],
        ["\x9C\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x29"],

        ["\x58\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xA8"],
        ["\x9C\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x2A"],

        ["\x58\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xA9"],
        ["\x9C\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x2B"],

        ["\x58\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xAA"],
        ["\x9C\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x2C"],

        ["\x58\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xAB"],
        ["\x9C\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x2D"],

        ["\x58\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xAC"],
        ["\x9C\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x2E"],

        ["\x58\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xAD"],
        ["\x9C\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x2F"],

        ["\x58\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xAE"],
        ["\x9C\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x30"],

        ["\x58\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xAF"],
        ["\x9C\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x31"],

        ["\x58\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xB0"],
        ["\x9C\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x32"],

        ["\x58\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xB1"],
        ["\x9C\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x33"],

        ["\x58\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xB2"],
        ["\x9C\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x34"],

        ["\x58\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xB3"],
        ["\x9C\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x35"],

        ["\x58\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xB4"],
        ["\x9C\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x36"],

        ["\x58\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xB5"],
        ["\x9C\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x37"],

        ["\x58\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xB6"],
        ["\x9C\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x38"],

        ["\x58\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xB7"],
        ["\x9C\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x39"],

        ["\x58\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xB8"],
        ["\x9C\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x3A"],

        ["\x58\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xB9"],
        ["\x9C\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x3B"],

        ["\x58\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xBA"],
        ["\x9C\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x3C"],

        ["\x58\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xBB"],
        ["\x9C\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x3D"],

        ["\x58\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xBC"],
        ["\x9C\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x3E"],

        ["\x58\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xBD"],
        ["\x9C\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x3F"],

        ["\x58\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xBE"],
        ["\x9C\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x40"],

        ["\x58\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xBF"],
        ["\x9C\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x41"],

        ["\x58\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xC0"],
        ["\x9C\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x42"],

        ["\x58\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xC1"],
        ["\x9C\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x43"],

        ["\x58\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xC2"],
        ["\x9C\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x44"],

        ["\x58\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xC3"],
        ["\x9C\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x45"],

        ["\x58\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xC4"],
        ["\x9C\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x46"],

        ["\x58\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xC5"],
        ["\x9C\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x47"],

        ["\x58\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xC6"],
        ["\x9C\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x48"],

        ["\x58\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xC7"],
        ["\x9C\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x49"],

        ["\x58\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xC8"],
        ["\x9C\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x4A"],

        ["\x58\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xC9"],
        ["\x9C\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x4B"],

        ["\x58\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xCA"],
        ["\x9C\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x4C"],

        ["\x58\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xCB"],
        ["\x9C\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x4D"],

        ["\x58\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xCC"],
        ["\x9C\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x4E"],

        ["\x58\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xCD"],
        ["\x9C\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x4F"],

        ["\x58\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xCE"],
        ["\x9C\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x50"],

        ["\x58\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xCF"],
        ["\x9C\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x51"],

        ["\x58\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xD0"],
        ["\x9C\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x52"],

        ["\x58\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xD1"],
        ["\x9C\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x53"],

        ["\x58\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xD2"],
        ["\x9C\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x54"],

        ["\x58\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xD3"],
        ["\x9C\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x55"],

        ["\x58\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xD4"],
        ["\x9C\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x56"],

        ["\x58\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xD5"],
        ["\x9C\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x57"],

        ["\x58\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xD6"],
        ["\x9C\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x58"],

        ["\x58\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xD7"],
        ["\x9C\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x59"],

        ["\x58\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xD8"],
        ["\x9C\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x5A"],

        ["\x58\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xD9"],
        ["\x9C\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x5B"],

        ["\x58\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xDA"],
        ["\x9C\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x5C"],

        ["\x58\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xDB"],
        ["\x9C\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x5D"],

        ["\x58\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xDC"],
        ["\x9C\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x5E"],

        ["\x58\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xDD"],
        ["\x9C\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x5F"],

        ["\x58\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xDE"],
        ["\x9C\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x60"],

        ["\x58\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xDF"],
        ["\x9C\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x61"],

        ["\x58\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xE0"],
        ["\x9C\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x62"],

        ["\x58\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xE1"],
        ["\x9C\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x63"],

        ["\x58\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xE2"],
        ["\x9C\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x64"],

        ["\x58\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xE3"],
        ["\x9C\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x65"],

        ["\x58\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xE4"],
        ["\x9C\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x66"],

        ["\x58\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xE5"],
        ["\x9C\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x67"],

        ["\x58\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xE6"],
        ["\x9C\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x68"],

        ["\x58\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xE7"],
        ["\x9C\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x69"],

        ["\x58\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xE8"],
        ["\x9C\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x6A"],

        ["\x58\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xE9"],
        ["\x9C\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x6B"],

        ["\x58\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xEA"],
        ["\x9C\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x6C"],

        ["\x58\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xEB"],
        ["\x9C\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x6D"],

        ["\x58\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xEC"],
        ["\x9C\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x6E"],

        ["\x58\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xED"],
        ["\x9C\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x6F"],

        ["\x58\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xEE"],
        ["\x9C\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x70"],

        ["\x58\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xEF"],
        ["\x9C\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x71"],

        ["\x58\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xF0"],
        ["\x9C\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x72"],

        ["\x58\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xF1"],
        ["\x9C\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x73"],

        ["\x58\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xF2"],
        ["\x9C\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x74"],

        ["\x58\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xF3"],
        ["\x9C\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x75"],

        ["\x58\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xF4"],
        ["\x9C\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x76"],

        ["\x58\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xF5"],
        ["\x9C\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x77"],

        ["\x58\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xF6"],
        ["\x9C\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x78"],

        ["\x58\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xF7"],
        ["\x9C\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x79"],

        ["\x58\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xF8"],
        ["\x9C\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x7A"],

        ["\x58\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xF9"],
        ["\x9C\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x7B"],

        ["\x58\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xFA"],
        ["\x9C\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x7C"],

        ["\x58\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xFB"],
        ["\x9C\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x7D"],

        ["\x58\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9C\xFC"],
        ["\x9C\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x58\x7E"],

        ["\x59\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x40"],
        ["\x9D\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x21"],

        ["\x59\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x41"],
        ["\x9D\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x22"],

        ["\x59\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x42"],
        ["\x9D\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x23"],

        ["\x59\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x43"],
        ["\x9D\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x24"],

        ["\x59\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x44"],
        ["\x9D\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x25"],

        ["\x59\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x45"],
        ["\x9D\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x26"],

        ["\x59\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x46"],
        ["\x9D\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x27"],

        ["\x59\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x47"],
        ["\x9D\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x28"],

        ["\x59\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x48"],
        ["\x9D\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x29"],

        ["\x59\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x49"],
        ["\x9D\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x2A"],

        ["\x59\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x4A"],
        ["\x9D\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x2B"],

        ["\x59\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x4B"],
        ["\x9D\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x2C"],

        ["\x59\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x4C"],
        ["\x9D\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x2D"],

        ["\x59\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x4D"],
        ["\x9D\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x2E"],

        ["\x59\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x4E"],
        ["\x9D\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x2F"],

        ["\x59\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x4F"],
        ["\x9D\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x30"],

        ["\x59\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x50"],
        ["\x9D\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x31"],

        ["\x59\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x51"],
        ["\x9D\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x32"],

        ["\x59\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x52"],
        ["\x9D\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x33"],

        ["\x59\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x53"],
        ["\x9D\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x34"],

        ["\x59\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x54"],
        ["\x9D\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x35"],

        ["\x59\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x55"],
        ["\x9D\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x36"],

        ["\x59\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x56"],
        ["\x9D\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x37"],

        ["\x59\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x57"],
        ["\x9D\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x38"],

        ["\x59\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x58"],
        ["\x9D\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x39"],

        ["\x59\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x59"],
        ["\x9D\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x3A"],

        ["\x59\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x5A"],
        ["\x9D\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x3B"],

        ["\x59\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x5B"],
        ["\x9D\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x3C"],

        ["\x59\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x5C"],
        ["\x9D\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x3D"],

        ["\x59\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x5D"],
        ["\x9D\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x3E"],

        ["\x59\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x5E"],
        ["\x9D\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x3F"],

        ["\x59\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x5F"],
        ["\x9D\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x40"],

        ["\x59\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x60"],
        ["\x9D\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x41"],

        ["\x59\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x61"],
        ["\x9D\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x42"],

        ["\x59\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x62"],
        ["\x9D\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x43"],

        ["\x59\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x63"],
        ["\x9D\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x44"],

        ["\x59\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x64"],
        ["\x9D\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x45"],

        ["\x59\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x65"],
        ["\x9D\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x46"],

        ["\x59\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x66"],
        ["\x9D\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x47"],

        ["\x59\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x67"],
        ["\x9D\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x48"],

        ["\x59\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x68"],
        ["\x9D\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x49"],

        ["\x59\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x69"],
        ["\x9D\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x4A"],

        ["\x59\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x6A"],
        ["\x9D\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x4B"],

        ["\x59\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x6B"],
        ["\x9D\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x4C"],

        ["\x59\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x6C"],
        ["\x9D\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x4D"],

        ["\x59\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x6D"],
        ["\x9D\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x4E"],

        ["\x59\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x6E"],
        ["\x9D\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x4F"],

        ["\x59\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x6F"],
        ["\x9D\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x50"],

        ["\x59\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x70"],
        ["\x9D\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x51"],

        ["\x59\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x71"],
        ["\x9D\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x52"],

        ["\x59\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x72"],
        ["\x9D\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x53"],

        ["\x59\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x73"],
        ["\x9D\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x54"],

        ["\x59\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x74"],
        ["\x9D\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x55"],

        ["\x59\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x75"],
        ["\x9D\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x56"],

        ["\x59\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x76"],
        ["\x9D\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x57"],

        ["\x59\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x77"],
        ["\x9D\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x58"],

        ["\x59\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x78"],
        ["\x9D\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x59"],

        ["\x59\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x79"],
        ["\x9D\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x5A"],

        ["\x59\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x7A"],
        ["\x9D\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x5B"],

        ["\x59\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x7B"],
        ["\x9D\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x5C"],

        ["\x59\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x7C"],
        ["\x9D\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x5D"],

        ["\x59\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x7D"],
        ["\x9D\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x5E"],

        ["\x59\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x7E"],
        ["\x9D\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x5F"],

        ["\x59\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x80"],
        ["\x9D\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x60"],

        ["\x59\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x81"],
        ["\x9D\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x61"],

        ["\x59\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x82"],
        ["\x9D\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x62"],

        ["\x59\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x83"],
        ["\x9D\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x63"],

        ["\x59\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x84"],
        ["\x9D\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x64"],

        ["\x59\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x85"],
        ["\x9D\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x65"],

        ["\x59\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x86"],
        ["\x9D\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x66"],

        ["\x59\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x87"],
        ["\x9D\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x67"],

        ["\x59\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x88"],
        ["\x9D\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x68"],

        ["\x59\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x89"],
        ["\x9D\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x69"],

        ["\x59\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x8A"],
        ["\x9D\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x6A"],

        ["\x59\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x8B"],
        ["\x9D\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x6B"],

        ["\x59\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x8C"],
        ["\x9D\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x6C"],

        ["\x59\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x8D"],
        ["\x9D\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x6D"],

        ["\x59\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x8E"],
        ["\x9D\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x6E"],

        ["\x59\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x8F"],
        ["\x9D\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x6F"],

        ["\x59\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x90"],
        ["\x9D\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x70"],

        ["\x59\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x91"],
        ["\x9D\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x71"],

        ["\x59\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x92"],
        ["\x9D\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x72"],

        ["\x59\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x93"],
        ["\x9D\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x73"],

        ["\x59\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x94"],
        ["\x9D\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x74"],

        ["\x59\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x95"],
        ["\x9D\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x75"],

        ["\x59\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x96"],
        ["\x9D\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x76"],

        ["\x59\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x97"],
        ["\x9D\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x77"],

        ["\x33\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x98"],
        ["\x9D\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x49"],

        ["\x59\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x99"],
        ["\x9D\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x79"],

        ["\x59\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x9A"],
        ["\x9D\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x7A"],

        ["\x59\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x9B"],
        ["\x9D\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x7B"],

        ["\x59\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x9C"],
        ["\x9D\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x7C"],

        ["\x59\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x9D"],
        ["\x9D\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x7D"],

        ["\x59\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x9E"],
        ["\x9D\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x59\x7E"],

        ["\x5A\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\x9F"],
        ["\x9D\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x21"],

        ["\x5A\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xA0"],
        ["\x9D\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x22"],

        ["\x5A\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xA1"],
        ["\x9D\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x23"],

        ["\x5A\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xA2"],
        ["\x9D\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x24"],

        ["\x5A\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xA3"],
        ["\x9D\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x25"],

        ["\x5A\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xA4"],
        ["\x9D\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x26"],

        ["\x5A\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xA5"],
        ["\x9D\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x27"],

        ["\x5A\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xA6"],
        ["\x9D\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x28"],

        ["\x5A\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xA7"],
        ["\x9D\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x29"],

        ["\x5A\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xA8"],
        ["\x9D\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x2A"],

        ["\x5A\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xA9"],
        ["\x9D\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x2B"],

        ["\x5A\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xAA"],
        ["\x9D\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x2C"],

        ["\x5A\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xAB"],
        ["\x9D\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x2D"],

        ["\x5A\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xAC"],
        ["\x9D\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x2E"],

        ["\x5A\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xAD"],
        ["\x9D\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x2F"],

        ["\x5A\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xAE"],
        ["\x9D\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x30"],

        ["\x5A\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xAF"],
        ["\x9D\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x31"],

        ["\x5A\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xB0"],
        ["\x9D\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x32"],

        ["\x5A\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xB1"],
        ["\x9D\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x33"],

        ["\x5A\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xB2"],
        ["\x9D\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x34"],

        ["\x5A\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xB3"],
        ["\x9D\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x35"],

        ["\x5A\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xB4"],
        ["\x9D\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x36"],

        ["\x5A\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xB5"],
        ["\x9D\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x37"],

        ["\x5A\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xB6"],
        ["\x9D\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x38"],

        ["\x5A\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xB7"],
        ["\x9D\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x39"],

        ["\x5A\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xB8"],
        ["\x9D\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x3A"],

        ["\x5A\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xB9"],
        ["\x9D\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x3B"],

        ["\x5A\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xBA"],
        ["\x9D\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x3C"],

        ["\x5A\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xBB"],
        ["\x9D\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x3D"],

        ["\x5A\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xBC"],
        ["\x9D\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x3E"],

        ["\x5A\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xBD"],
        ["\x9D\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x3F"],

        ["\x5A\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xBE"],
        ["\x9D\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x40"],

        ["\x5A\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xBF"],
        ["\x9D\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x41"],

        ["\x5A\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xC0"],
        ["\x9D\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x42"],

        ["\x5A\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xC1"],
        ["\x9D\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x43"],

        ["\x5A\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xC2"],
        ["\x9D\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x44"],

        ["\x5A\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xC3"],
        ["\x9D\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x45"],

        ["\x5A\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xC4"],
        ["\x9D\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x46"],

        ["\x5A\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xC5"],
        ["\x9D\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x47"],

        ["\x5A\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xC6"],
        ["\x9D\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x48"],

        ["\x5A\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xC7"],
        ["\x9D\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x49"],

        ["\x5A\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xC8"],
        ["\x9D\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x4A"],

        ["\x5A\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xC9"],
        ["\x9D\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x4B"],

        ["\x5A\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xCA"],
        ["\x9D\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x4C"],

        ["\x5A\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xCB"],
        ["\x9D\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x4D"],

        ["\x5A\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xCC"],
        ["\x9D\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x4E"],

        ["\x5A\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xCD"],
        ["\x9D\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x4F"],

        ["\x5A\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xCE"],
        ["\x9D\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x50"],

        ["\x5A\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xCF"],
        ["\x9D\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x51"],

        ["\x5A\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xD0"],
        ["\x9D\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x52"],

        ["\x5A\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xD1"],
        ["\x9D\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x53"],

        ["\x5A\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xD2"],
        ["\x9D\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x54"],

        ["\x5A\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xD3"],
        ["\x9D\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x55"],

        ["\x5A\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xD4"],
        ["\x9D\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x56"],

        ["\x5A\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xD5"],
        ["\x9D\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x57"],

        ["\x5A\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xD6"],
        ["\x9D\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x58"],

        ["\x5A\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xD7"],
        ["\x9D\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x59"],

        ["\x5A\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xD8"],
        ["\x9D\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x5A"],

        ["\x5A\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xD9"],
        ["\x9D\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x5B"],

        ["\x5A\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xDA"],
        ["\x9D\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x5C"],

        ["\x5A\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xDB"],
        ["\x9D\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x5D"],

        ["\x5A\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xDC"],
        ["\x9D\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x5E"],

        ["\x5A\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xDD"],
        ["\x9D\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x5F"],

        ["\x5A\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xDE"],
        ["\x9D\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x60"],

        ["\x5A\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xDF"],
        ["\x9D\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x61"],

        ["\x5A\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xE0"],
        ["\x9D\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x62"],

        ["\x5A\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xE1"],
        ["\x9D\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x63"],

        ["\x5A\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xE2"],
        ["\x9D\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x64"],

        ["\x5A\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xE3"],
        ["\x9D\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x65"],

        ["\x5A\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xE4"],
        ["\x9D\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x66"],

        ["\x5A\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xE5"],
        ["\x9D\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x67"],

        ["\x5A\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xE6"],
        ["\x9D\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x68"],

        ["\x5A\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xE7"],
        ["\x9D\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x69"],

        ["\x5A\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xE8"],
        ["\x9D\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x6A"],

        ["\x5A\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xE9"],
        ["\x9D\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x6B"],

        ["\x5A\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xEA"],
        ["\x9D\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x6C"],

        ["\x5A\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xEB"],
        ["\x9D\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x6D"],

        ["\x5A\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xEC"],
        ["\x9D\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x6E"],

        ["\x5A\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xED"],
        ["\x9D\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x6F"],

        ["\x5A\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xEE"],
        ["\x9D\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x70"],

        ["\x5A\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xEF"],
        ["\x9D\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x71"],

        ["\x5A\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xF0"],
        ["\x9D\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x72"],

        ["\x5A\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xF1"],
        ["\x9D\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x73"],

        ["\x5A\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xF2"],
        ["\x9D\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x74"],

        ["\x5A\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xF3"],
        ["\x9D\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x75"],

        ["\x5A\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xF4"],
        ["\x9D\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x76"],

        ["\x5A\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xF5"],
        ["\x9D\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x77"],

        ["\x5A\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xF6"],
        ["\x9D\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x78"],

        ["\x5A\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xF7"],
        ["\x9D\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x79"],

        ["\x5A\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xF8"],
        ["\x9D\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x7A"],

        ["\x5A\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xF9"],
        ["\x9D\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x7B"],

        ["\x5A\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xFA"],
        ["\x9D\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x7C"],

        ["\x5A\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xFB"],
        ["\x9D\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x7D"],

        ["\x5A\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9D\xFC"],
        ["\x9D\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5A\x7E"],

        ["\x5B\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x40"],
        ["\x9E\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x21"],

        ["\x5B\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x41"],
        ["\x9E\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x22"],

        ["\x5B\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x42"],
        ["\x9E\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x23"],

        ["\x5B\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x43"],
        ["\x9E\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x24"],

        ["\x5B\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x44"],
        ["\x9E\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x25"],

        ["\x5B\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x45"],
        ["\x9E\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x26"],

        ["\x5B\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x46"],
        ["\x9E\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x27"],

        ["\x5B\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x47"],
        ["\x9E\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x28"],

        ["\x5B\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x48"],
        ["\x9E\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x29"],

        ["\x5B\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x49"],
        ["\x9E\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x2A"],

        ["\x5B\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x4A"],
        ["\x9E\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x2B"],

        ["\x5B\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x4B"],
        ["\x9E\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x2C"],

        ["\x5B\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x4C"],
        ["\x9E\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x2D"],

        ["\x5B\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x4D"],
        ["\x9E\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x2E"],

        ["\x5B\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x4E"],
        ["\x9E\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x2F"],

        ["\x5B\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x4F"],
        ["\x9E\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x30"],

        ["\x5B\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x50"],
        ["\x9E\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x31"],

        ["\x5B\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x51"],
        ["\x9E\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x32"],

        ["\x5B\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x52"],
        ["\x9E\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x33"],

        ["\x5B\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x53"],
        ["\x9E\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x34"],

        ["\x5B\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x54"],
        ["\x9E\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x35"],

        ["\x5B\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x55"],
        ["\x9E\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x36"],

        ["\x5B\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x56"],
        ["\x9E\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x37"],

        ["\x5B\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x57"],
        ["\x9E\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x38"],

        ["\x5B\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x58"],
        ["\x9E\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x39"],

        ["\x5B\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x59"],
        ["\x9E\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x3A"],

        ["\x5B\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x5A"],
        ["\x9E\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x3B"],

        ["\x5B\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x5B"],
        ["\x9E\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x3C"],

        ["\x5B\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x5C"],
        ["\x9E\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x3D"],

        ["\x5B\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x5D"],
        ["\x9E\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x3E"],

        ["\x5B\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x5E"],
        ["\x9E\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x3F"],

        ["\x5B\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x5F"],
        ["\x9E\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x40"],

        ["\x5B\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x60"],
        ["\x9E\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x41"],

        ["\x5B\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x61"],
        ["\x9E\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x42"],

        ["\x5B\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x62"],
        ["\x9E\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x43"],

        ["\x5B\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x63"],
        ["\x9E\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x44"],

        ["\x5B\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x64"],
        ["\x9E\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x45"],

        ["\x5B\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x65"],
        ["\x9E\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x46"],

        ["\x5B\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x66"],
        ["\x9E\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x47"],

        ["\x5B\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x67"],
        ["\x9E\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x48"],

        ["\x5B\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x68"],
        ["\x9E\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x49"],

        ["\x5B\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x69"],
        ["\x9E\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x4A"],

        ["\x5B\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x6A"],
        ["\x9E\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x4B"],

        ["\x5B\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x6B"],
        ["\x9E\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x4C"],

        ["\x5B\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x6C"],
        ["\x9E\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x4D"],

        ["\x5B\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x6D"],
        ["\x9E\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x4E"],

        ["\x5B\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x6E"],
        ["\x9E\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x4F"],

        ["\x5B\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x6F"],
        ["\x9E\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x50"],

        ["\x5B\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x70"],
        ["\x9E\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x51"],

        ["\x5B\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x71"],
        ["\x9E\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x52"],

        ["\x5B\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x72"],
        ["\x9E\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x53"],

        ["\x5B\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x73"],
        ["\x9E\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x54"],

        ["\x5B\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x74"],
        ["\x9E\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x55"],

        ["\x5B\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x75"],
        ["\x9E\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x56"],

        ["\x5B\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x76"],
        ["\x9E\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x57"],

        ["\x49\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x77"],
        ["\x9E\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x49\x30"],

        ["\x5B\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x78"],
        ["\x9E\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x59"],

        ["\x5B\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x79"],
        ["\x9E\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x5A"],

        ["\x5B\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x7A"],
        ["\x9E\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x5B"],

        ["\x5B\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x7B"],
        ["\x9E\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x5C"],

        ["\x5B\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x7C"],
        ["\x9E\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x5D"],

        ["\x5B\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x7D"],
        ["\x9E\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x5E"],

        ["\x5B\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x7E"],
        ["\x9E\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x5F"],

        ["\x5B\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x80"],
        ["\x9E\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x60"],

        ["\x5B\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x81"],
        ["\x9E\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x61"],

        ["\x5B\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x82"],
        ["\x9E\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x62"],

        ["\x5B\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x83"],
        ["\x9E\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x63"],

        ["\x5B\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x84"],
        ["\x9E\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x64"],

        ["\x5B\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x85"],
        ["\x9E\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x65"],

        ["\x5B\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x86"],
        ["\x9E\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x66"],

        ["\x5B\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x87"],
        ["\x9E\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x67"],

        ["\x5B\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x88"],
        ["\x9E\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x68"],

        ["\x5B\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x89"],
        ["\x9E\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x69"],

        ["\x5B\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x8A"],
        ["\x9E\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x6A"],

        ["\x5B\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x8B"],
        ["\x9E\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x6B"],

        ["\x5B\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x8C"],
        ["\x9E\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x6C"],

        ["\x45\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x8D"],
        ["\x9E\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x6E"],

        ["\x5B\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x8E"],
        ["\x9E\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x6E"],

        ["\x5B\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x8F"],
        ["\x9E\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x6F"],

        ["\x5B\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x90"],
        ["\x9E\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x70"],

        ["\x5B\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x91"],
        ["\x9E\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x71"],

        ["\x5B\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x92"],
        ["\x9E\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x72"],

        ["\x5B\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x93"],
        ["\x9E\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x73"],

        ["\x5B\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x94"],
        ["\x9E\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x74"],

        ["\x5B\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x95"],
        ["\x9E\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x75"],

        ["\x5B\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x96"],
        ["\x9E\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x76"],

        ["\x5B\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x97"],
        ["\x9E\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x77"],

        ["\x5B\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x98"],
        ["\x9E\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x78"],

        ["\x5B\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x99"],
        ["\x9E\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x79"],

        ["\x5B\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x9A"],
        ["\x9E\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x7A"],

        ["\x5B\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x9B"],
        ["\x9E\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x7B"],

        ["\x5B\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x9C"],
        ["\x9E\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x7C"],

        ["\x5B\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x9D"],
        ["\x9E\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x7D"],

        ["\x5B\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x9E"],
        ["\x9E\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5B\x7E"],

        ["\x5C\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\x9F"],
        ["\x9E\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x21"],

        ["\x5C\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xA0"],
        ["\x9E\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x22"],

        ["\x5C\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xA1"],
        ["\x9E\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x23"],

        ["\x5C\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xA2"],
        ["\x9E\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x24"],

        ["\x5C\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xA3"],
        ["\x9E\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x25"],

        ["\x5C\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xA4"],
        ["\x9E\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x26"],

        ["\x5C\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xA5"],
        ["\x9E\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x27"],

        ["\x5C\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xA6"],
        ["\x9E\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x28"],

        ["\x5C\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xA7"],
        ["\x9E\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x29"],

        ["\x5C\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xA8"],
        ["\x9E\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x2A"],

        ["\x5C\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xA9"],
        ["\x9E\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x2B"],

        ["\x5C\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xAA"],
        ["\x9E\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x2C"],

        ["\x5C\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xAB"],
        ["\x9E\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x2D"],

        ["\x5C\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xAC"],
        ["\x9E\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x2E"],

        ["\x5C\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xAD"],
        ["\x9E\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x2F"],

        ["\x5C\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xAE"],
        ["\x9E\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x30"],

        ["\x5C\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xAF"],
        ["\x9E\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x31"],

        ["\x5C\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xB0"],
        ["\x9E\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x32"],

        ["\x5C\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xB1"],
        ["\x9E\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x33"],

        ["\x5C\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xB2"],
        ["\x9E\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x34"],

        ["\x5C\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xB3"],
        ["\x9E\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x35"],

        ["\x5C\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xB4"],
        ["\x9E\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x36"],

        ["\x5C\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xB5"],
        ["\x9E\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x37"],

        ["\x5C\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xB6"],
        ["\x9E\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x38"],

        ["\x5C\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xB7"],
        ["\x9E\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x39"],

        ["\x5C\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xB8"],
        ["\x9E\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x3A"],

        ["\x5C\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xB9"],
        ["\x9E\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x3B"],

        ["\x5C\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xBA"],
        ["\x9E\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x3C"],

        ["\x5C\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xBB"],
        ["\x9E\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x3D"],

        ["\x5C\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xBC"],
        ["\x9E\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x3E"],

        ["\x5C\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xBD"],
        ["\x9E\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x3F"],

        ["\x5C\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xBE"],
        ["\x9E\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x40"],

        ["\x5C\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xBF"],
        ["\x9E\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x41"],

        ["\x5C\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xC0"],
        ["\x9E\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x42"],

        ["\x5C\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xC1"],
        ["\x9E\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x43"],

        ["\x5C\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xC2"],
        ["\x9E\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x44"],

        ["\x5C\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xC3"],
        ["\x9E\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x45"],

        ["\x5C\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xC4"],
        ["\x9E\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x46"],

        ["\x5C\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xC5"],
        ["\x9E\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x47"],

        ["\x5C\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xC6"],
        ["\x9E\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x48"],

        ["\x5C\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xC7"],
        ["\x9E\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x49"],

        ["\x5C\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xC8"],
        ["\x9E\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x4A"],

        ["\x5C\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xC9"],
        ["\x9E\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x4B"],

        ["\x5C\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xCA"],
        ["\x9E\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x4C"],

        ["\x5C\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xCB"],
        ["\x9E\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x4D"],

        ["\x5C\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xCC"],
        ["\x9E\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x4E"],

        ["\x5C\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xCD"],
        ["\x9E\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x4F"],

        ["\x5C\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xCE"],
        ["\x9E\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x50"],

        ["\x5C\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xCF"],
        ["\x9E\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x51"],

        ["\x5C\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xD0"],
        ["\x9E\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x52"],

        ["\x5C\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xD1"],
        ["\x9E\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x53"],

        ["\x5C\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xD2"],
        ["\x9E\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x54"],

        ["\x5C\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xD3"],
        ["\x9E\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x55"],

        ["\x5C\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xD4"],
        ["\x9E\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x56"],

        ["\x5C\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xD5"],
        ["\x9E\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x57"],

        ["\x5C\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xD6"],
        ["\x9E\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x58"],

        ["\x5C\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xD7"],
        ["\x9E\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x59"],

        ["\x5C\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xD8"],
        ["\x9E\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x5A"],

        ["\x5C\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xD9"],
        ["\x9E\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x5B"],

        ["\x5C\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xDA"],
        ["\x9E\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x5C"],

        ["\x5C\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xDB"],
        ["\x9E\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x5D"],

        ["\x5C\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xDC"],
        ["\x9E\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x5E"],

        ["\x5C\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xDD"],
        ["\x9E\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x5F"],

        ["\x5C\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xDE"],
        ["\x9E\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x60"],

        ["\x5C\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xDF"],
        ["\x9E\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x61"],

        ["\x5C\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xE0"],
        ["\x9E\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x62"],

        ["\x5C\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xE1"],
        ["\x9E\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x63"],

        ["\x5C\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xE2"],
        ["\x9E\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x64"],

        ["\x5C\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xE3"],
        ["\x9E\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x65"],

        ["\x5C\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xE4"],
        ["\x9E\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x66"],

        ["\x5C\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xE5"],
        ["\x9E\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x67"],

        ["\x5C\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xE6"],
        ["\x9E\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x68"],

        ["\x5C\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xE7"],
        ["\x9E\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x69"],

        ["\x5C\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xE8"],
        ["\x9E\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x6A"],

        ["\x5C\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xE9"],
        ["\x9E\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x6B"],

        ["\x5C\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xEA"],
        ["\x9E\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x6C"],

        ["\x5C\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xEB"],
        ["\x9E\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x6D"],

        ["\x5C\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xEC"],
        ["\x9E\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x6E"],

        ["\x5C\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xED"],
        ["\x9E\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x6F"],

        ["\x5C\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xEE"],
        ["\x9E\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x70"],

        ["\x5C\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xEF"],
        ["\x9E\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x71"],

        ["\x5C\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xF0"],
        ["\x9E\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x72"],

        ["\x5C\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xF1"],
        ["\x9E\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x73"],

        ["\x5C\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xF2"],
        ["\x9E\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x74"],

        ["\x5C\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xF3"],
        ["\x9E\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x75"],

        ["\x5C\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xF4"],
        ["\x9E\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x76"],

        ["\x5C\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xF5"],
        ["\x9E\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x77"],

        ["\x5C\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xF6"],
        ["\x9E\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x78"],

        ["\x5C\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xF7"],
        ["\x9E\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x79"],

        ["\x5C\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xF8"],
        ["\x9E\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x7A"],

        ["\x5C\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xF9"],
        ["\x9E\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x7B"],

        ["\x5C\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xFA"],
        ["\x9E\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x7C"],

        ["\x5C\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xFB"],
        ["\x9E\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x7D"],

        ["\x5C\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9E\xFC"],
        ["\x9E\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5C\x7E"],

        ["\x5D\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x40"],
        ["\x9F\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x21"],

        ["\x5D\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x41"],
        ["\x9F\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x22"],

        ["\x5D\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x42"],
        ["\x9F\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x23"],

        ["\x5D\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x43"],
        ["\x9F\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x24"],

        ["\x5D\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x44"],
        ["\x9F\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x25"],

        ["\x5D\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x45"],
        ["\x9F\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x26"],

        ["\x5D\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x46"],
        ["\x9F\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x27"],

        ["\x5D\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x47"],
        ["\x9F\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x28"],

        ["\x5D\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x48"],
        ["\x9F\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x29"],

        ["\x5D\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x49"],
        ["\x9F\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x2A"],

        ["\x5D\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x4A"],
        ["\x9F\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x2B"],

        ["\x5D\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x4B"],
        ["\x9F\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x2C"],

        ["\x5D\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x4C"],
        ["\x9F\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x2D"],

        ["\x5D\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x4D"],
        ["\x9F\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x2E"],

        ["\x5D\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x4E"],
        ["\x9F\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x2F"],

        ["\x5D\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x4F"],
        ["\x9F\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x30"],

        ["\x5D\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x50"],
        ["\x9F\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x31"],

        ["\x5D\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x51"],
        ["\x9F\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x32"],

        ["\x5D\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x52"],
        ["\x9F\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x33"],

        ["\x5D\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x53"],
        ["\x9F\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x34"],

        ["\x5D\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x54"],
        ["\x9F\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x35"],

        ["\x5D\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x55"],
        ["\x9F\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x36"],

        ["\x5D\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x56"],
        ["\x9F\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x37"],

        ["\x5D\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x57"],
        ["\x9F\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x38"],

        ["\x5D\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x58"],
        ["\x9F\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x39"],

        ["\x5D\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x59"],
        ["\x9F\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x3A"],

        ["\x5D\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x5A"],
        ["\x9F\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x3B"],

        ["\x5D\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x5B"],
        ["\x9F\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x3C"],

        ["\x5D\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x5C"],
        ["\x9F\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x3D"],

        ["\x5D\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x5D"],
        ["\x9F\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x3E"],

        ["\x5D\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x5E"],
        ["\x9F\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x3F"],

        ["\x5D\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x5F"],
        ["\x9F\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x40"],

        ["\x5D\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x60"],
        ["\x9F\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x41"],

        ["\x5D\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x61"],
        ["\x9F\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x42"],

        ["\x5D\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x62"],
        ["\x9F\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x43"],

        ["\x5D\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x63"],
        ["\x9F\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x44"],

        ["\x5D\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x64"],
        ["\x9F\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x45"],

        ["\x5D\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x65"],
        ["\x9F\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x46"],

        ["\x5D\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x66"],
        ["\x9F\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x47"],

        ["\x5D\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x67"],
        ["\x9F\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x48"],

        ["\x5D\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x68"],
        ["\x9F\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x49"],

        ["\x5D\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x69"],
        ["\x9F\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x4A"],

        ["\x5D\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x6A"],
        ["\x9F\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x4B"],

        ["\x5D\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x6B"],
        ["\x9F\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x4C"],

        ["\x5D\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x6C"],
        ["\x9F\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x4D"],

        ["\x5D\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x6D"],
        ["\x9F\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x4E"],

        ["\x5D\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x6E"],
        ["\x9F\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x4F"],

        ["\x5D\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x6F"],
        ["\x9F\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x50"],

        ["\x5D\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x70"],
        ["\x9F\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x51"],

        ["\x5D\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x71"],
        ["\x9F\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x52"],

        ["\x5D\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x72"],
        ["\x9F\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x53"],

        ["\x5D\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x73"],
        ["\x9F\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x54"],

        ["\x5D\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x74"],
        ["\x9F\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x55"],

        ["\x5D\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x75"],
        ["\x9F\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x56"],

        ["\x5D\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x76"],
        ["\x9F\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x57"],

        ["\x5D\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x77"],
        ["\x9F\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x58"],

        ["\x5D\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x78"],
        ["\x9F\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x59"],

        ["\x5D\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x79"],
        ["\x9F\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x5A"],

        ["\x5D\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x7A"],
        ["\x9F\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x5B"],

        ["\x5D\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x7B"],
        ["\x9F\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x5C"],

        ["\x5D\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x7C"],
        ["\x9F\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x5D"],

        ["\x5D\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x7D"],
        ["\x9F\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x5E"],

        ["\x5D\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x7E"],
        ["\x9F\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x5F"],

        ["\x5D\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x80"],
        ["\x9F\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x60"],

        ["\x5D\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x81"],
        ["\x9F\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x61"],

        ["\x5D\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x82"],
        ["\x9F\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x62"],

        ["\x5D\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x83"],
        ["\x9F\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x63"],

        ["\x5D\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x84"],
        ["\x9F\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x64"],

        ["\x5D\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x85"],
        ["\x9F\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x65"],

        ["\x5D\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x86"],
        ["\x9F\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x66"],

        ["\x5D\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x87"],
        ["\x9F\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x67"],

        ["\x5D\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x88"],
        ["\x9F\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x68"],

        ["\x5D\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x89"],
        ["\x9F\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x69"],

        ["\x5D\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x8A"],
        ["\x9F\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x6A"],

        ["\x5D\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x8B"],
        ["\x9F\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x6B"],

        ["\x5D\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x8C"],
        ["\x9F\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x6C"],

        ["\x5D\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x8D"],
        ["\x9F\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x6D"],

        ["\x5D\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x8E"],
        ["\x9F\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x6E"],

        ["\x5D\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x8F"],
        ["\x9F\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x6F"],

        ["\x5D\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x90"],
        ["\x9F\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x70"],

        ["\x5D\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x91"],
        ["\x9F\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x71"],

        ["\x5D\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x92"],
        ["\x9F\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x72"],

        ["\x5D\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x93"],
        ["\x9F\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x73"],

        ["\x5D\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x94"],
        ["\x9F\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x74"],

        ["\x5D\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x95"],
        ["\x9F\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x75"],

        ["\x5D\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x96"],
        ["\x9F\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x76"],

        ["\x5D\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x97"],
        ["\x9F\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x77"],

        ["\x5D\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x98"],
        ["\x9F\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x78"],

        ["\x5D\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x99"],
        ["\x9F\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x79"],

        ["\x5D\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x9A"],
        ["\x9F\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x7A"],

        ["\x5D\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x9B"],
        ["\x9F\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x7B"],

        ["\x5D\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x9C"],
        ["\x9F\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x7C"],

        ["\x5D\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x9D"],
        ["\x9F\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x7D"],

        ["\x5D\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x9E"],
        ["\x9F\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5D\x7E"],

        ["\x5E\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\x9F"],
        ["\x9F\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x21"],

        ["\x5E\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xA0"],
        ["\x9F\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x22"],

        ["\x5E\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xA1"],
        ["\x9F\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x23"],

        ["\x5E\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xA2"],
        ["\x9F\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x24"],

        ["\x5E\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xA3"],
        ["\x9F\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x25"],

        ["\x5E\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xA4"],
        ["\x9F\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x26"],

        ["\x5E\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xA5"],
        ["\x9F\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x27"],

        ["\x5E\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xA6"],
        ["\x9F\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x28"],

        ["\x5E\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xA7"],
        ["\x9F\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x29"],

        ["\x5E\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xA8"],
        ["\x9F\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x2A"],

        ["\x5E\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xA9"],
        ["\x9F\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x2B"],

        ["\x5E\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xAA"],
        ["\x9F\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x2C"],

        ["\x5E\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xAB"],
        ["\x9F\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x2D"],

        ["\x5E\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xAC"],
        ["\x9F\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x2E"],

        ["\x5E\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xAD"],
        ["\x9F\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x2F"],

        ["\x5E\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xAE"],
        ["\x9F\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x30"],

        ["\x5E\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xAF"],
        ["\x9F\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x31"],

        ["\x5E\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xB0"],
        ["\x9F\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x32"],

        ["\x5E\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xB1"],
        ["\x9F\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x33"],

        ["\x5E\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xB2"],
        ["\x9F\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x34"],

        ["\x5E\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xB3"],
        ["\x9F\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x35"],

        ["\x5E\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xB4"],
        ["\x9F\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x36"],

        ["\x5E\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xB5"],
        ["\x9F\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x37"],

        ["\x5E\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xB6"],
        ["\x9F\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x38"],

        ["\x45\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xB7"],
        ["\x9F\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x73"],

        ["\x5E\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xB8"],
        ["\x9F\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x3A"],

        ["\x5E\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xB9"],
        ["\x9F\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x3B"],

        ["\x5E\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xBA"],
        ["\x9F\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x3C"],

        ["\x5E\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xBB"],
        ["\x9F\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x3D"],

        ["\x5E\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xBC"],
        ["\x9F\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x3E"],

        ["\x5E\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xBD"],
        ["\x9F\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x3F"],

        ["\x5E\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xBE"],
        ["\x9F\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x40"],

        ["\x5E\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xBF"],
        ["\x9F\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x41"],

        ["\x5E\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xC0"],
        ["\x9F\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x42"],

        ["\x5E\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xC1"],
        ["\x9F\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x43"],

        ["\x5E\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xC2"],
        ["\x9F\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x44"],

        ["\x5E\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xC3"],
        ["\x9F\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x45"],

        ["\x5E\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xC4"],
        ["\x9F\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x46"],

        ["\x5E\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xC5"],
        ["\x9F\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x47"],

        ["\x5E\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xC6"],
        ["\x9F\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x48"],

        ["\x5E\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xC7"],
        ["\x9F\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x49"],

        ["\x5E\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xC8"],
        ["\x9F\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x4A"],

        ["\x5E\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xC9"],
        ["\x9F\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x4B"],

        ["\x5E\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xCA"],
        ["\x9F\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x4C"],

        ["\x5E\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xCB"],
        ["\x9F\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x4D"],

        ["\x5E\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xCC"],
        ["\x9F\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x4E"],

        ["\x5E\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xCD"],
        ["\x9F\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x4F"],

        ["\x5E\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xCE"],
        ["\x9F\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x50"],

        ["\x5E\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xCF"],
        ["\x9F\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x51"],

        ["\x5E\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xD0"],
        ["\x9F\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x52"],

        ["\x5E\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xD1"],
        ["\x9F\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x53"],

        ["\x5E\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xD2"],
        ["\x9F\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x54"],

        ["\x5E\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xD3"],
        ["\x9F\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x55"],

        ["\x5E\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xD4"],
        ["\x9F\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x56"],

        ["\x5E\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xD5"],
        ["\x9F\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x57"],

        ["\x5E\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xD6"],
        ["\x9F\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x58"],

        ["\x5E\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xD7"],
        ["\x9F\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x59"],

        ["\x5E\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xD8"],
        ["\x9F\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x5A"],

        ["\x5E\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xD9"],
        ["\x9F\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x5B"],

        ["\x5E\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xDA"],
        ["\x9F\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x5C"],

        ["\x5E\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xDB"],
        ["\x9F\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x5D"],

        ["\x5E\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xDC"],
        ["\x9F\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x5E"],

        ["\x5E\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xDD"],
        ["\x9F\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x5F"],

        ["\x5E\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xDE"],
        ["\x9F\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x60"],

        ["\x5E\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xDF"],
        ["\x9F\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x61"],

        ["\x5E\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xE0"],
        ["\x9F\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x62"],

        ["\x5E\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xE1"],
        ["\x9F\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x63"],

        ["\x5E\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xE2"],
        ["\x9F\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x64"],

        ["\x5E\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xE3"],
        ["\x9F\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x65"],

        ["\x5E\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xE4"],
        ["\x9F\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x66"],

        ["\x5E\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xE5"],
        ["\x9F\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x67"],

        ["\x5E\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xE6"],
        ["\x9F\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x68"],

        ["\x5E\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xE7"],
        ["\x9F\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x69"],

        ["\x5E\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xE8"],
        ["\x9F\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x6A"],

        ["\x5E\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xE9"],
        ["\x9F\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x6B"],

        ["\x5E\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xEA"],
        ["\x9F\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x6C"],

        ["\x5E\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xEB"],
        ["\x9F\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x6D"],

        ["\x5E\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xEC"],
        ["\x9F\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x6E"],

        ["\x5E\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xED"],
        ["\x9F\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x6F"],

        ["\x5E\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xEE"],
        ["\x9F\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x70"],

        ["\x5E\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xEF"],
        ["\x9F\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x71"],

        ["\x5E\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xF0"],
        ["\x9F\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x72"],

        ["\x5E\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xF1"],
        ["\x9F\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x73"],

        ["\x5E\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xF2"],
        ["\x9F\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x74"],

        ["\x34\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xF3"],
        ["\x9F\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x43"],

        ["\x5E\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xF4"],
        ["\x9F\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x76"],

        ["\x5E\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xF5"],
        ["\x9F\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x77"],

        ["\x5E\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xF6"],
        ["\x9F\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x78"],

        ["\x5E\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xF7"],
        ["\x9F\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x79"],

        ["\x5E\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xF8"],
        ["\x9F\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x7A"],

        ["\x5E\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xF9"],
        ["\x9F\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x7B"],

        ["\x5E\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xFA"],
        ["\x9F\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x7C"],

        ["\x5E\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xFB"],
        ["\x9F\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x7D"],

        ["\x5E\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\x9F\xFC"],
        ["\x9F\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5E\x7E"],

        ["\x5F\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x40"],
        ["\xE0\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x21"],

        ["\x5F\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x41"],
        ["\xE0\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x22"],

        ["\x5F\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x42"],
        ["\xE0\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x23"],

        ["\x5F\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x43"],
        ["\xE0\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x24"],

        ["\x5F\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x44"],
        ["\xE0\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x25"],

        ["\x5F\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x45"],
        ["\xE0\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x26"],

        ["\x5F\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x46"],
        ["\xE0\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x27"],

        ["\x5F\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x47"],
        ["\xE0\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x28"],

        ["\x5F\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x48"],
        ["\xE0\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x29"],

        ["\x5F\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x49"],
        ["\xE0\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x2A"],

        ["\x5F\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x4A"],
        ["\xE0\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x2B"],

        ["\x5F\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x4B"],
        ["\xE0\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x2C"],

        ["\x5F\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x4C"],
        ["\xE0\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x2D"],

        ["\x5F\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x4D"],
        ["\xE0\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x2E"],

        ["\x5F\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x4E"],
        ["\xE0\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x2F"],

        ["\x5F\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x4F"],
        ["\xE0\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x30"],

        ["\x5F\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x50"],
        ["\xE0\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x31"],

        ["\x5F\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x51"],
        ["\xE0\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x32"],

        ["\x5F\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x52"],
        ["\xE0\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x33"],

        ["\x5F\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x53"],
        ["\xE0\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x34"],

        ["\x5F\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x54"],
        ["\xE0\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x35"],

        ["\x5F\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x55"],
        ["\xE0\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x36"],

        ["\x5F\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x56"],
        ["\xE0\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x37"],

        ["\x5F\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x57"],
        ["\xE0\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x38"],

        ["\x5F\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x58"],
        ["\xE0\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x39"],

        ["\x5F\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x59"],
        ["\xE0\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x3A"],

        ["\x5F\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x5A"],
        ["\xE0\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x3B"],

        ["\x5F\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x5B"],
        ["\xE0\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x3C"],

        ["\x5F\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x5C"],
        ["\xE0\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x3D"],

        ["\x5F\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x5D"],
        ["\xE0\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x3E"],

        ["\x5F\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x5E"],
        ["\xE0\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x3F"],

        ["\x5F\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x5F"],
        ["\xE0\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x40"],

        ["\x5F\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x60"],
        ["\xE0\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x41"],

        ["\x5F\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x61"],
        ["\xE0\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x42"],

        ["\x5F\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x62"],
        ["\xE0\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x43"],

        ["\x5F\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x63"],
        ["\xE0\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x44"],

        ["\x5F\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x64"],
        ["\xE0\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x45"],

        ["\x5F\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x65"],
        ["\xE0\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x46"],

        ["\x5F\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x66"],
        ["\xE0\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x47"],

        ["\x5F\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x67"],
        ["\xE0\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x48"],

        ["\x5F\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x68"],
        ["\xE0\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x49"],

        ["\x5F\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x69"],
        ["\xE0\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x4A"],

        ["\x5F\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x6A"],
        ["\xE0\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x4B"],

        ["\x5F\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x6B"],
        ["\xE0\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x4C"],

        ["\x5F\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x6C"],
        ["\xE0\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x4D"],

        ["\x5F\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x6D"],
        ["\xE0\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x4E"],

        ["\x5F\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x6E"],
        ["\xE0\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x4F"],

        ["\x5F\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x6F"],
        ["\xE0\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x50"],

        ["\x5F\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x70"],
        ["\xE0\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x51"],

        ["\x5F\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x71"],
        ["\xE0\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x52"],

        ["\x5F\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x72"],
        ["\xE0\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x53"],

        ["\x5F\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x73"],
        ["\xE0\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x54"],

        ["\x5F\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x74"],
        ["\xE0\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x55"],

        ["\x5F\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x75"],
        ["\xE0\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x56"],

        ["\x5F\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x76"],
        ["\xE0\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x57"],

        ["\x5F\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x77"],
        ["\xE0\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x58"],

        ["\x5F\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x78"],
        ["\xE0\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x59"],

        ["\x5F\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x79"],
        ["\xE0\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x5A"],

        ["\x5F\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x7A"],
        ["\xE0\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x5B"],

        ["\x5F\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x7B"],
        ["\xE0\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x5C"],

        ["\x5F\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x7C"],
        ["\xE0\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x5D"],

        ["\x5F\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x7D"],
        ["\xE0\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x5E"],

        ["\x5F\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x7E"],
        ["\xE0\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x5F"],

        ["\x5F\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x80"],
        ["\xE0\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x60"],

        ["\x5F\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x81"],
        ["\xE0\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x61"],

        ["\x5F\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x82"],
        ["\xE0\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x62"],

        ["\x5F\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x83"],
        ["\xE0\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x63"],

        ["\x5F\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x84"],
        ["\xE0\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x64"],

        ["\x5F\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x85"],
        ["\xE0\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x65"],

        ["\x5F\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x86"],
        ["\xE0\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x66"],

        ["\x5F\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x87"],
        ["\xE0\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x67"],

        ["\x5F\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x88"],
        ["\xE0\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x68"],

        ["\x5F\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x89"],
        ["\xE0\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x69"],

        ["\x5F\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x8A"],
        ["\xE0\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x6A"],

        ["\x5F\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x8B"],
        ["\xE0\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x6B"],

        ["\x5F\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x8C"],
        ["\xE0\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x6C"],

        ["\x5F\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x8D"],
        ["\xE0\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x6D"],

        ["\x5F\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x8E"],
        ["\xE0\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x6E"],

        ["\x5F\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x8F"],
        ["\xE0\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x6F"],

        ["\x5F\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x90"],
        ["\xE0\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x70"],

        ["\x5F\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x91"],
        ["\xE0\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x71"],

        ["\x5F\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x92"],
        ["\xE0\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x72"],

        ["\x5F\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x93"],
        ["\xE0\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x73"],

        ["\x5F\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x94"],
        ["\xE0\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x74"],

        ["\x5F\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x95"],
        ["\xE0\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x75"],

        ["\x5F\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x96"],
        ["\xE0\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x76"],

        ["\x5F\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x97"],
        ["\xE0\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x77"],

        ["\x5F\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x98"],
        ["\xE0\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x78"],

        ["\x5F\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x99"],
        ["\xE0\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x79"],

        ["\x5F\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x9A"],
        ["\xE0\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x7A"],

        ["\x5F\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x9B"],
        ["\xE0\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x7B"],

        ["\x5F\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x9C"],
        ["\xE0\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x7C"],

        ["\x5F\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x9D"],
        ["\xE0\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x7D"],

        ["\x5F\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x9E"],
        ["\xE0\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x5F\x7E"],

        ["\x60\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\x9F"],
        ["\xE0\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x21"],

        ["\x60\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA0"],
        ["\xE0\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x22"],

        ["\x60\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],
        ["\xE0\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x23"],

        ["\x60\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],
        ["\xE0\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x24"],

        ["\x60\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],
        ["\xE0\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x25"],

        ["\x60\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],
        ["\xE0\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x26"],

        ["\x60\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],
        ["\xE0\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x27"],

        ["\x60\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],
        ["\xE0\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x28"],

        ["\x60\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],
        ["\xE0\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x29"],

        ["\x60\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],
        ["\xE0\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x2A"],

        ["\x60\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],
        ["\xE0\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x2B"],

        ["\x60\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],
        ["\xE0\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x2C"],

        ["\x60\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],
        ["\xE0\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x2D"],

        ["\x60\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],
        ["\xE0\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x2E"],

        ["\x60\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],
        ["\xE0\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x2F"],

        ["\x60\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],
        ["\xE0\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x30"],

        ["\x60\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],
        ["\xE0\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x31"],

        ["\x60\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],
        ["\xE0\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x32"],

        ["\x60\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],
        ["\xE0\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x33"],

        ["\x60\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],
        ["\xE0\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x34"],

        ["\x60\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],
        ["\xE0\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x35"],

        ["\x60\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],
        ["\xE0\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x36"],

        ["\x60\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],
        ["\xE0\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x37"],

        ["\x60\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],
        ["\xE0\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x38"],

        ["\x60\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],
        ["\xE0\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x39"],

        ["\x60\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],
        ["\xE0\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x3A"],

        ["\x60\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],
        ["\xE0\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x3B"],

        ["\x60\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],
        ["\xE0\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x3C"],

        ["\x60\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],
        ["\xE0\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x3D"],

        ["\x60\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],
        ["\xE0\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x3E"],

        ["\x60\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],
        ["\xE0\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x3F"],

        ["\x60\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],
        ["\xE0\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x40"],

        ["\x60\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],
        ["\xE0\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x41"],

        ["\x60\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],
        ["\xE0\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x42"],

        ["\x60\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],
        ["\xE0\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x43"],

        ["\x60\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],
        ["\xE0\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x44"],

        ["\x60\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],
        ["\xE0\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x45"],

        ["\x60\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],
        ["\xE0\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x46"],

        ["\x60\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],
        ["\xE0\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x47"],

        ["\x60\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],
        ["\xE0\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x48"],

        ["\x60\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],
        ["\xE0\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x49"],

        ["\x60\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],
        ["\xE0\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x4A"],

        ["\x60\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],
        ["\xE0\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x4B"],

        ["\x60\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],
        ["\xE0\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x4C"],

        ["\x60\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],
        ["\xE0\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x4D"],

        ["\x60\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],
        ["\xE0\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x4E"],

        ["\x60\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],
        ["\xE0\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x4F"],

        ["\x60\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],
        ["\xE0\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x50"],

        ["\x60\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],
        ["\xE0\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x51"],

        ["\x60\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],
        ["\xE0\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x52"],

        ["\x60\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],
        ["\xE0\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x53"],

        ["\x60\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],
        ["\xE0\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x54"],

        ["\x60\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],
        ["\xE0\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x55"],

        ["\x60\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],
        ["\xE0\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x56"],

        ["\x60\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],
        ["\xE0\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x57"],

        ["\x60\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],
        ["\xE0\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x58"],

        ["\x60\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],
        ["\xE0\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x59"],

        ["\x60\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],
        ["\xE0\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x5A"],

        ["\x60\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],
        ["\xE0\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x5B"],

        ["\x60\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],
        ["\xE0\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x5C"],

        ["\x60\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],
        ["\xE0\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x5D"],

        ["\x60\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],
        ["\xE0\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x5E"],

        ["\x60\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],
        ["\xE0\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x5F"],

        ["\x60\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],
        ["\xE0\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x60"],

        ["\x60\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],
        ["\xE0\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x61"],

        ["\x60\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],
        ["\xE0\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x62"],

        ["\x60\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],
        ["\xE0\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x63"],

        ["\x60\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],
        ["\xE0\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x64"],

        ["\x60\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],
        ["\xE0\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x65"],

        ["\x60\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],
        ["\xE0\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x66"],

        ["\x60\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],
        ["\xE0\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x67"],

        ["\x60\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],
        ["\xE0\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x68"],

        ["\x60\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],
        ["\xE0\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x69"],

        ["\x60\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],
        ["\xE0\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x6A"],

        ["\x60\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],
        ["\xE0\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x6B"],

        ["\x60\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],
        ["\xE0\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x6C"],

        ["\x60\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],
        ["\xE0\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x6D"],

        ["\x60\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],
        ["\xE0\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x6E"],

        ["\x60\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],
        ["\xE0\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x6F"],

        ["\x60\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],
        ["\xE0\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x70"],

        ["\x60\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],
        ["\xE0\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x71"],

        ["\x60\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],
        ["\xE0\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x72"],

        ["\x60\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],
        ["\xE0\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x73"],

        ["\x60\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],
        ["\xE0\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x74"],

        ["\x60\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],
        ["\xE0\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x75"],

        ["\xC4\xE8",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],
        ["\xE0\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],

        ["\x60\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],
        ["\xE0\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x77"],

        ["\x60\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],
        ["\xE0\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x78"],

        ["\x60\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],
        ["\xE0\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x79"],

        ["\x60\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],
        ["\xE0\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x7A"],

        ["\x60\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],
        ["\xE0\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x7B"],

        ["\x60\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],
        ["\xE0\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x7C"],

        ["\x60\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],
        ["\xE0\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x7D"],

        ["\x60\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],
        ["\xE0\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x60\x7E"],

        ["\x61\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x40"],
        ["\xE1\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x21"],

        ["\x61\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x41"],
        ["\xE1\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x22"],

        ["\x61\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x42"],
        ["\xE1\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x23"],

        ["\x61\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x43"],
        ["\xE1\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x24"],

        ["\x61\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x44"],
        ["\xE1\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x25"],

        ["\x61\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x45"],
        ["\xE1\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x26"],

        ["\x61\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x46"],
        ["\xE1\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x27"],

        ["\x61\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x47"],
        ["\xE1\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x28"],

        ["\x61\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x48"],
        ["\xE1\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x29"],

        ["\x61\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x49"],
        ["\xE1\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x2A"],

        ["\x61\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x4A"],
        ["\xE1\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x2B"],

        ["\x61\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x4B"],
        ["\xE1\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x2C"],

        ["\x61\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x4C"],
        ["\xE1\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x2D"],

        ["\x61\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x4D"],
        ["\xE1\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x2E"],

        ["\x61\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x4E"],
        ["\xE1\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x2F"],

        ["\x61\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x4F"],
        ["\xE1\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x30"],

        ["\x61\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x50"],
        ["\xE1\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x31"],

        ["\x61\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x51"],
        ["\xE1\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x32"],

        ["\x61\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x52"],
        ["\xE1\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x33"],

        ["\x61\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x53"],
        ["\xE1\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x34"],

        ["\x61\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x54"],
        ["\xE1\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x35"],

        ["\x61\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x55"],
        ["\xE1\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x36"],

        ["\x61\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x56"],
        ["\xE1\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x37"],

        ["\x61\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x57"],
        ["\xE1\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x38"],

        ["\x61\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x58"],
        ["\xE1\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x39"],

        ["\x61\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x59"],
        ["\xE1\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x3A"],

        ["\x61\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x5A"],
        ["\xE1\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x3B"],

        ["\x61\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x5B"],
        ["\xE1\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x3C"],

        ["\x61\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x5C"],
        ["\xE1\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x3D"],

        ["\x61\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x5D"],
        ["\xE1\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x3E"],

        ["\x61\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x5E"],
        ["\xE1\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x3F"],

        ["\x61\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x5F"],
        ["\xE1\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x40"],

        ["\x61\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x60"],
        ["\xE1\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x41"],

        ["\x61\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x61"],
        ["\xE1\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x42"],

        ["\x61\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x62"],
        ["\xE1\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x43"],

        ["\x61\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x63"],
        ["\xE1\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x44"],

        ["\x61\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x64"],
        ["\xE1\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x45"],

        ["\x61\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x65"],
        ["\xE1\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x46"],

        ["\x61\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x66"],
        ["\xE1\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x47"],

        ["\x61\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x67"],
        ["\xE1\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x48"],

        ["\x61\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x68"],
        ["\xE1\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x49"],

        ["\x61\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x69"],
        ["\xE1\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x4A"],

        ["\x61\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x6A"],
        ["\xE1\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x4B"],

        ["\x61\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x6B"],
        ["\xE1\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x4C"],

        ["\x61\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x6C"],
        ["\xE1\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x4D"],

        ["\x61\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x6D"],
        ["\xE1\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x4E"],

        ["\x61\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x6E"],
        ["\xE1\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x4F"],

        ["\x61\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x6F"],
        ["\xE1\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x50"],

        ["\x61\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x70"],
        ["\xE1\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x51"],

        ["\x61\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x71"],
        ["\xE1\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x52"],

        ["\x61\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x72"],
        ["\xE1\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x53"],

        ["\x61\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x73"],
        ["\xE1\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x54"],

        ["\x61\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x74"],
        ["\xE1\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x55"],

        ["\x61\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x75"],
        ["\xE1\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x56"],

        ["\x61\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x76"],
        ["\xE1\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x57"],

        ["\x61\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x77"],
        ["\xE1\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x58"],

        ["\x61\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x78"],
        ["\xE1\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x59"],

        ["\x61\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x79"],
        ["\xE1\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x5A"],

        ["\x61\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x7A"],
        ["\xE1\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x5B"],

        ["\x61\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x7B"],
        ["\xE1\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x5C"],

        ["\x61\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x7C"],
        ["\xE1\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x5D"],

        ["\x61\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x7D"],
        ["\xE1\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x5E"],

        ["\x61\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x7E"],
        ["\xE1\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x5F"],

        ["\x61\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x80"],
        ["\xE1\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x60"],

        ["\x61\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x81"],
        ["\xE1\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x61"],

        ["\x61\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x82"],
        ["\xE1\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x62"],

        ["\x61\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x83"],
        ["\xE1\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x63"],

        ["\x61\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x84"],
        ["\xE1\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x64"],

        ["\x61\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x85"],
        ["\xE1\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x65"],

        ["\x61\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x86"],
        ["\xE1\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x66"],

        ["\x61\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x87"],
        ["\xE1\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x67"],

        ["\x61\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x88"],
        ["\xE1\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x68"],

        ["\x61\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x89"],
        ["\xE1\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x69"],

        ["\x61\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x8A"],
        ["\xE1\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x6A"],

        ["\x61\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x8B"],
        ["\xE1\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x6B"],

        ["\x61\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x8C"],
        ["\xE1\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x6C"],

        ["\x61\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x8D"],
        ["\xE1\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x6D"],

        ["\x61\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x8E"],
        ["\xE1\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x6E"],

        ["\x61\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x8F"],
        ["\xE1\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x6F"],

        ["\x61\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x90"],
        ["\xE1\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x70"],

        ["\x61\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x91"],
        ["\xE1\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x71"],

        ["\x61\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x92"],
        ["\xE1\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x72"],

        ["\x61\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x93"],
        ["\xE1\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x73"],

        ["\x61\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x94"],
        ["\xE1\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x74"],

        ["\x61\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x95"],
        ["\xE1\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x75"],

        ["\x61\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x96"],
        ["\xE1\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x76"],

        ["\x61\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x97"],
        ["\xE1\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x77"],

        ["\x61\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x98"],
        ["\xE1\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x78"],

        ["\x61\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x99"],
        ["\xE1\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x79"],

        ["\x61\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x9A"],
        ["\xE1\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x7A"],

        ["\x61\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x9B"],
        ["\xE1\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x7B"],

        ["\x61\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x9C"],
        ["\xE1\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x7C"],

        ["\x61\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x9D"],
        ["\xE1\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x7D"],

        ["\x61\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x9E"],
        ["\xE1\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x61\x7E"],

        ["\x62\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\x9F"],
        ["\xE1\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x21"],

        ["\x62\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA0"],
        ["\xE1\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x22"],

        ["\x62\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],
        ["\xE1\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x23"],

        ["\x62\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],
        ["\xE1\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x24"],

        ["\x62\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],
        ["\xE1\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x25"],

        ["\x62\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],
        ["\xE1\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x26"],

        ["\x62\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],
        ["\xE1\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x27"],

        ["\x62\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],
        ["\xE1\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x28"],

        ["\x62\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],
        ["\xE1\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x29"],

        ["\x62\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],
        ["\xE1\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x2A"],

        ["\x62\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],
        ["\xE1\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x2B"],

        ["\x62\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],
        ["\xE1\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x2C"],

        ["\x62\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],
        ["\xE1\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x2D"],

        ["\x62\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],
        ["\xE1\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x2E"],

        ["\x62\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],
        ["\xE1\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x2F"],

        ["\x62\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],
        ["\xE1\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x30"],

        ["\x62\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],
        ["\xE1\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x31"],

        ["\x62\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],
        ["\xE1\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x32"],

        ["\x62\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],
        ["\xE1\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x33"],

        ["\x62\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],
        ["\xE1\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x34"],

        ["\x62\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],
        ["\xE1\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x35"],

        ["\x62\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],
        ["\xE1\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x36"],

        ["\x62\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],
        ["\xE1\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x37"],

        ["\x62\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],
        ["\xE1\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x38"],

        ["\x62\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],
        ["\xE1\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x39"],

        ["\x62\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],
        ["\xE1\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x3A"],

        ["\x62\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],
        ["\xE1\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x3B"],

        ["\x62\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],
        ["\xE1\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x3C"],

        ["\x62\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],
        ["\xE1\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x3D"],

        ["\x62\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],
        ["\xE1\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x3E"],

        ["\x62\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],
        ["\xE1\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x3F"],

        ["\x62\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],
        ["\xE1\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x40"],

        ["\x62\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],
        ["\xE1\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x41"],

        ["\x62\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],
        ["\xE1\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x42"],

        ["\x62\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],
        ["\xE1\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x43"],

        ["\x62\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],
        ["\xE1\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x44"],

        ["\x62\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],
        ["\xE1\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x45"],

        ["\x62\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],
        ["\xE1\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x46"],

        ["\x62\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],
        ["\xE1\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x47"],

        ["\x62\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],
        ["\xE1\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x48"],

        ["\x62\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],
        ["\xE1\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x49"],

        ["\x62\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],
        ["\xE1\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x4A"],

        ["\x62\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],
        ["\xE1\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x4B"],

        ["\x62\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],
        ["\xE1\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x4C"],

        ["\x62\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],
        ["\xE1\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x4D"],

        ["\x62\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],
        ["\xE1\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x4E"],

        ["\x62\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],
        ["\xE1\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x4F"],

        ["\x62\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],
        ["\xE1\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x50"],

        ["\x62\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],
        ["\xE1\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x51"],

        ["\x62\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],
        ["\xE1\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x52"],

        ["\x62\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],
        ["\xE1\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x53"],

        ["\x62\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],
        ["\xE1\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x54"],

        ["\x62\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],
        ["\xE1\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x55"],

        ["\x62\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],
        ["\xE1\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x56"],

        ["\x62\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],
        ["\xE1\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x57"],

        ["\x62\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],
        ["\xE1\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x58"],

        ["\x62\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],
        ["\xE1\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x59"],

        ["\x62\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],
        ["\xE1\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x5A"],

        ["\x62\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],
        ["\xE1\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x5B"],

        ["\x62\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],
        ["\xE1\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x5C"],

        ["\x62\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],
        ["\xE1\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x5D"],

        ["\x62\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],
        ["\xE1\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x5E"],

        ["\x62\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],
        ["\xE1\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x5F"],

        ["\x62\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],
        ["\xE1\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x60"],

        ["\x62\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],
        ["\xE1\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x61"],

        ["\x62\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],
        ["\xE1\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x62"],

        ["\x62\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],
        ["\xE1\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x63"],

        ["\x62\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],
        ["\xE1\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x64"],

        ["\x62\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],
        ["\xE1\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x65"],

        ["\x62\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],
        ["\xE1\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x66"],

        ["\x62\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],
        ["\xE1\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x67"],

        ["\x39\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],
        ["\xE1\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x39\x5C"],

        ["\x62\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],
        ["\xE1\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x69"],

        ["\x45\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],
        ["\xE1\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x45\x57"],

        ["\x62\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],
        ["\xE1\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x6B"],

        ["\x62\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],
        ["\xE1\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x6C"],

        ["\x62\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],
        ["\xE1\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x6D"],

        ["\x62\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],
        ["\xE1\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x6E"],

        ["\x62\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],
        ["\xE1\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x6F"],

        ["\x62\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],
        ["\xE1\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x70"],

        ["\x62\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],
        ["\xE1\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x71"],

        ["\x62\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],
        ["\xE1\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x72"],

        ["\x62\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],
        ["\xE1\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x73"],

        ["\x62\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],
        ["\xE1\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x74"],

        ["\x62\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],
        ["\xE1\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x75"],

        ["\x62\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],
        ["\xE1\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x76"],

        ["\x62\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],
        ["\xE1\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x77"],

        ["\x62\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],
        ["\xE1\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x78"],

        ["\x62\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],
        ["\xE1\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x79"],

        ["\x62\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],
        ["\xE1\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x7A"],

        ["\x62\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],
        ["\xE1\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x7B"],

        ["\x62\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],
        ["\xE1\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x7C"],

        ["\x62\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],
        ["\xE1\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x7D"],

        ["\x62\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],
        ["\xE1\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x62\x7E"],

        ["\x63\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x40"],
        ["\xE2\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x21"],

        ["\x63\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x41"],
        ["\xE2\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x22"],

        ["\x63\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x42"],
        ["\xE2\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x23"],

        ["\x63\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x43"],
        ["\xE2\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x24"],

        ["\x63\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x44"],
        ["\xE2\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x25"],

        ["\x63\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x45"],
        ["\xE2\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x26"],

        ["\x63\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x46"],
        ["\xE2\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x27"],

        ["\x63\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x47"],
        ["\xE2\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x28"],

        ["\x63\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x48"],
        ["\xE2\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x29"],

        ["\x63\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x49"],
        ["\xE2\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x2A"],

        ["\x63\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x4A"],
        ["\xE2\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x2B"],

        ["\x63\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x4B"],
        ["\xE2\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x2C"],

        ["\x63\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x4C"],
        ["\xE2\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x2D"],

        ["\x63\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x4D"],
        ["\xE2\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x2E"],

        ["\x63\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x4E"],
        ["\xE2\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x2F"],

        ["\x63\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x4F"],
        ["\xE2\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x30"],

        ["\x63\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x50"],
        ["\xE2\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x31"],

        ["\x63\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x51"],
        ["\xE2\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x32"],

        ["\x63\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x52"],
        ["\xE2\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x33"],

        ["\x63\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x53"],
        ["\xE2\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x34"],

        ["\x63\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x54"],
        ["\xE2\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x35"],

        ["\x63\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x55"],
        ["\xE2\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x36"],

        ["\x63\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x56"],
        ["\xE2\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x37"],

        ["\x63\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x57"],
        ["\xE2\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x38"],

        ["\x63\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x58"],
        ["\xE2\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x39"],

        ["\x63\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x59"],
        ["\xE2\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x3A"],

        ["\x63\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x5A"],
        ["\xE2\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x3B"],

        ["\x63\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x5B"],
        ["\xE2\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x3C"],

        ["\x63\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x5C"],
        ["\xE2\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x3D"],

        ["\x63\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x5D"],
        ["\xE2\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x3E"],

        ["\x63\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x5E"],
        ["\xE2\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x3F"],

        ["\x63\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x5F"],
        ["\xE2\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x40"],

        ["\x63\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x60"],
        ["\xE2\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x41"],

        ["\x63\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x61"],
        ["\xE2\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x42"],

        ["\x63\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x62"],
        ["\xE2\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x43"],

        ["\x63\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x63"],
        ["\xE2\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x44"],

        ["\x63\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x64"],
        ["\xE2\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x45"],

        ["\x63\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x65"],
        ["\xE2\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x46"],

        ["\x63\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x66"],
        ["\xE2\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x47"],

        ["\x63\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x67"],
        ["\xE2\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x48"],

        ["\x63\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x68"],
        ["\xE2\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x49"],

        ["\x63\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x69"],
        ["\xE2\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x4A"],

        ["\x63\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x6A"],
        ["\xE2\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x4B"],

        ["\x63\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x6B"],
        ["\xE2\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x4C"],

        ["\x63\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x6C"],
        ["\xE2\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x4D"],

        ["\x63\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x6D"],
        ["\xE2\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x4E"],

        ["\x63\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x6E"],
        ["\xE2\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x4F"],

        ["\x63\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x6F"],
        ["\xE2\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x50"],

        ["\x63\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x70"],
        ["\xE2\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x51"],

        ["\x63\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x71"],
        ["\xE2\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x52"],

        ["\x63\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x72"],
        ["\xE2\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x53"],

        ["\x63\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x73"],
        ["\xE2\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x54"],

        ["\x63\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x74"],
        ["\xE2\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x55"],

        ["\x63\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x75"],
        ["\xE2\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x56"],

        ["\x63\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x76"],
        ["\xE2\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x57"],

        ["\x63\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x77"],
        ["\xE2\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x58"],

        ["\x63\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x78"],
        ["\xE2\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x59"],

        ["\x63\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x79"],
        ["\xE2\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x5A"],

        ["\x63\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x7A"],
        ["\xE2\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x5B"],

        ["\x63\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x7B"],
        ["\xE2\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x5C"],

        ["\x63\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x7C"],
        ["\xE2\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x5D"],

        ["\x33\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x7D"],
        ["\xE2\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x76"],

        ["\x63\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x7E"],
        ["\xE2\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x5F"],

        ["\x63\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x80"],
        ["\xE2\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x60"],

        ["\x63\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x81"],
        ["\xE2\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x61"],

        ["\x63\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x82"],
        ["\xE2\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x62"],

        ["\x63\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x83"],
        ["\xE2\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x63"],

        ["\x63\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x84"],
        ["\xE2\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x64"],

        ["\x63\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x85"],
        ["\xE2\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x65"],

        ["\x63\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x86"],
        ["\xE2\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x66"],

        ["\x63\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x87"],
        ["\xE2\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x67"],

        ["\x63\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x88"],
        ["\xE2\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x68"],

        ["\x63\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x89"],
        ["\xE2\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x69"],

        ["\x63\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A"],
        ["\xE2\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x6A"],

        ["\x63\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x8B"],
        ["\xE2\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x6B"],

        ["\x63\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C"],
        ["\xE2\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x6C"],

        ["\x63\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x8D"],
        ["\xE2\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x6D"],

        ["\x63\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x8E"],
        ["\xE2\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x6E"],

        ["\x63\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x8F"],
        ["\xE2\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x6F"],

        ["\x63\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x90"],
        ["\xE2\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x70"],

        ["\x63\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x91"],
        ["\xE2\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x71"],

        ["\x63\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x92"],
        ["\xE2\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x72"],

        ["\x63\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x93"],
        ["\xE2\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x73"],

        ["\x63\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x94"],
        ["\xE2\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x74"],

        ["\x63\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x95"],
        ["\xE2\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x75"],

        ["\x63\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x96"],
        ["\xE2\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x76"],

        ["\x63\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x97"],
        ["\xE2\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x77"],

        ["\x63\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x98"],
        ["\xE2\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x78"],

        ["\x63\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x99"],
        ["\xE2\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x79"],

        ["\x63\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x9A"],
        ["\xE2\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x7A"],

        ["\x63\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x9B"],
        ["\xE2\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x7B"],

        ["\x63\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x9C"],
        ["\xE2\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x7C"],

        ["\x63\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x9D"],
        ["\xE2\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x7D"],

        ["\x63\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x9E"],
        ["\xE2\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x63\x7E"],

        ["\x64\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\x9F"],
        ["\xE2\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x21"],

        ["\x64\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA0"],
        ["\xE2\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x22"],

        ["\x64\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],
        ["\xE2\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x23"],

        ["\x64\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],
        ["\xE2\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x24"],

        ["\x64\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],
        ["\xE2\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x25"],

        ["\x64\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],
        ["\xE2\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x26"],

        ["\x64\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],
        ["\xE2\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x27"],

        ["\x64\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],
        ["\xE2\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x28"],

        ["\x64\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],
        ["\xE2\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x29"],

        ["\x64\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],
        ["\xE2\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x2A"],

        ["\x64\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],
        ["\xE2\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x2B"],

        ["\x64\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],
        ["\xE2\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x2C"],

        ["\x64\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],
        ["\xE2\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x2D"],

        ["\x64\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],
        ["\xE2\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x2E"],

        ["\x64\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],
        ["\xE2\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x2F"],

        ["\x64\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],
        ["\xE2\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x30"],

        ["\x64\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],
        ["\xE2\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x31"],

        ["\x64\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],
        ["\xE2\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x32"],

        ["\x64\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],
        ["\xE2\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x33"],

        ["\x64\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],
        ["\xE2\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x34"],

        ["\x64\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],
        ["\xE2\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x35"],

        ["\x64\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],
        ["\xE2\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x36"],

        ["\x64\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],
        ["\xE2\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x37"],

        ["\x64\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],
        ["\xE2\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x38"],

        ["\x64\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],
        ["\xE2\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x39"],

        ["\x64\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],
        ["\xE2\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x3A"],

        ["\x64\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],
        ["\xE2\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x3B"],

        ["\x64\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],
        ["\xE2\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x3C"],

        ["\x64\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],
        ["\xE2\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x3D"],

        ["\x64\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],
        ["\xE2\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x3E"],

        ["\x64\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],
        ["\xE2\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x3F"],

        ["\x64\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],
        ["\xE2\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x40"],

        ["\x64\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],
        ["\xE2\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x41"],

        ["\x64\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],
        ["\xE2\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x42"],

        ["\x64\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],
        ["\xE2\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x43"],

        ["\x64\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],
        ["\xE2\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x44"],

        ["\x64\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],
        ["\xE2\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x45"],

        ["\x4F\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],
        ["\xE2\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4F\x36"],

        ["\x64\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],
        ["\xE2\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x47"],

        ["\x64\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],
        ["\xE2\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x48"],

        ["\x64\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],
        ["\xE2\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x49"],

        ["\x64\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],
        ["\xE2\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x4A"],

        ["\x64\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],
        ["\xE2\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x4B"],

        ["\x64\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],
        ["\xE2\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x4C"],

        ["\x64\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],
        ["\xE2\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x4D"],

        ["\x64\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],
        ["\xE2\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x4E"],

        ["\x64\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],
        ["\xE2\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x4F"],

        ["\x64\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],
        ["\xE2\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x50"],

        ["\x64\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],
        ["\xE2\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x51"],

        ["\x64\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],
        ["\xE2\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x52"],

        ["\x64\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],
        ["\xE2\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x53"],

        ["\x64\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],
        ["\xE2\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x54"],

        ["\x64\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],
        ["\xE2\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x55"],

        ["\x64\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],
        ["\xE2\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x56"],

        ["\x64\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],
        ["\xE2\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x57"],

        ["\x64\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],
        ["\xE2\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x58"],

        ["\x64\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],
        ["\xE2\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x59"],

        ["\x64\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],
        ["\xE2\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x5A"],

        ["\x64\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],
        ["\xE2\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x5B"],

        ["\x64\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],
        ["\xE2\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x5C"],

        ["\x64\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],
        ["\xE2\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x5D"],

        ["\x64\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],
        ["\xE2\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x5E"],

        ["\x64\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],
        ["\xE2\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x5F"],

        ["\x64\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],
        ["\xE2\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x60"],

        ["\x64\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],
        ["\xE2\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x61"],

        ["\x64\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],
        ["\xE2\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x62"],

        ["\x64\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],
        ["\xE2\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x63"],

        ["\x64\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],
        ["\xE2\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x64"],

        ["\x64\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],
        ["\xE2\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x65"],

        ["\x64\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],
        ["\xE2\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x66"],

        ["\x64\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],
        ["\xE2\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x67"],

        ["\x64\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],
        ["\xE2\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x68"],

        ["\x64\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],
        ["\xE2\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x69"],

        ["\x64\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],
        ["\xE2\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x6A"],

        ["\x64\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],
        ["\xE2\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x6B"],

        ["\x64\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],
        ["\xE2\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x6C"],

        ["\x64\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],
        ["\xE2\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x6D"],

        ["\x64\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],
        ["\xE2\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x6E"],

        ["\x64\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],
        ["\xE2\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x6F"],

        ["\x64\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],
        ["\xE2\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x70"],

        ["\x64\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],
        ["\xE2\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x71"],

        ["\x64\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],
        ["\xE2\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x72"],

        ["\x64\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],
        ["\xE2\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x73"],

        ["\x64\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],
        ["\xE2\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x74"],

        ["\x64\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],
        ["\xE2\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x75"],

        ["\x64\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],
        ["\xE2\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x76"],

        ["\x64\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],
        ["\xE2\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x77"],

        ["\x64\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],
        ["\xE2\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x78"],

        ["\x64\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],
        ["\xE2\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x79"],

        ["\x64\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],
        ["\xE2\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x7A"],

        ["\x64\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],
        ["\xE2\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x7B"],

        ["\x64\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],
        ["\xE2\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x7C"],

        ["\x64\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],
        ["\xE2\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x7D"],

        ["\x64\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],
        ["\xE2\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x64\x7E"],

        ["\x65\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x40"],
        ["\xE3\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x21"],

        ["\x65\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x41"],
        ["\xE3\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x22"],

        ["\x65\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x42"],
        ["\xE3\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x23"],

        ["\x65\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x43"],
        ["\xE3\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x24"],

        ["\x65\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x44"],
        ["\xE3\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x25"],

        ["\x65\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x45"],
        ["\xE3\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x26"],

        ["\x65\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x46"],
        ["\xE3\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x27"],

        ["\x65\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x47"],
        ["\xE3\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x28"],

        ["\x65\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x48"],
        ["\xE3\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x29"],

        ["\x65\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x49"],
        ["\xE3\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x2A"],

        ["\x65\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x4A"],
        ["\xE3\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x2B"],

        ["\x65\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x4B"],
        ["\xE3\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x2C"],

        ["\x65\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x4C"],
        ["\xE3\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x2D"],

        ["\x65\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x4D"],
        ["\xE3\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x2E"],

        ["\x65\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x4E"],
        ["\xE3\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x2F"],

        ["\x65\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x4F"],
        ["\xE3\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x30"],

        ["\x65\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x50"],
        ["\xE3\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x31"],

        ["\x65\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x51"],
        ["\xE3\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x32"],

        ["\x65\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x52"],
        ["\xE3\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x33"],

        ["\x65\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x53"],
        ["\xE3\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x34"],

        ["\x65\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x54"],
        ["\xE3\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x35"],

        ["\x65\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x55"],
        ["\xE3\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x36"],

        ["\x65\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x56"],
        ["\xE3\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x37"],

        ["\x65\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x57"],
        ["\xE3\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x38"],

        ["\x65\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x58"],
        ["\xE3\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x39"],

        ["\x65\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x59"],
        ["\xE3\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x3A"],

        ["\x65\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x5A"],
        ["\xE3\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x3B"],

        ["\x65\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x5B"],
        ["\xE3\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x3C"],

        ["\x65\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x5C"],
        ["\xE3\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x3D"],

        ["\x65\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x5D"],
        ["\xE3\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x3E"],

        ["\x65\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x5E"],
        ["\xE3\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x3F"],

        ["\x65\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x5F"],
        ["\xE3\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x40"],

        ["\x65\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x60"],
        ["\xE3\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x41"],

        ["\x65\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x61"],
        ["\xE3\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x42"],

        ["\x65\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x62"],
        ["\xE3\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x43"],

        ["\x65\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x63"],
        ["\xE3\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x44"],

        ["\x65\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x64"],
        ["\xE3\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x45"],

        ["\x65\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x65"],
        ["\xE3\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x46"],

        ["\x65\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x66"],
        ["\xE3\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x47"],

        ["\x65\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x67"],
        ["\xE3\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x48"],

        ["\x65\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x68"],
        ["\xE3\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x49"],

        ["\x65\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x69"],
        ["\xE3\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x4A"],

        ["\x65\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x6A"],
        ["\xE3\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x4B"],

        ["\x65\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x6B"],
        ["\xE3\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x4C"],

        ["\x65\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x6C"],
        ["\xE3\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x4D"],

        ["\x65\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x6D"],
        ["\xE3\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x4E"],

        ["\x65\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x6E"],
        ["\xE3\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x4F"],

        ["\x65\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x6F"],
        ["\xE3\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x50"],

        ["\x65\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x70"],
        ["\xE3\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x51"],

        ["\x65\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x71"],
        ["\xE3\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x52"],

        ["\x65\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x72"],
        ["\xE3\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x53"],

        ["\x65\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x73"],
        ["\xE3\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x54"],

        ["\x65\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x74"],
        ["\xE3\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x55"],

        ["\x65\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x75"],
        ["\xE3\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x56"],

        ["\x65\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x76"],
        ["\xE3\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x57"],

        ["\x65\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x77"],
        ["\xE3\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x58"],

        ["\x65\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x78"],
        ["\xE3\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x59"],

        ["\x65\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x79"],
        ["\xE3\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x5A"],

        ["\x65\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x7A"],
        ["\xE3\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x5B"],

        ["\x65\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x7B"],
        ["\xE3\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x5C"],

        ["\x65\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x7C"],
        ["\xE3\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x5D"],

        ["\x65\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x7D"],
        ["\xE3\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x5E"],

        ["\x65\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x7E"],
        ["\xE3\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x5F"],

        ["\x65\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x80"],
        ["\xE3\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x60"],

        ["\x65\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x81"],
        ["\xE3\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x61"],

        ["\x65\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x82"],
        ["\xE3\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x62"],

        ["\x65\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x83"],
        ["\xE3\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x63"],

        ["\x65\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x84"],
        ["\xE3\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x64"],

        ["\x65\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x85"],
        ["\xE3\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x65"],

        ["\x65\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x86"],
        ["\xE3\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x66"],

        ["\x65\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x87"],
        ["\xE3\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x67"],

        ["\x65\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x88"],
        ["\xE3\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x68"],

        ["\x65\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x89"],
        ["\xE3\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x69"],

        ["\x65\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A"],
        ["\xE3\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x6A"],

        ["\x65\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x8B"],
        ["\xE3\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x6B"],

        ["\x65\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C"],
        ["\xE3\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x6C"],

        ["\x65\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D"],
        ["\xE3\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x6D"],

        ["\x65\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E"],
        ["\xE3\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x6E"],

        ["\x65\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F"],
        ["\xE3\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x6F"],

        ["\x65\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x90"],
        ["\xE3\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x70"],

        ["\x65\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x91"],
        ["\xE3\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x71"],

        ["\x65\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x92"],
        ["\xE3\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x72"],

        ["\x65\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x93"],
        ["\xE3\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x73"],

        ["\x65\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x94"],
        ["\xE3\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x74"],

        ["\x65\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x95"],
        ["\xE3\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x75"],

        ["\x65\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x96"],
        ["\xE3\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x76"],

        ["\x65\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x97"],
        ["\xE3\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x77"],

        ["\x65\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x98"],
        ["\xE3\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x78"],

        ["\x65\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x99"],
        ["\xE3\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x79"],

        ["\x65\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x9A"],
        ["\xE3\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x7A"],

        ["\x65\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x9B"],
        ["\xE3\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x7B"],

        ["\x65\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x9C"],
        ["\xE3\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x7C"],

        ["\x65\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x9D"],
        ["\xE3\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x7D"],

        ["\x65\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x9E"],
        ["\xE3\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x65\x7E"],

        ["\x66\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\x9F"],
        ["\xE3\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x21"],

        ["\x66\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA0"],
        ["\xE3\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x22"],

        ["\x66\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],
        ["\xE3\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x23"],

        ["\x66\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],
        ["\xE3\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x24"],

        ["\x66\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],
        ["\xE3\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x25"],

        ["\x66\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],
        ["\xE3\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x26"],

        ["\x66\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],
        ["\xE3\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x27"],

        ["\x66\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],
        ["\xE3\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x28"],

        ["\x66\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],
        ["\xE3\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x29"],

        ["\x66\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],
        ["\xE3\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x2A"],

        ["\x66\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],
        ["\xE3\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x2B"],

        ["\x66\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],
        ["\xE3\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x2C"],

        ["\x66\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],
        ["\xE3\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x2D"],

        ["\x66\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],
        ["\xE3\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x2E"],

        ["\x66\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],
        ["\xE3\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x2F"],

        ["\x66\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],
        ["\xE3\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x30"],

        ["\x66\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],
        ["\xE3\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x31"],

        ["\x66\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],
        ["\xE3\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x32"],

        ["\x66\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],
        ["\xE3\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x33"],

        ["\x66\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],
        ["\xE3\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x34"],

        ["\x66\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],
        ["\xE3\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x35"],

        ["\x66\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],
        ["\xE3\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x36"],

        ["\x66\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],
        ["\xE3\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x37"],

        ["\x66\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],
        ["\xE3\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x38"],

        ["\x66\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],
        ["\xE3\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x39"],

        ["\x66\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],
        ["\xE3\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x3A"],

        ["\x66\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],
        ["\xE3\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x3B"],

        ["\x66\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],
        ["\xE3\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x3C"],

        ["\x66\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],
        ["\xE3\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x3D"],

        ["\x66\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],
        ["\xE3\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x3E"],

        ["\x66\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],
        ["\xE3\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x3F"],

        ["\x66\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],
        ["\xE3\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x40"],

        ["\x66\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],
        ["\xE3\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x41"],

        ["\x66\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],
        ["\xE3\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x42"],

        ["\x66\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],
        ["\xE3\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x43"],

        ["\x66\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],
        ["\xE3\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x44"],

        ["\x66\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],
        ["\xE3\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x45"],

        ["\x66\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],
        ["\xE3\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x46"],

        ["\x66\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],
        ["\xE3\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x47"],

        ["\x66\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],
        ["\xE3\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x48"],

        ["\x66\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],
        ["\xE3\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x49"],

        ["\x66\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],
        ["\xE3\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x4A"],

        ["\x66\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],
        ["\xE3\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x4B"],

        ["\x66\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],
        ["\xE3\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x4C"],

        ["\x66\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],
        ["\xE3\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x4D"],

        ["\x66\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],
        ["\xE3\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x4E"],

        ["\x66\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],
        ["\xE3\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x4F"],

        ["\x66\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],
        ["\xE3\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x50"],

        ["\x66\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],
        ["\xE3\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x51"],

        ["\x66\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],
        ["\xE3\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x52"],

        ["\x66\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],
        ["\xE3\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x53"],

        ["\x66\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],
        ["\xE3\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x54"],

        ["\x66\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],
        ["\xE3\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x55"],

        ["\x66\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],
        ["\xE3\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x56"],

        ["\x66\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],
        ["\xE3\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x57"],

        ["\x66\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],
        ["\xE3\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x58"],

        ["\x66\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],
        ["\xE3\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x59"],

        ["\x66\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],
        ["\xE3\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x5A"],

        ["\x66\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],
        ["\xE3\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x5B"],

        ["\x66\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],
        ["\xE3\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x5C"],

        ["\x66\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],
        ["\xE3\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x5D"],

        ["\x66\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],
        ["\xE3\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x5E"],

        ["\x66\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],
        ["\xE3\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x5F"],

        ["\x66\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],
        ["\xE3\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x60"],

        ["\x66\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],
        ["\xE3\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x61"],

        ["\x66\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],
        ["\xE3\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x62"],

        ["\x66\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],
        ["\xE3\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x63"],

        ["\x66\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],
        ["\xE3\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x64"],

        ["\x66\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],
        ["\xE3\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x65"],

        ["\x66\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],
        ["\xE3\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x66"],

        ["\x66\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],
        ["\xE3\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x67"],

        ["\x66\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],
        ["\xE3\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x68"],

        ["\x66\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],
        ["\xE3\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x69"],

        ["\x66\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],
        ["\xE3\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x6A"],

        ["\x66\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],
        ["\xE3\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x6B"],

        ["\x66\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],
        ["\xE3\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x6C"],

        ["\x66\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],
        ["\xE3\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x6D"],

        ["\x66\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],
        ["\xE3\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x6E"],

        ["\x66\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],
        ["\xE3\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x6F"],

        ["\x66\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],
        ["\xE3\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x70"],

        ["\x66\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],
        ["\xE3\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x71"],

        ["\x66\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],
        ["\xE3\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x72"],

        ["\x66\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],
        ["\xE3\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x73"],

        ["\x66\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],
        ["\xE3\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x74"],

        ["\x66\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],
        ["\xE3\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x75"],

        ["\x66\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],
        ["\xE3\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x76"],

        ["\x66\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],
        ["\xE3\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x77"],

        ["\x66\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],
        ["\xE3\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x78"],

        ["\x66\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],
        ["\xE3\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x79"],

        ["\x66\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],
        ["\xE3\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x7A"],

        ["\x66\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],
        ["\xE3\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x7B"],

        ["\x66\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],
        ["\xE3\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x7C"],

        ["\x66\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],
        ["\xE3\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x7D"],

        ["\x66\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],
        ["\xE3\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x66\x7E"],

        ["\x67\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x40"],
        ["\xE4\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x21"],

        ["\x67\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x41"],
        ["\xE4\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x22"],

        ["\x67\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x42"],
        ["\xE4\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x23"],

        ["\x67\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x43"],
        ["\xE4\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x24"],

        ["\x67\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x44"],
        ["\xE4\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x25"],

        ["\x67\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x45"],
        ["\xE4\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x26"],

        ["\x67\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x46"],
        ["\xE4\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x27"],

        ["\x67\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x47"],
        ["\xE4\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x28"],

        ["\x67\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x48"],
        ["\xE4\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x29"],

        ["\x67\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x49"],
        ["\xE4\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x2A"],

        ["\x67\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x4A"],
        ["\xE4\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x2B"],

        ["\x67\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x4B"],
        ["\xE4\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x2C"],

        ["\x67\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x4C"],
        ["\xE4\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x2D"],

        ["\x67\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x4D"],
        ["\xE4\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x2E"],

        ["\x67\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x4E"],
        ["\xE4\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x2F"],

        ["\x67\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x4F"],
        ["\xE4\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x30"],

        ["\x67\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x50"],
        ["\xE4\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x31"],

        ["\x67\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x51"],
        ["\xE4\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x32"],

        ["\x67\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x52"],
        ["\xE4\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x33"],

        ["\x67\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x53"],
        ["\xE4\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x34"],

        ["\x67\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x54"],
        ["\xE4\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x35"],

        ["\x67\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x55"],
        ["\xE4\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x36"],

        ["\x67\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x56"],
        ["\xE4\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x37"],

        ["\x67\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x57"],
        ["\xE4\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x38"],

        ["\x67\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x58"],
        ["\xE4\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x39"],

        ["\x67\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x59"],
        ["\xE4\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x3A"],

        ["\x67\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x5A"],
        ["\xE4\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x3B"],

        ["\x67\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x5B"],
        ["\xE4\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x3C"],

        ["\x67\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x5C"],
        ["\xE4\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x3D"],

        ["\x67\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x5D"],
        ["\xE4\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x3E"],

        ["\x67\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x5E"],
        ["\xE4\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x3F"],

        ["\x67\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x5F"],
        ["\xE4\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x40"],

        ["\x67\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x60"],
        ["\xE4\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x41"],

        ["\x67\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x61"],
        ["\xE4\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x42"],

        ["\x67\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x62"],
        ["\xE4\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x43"],

        ["\x67\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x63"],
        ["\xE4\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x44"],

        ["\x67\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x64"],
        ["\xE4\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x45"],

        ["\x67\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x65"],
        ["\xE4\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x46"],

        ["\x67\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x66"],
        ["\xE4\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x47"],

        ["\x67\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x67"],
        ["\xE4\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x48"],

        ["\x67\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x68"],
        ["\xE4\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x49"],

        ["\x67\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x69"],
        ["\xE4\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x4A"],

        ["\x67\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x6A"],
        ["\xE4\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x4B"],

        ["\x67\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x6B"],
        ["\xE4\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x4C"],

        ["\x67\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x6C"],
        ["\xE4\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x4D"],

        ["\x67\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x6D"],
        ["\xE4\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x4E"],

        ["\x67\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x6E"],
        ["\xE4\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x4F"],

        ["\x67\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x6F"],
        ["\xE4\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x50"],

        ["\x67\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x70"],
        ["\xE4\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x51"],

        ["\x67\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x71"],
        ["\xE4\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x52"],

        ["\x67\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x72"],
        ["\xE4\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x53"],

        ["\x67\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x73"],
        ["\xE4\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x54"],

        ["\x67\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x74"],
        ["\xE4\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x55"],

        ["\x67\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x75"],
        ["\xE4\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x56"],

        ["\x67\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x76"],
        ["\xE4\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x57"],

        ["\x67\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x77"],
        ["\xE4\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x58"],

        ["\x67\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x78"],
        ["\xE4\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x59"],

        ["\x67\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x79"],
        ["\xE4\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x5A"],

        ["\x67\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x7A"],
        ["\xE4\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x5B"],

        ["\x67\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x7B"],
        ["\xE4\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x5C"],

        ["\x67\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x7C"],
        ["\xE4\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x5D"],

        ["\x67\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x7D"],
        ["\xE4\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x5E"],

        ["\x67\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x7E"],
        ["\xE4\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x5F"],

        ["\x67\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x80"],
        ["\xE4\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x60"],

        ["\x67\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x81"],
        ["\xE4\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x61"],

        ["\x67\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x82"],
        ["\xE4\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x62"],

        ["\x67\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x83"],
        ["\xE4\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x63"],

        ["\x67\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x84"],
        ["\xE4\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x64"],

        ["\x67\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x85"],
        ["\xE4\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x65"],

        ["\x67\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x86"],
        ["\xE4\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x66"],

        ["\x67\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x87"],
        ["\xE4\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x67"],

        ["\x67\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x88"],
        ["\xE4\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x68"],

        ["\x67\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x89"],
        ["\xE4\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x69"],

        ["\x67\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x8A"],
        ["\xE4\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x6A"],

        ["\x67\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x8B"],
        ["\xE4\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x6B"],

        ["\x67\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x8C"],
        ["\xE4\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x6C"],

        ["\x67\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x8D"],
        ["\xE4\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x6D"],

        ["\x67\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x8E"],
        ["\xE4\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x6E"],

        ["\x67\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x8F"],
        ["\xE4\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x6F"],

        ["\x67\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x90"],
        ["\xE4\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x70"],

        ["\x67\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x91"],
        ["\xE4\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x71"],

        ["\x67\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x92"],
        ["\xE4\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x72"],

        ["\x67\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x93"],
        ["\xE4\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x73"],

        ["\x67\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x94"],
        ["\xE4\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x74"],

        ["\x67\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x95"],
        ["\xE4\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x75"],

        ["\x67\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x96"],
        ["\xE4\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x76"],

        ["\x67\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x97"],
        ["\xE4\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x77"],

        ["\x67\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x98"],
        ["\xE4\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x78"],

        ["\x67\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x99"],
        ["\xE4\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x79"],

        ["\x67\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x9A"],
        ["\xE4\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x7A"],

        ["\x67\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x9B"],
        ["\xE4\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x7B"],

        ["\x67\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x9C"],
        ["\xE4\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x7C"],

        ["\x67\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x9D"],
        ["\xE4\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x7D"],

        ["\x67\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x9E"],
        ["\xE4\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x67\x7E"],

        ["\x68\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\x9F"],
        ["\xE4\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x21"],

        ["\x68\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA0"],
        ["\xE4\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x22"],

        ["\x68\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],
        ["\xE4\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x23"],

        ["\x68\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],
        ["\xE4\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x24"],

        ["\x68\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],
        ["\xE4\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x25"],

        ["\x68\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],
        ["\xE4\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x26"],

        ["\x68\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],
        ["\xE4\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x27"],

        ["\x68\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],
        ["\xE4\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x28"],

        ["\x68\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],
        ["\xE4\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x29"],

        ["\x68\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],
        ["\xE4\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x2A"],

        ["\x68\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],
        ["\xE4\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x2B"],

        ["\x68\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],
        ["\xE4\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x2C"],

        ["\x68\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],
        ["\xE4\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x2D"],

        ["\x68\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],
        ["\xE4\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x2E"],

        ["\x68\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],
        ["\xE4\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x2F"],

        ["\x68\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],
        ["\xE4\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x30"],

        ["\x68\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],
        ["\xE4\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x31"],

        ["\x68\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],
        ["\xE4\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x32"],

        ["\x68\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],
        ["\xE4\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x33"],

        ["\x68\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],
        ["\xE4\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x34"],

        ["\x68\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],
        ["\xE4\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x35"],

        ["\x68\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],
        ["\xE4\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x36"],

        ["\x68\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],
        ["\xE4\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x37"],

        ["\x68\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],
        ["\xE4\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x38"],

        ["\x68\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],
        ["\xE4\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x39"],

        ["\x68\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],
        ["\xE4\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x3A"],

        ["\x68\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],
        ["\xE4\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x3B"],

        ["\x68\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],
        ["\xE4\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x3C"],

        ["\x68\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],
        ["\xE4\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x3D"],

        ["\x68\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],
        ["\xE4\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x3E"],

        ["\x68\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],
        ["\xE4\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x3F"],

        ["\x68\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],
        ["\xE4\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x40"],

        ["\x68\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],
        ["\xE4\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x41"],

        ["\x68\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],
        ["\xE4\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x42"],

        ["\x68\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],
        ["\xE4\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x43"],

        ["\x68\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],
        ["\xE4\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x44"],

        ["\x68\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],
        ["\xE4\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x45"],

        ["\x68\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],
        ["\xE4\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x46"],

        ["\x68\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],
        ["\xE4\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x47"],

        ["\x68\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],
        ["\xE4\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x48"],

        ["\x68\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],
        ["\xE4\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x49"],

        ["\x68\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],
        ["\xE4\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x4A"],

        ["\x68\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],
        ["\xE4\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x4B"],

        ["\x68\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],
        ["\xE4\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x4C"],

        ["\x68\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],
        ["\xE4\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x4D"],

        ["\x68\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],
        ["\xE4\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x4E"],

        ["\x68\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],
        ["\xE4\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x4F"],

        ["\x68\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],
        ["\xE4\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x50"],

        ["\x68\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],
        ["\xE4\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x51"],

        ["\x68\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],
        ["\xE4\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x52"],

        ["\x68\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],
        ["\xE4\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x53"],

        ["\x68\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],
        ["\xE4\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x54"],

        ["\x68\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],
        ["\xE4\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x55"],

        ["\x68\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],
        ["\xE4\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x56"],

        ["\x68\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],
        ["\xE4\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x57"],

        ["\x68\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],
        ["\xE4\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x58"],

        ["\x68\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],
        ["\xE4\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x59"],

        ["\x68\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],
        ["\xE4\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x5A"],

        ["\x68\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],
        ["\xE4\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x5B"],

        ["\x68\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],
        ["\xE4\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x5C"],

        ["\x68\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],
        ["\xE4\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x5D"],

        ["\x68\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],
        ["\xE4\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x5E"],

        ["\x68\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],
        ["\xE4\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x5F"],

        ["\x68\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],
        ["\xE4\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x60"],

        ["\x68\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],
        ["\xE4\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x61"],

        ["\x68\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],
        ["\xE4\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x62"],

        ["\x68\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],
        ["\xE4\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x63"],

        ["\x68\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],
        ["\xE4\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x64"],

        ["\x68\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],
        ["\xE4\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x65"],

        ["\x68\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],
        ["\xE4\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x66"],

        ["\x68\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],
        ["\xE4\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x67"],

        ["\x68\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],
        ["\xE4\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x68"],

        ["\x68\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],
        ["\xE4\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x69"],

        ["\x68\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],
        ["\xE4\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x6A"],

        ["\x68\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],
        ["\xE4\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x6B"],

        ["\x68\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],
        ["\xE4\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x6C"],

        ["\x68\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],
        ["\xE4\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x6D"],

        ["\x68\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],
        ["\xE4\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x6E"],

        ["\x68\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],
        ["\xE4\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x6F"],

        ["\x68\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],
        ["\xE4\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x70"],

        ["\x68\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],
        ["\xE4\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x71"],

        ["\x68\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],
        ["\xE4\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x72"],

        ["\x68\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],
        ["\xE4\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x73"],

        ["\x68\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],
        ["\xE4\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x74"],

        ["\x68\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],
        ["\xE4\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x75"],

        ["\x68\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],
        ["\xE4\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x76"],

        ["\x68\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],
        ["\xE4\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x77"],

        ["\x68\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],
        ["\xE4\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x78"],

        ["\x68\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],
        ["\xE4\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x79"],

        ["\x68\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],
        ["\xE4\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x7A"],

        ["\x68\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],
        ["\xE4\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x7B"],

        ["\x68\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],
        ["\xE4\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x7C"],

        ["\x68\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],
        ["\xE4\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x7D"],

        ["\x68\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],
        ["\xE4\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x68\x7E"],

        ["\x69\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x40"],
        ["\xE5\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x21"],

        ["\x3C\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x41"],
        ["\xE5\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3C\x49"],

        ["\x69\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x42"],
        ["\xE5\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x23"],

        ["\x69\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x43"],
        ["\xE5\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x24"],

        ["\x69\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x44"],
        ["\xE5\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x25"],

        ["\x69\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x45"],
        ["\xE5\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x26"],

        ["\x69\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x46"],
        ["\xE5\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x27"],

        ["\x69\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x47"],
        ["\xE5\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x28"],

        ["\x69\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x48"],
        ["\xE5\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x29"],

        ["\x69\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x49"],
        ["\xE5\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x2A"],

        ["\x69\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x4A"],
        ["\xE5\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x2B"],

        ["\x69\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x4B"],
        ["\xE5\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x2C"],

        ["\x69\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x4C"],
        ["\xE5\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x2D"],

        ["\x4C\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x4D"],
        ["\xE5\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x4C\x79"],

        ["\x69\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x4E"],
        ["\xE5\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x2F"],

        ["\x69\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x4F"],
        ["\xE5\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x30"],

        ["\x69\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x50"],
        ["\xE5\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x31"],

        ["\x69\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x51"],
        ["\xE5\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x32"],

        ["\x69\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x52"],
        ["\xE5\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x33"],

        ["\x69\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x53"],
        ["\xE5\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x34"],

        ["\x69\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x54"],
        ["\xE5\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x35"],

        ["\x69\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x55"],
        ["\xE5\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x36"],

        ["\x69\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x56"],
        ["\xE5\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x37"],

        ["\x69\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x57"],
        ["\xE5\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x38"],

        ["\x69\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x58"],
        ["\xE5\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x39"],

        ["\x69\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x59"],
        ["\xE5\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x3A"],

        ["\x69\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x5A"],
        ["\xE5\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x3B"],

        ["\x69\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x5B"],
        ["\xE5\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x3C"],

        ["\x69\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x5C"],
        ["\xE5\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x3D"],

        ["\x69\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x5D"],
        ["\xE5\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x3E"],

        ["\x69\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x5E"],
        ["\xE5\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x3F"],

        ["\x69\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x5F"],
        ["\xE5\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x40"],

        ["\x69\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x60"],
        ["\xE5\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x41"],

        ["\x69\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x61"],
        ["\xE5\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x42"],

        ["\x69\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x62"],
        ["\xE5\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x43"],

        ["\x69\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x63"],
        ["\xE5\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x44"],

        ["\x69\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x64"],
        ["\xE5\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x45"],

        ["\x69\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x65"],
        ["\xE5\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x46"],

        ["\x69\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x66"],
        ["\xE5\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x47"],

        ["\x69\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x67"],
        ["\xE5\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x48"],

        ["\x69\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x68"],
        ["\xE5\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x49"],

        ["\x69\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x69"],
        ["\xE5\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x4A"],

        ["\x69\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x6A"],
        ["\xE5\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x4B"],

        ["\x69\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x6B"],
        ["\xE5\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x4C"],

        ["\x69\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x6C"],
        ["\xE5\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x4D"],

        ["\x69\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x6D"],
        ["\xE5\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x4E"],

        ["\x69\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x6E"],
        ["\xE5\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x4F"],

        ["\x69\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x6F"],
        ["\xE5\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x50"],

        ["\x69\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x70"],
        ["\xE5\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x51"],

        ["\x69\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x71"],
        ["\xE5\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x52"],

        ["\x69\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x72"],
        ["\xE5\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x53"],

        ["\x69\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x73"],
        ["\xE5\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x54"],

        ["\x69\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x74"],
        ["\xE5\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x55"],

        ["\x69\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x75"],
        ["\xE5\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x56"],

        ["\x69\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x76"],
        ["\xE5\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x57"],

        ["\x69\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x77"],
        ["\xE5\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x58"],

        ["\x69\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x78"],
        ["\xE5\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x59"],

        ["\x33\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x79"],
        ["\xE5\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x33\x42"],

        ["\x69\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x7A"],
        ["\xE5\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x5B"],

        ["\x69\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x7B"],
        ["\xE5\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x5C"],

        ["\x69\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x7C"],
        ["\xE5\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x5D"],

        ["\x69\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x7D"],
        ["\xE5\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x5E"],

        ["\x69\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x7E"],
        ["\xE5\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x5F"],

        ["\x69\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x80"],
        ["\xE5\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x60"],

        ["\x69\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x81"],
        ["\xE5\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x61"],

        ["\x69\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x82"],
        ["\xE5\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x62"],

        ["\x69\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x83"],
        ["\xE5\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x63"],

        ["\x69\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x84"],
        ["\xE5\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x64"],

        ["\x69\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x85"],
        ["\xE5\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x65"],

        ["\x69\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x86"],
        ["\xE5\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x66"],

        ["\x69\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x87"],
        ["\xE5\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x67"],

        ["\x69\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x88"],
        ["\xE5\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x68"],

        ["\x69\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x89"],
        ["\xE5\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x69"],

        ["\x69\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A"],
        ["\xE5\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x6A"],

        ["\x69\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B"],
        ["\xE5\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x6B"],

        ["\x69\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C"],
        ["\xE5\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x6C"],

        ["\x69\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D"],
        ["\xE5\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x6D"],

        ["\x69\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E"],
        ["\xE5\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x6E"],

        ["\x69\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F"],
        ["\xE5\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x6F"],

        ["\x69\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x90"],
        ["\xE5\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x70"],

        ["\x69\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x91"],
        ["\xE5\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x71"],

        ["\x69\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x92"],
        ["\xE5\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x72"],

        ["\x69\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x93"],
        ["\xE5\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x73"],

        ["\x69\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x94"],
        ["\xE5\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x74"],

        ["\x69\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x95"],
        ["\xE5\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x75"],

        ["\x69\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x96"],
        ["\xE5\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x76"],

        ["\x69\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x97"],
        ["\xE5\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x77"],

        ["\x69\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x98"],
        ["\xE5\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x78"],

        ["\x69\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x99"],
        ["\xE5\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x79"],

        ["\x69\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A"],
        ["\xE5\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x7A"],

        ["\x69\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B"],
        ["\xE5\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x7B"],

        ["\x69\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C"],
        ["\xE5\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x7C"],

        ["\x69\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D"],
        ["\xE5\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x7D"],

        ["\x69\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E"],
        ["\xE5\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x69\x7E"],

        ["\x6A\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F"],
        ["\xE5\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x21"],

        ["\x6A\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0"],
        ["\xE5\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x22"],

        ["\x6A\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],
        ["\xE5\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x23"],

        ["\x47\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],
        ["\xE5\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x47\x68"],

        ["\x6A\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],
        ["\xE5\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x25"],

        ["\x6A\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],
        ["\xE5\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x26"],

        ["\x6A\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],
        ["\xE5\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x27"],

        ["\x6A\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],
        ["\xE5\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x28"],

        ["\x6A\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],
        ["\xE5\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x29"],

        ["\x6A\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],
        ["\xE5\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x2A"],

        ["\x6A\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],
        ["\xE5\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x2B"],

        ["\x6A\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],
        ["\xE5\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x2C"],

        ["\x6A\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],
        ["\xE5\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x2D"],

        ["\x6A\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],
        ["\xE5\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x2E"],

        ["\x6A\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],
        ["\xE5\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x2F"],

        ["\x6A\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],
        ["\xE5\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x30"],

        ["\x6A\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],
        ["\xE5\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x31"],

        ["\x6A\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],
        ["\xE5\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x32"],

        ["\x6A\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],
        ["\xE5\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x33"],

        ["\x6A\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],
        ["\xE5\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x34"],

        ["\x6A\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],
        ["\xE5\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x35"],

        ["\x6A\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],
        ["\xE5\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x36"],

        ["\x6A\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],
        ["\xE5\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x37"],

        ["\x6A\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],
        ["\xE5\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x38"],

        ["\x6A\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],
        ["\xE5\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x39"],

        ["\x6A\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],
        ["\xE5\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x3A"],

        ["\x6A\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],
        ["\xE5\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x3B"],

        ["\x6A\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],
        ["\xE5\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x3C"],

        ["\x6A\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],
        ["\xE5\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x3D"],

        ["\x6A\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],
        ["\xE5\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x3E"],

        ["\x6A\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],
        ["\xE5\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x3F"],

        ["\x6A\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],
        ["\xE5\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x40"],

        ["\x6A\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],
        ["\xE5\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x41"],

        ["\x6A\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],
        ["\xE5\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x42"],

        ["\x6A\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],
        ["\xE5\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x43"],

        ["\x6A\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],
        ["\xE5\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x44"],

        ["\x6A\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],
        ["\xE5\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x45"],

        ["\x6A\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],
        ["\xE5\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x46"],

        ["\x6A\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],
        ["\xE5\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x47"],

        ["\x6A\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],
        ["\xE5\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x48"],

        ["\x6A\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],
        ["\xE5\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x49"],

        ["\x6A\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],
        ["\xE5\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x4A"],

        ["\x6A\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],
        ["\xE5\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x4B"],

        ["\x6A\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],
        ["\xE5\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x4C"],

        ["\x6A\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],
        ["\xE5\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x4D"],

        ["\x6A\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],
        ["\xE5\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x4E"],

        ["\x6A\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],
        ["\xE5\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x4F"],

        ["\x6A\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],
        ["\xE5\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x50"],

        ["\x6A\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],
        ["\xE5\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x51"],

        ["\x6A\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],
        ["\xE5\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x52"],

        ["\x6A\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],
        ["\xE5\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x53"],

        ["\x6A\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],
        ["\xE5\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x54"],

        ["\x6A\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],
        ["\xE5\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x55"],

        ["\x6A\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],
        ["\xE5\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x56"],

        ["\x6A\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],
        ["\xE5\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x57"],

        ["\x6A\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],
        ["\xE5\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x58"],

        ["\x6A\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],
        ["\xE5\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x59"],

        ["\x6A\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],
        ["\xE5\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x5A"],

        ["\x6A\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],
        ["\xE5\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x5B"],

        ["\x6A\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],
        ["\xE5\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x5C"],

        ["\x6A\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],
        ["\xE5\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x5D"],

        ["\x6A\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],
        ["\xE5\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x5E"],

        ["\x6A\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],
        ["\xE5\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x5F"],

        ["\x6A\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],
        ["\xE5\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x60"],

        ["\x6A\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],
        ["\xE5\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x61"],

        ["\x6A\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],
        ["\xE5\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x62"],

        ["\x6A\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],
        ["\xE5\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x63"],

        ["\x6A\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],
        ["\xE5\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x64"],

        ["\x6A\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],
        ["\xE5\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x65"],

        ["\x6A\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],
        ["\xE5\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x66"],

        ["\x6A\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],
        ["\xE5\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x67"],

        ["\x6A\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],
        ["\xE5\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x68"],

        ["\x6A\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],
        ["\xE5\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x69"],

        ["\x6A\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],
        ["\xE5\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x6A"],

        ["\x6A\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],
        ["\xE5\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x6B"],

        ["\x6A\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],
        ["\xE5\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x6C"],

        ["\x6A\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],
        ["\xE5\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x6D"],

        ["\x6A\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],
        ["\xE5\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x6E"],

        ["\x6A\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],
        ["\xE5\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x6F"],

        ["\x6A\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],
        ["\xE5\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x70"],

        ["\x6A\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],
        ["\xE5\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x71"],

        ["\x6A\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],
        ["\xE5\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x72"],

        ["\x6A\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],
        ["\xE5\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x73"],

        ["\x6A\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],
        ["\xE5\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x74"],

        ["\x6A\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],
        ["\xE5\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x75"],

        ["\x6A\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],
        ["\xE5\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x76"],

        ["\x6A\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],
        ["\xE5\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x77"],

        ["\x6A\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],
        ["\xE5\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x78"],

        ["\x6A\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],
        ["\xE5\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x79"],

        ["\x6A\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],
        ["\xE5\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x7A"],

        ["\x6A\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],
        ["\xE5\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x7B"],

        ["\x6A\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],
        ["\xE5\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x7C"],

        ["\x6A\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],
        ["\xE5\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x7D"],

        ["\x6A\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],
        ["\xE5\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6A\x7E"],

        ["\x6B\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x40"],
        ["\xE6\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x21"],

        ["\x6B\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x41"],
        ["\xE6\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x22"],

        ["\x6B\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x42"],
        ["\xE6\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x23"],

        ["\x6B\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x43"],
        ["\xE6\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x24"],

        ["\x6B\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x44"],
        ["\xE6\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x25"],

        ["\x6B\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x45"],
        ["\xE6\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x26"],

        ["\x6B\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x46"],
        ["\xE6\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x27"],

        ["\x6B\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x47"],
        ["\xE6\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x28"],

        ["\x6B\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x48"],
        ["\xE6\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x29"],

        ["\x6B\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x49"],
        ["\xE6\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x2A"],

        ["\x6B\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x4A"],
        ["\xE6\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x2B"],

        ["\x6B\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x4B"],
        ["\xE6\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x2C"],

        ["\x6B\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x4C"],
        ["\xE6\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x2D"],

        ["\x6B\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x4D"],
        ["\xE6\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x2E"],

        ["\x6B\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x4E"],
        ["\xE6\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x2F"],

        ["\x6B\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x4F"],
        ["\xE6\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x30"],

        ["\x6B\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x50"],
        ["\xE6\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x31"],

        ["\x6B\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x51"],
        ["\xE6\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x32"],

        ["\x6B\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x52"],
        ["\xE6\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x33"],

        ["\x6B\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x53"],
        ["\xE6\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x34"],

        ["\x6B\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x54"],
        ["\xE6\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x35"],

        ["\x6B\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x55"],
        ["\xE6\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x36"],

        ["\x6B\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x56"],
        ["\xE6\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x37"],

        ["\x6B\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x57"],
        ["\xE6\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x38"],

        ["\x6B\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x58"],
        ["\xE6\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x39"],

        ["\x6B\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x59"],
        ["\xE6\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x3A"],

        ["\x6B\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x5A"],
        ["\xE6\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x3B"],

        ["\x6B\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x5B"],
        ["\xE6\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x3C"],

        ["\x6B\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x5C"],
        ["\xE6\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x3D"],

        ["\x6B\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x5D"],
        ["\xE6\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x3E"],

        ["\x6B\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x5E"],
        ["\xE6\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x3F"],

        ["\x6B\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x5F"],
        ["\xE6\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x40"],

        ["\x6B\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x60"],
        ["\xE6\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x41"],

        ["\x6B\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x61"],
        ["\xE6\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x42"],

        ["\x6B\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x62"],
        ["\xE6\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x43"],

        ["\x6B\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x63"],
        ["\xE6\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x44"],

        ["\x6B\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x64"],
        ["\xE6\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x45"],

        ["\x6B\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x65"],
        ["\xE6\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x46"],

        ["\x6B\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x66"],
        ["\xE6\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x47"],

        ["\x6B\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x67"],
        ["\xE6\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x48"],

        ["\x6B\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x68"],
        ["\xE6\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x49"],

        ["\x6B\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x69"],
        ["\xE6\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x4A"],

        ["\x6B\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x6A"],
        ["\xE6\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x4B"],

        ["\x6B\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x6B"],
        ["\xE6\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x4C"],

        ["\x6B\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x6C"],
        ["\xE6\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x4D"],

        ["\x6B\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x6D"],
        ["\xE6\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x4E"],

        ["\x6B\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x6E"],
        ["\xE6\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x4F"],

        ["\x6B\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x6F"],
        ["\xE6\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x50"],

        ["\x6B\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x70"],
        ["\xE6\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x51"],

        ["\x6B\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x71"],
        ["\xE6\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x52"],

        ["\x6B\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x72"],
        ["\xE6\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x53"],

        ["\x6B\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x73"],
        ["\xE6\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x54"],

        ["\x6B\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x74"],
        ["\xE6\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x55"],

        ["\x6B\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x75"],
        ["\xE6\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x56"],

        ["\x6B\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x76"],
        ["\xE6\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x57"],

        ["\x6B\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x77"],
        ["\xE6\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x58"],

        ["\x6B\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x78"],
        ["\xE6\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x59"],

        ["\x6B\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x79"],
        ["\xE6\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x5A"],

        ["\x6B\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x7A"],
        ["\xE6\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x5B"],

        ["\x6B\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x7B"],
        ["\xE6\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x5C"],

        ["\x34\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x7C"],
        ["\xE6\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x34\x52"],

        ["\x6B\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x7D"],
        ["\xE6\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x5E"],

        ["\x6B\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x7E"],
        ["\xE6\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x5F"],

        ["\x6B\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x80"],
        ["\xE6\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x60"],

        ["\x6B\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x81"],
        ["\xE6\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x61"],

        ["\x6B\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x82"],
        ["\xE6\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x62"],

        ["\x6B\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x83"],
        ["\xE6\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x63"],

        ["\x6B\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x84"],
        ["\xE6\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x64"],

        ["\x6B\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x85"],
        ["\xE6\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x65"],

        ["\x6B\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x86"],
        ["\xE6\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x66"],

        ["\x6B\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x87"],
        ["\xE6\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x67"],

        ["\x6B\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x88"],
        ["\xE6\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x68"],

        ["\x6B\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x89"],
        ["\xE6\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x69"],

        ["\x6B\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A"],
        ["\xE6\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x6A"],

        ["\x6B\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B"],
        ["\xE6\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x6B"],

        ["\x6B\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C"],
        ["\xE6\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x6C"],

        ["\x6B\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D"],
        ["\xE6\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x6D"],

        ["\x6B\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E"],
        ["\xE6\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x6E"],

        ["\x6B\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F"],
        ["\xE6\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x6F"],

        ["\x6B\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x90"],
        ["\xE6\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x70"],

        ["\x6B\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x91"],
        ["\xE6\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x71"],

        ["\x6B\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x92"],
        ["\xE6\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x72"],

        ["\x6B\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x93"],
        ["\xE6\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x73"],

        ["\x6B\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x94"],
        ["\xE6\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x74"],

        ["\x6B\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x95"],
        ["\xE6\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x75"],

        ["\x6B\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x96"],
        ["\xE6\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x76"],

        ["\x6B\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x97"],
        ["\xE6\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x77"],

        ["\x6B\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x98"],
        ["\xE6\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x78"],

        ["\x6B\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x99"],
        ["\xE6\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x79"],

        ["\x6B\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A"],
        ["\xE6\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x7A"],

        ["\x6B\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B"],
        ["\xE6\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x7B"],

        ["\x6B\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C"],
        ["\xE6\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x7C"],

        ["\x6B\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D"],
        ["\xE6\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x7D"],

        ["\x6B\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E"],
        ["\xE6\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6B\x7E"],

        ["\x6C\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F"],
        ["\xE6\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x21"],

        ["\x6C\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0"],
        ["\xE6\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x22"],

        ["\x6C\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],
        ["\xE6\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x23"],

        ["\x6C\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2"],
        ["\xE6\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x24"],

        ["\x6C\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3"],
        ["\xE6\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x25"],

        ["\x6C\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4"],
        ["\xE6\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x26"],

        ["\x6C\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5"],
        ["\xE6\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x27"],

        ["\x6C\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],
        ["\xE6\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x28"],

        ["\x6C\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],
        ["\xE6\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x29"],

        ["\x6C\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],
        ["\xE6\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x2A"],

        ["\x6C\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],
        ["\xE6\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x2B"],

        ["\x6C\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA"],
        ["\xE6\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x2C"],

        ["\x6C\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],
        ["\xE6\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x2D"],

        ["\x6C\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],
        ["\xE6\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x2E"],

        ["\x6C\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD"],
        ["\xE6\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x2F"],

        ["\x6C\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],
        ["\xE6\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x30"],

        ["\x6C\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],
        ["\xE6\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x31"],

        ["\x6C\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],
        ["\xE6\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x32"],

        ["\x6C\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1"],
        ["\xE6\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x33"],

        ["\x6C\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2"],
        ["\xE6\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x34"],

        ["\x6C\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],
        ["\xE6\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x35"],

        ["\x6C\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],
        ["\xE6\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x36"],

        ["\x6C\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],
        ["\xE6\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x37"],

        ["\x6C\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6"],
        ["\xE6\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x38"],

        ["\x6C\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7"],
        ["\xE6\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x39"],

        ["\x6C\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],
        ["\xE6\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x3A"],

        ["\x6C\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],
        ["\xE6\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x3B"],

        ["\x6C\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],
        ["\xE6\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x3C"],

        ["\x6C\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB"],
        ["\xE6\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x3D"],

        ["\x6C\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC"],
        ["\xE6\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x3E"],

        ["\x6C\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD"],
        ["\xE6\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x3F"],

        ["\x6C\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE"],
        ["\xE6\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x40"],

        ["\x6C\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF"],
        ["\xE6\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x41"],

        ["\x6C\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],
        ["\xE6\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x42"],

        ["\x6C\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],
        ["\xE6\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x43"],

        ["\x6C\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],
        ["\xE6\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x44"],

        ["\x6C\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],
        ["\xE6\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x45"],

        ["\x6C\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],
        ["\xE6\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x46"],

        ["\x6C\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],
        ["\xE6\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x47"],

        ["\x6C\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],
        ["\xE6\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x48"],

        ["\x6C\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],
        ["\xE6\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x49"],

        ["\x6C\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],
        ["\xE6\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x4A"],

        ["\x6C\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],
        ["\xE6\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x4B"],

        ["\x6C\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCA"],
        ["\xE6\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x4C"],

        ["\x41\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCB"],
        ["\xE6\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x41\x28"],

        ["\x6C\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCC"],
        ["\xE6\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x4E"],

        ["\x6C\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCD"],
        ["\xE6\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x4F"],

        ["\x6C\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCE"],
        ["\xE6\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x50"],

        ["\x6C\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],
        ["\xE6\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x51"],

        ["\x6C\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],
        ["\xE6\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x52"],

        ["\x6C\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],
        ["\xE6\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x53"],

        ["\x6C\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],
        ["\xE6\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x54"],

        ["\x6C\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],
        ["\xE6\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x55"],

        ["\x6C\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],
        ["\xE6\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x56"],

        ["\x6C\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],
        ["\xE6\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x57"],

        ["\x6C\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],
        ["\xE6\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x58"],

        ["\x6C\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],
        ["\xE6\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x59"],

        ["\x6C\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],
        ["\xE6\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x5A"],

        ["\x6C\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],
        ["\xE6\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x5B"],

        ["\x6C\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],
        ["\xE6\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x5C"],

        ["\x6C\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],
        ["\xE6\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x5D"],

        ["\x6C\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],
        ["\xE6\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x5E"],

        ["\x6C\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],
        ["\xE6\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x5F"],

        ["\x6C\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDE"],
        ["\xE6\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x60"],

        ["\x6C\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xDF"],
        ["\xE6\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x61"],

        ["\x6C\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],
        ["\xE6\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x62"],

        ["\x6C\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE1"],
        ["\xE6\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x63"],

        ["\x6C\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],
        ["\xE6\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x64"],

        ["\x6C\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],
        ["\xE6\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x65"],

        ["\x6C\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],
        ["\xE6\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x66"],

        ["\x6C\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],
        ["\xE6\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x67"],

        ["\x6C\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],
        ["\xE6\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x68"],

        ["\x6C\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],
        ["\xE6\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x69"],

        ["\x6C\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],
        ["\xE6\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x6A"],

        ["\x6C\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],
        ["\xE6\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x6B"],

        ["\x6C\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEA"],
        ["\xE6\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x6C"],

        ["\x6C\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEB"],
        ["\xE6\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x6D"],

        ["\x6C\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEC"],
        ["\xE6\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x6E"],

        ["\x6C\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xED"],
        ["\xE6\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x6F"],

        ["\x6C\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEE"],
        ["\xE6\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x70"],

        ["\x6C\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],
        ["\xE6\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x71"],

        ["\x6C\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],
        ["\xE6\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x72"],

        ["\x6C\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],
        ["\xE6\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x73"],

        ["\x6C\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],
        ["\xE6\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x74"],

        ["\x6C\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],
        ["\xE6\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x75"],

        ["\x6C\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],
        ["\xE6\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x76"],

        ["\x6C\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],
        ["\xE6\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x77"],

        ["\x6C\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\xE6\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x78"],

        ["\x6C\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],
        ["\xE6\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x79"],

        ["\x6C\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],
        ["\xE6\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x7A"],

        ["\x6C\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],
        ["\xE6\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x7B"],

        ["\x6C\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xFA"],
        ["\xE6\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x7C"],

        ["\x6C\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xFB"],
        ["\xE6\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x7D"],

        ["\x6C\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE6\xFC"],
        ["\xE6\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6C\x7E"],

        ["\x6D\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x40"],
        ["\xE7\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x21"],

        ["\x6D\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x41"],
        ["\xE7\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x22"],

        ["\x6D\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x42"],
        ["\xE7\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x23"],

        ["\x6D\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x43"],
        ["\xE7\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x24"],

        ["\x6D\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x44"],
        ["\xE7\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x25"],

        ["\x6D\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x45"],
        ["\xE7\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x26"],

        ["\x6D\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x46"],
        ["\xE7\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x27"],

        ["\x6D\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x47"],
        ["\xE7\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x28"],

        ["\x6D\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x48"],
        ["\xE7\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x29"],

        ["\x6D\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x49"],
        ["\xE7\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x2A"],

        ["\x6D\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x4A"],
        ["\xE7\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x2B"],

        ["\x6D\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x4B"],
        ["\xE7\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x2C"],

        ["\x6D\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x4C"],
        ["\xE7\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x2D"],

        ["\x6D\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x4D"],
        ["\xE7\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x2E"],

        ["\x6D\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x4E"],
        ["\xE7\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x2F"],

        ["\x6D\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x4F"],
        ["\xE7\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x30"],

        ["\x6D\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x50"],
        ["\xE7\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x31"],

        ["\x6D\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x51"],
        ["\xE7\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x32"],

        ["\x6D\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x52"],
        ["\xE7\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x33"],

        ["\x6D\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x53"],
        ["\xE7\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x34"],

        ["\x6D\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x54"],
        ["\xE7\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x35"],

        ["\x6D\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x55"],
        ["\xE7\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x36"],

        ["\x6D\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x56"],
        ["\xE7\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x37"],

        ["\x6D\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x57"],
        ["\xE7\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x38"],

        ["\x6D\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x58"],
        ["\xE7\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x39"],

        ["\x6D\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x59"],
        ["\xE7\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x3A"],

        ["\x6D\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x5A"],
        ["\xE7\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x3B"],

        ["\x6D\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x5B"],
        ["\xE7\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x3C"],

        ["\x6D\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x5C"],
        ["\xE7\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x3D"],

        ["\x6D\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x5D"],
        ["\xE7\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x3E"],

        ["\x6D\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x5E"],
        ["\xE7\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x3F"],

        ["\x6D\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x5F"],
        ["\xE7\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x40"],

        ["\x6D\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x60"],
        ["\xE7\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x41"],

        ["\x6D\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x61"],
        ["\xE7\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x42"],

        ["\x6D\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x62"],
        ["\xE7\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x43"],

        ["\x6D\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x63"],
        ["\xE7\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x44"],

        ["\x6D\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x64"],
        ["\xE7\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x45"],

        ["\x6D\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x65"],
        ["\xE7\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x46"],

        ["\x6D\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x66"],
        ["\xE7\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x47"],

        ["\x6D\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x67"],
        ["\xE7\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x48"],

        ["\x6D\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x68"],
        ["\xE7\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x49"],

        ["\x6D\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x69"],
        ["\xE7\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x4A"],

        ["\x6D\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x6A"],
        ["\xE7\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x4B"],

        ["\x6D\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x6B"],
        ["\xE7\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x4C"],

        ["\x6D\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x6C"],
        ["\xE7\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x4D"],

        ["\x6D\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x6D"],
        ["\xE7\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x4E"],

        ["\x6D\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x6E"],
        ["\xE7\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x4F"],

        ["\x6D\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x6F"],
        ["\xE7\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x50"],

        ["\x6D\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x70"],
        ["\xE7\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x51"],

        ["\x6D\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x71"],
        ["\xE7\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x52"],

        ["\x6D\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x72"],
        ["\xE7\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x53"],

        ["\x6D\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x73"],
        ["\xE7\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x54"],

        ["\x6D\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x74"],
        ["\xE7\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x55"],

        ["\x6D\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x75"],
        ["\xE7\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x56"],

        ["\x6D\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x76"],
        ["\xE7\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x57"],

        ["\x6D\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x77"],
        ["\xE7\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x58"],

        ["\x6D\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x78"],
        ["\xE7\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x59"],

        ["\x6D\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x79"],
        ["\xE7\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x5A"],

        ["\x6D\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x7A"],
        ["\xE7\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x5B"],

        ["\x6D\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x7B"],
        ["\xE7\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x5C"],

        ["\x6D\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x7C"],
        ["\xE7\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x5D"],

        ["\x6D\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x7D"],
        ["\xE7\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x5E"],

        ["\x6D\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x7E"],
        ["\xE7\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x5F"],

        ["\x6D\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x80"],
        ["\xE7\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x60"],

        ["\x6D\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x81"],
        ["\xE7\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x61"],

        ["\x6D\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x82"],
        ["\xE7\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x62"],

        ["\x6D\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x83"],
        ["\xE7\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x63"],

        ["\x6D\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x84"],
        ["\xE7\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x64"],

        ["\x6D\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x85"],
        ["\xE7\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x65"],

        ["\x6D\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x86"],
        ["\xE7\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x66"],

        ["\x6D\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x87"],
        ["\xE7\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x67"],

        ["\x6D\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x88"],
        ["\xE7\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x68"],

        ["\x6D\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x89"],
        ["\xE7\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x69"],

        ["\x6D\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A"],
        ["\xE7\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x6A"],

        ["\x6D\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B"],
        ["\xE7\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x6B"],

        ["\x6D\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C"],
        ["\xE7\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x6C"],

        ["\x6D\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D"],
        ["\xE7\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x6D"],

        ["\x46\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E"],
        ["\xE7\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x46\x76"],

        ["\x6D\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F"],
        ["\xE7\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x6F"],

        ["\x6D\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x90"],
        ["\xE7\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x70"],

        ["\x6D\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x91"],
        ["\xE7\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x71"],

        ["\x6D\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x92"],
        ["\xE7\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x72"],

        ["\x6D\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x93"],
        ["\xE7\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x73"],

        ["\x6D\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x94"],
        ["\xE7\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x74"],

        ["\x6D\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x95"],
        ["\xE7\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x75"],

        ["\x6D\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x96"],
        ["\xE7\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x76"],

        ["\x6D\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x97"],
        ["\xE7\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x77"],

        ["\x6D\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x98"],
        ["\xE7\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x78"],

        ["\x6D\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x99"],
        ["\xE7\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x79"],

        ["\x6D\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A"],
        ["\xE7\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x7A"],

        ["\x6D\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B"],
        ["\xE7\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x7B"],

        ["\x6D\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C"],
        ["\xE7\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x7C"],

        ["\x6D\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D"],
        ["\xE7\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x7D"],

        ["\x6D\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E"],
        ["\xE7\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6D\x7E"],

        ["\x6E\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F"],
        ["\xE7\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x21"],

        ["\x6E\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0"],
        ["\xE7\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x22"],

        ["\x6E\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],
        ["\xE7\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x23"],

        ["\x6E\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2"],
        ["\xE7\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x24"],

        ["\x6E\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3"],
        ["\xE7\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x25"],

        ["\x6E\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4"],
        ["\xE7\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x26"],

        ["\x6E\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5"],
        ["\xE7\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x27"],

        ["\x6E\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6"],
        ["\xE7\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x28"],

        ["\x6E\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7"],
        ["\xE7\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x29"],

        ["\x6E\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8"],
        ["\xE7\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x2A"],

        ["\x6E\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9"],
        ["\xE7\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x2B"],

        ["\x6E\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],
        ["\xE7\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x2C"],

        ["\x6E\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],
        ["\xE7\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x2D"],

        ["\x6E\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC"],
        ["\xE7\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x2E"],

        ["\x6E\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD"],
        ["\xE7\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x2F"],

        ["\x6E\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE"],
        ["\xE7\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x30"],

        ["\x6E\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],
        ["\xE7\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x31"],

        ["\x6E\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],
        ["\xE7\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x32"],

        ["\x6E\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],
        ["\xE7\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x33"],

        ["\x6E\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],
        ["\xE7\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x34"],

        ["\x6E\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],
        ["\xE7\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x35"],

        ["\x6E\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],
        ["\xE7\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x36"],

        ["\x6E\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],
        ["\xE7\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x37"],

        ["\x6E\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],
        ["\xE7\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x38"],

        ["\x6E\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],
        ["\xE7\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x39"],

        ["\x6E\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],
        ["\xE7\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x3A"],

        ["\x6E\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],
        ["\xE7\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x3B"],

        ["\x6E\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],
        ["\xE7\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x3C"],

        ["\x6E\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],
        ["\xE7\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x3D"],

        ["\x6E\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],
        ["\xE7\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x3E"],

        ["\x6E\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],
        ["\xE7\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x3F"],

        ["\x6E\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],
        ["\xE7\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x40"],

        ["\x6E\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],
        ["\xE7\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x41"],

        ["\x6E\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],
        ["\xE7\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x42"],

        ["\x6E\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],
        ["\xE7\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x43"],

        ["\x6E\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],
        ["\xE7\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x44"],

        ["\x6E\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],
        ["\xE7\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x45"],

        ["\x6E\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],
        ["\xE7\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x46"],

        ["\x6E\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],
        ["\xE7\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x47"],

        ["\x6E\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],
        ["\xE7\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x48"],

        ["\x6E\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],
        ["\xE7\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x49"],

        ["\x6E\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],
        ["\xE7\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x4A"],

        ["\x6E\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],
        ["\xE7\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x4B"],

        ["\x6E\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],
        ["\xE7\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x4C"],

        ["\x6E\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],
        ["\xE7\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x4D"],

        ["\x6E\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],
        ["\xE7\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x4E"],

        ["\x6E\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCD"],
        ["\xE7\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x4F"],

        ["\x6E\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCE"],
        ["\xE7\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x50"],

        ["\x6E\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xCF"],
        ["\xE7\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x51"],

        ["\x6E\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],
        ["\xE7\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x52"],

        ["\x6E\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],
        ["\xE7\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x53"],

        ["\x6E\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],
        ["\xE7\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x54"],

        ["\x6E\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],
        ["\xE7\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x55"],

        ["\x6E\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],
        ["\xE7\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x56"],

        ["\x6E\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],
        ["\xE7\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x57"],

        ["\x6E\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],
        ["\xE7\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x58"],

        ["\x6E\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],
        ["\xE7\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x59"],

        ["\x6E\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],
        ["\xE7\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x5A"],

        ["\x6E\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],
        ["\xE7\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x5B"],

        ["\x6E\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDA"],
        ["\xE7\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x5C"],

        ["\x6E\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDB"],
        ["\xE7\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x5D"],

        ["\x6E\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDC"],
        ["\xE7\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x5E"],

        ["\x6E\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDD"],
        ["\xE7\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x5F"],

        ["\x6E\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDE"],
        ["\xE7\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x60"],

        ["\x6E\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xDF"],
        ["\xE7\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x61"],

        ["\x6E\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],
        ["\xE7\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x62"],

        ["\x6E\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE1"],
        ["\xE7\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x63"],

        ["\x6E\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],
        ["\xE7\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x64"],

        ["\x6E\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],
        ["\xE7\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x65"],

        ["\x6E\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],
        ["\xE7\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x66"],

        ["\x6E\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],
        ["\xE7\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x67"],

        ["\x6E\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],
        ["\xE7\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x68"],

        ["\x6E\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],
        ["\xE7\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x69"],

        ["\x6E\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],
        ["\xE7\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x6A"],

        ["\x6E\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],
        ["\xE7\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x6B"],

        ["\x6E\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEA"],
        ["\xE7\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x6C"],

        ["\x6E\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEB"],
        ["\xE7\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x6D"],

        ["\x6E\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEC"],
        ["\xE7\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x6E"],

        ["\x6E\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xED"],
        ["\xE7\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x6F"],

        ["\x6E\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEE"],
        ["\xE7\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x70"],

        ["\x6E\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xEF"],
        ["\xE7\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x71"],

        ["\x6E\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],
        ["\xE7\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x72"],

        ["\x6E\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],
        ["\xE7\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x73"],

        ["\x6E\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],
        ["\xE7\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x74"],

        ["\x6E\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],
        ["\xE7\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x75"],

        ["\x6E\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],
        ["\xE7\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x76"],

        ["\x6E\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],
        ["\xE7\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x77"],

        ["\x6E\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],
        ["\xE7\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x78"],

        ["\x6E\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],
        ["\xE7\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x79"],

        ["\x6E\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],
        ["\xE7\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x7A"],

        ["\x6E\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],
        ["\xE7\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x7B"],

        ["\x6E\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xFA"],
        ["\xE7\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x7C"],

        ["\x6E\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xFB"],
        ["\xE7\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x7D"],

        ["\x6E\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE7\xFC"],
        ["\xE7\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6E\x7E"],

        ["\x6F\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x40"],
        ["\xE8\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x21"],

        ["\x6F\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x41"],
        ["\xE8\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x22"],

        ["\x6F\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x42"],
        ["\xE8\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x23"],

        ["\x6F\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x43"],
        ["\xE8\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x24"],

        ["\x6F\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x44"],
        ["\xE8\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x25"],

        ["\x6F\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x45"],
        ["\xE8\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x26"],

        ["\x6F\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x46"],
        ["\xE8\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x27"],

        ["\x6F\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x47"],
        ["\xE8\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x28"],

        ["\x6F\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x48"],
        ["\xE8\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x29"],

        ["\x6F\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x49"],
        ["\xE8\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x2A"],

        ["\x6F\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x4A"],
        ["\xE8\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x2B"],

        ["\x6F\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x4B"],
        ["\xE8\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x2C"],

        ["\x6F\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x4C"],
        ["\xE8\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x2D"],

        ["\x6F\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x4D"],
        ["\xE8\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x2E"],

        ["\x6F\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x4E"],
        ["\xE8\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x2F"],

        ["\x6F\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x4F"],
        ["\xE8\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x30"],

        ["\x6F\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x50"],
        ["\xE8\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x31"],

        ["\x6F\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x51"],
        ["\xE8\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x32"],

        ["\x6F\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x52"],
        ["\xE8\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x33"],

        ["\x6F\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x53"],
        ["\xE8\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x34"],

        ["\x6F\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x54"],
        ["\xE8\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x35"],

        ["\x6F\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x55"],
        ["\xE8\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x36"],

        ["\x6F\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x56"],
        ["\xE8\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x37"],

        ["\x6F\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x57"],
        ["\xE8\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x38"],

        ["\x6F\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x58"],
        ["\xE8\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x39"],

        ["\x6F\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x59"],
        ["\xE8\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x3A"],

        ["\x6F\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x5A"],
        ["\xE8\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x3B"],

        ["\x6F\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x5B"],
        ["\xE8\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x3C"],

        ["\x6F\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x5C"],
        ["\xE8\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x3D"],

        ["\x6F\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x5D"],
        ["\xE8\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x3E"],

        ["\x6F\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x5E"],
        ["\xE8\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x3F"],

        ["\x6F\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x5F"],
        ["\xE8\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x40"],

        ["\x6F\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x60"],
        ["\xE8\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x41"],

        ["\x6F\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x61"],
        ["\xE8\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x42"],

        ["\x6F\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x62"],
        ["\xE8\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x43"],

        ["\x6F\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x63"],
        ["\xE8\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x44"],

        ["\x6F\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x64"],
        ["\xE8\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x45"],

        ["\x6F\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x65"],
        ["\xE8\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x46"],

        ["\x6F\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x66"],
        ["\xE8\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x47"],

        ["\x6F\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x67"],
        ["\xE8\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x48"],

        ["\x6F\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x68"],
        ["\xE8\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x49"],

        ["\x6F\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x69"],
        ["\xE8\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x4A"],

        ["\x6F\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x6A"],
        ["\xE8\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x4B"],

        ["\x6F\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x6B"],
        ["\xE8\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x4C"],

        ["\x6F\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x6C"],
        ["\xE8\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x4D"],

        ["\x6F\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x6D"],
        ["\xE8\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x4E"],

        ["\x6F\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x6E"],
        ["\xE8\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x4F"],

        ["\x6F\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x6F"],
        ["\xE8\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x50"],

        ["\x6F\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x70"],
        ["\xE8\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x51"],

        ["\x6F\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x71"],
        ["\xE8\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x52"],

        ["\x6F\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x72"],
        ["\xE8\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x53"],

        ["\x6F\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x73"],
        ["\xE8\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x54"],

        ["\x6F\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x74"],
        ["\xE8\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x55"],

        ["\x6F\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x75"],
        ["\xE8\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x56"],

        ["\x6F\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x76"],
        ["\xE8\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x57"],

        ["\x6F\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x77"],
        ["\xE8\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x58"],

        ["\x6F\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x78"],
        ["\xE8\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x59"],

        ["\x6F\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x79"],
        ["\xE8\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x5A"],

        ["\x6F\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x7A"],
        ["\xE8\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x5B"],

        ["\x6F\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x7B"],
        ["\xE8\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x5C"],

        ["\x6F\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x7C"],
        ["\xE8\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x5D"],

        ["\x6F\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x7D"],
        ["\xE8\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x5E"],

        ["\x6F\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x7E"],
        ["\xE8\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x5F"],

        ["\x6F\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x80"],
        ["\xE8\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x60"],

        ["\x6F\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x81"],
        ["\xE8\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x61"],

        ["\x6F\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x82"],
        ["\xE8\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x62"],

        ["\x6F\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x83"],
        ["\xE8\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x63"],

        ["\x6F\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x84"],
        ["\xE8\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x64"],

        ["\x6F\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x85"],
        ["\xE8\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x65"],

        ["\x6F\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x86"],
        ["\xE8\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x66"],

        ["\x6F\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x87"],
        ["\xE8\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x67"],

        ["\x6F\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x88"],
        ["\xE8\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x68"],

        ["\x6F\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x89"],
        ["\xE8\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x69"],

        ["\x6F\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A"],
        ["\xE8\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x6A"],

        ["\x6F\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B"],
        ["\xE8\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x6B"],

        ["\x6F\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C"],
        ["\xE8\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x6C"],

        ["\x6F\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D"],
        ["\xE8\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x6D"],

        ["\x6F\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E"],
        ["\xE8\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x6E"],

        ["\x6F\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F"],
        ["\xE8\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x6F"],

        ["\x6F\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x90"],
        ["\xE8\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x70"],

        ["\x6F\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x91"],
        ["\xE8\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x71"],

        ["\x6F\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x92"],
        ["\xE8\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x72"],

        ["\x6F\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x93"],
        ["\xE8\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x73"],

        ["\x6F\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x94"],
        ["\xE8\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x74"],

        ["\x6F\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x95"],
        ["\xE8\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x75"],

        ["\x6F\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x96"],
        ["\xE8\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x76"],

        ["\x6F\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x97"],
        ["\xE8\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x77"],

        ["\x6F\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x98"],
        ["\xE8\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x78"],

        ["\x6F\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x99"],
        ["\xE8\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x79"],

        ["\x6F\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A"],
        ["\xE8\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x7A"],

        ["\x6F\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B"],
        ["\xE8\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x7B"],

        ["\x6F\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C"],
        ["\xE8\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x7C"],

        ["\x6F\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D"],
        ["\xE8\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x7D"],

        ["\x6F\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E"],
        ["\xE8\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x6F\x7E"],

        ["\x70\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F"],
        ["\xE8\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x21"],

        ["\x70\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0"],
        ["\xE8\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x22"],

        ["\x70\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],
        ["\xE8\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x23"],

        ["\x70\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2"],
        ["\xE8\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x24"],

        ["\x70\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3"],
        ["\xE8\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x25"],

        ["\x70\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4"],
        ["\xE8\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x26"],

        ["\x70\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5"],
        ["\xE8\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x27"],

        ["\x70\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6"],
        ["\xE8\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x28"],

        ["\x70\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7"],
        ["\xE8\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x29"],

        ["\x70\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8"],
        ["\xE8\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x2A"],

        ["\x70\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9"],
        ["\xE8\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x2B"],

        ["\x70\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],
        ["\xE8\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x2C"],

        ["\x70\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\xE8\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x2D"],

        ["\x70\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC"],
        ["\xE8\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x2E"],

        ["\x70\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD"],
        ["\xE8\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x2F"],

        ["\x70\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],
        ["\xE8\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x30"],

        ["\x70\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xAF"],
        ["\xE8\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x31"],

        ["\x70\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],
        ["\xE8\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x32"],

        ["\x70\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1"],
        ["\xE8\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x33"],

        ["\x70\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],
        ["\xE8\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x34"],

        ["\x70\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3"],
        ["\xE8\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x35"],

        ["\x70\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4"],
        ["\xE8\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x36"],

        ["\x70\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5"],
        ["\xE8\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x37"],

        ["\x70\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6"],
        ["\xE8\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x38"],

        ["\x70\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7"],
        ["\xE8\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x39"],

        ["\x70\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],
        ["\xE8\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x3A"],

        ["\x70\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9"],
        ["\xE8\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x3B"],

        ["\x70\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA"],
        ["\xE8\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x3C"],

        ["\x70\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB"],
        ["\xE8\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x3D"],

        ["\x70\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC"],
        ["\xE8\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x3E"],

        ["\x70\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD"],
        ["\xE8\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x3F"],

        ["\x70\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE"],
        ["\xE8\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x40"],

        ["\x70\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF"],
        ["\xE8\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x41"],

        ["\x70\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],
        ["\xE8\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x42"],

        ["\x70\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],
        ["\xE8\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x43"],

        ["\x70\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],
        ["\xE8\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x44"],

        ["\x70\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],
        ["\xE8\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x45"],

        ["\x70\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],
        ["\xE8\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x46"],

        ["\x70\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],
        ["\xE8\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x47"],

        ["\x70\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],
        ["\xE8\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x48"],

        ["\x70\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],
        ["\xE8\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x49"],

        ["\x70\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],
        ["\xE8\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x4A"],

        ["\x70\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],
        ["\xE8\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x4B"],

        ["\x70\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCA"],
        ["\xE8\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x4C"],

        ["\x70\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCB"],
        ["\xE8\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x4D"],

        ["\x70\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCC"],
        ["\xE8\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x4E"],

        ["\x70\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCD"],
        ["\xE8\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x4F"],

        ["\x70\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCE"],
        ["\xE8\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x50"],

        ["\x70\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xCF"],
        ["\xE8\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x51"],

        ["\x70\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],
        ["\xE8\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x52"],

        ["\x70\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],
        ["\xE8\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x53"],

        ["\x70\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],
        ["\xE8\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x54"],

        ["\x70\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],
        ["\xE8\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x55"],

        ["\x70\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],
        ["\xE8\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x56"],

        ["\x3F\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],
        ["\xE8\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x3F\x59"],

        ["\x70\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],
        ["\xE8\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x58"],

        ["\x70\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],
        ["\xE8\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x59"],

        ["\x70\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\xE8\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x5A"],

        ["\x70\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\xE8\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x5B"],

        ["\x70\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],
        ["\xE8\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x5C"],

        ["\x70\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],
        ["\xE8\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x5D"],

        ["\x70\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDC"],
        ["\xE8\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x5E"],

        ["\x70\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDD"],
        ["\xE8\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x5F"],

        ["\x70\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDE"],
        ["\xE8\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x60"],

        ["\x70\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xDF"],
        ["\xE8\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x61"],

        ["\x70\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],
        ["\xE8\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x62"],

        ["\x70\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE1"],
        ["\xE8\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x63"],

        ["\x70\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],
        ["\xE8\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x64"],

        ["\x70\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],
        ["\xE8\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x65"],

        ["\x70\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],
        ["\xE8\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x66"],

        ["\x70\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],
        ["\xE8\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x67"],

        ["\x70\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],
        ["\xE8\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x68"],

        ["\x70\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],
        ["\xE8\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x69"],

        ["\x70\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],
        ["\xE8\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x6A"],

        ["\x70\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],
        ["\xE8\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x6B"],

        ["\x70\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEA"],
        ["\xE8\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x6C"],

        ["\x70\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],
        ["\xE8\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x6D"],

        ["\x70\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],
        ["\xE8\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x6E"],

        ["\x70\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xED"],
        ["\xE8\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x6F"],

        ["\x70\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEE"],
        ["\xE8\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x70"],

        ["\x70\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xEF"],
        ["\xE8\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x71"],

        ["\x70\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],
        ["\xE8\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x72"],

        ["\x70\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],
        ["\xE8\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x73"],

        ["\x37\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],
        ["\xE8\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x37\x5B"],

        ["\x70\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],
        ["\xE8\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x75"],

        ["\x70\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],
        ["\xE8\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x76"],

        ["\x70\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],
        ["\xE8\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x77"],

        ["\x70\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],
        ["\xE8\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x78"],

        ["\x70\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],
        ["\xE8\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x79"],

        ["\x70\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],
        ["\xE8\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x7A"],

        ["\x70\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\xE8\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x7B"],

        ["\x70\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],
        ["\xE8\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x7C"],

        ["\x70\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],
        ["\xE8\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x7D"],

        ["\x70\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE8\xFC"],
        ["\xE8\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x70\x7E"],

        ["\x71\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x40"],
        ["\xE9\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x21"],

        ["\x71\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x41"],
        ["\xE9\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x22"],

        ["\x71\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x42"],
        ["\xE9\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x23"],

        ["\x71\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x43"],
        ["\xE9\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x24"],

        ["\x71\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x44"],
        ["\xE9\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x25"],

        ["\x71\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x45"],
        ["\xE9\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x26"],

        ["\x71\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x46"],
        ["\xE9\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x27"],

        ["\x71\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x47"],
        ["\xE9\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x28"],

        ["\x71\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x48"],
        ["\xE9\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x29"],

        ["\x71\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x49"],
        ["\xE9\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x2A"],

        ["\x71\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x4A"],
        ["\xE9\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x2B"],

        ["\x71\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x4B"],
        ["\xE9\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x2C"],

        ["\x71\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x4C"],
        ["\xE9\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x2D"],

        ["\x71\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x4D"],
        ["\xE9\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x2E"],

        ["\x71\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x4E"],
        ["\xE9\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x2F"],

        ["\x71\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x4F"],
        ["\xE9\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x30"],

        ["\x71\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x50"],
        ["\xE9\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x31"],

        ["\x71\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x51"],
        ["\xE9\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x32"],

        ["\x71\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x52"],
        ["\xE9\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x33"],

        ["\x71\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x53"],
        ["\xE9\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x34"],

        ["\x71\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x54"],
        ["\xE9\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x35"],

        ["\x71\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x55"],
        ["\xE9\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x36"],

        ["\x71\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x56"],
        ["\xE9\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x37"],

        ["\x71\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x57"],
        ["\xE9\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x38"],

        ["\x71\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x58"],
        ["\xE9\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x39"],

        ["\x71\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x59"],
        ["\xE9\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x3A"],

        ["\x71\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x5A"],
        ["\xE9\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x3B"],

        ["\x71\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x5B"],
        ["\xE9\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x3C"],

        ["\x71\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x5C"],
        ["\xE9\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x3D"],

        ["\x71\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x5D"],
        ["\xE9\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x3E"],

        ["\x71\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x5E"],
        ["\xE9\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x3F"],

        ["\x71\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x5F"],
        ["\xE9\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x40"],

        ["\x71\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x60"],
        ["\xE9\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x41"],

        ["\x71\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x61"],
        ["\xE9\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x42"],

        ["\x71\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x62"],
        ["\xE9\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x43"],

        ["\x71\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x63"],
        ["\xE9\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x44"],

        ["\x71\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x64"],
        ["\xE9\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x45"],

        ["\x71\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x65"],
        ["\xE9\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x46"],

        ["\x71\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x66"],
        ["\xE9\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x47"],

        ["\x71\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x67"],
        ["\xE9\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x48"],

        ["\x71\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x68"],
        ["\xE9\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x49"],

        ["\x71\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x69"],
        ["\xE9\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x4A"],

        ["\x71\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x6A"],
        ["\xE9\x6A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x4B"],

        ["\x71\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x6B"],
        ["\xE9\x6B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x4C"],

        ["\x71\x4D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x6C"],
        ["\xE9\x6C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x4D"],

        ["\x71\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x6D"],
        ["\xE9\x6D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x4E"],

        ["\x71\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x6E"],
        ["\xE9\x6E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x4F"],

        ["\x71\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x6F"],
        ["\xE9\x6F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x50"],

        ["\x71\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x70"],
        ["\xE9\x70",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x51"],

        ["\x71\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x71"],
        ["\xE9\x71",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x52"],

        ["\x71\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x72"],
        ["\xE9\x72",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x53"],

        ["\x71\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x73"],
        ["\xE9\x73",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x54"],

        ["\x71\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x74"],
        ["\xE9\x74",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x55"],

        ["\x71\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x75"],
        ["\xE9\x75",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x56"],

        ["\x71\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x76"],
        ["\xE9\x76",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x57"],

        ["\x71\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x77"],
        ["\xE9\x77",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x58"],

        ["\x71\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x78"],
        ["\xE9\x78",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x59"],

        ["\x71\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x79"],
        ["\xE9\x79",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x5A"],

        ["\x71\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x7A"],
        ["\xE9\x7A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x5B"],

        ["\x71\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x7B"],
        ["\xE9\x7B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x5C"],

        ["\x71\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x7C"],
        ["\xE9\x7C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x5D"],

        ["\x71\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x7D"],
        ["\xE9\x7D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x5E"],

        ["\x71\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x7E"],
        ["\xE9\x7E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x5F"],

        ["\x71\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x80"],
        ["\xE9\x80",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x60"],

        ["\x71\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x81"],
        ["\xE9\x81",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x61"],

        ["\x71\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x82"],
        ["\xE9\x82",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x62"],

        ["\x71\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x83"],
        ["\xE9\x83",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x63"],

        ["\x71\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x84"],
        ["\xE9\x84",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x64"],

        ["\x71\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x85"],
        ["\xE9\x85",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x65"],

        ["\x71\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x86"],
        ["\xE9\x86",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x66"],

        ["\x71\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x87"],
        ["\xE9\x87",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x67"],

        ["\x71\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x88"],
        ["\xE9\x88",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x68"],

        ["\x71\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x89"],
        ["\xE9\x89",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x69"],

        ["\x71\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A"],
        ["\xE9\x8A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x6A"],

        ["\x71\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B"],
        ["\xE9\x8B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x6B"],

        ["\x71\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C"],
        ["\xE9\x8C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x6C"],

        ["\x71\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D"],
        ["\xE9\x8D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x6D"],

        ["\x71\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E"],
        ["\xE9\x8E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x6E"],

        ["\x71\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F"],
        ["\xE9\x8F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x6F"],

        ["\x71\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x90"],
        ["\xE9\x90",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x70"],

        ["\x71\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x91"],
        ["\xE9\x91",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x71"],

        ["\x71\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x92"],
        ["\xE9\x92",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x72"],

        ["\x71\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x93"],
        ["\xE9\x93",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x73"],

        ["\x71\x74",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x94"],
        ["\xE9\x94",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x74"],

        ["\x71\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x95"],
        ["\xE9\x95",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x75"],

        ["\x71\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x96"],
        ["\xE9\x96",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x76"],

        ["\x71\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x97"],
        ["\xE9\x97",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x77"],

        ["\x71\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x98"],
        ["\xE9\x98",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x78"],

        ["\x71\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x99"],
        ["\xE9\x99",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x79"],

        ["\x71\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A"],
        ["\xE9\x9A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x7A"],

        ["\x71\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B"],
        ["\xE9\x9B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x7B"],

        ["\x71\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C"],
        ["\xE9\x9C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x7C"],

        ["\x71\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D"],
        ["\xE9\x9D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x7D"],

        ["\x71\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E"],
        ["\xE9\x9E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x71\x7E"],

        ["\x72\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F"],
        ["\xE9\x9F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x21"],

        ["\x72\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0"],
        ["\xE9\xA0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x22"],

        ["\x72\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],
        ["\xE9\xA1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x23"],

        ["\x72\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2"],
        ["\xE9\xA2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x24"],

        ["\x72\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3"],
        ["\xE9\xA3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x25"],

        ["\x72\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4"],
        ["\xE9\xA4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x26"],

        ["\x72\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5"],
        ["\xE9\xA5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x27"],

        ["\x72\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6"],
        ["\xE9\xA6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x28"],

        ["\x72\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7"],
        ["\xE9\xA7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x29"],

        ["\x72\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8"],
        ["\xE9\xA8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x2A"],

        ["\x72\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9"],
        ["\xE9\xA9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x2B"],

        ["\x72\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA"],
        ["\xE9\xAA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x2C"],

        ["\x72\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],
        ["\xE9\xAB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x2D"],

        ["\x72\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC"],
        ["\xE9\xAC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x2E"],

        ["\x72\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD"],
        ["\xE9\xAD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x2F"],

        ["\x72\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE"],
        ["\xE9\xAE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x30"],

        ["\x72\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF"],
        ["\xE9\xAF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x31"],

        ["\x72\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],
        ["\xE9\xB0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x32"],

        ["\x72\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1"],
        ["\xE9\xB1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x33"],

        ["\x72\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB2"],
        ["\xE9\xB2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x34"],

        ["\x72\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3"],
        ["\xE9\xB3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x35"],

        ["\x72\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4"],
        ["\xE9\xB4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x36"],

        ["\x72\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5"],
        ["\xE9\xB5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x37"],

        ["\x72\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6"],
        ["\xE9\xB6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x38"],

        ["\x72\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7"],
        ["\xE9\xB7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x39"],

        ["\x72\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8"],
        ["\xE9\xB8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x3A"],

        ["\x72\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9"],
        ["\xE9\xB9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x3B"],

        ["\x72\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA"],
        ["\xE9\xBA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x3C"],

        ["\x72\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB"],
        ["\xE9\xBB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x3D"],

        ["\x72\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC"],
        ["\xE9\xBC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x3E"],

        ["\x72\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD"],
        ["\xE9\xBD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x3F"],

        ["\x72\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE"],
        ["\xE9\xBE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x40"],

        ["\x72\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xBF"],
        ["\xE9\xBF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x41"],

        ["\x72\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],
        ["\xE9\xC0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x42"],

        ["\x72\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],
        ["\xE9\xC1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x43"],

        ["\x72\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],
        ["\xE9\xC2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x44"],

        ["\x72\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],
        ["\xE9\xC3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x45"],

        ["\x72\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],
        ["\xE9\xC4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x46"],

        ["\x72\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],
        ["\xE9\xC5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x47"],

        ["\x72\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],
        ["\xE9\xC6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x48"],

        ["\x72\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],
        ["\xE9\xC7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x49"],

        ["\x72\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],
        ["\xE9\xC8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x4A"],

        ["\x72\x4B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],
        ["\xE9\xC9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x4B"],

        ["\x72\x4C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCA"],
        ["\xE9\xCA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x4C"],

        ["\x30\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCB"],
        ["\xE9\xCB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x30\x33"],

        ["\x72\x4E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCC"],
        ["\xE9\xCC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x4E"],

        ["\x72\x4F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCD"],
        ["\xE9\xCD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x4F"],

        ["\x72\x50",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCE"],
        ["\xE9\xCE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x50"],

        ["\x72\x51",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xCF"],
        ["\xE9\xCF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x51"],

        ["\x72\x52",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],
        ["\xE9\xD0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x52"],

        ["\x72\x53",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],
        ["\xE9\xD1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x53"],

        ["\x72\x54",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],
        ["\xE9\xD2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x54"],

        ["\x72\x55",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],
        ["\xE9\xD3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x55"],

        ["\x72\x56",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],
        ["\xE9\xD4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x56"],

        ["\x72\x57",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],
        ["\xE9\xD5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x57"],

        ["\x72\x58",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],
        ["\xE9\xD6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x58"],

        ["\x72\x59",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],
        ["\xE9\xD7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x59"],

        ["\x72\x5A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],
        ["\xE9\xD8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x5A"],

        ["\x72\x5B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],
        ["\xE9\xD9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x5B"],

        ["\x72\x5C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDA"],
        ["\xE9\xDA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x5C"],

        ["\x72\x5D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDB"],
        ["\xE9\xDB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x5D"],

        ["\x72\x5E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDC"],
        ["\xE9\xDC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x5E"],

        ["\x72\x5F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDD"],
        ["\xE9\xDD",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x5F"],

        ["\x72\x60",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDE"],
        ["\xE9\xDE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x60"],

        ["\x72\x61",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xDF"],
        ["\xE9\xDF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x61"],

        ["\x72\x62",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],
        ["\xE9\xE0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x62"],

        ["\x72\x63",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE1"],
        ["\xE9\xE1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x63"],

        ["\x72\x64",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],
        ["\xE9\xE2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x64"],

        ["\x72\x65",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],
        ["\xE9\xE3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x65"],

        ["\x72\x66",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],
        ["\xE9\xE4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x66"],

        ["\x72\x67",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],
        ["\xE9\xE5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x67"],

        ["\x72\x68",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],
        ["\xE9\xE6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x68"],

        ["\x72\x69",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],
        ["\xE9\xE7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x69"],

        ["\x72\x6A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],
        ["\xE9\xE8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x6A"],

        ["\x72\x6B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],
        ["\xE9\xE9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x6B"],

        ["\x72\x6C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEA"],
        ["\xE9\xEA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x6C"],

        ["\x72\x6D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEB"],
        ["\xE9\xEB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x6D"],

        ["\x72\x6E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEC"],
        ["\xE9\xEC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x6E"],

        ["\x72\x6F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xED"],
        ["\xE9\xED",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x6F"],

        ["\x72\x70",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEE"],
        ["\xE9\xEE",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x70"],

        ["\x72\x71",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xEF"],
        ["\xE9\xEF",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x71"],

        ["\x72\x72",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],
        ["\xE9\xF0",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x72"],

        ["\x72\x73",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],
        ["\xE9\xF1",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x73"],

        ["\x32\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],
        ["\xE9\xF2",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x32\x29"],

        ["\x72\x75",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],
        ["\xE9\xF3",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x75"],

        ["\x72\x76",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],
        ["\xE9\xF4",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x76"],

        ["\x72\x77",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],
        ["\xE9\xF5",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x77"],

        ["\x72\x78",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],
        ["\xE9\xF6",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x78"],

        ["\x72\x79",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],
        ["\xE9\xF7",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x79"],

        ["\x72\x7A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],
        ["\xE9\xF8",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x7A"],

        ["\x72\x7B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],
        ["\xE9\xF9",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x7B"],

        ["\x72\x7C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xFA"],
        ["\xE9\xFA",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x7C"],

        ["\x72\x7D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xFB"],
        ["\xE9\xFB",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x7D"],

        ["\x72\x7E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xE9\xFC"],
        ["\xE9\xFC",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x72\x7E"],

        ["\x73\x21",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x40"],
        ["\xEA\x40",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x21"],

        ["\x73\x22",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x41"],
        ["\xEA\x41",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x22"],

        ["\x73\x23",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x42"],
        ["\xEA\x42",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x23"],

        ["\x73\x24",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x43"],
        ["\xEA\x43",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x24"],

        ["\x73\x25",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x44"],
        ["\xEA\x44",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x25"],

        ["\x73\x26",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x45"],
        ["\xEA\x45",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x26"],

        ["\x73\x27",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x46"],
        ["\xEA\x46",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x27"],

        ["\x73\x28",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x47"],
        ["\xEA\x47",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x28"],

        ["\x73\x29",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x48"],
        ["\xEA\x48",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x29"],

        ["\x73\x2A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x49"],
        ["\xEA\x49",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x2A"],

        ["\x73\x2B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x4A"],
        ["\xEA\x4A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x2B"],

        ["\x73\x2C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x4B"],
        ["\xEA\x4B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x2C"],

        ["\x73\x2D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x4C"],
        ["\xEA\x4C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x2D"],

        ["\x73\x2E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x4D"],
        ["\xEA\x4D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x2E"],

        ["\x73\x2F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x4E"],
        ["\xEA\x4E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x2F"],

        ["\x73\x30",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x4F"],
        ["\xEA\x4F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x30"],

        ["\x73\x31",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x50"],
        ["\xEA\x50",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x31"],

        ["\x73\x32",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x51"],
        ["\xEA\x51",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x32"],

        ["\x73\x33",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x52"],
        ["\xEA\x52",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x33"],

        ["\x73\x34",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x53"],
        ["\xEA\x53",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x34"],

        ["\x73\x35",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x54"],
        ["\xEA\x54",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x35"],

        ["\x73\x36",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x55"],
        ["\xEA\x55",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x36"],

        ["\x73\x37",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x56"],
        ["\xEA\x56",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x37"],

        ["\x73\x38",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x57"],
        ["\xEA\x57",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x38"],

        ["\x73\x39",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x58"],
        ["\xEA\x58",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x39"],

        ["\x73\x3A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x59"],
        ["\xEA\x59",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x3A"],

        ["\x73\x3B",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x5A"],
        ["\xEA\x5A",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x3B"],

        ["\x73\x3C",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x5B"],
        ["\xEA\x5B",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x3C"],

        ["\x73\x3D",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x5C"],
        ["\xEA\x5C",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x3D"],

        ["\x73\x3E",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x5D"],
        ["\xEA\x5D",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x3E"],

        ["\x73\x3F",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x5E"],
        ["\xEA\x5E",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x3F"],

        ["\x73\x40",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x5F"],
        ["\xEA\x5F",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x40"],

        ["\x73\x41",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x60"],
        ["\xEA\x60",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x41"],

        ["\x73\x42",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x61"],
        ["\xEA\x61",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x42"],

        ["\x73\x43",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x62"],
        ["\xEA\x62",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x43"],

        ["\x73\x44",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x63"],
        ["\xEA\x63",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x44"],

        ["\x73\x45",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x64"],
        ["\xEA\x64",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x45"],

        ["\x73\x46",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x65"],
        ["\xEA\x65",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x46"],

        ["\x73\x47",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x66"],
        ["\xEA\x66",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x47"],

        ["\x73\x48",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x67"],
        ["\xEA\x67",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x48"],

        ["\x73\x49",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x68"],
        ["\xEA\x68",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x49"],

        ["\x73\x4A",'cp932x','jipsj',{'INPUT_LAYOUT'=>'D'},"\xEA\x69"],
        ["\xEA\x69",'jipsj','cp932x',{'INPUT_LAYOUT'=>'D'},"\x73\x4A"],

        ["\x73\x4B",