######################################################################
#
# 5075_utf8_by_jef_RT_DBCS.t
#
# Copyright (c) 2018, 2019 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\xA1\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x80"],
        ["\xE3\x80\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xA1"],

        ["\xA1\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x81"],
        ["\xE3\x80\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xA2"],

        ["\xA1\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x82"],
        ["\xE3\x80\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xA3"],

        ["\xA1\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8C"],
        ["\xEF\xBC\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xA4"],

        ["\xA1\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8E"],
        ["\xEF\xBC\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xA5"],

        ["\xA1\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBB"],
        ["\xE3\x83\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xA6"],

        ["\xA1\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9A"],
        ["\xEF\xBC\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xA7"],

        ["\xA1\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9B"],
        ["\xEF\xBC\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xA8"],

        ["\xA1\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9F"],
        ["\xEF\xBC\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xA9"],

        ["\xA1\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x81"],
        ["\xEF\xBC\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xAA"],

        ["\xA1\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9B"],
        ["\xE3\x82\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xAB"],

        ["\xA1\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9C"],
        ["\xE3\x82\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xAC"],

        ["\xA1\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],
        ["\xC2\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xAD"],

        ["\xA1\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x80"],
        ["\xEF\xBD\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xAE"],

        ["\xA1\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],
        ["\xC2\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xAF"],

        ["\xA1\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBE"],
        ["\xEF\xBC\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB0"],

        ["\xA1\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA3"],
        ["\xEF\xBF\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB1"],

        ["\xA1\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBF"],
        ["\xEF\xBC\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB2"],

        ["\xA1\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBD"],
        ["\xE3\x83\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB3"],

        ["\xA1\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBE"],
        ["\xE3\x83\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB4"],

        ["\xA1\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9D"],
        ["\xE3\x82\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB5"],

        ["\xA1\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x9E"],
        ["\xE3\x82\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB6"],

        ["\xA1\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x83"],
        ["\xE3\x80\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB7"],

        ["\xA1\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9D"],
        ["\xE4\xBB\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB8"],

        ["\xA1\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x85"],
        ["\xE3\x80\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xB9"],

        ["\xA1\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x86"],
        ["\xE3\x80\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xBA"],

        ["\xA1\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x87"],
        ["\xE3\x80\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xBB"],

        ["\xA1\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xBC"],
        ["\xE3\x83\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xBC"],

        ["\xA1\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x95"],
        ["\xE2\x80\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xBD"],

        ["\xA1\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x90"],
        ["\xE2\x80\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xBE"],

        ["\xA1\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8F"],
        ["\xEF\xBC\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xBF"],

        ["\xA1\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBC"],
        ["\xEF\xBC\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC0"],

        ["\xA1\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9C"],
        ["\xE3\x80\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC1"],

        ["\xA1\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA5"],
        ["\xE2\x88\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC2"],

        ["\xA1\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9C"],
        ["\xEF\xBD\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC3"],

        ["\xA1\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA6"],
        ["\xE2\x80\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC4"],

        ["\xA1\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA5"],
        ["\xE2\x80\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC5"],

        ["\xA1\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x98"],
        ["\xE2\x80\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC6"],

        ["\xA1\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x99"],
        ["\xE2\x80\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC7"],

        ["\xA1\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x9C"],
        ["\xE2\x80\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC8"],

        ["\xA1\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\x9D"],
        ["\xE2\x80\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xC9"],

        ["\xA1\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x88"],
        ["\xEF\xBC\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xCA"],

        ["\xA1\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x89"],
        ["\xEF\xBC\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xCB"],

        ["\xA1\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x94"],
        ["\xE3\x80\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xCC"],

        ["\xA1\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x95"],
        ["\xE3\x80\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xCD"],

        ["\xA1\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBB"],
        ["\xEF\xBC\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xCE"],

        ["\xA1\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBD"],
        ["\xEF\xBC\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xCF"],

        ["\xA1\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9B"],
        ["\xEF\xBD\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD0"],

        ["\xA1\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9D"],
        ["\xEF\xBD\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD1"],

        ["\xA1\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x88"],
        ["\xE3\x80\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD2"],

        ["\xA1\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x89"],
        ["\xE3\x80\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD3"],

        ["\xA1\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8A"],
        ["\xE3\x80\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD4"],

        ["\xA1\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8B"],
        ["\xE3\x80\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD5"],

        ["\xA1\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8C"],
        ["\xE3\x80\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD6"],

        ["\xA1\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8D"],
        ["\xE3\x80\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD7"],

        ["\xA1\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8E"],
        ["\xE3\x80\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD8"],

        ["\xA1\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x8F"],
        ["\xE3\x80\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xD9"],

        ["\xA1\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x90"],
        ["\xE3\x80\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xDA"],

        ["\xA1\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x91"],
        ["\xE3\x80\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xDB"],

        ["\xA1\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8B"],
        ["\xEF\xBC\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xDC"],

        ["\xA1\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8D"],
        ["\xEF\xBC\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xDD"],

        ["\xA1\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],
        ["\xC2\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xDE"],

        ["\xA1\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\x97"],
        ["\xC3\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xDF"],

        ["\xA1\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],
        ["\xC3\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE0"],

        ["\xA1\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9D"],
        ["\xEF\xBC\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE1"],

        ["\xA1\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA0"],
        ["\xE2\x89\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE2"],

        ["\xA1\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9C"],
        ["\xEF\xBC\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE3"],

        ["\xA1\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x9E"],
        ["\xEF\xBC\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE4"],

        ["\xA1\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA6"],
        ["\xE2\x89\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE5"],

        ["\xA1\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA7"],
        ["\xE2\x89\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE6"],

        ["\xA1\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9E"],
        ["\xE2\x88\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE7"],

        ["\xA1\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xB4"],
        ["\xE2\x88\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE8"],

        ["\xA1\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\x82"],
        ["\xE2\x99\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xE9"],

        ["\xA1\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\x80"],
        ["\xE2\x99\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xEA"],

        ["\xA1\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],
        ["\xC2\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xEB"],

        ["\xA1\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB2"],
        ["\xE2\x80\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xEC"],

        ["\xA1\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB3"],
        ["\xE2\x80\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xED"],

        ["\xA1\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\x83"],
        ["\xE2\x84\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xEE"],

        ["\xA1\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA5"],
        ["\xEF\xBF\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xEF"],

        ["\xA1\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x84"],
        ["\xEF\xBC\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF0"],

        ["\xA1\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA0"],
        ["\xEF\xBF\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF1"],

        ["\xA1\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA1"],
        ["\xEF\xBF\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF2"],

        ["\xA1\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x85"],
        ["\xEF\xBC\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF3"],

        ["\xA1\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x83"],
        ["\xEF\xBC\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF4"],

        ["\xA1\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x86"],
        ["\xEF\xBC\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF5"],

        ["\xA1\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x8A"],
        ["\xEF\xBC\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF6"],

        ["\xA1\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA0"],
        ["\xEF\xBC\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF7"],

        ["\xA1\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],
        ["\xC2\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF8"],

        ["\xA1\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x86"],
        ["\xE2\x98\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xF9"],

        ["\xA1\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x98\x85"],
        ["\xE2\x98\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xFA"],

        ["\xA1\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8B"],
        ["\xE2\x97\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xFB"],

        ["\xA1\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8F"],
        ["\xE2\x97\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xFC"],

        ["\xA1\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x8E"],
        ["\xE2\x97\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xFD"],

        ["\xA1\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x87"],
        ["\xE2\x97\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA1\xFE"],

        ["\xA2\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\x86"],
        ["\xE2\x97\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xA1"],

        ["\xA2\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xA1"],
        ["\xE2\x96\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xA2"],

        ["\xA2\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xA0"],
        ["\xE2\x96\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xA3"],

        ["\xA2\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB3"],
        ["\xE2\x96\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xA4"],

        ["\xA2\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xB2"],
        ["\xE2\x96\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xA5"],

        ["\xA2\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xBD"],
        ["\xE2\x96\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xA6"],

        ["\xA2\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x96\xBC"],
        ["\xE2\x96\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xA7"],

        ["\xA2\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xBB"],
        ["\xE2\x80\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xA8"],

        ["\xA2\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x92"],
        ["\xE3\x80\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xA9"],

        ["\xA2\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x92"],
        ["\xE2\x86\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAA"],

        ["\xA2\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x90"],
        ["\xE2\x86\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAB"],

        ["\xA2\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x91"],
        ["\xE2\x86\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAC"],

        ["\xA2\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x86\x93"],
        ["\xE2\x86\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAD"],

        ["\xA2\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x93"],
        ["\xE3\x80\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA2\xAE"],

        ["\x7F\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x88"],
        ["\xE2\x88\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xD0"],

        ["\x7F\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x8B"],
        ["\xE2\x88\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xD1"],

        ["\x7F\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x86"],
        ["\xE2\x8A\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xD2"],

        ["\x7F\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x87"],
        ["\xE2\x8A\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xD3"],

        ["\x7F\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x82"],
        ["\xE2\x8A\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xD4"],

        ["\x7F\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\x83"],
        ["\xE2\x8A\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xD5"],

        ["\x7F\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAA"],
        ["\xE2\x88\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xD6"],

        ["\x7F\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA9"],
        ["\xE2\x88\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xD7"],

        ["\x7F\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA7"],
        ["\xE2\x88\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xD8"],

        ["\x7F\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA8"],
        ["\xE2\x88\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xD9"],

        ["\x76\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF\xA2"],
        ["\xEF\xBF\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xA7"],

        ["\x7F\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\x92"],
        ["\xE2\x87\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xDA"],

        ["\x7F\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x87\x94"],
        ["\xE2\x87\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xDB"],

        ["\x7F\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x80"],
        ["\xE2\x88\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xDC"],

        ["\x7F\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x83"],
        ["\xE2\x88\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xDD"],

        ["\x7F\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xA0"],
        ["\xE2\x88\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xDE"],

        ["\x7F\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\xA5"],
        ["\xE2\x8A\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xDF"],

        ["\x7F\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x8C\x92"],
        ["\xE2\x8C\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xE0"],

        ["\x7F\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x82"],
        ["\xE2\x88\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xE1"],

        ["\x7F\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x87"],
        ["\xE2\x88\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xE2"],

        ["\x76\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xA1"],
        ["\xE2\x89\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xAA"],

        ["\x76\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\x92"],
        ["\xE2\x89\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xA9"],

        ["\x7F\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xAA"],
        ["\xE2\x89\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xE3"],

        ["\x7F\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x89\xAB"],
        ["\xE2\x89\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xE4"],

        ["\x7F\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9A"],
        ["\xE2\x88\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xE5"],

        ["\x7F\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xBD"],
        ["\xE2\x88\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xE6"],

        ["\x7F\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9D"],
        ["\xE2\x88\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xE7"],

        ["\x76\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xB5"],
        ["\xE2\x88\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xA8"],

        ["\x7F\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAB"],
        ["\xE2\x88\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xE8"],

        ["\x7F\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAC"],
        ["\xE2\x88\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xE9"],

        ["\x76\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\xAB"],
        ["\xE2\x84\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xD1"],

        ["\x76\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xB0"],
        ["\xE2\x80\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xD3"],

        ["\x7F\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAF"],
        ["\xE2\x99\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xEA"],

        ["\x7F\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAD"],
        ["\xE2\x99\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xEB"],

        ["\x7F\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x99\xAA"],
        ["\xE2\x99\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xEC"],

        ["\x7F\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA0"],
        ["\xE2\x80\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xED"],

        ["\x7F\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x80\xA1"],
        ["\xE2\x80\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xEE"],

        ["\x7F\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],
        ["\xC2\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xEF"],

        ["\x7F\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x97\xAF"],
        ["\xE2\x97\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xF0"],

        ["\xA3\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x90"],
        ["\xEF\xBC\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB0"],

        ["\xA3\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x91"],
        ["\xEF\xBC\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB1"],

        ["\xA3\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x92"],
        ["\xEF\xBC\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB2"],

        ["\xA3\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x93"],
        ["\xEF\xBC\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB3"],

        ["\xA3\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x94"],
        ["\xEF\xBC\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB4"],

        ["\xA3\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x95"],
        ["\xEF\xBC\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB5"],

        ["\xA3\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x96"],
        ["\xEF\xBC\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB6"],

        ["\xA3\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x97"],
        ["\xEF\xBC\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB7"],

        ["\xA3\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x98"],
        ["\xEF\xBC\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB8"],

        ["\xA3\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\x99"],
        ["\xEF\xBC\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xB9"],

        ["\xA3\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA1"],
        ["\xEF\xBC\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xC1"],

        ["\xA3\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA2"],
        ["\xEF\xBC\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xC2"],

        ["\xA3\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA3"],
        ["\xEF\xBC\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xC3"],

        ["\xA3\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA4"],
        ["\xEF\xBC\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xC4"],

        ["\xA3\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA5"],
        ["\xEF\xBC\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xC5"],

        ["\xA3\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA6"],
        ["\xEF\xBC\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xC6"],

        ["\xA3\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA7"],
        ["\xEF\xBC\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xC7"],

        ["\xA3\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA8"],
        ["\xEF\xBC\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xC8"],

        ["\xA3\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xA9"],
        ["\xEF\xBC\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xC9"],

        ["\xA3\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAA"],
        ["\xEF\xBC\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xCA"],

        ["\xA3\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAB"],
        ["\xEF\xBC\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xCB"],

        ["\xA3\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAC"],
        ["\xEF\xBC\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xCC"],

        ["\xA3\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAD"],
        ["\xEF\xBC\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xCD"],

        ["\xA3\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAE"],
        ["\xEF\xBC\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xCE"],

        ["\xA3\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xAF"],
        ["\xEF\xBC\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xCF"],

        ["\xA3\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB0"],
        ["\xEF\xBC\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD0"],

        ["\xA3\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB1"],
        ["\xEF\xBC\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD1"],

        ["\xA3\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB2"],
        ["\xEF\xBC\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD2"],

        ["\xA3\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB3"],
        ["\xEF\xBC\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD3"],

        ["\xA3\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB4"],
        ["\xEF\xBC\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD4"],

        ["\xA3\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB5"],
        ["\xEF\xBC\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD5"],

        ["\xA3\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB6"],
        ["\xEF\xBC\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD6"],

        ["\xA3\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB7"],
        ["\xEF\xBC\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD7"],

        ["\xA3\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB8"],
        ["\xEF\xBC\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD8"],

        ["\xA3\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xB9"],
        ["\xEF\xBC\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xD9"],

        ["\xA3\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC\xBA"],
        ["\xEF\xBC\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xDA"],

        ["\xA3\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x81"],
        ["\xEF\xBD\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xE1"],

        ["\xA3\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x82"],
        ["\xEF\xBD\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xE2"],

        ["\xA3\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x83"],
        ["\xEF\xBD\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xE3"],

        ["\xA3\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x84"],
        ["\xEF\xBD\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xE4"],

        ["\xA3\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x85"],
        ["\xEF\xBD\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xE5"],

        ["\xA3\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x86"],
        ["\xEF\xBD\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xE6"],

        ["\xA3\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x87"],
        ["\xEF\xBD\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xE7"],

        ["\xA3\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x88"],
        ["\xEF\xBD\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xE8"],

        ["\xA3\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x89"],
        ["\xEF\xBD\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xE9"],

        ["\xA3\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8A"],
        ["\xEF\xBD\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xEA"],

        ["\xA3\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8B"],
        ["\xEF\xBD\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xEB"],

        ["\xA3\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8C"],
        ["\xEF\xBD\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xEC"],

        ["\xA3\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8D"],
        ["\xEF\xBD\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xED"],

        ["\xA3\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8E"],
        ["\xEF\xBD\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xEE"],

        ["\xA3\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x8F"],
        ["\xEF\xBD\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xEF"],

        ["\xA3\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x90"],
        ["\xEF\xBD\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF0"],

        ["\xA3\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x91"],
        ["\xEF\xBD\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF1"],

        ["\xA3\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x92"],
        ["\xEF\xBD\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF2"],

        ["\xA3\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x93"],
        ["\xEF\xBD\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF3"],

        ["\xA3\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x94"],
        ["\xEF\xBD\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF4"],

        ["\xA3\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x95"],
        ["\xEF\xBD\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF5"],

        ["\xA3\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x96"],
        ["\xEF\xBD\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF6"],

        ["\xA3\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x97"],
        ["\xEF\xBD\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF7"],

        ["\xA3\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x98"],
        ["\xEF\xBD\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF8"],

        ["\xA3\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x99"],
        ["\xEF\xBD\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xF9"],

        ["\xA3\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD\x9A"],
        ["\xEF\xBD\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA3\xFA"],

        ["\xA4\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x81"],
        ["\xE3\x81\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xA1"],

        ["\xA4\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x82"],
        ["\xE3\x81\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xA2"],

        ["\xA4\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x83"],
        ["\xE3\x81\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xA3"],

        ["\xA4\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x84"],
        ["\xE3\x81\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xA4"],

        ["\xA4\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x85"],
        ["\xE3\x81\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xA5"],

        ["\xA4\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x86"],
        ["\xE3\x81\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xA6"],

        ["\xA4\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x87"],
        ["\xE3\x81\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xA7"],

        ["\xA4\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x88"],
        ["\xE3\x81\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xA8"],

        ["\xA4\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x89"],
        ["\xE3\x81\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xA9"],

        ["\xA4\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8A"],
        ["\xE3\x81\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xAA"],

        ["\xA4\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8B"],
        ["\xE3\x81\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xAB"],

        ["\xA4\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8C"],
        ["\xE3\x81\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xAC"],

        ["\xA4\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8D"],
        ["\xE3\x81\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xAD"],

        ["\xA4\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8E"],
        ["\xE3\x81\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xAE"],

        ["\xA4\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x8F"],
        ["\xE3\x81\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xAF"],

        ["\xA4\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x90"],
        ["\xE3\x81\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB0"],

        ["\xA4\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x91"],
        ["\xE3\x81\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB1"],

        ["\xA4\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x92"],
        ["\xE3\x81\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB2"],

        ["\xA4\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x93"],
        ["\xE3\x81\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB3"],

        ["\xA4\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x94"],
        ["\xE3\x81\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB4"],

        ["\xA4\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x95"],
        ["\xE3\x81\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB5"],

        ["\xA4\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x96"],
        ["\xE3\x81\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB6"],

        ["\xA4\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x97"],
        ["\xE3\x81\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB7"],

        ["\xA4\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x98"],
        ["\xE3\x81\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB8"],

        ["\xA4\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x99"],
        ["\xE3\x81\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xB9"],

        ["\xA4\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9A"],
        ["\xE3\x81\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xBA"],

        ["\xA4\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9B"],
        ["\xE3\x81\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xBB"],

        ["\xA4\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9C"],
        ["\xE3\x81\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xBC"],

        ["\xA4\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9D"],
        ["\xE3\x81\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xBD"],

        ["\xA4\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9E"],
        ["\xE3\x81\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xBE"],

        ["\xA4\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\x9F"],
        ["\xE3\x81\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xBF"],

        ["\xA4\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA0"],
        ["\xE3\x81\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC0"],

        ["\xA4\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA1"],
        ["\xE3\x81\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC1"],

        ["\xA4\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA2"],
        ["\xE3\x81\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC2"],

        ["\xA4\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA3"],
        ["\xE3\x81\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC3"],

        ["\xA4\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA4"],
        ["\xE3\x81\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC4"],

        ["\xA4\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA5"],
        ["\xE3\x81\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC5"],

        ["\xA4\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA6"],
        ["\xE3\x81\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC6"],

        ["\xA4\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA7"],
        ["\xE3\x81\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC7"],

        ["\xA4\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA8"],
        ["\xE3\x81\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC8"],

        ["\xA4\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xA9"],
        ["\xE3\x81\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xC9"],

        ["\xA4\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAA"],
        ["\xE3\x81\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xCA"],

        ["\xA4\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAB"],
        ["\xE3\x81\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xCB"],

        ["\xA4\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAC"],
        ["\xE3\x81\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xCC"],

        ["\xA4\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAD"],
        ["\xE3\x81\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xCD"],

        ["\xA4\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAE"],
        ["\xE3\x81\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xCE"],

        ["\xA4\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xAF"],
        ["\xE3\x81\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xCF"],

        ["\xA4\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB0"],
        ["\xE3\x81\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD0"],

        ["\xA4\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB1"],
        ["\xE3\x81\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD1"],

        ["\xA4\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB2"],
        ["\xE3\x81\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD2"],

        ["\xA4\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB3"],
        ["\xE3\x81\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD3"],

        ["\xA4\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB4"],
        ["\xE3\x81\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD4"],

        ["\xA4\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB5"],
        ["\xE3\x81\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD5"],

        ["\xA4\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB6"],
        ["\xE3\x81\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD6"],

        ["\xA4\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB7"],
        ["\xE3\x81\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD7"],

        ["\xA4\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB8"],
        ["\xE3\x81\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD8"],

        ["\xA4\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xB9"],
        ["\xE3\x81\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xD9"],

        ["\xA4\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBA"],
        ["\xE3\x81\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xDA"],

        ["\xA4\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBB"],
        ["\xE3\x81\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xDB"],

        ["\xA4\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBC"],
        ["\xE3\x81\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xDC"],

        ["\xA4\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBD"],
        ["\xE3\x81\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xDD"],

        ["\xA4\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBE"],
        ["\xE3\x81\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xDE"],

        ["\xA4\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x81\xBF"],
        ["\xE3\x81\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xDF"],

        ["\xA4\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x80"],
        ["\xE3\x82\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE0"],

        ["\xA4\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x81"],
        ["\xE3\x82\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE1"],

        ["\xA4\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x82"],
        ["\xE3\x82\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE2"],

        ["\xA4\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x83"],
        ["\xE3\x82\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE3"],

        ["\xA4\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x84"],
        ["\xE3\x82\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE4"],

        ["\xA4\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x85"],
        ["\xE3\x82\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE5"],

        ["\xA4\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x86"],
        ["\xE3\x82\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE6"],

        ["\xA4\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x87"],
        ["\xE3\x82\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE7"],

        ["\xA4\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x88"],
        ["\xE3\x82\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE8"],

        ["\xA4\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x89"],
        ["\xE3\x82\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xE9"],

        ["\xA4\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8A"],
        ["\xE3\x82\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xEA"],

        ["\xA4\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8B"],
        ["\xE3\x82\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xEB"],

        ["\xA4\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8C"],
        ["\xE3\x82\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xEC"],

        ["\xA4\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8D"],
        ["\xE3\x82\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xED"],

        ["\xA4\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8E"],
        ["\xE3\x82\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xEE"],

        ["\xA4\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x8F"],
        ["\xE3\x82\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xEF"],

        ["\xA4\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x90"],
        ["\xE3\x82\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xF0"],

        ["\xA4\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x91"],
        ["\xE3\x82\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xF1"],

        ["\xA4\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x92"],
        ["\xE3\x82\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xF2"],

        ["\xA4\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\x93"],
        ["\xE3\x82\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA4\xF3"],

        ["\xA5\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA1"],
        ["\xE3\x82\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xA1"],

        ["\xA5\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA2"],
        ["\xE3\x82\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xA2"],

        ["\xA5\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA3"],
        ["\xE3\x82\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xA3"],

        ["\xA5\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA4"],
        ["\xE3\x82\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xA4"],

        ["\xA5\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA5"],
        ["\xE3\x82\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xA5"],

        ["\xA5\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA6"],
        ["\xE3\x82\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xA6"],

        ["\xA5\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA7"],
        ["\xE3\x82\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xA7"],

        ["\xA5\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA8"],
        ["\xE3\x82\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xA8"],

        ["\xA5\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xA9"],
        ["\xE3\x82\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xA9"],

        ["\xA5\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAA"],
        ["\xE3\x82\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xAA"],

        ["\xA5\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAB"],
        ["\xE3\x82\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xAB"],

        ["\xA5\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAC"],
        ["\xE3\x82\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xAC"],

        ["\xA5\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAD"],
        ["\xE3\x82\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xAD"],

        ["\xA5\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAE"],
        ["\xE3\x82\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xAE"],

        ["\xA5\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xAF"],
        ["\xE3\x82\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xAF"],

        ["\xA5\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB0"],
        ["\xE3\x82\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB0"],

        ["\xA5\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB1"],
        ["\xE3\x82\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB1"],

        ["\xA5\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB2"],
        ["\xE3\x82\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB2"],

        ["\xA5\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB3"],
        ["\xE3\x82\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB3"],

        ["\xA5\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB4"],
        ["\xE3\x82\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB4"],

        ["\xA5\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB5"],
        ["\xE3\x82\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB5"],

        ["\xA5\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB6"],
        ["\xE3\x82\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB6"],

        ["\xA5\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB7"],
        ["\xE3\x82\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB7"],

        ["\xA5\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB8"],
        ["\xE3\x82\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB8"],

        ["\xA5\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xB9"],
        ["\xE3\x82\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xB9"],

        ["\xA5\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBA"],
        ["\xE3\x82\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xBA"],

        ["\xA5\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBB"],
        ["\xE3\x82\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xBB"],

        ["\xA5\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBC"],
        ["\xE3\x82\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xBC"],

        ["\xA5\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBD"],
        ["\xE3\x82\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xBD"],

        ["\xA5\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBE"],
        ["\xE3\x82\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xBE"],

        ["\xA5\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x82\xBF"],
        ["\xE3\x82\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xBF"],

        ["\xA5\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x80"],
        ["\xE3\x83\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC0"],

        ["\xA5\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x81"],
        ["\xE3\x83\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC1"],

        ["\xA5\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x82"],
        ["\xE3\x83\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC2"],

        ["\xA5\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x83"],
        ["\xE3\x83\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC3"],

        ["\xA5\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x84"],
        ["\xE3\x83\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC4"],

        ["\xA5\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x85"],
        ["\xE3\x83\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC5"],

        ["\xA5\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x86"],
        ["\xE3\x83\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC6"],

        ["\xA5\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x87"],
        ["\xE3\x83\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC7"],

        ["\xA5\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x88"],
        ["\xE3\x83\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC8"],

        ["\xA5\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x89"],
        ["\xE3\x83\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xC9"],

        ["\xA5\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8A"],
        ["\xE3\x83\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xCA"],

        ["\xA5\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8B"],
        ["\xE3\x83\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xCB"],

        ["\xA5\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8C"],
        ["\xE3\x83\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xCC"],

        ["\xA5\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8D"],
        ["\xE3\x83\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xCD"],

        ["\xA5\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8E"],
        ["\xE3\x83\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xCE"],

        ["\xA5\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x8F"],
        ["\xE3\x83\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xCF"],

        ["\xA5\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x90"],
        ["\xE3\x83\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD0"],

        ["\xA5\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x91"],
        ["\xE3\x83\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD1"],

        ["\xA5\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x92"],
        ["\xE3\x83\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD2"],

        ["\xA5\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x93"],
        ["\xE3\x83\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD3"],

        ["\xA5\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x94"],
        ["\xE3\x83\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD4"],

        ["\xA5\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x95"],
        ["\xE3\x83\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD5"],

        ["\xA5\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x96"],
        ["\xE3\x83\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD6"],

        ["\xA5\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x97"],
        ["\xE3\x83\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD7"],

        ["\xA5\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x98"],
        ["\xE3\x83\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD8"],

        ["\xA5\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x99"],
        ["\xE3\x83\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xD9"],

        ["\xA5\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9A"],
        ["\xE3\x83\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xDA"],

        ["\xA5\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9B"],
        ["\xE3\x83\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xDB"],

        ["\xA5\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9C"],
        ["\xE3\x83\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xDC"],

        ["\xA5\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9D"],
        ["\xE3\x83\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xDD"],

        ["\xA5\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9E"],
        ["\xE3\x83\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xDE"],

        ["\xA5\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\x9F"],
        ["\xE3\x83\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xDF"],

        ["\xA5\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA0"],
        ["\xE3\x83\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE0"],

        ["\xA5\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA1"],
        ["\xE3\x83\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE1"],

        ["\xA5\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA2"],
        ["\xE3\x83\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE2"],

        ["\xA5\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA3"],
        ["\xE3\x83\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE3"],

        ["\xA5\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA4"],
        ["\xE3\x83\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE4"],

        ["\xA5\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA5"],
        ["\xE3\x83\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE5"],

        ["\xA5\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA6"],
        ["\xE3\x83\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE6"],

        ["\xA5\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA7"],
        ["\xE3\x83\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE7"],

        ["\xA5\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA8"],
        ["\xE3\x83\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE8"],

        ["\xA5\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xA9"],
        ["\xE3\x83\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xE9"],

        ["\xA5\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAA"],
        ["\xE3\x83\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xEA"],

        ["\xA5\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAB"],
        ["\xE3\x83\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xEB"],

        ["\xA5\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAC"],
        ["\xE3\x83\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xEC"],

        ["\xA5\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAD"],
        ["\xE3\x83\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xED"],

        ["\xA5\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAE"],
        ["\xE3\x83\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xEE"],

        ["\xA5\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xAF"],
        ["\xE3\x83\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xEF"],

        ["\xA5\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB0"],
        ["\xE3\x83\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xF0"],

        ["\xA5\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB1"],
        ["\xE3\x83\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xF1"],

        ["\xA5\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB2"],
        ["\xE3\x83\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xF2"],

        ["\xA5\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB3"],
        ["\xE3\x83\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xF3"],

        ["\xA5\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB4"],
        ["\xE3\x83\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xF4"],

        ["\xA5\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB5"],
        ["\xE3\x83\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xF5"],

        ["\xA5\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x83\xB6"],
        ["\xE3\x83\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA5\xF6"],

        ["\xA6\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\x91"],
        ["\xCE\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xA1"],

        ["\xA6\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\x92"],
        ["\xCE\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xA2"],

        ["\xA6\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\x93"],
        ["\xCE\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xA3"],

        ["\xA6\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\x94"],
        ["\xCE\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xA4"],

        ["\xA6\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\x95"],
        ["\xCE\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xA5"],

        ["\xA6\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\x96"],
        ["\xCE\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xA6"],

        ["\xA6\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\x97"],
        ["\xCE\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xA7"],

        ["\xA6\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\x98"],
        ["\xCE\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xA8"],

        ["\xA6\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\x99"],
        ["\xCE\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xA9"],

        ["\xA6\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\x9A"],
        ["\xCE\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xAA"],

        ["\xA6\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\x9B"],
        ["\xCE\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xAB"],

        ["\xA6\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\x9C"],
        ["\xCE\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xAC"],

        ["\xA6\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\x9D"],
        ["\xCE\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xAD"],

        ["\xA6\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\x9E"],
        ["\xCE\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xAE"],

        ["\xA6\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\x9F"],
        ["\xCE\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xAF"],

        ["\xA6\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA0"],
        ["\xCE\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xB0"],

        ["\xA6\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],
        ["\xCE\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xB1"],

        ["\xA6\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],
        ["\xCE\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xB2"],

        ["\xA6\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],
        ["\xCE\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xB3"],

        ["\xA6\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA5"],
        ["\xCE\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xB4"],

        ["\xA6\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],
        ["\xCE\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xB5"],

        ["\xA6\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],
        ["\xCE\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xB6"],

        ["\xA6\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA8"],
        ["\xCE\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xB7"],

        ["\xA6\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],
        ["\xCE\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xB8"],

        ["\xA6\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB1"],
        ["\xCE\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xC1"],

        ["\xA6\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB2"],
        ["\xCE\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xC2"],

        ["\xA6\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB3"],
        ["\xCE\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xC3"],

        ["\xA6\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB4"],
        ["\xCE\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xC4"],

        ["\xA6\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB5"],
        ["\xCE\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xC5"],

        ["\xA6\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB6"],
        ["\xCE\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xC6"],

        ["\xA6\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB7"],
        ["\xCE\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xC7"],

        ["\xA6\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],
        ["\xCE\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xC8"],

        ["\xA6\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],
        ["\xCE\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xC9"],

        ["\xA6\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xBA"],
        ["\xCE\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xCA"],

        ["\xA6\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],
        ["\xCE\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xCB"],

        ["\xA6\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],
        ["\xCE\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xCC"],

        ["\xA6\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xBD"],
        ["\xCE\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xCD"],

        ["\xA6\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xBE"],
        ["\xCE\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xCE"],

        ["\xA6\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],
        ["\xCE\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xCF"],

        ["\xA6\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\x80"],
        ["\xCF\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xD0"],

        ["\xA6\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\x81"],
        ["\xCF\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xD1"],

        ["\xA6\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\x83"],
        ["\xCF\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xD2"],

        ["\xA6\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\x84"],
        ["\xCF\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xD3"],

        ["\xA6\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\x85"],
        ["\xCF\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xD4"],

        ["\xA6\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\x86"],
        ["\xCF\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xD5"],

        ["\xA6\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\x87"],
        ["\xCF\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xD6"],

        ["\xA6\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\x88"],
        ["\xCF\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xD7"],

        ["\xA6\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xCF\x89"],
        ["\xCF\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA6\xD8"],

        ["\xA7\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\x90"],
        ["\xD0\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xA1"],

        ["\xA7\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\x91"],
        ["\xD0\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xA2"],

        ["\xA7\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\x92"],
        ["\xD0\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xA3"],

        ["\xA7\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\x93"],
        ["\xD0\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xA4"],

        ["\xA7\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\x94"],
        ["\xD0\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xA5"],

        ["\xA7\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\x95"],
        ["\xD0\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xA6"],

        ["\xA7\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\x81"],
        ["\xD0\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xA7"],

        ["\xA7\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\x96"],
        ["\xD0\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xA8"],

        ["\xA7\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\x97"],
        ["\xD0\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xA9"],

        ["\xA7\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\x98"],
        ["\xD0\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xAA"],

        ["\xA7\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\x99"],
        ["\xD0\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xAB"],

        ["\xA7\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\x9A"],
        ["\xD0\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xAC"],

        ["\xA7\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\x9B"],
        ["\xD0\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xAD"],

        ["\xA7\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\x9C"],
        ["\xD0\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xAE"],

        ["\xA7\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\x9D"],
        ["\xD0\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xAF"],

        ["\xA7\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\x9E"],
        ["\xD0\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB0"],

        ["\xA7\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\x9F"],
        ["\xD0\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB1"],

        ["\xA7\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA0"],
        ["\xD0\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB2"],

        ["\xA7\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],
        ["\xD0\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB3"],

        ["\xA7\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],
        ["\xD0\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB4"],

        ["\xA7\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA3"],
        ["\xD0\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB5"],

        ["\xA7\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA4"],
        ["\xD0\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB6"],

        ["\xA7\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA5"],
        ["\xD0\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB7"],

        ["\xA7\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA6"],
        ["\xD0\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB8"],

        ["\xA7\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA7"],
        ["\xD0\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xB9"],

        ["\xA7\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA8"],
        ["\xD0\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xBA"],

        ["\xA7\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xA9"],
        ["\xD0\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xBB"],

        ["\xA7\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xAA"],
        ["\xD0\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xBC"],

        ["\xA7\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xAB"],
        ["\xD0\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xBD"],

        ["\xA7\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xAC"],
        ["\xD0\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xBE"],

        ["\xA7\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xAD"],
        ["\xD0\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xBF"],

        ["\xA7\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xAE"],
        ["\xD0\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xC0"],

        ["\xA7\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xAF"],
        ["\xD0\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xC1"],

        ["\xA7\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB0"],
        ["\xD0\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xD1"],

        ["\xA7\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB1"],
        ["\xD0\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xD2"],

        ["\xA7\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],
        ["\xD0\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xD3"],

        ["\xA7\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB3"],
        ["\xD0\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xD4"],

        ["\xA7\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],
        ["\xD0\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xD5"],

        ["\xA7\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB5"],
        ["\xD0\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xD6"],

        ["\xA7\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\x91"],
        ["\xD1\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xD7"],

        ["\xA7\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB6"],
        ["\xD0\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xD8"],

        ["\xA7\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB7"],
        ["\xD0\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xD9"],

        ["\xA7\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],
        ["\xD0\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xDA"],

        ["\xA7\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],
        ["\xD0\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xDB"],

        ["\xA7\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xBA"],
        ["\xD0\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xDC"],

        ["\xA7\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xBB"],
        ["\xD0\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xDD"],

        ["\xA7\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xBC"],
        ["\xD0\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xDE"],

        ["\xA7\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xBD"],
        ["\xD0\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xDF"],

        ["\xA7\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],
        ["\xD0\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE0"],

        ["\xA7\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD0\xBF"],
        ["\xD0\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE1"],

        ["\xA7\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\x80"],
        ["\xD1\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE2"],

        ["\xA7\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\x81"],
        ["\xD1\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE3"],

        ["\xA7\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\x82"],
        ["\xD1\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE4"],

        ["\xA7\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\x83"],
        ["\xD1\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE5"],

        ["\xA7\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\x84"],
        ["\xD1\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE6"],

        ["\xA7\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\x85"],
        ["\xD1\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE7"],

        ["\xA7\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\x86"],
        ["\xD1\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE8"],

        ["\xA7\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\x87"],
        ["\xD1\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xE9"],

        ["\xA7\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\x88"],
        ["\xD1\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xEA"],

        ["\xA7\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\x89"],
        ["\xD1\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xEB"],

        ["\xA7\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\x8A"],
        ["\xD1\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xEC"],

        ["\xA7\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\x8B"],
        ["\xD1\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xED"],

        ["\xA7\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\x8C"],
        ["\xD1\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xEE"],

        ["\xA7\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\x8D"],
        ["\xD1\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xEF"],

        ["\xA7\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\x8E"],
        ["\xD1\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xF0"],

        ["\xA7\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xD1\x8F"],
        ["\xD1\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xA7\xF1"],

        ["\x7C\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x80"],
        ["\xE2\x94\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xD1"],

        ["\x7C\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x82"],
        ["\xE2\x94\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xD2"],

        ["\x7C\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x8C"],
        ["\xE2\x94\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xC1"],

        ["\x7C\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x90"],
        ["\xE2\x94\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xC2"],

        ["\x7C\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x98"],
        ["\xE2\x94\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xC3"],

        ["\x7C\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x94"],
        ["\xE2\x94\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xC4"],

        ["\x7C\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9C"],
        ["\xE2\x94\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xC7"],

        ["\x7C\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAC"],
        ["\xE2\x94\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xC5"],

        ["\x7C\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA4"],
        ["\xE2\x94\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xC8"],

        ["\x7C\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB4"],
        ["\xE2\x94\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xC6"],

        ["\x7C\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBC"],
        ["\xE2\x94\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xC9"],

        ["\x7C\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x81"],
        ["\xE2\x94\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xF6"],

        ["\x7C\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x83"],
        ["\xE2\x94\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xF7"],

        ["\x7C\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x8F"],
        ["\xE2\x94\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xE6"],

        ["\x7C\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x93"],
        ["\xE2\x94\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xE7"],

        ["\x7C\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9B"],
        ["\xE2\x94\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xE8"],

        ["\x7C\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x97"],
        ["\xE2\x94\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xE9"],

        ["\x7C\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA3"],
        ["\xE2\x94\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xF3"],

        ["\x7C\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB3"],
        ["\xE2\x94\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xF1"],

        ["\x7C\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAB"],
        ["\xE2\x94\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xF4"],

        ["\x7C\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBB"],
        ["\xE2\x94\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xF2"],

        ["\x7C\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x95\x8B"],
        ["\xE2\x95\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xF5"],

        ["\x7C\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA0"],
        ["\xE2\x94\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xCA"],

        ["\x7C\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xAF"],
        ["\xE2\x94\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xCB"],

        ["\x7C\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA8"],
        ["\xE2\x94\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xCC"],

        ["\x7C\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB7"],
        ["\xE2\x94\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xC0"],

        ["\x7C\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xBF"],
        ["\xE2\x94\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xCE"],

        ["\x7F\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\x9D"],
        ["\xE2\x94\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xA2"],

        ["\x7F\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB0"],
        ["\xE2\x94\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xA3"],

        ["\x7F\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xA5"],
        ["\xE2\x94\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xA4"],

        ["\x7F\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x94\xB8"],
        ["\xE2\x94\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7F\xA1"],

        ["\x7C\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x95\x82"],
        ["\xE2\x95\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x7C\xCD"],

        ["\x77\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA0"],
        ["\xE2\x91\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xC9"],

        ["\x77\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA1"],
        ["\xE2\x91\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xCA"],

        ["\x77\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA2"],
        ["\xE2\x91\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xCB"],

        ["\x77\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA3"],
        ["\xE2\x91\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xCC"],

        ["\x77\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA4"],
        ["\xE2\x91\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xCD"],

        ["\x77\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA5"],
        ["\xE2\x91\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xCE"],

        ["\x77\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA6"],
        ["\xE2\x91\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xCF"],

        ["\x77\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA7"],
        ["\xE2\x91\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xD0"],

        ["\x77\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA8"],
        ["\xE2\x91\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xD1"],

        ["\x77\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xA9"],
        ["\xE2\x91\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xD2"],

        ["\x77\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAA"],
        ["\xE2\x91\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xD3"],

        ["\x77\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAB"],
        ["\xE2\x91\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xD4"],

        ["\x77\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAC"],
        ["\xE2\x91\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xD5"],

        ["\x77\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAD"],
        ["\xE2\x91\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xD6"],

        ["\x77\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAE"],
        ["\xE2\x91\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xD7"],

        ["\x77\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xAF"],
        ["\xE2\x91\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xD8"],

        ["\x77\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB0"],
        ["\xE2\x91\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xD9"],

        ["\x77\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB1"],
        ["\xE2\x91\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xDA"],

        ["\x77\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB2"],
        ["\xE2\x91\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xDB"],

        ["\x77\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x91\xB3"],
        ["\xE2\x91\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xDC"],

        ["\x77\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA0"],
        ["\xE2\x85\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xDE"],

        ["\x77\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA1"],
        ["\xE2\x85\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xDF"],

        ["\x77\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA2"],
        ["\xE2\x85\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xE0"],

        ["\x77\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA3"],
        ["\xE2\x85\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xE1"],

        ["\x77\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA4"],
        ["\xE2\x85\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xE2"],

        ["\x77\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA5"],
        ["\xE2\x85\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xE3"],

        ["\x77\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA6"],
        ["\xE2\x85\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xE4"],

        ["\x77\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA7"],
        ["\xE2\x85\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xE5"],

        ["\x77\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA8"],
        ["\xE2\x85\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xE6"],

        ["\x77\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x85\xA9"],
        ["\xE2\x85\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x77\xE7"],

        ["\x76\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x89"],
        ["\xE3\x8D\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xDA"],

        ["\x76\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x94"],
        ["\xE3\x8C\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xDC"],

        ["\x76\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA2"],
        ["\xE3\x8C\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xDB"],

        ["\x76\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x8D"],
        ["\xE3\x8D\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xD9"],

        ["\x76\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x98"],
        ["\xE3\x8C\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xDE"],

        ["\x76\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA7"],
        ["\xE3\x8C\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xE0"],

        ["\x76\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x83"],
        ["\xE3\x8C\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xE1"],

        ["\x76\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xB6"],
        ["\xE3\x8C\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xE2"],

        ["\x80\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x91"],
        ["\xE3\x8D\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xA1"],

        ["\x76\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x97"],
        ["\xE3\x8D\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xE7"],

        ["\x76\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\x8D"],
        ["\xE3\x8C\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xE6"],

        ["\x76\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA6"],
        ["\xE3\x8C\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xE3"],

        ["\x76\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xA3"],
        ["\xE3\x8C\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xE4"],

        ["\x76\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xAB"],
        ["\xE3\x8C\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xE5"],

        ["\x76\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\x8A"],
        ["\xE3\x8D\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xE9"],

        ["\x76\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8C\xBB"],
        ["\xE3\x8C\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xEB"],

        ["\x76\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9C"],
        ["\xE3\x8E\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xBC"],

        ["\x76\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9D"],
        ["\xE3\x8E\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xBD"],

        ["\x76\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x9E"],
        ["\xE3\x8E\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xBE"],

        ["\x76\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x8E"],
        ["\xE3\x8E\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xC4"],

        ["\x76\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\x8F"],
        ["\xE3\x8E\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xC5"],

        ["\x76\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F\x84"],
        ["\xE3\x8F\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xC6"],

        ["\x76\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8E\xA1"],
        ["\xE3\x8E\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xC0"],

        ["\x80\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBB"],
        ["\xE3\x8D\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xA2"],

        ["\x80\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9D"],
        ["\xE3\x80\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xA3"],

        ["\x80\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x80\x9F"],
        ["\xE3\x80\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xA4"],

        ["\x76\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\x96"],
        ["\xE2\x84\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xFA"],

        ["\x76\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8F\x8D"],
        ["\xE3\x8F\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xF4"],

        ["\x76\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x84\xA1"],
        ["\xE2\x84\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x76\xF6"],

        ["\x80\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA4"],
        ["\xE3\x8A\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xA5"],

        ["\x80\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA5"],
        ["\xE3\x8A\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xA6"],

        ["\x80\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA6"],
        ["\xE3\x8A\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xA7"],

        ["\x80\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA7"],
        ["\xE3\x8A\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xA8"],

        ["\x80\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8A\xA8"],
        ["\xE3\x8A\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xA9"],

        ["\x78\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB1"],
        ["\xE3\x88\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x78\xD5"],

        ["\x78\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB2"],
        ["\xE3\x88\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x78\xCF"],

        ["\x78\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x88\xB9"],
        ["\xE3\x88\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x78\xCB"],

        ["\x80\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBE"],
        ["\xE3\x8D\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xAA"],

        ["\x80\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBD"],
        ["\xE3\x8D\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xAB"],

        ["\x80\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE3\x8D\xBC"],
        ["\xE3\x8D\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xAC"],

        ["\x80\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\xAE"],
        ["\xE2\x88\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xAD"],

        ["\x80\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x91"],
        ["\xE2\x88\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xAE"],

        ["\x80\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x88\x9F"],
        ["\xE2\x88\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xAF"],

        ["\x80\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE2\x8A\xBF"],
        ["\xE2\x8A\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x80\xB0"],

        ["\xB0\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9C"],
        ["\xE4\xBA\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xA1"],

        ["\xB0\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x96"],
        ["\xE5\x94\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xA2"],

        ["\xB0\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x83"],
        ["\xE5\xA8\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xA3"],

        ["\xB0\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xBF"],
        ["\xE9\x98\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xA4"],

        ["\xB0\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x80"],
        ["\xE5\x93\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xA5"],

        ["\xB0\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9B"],
        ["\xE6\x84\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xA6"],

        ["\xB0\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xA8"],
        ["\xE6\x8C\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xA7"],

        ["\xB0\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xB6"],
        ["\xE5\xA7\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xA8"],

        ["\xB0\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA2"],
        ["\xE9\x80\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xA9"],

        ["\xB0\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB5"],
        ["\xE8\x91\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xAA"],

        ["\xB0\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x9C"],
        ["\xE8\x8C\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xAB"],

        ["\xB0\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x90"],
        ["\xE7\xA9\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xAC"],

        ["\xB0\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xAA"],
        ["\xE6\x82\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xAD"],

        ["\xB0\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA1"],
        ["\xE6\x8F\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xAE"],

        ["\xB0\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA5"],
        ["\xE6\xB8\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xAF"],

        ["\xB0\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xAD"],
        ["\xE6\x97\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB0"],

        ["\xB0\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA6"],
        ["\xE8\x91\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB1"],

        ["\xB0\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA6"],
        ["\xE8\x8A\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB2"],

        ["\xF2\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB5"],
        ["\xE9\xAF\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xCD"],

        ["\xB0\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x93"],
        ["\xE6\xA2\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB4"],

        ["\xB0\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA7"],
        ["\xE5\x9C\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB5"],

        ["\xB0\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA1"],
        ["\xE6\x96\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB6"],

        ["\xB0\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB1"],
        ["\xE6\x89\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB7"],

        ["\xB0\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9B"],
        ["\xE5\xAE\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB8"],

        ["\xB0\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x90"],
        ["\xE5\xA7\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB9"],

        ["\xB0\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xBB"],
        ["\xE8\x99\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xBA"],

        ["\xB0\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xB4"],
        ["\xE9\xA3\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xBB"],

        ["\xB0\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA2"],
        ["\xE7\xB5\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xBC"],

        ["\xB0\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBE"],
        ["\xE7\xB6\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xBD"],

        ["\xB0\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x8E"],
        ["\xE9\xAE\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xBE"],

        ["\xB0\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x96"],
        ["\xE6\x88\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xBF"],

        ["\xB0\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x9F"],
        ["\xE7\xB2\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC0"],

        ["\xB0\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB7"],
        ["\xE8\xA2\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC1"],

        ["\xB0\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x89"],
        ["\xE5\xAE\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC2"],

        ["\xB0\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB5"],
        ["\xE5\xBA\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC3"],

        ["\xB0\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x89"],
        ["\xE6\x8C\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC4"],

        ["\xB0\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x97"],
        ["\xE6\x9A\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC5"],

        ["\xB0\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x88"],
        ["\xE6\xA1\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC6"],

        ["\xB0\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x87"],
        ["\xE9\x97\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC7"],

        ["\xB0\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x8D"],
        ["\xE9\x9E\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC8"],

        ["\xB0\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x8F"],
        ["\xE6\x9D\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xC9"],

        ["\xB0\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA5"],
        ["\xE4\xBB\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xCA"],

        ["\xB0\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8A"],
        ["\xE4\xBC\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xCB"],

        ["\xB0\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8D"],
        ["\xE4\xBD\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xCC"],

        ["\xB0\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x9D"],
        ["\xE4\xBE\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xCD"],

        ["\xB0\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x89"],
        ["\xE5\x81\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xCE"],

        ["\xB0\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB2"],
        ["\xE5\x9B\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xCF"],

        ["\xB0\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB7"],
        ["\xE5\xA4\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD0"],

        ["\xB0\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x94"],
        ["\xE5\xA7\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD1"],

        ["\xB0\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x81"],
        ["\xE5\xA8\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD2"],

        ["\xB0\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x89"],
        ["\xE5\xB0\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD3"],

        ["\xB0\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9F"],
        ["\xE6\x83\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD4"],

        ["\xB0\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8F"],
        ["\xE6\x84\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD5"],

        ["\xB0\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB0"],
        ["\xE6\x85\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD6"],

        ["\xB0\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x93"],
        ["\xE6\x98\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD7"],

        ["\xB0\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x85"],
        ["\xE6\xA4\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD8"],

        ["\xB0\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xBA"],
        ["\xE7\x82\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xD9"],

        ["\xB0\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8F"],
        ["\xE7\x95\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xDA"],

        ["\xB0\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB0"],
        ["\xE7\x95\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xDB"],

        ["\xB0\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xBB"],
        ["\xE7\xA7\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xDC"],

        ["\xB0\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAD"],
        ["\xE7\xB6\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xDD"],

        ["\xB0\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xAF"],
        ["\xE7\xB7\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xDE"],

        ["\xB0\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x83"],
        ["\xE8\x83\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xDF"],

        ["\xB0\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8E"],
        ["\xE8\x90\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE0"],

        ["\xB0\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA3"],
        ["\xE8\xA1\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE1"],

        ["\xB0\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x82"],
        ["\xE8\xAC\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE2"],

        ["\xB0\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x95"],
        ["\xE9\x81\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE3"],

        ["\xB0\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBA"],
        ["\xE9\x81\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE4"],

        ["\xB0\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBB"],
        ["\xE5\x8C\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE5"],

        ["\xB0\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x95"],
        ["\xE4\xBA\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE6"],

        ["\xB0\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA5"],
        ["\xE4\xBA\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE7"],

        ["\xB0\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x9F"],
        ["\xE5\x9F\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE8"],

        ["\xB0\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB2"],
        ["\xE8\x82\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xE9"],

        ["\xB0\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x81"],
        ["\xE9\x83\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xEA"],

        ["\xB0\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xAF"],
        ["\xE7\xA3\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xEB"],

        ["\xB0\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x80"],
        ["\xE4\xB8\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xEC"],

        ["\xB0\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB1"],
        ["\xE5\xA3\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xED"],

        ["\xB0\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xA2"],
        ["\xE6\xBA\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xEE"],

        ["\xB0\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB8"],
        ["\xE9\x80\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xEF"],

        ["\xB0\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB2"],
        ["\xE7\xA8\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF0"],

        ["\xB0\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xA8"],
        ["\xE8\x8C\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF1"],

        ["\xB0\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8B"],
        ["\xE8\x8A\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF2"],

        ["\xB0\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAF"],
        ["\xE9\xB0\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF3"],

        ["\xB0\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x81"],
        ["\xE5\x85\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF4"],

        ["\xB0\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB0"],
        ["\xE5\x8D\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF5"],

        ["\xB0\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBD"],
        ["\xE5\x92\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF6"],

        ["\xB0\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA1"],
        ["\xE5\x93\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF7"],

        ["\xB0\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xA0"],
        ["\xE5\x9B\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF8"],

        ["\xB0\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xBB"],
        ["\xE5\xA7\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xF9"],

        ["\xB0\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x95"],
        ["\xE5\xBC\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xFA"],

        ["\xB0\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xB2"],
        ["\xE9\xA3\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xFB"],

        ["\xB0\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAB"],
        ["\xE6\xB7\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xFC"],

        ["\xB0\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA4"],
        ["\xE8\x83\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xFD"],

        ["\xB0\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xAD"],
        ["\xE8\x94\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xFE"],

        ["\xB1\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA2"],
        ["\xE9\x99\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xA1"],

        ["\xB1\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB0"],
        ["\xE9\x99\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xA2"],

        ["\xB1\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA0"],
        ["\xE9\x9A\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xA3"],

        ["\xB1\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xBB"],
        ["\xE9\x9F\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xA4"],

        ["\xB1\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8B"],
        ["\xE5\x90\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xA5"],

        ["\xB1\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB3"],
        ["\xE5\x8F\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xA6"],

        ["\xB1\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x87"],
        ["\xE5\xAE\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xA7"],

        ["\xB1\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x8F"],
        ["\xE7\x83\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xA8"],

        ["\xB1\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xBD"],
        ["\xE7\xBE\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xA9"],

        ["\xB1\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x82"],
        ["\xE8\xBF\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xAA"],

        ["\xB1\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA8"],
        ["\xE9\x9B\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xAB"],

        ["\xB1\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xAF"],
        ["\xE5\x8D\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xAC"],

        ["\xB1\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x9C"],
        ["\xE9\xB5\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xAD"],

        ["\xB1\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBA"],
        ["\xE7\xAA\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xAE"],

        ["\xB1\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x91"],
        ["\xE4\xB8\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xAF"],

        ["\xB1\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x93"],
        ["\xE7\xA2\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB0"],

        ["\xB1\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBC"],
        ["\xE8\x87\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB1"],

        ["\xB1\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA6"],
        ["\xE6\xB8\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB2"],

        ["\xB1\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x98"],
        ["\xE5\x98\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB3"],

        ["\xB1\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x84"],
        ["\xE5\x94\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB4"],

        ["\xB1\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x9D"],
        ["\xE6\xAC\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB5"],

        ["\xB1\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x9A"],
        ["\xE8\x94\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB6"],

        ["\xB1\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xBB"],
        ["\xE9\xB0\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB7"],

        ["\xB1\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA5"],
        ["\xE5\xA7\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB8"],

        ["\xB1\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA9"],
        ["\xE5\x8E\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xB9"],

        ["\xB1\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA6"],
        ["\xE6\xB5\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xBA"],

        ["\xB1\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x9C"],
        ["\xE7\x93\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xBB"],

        ["\xB1\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8F"],
        ["\xE9\x96\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xBC"],

        ["\xB1\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x82"],
        ["\xE5\x99\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xBD"],

        ["\xB1\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x91"],
        ["\xE4\xBA\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xBE"],

        ["\xB1\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8B"],
        ["\xE9\x81\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xBF"],

        ["\xB1\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB2"],
        ["\xE9\x9B\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC0"],

        ["\xB1\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x8F"],
        ["\xE8\x8D\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC1"],

        ["\xB1\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x8C"],
        ["\xE9\xA4\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC2"],

        ["\xB1\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA1"],
        ["\xE5\x8F\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC3"],

        ["\xB1\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xB6"],
        ["\xE5\x96\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC4"],

        ["\xB1\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB0"],
        ["\xE5\xAC\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC5"],

        ["\xB1\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB1"],
        ["\xE5\xBD\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC6"],

        ["\xB1\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA0"],
        ["\xE6\x98\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC7"],

        ["\xB1\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB3"],
        ["\xE6\x9B\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC8"],

        ["\xB1\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x84"],
        ["\xE6\xA0\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xC9"],

        ["\xB1\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB8"],
        ["\xE6\xB0\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xCA"],

        ["\xB1\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB3"],
        ["\xE6\xB3\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xCB"],

        ["\xB1\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA9"],
        ["\xE6\xB4\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xCC"],

        ["\xB1\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9B"],
        ["\xE7\x91\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xCD"],

        ["\xB1\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x88"],
        ["\xE7\x9B\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xCE"],

        ["\xB1\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8E"],
        ["\xE7\xA9\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xCF"],

        ["\xB1\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB4"],
        ["\xE9\xA0\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD0"],

        ["\xB1\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB1"],
        ["\xE8\x8B\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD1"],

        ["\xB1\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9B"],
        ["\xE8\xA1\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD2"],

        ["\xB1\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA0"],
        ["\xE8\xA9\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD3"],

        ["\xB1\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xAD"],
        ["\xE9\x8B\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD4"],

        ["\xB1\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB2"],
        ["\xE6\xB6\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD5"],

        ["\xB1\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xAB"],
        ["\xE7\x96\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD6"],

        ["\xB1\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8A"],
        ["\xE7\x9B\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD7"],

        ["\xB1\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x85"],
        ["\xE9\xA7\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD8"],

        ["\xB1\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA6"],
        ["\xE6\x82\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xD9"],

        ["\xB1\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x81"],
        ["\xE8\xAC\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xDA"],

        ["\xB1\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x8A"],
        ["\xE8\xB6\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xDB"],

        ["\xB1\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xB2"],
        ["\xE9\x96\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xDC"],

        ["\xB1\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x8E"],
        ["\xE6\xA6\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xDD"],

        ["\xB1\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xAD"],
        ["\xE5\x8E\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xDE"],

        ["\xB1\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x86"],
        ["\xE5\x86\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xDF"],

        ["\xB1\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x92"],
        ["\xE5\x9C\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE0"],

        ["\xB1\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB0"],
        ["\xE5\xA0\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE1"],

        ["\xB1\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x84"],
        ["\xE5\xA5\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE2"],

        ["\xB1\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB4"],
        ["\xE5\xAE\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE3"],

        ["\xB1\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB6"],
        ["\xE5\xBB\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE4"],

        ["\xB1\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA8"],
        ["\xE6\x80\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE5"],

        ["\xB1\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA9"],
        ["\xE6\x8E\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE6"],

        ["\xB1\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB4"],
        ["\xE6\x8F\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE7"],

        ["\xB1\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBF"],
        ["\xE6\xB2\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE8"],

        ["\xB1\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x94"],
        ["\xE6\xBC\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xE9"],

        ["\xB1\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x8E"],
        ["\xE7\x82\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xEA"],

        ["\xB1\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x94"],
        ["\xE7\x84\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xEB"],

        ["\xB1\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x99"],
        ["\xE7\x85\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xEC"],

        ["\xB1\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x95"],
        ["\xE7\x87\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xED"],

        ["\xB1\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xBF"],
        ["\xE7\x8C\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xEE"],

        ["\xB1\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x81"],
        ["\xE7\xB8\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xEF"],

        ["\xB1\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB6"],
        ["\xE8\x89\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF0"],

        ["\xB1\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x91"],
        ["\xE8\x8B\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF1"],

        ["\xB1\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x97"],
        ["\xE8\x96\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF2"],

        ["\xB1\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA0"],
        ["\xE9\x81\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF3"],

        ["\xB1\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9B"],
        ["\xE9\x89\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF4"],

        ["\xB1\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x9B"],
        ["\xE9\xB4\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF5"],

        ["\xB1\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA9"],
        ["\xE5\xA1\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF6"],

        ["\xB1\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xBC"],
        ["\xE6\x96\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF7"],

        ["\xB1\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9A"],
        ["\xE6\xB1\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF8"],

        ["\xB1\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA5"],
        ["\xE7\x94\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xF9"],

        ["\xB1\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB9"],
        ["\xE5\x87\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xFA"],

        ["\xB1\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAE"],
        ["\xE5\xA4\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xFB"],

        ["\xB1\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA5"],
        ["\xE5\xA5\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xFC"],

        ["\xB1\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x80"],
        ["\xE5\xBE\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xFD"],

        ["\xB1\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x9C"],
        ["\xE5\xBF\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB1\xFE"],

        ["\xB2\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBC"],
        ["\xE6\x8A\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xA1"],

        ["\xB2\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xBA"],
        ["\xE6\x97\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xA2"],

        ["\xB2\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAA"],
        ["\xE6\xA8\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xA3"],

        ["\xB2\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA7"],
        ["\xE6\xAC\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xA4"],

        ["\xB2\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB4"],
        ["\xE6\xAE\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xA5"],

        ["\xB2\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x8B"],
        ["\xE7\x8E\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xA6"],

        ["\xB2\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x81"],
        ["\xE7\xBF\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xA7"],

        ["\xB2\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x96"],
        ["\xE8\xA5\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xA8"],

        ["\xF2\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xAC"],
        ["\xE9\xB4\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF4"],

        ["\xB2\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x8E"],
        ["\xE9\xB4\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xAA"],

        ["\xB2\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x84"],
        ["\xE9\xBB\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xAB"],

        ["\xB2\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA1"],
        ["\xE5\xB2\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xAC"],

        ["\xB2\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x96"],
        ["\xE6\xB2\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xAD"],

        ["\xB2\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBB"],
        ["\xE8\x8D\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xAE"],

        ["\xB2\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x84"],
        ["\xE5\x84\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xAF"],

        ["\xB2\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8B"],
        ["\xE5\xB1\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB0"],

        ["\xB2\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xB6"],
        ["\xE6\x86\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB1"],

        ["\xB2\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x86"],
        ["\xE8\x87\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB2"],

        ["\xB2\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB6"],
        ["\xE6\xA1\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB3"],

        ["\xB2\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA1"],
        ["\xE7\x89\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB4"],

        ["\xB2\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x99"],
        ["\xE4\xB9\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB5"],

        ["\xB2\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xBA"],
        ["\xE4\xBF\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB6"],

        ["\xB2\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB8"],
        ["\xE5\x8D\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB7"],

        ["\xB2\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA9"],
        ["\xE6\x81\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB8"],

        ["\xB2\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA9"],
        ["\xE6\xB8\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xB9"],

        ["\xB2\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8F"],
        ["\xE7\xA9\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xBA"],

        ["\xB2\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB3"],
        ["\xE9\x9F\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xBB"],

        ["\xB2\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8B"],
        ["\xE4\xB8\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xBC"],

        ["\xB2\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x96"],
        ["\xE5\x8C\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xBD"],

        ["\xB2\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xAE"],
        ["\xE4\xBB\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xBE"],

        ["\xB2\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x95"],
        ["\xE4\xBD\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xBF"],

        ["\xB2\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBD"],
        ["\xE4\xBC\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC0"],

        ["\xB2\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xA1"],
        ["\xE4\xBE\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC1"],

        ["\xB2\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB3"],
        ["\xE4\xBD\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC2"],

        ["\xB2\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA0"],
        ["\xE5\x8A\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC3"],

        ["\xB2\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAF"],
        ["\xE5\x8F\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC4"],

        ["\xB2\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x89"],
        ["\xE5\x98\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC5"],

        ["\xB2\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8F"],
        ["\xE5\xA4\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC6"],

        ["\xB2\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x81"],
        ["\xE5\xAB\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC7"],

        ["\xB2\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB6"],
        ["\xE5\xAE\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC8"],

        ["\xB2\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA1"],
        ["\xE5\xAF\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xC9"],

        ["\xB2\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x91"],
        ["\xE7\xA7\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xCA"],

        ["\xB2\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x87"],
        ["\xE6\x9A\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xCB"],

        ["\xB2\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9C"],
        ["\xE6\x9E\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xCC"],

        ["\xB2\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB6"],
        ["\xE6\x9E\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xCD"],

        ["\xB2\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x8C"],
        ["\xE6\xAD\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xCE"],

        ["\xB2\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB3"],
        ["\xE6\xB2\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xCF"],

        ["\xB2\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAB"],
        ["\xE7\x81\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD0"],

        ["\xB2\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x82"],
        ["\xE7\x8F\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD1"],

        ["\xB2\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8D"],
        ["\xE7\xA6\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD2"],

        ["\xB2\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBE"],
        ["\xE7\xA6\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD3"],

        ["\xB2\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBC"],
        ["\xE7\xA8\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD4"],

        ["\xB2\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x87"],
        ["\xE7\xAE\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD5"],

        ["\xB2\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB1"],
        ["\xE8\x8A\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD6"],

        ["\xB2\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9B"],
        ["\xE8\x8B\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD7"],

        ["\xB2\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x84"],
        ["\xE8\x8C\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD8"],

        ["\xB2\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB7"],
        ["\xE8\x8D\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xD9"],

        ["\xB2\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xAF"],
        ["\xE8\x8F\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xDA"],

        ["\xB2\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x93"],
        ["\xE8\x8F\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xDB"],

        ["\xB2\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA6"],
        ["\xE8\x9D\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xDC"],

        ["\xB2\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB2"],
        ["\xE8\xAA\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xDD"],

        ["\xB2\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xA9"],
        ["\xE5\x98\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xDE"],

        ["\xB2\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA8"],
        ["\xE8\xB2\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xDF"],

        ["\xB2\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA6"],
        ["\xE8\xBF\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE0"],

        ["\xB2\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8E"],
        ["\xE9\x81\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE1"],

        ["\xB2\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x9E"],
        ["\xE9\x9C\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE2"],

        ["\xB2\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8A"],
        ["\xE8\x9A\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE3"],

        ["\xB2\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x84"],
        ["\xE4\xBF\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE4"],

        ["\xB2\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA8"],
        ["\xE5\xB3\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE5"],

        ["\xB2\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x91"],
        ["\xE6\x88\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE6"],

        ["\xB2\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x99"],
        ["\xE7\x89\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE7"],

        ["\xB2\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBB"],
        ["\xE7\x94\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE8"],

        ["\xB2\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA5"],
        ["\xE8\x87\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xE9"],

        ["\xB2\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBD"],
        ["\xE8\x8A\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xEA"],

        ["\xB2\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBE"],
        ["\xE8\x9B\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xEB"],

        ["\xB2\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x80"],
        ["\xE8\xB3\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xEC"],

        ["\xB2\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x85"],
        ["\xE9\x9B\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xED"],

        ["\xB2\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x93"],
        ["\xE9\xA4\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xEE"],

        ["\xB2\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x95"],
        ["\xE9\xA7\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xEF"],

        ["\xB2\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8B"],
        ["\xE4\xBB\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF0"],

        ["\xB2\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9A"],
        ["\xE4\xBC\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF1"],

        ["\xB2\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA3"],
        ["\xE8\xA7\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF2"],

        ["\xB2\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9E"],
        ["\xE5\x9B\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF3"],

        ["\xB2\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x8A"],
        ["\xE5\xA1\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF4"],

        ["\xB2\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x8A"],
        ["\xE5\xA3\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF5"],

        ["\xB2\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBB"],
        ["\xE5\xBB\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF6"],

        ["\xB2\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xAB"],
        ["\xE5\xBF\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF7"],

        ["\xB2\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAA"],
        ["\xE6\x80\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF8"],

        ["\xB2\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x94"],
        ["\xE6\x82\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xF9"],

        ["\xB2\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA2"],
        ["\xE6\x81\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xFA"],

        ["\xB2\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x90"],
        ["\xE6\x87\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xFB"],

        ["\xB2\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x92"],
        ["\xE6\x88\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xFC"],

        ["\xB2\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x90"],
        ["\xE6\x8B\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xFD"],

        ["\xB2\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB9"],
        ["\xE6\x94\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xFE"],

        ["\xB3\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x81"],
        ["\xE9\xAD\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA1"],

        ["\xB3\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA6"],
        ["\xE6\x99\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA2"],

        ["\xB3\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB0"],
        ["\xE6\xA2\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA3"],

        ["\xB3\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB7"],
        ["\xE6\xB5\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA4"],

        ["\xB3\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xB0"],
        ["\xE7\x81\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA5"],

        ["\xB3\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8C"],
        ["\xE7\x95\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA6"],

        ["\xB3\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x86"],
        ["\xE7\x9A\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA7"],

        ["\xB3\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB5"],
        ["\xE7\xB5\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA8"],

        ["\xB3\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xA5"],
        ["\xE8\x8A\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xA9"],

        ["\xB3\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB9"],
        ["\xE8\x9F\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xAA"],

        ["\xB3\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8B"],
        ["\xE9\x96\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xAB"],

        ["\xB3\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8E"],
        ["\xE9\x9A\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xAC"],

        ["\xB3\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x9D"],
        ["\xE8\xB2\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xAD"],

        ["\xB3\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB1"],
        ["\xE5\x87\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xAE"],

        ["\xB3\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xBE"],
        ["\xE5\x8A\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xAF"],

        ["\xB3\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x96"],
        ["\xE5\xA4\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB0"],

        ["\xB3\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB3"],
        ["\xE5\x92\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB1"],

        ["\xB3\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB3"],
        ["\xE5\xAE\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB2"],

        ["\xB3\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x96"],
        ["\xE5\xB4\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB3"],

        ["\xB3\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA8"],
        ["\xE6\x85\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB4"],

        ["\xB3\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x82"],
        ["\xE6\xA6\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB5"],

        ["\xB3\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xAF"],
        ["\xE6\xB6\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB6"],

        ["\xB3\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8D"],
        ["\xE7\xA2\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB7"],

        ["\xB3\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8B"],
        ["\xE8\x93\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB8"],

        ["\xB3\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x97"],
        ["\xE8\xA1\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xB9"],

        ["\xB3\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB2"],
        ["\xE8\xA9\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xBA"],

        ["\xB3\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xA7"],
        ["\xE9\x8E\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xBB"],

        ["\xB3\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xB8"],
        ["\xE9\xAA\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xBC"],

        ["\xB3\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAC"],
        ["\xE6\xB5\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xBD"],

        ["\xB3\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xA8"],
        ["\xE9\xA6\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xBE"],

        ["\xB3\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x99"],
        ["\xE8\x9B\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xBF"],

        ["\xB3\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA3"],
        ["\xE5\x9E\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC0"],

        ["\xB3\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBF"],
        ["\xE6\x9F\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC1"],

        ["\xE9\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8E"],
        ["\xE8\x9B\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDA"],

        ["\xB3\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x8E"],
        ["\xE9\x88\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC3"],

        ["\xB3\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x83"],
        ["\xE5\x8A\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC4"],

        ["\xB3\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x87"],
        ["\xE5\x9A\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC5"],

        ["\xB3\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x84"],
        ["\xE5\x90\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC6"],

        ["\xB3\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x93"],
        ["\xE5\xBB\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC7"],

        ["\xB3\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xA1"],
        ["\xE6\x8B\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC8"],

        ["\xD9\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB9"],
        ["\xE6\x92\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF8"],

        ["\xB3\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xBC"],
        ["\xE6\xA0\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xCA"],

        ["\xB3\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB8"],
        ["\xE6\xA0\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xCB"],

        ["\xB3\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBB"],
        ["\xE6\xAE\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xCC"],

        ["\xB3\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB2"],
        ["\xE7\x8D\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xCD"],

        ["\xB3\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBA"],
        ["\xE7\xA2\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xCE"],

        ["\xB3\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xAB"],
        ["\xE7\xA9\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xCF"],

        ["\xB3\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x9A"],
        ["\xE8\xA6\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD0"],

        ["\xB3\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x92"],
        ["\xE8\xA7\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD1"],

        ["\xB3\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xAB"],
        ["\xE8\xB5\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD2"],

        ["\xB3\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x83"],
        ["\xE8\xBC\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD3"],

        ["\xB3\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xAD"],
        ["\xE9\x83\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD4"],

        ["\xB3\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA3"],
        ["\xE9\x96\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD5"],

        ["\xB3\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x94"],
        ["\xE9\x9A\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD6"],

        ["\xB3\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA9"],
        ["\xE9\x9D\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD7"],

        ["\xB3\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA6"],
        ["\xE5\xAD\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD8"],

        ["\xB3\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB3"],
        ["\xE5\xB2\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xD9"],

        ["\xB3\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBD"],
        ["\xE6\xA5\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xDA"],

        ["\xB3\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8D"],
        ["\xE9\xA1\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xDB"],

        ["\xB3\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8E"],
        ["\xE9\xA1\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xDC"],

        ["\xB3\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x9B"],
        ["\xE6\x8E\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xDD"],

        ["\xB3\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA0"],
        ["\xE7\xAC\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xDE"],

        ["\xB3\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAB"],
        ["\xE6\xA8\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xDF"],

        ["\xB3\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xBF"],
        ["\xE6\xA9\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE0"],

        ["\xB3\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB6"],
        ["\xE6\xA2\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE1"],

        ["\xB3\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x8D"],
        ["\xE9\xB0\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE2"],

        ["\xB3\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9F"],
        ["\xE6\xBD\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE3"],

        ["\xB3\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB2"],
        ["\xE5\x89\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE4"],

        ["\xB3\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9D"],
        ["\xE5\x96\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE5"],

        ["\xB3\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB0"],
        ["\xE6\x81\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE6"],

        ["\xB3\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAC"],
        ["\xE6\x8B\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE7"],

        ["\xB3\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBB"],
        ["\xE6\xB4\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE8"],

        ["\xB3\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x87"],
        ["\xE6\xB8\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xE9"],

        ["\xB3\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x91"],
        ["\xE6\xBB\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xEA"],

        ["\xB3\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x9B"],
        ["\xE8\x91\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xEB"],

        ["\xB3\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x90"],
        ["\xE8\xA4\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xEC"],

        ["\xB3\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x84"],
        ["\xE8\xBD\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xED"],

        ["\xB3\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x94"],
        ["\xE4\xB8\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xEE"],

        ["\xB3\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB9"],
        ["\xE9\xB0\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xEF"],

        ["\xB3\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB6"],
        ["\xE5\x8F\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF0"],

        ["\xB3\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9B"],
        ["\xE6\xA4\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF1"],

        ["\xB3\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBA"],
        ["\xE6\xA8\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF2"],

        ["\xB3\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x84"],
        ["\xE9\x9E\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF3"],

        ["\xB3\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xAA"],
        ["\xE6\xA0\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF4"],

        ["\xB3\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x9C"],
        ["\xE5\x85\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF5"],

        ["\xE3\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x83"],
        ["\xE7\xAB\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDE"],

        ["\xB3\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB2"],
        ["\xE8\x92\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF7"],

        ["\xB3\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9C"],
        ["\xE9\x87\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF8"],

        ["\xB3\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x8C"],
        ["\xE9\x8E\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF9"],

        ["\xB3\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x9B"],
        ["\xE5\x99\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xFA"],

        ["\xB3\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xA8"],
        ["\xE9\xB4\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xFB"],

        ["\xB3\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA2"],
        ["\xE6\xA0\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xFC"],

        ["\xB3\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x85"],
        ["\xE8\x8C\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xFD"],

        ["\xB3\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB1"],
        ["\xE8\x90\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xFE"],

        ["\xB4\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA5"],
        ["\xE7\xB2\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA1"],

        ["\xB4\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x88"],
        ["\xE5\x88\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA2"],

        ["\xB4\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x85"],
        ["\xE8\x8B\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA3"],

        ["\xB4\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA6"],
        ["\xE7\x93\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA4"],

        ["\xB4\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xBE"],
        ["\xE4\xB9\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA5"],

        ["\xB4\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x83"],
        ["\xE4\xBE\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA6"],

        ["\xB4\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA0"],
        ["\xE5\x86\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA7"],

        ["\xB4\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x92"],
        ["\xE5\xAF\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA8"],

        ["\xB4\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8A"],
        ["\xE5\x88\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xA9"],

        ["\xB4\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x98"],
        ["\xE5\x8B\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xAA"],

        ["\xB4\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA7"],
        ["\xE5\x8B\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xAB"],

        ["\xB4\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBB"],
        ["\xE5\xB7\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xAC"],

        ["\xB4\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9A"],
        ["\xE5\x96\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xAD"],

        ["\xB4\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xAA"],
        ["\xE5\xA0\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xAE"],

        ["\xB4\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA6"],
        ["\xE5\xA7\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xAF"],

        ["\xB4\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8C"],
        ["\xE5\xAE\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB0"],

        ["\xB4\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x98"],
        ["\xE5\xAE\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB1"],

        ["\xB4\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9B"],
        ["\xE5\xAF\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB2"],

        ["\xB4\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB2"],
        ["\xE5\xB9\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB3"],

        ["\xB4\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB9"],
        ["\xE5\xB9\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB4"],

        ["\xB4\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA3"],
        ["\xE6\x82\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB5"],

        ["\xB4\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9F"],
        ["\xE6\x84\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB6"],

        ["\xB4\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA3"],
        ["\xE6\x85\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB7"],

        ["\xB4\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xBE"],
        ["\xE6\x86\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB8"],

        ["\xB4\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x9B"],
        ["\xE6\x8F\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xB9"],

        ["\xB4\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA2"],
        ["\xE6\x95\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xBA"],

        ["\xB4\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x91"],
        ["\xE6\x9F\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xBB"],

        ["\xB4\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x93"],
        ["\xE6\xA1\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xBC"],

        ["\xB4\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xBA"],
        ["\xE6\xA3\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xBD"],

        ["\xB4\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBE"],
        ["\xE6\xAC\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xBE"],

        ["\xB4\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x93"],
        ["\xE6\xAD\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xBF"],

        ["\xB4\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x97"],
        ["\xE6\xB1\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC0"],

        ["\xB4\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA2"],
        ["\xE6\xBC\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC1"],

        ["\xB4\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x97"],
        ["\xE6\xBE\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC2"],

        ["\xDE\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x85"],
        ["\xE6\xBD\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF5"],

        ["\xB4\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xB0"],
        ["\xE7\x92\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC4"],

        ["\xB4\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x98"],
        ["\xE7\x94\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC5"],

        ["\xB4\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA3"],
        ["\xE7\x9B\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC6"],

        ["\xB4\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x8B"],
        ["\xE7\x9C\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC7"],

        ["\xB4\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xBF"],
        ["\xE7\xAB\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC8"],

        ["\xB4\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xA1"],
        ["\xE7\xAE\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC9"],

        ["\xB4\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA1"],
        ["\xE7\xB0\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xCA"],

        ["\xB4\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA9"],
        ["\xE7\xB7\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xCB"],

        ["\xB4\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xB6"],
        ["\xE7\xBC\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xCC"],

        ["\xB4\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB0"],
        ["\xE7\xBF\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xCD"],

        ["\xB4\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9D"],
        ["\xE8\x82\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xCE"],

        ["\xB4\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA6"],
        ["\xE8\x89\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xCF"],

        ["\xB4\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9E"],
        ["\xE8\x8E\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD0"],

        ["\xB4\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xB3"],
        ["\xE8\xA6\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD1"],

        ["\xEB\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8C"],
        ["\xE8\xAB\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xDD"],

        ["\xB4\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAB"],
        ["\xE8\xB2\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD3"],

        ["\xB4\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x84"],
        ["\xE9\x82\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD4"],

        ["\xB4\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x91"],
        ["\xE9\x91\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD5"],

        ["\xB4\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x93"],
        ["\xE9\x96\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD6"],

        ["\xB4\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x91"],
        ["\xE9\x96\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD7"],

        ["\xB4\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA2"],
        ["\xE9\x96\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD8"],

        ["\xB4\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA5"],
        ["\xE9\x99\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD9"],

        ["\xB4\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x93"],
        ["\xE9\x9F\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xDA"],

        ["\xB4\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA8"],
        ["\xE9\xA4\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xDB"],

        ["\xB4\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x98"],
        ["\xE8\x88\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xDC"],

        ["\xB4\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB8"],
        ["\xE4\xB8\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xDD"],

        ["\xB4\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAB"],
        ["\xE5\x90\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xDE"],

        ["\xB4\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB8"],
        ["\xE5\xB2\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xDF"],

        ["\xB4\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x8C"],
        ["\xE5\xB7\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE0"],

        ["\xB4\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xA9"],
        ["\xE7\x8E\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE1"],

        ["\xB4\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x8C"],
        ["\xE7\x99\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE2"],

        ["\xB4\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xBC"],
        ["\xE7\x9C\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE3"],

        ["\xB4\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA9"],
        ["\xE5\xB2\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE4"],

        ["\xB4\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xAB"],
        ["\xE7\xBF\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE5"],

        ["\xB4\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8B"],
        ["\xE8\xB4\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE6"],

        ["\xB4\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x81"],
        ["\xE9\x9B\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE7"],

        ["\xB4\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x91"],
        ["\xE9\xA0\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE8"],

        ["\xB4\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x94"],
        ["\xE9\xA1\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xE9"],

        ["\xB4\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x98"],
        ["\xE9\xA1\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xEA"],

        ["\xB4\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x81"],
        ["\xE4\xBC\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xEB"],

        ["\xB4\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8E"],
        ["\xE4\xBC\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xEC"],

        ["\xB4\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB1"],
        ["\xE5\x8D\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xED"],

        ["\xB4\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9C"],
        ["\xE5\x96\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xEE"],

        ["\xB4\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xA8"],
        ["\xE5\x99\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xEF"],

        ["\xB4\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBA"],
        ["\xE5\x9F\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF0"],

        ["\xB4\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x87"],
        ["\xE5\xA5\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF1"],

        ["\xB4\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x89"],
        ["\xE5\xAC\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF2"],

        ["\xB4\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x84"],
        ["\xE5\xAF\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF3"],

        ["\xB4\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x90"],
        ["\xE5\xB2\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF4"],

        ["\xB4\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x8C"],
        ["\xE5\xB8\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF5"],

        ["\xB4\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBE"],
        ["\xE5\xB9\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF6"],

        ["\xB4\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x8C"],
        ["\xE5\xBF\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF7"],

        ["\xB4\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xAE"],
        ["\xE6\x8F\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF8"],

        ["\xB4\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBA"],
        ["\xE6\x9C\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xF9"],

        ["\xB4\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x97"],
        ["\xE6\x97\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xFA"],

        ["\xB4\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA2"],
        ["\xE6\x97\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xFB"],

        ["\xB4\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9F"],
        ["\xE6\x9C\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xFC"],

        ["\xB4\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8B"],
        ["\xE6\xA3\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xFD"],

        ["\xB4\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x84"],
        ["\xE6\xA3\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xFE"],

        ["\xB5\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x9F"],
        ["\xE6\xA9\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA1"],

        ["\xB5\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB0"],
        ["\xE5\xB8\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA2"],

        ["\xB5\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x85"],
        ["\xE6\xAF\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA3"],

        ["\xB5\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x97"],
        ["\xE6\xB0\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA4"],

        ["\xB5\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBD"],
        ["\xE6\xB1\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA5"],

        ["\xB5\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xBF"],
        ["\xE7\x95\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA6"],

        ["\xB5\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x88"],
        ["\xE7\xA5\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA7"],

        ["\xB5\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA3"],
        ["\xE5\xAD\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA8"],

        ["\xB5\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x80"],
        ["\xE7\xA8\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xA9"],

        ["\xB5\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x80"],
        ["\xE7\xB4\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xAA"],

        ["\xB5\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xBD"],
        ["\xE5\xBE\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xAB"],

        ["\xB5\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8F"],
        ["\xE8\xA6\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xAC"],

        ["\xB5\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x98"],
        ["\xE8\xA8\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xAD"],

        ["\xB5\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB4"],
        ["\xE8\xB2\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xAE"],

        ["\xB5\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB7"],
        ["\xE8\xB5\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xAF"],

        ["\xB5\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8C"],
        ["\xE8\xBB\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB0"],

        ["\xB5\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9D"],
        ["\xE8\xBC\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB1"],

        ["\xB5\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xA2"],
        ["\xE9\xA3\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB2"],

        ["\xB5\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x8E"],
        ["\xE9\xA8\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB3"],

        ["\xB5\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xBC"],
        ["\xE9\xAC\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB4"],

        ["\xB5\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x80"],
        ["\xE4\xBA\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB5"],

        ["\xB5\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xBD"],
        ["\xE5\x81\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB6"],

        ["\xB5\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x80"],
        ["\xE5\x84\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB7"],

        ["\xB5\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x93"],
        ["\xE5\xA6\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB8"],

        ["\xB5\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9C"],
        ["\xE5\xAE\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xB9"],

        ["\xB5\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAF"],
        ["\xE6\x88\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xBA"],

        ["\xB5\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x80"],
        ["\xE6\x8A\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xBB"],

        ["\xB5\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xAC"],
        ["\xE6\x93\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xBC"],

        ["\xB5\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBA"],
        ["\xE6\xAC\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xBD"],

        ["\xB5\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA0"],
        ["\xE7\x8A\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xBE"],

        ["\xB5\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x91"],
        ["\xE7\x96\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xBF"],

        ["\xB5\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x87"],
        ["\xE7\xA5\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC0"],

        ["\xB5\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA9"],
        ["\xE7\xBE\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC1"],

        ["\xB5\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xBB"],
        ["\xE8\x9F\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC2"],

        ["\xB5\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xBC"],
        ["\xE8\xAA\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC3"],

        ["\xB5\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB0"],
        ["\xE8\xAD\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC4"],

        ["\xB5\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAC"],
        ["\xE6\x8E\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC5"],

        ["\xB5\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8A"],
        ["\xE8\x8F\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC6"],

        ["\xB5\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA0"],
        ["\xE9\x9E\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC7"],

        ["\xB5\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x89"],
        ["\xE5\x90\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC8"],

        ["\xB5\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x83"],
        ["\xE5\x90\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xC9"],

        ["\xB5\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAB"],
        ["\xE5\x96\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xCA"],

        ["\xB5\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x94"],
        ["\xE6\xA1\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xCB"],

        ["\xB5\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x98"],
        ["\xE6\xA9\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xCC"],

        ["\xB5\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB0"],
        ["\xE8\xA9\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xCD"],

        ["\xB5\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA7"],
        ["\xE7\xA0\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xCE"],

        ["\xB5\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB5"],
        ["\xE6\x9D\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xCF"],

        ["\xB5\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x8D"],
        ["\xE9\xBB\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD0"],

        ["\xB5\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB4"],
        ["\xE5\x8D\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD1"],

        ["\xB5\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA2"],
        ["\xE5\xAE\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD2"],

        ["\xB5\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x9A"],
        ["\xE8\x84\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD3"],

        ["\xB5\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x90"],
        ["\xE8\x99\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD4"],

        ["\xB5\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x86"],
        ["\xE9\x80\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD5"],

        ["\xB5\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x98"],
        ["\xE4\xB8\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD6"],

        ["\xB5\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x85"],
        ["\xE4\xB9\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD7"],

        ["\xB5\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x87"],
        ["\xE4\xBB\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD8"],

        ["\xB5\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x91"],
        ["\xE4\xBC\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xD9"],

        ["\xB5\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8A"],
        ["\xE5\x8F\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xDA"],

        ["\xB5\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB8"],
        ["\xE5\x90\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xDB"],

        ["\xB5\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xAE"],
        ["\xE5\xAE\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xDC"],

        ["\xB5\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x93"],
        ["\xE5\xBC\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xDD"],

        ["\xB5\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA5"],
        ["\xE6\x80\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xDE"],

        ["\xB5\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x91"],
        ["\xE6\x95\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xDF"],

        ["\xB5\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBD"],
        ["\xE6\x9C\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE0"],

        ["\xB5\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x82"],
        ["\xE6\xB1\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE1"],

        ["\xB5\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB2"],
        ["\xE6\xB1\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE2"],

        ["\xB5\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA3"],
        ["\xE6\xB3\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE3"],

        ["\xB5\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xB8"],
        ["\xE7\x81\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE4"],

        ["\xB5\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x83"],
        ["\xE7\x90\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE5"],

        ["\xB5\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB6"],
        ["\xE7\xA9\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE6"],

        ["\xB5\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAE"],
        ["\xE7\xAA\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE7"],

        ["\xB5\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x88"],
        ["\xE7\xAC\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE8"],

        ["\xB5\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9A"],
        ["\xE7\xB4\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xE9"],

        ["\xB5\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBE"],
        ["\xE7\xB3\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xEA"],

        ["\xB5\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA6"],
        ["\xE7\xB5\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xEB"],

        ["\xB5\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA7"],
        ["\xE6\x97\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xEC"],

        ["\xB5\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9B"],
        ["\xE7\x89\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xED"],

        ["\xB5\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xBB"],
        ["\xE5\x8E\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xEE"],

        ["\xB5\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x85"],
        ["\xE5\xB1\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xEF"],

        ["\xB5\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA8"],
        ["\xE5\xB7\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF0"],

        ["\xB5\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x92"],
        ["\xE6\x8B\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF1"],

        ["\xB5\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xA0"],
        ["\xE6\x8B\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF2"],

        ["\xB5\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x99"],
        ["\xE6\x8C\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF3"],

        ["\xB5\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA0"],
        ["\xE6\xB8\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF4"],

        ["\xB5\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9A"],
        ["\xE8\x99\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF5"],

        ["\xB5\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB1"],
        ["\xE8\xA8\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF6"],

        ["\xB5\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9D"],
        ["\xE8\xB7\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF7"],

        ["\xB5\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB8"],
        ["\xE9\x8B\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF8"],

        ["\xB5\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x81"],
        ["\xE6\xBC\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xF9"],

        ["\xB5\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xA6"],
        ["\xE7\xA6\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xFA"],

        ["\xB5\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x9A"],
        ["\xE9\xAD\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xFB"],

        ["\xB5\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA8"],
        ["\xE4\xBA\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xFC"],

        ["\xB5\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAB"],
        ["\xE4\xBA\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xFD"],

        ["\xB5\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAC"],
        ["\xE4\xBA\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB5\xFE"],

        ["\xB6\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x9B"],
        ["\xE4\xBE\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA1"],

        ["\xB6\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xA0"],
        ["\xE4\xBE\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA2"],

        ["\xB6\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x91"],
        ["\xE5\x83\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA3"],

        ["\xB6\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x87"],
        ["\xE5\x85\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA4"],

        ["\xB6\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB6"],
        ["\xE7\xAB\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA5"],

        ["\xB6\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB1"],
        ["\xE5\x85\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA6"],

        ["\xB6\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB6"],
        ["\xE5\x87\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA7"],

        ["\xB6\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x94"],
        ["\xE5\x8D\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA8"],

        ["\xB6\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA1"],
        ["\xE5\x8C\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xA9"],

        ["\xB6\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xBF"],
        ["\xE5\x8D\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xAA"],

        ["\xB6\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAB"],
        ["\xE5\x8F\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xAB"],

        ["\xB6\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAC"],
        ["\xE5\x96\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xAC"],

        ["\xB6\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x83"],
        ["\xE5\xA2\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xAD"],

        ["\xB6\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA1"],
        ["\xE5\xB3\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xAE"],

        ["\xB6\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB7"],
        ["\xE5\xBC\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xAF"],

        ["\xB6\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8A"],
        ["\xE5\xBD\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB0"],

        ["\xB6\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAF"],
        ["\xE6\x80\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB1"],

        ["\xB6\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x90"],
        ["\xE6\x81\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB2"],

        ["\xB6\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAD"],
        ["\xE6\x81\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB3"],

        ["\xB6\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x9F"],
        ["\xE6\x8C\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB4"],

        ["\xB6\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x99"],
        ["\xE6\x95\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB5"],

        ["\xB6\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x8B"],
        ["\xE6\xA9\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB6"],

        ["\xB6\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x81"],
        ["\xE6\xB3\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB7"],

        ["\xB6\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x82"],
        ["\xE7\x8B\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB8"],

        ["\xB6\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xAD"],
        ["\xE7\x8B\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xB9"],

        ["\xB6\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAF"],
        ["\xE7\x9F\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xBA"],

        ["\xB6\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB8"],
        ["\xE8\x83\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xBB"],

        ["\xB6\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x85"],
        ["\xE8\x84\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xBC"],

        ["\xB6\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x88"],
        ["\xE8\x88\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xBD"],

        ["\xB6\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8E"],
        ["\xE8\x95\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xBE"],

        ["\xB6\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xB7"],
        ["\xE9\x83\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xBF"],

        ["\xB6\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA1"],
        ["\xE9\x8F\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC0"],

        ["\xB6\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xBF"],
        ["\xE9\x9F\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC1"],

        ["\xB6\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x97"],
        ["\xE9\xA5\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC2"],

        ["\xB6\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x9A"],
        ["\xE9\xA9\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC3"],

        ["\xB6\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB0"],
        ["\xE4\xBB\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC4"],

        ["\xB6\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9D"],
        ["\xE5\x87\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC5"],

        ["\x47\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xAD"],
        ["\xE5\xB0\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC8"],

        ["\xB6\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x81"],
        ["\xE6\x9A\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC7"],

        ["\xB6\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAD"],
        ["\xE6\xA5\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC8"],

        ["\xB6\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x80"],
        ["\xE5\xB1\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xC9"],

        ["\xB6\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB2"],
        ["\xE6\x9B\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xCA"],

        ["\xB6\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB5"],
        ["\xE6\xA5\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xCB"],

        ["\xB6\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x89"],
        ["\xE7\x8E\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xCC"],

        ["\xB6\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x90"],
        ["\xE6\xA1\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xCD"],

        ["\xB6\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x81"],
        ["\xE7\xB2\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xCE"],

        ["\xB6\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x85"],
        ["\xE5\x83\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xCF"],

        ["\xB6\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA4"],
        ["\xE5\x8B\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD0"],

        ["\xB6\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x87"],
        ["\xE5\x9D\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD1"],

        ["\xB6\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBE"],
        ["\xE5\xB7\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD2"],

        ["\xB6\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA6"],
        ["\xE9\x8C\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD3"],

        ["\xB6\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA4"],
        ["\xE6\x96\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD4"],

        ["\xB6\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA3"],
        ["\xE6\xAC\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD5"],

        ["\xB6\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xBD"],
        ["\xE6\xAC\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD6"],

        ["\xB6\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB4"],
        ["\xE7\x90\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD7"],

        ["\xB6\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x81"],
        ["\xE7\xA6\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD8"],

        ["\xB6\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBD"],
        ["\xE7\xA6\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xD9"],

        ["\xB6\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8B"],
        ["\xE7\xAD\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xDA"],

        ["\xB6\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8A"],
        ["\xE7\xB7\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xDB"],

        ["\xB6\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB9"],
        ["\xE8\x8A\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xDC"],

        ["\xB6\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8C"],
        ["\xE8\x8F\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xDD"],

        ["\xB6\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBF"],
        ["\xE8\xA1\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xDE"],

        ["\xB6\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x9F"],
        ["\xE8\xA5\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xDF"],

        ["\xB6\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xB9"],
        ["\xE8\xAC\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE0"],

        ["\xB6\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x91"],
        ["\xE8\xBF\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE1"],

        ["\xB6\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x91"],
        ["\xE9\x87\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE2"],

        ["\xB6\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9F"],
        ["\xE5\x90\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE3"],

        ["\xB6\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x80"],
        ["\xE9\x8A\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE4"],

        ["\xB6\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9D"],
        ["\xE4\xB9\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE5"],

        ["\xB6\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xB6"],
        ["\xE5\x80\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE6"],

        ["\xB6\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA5"],
        ["\xE5\x8F\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE7"],

        ["\xB6\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBA"],
        ["\xE5\x8C\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE8"],

        ["\xB6\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x97"],
        ["\xE7\x8B\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xE9"],

        ["\xB6\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x96"],
        ["\xE7\x8E\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xEA"],

        ["\xB6\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA9"],
        ["\xE7\x9F\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xEB"],

        ["\xB6\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA6"],
        ["\xE8\x8B\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xEC"],

        ["\xB6\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAF"],
        ["\xE8\xBA\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xED"],

        ["\xB6\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x86"],
        ["\xE9\xA7\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xEE"],

        ["\xB6\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x88"],
        ["\xE9\xA7\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xEF"],

        ["\xB6\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x92"],
        ["\xE9\xA7\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF0"],

        ["\xB6\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB7"],
        ["\xE5\x85\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF1"],

        ["\xB6\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x9A"],
        ["\xE6\x84\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF2"],

        ["\xB6\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9E"],
        ["\xE8\x99\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF3"],

        ["\xB6\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xB0"],
        ["\xE5\x96\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF4"],

        ["\xB6\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBA"],
        ["\xE7\xA9\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF5"],

        ["\xB6\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB6"],
        ["\xE5\x81\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF6"],

        ["\xB6\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x93"],
        ["\xE5\xAF\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF7"],

        ["\xB6\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x87"],
        ["\xE9\x81\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF8"],

        ["\xB6\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x85"],
        ["\xE9\x9A\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xF9"],

        ["\xB6\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB2"],
        ["\xE4\xB8\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xFA"],

        ["\xB6\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9B"],
        ["\xE6\xAB\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xFB"],

        ["\xB6\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA7"],
        ["\xE9\x87\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xFC"],

        ["\xB6\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x91"],
        ["\xE5\xB1\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xFD"],

        ["\xB6\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x88"],
        ["\xE5\xB1\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB6\xFE"],

        ["\xB7\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x98"],
        ["\xE6\x8E\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA1"],

        ["\xB7\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x9F"],
        ["\xE7\xAA\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA2"],

        ["\xB7\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x93"],
        ["\xE6\xB2\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA3"],

        ["\xB7\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB4"],
        ["\xE9\x9D\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA4"],

        ["\xB7\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA1"],
        ["\xE8\xBD\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA5"],

        ["\xB7\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAA"],
        ["\xE7\xAA\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA6"],

        ["\xB7\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x8A"],
        ["\xE7\x86\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA7"],

        ["\xB7\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x88"],
        ["\xE9\x9A\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA8"],

        ["\xB7\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x82"],
        ["\xE7\xB2\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xA9"],

        ["\xB7\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x97"],
        ["\xE6\xA0\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xAA"],

        ["\xB7\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xB0"],
        ["\xE7\xB9\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xAB"],

        ["\xB7\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x91"],
        ["\xE6\xA1\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xAC"],

        ["\xB7\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xAC"],
        ["\xE9\x8D\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xAD"],

        ["\xB7\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB2"],
        ["\xE5\x8B\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xAE"],

        ["\xB7\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9B"],
        ["\xE5\x90\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xAF"],

        ["\xB7\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAB"],
        ["\xE8\x96\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB0"],

        ["\xB7\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x93"],
        ["\xE8\xA8\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB1"],

        ["\xB7\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA4"],
        ["\xE7\xBE\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB2"],

        ["\xB7\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8D"],
        ["\xE8\xBB\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB3"],

        ["\xB7\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA1"],
        ["\xE9\x83\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB4"],

        ["\xB7\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA6"],
        ["\xE5\x8D\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB5"],

        ["\xB7\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x88"],
        ["\xE8\xA2\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB6"],

        ["\xB7\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x81"],
        ["\xE7\xA5\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB7"],

        ["\xB7\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x82"],
        ["\xE4\xBF\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB8"],

        ["\xB7\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xBE"],
        ["\xE5\x82\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xB9"],

        ["\xB7\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x91"],
        ["\xE5\x88\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xBA"],

        ["\xB7\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x84"],
        ["\xE5\x85\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xBB"],

        ["\xB7\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x93"],
        ["\xE5\x95\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xBC"],

        ["\xB7\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xAD"],
        ["\xE5\x9C\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xBD"],

        ["\xB7\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAA"],
        ["\xE7\x8F\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xBE"],

        ["\xB7\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x8B"],
        ["\xE5\x9E\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xBF"],

        ["\xB7\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x91"],
        ["\xE5\xA5\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC0"],

        ["\xB7\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA2"],
        ["\xE5\xBD\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC1"],

        ["\xB7\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x84"],
        ["\xE5\xBE\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC2"],

        ["\xB7\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB5"],
        ["\xE6\x81\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC3"],

        ["\xB7\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB6"],
        ["\xE6\x85\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC4"],

        ["\xB7\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA7"],
        ["\xE6\x85\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC5"],

        ["\xB7\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA9"],
        ["\xE6\x86\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC6"],

        ["\xB7\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB2"],
        ["\xE6\x8E\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC7"],

        ["\xB7\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xBA"],
        ["\xE6\x90\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC8"],

        ["\xB7\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xAC"],
        ["\xE6\x95\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xC9"],

        ["\xB7\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAF"],
        ["\xE6\x99\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xCA"],

        ["\xB7\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x82"],
        ["\xE6\xA1\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xCB"],

        ["\xB7\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x93"],
        ["\xE6\xB8\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xCC"],

        ["\xB7\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA6"],
        ["\xE7\x95\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xCD"],

        ["\xB7\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBD"],
        ["\xE7\xA8\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xCE"],

        ["\xB7\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBB"],
        ["\xE7\xB3\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xCF"],

        ["\xB7\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8C"],
        ["\xE7\xB5\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD0"],

        ["\xB7\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x99"],
        ["\xE7\xB6\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD1"],

        ["\xB7\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8B"],
        ["\xE7\xB9\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD2"],

        ["\xB7\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAB"],
        ["\xE7\xBD\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD3"],

        ["\xB7\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x8E"],
        ["\xE8\x8C\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD4"],

        ["\xB7\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x8A"],
        ["\xE8\x8D\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD5"],

        ["\xB7\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8D"],
        ["\xE8\x9B\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD6"],

        ["\xB7\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x88"],
        ["\xE8\xA8\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD7"],

        ["\xB7\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA3"],
        ["\xE8\xA9\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD8"],

        ["\xB7\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xA6"],
        ["\xE8\xAD\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xD9"],

        ["\xB7\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBD"],
        ["\xE8\xBB\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xDA"],

        ["\xF0\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x9A"],
        ["\xE9\xA0\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF4"],

        ["\xB7\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x8F"],
        ["\xE9\xB6\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xDC"],

        ["\xB7\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB8"],
        ["\xE8\x8A\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xDD"],

        ["\xB7\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x8E"],
        ["\xE8\xBF\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xDE"],

        ["\xB7\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA8"],
        ["\xE9\xAF\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xDF"],

        ["\xB7\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x87"],
        ["\xE5\x8A\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE0"],

        ["\xB7\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9F"],
        ["\xE6\x88\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE1"],

        ["\xB7\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x83"],
        ["\xE6\x92\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE2"],

        ["\xB7\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x80"],
        ["\xE6\xBF\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE3"],

        ["\xB7\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x99"],
        ["\xE9\x9A\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE4"],

        ["\xB7\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x81"],
        ["\xE6\xA1\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE5"],

        ["\xB7\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x91"],
        ["\xE5\x82\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE6"],

        ["\xB7\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA0"],
        ["\xE6\xAC\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE7"],

        ["\xB7\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBA"],
        ["\xE6\xB1\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE8"],

        ["\xB7\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x94"],
        ["\xE6\xBD\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xE9"],

        ["\xB7\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB4"],
        ["\xE7\xA9\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xEA"],

        ["\xB7\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x90"],
        ["\xE7\xB5\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xEB"],

        ["\xB7\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x80"],
        ["\xE8\xA1\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xEC"],

        ["\xB7\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA3"],
        ["\xE8\xA8\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xED"],

        ["\xB7\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x88"],
        ["\xE6\x9C\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xEE"],

        ["\xB7\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB6"],
        ["\xE4\xBB\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xEF"],

        ["\xB7\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xB9"],
        ["\xE5\x80\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF0"],

        ["\xB7\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA6"],
        ["\xE5\x80\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF1"],

        ["\xB7\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xA5"],
        ["\xE5\x81\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF2"],

        ["\xB7\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xBC"],
        ["\xE5\x85\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF3"],

        ["\xB7\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB8"],
        ["\xE5\x88\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF4"],

        ["\xB7\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA3"],
        ["\xE5\x89\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF5"],

        ["\xB7\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA7"],
        ["\xE5\x96\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF6"],

        ["\xB7\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8F"],
        ["\xE5\x9C\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF7"],

        ["\xB7\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x85"],
        ["\xE5\xA0\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF8"],

        ["\xB7\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x8C"],
        ["\xE5\xAB\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xF9"],

        ["\xB7\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBA"],
        ["\xE5\xBB\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xFA"],

        ["\xB7\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xB2"],
        ["\xE6\x86\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xFB"],

        ["\xB7\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB8"],
        ["\xE6\x87\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xFC"],

        ["\xB7\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB3"],
        ["\xE6\x8B\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xFD"],

        ["\xB7\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB2"],
        ["\xE6\x8D\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xFE"],

        ["\xB8\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9C"],
        ["\xE6\xA4\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA1"],

        ["\xB8\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA9"],
        ["\xE6\xA8\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA2"],

        ["\xB8\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xBD"],
        ["\xE7\x89\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA3"],

        ["\xB8\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAC"],
        ["\xE7\x8A\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA4"],

        ["\xB8\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAE"],
        ["\xE7\x8C\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA5"],

        ["\xB8\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x94"],
        ["\xE7\xA0\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA6"],

        ["\xB8\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAF"],
        ["\xE7\xA1\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA7"],

        ["\xB8\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB9"],
        ["\xE7\xB5\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA8"],

        ["\xB8\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x8C"],
        ["\xE7\x9C\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xA9"],

        ["\xB8\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA9"],
        ["\xE8\x82\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xAA"],

        ["\xB8\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8B"],
        ["\xE8\xA6\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xAB"],

        ["\xB8\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x99"],
        ["\xE8\xAC\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xAC"],

        ["\xB8\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA2"],
        ["\xE8\xB3\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xAD"],

        ["\xB8\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x92"],
        ["\xE8\xBB\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xAE"],

        ["\xB8\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA3"],
        ["\xE9\x81\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xAF"],

        ["\xB8\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xB5"],
        ["\xE9\x8D\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB0"],

        ["\xB8\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xBA"],
        ["\xE9\x99\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB1"],

        ["\xB8\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x95"],
        ["\xE9\xA1\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB2"],

        ["\xB8\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x93"],
        ["\xE9\xA8\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB3"],

        ["\xB8\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xB8"],
        ["\xE9\xB9\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB4"],

        ["\xB8\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x83"],
        ["\xE5\x85\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB5"],

        ["\xB8\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x9F"],
        ["\xE5\x8E\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB6"],

        ["\xB8\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB3"],
        ["\xE5\x8E\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB7"],

        ["\xB8\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBB"],
        ["\xE5\xB9\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB8"],

        ["\xB8\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA6"],
        ["\xE5\xBC\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xB9"],

        ["\xB8\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9B"],
        ["\xE6\xB8\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xBA"],

        ["\xB8\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x90"],
        ["\xE6\xBA\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xBB"],

        ["\xB8\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x84"],
        ["\xE7\x8E\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xBC"],

        ["\xB8\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xBE"],
        ["\xE7\x8F\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xBD"],

        ["\xB8\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x83"],
        ["\xE7\xB5\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xBE"],

        ["\xB8\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB7"],
        ["\xE8\x88\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xBF"],

        ["\xB8\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x80"],
        ["\xE8\xA8\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC0"],

        ["\xB8\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xBA"],
        ["\xE8\xAB\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC1"],

        ["\xB8\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x90"],
        ["\xE9\x99\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC2"],

        ["\xB8\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8E"],
        ["\xE4\xB9\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC3"],

        ["\xB8\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8B"],
        ["\xE5\x80\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC4"],

        ["\xB8\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA4"],
        ["\xE5\x8F\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC5"],

        ["\xB8\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBC"],
        ["\xE5\x91\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC6"],

        ["\xB8\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBA"],
        ["\xE5\x9B\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC7"],

        ["\xB8\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x91"],
        ["\xE5\xA7\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC8"],

        ["\xB8\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA4"],
        ["\xE5\xAD\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xC9"],

        ["\xB8\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB1"],
        ["\xE5\xB7\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xCA"],

        ["\xB8\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xAB"],
        ["\xE5\xBA\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xCB"],

        ["\xB8\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA7"],
        ["\xE5\xBC\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xCC"],

        ["\xB8\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB8"],
        ["\xE6\x88\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xCD"],

        ["\xB8\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x85"],
        ["\xE6\x95\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xCE"],

        ["\xB8\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xAF"],
        ["\xE6\x9E\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xCF"],

        ["\xB8\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x96"],
        ["\xE6\xB9\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD0"],

        ["\xB8\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x90"],
        ["\xE7\x8B\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD1"],

        ["\xB8\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x8A"],
        ["\xE7\xB3\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD2"],

        ["\xB8\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB4"],
        ["\xE8\xA2\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD3"],

        ["\xB8\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA1"],
        ["\xE8\x82\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD4"],

        ["\xB8\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA1"],
        ["\xE8\x83\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD5"],

        ["\xB8\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB0"],
        ["\xE8\x8F\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD6"],

        ["\xB8\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x8E"],
        ["\xE8\x99\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD7"],

        ["\xB8\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x87"],
        ["\xE8\xAA\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD8"],

        ["\xB8\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA8"],
        ["\xE8\xB7\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xD9"],

        ["\xB8\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB7"],
        ["\xE9\x88\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xDA"],

        ["\xB8\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x87"],
        ["\xE9\x9B\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xDB"],

        ["\xB8\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xA7"],
        ["\xE9\xA1\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xDC"],

        ["\xB8\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x93"],
        ["\xE9\xBC\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xDD"],

        ["\xB8\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x94"],
        ["\xE4\xBA\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xDE"],

        ["\xB8\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x92"],
        ["\xE4\xBA\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xDF"],

        ["\xB8\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8D"],
        ["\xE4\xBC\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE0"],

        ["\xB8\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x88"],
        ["\xE5\x8D\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE1"],

        ["\xB8\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x89"],
        ["\xE5\x91\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE2"],

        ["\xB8\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBE"],
        ["\xE5\x90\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE3"],

        ["\xB8\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xAF"],
        ["\xE5\xA8\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE4"],

        ["\xB8\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8C"],
        ["\xE5\xBE\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE5"],

        ["\xB8\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA1"],
        ["\xE5\xBE\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE6"],

        ["\xB8\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9F"],
        ["\xE6\x82\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE7"],

        ["\xB8\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA7"],
        ["\xE6\xA2\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE8"],

        ["\xB8\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x8E"],
        ["\xE6\xAA\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xE9"],

        ["\xB8\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9A"],
        ["\xE7\x91\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xEA"],

        ["\xB8\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x81"],
        ["\xE7\xA2\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xEB"],

        ["\xB8\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x9E"],
        ["\xE8\xAA\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xEC"],

        ["\xB8\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA4"],
        ["\xE8\xAA\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xED"],

        ["\xB8\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB7"],
        ["\xE8\xAD\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xEE"],

        ["\xB8\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x90"],
        ["\xE9\x86\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xEF"],

        ["\xB8\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9E"],
        ["\xE4\xB9\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF0"],

        ["\xB8\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x89"],
        ["\xE9\xAF\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF1"],

        ["\xB8\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA4"],
        ["\xE4\xBA\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF2"],

        ["\xB8\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBC"],
        ["\xE4\xBD\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF3"],

        ["\xB8\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAF"],
        ["\xE4\xBE\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF4"],

        ["\xB8\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x99"],
        ["\xE5\x80\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF5"],

        ["\xB8\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x96"],
        ["\xE5\x80\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF6"],

        ["\xB8\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x89"],
        ["\xE5\x85\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF7"],

        ["\xB8\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAC"],
        ["\xE5\x85\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF8"],

        ["\xB8\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x9F"],
        ["\xE5\x8A\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xF9"],

        ["\xB8\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB9"],
        ["\xE5\x8A\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xFA"],

        ["\xB8\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBE"],
        ["\xE5\x8B\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xFB"],

        ["\xB8\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x9A"],
        ["\xE5\x8E\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xFC"],

        ["\xB8\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA3"],
        ["\xE5\x8F\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xFD"],

        ["\xB8\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x91"],
        ["\xE5\x90\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB8\xFE"],

        ["\xB9\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8E"],
        ["\xE5\x90\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA1"],

        ["\xB9\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x89"],
        ["\xE5\x96\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA2"],

        ["\xB9\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x91"],
        ["\xE5\x9D\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA3"],

        ["\xB9\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA2"],
        ["\xE5\x9E\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA4"],

        ["\xB9\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xBD"],
        ["\xE5\xA5\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA5"],

        ["\xB9\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x94"],
        ["\xE5\xAD\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA6"],

        ["\xB9\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9D"],
        ["\xE5\xAD\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA7"],

        ["\xB9\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8F"],
        ["\xE5\xAE\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA8"],

        ["\xB9\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA5"],
        ["\xE5\xB7\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xA9"],

        ["\xB9\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA7"],
        ["\xE5\xB7\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xAA"],

        ["\xB9\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB7"],
        ["\xE5\xB7\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xAB"],

        ["\xB9\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB8"],
        ["\xE5\xB9\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xAC"],

        ["\xB9\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x83"],
        ["\xE5\xBA\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xAD"],

        ["\xB9\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x9A"],
        ["\xE5\xBA\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xAE"],

        ["\xB9\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB7"],
        ["\xE5\xBA\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xAF"],

        ["\xB9\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x98"],
        ["\xE5\xBC\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB0"],

        ["\xB9\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x92"],
        ["\xE6\x81\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB1"],

        ["\xB9\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8C"],
        ["\xE6\x85\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB2"],

        ["\xB9\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x97"],
        ["\xE6\x8A\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB3"],

        ["\xB9\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x98"],
        ["\xE6\x8B\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB4"],

        ["\xB9\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA7"],
        ["\xE6\x8E\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB5"],

        ["\xB9\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBB"],
        ["\xE6\x94\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB6"],

        ["\x50\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x82"],
        ["\xE6\x98\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x50\xFC"],

        ["\xB9\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x83"],
        ["\xE6\x99\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB8"],

        ["\xB9\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB4"],
        ["\xE6\x9B\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xB9"],

        ["\xB9\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAD"],
        ["\xE6\x9D\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xBA"],

        ["\xB9\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA1"],
        ["\xE6\xA0\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xBB"],

        ["\xB9\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x97"],
        ["\xE6\xA2\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xBC"],

        ["\xB9\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8B"],
        ["\xE6\xA7\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xBD"],

        ["\xB9\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9F"],
        ["\xE6\xB1\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xBE"],

        ["\xB9\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAA"],
        ["\xE6\xB4\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xBF"],

        ["\xB9\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA9"],
        ["\xE6\xB5\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC0"],

        ["\xB9\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAF"],
        ["\xE6\xB8\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC1"],

        ["\xB9\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9D"],
        ["\xE6\xBA\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC2"],

        ["\xB9\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB2"],
        ["\xE7\x94\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC3"],

        ["\xB9\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x87"],
        ["\xE7\x9A\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC4"],

        ["\xB9\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAC"],
        ["\xE7\xA1\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC5"],

        ["\xB9\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBF"],
        ["\xE7\xA8\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC6"],

        ["\xB9\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA0"],
        ["\xE7\xB3\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC7"],

        ["\xB9\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x85"],
        ["\xE7\xB4\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC8"],

        ["\xB9\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x98"],
        ["\xE7\xB4\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xC9"],

        ["\xB9\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9E"],
        ["\xE7\xB5\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xCA"],

        ["\xB9\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB1"],
        ["\xE7\xB6\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xCB"],

        ["\xB9\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x95"],
        ["\xE8\x80\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xCC"],

        ["\xB9\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x83"],
        ["\xE8\x80\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xCD"],

        ["\xB9\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAF"],
        ["\xE8\x82\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xCE"],

        ["\xB9\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB1"],
        ["\xE8\x82\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xCF"],

        ["\xB9\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x94"],
        ["\xE8\x85\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD0"],

        ["\xB9\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x8F"],
        ["\xE8\x86\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD1"],

        ["\xB9\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAA"],
        ["\xE8\x88\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD2"],

        ["\xB9\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x92"],
        ["\xE8\x8D\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD3"],

        ["\xB9\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x8C"],
        ["\xE8\xA1\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD4"],

        ["\xB9\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA1"],
        ["\xE8\xA1\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD5"],

        ["\xB9\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9B"],
        ["\xE8\xAC\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD6"],

        ["\xB9\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA2"],
        ["\xE8\xB2\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD7"],

        ["\xB9\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBC"],
        ["\xE8\xB3\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD8"],

        ["\xB9\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x8A"],
        ["\xE9\x83\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xD9"],

        ["\xB9\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB5"],
        ["\xE9\x85\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xDA"],

        ["\xB9\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xB1"],
        ["\xE9\x89\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xDB"],

        ["\xE2\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xBF"],
        ["\xE7\xA0\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],

        ["\xB9\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBC"],
        ["\xE9\x8B\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xDD"],

        ["\xB9\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA4"],
        ["\xE9\x96\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xDE"],

        ["\xB9\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8D"],
        ["\xE9\x99\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xDF"],

        ["\xB9\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x85"],
        ["\xE9\xA0\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE0"],

        ["\xB9\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x99"],
        ["\xE9\xA6\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE1"],

        ["\xB9\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x98"],
        ["\xE9\xAB\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE2"],

        ["\xB9\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xBB"],
        ["\xE9\xB4\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE3"],

        ["\xB9\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x9B"],
        ["\xE5\x89\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE4"],

        ["\xB9\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAB"],
        ["\xE5\x8A\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE5"],

        ["\xB9\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB7"],
        ["\xE5\x8F\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE6"],

        ["\xB9\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x88"],
        ["\xE5\x90\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE7"],

        ["\xB9\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x95"],
        ["\xE5\xA3\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE8"],

        ["\xB9\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB7"],
        ["\xE6\x8B\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xE9"],

        ["\xB9\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA0"],
        ["\xE6\xBF\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xEA"],

        ["\xB9\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAA"],
        ["\xE8\xB1\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xEB"],

        ["\xB9\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x9F"],
        ["\xE8\xBD\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xEC"],

        ["\x6F\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xB9"],
        ["\xE9\xBA\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xC3"],

        ["\xB9\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8B"],
        ["\xE5\x85\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xEE"],

        ["\xB9\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xBB"],
        ["\xE5\x88\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xEF"],

        ["\xB9\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x8A"],
        ["\xE5\x91\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF0"],

        ["\xB9\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBD"],
        ["\xE5\x9B\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF1"],

        ["\xB9\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x80"],
        ["\xE7\xA9\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF2"],

        ["\xB9\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB7"],
        ["\xE9\x85\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF3"],

        ["\xB9\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA0"],
        ["\xE9\xB5\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF4"],

        ["\xB9\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x92"],
        ["\xE9\xBB\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF5"],

        ["\xB9\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x84"],
        ["\xE7\x8D\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF6"],

        ["\xB9\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x89"],
        ["\xE6\xBC\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF7"],

        ["\xB9\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB0"],
        ["\xE8\x85\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF8"],

        ["\xB9\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x91"],
        ["\xE7\x94\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xF9"],

        ["\xB9\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBD"],
        ["\xE5\xBF\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xFA"],

        ["\xB9\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9A"],
        ["\xE6\x83\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xFB"],

        ["\xB9\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xA8"],
        ["\xE9\xAA\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xFC"],

        ["\xB9\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x9B"],
        ["\xE7\x8B\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xFD"],

        ["\xB9\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBC"],
        ["\xE8\xBE\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xFE"],

        ["\xBA\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA4"],
        ["\xE6\xAD\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA1"],

        ["\xBA\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x83"],
        ["\xE9\xA0\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA2"],

        ["\xBA\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8A"],
        ["\xE4\xBB\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA3"],

        ["\xBA\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB0"],
        ["\xE5\x9B\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA4"],

        ["\xBA\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA4"],
        ["\xE5\x9D\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA5"],

        ["\xBA\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBE"],
        ["\xE5\xA2\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA6"],

        ["\xBA\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x9A"],
        ["\xE5\xA9\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA7"],

        ["\xBA\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA8"],
        ["\xE6\x81\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA8"],

        ["\xBA\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x87"],
        ["\xE6\x87\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xA9"],

        ["\xBA\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8F"],
        ["\xE6\x98\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xAA"],

        ["\xBA\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x86"],
        ["\xE6\x98\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xAB"],

        ["\xBA\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB9"],
        ["\xE6\xA0\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xAC"],

        ["\xBA\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB1"],
        ["\xE6\xA2\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xAD"],

        ["\xBA\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB7"],
        ["\xE6\xB7\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xAE"],

        ["\xBA\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x95"],
        ["\xE7\x97\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xAF"],

        ["\xBA\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBA"],
        ["\xE7\xB4\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB0"],

        ["\xBA\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAE"],
        ["\xE8\x89\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB1"],

        ["\xBA\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x82"],
        ["\xE9\xAD\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB2"],

        ["\xBA\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9B"],
        ["\xE4\xBA\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB3"],

        ["\xBA\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x90"],
        ["\xE4\xBD\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB4"],

        ["\xBA\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x89"],
        ["\xE5\x8F\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB5"],

        ["\xBA\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x86"],
        ["\xE5\x94\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB6"],

        ["\xBA\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAF"],
        ["\xE5\xB5\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB7"],

        ["\xBA\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA6"],
        ["\xE5\xB7\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB8"],

        ["\xBA\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xAE"],
        ["\xE5\xB7\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xB9"],

        ["\xBA\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBB"],
        ["\xE6\x9F\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xBA"],

        ["\xBA\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x99"],
        ["\xE6\xB2\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xBB"],

        ["\xBA\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB3"],
        ["\xE7\x91\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xBC"],

        ["\xBA\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x82"],
        ["\xE7\xA0\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xBD"],

        ["\xBA\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x90"],
        ["\xE8\xA9\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xBE"],

        ["\xBA\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x96"],
        ["\xE9\x8E\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xBF"],

        ["\xBA\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9F"],
        ["\xE8\xA3\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC0"],

        ["\xBA\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x90"],
        ["\xE5\x9D\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC1"],

        ["\xBA\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA7"],
        ["\xE5\xBA\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC2"],

        ["\xBA\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xAB"],
        ["\xE6\x8C\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC3"],

        ["\xBA\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB5"],
        ["\xE5\x82\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC4"],

        ["\xBA\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xAC"],
        ["\xE5\x82\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC5"],

        ["\xBA\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8D"],
        ["\xE5\x86\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC6"],

        ["\xBA\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x80"],
        ["\xE6\x9C\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC7"],

        ["\xBA\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x89"],
        ["\xE5\x93\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC8"],

        ["\xBA\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x9E"],
        ["\xE5\xA1\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xC9"],

        ["\xBA\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBB"],
        ["\xE5\xA6\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xCA"],

        ["\xBA\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB0"],
        ["\xE5\xAE\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xCB"],

        ["\xBA\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA9"],
        ["\xE5\xBD\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xCC"],

        ["\xBA\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8D"],
        ["\xE6\x89\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xCD"],

        ["\xBA\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA1"],
        ["\xE6\x8E\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xCE"],

        ["\xBA\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xBD"],
        ["\xE6\xA0\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xCF"],

        ["\xBA\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB3"],
        ["\xE6\xAD\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD0"],

        ["\xBA\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x88"],
        ["\xE6\xB8\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD1"],

        ["\xBA\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xBD"],
        ["\xE7\x81\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD2"],

        ["\xBA\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x87"],
        ["\xE9\x87\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD3"],

        ["\xBA\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x80"],
        ["\xE7\x8A\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD4"],

        ["\xBA\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x95"],
        ["\xE7\xA0\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD5"],

        ["\xBA\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA6"],
        ["\xE7\xA0\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD6"],

        ["\xBA\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xAD"],
        ["\xE7\xA5\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD7"],

        ["\xBA\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x8E"],
        ["\xE6\x96\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD8"],

        ["\xBA\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB0"],
        ["\xE7\xB4\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xD9"],

        ["\xBA\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x9C"],
        ["\xE8\x8F\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xDA"],

        ["\xBA\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x81"],
        ["\xE8\xA3\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xDB"],

        ["\xBA\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x89"],
        ["\xE8\xBC\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xDC"],

        ["\xBA\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x9B"],
        ["\xE9\x9A\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xDD"],

        ["\xBA\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA4"],
        ["\xE5\x89\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xDE"],

        ["\xBA\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA8"],
        ["\xE5\x9C\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xDF"],

        ["\xBA\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x90"],
        ["\xE6\x9D\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE0"],

        ["\xBA\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAA"],
        ["\xE7\xBD\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE1"],

        ["\xBA\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA1"],
        ["\xE8\xB2\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE2"],

        ["\xBA\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB4"],
        ["\xE5\x86\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE3"],

        ["\xBA\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x82"],
        ["\xE5\x9D\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE4"],

        ["\xBA\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAA"],
        ["\xE9\x98\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE5"],

        ["\xBA\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xBA"],
        ["\xE5\xA0\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE6"],

        ["\xBA\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x8A"],
        ["\xE6\xA6\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE7"],

        ["\xBA\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xB4"],
        ["\xE8\x82\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE8"],

        ["\xBA\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB2"],
        ["\xE5\x92\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xE9"],

        ["\xBA\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x8E"],
        ["\xE5\xB4\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xEA"],

        ["\xBA\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xBC"],
        ["\xE5\x9F\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xEB"],

        ["\xBA\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x95"],
        ["\xE7\xA2\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xEC"],

        ["\xBA\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xBA"],
        ["\xE9\xB7\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xED"],

        ["\xBA\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9C"],
        ["\xE4\xBD\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xEE"],

        ["\xBA\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8A"],
        ["\xE5\x89\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xEF"],

        ["\xBA\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8B"],
        ["\xE5\x92\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF0"],

        ["\xBA\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xBE"],
        ["\xE6\x90\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF1"],

        ["\xBA\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA8"],
        ["\xE6\x98\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF2"],

        ["\xBA\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x94"],
        ["\xE6\x9C\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF3"],

        ["\xBA\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB5"],
        ["\xE6\x9F\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF4"],

        ["\xBA\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x84"],
        ["\xE7\xAA\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF5"],

        ["\xBA\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x96"],
        ["\xE7\xAD\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF6"],

        ["\xBA\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA2"],
        ["\xE7\xB4\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF7"],

        ["\xBA\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAF"],
        ["\xE9\x8C\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF8"],

        ["\xBA\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9C"],
        ["\xE6\xA1\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xF9"],

        ["\xBA\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAD"],
        ["\xE9\xAE\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xFA"],

        ["\xBA\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB9"],
        ["\xE7\xAC\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xFB"],

        ["\xBA\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x99"],
        ["\xE5\x8C\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xFC"],

        ["\xBA\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8A"],
        ["\xE5\x86\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xFD"],

        ["\xBA\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB7"],
        ["\xE5\x88\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBA\xFE"],

        ["\xBB\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9F"],
        ["\xE5\xAF\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA1"],

        ["\xBB\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB6"],
        ["\xE6\x8B\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA2"],

        ["\xBB\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAE"],
        ["\xE6\x92\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA3"],

        ["\xBB\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA6"],
        ["\xE6\x93\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA4"],

        ["\xBB\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAD"],
        ["\xE6\x9C\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA5"],

        ["\xBB\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBA"],
        ["\xE6\xAE\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA6"],

        ["\xBB\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA9"],
        ["\xE8\x96\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA7"],

        ["\xBB\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x91"],
        ["\xE9\x9B\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA8"],

        ["\xBB\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x90"],
        ["\xE7\x9A\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xA9"],

        ["\xBB\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x96"],
        ["\xE9\xAF\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xAA"],

        ["\xBB\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8C"],
        ["\xE6\x8D\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xAB"],

        ["\xBB\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x86"],
        ["\xE9\x8C\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xAC"],

        ["\xBB\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAB"],
        ["\xE9\xAE\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xAD"],

        ["\xBB\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xBF"],
        ["\xE7\x9A\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xAE"],

        ["\xBB\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x92"],
        ["\xE6\x99\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xAF"],

        ["\xBB\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x89"],
        ["\xE4\xB8\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB0"],

        ["\xBB\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x98"],
        ["\xE5\x82\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB1"],

        ["\xBB\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x82"],
        ["\xE5\x8F\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB2"],

        ["\xBB\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB1"],
        ["\xE5\xB1\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB3"],

        ["\xBB\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA8"],
        ["\xE6\x83\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB4"],

        ["\xBB\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x92"],
        ["\xE6\x92\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB5"],

        ["\xBB\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA3"],
        ["\xE6\x95\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB6"],

        ["\xBB\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9F"],
        ["\xE6\xA1\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB7"],

        ["\xBB\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA6"],
        ["\xE7\x87\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB8"],

        ["\xBB\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8A"],
        ["\xE7\x8F\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xB9"],

        ["\xBB\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA3"],
        ["\xE7\x94\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xBA"],

        ["\xBB\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x97"],
        ["\xE7\xAE\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xBB"],

        ["\xBB\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x82"],
        ["\xE7\xBA\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xBC"],

        ["\xBB\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x95"],
        ["\xE8\x9A\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xBD"],

        ["\xBB\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x83"],
        ["\xE8\xAE\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xBE"],

        ["\xBB\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9B"],
        ["\xE8\xB3\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xBF"],

        ["\xBB\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB8"],
        ["\xE9\x85\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC0"],

        ["\xBB\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x90"],
        ["\xE9\xA4\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC1"],

        ["\xBB\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAC"],
        ["\xE6\x96\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC2"],

        ["\xBB\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xAB"],
        ["\xE6\x9A\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC3"],

        ["\xBB\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8B"],
        ["\xE6\xAE\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC4"],

        ["\xBB\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x95"],
        ["\xE4\xBB\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC5"],

        ["\xBB\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x94"],
        ["\xE4\xBB\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC6"],

        ["\xBB\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBA"],
        ["\xE4\xBC\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC7"],

        ["\xBB\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBF"],
        ["\xE4\xBD\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC8"],

        ["\xBB\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xBA"],
        ["\xE5\x88\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xC9"],

        ["\xBB\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB8"],
        ["\xE5\x8F\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xCA"],

        ["\xBB\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB2"],
        ["\xE5\x8F\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xCB"],

        ["\xBB\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xA3"],
        ["\xE5\x97\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xCC"],

        ["\xBB\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9B"],
        ["\xE5\x9B\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xCD"],

        ["\xBB\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAB"],
        ["\xE5\xA3\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xCE"],

        ["\xBB\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x8B"],
        ["\xE5\xA7\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xCF"],

        ["\xBB\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x89"],
        ["\xE5\xA7\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD0"],

        ["\xBB\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xBF"],
        ["\xE5\xA7\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD1"],

        ["\xBB\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x90"],
        ["\xE5\xAD\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD2"],

        ["\xBB\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8D"],
        ["\xE5\xB1\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD3"],

        ["\xBB\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x82"],
        ["\xE5\xB8\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD4"],

        ["\xBB\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAB"],
        ["\xE5\xB8\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD5"],

        ["\xBB\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x97"],
        ["\xE5\xBF\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD6"],

        ["\xBB\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9D"],
        ["\xE6\x80\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD7"],

        ["\xBB\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x87"],
        ["\xE6\x8C\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD8"],

        ["\xBB\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAF"],
        ["\xE6\x94\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xD9"],

        ["\xBB\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9C"],
        ["\xE5\xAD\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xDA"],

        ["\xBB\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAF"],
        ["\xE6\x96\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xDB"],

        ["\xBB\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xBD"],
        ["\xE6\x96\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xDC"],

        ["\xBB\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA8"],
        ["\xE6\x97\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xDD"],

        ["\xBB\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9D"],
        ["\xE6\x9E\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xDE"],

        ["\xBB\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA2"],
        ["\xE6\xAD\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xDF"],

        ["\xBB\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xBB"],
        ["\xE6\xAD\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE0"],

        ["\xBB\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x8F"],
        ["\xE6\xB0\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE1"],

        ["\xBB\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x85"],
        ["\xE7\x8D\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE2"],

        ["\xBB\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x89"],
        ["\xE7\xA5\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE3"],

        ["\xBB\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x81"],
        ["\xE7\xA7\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE4"],

        ["\xBB\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB8"],
        ["\xE7\xB3\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE5"],

        ["\xBB\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x99"],
        ["\xE7\xB4\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE6"],

        ["\xBB\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAB"],
        ["\xE7\xB4\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE7"],

        ["\xBB\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA2"],
        ["\xE8\x82\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE8"],

        ["\xBB\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x82"],
        ["\xE8\x84\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xE9"],

        ["\xBB\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xB3"],
        ["\xE8\x87\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xEA"],

        ["\xBB\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x96"],
        ["\xE8\xA6\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xEB"],

        ["\xBB\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x9E"],
        ["\xE8\xA9\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xEC"],

        ["\xBB\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA9"],
        ["\xE8\xA9\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xED"],

        ["\xBB\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA6"],
        ["\xE8\xA9\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xEE"],

        ["\xBB\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x8C"],
        ["\xE8\xAA\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xEF"],

        ["\xBB\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAE"],
        ["\xE8\xAB\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF0"],

        ["\xBB\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x87"],
        ["\xE8\xB3\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF1"],

        ["\xBB\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9C"],
        ["\xE8\xB3\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF2"],

        ["\xBB\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8C"],
        ["\xE9\x9B\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF3"],

        ["\xBB\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBC"],
        ["\xE9\xA3\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF4"],

        ["\xBB\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xAF"],
        ["\xE6\xAD\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF5"],

        ["\xBB\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8B"],
        ["\xE4\xBA\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF6"],

        ["\xBB\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xBC"],
        ["\xE4\xBC\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF7"],

        ["\xBB\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8D"],
        ["\xE4\xBE\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF8"],

        ["\xBB\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x90"],
        ["\xE5\x85\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xF9"],

        ["\xBB\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x97"],
        ["\xE5\xAD\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xFA"],

        ["\xBB\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBA"],
        ["\xE5\xAF\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xFB"],

        ["\xBB\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x88"],
        ["\xE6\x85\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xFC"],

        ["\xBB\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x81"],
        ["\xE6\x8C\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xFD"],

        ["\xBB\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x82"],
        ["\xE6\x99\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBB\xFE"],

        ["\xBC\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xA1"],
        ["\xE6\xAC\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA1"],

        ["\xBC\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x8B"],
        ["\xE6\xBB\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA2"],

        ["\xBC\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBB"],
        ["\xE6\xB2\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA3"],

        ["\xBC\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBE"],
        ["\xE7\x88\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA4"],

        ["\xBC\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xBD"],
        ["\xE7\x92\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA5"],

        ["\xBC\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x94"],
        ["\xE7\x97\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA6"],

        ["\xBC\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x81"],
        ["\xE7\xA3\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA7"],

        ["\xBC\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBA"],
        ["\xE7\xA4\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA8"],

        ["\xBC\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x8C"],
        ["\xE8\x80\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xA9"],

        ["\xBC\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB3"],
        ["\xE8\x80\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xAA"],

        ["\xBC\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xAA"],
        ["\xE8\x87\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xAB"],

        ["\xBC\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x94"],
        ["\xE8\x92\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xAC"],

        ["\xBC\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9E"],
        ["\xE8\xBE\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xAD"],

        ["\xBC\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x90"],
        ["\xE6\xB1\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xAE"],

        ["\xBC\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xBF"],
        ["\xE9\xB9\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xAF"],

        ["\xBC\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8F"],
        ["\xE5\xBC\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB0"],

        ["\xBC\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x98"],
        ["\xE8\xAD\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB1"],

        ["\xBC\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xAB"],
        ["\xE9\xB4\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB2"],

        ["\xBC\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xBA"],
        ["\xE7\xAB\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB3"],

        ["\xBC\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xB8"],
        ["\xE8\xBB\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB4"],

        ["\xBC\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8D"],
        ["\xE5\xAE\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB5"],

        ["\xBC\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xAB"],
        ["\xE9\x9B\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB6"],

        ["\xBC\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x83"],
        ["\xE4\xB8\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB7"],

        ["\xBC\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB1"],
        ["\xE5\x8F\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB8"],

        ["\xBC\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB7"],
        ["\xE5\x9F\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xB9"],

        ["\xBC\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB1"],
        ["\xE5\xA4\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xBA"],

        ["\xBC\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x89"],
        ["\xE5\xAB\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xBB"],

        ["\xBC\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA4"],
        ["\xE5\xAE\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xBC"],

        ["\xBC\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x89"],
        ["\xE6\x82\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xBD"],

        ["\xBC\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xBF"],
        ["\xE6\xB9\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xBE"],

        ["\xBC\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x86"],
        ["\xE6\xBC\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xBF"],

        ["\xBC\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBE"],
        ["\xE7\x96\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC0"],

        ["\xBC\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xAA"],
        ["\xE8\xB3\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC1"],

        ["\xBC\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9F"],
        ["\xE5\xAE\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC2"],

        ["\xBC\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x80"],
        ["\xE8\x94\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC3"],

        ["\xBC\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA0"],
        ["\xE7\xAF\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC4"],

        ["\xBC\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB2"],
        ["\xE5\x81\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC5"],

        ["\xBC\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB4"],
        ["\xE6\x9F\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC6"],

        ["\xBC\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x9D"],
        ["\xE8\x8A\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC7"],

        ["\xBC\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA1"],
        ["\xE5\xB1\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC8"],

        ["\xE9\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8A"],
        ["\xE8\x95\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2"],

        ["\xBC\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9E"],
        ["\xE7\xB8\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xCA"],

        ["\xBC\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8E"],
        ["\xE8\x88\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xCB"],

        ["\xBC\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x99"],
        ["\xE5\x86\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xCC"],

        ["\xBC\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x84"],
        ["\xE5\xB0\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xCD"],

        ["\xBC\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA8"],
        ["\xE6\x8D\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xCE"],

        ["\xBC\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA6"],
        ["\xE8\xB5\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xCF"],

        ["\xBC\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9C"],
        ["\xE6\x96\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD0"],

        ["\xBC\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xAE"],
        ["\xE7\x85\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD1"],

        ["\xBC\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBE"],
        ["\xE7\xA4\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD2"],

        ["\xBC\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x97"],
        ["\xE7\xB4\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD3"],

        ["\xBC\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x85"],
        ["\xE8\x80\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD4"],

        ["\xBC\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9D"],
        ["\xE8\xAC\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD5"],

        ["\xBC\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8A"],
        ["\xE8\xBB\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD6"],

        ["\xBC\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAE"],
        ["\xE9\x81\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD7"],

        ["\xBC\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x87"],
        ["\xE8\x9B\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD8"],

        ["\xBC\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xAA"],
        ["\xE9\x82\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xD9"],

        ["\xBC\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9F"],
        ["\xE5\x80\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xDA"],

        ["\xBC\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBA"],
        ["\xE5\x8B\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xDB"],

        ["\xBC\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBA"],
        ["\xE5\xB0\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xDC"],

        ["\xBC\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x93"],
        ["\xE6\x9D\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xDD"],

        ["\xBC\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xBC"],
        ["\xE7\x81\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xDE"],

        ["\xBC\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB5"],
        ["\xE7\x88\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xDF"],

        ["\xBC\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8C"],
        ["\xE9\x85\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE0"],

        ["\xBC\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x88"],
        ["\xE9\x87\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE1"],

        ["\xBC\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAB"],
        ["\xE9\x8C\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE2"],

        ["\xBC\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA5"],
        ["\xE8\x8B\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE3"],

        ["\xBC\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x82"],
        ["\xE5\xAF\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE4"],

        ["\xBC\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB1"],
        ["\xE5\xBC\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE5"],

        ["\xBC\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB9"],
        ["\xE6\x83\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE6"],

        ["\xBC\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBB"],
        ["\xE4\xB8\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE7"],

        ["\xBC\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x96"],
        ["\xE5\x8F\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE8"],

        ["\xBC\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x88"],
        ["\xE5\xAE\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xE9"],

        ["\xBC\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8B"],
        ["\xE6\x89\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xEA"],

        ["\xBC\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB1"],
        ["\xE6\x9C\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xEB"],

        ["\xBC\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8A"],
        ["\xE6\xAE\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xEC"],

        ["\xBC\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA9"],
        ["\xE7\x8B\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xED"],

        ["\xBC\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA0"],
        ["\xE7\x8F\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xEE"],

        ["\xBC\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xAE"],
        ["\xE7\xA8\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xEF"],

        ["\xBC\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xAB"],
        ["\xE8\x85\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF0"],

        ["\xBC\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xA3"],
        ["\xE8\xB6\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF1"],

        ["\xBC\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x92"],
        ["\xE9\x85\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF2"],

        ["\xBC\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x96"],
        ["\xE9\xA6\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF3"],

        ["\xBC\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x92"],
        ["\xE5\x84\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF4"],

        ["\xBC\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x97"],
        ["\xE5\x8F\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF5"],

        ["\xBC\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xAA"],
        ["\xE5\x91\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF6"],

        ["\xBC\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBF"],
        ["\xE5\xAF\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF7"],

        ["\xBC\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x88"],
        ["\xE6\x8E\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF8"],

        ["\xBC\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB9"],
        ["\xE6\xA8\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xF9"],

        ["\xBC\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAC"],
        ["\xE7\xB6\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xFA"],

        ["\xBC\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x80"],
        ["\xE9\x9C\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xFB"],

        ["\xBC\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x9A"],
        ["\xE5\x9B\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xFC"],

        ["\xBC\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8E"],
        ["\xE5\x8F\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xFD"],

        ["\xBC\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xA8"],
        ["\xE5\x91\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xFE"],

        ["\xBD\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x97"],
        ["\xE5\xAE\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA1"],

        ["\xBD\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB1"],
        ["\xE5\xB0\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA2"],

        ["\xBD\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9E"],
        ["\xE5\xB7\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA3"],

        ["\xBD\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xAE"],
        ["\xE4\xBF\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA4"],

        ["\xBD\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x81"],
        ["\xE6\x84\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA5"],

        ["\xBD\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBE"],
        ["\xE6\x8B\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA6"],

        ["\xBD\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB2"],
        ["\xE6\xB4\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA7"],

        ["\xBD\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x80"],
        ["\xE7\xA7\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA8"],

        ["\xBD\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x8B"],
        ["\xE7\xA7\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xA9"],

        ["\xBD\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x82"],
        ["\xE7\xB5\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xAA"],

        ["\xBD\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8D"],
        ["\xE7\xB9\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xAB"],

        ["\xBD\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x92"],
        ["\xE7\xBF\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xAC"],

        ["\xBD\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xAD"],
        ["\xE8\x87\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xAD"],

        ["\xBD\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9F"],
        ["\xE8\x88\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xAE"],

        ["\xBD\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x90"],
        ["\xE8\x92\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xAF"],

        ["\xBD\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x86"],
        ["\xE8\xA1\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB0"],

        ["\xBD\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB2"],
        ["\xE8\xA5\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB1"],

        ["\xBD\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x90"],
        ["\xE8\xAE\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB2"],

        ["\xBD\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB4"],
        ["\xE8\xB9\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB3"],

        ["\xBD\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xAF"],
        ["\xE8\xBC\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB4"],

        ["\xBD\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB1"],
        ["\xE9\x80\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB5"],

        ["\xBD\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8B"],
        ["\xE9\x85\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB6"],

        ["\xBD\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xAC"],
        ["\xE9\x85\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB7"],

        ["\xBD\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x86"],
        ["\xE9\x9B\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB8"],

        ["\xBD\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x9C"],
        ["\xE9\x86\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xB9"],

        ["\xBD\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x80"],
        ["\xE4\xBB\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xBA"],

        ["\xBD\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8F"],
        ["\xE4\xBD\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xBB"],

        ["\xBD\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x85"],
        ["\xE5\x85\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xBC"],

        ["\xBD\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x81"],
        ["\xE5\x8D\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xBD"],

        ["\xBD\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x93"],
        ["\xE5\xBE\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xBE"],

        ["\xBD\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8E"],
        ["\xE6\x88\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xBF"],

        ["\xBD\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x94"],
        ["\xE6\x9F\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC0"],

        ["\xBD\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x81"],
        ["\xE6\xB1\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC1"],

        ["\xBD\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x8B"],
        ["\xE6\xB8\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC2"],

        ["\xBD\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xA3"],
        ["\xE7\x8D\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC3"],

        ["\xBD\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA6"],
        ["\xE7\xB8\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC4"],

        ["\xBD\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8D"],
        ["\xE9\x87\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC5"],

        ["\xBD\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x83"],
        ["\xE9\x8A\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC6"],

        ["\xBD\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x94"],
        ["\xE5\x8F\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC7"],

        ["\xBD\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x99"],
        ["\xE5\xA4\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC8"],

        ["\xBD\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xBF"],
        ["\xE5\xAE\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xC9"],

        ["\xBD\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x91"],
        ["\xE6\xB7\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xCA"],

        ["\xBD\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9D"],
        ["\xE7\xA5\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xCB"],

        ["\xBD\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xAE"],
        ["\xE7\xB8\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xCC"],

        ["\xBD\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x9B"],
        ["\xE7\xB2\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xCD"],

        ["\xBD\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xBE"],
        ["\xE5\xA1\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xCE"],

        ["\xBD\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x9F"],
        ["\xE7\x86\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xCF"],

        ["\xBD\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBA"],
        ["\xE5\x87\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD0"],

        ["\xBD\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x93"],
        ["\xE8\xA1\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD1"],

        ["\xBD\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB0"],
        ["\xE8\xBF\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD2"],

        ["\xBD\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8A"],
        ["\xE4\xBF\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD3"],

        ["\xBD\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBB"],
        ["\xE5\xB3\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD4"],

        ["\xBD\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA5"],
        ["\xE6\x98\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD5"],

        ["\xBD\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xAC"],
        ["\xE7\x9E\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD6"],

        ["\xBD\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA3"],
        ["\xE7\xAB\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD7"],

        ["\xBD\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9C"],
        ["\xE8\x88\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD8"],

        ["\xBD\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xBF"],
        ["\xE9\xA7\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xD9"],

        ["\xBD\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x86"],
        ["\xE5\x87\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xDA"],

        ["\xBD\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAA"],
        ["\xE5\xBE\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xDB"],

        ["\xBD\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xAC"],
        ["\xE6\x97\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xDC"],

        ["\xBD\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAF"],
        ["\xE6\xA5\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xDD"],

        ["\xBD\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x89"],
        ["\xE6\xAE\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xDE"],

        ["\xBD\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB3"],
        ["\xE6\xB7\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xDF"],

        ["\xBD\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x96"],
        ["\xE6\xBA\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE0"],

        ["\xBD\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA4"],
        ["\xE6\xBD\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE1"],

        ["\xBD\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xBE"],
        ["\xE7\x9B\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE2"],

        ["\xBD\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x94"],
        ["\xE7\xB4\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE3"],

        ["\xBD\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA1"],
        ["\xE5\xB7\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE4"],

        ["\xBD\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB5"],
        ["\xE9\x81\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE5"],

        ["\xBD\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x87"],
        ["\xE9\x86\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE6"],

        ["\xBD\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x86"],
        ["\xE9\xA0\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE7"],

        ["\xBD\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA6"],
        ["\xE5\x87\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE8"],

        ["\xBD\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x9D"],
        ["\xE5\x88\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xE9"],

        ["\xBD\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x80"],
        ["\xE6\x89\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xEA"],

        ["\xBD\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x91"],
        ["\xE6\x9A\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xEB"],

        ["\xBD\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x99"],
        ["\xE6\x9B\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xEC"],

        ["\xBD\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9A"],
        ["\xE6\xB8\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xED"],

        ["\xBD\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB6"],
        ["\xE5\xBA\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xEE"],

        ["\xBD\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x92"],
        ["\xE7\xB7\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xEF"],

        ["\xBD\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB2"],
        ["\xE7\xBD\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF0"],

        ["\xBD\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB8"],
        ["\xE6\x9B\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF1"],

        ["\xBD\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAF"],
        ["\xE8\x96\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF2"],

        ["\xBD\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xB7"],
        ["\xE8\x97\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF3"],

        ["\xBD\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB8"],
        ["\xE8\xAB\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF4"],

        ["\xBD\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA9"],
        ["\xE5\x8A\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF5"],

        ["\xBD\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x99"],
        ["\xE5\x8F\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF6"],

        ["\xBD\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB3"],
        ["\xE5\xA5\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF7"],

        ["\xBD\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x8F"],
        ["\xE5\xBA\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF8"],

        ["\xBD\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x90"],
        ["\xE5\xBE\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xF9"],

        ["\xBD\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x95"],
        ["\xE6\x81\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xFA"],

        ["\xBD\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA4"],
        ["\xE9\x8B\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xFB"],

        ["\xBD\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA4"],
        ["\xE9\x99\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xFC"],

        ["\xBD\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB7"],
        ["\xE5\x82\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xFD"],

        ["\xBD\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x9F"],
        ["\xE5\x84\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBD\xFE"],

        ["\xBE\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9D"],
        ["\xE5\x8B\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA1"],

        ["\xBE\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA0"],
        ["\xE5\x8C\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA2"],

        ["\xBE\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x87"],
        ["\xE5\x8D\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA3"],

        ["\xBE\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAC"],
        ["\xE5\x8F\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA4"],

        ["\xBE\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA8"],
        ["\xE5\x93\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA5"],

        ["\xBE\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x86"],
        ["\xE5\x95\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA6"],

        ["\xBE\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB1"],
        ["\xE5\x94\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA7"],

        ["\xBE\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x97"],
        ["\xE5\x98\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA8"],

        ["\xBE\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA8"],
        ["\xE5\xA5\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xA9"],

        ["\xBE\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xBE"],
        ["\xE5\xA6\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xAA"],

        ["\xBE\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xBC"],
        ["\xE5\xA8\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xAB"],

        ["\xBE\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB5"],
        ["\xE5\xAE\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xAC"],

        ["\xBE\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x86"],
        ["\xE5\xB0\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xAD"],

        ["\xBE\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8F"],
        ["\xE5\xB0\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xAE"],

        ["\xBE\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x91"],
        ["\xE5\xB0\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xAF"],

        ["\xBE\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x9A"],
        ["\xE5\xB0\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB0"],

        ["\xBE\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x84"],
        ["\xE5\xBA\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB1"],

        ["\xBE\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x8A"],
        ["\xE5\xBA\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB2"],

        ["\xBE\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA0"],
        ["\xE5\xBB\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB3"],

        ["\xBE\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB0"],
        ["\xE5\xBD\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB4"],

        ["\xBE\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBF"],
        ["\xE6\x89\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB5"],

        ["\xBE\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x84"],
        ["\xE6\x8A\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB6"],

        ["\xBE\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9B"],
        ["\xE6\x8B\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB7"],

        ["\xBE\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8C"],
        ["\xE6\x8E\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB8"],

        ["\xBE\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB7"],
        ["\xE6\x8D\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xB9"],

        ["\xBE\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x87"],
        ["\xE6\x98\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xBA"],

        ["\xBE\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8C"],
        ["\xE6\x98\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xBB"],

        ["\xBE\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAD"],
        ["\xE6\x98\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xBC"],

        ["\xBE\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB6"],
        ["\xE6\x99\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xBD"],

        ["\xBE\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBE"],
        ["\xE6\x9D\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xBE"],

        ["\xBE\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA2"],
        ["\xE6\xA2\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xBF"],

        ["\xBE\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9F"],
        ["\xE6\xA8\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC0"],

        ["\xBE\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB5"],
        ["\xE6\xA8\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC1"],

        ["\xBE\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBC"],
        ["\xE6\xB2\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC2"],

        ["\xBE\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x88"],
        ["\xE6\xB6\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC3"],

        ["\xBE\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x89"],
        ["\xE6\xB8\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC4"],

        ["\xBE\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x98"],
        ["\xE6\xB9\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC5"],

        ["\xBE\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xBC"],
        ["\xE7\x84\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC6"],

        ["\xBE\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xA6"],
        ["\xE7\x84\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC7"],

        ["\xBE\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA7"],
        ["\xE7\x85\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC8"],

        ["\xBE\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x87"],
        ["\xE7\x97\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xC9"],

        ["\xBE\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x81"],
        ["\xE7\x9C\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xCA"],

        ["\xBE\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x9D"],
        ["\xE7\xA1\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xCB"],

        ["\xBE\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x81"],
        ["\xE7\xA4\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xCC"],

        ["\xBE\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA5"],
        ["\xE7\xA5\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xCD"],

        ["\xBE\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xB0"],
        ["\xE7\xA7\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xCE"],

        ["\xBE\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA0"],
        ["\xE7\xAB\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xCF"],

        ["\xBE\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x91"],
        ["\xE7\xAC\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD0"],

        ["\xBE\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA7"],
        ["\xE7\xB2\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD1"],

        ["\xBE\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB9"],
        ["\xE7\xB4\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD2"],

        ["\xBE\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x96"],
        ["\xE8\x82\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD3"],

        ["\xBE\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x96"],
        ["\xE8\x8F\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD4"],

        ["\xBE\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x8B"],
        ["\xE8\x92\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD5"],

        ["\xBE\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x89"],
        ["\xE8\x95\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD6"],

        ["\xBE\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9D"],
        ["\xE8\xA1\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD7"],

        ["\xBE\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB3"],
        ["\xE8\xA3\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD8"],

        ["\xBE\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9F"],
        ["\xE8\xA8\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xD9"],

        ["\xBE\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBC"],
        ["\xE8\xA8\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xDA"],

        ["\xBE\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x94"],
        ["\xE8\xA9\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xDB"],

        ["\xBE\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB3"],
        ["\xE8\xA9\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xDC"],

        ["\xBE\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xA1"],
        ["\xE8\xB1\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xDD"],

        ["\xBE\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9E"],
        ["\xE8\xB3\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xDE"],

        ["\xBE\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xA4"],
        ["\xE9\x86\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xDF"],

        ["\xBE\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA6"],
        ["\xE9\x89\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE0"],

        ["\xBE\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xBE"],
        ["\xE9\x8D\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE1"],

        ["\xBE\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x98"],
        ["\xE9\x90\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE2"],

        ["\xBE\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x9C"],
        ["\xE9\x9A\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE3"],

        ["\xBE\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x98"],
        ["\xE9\x9E\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE4"],

        ["\xBE\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8A"],
        ["\xE4\xB8\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE5"],

        ["\xBE\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x88"],
        ["\xE4\xB8\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE6"],

        ["\xBE\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x9E"],
        ["\xE4\xB8\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE7"],

        ["\xBE\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x97"],
        ["\xE4\xB9\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE8"],

        ["\xBE\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x97"],
        ["\xE5\x86\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xE9"],

        ["\xBE\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB0"],
        ["\xE5\x89\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xEA"],

        ["\xBE\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x8E"],
        ["\xE5\x9F\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xEB"],

        ["\xBE\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB4"],
        ["\xE5\xA0\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xEC"],

        ["\xBE\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x8C"],
        ["\xE5\xA3\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xED"],

        ["\xBE\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xA2"],
        ["\xE5\xAC\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xEE"],

        ["\xBE\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB8"],
        ["\xE5\xB8\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xEF"],

        ["\xBE\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x85"],
        ["\xE6\x83\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF0"],

        ["\xBE\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBE"],
        ["\xE6\x93\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF1"],

        ["\xBE\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA1"],
        ["\xE6\x9D\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF2"],

        ["\xBE\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x96"],
        ["\xE6\x9D\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF3"],

        ["\xBE\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x84"],
        ["\xE6\xB5\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF4"],

        ["\xBE\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB6"],
        ["\xE7\x8A\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF5"],

        ["\xBE\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB3"],
        ["\xE7\x95\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF6"],

        ["\xBE\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA3"],
        ["\xE7\xA9\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF7"],

        ["\xBE\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB8"],
        ["\xE8\x92\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF8"],

        ["\xBE\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB2"],
        ["\xE8\xAD\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xF9"],

        ["\xBE\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB8"],
        ["\xE9\x86\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xFA"],

        ["\xBE\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA0"],
        ["\xE9\x8C\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xFB"],

        ["\xBE\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB1"],
        ["\xE5\x98\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xFC"],

        ["\xBE\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB4"],
        ["\xE5\x9F\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xFD"],

        ["\xBE\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBE"],
        ["\xE9\xA3\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBE\xFE"],

        ["\xBF\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAD"],
        ["\xE6\x8B\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA1"],

        ["\xBF\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8D"],
        ["\xE6\xA4\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA2"],

        ["\xBF\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x96"],
        ["\xE6\xAE\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA3"],

        ["\xBF\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAD"],
        ["\xE7\x87\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA4"],

        ["\xBF\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x94"],
        ["\xE7\xB9\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA5"],

        ["\xBF\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB7"],
        ["\xE8\x81\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA6"],

        ["\xBF\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB2"],
        ["\xE8\x89\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA7"],

        ["\xBF\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA6"],
        ["\xE8\xA7\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA8"],

        ["\xBF\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9F"],
        ["\xE9\xA3\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xA9"],

        ["\xBF\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x95"],
        ["\xE8\x9D\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xAA"],

        ["\xBF\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB1"],
        ["\xE8\xBE\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xAB"],

        ["\xBF\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBB"],
        ["\xE5\xB0\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xAC"],

        ["\xBF\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB8"],
        ["\xE4\xBC\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xAD"],

        ["\xBF\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA1"],
        ["\xE4\xBF\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xAE"],

        ["\xBF\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xB5"],
        ["\xE4\xBE\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xAF"],

        ["\xBF\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x87"],
        ["\xE5\x94\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB0"],

        ["\xBF\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA0"],
        ["\xE5\xA8\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB1"],

        ["\xBF\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9D"],
        ["\xE5\xAF\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB2"],

        ["\xBF\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA9"],
        ["\xE5\xAF\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB3"],

        ["\xBF\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x83"],
        ["\xE5\xBF\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB4"],

        ["\xBF\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8E"],
        ["\xE6\x85\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB5"],

        ["\xBF\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xAF"],
        ["\xE6\x8C\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB6"],

        ["\xBF\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB0"],
        ["\xE6\x96\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB7"],

        ["\xBF\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8B"],
        ["\xE6\x99\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB8"],

        ["\xBF\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAE"],
        ["\xE6\xA3\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xB9"],

        ["\xBF\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x9B"],
        ["\xE6\xA6\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xBA"],

        ["\xBF\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB8"],
        ["\xE6\xB5\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xBB"],

        ["\xBF\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB1"],
        ["\xE6\xB7\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xBC"],

        ["\xBF\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB3"],
        ["\xE7\x94\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xBD"],

        ["\xBF\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB9"],
        ["\xE7\x96\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xBE"],

        ["\xBF\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9F"],
        ["\xE7\x9C\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xBF"],

        ["\xBF\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9E"],
        ["\xE7\xA5\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC0"],

        ["\xBF\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA6"],
        ["\xE7\xA7\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC1"],

        ["\xBF\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB3"],
        ["\xE7\xB4\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC2"],

        ["\xBF\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA3"],
        ["\xE8\x87\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC3"],

        ["\xBF\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAF"],
        ["\xE8\x8A\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC4"],

        ["\xBF\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAA"],
        ["\xE8\x96\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC5"],

        ["\xBF\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAA"],
        ["\xE8\xA6\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC6"],

        ["\xBF\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBA"],
        ["\xE8\xA8\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC7"],

        ["\xBF\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAB"],
        ["\xE8\xBA\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC8"],

        ["\xBF\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9B"],
        ["\xE8\xBE\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xC9"],

        ["\xBF\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB2"],
        ["\xE9\x80\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xCA"],

        ["\xBF\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9D"],
        ["\xE9\x87\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xCB"],

        ["\xBF\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x87"],
        ["\xE9\x9C\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xCC"],

        ["\xBF\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xBA"],
        ["\xE4\xBA\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xCD"],

        ["\xBF\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x81"],
        ["\xE4\xBB\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xCE"],

        ["\xBF\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x83"],
        ["\xE5\x88\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xCF"],

        ["\xBF\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB5"],
        ["\xE5\xA1\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD0"],

        ["\xBF\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAC"],
        ["\xE5\xA3\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD1"],

        ["\xBF\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8B"],
        ["\xE5\xB0\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD2"],

        ["\xBF\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9A"],
        ["\xE7\x94\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD3"],

        ["\xBF\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBD"],
        ["\xE5\xB0\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD4"],

        ["\xBF\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x8E"],
        ["\xE8\x85\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD5"],

        ["\xBF\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8A"],
        ["\xE8\xA8\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD6"],

        ["\xBF\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x85"],
        ["\xE8\xBF\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD7"],

        ["\xBF\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA3"],
        ["\xE9\x99\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD8"],

        ["\xF0\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xAD"],
        ["\xE9\x9D\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD7"],

        ["\xBF\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA5"],
        ["\xE7\xAC\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xDA"],

        ["\xBF\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8F"],
        ["\xE8\xAB\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xDB"],

        ["\xBF\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x88"],
        ["\xE9\xA0\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xDC"],

        ["\xBF\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA2"],
        ["\xE9\x85\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xDD"],

        ["\xBF\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB3"],
        ["\xE5\x9B\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xDE"],

        ["\xBF\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA8"],
        ["\xE5\x8E\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xDF"],

        ["\xBF\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x97"],
        ["\xE9\x80\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE0"],

        ["\xBF\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB9"],
        ["\xE5\x90\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE1"],

        ["\xBF\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x82"],
        ["\xE5\x9E\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE2"],

        ["\xBF\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xA5"],
        ["\xE5\xB8\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE3"],

        ["\xBF\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA8"],
        ["\xE6\x8E\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE4"],

        ["\xBF\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB4"],
        ["\xE6\xB0\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE5"],

        ["\xBF\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x8A"],
        ["\xE7\x82\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE6"],

        ["\xBF\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA1"],
        ["\xE7\x9D\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE7"],

        ["\xBF\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x8B"],
        ["\xE7\xB2\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE8"],

        ["\xBF\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA0"],
        ["\xE7\xBF\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xE9"],

        ["\xBF\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB0"],
        ["\xE8\xA1\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xEA"],

        ["\xBF\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x82"],
        ["\xE9\x81\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xEB"],

        ["\xBF\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x94"],
        ["\xE9\x85\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xEC"],

        ["\xBF\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x90"],
        ["\xE9\x8C\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xED"],

        ["\xBF\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x98"],
        ["\xE9\x8C\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xEE"],

        ["\xBF\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8F"],
        ["\xE9\x9A\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xEF"],

        ["\xBF\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9E"],
        ["\xE7\x91\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF0"],

        ["\xBF\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x84"],
        ["\xE9\xAB\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF1"],

        ["\xBF\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x87"],
        ["\xE5\xB4\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF2"],

        ["\xBF\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xA9"],
        ["\xE5\xB5\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF3"],

        ["\xBF\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB0"],
        ["\xE6\x95\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF4"],

        ["\xBF\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA2"],
        ["\xE6\x9E\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF5"],

        ["\xBF\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xA8"],
        ["\xE8\xB6\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF6"],

        ["\xBF\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x9B"],
        ["\xE9\x9B\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF7"],

        ["\xBF\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xAE"],
        ["\xE6\x8D\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF8"],

        ["\xBF\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x89"],
        ["\xE6\x9D\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xF9"],

        ["\xBF\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x99"],
        ["\xE6\xA4\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xFA"],

        ["\xBF\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x85"],
        ["\xE8\x8F\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xFB"],

        ["\xBF\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x97"],
        ["\xE9\xA0\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xFC"],

        ["\xBF\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x80"],
        ["\xE9\x9B\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xFD"],

        ["\xBF\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBE"],
        ["\xE8\xA3\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xFE"],

        ["\xC0\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x84"],
        ["\xE6\xBE\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA1"],

        ["\xC0\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xBA"],
        ["\xE6\x91\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA2"],

        ["\xC0\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB8"],
        ["\xE5\xAF\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA3"],

        ["\xC0\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x96"],
        ["\xE4\xB8\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA4"],

        ["\xC0\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xAC"],
        ["\xE7\x80\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA5"],

        ["\xC0\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9D"],
        ["\xE7\x95\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA6"],

        ["\xC0\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xAF"],
        ["\xE6\x98\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA7"],

        ["\xC0\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x84"],
        ["\xE5\x87\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA8"],

        ["\xC0\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB6"],
        ["\xE5\x88\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xA9"],

        ["\xC0\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA2"],
        ["\xE5\x8B\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xAA"],

        ["\xC0\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x93"],
        ["\xE5\xA7\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xAB"],

        ["\xC0\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x81"],
        ["\xE5\xBE\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xAC"],

        ["\xC0\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA7"],
        ["\xE6\x80\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xAD"],

        ["\xC0\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x90"],
        ["\xE6\x88\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xAE"],

        ["\xC0\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBF"],
        ["\xE6\x94\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xAF"],

        ["\xC0\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB4"],
        ["\xE6\x95\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB0"],

        ["\xC0\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x9F"],
        ["\xE6\x98\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB1"],

        ["\xC0\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB4"],
        ["\xE6\x99\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB2"],

        ["\xC0\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB2"],
        ["\xE6\xA3\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB3"],

        ["\xC0\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x96"],
        ["\xE6\xA0\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB4"],

        ["\xC0\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA3"],
        ["\xE6\xAD\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB5"],

        ["\xC0\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x85"],
        ["\xE6\xB8\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB6"],

        ["\xC0\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB2"],
        ["\xE7\x89\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB7"],

        ["\xC0\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9F"],
        ["\xE7\x94\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB8"],

        ["\xC0\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9B"],
        ["\xE7\x9B\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xB9"],

        ["\xC0\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xBE"],
        ["\xE7\xB2\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xBA"],

        ["\xC0\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x96"],
        ["\xE8\x81\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xBB"],

        ["\xC0\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB0"],
        ["\xE5\xA3\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xBC"],

        ["\xC0\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBD"],
        ["\xE8\xA3\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xBD"],

        ["\xC0\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xBF"],
        ["\xE8\xA5\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xBE"],

        ["\xC0\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA0"],
        ["\xE8\xAA\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xBF"],

        ["\xC0\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x93"],
        ["\xE8\xAA\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC0"],

        ["\xC0\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8B"],
        ["\xE8\xAB\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC1"],

        ["\xC0\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9D"],
        ["\xE9\x80\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC2"],

        ["\xC0\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x92"],
        ["\xE9\x86\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC3"],

        ["\xC0\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x92"],
        ["\xE9\x9D\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC4"],

        ["\xC0\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x99"],
        ["\xE9\x9D\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC5"],

        ["\xC0\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x89"],
        ["\xE6\x96\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC6"],

        ["\xC0\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8E"],
        ["\xE7\xA8\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC7"],

        ["\xC0\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x86"],
        ["\xE8\x84\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC8"],

        ["\xC0\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xBB"],
        ["\xE9\x9A\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xC9"],

        ["\xC0\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAD"],
        ["\xE5\xB8\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xCA"],

        ["\xC0\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x9C"],
        ["\xE6\x83\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xCB"],

        ["\xC0\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9A"],
        ["\xE6\x88\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xCC"],

        ["\xC0\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA5"],
        ["\xE6\x96\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xCD"],

        ["\xC0\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x94"],
        ["\xE6\x98\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xCE"],

        ["\xC0\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x90"],
        ["\xE6\x9E\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xCF"],

        ["\xC0\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xB3"],
        ["\xE7\x9F\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD0"],

        ["\xC0\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x8D"],
        ["\xE7\xA9\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD1"],

        ["\xC0\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8D"],
        ["\xE7\xB1\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD2"],

        ["\xC0\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBE"],
        ["\xE7\xB8\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD3"],

        ["\xC0\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x8A"],
        ["\xE8\x84\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD4"],

        ["\xC0\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAC"],
        ["\xE8\xB2\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD5"],

        ["\xC0\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA4"],
        ["\xE8\xB5\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD6"],

        ["\xC0\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA1"],
        ["\xE8\xB7\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD7"],

        ["\xC0\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x9F"],
        ["\xE8\xB9\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD8"],

        ["\xC0\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA9"],
        ["\xE7\xA2\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xD9"],

        ["\xC0\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x87"],
        ["\xE5\x88\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xDA"],

        ["\xC0\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x99"],
        ["\xE6\x8B\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xDB"],

        ["\xC0\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA5"],
        ["\xE6\x8E\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xDC"],

        ["\xC0\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x82"],
        ["\xE6\x91\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xDD"],

        ["\xC0\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x98"],
        ["\xE6\x8A\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xDE"],

        ["\xC0\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xAD"],
        ["\xE8\xA8\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xDF"],

        ["\xC0\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x83"],
        ["\xE7\xAA\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE0"],

        ["\xC0\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x80"],
        ["\xE7\xAF\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE1"],

        ["\xC0\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xAC"],
        ["\xE8\xAA\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE2"],

        ["\xC0\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xAA"],
        ["\xE9\x9B\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE3"],

        ["\xC0\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB6"],
        ["\xE7\xB5\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE4"],

        ["\xC0\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8C"],
        ["\xE8\x88\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE5"],

        ["\xC0\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x89"],
        ["\xE8\x9D\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE6"],

        ["\xC0\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x99"],
        ["\xE4\xBB\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE7"],

        ["\xC0\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x88"],
        ["\xE5\x85\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE8"],

        ["\xC0\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x83"],
        ["\xE5\x8D\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xE9"],

        ["\xC0\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA0"],
        ["\xE5\x8D\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xEA"],

        ["\xC0\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA3"],
        ["\xE5\xAE\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xEB"],

        ["\xC0\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x82"],
        ["\xE5\xB0\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xEC"],

        ["\xC0\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x96"],
        ["\xE5\xB0\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xED"],

        ["\xC0\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9D"],
        ["\xE5\xB7\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xEE"],

        ["\xC0\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA6"],
        ["\xE6\x88\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xEF"],

        ["\xC0\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x87"],
        ["\xE6\x89\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF0"],

        ["\xC0\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB0"],
        ["\xE6\x92\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF1"],

        ["\xC0\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x93"],
        ["\xE6\xA0\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF2"],

        ["\xC0\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB4"],
        ["\xE6\xA0\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF3"],

        ["\xC0\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x89"],
        ["\xE6\xB3\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF4"],

        ["\xC0\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x85"],
        ["\xE6\xB5\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF5"],

        ["\xC0\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x97"],
        ["\xE6\xB4\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF6"],

        ["\xC0\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x93"],
        ["\xE6\x9F\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF7"],

        ["\xC0\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9C"],
        ["\xE6\xBD\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF8"],

        ["\xC0\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x8E"],
        ["\xE7\x85\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xF9"],

        ["\xC0\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xBD"],
        ["\xE7\x85\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xFA"],

        ["\xC0\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8B"],
        ["\xE6\x97\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xFB"],

        ["\xC0\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBF"],
        ["\xE7\xA9\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xFC"],

        ["\xC0\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xAD"],
        ["\xE7\xAE\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xFD"],

        ["\xC0\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9A"],
        ["\xE7\xB7\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC0\xFE"],

        ["\xC1\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x8A"],
        ["\xE7\xB9\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA1"],

        ["\xC1\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA8"],
        ["\xE7\xBE\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA2"],

        ["\xC1\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xBA"],
        ["\xE8\x85\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA3"],

        ["\xC1\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9B"],
        ["\xE8\x88\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA4"],

        ["\xC1\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB9"],
        ["\xE8\x88\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA5"],

        ["\xC1\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA6"],
        ["\xE8\x96\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA6"],

        ["\xC1\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAE"],
        ["\xE8\xA9\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA7"],

        ["\xEC\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8E"],
        ["\xE8\xB3\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xCD"],

        ["\xC1\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xB5"],
        ["\xE8\xB7\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA9"],

        ["\xC1\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB8"],
        ["\xE9\x81\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xAA"],

        ["\xC1\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB7"],
        ["\xE9\x81\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xAB"],

        ["\xC1\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xAD"],
        ["\xE9\x8A\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xAC"],

        ["\xC1\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x91"],
        ["\xE9\x8A\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xAD"],

        ["\xC1\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x83"],
        ["\xE9\x96\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xAE"],

        ["\xC1\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAE"],
        ["\xE9\xAE\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xAF"],

        ["\xC1\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8D"],
        ["\xE5\x89\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB0"],

        ["\xC1\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x84"],
        ["\xE5\x96\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB1"],

        ["\xC1\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB8"],
        ["\xE6\xBC\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB2"],

        ["\xC1\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xB6"],
        ["\xE7\x84\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB3"],

        ["\xC1\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA8"],
        ["\xE5\x85\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB4"],

        ["\xC1\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x85"],
        ["\xE7\xA6\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB5"],

        ["\xC1\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x95"],
        ["\xE7\xB9\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB6"],

        ["\xC1\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB3"],
        ["\xE8\x86\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB7"],

        ["\xC1\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x8E"],
        ["\xE7\xB3\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB8"],

        ["\xC1\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x8C"],
        ["\xE5\x99\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xB9"],

        ["\xC1\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x91"],
        ["\xE5\xA1\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xBA"],

        ["\xC1\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xA8"],
        ["\xE5\xB2\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xBB"],

        ["\xC1\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAA"],
        ["\xE6\x8E\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xBC"],

        ["\xC1\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBE"],
        ["\xE6\x9B\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xBD"],

        ["\xC1\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBD"],
        ["\xE6\x9B\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xBE"],

        ["\xC1\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9A"],
        ["\xE6\xA5\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xBF"],

        ["\xC1\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x99"],
        ["\xE7\x8B\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC0"],

        ["\xC1\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8F"],
        ["\xE7\x96\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC1"],

        ["\xC1\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8E"],
        ["\xE7\x96\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC2"],

        ["\xC1\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x8E"],
        ["\xE7\xA4\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC3"],

        ["\xC1\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x96"],
        ["\xE7\xA5\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC4"],

        ["\xC1\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x9F"],
        ["\xE7\xA7\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC5"],

        ["\xC1\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x97"],
        ["\xE7\xB2\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC6"],

        ["\xC1\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA0"],
        ["\xE7\xB4\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC7"],

        ["\xC1\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x84"],
        ["\xE7\xB5\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC8"],

        ["\xC1\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x87"],
        ["\xE8\x98\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xC9"],

        ["\xC1\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB4"],
        ["\xE8\xA8\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xCA"],

        ["\xC1\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xBB"],
        ["\xE9\x98\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xCB"],

        ["\xC1\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA1"],
        ["\xE9\x81\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xCC"],

        ["\xC1\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xA0"],
        ["\xE9\xBC\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xCD"],

        ["\xC1\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA7"],
        ["\xE5\x83\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xCE"],

        ["\xC1\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB5"],
        ["\xE5\x89\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xCF"],

        ["\xC1\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8C"],
        ["\xE5\x8F\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD0"],

        ["\xC1\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA2"],
        ["\xE5\x8F\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD1"],

        ["\xC1\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x89"],
        ["\xE5\x80\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD2"],

        ["\xC1\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAA"],
        ["\xE5\x96\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD3"],

        ["\xC1\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAE"],
        ["\xE5\xA3\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD4"],

        ["\xC1\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x8F"],
        ["\xE5\xA5\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD5"],

        ["\xC1\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBD"],
        ["\xE7\x88\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD6"],

        ["\xC1\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x8B"],
        ["\xE5\xAE\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD7"],

        ["\xC1\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA4"],
        ["\xE5\xB1\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD8"],

        ["\xC1\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x9D"],
        ["\xE5\x8C\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xD9"],

        ["\xC1\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA3"],
        ["\xE6\x83\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xDA"],

        ["\xC1\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB3"],
        ["\xE6\x83\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xDB"],

        ["\xC1\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x9C"],
        ["\xE6\x8D\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xDC"],

        ["\xC1\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x83"],
        ["\xE6\x8E\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xDD"],

        ["\xC1\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBF"],
        ["\xE6\x8C\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xDE"],

        ["\xC1\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xBB"],
        ["\xE6\x8E\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xDF"],

        ["\xC1\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x8D"],
        ["\xE6\x93\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE0"],

        ["\xC1\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA9"],
        ["\xE6\x97\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE1"],

        ["\xC1\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB9"],
        ["\xE6\x9B\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE2"],

        ["\xC1\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xA3"],
        ["\xE5\xB7\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE3"],

        ["\xC1\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8D"],
        ["\xE6\xA7\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE4"],

        ["\xC1\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBD"],
        ["\xE6\xA7\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE5"],

        ["\xC1\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x95"],
        ["\xE6\xBC\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE6"],

        ["\xC1\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA5"],
        ["\xE7\x87\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE7"],

        ["\xC1\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x89"],
        ["\xE4\xBA\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE8"],

        ["\xC1\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA9"],
        ["\xE7\x97\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xE9"],

        ["\xC1\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB8"],
        ["\xE7\x9B\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xEA"],

        ["\xC1\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x93"],
        ["\xE7\xAA\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xEB"],

        ["\xC1\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9F"],
        ["\xE7\xB3\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xEC"],

        ["\xC1\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8F"],
        ["\xE7\xB7\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xED"],

        ["\xC1\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9C"],
        ["\xE7\xB6\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xEE"],

        ["\xC1\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA1"],
        ["\xE8\x81\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xEF"],

        ["\xC1\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x89"],
        ["\xE8\x8D\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF0"],

        ["\xC1\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x98"],
        ["\xE8\x8D\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF1"],

        ["\xC1\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAC"],
        ["\xE8\x91\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF2"],

        ["\xC1\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBC"],
        ["\xE8\x92\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF3"],

        ["\xC1\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBB"],
        ["\xE8\x97\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF4"],

        ["\xC1\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x85"],
        ["\xE8\xA3\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF5"],

        ["\xC1\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB0"],
        ["\xE8\xB5\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF6"],

        ["\xC1\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x81"],
        ["\xE9\x80\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF7"],

        ["\xC1\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAD"],
        ["\xE9\x81\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF8"],

        ["\xC1\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x97"],
        ["\xE9\x8E\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xF9"],

        ["\xC1\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x9C"],
        ["\xE9\x9C\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xFA"],

        ["\xC1\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x92"],
        ["\xE9\xA8\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xFB"],

        ["\xC1\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8F"],
        ["\xE5\x83\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xFC"],

        ["\xC1\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x97"],
        ["\xE5\xA2\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xFD"],

        ["\xC1\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x8E"],
        ["\xE6\x86\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xFE"],

        ["\xC2\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x93"],
        ["\xE8\x87\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA1"],

        ["\xC2\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xB5"],
        ["\xE8\x94\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA2"],

        ["\xC2\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x88"],
        ["\xE8\xB4\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA3"],

        ["\xC2\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA0"],
        ["\xE9\x80\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA4"],

        ["\xC2\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x83"],
        ["\xE4\xBF\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA5"],

        ["\xC2\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB4"],
        ["\xE5\x81\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA6"],

        ["\xC2\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x87"],
        ["\xE5\x89\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],

        ["\xC2\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB3"],
        ["\xE5\x8D\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],

        ["\xC2\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAF"],
        ["\xE6\x81\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xA9"],

        ["\xC2\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x89"],
        ["\xE6\x8D\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xAA"],

        ["\xC2\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9F"],
        ["\xE6\x9D\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xAB"],

        ["\xC2\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAC"],
        ["\xE6\xB8\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xAC"],

        ["\xC2\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xB3"],
        ["\xE8\xB6\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xAD"],

        ["\xC2\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9F"],
        ["\xE9\x80\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xAE"],

        ["\xC2\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x97"],
        ["\xE4\xBF\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xAF"],

        ["\xC2\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x9E"],
        ["\xE5\xB1\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],

        ["\xC2\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8A"],
        ["\xE8\xB3\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],

        ["\xC2\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8F"],
        ["\xE6\x97\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB2"],

        ["\xC2\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9A"],
        ["\xE7\xB6\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB3"],

        ["\xC2\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x92"],
        ["\xE5\x8D\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],

        ["\xC2\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x96"],
        ["\xE8\xA2\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB5"],

        ["\xC2\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB6"],
        ["\xE5\x85\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],

        ["\xC2\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x83"],
        ["\xE6\x8F\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB7"],

        ["\xC2\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x98"],
        ["\xE5\xAD\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB8"],

        ["\xC2\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xAB"],
        ["\xE5\xAD\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xB9"],

        ["\xC2\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8A"],
        ["\xE5\xB0\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xBA"],

        ["\xC2\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x8D"],
        ["\xE6\x90\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xBB"],

        ["\xC2\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x91"],
        ["\xE6\x9D\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xBC"],

        ["\xC2\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x9C"],
        ["\xE9\x81\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xBD"],

        ["\xC2\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x96"],
        ["\xE4\xBB\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xBE"],

        ["\xC2\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9A"],
        ["\xE5\xA4\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xBF"],

        ["\xC2\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAA"],
        ["\xE5\xA4\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC0"],

        ["\xC2\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB0"],
        ["\xE6\xB1\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC1"],

        ["\xC2\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x91"],
        ["\xE8\xA9\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC2"],

        ["\xC2\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xBE"],
        ["\xE5\x94\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC3"],

        ["\xC2\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x95"],
        ["\xE5\xA0\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC4"],

        ["\xC2\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA5"],
        ["\xE5\xA6\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC5"],

        ["\xC2\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB0"],
        ["\xE6\x83\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC6"],

        ["\xC2\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x93"],
        ["\xE6\x89\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC7"],

        ["\xC2\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x81"],
        ["\xE6\x9F\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC8"],

        ["\xC2\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB5"],
        ["\xE8\x88\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xC9"],

        ["\xC2\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x95"],
        ["\xE6\xA5\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xCA"],

        ["\xC2\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x80"],
        ["\xE9\x99\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xCB"],

        ["\xC2\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x84"],
        ["\xE9\xA7\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xCC"],

        ["\xC2\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xA8"],
        ["\xE9\xA8\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xCD"],

        ["\xC2\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x93"],
        ["\xE4\xBD\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xCE"],

        ["\xC2\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x86"],
        ["\xE5\xA0\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xCF"],

        ["\xC2\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xBE"],
        ["\xE5\xAF\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD0"],

        ["\xC2\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x90"],
        ["\xE8\x80\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD1"],

        ["\xC2\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB1"],
        ["\xE5\xB2\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD2"],

        ["\xC2\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xAF"],
        ["\xE5\xB8\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD3"],

        ["\xC2\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x85"],
        ["\xE5\xBE\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD4"],

        ["\xC2\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA0"],
        ["\xE6\x80\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD5"],

        ["\xC2\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8B"],
        ["\xE6\x85\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD6"],

        ["\xC2\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB4"],
        ["\xE6\x88\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD7"],

        ["\xC2\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBF"],
        ["\xE6\x9B\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD8"],

        ["\xC2\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB0"],
        ["\xE6\xB3\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xD9"],

        ["\xC2\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x9E"],
        ["\xE6\xBB\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xDA"],

        ["\xC2\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x8E"],
        ["\xE8\x83\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xDB"],

        ["\xC2\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xBF"],
        ["\xE8\x85\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xDC"],

        ["\xC2\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x94"],
        ["\xE8\x8B\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xDD"],

        ["\xC2\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x8B"],
        ["\xE8\xA2\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xDE"],

        ["\xC2\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB8"],
        ["\xE8\xB2\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xDF"],

        ["\xC2\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x80"],
        ["\xE9\x80\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE0"],

        ["\xC2\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xAE"],
        ["\xE9\x80\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE1"],

        ["\xC2\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8A"],
        ["\xE9\x9A\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE2"],

        ["\xC2\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x9B"],
        ["\xE9\xBB\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE3"],

        ["\xC2\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x9B"],
        ["\xE9\xAF\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE4"],

        ["\xC2\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA3"],
        ["\xE4\xBB\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE5"],

        ["\xC2\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xB0"],
        ["\xE5\x8F\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE6"],

        ["\xC2\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA7"],
        ["\xE5\xA4\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE7"],

        ["\xC2\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xAC"],
        ["\xE7\xAC\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE8"],

        ["\xC2\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x8D"],
        ["\xE9\x86\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xE9"],

        ["\xC2\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8C"],
        ["\xE9\xA1\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xEA"],

        ["\xC2\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB9"],
        ["\xE9\xB7\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xEB"],

        ["\xC2\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x9D"],
        ["\xE6\xBB\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xEC"],

        ["\xC2\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA7"],
        ["\xE7\x80\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xED"],

        ["\xC2\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x93"],
        ["\xE5\x8D\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xEE"],

        ["\xC2\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x84"],
        ["\xE5\x95\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xEF"],

        ["\xC2\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x85"],
        ["\xE5\xAE\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF0"],

        ["\xC2\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x98"],
        ["\xE6\x89\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF1"],

        ["\xC2\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9E"],
        ["\xE6\x8A\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF2"],

        ["\xC2\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x93"],
        ["\xE6\x8B\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF3"],

        ["\xC2\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xA2"],
        ["\xE6\xB2\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF4"],

        ["\xC2\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAF"],
        ["\xE6\xBF\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF5"],

        ["\xC2\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA2"],
        ["\xE7\x90\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF6"],

        ["\xC2\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x97"],
        ["\xE8\xA8\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF7"],

        ["\xC2\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB8"],
        ["\xE9\x90\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF8"],

        ["\xC2\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x81"],
        ["\xE6\xBF\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xF9"],

        ["\xC2\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xBE"],
        ["\xE8\xAB\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xFA"],

        ["\xC2\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB8"],
        ["\xE8\x8C\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xFB"],

        ["\xC2\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA7"],
        ["\xE5\x87\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xFC"],

        ["\xC2\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xB8"],
        ["\xE8\x9B\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xFD"],

        ["\xC2\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAA"],
        ["\xE5\x8F\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC2\xFE"],

        ["\xC3\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA9"],
        ["\xE5\x8F\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],

        ["\xC3\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x86"],
        ["\xE4\xBD\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA2"],

        ["\xC3\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x94"],
        ["\xE9\x81\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA3"],

        ["\xC3\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB0"],
        ["\xE8\xBE\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA4"],

        ["\xC3\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAA"],
        ["\xE5\xA5\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA5"],

        ["\xC3\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB1"],
        ["\xE8\x84\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA6"],

        ["\xC3\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xBD"],
        ["\xE5\xB7\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA7"],

        ["\xC3\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAA"],
        ["\xE7\xAB\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA8"],

        ["\xC3\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBF"],
        ["\xE8\xBE\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xA9"],

        ["\xC3\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x9A"],
        ["\xE6\xA3\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xAA"],

        ["\xC3\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xB7"],
        ["\xE8\xB0\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],

        ["\xC3\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB8"],
        ["\xE7\x8B\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xAC"],

        ["\xC3\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x88"],
        ["\xE9\xB1\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xAD"],

        ["\xC3\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xBD"],
        ["\xE6\xA8\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xAE"],

        ["\xC3\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB0"],
        ["\xE8\xAA\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xAF"],

        ["\xC3\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB9"],
        ["\xE4\xB8\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB0"],

        ["\xC3\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x98"],
        ["\xE5\x8D\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB1"],

        ["\xC3\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x86"],
        ["\xE5\x98\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB2"],

        ["\xC3\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA6"],
        ["\xE5\x9D\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB3"],

        ["\xC3\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x85"],
        ["\xE6\x8B\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB4"],

        ["\xC3\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA2"],
        ["\xE6\x8E\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB5"],

        ["\xC3\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA6"],
        ["\xE6\x97\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB6"],

        ["\xC3\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x8E"],
        ["\xE6\xAD\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],

        ["\xC3\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA1"],
        ["\xE6\xB7\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB8"],

        ["\xC3\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9B"],
        ["\xE6\xB9\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xB9"],

        ["\xC3\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAD"],
        ["\xE7\x82\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],

        ["\xC3\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAD"],
        ["\xE7\x9F\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xBB"],

        ["\xC3\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAF"],
        ["\xE7\xAB\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xBC"],

        ["\xC3\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xAA"],
        ["\xE7\xAE\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xBD"],

        ["\xC3\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBB"],
        ["\xE7\xB6\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xBE"],

        ["\xC3\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBD"],
        ["\xE8\x80\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xBF"],

        ["\xC3\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x86"],
        ["\xE8\x83\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC0"],

        ["\xC3\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x8B"],
        ["\xE8\x9B\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC1"],

        ["\xC3\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x95"],
        ["\xE8\xAA\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC2"],

        ["\xC3\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x9B"],
        ["\xE9\x8D\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC3"],

        ["\xC3\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xA3"],
        ["\xE5\x9B\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC4"],

        ["\xC3\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x87"],
        ["\xE5\xA3\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC5"],

        ["\xC3\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xBE"],
        ["\xE5\xBC\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC6"],

        ["\xC3\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAD"],
        ["\xE6\x96\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC7"],

        ["\xC3\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x96"],
        ["\xE6\x9A\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC8"],

        ["\xC3\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x80"],
        ["\xE6\xAA\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xC9"],

        ["\xC3\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB5"],
        ["\xE6\xAE\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xCA"],

        ["\xC3\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB7"],
        ["\xE7\x94\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xCB"],

        ["\xC3\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x87"],
        ["\xE8\xAB\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xCC"],

        ["\xC3\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA4"],
        ["\xE5\x80\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xCD"],

        ["\xC3\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA5"],
        ["\xE7\x9F\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xCE"],

        ["\xC3\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB0"],
        ["\xE5\x9C\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xCF"],

        ["\xC3\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9B"],
        ["\xE5\xBC\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD0"],

        ["\xC3\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA5"],
        ["\xE6\x81\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD1"],

        ["\xC3\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xBA"],
        ["\xE6\x99\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD2"],

        ["\xC3\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA0"],
        ["\xE6\xB1\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD3"],

        ["\xC3\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB4"],
        ["\xE7\x97\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD4"],

        ["\xC3\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9A"],
        ["\xE7\xA8\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD5"],

        ["\xC3\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xAE"],
        ["\xE7\xBD\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD6"],

        ["\xC3\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xB4"],
        ["\xE8\x87\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD7"],

        ["\xC3\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x98"],
        ["\xE8\x9C\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD8"],

        ["\xC3\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x85"],
        ["\xE9\x81\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xD9"],

        ["\xC3\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xB3"],
        ["\xE9\xA6\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xDA"],

        ["\xC3\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x89"],
        ["\xE7\xAF\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xDB"],

        ["\xC3\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9C"],
        ["\xE7\x95\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xDC"],

        ["\xC3\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB9"],
        ["\xE7\xAB\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xDD"],

        ["\xC3\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x91"],
        ["\xE7\xAD\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xDE"],

        ["\xC3\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x84"],
        ["\xE8\x93\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xDF"],

        ["\xC3\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x90"],
        ["\xE9\x80\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE0"],

        ["\xC3\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA9"],
        ["\xE7\xA7\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE1"],

        ["\xC3\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x92"],
        ["\xE7\xAA\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE2"],

        ["\xC3\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB6"],
        ["\xE8\x8C\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE3"],

        ["\xC3\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA1"],
        ["\xE5\xAB\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE4"],

        ["\xC3\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x80"],
        ["\xE7\x9D\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE5"],

        ["\xC3\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAD"],
        ["\xE4\xB8\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE6"],

        ["\xC3\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB2"],
        ["\xE4\xBB\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE7"],

        ["\xC3\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x99"],
        ["\xE5\xAE\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE8"],

        ["\xC3\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA0"],
        ["\xE5\xBF\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xE9"],

        ["\xC3\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBD"],
        ["\xE6\x8A\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xEA"],

        ["\xC3\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBC"],
        ["\xE6\x98\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xEB"],

        ["\xC3\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB1"],
        ["\xE6\x9F\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xEC"],

        ["\xC3\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA8"],
        ["\xE6\xB3\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xED"],

        ["\xC3\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xAB"],
        ["\xE8\x99\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xEE"],

        ["\xC3\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB7"],
        ["\xE8\xA1\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xEF"],

        ["\xC3\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xBB"],
        ["\xE8\xA8\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF0"],

        ["\xC3\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8E"],
        ["\xE9\x85\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF1"],

        ["\xC3\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB3"],
        ["\xE9\x8B\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF2"],

        ["\xC3\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x90"],
        ["\xE9\xA7\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF3"],

        ["\xC3\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x97"],
        ["\xE6\xA8\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF4"],

        ["\xC3\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xA6"],
        ["\xE7\x80\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF5"],

        ["\xC3\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAA"],
        ["\xE7\x8C\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF6"],

        ["\xC3\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA7"],
        ["\xE8\x8B\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF7"],

        ["\xC3\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x97"],
        ["\xE8\x91\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF8"],

        ["\xC3\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAF"],
        ["\xE8\xB2\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xF9"],

        ["\xC3\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x81"],
        ["\xE4\xB8\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xFA"],

        ["\xC3\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x86"],
        ["\xE5\x85\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xFB"],

        ["\xC3\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8B"],
        ["\xE5\x87\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xFC"],

        ["\xC3\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x8B"],
        ["\xE5\x96\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xFD"],

        ["\xC3\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB5"],
        ["\xE5\xAF\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC3\xFE"],

        ["\xC4\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x96"],
        ["\xE5\xB8\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA1"],

        ["\xC4\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB3"],
        ["\xE5\xB8\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA2"],

        ["\xC4\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x81"],
        ["\xE5\xBA\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA3"],

        ["\xC4\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x94"],
        ["\xE5\xBC\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA4"],

        ["\xC4\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB5"],
        ["\xE5\xBC\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA5"],

        ["\xC4\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAB"],
        ["\xE5\xBD\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA6"],

        ["\xC4\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB4"],
        ["\xE5\xBE\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA7"],

        ["\xC4\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB2"],
        ["\xE6\x87\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA8"],

        ["\xC4\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x91"],
        ["\xE6\x8C\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xA9"],

        ["\xC4\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xA2"],
        ["\xE6\x9A\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xAA"],

        ["\xC4\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9D"],
        ["\xE6\x9C\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xAB"],

        ["\xC4\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAE"],
        ["\xE6\xBD\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xAC"],

        ["\xC4\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x92"],
        ["\xE7\x89\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xAD"],

        ["\xC4\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBA"],
        ["\xE7\x94\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xAE"],

        ["\xC4\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xBA"],
        ["\xE7\x9C\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xAF"],

        ["\xC4\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB4"],
        ["\xE8\x81\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB0"],

        ["\xC4\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB9"],
        ["\xE8\x84\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB1"],

        ["\xC4\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB8"],
        ["\xE8\x85\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB2"],

        ["\xC4\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB6"],
        ["\xE8\x9D\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB3"],

        ["\xC4\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xBF"],
        ["\xE8\xAA\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB4"],

        ["\xC4\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9C"],
        ["\xE8\xAB\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB5"],

        ["\xC4\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x85"],
        ["\xE8\xB6\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB6"],

        ["\xC4\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xB3"],
        ["\xE8\xB7\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB7"],

        ["\xC4\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9A"],
        ["\xE9\x8A\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB8"],

        ["\xC4\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x95\xB7"],
        ["\xE9\x95\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xB9"],

        ["\xC4\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x82"],
        ["\xE9\xA0\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xBA"],

        ["\xC4\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA5"],
        ["\xE9\xB3\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xBB"],

        ["\xC4\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x85"],
        ["\xE5\x8B\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xBC"],

        ["\xC4\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x97"],
        ["\xE6\x8D\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xBD"],

        ["\xC4\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB4"],
        ["\xE7\x9B\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xBE"],

        ["\xC4\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x95"],
        ["\xE6\x9C\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xBF"],

        ["\xC4\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x88"],
        ["\xE6\xB2\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC0"],

        ["\xC4\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8D"],
        ["\xE7\x8F\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC1"],

        ["\xC4\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x83"],
        ["\xE8\xB3\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC2"],

        ["\xC4\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAE"],
        ["\xE9\x8E\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC3"],

        ["\xC4\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB3"],
        ["\xE9\x99\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC4"],

        ["\xC4\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xA5"],
        ["\xE6\xB4\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC5"],

        ["\xC4\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9C"],
        ["\xE5\xA2\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC6"],

        ["\xC4\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8E"],
        ["\xE6\xA4\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC7"],

        ["\xC4\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8C"],
        ["\xE6\xA7\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC8"],

        ["\xC4\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xBD"],
        ["\xE8\xBF\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xC9"],

        ["\xC4\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x9A"],
        ["\xE9\x8E\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xCA"],

        ["\xC4\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x9B"],
        ["\xE7\x97\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xCB"],

        ["\xC4\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9A"],
        ["\xE9\x80\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xCC"],

        ["\x47\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x9A"],
        ["\xE5\xA1\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xC9"],

        ["\xC4\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x82"],
        ["\xE6\xA0\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xCE"],

        ["\xC4\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB4"],
        ["\xE6\x8E\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xCF"],

        ["\xC4\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBB"],
        ["\xE6\xA7\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD0"],

        ["\xC4\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x83"],
        ["\xE4\xBD\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD1"],

        ["\xC4\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xAC"],
        ["\xE6\xBC\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD2"],

        ["\xC4\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x98"],
        ["\xE6\x9F\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD3"],

        ["\xC4\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBB"],
        ["\xE8\xBE\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD4"],

        ["\xC4\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA6"],
        ["\xE8\x94\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD5"],

        ["\xC4\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB4"],
        ["\xE7\xB6\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD6"],

        ["\xC4\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x94"],
        ["\xE9\x8D\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD7"],

        ["\xC4\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xBF"],
        ["\xE6\xA4\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD8"],

        ["\xC4\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB0"],
        ["\xE6\xBD\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xD9"],

        ["\xC4\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xAA"],
        ["\xE5\x9D\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xDA"],

        ["\xD4\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB7"],
        ["\xE5\xA3\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE4"],

        ["\xC4\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xAC"],
        ["\xE5\xAC\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xDC"],

        ["\xC4\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAC"],
        ["\xE7\xB4\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xDD"],

        ["\xC4\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAA"],
        ["\xE7\x88\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xDE"],

        ["\xC4\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8A"],
        ["\xE5\x90\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xDF"],

        ["\xC4\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA3"],
        ["\xE9\x87\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE0"],

        ["\xC4\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB4"],
        ["\xE9\xB6\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE1"],

        ["\xC4\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAD"],
        ["\xE4\xBA\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE2"],

        ["\xC4\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x8E"],
        ["\xE4\xBD\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE3"],

        ["\xC4\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x9C"],
        ["\xE5\x81\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE4"],

        ["\xC4\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB5"],
        ["\xE5\x81\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE5"],

        ["\xC4\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x83"],
        ["\xE5\x89\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE6"],

        ["\xC4\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x9E"],
        ["\xE8\xB2\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE7"],

        ["\xC4\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x88"],
        ["\xE5\x91\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],

        ["\xC4\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xA4"],
        ["\xE5\xA0\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xE9"],

        ["\xC4\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9A"],
        ["\xE5\xAE\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xEA"],

        ["\xC4\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9D"],
        ["\xE5\xB8\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xEB"],

        ["\xC4\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x95"],
        ["\xE5\xBA\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xEC"],

        ["\xC4\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xAD"],
        ["\xE5\xBA\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xED"],

        ["\xC4\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB7"],
        ["\xE5\xBB\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xEE"],

        ["\xC4\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x9F"],
        ["\xE5\xBC\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xEF"],

        ["\xC4\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8C"],
        ["\xE6\x82\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF0"],

        ["\xC4\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB5"],
        ["\xE6\x8A\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF1"],

        ["\xC4\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBA"],
        ["\xE6\x8C\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF2"],

        ["\xC4\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x90"],
        ["\xE6\x8F\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF3"],

        ["\xC4\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xAF"],
        ["\xE6\xA2\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF4"],

        ["\xC4\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x80"],
        ["\xE6\xB1\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF5"],

        ["\xC4\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x87"],
        ["\xE7\xA2\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF6"],

        ["\xC4\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8E"],
        ["\xE7\xA6\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF7"],

        ["\xC4\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8B"],
        ["\xE7\xA8\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF8"],

        ["\xC4\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA0"],
        ["\xE7\xB7\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xF9"],

        ["\xC4\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x87"],
        ["\xE8\x89\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xFA"],

        ["\xC4\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x82"],
        ["\xE8\xA8\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xFB"],

        ["\xC4\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA6"],
        ["\xE8\xAB\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xFC"],

        ["\xC4\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x84"],
        ["\xE8\xB9\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xFD"],

        ["\xC4\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x93"],
        ["\xE9\x80\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xFE"],

        ["\xC5\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB8"],
        ["\xE9\x82\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA1"],

        ["\xC5\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xAD"],
        ["\xE9\x84\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA2"],

        ["\xC5\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x98"],
        ["\xE9\x87\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA3"],

        ["\xC5\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\x8E"],
        ["\xE9\xBC\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA4"],

        ["\xC5\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA5"],
        ["\xE6\xB3\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA5"],

        ["\xC5\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x98"],
        ["\xE6\x91\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA6"],

        ["\xC5\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA2"],
        ["\xE6\x93\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA7"],

        ["\xC5\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB5"],
        ["\xE6\x95\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA8"],

        ["\xC5\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB4"],
        ["\xE6\xBB\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xA9"],

        ["\xC5\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x84"],
        ["\xE7\x9A\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xAA"],

        ["\xC5\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x9B"],
        ["\xE7\xAC\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xAB"],

        ["\xC5\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA9"],
        ["\xE9\x81\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xAC"],

        ["\xC5\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x91"],
        ["\xE9\x8F\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xAD"],

        ["\xC5\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xBA"],
        ["\xE6\xBA\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xAE"],

        ["\xC5\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xB2"],
        ["\xE5\x93\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xAF"],

        ["\xC5\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB9"],
        ["\xE5\xBE\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB0"],

        ["\xC5\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA4"],
        ["\xE6\x92\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB1"],

        ["\xC5\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8D"],
        ["\xE8\xBD\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB2"],

        ["\xC5\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAD"],
        ["\xE8\xBF\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB3"],

        ["\xC5\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x84"],
        ["\xE9\x89\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB4"],

        ["\xC5\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB8"],
        ["\xE5\x85\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB5"],

        ["\x47\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xAB"],
        ["\xE5\xA1\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x47\xCA"],

        ["\xC5\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA9"],
        ["\xE5\xA4\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB7"],

        ["\xC5\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x95"],
        ["\xE5\xB1\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB8"],

        ["\xC5\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x97"],
        ["\xE5\xBA\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xB9"],

        ["\xC5\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xBB"],
        ["\xE6\xB7\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xBA"],

        ["\xC5\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8F"],
        ["\xE7\xBA\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xBB"],

        ["\xC5\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9C"],
        ["\xE7\x94\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xBC"],

        ["\xC5\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBC"],
        ["\xE8\xB2\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xBD"],

        ["\xC5\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xA2"],
        ["\xE8\xBB\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xBE"],

        ["\x6C\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x9B"],
        ["\xE9\xA1\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x6C\xFC"],

        ["\xC5\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB9"],
        ["\xE7\x82\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC0"],

        ["\xC5\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9D"],
        ["\xE4\xBC\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC1"],

        ["\xC5\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBF"],
        ["\xE6\xAE\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC2"],

        ["\xC5\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB1"],
        ["\xE6\xBE\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC3"],

        ["\xC5\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB0"],
        ["\xE7\x94\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC4"],

        ["\xC5\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xBB"],
        ["\xE9\x9B\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC5"],

        ["\xC5\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8E"],
        ["\xE5\x85\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC6"],

        ["\xC5\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x90"],
        ["\xE5\x90\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC7"],

        ["\xC5\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB5"],
        ["\xE5\xA0\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC8"],

        ["\xC5\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x97"],
        ["\xE5\xA1\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xC9"],

        ["\xC5\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xAC"],
        ["\xE5\xA6\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xCA"],

        ["\xC5\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA0"],
        ["\xE5\xB1\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xCB"],

        ["\xC5\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x92"],
        ["\xE5\xBE\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xCC"],

        ["\xC5\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x97"],
        ["\xE6\x96\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xCD"],

        ["\xC5\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9C"],
        ["\xE6\x9D\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xCE"],

        ["\xC5\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA1"],
        ["\xE6\xB8\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xCF"],

        ["\xC5\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBB"],
        ["\xE7\x99\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD0"],

        ["\xC5\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x9F"],
        ["\xE8\x8F\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD1"],

        ["\xC5\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xAD"],
        ["\xE8\xB3\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD2"],

        ["\xC5\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x94"],
        ["\xE9\x80\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD3"],

        ["\xC5\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xBD"],
        ["\xE9\x83\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD4"],

        ["\xC5\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x8D"],
        ["\xE9\x8D\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD5"],

        ["\xC5\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA5"],
        ["\xE7\xA0\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD6"],

        ["\xE2\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xBA"],
        ["\xE7\xA0\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],

        ["\xC5\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAA"],
        ["\xE5\x8A\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD8"],

        ["\xC5\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA6"],
        ["\xE5\xBA\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD9"],

        ["\xC5\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x9F"],
        ["\xE5\x9C\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xDA"],

        ["\xC5\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB4"],
        ["\xE5\xA5\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xDB"],

        ["\xC5\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x92"],
        ["\xE6\x80\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xDC"],

        ["\xC5\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x92"],
        ["\xE5\x80\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xDD"],

        ["\xC5\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x9A"],
        ["\xE5\x85\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xDE"],

        ["\xC5\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAC"],
        ["\xE5\x86\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xDF"],

        ["\xC5\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8D"],
        ["\xE5\x87\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE0"],

        ["\xC5\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x80"],
        ["\xE5\x88\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE1"],

        ["\xC5\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x90"],
        ["\xE5\x94\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE2"],

        ["\xC5\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x94"],
        ["\xE5\xA1\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE3"],

        ["\xC5\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x98"],
        ["\xE5\xA1\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE4"],

        ["\xC5\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x97"],
        ["\xE5\xA5\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE5"],

        ["\xC5\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x95"],
        ["\xE5\xAE\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE6"],

        ["\xC5\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB6"],
        ["\xE5\xB3\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE7"],

        ["\xC5\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x8B"],
        ["\xE5\xB6\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE8"],

        ["\xC5\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xBC"],
        ["\xE6\x82\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xE9"],

        ["\xC5\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x95"],
        ["\xE6\x8A\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xEA"],

        ["\xC5\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xAD"],
        ["\xE6\x90\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xEB"],

        ["\xC5\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB1"],
        ["\xE6\x9D\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xEC"],

        ["\xC5\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x83"],
        ["\xE6\xA1\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xED"],

        ["\xDB\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xBC"],
        ["\xE6\xA2\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xED"],

        ["\xC5\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x9F"],
        ["\xE6\xA3\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xEF"],

        ["\xC5\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x97"],
        ["\xE7\x9B\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF0"],

        ["\xC5\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x98"],
        ["\xE6\xB7\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF1"],

        ["\xC5\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAF"],
        ["\xE6\xB9\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF2"],

        ["\xDE\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x9B"],
        ["\xE6\xB6\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB9"],

        ["\xC5\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xAF"],
        ["\xE7\x81\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF4"],

        ["\xC5\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x88"],
        ["\xE7\x87\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF5"],

        ["\xC5\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x93"],
        ["\xE5\xBD\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF6"],

        ["\xC5\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x98"],
        ["\xE7\x97\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF7"],

        ["\xC5\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xB7"],
        ["\xE7\xA5\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF8"],

        ["\xC5\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x89"],
        ["\xE7\xAD\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF9"],

        ["\xC5\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x94"],
        ["\xE7\xAD\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xFA"],

        ["\xC5\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x92"],
        ["\xE7\xAD\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xFB"],

        ["\xC5\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x96"],
        ["\xE7\xB3\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xFC"],

        ["\xC5\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB1"],
        ["\xE7\xB5\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xFD"],

        ["\xC5\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB0"],
        ["\xE5\x88\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xFE"],

        ["\xC6\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA3"],
        ["\xE8\x91\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA1"],

        ["\xC6\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA9"],
        ["\xE8\x95\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA2"],

        ["\xC6\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA4"],
        ["\xE8\x97\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA3"],

        ["\xC6\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8E"],
        ["\xE8\xA8\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA4"],

        ["\xC6\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x84"],
        ["\xE8\xAC\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA5"],

        ["\xC6\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x86"],
        ["\xE8\xB1\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA6"],

        ["\xC6\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x8F"],
        ["\xE8\xB8\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA7"],

        ["\xC6\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x83"],
        ["\xE9\x80\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA8"],

        ["\xC6\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8F"],
        ["\xE9\x80\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xA9"],

        ["\xC6\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x99"],
        ["\xE9\x90\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xAA"],

        ["\xC6\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB6"],
        ["\xE9\x99\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xAB"],

        ["\xC6\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xAD"],
        ["\xE9\xA0\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xAC"],

        ["\xC6\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xB0"],
        ["\xE9\xA8\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xAD"],

        ["\xC6\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x98"],
        ["\xE9\x97\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xAE"],

        ["\xC6\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8D"],
        ["\xE5\x83\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xAF"],

        ["\xC6\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x95"],
        ["\xE5\x8B\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB0"],

        ["\xC6\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8C"],
        ["\xE5\x90\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB1"],

        ["\xC6\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x82"],
        ["\xE5\xA0\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB2"],

        ["\xC6\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8E"],
        ["\xE5\xB0\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB3"],

        ["\xC6\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA7"],
        ["\xE6\x86\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB4"],

        ["\xC6\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9E"],
        ["\xE6\x92\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB5"],

        ["\xC6\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9E"],
        ["\xE6\xB4\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB6"],

        ["\xC6\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB3"],
        ["\xE7\x9E\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB7"],

        ["\xC6\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA5"],
        ["\xE7\xAB\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB8"],

        ["\xC6\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB4"],
        ["\xE8\x83\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xB9"],

        ["\xC6\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x84"],
        ["\xE8\x90\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xBA"],

        ["\xC6\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x93"],
        ["\xE9\x81\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xBB"],

        ["\xC6\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x85"],
        ["\xE9\x8A\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xBC"],

        ["\xC6\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA0"],
        ["\xE5\xB3\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xBD"],

        ["\xC6\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x87"],
        ["\xE9\xB4\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xBE"],

        ["\xC6\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xBF"],
        ["\xE5\x8C\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xBF"],

        ["\xC6\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x97"],
        ["\xE5\xBE\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC0"],

        ["\xC6\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xB3"],
        ["\xE5\xBE\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC1"],

        ["\xC6\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x9C"],
        ["\xE6\xB6\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC2"],

        ["\xC6\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB9"],
        ["\xE7\x89\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC3"],

        ["\xC6\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA3"],
        ["\xE7\x9D\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC4"],

        ["\xC6\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBF"],
        ["\xE7\xA6\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC5"],

        ["\xC6\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA4"],
        ["\xE7\xAF\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC6"],

        ["\xC6\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x92"],
        ["\xE6\xAF\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC7"],

        ["\xC6\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xAC"],
        ["\xE7\x8B\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC8"],

        ["\xC6\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xAD"],
        ["\xE8\xAA\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xC9"],

        ["\xC6\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x83"],
        ["\xE6\xA0\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xCA"],

        ["\xC6\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA1"],
        ["\xE6\xA9\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xCB"],

        ["\xC6\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB8"],
        ["\xE5\x87\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xCC"],

        ["\xC6\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x81"],
        ["\xE7\xAA\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xCD"],

        ["\xC6\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB4"],
        ["\xE6\xA4\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xCE"],

        ["\xC6\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8A"],
        ["\xE5\xB1\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xCF"],

        ["\xC6\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB6"],
        ["\xE9\xB3\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD0"],

        ["\xC6\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xAB"],
        ["\xE8\x8B\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD1"],

        ["\xC6\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x85"],
        ["\xE5\xAF\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD2"],

        ["\xC6\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x89"],
        ["\xE9\x85\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD3"],

        ["\xC6\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9E"],
        ["\xE7\x80\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD4"],

        ["\xC6\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB8"],
        ["\xE5\x99\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD5"],

        ["\xC6\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAF"],
        ["\xE5\xB1\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD6"],

        ["\xC6\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x87"],
        ["\xE6\x83\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD7"],

        ["\xC6\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xA6"],
        ["\xE6\x95\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD8"],

        ["\xC6\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x8C"],
        ["\xE6\xB2\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xD9"],

        ["\xC6\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x9A"],
        ["\xE8\xB1\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xDA"],

        ["\xC6\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x81"],
        ["\xE9\x81\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xDB"],

        ["\xC6\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x93"],
        ["\xE9\xA0\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xDC"],

        ["\xC6\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x91"],
        ["\xE5\x91\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xDD"],

        ["\xC6\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x87"],
        ["\xE6\x9B\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xDE"],

        ["\xC6\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x8D"],
        ["\xE9\x88\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xDF"],

        ["\xC6\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x88"],
        ["\xE5\xA5\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE0"],

        ["\xC6\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA3"],
        ["\xE9\x82\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE1"],

        ["\xC6\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x85"],
        ["\xE5\x86\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE2"],

        ["\xC6\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8D"],
        ["\xE4\xB9\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE3"],

        ["\xC6\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAA"],
        ["\xE5\x87\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE4"],

        ["\xC6\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x99"],
        ["\xE8\x96\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE5"],

        ["\xC6\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x8E"],
        ["\xE8\xAC\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE6"],

        ["\xC6\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x98"],
        ["\xE7\x81\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE7"],

        ["\xC6\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xBA"],
        ["\xE6\x8D\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE8"],

        ["\xC6\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x8B"],
        ["\xE9\x8D\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xE9"],

        ["\xC6\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA2"],
        ["\xE6\xA5\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xEA"],

        ["\xC6\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xB4"],
        ["\xE9\xA6\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xEB"],

        ["\xC6\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x84"],
        ["\xE7\xB8\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xEC"],

        ["\xC6\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB7"],
        ["\xE7\x95\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xED"],

        ["\xC6\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x97"],
        ["\xE5\x8D\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xEE"],

        ["\xC6\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA0"],
        ["\xE6\xA5\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xEF"],

        ["\xC6\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x9F"],
        ["\xE8\xBB\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF0"],

        ["\xC6\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA3"],
        ["\xE9\x9B\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF1"],

        ["\xC6\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9D"],
        ["\xE6\xB1\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF2"],

        ["\xC6\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8C"],
        ["\xE4\xBA\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF3"],

        ["\xC6\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBC"],
        ["\xE5\xB0\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF4"],

        ["\xC6\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x90"],
        ["\xE5\xBC\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF5"],

        ["\xED\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA9"],
        ["\xE8\xBF\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xEE"],

        ["\xC6\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x82"],
        ["\xE5\x8C\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF7"],

        ["\xC6\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x91"],
        ["\xE8\xB3\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF8"],

        ["\xC6\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x89"],
        ["\xE8\x82\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF9"],

        ["\xC6\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xB9"],
        ["\xE8\x99\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xFA"],

        ["\xC6\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBF"],
        ["\xE5\xBB\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xFB"],

        ["\xC6\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA5"],
        ["\xE6\x97\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xFC"],

        ["\xC6\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xB3"],
        ["\xE4\xB9\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xFD"],

        ["\xC6\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA5"],
        ["\xE5\x85\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xFE"],

        ["\xC7\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x82"],
        ["\xE5\xA6\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA1"],

        ["\xC7\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBF"],
        ["\xE5\xB0\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA2"],

        ["\xC7\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xAE"],
        ["\xE9\x9F\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA3"],

        ["\xC7\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xBB"],
        ["\xE4\xBB\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA4"],

        ["\xC7\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x8A"],
        ["\xE5\xA6\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA5"],

        ["\xC7\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x8D"],
        ["\xE5\xBF\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA6"],

        ["\xC7\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x8D"],
        ["\xE8\xAA\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA7"],

        ["\xC7\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA1"],
        ["\xE6\xBF\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA8"],

        ["\xC7\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB0"],
        ["\xE7\xA6\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xA9"],

        ["\xC7\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA2"],
        ["\xE7\xA5\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xAA"],

        ["\xC7\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA7"],
        ["\xE5\xAF\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xAB"],

        ["\xC7\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB1"],
        ["\xE8\x91\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xAC"],

        ["\xC7\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAB"],
        ["\xE7\x8C\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xAD"],

        ["\xC7\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xB1"],
        ["\xE7\x86\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xAE"],

        ["\xC7\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB4"],
        ["\xE5\xB9\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xAF"],

        ["\xC7\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB5"],
        ["\xE5\xBF\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB0"],

        ["\xC7\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xBB"],
        ["\xE6\x8D\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB1"],

        ["\xC7\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x9A"],
        ["\xE6\x92\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB2"],

        ["\xC7\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x83"],
        ["\xE7\x87\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB3"],

        ["\xC7\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x98"],
        ["\xE7\xB2\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB4"],

        ["\xC7\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x83"],
        ["\xE4\xB9\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB5"],

        ["\xC7\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBC"],
        ["\xE5\xBB\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB6"],

        ["\xC7\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8B"],
        ["\xE4\xB9\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB7"],

        ["\xC7\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x9C"],
        ["\xE5\x9F\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB8"],

        ["\xC7\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA2"],
        ["\xE5\x9A\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xB9"],

        ["\xC7\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA9"],
        ["\xE6\x82\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xBA"],

        ["\xC7\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x83"],
        ["\xE6\xBF\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xBB"],

        ["\xC7\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8D"],
        ["\xE7\xB4\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xBC"],

        ["\xC7\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xBD"],
        ["\xE8\x83\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xBD"],

        ["\xC7\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xB3"],
        ["\xE8\x84\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xBE"],

        ["\xC7\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBF"],
        ["\xE8\x86\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xBF"],

        ["\xC7\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB2"],
        ["\xE8\xBE\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC0"],

        ["\xC7\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x97"],
        ["\xE8\xA6\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC1"],

        ["\xC7\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA4"],
        ["\xE8\x9A\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC2"],

        ["\xC7\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB4"],
        ["\xE5\xB7\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC3"],

        ["\xC7\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x8A"],
        ["\xE6\x8A\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC4"],

        ["\xC7\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAD"],
        ["\xE6\x92\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC5"],

        ["\xC7\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x87"],
        ["\xE8\xA6\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC6"],

        ["\xC7\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB7"],
        ["\xE6\x9D\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC7"],

        ["\xC7\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA2"],
        ["\xE6\xB3\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC8"],

        ["\xC7\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBE"],
        ["\xE6\xB4\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xC9"],

        ["\xC7\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB6"],
        ["\xE7\x90\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xCA"],

        ["\xC7\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xB4"],
        ["\xE7\xA0\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xCB"],

        ["\xC7\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x86"],
        ["\xE5\xA9\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xCC"],

        ["\xC7\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB5"],
        ["\xE7\xBD\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xCD"],

        ["\xC7\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAD"],
        ["\xE8\x8A\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xCE"],

        ["\xC7\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xAC"],
        ["\xE9\xA6\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xCF"],

        ["\xC7\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB3"],
        ["\xE4\xBF\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD0"],

        ["\xC7\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x83"],
        ["\xE5\xBB\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD1"],

        ["\xC7\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9D"],
        ["\xE6\x8B\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD2"],

        ["\xC7\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x92"],
        ["\xE6\x8E\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD3"],

        ["\xC7\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x97"],
        ["\xE6\x95\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD4"],

        ["\xC7\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAF"],
        ["\xE6\x9D\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD5"],

        ["\xC7\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x83"],
        ["\xE7\x9B\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD6"],

        ["\xC7\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x8C"],
        ["\xE7\x89\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD7"],

        ["\xC7\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x8C"],
        ["\xE8\x83\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD8"],

        ["\xC7\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xBA"],
        ["\xE8\x82\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xD9"],

        ["\xC7\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xA9"],
        ["\xE8\xBC\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xDA"],

        ["\xC7\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8D"],
        ["\xE9\x85\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xDB"],

        ["\xC7\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8D"],
        ["\xE5\x80\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xDC"],

        ["\xC7\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xB9"],
        ["\xE5\x9F\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xDD"],

        ["\xC7\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x92"],
        ["\xE5\xAA\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xDE"],

        ["\xC7\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x85"],
        ["\xE6\xA2\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xDF"],

        ["\xC7\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB3"],
        ["\xE6\xA5\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE0"],

        ["\xC7\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA4"],
        ["\xE7\x85\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE1"],

        ["\xC7\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xBD"],
        ["\xE7\x8B\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE2"],

        ["\xC7\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB7"],
        ["\xE8\xB2\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE3"],

        ["\xC7\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB2"],
        ["\xE5\xA3\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE4"],

        ["\xC7\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA0"],
        ["\xE8\xB3\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE5"],

        ["\xC7\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xAA"],
        ["\xE9\x99\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE6"],

        ["\xC7\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x99"],
        ["\xE9\x80\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE7"],

        ["\xEA\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xBF"],
        ["\xE8\x9D\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA4"],

        ["\xC7\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA4"],
        ["\xE7\xA7\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE9"],

        ["\xC7\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA7"],
        ["\xE7\x9F\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xEA"],

        ["\xC7\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA9"],
        ["\xE8\x90\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xEB"],

        ["\xC7\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xAF"],
        ["\xE4\xBC\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xEC"],

        ["\xC7\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA5"],
        ["\xE5\x89\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xED"],

        ["\xC7\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9A"],
        ["\xE5\x8D\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xEE"],

        ["\xC7\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8D"],
        ["\xE6\x8B\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xEF"],

        ["\xC7\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8F"],
        ["\xE6\x9F\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF0"],

        ["\xC7\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x8A"],
        ["\xE6\xB3\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF1"],

        ["\xC7\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBD"],
        ["\xE7\x99\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF2"],

        ["\xC7\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x94"],
        ["\xE7\xAE\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF3"],

        ["\xC7\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x95"],
        ["\xE7\xB2\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF4"],

        ["\xC7\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB6"],
        ["\xE8\x88\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF5"],

        ["\xC7\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x84"],
        ["\xE8\x96\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF6"],

        ["\xC7\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAB"],
        ["\xE8\xBF\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF7"],

        ["\xC7\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9D"],
        ["\xE6\x9B\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF8"],

        ["\xC7\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA0"],
        ["\xE6\xBC\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xF9"],

        ["\xC7\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x86"],
        ["\xE7\x88\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xFA"],

        ["\xC7\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9B"],
        ["\xE7\xB8\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xFB"],

        ["\xC7\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xAB"],
        ["\xE8\x8E\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xFC"],

        ["\xC7\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x81"],
        ["\xE9\xA7\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xFD"],

        ["\xC7\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA6"],
        ["\xE9\xBA\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xFE"],

        ["\xC8\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBD"],
        ["\xE5\x87\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA1"],

        ["\xC8\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB1"],
        ["\xE7\xAE\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA2"],

        ["\xC8\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xB2"],
        ["\xE7\xA1\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA3"],

        ["\xC8\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB8"],
        ["\xE7\xAE\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA4"],

        ["\xC8\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x87"],
        ["\xE8\x82\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA5"],

        ["\xC8\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x88"],
        ["\xE7\xAD\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA6"],

        ["\xC8\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xA8"],
        ["\xE6\xAB\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA7"],

        ["\xC8\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA1"],
        ["\xE5\xB9\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA8"],

        ["\xC8\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x8C"],
        ["\xE8\x82\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xA9"],

        ["\xC8\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x91"],
        ["\xE7\x95\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xAA"],

        ["\xC8\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA0"],
        ["\xE7\x95\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xAB"],

        ["\xC8\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAB"],
        ["\xE5\x85\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xAC"],

        ["\xC8\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA2"],
        ["\xE9\x89\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xAD"],

        ["\xC8\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x8C"],
        ["\xE6\xBA\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xAE"],

        ["\xC8\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBA"],
        ["\xE7\x99\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xAF"],

        ["\xC8\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x97"],
        ["\xE9\x86\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB0"],

        ["\xC8\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAA"],
        ["\xE9\xAB\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB1"],

        ["\xC8\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x90"],
        ["\xE4\xBC\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB2"],

        ["\xC8\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB0"],
        ["\xE7\xBD\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB3"],

        ["\xC8\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9C"],
        ["\xE6\x8A\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB4"],

        ["\xC8\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8F"],
        ["\xE7\xAD\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB5"],

        ["\xC8\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA5"],
        ["\xE9\x96\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB6"],

        ["\xC8\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA9"],
        ["\xE9\xB3\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB7"],

        ["\xC8\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xBA"],
        ["\xE5\x99\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB8"],

        ["\xC8\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x99"],
        ["\xE5\xA1\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xB9"],

        ["\xC8\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xA4"],
        ["\xE8\x9B\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xBA"],

        ["\xC8\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xBC"],
        ["\xE9\x9A\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xBB"],

        ["\xC8\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB4"],
        ["\xE4\xBC\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xBC"],

        ["\xC8\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA4"],
        ["\xE5\x88\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xBD"],

        ["\xC8\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x8A"],
        ["\xE5\x8D\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xBE"],

        ["\xC8\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8D"],
        ["\xE5\x8F\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xBF"],

        ["\xC8\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9B"],
        ["\xE5\x8F\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC0"],

        ["\xC8\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x86"],
        ["\xE5\xB8\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC1"],

        ["\xC8\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xAC"],
        ["\xE6\x90\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC2"],

        ["\xC8\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x91"],
        ["\xE6\x96\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC3"],

        ["\xC8\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBF"],
        ["\xE6\x9D\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC4"],

        ["\xC8\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xBE"],
        ["\xE6\xB0\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC5"],

        ["\xC8\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x8E"],
        ["\xE6\xB1\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC6"],

        ["\xC8\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x88"],
        ["\xE7\x89\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC7"],

        ["\xC8\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xAF"],
        ["\xE7\x8A\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC8"],

        ["\xC8\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAD"],
        ["\xE7\x8F\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xC9"],

        ["\xC8\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x94"],
        ["\xE7\x95\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xCA"],

        ["\xC8\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x81"],
        ["\xE7\xB9\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xCB"],

        ["\xC8\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAC"],
        ["\xE8\x88\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xCC"],

        ["\xC8\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA9"],
        ["\xE8\x97\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xCD"],

        ["\xC8\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA9"],
        ["\xE8\xB2\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xCE"],

        ["\xC8\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x84"],
        ["\xE7\xAF\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xCF"],

        ["\xC8\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x86"],
        ["\xE9\x87\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD0"],

        ["\xC8\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA9"],
        ["\xE7\x85\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD1"],

        ["\xC8\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x92"],
        ["\xE9\xA0\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD2"],

        ["\xC8\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAF"],
        ["\xE9\xA3\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD3"],

        ["\xC8\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBD"],
        ["\xE6\x8C\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD4"],

        ["\xC8\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA9"],
        ["\xE6\x99\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD5"],

        ["\xC8\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAA"],
        ["\xE7\x95\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD6"],

        ["\xC8\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA4"],
        ["\xE7\x9B\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD7"],

        ["\xC8\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x90"],
        ["\xE7\xA3\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD8"],

        ["\xC8\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x83"],
        ["\xE8\x95\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xD9"],

        ["\xC8\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAE"],
        ["\xE8\x9B\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xDA"],

        ["\xC8\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xAA"],
        ["\xE5\x8C\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xDB"],

        ["\xC8\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x91"],
        ["\xE5\x8D\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xDC"],

        ["\xC8\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA6"],
        ["\xE5\x90\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xDD"],

        ["\xC8\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x83"],
        ["\xE5\xA6\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xDE"],

        ["\xC8\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x87"],
        ["\xE5\xBA\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xDF"],

        ["\xC8\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xBC"],
        ["\xE5\xBD\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE0"],

        ["\xC8\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB2"],
        ["\xE6\x82\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE1"],

        ["\xC8\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x89"],
        ["\xE6\x89\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE2"],

        ["\xC8\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB9"],
        ["\xE6\x89\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE3"],

        ["\xC8\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xAB"],
        ["\xE6\x8A\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE4"],

        ["\xC8\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x90"],
        ["\xE6\x96\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE5"],

        ["\xC8\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x94"],
        ["\xE6\xAF\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE6"],

        ["\xC8\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x8C"],
        ["\xE6\xB3\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE7"],

        ["\xC8\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB2"],
        ["\xE7\x96\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE8"],

        ["\xC8\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xAE"],
        ["\xE7\x9A\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xE9"],

        ["\xC8\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x91"],
        ["\xE7\xA2\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xEA"],

        ["\xC8\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x98"],
        ["\xE7\xA7\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xEB"],

        ["\xC8\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x8B"],
        ["\xE7\xB7\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xEC"],

        ["\xC8\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB7"],
        ["\xE7\xBD\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xED"],

        ["\xC8\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xA5"],
        ["\xE8\x82\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xEE"],

        ["\xC8\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xAB"],
        ["\xE8\xA2\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xEF"],

        ["\xC8\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xB9"],
        ["\xE8\xAA\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF0"],

        ["\xC8\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBB"],
        ["\xE8\xB2\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF1"],

        ["\xC8\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBF"],
        ["\xE9\x81\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF2"],

        ["\xC8\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x9E"],
        ["\xE9\x9D\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF3"],

        ["\xC8\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9B"],
        ["\xE9\xA3\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF4"],

        ["\xC8\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8B"],
        ["\xE6\xA8\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF5"],

        ["\xC8\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB8"],
        ["\xE7\xB0\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF6"],

        ["\xC8\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x99"],
        ["\xE5\x82\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF7"],

        ["\xC8\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xBE"],
        ["\xE5\xB0\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF8"],

        ["\xC8\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAE"],
        ["\xE5\xBE\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xF9"],

        ["\xC8\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x87"],
        ["\xE6\x9E\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xFA"],

        ["\xC8\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x98"],
        ["\xE6\xAF\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xFB"],

        ["\xC8\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB5"],
        ["\xE7\x90\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xFC"],

        ["\xC8\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x89"],
        ["\xE7\x9C\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xFD"],

        ["\xC8\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8E"],
        ["\xE7\xBE\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC8\xFE"],

        ["\xC9\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC\xBB"],
        ["\xE9\xBC\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA1"],

        ["\xC9\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8A"],
        ["\xE6\x9F\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA2"],

        ["\xC9\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x97"],
        ["\xE7\xA8\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA3"],

        ["\xC9\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB9"],
        ["\xE5\x8C\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA4"],

        ["\xC9\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8B"],
        ["\xE7\x96\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA5"],

        ["\xC9\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAD"],
        ["\xE9\xAB\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA6"],

        ["\xC9\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA6"],
        ["\xE5\xBD\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA7"],

        ["\xC9\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9D"],
        ["\xE8\x86\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA8"],

        ["\xC9\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB1"],
        ["\xE8\x8F\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xA9"],

        ["\xC9\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x98"],
        ["\xE8\x82\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xAA"],

        ["\xC9\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xBC"],
        ["\xE5\xBC\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xAB"],

        ["\xC9\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x85"],
        ["\xE5\xBF\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xAC"],

        ["\xC9\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA2"],
        ["\xE7\x95\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xAD"],

        ["\xC9\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x86"],
        ["\xE7\xAD\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xAE"],

        ["\xC9\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xBC"],
        ["\xE9\x80\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xAF"],

        ["\xDB\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xA7"],
        ["\xE6\xA1\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD8"],

        ["\xC9\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xAB"],
        ["\xE5\xA7\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB1"],

        ["\xC9\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9B"],
        ["\xE5\xAA\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB2"],

        ["\xC9\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x90"],
        ["\xE7\xB4\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB3"],

        ["\xC9\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBE"],
        ["\xE7\x99\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB4"],

        ["\xC9\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xAC"],
        ["\xE8\xAC\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB5"],

        ["\xC9\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB5"],
        ["\xE4\xBF\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB6"],

        ["\xC9\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAA"],
        ["\xE5\xBD\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB7"],

        ["\xC9\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x99"],
        ["\xE6\xA8\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB8"],

        ["\xC9\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xB7"],
        ["\xE6\xB0\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB9"],

        ["\xC9\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x82"],
        ["\xE6\xBC\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xBA"],

        ["\xC9\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA2"],
        ["\xE7\x93\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xBB"],

        ["\xC9\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA8"],
        ["\xE7\xA5\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xBC"],

        ["\xC9\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA8"],
        ["\xE8\xA1\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xBD"],

        ["\xC9\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x95"],
        ["\xE8\xA9\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xBE"],

        ["\xC9\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xB9"],
        ["\xE8\xB1\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xBF"],

        ["\xC9\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9F"],
        ["\xE5\xBB\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC0"],

        ["\xC9\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x8F"],
        ["\xE6\x8F\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC1"],

        ["\xC9\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x85"],
        ["\xE7\x97\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC2"],

        ["\xC9\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x92"],
        ["\xE7\xA7\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC3"],

        ["\xC9\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x97"],
        ["\xE8\x8B\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC4"],

        ["\xC9\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA8"],
        ["\xE9\x8C\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC5"],

        ["\xC9\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xB2"],
        ["\xE9\x8B\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC6"],

        ["\xC9\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x9C"],
        ["\xE8\x92\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC7"],

        ["\xC9\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAD"],
        ["\xE8\x9B\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC8"],

        ["\xC9\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAD"],
        ["\xE9\xB0\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xC9"],

        ["\xC9\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x81"],
        ["\xE5\x93\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xCA"],

        ["\xC9\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAC"],
        ["\xE5\xBD\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xCB"],

        ["\xC9\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x8C"],
        ["\xE6\x96\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xCC"],

        ["\xC9\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x9C"],
        ["\xE6\xB5\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xCD"],

        ["\xC9\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x95"],
        ["\xE7\x80\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xCE"],

        ["\xC9\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA7"],
        ["\xE8\xB2\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xCF"],

        ["\xC9\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x93"],
        ["\xE8\xB3\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD0"],

        ["\xC9\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xBB"],
        ["\xE9\xA0\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD1"],

        ["\xC9\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x8F"],
        ["\xE6\x95\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD2"],

        ["\xC9\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB6"],
        ["\xE7\x93\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD3"],

        ["\xC9\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8D"],
        ["\xE4\xB8\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD4"],

        ["\xC9\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x98"],
        ["\xE4\xBB\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD5"],

        ["\xC9\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xA0"],
        ["\xE5\x9F\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD6"],

        ["\xC9\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAB"],
        ["\xE5\xA4\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD7"],

        ["\xC9\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA6"],
        ["\xE5\xA9\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],

        ["\xC9\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x8C"],
        ["\xE5\xAF\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xD9"],

        ["\xC9\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA8"],
        ["\xE5\x86\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xDA"],

        ["\xC9\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x83"],
        ["\xE5\xB8\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xDB"],

        ["\xC9\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x9C"],
        ["\xE5\xBA\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xDC"],

        ["\xC9\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x96"],
        ["\xE6\x80\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xDD"],

        ["\xC9\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xB6"],
        ["\xE6\x89\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xDE"],

        ["\xC9\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB7"],
        ["\xE6\x95\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xDF"],

        ["\xC9\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xA7"],
        ["\xE6\x96\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE0"],

        ["\xC9\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xAE"],
        ["\xE6\x99\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE1"],

        ["\xC9\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAE"],
        ["\xE6\xB5\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE2"],

        ["\xC9\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB6"],
        ["\xE7\x88\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE3"],

        ["\xC9\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA6"],
        ["\xE7\xAC\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE4"],

        ["\xC9\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x90"],
        ["\xE8\x85\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE5"],

        ["\xC9\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9A"],
        ["\xE8\x86\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE6"],

        ["\xC9\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x99"],
        ["\xE8\x8A\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE7"],

        ["\xC9\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9C"],
        ["\xE8\xAD\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE8"],

        ["\xC9\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xA0"],
        ["\xE8\xB2\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xE9"],

        ["\xC9\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA6"],
        ["\xE8\xB3\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xEA"],

        ["\xC9\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB4"],
        ["\xE8\xB5\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xEB"],

        ["\xC9\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\x9C"],
        ["\xE9\x98\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xEC"],

        ["\xC9\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x84"],
        ["\xE9\x99\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xED"],

        ["\xC9\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAE"],
        ["\xE4\xBE\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xEE"],

        ["\xC9\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xAB"],
        ["\xE6\x92\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xEF"],

        ["\xC9\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA6"],
        ["\xE6\xAD\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF0"],

        ["\xC9\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x9E"],
        ["\xE8\x88\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF1"],

        ["\xC9\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA1"],
        ["\xE8\x91\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF2"],

        ["\xC9\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAA"],
        ["\xE8\x95\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF3"],

        ["\xC9\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA8"],
        ["\xE9\x83\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF4"],

        ["\xC9\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x81"],
        ["\xE5\xB0\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF5"],

        ["\xC9\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x93"],
        ["\xE6\xA5\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF6"],

        ["\xC9\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xA8"],
        ["\xE9\xA2\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF7"],

        ["\xC9\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xBA"],
        ["\xE8\x91\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF8"],

        ["\xC9\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x97"],
        ["\xE8\x95\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xF9"],

        ["\xC9\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x8F"],
        ["\xE4\xBC\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xFA"],

        ["\xC9\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xAF"],
        ["\xE5\x89\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xFB"],

        ["\xC9\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA9"],
        ["\xE5\xBE\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xFC"],

        ["\xC9\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x85"],
        ["\xE5\xB9\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xFD"],

        ["\xC9\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8D"],
        ["\xE6\x9C\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xFE"],

        ["\xCA\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8F"],
        ["\xE7\xA6\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA1"],

        ["\xCA\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB9"],
        ["\xE8\x85\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA2"],

        ["\xCA\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x87"],
        ["\xE8\xA4\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA3"],

        ["\xCA\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x86"],
        ["\xE8\xA6\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA4"],

        ["\xCA\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB5"],
        ["\xE6\xB7\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA5"],

        ["\xCA\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x97"],
        ["\xE5\xBC\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA6"],

        ["\xCA\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x95"],
        ["\xE6\x89\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA7"],

        ["\xCA\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB8"],
        ["\xE6\xB2\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA8"],

        ["\xCA\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8F"],
        ["\xE4\xBB\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xA9"],

        ["\xCA\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA9"],
        ["\xE7\x89\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xAA"],

        ["\xCA\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x92"],
        ["\xE9\xAE\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xAB"],

        ["\xCA\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x86"],
        ["\xE5\x88\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xAC"],

        ["\xCA\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBB"],
        ["\xE5\x90\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xAD"],

        ["\xCA\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xB4"],
        ["\xE5\x99\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xAE"],

        ["\xCA\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB3"],
        ["\xE5\xA2\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xAF"],

        ["\xCA\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xA4"],
        ["\xE6\x86\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB0"],

        ["\xCA\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xAE"],
        ["\xE6\x89\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB1"],

        ["\xCA\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x9A"],
        ["\xE7\x84\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB2"],

        ["\xCA\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAE"],
        ["\xE5\xA5\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB3"],

        ["\xCA\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x89"],
        ["\xE7\xB2\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB4"],

        ["\xCA\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9E"],
        ["\xE7\xB3\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB5"],

        ["\xCA\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9B"],
        ["\xE7\xB4\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB6"],

        ["\xCA\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB0"],
        ["\xE9\x9B\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB7"],

        ["\xCA\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x87"],
        ["\xE6\x96\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB8"],

        ["\xCA\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9E"],
        ["\xE8\x81\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xB9"],

        ["\xCA\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x99"],
        ["\xE4\xB8\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xBA"],

        ["\xCA\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB5"],
        ["\xE4\xBD\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xBB"],

        ["\xCA\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xB5"],
        ["\xE5\x85\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xBC"],

        ["\xCA\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x80"],
        ["\xE5\xA1\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xBD"],

        ["\xCA\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA3"],
        ["\xE5\xB9\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xBE"],

        ["\xCA\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB3"],
        ["\xE5\xB9\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xBF"],

        ["\xCA\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8A"],
        ["\xE5\xBC\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC0"],

        ["\xCA\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x84"],
        ["\xE6\x9F\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC1"],

        ["\xCA\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA6"],
        ["\xE4\xB8\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC2"],

        ["\xCA\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xBD"],
        ["\xE8\x94\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC3"],

        ["\xCA\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x89"],
        ["\xE9\x96\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC4"],

        ["\xCA\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9B"],
        ["\xE9\x99\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC5"],

        ["\xCA\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xB3"],
        ["\xE7\xB1\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC6"],

        ["\xCA\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x81"],
        ["\xE9\xA0\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC7"],

        ["\xCA\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xBB"],
        ["\xE5\x83\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC8"],

        ["\xCA\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x81"],
        ["\xE5\xA3\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xC9"],

        ["\xCA\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x96"],
        ["\xE7\x99\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xCA"],

        ["\xCA\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA7"],
        ["\xE7\xA2\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xCB"],

        ["\xCA\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA5"],
        ["\xE5\x88\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xCC"],

        ["\xCA\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA5"],
        ["\xE7\x9E\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xCD"],

        ["\xCA\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x91"],
        ["\xE8\x94\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xCE"],

        ["\xCA\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x86"],
        ["\xE7\xAE\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xCF"],

        ["\xCA\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x8F"],
        ["\xE5\x81\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD0"],

        ["\xCA\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x89"],
        ["\xE5\xA4\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD1"],

        ["\xCA\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x87"],
        ["\xE7\x89\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD2"],

        ["\xCA\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x87"],
        ["\xE7\xAF\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD3"],

        ["\xCA\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA8"],
        ["\xE7\xB7\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD4"],

        ["\xCA\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xBA"],
        ["\xE8\xBE\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD5"],

        ["\xCA\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x94"],
        ["\xE8\xBF\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD6"],

        ["\xCA\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8D"],
        ["\xE9\x81\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD7"],

        ["\xCA\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xBF"],
        ["\xE4\xBE\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD8"],

        ["\xCA\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x89"],
        ["\xE5\x8B\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xD9"],

        ["\xCA\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA9"],
        ["\xE5\xA8\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xDA"],

        ["\xCA\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x81"],
        ["\xE5\xBC\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xDB"],

        ["\xCA\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xAD"],
        ["\xE9\x9E\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xDC"],

        ["\xCA\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9D"],
        ["\xE4\xBF\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xDD"],

        ["\xCA\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x97"],
        ["\xE8\x88\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xDE"],

        ["\xCA\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xAA"],
        ["\xE9\x8B\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xDF"],

        ["\xCA\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x83"],
        ["\xE5\x9C\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE0"],

        ["\xCA\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x95"],
        ["\xE6\x8D\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE1"],

        ["\xCA\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA9"],
        ["\xE6\xAD\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE2"],

        ["\xCA\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAB"],
        ["\xE7\x94\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE3"],

        ["\xCA\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9C"],
        ["\xE8\xA3\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE4"],

        ["\xCA\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x94"],
        ["\xE8\xBC\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE5"],

        ["\xCA\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x82"],
        ["\xE7\xA9\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE6"],

        ["\xCA\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9F"],
        ["\xE5\x8B\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE7"],

        ["\xCA\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x93"],
        ["\xE5\xA2\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE8"],

        ["\xCA\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x95"],
        ["\xE6\x85\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xE9"],

        ["\xCA\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8A"],
        ["\xE6\x88\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xEA"],

        ["\xCA\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xAE"],
        ["\xE6\x9A\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xEB"],

        ["\xCA\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8D"],
        ["\xE6\xAF\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xEC"],

        ["\xCA\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBF"],
        ["\xE7\xB0\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xED"],

        ["\xCA\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xA9"],
        ["\xE8\x8F\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xEE"],

        ["\xCA\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA3"],
        ["\xE5\x80\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xEF"],

        ["\xCA\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB8"],
        ["\xE4\xBF\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF0"],

        ["\xCA\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x85"],
        ["\xE5\x8C\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF1"],

        ["\xCA\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x86"],
        ["\xE5\x91\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF2"],

        ["\xCA\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xB1"],
        ["\xE5\xA0\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF3"],

        ["\xCA\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x89"],
        ["\xE5\xA5\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF4"],

        ["\xCA\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x9D"],
        ["\xE5\xAE\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF5"],

        ["\xCA\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xB0"],
        ["\xE5\xB3\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF6"],

        ["\xCA\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAF"],
        ["\xE5\xB3\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF7"],

        ["\xCA\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA9"],
        ["\xE5\xB4\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF8"],

        ["\xCA\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\x96"],
        ["\xE5\xBA\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xF9"],

        ["\xCA\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB1"],
        ["\xE6\x8A\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xFA"],

        ["\xCA\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA7"],
        ["\xE6\x8D\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xFB"],

        ["\xCA\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xBE"],
        ["\xE6\x94\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xFC"],

        ["\xCA\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB9"],
        ["\xE6\x96\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xFD"],

        ["\xCA\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8B"],
        ["\xE6\x9C\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCA\xFE"],

        ["\xCB\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x95"],
        ["\xE6\xB3\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA1"],

        ["\xCB\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xA1"],
        ["\xE6\xB3\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA2"],

        ["\xCB\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xB9"],
        ["\xE7\x83\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA3"],

        ["\xCB\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xB2"],
        ["\xE7\xA0\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA4"],

        ["\xCB\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xAB"],
        ["\xE7\xB8\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA5"],

        ["\xCB\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9E"],
        ["\xE8\x83\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA6"],

        ["\xCB\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xB3"],
        ["\xE8\x8A\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA7"],

        ["\xCB\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8C"],
        ["\xE8\x90\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA8"],

        ["\xCB\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xAC"],
        ["\xE8\x93\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xA9"],

        ["\xCB\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x82"],
        ["\xE8\x9C\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xAA"],

        ["\xCB\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x92"],
        ["\xE8\xA4\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xAB"],

        ["\xCB\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xAA"],
        ["\xE8\xA8\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xAC"],

        ["\xCB\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8A"],
        ["\xE8\xB1\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xAD"],

        ["\xCB\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA6"],
        ["\xE9\x82\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xAE"],

        ["\xCB\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x92"],
        ["\xE9\x8B\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xAF"],

        ["\xCB\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xBD"],
        ["\xE9\xA3\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB0"],

        ["\xCB\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB3"],
        ["\xE9\xB3\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB1"],

        ["\xCB\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xAC"],
        ["\xE9\xB5\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB2"],

        ["\xCB\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x8F"],
        ["\xE4\xB9\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB3"],

        ["\xCB\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA1"],
        ["\xE4\xBA\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB4"],

        ["\xCB\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x8D"],
        ["\xE5\x82\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB5"],

        ["\xCB\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x96"],
        ["\xE5\x89\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB6"],

        ["\xCB\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8A"],
        ["\xE5\x9D\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB7"],

        ["\xCB\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA8"],
        ["\xE5\xA6\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB8"],

        ["\xCB\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xBD"],
        ["\xE5\xB8\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xB9"],

        ["\xCB\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x98"],
        ["\xE5\xBF\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xBA"],

        ["\xCB\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x99"],
        ["\xE5\xBF\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xBB"],

        ["\xCB\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xBF"],
        ["\xE6\x88\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xBC"],

        ["\xCB\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB4"],
        ["\xE6\x9A\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xBD"],

        ["\xCB\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9B"],
        ["\xE6\x9C\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xBE"],

        ["\xCB\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x90"],
        ["\xE6\x9F\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xBF"],

        ["\xCB\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x92"],
        ["\xE6\xA3\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC0"],

        ["\xCB\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x92"],
        ["\xE5\x86\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC1"],

        ["\xCB\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xA1"],
        ["\xE7\xB4\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC2"],

        ["\xCB\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAA"],
        ["\xE8\x82\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC3"],

        ["\xCB\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA8"],
        ["\xE8\x86\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC4"],

        ["\xCB\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x80"],
        ["\xE8\xAC\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC5"],

        ["\xCB\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8C"],
        ["\xE8\xB2\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC6"],

        ["\xCB\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBF"],
        ["\xE8\xB2\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC7"],

        ["\xCB\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xBE"],
        ["\xE9\x89\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC8"],

        ["\xCB\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xB2"],
        ["\xE9\x98\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xC9"],

        ["\xCB\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA0"],
        ["\xE5\x90\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xCA"],

        ["\xCB\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xAC"],
        ["\xE9\xA0\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xCB"],

        ["\xCB\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x97"],
        ["\xE5\x8C\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xCC"],

        ["\xCB\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x95"],
        ["\xE5\x83\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xCD"],

        ["\xCB\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9C"],
        ["\xE5\x8D\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xCE"],

        ["\xCB\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xA8"],
        ["\xE5\xA2\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xCF"],

        ["\xCB\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xB2"],
        ["\xE6\x92\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD0"],

        ["\xCB\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB4"],
        ["\xE6\x9C\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD1"],

        ["\xCB\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA7"],
        ["\xE7\x89\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD2"],

        ["\xCB\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA6"],
        ["\xE7\x9D\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD3"],

        ["\xCB\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x86"],
        ["\xE7\xA9\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD4"],

        ["\xCB\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA6"],
        ["\xE9\x87\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD5"],

        ["\xCB\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x83"],
        ["\xE5\x8B\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD6"],

        ["\xCB\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xA1"],
        ["\xE6\xB2\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD7"],

        ["\xCB\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x86"],
        ["\xE6\xAE\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD8"],

        ["\xCB\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x80"],
        ["\xE5\xA0\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xD9"],

        ["\xCB\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x8C"],
        ["\xE5\xB9\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xDA"],

        ["\xCB\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x94"],
        ["\xE5\xA5\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xDB"],

        ["\xCB\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAC"],
        ["\xE6\x9C\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xDC"],

        ["\xCB\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xBB"],
        ["\xE7\xBF\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xDD"],

        ["\xCB\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA1"],
        ["\xE5\x87\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xDE"],

        ["\xCB\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x86"],
        ["\xE7\x9B\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xDF"],

        ["\xCB\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xA9"],
        ["\xE6\x91\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE0"],

        ["\xCB\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA8"],
        ["\xE7\xA3\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE1"],

        ["\xCB\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x94"],
        ["\xE9\xAD\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE2"],

        ["\xCB\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBB"],
        ["\xE9\xBA\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE3"],

        ["\xCB\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x8B"],
        ["\xE5\x9F\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE4"],

        ["\xCB\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xB9"],
        ["\xE5\xA6\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE5"],

        ["\xCB\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xA7"],
        ["\xE6\x98\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE6"],

        ["\xCB\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x9A"],
        ["\xE6\x9E\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE7"],

        ["\xCB\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8E"],
        ["\xE6\xAF\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE8"],

        ["\xCB\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA9"],
        ["\xE5\x93\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xE9"],

        ["\x54\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x99"],
        ["\xE6\xA7\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x54\xC4"],

        ["\xCB\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x95"],
        ["\xE5\xB9\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xEB"],

        ["\xCB\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x9C"],
        ["\xE8\x86\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xEC"],

        ["\xCB\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x95"],
        ["\xE6\x9E\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xED"],

        ["\xCB\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xAA"],
        ["\xE9\xAE\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xEE"],

        ["\xCB\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xBE"],
        ["\xE6\x9F\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xEF"],

        ["\xCB\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x92"],
        ["\xE9\xB1\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF0"],

        ["\xCB\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x9D"],
        ["\xE6\xA1\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF1"],

        ["\xCB\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA6"],
        ["\xE4\xBA\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF2"],

        ["\xCB\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA3"],
        ["\xE4\xBF\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF3"],

        ["\xCB\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x88"],
        ["\xE5\x8F\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF4"],

        ["\xCB\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xB9"],
        ["\xE6\x8A\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF5"],

        ["\xCB\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAB"],
        ["\xE6\x9C\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF6"],

        ["\xCB\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xAB"],
        ["\xE6\xB2\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF7"],

        ["\xCB\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x84"],
        ["\xE8\xBF\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF8"],

        ["\xD0\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAD"],
        ["\xE4\xBE\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD6"],

        ["\xCB\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xAD"],
        ["\xE7\xB9\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xFA"],

        ["\xCB\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBF"],
        ["\xE9\xBA\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xFB"],

        ["\xCB\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x87"],
        ["\xE4\xB8\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xFC"],

        ["\xCB\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA2"],
        ["\xE6\x85\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xFD"],

        ["\xCB\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x80"],
        ["\xE6\xBA\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xFE"],

        ["\xCC\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xAB"],
        ["\xE6\xBC\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA1"],

        ["\xCC\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x93"],
        ["\xE8\x94\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA2"],

        ["\xCC\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB3"],
        ["\xE5\x91\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA3"],

        ["\xCC\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAA"],
        ["\xE6\x9C\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA4"],

        ["\xCC\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x85"],
        ["\xE9\xAD\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA5"],

        ["\xCC\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB3"],
        ["\xE5\xB7\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA6"],

        ["\xCC\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x95"],
        ["\xE7\xAE\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA7"],

        ["\xCC\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAC"],
        ["\xE5\xB2\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA8"],

        ["\xCC\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x86"],
        ["\xE5\xAF\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xA9"],

        ["\xCC\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x9C"],
        ["\xE8\x9C\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xAA"],

        ["\xCC\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8A"],
        ["\xE6\xB9\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xAB"],

        ["\xCC\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x91"],
        ["\xE8\x93\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xAC"],

        ["\xCC\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x94"],
        ["\xE7\xA8\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xAD"],

        ["\xCC\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x88"],
        ["\xE8\x84\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xAE"],

        ["\xCC\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x99"],
        ["\xE5\xA6\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xAF"],

        ["\xCC\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x8D"],
        ["\xE7\xB2\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB0"],

        ["\xCC\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x91"],
        ["\xE6\xB0\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB1"],

        ["\xCC\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA0"],
        ["\xE7\x9C\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB2"],

        ["\xCC\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x99"],
        ["\xE5\x8B\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB3"],

        ["\xCC\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA2"],
        ["\xE5\xA4\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB4"],

        ["\xCC\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\xA1"],
        ["\xE7\x84\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB5"],

        ["\xCC\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9F"],
        ["\xE7\x89\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB6"],

        ["\xCC\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9B"],
        ["\xE7\x9F\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB7"],

        ["\xCC\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xA7"],
        ["\xE9\x9C\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB8"],

        ["\xCC\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA1"],
        ["\xE9\xB5\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xB9"],

        ["\xCC\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8B"],
        ["\xE6\xA4\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xBA"],

        ["\xCC\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xBF"],
        ["\xE5\xA9\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xBB"],

        ["\xCC\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x98"],
        ["\xE5\xA8\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xBC"],

        ["\xCC\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA5"],
        ["\xE5\x86\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xBD"],

        ["\xCC\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8D"],
        ["\xE5\x90\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xBE"],

        ["\xCC\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBD"],
        ["\xE5\x91\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xBF"],

        ["\xCC\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8E"],
        ["\xE6\x98\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC0"],

        ["\xCC\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9F"],
        ["\xE7\x9B\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC1"],

        ["\xCC\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB7"],
        ["\xE8\xBF\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC2"],

        ["\xCC\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x98"],
        ["\xE9\x8A\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC3"],

        ["\xCC\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB4"],
        ["\xE9\xB3\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC4"],

        ["\xCC\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xAA"],
        ["\xE5\xA7\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC5"],

        ["\xCC\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x9D"],
        ["\xE7\x89\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC6"],

        ["\xCC\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x85"],
        ["\xE6\xBB\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC7"],

        ["\xCC\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8D"],
        ["\xE5\x85\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC8"],

        ["\xCC\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x89"],
        ["\xE6\xA3\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xC9"],

        ["\xCC\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBF"],
        ["\xE7\xB6\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xCA"],

        ["\xCC\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xAC"],
        ["\xE7\xB7\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xCB"],

        ["\xCC\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA2"],
        ["\xE9\x9D\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xCC"],

        ["\x6F\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBA"],
        ["\xE9\xBA\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x6F\xC4"],

        ["\xCC\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xB8"],
        ["\xE6\x91\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xCE"],

        ["\xCC\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA1"],
        ["\xE6\xA8\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xCF"],

        ["\xCC\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x82"],
        ["\xE8\x8C\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD0"],

        ["\xCC\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x84"],
        ["\xE5\xA6\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD1"],

        ["\xCC\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9F"],
        ["\xE5\xAD\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD2"],

        ["\xCC\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x9B"],
        ["\xE6\xAF\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD3"],

        ["\xCC\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9B"],
        ["\xE7\x8C\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD4"],

        ["\xCC\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xB2"],
        ["\xE7\x9B\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD5"],

        ["\xCC\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB2"],
        ["\xE7\xB6\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD6"],

        ["\xCC\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x97"],
        ["\xE8\x80\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD7"],

        ["\xCC\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x99"],
        ["\xE8\x92\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD8"],

        ["\xCC\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xB2"],
        ["\xE5\x84\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xD9"],

        ["\xCC\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA8"],
        ["\xE6\x9C\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xDA"],

        ["\xCC\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x99"],
        ["\xE9\xBB\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xDB"],

        ["\xCC\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xAE"],
        ["\xE7\x9B\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xDC"],

        ["\xCC\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA2"],
        ["\xE6\x9D\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xDD"],

        ["\xCC\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xBF"],
        ["\xE5\x8B\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xDE"],

        ["\xCC\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x85"],
        ["\xE9\xA4\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xDF"],

        ["\xCC\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA4"],
        ["\xE5\xB0\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE0"],

        ["\xCC\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xBB"],
        ["\xE6\x88\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE1"],

        ["\xCC\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xBE"],
        ["\xE7\xB1\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE2"],

        ["\xCC\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB0"],
        ["\xE8\xB2\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE3"],

        ["\xCC\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x8F"],
        ["\xE5\x95\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE4"],

        ["\xCC\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB6"],
        ["\xE6\x82\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE5"],

        ["\xCC\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8B"],
        ["\xE7\xB4\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE6"],

        ["\xCC\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x80"],
        ["\xE9\x96\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE7"],

        ["\xCC\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x81"],
        ["\xE5\x8C\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE8"],

        ["\xCC\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x9F"],
        ["\xE4\xB9\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xE9"],

        ["\xCC\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB6"],
        ["\xE5\x86\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xEA"],

        ["\xCC\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9C"],
        ["\xE5\xA4\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xEB"],

        ["\xCC\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBA"],
        ["\xE7\x88\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xEC"],

        ["\xCC\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xB6"],
        ["\xE8\x80\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xED"],

        ["\xCC\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8E"],
        ["\xE9\x87\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xEE"],

        ["\xCC\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA5"],
        ["\xE5\xBC\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xEF"],

        ["\xCC\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA2"],
        ["\xE7\x9F\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF0"],

        ["\xCC\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x84"],
        ["\xE5\x8E\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF1"],

        ["\xCC\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB9"],
        ["\xE5\xBD\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF2"],

        ["\xCC\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x84"],
        ["\xE7\xB4\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF3"],

        ["\xCC\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAC"],
        ["\xE8\x96\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF4"],

        ["\xCC\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB3"],
        ["\xE8\xA8\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF5"],

        ["\xCC\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8D"],
        ["\xE8\xBA\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF6"],

        ["\xCC\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x96"],
        ["\xE9\x9D\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF7"],

        ["\xCC\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xB3"],
        ["\xE6\x9F\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF8"],

        ["\xE9\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xAE"],
        ["\xE8\x96\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE"],

        ["\xCC\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x93"],
        ["\xE9\x91\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xFA"],

        ["\xCC\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x89"],
        ["\xE6\x84\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xFB"],

        ["\xCC\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x88"],
        ["\xE6\x84\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xFC"],

        ["\xCC\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB9"],
        ["\xE6\xB2\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xFD"],

        ["\xCC\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x92"],
        ["\xE7\x99\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xFE"],

        ["\xCD\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAD"],
        ["\xE8\xAB\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA1"],

        ["\xCD\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB8"],
        ["\xE8\xBC\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA2"],

        ["\xCD\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xAF"],
        ["\xE5\x94\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA3"],

        ["\xCD\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x91"],
        ["\xE4\xBD\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA4"],

        ["\xCD\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xAA"],
        ["\xE5\x84\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA5"],

        ["\xCD\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x87"],
        ["\xE5\x8B\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA6"],

        ["\xCD\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x8B"],
        ["\xE5\x8F\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA7"],

        ["\xCD\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA5"],
        ["\xE5\xAE\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA8"],

        ["\xCD\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBD"],
        ["\xE5\xB9\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xA9"],

        ["\xCD\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA0"],
        ["\xE6\x82\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xAA"],

        ["\xCD\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x82"],
        ["\xE6\x86\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xAB"],

        ["\xCD\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x96"],
        ["\xE6\x8F\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xAC"],

        ["\xCD\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x89"],
        ["\xE6\x9C\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xAD"],

        ["\xCD\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9A"],
        ["\xE6\x9F\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xAE"],

        ["\xCD\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xA7"],
        ["\xE6\xB9\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xAF"],

        ["\xCD\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x8C"],
        ["\xE6\xB6\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB0"],

        ["\xCD\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB6"],
        ["\xE7\x8C\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB1"],

        ["\xCD\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB7"],
        ["\xE7\x8C\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB2"],

        ["\xCD\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB1"],
        ["\xE7\x94\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB3"],

        ["\xCD\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x90"],
        ["\xE7\xA5\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB4"],

        ["\xCD\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x95"],
        ["\xE8\xA3\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB5"],

        ["\xCD\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x98"],
        ["\xE8\xAA\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB6"],

        ["\xCD\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8A"],
        ["\xE9\x81\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB7"],

        ["\xCD\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x91"],
        ["\xE9\x82\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB8"],

        ["\xCD\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xB5"],
        ["\xE9\x83\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xB9"],

        ["\xCD\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x84"],
        ["\xE9\x9B\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xBA"],

        ["\xCD\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x8D"],
        ["\xE8\x9E\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xBB"],

        ["\xCD\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x95"],
        ["\xE5\xA4\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xBC"],

        ["\xCD\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x88"],
        ["\xE4\xBA\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xBD"],

        ["\xCD\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x99"],
        ["\xE4\xBD\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xBE"],

        ["\xCD\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x8E"],
        ["\xE4\xB8\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xBF"],

        ["\xCD\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x89"],
        ["\xE8\xAA\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC0"],

        ["\xCD\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBF"],
        ["\xE8\xBC\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC1"],

        ["\xCD\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x90"],
        ["\xE9\xA0\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC2"],

        ["\xCD\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xAD"],
        ["\xE5\x82\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC3"],

        ["\xCD\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBC"],
        ["\xE5\xB9\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC4"],

        ["\xCD\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x96"],
        ["\xE5\xA6\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC5"],

        ["\xCD\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB9"],
        ["\xE5\xAE\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC6"],

        ["\xCD\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xB8"],
        ["\xE5\xBA\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC7"],

        ["\xCD\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x9A"],
        ["\xE6\x8F\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC8"],

        ["\xCD\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xBA"],
        ["\xE6\x8F\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xC9"],

        ["\xCD\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x81"],
        ["\xE6\x93\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xCA"],

        ["\xCD\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9C"],
        ["\xE6\x9B\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xCB"],

        ["\xCD\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x8A"],
        ["\xE6\xA5\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xCC"],

        ["\xCD\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x98"],
        ["\xE6\xA7\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xCD"],

        ["\xCD\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8B"],
        ["\xE6\xB4\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xCE"],

        ["\xCD\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB6"],
        ["\xE6\xBA\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xCF"],

        ["\xCD\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x94"],
        ["\xE7\x86\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD0"],

        ["\xCD\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA8"],
        ["\xE7\x94\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD1"],

        ["\xCD\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xAF"],
        ["\xE7\xAA\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD2"],

        ["\xCD\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8A"],
        ["\xE7\xBE\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD3"],

        ["\xCD\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x80"],
        ["\xE8\x80\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD4"],

        ["\xCD\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x89"],
        ["\xE8\x91\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD5"],

        ["\xCD\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x89"],
        ["\xE8\x93\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD6"],

        ["\xCD\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x81"],
        ["\xE8\xA6\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD7"],

        ["\xCD\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA1"],
        ["\xE8\xAC\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD8"],

        ["\xCD\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x8A"],
        ["\xE8\xB8\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xD9"],

        ["\x70\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA5"],
        ["\xE9\x81\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x70\xEB"],

        ["\xCD\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xBD"],
        ["\xE9\x99\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xDB"],

        ["\xCD\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x8A"],
        ["\xE9\xA4\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xDC"],

        ["\xCD\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xBE"],
        ["\xE6\x85\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xDD"],

        ["\xCD\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x91"],
        ["\xE6\x8A\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xDE"],

        ["\xCD\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB2"],
        ["\xE6\xAC\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xDF"],

        ["\xCD\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x83"],
        ["\xE6\xB2\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE0"],

        ["\xCD\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB4"],
        ["\xE6\xB5\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE1"],

        ["\xCD\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8C"],
        ["\xE7\xBF\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE2"],

        ["\xCD\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xBC"],
        ["\xE7\xBF\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE3"],

        ["\xCD\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x80"],
        ["\xE6\xB7\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE4"],

        ["\xCD\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x85"],
        ["\xE7\xBE\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE5"],

        ["\xCD\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBA"],
        ["\xE8\x9E\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE6"],

        ["\xCD\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB8"],
        ["\xE8\xA3\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE7"],

        ["\xCD\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA5"],
        ["\xE6\x9D\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE8"],

        ["\xCD\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xB1"],
        ["\xE8\x8E\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xE9"],

        ["\xCD\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xBC"],
        ["\xE9\xA0\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xEA"],

        ["\xCD\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB7"],
        ["\xE9\x9B\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xEB"],

        ["\xCD\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9B"],
        ["\xE6\xB4\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xEC"],

        ["\xCD\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA1"],
        ["\xE7\xB5\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xED"],

        ["\xCD\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xBD"],
        ["\xE8\x90\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xEE"],

        ["\xCD\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xAA"],
        ["\xE9\x85\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xEF"],

        ["\xCD\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xB1"],
        ["\xE4\xB9\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF0"],

        ["\xCD\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB5"],
        ["\xE5\x8D\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF1"],

        ["\xCD\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x90"],
        ["\xE5\xB5\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF2"],

        ["\xCD\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x84"],
        ["\xE6\xAC\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF3"],

        ["\xCD\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAB"],
        ["\xE6\xBF\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF4"],

        ["\xCD\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8D"],
        ["\xE8\x97\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF5"],

        ["\xCD\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xAD"],
        ["\xE8\x98\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF6"],

        ["\xCD\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA7"],
        ["\xE8\xA6\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF7"],

        ["\xCD\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA9"],
        ["\xE5\x88\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF8"],

        ["\xCD\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x8F"],
        ["\xE5\x90\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xF9"],

        ["\xCD\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xA5"],
        ["\xE5\xB1\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xFA"],

        ["\xCD\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x8E"],
        ["\xE6\x9D\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xFB"],

        ["\xCD\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA8"],
        ["\xE6\xA2\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xFC"],

        ["\xCD\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x86"],
        ["\xE7\x90\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xFD"],

        ["\xCD\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x83"],
        ["\xE7\x92\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCD\xFE"],

        ["\xCE\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA2"],
        ["\xE7\x97\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA1"],

        ["\xCE\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x8F"],
        ["\xE8\xA3\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA2"],

        ["\xCE\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xA1"],
        ["\xE8\xA3\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],

        ["\xCE\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8C"],
        ["\xE9\x87\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA4"],

        ["\xCE\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xA2"],
        ["\xE9\x9B\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA5"],

        ["\xCE\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB8"],
        ["\xE9\x99\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],

        ["\xCE\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8B"],
        ["\xE5\xBE\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],

        ["\xCE\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\x87"],
        ["\xE7\x8E\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA8"],

        ["\xCE\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8B"],
        ["\xE7\xAB\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xA9"],

        ["\xCE\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x8E"],
        ["\xE8\x91\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xAA"],

        ["\xCE\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA0"],
        ["\xE6\x8E\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xAB"],

        ["\xCE\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA5"],
        ["\xE7\x95\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xAC"],

        ["\xCE\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x89"],
        ["\xE5\x8A\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xAD"],

        ["\xCE\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x81"],
        ["\xE6\xB5\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xAE"],

        ["\xCE\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9C"],
        ["\xE6\xBA\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xAF"],

        ["\xCE\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x89"],
        ["\xE7\x90\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB0"],

        ["\xCE\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x99"],
        ["\xE7\x95\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB1"],

        ["\xCE\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xAB"],
        ["\xE7\xA1\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB2"],

        ["\xCE\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x92"],
        ["\xE7\xB2\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB3"],

        ["\xCE\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x86"],
        ["\xE9\x9A\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB4"],

        ["\xCE\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9C"],
        ["\xE7\xAB\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB5"],

        ["\xCE\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x8D"],
        ["\xE9\xBE\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB6"],

        ["\xCE\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xB6"],
        ["\xE4\xBE\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB7"],

        ["\xCE\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAE"],
        ["\xE6\x85\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB8"],

        ["\xCE\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x85"],
        ["\xE6\x97\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],

        ["\xCE\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9C"],
        ["\xE8\x99\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xBA"],

        ["\xCE\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x86"],
        ["\xE4\xBA\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],

        ["\xCE\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xAE"],
        ["\xE4\xBA\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],

        ["\xCE\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x9A"],
        ["\xE5\x83\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xBD"],

        ["\xCE\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xA1"],
        ["\xE4\xB8\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xBE"],

        ["\xCE\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x8C"],
        ["\xE5\x87\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xBF"],

        ["\xCE\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xAE"],
        ["\xE5\xAF\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC0"],

        ["\xCE\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x99"],
        ["\xE6\x96\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC1"],

        ["\xCE\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x81"],
        ["\xE6\xA2\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC2"],

        ["\xCE\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xBC"],
        ["\xE6\xB6\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC3"],

        ["\xCE\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9F"],
        ["\xE7\x8C\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC4"],

        ["\xCE\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x82"],
        ["\xE7\x99\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC5"],

        ["\xCE\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xAD"],
        ["\xE7\x9E\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC6"],

        ["\xCE\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9C"],
        ["\xE7\xA8\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC7"],

        ["\xCE\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA7"],
        ["\xE7\xB3\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC8"],

        ["\xCE\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAF"],
        ["\xE8\x89\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xC9"],

        ["\xCE\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x92"],
        ["\xE8\xAB\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xCA"],

        ["\xCE\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBC"],
        ["\xE9\x81\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xCB"],

        ["\xCE\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8F"],
        ["\xE9\x87\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xCC"],

        ["\xCE\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB5"],
        ["\xE9\x99\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xCD"],

        ["\xCE\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x98"],
        ["\xE9\xA0\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xCE"],

        ["\xCE\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x9B"],
        ["\xE5\x8A\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xCF"],

        ["\xCE\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x91"],
        ["\xE7\xB7\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD0"],

        ["\xCE\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAB"],
        ["\xE5\x80\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD1"],

        ["\xCE\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x98"],
        ["\xE5\x8E\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD2"],

        ["\xCE\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x97"],
        ["\xE6\x9E\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD3"],

        ["\xCE\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8B"],
        ["\xE6\xB7\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD4"],

        ["\xCE\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x90"],
        ["\xE7\x87\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD5"],

        ["\xCE\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB3"],
        ["\xE7\x90\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD6"],

        ["\xCE\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA8"],
        ["\xE8\x87\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD7"],

        ["\xCE\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xAA"],
        ["\xE8\xBC\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD8"],

        ["\xCE\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA3"],
        ["\xE9\x9A\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xD9"],

        ["\xCE\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x97"],
        ["\xE9\xB1\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xDA"],

        ["\xCE\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x9F"],
        ["\xE9\xBA\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xDB"],

        ["\xCE\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA0"],
        ["\xE7\x91\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xDC"],

        ["\xCE\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x81"],
        ["\xE5\xA1\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xDD"],

        ["\xCE\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x99"],
        ["\xE6\xB6\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xDE"],

        ["\xCE\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAF"],
        ["\xE7\xB4\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xDF"],

        ["\xCE\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x9E"],
        ["\xE9\xA1\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE0"],

        ["\xCE\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xA4"],
        ["\xE4\xBB\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE1"],

        ["\xCE\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB6"],
        ["\xE4\xBC\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE2"],

        ["\xCE\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8B"],
        ["\xE4\xBE\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE3"],

        ["\xCE\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB7"],
        ["\xE5\x86\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE4"],

        ["\xCE\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB1"],
        ["\xE5\x8A\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE5"],

        ["\xCE\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBA"],
        ["\xE5\xB6\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE6"],

        ["\xCE\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9C"],
        ["\xE6\x80\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE7"],

        ["\xCE\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB2"],
        ["\xE7\x8E\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE8"],

        ["\xCE\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xBC"],
        ["\xE7\xA4\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xE9"],

        ["\xCE\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x93"],
        ["\xE8\x8B\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xEA"],

        ["\xCE\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xB4"],
        ["\xE9\x88\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xEB"],

        ["\xCE\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB7"],
        ["\xE9\x9A\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xEC"],

        ["\xCE\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB6"],
        ["\xE9\x9B\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xED"],

        ["\xCE\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8A"],
        ["\xE9\x9C\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xEE"],

        ["\xCE\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x97"],
        ["\xE9\xBA\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xEF"],

        ["\xCE\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\xA2"],
        ["\xE9\xBD\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF0"],

        ["\xCE\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xA6"],
        ["\xE6\x9A\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF1"],

        ["\xCE\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB4"],
        ["\xE6\xAD\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF2"],

        ["\xCE\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x97"],
        ["\xE5\x88\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF3"],

        ["\xCE\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xA3"],
        ["\xE5\x8A\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF4"],

        ["\xCE\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x88"],
        ["\xE7\x83\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF5"],

        ["\xCE\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x82"],
        ["\xE8\xA3\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF6"],

        ["\xCE\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x89"],
        ["\xE5\xBB\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF7"],

        ["\xCE\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8B"],
        ["\xE6\x81\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF8"],

        ["\xCE\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x90"],
        ["\xE6\x86\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xF9"],

        ["\xCE\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xA3"],
        ["\xE6\xBC\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xFA"],

        ["\xCE\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x89"],
        ["\xE7\x85\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xFB"],

        ["\xCE\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBE"],
        ["\xE7\xB0\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xFC"],

        ["\xCE\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xB4"],
        ["\xE7\xB7\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xFD"],

        ["\xCE\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xAF"],
        ["\xE8\x81\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCE\xFE"],

        ["\xCF\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xAE"],
        ["\xE8\x93\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA1"],

        ["\xCF\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA3"],
        ["\xE9\x80\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA2"],

        ["\xCF\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAC"],
        ["\xE9\x8C\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA3"],

        ["\xCF\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x82"],
        ["\xE5\x91\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA4"],

        ["\xCF\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xAF"],
        ["\xE9\xAD\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA5"],

        ["\xCF\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x93"],
        ["\xE6\xAB\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA6"],

        ["\xCF\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x89"],
        ["\xE7\x82\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA7"],

        ["\xCF\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x82"],
        ["\xE8\xB3\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA8"],

        ["\xCF\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAF"],
        ["\xE8\xB7\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xA9"],

        ["\xCF\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB2"],
        ["\xE9\x9C\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xAA"],

        ["\xCF\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB4"],
        ["\xE5\x8A\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xAB"],

        ["\xCF\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x81"],
        ["\xE5\xA9\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xAC"],

        ["\xCF\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x8A"],
        ["\xE5\xBB\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xAD"],

        ["\xCF\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x84"],
        ["\xE5\xBC\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xAE"],

        ["\xCF\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x97"],
        ["\xE6\x9C\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xAF"],

        ["\xCF\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBC"],
        ["\xE6\xA5\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB0"],

        ["\xCF\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x94"],
        ["\xE6\xA6\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB1"],

        ["\xCF\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xAA"],
        ["\xE6\xB5\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB2"],

        ["\xCF\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x8F"],
        ["\xE6\xBC\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB3"],

        ["\xCF\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xA2"],
        ["\xE7\x89\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB4"],

        ["\xCF\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xBC"],
        ["\xE7\x8B\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB5"],

        ["\xE4\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xAD"],
        ["\xE7\xAF\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],

        ["\xCF\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x81"],
        ["\xE8\x80\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB7"],

        ["\xCF\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBE"],
        ["\xE8\x81\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB8"],

        ["\xCF\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8B"],
        ["\xE8\x9D\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB9"],

        ["\xCF\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x8E"],
        ["\xE9\x83\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xBA"],

        ["\xCF\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAD"],
        ["\xE5\x85\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xBB"],

        ["\xCF\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x93"],
        ["\xE9\xBA\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xBC"],

        ["\xCF\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x84"],
        ["\xE7\xA6\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xBD"],

        ["\xCF\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x8B"],
        ["\xE8\x82\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xBE"],

        ["\xCF\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xB2"],
        ["\xE9\x8C\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xBF"],

        ["\xCF\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x96"],
        ["\xE8\xAB\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC0"],

        ["\xCF\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAD"],
        ["\xE5\x80\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC1"],

        ["\xCF\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8C"],
        ["\xE5\x92\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC2"],

        ["\xCF\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xB1"],
        ["\xE8\xA9\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC3"],

        ["\xCF\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xAA"],
        ["\xE6\xAD\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC4"],

        ["\xCF\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x84"],
        ["\xE8\xB3\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC5"],

        ["\xCF\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x87"],
        ["\xE8\x84\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC6"],

        ["\xCF\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x91"],
        ["\xE6\x83\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC7"],

        ["\xCF\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA0"],
        ["\xE6\x9E\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC8"],

        ["\xCF\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB2"],
        ["\xE9\xB7\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xC9"],

        ["\xCF\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x99"],
        ["\xE4\xBA\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xCA"],

        ["\xCF\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x98"],
        ["\xE4\xBA\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xCB"],

        ["\xCF\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x90"],
        ["\xE9\xB0\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xCC"],

        ["\xCF\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAB"],
        ["\xE8\xA9\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xCD"],

        ["\xCF\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x81"],
        ["\xE8\x97\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xCE"],

        ["\xCF\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA8"],
        ["\xE8\x95\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xCF"],

        ["\xCF\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x80"],
        ["\xE6\xA4\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xD0"],

        ["\xCF\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xBE"],
        ["\xE6\xB9\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xD1"],

        ["\xCF\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x97"],
        ["\xE7\xA2\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xD2"],

        ["\xCF\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x95"],
        ["\xE8\x85\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xD3"],

        ["\xD0\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8C"],
        ["\xE5\xBC\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xA1"],

        ["\xD0\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x90"],
        ["\xE4\xB8\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xA2"],

        ["\xD0\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x95"],
        ["\xE4\xB8\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xA3"],

        ["\xD0\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xAA"],
        ["\xE4\xB8\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xA4"],

        ["\xD0\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB1"],
        ["\xE4\xB8\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xA5"],

        ["\xD0\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xB6"],
        ["\xE4\xB8\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xA6"],

        ["\xD0\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBC"],
        ["\xE4\xB8\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xA7"],

        ["\xD0\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\xBF"],
        ["\xE4\xB8\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xA8"],

        ["\xD0\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x82"],
        ["\xE4\xB9\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xA9"],

        ["\xD0\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x96"],
        ["\xE4\xB9\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xAA"],

        ["\xD0\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x98"],
        ["\xE4\xB9\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xAB"],

        ["\xD0\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x82"],
        ["\xE4\xBA\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xAC"],

        ["\xD0\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x85"],
        ["\xE4\xBA\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xAD"],

        ["\xD0\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAB"],
        ["\xE8\xB1\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xAE"],

        ["\xD0\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8A"],
        ["\xE4\xBA\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xAF"],

        ["\xD0\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x92"],
        ["\xE8\x88\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB0"],

        ["\xD0\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8D"],
        ["\xE5\xBC\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB1"],

        ["\xD0\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x8E"],
        ["\xE4\xBA\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],

        ["\xD0\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9E"],
        ["\xE4\xBA\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB3"],

        ["\xD0\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\x9F"],
        ["\xE4\xBA\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB4"],

        ["\xD0\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA0"],
        ["\xE4\xBA\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB5"],

        ["\xD0\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xA2"],
        ["\xE4\xBA\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB6"],

        ["\xD0\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB0"],
        ["\xE4\xBA\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB7"],

        ["\xD0\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB3"],
        ["\xE4\xBA\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],

        ["\xD0\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA\xB6"],
        ["\xE4\xBA\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],

        ["\xD0\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8E"],
        ["\xE4\xBB\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xBA"],

        ["\xD0\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x8D"],
        ["\xE4\xBB\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xBB"],

        ["\xD0\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x84"],
        ["\xE4\xBB\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xBC"],

        ["\xD0\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x86"],
        ["\xE4\xBB\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xBD"],

        ["\xD0\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x82"],
        ["\xE4\xBB\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xBE"],

        ["\xD0\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x97"],
        ["\xE4\xBB\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xBF"],

        ["\xD0\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9E"],
        ["\xE4\xBB\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC0"],

        ["\xD0\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xAD"],
        ["\xE4\xBB\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC1"],

        ["\xD0\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\x9F"],
        ["\xE4\xBB\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC2"],

        ["\xD0\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB\xB7"],
        ["\xE4\xBB\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC3"],

        ["\xD0\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x89"],
        ["\xE4\xBC\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC4"],

        ["\xD0\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9A"],
        ["\xE4\xBD\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC5"],

        ["\xD0\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\xB0"],
        ["\xE4\xBC\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC6"],

        ["\xD0\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9B"],
        ["\xE4\xBD\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC7"],

        ["\xD0\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9D"],
        ["\xE4\xBD\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC8"],

        ["\xD0\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x97"],
        ["\xE4\xBD\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xC9"],

        ["\xD0\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x87"],
        ["\xE4\xBD\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xCA"],

        ["\xD0\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB6"],
        ["\xE4\xBD\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xCB"],

        ["\xD0\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x88"],
        ["\xE4\xBE\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xCC"],

        ["\xD0\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x8F"],
        ["\xE4\xBE\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xCD"],

        ["\xD0\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x98"],
        ["\xE4\xBE\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xCE"],

        ["\xD0\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xBB"],
        ["\xE4\xBD\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xCF"],

        ["\xD0\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xA9"],
        ["\xE4\xBD\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD0"],

        ["\xD0\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xB0"],
        ["\xE4\xBD\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD1"],

        ["\xD0\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x91"],
        ["\xE4\xBE\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD2"],

        ["\xD0\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\xAF"],
        ["\xE4\xBD\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD3"],

        ["\xD0\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x86"],
        ["\xE4\xBE\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD4"],

        ["\xD0\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\x96"],
        ["\xE4\xBE\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD5"],

        ["\xCB\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x98"],
        ["\xE5\x84\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCB\xF9"],

        ["\xD0\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x94"],
        ["\xE4\xBF\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD7"],

        ["\xD0\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9F"],
        ["\xE4\xBF\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD8"],

        ["\xD0\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x8E"],
        ["\xE4\xBF\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xD9"],

        ["\xD0\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x98"],
        ["\xE4\xBF\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xDA"],

        ["\xD0\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9B"],
        ["\xE4\xBF\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xDB"],

        ["\xD0\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x91"],
        ["\xE4\xBF\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xDC"],

        ["\xD0\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x9A"],
        ["\xE4\xBF\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xDD"],

        ["\xD0\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\x90"],
        ["\xE4\xBF\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xDE"],

        ["\xD0\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA4"],
        ["\xE4\xBF\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xDF"],

        ["\xD0\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xA5"],
        ["\xE4\xBF\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE0"],

        ["\xD0\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x9A"],
        ["\xE5\x80\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE1"],

        ["\xD0\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA8"],
        ["\xE5\x80\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE2"],

        ["\xD0\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x94"],
        ["\xE5\x80\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE3"],

        ["\xD0\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAA"],
        ["\xE5\x80\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE4"],

        ["\xD0\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA5"],
        ["\xE5\x80\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE5"],

        ["\xD0\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x85"],
        ["\xE5\x80\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE6"],

        ["\xD0\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC\x9C"],
        ["\xE4\xBC\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE7"],

        ["\xD0\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xB6"],
        ["\xE4\xBF\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE8"],

        ["\xD0\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA1"],
        ["\xE5\x80\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xE9"],

        ["\xD0\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xA9"],
        ["\xE5\x80\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xEA"],

        ["\xD0\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\xAC"],
        ["\xE5\x80\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xEB"],

        ["\xD0\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xBE"],
        ["\xE4\xBF\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xEC"],

        ["\xD0\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF\xAF"],
        ["\xE4\xBF\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xED"],

        ["\xD0\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x91"],
        ["\xE5\x80\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xEE"],

        ["\xD0\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x86"],
        ["\xE5\x80\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xEF"],

        ["\xD0\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x83"],
        ["\xE5\x81\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF0"],

        ["\xD0\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x87"],
        ["\xE5\x81\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF1"],

        ["\xD0\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x83"],
        ["\xE6\x9C\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF2"],

        ["\xD0\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x95"],
        ["\xE5\x81\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF3"],

        ["\xD0\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x90"],
        ["\xE5\x81\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF4"],

        ["\xD0\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x88"],
        ["\xE5\x81\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF5"],

        ["\xD0\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x9A"],
        ["\xE5\x81\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF6"],

        ["\xD0\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\x96"],
        ["\xE5\x81\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF7"],

        ["\xD0\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xAC"],
        ["\xE5\x81\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF8"],

        ["\xD0\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x81\xB8"],
        ["\xE5\x81\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xF9"],

        ["\xD0\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x80"],
        ["\xE5\x82\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xFA"],

        ["\xD0\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x9A"],
        ["\xE5\x82\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xFB"],

        ["\xD0\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\x85"],
        ["\xE5\x82\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xFC"],

        ["\xD0\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB4"],
        ["\xE5\x82\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xFD"],

        ["\xD0\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB2"],
        ["\xE5\x82\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD0\xFE"],

        ["\xD1\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x89"],
        ["\xE5\x83\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA1"],

        ["\xD1\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x8A"],
        ["\xE5\x83\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA2"],

        ["\xD1\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x82\xB3"],
        ["\xE5\x82\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA3"],

        ["\xD1\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x82"],
        ["\xE5\x83\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA4"],

        ["\xD1\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x96"],
        ["\xE5\x83\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA5"],

        ["\xD1\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\x9E"],
        ["\xE5\x83\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA6"],

        ["\xD1\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA5"],
        ["\xE5\x83\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA7"],

        ["\xD1\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xAD"],
        ["\xE5\x83\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA8"],

        ["\xD1\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xA3"],
        ["\xE5\x83\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xA9"],

        ["\xD1\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xAE"],
        ["\xE5\x83\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xAA"],

        ["\xD1\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB9"],
        ["\xE5\x83\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xAB"],

        ["\xD1\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x83\xB5"],
        ["\xE5\x83\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xAC"],

        ["\xD1\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x89"],
        ["\xE5\x84\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xAD"],

        ["\xD1\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x81"],
        ["\xE5\x84\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xAE"],

        ["\xD1\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x82"],
        ["\xE5\x84\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xAF"],

        ["\xD1\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x96"],
        ["\xE5\x84\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB0"],

        ["\xD1\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x95"],
        ["\xE5\x84\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB1"],

        ["\xD1\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x94"],
        ["\xE5\x84\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB2"],

        ["\xD1\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\x9A"],
        ["\xE5\x84\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB3"],

        ["\xD1\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xA1"],
        ["\xE5\x84\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB4"],

        ["\xD1\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBA"],
        ["\xE5\x84\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB5"],

        ["\xD1\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xB7"],
        ["\xE5\x84\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB6"],

        ["\xD1\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBC"],
        ["\xE5\x84\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB7"],

        ["\xD1\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBB"],
        ["\xE5\x84\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB8"],

        ["\xD1\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x84\xBF"],
        ["\xE5\x84\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xB9"],

        ["\xD1\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x80"],
        ["\xE5\x85\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xBA"],

        ["\xD1\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x92"],
        ["\xE5\x85\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xBB"],

        ["\xD1\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x8C"],
        ["\xE5\x85\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xBC"],

        ["\xD1\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\x94"],
        ["\xE5\x85\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xBD"],

        ["\xD1\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA2"],
        ["\xE5\x85\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xBE"],

        ["\xD1\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB8"],
        ["\xE7\xAB\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xBF"],

        ["\xD1\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xA9"],
        ["\xE5\x85\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC0"],

        ["\xD1\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAA"],
        ["\xE5\x85\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC1"],

        ["\xD1\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x85\xAE"],
        ["\xE5\x85\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC2"],

        ["\xD1\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x80"],
        ["\xE5\x86\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC3"],

        ["\xD1\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x82"],
        ["\xE5\x86\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC4"],

        ["\xD1\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x98"],
        ["\xE5\x9B\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC5"],

        ["\xD1\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8C"],
        ["\xE5\x86\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC6"],

        ["\xD1\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x89"],
        ["\xE5\x86\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC7"],

        ["\xD1\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x8F"],
        ["\xE5\x86\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC8"],

        ["\xD1\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x91"],
        ["\xE5\x86\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xC9"],

        ["\xD1\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x93"],
        ["\xE5\x86\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xCA"],

        ["\xD1\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x95"],
        ["\xE5\x86\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xCB"],

        ["\xD1\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x96"],
        ["\xE5\x86\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xCC"],

        ["\xD1\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA4"],
        ["\xE5\x86\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xCD"],

        ["\xD1\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA6"],
        ["\xE5\x86\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xCE"],

        ["\xD1\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA2"],
        ["\xE5\x86\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xCF"],

        ["\xD1\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xA9"],
        ["\xE5\x86\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD0"],

        ["\xD1\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAA"],
        ["\xE5\x86\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD1"],

        ["\xD1\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xAB"],
        ["\xE5\x86\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD2"],

        ["\xD1\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB3"],
        ["\xE5\x86\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD3"],

        ["\xD1\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB1"],
        ["\xE5\x86\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD4"],

        ["\xD1\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB2"],
        ["\xE5\x86\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD5"],

        ["\xD1\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB0"],
        ["\xE5\x86\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD6"],

        ["\xD1\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xB5"],
        ["\xE5\x86\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD7"],

        ["\xD1\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\xBD"],
        ["\xE5\x86\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD8"],

        ["\xD1\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x85"],
        ["\xE5\x87\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xD9"],

        ["\xD1\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x89"],
        ["\xE5\x87\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xDA"],

        ["\xD1\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x9B"],
        ["\xE5\x87\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xDB"],

        ["\xD1\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA0"],
        ["\xE5\x87\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xDC"],

        ["\xD1\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x95"],
        ["\xE8\x99\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xDD"],

        ["\xD1\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xA9"],
        ["\xE5\x87\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xDE"],

        ["\xD1\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xAD"],
        ["\xE5\x87\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xDF"],

        ["\xD1\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB0"],
        ["\xE5\x87\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE0"],

        ["\xD1\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xB5"],
        ["\xE5\x87\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE1"],

        ["\xD1\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\xBE"],
        ["\xE5\x87\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE2"],

        ["\xD1\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x84"],
        ["\xE5\x88\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE3"],

        ["\xD1\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8B"],
        ["\xE5\x88\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE4"],

        ["\xD1\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x94"],
        ["\xE5\x88\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE5"],

        ["\xD1\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\x8E"],
        ["\xE5\x88\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE6"],

        ["\xD1\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xA7"],
        ["\xE5\x88\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE7"],

        ["\xD1\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xAA"],
        ["\xE5\x88\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE8"],

        ["\xD1\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xAE"],
        ["\xE5\x88\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xE9"],

        ["\xD1\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB3"],
        ["\xE5\x88\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xEA"],

        ["\xD1\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x88\xB9"],
        ["\xE5\x88\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xEB"],

        ["\xD1\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8F"],
        ["\xE5\x89\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xEC"],

        ["\xD1\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x84"],
        ["\xE5\x89\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xED"],

        ["\xD1\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8B"],
        ["\xE5\x89\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xEE"],

        ["\xD1\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x8C"],
        ["\xE5\x89\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xEF"],

        ["\xD1\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x9E"],
        ["\xE5\x89\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF0"],

        ["\xD1\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\x94"],
        ["\xE5\x89\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF1"],

        ["\xD1\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xAA"],
        ["\xE5\x89\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF2"],

        ["\xD1\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB4"],
        ["\xE5\x89\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF3"],

        ["\xD1\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xA9"],
        ["\xE5\x89\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF4"],

        ["\xD1\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB3"],
        ["\xE5\x89\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF5"],

        ["\xD1\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xBF"],
        ["\xE5\x89\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF6"],

        ["\xD1\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xBD"],
        ["\xE5\x89\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF7"],

        ["\xD1\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x8D"],
        ["\xE5\x8A\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF8"],

        ["\xD1\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x94"],
        ["\xE5\x8A\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xF9"],

        ["\xD1\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x92"],
        ["\xE5\x8A\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xFA"],

        ["\xD1\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x89\xB1"],
        ["\xE5\x89\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xFB"],

        ["\xD1\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x88"],
        ["\xE5\x8A\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xFC"],

        ["\xD1\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\x91"],
        ["\xE5\x8A\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xFD"],

        ["\xD1\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA8"],
        ["\xE8\xBE\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD1\xFE"],

        ["\xD2\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA7"],
        ["\xE8\xBE\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xA1"],

        ["\xD2\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAC"],
        ["\xE5\x8A\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xA2"],

        ["\xD2\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xAD"],
        ["\xE5\x8A\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xA3"],

        ["\xD2\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xBC"],
        ["\xE5\x8A\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xA4"],

        ["\xD2\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8A\xB5"],
        ["\xE5\x8A\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xA5"],

        ["\xD2\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x81"],
        ["\xE5\x8B\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xA6"],

        ["\xD2\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x8D"],
        ["\xE5\x8B\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xA7"],

        ["\xD2\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x97"],
        ["\xE5\x8B\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xA8"],

        ["\xD2\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x9E"],
        ["\xE5\x8B\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xA9"],

        ["\xD2\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA3"],
        ["\xE5\x8B\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xAA"],

        ["\xD2\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA6"],
        ["\xE5\x8B\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xAB"],

        ["\xD2\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAD"],
        ["\xE9\xA3\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xAC"],

        ["\xD2\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xA0"],
        ["\xE5\x8B\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xAD"],

        ["\xD2\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB3"],
        ["\xE5\x8B\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xAE"],

        ["\xD2\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB5"],
        ["\xE5\x8B\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xAF"],

        ["\xD2\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB8"],
        ["\xE5\x8B\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB0"],

        ["\xD2\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\xB9"],
        ["\xE5\x8B\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB1"],

        ["\xD2\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x86"],
        ["\xE5\x8C\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB2"],

        ["\xD2\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x88"],
        ["\xE5\x8C\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB3"],

        ["\xD2\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xB8"],
        ["\xE7\x94\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB4"],

        ["\xD2\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8D"],
        ["\xE5\x8C\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB5"],

        ["\xD2\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x90"],
        ["\xE5\x8C\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB6"],

        ["\xD2\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x8F"],
        ["\xE5\x8C\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB7"],

        ["\xD2\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x95"],
        ["\xE5\x8C\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB8"],

        ["\xD2\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\x9A"],
        ["\xE5\x8C\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xB9"],

        ["\xD2\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xA3"],
        ["\xE5\x8C\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xBA"],

        ["\xD2\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xAF"],
        ["\xE5\x8C\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xBB"],

        ["\xD2\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB1"],
        ["\xE5\x8C\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xBC"],

        ["\xD2\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB3"],
        ["\xE5\x8C\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xBD"],

        ["\xD2\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8C\xB8"],
        ["\xE5\x8C\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xBE"],

        ["\xD2\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x80"],
        ["\xE5\x8D\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xBF"],

        ["\xD2\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x86"],
        ["\xE5\x8D\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC0"],

        ["\xD2\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x85"],
        ["\xE5\x8D\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC1"],

        ["\xD2\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8\x97"],
        ["\xE4\xB8\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC2"],

        ["\xD2\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x89"],
        ["\xE5\x8D\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC3"],

        ["\xD2\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x8D"],
        ["\xE5\x8D\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC4"],

        ["\xD2\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x87\x96"],
        ["\xE5\x87\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC5"],

        ["\xD2\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\x9E"],
        ["\xE5\x8D\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC6"],

        ["\xD2\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xA9"],
        ["\xE5\x8D\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC7"],

        ["\xD2\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xAE"],
        ["\xE5\x8D\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC8"],

        ["\xD2\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x98"],
        ["\xE5\xA4\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xC9"],

        ["\xD2\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xBB"],
        ["\xE5\x8D\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xCA"],

        ["\xD2\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8D\xB7"],
        ["\xE5\x8D\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xCB"],

        ["\xD2\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x82"],
        ["\xE5\x8E\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xCC"],

        ["\xD2\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\x96"],
        ["\xE5\x8E\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xCD"],

        ["\xD2\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA0"],
        ["\xE5\x8E\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xCE"],

        ["\xD2\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA6"],
        ["\xE5\x8E\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xCF"],

        ["\xD2\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xA5"],
        ["\xE5\x8E\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD0"],

        ["\xD2\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xAE"],
        ["\xE5\x8E\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD1"],

        ["\xD2\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB0"],
        ["\xE5\x8E\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD2"],

        ["\xD2\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8E\xB6"],
        ["\xE5\x8E\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD3"],

        ["\xD2\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x83"],
        ["\xE5\x8F\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD4"],

        ["\xD2\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x92"],
        ["\xE7\xB0\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD5"],

        ["\xD2\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x99"],
        ["\xE9\x9B\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD6"],

        ["\xD2\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\x9F"],
        ["\xE5\x8F\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD7"],

        ["\xD2\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xBC"],
        ["\xE6\x9B\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD8"],

        ["\xD2\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAE"],
        ["\xE7\x87\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xD9"],

        ["\xD2\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAE"],
        ["\xE5\x8F\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xDA"],

        ["\xD2\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xA8"],
        ["\xE5\x8F\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xDB"],

        ["\xD2\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xAD"],
        ["\xE5\x8F\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xDC"],

        ["\xD2\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8F\xBA"],
        ["\xE5\x8F\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xDD"],

        ["\xD2\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x81"],
        ["\xE5\x90\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xDE"],

        ["\xD2\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBD"],
        ["\xE5\x90\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xDF"],

        ["\xD2\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x80"],
        ["\xE5\x91\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE0"],

        ["\xD2\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAC"],
        ["\xE5\x90\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE1"],

        ["\xD2\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAD"],
        ["\xE5\x90\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE2"],

        ["\xD2\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xBC"],
        ["\xE5\x90\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE3"],

        ["\xD2\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xAE"],
        ["\xE5\x90\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE4"],

        ["\xD2\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xB6"],
        ["\xE5\x90\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE5"],

        ["\xD2\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\xA9"],
        ["\xE5\x90\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE6"],

        ["\xD2\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x90\x9D"],
        ["\xE5\x90\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE7"],

        ["\xD2\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x8E"],
        ["\xE5\x91\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE8"],

        ["\xD2\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8F"],
        ["\xE5\x92\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xE9"],

        ["\xD2\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB5"],
        ["\xE5\x91\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xEA"],

        ["\xD2\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x8E"],
        ["\xE5\x92\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xEB"],

        ["\xD2\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\x9F"],
        ["\xE5\x91\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xEC"],

        ["\xD2\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB1"],
        ["\xE5\x91\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xED"],

        ["\xD2\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB7"],
        ["\xE5\x91\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xEE"],

        ["\xD2\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB0"],
        ["\xE5\x91\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xEF"],

        ["\xD2\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x92"],
        ["\xE5\x92\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF0"],

        ["\xD2\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xBB"],
        ["\xE5\x91\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF1"],

        ["\xD2\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x80"],
        ["\xE5\x92\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF2"],

        ["\xD2\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x91\xB6"],
        ["\xE5\x91\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF3"],

        ["\xD2\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x84"],
        ["\xE5\x92\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF4"],

        ["\xD2\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x90"],
        ["\xE5\x92\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF5"],

        ["\xD2\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\x86"],
        ["\xE5\x92\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF6"],

        ["\xD2\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x87"],
        ["\xE5\x93\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF7"],

        ["\xD2\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA2"],
        ["\xE5\x92\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF8"],

        ["\xD2\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xB8"],
        ["\xE5\x92\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xF9"],

        ["\xD2\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA5"],
        ["\xE5\x92\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xFA"],

        ["\xD2\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAC"],
        ["\xE5\x92\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xFB"],

        ["\xD2\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x84"],
        ["\xE5\x93\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xFC"],

        ["\xD2\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x88"],
        ["\xE5\x93\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xFD"],

        ["\xD2\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA8"],
        ["\xE5\x92\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD2\xFE"],

        ["\xD3\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAB"],
        ["\xE5\x92\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA1"],

        ["\xD3\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x82"],
        ["\xE5\x93\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA2"],

        ["\xD3\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xA4"],
        ["\xE5\x92\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA3"],

        ["\xD3\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBE"],
        ["\xE5\x92\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA4"],

        ["\xD3\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xBC"],
        ["\xE5\x92\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA5"],

        ["\xD3\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\x98"],
        ["\xE5\x93\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA6"],

        ["\xD3\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA5"],
        ["\xE5\x93\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA7"],

        ["\xD3\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA6"],
        ["\xE5\x93\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA8"],

        ["\xD3\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x8F"],
        ["\xE5\x94\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xA9"],

        ["\xD3\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\x94"],
        ["\xE5\x94\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xAA"],

        ["\xD3\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xBD"],
        ["\xE5\x93\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xAB"],

        ["\xD3\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xAE"],
        ["\xE5\x93\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xAC"],

        ["\xD3\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xAD"],
        ["\xE5\x93\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xAD"],

        ["\xD3\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xBA"],
        ["\xE5\x93\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xAE"],

        ["\xD3\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x93\xA2"],
        ["\xE5\x93\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xAF"],

        ["\xD3\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB9"],
        ["\xE5\x94\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB0"],

        ["\xD3\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x80"],
        ["\xE5\x95\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB1"],

        ["\xD3\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xA3"],
        ["\xE5\x95\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB2"],

        ["\xD3\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x8C"],
        ["\xE5\x95\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB3"],

        ["\xD3\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xAE"],
        ["\xE5\x94\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB4"],

        ["\xD3\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x9C"],
        ["\xE5\x95\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB5"],

        ["\xD3\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x85"],
        ["\xE5\x95\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB6"],

        ["\xD3\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x96"],
        ["\xE5\x95\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB7"],

        ["\xD3\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x97"],
        ["\xE5\x95\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB8"],

        ["\xD3\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB8"],
        ["\xE5\x94\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xB9"],

        ["\xD3\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x94\xB3"],
        ["\xE5\x94\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xBA"],

        ["\xD3\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\x9D"],
        ["\xE5\x95\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xBB"],

        ["\xD3\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x99"],
        ["\xE5\x96\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xBC"],

        ["\xD3\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x80"],
        ["\xE5\x96\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xBD"],

        ["\xD3\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x92\xAF"],
        ["\xE5\x92\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xBE"],

        ["\xD3\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x8A"],
        ["\xE5\x96\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xBF"],

        ["\xD3\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9F"],
        ["\xE5\x96\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC0"],

        ["\xD3\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBB"],
        ["\xE5\x95\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC1"],

        ["\xD3\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBE"],
        ["\xE5\x95\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC2"],

        ["\xD3\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x98"],
        ["\xE5\x96\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC3"],

        ["\xD3\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x9E"],
        ["\xE5\x96\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC4"],

        ["\xD3\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xAE"],
        ["\xE5\x96\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC5"],

        ["\xD3\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x95\xBC"],
        ["\xE5\x95\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC6"],

        ["\xD3\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x83"],
        ["\xE5\x96\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC7"],

        ["\xD3\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA9"],
        ["\xE5\x96\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC8"],

        ["\xD3\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\x87"],
        ["\xE5\x96\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xC9"],

        ["\xD3\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x96\xA8"],
        ["\xE5\x96\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xCA"],

        ["\xD3\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9A"],
        ["\xE5\x97\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xCB"],

        ["\xD3\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x85"],
        ["\xE5\x97\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xCC"],

        ["\xD3\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9F"],
        ["\xE5\x97\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xCD"],

        ["\xD3\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x84"],
        ["\xE5\x97\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xCE"],

        ["\xD3\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x9C"],
        ["\xE5\x97\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xCF"],

        ["\xD3\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xA4"],
        ["\xE5\x97\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD0"],

        ["\xD3\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x94"],
        ["\xE5\x97\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD1"],

        ["\xD3\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x94"],
        ["\xE5\x98\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD2"],

        ["\xD3\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xB7"],
        ["\xE5\x97\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD3"],

        ["\xD3\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x96"],
        ["\xE5\x98\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD4"],

        ["\xD3\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xBE"],
        ["\xE5\x97\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD5"],

        ["\xD3\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xBD"],
        ["\xE5\x97\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD6"],

        ["\xD3\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\x9B"],
        ["\xE5\x98\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD7"],

        ["\xD3\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\xB9"],
        ["\xE5\x97\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD8"],

        ["\xD3\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x8E"],
        ["\xE5\x99\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xD9"],

        ["\xD3\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\x90"],
        ["\xE5\x99\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xDA"],

        ["\xD3\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x9F"],
        ["\xE7\x87\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xDB"],

        ["\xD3\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB4"],
        ["\xE5\x98\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xDC"],

        ["\xD3\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB6"],
        ["\xE5\x98\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xDD"],

        ["\xD3\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB2"],
        ["\xE5\x98\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xDE"],

        ["\xD3\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xB8"],
        ["\xE5\x98\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xDF"],

        ["\xD3\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAB"],
        ["\xE5\x99\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE0"],

        ["\xD3\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xA4"],
        ["\xE5\x99\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE1"],

        ["\xD3\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x98\xAF"],
        ["\xE5\x98\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE2"],

        ["\xD3\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAC"],
        ["\xE5\x99\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE3"],

        ["\xD3\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x99\xAA"],
        ["\xE5\x99\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE4"],

        ["\xD3\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x86"],
        ["\xE5\x9A\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE5"],

        ["\xD3\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x80"],
        ["\xE5\x9A\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE6"],

        ["\xD3\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x8A"],
        ["\xE5\x9A\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE7"],

        ["\xD3\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA0"],
        ["\xE5\x9A\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE8"],

        ["\xD3\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x94"],
        ["\xE5\x9A\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xE9"],

        ["\xD3\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\x8F"],
        ["\xE5\x9A\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xEA"],

        ["\xD3\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xA5"],
        ["\xE5\x9A\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xEB"],

        ["\xD3\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xAE"],
        ["\xE5\x9A\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xEC"],

        ["\xD3\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xB6"],
        ["\xE5\x9A\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xED"],

        ["\xD3\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xB4"],
        ["\xE5\x9A\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xEE"],

        ["\xD3\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x82"],
        ["\xE5\x9B\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xEF"],

        ["\xD3\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9A\xBC"],
        ["\xE5\x9A\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF0"],

        ["\xD3\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x81"],
        ["\xE5\x9B\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF1"],

        ["\xD3\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x83"],
        ["\xE5\x9B\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF2"],

        ["\xD3\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x80"],
        ["\xE5\x9B\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF3"],

        ["\xD3\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x88"],
        ["\xE5\x9B\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF4"],

        ["\xD3\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x8E"],
        ["\xE5\x9B\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF5"],

        ["\xD3\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x91"],
        ["\xE5\x9B\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF6"],

        ["\xD3\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x93"],
        ["\xE5\x9B\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF7"],

        ["\xD3\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\x97"],
        ["\xE5\x9B\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF8"],

        ["\xD3\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xAE"],
        ["\xE5\x9B\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xF9"],

        ["\xD3\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xB9"],
        ["\xE5\x9B\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xFA"],

        ["\xD3\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x80"],
        ["\xE5\x9C\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xFB"],

        ["\xD3\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9B\xBF"],
        ["\xE5\x9B\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xFC"],

        ["\xD3\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x84"],
        ["\xE5\x9C\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xFD"],

        ["\xD3\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x89"],
        ["\xE5\x9C\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD3\xFE"],

        ["\xD4\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x88"],
        ["\xE5\x9C\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA1"],

        ["\xD4\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8B"],
        ["\xE5\x9C\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA2"],

        ["\xD4\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x8D"],
        ["\xE5\x9C\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA3"],

        ["\xD4\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x93"],
        ["\xE5\x9C\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA4"],

        ["\xD4\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x98"],
        ["\xE5\x9C\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA5"],

        ["\xD4\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x96"],
        ["\xE5\x9C\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA6"],

        ["\xD4\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x97\x87"],
        ["\xE5\x97\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA7"],

        ["\xD4\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\x9C"],
        ["\xE5\x9C\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA8"],

        ["\xD4\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xA6"],
        ["\xE5\x9C\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xA9"],

        ["\xD4\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB7"],
        ["\xE5\x9C\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xAA"],

        ["\xD4\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xB8"],
        ["\xE5\x9C\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xAB"],

        ["\xD4\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8E"],
        ["\xE5\x9D\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xAC"],

        ["\xD4\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9C\xBB"],
        ["\xE5\x9C\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xAD"],

        ["\xD4\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x80"],
        ["\xE5\x9D\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xAE"],

        ["\xD4\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\x8F"],
        ["\xE5\x9D\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xAF"],

        ["\xD4\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA9"],
        ["\xE5\x9D\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB0"],

        ["\xD4\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x80"],
        ["\xE5\x9F\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB1"],

        ["\xD4\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x88"],
        ["\xE5\x9E\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB2"],

        ["\xD4\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xA1"],
        ["\xE5\x9D\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB3"],

        ["\xD4\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9D\xBF"],
        ["\xE5\x9D\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB4"],

        ["\xD4\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x89"],
        ["\xE5\x9E\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB5"],

        ["\xD4\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\x93"],
        ["\xE5\x9E\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB6"],

        ["\xD4\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA0"],
        ["\xE5\x9E\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB7"],

        ["\xD4\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xB3"],
        ["\xE5\x9E\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB8"],

        ["\xD4\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xA4"],
        ["\xE5\x9E\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xB9"],

        ["\xD4\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xAA"],
        ["\xE5\x9E\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xBA"],

        ["\xD4\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9E\xB0"],
        ["\xE5\x9E\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xBB"],

        ["\xD4\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x83"],
        ["\xE5\x9F\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xBC"],

        ["\xD4\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x86"],
        ["\xE5\x9F\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xBD"],

        ["\xD4\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x94"],
        ["\xE5\x9F\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xBE"],

        ["\xD4\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x92"],
        ["\xE5\x9F\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xBF"],

        ["\xD4\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x93"],
        ["\xE5\x9F\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC0"],

        ["\xD4\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x8A"],
        ["\xE5\xA0\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC1"],

        ["\xD4\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\x96"],
        ["\xE5\x9F\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC2"],

        ["\xD4\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x9F\xA3"],
        ["\xE5\x9F\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC3"],

        ["\xD4\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x8B"],
        ["\xE5\xA0\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC4"],

        ["\xD4\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x99"],
        ["\xE5\xA0\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC5"],

        ["\xD4\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\x9D"],
        ["\xE5\xA0\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC6"],

        ["\xD4\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB2"],
        ["\xE5\xA1\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC7"],

        ["\xD4\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xA1"],
        ["\xE5\xA0\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC8"],

        ["\xD4\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xA2"],
        ["\xE5\xA1\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xC9"],

        ["\xD4\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x8B"],
        ["\xE5\xA1\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xCA"],

        ["\xD4\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB0"],
        ["\xE5\xA1\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xCB"],

        ["\xD4\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x80"],
        ["\xE6\xAF\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xCC"],

        ["\xD4\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\x92"],
        ["\xE5\xA1\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xCD"],

        ["\xD4\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA0\xBD"],
        ["\xE5\xA0\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xCE"],

        ["\xD4\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1\xB9"],
        ["\xE5\xA1\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xCF"],

        ["\xD4\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x85"],
        ["\xE5\xA2\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD0"],

        ["\xD4\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB9"],
        ["\xE5\xA2\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD1"],

        ["\xD4\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\x9F"],
        ["\xE5\xA2\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD2"],

        ["\xD4\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xAB"],
        ["\xE5\xA2\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD3"],

        ["\xD4\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBA"],
        ["\xE5\xA2\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD4"],

        ["\xD4\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9E"],
        ["\xE5\xA3\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD5"],

        ["\xD4\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xBB"],
        ["\xE5\xA2\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD6"],

        ["\xD4\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xB8"],
        ["\xE5\xA2\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD7"],

        ["\xD4\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2\xAE"],
        ["\xE5\xA2\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD8"],

        ["\xD4\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x85"],
        ["\xE5\xA3\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xD9"],

        ["\xD4\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x93"],
        ["\xE5\xA3\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xDA"],

        ["\xD4\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x91"],
        ["\xE5\xA3\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xDB"],

        ["\xD4\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x97"],
        ["\xE5\xA3\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xDC"],

        ["\xD4\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x99"],
        ["\xE5\xA3\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xDD"],

        ["\xD4\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x98"],
        ["\xE5\xA3\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xDE"],

        ["\xD4\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA5"],
        ["\xE5\xA3\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xDF"],

        ["\xD4\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9C"],
        ["\xE5\xA3\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE0"],

        ["\xD4\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xA4"],
        ["\xE5\xA3\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE1"],

        ["\xD4\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\x9F"],
        ["\xE5\xA3\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE2"],

        ["\xD4\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xAF"],
        ["\xE5\xA3\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE3"],

        ["\xC4\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBA"],
        ["\xE5\xA3\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC4\xDB"],

        ["\xD4\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xB9"],
        ["\xE5\xA3\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE5"],

        ["\xD4\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBB"],
        ["\xE5\xA3\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE6"],

        ["\xD4\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBC"],
        ["\xE5\xA3\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE7"],

        ["\xD4\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3\xBD"],
        ["\xE5\xA3\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE8"],

        ["\xD4\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x82"],
        ["\xE5\xA4\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xE9"],

        ["\xD4\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x8A"],
        ["\xE5\xA4\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xEA"],

        ["\xD4\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x90"],
        ["\xE5\xA4\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xEB"],

        ["\xD4\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\x9B"],
        ["\xE5\xA4\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xEC"],

        ["\xD4\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA6"],
        ["\xE6\xA2\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xED"],

        ["\xD4\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xA5"],
        ["\xE5\xA4\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xEE"],

        ["\xD4\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAC"],
        ["\xE5\xA4\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xEF"],

        ["\xD4\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xAD"],
        ["\xE5\xA4\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF0"],

        ["\xD4\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB2"],
        ["\xE5\xA4\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF1"],

        ["\xD4\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xB8"],
        ["\xE5\xA4\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF2"],

        ["\xD4\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4\xBE"],
        ["\xE5\xA4\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF3"],

        ["\xD4\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x92"],
        ["\xE7\xAB\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF4"],

        ["\xD4\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x95"],
        ["\xE5\xA5\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF5"],

        ["\xD4\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x90"],
        ["\xE5\xA5\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF6"],

        ["\xD4\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x8E"],
        ["\xE5\xA5\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF7"],

        ["\xD4\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x9A"],
        ["\xE5\xA5\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF8"],

        ["\xD4\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\x98"],
        ["\xE5\xA5\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xF9"],

        ["\xD4\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA2"],
        ["\xE5\xA5\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xFA"],

        ["\xD4\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA0"],
        ["\xE5\xA5\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xFB"],

        ["\xD4\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA7"],
        ["\xE5\xA5\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xFC"],

        ["\xD4\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xAC"],
        ["\xE5\xA5\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xFD"],

        ["\xD4\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xA9"],
        ["\xE5\xA5\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD4\xFE"],

        ["\xD5\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5\xB8"],
        ["\xE5\xA5\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xA1"],

        ["\xD5\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x81"],
        ["\xE5\xA6\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xA2"],

        ["\xD5\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x9D"],
        ["\xE5\xA6\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xA3"],

        ["\xD5\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD\x9E"],
        ["\xE4\xBD\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xA4"],

        ["\xD5\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE\xAB"],
        ["\xE4\xBE\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xA5"],

        ["\xD5\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xA3"],
        ["\xE5\xA6\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xA6"],

        ["\xD5\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\xB2"],
        ["\xE5\xA6\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xA7"],

        ["\xD5\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x86"],
        ["\xE5\xA7\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xA8"],

        ["\xD5\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\xA8"],
        ["\xE5\xA7\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xA9"],

        ["\xD5\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9C"],
        ["\xE5\xA7\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xAA"],

        ["\xD5\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x8D"],
        ["\xE5\xA6\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xAB"],

        ["\xD5\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x99"],
        ["\xE5\xA7\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xAC"],

        ["\xD5\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7\x9A"],
        ["\xE5\xA7\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xAD"],

        ["\xD5\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xA5"],
        ["\xE5\xA8\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xAE"],

        ["\xD5\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9F"],
        ["\xE5\xA8\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xAF"],

        ["\xD5\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x91"],
        ["\xE5\xA8\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB0"],

        ["\xD5\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9C"],
        ["\xE5\xA8\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB1"],

        ["\xD5\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x89"],
        ["\xE5\xA8\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB2"],

        ["\xD5\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\x9A"],
        ["\xE5\xA8\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB3"],

        ["\xD5\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x80"],
        ["\xE5\xA9\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB4"],

        ["\xD5\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xAC"],
        ["\xE5\xA9\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB5"],

        ["\xD5\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\x89"],
        ["\xE5\xA9\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB6"],

        ["\xD5\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xB5"],
        ["\xE5\xA8\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB7"],

        ["\xD5\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8\xB6"],
        ["\xE5\xA8\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB8"],

        ["\xD5\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xA2"],
        ["\xE5\xA9\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xB9"],

        ["\xD5\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9\xAA"],
        ["\xE5\xA9\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xBA"],

        ["\xD5\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\x9A"],
        ["\xE5\xAA\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xBB"],

        ["\xD5\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBC"],
        ["\xE5\xAA\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xBC"],

        ["\xD5\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBE"],
        ["\xE5\xAA\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xBD"],

        ["\xD5\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x8B"],
        ["\xE5\xAB\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xBE"],

        ["\xD5\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x82"],
        ["\xE5\xAB\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xBF"],

        ["\xD5\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA\xBD"],
        ["\xE5\xAA\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC0"],

        ["\xD5\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA3"],
        ["\xE5\xAB\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC1"],

        ["\xD5\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x97"],
        ["\xE5\xAB\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC2"],

        ["\xD5\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA6"],
        ["\xE5\xAB\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC3"],

        ["\xD5\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xA9"],
        ["\xE5\xAB\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC4"],

        ["\xD5\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x96"],
        ["\xE5\xAB\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC5"],

        ["\xD5\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xBA"],
        ["\xE5\xAB\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC6"],

        ["\xD5\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\xBB"],
        ["\xE5\xAB\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC7"],

        ["\xD5\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x8C"],
        ["\xE5\xAC\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC8"],

        ["\xD5\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x8B"],
        ["\xE5\xAC\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xC9"],

        ["\xD5\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\x96"],
        ["\xE5\xAC\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xCA"],

        ["\xD5\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB2"],
        ["\xE5\xAC\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xCB"],

        ["\xD5\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB\x90"],
        ["\xE5\xAB\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xCC"],

        ["\xD5\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xAA"],
        ["\xE5\xAC\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xCD"],

        ["\xD5\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xB6"],
        ["\xE5\xAC\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xCE"],

        ["\xD5\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC\xBE"],
        ["\xE5\xAC\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xCF"],

        ["\xD5\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x83"],
        ["\xE5\xAD\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD0"],

        ["\xD5\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x85"],
        ["\xE5\xAD\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD1"],

        ["\xD5\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x80"],
        ["\xE5\xAD\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD2"],

        ["\xD5\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x91"],
        ["\xE5\xAD\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD3"],

        ["\xD5\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x95"],
        ["\xE5\xAD\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD4"],

        ["\xD5\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9A"],
        ["\xE5\xAD\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD5"],

        ["\xD5\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\x9B"],
        ["\xE5\xAD\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD6"],

        ["\xD5\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA5"],
        ["\xE5\xAD\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD7"],

        ["\xD5\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xA9"],
        ["\xE5\xAD\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD8"],

        ["\xD5\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB0"],
        ["\xE5\xAD\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xD9"],

        ["\xD5\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB3"],
        ["\xE5\xAD\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xDA"],

        ["\xD5\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB5"],
        ["\xE5\xAD\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xDB"],

        ["\xD5\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB8"],
        ["\xE5\xAD\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xDC"],

        ["\xD5\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x88"],
        ["\xE6\x96\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xDD"],

        ["\xD5\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xBA"],
        ["\xE5\xAD\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xDE"],

        ["\xD5\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x80"],
        ["\xE5\xAE\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xDF"],

        ["\xD5\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\x83"],
        ["\xE5\xAE\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE0"],

        ["\xD5\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xA6"],
        ["\xE5\xAE\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE1"],

        ["\xD5\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE\xB8"],
        ["\xE5\xAE\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE2"],

        ["\xD5\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x83"],
        ["\xE5\xAF\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE3"],

        ["\xD5\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x87"],
        ["\xE5\xAF\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE4"],

        ["\xD5\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x89"],
        ["\xE5\xAF\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE5"],

        ["\xD5\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x94"],
        ["\xE5\xAF\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE6"],

        ["\xD5\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x90"],
        ["\xE5\xAF\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE7"],

        ["\xD5\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA4"],
        ["\xE5\xAF\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE8"],

        ["\xD5\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA6"],
        ["\xE5\xAF\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xE9"],

        ["\xD5\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA2"],
        ["\xE5\xAF\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xEA"],

        ["\xD5\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\x9E"],
        ["\xE5\xAF\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xEB"],

        ["\xD5\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA5"],
        ["\xE5\xAF\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xEC"],

        ["\xD5\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xAB"],
        ["\xE5\xAF\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xED"],

        ["\xD5\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB0"],
        ["\xE5\xAF\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xEE"],

        ["\xD5\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB6"],
        ["\xE5\xAF\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xEF"],

        ["\xD5\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xB3"],
        ["\xE5\xAF\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF0"],

        ["\xD5\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x85"],
        ["\xE5\xB0\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF1"],

        ["\xD5\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x87"],
        ["\xE5\xB0\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF2"],

        ["\xD5\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x88"],
        ["\xE5\xB0\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF3"],

        ["\xD5\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x8D"],
        ["\xE5\xB0\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF4"],

        ["\xD5\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\x93"],
        ["\xE5\xB0\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF5"],

        ["\xD5\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA0"],
        ["\xE5\xB0\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF6"],

        ["\xD5\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA2"],
        ["\xE5\xB0\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF7"],

        ["\xD5\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xA8"],
        ["\xE5\xB0\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF8"],

        ["\xD5\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB8"],
        ["\xE5\xB0\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xF9"],

        ["\xD5\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0\xB9"],
        ["\xE5\xB0\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xFA"],

        ["\xD5\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x81"],
        ["\xE5\xB1\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xFB"],

        ["\xD5\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x86"],
        ["\xE5\xB1\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xFC"],

        ["\xD5\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8E"],
        ["\xE5\xB1\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xFD"],

        ["\xD5\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x93"],
        ["\xE5\xB1\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD5\xFE"],

        ["\xD6\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x90"],
        ["\xE5\xB1\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xA1"],

        ["\xD6\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\x8F"],
        ["\xE5\xB1\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xA2"],

        ["\xD6\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD\xB1"],
        ["\xE5\xAD\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xA3"],

        ["\xD6\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAC"],
        ["\xE5\xB1\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xA4"],

        ["\xD6\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xAE"],
        ["\xE5\xB1\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xA5"],

        ["\xD6\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\xA2"],
        ["\xE4\xB9\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xA6"],

        ["\xD6\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB6"],
        ["\xE5\xB1\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xA7"],

        ["\xD6\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1\xB9"],
        ["\xE5\xB1\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xA8"],

        ["\xD6\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x8C"],
        ["\xE5\xB2\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xA9"],

        ["\xD6\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x91"],
        ["\xE5\xB2\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xAA"],

        ["\xD6\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\x94"],
        ["\xE5\xB2\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xAB"],

        ["\xD6\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6\x9B"],
        ["\xE5\xA6\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xAC"],

        ["\xD6\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xAB"],
        ["\xE5\xB2\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xAD"],

        ["\xD6\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBB"],
        ["\xE5\xB2\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xAE"],

        ["\xD6\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB6"],
        ["\xE5\xB2\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xAF"],

        ["\xD6\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBC"],
        ["\xE5\xB2\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB0"],

        ["\xD6\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xB7"],
        ["\xE5\xB2\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB1"],

        ["\xD6\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x85"],
        ["\xE5\xB3\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB2"],

        ["\xD6\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2\xBE"],
        ["\xE5\xB2\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB3"],

        ["\xD6\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x87"],
        ["\xE5\xB3\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB4"],

        ["\xD6\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\x99"],
        ["\xE5\xB3\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB5"],

        ["\xD6\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xA9"],
        ["\xE5\xB3\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB6"],

        ["\xD6\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBD"],
        ["\xE5\xB3\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB7"],

        ["\xD6\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xBA"],
        ["\xE5\xB3\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB8"],

        ["\xD6\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAD"],
        ["\xE5\xB3\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xB9"],

        ["\xD6\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x8C"],
        ["\xE5\xB6\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xBA"],

        ["\xD6\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3\xAA"],
        ["\xE5\xB3\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xBB"],

        ["\xD6\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x8B"],
        ["\xE5\xB4\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xBC"],

        ["\xD6\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x95"],
        ["\xE5\xB4\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xBD"],

        ["\xD6\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x97"],
        ["\xE5\xB4\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xBE"],

        ["\xD6\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x9C"],
        ["\xE5\xB5\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xBF"],

        ["\xD6\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9F"],
        ["\xE5\xB4\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC0"],

        ["\xD6\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9B"],
        ["\xE5\xB4\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC1"],

        ["\xD6\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x91"],
        ["\xE5\xB4\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC2"],

        ["\xD6\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x94"],
        ["\xE5\xB4\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC3"],

        ["\xD6\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\xA2"],
        ["\xE5\xB4\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC4"],

        ["\xD6\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x9A"],
        ["\xE5\xB4\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC5"],

        ["\xD6\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x99"],
        ["\xE5\xB4\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC6"],

        ["\xD6\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4\x98"],
        ["\xE5\xB4\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC7"],

        ["\xD6\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8C"],
        ["\xE5\xB5\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC8"],

        ["\xD6\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x92"],
        ["\xE5\xB5\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xC9"],

        ["\xD6\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8E"],
        ["\xE5\xB5\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xCA"],

        ["\xD6\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\x8B"],
        ["\xE5\xB5\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xCB"],

        ["\xD6\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xAC"],
        ["\xE5\xB5\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xCC"],

        ["\xD6\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xB3"],
        ["\xE5\xB5\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xCD"],

        ["\xD6\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5\xB6"],
        ["\xE5\xB5\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xCE"],

        ["\xD6\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x87"],
        ["\xE5\xB6\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xCF"],

        ["\xD6\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x84"],
        ["\xE5\xB6\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD0"],

        ["\xD6\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x82"],
        ["\xE5\xB6\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD1"],

        ["\xD6\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xA2"],
        ["\xE5\xB6\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD2"],

        ["\xD6\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x9D"],
        ["\xE5\xB6\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD3"],

        ["\xD6\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xAC"],
        ["\xE5\xB6\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD4"],

        ["\xD6\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xAE"],
        ["\xE5\xB6\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD5"],

        ["\xD6\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBD"],
        ["\xE5\xB6\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD6"],

        ["\xD6\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\x90"],
        ["\xE5\xB6\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD7"],

        ["\xD6\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xB7"],
        ["\xE5\xB6\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD8"],

        ["\xD6\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6\xBC"],
        ["\xE5\xB6\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xD9"],

        ["\xD6\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x89"],
        ["\xE5\xB7\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xDA"],

        ["\xD6\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x8D"],
        ["\xE5\xB7\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xDB"],

        ["\xD6\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x93"],
        ["\xE5\xB7\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xDC"],

        ["\xD6\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x92"],
        ["\xE5\xB7\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xDD"],

        ["\xD6\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x96"],
        ["\xE5\xB7\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xDE"],

        ["\xD6\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\x9B"],
        ["\xE5\xB7\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xDF"],

        ["\xD6\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xAB"],
        ["\xE5\xB7\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE0"],

        ["\xD6\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB2"],
        ["\xE5\xB7\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE1"],

        ["\xD6\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7\xB5"],
        ["\xE5\xB7\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE2"],

        ["\xD6\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x8B"],
        ["\xE5\xB8\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE3"],

        ["\xD6\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9A"],
        ["\xE5\xB8\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE4"],

        ["\xD6\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x99"],
        ["\xE5\xB8\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE5"],

        ["\xD6\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x91"],
        ["\xE5\xB8\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE6"],

        ["\xD6\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\x9B"],
        ["\xE5\xB8\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE7"],

        ["\xD6\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB6"],
        ["\xE5\xB8\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE8"],

        ["\xD6\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8\xB7"],
        ["\xE5\xB8\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xE9"],

        ["\xD6\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x84"],
        ["\xE5\xB9\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xEA"],

        ["\xD6\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x83"],
        ["\xE5\xB9\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xEB"],

        ["\xD6\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x80"],
        ["\xE5\xB9\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xEC"],

        ["\xD6\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x8E"],
        ["\xE5\xB9\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xED"],

        ["\xD6\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x97"],
        ["\xE5\xB9\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xEE"],

        ["\xD6\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x94"],
        ["\xE5\xB9\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xEF"],

        ["\xD6\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x9F"],
        ["\xE5\xB9\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF0"],

        ["\xD6\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA2"],
        ["\xE5\xB9\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF1"],

        ["\xD6\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xA4"],
        ["\xE5\xB9\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF2"],

        ["\xD6\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\x87"],
        ["\xE5\xB9\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF3"],

        ["\xD6\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB5"],
        ["\xE5\xB9\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF4"],

        ["\xD6\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xB6"],
        ["\xE5\xB9\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF5"],

        ["\xD6\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBA"],
        ["\xE5\xB9\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF6"],

        ["\xD6\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBC"],
        ["\xE9\xBA\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF7"],

        ["\xD6\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9\xBF"],
        ["\xE5\xB9\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF8"],

        ["\xD6\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA\xA0"],
        ["\xE5\xBA\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xF9"],

        ["\xD6\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x81"],
        ["\xE5\xBB\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xFA"],

        ["\xD6\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x82"],
        ["\xE5\xBB\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xFB"],

        ["\xD6\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x88"],
        ["\xE5\xBB\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xFC"],

        ["\xD6\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x90"],
        ["\xE5\xBB\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xFD"],

        ["\xD6\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x8F"],
        ["\xE5\xBB\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD6\xFE"],

        ["\xD7\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x96"],
        ["\xE5\xBB\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xA1"],

        ["\xD7\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA3"],
        ["\xE5\xBB\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xA2"],

        ["\xD7\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9D"],
        ["\xE5\xBB\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xA3"],

        ["\xD7\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9A"],
        ["\xE5\xBB\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xA4"],

        ["\xD7\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\x9B"],
        ["\xE5\xBB\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xA5"],

        ["\xD7\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA2"],
        ["\xE5\xBB\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xA6"],

        ["\xD7\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA1"],
        ["\xE5\xBB\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xA7"],

        ["\xD7\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA8"],
        ["\xE5\xBB\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xA8"],

        ["\xD7\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xA9"],
        ["\xE5\xBB\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xA9"],

        ["\xD7\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xAC"],
        ["\xE5\xBB\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xAA"],

        ["\xD7\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB1"],
        ["\xE5\xBB\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xAB"],

        ["\xD7\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB3"],
        ["\xE5\xBB\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xAC"],

        ["\xD7\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB0"],
        ["\xE5\xBB\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xAD"],

        ["\xD7\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB4"],
        ["\xE5\xBB\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xAE"],

        ["\xD7\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xB8"],
        ["\xE5\xBB\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xAF"],

        ["\xD7\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB\xBE"],
        ["\xE5\xBB\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB0"],

        ["\xD7\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x83"],
        ["\xE5\xBC\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB1"],

        ["\xD7\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x89"],
        ["\xE5\xBC\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB2"],

        ["\xD7\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x9D"],
        ["\xE5\xBD\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB3"],

        ["\xD7\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x9C"],
        ["\xE5\xBD\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB4"],

        ["\xD7\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x8B"],
        ["\xE5\xBC\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB5"],

        ["\xD7\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x91"],
        ["\xE5\xBC\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB6"],

        ["\xD7\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\x96"],
        ["\xE5\xBC\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB7"],

        ["\xD7\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xA9"],
        ["\xE5\xBC\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB8"],

        ["\xD7\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xAD"],
        ["\xE5\xBC\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xB9"],

        ["\xD7\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xB8"],
        ["\xE5\xBC\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xBA"],

        ["\xD7\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x88"],
        ["\xE5\xBD\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xBC"],

        ["\xD7\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8C"],
        ["\xE5\xBD\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xBD"],

        ["\xD7\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x8E"],
        ["\xE5\xBD\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xBE"],

        ["\xD7\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC\xAF"],
        ["\xE5\xBC\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xBF"],

        ["\xD7\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x91"],
        ["\xE5\xBD\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC0"],

        ["\xD7\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x96"],
        ["\xE5\xBD\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC1"],

        ["\xD7\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x97"],
        ["\xE5\xBD\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC2"],

        ["\xD7\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\x99"],
        ["\xE5\xBD\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC3"],

        ["\xD7\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xA1"],
        ["\xE5\xBD\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC4"],

        ["\xD7\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xAD"],
        ["\xE5\xBD\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC5"],

        ["\xD7\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB3"],
        ["\xE5\xBD\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC6"],

        ["\xD7\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xB7"],
        ["\xE5\xBD\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC7"],

        ["\xD7\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x83"],
        ["\xE5\xBE\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC8"],

        ["\xD7\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x82"],
        ["\xE5\xBE\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xC9"],

        ["\xD7\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD\xBF"],
        ["\xE5\xBD\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xCA"],

        ["\xD7\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x8A"],
        ["\xE5\xBE\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xCB"],

        ["\xD7\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x88"],
        ["\xE5\xBE\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xCC"],

        ["\xD7\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x91"],
        ["\xE5\xBE\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xCD"],

        ["\xD7\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x87"],
        ["\xE5\xBE\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xCE"],

        ["\xD7\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x9E"],
        ["\xE5\xBE\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xCF"],

        ["\xD7\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x99"],
        ["\xE5\xBE\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD0"],

        ["\xD7\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\x98"],
        ["\xE5\xBE\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD1"],

        ["\xD7\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA0"],
        ["\xE5\xBE\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD2"],

        ["\xD7\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xA8"],
        ["\xE5\xBE\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD3"],

        ["\xD7\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xAD"],
        ["\xE5\xBE\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD4"],

        ["\xD7\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE\xBC"],
        ["\xE5\xBE\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD5"],

        ["\xD7\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x96"],
        ["\xE5\xBF\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD6"],

        ["\xD7\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBB"],
        ["\xE5\xBF\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD7"],

        ["\xD7\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xA4"],
        ["\xE5\xBF\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD8"],

        ["\xD7\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB8"],
        ["\xE5\xBF\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xD9"],

        ["\xD7\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB1"],
        ["\xE5\xBF\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xDA"],

        ["\xD7\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\x9D"],
        ["\xE5\xBF\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xDB"],

        ["\xD7\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB3"],
        ["\xE6\x82\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xDC"],

        ["\xD7\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xBF"],
        ["\xE5\xBF\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xDD"],

        ["\xD7\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA1"],
        ["\xE6\x80\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xDE"],

        ["\xD7\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA0"],
        ["\xE6\x81\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xDF"],

        ["\xD7\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x99"],
        ["\xE6\x80\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE0"],

        ["\xD7\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x90"],
        ["\xE6\x80\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE1"],

        ["\xD7\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA9"],
        ["\xE6\x80\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE2"],

        ["\xD7\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x8E"],
        ["\xE6\x80\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE3"],

        ["\xD7\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xB1"],
        ["\xE6\x80\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE4"],

        ["\xD7\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x9B"],
        ["\xE6\x80\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE5"],

        ["\xD7\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x95"],
        ["\xE6\x80\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE6"],

        ["\xD7\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xAB"],
        ["\xE6\x80\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE7"],

        ["\xD7\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xA6"],
        ["\xE6\x80\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE8"],

        ["\xD7\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\x8F"],
        ["\xE6\x80\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xE9"],

        ["\xD7\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x80\xBA"],
        ["\xE6\x80\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xEA"],

        ["\xD7\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x9A"],
        ["\xE6\x81\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xEB"],

        ["\xD7\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x81"],
        ["\xE6\x81\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xEC"],

        ["\xD7\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAA"],
        ["\xE6\x81\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xED"],

        ["\xD7\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xB7"],
        ["\xE6\x81\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xEE"],

        ["\xD7\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x9F"],
        ["\xE6\x81\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xEF"],

        ["\xD7\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8A"],
        ["\xE6\x81\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF0"],

        ["\xD7\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x86"],
        ["\xE6\x81\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF1"],

        ["\xD7\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x8D"],
        ["\xE6\x81\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF2"],

        ["\xD7\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA3"],
        ["\xE6\x81\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF3"],

        ["\xD7\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x83"],
        ["\xE6\x81\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF4"],

        ["\xD7\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xA4"],
        ["\xE6\x81\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF5"],

        ["\xD7\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x82"],
        ["\xE6\x81\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF6"],

        ["\xD7\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAC"],
        ["\xE6\x81\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF7"],

        ["\xD7\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\xAB"],
        ["\xE6\x81\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF8"],

        ["\xD7\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x81\x99"],
        ["\xE6\x81\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xF9"],

        ["\xD7\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x81"],
        ["\xE6\x82\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xFA"],

        ["\xD7\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8D"],
        ["\xE6\x82\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xFB"],

        ["\xD7\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA7"],
        ["\xE6\x83\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xFC"],

        ["\xD7\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x83"],
        ["\xE6\x82\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xFD"],

        ["\xD7\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9A"],
        ["\xE6\x82\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD7\xFE"],

        ["\xD8\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x84"],
        ["\xE6\x82\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA1"],

        ["\xD8\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x9B"],
        ["\xE6\x82\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA2"],

        ["\xD8\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x96"],
        ["\xE6\x82\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA3"],

        ["\xD8\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x97"],
        ["\xE6\x82\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA4"],

        ["\xD8\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x92"],
        ["\xE6\x82\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA5"],

        ["\xD8\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xA7"],
        ["\xE6\x82\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA6"],

        ["\xD8\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\x8B"],
        ["\xE6\x82\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA7"],

        ["\xD8\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA1"],
        ["\xE6\x83\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA8"],

        ["\xD8\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB8"],
        ["\xE6\x82\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xA9"],

        ["\xD8\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xA0"],
        ["\xE6\x83\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xAA"],

        ["\xD8\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x93"],
        ["\xE6\x83\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xAB"],

        ["\xD8\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB4"],
        ["\xE6\x82\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xAC"],

        ["\xD8\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF\xB0"],
        ["\xE5\xBF\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xAD"],

        ["\xD8\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xBD"],
        ["\xE6\x82\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xAE"],

        ["\xD8\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x86"],
        ["\xE6\x83\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xAF"],

        ["\xD8\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x82\xB5"],
        ["\xE6\x82\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB0"],

        ["\xD8\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\x98"],
        ["\xE6\x83\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB1"],

        ["\xD8\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8D"],
        ["\xE6\x85\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB2"],

        ["\xD8\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x95"],
        ["\xE6\x84\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB3"],

        ["\xD8\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x86"],
        ["\xE6\x84\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB4"],

        ["\xD8\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB6"],
        ["\xE6\x83\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB5"],

        ["\xD8\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB7"],
        ["\xE6\x83\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB6"],

        ["\xD8\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x80"],
        ["\xE6\x84\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB7"],

        ["\xD8\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB4"],
        ["\xE6\x83\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB8"],

        ["\xD8\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xBA"],
        ["\xE6\x83\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xB9"],

        ["\xD8\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x83"],
        ["\xE6\x84\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xBA"],

        ["\xD8\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA1"],
        ["\xE6\x84\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xBB"],

        ["\xD8\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xBB"],
        ["\xE6\x83\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xBC"],

        ["\xD8\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x83\xB1"],
        ["\xE6\x83\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xBD"],

        ["\xD8\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8D"],
        ["\xE6\x84\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xBE"],

        ["\xD8\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\x8E"],
        ["\xE6\x84\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xBF"],

        ["\xD8\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x87"],
        ["\xE6\x85\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC0"],

        ["\xD8\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBE"],
        ["\xE6\x84\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC1"],

        ["\xD8\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA8"],
        ["\xE6\x84\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC2"],

        ["\xD8\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xA7"],
        ["\xE6\x84\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC3"],

        ["\xD8\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x8A"],
        ["\xE6\x85\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC4"],

        ["\xD8\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBF"],
        ["\xE6\x84\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC5"],

        ["\xD8\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBC"],
        ["\xE6\x84\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC6"],

        ["\xD8\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xAC"],
        ["\xE6\x84\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC7"],

        ["\xD8\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xB4"],
        ["\xE6\x84\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC8"],

        ["\xD8\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x84\xBD"],
        ["\xE6\x84\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xC9"],

        ["\xD8\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x82"],
        ["\xE6\x85\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xCA"],

        ["\xD8\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x84"],
        ["\xE6\x85\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xCB"],

        ["\xD8\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB3"],
        ["\xE6\x85\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xCC"],

        ["\xD8\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB7"],
        ["\xE6\x85\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xCD"],

        ["\xD8\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x98"],
        ["\xE6\x85\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xCE"],

        ["\xD8\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x99"],
        ["\xE6\x85\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xCF"],

        ["\xD8\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9A"],
        ["\xE6\x85\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD0"],

        ["\xD8\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAB"],
        ["\xE6\x85\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD1"],

        ["\xD8\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB4"],
        ["\xE6\x85\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD2"],

        ["\xD8\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xAF"],
        ["\xE6\x85\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD3"],

        ["\xD8\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xA5"],
        ["\xE6\x85\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD4"],

        ["\xD8\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB1"],
        ["\xE6\x85\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD5"],

        ["\xD8\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9F"],
        ["\xE6\x85\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD6"],

        ["\xD8\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x9D"],
        ["\xE6\x85\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD7"],

        ["\xD8\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\x93"],
        ["\xE6\x85\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD8"],

        ["\xD8\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x85\xB5"],
        ["\xE6\x85\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xD9"],

        ["\xD8\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x99"],
        ["\xE6\x86\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xDA"],

        ["\xD8\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x96"],
        ["\xE6\x86\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xDB"],

        ["\xD8\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x87"],
        ["\xE6\x86\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xDC"],

        ["\xD8\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAC"],
        ["\xE6\x86\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xDD"],

        ["\xD8\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x94"],
        ["\xE6\x86\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xDE"],

        ["\xD8\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x9A"],
        ["\xE6\x86\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xDF"],

        ["\xD8\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x8A"],
        ["\xE6\x86\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE0"],

        ["\xD8\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\x91"],
        ["\xE6\x86\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE1"],

        ["\xD8\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAB"],
        ["\xE6\x86\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE2"],

        ["\xD8\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xAE"],
        ["\xE6\x86\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE3"],

        ["\xD8\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8C"],
        ["\xE6\x87\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE4"],

        ["\xD8\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8A"],
        ["\xE6\x87\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE5"],

        ["\xD8\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x89"],
        ["\xE6\x87\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE6"],

        ["\xD8\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB7"],
        ["\xE6\x87\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE7"],

        ["\xD8\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x88"],
        ["\xE6\x87\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE8"],

        ["\xD8\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x83"],
        ["\xE6\x87\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xE9"],

        ["\xD8\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x86"],
        ["\xE6\x87\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xEA"],

        ["\xD8\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x86\xBA"],
        ["\xE6\x86\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xEB"],

        ["\xD8\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8B"],
        ["\xE6\x87\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xEC"],

        ["\xD8\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB9"],
        ["\xE7\xBD\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xED"],

        ["\xD8\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\x8D"],
        ["\xE6\x87\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xEE"],

        ["\xD8\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xA6"],
        ["\xE6\x87\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xEF"],

        ["\xD8\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xA3"],
        ["\xE6\x87\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF0"],

        ["\xD8\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB6"],
        ["\xE6\x87\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF1"],

        ["\xD8\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBA"],
        ["\xE6\x87\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF2"],

        ["\xD8\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xB4"],
        ["\xE6\x87\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF3"],

        ["\xD8\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBF"],
        ["\xE6\x87\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF4"],

        ["\xD8\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBD"],
        ["\xE6\x87\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF5"],

        ["\xD8\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBC"],
        ["\xE6\x87\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF6"],

        ["\xD8\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x87\xBE"],
        ["\xE6\x87\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF7"],

        ["\xD8\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x80"],
        ["\xE6\x88\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF8"],

        ["\xD8\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x88"],
        ["\xE6\x88\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xF9"],

        ["\xD8\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x89"],
        ["\xE6\x88\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xFA"],

        ["\xD8\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8D"],
        ["\xE6\x88\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xFB"],

        ["\xD8\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x8C"],
        ["\xE6\x88\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xFC"],

        ["\xD8\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x94"],
        ["\xE6\x88\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xFD"],

        ["\xD8\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9B"],
        ["\xE6\x88\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD8\xFE"],

        ["\xD9\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9E"],
        ["\xE6\x88\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xA1"],

        ["\xD9\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xA1"],
        ["\xE6\x88\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xA2"],

        ["\xD9\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAA"],
        ["\xE6\x88\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xA3"],

        ["\xD9\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xAE"],
        ["\xE6\x88\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xA4"],

        ["\xD9\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB0"],
        ["\xE6\x88\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xA5"],

        ["\xD9\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB2"],
        ["\xE6\x88\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xA6"],

        ["\xD9\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\xB3"],
        ["\xE6\x88\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xA7"],

        ["\xD9\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x81"],
        ["\xE6\x89\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xA8"],

        ["\xD9\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x8E"],
        ["\xE6\x89\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xA9"],

        ["\xD9\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x9E"],
        ["\xE6\x89\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xAA"],

        ["\xD9\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA3"],
        ["\xE6\x89\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xAB"],

        ["\xD9\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x9B"],
        ["\xE6\x89\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xAC"],

        ["\xD9\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA0"],
        ["\xE6\x89\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xAD"],

        ["\xD9\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xA8"],
        ["\xE6\x89\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xAE"],

        ["\xD9\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBC"],
        ["\xE6\x89\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xAF"],

        ["\xD9\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x82"],
        ["\xE6\x8A\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB0"],

        ["\xD9\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x89"],
        ["\xE6\x8A\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB1"],

        ["\xD9\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\xBE"],
        ["\xE6\x89\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB2"],

        ["\xD9\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x92"],
        ["\xE6\x8A\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB3"],

        ["\xD9\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x93"],
        ["\xE6\x8A\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB4"],

        ["\xD9\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x96"],
        ["\xE6\x8A\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB5"],

        ["\xD9\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x94"],
        ["\xE6\x8B\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB6"],

        ["\xD9\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x83"],
        ["\xE6\x8A\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB7"],

        ["\xD9\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x94"],
        ["\xE6\x8A\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB8"],

        ["\xD9\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x97"],
        ["\xE6\x8B\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xB9"],

        ["\xD9\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x91"],
        ["\xE6\x8B\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xBA"],

        ["\xD9\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xBB"],
        ["\xE6\x8A\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xBB"],

        ["\xD9\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8F"],
        ["\xE6\x8B\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xBC"],

        ["\xD9\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xBF"],
        ["\xE6\x8B\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xBD"],

        ["\xD9\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x86"],
        ["\xE6\x8B\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xBE"],

        ["\xD9\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x94"],
        ["\xE6\x93\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xBF"],

        ["\xD9\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x88"],
        ["\xE6\x8B\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC0"],

        ["\xD9\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x9C"],
        ["\xE6\x8B\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC1"],

        ["\xD9\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8C"],
        ["\xE6\x8B\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC2"],

        ["\xD9\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x8A"],
        ["\xE6\x8B\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC3"],

        ["\xD9\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x82"],
        ["\xE6\x8B\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC4"],

        ["\xD9\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x87"],
        ["\xE6\x8B\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC5"],

        ["\xD9\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\x9B"],
        ["\xE6\x8A\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC6"],

        ["\xD9\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\x89"],
        ["\xE6\x8B\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC7"],

        ["\xD9\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x8C"],
        ["\xE6\x8C\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC8"],

        ["\xD9\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAE"],
        ["\xE6\x8B\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xC9"],

        ["\xD9\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB1"],
        ["\xE6\x8B\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xCA"],

        ["\xD9\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xA7"],
        ["\xE6\x8C\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xCB"],

        ["\xD9\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x82"],
        ["\xE6\x8C\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xCC"],

        ["\xD9\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\x88"],
        ["\xE6\x8C\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xCD"],

        ["\xD9\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xAF"],
        ["\xE6\x8B\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xCE"],

        ["\xD9\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8B\xB5"],
        ["\xE6\x8B\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xCF"],

        ["\xD9\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x90"],
        ["\xE6\x8D\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD0"],

        ["\xD9\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8C\xBE"],
        ["\xE6\x8C\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD1"],

        ["\xD9\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8D"],
        ["\xE6\x8D\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD2"],

        ["\xD9\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x9C"],
        ["\xE6\x90\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD3"],

        ["\xD9\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\x8F"],
        ["\xE6\x8D\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD4"],

        ["\xD9\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x96"],
        ["\xE6\x8E\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD5"],

        ["\xD9\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8E"],
        ["\xE6\x8E\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD6"],

        ["\xD9\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x80"],
        ["\xE6\x8E\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD7"],

        ["\xD9\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xAB"],
        ["\xE6\x8E\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD8"],

        ["\xD9\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xB6"],
        ["\xE6\x8D\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xD9"],

        ["\xD9\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xA3"],
        ["\xE6\x8E\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xDA"],

        ["\xD9\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x8F"],
        ["\xE6\x8E\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xDB"],

        ["\xD9\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x89"],
        ["\xE6\x8E\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xDC"],

        ["\xD9\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\x9F"],
        ["\xE6\x8E\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xDD"],

        ["\xD9\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xB5"],
        ["\xE6\x8E\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xDE"],

        ["\xD9\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xAB"],
        ["\xE6\x8D\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xDF"],

        ["\xD9\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8D\xA9"],
        ["\xE6\x8D\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE0"],

        ["\xD9\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8E\xBE"],
        ["\xE6\x8E\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE1"],

        ["\xD9\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA9"],
        ["\xE6\x8F\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE2"],

        ["\xD9\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x80"],
        ["\xE6\x8F\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE3"],

        ["\xD9\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x86"],
        ["\xE6\x8F\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE4"],

        ["\xD9\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xA3"],
        ["\xE6\x8F\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE5"],

        ["\xD9\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x89"],
        ["\xE6\x8F\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE6"],

        ["\xD9\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x92"],
        ["\xE6\x8F\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE7"],

        ["\xD9\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\xB6"],
        ["\xE6\x8F\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE8"],

        ["\xD9\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8F\x84"],
        ["\xE6\x8F\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xE9"],

        ["\xD9\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x96"],
        ["\xE6\x90\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xEA"],

        ["\xD9\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xB4"],
        ["\xE6\x90\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xEB"],

        ["\xD9\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x86"],
        ["\xE6\x90\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xEC"],

        ["\xD9\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x93"],
        ["\xE6\x90\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xED"],

        ["\xD9\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA6"],
        ["\xE6\x90\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xEE"],

        ["\xD9\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xB6"],
        ["\xE6\x90\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xEF"],

        ["\xD9\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x9D"],
        ["\xE6\x94\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF0"],

        ["\xD9\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x97"],
        ["\xE6\x90\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF1"],

        ["\xD9\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\xA8"],
        ["\xE6\x90\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF2"],

        ["\xD9\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x90\x8F"],
        ["\xE6\x90\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF3"],

        ["\xD9\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xA7"],
        ["\xE6\x91\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF4"],

        ["\xD9\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xAF"],
        ["\xE6\x91\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF5"],

        ["\xD9\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\xB6"],
        ["\xE6\x91\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF6"],

        ["\xD9\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x91\x8E"],
        ["\xE6\x91\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF7"],

        ["\xB3\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAA"],
        ["\xE6\x94\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC9"],

        ["\xD9\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x95"],
        ["\xE6\x92\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xF9"],

        ["\xD9\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x93"],
        ["\xE6\x92\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xFA"],

        ["\xD9\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA5"],
        ["\xE6\x92\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xFB"],

        ["\xD9\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xA9"],
        ["\xE6\x92\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xFC"],

        ["\xD9\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\x88"],
        ["\xE6\x92\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xFD"],

        ["\xD9\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBC"],
        ["\xE6\x92\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xD9\xFE"],

        ["\xDA\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x9A"],
        ["\xE6\x93\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xA1"],

        ["\xDA\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x92"],
        ["\xE6\x93\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xA2"],

        ["\xDA\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x85"],
        ["\xE6\x93\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xA3"],

        ["\xDA\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x87"],
        ["\xE6\x93\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xA4"],

        ["\xDA\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x92\xBB"],
        ["\xE6\x92\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xA5"],

        ["\xDA\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x98"],
        ["\xE6\x93\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xA6"],

        ["\xDA\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\x82"],
        ["\xE6\x93\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xA7"],

        ["\xDA\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB1"],
        ["\xE6\x93\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xA8"],

        ["\xDA\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA7"],
        ["\xE6\x93\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xA9"],

        ["\xDA\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x89"],
        ["\xE8\x88\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xAA"],

        ["\xDA\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA0"],
        ["\xE6\x93\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xAB"],

        ["\xDA\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA1"],
        ["\xE6\x93\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xAC"],

        ["\xDA\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x8A\xAC"],
        ["\xE6\x8A\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xAD"],

        ["\xDA\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xA3"],
        ["\xE6\x93\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xAE"],

        ["\xDA\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xAF"],
        ["\xE6\x93\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xAF"],

        ["\xDA\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAC"],
        ["\xE6\x94\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB0"],

        ["\xDA\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB6"],
        ["\xE6\x93\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB1"],

        ["\xDA\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB4"],
        ["\xE6\x93\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB2"],

        ["\xDA\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xB2"],
        ["\xE6\x93\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB3"],

        ["\xDA\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBA"],
        ["\xE6\x93\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB4"],

        ["\xDA\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x80"],
        ["\xE6\x94\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB5"],

        ["\xDA\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x93\xBD"],
        ["\xE6\x93\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB6"],

        ["\xDA\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x98"],
        ["\xE6\x94\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB7"],

        ["\xDA\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x9C"],
        ["\xE6\x94\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB8"],

        ["\xDA\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\x85"],
        ["\xE6\x94\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xB9"],

        ["\xDA\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA4"],
        ["\xE6\x94\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xBA"],

        ["\xDA\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xA3"],
        ["\xE6\x94\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xBB"],

        ["\xDA\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xAB"],
        ["\xE6\x94\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xBC"],

        ["\xDA\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB4"],
        ["\xE6\x94\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xBD"],

        ["\xDA\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB5"],
        ["\xE6\x94\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xBE"],

        ["\xDA\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB7"],
        ["\xE6\x94\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xBF"],

        ["\xDA\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB6"],
        ["\xE6\x94\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC0"],

        ["\xDA\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x94\xB8"],
        ["\xE6\x94\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC1"],

        ["\xDA\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8B"],
        ["\xE7\x95\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC2"],

        ["\xDA\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x88"],
        ["\xE6\x95\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC3"],

        ["\xDA\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x96"],
        ["\xE6\x95\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC4"],

        ["\xDA\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x95"],
        ["\xE6\x95\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC5"],

        ["\xDA\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x8D"],
        ["\xE6\x95\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC6"],

        ["\xDA\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x98"],
        ["\xE6\x95\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC7"],

        ["\xDA\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x9E"],
        ["\xE6\x95\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC8"],

        ["\xDA\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\x9D"],
        ["\xE6\x95\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xC9"],

        ["\xDA\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB2"],
        ["\xE6\x95\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xCA"],

        ["\xDA\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x95\xB8"],
        ["\xE6\x95\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xCB"],

        ["\xDA\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x82"],
        ["\xE6\x96\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xCC"],

        ["\xDA\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x83"],
        ["\xE6\x96\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xCD"],

        ["\xDA\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8A"],
        ["\xE8\xAE\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xCE"],

        ["\xDA\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9B"],
        ["\xE6\x96\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xCF"],

        ["\xDA\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\x9F"],
        ["\xE6\x96\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD0"],

        ["\xDA\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xAB"],
        ["\xE6\x96\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD1"],

        ["\xDA\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x96\xB7"],
        ["\xE6\x96\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD2"],

        ["\xDA\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x83"],
        ["\xE6\x97\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD3"],

        ["\xDA\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x86"],
        ["\xE6\x97\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD4"],

        ["\xDA\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x81"],
        ["\xE6\x97\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD5"],

        ["\xDA\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x84"],
        ["\xE6\x97\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD6"],

        ["\xDA\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x8C"],
        ["\xE6\x97\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD7"],

        ["\xDA\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x92"],
        ["\xE6\x97\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD8"],

        ["\xDA\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x9B"],
        ["\xE6\x97\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xD9"],

        ["\xDA\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\x99"],
        ["\xE6\x97\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xDA"],

        ["\xDA\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA0"],
        ["\xE6\x97\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xDB"],

        ["\xDA\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xA1"],
        ["\xE6\x97\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xDC"],

        ["\xDA\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xB1"],
        ["\xE6\x97\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xDD"],

        ["\xDA\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB2"],
        ["\xE6\x9D\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xDE"],

        ["\xDA\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x8A"],
        ["\xE6\x98\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xDF"],

        ["\xDA\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x83"],
        ["\xE6\x98\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE0"],

        ["\xDA\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x97\xBB"],
        ["\xE6\x97\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE1"],

        ["\xDA\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB3"],
        ["\xE6\x9D\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE2"],

        ["\xDA\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB5"],
        ["\xE6\x98\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE3"],

        ["\xDA\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB6"],
        ["\xE6\x98\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE4"],

        ["\xDA\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xB4"],
        ["\xE6\x98\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE5"],

        ["\xDA\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\x9C"],
        ["\xE6\x98\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE6"],

        ["\xDA\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x8F"],
        ["\xE6\x99\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE7"],

        ["\xDA\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x84"],
        ["\xE6\x99\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE8"],

        ["\xDA\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x89"],
        ["\xE6\x99\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xE9"],

        ["\xDA\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x81"],
        ["\xE6\x99\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xEA"],

        ["\xDA\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9E"],
        ["\xE6\x99\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xEB"],

        ["\xDA\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9D"],
        ["\xE6\x99\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xEC"],

        ["\xDA\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA4"],
        ["\xE6\x99\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xED"],

        ["\xDA\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA7"],
        ["\xE6\x99\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xEE"],

        ["\xDA\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA8"],
        ["\xE6\x99\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xEF"],

        ["\xDA\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\x9F"],
        ["\xE6\x99\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF0"],

        ["\xDA\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xA2"],
        ["\xE6\x99\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF1"],

        ["\xDA\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x99\xB0"],
        ["\xE6\x99\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF2"],

        ["\xDA\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x83"],
        ["\xE6\x9A\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF3"],

        ["\xDA\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x88"],
        ["\xE6\x9A\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF4"],

        ["\xDA\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x8E"],
        ["\xE6\x9A\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF5"],

        ["\xDA\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x89"],
        ["\xE6\x9A\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF6"],

        ["\xDA\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x84"],
        ["\xE6\x9A\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF7"],

        ["\xDA\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x98"],
        ["\xE6\x9A\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF8"],

        ["\xDA\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\x9D"],
        ["\xE6\x9A\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xF9"],

        ["\xDA\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x81"],
        ["\xE6\x9B\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xFA"],

        ["\xDA\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB9"],
        ["\xE6\x9A\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xFB"],

        ["\xDA\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x89"],
        ["\xE6\x9B\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xFC"],

        ["\xDA\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBE"],
        ["\xE6\x9A\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xFD"],

        ["\xDA\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xBC"],
        ["\xE6\x9A\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDA\xFE"],

        ["\xDB\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x84"],
        ["\xE6\x9B\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xA1"],

        ["\xDB\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9A\xB8"],
        ["\xE6\x9A\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xA2"],

        ["\xDB\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x96"],
        ["\xE6\x9B\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xA3"],

        ["\xDB\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\x9A"],
        ["\xE6\x9B\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xA4"],

        ["\xDB\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA0"],
        ["\xE6\x9B\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xA5"],

        ["\xDB\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x98\xBF"],
        ["\xE6\x98\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xA6"],

        ["\xDB\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA6"],
        ["\xE6\x9B\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xA7"],

        ["\xDB\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xA9"],
        ["\xE6\x9B\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xA8"],

        ["\xDB\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB0"],
        ["\xE6\x9B\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xA9"],

        ["\xDB\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB5"],
        ["\xE6\x9B\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xAA"],

        ["\xDB\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9B\xB7"],
        ["\xE6\x9B\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xAB"],

        ["\xDB\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x8F"],
        ["\xE6\x9C\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xAC"],

        ["\xDB\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x96"],
        ["\xE6\x9C\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xAD"],

        ["\xDB\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\x9E"],
        ["\xE6\x9C\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xAE"],

        ["\xDB\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA6"],
        ["\xE6\x9C\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xAF"],

        ["\xDB\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xA7"],
        ["\xE6\x9C\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB0"],

        ["\xDB\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB8"],
        ["\xE9\x9C\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB1"],

        ["\xDB\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xAE"],
        ["\xE6\x9C\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB2"],

        ["\xDB\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xBF"],
        ["\xE6\x9C\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB3"],

        ["\xDB\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB6"],
        ["\xE6\x9C\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB4"],

        ["\xDB\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x81"],
        ["\xE6\x9D\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB5"],

        ["\xDB\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB8"],
        ["\xE6\x9C\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB6"],

        ["\xDB\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9C\xB7"],
        ["\xE6\x9C\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB7"],

        ["\xDB\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x86"],
        ["\xE6\x9D\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB8"],

        ["\xDB\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x9E"],
        ["\xE6\x9D\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xB9"],

        ["\xDB\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA0"],
        ["\xE6\x9D\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xBA"],

        ["\xDB\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\x99"],
        ["\xE6\x9D\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xBB"],

        ["\xDB\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA3"],
        ["\xE6\x9D\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xBC"],

        ["\xDB\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xA4"],
        ["\xE6\x9D\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xBD"],

        ["\xDB\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x89"],
        ["\xE6\x9E\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xBE"],

        ["\xDB\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xB0"],
        ["\xE6\x9D\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xBF"],

        ["\xDB\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA9"],
        ["\xE6\x9E\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC0"],

        ["\xDB\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xBC"],
        ["\xE6\x9D\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC1"],

        ["\xDB\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9D\xAA"],
        ["\xE6\x9D\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC2"],

        ["\xDB\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x8C"],
        ["\xE6\x9E\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC3"],

        ["\xDB\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x8B"],
        ["\xE6\x9E\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC4"],

        ["\xDB\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA6"],
        ["\xE6\x9E\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC5"],

        ["\xDB\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xA1"],
        ["\xE6\x9E\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC6"],

        ["\xDB\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\x85"],
        ["\xE6\x9E\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC7"],

        ["\xDB\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB7"],
        ["\xE6\x9E\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC8"],

        ["\xDB\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAF"],
        ["\xE6\x9F\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xC9"],

        ["\xDB\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB4"],
        ["\xE6\x9E\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xCA"],

        ["\xDB\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAC"],
        ["\xE6\x9F\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xCB"],

        ["\xDB\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB3"],
        ["\xE6\x9E\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xCC"],

        ["\xDB\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA9"],
        ["\xE6\x9F\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xCD"],

        ["\xDB\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB8"],
        ["\xE6\x9E\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xCE"],

        ["\xDB\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA4"],
        ["\xE6\x9F\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xCF"],

        ["\xDB\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9E"],
        ["\xE6\x9F\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD0"],

        ["\xDB\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x9D"],
        ["\xE6\x9F\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD1"],

        ["\xDB\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA2"],
        ["\xE6\x9F\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD2"],

        ["\xDB\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xAE"],
        ["\xE6\x9F\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD3"],

        ["\xDB\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9E\xB9"],
        ["\xE6\x9E\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD4"],

        ["\xDB\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x8E"],
        ["\xE6\x9F\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD5"],

        ["\xDB\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\x86"],
        ["\xE6\x9F\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD6"],

        ["\xDB\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x9F\xA7"],
        ["\xE6\x9F\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD7"],

        ["\xC9\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x9C"],
        ["\xE6\xAA\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC9\xB0"],

        ["\xDB\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\x9E"],
        ["\xE6\xA0\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xD9"],

        ["\xDB\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x86"],
        ["\xE6\xA1\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xDA"],

        ["\xDB\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xA9"],
        ["\xE6\xA0\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xDB"],

        ["\xDB\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x80"],
        ["\xE6\xA1\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xDC"],

        ["\xDB\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x8D"],
        ["\xE6\xA1\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xDD"],

        ["\xDB\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xB2"],
        ["\xE6\xA0\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xDE"],

        ["\xDB\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x8E"],
        ["\xE6\xA1\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xDF"],

        ["\xDB\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB3"],
        ["\xE6\xA2\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE0"],

        ["\xDB\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA0\xAB"],
        ["\xE6\xA0\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE1"],

        ["\xDB\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\x99"],
        ["\xE6\xA1\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE2"],

        ["\xDB\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xA3"],
        ["\xE6\xA1\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE3"],

        ["\xDB\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB7"],
        ["\xE6\xA1\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE4"],

        ["\xDB\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBF"],
        ["\xE6\xA1\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE5"],

        ["\xDB\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9F"],
        ["\xE6\xA2\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE6"],

        ["\xDB\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x8F"],
        ["\xE6\xA2\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE7"],

        ["\xDB\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xAD"],
        ["\xE6\xA2\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE8"],

        ["\xDB\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x94"],
        ["\xE6\xA2\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xE9"],

        ["\xDB\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9D"],
        ["\xE6\xA2\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xEA"],

        ["\xDB\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x9B"],
        ["\xE6\xA2\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xEB"],

        ["\xDB\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x83"],
        ["\xE6\xA2\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xEC"],

        ["\xC5\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAE"],
        ["\xE6\xAA\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xEE"],

        ["\xDB\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB9"],
        ["\xE6\xA2\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xEE"],

        ["\xDB\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xB4"],
        ["\xE6\xA1\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xEF"],

        ["\xDB\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xB5"],
        ["\xE6\xA2\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF0"],

        ["\xDB\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xA0"],
        ["\xE6\xA2\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF1"],

        ["\xDB\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\xBA"],
        ["\xE6\xA2\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF2"],

        ["\xDB\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8F"],
        ["\xE6\xA4\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF3"],

        ["\xDB\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2\x8D"],
        ["\xE6\xA2\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF4"],

        ["\xDB\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1\xBE"],
        ["\xE6\xA1\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF5"],

        ["\xDB\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x81"],
        ["\xE6\xA4\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF6"],

        ["\xDB\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8A"],
        ["\xE6\xA3\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF7"],

        ["\xDB\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x88"],
        ["\xE6\xA4\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF8"],

        ["\xDB\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x98"],
        ["\xE6\xA3\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xF9"],

        ["\xDB\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA2"],
        ["\xE6\xA4\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xFA"],

        ["\xDB\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA6"],
        ["\xE6\xA4\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xFB"],

        ["\xDB\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA1"],
        ["\xE6\xA3\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xFC"],

        ["\xDB\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x8C"],
        ["\xE6\xA4\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xFD"],

        ["\xDB\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x8D"],
        ["\xE6\xA3\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDB\xFE"],

        ["\xDC\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x94"],
        ["\xE6\xA3\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xA1"],

        ["\xDC\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA7"],
        ["\xE6\xA3\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xA2"],

        ["\xDC\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x95"],
        ["\xE6\xA3\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xA3"],

        ["\xDC\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB6"],
        ["\xE6\xA4\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xA4"],

        ["\xDC\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x92"],
        ["\xE6\xA4\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xA5"],

        ["\xDC\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x84"],
        ["\xE6\xA4\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xA6"],

        ["\xDC\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x97"],
        ["\xE6\xA3\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xA7"],

        ["\xDC\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA3"],
        ["\xE6\xA3\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xA8"],

        ["\xDC\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA5"],
        ["\xE6\xA4\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xA9"],

        ["\xDC\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xB9"],
        ["\xE6\xA3\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xAA"],

        ["\xDC\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xA0"],
        ["\xE6\xA3\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xAB"],

        ["\xDC\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\xAF"],
        ["\xE6\xA3\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xAC"],

        ["\xDC\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA8"],
        ["\xE6\xA4\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xAD"],

        ["\xDC\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xAA"],
        ["\xE6\xA4\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xAE"],

        ["\xDC\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\x9A"],
        ["\xE6\xA4\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xAF"],

        ["\xDC\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA3"],
        ["\xE6\xA4\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB0"],

        ["\xDC\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xA1"],
        ["\xE6\xA4\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB1"],

        ["\xDC\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3\x86"],
        ["\xE6\xA3\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB2"],

        ["\xDC\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB9"],
        ["\xE6\xA5\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB3"],

        ["\xDC\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB7"],
        ["\xE6\xA5\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB4"],

        ["\xDC\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9C"],
        ["\xE6\xA5\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB5"],

        ["\xDC\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB8"],
        ["\xE6\xA5\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB6"],

        ["\xDC\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAB"],
        ["\xE6\xA5\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB7"],

        ["\xDC\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x94"],
        ["\xE6\xA5\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB8"],

        ["\xDC\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xBE"],
        ["\xE6\xA5\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xB9"],

        ["\xDC\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAE"],
        ["\xE6\xA5\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xBA"],

        ["\xDC\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB9"],
        ["\xE6\xA4\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xBB"],

        ["\xDC\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xB4"],
        ["\xE6\xA5\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xBC"],

        ["\xDC\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xBD"],
        ["\xE6\xA4\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xBD"],

        ["\xDC\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x99"],
        ["\xE6\xA5\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xBE"],

        ["\xDC\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4\xB0"],
        ["\xE6\xA4\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xBF"],

        ["\xDC\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xA1"],
        ["\xE6\xA5\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC0"],

        ["\xDC\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9E"],
        ["\xE6\xA5\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC1"],

        ["\xDC\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\x9D"],
        ["\xE6\xA5\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC2"],

        ["\xDC\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x81"],
        ["\xE6\xA6\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC3"],

        ["\xDC\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5\xAA"],
        ["\xE6\xA5\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC4"],

        ["\xDC\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB2"],
        ["\xE6\xA6\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC5"],

        ["\xDC\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xAE"],
        ["\xE6\xA6\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC6"],

        ["\xDC\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x90"],
        ["\xE6\xA7\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC7"],

        ["\xDC\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBF"],
        ["\xE6\xA6\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC8"],

        ["\xDC\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x81"],
        ["\xE6\xA7\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xC9"],

        ["\xDC\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x93"],
        ["\xE6\xA7\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xCA"],

        ["\xDC\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBE"],
        ["\xE6\xA6\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xCB"],

        ["\xDC\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8E"],
        ["\xE6\xA7\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xCC"],

        ["\xDC\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF\xA8"],
        ["\xE5\xAF\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xCD"],

        ["\xDC\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x8A"],
        ["\xE6\xA7\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xCE"],

        ["\xDC\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x9D"],
        ["\xE6\xA7\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xCF"],

        ["\xDC\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xBB"],
        ["\xE6\xA6\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD0"],

        ["\xDC\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x83"],
        ["\xE6\xA7\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD1"],

        ["\xDC\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xA7"],
        ["\xE6\xA6\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD2"],

        ["\xDC\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xAE"],
        ["\xE6\xA8\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD3"],

        ["\xDC\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x91"],
        ["\xE6\xA6\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD4"],

        ["\xDC\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xA0"],
        ["\xE6\xA6\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD5"],

        ["\xDC\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x9C"],
        ["\xE6\xA6\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD6"],

        ["\xDC\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\x95"],
        ["\xE6\xA6\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD7"],

        ["\xDC\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB4"],
        ["\xE6\xA6\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD8"],

        ["\xDC\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\x9E"],
        ["\xE6\xA7\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xD9"],

        ["\xDC\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA8"],
        ["\xE6\xA7\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xDA"],

        ["\xDC\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x82"],
        ["\xE6\xA8\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xDB"],

        ["\xDC\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9B"],
        ["\xE6\xA8\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xDC"],

        ["\xDC\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xBF"],
        ["\xE6\xA7\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xDD"],

        ["\xDC\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x8A"],
        ["\xE6\xAC\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xDE"],

        ["\xDC\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB9"],
        ["\xE6\xA7\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xDF"],

        ["\xDC\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xB2"],
        ["\xE6\xA7\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE0"],

        ["\xDC\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xA7"],
        ["\xE6\xA7\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE1"],

        ["\xDC\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x85"],
        ["\xE6\xA8\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE2"],

        ["\xDC\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6\xB1"],
        ["\xE6\xA6\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE3"],

        ["\xDC\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x9E"],
        ["\xE6\xA8\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE4"],

        ["\xDC\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAD"],
        ["\xE6\xA7\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE5"],

        ["\xDC\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x94"],
        ["\xE6\xA8\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE6"],

        ["\xDC\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7\xAB"],
        ["\xE6\xA7\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE7"],

        ["\xDC\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8A"],
        ["\xE6\xA8\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE8"],

        ["\xDC\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x92"],
        ["\xE6\xA8\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xE9"],

        ["\xDC\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x81"],
        ["\xE6\xAB\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xEA"],

        ["\xDC\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA3"],
        ["\xE6\xA8\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xEB"],

        ["\xDC\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x93"],
        ["\xE6\xA8\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xEC"],

        ["\xDC\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x84"],
        ["\xE6\xA9\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xED"],

        ["\xDC\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\x8C"],
        ["\xE6\xA8\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xEE"],

        ["\xDC\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xB2"],
        ["\xE6\xA9\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xEF"],

        ["\xDC\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB6"],
        ["\xE6\xA8\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF0"],

        ["\xDC\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xB8"],
        ["\xE6\xA9\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF1"],

        ["\xDC\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x87"],
        ["\xE6\xA9\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF2"],

        ["\xDC\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA2"],
        ["\xE6\xA9\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF3"],

        ["\xDC\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x99"],
        ["\xE6\xA9\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF4"],

        ["\xDC\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\xA6"],
        ["\xE6\xA9\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF5"],

        ["\xDC\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9\x88"],
        ["\xE6\xA9\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF6"],

        ["\xDC\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xB8"],
        ["\xE6\xA8\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF7"],

        ["\xDC\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8\xA2"],
        ["\xE6\xA8\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF8"],

        ["\xDC\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x90"],
        ["\xE6\xAA\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xF9"],

        ["\xDC\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x8D"],
        ["\xE6\xAA\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xFA"],

        ["\xDC\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA0"],
        ["\xE6\xAA\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xFB"],

        ["\xDC\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x84"],
        ["\xE6\xAA\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xFC"],

        ["\xDC\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA2"],
        ["\xE6\xAA\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xFD"],

        ["\xDC\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xA3"],
        ["\xE6\xAA\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDC\xFE"],

        ["\xDD\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\x97"],
        ["\xE6\xAA\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xA1"],

        ["\xDD\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x97"],
        ["\xE8\x98\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xA2"],

        ["\xDD\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xBB"],
        ["\xE6\xAA\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xA3"],

        ["\xDD\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x83"],
        ["\xE6\xAB\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xA4"],

        ["\xDD\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x82"],
        ["\xE6\xAB\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xA5"],

        ["\xDD\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xB8"],
        ["\xE6\xAA\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xA6"],

        ["\xDD\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xB3"],
        ["\xE6\xAA\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xA7"],

        ["\xDD\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAC"],
        ["\xE6\xAA\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xA8"],

        ["\xDD\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9E"],
        ["\xE6\xAB\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xA9"],

        ["\xDD\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x91"],
        ["\xE6\xAB\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xAA"],

        ["\xDD\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9F"],
        ["\xE6\xAB\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xAB"],

        ["\xDD\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA\xAA"],
        ["\xE6\xAA\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xAC"],

        ["\xDD\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\x9A"],
        ["\xE6\xAB\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xAD"],

        ["\xDD\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xAA"],
        ["\xE6\xAB\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xAE"],

        ["\xDD\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xBB"],
        ["\xE6\xAB\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xAF"],

        ["\xDD\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x85"],
        ["\xE6\xAC\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB0"],

        ["\xDD\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x96"],
        ["\xE8\x98\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB1"],

        ["\xDD\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB\xBA"],
        ["\xE6\xAB\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB2"],

        ["\xDD\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x92"],
        ["\xE6\xAC\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB3"],

        ["\xDD\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x96"],
        ["\xE6\xAC\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB4"],

        ["\xDD\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xB1"],
        ["\xE9\xAC\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB5"],

        ["\xDD\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\x9F"],
        ["\xE6\xAC\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB6"],

        ["\xDD\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB8"],
        ["\xE6\xAC\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB7"],

        ["\xDD\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB7"],
        ["\xE6\xAC\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB8"],

        ["\xDD\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9C"],
        ["\xE7\x9B\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xB9"],

        ["\xDD\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC\xB9"],
        ["\xE6\xAC\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xBA"],

        ["\xDD\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAE"],
        ["\xE9\xA3\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xBB"],

        ["\xDD\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x87"],
        ["\xE6\xAD\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xBC"],

        ["\xDD\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x83"],
        ["\xE6\xAD\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xBD"],

        ["\xDD\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x89"],
        ["\xE6\xAD\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xBE"],

        ["\xDD\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x90"],
        ["\xE6\xAD\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xBF"],

        ["\xDD\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x99"],
        ["\xE6\xAD\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC0"],

        ["\xDD\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x94"],
        ["\xE6\xAD\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC1"],

        ["\xDD\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x9B"],
        ["\xE6\xAD\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC2"],

        ["\xDD\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\x9F"],
        ["\xE6\xAD\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC3"],

        ["\xDD\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xA1"],
        ["\xE6\xAD\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC4"],

        ["\xDD\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB8"],
        ["\xE6\xAD\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC5"],

        ["\xDD\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xB9"],
        ["\xE6\xAD\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC6"],

        ["\xDD\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD\xBF"],
        ["\xE6\xAD\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC7"],

        ["\xDD\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x80"],
        ["\xE6\xAE\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC8"],

        ["\xDD\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x84"],
        ["\xE6\xAE\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xC9"],

        ["\xDD\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x83"],
        ["\xE6\xAE\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xCA"],

        ["\xDD\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x8D"],
        ["\xE6\xAE\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xCB"],

        ["\xDD\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x98"],
        ["\xE6\xAE\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xCC"],

        ["\xDD\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x95"],
        ["\xE6\xAE\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xCD"],

        ["\xDD\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\x9E"],
        ["\xE6\xAE\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xCE"],

        ["\xDD\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xA4"],
        ["\xE6\xAE\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xCF"],

        ["\xDD\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAA"],
        ["\xE6\xAE\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD0"],

        ["\xDD\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAB"],
        ["\xE6\xAE\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD1"],

        ["\xDD\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xAF"],
        ["\xE6\xAE\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD2"],

        ["\xDD\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB2"],
        ["\xE6\xAE\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD3"],

        ["\xDD\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB1"],
        ["\xE6\xAE\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD4"],

        ["\xDD\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB3"],
        ["\xE6\xAE\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD5"],

        ["\xDD\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xB7"],
        ["\xE6\xAE\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD6"],

        ["\xDD\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE\xBC"],
        ["\xE6\xAE\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD7"],

        ["\xDD\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x86"],
        ["\xE6\xAF\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD8"],

        ["\xDD\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x8B"],
        ["\xE6\xAF\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xD9"],

        ["\xDD\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x93"],
        ["\xE6\xAF\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xDA"],

        ["\xDD\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\x9F"],
        ["\xE6\xAF\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xDB"],

        ["\xDD\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAC"],
        ["\xE6\xAF\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xDC"],

        ["\xDD\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAB"],
        ["\xE6\xAF\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xDD"],

        ["\xDD\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xB3"],
        ["\xE6\xAF\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xDE"],

        ["\xDD\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF\xAF"],
        ["\xE6\xAF\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xDF"],

        ["\xDD\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xBE"],
        ["\xE9\xBA\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE0"],

        ["\xDD\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x88"],
        ["\xE6\xB0\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE1"],

        ["\xDD\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x93"],
        ["\xE6\xB0\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE2"],

        ["\xDD\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x94"],
        ["\xE6\xB0\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE3"],

        ["\xDD\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\x9B"],
        ["\xE6\xB0\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE4"],

        ["\xDD\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xA4"],
        ["\xE6\xB0\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE5"],

        ["\xDD\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0\xA3"],
        ["\xE6\xB0\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE6"],

        ["\xDD\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x9E"],
        ["\xE6\xB1\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE7"],

        ["\xDD\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\x95"],
        ["\xE6\xB1\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE8"],

        ["\xDD\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA2"],
        ["\xE6\xB1\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xE9"],

        ["\xDD\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xAA"],
        ["\xE6\xB1\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xEA"],

        ["\xDD\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x82"],
        ["\xE6\xB2\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xEB"],

        ["\xDD\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x8D"],
        ["\xE6\xB2\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xEC"],

        ["\xDD\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x9A"],
        ["\xE6\xB2\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xED"],

        ["\xDD\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x81"],
        ["\xE6\xB2\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xEE"],

        ["\xDD\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x9B"],
        ["\xE6\xB2\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xEF"],

        ["\xDD\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xBE"],
        ["\xE6\xB1\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF0"],

        ["\xDD\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xA8"],
        ["\xE6\xB1\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF1"],

        ["\xDD\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1\xB3"],
        ["\xE6\xB1\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF2"],

        ["\xDD\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x92"],
        ["\xE6\xB2\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF3"],

        ["\xDD\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\x90"],
        ["\xE6\xB2\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF4"],

        ["\xDD\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x84"],
        ["\xE6\xB3\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF5"],

        ["\xDD\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xB1"],
        ["\xE6\xB3\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF6"],

        ["\xDD\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x93"],
        ["\xE6\xB3\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF7"],

        ["\xDD\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBD"],
        ["\xE6\xB2\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF8"],

        ["\xDD\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x97"],
        ["\xE6\xB3\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xF9"],

        ["\xDD\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x85"],
        ["\xE6\xB3\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xFA"],

        ["\xDD\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9D"],
        ["\xE6\xB3\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xFB"],

        ["\xDD\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xAE"],
        ["\xE6\xB2\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xFC"],

        ["\xDD\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xB1"],
        ["\xE6\xB2\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xFD"],

        ["\xDD\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBE"],
        ["\xE6\xB2\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDD\xFE"],

        ["\xDE\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2\xBA"],
        ["\xE6\xB2\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xA1"],

        ["\xDE\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x9B"],
        ["\xE6\xB3\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xA2"],

        ["\xDE\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAF"],
        ["\xE6\xB3\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xA3"],

        ["\xDE\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\x99"],
        ["\xE6\xB3\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xA4"],

        ["\xDE\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3\xAA"],
        ["\xE6\xB3\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xA5"],

        ["\xDE\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x9F"],
        ["\xE6\xB4\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xA6"],

        ["\xDE\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x8D"],
        ["\xE8\xA1\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xA7"],

        ["\xDE\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB6"],
        ["\xE6\xB4\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xA8"],

        ["\xDE\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xAB"],
        ["\xE6\xB4\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xA9"],

        ["\xDE\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xBD"],
        ["\xE6\xB4\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xAA"],

        ["\xDE\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB8"],
        ["\xE6\xB4\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xAB"],

        ["\xDE\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x99"],
        ["\xE6\xB4\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xAC"],

        ["\xDE\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB5"],
        ["\xE6\xB4\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xAD"],

        ["\xDE\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\xB3"],
        ["\xE6\xB4\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xAE"],

        ["\xDE\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x92"],
        ["\xE6\xB4\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xAF"],

        ["\xDE\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4\x8C"],
        ["\xE6\xB4\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB0"],

        ["\xDE\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA3"],
        ["\xE6\xB5\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB1"],

        ["\xDE\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x93"],
        ["\xE6\xB6\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB2"],

        ["\xDE\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xA4"],
        ["\xE6\xB5\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB3"],

        ["\xDE\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x9A"],
        ["\xE6\xB5\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB4"],

        ["\xDE\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\xB9"],
        ["\xE6\xB5\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB5"],

        ["\xDE\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5\x99"],
        ["\xE6\xB5\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB6"],

        ["\xDE\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x8E"],
        ["\xE6\xB6\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB7"],

        ["\xDE\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x95"],
        ["\xE6\xB6\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xB8"],

        ["\xC5\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xA4"],
        ["\xE6\xBF\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xF3"],

        ["\xDE\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\x85"],
        ["\xE6\xB6\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xBA"],

        ["\xDE\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xB9"],
        ["\xE6\xB7\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xBB"],

        ["\xDE\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x95"],
        ["\xE6\xB8\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xBC"],

        ["\xDE\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x8A"],
        ["\xE6\xB8\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xBD"],

        ["\xDE\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB5"],
        ["\xE6\xB6\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xBE"],

        ["\xDE\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x87"],
        ["\xE6\xB7\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xBF"],

        ["\xDE\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA6"],
        ["\xE6\xB7\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC0"],

        ["\xDE\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6\xB8"],
        ["\xE6\xB6\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC1"],

        ["\xDE\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x86"],
        ["\xE6\xB7\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC2"],

        ["\xDE\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAC"],
        ["\xE6\xB7\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC3"],

        ["\xDE\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x9E"],
        ["\xE6\xB7\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC4"],

        ["\xDE\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x8C"],
        ["\xE6\xB7\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC5"],

        ["\xDE\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA8"],
        ["\xE6\xB7\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC6"],

        ["\xDE\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x92"],
        ["\xE6\xB7\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC7"],

        ["\xDE\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x85"],
        ["\xE6\xB7\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC8"],

        ["\xDE\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xBA"],
        ["\xE6\xB7\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xC9"],

        ["\xDE\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x99"],
        ["\xE6\xB7\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xCA"],

        ["\xDE\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xA4"],
        ["\xE6\xB7\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xCB"],

        ["\xDE\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\x95"],
        ["\xE6\xB7\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xCC"],

        ["\xDE\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAA"],
        ["\xE6\xB7\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xCD"],

        ["\xDE\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7\xAE"],
        ["\xE6\xB7\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xCE"],

        ["\xDE\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAD"],
        ["\xE6\xB8\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xCF"],

        ["\xDE\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAE"],
        ["\xE6\xB9\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD0"],

        ["\xDE\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAE"],
        ["\xE6\xB8\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD1"],

        ["\xDE\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x99"],
        ["\xE6\xB8\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD2"],

        ["\xDE\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xB2"],
        ["\xE6\xB9\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD3"],

        ["\xDE\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x9F"],
        ["\xE6\xB9\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD4"],

        ["\xDE\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xBE"],
        ["\xE6\xB8\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD5"],

        ["\xDE\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA3"],
        ["\xE6\xB8\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD6"],

        ["\xDE\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xAB"],
        ["\xE6\xB9\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD7"],

        ["\xDE\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xAB"],
        ["\xE6\xB8\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD8"],

        ["\xDE\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\xB6"],
        ["\xE6\xB9\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xD9"],

        ["\xDE\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8D"],
        ["\xE6\xB9\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xDA"],

        ["\xDE\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9F"],
        ["\xE6\xB8\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xDB"],

        ["\xDE\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x83"],
        ["\xE6\xB9\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xDC"],

        ["\xDE\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xBA"],
        ["\xE6\xB8\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xDD"],

        ["\xDE\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9\x8E"],
        ["\xE6\xB9\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xDE"],

        ["\xDE\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xA4"],
        ["\xE6\xB8\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xDF"],

        ["\xDE\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xBF"],
        ["\xE6\xBB\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE0"],

        ["\xDE\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\x9D"],
        ["\xE6\xB8\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE1"],

        ["\xDE\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8\xB8"],
        ["\xE6\xB8\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE2"],

        ["\xDE\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x82"],
        ["\xE6\xBA\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE3"],

        ["\xDE\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xAA"],
        ["\xE6\xBA\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE4"],

        ["\xDE\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x98"],
        ["\xE6\xBA\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE5"],

        ["\xDE\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x89"],
        ["\xE6\xBB\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE6"],

        ["\xDE\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB7"],
        ["\xE6\xBA\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE7"],

        ["\xDE\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x93"],
        ["\xE6\xBB\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE8"],

        ["\xDE\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xBD"],
        ["\xE6\xBA\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xE9"],

        ["\xDE\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xAF"],
        ["\xE6\xBA\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xEA"],

        ["\xDE\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x84"],
        ["\xE6\xBB\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xEB"],

        ["\xDE\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xB2"],
        ["\xE6\xBA\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xEC"],

        ["\xDE\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x94"],
        ["\xE6\xBB\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xED"],

        ["\xDE\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x95"],
        ["\xE6\xBB\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xEE"],

        ["\xDE\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x8F"],
        ["\xE6\xBA\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xEF"],

        ["\xDE\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\xA5"],
        ["\xE6\xBA\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF0"],

        ["\xDE\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x82"],
        ["\xE6\xBB\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF1"],

        ["\xDE\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA\x9F"],
        ["\xE6\xBA\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF2"],

        ["\xDE\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x81"],
        ["\xE6\xBD\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF3"],

        ["\xDE\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x91"],
        ["\xE6\xBC\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF4"],

        ["\xB4\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x8C"],
        ["\xE7\x81\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xC3"],

        ["\xDE\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xAC"],
        ["\xE6\xBB\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF6"],

        ["\xDE\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB8"],
        ["\xE6\xBB\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF7"],

        ["\xDE\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xBE"],
        ["\xE6\xBB\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF8"],

        ["\xDE\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xBF"],
        ["\xE6\xBC\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xF9"],

        ["\xDE\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB2"],
        ["\xE6\xBB\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xFA"],

        ["\xDE\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB1"],
        ["\xE6\xBC\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xFB"],

        ["\xDE\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xAF"],
        ["\xE6\xBB\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xFC"],

        ["\xDE\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xB2"],
        ["\xE6\xBC\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xFD"],

        ["\xDE\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\x8C"],
        ["\xE6\xBB\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDE\xFE"],

        ["\xDF\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\xBE"],
        ["\xE6\xBC\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xA1"],

        ["\xDF\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC\x93"],
        ["\xE6\xBC\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xA2"],

        ["\xDF\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB\xB7"],
        ["\xE6\xBB\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xA3"],

        ["\xDF\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x86"],
        ["\xE6\xBE\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xA4"],

        ["\xDF\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBA"],
        ["\xE6\xBD\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xA5"],

        ["\xDF\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB8"],
        ["\xE6\xBD\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xA6"],

        ["\xDF\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x81"],
        ["\xE6\xBE\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xA7"],

        ["\xDF\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x80"],
        ["\xE6\xBE\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xA8"],

        ["\xDF\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAF"],
        ["\xE6\xBD\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xA9"],

        ["\xDF\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x9B"],
        ["\xE6\xBD\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xAA"],

        ["\xDF\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB3"],
        ["\xE6\xBF\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xAB"],

        ["\xDF\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xAD"],
        ["\xE6\xBD\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xAC"],

        ["\xDF\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x82"],
        ["\xE6\xBE\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xAD"],

        ["\xDF\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xBC"],
        ["\xE6\xBD\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xAE"],

        ["\xDF\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\x98"],
        ["\xE6\xBD\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xAF"],

        ["\xDF\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x8E"],
        ["\xE6\xBE\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB0"],

        ["\xDF\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\x91"],
        ["\xE6\xBE\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB1"],

        ["\xDF\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x82"],
        ["\xE6\xBF\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB2"],

        ["\xDF\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xA6"],
        ["\xE6\xBD\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB3"],

        ["\xDF\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB3"],
        ["\xE6\xBE\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB4"],

        ["\xDF\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA3"],
        ["\xE6\xBE\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB5"],

        ["\xDF\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA1"],
        ["\xE6\xBE\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB6"],

        ["\xDF\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xA4"],
        ["\xE6\xBE\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB7"],

        ["\xDF\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xB9"],
        ["\xE6\xBE\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB8"],

        ["\xDF\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x86"],
        ["\xE6\xBF\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xB9"],

        ["\xDF\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE\xAA"],
        ["\xE6\xBE\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xBA"],

        ["\xDF\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9F"],
        ["\xE6\xBF\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xBB"],

        ["\xDF\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x95"],
        ["\xE6\xBF\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xBC"],

        ["\xDF\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAC"],
        ["\xE6\xBF\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xBD"],

        ["\xDF\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x94"],
        ["\xE6\xBF\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xBE"],

        ["\xDF\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x98"],
        ["\xE6\xBF\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xBF"],

        ["\xDF\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB1"],
        ["\xE6\xBF\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC0"],

        ["\xDF\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xAE"],
        ["\xE6\xBF\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC1"],

        ["\xDF\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\x9B"],
        ["\xE6\xBF\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC2"],

        ["\xDF\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x89"],
        ["\xE7\x80\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC3"],

        ["\xDF\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x8B"],
        ["\xE7\x80\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC4"],

        ["\xDF\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xBA"],
        ["\xE6\xBF\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC5"],

        ["\xDF\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x91"],
        ["\xE7\x80\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC6"],

        ["\xDF\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x81"],
        ["\xE7\x80\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC7"],

        ["\xDF\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x8F"],
        ["\xE7\x80\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC8"],

        ["\xDF\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xBE"],
        ["\xE6\xBF\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xC9"],

        ["\xDF\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9B"],
        ["\xE7\x80\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xCA"],

        ["\xDF\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9A"],
        ["\xE7\x80\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xCB"],

        ["\xDF\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD\xB4"],
        ["\xE6\xBD\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xCC"],

        ["\xDF\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9D"],
        ["\xE7\x80\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xCD"],

        ["\xDF\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x98"],
        ["\xE7\x80\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xCE"],

        ["\xDF\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\x9F"],
        ["\xE7\x80\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xCF"],

        ["\xDF\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xB0"],
        ["\xE7\x80\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD0"],

        ["\xDF\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xBE"],
        ["\xE7\x80\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD1"],

        ["\xDF\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x80\xB2"],
        ["\xE7\x80\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD2"],

        ["\xDF\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\x91"],
        ["\xE7\x81\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD3"],

        ["\xDF\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x81\xA3"],
        ["\xE7\x81\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD4"],

        ["\xDF\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x99"],
        ["\xE7\x82\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD5"],

        ["\xDF\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\x92"],
        ["\xE7\x82\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD6"],

        ["\xDF\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAF"],
        ["\xE7\x82\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD7"],

        ["\xDF\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xB1"],
        ["\xE7\x83\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD8"],

        ["\xDF\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAC"],
        ["\xE7\x82\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xD9"],

        ["\xDF\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB8"],
        ["\xE7\x82\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xDA"],

        ["\xDF\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xB3"],
        ["\xE7\x82\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xDB"],

        ["\xDF\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x82\xAE"],
        ["\xE7\x82\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xDC"],

        ["\xDF\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x9F"],
        ["\xE7\x83\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xDD"],

        ["\xDF\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x8B"],
        ["\xE7\x83\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xDE"],

        ["\xDF\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x9D"],
        ["\xE7\x83\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xDF"],

        ["\xDF\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\x99"],
        ["\xE7\x83\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE0"],

        ["\xDF\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x89"],
        ["\xE7\x84\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE1"],

        ["\xDF\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x83\xBD"],
        ["\xE7\x83\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE2"],

        ["\xDF\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x9C"],
        ["\xE7\x84\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE3"],

        ["\xDF\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x84\x99"],
        ["\xE7\x84\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE4"],

        ["\xDF\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA5"],
        ["\xE7\x85\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE5"],

        ["\xDF\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x95"],
        ["\xE7\x85\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE6"],

        ["\xDF\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x88"],
        ["\xE7\x86\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE7"],

        ["\xDF\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA6"],
        ["\xE7\x85\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE8"],

        ["\xDF\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xA2"],
        ["\xE7\x85\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xE9"],

        ["\xDF\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x8C"],
        ["\xE7\x85\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xEA"],

        ["\xDF\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\x96"],
        ["\xE7\x85\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xEB"],

        ["\xDF\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x85\xAC"],
        ["\xE7\x85\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xEC"],

        ["\xDF\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x8F"],
        ["\xE7\x86\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xED"],

        ["\xDF\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBB"],
        ["\xE7\x87\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xEE"],

        ["\xDF\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x84"],
        ["\xE7\x86\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xEF"],

        ["\xDF\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\x95"],
        ["\xE7\x86\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF0"],

        ["\xDF\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xA8"],
        ["\xE7\x86\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF1"],

        ["\xDF\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xAC"],
        ["\xE7\x86\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF2"],

        ["\xDF\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x97"],
        ["\xE7\x87\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF3"],

        ["\xDF\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xB9"],
        ["\xE7\x86\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF4"],

        ["\xDF\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x86\xBE"],
        ["\xE7\x86\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF5"],

        ["\xDF\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x92"],
        ["\xE7\x87\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF6"],

        ["\xDF\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x89"],
        ["\xE7\x87\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF7"],

        ["\xDF\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x94"],
        ["\xE7\x87\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF8"],

        ["\xDF\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\x8E"],
        ["\xE7\x87\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xF9"],

        ["\xDF\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA0"],
        ["\xE7\x87\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xFA"],

        ["\xDF\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xAC"],
        ["\xE7\x87\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xFB"],

        ["\xDF\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xA7"],
        ["\xE7\x87\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xFC"],

        ["\xDF\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xB5"],
        ["\xE7\x87\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xFD"],

        ["\xDF\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBC"],
        ["\xE7\x87\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xDF\xFE"],

        ["\xE0\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xB9"],
        ["\xE7\x87\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA1"],

        ["\xE0\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x87\xBF"],
        ["\xE7\x87\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA2"],

        ["\xE0\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x8D"],
        ["\xE7\x88\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA3"],

        ["\xE0\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x90"],
        ["\xE7\x88\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA4"],

        ["\xE0\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\x9B"],
        ["\xE7\x88\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA5"],

        ["\xE0\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xA8"],
        ["\xE7\x88\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA6"],

        ["\xE0\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAD"],
        ["\xE7\x88\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA7"],

        ["\xE0\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xAC"],
        ["\xE7\x88\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA8"],

        ["\xE0\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB0"],
        ["\xE7\x88\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xA9"],

        ["\xE0\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xB2"],
        ["\xE7\x88\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAA"],

        ["\xE0\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBB"],
        ["\xE7\x88\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAB"],

        ["\xE0\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBC"],
        ["\xE7\x88\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],

        ["\xE0\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x88\xBF"],
        ["\xE7\x88\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAD"],

        ["\xE0\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x80"],
        ["\xE7\x89\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAE"],

        ["\xE0\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x86"],
        ["\xE7\x89\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xAF"],

        ["\xE0\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x8B"],
        ["\xE7\x89\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB0"],

        ["\xE0\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\x98"],
        ["\xE7\x89\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB1"],

        ["\xE0\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xB4"],
        ["\xE7\x89\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB2"],

        ["\xE0\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x89\xBE"],
        ["\xE7\x89\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB3"],

        ["\xE0\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x82"],
        ["\xE7\x8A\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB4"],

        ["\xE0\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x81"],
        ["\xE7\x8A\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB5"],

        ["\xE0\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x87"],
        ["\xE7\x8A\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB6"],

        ["\xE0\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x92"],
        ["\xE7\x8A\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB7"],

        ["\xE0\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\x96"],
        ["\xE7\x8A\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB8"],

        ["\xE0\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA2"],
        ["\xE7\x8A\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xB9"],

        ["\xE0\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xA7"],
        ["\xE7\x8A\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBA"],

        ["\xE0\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB9"],
        ["\xE7\x8A\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBB"],

        ["\xE0\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A\xB2"],
        ["\xE7\x8A\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBC"],

        ["\xE0\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x83"],
        ["\xE7\x8B\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBD"],

        ["\xE0\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x86"],
        ["\xE7\x8B\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBE"],

        ["\xE0\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x84"],
        ["\xE7\x8B\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xBF"],

        ["\xE0\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x8E"],
        ["\xE7\x8B\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC0"],

        ["\xE0\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\x92"],
        ["\xE7\x8B\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC1"],

        ["\xE0\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA2"],
        ["\xE7\x8B\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC2"],

        ["\xE0\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA0"],
        ["\xE7\x8B\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC3"],

        ["\xE0\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xA1"],
        ["\xE7\x8B\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC4"],

        ["\xE0\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB9"],
        ["\xE7\x8B\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC5"],

        ["\xE0\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B\xB7"],
        ["\xE7\x8B\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC6"],

        ["\xE0\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x80\x8F"],
        ["\xE5\x80\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],

        ["\xE0\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x97"],
        ["\xE7\x8C\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],

        ["\xE0\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x8A"],
        ["\xE7\x8C\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xC9"],

        ["\xE0\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9C"],
        ["\xE7\x8C\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCA"],

        ["\xE0\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x96"],
        ["\xE7\x8C\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCB"],

        ["\xE0\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\x9D"],
        ["\xE7\x8C\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCC"],

        ["\xE0\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xB4"],
        ["\xE7\x8C\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCD"],

        ["\xE0\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xAF"],
        ["\xE7\x8C\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCE"],

        ["\xE0\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA9"],
        ["\xE7\x8C\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xCF"],

        ["\xE0\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xA5"],
        ["\xE7\x8C\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD0"],

        ["\xE0\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C\xBE"],
        ["\xE7\x8C\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD1"],

        ["\xE0\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x8E"],
        ["\xE7\x8D\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD2"],

        ["\xE0\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x8F"],
        ["\xE7\x8D\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD3"],

        ["\xE0\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB\x98"],
        ["\xE9\xBB\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD4"],

        ["\xE0\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\x97"],
        ["\xE7\x8D\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD5"],

        ["\xE0\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xAA"],
        ["\xE7\x8D\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD6"],

        ["\xE0\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xA8"],
        ["\xE7\x8D\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD7"],

        ["\xE0\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB0"],
        ["\xE7\x8D\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD8"],

        ["\xE0\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB8"],
        ["\xE7\x8D\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xD9"],

        ["\xE0\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xB5"],
        ["\xE7\x8D\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDA"],

        ["\xE0\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xBB"],
        ["\xE7\x8D\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDB"],

        ["\xE0\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D\xBA"],
        ["\xE7\x8D\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDC"],

        ["\xE0\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x88"],
        ["\xE7\x8F\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDD"],

        ["\xE0\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xB3"],
        ["\xE7\x8E\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDE"],

        ["\xE0\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x8E"],
        ["\xE7\x8F\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xDF"],

        ["\xE0\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E\xBB"],
        ["\xE7\x8E\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE0"],

        ["\xE0\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x80"],
        ["\xE7\x8F\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE1"],

        ["\xE0\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xA5"],
        ["\xE7\x8F\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE2"],

        ["\xE0\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xAE"],
        ["\xE7\x8F\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE3"],

        ["\xE0\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\x9E"],
        ["\xE7\x8F\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE4"],

        ["\xE0\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA2"],
        ["\xE7\x92\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE5"],

        ["\xE0\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\x85"],
        ["\xE7\x90\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE6"],

        ["\xE0\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xAF"],
        ["\xE7\x91\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE7"],

        ["\xE0\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xA5"],
        ["\xE7\x90\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE8"],

        ["\xE0\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB8"],
        ["\xE7\x8F\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xE9"],

        ["\xE0\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xB2"],
        ["\xE7\x90\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEA"],

        ["\xE0\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xBA"],
        ["\xE7\x90\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEB"],

        ["\xE0\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x95"],
        ["\xE7\x91\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEC"],

        ["\xE0\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x90\xBF"],
        ["\xE7\x90\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xED"],

        ["\xE0\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9F"],
        ["\xE7\x91\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],

        ["\xE0\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x99"],
        ["\xE7\x91\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],

        ["\xE0\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x81"],
        ["\xE7\x91\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF0"],

        ["\xE0\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\x9C"],
        ["\xE7\x91\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],

        ["\xE0\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA9"],
        ["\xE7\x91\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF2"],

        ["\xE0\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB0"],
        ["\xE7\x91\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF3"],

        ["\xE0\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xA3"],
        ["\xE7\x91\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF4"],

        ["\xE0\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xAA"],
        ["\xE7\x91\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],

        ["\x59\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xB6"],
        ["\xE7\x91\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\x59\xA2"],

        ["\xE0\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x91\xBE"],
        ["\xE7\x91\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],

        ["\xE0\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x8B"],
        ["\xE7\x92\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],

        ["\xE0\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\x9E"],
        ["\xE7\x92\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],

        ["\xE0\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x92\xA7"],
        ["\xE7\x92\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],

        ["\xE0\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x8A"],
        ["\xE7\x93\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],

        ["\xE0\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x8F"],
        ["\xE7\x93\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],

        ["\xE0\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\x94"],
        ["\xE7\x93\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFD"],

        ["\xE0\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F\xB1"],
        ["\xE7\x8F\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE0\xFE"],

        ["\xE1\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA0"],
        ["\xE7\x93\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA1"],

        ["\xE1\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA3"],
        ["\xE7\x93\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA2"],

        ["\xE1\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA7"],
        ["\xE7\x93\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA3"],

        ["\xE1\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xA9"],
        ["\xE7\x93\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA4"],

        ["\xE1\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xAE"],
        ["\xE7\x93\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA5"],

        ["\xE1\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB2"],
        ["\xE7\x93\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA6"],

        ["\xE1\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB0"],
        ["\xE7\x93\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA7"],

        ["\xE1\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB1"],
        ["\xE7\x93\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA8"],

        ["\xE1\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB8"],
        ["\xE7\x93\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xA9"],

        ["\xE1\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x93\xB7"],
        ["\xE7\x93\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAA"],

        ["\xE1\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x84"],
        ["\xE7\x94\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAB"],

        ["\xE1\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x83"],
        ["\xE7\x94\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAC"],

        ["\xE1\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x85"],
        ["\xE7\x94\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAD"],

        ["\xE1\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8C"],
        ["\xE7\x94\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAE"],

        ["\xE1\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8E"],
        ["\xE7\x94\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xAF"],

        ["\xE1\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x8D"],
        ["\xE7\x94\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB0"],

        ["\xE1\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x95"],
        ["\xE7\x94\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB1"],

        ["\xE1\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x93"],
        ["\xE7\x94\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB2"],

        ["\xE1\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\x9E"],
        ["\xE7\x94\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB3"],

        ["\xE1\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xA6"],
        ["\xE7\x94\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB4"],

        ["\xE1\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xAC"],
        ["\xE7\x94\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB5"],

        ["\xE1\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x94\xBC"],
        ["\xE7\x94\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB6"],

        ["\xE1\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x84"],
        ["\xE7\x95\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB7"],

        ["\xE1\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8D"],
        ["\xE7\x95\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB8"],

        ["\xE1\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x8A"],
        ["\xE7\x95\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xB9"],

        ["\xE1\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x89"],
        ["\xE7\x95\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBA"],

        ["\xE1\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9B"],
        ["\xE7\x95\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBB"],

        ["\xE1\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x86"],
        ["\xE7\x95\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBC"],

        ["\xE1\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\x9A"],
        ["\xE7\x95\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBD"],

        ["\xE1\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA9"],
        ["\xE7\x95\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBE"],

        ["\xE1\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA4"],
        ["\xE7\x95\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xBF"],

        ["\xE1\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xA7"],
        ["\xE7\x95\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC0"],

        ["\xE1\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAB"],
        ["\xE7\x95\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC1"],

        ["\xE1\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xAD"],
        ["\xE7\x95\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC2"],

        ["\xE1\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB8"],
        ["\xE7\x95\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC3"],

        ["\xE1\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB6"],
        ["\xE7\x95\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC4"],

        ["\xE1\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x86"],
        ["\xE7\x96\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC5"],

        ["\xE1\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x87"],
        ["\xE7\x96\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC6"],

        ["\xE1\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x95\xB4"],
        ["\xE7\x95\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC7"],

        ["\xE1\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x8A"],
        ["\xE7\x96\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC8"],

        ["\xE1\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x89"],
        ["\xE7\x96\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xC9"],

        ["\xE1\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x82"],
        ["\xE7\x96\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCA"],

        ["\xE1\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x94"],
        ["\xE7\x96\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCB"],

        ["\xE1\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x9A"],
        ["\xE7\x96\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCC"],

        ["\xE1\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\x9D"],
        ["\xE7\x96\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCD"],

        ["\xE1\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xA5"],
        ["\xE7\x96\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCE"],

        ["\xE1\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xA3"],
        ["\xE7\x96\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xCF"],

        ["\xE1\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x82"],
        ["\xE7\x97\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD0"],

        ["\xE1\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB3"],
        ["\xE7\x96\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD1"],

        ["\xE1\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x83"],
        ["\xE7\x97\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD2"],

        ["\xE1\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB5"],
        ["\xE7\x96\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD3"],

        ["\xE1\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBD"],
        ["\xE7\x96\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD4"],

        ["\xE1\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB8"],
        ["\xE7\x96\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD5"],

        ["\xE1\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xBC"],
        ["\xE7\x96\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD6"],

        ["\xE1\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x96\xB1"],
        ["\xE7\x96\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD7"],

        ["\xE1\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x8D"],
        ["\xE7\x97\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD8"],

        ["\xE1\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x8A"],
        ["\xE7\x97\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xD9"],

        ["\xE1\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x92"],
        ["\xE7\x97\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDA"],

        ["\xE1\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x99"],
        ["\xE7\x97\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDB"],

        ["\xE1\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xA3"],
        ["\xE7\x97\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDC"],

        ["\xE1\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\x9E"],
        ["\xE7\x97\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDD"],

        ["\xE1\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBE"],
        ["\xE7\x97\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDE"],

        ["\xE1\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBF"],
        ["\xE7\x97\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xDF"],

        ["\xE1\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBC"],
        ["\xE7\x97\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE0"],

        ["\xE1\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x81"],
        ["\xE7\x98\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE1"],

        ["\xE1\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB0"],
        ["\xE7\x97\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE2"],

        ["\xE1\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xBA"],
        ["\xE7\x97\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE3"],

        ["\xE1\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB2"],
        ["\xE7\x97\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE4"],

        ["\xE1\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x97\xB3"],
        ["\xE7\x97\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE5"],

        ["\xE1\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x8B"],
        ["\xE7\x98\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE6"],

        ["\xE1\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x8D"],
        ["\xE7\x98\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE7"],

        ["\xE1\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x89"],
        ["\xE7\x98\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE8"],

        ["\xE1\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\x9F"],
        ["\xE7\x98\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xE9"],

        ["\xE1\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA7"],
        ["\xE7\x98\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEA"],

        ["\xE1\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA0"],
        ["\xE7\x98\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEB"],

        ["\xE1\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA1"],
        ["\xE7\x98\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEC"],

        ["\xE1\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA2"],
        ["\xE7\x98\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xED"],

        ["\xE1\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xA4"],
        ["\xE7\x98\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEE"],

        ["\xE1\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xB4"],
        ["\xE7\x98\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xEF"],

        ["\xE1\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xB0"],
        ["\xE7\x98\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF0"],

        ["\xE1\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x98\xBB"],
        ["\xE7\x98\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF1"],

        ["\xE1\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x87"],
        ["\xE7\x99\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF2"],

        ["\xE1\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x88"],
        ["\xE7\x99\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF3"],

        ["\xE1\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x86"],
        ["\xE7\x99\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF4"],

        ["\xE1\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x9C"],
        ["\xE7\x99\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF5"],

        ["\xE1\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\x98"],
        ["\xE7\x99\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF6"],

        ["\xE1\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA1"],
        ["\xE7\x99\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF7"],

        ["\xE1\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA2"],
        ["\xE7\x99\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF8"],

        ["\xE1\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA8"],
        ["\xE7\x99\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xF9"],

        ["\xE1\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA9"],
        ["\xE7\x99\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xFA"],

        ["\xE1\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAA"],
        ["\xE7\x99\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xFB"],

        ["\xE1\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xA7"],
        ["\xE7\x99\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xFC"],

        ["\xE1\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xAC"],
        ["\xE7\x99\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xFD"],

        ["\xE1\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB0"],
        ["\xE7\x99\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE1\xFE"],

        ["\xE2\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB2"],
        ["\xE7\x99\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA1"],

        ["\xE2\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB6"],
        ["\xE7\x99\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA2"],

        ["\xE2\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xB8"],
        ["\xE7\x99\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA3"],

        ["\xE2\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x99\xBC"],
        ["\xE7\x99\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA4"],

        ["\xE2\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x80"],
        ["\xE7\x9A\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA5"],

        ["\xE2\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x83"],
        ["\xE7\x9A\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA6"],

        ["\xE2\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x88"],
        ["\xE7\x9A\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA7"],

        ["\xE2\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x8B"],
        ["\xE7\x9A\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA8"],

        ["\xE2\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x8E"],
        ["\xE7\x9A\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xA9"],

        ["\xE2\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x96"],
        ["\xE7\x9A\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAA"],

        ["\xE2\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x93"],
        ["\xE7\x9A\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAB"],

        ["\xE2\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x99"],
        ["\xE7\x9A\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAC"],

        ["\xE2\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\x9A"],
        ["\xE7\x9A\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAD"],

        ["\xE2\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB0"],
        ["\xE7\x9A\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAE"],

        ["\xE2\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB4"],
        ["\xE7\x9A\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xAF"],

        ["\xE2\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB8"],
        ["\xE7\x9A\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB0"],

        ["\xE2\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xB9"],
        ["\xE7\x9A\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB1"],

        ["\xE2\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9A\xBA"],
        ["\xE7\x9A\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB2"],

        ["\xE2\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x82"],
        ["\xE7\x9B\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB3"],

        ["\xE2\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x8D"],
        ["\xE7\x9B\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB4"],

        ["\xE2\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x96"],
        ["\xE7\x9B\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB5"],

        ["\xE2\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x92"],
        ["\xE7\x9B\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB6"],

        ["\xE2\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\x9E"],
        ["\xE7\x9B\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB7"],

        ["\xE2\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA1"],
        ["\xE7\x9B\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB8"],

        ["\xE2\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA5"],
        ["\xE7\x9B\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xB9"],

        ["\xE2\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xA7"],
        ["\xE7\x9B\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBA"],

        ["\xE2\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xAA"],
        ["\xE7\x9B\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBB"],

        ["\xE2\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xAF"],
        ["\xE8\x98\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBC"],

        ["\xE2\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9B\xBB"],
        ["\xE7\x9B\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBD"],

        ["\xE2\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x88"],
        ["\xE7\x9C\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBE"],

        ["\xE2\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x87"],
        ["\xE7\x9C\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xBF"],

        ["\xE2\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x84"],
        ["\xE7\x9C\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC0"],

        ["\xE2\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA9"],
        ["\xE7\x9C\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC1"],

        ["\xE2\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA4"],
        ["\xE7\x9C\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC2"],

        ["\xE2\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9E"],
        ["\xE7\x9C\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC3"],

        ["\xE2\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA5"],
        ["\xE7\x9C\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC4"],

        ["\xE2\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xA6"],
        ["\xE7\x9C\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC5"],

        ["\xE2\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\x9B"],
        ["\xE7\x9C\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC6"],

        ["\xE2\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB7"],
        ["\xE7\x9C\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC7"],

        ["\xE2\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C\xB8"],
        ["\xE7\x9C\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC8"],

        ["\xE2\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x87"],
        ["\xE7\x9D\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xC9"],

        ["\xE2\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9A"],
        ["\xE7\x9D\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCA"],

        ["\xE2\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA8"],
        ["\xE7\x9D\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCB"],

        ["\xE2\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xAB"],
        ["\xE7\x9D\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCC"],

        ["\xE2\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\x9B"],
        ["\xE7\x9D\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCD"],

        ["\xE2\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xA5"],
        ["\xE7\x9D\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCE"],

        ["\xE2\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBF"],
        ["\xE7\x9D\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xCF"],

        ["\xE2\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xBE"],
        ["\xE7\x9D\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD0"],

        ["\xE2\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D\xB9"],
        ["\xE7\x9D\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD1"],

        ["\xE2\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x8E"],
        ["\xE7\x9E\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD2"],

        ["\xE2\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x8B"],
        ["\xE7\x9E\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD3"],

        ["\xE2\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x91"],
        ["\xE7\x9E\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD4"],

        ["\xE2\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xA0"],
        ["\xE7\x9E\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD5"],

        ["\xE2\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\x9E"],
        ["\xE7\x9E\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD6"],

        ["\xE2\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB0"],
        ["\xE7\x9E\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD7"],

        ["\xE2\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB6"],
        ["\xE7\x9E\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD8"],

        ["\xE2\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xB9"],
        ["\xE7\x9E\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xD9"],

        ["\xE2\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBF"],
        ["\xE7\x9E\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDA"],

        ["\xE2\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBC"],
        ["\xE7\x9E\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDB"],

        ["\xE2\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBD"],
        ["\xE7\x9E\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDC"],

        ["\xE2\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9E\xBB"],
        ["\xE7\x9E\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDD"],

        ["\xE2\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x87"],
        ["\xE7\x9F\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDE"],

        ["\xE2\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x8D"],
        ["\xE7\x9F\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xDF"],

        ["\xE2\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x97"],
        ["\xE7\x9F\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],

        ["\xE2\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9A"],
        ["\xE7\x9F\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],

        ["\xE2\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\x9C"],
        ["\xE7\x9F\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],

        ["\xE2\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xA3"],
        ["\xE7\x9F\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],

        ["\xE2\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xAE"],
        ["\xE7\x9F\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],

        ["\xE2\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\x9F\xBC"],
        ["\xE7\x9F\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],

        ["\xE2\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x8C"],
        ["\xE7\xA0\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],

        ["\xE2\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\x92"],
        ["\xE7\xA0\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],

        ["\xB9\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xA6"],
        ["\xE7\xA4\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB9\xDC"],

        ["\xE2\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA0\xA0"],
        ["\xE7\xA0\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],

        ["\xC5\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAA"],
        ["\xE7\xA4\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC5\xD7"],

        ["\xE2\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\x85"],
        ["\xE7\xA1\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],

        ["\xE2\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8E"],
        ["\xE7\xA2\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],

        ["\xE2\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xB4"],
        ["\xE7\xA1\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],

        ["\xE2\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x86"],
        ["\xE7\xA2\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],

        ["\xE2\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1\xBC"],
        ["\xE7\xA1\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],

        ["\xE2\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x9A"],
        ["\xE7\xA2\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],

        ["\xE2\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\x8C"],
        ["\xE7\xA2\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],

        ["\xE2\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xA3"],
        ["\xE7\xA2\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],

        ["\xE2\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xB5"],
        ["\xE7\xA2\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],

        ["\xE2\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xAA"],
        ["\xE7\xA2\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],

        ["\xE2\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xAF"],
        ["\xE7\xA2\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],

        ["\xE2\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x91"],
        ["\xE7\xA3\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],

        ["\xE2\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x86"],
        ["\xE7\xA3\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],

        ["\xE2\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x8B"],
        ["\xE7\xA3\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],

        ["\xE2\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x94"],
        ["\xE7\xA3\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],

        ["\xE2\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBE"],
        ["\xE7\xA2\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFA"],

        ["\xE2\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2\xBC"],
        ["\xE7\xA2\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],

        ["\xE2\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x85"],
        ["\xE7\xA3\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],

        ["\xE2\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x8A"],
        ["\xE7\xA3\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFD"],

        ["\xE2\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xAC"],
        ["\xE7\xA3\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE2\xFE"],

        ["\xE3\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xA7"],
        ["\xE7\xA3\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA1"],

        ["\xE3\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\x9A"],
        ["\xE7\xA3\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA2"],

        ["\xE3\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xBD"],
        ["\xE7\xA3\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA3"],

        ["\xE3\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3\xB4"],
        ["\xE7\xA3\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA4"],

        ["\xE3\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x87"],
        ["\xE7\xA4\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA5"],

        ["\xE3\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x92"],
        ["\xE7\xA4\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA6"],

        ["\xE3\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x91"],
        ["\xE7\xA4\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA7"],

        ["\xE3\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\x99"],
        ["\xE7\xA4\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA8"],

        ["\xE3\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAC"],
        ["\xE7\xA4\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xA9"],

        ["\xE3\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4\xAB"],
        ["\xE7\xA4\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAA"],

        ["\xE3\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x80"],
        ["\xE7\xA5\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAB"],

        ["\xE3\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xA0"],
        ["\xE7\xA5\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAC"],

        ["\xE3\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x97"],
        ["\xE7\xA5\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAD"],

        ["\xE3\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9F"],
        ["\xE7\xA5\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAE"],

        ["\xE3\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x9A"],
        ["\xE7\xA5\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xAF"],

        ["\xE3\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x95"],
        ["\xE7\xA5\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB0"],

        ["\xE3\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\x93"],
        ["\xE7\xA5\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB1"],

        ["\xE3\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xBA"],
        ["\xE7\xA5\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB2"],

        ["\xE3\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5\xBF"],
        ["\xE7\xA5\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB3"],

        ["\xE3\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x8A"],
        ["\xE7\xA6\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB4"],

        ["\xE3\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x9D"],
        ["\xE7\xA6\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB5"],

        ["\xE3\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xA7"],
        ["\xE7\xA6\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB6"],

        ["\xE3\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8B"],
        ["\xE9\xBD\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB7"],

        ["\xE3\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xAA"],
        ["\xE7\xA6\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB8"],

        ["\xE3\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xAE"],
        ["\xE7\xA6\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xB9"],

        ["\xE3\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB3"],
        ["\xE7\xA6\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBA"],

        ["\xE3\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xB9"],
        ["\xE7\xA6\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBB"],

        ["\xE3\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\xBA"],
        ["\xE7\xA6\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBC"],

        ["\xE3\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x89"],
        ["\xE7\xA7\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBD"],

        ["\xE3\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\x95"],
        ["\xE7\xA7\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBE"],

        ["\xE3\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA7"],
        ["\xE7\xA7\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xBF"],

        ["\xE3\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xAC"],
        ["\xE7\xA7\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC0"],

        ["\xE3\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA1"],
        ["\xE7\xA7\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC1"],

        ["\xE3\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7\xA3"],
        ["\xE7\xA7\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC2"],

        ["\xE3\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x88"],
        ["\xE7\xA8\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC3"],

        ["\xE3\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x8D"],
        ["\xE7\xA8\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC4"],

        ["\xE3\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x98"],
        ["\xE7\xA8\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC5"],

        ["\xE3\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x99"],
        ["\xE7\xA8\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC6"],

        ["\xE3\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xA0"],
        ["\xE7\xA8\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC7"],

        ["\xE3\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\x9F"],
        ["\xE7\xA8\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC8"],

        ["\xE3\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6\x80"],
        ["\xE7\xA6\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xC9"],

        ["\xE3\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB1"],
        ["\xE7\xA8\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCA"],

        ["\xE3\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBB"],
        ["\xE7\xA8\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCB"],

        ["\xE3\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xBE"],
        ["\xE7\xA8\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCC"],

        ["\xE3\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8\xB7"],
        ["\xE7\xA8\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCD"],

        ["\xE3\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x83"],
        ["\xE7\xA9\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCE"],

        ["\xE3\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x97"],
        ["\xE7\xA9\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xCF"],

        ["\xE3\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\x89"],
        ["\xE7\xA9\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD0"],

        ["\xE3\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA1"],
        ["\xE7\xA9\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD1"],

        ["\xE3\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA2"],
        ["\xE7\xA9\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD2"],

        ["\xE3\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xA9"],
        ["\xE7\xA9\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD3"],

        ["\xE3\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE\x9D"],
        ["\xE9\xBE\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD4"],

        ["\xE3\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB0"],
        ["\xE7\xA9\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD5"],

        ["\xE3\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xB9"],
        ["\xE7\xA9\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD6"],

        ["\xE3\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9\xBD"],
        ["\xE7\xA9\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD7"],

        ["\xE3\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x88"],
        ["\xE7\xAA\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD8"],

        ["\xE3\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x97"],
        ["\xE7\xAA\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xD9"],

        ["\xE3\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x95"],
        ["\xE7\xAA\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDA"],

        ["\xE3\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x98"],
        ["\xE7\xAA\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDB"],

        ["\xE3\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\x96"],
        ["\xE7\xAA\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDC"],

        ["\xE3\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xA9"],
        ["\xE7\xAA\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDD"],

        ["\xB3\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x88"],
        ["\xE7\xAB\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xF6"],

        ["\xE3\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xB0"],
        ["\xE7\xAA\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xDF"],

        ["\xE3\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xB6"],
        ["\xE7\xAA\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE0"],

        ["\xE3\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x85"],
        ["\xE7\xAB\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],

        ["\xE3\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x84"],
        ["\xE7\xAB\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE2"],

        ["\xE3\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA\xBF"],
        ["\xE7\xAA\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE3"],

        ["\xE3\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x83"],
        ["\xE9\x82\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],

        ["\xE3\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x87"],
        ["\xE7\xAB\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],

        ["\xE3\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8A"],
        ["\xE7\xAB\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE6"],

        ["\xE3\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8D"],
        ["\xE7\xAB\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE7"],

        ["\xE3\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x8F"],
        ["\xE7\xAB\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE8"],

        ["\xE3\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x95"],
        ["\xE7\xAB\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xE9"],

        ["\xE3\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x93"],
        ["\xE7\xAB\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEA"],

        ["\xE3\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x99"],
        ["\xE7\xAB\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEB"],

        ["\xE3\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9A"],
        ["\xE7\xAB\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],

        ["\xE3\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9D"],
        ["\xE7\xAB\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],

        ["\xE3\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA1"],
        ["\xE7\xAB\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEE"],

        ["\xE3\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA2"],
        ["\xE7\xAB\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xEF"],

        ["\xE3\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xA6"],
        ["\xE7\xAB\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF0"],

        ["\xE3\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xAD"],
        ["\xE7\xAB\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF1"],

        ["\xE3\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\xB0"],
        ["\xE7\xAB\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF2"],

        ["\xE3\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x82"],
        ["\xE7\xAC\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],

        ["\xE3\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8F"],
        ["\xE7\xAC\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF4"],

        ["\xE3\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8A"],
        ["\xE7\xAC\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF5"],

        ["\xE3\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x86"],
        ["\xE7\xAC\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF6"],

        ["\xE3\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB3"],
        ["\xE7\xAC\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],

        ["\xE3\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x98"],
        ["\xE7\xAC\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],

        ["\xE3\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x99"],
        ["\xE7\xAC\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],

        ["\xE3\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x9E"],
        ["\xE7\xAC\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],

        ["\xE3\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB5"],
        ["\xE7\xAC\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xFB"],

        ["\xE3\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xA8"],
        ["\xE7\xAC\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xFC"],

        ["\xE3\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\xB6"],
        ["\xE7\xAC\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xFD"],

        ["\xE3\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x90"],
        ["\xE7\xAD\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE3\xFE"],

        ["\xE4\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xBA"],
        ["\xE7\xAD\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA1"],

        ["\xE4\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x84"],
        ["\xE7\xAC\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA2"],

        ["\xE4\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8D"],
        ["\xE7\xAD\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA3"],

        ["\xE4\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC\x8B"],
        ["\xE7\xAC\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA4"],

        ["\xE4\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x8C"],
        ["\xE7\xAD\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA5"],

        ["\xE4\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x85"],
        ["\xE7\xAD\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA6"],

        ["\xE4\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB5"],
        ["\xE7\xAD\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA7"],

        ["\xE4\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA5"],
        ["\xE7\xAD\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA8"],

        ["\xE4\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB4"],
        ["\xE7\xAD\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xA9"],

        ["\xE4\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xA7"],
        ["\xE7\xAD\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAA"],

        ["\xE4\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB0"],
        ["\xE7\xAD\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAB"],

        ["\xE4\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xB1"],
        ["\xE7\xAD\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAC"],

        ["\xE4\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAC"],
        ["\xE7\xAD\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAD"],

        ["\xE4\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\xAE"],
        ["\xE7\xAD\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAE"],

        ["\xE4\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9D"],
        ["\xE7\xAE\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xAF"],

        ["\xE4\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x98"],
        ["\xE7\xAE\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB0"],

        ["\xE4\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9F"],
        ["\xE7\xAE\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB1"],

        ["\xE4\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8D"],
        ["\xE7\xAE\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB2"],

        ["\xE4\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9C"],
        ["\xE7\xAE\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB3"],

        ["\xE4\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x9A"],
        ["\xE7\xAE\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB4"],

        ["\xE4\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8B"],
        ["\xE7\xAE\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB5"],

        ["\xE4\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x92"],
        ["\xE7\xAE\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB6"],

        ["\xE4\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x8F"],
        ["\xE7\xAE\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB7"],

        ["\xE4\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD\x9D"],
        ["\xE7\xAD\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB8"],

        ["\xE4\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\x99"],
        ["\xE7\xAE\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9"],

        ["\xE4\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8B"],
        ["\xE7\xAF\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBA"],

        ["\xE4\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x81"],
        ["\xE7\xAF\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBB"],

        ["\xE4\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8C"],
        ["\xE7\xAF\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBC"],

        ["\xE4\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x8F"],
        ["\xE7\xAF\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBD"],

        ["\xE4\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE\xB4"],
        ["\xE7\xAE\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],

        ["\xE4\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x86"],
        ["\xE7\xAF\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],

        ["\xE4\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\x9D"],
        ["\xE7\xAF\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],

        ["\xE4\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA9"],
        ["\xE7\xAF\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],

        ["\xE4\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x91"],
        ["\xE7\xB0\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],

        ["\xE4\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x94"],
        ["\xE7\xB0\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],

        ["\xE4\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA6"],
        ["\xE7\xAF\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],

        ["\xE4\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xA5"],
        ["\xE7\xAF\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],

        ["\xCF\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA0"],
        ["\xE7\xB1\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCF\xB6"],

        ["\xE4\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x80"],
        ["\xE7\xB0\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],

        ["\xE4\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x87"],
        ["\xE7\xB0\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],

        ["\xE4\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x93"],
        ["\xE7\xB0\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],

        ["\xE4\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB3"],
        ["\xE7\xAF\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],

        ["\xE4\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB7"],
        ["\xE7\xAF\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],

        ["\xE4\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x97"],
        ["\xE7\xB0\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],

        ["\xE4\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x8D"],
        ["\xE7\xB0\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCD"],

        ["\xE4\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF\xB6"],
        ["\xE7\xAF\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCE"],

        ["\xE4\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA3"],
        ["\xE7\xB0\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xCF"],

        ["\xE4\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xA7"],
        ["\xE7\xB0\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD0"],

        ["\xE4\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xAA"],
        ["\xE7\xB0\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD1"],

        ["\xE4\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\x9F"],
        ["\xE7\xB0\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD2"],

        ["\xE4\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xB7"],
        ["\xE7\xB0\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD3"],

        ["\xE4\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xAB"],
        ["\xE7\xB0\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD4"],

        ["\xE4\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0\xBD"],
        ["\xE7\xB0\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD5"],

        ["\xE4\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8C"],
        ["\xE7\xB1\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD6"],

        ["\xE4\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x83"],
        ["\xE7\xB1\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD7"],

        ["\xE4\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x94"],
        ["\xE7\xB1\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD8"],

        ["\xE4\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x8F"],
        ["\xE7\xB1\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xD9"],

        ["\xE4\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x80"],
        ["\xE7\xB1\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDA"],

        ["\xE4\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x90"],
        ["\xE7\xB1\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDB"],

        ["\xE4\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x98"],
        ["\xE7\xB1\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDC"],

        ["\xE4\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x9F"],
        ["\xE7\xB1\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDD"],

        ["\xE4\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA4"],
        ["\xE7\xB1\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDE"],

        ["\xE4\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\x96"],
        ["\xE7\xB1\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xDF"],

        ["\xE4\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xA5"],
        ["\xE7\xB1\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE0"],

        ["\xE4\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xAC"],
        ["\xE7\xB1\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE1"],

        ["\xE4\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1\xB5"],
        ["\xE7\xB1\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE2"],

        ["\xE4\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x83"],
        ["\xE7\xB2\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE3"],

        ["\xE4\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\x90"],
        ["\xE7\xB2\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE4"],

        ["\xE4\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA4"],
        ["\xE7\xB2\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE5"],

        ["\xE4\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAD"],
        ["\xE7\xB2\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE6"],

        ["\xE4\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA2"],
        ["\xE7\xB2\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE7"],

        ["\xE4\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAB"],
        ["\xE7\xB2\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE8"],

        ["\xE4\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA1"],
        ["\xE7\xB2\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xE9"],

        ["\xE4\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xA8"],
        ["\xE7\xB2\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEA"],

        ["\xE4\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB3"],
        ["\xE7\xB2\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEB"],

        ["\xE4\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB2"],
        ["\xE7\xB2\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEC"],

        ["\xE4\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB1"],
        ["\xE7\xB2\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xED"],

        ["\xE4\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xAE"],
        ["\xE7\xB2\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEE"],

        ["\xE4\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xB9"],
        ["\xE7\xB2\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xEF"],

        ["\xE4\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2\xBD"],
        ["\xE7\xB2\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF0"],

        ["\xE4\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x80"],
        ["\xE7\xB3\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF1"],

        ["\xE4\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x85"],
        ["\xE7\xB3\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF2"],

        ["\xE4\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x82"],
        ["\xE7\xB3\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF3"],

        ["\xE4\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x98"],
        ["\xE7\xB3\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF4"],

        ["\xE4\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x92"],
        ["\xE7\xB3\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF5"],

        ["\xE4\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\x9C"],
        ["\xE7\xB3\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF6"],

        ["\xE4\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xA2"],
        ["\xE7\xB3\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF7"],

        ["\xE4\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xBB"],
        ["\xE9\xAC\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF8"],

        ["\xE4\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xAF"],
        ["\xE7\xB3\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xF9"],

        ["\xE4\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB2"],
        ["\xE7\xB3\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xFA"],

        ["\xE4\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB4"],
        ["\xE7\xB3\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xFB"],

        ["\xE4\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xB6"],
        ["\xE7\xB3\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xFC"],

        ["\xE4\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3\xBA"],
        ["\xE7\xB3\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xFD"],

        ["\xE4\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x86"],
        ["\xE7\xB4\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE4\xFE"],

        ["\xE5\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x82"],
        ["\xE7\xB4\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA1"],

        ["\xE5\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x9C"],
        ["\xE7\xB4\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA2"],

        ["\xE5\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x95"],
        ["\xE7\xB4\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA3"],

        ["\xE5\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\x8A"],
        ["\xE7\xB4\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA4"],

        ["\xE5\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x85"],
        ["\xE7\xB5\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA5"],

        ["\xE5\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8B"],
        ["\xE7\xB5\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA6"],

        ["\xE5\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xAE"],
        ["\xE7\xB4\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA7"],

        ["\xE5\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB2"],
        ["\xE7\xB4\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA8"],

        ["\xE5\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xBF"],
        ["\xE7\xB4\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xA9"],

        ["\xE5\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4\xB5"],
        ["\xE7\xB4\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAA"],

        ["\xE5\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x86"],
        ["\xE7\xB5\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAB"],

        ["\xE5\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB3"],
        ["\xE7\xB5\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAC"],

        ["\xE5\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x96"],
        ["\xE7\xB5\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAD"],

        ["\xE5\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8E"],
        ["\xE7\xB5\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAE"],

        ["\xE5\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xB2"],
        ["\xE7\xB5\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xAF"],

        ["\xE5\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA8"],
        ["\xE7\xB5\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB0"],

        ["\xE5\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xAE"],
        ["\xE7\xB5\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB1"],

        ["\xE5\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x8F"],
        ["\xE7\xB5\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],

        ["\xE5\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xA3"],
        ["\xE7\xB5\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB3"],

        ["\xE5\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x93"],
        ["\xE7\xB6\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB4"],

        ["\xE5\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x89"],
        ["\xE7\xB6\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB5"],

        ["\xE5\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\x9B"],
        ["\xE7\xB5\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB6"],

        ["\xE5\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x8F"],
        ["\xE7\xB6\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB7"],

        ["\xE5\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5\xBD"],
        ["\xE7\xB5\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB8"],

        ["\xE5\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9B"],
        ["\xE7\xB6\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xB9"],

        ["\xE5\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBA"],
        ["\xE7\xB6\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBA"],

        ["\xE5\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAE"],
        ["\xE7\xB6\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBB"],

        ["\xE5\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA3"],
        ["\xE7\xB6\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBC"],

        ["\xE5\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB5"],
        ["\xE7\xB6\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBD"],

        ["\xE5\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x87"],
        ["\xE7\xB7\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBE"],

        ["\xE5\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xBD"],
        ["\xE7\xB6\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xBF"],

        ["\xE5\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAB"],
        ["\xE7\xB6\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC0"],

        ["\xE5\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBD"],
        ["\xE7\xB8\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC1"],

        ["\xE5\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xA2"],
        ["\xE7\xB6\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC2"],

        ["\xE5\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xAF"],
        ["\xE7\xB6\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC3"],

        ["\xE5\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9C"],
        ["\xE7\xB7\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC4"],

        ["\xE5\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB8"],
        ["\xE7\xB6\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC5"],

        ["\xE5\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\x9F"],
        ["\xE7\xB6\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC6"],

        ["\xE5\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6\xB0"],
        ["\xE7\xB6\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC7"],

        ["\xE5\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x98"],
        ["\xE7\xB7\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC8"],

        ["\xE5\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9D"],
        ["\xE7\xB7\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xC9"],

        ["\xE5\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA4"],
        ["\xE7\xB7\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCA"],

        ["\xE5\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x9E"],
        ["\xE7\xB7\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCB"],

        ["\xE5\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xBB"],
        ["\xE7\xB7\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCC"],

        ["\xE5\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xB2"],
        ["\xE7\xB7\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCD"],

        ["\xE5\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\xA1"],
        ["\xE7\xB7\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCE"],

        ["\xE5\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x85"],
        ["\xE7\xB8\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xCF"],

        ["\xE5\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x8A"],
        ["\xE7\xB8\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD0"],

        ["\xE5\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA3"],
        ["\xE7\xB8\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD1"],

        ["\xE5\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA1"],
        ["\xE7\xB8\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD2"],

        ["\xE5\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x92"],
        ["\xE7\xB8\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD3"],

        ["\xE5\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB1"],
        ["\xE7\xB8\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD4"],

        ["\xE5\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x9F"],
        ["\xE7\xB8\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD5"],

        ["\xE5\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x89"],
        ["\xE7\xB8\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD6"],

        ["\xE5\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\x8B"],
        ["\xE7\xB8\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD7"],

        ["\xE5\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xA2"],
        ["\xE7\xB8\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD8"],

        ["\xE5\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x86"],
        ["\xE7\xB9\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xD9"],

        ["\xE5\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA6"],
        ["\xE7\xB9\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDA"],

        ["\xE5\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBB"],
        ["\xE7\xB8\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDB"],

        ["\xE5\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB5"],
        ["\xE7\xB8\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDC"],

        ["\xE5\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB9"],
        ["\xE7\xB8\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDD"],

        ["\xE5\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x83"],
        ["\xE7\xB9\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDE"],

        ["\xE5\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB7"],
        ["\xE7\xB8\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xDF"],

        ["\xE5\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xB2"],
        ["\xE7\xB8\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE0"],

        ["\xE5\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8\xBA"],
        ["\xE7\xB8\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE1"],

        ["\xE5\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA7"],
        ["\xE7\xB9\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE2"],

        ["\xE5\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9D"],
        ["\xE7\xB9\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE3"],

        ["\xE5\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x96"],
        ["\xE7\xB9\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE4"],

        ["\xE5\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9E"],
        ["\xE7\xB9\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE5"],

        ["\xE5\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x99"],
        ["\xE7\xB9\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE6"],

        ["\xE5\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\x9A"],
        ["\xE7\xB9\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE7"],

        ["\xE5\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xB9"],
        ["\xE7\xB9\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE8"],

        ["\xE5\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xAA"],
        ["\xE7\xB9\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xE9"],

        ["\xE5\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xA9"],
        ["\xE7\xB9\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEA"],

        ["\xE5\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBC"],
        ["\xE7\xB9\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEB"],

        ["\xE5\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBB"],
        ["\xE7\xB9\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEC"],

        ["\xE5\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x83"],
        ["\xE7\xBA\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xED"],

        ["\xE5\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7\x95"],
        ["\xE7\xB7\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEE"],

        ["\xE5\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBD"],
        ["\xE7\xB9\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],

        ["\xE5\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAE"],
        ["\xE8\xBE\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF0"],

        ["\xE5\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9\xBF"],
        ["\xE7\xB9\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF1"],

        ["\xE5\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x88"],
        ["\xE7\xBA\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF2"],

        ["\xE5\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x89"],
        ["\xE7\xBA\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF3"],

        ["\xE5\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8C"],
        ["\xE7\xBA\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF4"],

        ["\xE5\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x92"],
        ["\xE7\xBA\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF5"],

        ["\xE5\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x90"],
        ["\xE7\xBA\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF6"],

        ["\xE5\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x93"],
        ["\xE7\xBA\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF7"],

        ["\xE5\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x94"],
        ["\xE7\xBA\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF8"],

        ["\xE5\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x96"],
        ["\xE7\xBA\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xF9"],

        ["\xE5\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x8E"],
        ["\xE7\xBA\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xFA"],

        ["\xE5\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x9B"],
        ["\xE7\xBA\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xFB"],

        ["\xE5\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA\x9C"],
        ["\xE7\xBA\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xFC"],

        ["\xE5\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xB8"],
        ["\xE7\xBC\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xFD"],

        ["\xE5\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC\xBA"],
        ["\xE7\xBC\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE5\xFE"],

        ["\xE6\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x85"],
        ["\xE7\xBD\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA1"],

        ["\xE6\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8C"],
        ["\xE7\xBD\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA2"],

        ["\xE6\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8D"],
        ["\xE7\xBD\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA3"],

        ["\xE6\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x8E"],
        ["\xE7\xBD\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA4"],

        ["\xE6\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x90"],
        ["\xE7\xBD\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA5"],

        ["\xE6\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x91"],
        ["\xE7\xBD\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],

        ["\xE6\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x95"],
        ["\xE7\xBD\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],

        ["\xE6\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x94"],
        ["\xE7\xBD\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],

        ["\xE6\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x98"],
        ["\xE7\xBD\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],

        ["\xE6\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\x9F"],
        ["\xE7\xBD\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAA"],

        ["\xE6\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA0"],
        ["\xE7\xBD\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAB"],

        ["\xE6\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA8"],
        ["\xE7\xBD\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],

        ["\xE6\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA9"],
        ["\xE7\xBD\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAD"],

        ["\xE6\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xA7"],
        ["\xE7\xBD\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],

        ["\xE6\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD\xB8"],
        ["\xE7\xBD\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],

        ["\xE6\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x82"],
        ["\xE7\xBE\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB0"],

        ["\xE6\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x86"],
        ["\xE7\xBE\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB1"],

        ["\xE6\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x83"],
        ["\xE7\xBE\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB2"],

        ["\xE6\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x88"],
        ["\xE7\xBE\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],

        ["\xE6\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x87"],
        ["\xE7\xBE\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],

        ["\xE6\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x8C"],
        ["\xE7\xBE\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],

        ["\xE6\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x94"],
        ["\xE7\xBE\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB6"],

        ["\xE6\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9E"],
        ["\xE7\xBE\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB7"],

        ["\xE6\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9D"],
        ["\xE7\xBE\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],

        ["\xE6\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\x9A"],
        ["\xE7\xBE\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],

        ["\xE6\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xA3"],
        ["\xE7\xBE\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],

        ["\xE6\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xAF"],
        ["\xE7\xBE\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBB"],

        ["\xE6\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB2"],
        ["\xE7\xBE\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBC"],

        ["\xE6\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB9"],
        ["\xE7\xBE\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBD"],

        ["\xE6\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xAE"],
        ["\xE7\xBE\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBE"],

        ["\xE6\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB6"],
        ["\xE7\xBE\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF"],

        ["\xE6\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE\xB8"],
        ["\xE7\xBE\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC0"],

        ["\xE6\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB1"],
        ["\xE8\xAD\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC1"],

        ["\xE6\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x85"],
        ["\xE7\xBF\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC2"],

        ["\xE6\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x86"],
        ["\xE7\xBF\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC3"],

        ["\xE6\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x8A"],
        ["\xE7\xBF\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC4"],

        ["\xE6\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x95"],
        ["\xE7\xBF\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC5"],

        ["\xE6\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\x94"],
        ["\xE7\xBF\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC6"],

        ["\xE6\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA1"],
        ["\xE7\xBF\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC7"],

        ["\xE6\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA6"],
        ["\xE7\xBF\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC8"],

        ["\xE6\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xA9"],
        ["\xE7\xBF\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xC9"],

        ["\xE6\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB3"],
        ["\xE7\xBF\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCA"],

        ["\xE6\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF\xB9"],
        ["\xE7\xBF\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCB"],

        ["\xE6\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x9C"],
        ["\xE9\xA3\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCC"],

        ["\xE6\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x86"],
        ["\xE8\x80\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCD"],

        ["\xE6\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x84"],
        ["\xE8\x80\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCE"],

        ["\xE6\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x8B"],
        ["\xE8\x80\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],

        ["\xE6\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x92"],
        ["\xE8\x80\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],

        ["\xE6\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x98"],
        ["\xE8\x80\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],

        ["\xE6\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x99"],
        ["\xE8\x80\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],

        ["\xE6\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\x9C"],
        ["\xE8\x80\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD3"],

        ["\xE6\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA1"],
        ["\xE8\x80\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD4"],

        ["\xE6\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xA8"],
        ["\xE8\x80\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD5"],

        ["\xE6\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBF"],
        ["\xE8\x80\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD6"],

        ["\xE6\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x80\xBB"],
        ["\xE8\x80\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD7"],

        ["\xE6\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x8A"],
        ["\xE8\x81\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],

        ["\xE6\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x86"],
        ["\xE8\x81\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],

        ["\xE6\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x92"],
        ["\xE8\x81\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],

        ["\xE6\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x98"],
        ["\xE8\x81\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],

        ["\xE6\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9A"],
        ["\xE8\x81\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],

        ["\xE6\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\x9F"],
        ["\xE8\x81\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],

        ["\xE6\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA2"],
        ["\xE8\x81\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDE"],

        ["\xE6\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xA8"],
        ["\xE8\x81\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xDF"],

        ["\xE6\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB3"],
        ["\xE8\x81\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE0"],

        ["\xE6\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB2"],
        ["\xE8\x81\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE1"],

        ["\xE6\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB0"],
        ["\xE8\x81\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE2"],

        ["\xE6\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB6"],
        ["\xE8\x81\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE3"],

        ["\xE6\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xB9"],
        ["\xE8\x81\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE4"],

        ["\xE6\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBD"],
        ["\xE8\x81\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE5"],

        ["\xE6\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x81\xBF"],
        ["\xE8\x81\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE6"],

        ["\xE6\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x84"],
        ["\xE8\x82\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE7"],

        ["\xE6\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x86"],
        ["\xE8\x82\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE8"],

        ["\xE6\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x85"],
        ["\xE8\x82\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xE9"],

        ["\xE6\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9B"],
        ["\xE8\x82\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEA"],

        ["\xE6\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x93"],
        ["\xE8\x82\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEB"],

        ["\xE6\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\x9A"],
        ["\xE8\x82\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEC"],

        ["\xE6\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAD"],
        ["\xE8\x82\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xED"],

        ["\xE6\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x86\x90"],
        ["\xE5\x86\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEE"],

        ["\xE6\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x82\xAC"],
        ["\xE8\x82\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],

        ["\xE6\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9B"],
        ["\xE8\x83\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF0"],

        ["\xE6\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xA5"],
        ["\xE8\x83\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF1"],

        ["\xE6\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x99"],
        ["\xE8\x83\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF2"],

        ["\xE6\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9D"],
        ["\xE8\x83\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF3"],

        ["\xE6\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x84"],
        ["\xE8\x83\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF4"],

        ["\xE6\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x9A"],
        ["\xE8\x83\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF5"],

        ["\xE6\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\x96"],
        ["\xE8\x83\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],

        ["\xE6\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x89"],
        ["\xE8\x84\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF7"],

        ["\xE6\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xAF"],
        ["\xE8\x83\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF8"],

        ["\xE6\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xB1"],
        ["\xE8\x83\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xF9"],

        ["\xE6\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\x9B"],
        ["\xE8\x84\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xFA"],

        ["\xE6\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xA9"],
        ["\xE8\x84\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xFB"],

        ["\xE6\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xA3"],
        ["\xE8\x84\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xFC"],

        ["\xE6\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xAF"],
        ["\xE8\x84\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xFD"],

        ["\xE6\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x8B"],
        ["\xE8\x85\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE6\xFE"],

        ["\xE7\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8B"],
        ["\xE9\x9A\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA1"],

        ["\xE7\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x86"],
        ["\xE8\x85\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA2"],

        ["\xE7\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x84\xBE"],
        ["\xE8\x84\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA3"],

        ["\xE7\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x93"],
        ["\xE8\x85\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA4"],

        ["\xE7\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x91"],
        ["\xE8\x85\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA5"],

        ["\xE7\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x83\xBC"],
        ["\xE8\x83\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA6"],

        ["\xE7\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB1"],
        ["\xE8\x85\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA7"],

        ["\xE7\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xAE"],
        ["\xE8\x85\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA8"],

        ["\xE7\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA5"],
        ["\xE8\x85\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xA9"],

        ["\xE7\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xA6"],
        ["\xE8\x85\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],

        ["\xE7\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\xB4"],
        ["\xE8\x85\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB"],

        ["\xE7\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x83"],
        ["\xE8\x86\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAC"],

        ["\xE7\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x88"],
        ["\xE8\x86\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAD"],

        ["\xE7\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x8A"],
        ["\xE8\x86\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAE"],

        ["\xE7\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x80"],
        ["\xE8\x86\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],

        ["\xE7\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x82"],
        ["\xE8\x86\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],

        ["\xE7\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA0"],
        ["\xE8\x86\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],

        ["\xE7\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x95"],
        ["\xE8\x86\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],

        ["\xE7\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA4"],
        ["\xE8\x86\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],

        ["\xE7\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA3"],
        ["\xE8\x86\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],

        ["\xE7\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x85\x9F"],
        ["\xE8\x85\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],

        ["\xE7\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\x93"],
        ["\xE8\x86\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],

        ["\xE7\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xA9"],
        ["\xE8\x86\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],

        ["\xE7\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB0"],
        ["\xE8\x86\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],

        ["\xE7\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB5"],
        ["\xE8\x86\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],

        ["\xE7\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBE"],
        ["\xE8\x86\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],

        ["\xE7\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xB8"],
        ["\xE8\x86\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],

        ["\xE7\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBD"],
        ["\xE8\x86\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],

        ["\xE7\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x80"],
        ["\xE8\x87\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],

        ["\xE7\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x82"],
        ["\xE8\x87\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],

        ["\xE7\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x86\xBA"],
        ["\xE8\x86\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],

        ["\xE7\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x89"],
        ["\xE8\x87\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],

        ["\xE7\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x8D"],
        ["\xE8\x87\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],

        ["\xE7\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x91"],
        ["\xE8\x87\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],

        ["\xE7\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x99"],
        ["\xE8\x87\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],

        ["\xE7\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x98"],
        ["\xE8\x87\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],

        ["\xE7\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x88"],
        ["\xE8\x87\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],

        ["\xE7\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x9A"],
        ["\xE8\x87\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],

        ["\xE7\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\x9F"],
        ["\xE8\x87\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],

        ["\xE7\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA0"],
        ["\xE8\x87\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],

        ["\xE7\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xA7"],
        ["\xE8\x87\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],

        ["\xE7\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBA"],
        ["\xE8\x87\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],

        ["\xE7\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBB"],
        ["\xE8\x87\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],

        ["\xE7\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x87\xBE"],
        ["\xE8\x87\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],

        ["\xE7\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x81"],
        ["\xE8\x88\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCD"],

        ["\xE7\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x82"],
        ["\xE8\x88\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCE"],

        ["\xE7\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x85"],
        ["\xE8\x88\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xCF"],

        ["\xE7\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x87"],
        ["\xE8\x88\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD0"],

        ["\xE7\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8A"],
        ["\xE8\x88\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD1"],

        ["\xE7\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x8D"],
        ["\xE8\x88\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD2"],

        ["\xE7\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x90"],
        ["\xE8\x88\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD3"],

        ["\xE7\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\x96"],
        ["\xE8\x88\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD4"],

        ["\xE7\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xA9"],
        ["\xE8\x88\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD5"],

        ["\xE7\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAB"],
        ["\xE8\x88\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD6"],

        ["\xE7\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB8"],
        ["\xE8\x88\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD7"],

        ["\xE7\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xB3"],
        ["\xE8\x88\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD8"],

        ["\xE7\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x80"],
        ["\xE8\x89\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xD9"],

        ["\xE7\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x99"],
        ["\xE8\x89\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDA"],

        ["\xE7\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x98"],
        ["\xE8\x89\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDB"],

        ["\xE7\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9D"],
        ["\xE8\x89\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDC"],

        ["\xE7\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9A"],
        ["\xE8\x89\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDD"],

        ["\xE7\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\x9F"],
        ["\xE8\x89\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDE"],

        ["\xE7\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA4"],
        ["\xE8\x89\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xDF"],

        ["\xE7\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA2"],
        ["\xE8\x89\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE0"],

        ["\xE7\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xA8"],
        ["\xE8\x89\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE1"],

        ["\xE7\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAA"],
        ["\xE8\x89\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE2"],

        ["\xE7\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xAB"],
        ["\xE8\x89\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE3"],

        ["\xE7\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x88\xAE"],
        ["\xE8\x88\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE4"],

        ["\xE7\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB1"],
        ["\xE8\x89\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE5"],

        ["\xE7\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB7"],
        ["\xE8\x89\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE6"],

        ["\xE7\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xB8"],
        ["\xE8\x89\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE7"],

        ["\xE7\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x89\xBE"],
        ["\xE8\x89\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE8"],

        ["\xE7\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x8D"],
        ["\xE8\x8A\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xE9"],

        ["\xE7\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x92"],
        ["\xE8\x8A\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEA"],

        ["\xE7\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAB"],
        ["\xE8\x8A\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEB"],

        ["\xE7\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\x9F"],
        ["\xE8\x8A\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEC"],

        ["\xE7\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xBB"],
        ["\xE8\x8A\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xED"],

        ["\xE7\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8A\xAC"],
        ["\xE8\x8A\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEE"],

        ["\xE7\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA1"],
        ["\xE8\x8B\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xEF"],

        ["\xE7\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xA3"],
        ["\xE8\x8B\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF0"],

        ["\xE7\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9F"],
        ["\xE8\x8B\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF1"],

        ["\xE7\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x92"],
        ["\xE8\x8B\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF2"],

        ["\xE7\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB4"],
        ["\xE8\x8B\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF3"],

        ["\xE7\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB3"],
        ["\xE8\x8B\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF4"],

        ["\xE7\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xBA"],
        ["\xE8\x8B\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF5"],

        ["\xE7\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x93"],
        ["\xE8\x8E\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF6"],

        ["\xE7\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x83"],
        ["\xE8\x8C\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF7"],

        ["\xE7\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xBB"],
        ["\xE8\x8B\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF8"],

        ["\xE7\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\xB9"],
        ["\xE8\x8B\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xF9"],

        ["\xE7\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9E"],
        ["\xE8\x8B\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xFA"],

        ["\xE7\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x86"],
        ["\xE8\x8C\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xFB"],

        ["\xE7\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x9C"],
        ["\xE8\x8B\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xFC"],

        ["\xE7\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x89"],
        ["\xE8\x8C\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xFD"],

        ["\xE7\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8B\x99"],
        ["\xE8\x8B\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE7\xFE"],

        ["\xE8\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB5"],
        ["\xE8\x8C\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1"],

        ["\xE8\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB4"],
        ["\xE8\x8C\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2"],

        ["\xE8\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x96"],
        ["\xE8\x8C\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3"],

        ["\xE8\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB2"],
        ["\xE8\x8C\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4"],

        ["\xE8\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB1"],
        ["\xE8\x8C\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5"],

        ["\xE8\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x80"],
        ["\xE8\x8D\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6"],

        ["\xE8\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xB9"],
        ["\xE8\x8C\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7"],

        ["\xE8\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x90"],
        ["\xE8\x8D\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8"],

        ["\xE8\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\x85"],
        ["\xE8\x8D\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9"],

        ["\xE8\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xAF"],
        ["\xE8\x8C\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],

        ["\xE8\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xAB"],
        ["\xE8\x8C\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],

        ["\xE8\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x97"],
        ["\xE8\x8C\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC"],

        ["\xE8\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\x98"],
        ["\xE8\x8C\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD"],

        ["\xE8\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x85"],
        ["\xE8\x8E\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],

        ["\xE8\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9A"],
        ["\xE8\x8E\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xAF"],

        ["\xE8\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xAA"],
        ["\xE8\x8E\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0"],

        ["\xE8\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x9F"],
        ["\xE8\x8E\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1"],

        ["\xE8\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA2"],
        ["\xE8\x8E\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],

        ["\xE8\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x96"],
        ["\xE8\x8E\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3"],

        ["\xE8\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C\xA3"],
        ["\xE8\x8C\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4"],

        ["\xE8\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x8E"],
        ["\xE8\x8E\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5"],

        ["\xE8\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x87"],
        ["\xE8\x8E\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6"],

        ["\xE8\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x8A"],
        ["\xE8\x8E\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7"],

        ["\xE8\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xBC"],
        ["\xE8\x8D\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],

        ["\xE8\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xB5"],
        ["\xE8\x8E\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9"],

        ["\xE8\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB3"],
        ["\xE8\x8D\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA"],

        ["\xE8\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8D\xB5"],
        ["\xE8\x8D\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB"],

        ["\xE8\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA0"],
        ["\xE8\x8E\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC"],

        ["\xE8\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\x89"],
        ["\xE8\x8E\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD"],

        ["\xE8\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xA8"],
        ["\xE8\x8E\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE"],

        ["\xE8\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB4"],
        ["\xE8\x8F\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF"],

        ["\xE8\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x93"],
        ["\xE8\x90\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC0"],

        ["\xE8\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xAB"],
        ["\xE8\x8F\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC1"],

        ["\xE8\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x8E"],
        ["\xE8\x8F\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC2"],

        ["\xE8\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xBD"],
        ["\xE8\x8F\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC3"],

        ["\xE8\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x83"],
        ["\xE8\x90\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC4"],

        ["\xE8\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x98"],
        ["\xE8\x8F\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC5"],

        ["\xE8\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8B"],
        ["\xE8\x90\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC6"],

        ["\xE8\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\x81"],
        ["\xE8\x8F\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC7"],

        ["\xE8\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB7"],
        ["\xE8\x8F\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC8"],

        ["\xE8\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x87"],
        ["\xE8\x90\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xC9"],

        ["\xE8\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xA0"],
        ["\xE8\x8F\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCA"],

        ["\xE8\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xB2"],
        ["\xE8\x8F\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCB"],

        ["\xE8\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\x8D"],
        ["\xE8\x90\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCC"],

        ["\xE8\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA2"],
        ["\xE8\x90\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCD"],

        ["\xE8\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xA0"],
        ["\xE8\x90\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCE"],

        ["\xE8\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8E\xBD"],
        ["\xE8\x8E\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xCF"],

        ["\xE8\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB8"],
        ["\xE8\x90\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD0"],

        ["\xE8\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x86"],
        ["\xE8\x94\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD1"],

        ["\xE8\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x8F\xBB"],
        ["\xE8\x8F\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD2"],

        ["\xE8\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAD"],
        ["\xE8\x91\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD3"],

        ["\xE8\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xAA"],
        ["\xE8\x90\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD4"],

        ["\xE8\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xBC"],
        ["\xE8\x90\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD5"],

        ["\xE8\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x9A"],
        ["\xE8\x95\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD6"],

        ["\xE8\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x84"],
        ["\xE8\x92\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD7"],

        ["\xE8\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB7"],
        ["\xE8\x91\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],

        ["\xE8\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAB"],
        ["\xE8\x91\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],

        ["\xE8\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xAD"],
        ["\xE8\x92\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],

        ["\xE8\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAE"],
        ["\xE8\x91\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],

        ["\xE8\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x82"],
        ["\xE8\x92\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDC"],

        ["\xE8\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA9"],
        ["\xE8\x91\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDD"],

        ["\xE8\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\x86"],
        ["\xE8\x91\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDE"],

        ["\xE8\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xAC"],
        ["\xE8\x90\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xDF"],

        ["\xE8\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xAF"],
        ["\xE8\x91\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE0"],

        ["\xE8\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xB9"],
        ["\xE8\x91\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE1"],

        ["\xE8\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x90\xB5"],
        ["\xE8\x90\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE2"],

        ["\xE8\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8A"],
        ["\xE8\x93\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE3"],

        ["\xE8\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x91\xA2"],
        ["\xE8\x91\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE4"],

        ["\xE8\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xB9"],
        ["\xE8\x92\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE5"],

        ["\xE8\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBF"],
        ["\xE8\x92\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE6"],

        ["\xE8\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\x9F"],
        ["\xE8\x92\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE7"],

        ["\xE8\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x99"],
        ["\xE8\x93\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE8"],

        ["\xE8\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x8D"],
        ["\xE8\x93\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xE9"],

        ["\xE8\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xBB"],
        ["\xE8\x92\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEA"],

        ["\xE8\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x9A"],
        ["\xE8\x93\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],

        ["\xE8\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x90"],
        ["\xE8\x93\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],

        ["\xE8\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x81"],
        ["\xE8\x93\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xED"],

        ["\xE8\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x86"],
        ["\xE8\x93\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEE"],

        ["\xE8\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\x96"],
        ["\xE8\x93\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xEF"],

        ["\xE8\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x92\xA1"],
        ["\xE8\x92\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF0"],

        ["\xE8\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xA1"],
        ["\xE8\x94\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF1"],

        ["\xE8\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xBF"],
        ["\xE8\x93\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF2"],

        ["\xE8\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xB4"],
        ["\xE8\x93\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF3"],

        ["\xE8\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x97"],
        ["\xE8\x94\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF4"],

        ["\xE8\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x98"],
        ["\xE8\x94\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF5"],

        ["\xE8\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\xAC"],
        ["\xE8\x94\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF6"],

        ["\xE8\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x9F"],
        ["\xE8\x94\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF7"],

        ["\xE8\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x95"],
        ["\xE8\x94\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF8"],

        ["\xE8\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x94\x94"],
        ["\xE8\x94\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],

        ["\xE8\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x93\xBC"],
        ["\xE8\x93\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],

        ["\xE8\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x80"],
        ["\xE8\x95\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],

        ["\xE8\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xA3"],
        ["\xE8\x95\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFC"],

        ["\xE8\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x98"],
        ["\xE8\x95\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFD"],

        ["\xE8\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x88"],
        ["\xE8\x95\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE8\xFE"],

        ["\xE9\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x81"],
        ["\xE8\x95\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1"],

        ["\xBC\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x82"],
        ["\xE8\x98\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBC\xC9"],

        ["\xE9\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x8B"],
        ["\xE8\x95\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3"],

        ["\xE9\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\x95"],
        ["\xE8\x95\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4"],

        ["\xE9\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x80"],
        ["\xE8\x96\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5"],

        ["\xE9\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA4"],
        ["\xE8\x96\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6"],

        ["\xE9\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x88"],
        ["\xE8\x96\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7"],

        ["\xE9\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x91"],
        ["\xE8\x96\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8"],

        ["\xE9\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x8A"],
        ["\xE8\x96\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9"],

        ["\xE9\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xA8"],
        ["\xE8\x96\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA"],

        ["\xE9\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xAD"],
        ["\xE8\x95\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB"],

        ["\xE9\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x94"],
        ["\xE8\x96\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC"],

        ["\xE9\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x9B"],
        ["\xE8\x96\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD"],

        ["\xCC\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xAA"],
        ["\xE8\x97\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xCC\xF9"],

        ["\xE9\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x87"],
        ["\xE8\x96\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF"],

        ["\xE9\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x9C"],
        ["\xE8\x96\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0"],

        ["\xE9\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xB7"],
        ["\xE8\x95\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1"],

        ["\xE9\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x95\xBE"],
        ["\xE8\x95\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB2"],

        ["\xE9\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\x90"],
        ["\xE8\x96\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3"],

        ["\xE9\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x89"],
        ["\xE8\x97\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4"],

        ["\xE9\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xBA"],
        ["\xE8\x96\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5"],

        ["\xE9\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x8F"],
        ["\xE8\x97\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6"],

        ["\xE9\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x96\xB9"],
        ["\xE8\x96\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7"],

        ["\xE9\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x90"],
        ["\xE8\x97\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8"],

        ["\xE9\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x95"],
        ["\xE8\x97\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9"],

        ["\xE9\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x9D"],
        ["\xE8\x97\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA"],

        ["\xE9\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xA5"],
        ["\xE8\x97\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBB"],

        ["\xE9\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\x9C"],
        ["\xE8\x97\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBC"],

        ["\xE9\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xB9"],
        ["\xE8\x97\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD"],

        ["\xE9\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x8A"],
        ["\xE8\x98\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBE"],

        ["\xE9\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x93"],
        ["\xE8\x98\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xBF"],

        ["\xE9\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x8B"],
        ["\xE8\x98\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC0"],

        ["\xE9\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBE"],
        ["\xE8\x97\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC1"],

        ["\xE9\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x97\xBA"],
        ["\xE8\x97\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC2"],

        ["\xE9\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x86"],
        ["\xE8\x98\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC3"],

        ["\xE9\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xA2"],
        ["\xE8\x98\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC4"],

        ["\xE9\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\x9A"],
        ["\xE8\x98\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC5"],

        ["\xE9\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xB0"],
        ["\xE8\x98\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC6"],

        ["\xE9\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x98\xBF"],
        ["\xE8\x98\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC7"],

        ["\xE9\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x8D"],
        ["\xE8\x99\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC8"],

        ["\xE9\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE4\xB9\x95"],
        ["\xE4\xB9\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xC9"],

        ["\xE9\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x94"],
        ["\xE8\x99\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCA"],

        ["\xE9\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\x9F"],
        ["\xE8\x99\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCB"],

        ["\xE9\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xA7"],
        ["\xE8\x99\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCC"],

        ["\xE9\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x99\xB1"],
        ["\xE8\x99\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCD"],

        ["\xE9\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x93"],
        ["\xE8\x9A\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCE"],

        ["\xE9\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA3"],
        ["\xE8\x9A\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xCF"],

        ["\xE9\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xA9"],
        ["\xE8\x9A\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD0"],

        ["\xE9\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAA"],
        ["\xE8\x9A\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD1"],

        ["\xE9\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8B"],
        ["\xE8\x9A\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD2"],

        ["\xE9\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\x8C"],
        ["\xE8\x9A\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD3"],

        ["\xE9\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB6"],
        ["\xE8\x9A\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD4"],

        ["\xE9\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAF"],
        ["\xE8\x9A\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD5"],

        ["\xE9\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x84"],
        ["\xE8\x9B\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD6"],

        ["\xE9\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x86"],
        ["\xE8\x9B\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD7"],

        ["\xE9\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xB0"],
        ["\xE8\x9A\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD8"],

        ["\xE9\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x89"],
        ["\xE8\x9B\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xD9"],

        ["\xB3\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA3"],
        ["\xE8\xA0\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB3\xC2"],

        ["\xE9\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9A\xAB"],
        ["\xE8\x9A\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDB"],

        ["\xE9\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x94"],
        ["\xE8\x9B\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDC"],

        ["\xE9\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9E"],
        ["\xE8\x9B\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDD"],

        ["\xE9\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xA9"],
        ["\xE8\x9B\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDE"],

        ["\xE9\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAC"],
        ["\xE8\x9B\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xDF"],

        ["\xE9\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9F"],
        ["\xE8\x9B\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE0"],

        ["\xE9\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\x9B"],
        ["\xE8\x9B\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE1"],

        ["\xE9\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xAF"],
        ["\xE8\x9B\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE2"],

        ["\xE9\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x92"],
        ["\xE8\x9C\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE3"],

        ["\xE9\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x86"],
        ["\xE8\x9C\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE4"],

        ["\xE9\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x88"],
        ["\xE8\x9C\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE5"],

        ["\xE9\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x80"],
        ["\xE8\x9C\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE6"],

        ["\xE9\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x83"],
        ["\xE8\x9C\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE7"],

        ["\xE9\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xBB"],
        ["\xE8\x9B\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE8"],

        ["\xE9\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x91"],
        ["\xE8\x9C\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xE9"],

        ["\xE9\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x89"],
        ["\xE8\x9C\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEA"],

        ["\xE9\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x8D"],
        ["\xE8\x9C\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEB"],

        ["\xE9\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9B\xB9"],
        ["\xE8\x9B\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEC"],

        ["\xE9\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x8A"],
        ["\xE8\x9C\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xED"],

        ["\xE9\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xB4"],
        ["\xE8\x9C\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEE"],

        ["\xE9\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xBF"],
        ["\xE8\x9C\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xEF"],

        ["\xE9\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xB7"],
        ["\xE8\x9C\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF0"],

        ["\xE9\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xBB"],
        ["\xE8\x9C\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF1"],

        ["\xE9\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xA5"],
        ["\xE8\x9C\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF2"],

        ["\xE9\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\xA9"],
        ["\xE8\x9C\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],

        ["\xE9\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C\x9A"],
        ["\xE8\x9C\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF4"],

        ["\xE9\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA0"],
        ["\xE8\x9D\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF5"],

        ["\xE9\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x9F"],
        ["\xE8\x9D\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF6"],

        ["\xE9\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB8"],
        ["\xE8\x9D\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],

        ["\xE9\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8C"],
        ["\xE8\x9D\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],

        ["\xE9\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x8E"],
        ["\xE8\x9D\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xF9"],

        ["\xE9\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xB4"],
        ["\xE8\x9D\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xFA"],

        ["\xE9\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x97"],
        ["\xE8\x9D\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xFB"],

        ["\xE9\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA8"],
        ["\xE8\x9D\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xFC"],

        ["\xE9\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xAE"],
        ["\xE8\x9D\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xFD"],

        ["\xE9\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x99"],
        ["\xE8\x9D\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xE9\xFE"],

        ["\xEA\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\x93"],
        ["\xE8\x9D\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA1"],

        ["\xEA\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xA3"],
        ["\xE8\x9D\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA2"],

        ["\xEA\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9D\xAA"],
        ["\xE8\x9D\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA3"],

        ["\xC7\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x85"],
        ["\xE8\xA0\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC7\xE8"],

        ["\xEA\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xA2"],
        ["\xE8\x9E\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA5"],

        ["\xEA\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x9F"],
        ["\xE8\x9E\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA6"],

        ["\xEA\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\x82"],
        ["\xE8\x9E\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA7"],

        ["\xEA\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xAF"],
        ["\xE8\x9E\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA8"],

        ["\xEA\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x8B"],
        ["\xE8\x9F\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xA9"],

        ["\xEA\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBD"],
        ["\xE8\x9E\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xAA"],

        ["\xEA\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x80"],
        ["\xE8\x9F\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xAB"],

        ["\xEA\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x90"],
        ["\xE8\x9F\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xAC"],

        ["\xEA\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x96"],
        ["\xE9\x9B\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xAD"],

        ["\xEA\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xAB"],
        ["\xE8\x9E\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xAE"],

        ["\xEA\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x84"],
        ["\xE8\x9F\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xAF"],

        ["\xEA\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xB3"],
        ["\xE8\x9E\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB0"],

        ["\xEA\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x87"],
        ["\xE8\x9F\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB1"],

        ["\xEA\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x86"],
        ["\xE8\x9F\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB2"],

        ["\xEA\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9E\xBB"],
        ["\xE8\x9E\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB3"],

        ["\xEA\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xAF"],
        ["\xE8\x9F\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB4"],

        ["\xEA\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB2"],
        ["\xE8\x9F\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB5"],

        ["\xEA\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xA0"],
        ["\xE8\x9F\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB6"],

        ["\xEA\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8F"],
        ["\xE8\xA0\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB7"],

        ["\xEA\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8D"],
        ["\xE8\xA0\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB8"],

        ["\xEA\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xBE"],
        ["\xE8\x9F\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xB9"],

        ["\xEA\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB6"],
        ["\xE8\x9F\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xBA"],

        ["\xEA\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\xB7"],
        ["\xE8\x9F\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xBB"],

        ["\xEA\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x8E"],
        ["\xE8\xA0\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xBC"],

        ["\xEA\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\x9F\x92"],
        ["\xE8\x9F\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xBD"],

        ["\xEA\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x91"],
        ["\xE8\xA0\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xBE"],

        ["\xEA\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x96"],
        ["\xE8\xA0\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xBF"],

        ["\xEA\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\x95"],
        ["\xE8\xA0\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC0"],

        ["\xEA\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA2"],
        ["\xE8\xA0\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC1"],

        ["\xEA\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA1"],
        ["\xE8\xA0\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC2"],

        ["\xEA\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB1"],
        ["\xE8\xA0\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC3"],

        ["\xEA\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB6"],
        ["\xE8\xA0\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC4"],

        ["\xEA\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xB9"],
        ["\xE8\xA0\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC5"],

        ["\xEA\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xA7"],
        ["\xE8\xA0\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC6"],

        ["\xEA\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA0\xBB"],
        ["\xE8\xA0\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC7"],

        ["\xEA\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x84"],
        ["\xE8\xA1\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC8"],

        ["\xEA\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x82"],
        ["\xE8\xA1\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xC9"],

        ["\xEA\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x92"],
        ["\xE8\xA1\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xCA"],

        ["\xEA\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x99"],
        ["\xE8\xA1\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xCB"],

        ["\xEA\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\x9E"],
        ["\xE8\xA1\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xCC"],

        ["\xEA\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xA2"],
        ["\xE8\xA1\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xCD"],

        ["\xEA\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xAB"],
        ["\xE8\xA1\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xCE"],

        ["\xEA\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x81"],
        ["\xE8\xA2\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xCF"],

        ["\xEA\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBE"],
        ["\xE8\xA1\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD0"],

        ["\xEA\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x9E"],
        ["\xE8\xA2\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD1"],

        ["\xEA\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB5"],
        ["\xE8\xA1\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD2"],

        ["\xEA\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xBD"],
        ["\xE8\xA1\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD3"],

        ["\xEA\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB5"],
        ["\xE8\xA2\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD4"],

        ["\xEA\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA1\xB2"],
        ["\xE8\xA1\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD5"],

        ["\xEA\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x82"],
        ["\xE8\xA2\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD6"],

        ["\xEA\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x97"],
        ["\xE8\xA2\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD7"],

        ["\xEA\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x92"],
        ["\xE8\xA2\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD8"],

        ["\xEA\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xAE"],
        ["\xE8\xA2\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xD9"],

        ["\xEA\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x99"],
        ["\xE8\xA2\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xDA"],

        ["\xEA\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xA2"],
        ["\xE8\xA2\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xDB"],

        ["\xEA\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\x8D"],
        ["\xE8\xA2\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xDC"],

        ["\xEA\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xA4"],
        ["\xE8\xA2\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xDD"],

        ["\xEA\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB0"],
        ["\xE8\xA2\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xDE"],

        ["\xEA\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xBF"],
        ["\xE8\xA2\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xDF"],

        ["\xEA\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA2\xB1"],
        ["\xE8\xA2\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE0"],

        ["\xEA\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x83"],
        ["\xE8\xA3\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE1"],

        ["\xEA\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x84"],
        ["\xE8\xA3\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE2"],

        ["\xEA\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x94"],
        ["\xE8\xA3\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE3"],

        ["\xEA\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x98"],
        ["\xE8\xA3\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE4"],

        ["\xEA\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x99"],
        ["\xE8\xA3\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE5"],

        ["\xEA\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\x9D"],
        ["\xE8\xA3\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE6"],

        ["\xEA\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB9"],
        ["\xE8\xA3\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE7"],

        ["\xEA\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x82"],
        ["\xE8\xA4\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE8"],

        ["\xEA\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xBC"],
        ["\xE8\xA3\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xE9"],

        ["\xEA\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB4"],
        ["\xE8\xA3\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xEA"],

        ["\xEA\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xA8"],
        ["\xE8\xA3\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xEB"],

        ["\xEA\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA3\xB2"],
        ["\xE8\xA3\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xEC"],

        ["\xEA\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x84"],
        ["\xE8\xA4\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xED"],

        ["\xEA\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x8C"],
        ["\xE8\xA4\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xEE"],

        ["\xEA\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x8A"],
        ["\xE8\xA4\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xEF"],

        ["\xEA\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x93"],
        ["\xE8\xA4\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF0"],

        ["\xEA\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x83"],
        ["\xE8\xA5\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF1"],

        ["\xEA\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9E"],
        ["\xE8\xA4\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF2"],

        ["\xEA\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xA5"],
        ["\xE8\xA4\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF3"],

        ["\xEA\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xAA"],
        ["\xE8\xA4\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF4"],

        ["\xEA\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xAB"],
        ["\xE8\xA4\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF5"],

        ["\xEA\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x81"],
        ["\xE8\xA5\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF6"],

        ["\xEA\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x84"],
        ["\xE8\xA5\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF7"],

        ["\xEA\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xBB"],
        ["\xE8\xA4\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF8"],

        ["\xEA\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB6"],
        ["\xE8\xA4\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xF9"],

        ["\xEA\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\xB8"],
        ["\xE8\xA4\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xFA"],

        ["\xEA\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x8C"],
        ["\xE8\xA5\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xFB"],

        ["\xEA\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA4\x9D"],
        ["\xE8\xA4\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xFC"],

        ["\xEA\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA0"],
        ["\xE8\xA5\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xFD"],

        ["\xEA\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x9E"],
        ["\xE8\xA5\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEA\xFE"],

        ["\xEB\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA6"],
        ["\xE8\xA5\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA1"],

        ["\xEB\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xA4"],
        ["\xE8\xA5\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA2"],

        ["\xEB\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAD"],
        ["\xE8\xA5\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA3"],

        ["\xEB\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAA"],
        ["\xE8\xA5\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA4"],

        ["\xEB\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xAF"],
        ["\xE8\xA5\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA5"],

        ["\xEB\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB4"],
        ["\xE8\xA5\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA6"],

        ["\xEB\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xB7"],
        ["\xE8\xA5\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA7"],

        ["\xEB\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\xBE"],
        ["\xE8\xA5\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA8"],

        ["\xEB\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x83"],
        ["\xE8\xA6\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xA9"],

        ["\xEB\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x88"],
        ["\xE8\xA6\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xAA"],

        ["\xEB\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x8A"],
        ["\xE8\xA6\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xAB"],

        ["\xEB\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x93"],
        ["\xE8\xA6\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xAC"],

        ["\xEB\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\x98"],
        ["\xE8\xA6\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xAD"],

        ["\xEB\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA1"],
        ["\xE8\xA6\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xAE"],

        ["\xEB\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA9"],
        ["\xE8\xA6\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xAF"],

        ["\xEB\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xA6"],
        ["\xE8\xA6\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB0"],

        ["\xEB\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAC"],
        ["\xE8\xA6\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB1"],

        ["\xEB\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xAF"],
        ["\xE8\xA6\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB2"],

        ["\xEB\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xB2"],
        ["\xE8\xA6\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB3"],

        ["\xEB\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBA"],
        ["\xE8\xA6\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB4"],

        ["\xEB\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBD"],
        ["\xE8\xA6\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB5"],

        ["\xEB\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA6\xBF"],
        ["\xE8\xA6\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB6"],

        ["\xEB\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x80"],
        ["\xE8\xA7\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB7"],

        ["\xEB\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9A"],
        ["\xE8\xA7\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB8"],

        ["\xEB\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9C"],
        ["\xE8\xA7\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xB9"],

        ["\xEB\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\x9D"],
        ["\xE8\xA7\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xBA"],

        ["\xEB\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xA7"],
        ["\xE8\xA7\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xBB"],

        ["\xEB\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB4"],
        ["\xE8\xA7\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xBC"],

        ["\xEB\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA7\xB8"],
        ["\xE8\xA7\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xBD"],

        ["\xEB\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x83"],
        ["\xE8\xA8\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xBE"],

        ["\xEB\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x96"],
        ["\xE8\xA8\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xBF"],

        ["\xEB\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x90"],
        ["\xE8\xA8\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC0"],

        ["\xEB\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x8C"],
        ["\xE8\xA8\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC1"],

        ["\xEB\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9B"],
        ["\xE8\xA8\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC2"],

        ["\xEB\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\x9D"],
        ["\xE8\xA8\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC3"],

        ["\xEB\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xA5"],
        ["\xE8\xA8\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC4"],

        ["\xEB\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA8\xB6"],
        ["\xE8\xA8\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC5"],

        ["\xEB\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x81"],
        ["\xE8\xA9\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC6"],

        ["\xEB\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x9B"],
        ["\xE8\xA9\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC7"],

        ["\xEB\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x92"],
        ["\xE8\xA9\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC8"],

        ["\xEB\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x86"],
        ["\xE8\xA9\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xC9"],

        ["\xEB\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\x88"],
        ["\xE8\xA9\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xCA"],

        ["\xEB\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xBC"],
        ["\xE8\xA9\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xCB"],

        ["\xEB\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAD"],
        ["\xE8\xA9\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xCC"],

        ["\xEB\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xAC"],
        ["\xE8\xA9\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xCD"],

        ["\xEB\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA9\xA2"],
        ["\xE8\xA9\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xCE"],

        ["\xEB\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x85"],
        ["\xE8\xAA\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xCF"],

        ["\xEB\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x82"],
        ["\xE8\xAA\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD0"],

        ["\xEB\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x84"],
        ["\xE8\xAA\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD1"],

        ["\xEB\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA8"],
        ["\xE8\xAA\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD2"],

        ["\xEB\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA1"],
        ["\xE8\xAA\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD3"],

        ["\xEB\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x91"],
        ["\xE8\xAA\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD4"],

        ["\xEB\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA5"],
        ["\xE8\xAA\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD5"],

        ["\xEB\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA6"],
        ["\xE8\xAA\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD6"],

        ["\xEB\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\x9A"],
        ["\xE8\xAA\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD7"],

        ["\xEB\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA\xA3"],
        ["\xE8\xAA\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD8"],

        ["\xEB\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x84"],
        ["\xE8\xAB\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xD9"],

        ["\xEB\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x8D"],
        ["\xE8\xAB\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xDA"],

        ["\xEB\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x82"],
        ["\xE8\xAB\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xDB"],

        ["\xEB\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9A"],
        ["\xE8\xAB\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xDC"],

        ["\xB4\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xAB"],
        ["\xE8\xAB\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB4\xD2"],

        ["\xEB\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB3"],
        ["\xE8\xAB\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xDE"],

        ["\xEB\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA7"],
        ["\xE8\xAB\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xDF"],

        ["\xEB\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA4"],
        ["\xE8\xAB\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE0"],

        ["\xEB\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB1"],
        ["\xE8\xAB\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE1"],

        ["\xEB\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x94"],
        ["\xE8\xAC\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE2"],

        ["\xEB\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA0"],
        ["\xE8\xAB\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE3"],

        ["\xEB\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA2"],
        ["\xE8\xAB\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE4"],

        ["\xEB\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xB7"],
        ["\xE8\xAB\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE5"],

        ["\xEB\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9E"],
        ["\xE8\xAB\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE6"],

        ["\xEB\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\x9B"],
        ["\xE8\xAB\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE7"],

        ["\xEB\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x8C"],
        ["\xE8\xAC\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE8"],

        ["\xEB\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x87"],
        ["\xE8\xAC\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xE9"],

        ["\xEB\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x9A"],
        ["\xE8\xAC\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xEA"],

        ["\xEB\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB\xA1"],
        ["\xE8\xAB\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xEB"],

        ["\xEB\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x96"],
        ["\xE8\xAC\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xEC"],

        ["\xEB\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x90"],
        ["\xE8\xAC\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xED"],

        ["\xEB\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\x97"],
        ["\xE8\xAC\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xEE"],

        ["\xEB\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA0"],
        ["\xE8\xAC\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xEF"],

        ["\xEB\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xB3"],
        ["\xE8\xAC\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF0"],

        ["\xEB\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xAB"],
        ["\xE9\x9E\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF1"],

        ["\xEB\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA6"],
        ["\xE8\xAC\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF2"],

        ["\xEB\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xAB"],
        ["\xE8\xAC\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF3"],

        ["\xEB\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xBE"],
        ["\xE8\xAC\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF4"],

        ["\xEB\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAC\xA8"],
        ["\xE8\xAC\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF5"],

        ["\xEB\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x81"],
        ["\xE8\xAD\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF6"],

        ["\xEB\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8C"],
        ["\xE8\xAD\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF7"],

        ["\xEB\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8F"],
        ["\xE8\xAD\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF8"],

        ["\xEB\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x8E"],
        ["\xE8\xAD\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xF9"],

        ["\xEB\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x89"],
        ["\xE8\xAD\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xFA"],

        ["\xEB\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x96"],
        ["\xE8\xAD\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xFB"],

        ["\xEB\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9B"],
        ["\xE8\xAD\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xFC"],

        ["\xEB\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9A"],
        ["\xE8\xAD\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xFD"],

        ["\xEB\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAB"],
        ["\xE8\xAD\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEB\xFE"],

        ["\xEC\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\x9F"],
        ["\xE8\xAD\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA1"],

        ["\xEC\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAC"],
        ["\xE8\xAD\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA2"],

        ["\xEC\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xAF"],
        ["\xE8\xAD\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA3"],

        ["\xEC\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xB4"],
        ["\xE8\xAD\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA4"],

        ["\xEC\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAD\xBD"],
        ["\xE8\xAD\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA5"],

        ["\xEC\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x80"],
        ["\xE8\xAE\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA6"],

        ["\xEC\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8C"],
        ["\xE8\xAE\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA7"],

        ["\xEC\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x8E"],
        ["\xE8\xAE\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA8"],

        ["\xEC\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x92"],
        ["\xE8\xAE\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xA9"],

        ["\xEC\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x93"],
        ["\xE8\xAE\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAA"],

        ["\xEC\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x96"],
        ["\xE8\xAE\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAB"],

        ["\xEC\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x99"],
        ["\xE8\xAE\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAC"],

        ["\xEC\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE\x9A"],
        ["\xE8\xAE\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAD"],

        ["\xEC\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xBA"],
        ["\xE8\xB0\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAE"],

        ["\xEC\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x81"],
        ["\xE8\xB1\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xAF"],

        ["\xEC\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB0\xBF"],
        ["\xE8\xB0\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB0"],

        ["\xEC\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x88"],
        ["\xE8\xB1\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB1"],

        ["\xEC\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8C"],
        ["\xE8\xB1\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB2"],

        ["\xEC\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x8E"],
        ["\xE8\xB1\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB3"],

        ["\xEC\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x90"],
        ["\xE8\xB1\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB4"],

        ["\xEC\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\x95"],
        ["\xE8\xB1\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB5"],

        ["\xEC\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xA2"],
        ["\xE8\xB1\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB6"],

        ["\xEC\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xAC"],
        ["\xE8\xB1\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB7"],

        ["\xEC\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xB8"],
        ["\xE8\xB1\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB8"],

        ["\xEC\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xBA"],
        ["\xE8\xB1\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xB9"],

        ["\xEC\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x82"],
        ["\xE8\xB2\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xBA"],

        ["\xEC\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x89"],
        ["\xE8\xB2\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xBB"],

        ["\xEC\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x85"],
        ["\xE8\xB2\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xBC"],

        ["\xEC\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8A"],
        ["\xE8\xB2\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xBD"],

        ["\xEC\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8D"],
        ["\xE8\xB2\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xBE"],

        ["\xEC\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x8E"],
        ["\xE8\xB2\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xBF"],

        ["\xEC\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x94"],
        ["\xE8\xB2\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC0"],

        ["\xEC\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB1\xBC"],
        ["\xE8\xB1\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC1"],

        ["\xEC\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\x98"],
        ["\xE8\xB2\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC2"],

        ["\xEC\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x88\x9D"],
        ["\xE6\x88\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC3"],

        ["\xEC\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAD"],
        ["\xE8\xB2\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC4"],

        ["\xEC\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAA"],
        ["\xE8\xB2\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC5"],

        ["\xEC\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xBD"],
        ["\xE8\xB2\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC6"],

        ["\xEC\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB2"],
        ["\xE8\xB2\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC7"],

        ["\xEC\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB3"],
        ["\xE8\xB2\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC8"],

        ["\xEC\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xAE"],
        ["\xE8\xB2\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xC9"],

        ["\xEC\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2\xB6"],
        ["\xE8\xB2\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xCA"],

        ["\xEC\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x88"],
        ["\xE8\xB3\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xCB"],

        ["\xEC\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x81"],
        ["\xE8\xB3\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xCC"],

        ["\xC1\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA4"],
        ["\xE8\xB3\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC1\xA8"],

        ["\xEC\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xA3"],
        ["\xE8\xB3\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xCE"],

        ["\xEC\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x9A"],
        ["\xE8\xB3\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xCF"],

        ["\xEC\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBD"],
        ["\xE8\xB3\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD0"],

        ["\xEC\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBA"],
        ["\xE8\xB3\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD1"],

        ["\xEC\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\xBB"],
        ["\xE8\xB3\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD2"],

        ["\xEC\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x84"],
        ["\xE8\xB4\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD3"],

        ["\xEC\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x85"],
        ["\xE8\xB4\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD4"],

        ["\xEC\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8A"],
        ["\xE8\xB4\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD5"],

        ["\xEC\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x87"],
        ["\xE8\xB4\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD6"],

        ["\xEC\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8F"],
        ["\xE8\xB4\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD7"],

        ["\xEC\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x8D"],
        ["\xE8\xB4\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD8"],

        ["\xEC\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x90"],
        ["\xE8\xB4\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xD9"],

        ["\xEC\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8E"],
        ["\xE9\xBD\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xDA"],

        ["\xEC\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x93"],
        ["\xE8\xB4\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xDB"],

        ["\xEC\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB3\x8D"],
        ["\xE8\xB3\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xDC"],

        ["\xEC\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x94"],
        ["\xE8\xB4\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xDD"],

        ["\xEC\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB4\x96"],
        ["\xE8\xB4\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xDE"],

        ["\xEC\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xA7"],
        ["\xE8\xB5\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xDF"],

        ["\xEC\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xAD"],
        ["\xE8\xB5\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE0"],

        ["\xEC\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB1"],
        ["\xE8\xB5\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE1"],

        ["\xEC\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB5\xB3"],
        ["\xE8\xB5\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE2"],

        ["\xEC\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x81"],
        ["\xE8\xB6\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE3"],

        ["\xEC\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\x99"],
        ["\xE8\xB6\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE4"],

        ["\xEC\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x82"],
        ["\xE8\xB7\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE5"],

        ["\xEC\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xBE"],
        ["\xE8\xB6\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE6"],

        ["\xEC\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB6\xBA"],
        ["\xE8\xB6\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE7"],

        ["\xEC\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8F"],
        ["\xE8\xB7\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE8"],

        ["\xEC\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9A"],
        ["\xE8\xB7\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xE9"],

        ["\xEC\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x96"],
        ["\xE8\xB7\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xEA"],

        ["\xEC\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8C"],
        ["\xE8\xB7\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xEB"],

        ["\xEC\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9B"],
        ["\xE8\xB7\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xEC"],

        ["\xEC\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x8B"],
        ["\xE8\xB7\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xED"],

        ["\xEC\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAA"],
        ["\xE8\xB7\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xEE"],

        ["\xEC\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xAB"],
        ["\xE8\xB7\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xEF"],

        ["\xEC\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\x9F"],
        ["\xE8\xB7\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF0"],

        ["\xEC\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xA3"],
        ["\xE8\xB7\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF1"],

        ["\xEC\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xBC"],
        ["\xE8\xB7\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF2"],

        ["\xEC\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x88"],
        ["\xE8\xB8\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF3"],

        ["\xEC\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x89"],
        ["\xE8\xB8\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF4"],

        ["\xEC\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB7\xBF"],
        ["\xE8\xB7\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF5"],

        ["\xEC\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9D"],
        ["\xE8\xB8\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF6"],

        ["\xEC\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9E"],
        ["\xE8\xB8\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF7"],

        ["\xEC\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x90"],
        ["\xE8\xB8\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF8"],

        ["\xEC\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\x9F"],
        ["\xE8\xB8\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xF9"],

        ["\xEC\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x82"],
        ["\xE8\xB9\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xFA"],

        ["\xEC\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB5"],
        ["\xE8\xB8\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xFB"],

        ["\xEC\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB0"],
        ["\xE8\xB8\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xFC"],

        ["\xEC\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xB4"],
        ["\xE8\xB8\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xFD"],

        ["\xEC\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x8A"],
        ["\xE8\xB9\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEC\xFE"],

        ["\xED\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x87"],
        ["\xE8\xB9\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA1"],

        ["\xED\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x89"],
        ["\xE8\xB9\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA2"],

        ["\xED\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x8C"],
        ["\xE8\xB9\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA3"],

        ["\xED\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x90"],
        ["\xE8\xB9\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA4"],

        ["\xED\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x88"],
        ["\xE8\xB9\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA5"],

        ["\xED\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x99"],
        ["\xE8\xB9\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA6"],

        ["\xED\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA4"],
        ["\xE8\xB9\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA7"],

        ["\xED\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA0"],
        ["\xE8\xB9\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA8"],

        ["\xED\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8\xAA"],
        ["\xE8\xB8\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xA9"],

        ["\xED\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xA3"],
        ["\xE8\xB9\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xAA"],

        ["\xED\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\x95"],
        ["\xE8\xB9\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xAB"],

        ["\xED\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB6"],
        ["\xE8\xB9\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xAC"],

        ["\xED\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xB2"],
        ["\xE8\xB9\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xAD"],

        ["\xED\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xB9\xBC"],
        ["\xE8\xB9\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xAE"],

        ["\xED\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x81"],
        ["\xE8\xBA\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xAF"],

        ["\xED\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x87"],
        ["\xE8\xBA\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB0"],

        ["\xED\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x85"],
        ["\xE8\xBA\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB1"],

        ["\xED\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x84"],
        ["\xE8\xBA\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB2"],

        ["\xED\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8B"],
        ["\xE8\xBA\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB3"],

        ["\xED\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x8A"],
        ["\xE8\xBA\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB4"],

        ["\xED\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x93"],
        ["\xE8\xBA\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB5"],

        ["\xED\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x91"],
        ["\xE8\xBA\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB6"],

        ["\xED\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x94"],
        ["\xE8\xBA\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB7"],

        ["\xED\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\x99"],
        ["\xE8\xBA\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB8"],

        ["\xED\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAA"],
        ["\xE8\xBA\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xB9"],

        ["\xED\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xA1"],
        ["\xE8\xBA\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xBA"],

        ["\xED\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xAC"],
        ["\xE8\xBA\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xBB"],

        ["\xED\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xB0"],
        ["\xE8\xBA\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xBC"],

        ["\xED\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x86"],
        ["\xE8\xBB\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xBD"],

        ["\xED\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xB1"],
        ["\xE8\xBA\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xBE"],

        ["\xED\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBA\xBE"],
        ["\xE8\xBA\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xBF"],

        ["\xED\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x85"],
        ["\xE8\xBB\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC0"],

        ["\xED\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x88"],
        ["\xE8\xBB\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC1"],

        ["\xED\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x8B"],
        ["\xE8\xBB\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC2"],

        ["\xED\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\x9B"],
        ["\xE8\xBB\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC3"],

        ["\xED\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xA3"],
        ["\xE8\xBB\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC4"],

        ["\xED\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBC"],
        ["\xE8\xBB\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC5"],

        ["\xED\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBB"],
        ["\xE8\xBB\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC6"],

        ["\xED\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xAB"],
        ["\xE8\xBB\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC7"],

        ["\xED\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBB\xBE"],
        ["\xE8\xBB\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC8"],

        ["\xED\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x8A"],
        ["\xE8\xBC\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xC9"],

        ["\xED\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x85"],
        ["\xE8\xBC\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xCA"],

        ["\xED\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x95"],
        ["\xE8\xBC\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xCB"],

        ["\xED\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x92"],
        ["\xE8\xBC\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xCC"],

        ["\xED\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x99"],
        ["\xE8\xBC\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xCD"],

        ["\xED\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x93"],
        ["\xE8\xBC\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xCE"],

        ["\xED\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9C"],
        ["\xE8\xBC\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xCF"],

        ["\xED\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9F"],
        ["\xE8\xBC\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD0"],

        ["\xED\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x9B"],
        ["\xE8\xBC\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD1"],

        ["\xED\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\x8C"],
        ["\xE8\xBC\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD2"],

        ["\xED\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xA6"],
        ["\xE8\xBC\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD3"],

        ["\xED\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB3"],
        ["\xE8\xBC\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD4"],

        ["\xED\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBB"],
        ["\xE8\xBC\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD5"],

        ["\xED\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xB9"],
        ["\xE8\xBC\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD6"],

        ["\xED\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x85"],
        ["\xE8\xBD\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD7"],

        ["\xED\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x82"],
        ["\xE8\xBD\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD8"],

        ["\xED\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBC\xBE"],
        ["\xE8\xBC\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xD9"],

        ["\xED\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8C"],
        ["\xE8\xBD\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xDA"],

        ["\xED\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x89"],
        ["\xE8\xBD\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xDB"],

        ["\xED\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x86"],
        ["\xE8\xBD\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xDC"],

        ["\xED\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x8E"],
        ["\xE8\xBD\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xDD"],

        ["\xED\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x97"],
        ["\xE8\xBD\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xDE"],

        ["\xED\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\x9C"],
        ["\xE8\xBD\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xDF"],

        ["\xED\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA2"],
        ["\xE8\xBD\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE0"],

        ["\xED\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA3"],
        ["\xE8\xBD\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE1"],

        ["\xED\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBD\xA4"],
        ["\xE8\xBD\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE2"],

        ["\xED\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9C"],
        ["\xE8\xBE\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE3"],

        ["\xED\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\x9F"],
        ["\xE8\xBE\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE4"],

        ["\xED\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xA3"],
        ["\xE8\xBE\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE5"],

        ["\xED\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAD"],
        ["\xE8\xBE\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE6"],

        ["\xED\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xAF"],
        ["\xE8\xBE\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE7"],

        ["\xED\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBE\xB7"],
        ["\xE8\xBE\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE8"],

        ["\xED\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\x9A"],
        ["\xE8\xBF\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xE9"],

        ["\xED\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA5"],
        ["\xE8\xBF\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xEA"],

        ["\xED\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xA2"],
        ["\xE8\xBF\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xEB"],

        ["\xED\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAA"],
        ["\xE8\xBF\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xEC"],

        ["\xED\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xAF"],
        ["\xE8\xBF\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xED"],

        ["\xC6\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x87"],
        ["\xE9\x82\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xC6\xF6"],

        ["\xED\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB4"],
        ["\xE8\xBF\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xEF"],

        ["\xED\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x85"],
        ["\xE9\x80\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF0"],

        ["\xED\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB9"],
        ["\xE8\xBF\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF1"],

        ["\xED\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xBA"],
        ["\xE8\xBF\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF2"],

        ["\xED\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x91"],
        ["\xE9\x80\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF3"],

        ["\xED\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x95"],
        ["\xE9\x80\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF4"],

        ["\xED\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA1"],
        ["\xE9\x80\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF5"],

        ["\xED\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8D"],
        ["\xE9\x80\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF6"],

        ["\xED\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x9E"],
        ["\xE9\x80\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF7"],

        ["\xED\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x96"],
        ["\xE9\x80\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF8"],

        ["\xED\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8B"],
        ["\xE9\x80\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xF9"],

        ["\xED\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xA7"],
        ["\xE9\x80\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xFA"],

        ["\xED\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB6"],
        ["\xE9\x80\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xFB"],

        ["\xED\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB5"],
        ["\xE9\x80\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xFC"],

        ["\xED\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xB9"],
        ["\xE9\x80\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xFD"],

        ["\xED\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xBF\xB8"],
        ["\xE8\xBF\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xED\xFE"],

        ["\xEE\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x8F"],
        ["\xE9\x81\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA1"],

        ["\xEE\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x90"],
        ["\xE9\x81\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA2"],

        ["\xEE\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x91"],
        ["\xE9\x81\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA3"],

        ["\xEE\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x92"],
        ["\xE9\x81\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA4"],

        ["\xEE\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\x8E"],
        ["\xE9\x80\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA5"],

        ["\xEE\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x89"],
        ["\xE9\x81\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA6"],

        ["\xEE\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x80\xBE"],
        ["\xE9\x80\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA7"],

        ["\xEE\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x96"],
        ["\xE9\x81\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA8"],

        ["\xEE\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x98"],
        ["\xE9\x81\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xA9"],

        ["\xEE\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\x9E"],
        ["\xE9\x81\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xAA"],

        ["\xEE\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xA8"],
        ["\xE9\x81\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xAB"],

        ["\xEE\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xAF"],
        ["\xE9\x81\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xAC"],

        ["\xEE\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB6"],
        ["\xE9\x81\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xAD"],

        ["\xEE\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA8"],
        ["\xE9\x9A\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xAE"],

        ["\xEE\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xB2"],
        ["\xE9\x81\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xAF"],

        ["\xEE\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x82"],
        ["\xE9\x82\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB0"],

        ["\xEE\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x81\xBD"],
        ["\xE9\x81\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB1"],

        ["\xEE\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x81"],
        ["\xE9\x82\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB2"],

        ["\xEE\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x80"],
        ["\xE9\x82\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB3"],

        ["\xEE\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x8A"],
        ["\xE9\x82\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB4"],

        ["\xEE\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x89"],
        ["\xE9\x82\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB5"],

        ["\xEE\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\x8F"],
        ["\xE9\x82\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB6"],

        ["\xEE\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xA8"],
        ["\xE9\x82\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB7"],

        ["\xEE\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xAF"],
        ["\xE9\x82\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB8"],

        ["\xEE\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB1"],
        ["\xE9\x82\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xB9"],

        ["\xEE\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x82\xB5"],
        ["\xE9\x82\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xBA"],

        ["\xEE\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA2"],
        ["\xE9\x83\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xBB"],

        ["\xEE\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\xA4"],
        ["\xE9\x83\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xBC"],

        ["\xEE\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\x89\x88"],
        ["\xE6\x89\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xBD"],

        ["\xEE\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x83\x9B"],
        ["\xE9\x83\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xBE"],

        ["\xEE\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x82"],
        ["\xE9\x84\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xBF"],

        ["\xEE\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x92"],
        ["\xE9\x84\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC0"],

        ["\xEE\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\x99"],
        ["\xE9\x84\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC1"],

        ["\xEE\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB2"],
        ["\xE9\x84\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC2"],

        ["\xEE\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x84\xB0"],
        ["\xE9\x84\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC3"],

        ["\xEE\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x8A"],
        ["\xE9\x85\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC4"],

        ["\xEE\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x96"],
        ["\xE9\x85\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC5"],

        ["\xEE\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\x98"],
        ["\xE9\x85\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC6"],

        ["\xEE\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA3"],
        ["\xE9\x85\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC7"],

        ["\xEE\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA5"],
        ["\xE9\x85\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC8"],

        ["\xEE\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xA9"],
        ["\xE9\x85\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xC9"],

        ["\xEE\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB3"],
        ["\xE9\x85\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xCA"],

        ["\xEE\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x85\xB2"],
        ["\xE9\x85\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xCB"],

        ["\xEE\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x8B"],
        ["\xE9\x86\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xCC"],

        ["\xEE\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x89"],
        ["\xE9\x86\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xCD"],

        ["\xEE\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\x82"],
        ["\xE9\x86\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xCE"],

        ["\xEE\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xA2"],
        ["\xE9\x86\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xCF"],

        ["\xEE\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAB"],
        ["\xE9\x86\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD0"],

        ["\xEE\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAF"],
        ["\xE9\x86\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD1"],

        ["\xEE\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xAA"],
        ["\xE9\x86\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD2"],

        ["\xEE\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB5"],
        ["\xE9\x86\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD3"],

        ["\xEE\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xB4"],
        ["\xE9\x86\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD4"],

        ["\xEE\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x86\xBA"],
        ["\xE9\x86\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD5"],

        ["\xEE\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x80"],
        ["\xE9\x87\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD6"],

        ["\xEE\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x81"],
        ["\xE9\x87\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD7"],

        ["\xEE\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x89"],
        ["\xE9\x87\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD8"],

        ["\xEE\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x8B"],
        ["\xE9\x87\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xD9"],

        ["\xEE\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x90"],
        ["\xE9\x87\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xDA"],

        ["\xEE\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x96"],
        ["\xE9\x87\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xDB"],

        ["\xEE\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9F"],
        ["\xE9\x87\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xDC"],

        ["\xEE\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xA1"],
        ["\xE9\x87\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xDD"],

        ["\xEE\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\x9B"],
        ["\xE9\x87\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xDE"],

        ["\xEE\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xBC"],
        ["\xE9\x87\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xDF"],

        ["\xEE\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xB5"],
        ["\xE9\x87\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE0"],

        ["\xEE\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xB6"],
        ["\xE9\x87\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE1"],

        ["\xEE\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x9E"],
        ["\xE9\x88\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE2"],

        ["\xEE\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x87\xBF"],
        ["\xE9\x87\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE3"],

        ["\xEE\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x94"],
        ["\xE9\x88\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE4"],

        ["\xEE\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xAC"],
        ["\xE9\x88\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE5"],

        ["\xEE\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x95"],
        ["\xE9\x88\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE6"],

        ["\xEE\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\x91"],
        ["\xE9\x88\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE7"],

        ["\xEE\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9E"],
        ["\xE9\x89\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE8"],

        ["\xEE\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x97"],
        ["\xE9\x89\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xE9"],

        ["\xEE\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x85"],
        ["\xE9\x89\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xEA"],

        ["\xEE\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x89"],
        ["\xE9\x89\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xEB"],

        ["\xEE\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\xA4"],
        ["\xE9\x89\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xEC"],

        ["\xEE\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x88"],
        ["\xE9\x89\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xED"],

        ["\xEE\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x95"],
        ["\xE9\x8A\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xEE"],

        ["\xEE\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xBF"],
        ["\xE9\x88\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xEF"],

        ["\xEE\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x8B"],
        ["\xE9\x89\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF0"],

        ["\xEE\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x90"],
        ["\xE9\x89\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF1"],

        ["\xEE\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9C"],
        ["\xE9\x8A\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF2"],

        ["\xEE\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x96"],
        ["\xE9\x8A\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF3"],

        ["\xEE\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x93"],
        ["\xE9\x8A\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF4"],

        ["\xEE\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\x9B"],
        ["\xE9\x8A\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF5"],

        ["\xEE\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x89\x9A"],
        ["\xE9\x89\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF6"],

        ["\xEE\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\x8F"],
        ["\xE9\x8B\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF7"],

        ["\xEE\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xB9"],
        ["\xE9\x8A\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF8"],

        ["\xEE\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8A\xB7"],
        ["\xE9\x8A\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xF9"],

        ["\xEE\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xA9"],
        ["\xE9\x8B\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xFA"],

        ["\xEE\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x8F"],
        ["\xE9\x8C\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xFB"],

        ["\xEE\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8B\xBA"],
        ["\xE9\x8B\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xFC"],

        ["\xEE\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x84"],
        ["\xE9\x8D\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xFD"],

        ["\xEE\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xAE"],
        ["\xE9\x8C\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEE\xFE"],

        ["\xEF\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x99"],
        ["\xE9\x8C\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA1"],

        ["\xEF\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA2"],
        ["\xE9\x8C\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA2"],

        ["\xEF\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\x9A"],
        ["\xE9\x8C\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA3"],

        ["\xEF\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xA3"],
        ["\xE9\x8C\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA4"],

        ["\xEF\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xBA"],
        ["\xE9\x8C\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA5"],

        ["\xEF\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xB5"],
        ["\xE9\x8C\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA6"],

        ["\xEF\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8C\xBB"],
        ["\xE9\x8C\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA7"],

        ["\xEF\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x9C"],
        ["\xE9\x8D\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA8"],

        ["\xEF\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xA0"],
        ["\xE9\x8D\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xA9"],

        ["\xEF\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xBC"],
        ["\xE9\x8D\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xAA"],

        ["\xEF\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\xAE"],
        ["\xE9\x8D\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xAB"],

        ["\xEF\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8D\x96"],
        ["\xE9\x8D\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xAC"],

        ["\xEF\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xB0"],
        ["\xE9\x8E\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xAD"],

        ["\xEF\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAC"],
        ["\xE9\x8E\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xAE"],

        ["\xEF\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xAD"],
        ["\xE9\x8E\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xAF"],

        ["\xEF\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\x94"],
        ["\xE9\x8E\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB0"],

        ["\xEF\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8E\xB9"],
        ["\xE9\x8E\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB1"],

        ["\xEF\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x96"],
        ["\xE9\x8F\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB2"],

        ["\xEF\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x97"],
        ["\xE9\x8F\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB3"],

        ["\xEF\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA8"],
        ["\xE9\x8F\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB4"],

        ["\xEF\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA5"],
        ["\xE9\x8F\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB5"],

        ["\xEF\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x98"],
        ["\xE9\x8F\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB6"],

        ["\xEF\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x83"],
        ["\xE9\x8F\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB7"],

        ["\xEF\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x9D"],
        ["\xE9\x8F\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB8"],

        ["\xEF\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x90"],
        ["\xE9\x8F\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xB9"],

        ["\xEF\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\x88"],
        ["\xE9\x8F\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xBA"],

        ["\xEF\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x8F\xA4"],
        ["\xE9\x8F\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xBB"],

        ["\xEF\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x9A"],
        ["\xE9\x90\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xBC"],

        ["\xEF\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x94"],
        ["\xE9\x90\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xBD"],

        ["\xEF\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x93"],
        ["\xE9\x90\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xBE"],

        ["\xEF\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x83"],
        ["\xE9\x90\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xBF"],

        ["\xEF\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x87"],
        ["\xE9\x90\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC0"],

        ["\xEF\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\x90"],
        ["\xE9\x90\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC1"],

        ["\xEF\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB6"],
        ["\xE9\x90\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC2"],

        ["\xEF\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xAB"],
        ["\xE9\x90\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC3"],

        ["\xEF\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xB5"],
        ["\xE9\x90\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC4"],

        ["\xEF\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xA1"],
        ["\xE9\x90\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC5"],

        ["\xEF\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x90\xBA"],
        ["\xE9\x90\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC6"],

        ["\xEF\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x81"],
        ["\xE9\x91\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC7"],

        ["\xEF\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x92"],
        ["\xE9\x91\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC8"],

        ["\xEF\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x84"],
        ["\xE9\x91\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xC9"],

        ["\xEF\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9B"],
        ["\xE9\x91\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xCA"],

        ["\xEF\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xA0"],
        ["\xE9\x91\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xCB"],

        ["\xEF\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xA2"],
        ["\xE9\x91\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xCC"],

        ["\xEF\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9E"],
        ["\xE9\x91\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xCD"],

        ["\xEF\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xAA"],
        ["\xE9\x91\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xCE"],

        ["\xEF\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x88\xA9"],
        ["\xE9\x88\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xCF"],

        ["\xEF\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB0"],
        ["\xE9\x91\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD0"],

        ["\xEF\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB5"],
        ["\xE9\x91\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD1"],

        ["\xEF\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xB7"],
        ["\xE9\x91\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD2"],

        ["\xEF\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBD"],
        ["\xE9\x91\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD3"],

        ["\xEF\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\x9A"],
        ["\xE9\x91\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD4"],

        ["\xEF\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBC"],
        ["\xE9\x91\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD5"],

        ["\xEF\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBE"],
        ["\xE9\x91\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD6"],

        ["\xEF\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x92\x81"],
        ["\xE9\x92\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD7"],

        ["\xEF\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x91\xBF"],
        ["\xE9\x91\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD8"],

        ["\xEF\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x82"],
        ["\xE9\x96\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xD9"],

        ["\xEF\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x87"],
        ["\xE9\x96\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xDA"],

        ["\xEF\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x8A"],
        ["\xE9\x96\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xDB"],

        ["\xEF\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x94"],
        ["\xE9\x96\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xDC"],

        ["\xEF\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x96"],
        ["\xE9\x96\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xDD"],

        ["\xEF\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x98"],
        ["\xE9\x96\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xDE"],

        ["\xEF\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\x99"],
        ["\xE9\x96\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xDF"],

        ["\xEF\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA0"],
        ["\xE9\x96\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE0"],

        ["\xEF\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA8"],
        ["\xE9\x96\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE1"],

        ["\xEF\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xA7"],
        ["\xE9\x96\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE2"],

        ["\xEF\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xAD"],
        ["\xE9\x96\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE3"],

        ["\xEF\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xBC"],
        ["\xE9\x96\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE4"],

        ["\xEF\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xBB"],
        ["\xE9\x96\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE5"],

        ["\xEF\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xB9"],
        ["\xE9\x96\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE6"],

        ["\xEF\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x96\xBE"],
        ["\xE9\x96\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE7"],

        ["\xEF\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x8A"],
        ["\xE9\x97\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE8"],

        ["\xEF\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE6\xBF\xB6"],
        ["\xE6\xBF\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xE9"],

        ["\xEF\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x83"],
        ["\xE9\x97\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xEA"],

        ["\xEF\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x8D"],
        ["\xE9\x97\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xEB"],

        ["\xEF\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x8C"],
        ["\xE9\x97\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xEC"],

        ["\xEF\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x95"],
        ["\xE9\x97\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xED"],

        ["\xEF\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x94"],
        ["\xE9\x97\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xEE"],

        ["\xEF\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x96"],
        ["\xE9\x97\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xEF"],

        ["\xEF\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\x9C"],
        ["\xE9\x97\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF0"],

        ["\xEF\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\xA1"],
        ["\xE9\x97\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF1"],

        ["\xEF\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\xA5"],
        ["\xE9\x97\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF2"],

        ["\xEF\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x97\xA2"],
        ["\xE9\x97\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF3"],

        ["\xEF\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xA1"],
        ["\xE9\x98\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF4"],

        ["\xEF\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xA8"],
        ["\xE9\x98\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF5"],

        ["\xEF\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAE"],
        ["\xE9\x98\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF6"],

        ["\xEF\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x98\xAF"],
        ["\xE9\x98\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF7"],

        ["\xEF\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x82"],
        ["\xE9\x99\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF8"],

        ["\xEF\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8C"],
        ["\xE9\x99\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xF9"],

        ["\xEF\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8F"],
        ["\xE9\x99\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xFA"],

        ["\xEF\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x8B"],
        ["\xE9\x99\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xFB"],

        ["\xEF\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB7"],
        ["\xE9\x99\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xFC"],

        ["\xEF\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9C"],
        ["\xE9\x99\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xFD"],

        ["\xEF\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9E"],
        ["\xE9\x99\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xEF\xFE"],

        ["\xF0\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9D"],
        ["\xE9\x99\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA1"],

        ["\xF0\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\x9F"],
        ["\xE9\x99\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA2"],

        ["\xF0\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xA6"],
        ["\xE9\x99\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA3"],

        ["\xF0\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xB2"],
        ["\xE9\x99\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA4"],

        ["\xF0\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x99\xAC"],
        ["\xE9\x99\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA5"],

        ["\xF0\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x8D"],
        ["\xE9\x9A\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA6"],

        ["\xF0\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x98"],
        ["\xE9\x9A\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA7"],

        ["\xF0\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x95"],
        ["\xE9\x9A\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA8"],

        ["\xF0\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\x97"],
        ["\xE9\x9A\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xA9"],

        ["\xF0\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xAA"],
        ["\xE9\x9A\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xAA"],

        ["\xF0\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xA7"],
        ["\xE9\x9A\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xAB"],

        ["\xF0\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB1"],
        ["\xE9\x9A\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xAC"],

        ["\xF0\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB2"],
        ["\xE9\x9A\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xAD"],

        ["\xF0\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB0"],
        ["\xE9\x9A\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xAE"],

        ["\xF0\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB4"],
        ["\xE9\x9A\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xAF"],

        ["\xF0\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB6"],
        ["\xE9\x9A\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB0"],

        ["\xF0\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB8"],
        ["\xE9\x9A\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB1"],

        ["\xF0\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9A\xB9"],
        ["\xE9\x9A\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB2"],

        ["\xF0\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8E"],
        ["\xE9\x9B\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB3"],

        ["\xF0\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8B"],
        ["\xE9\x9B\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB4"],

        ["\xF0\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x89"],
        ["\xE9\x9B\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB5"],

        ["\xF0\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x8D"],
        ["\xE9\x9B\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB6"],

        ["\xF0\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE8\xA5\x8D"],
        ["\xE8\xA5\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB7"],

        ["\xF0\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x9C"],
        ["\xE9\x9B\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB8"],

        ["\xF0\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8D"],
        ["\xE9\x9C\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xB9"],

        ["\xF0\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\x95"],
        ["\xE9\x9B\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xBA"],

        ["\xF0\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9B\xB9"],
        ["\xE9\x9B\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xBB"],

        ["\xF0\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x84"],
        ["\xE9\x9C\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xBC"],

        ["\xF0\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x86"],
        ["\xE9\x9C\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xBD"],

        ["\xF0\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x88"],
        ["\xE9\x9C\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xBE"],

        ["\xF0\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x93"],
        ["\xE9\x9C\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xBF"],

        ["\xF0\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8E"],
        ["\xE9\x9C\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC0"],

        ["\xF0\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x91"],
        ["\xE9\x9C\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC1"],

        ["\xF0\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x8F"],
        ["\xE9\x9C\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC2"],

        ["\xF0\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x96"],
        ["\xE9\x9C\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC3"],

        ["\xF0\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\x99"],
        ["\xE9\x9C\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC4"],

        ["\xF0\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xA4"],
        ["\xE9\x9C\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC5"],

        ["\xF0\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xAA"],
        ["\xE9\x9C\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC6"],

        ["\xF0\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB0"],
        ["\xE9\x9C\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC7"],

        ["\xF0\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xB9"],
        ["\xE9\x9C\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC8"],

        ["\xF0\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xBD"],
        ["\xE9\x9C\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xC9"],

        ["\xF0\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9C\xBE"],
        ["\xE9\x9C\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xCA"],

        ["\xF0\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x84"],
        ["\xE9\x9D\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xCB"],

        ["\xF0\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x86"],
        ["\xE9\x9D\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xCC"],

        ["\xF0\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x88"],
        ["\xE9\x9D\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xCD"],

        ["\xF0\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x82"],
        ["\xE9\x9D\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xCE"],

        ["\xF0\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x89"],
        ["\xE9\x9D\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xCF"],

        ["\xF0\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\x9C"],
        ["\xE9\x9D\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD0"],

        ["\xF0\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA0"],
        ["\xE9\x9D\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD1"],

        ["\xF0\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA4"],
        ["\xE9\x9D\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD2"],

        ["\xF0\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA6"],
        ["\xE9\x9D\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD3"],

        ["\xF0\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xA8"],
        ["\xE9\x9D\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD4"],

        ["\xF0\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE5\x8B\x92"],
        ["\xE5\x8B\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD5"],

        ["\xF0\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xAB"],
        ["\xE9\x9D\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD6"],

        ["\xBF\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB1"],
        ["\xE9\x9D\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xBF\xD9"],

        ["\xF0\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xB9"],
        ["\xE9\x9D\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD8"],

        ["\xF0\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x85"],
        ["\xE9\x9E\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xD9"],

        ["\xF0\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xBC"],
        ["\xE9\x9D\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xDA"],

        ["\xF0\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x81"],
        ["\xE9\x9E\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xDB"],

        ["\xF0\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9D\xBA"],
        ["\xE9\x9D\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xDC"],

        ["\xF0\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x86"],
        ["\xE9\x9E\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xDD"],

        ["\xF0\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x8B"],
        ["\xE9\x9E\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xDE"],

        ["\xF0\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x8F"],
        ["\xE9\x9E\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xDF"],

        ["\xF0\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x90"],
        ["\xE9\x9E\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE0"],

        ["\xF0\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\x9C"],
        ["\xE9\x9E\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE1"],

        ["\xF0\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA8"],
        ["\xE9\x9E\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE2"],

        ["\xF0\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA6"],
        ["\xE9\x9E\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE3"],

        ["\xF0\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xA3"],
        ["\xE9\x9E\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE4"],

        ["\xF0\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xB3"],
        ["\xE9\x9E\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE5"],

        ["\xF0\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9E\xB4"],
        ["\xE9\x9E\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE6"],

        ["\xF0\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x83"],
        ["\xE9\x9F\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE7"],

        ["\xF0\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x86"],
        ["\xE9\x9F\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE8"],

        ["\xF0\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x88"],
        ["\xE9\x9F\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xE9"],

        ["\xF0\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x8B"],
        ["\xE9\x9F\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xEA"],

        ["\xF0\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\x9C"],
        ["\xE9\x9F\x9C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xEB"],

        ["\xF0\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xAD"],
        ["\xE9\x9F\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xEC"],

        ["\xF0\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBD\x8F"],
        ["\xE9\xBD\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xED"],

        ["\xF0\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB2"],
        ["\xE9\x9F\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xEE"],

        ["\xF0\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE7\xAB\x9F"],
        ["\xE7\xAB\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xEF"],

        ["\xF0\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB6"],
        ["\xE9\x9F\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF0"],

        ["\xF0\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\x9F\xB5"],
        ["\xE9\x9F\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF1"],

        ["\xF0\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x8F"],
        ["\xE9\xA0\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF2"],

        ["\xF0\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\x8C"],
        ["\xE9\xA0\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF3"],

        ["\xB7\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB8"],
        ["\xE9\xA0\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB7\xDB"],

        ["\xF0\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xA4"],
        ["\xE9\xA0\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF5"],

        ["\xF0\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xA1"],
        ["\xE9\xA0\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF6"],

        ["\xF0\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xB7"],
        ["\xE9\xA0\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF7"],

        ["\xF0\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA0\xBD"],
        ["\xE9\xA0\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF8"],

        ["\xF0\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x86"],
        ["\xE9\xA1\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xF9"],

        ["\xF0\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8F"],
        ["\xE9\xA1\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xFA"],

        ["\xF0\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\x8B"],
        ["\xE9\xA1\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xFB"],

        ["\xF0\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xAB"],
        ["\xE9\xA1\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xFC"],

        ["\xF0\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xAF"],
        ["\xE9\xA1\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xFD"],

        ["\xF0\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB0"],
        ["\xE9\xA1\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF0\xFE"],

        ["\xF1\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB1"],
        ["\xE9\xA1\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA1"],

        ["\xF1\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB4"],
        ["\xE9\xA1\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA2"],

        ["\xF1\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA1\xB3"],
        ["\xE9\xA1\xB3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA3"],

        ["\xF1\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xAA"],
        ["\xE9\xA2\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA4"],

        ["\xF1\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xAF"],
        ["\xE9\xA2\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA5"],

        ["\xF1\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xB1"],
        ["\xE9\xA2\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA6"],

        ["\xF1\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA2\xB6"],
        ["\xE9\xA2\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA7"],

        ["\xF1\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x84"],
        ["\xE9\xA3\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA8"],

        ["\xF1\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x83"],
        ["\xE9\xA3\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xA9"],

        ["\xF1\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\x86"],
        ["\xE9\xA3\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xAA"],

        ["\xF1\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xA9"],
        ["\xE9\xA3\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xAB"],

        ["\xF1\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA3\xAB"],
        ["\xE9\xA3\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xAC"],

        ["\xF1\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x83"],
        ["\xE9\xA4\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xAD"],

        ["\xF1\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x89"],
        ["\xE9\xA4\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xAE"],

        ["\xF1\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x92"],
        ["\xE9\xA4\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xAF"],

        ["\xF1\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x94"],
        ["\xE9\xA4\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB0"],

        ["\xF1\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x98"],
        ["\xE9\xA4\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB1"],

        ["\xF1\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA1"],
        ["\xE9\xA4\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB2"],

        ["\xF1\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x9D"],
        ["\xE9\xA4\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB3"],

        ["\xF1\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\x9E"],
        ["\xE9\xA4\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB4"],

        ["\xF1\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA4"],
        ["\xE9\xA4\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB5"],

        ["\xF1\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xA0"],
        ["\xE9\xA4\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB6"],

        ["\xF1\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xAC"],
        ["\xE9\xA4\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB7"],

        ["\xF1\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xAE"],
        ["\xE9\xA4\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB8"],

        ["\xF1\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xBD"],
        ["\xE9\xA4\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xB9"],

        ["\xF1\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA4\xBE"],
        ["\xE9\xA4\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xBA"],

        ["\xF1\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x82"],
        ["\xE9\xA5\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xBB"],

        ["\xF1\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x89"],
        ["\xE9\xA5\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xBC"],

        ["\xF1\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x85"],
        ["\xE9\xA5\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xBD"],

        ["\xF1\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x90"],
        ["\xE9\xA5\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xBE"],

        ["\xF1\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x8B"],
        ["\xE9\xA5\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xBF"],

        ["\xF1\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x91"],
        ["\xE9\xA5\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC0"],

        ["\xF1\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x92"],
        ["\xE9\xA5\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC1"],

        ["\xF1\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x8C"],
        ["\xE9\xA5\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC2"],

        ["\xF1\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA5\x95"],
        ["\xE9\xA5\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC3"],

        ["\xF1\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x97"],
        ["\xE9\xA6\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC4"],

        ["\xF1\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\x98"],
        ["\xE9\xA6\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC5"],

        ["\xF1\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xA5"],
        ["\xE9\xA6\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC6"],

        ["\xF1\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xAD"],
        ["\xE9\xA6\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC7"],

        ["\xF1\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xAE"],
        ["\xE9\xA6\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC8"],

        ["\xF1\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA6\xBC"],
        ["\xE9\xA6\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xC9"],

        ["\xF1\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x9F"],
        ["\xE9\xA7\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xCA"],

        ["\xF1\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x9B"],
        ["\xE9\xA7\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xCB"],

        ["\xF1\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x9D"],
        ["\xE9\xA7\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xCC"],

        ["\xF1\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x98"],
        ["\xE9\xA7\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xCD"],

        ["\xF1\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\x91"],
        ["\xE9\xA7\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xCE"],

        ["\xF1\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xAD"],
        ["\xE9\xA7\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xCF"],

        ["\xF1\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xAE"],
        ["\xE9\xA7\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD0"],

        ["\xF1\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xB1"],
        ["\xE9\xA7\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD1"],

        ["\xF1\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xB2"],
        ["\xE9\xA7\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD2"],

        ["\xF1\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xBB"],
        ["\xE9\xA7\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD3"],

        ["\xF1\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xB8"],
        ["\xE9\xA7\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD4"],

        ["\xF1\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x81"],
        ["\xE9\xA8\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD5"],

        ["\xF1\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x8F"],
        ["\xE9\xA8\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD6"],

        ["\xF1\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x85"],
        ["\xE9\xA8\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD7"],

        ["\xF1\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA7\xA2"],
        ["\xE9\xA7\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD8"],

        ["\xF1\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\x99"],
        ["\xE9\xA8\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xD9"],

        ["\xF1\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xAB"],
        ["\xE9\xA8\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xDA"],

        ["\xF1\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xB7"],
        ["\xE9\xA8\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xDB"],

        ["\xF1\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x85"],
        ["\xE9\xA9\x85",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xDC"],

        ["\xF1\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x82"],
        ["\xE9\xA9\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xDD"],

        ["\xF1\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x80"],
        ["\xE9\xA9\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xDE"],

        ["\xF1\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x83"],
        ["\xE9\xA9\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xDF"],

        ["\xF1\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA8\xBE"],
        ["\xE9\xA8\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE0"],

        ["\xF1\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x95"],
        ["\xE9\xA9\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE1"],

        ["\xF1\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x8D"],
        ["\xE9\xA9\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE2"],

        ["\xF1\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x9B"],
        ["\xE9\xA9\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE3"],

        ["\xF1\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x97"],
        ["\xE9\xA9\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE4"],

        ["\xF1\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\x9F"],
        ["\xE9\xA9\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE5"],

        ["\xF1\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA2"],
        ["\xE9\xA9\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE6"],

        ["\xF1\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA5"],
        ["\xE9\xA9\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE7"],

        ["\xF1\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA4"],
        ["\xE9\xA9\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE8"],

        ["\xF1\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xA9"],
        ["\xE9\xA9\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xE9"],

        ["\xF1\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xAB"],
        ["\xE9\xA9\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xEA"],

        ["\xF1\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xA9\xAA"],
        ["\xE9\xA9\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xEB"],

        ["\xF1\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xAD"],
        ["\xE9\xAA\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xEC"],

        ["\xF1\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xB0"],
        ["\xE9\xAA\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xED"],

        ["\xF1\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAA\xBC"],
        ["\xE9\xAA\xBC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xEE"],

        ["\xF1\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x80"],
        ["\xE9\xAB\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xEF"],

        ["\xF1\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x8F"],
        ["\xE9\xAB\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF0"],

        ["\xF1\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x91"],
        ["\xE9\xAB\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF1"],

        ["\xF1\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x93"],
        ["\xE9\xAB\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF2"],

        ["\xF1\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x94"],
        ["\xE9\xAB\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF3"],

        ["\xF1\xF4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x9E"],
        ["\xE9\xAB\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF4"],

        ["\xF1\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\x9F"],
        ["\xE9\xAB\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF5"],

        ["\xF1\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA2"],
        ["\xE9\xAB\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF6"],

        ["\xF1\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA3"],
        ["\xE9\xAB\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF7"],

        ["\xF1\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xA6"],
        ["\xE9\xAB\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF8"],

        ["\xF1\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAF"],
        ["\xE9\xAB\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xF9"],

        ["\xF1\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAB"],
        ["\xE9\xAB\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xFA"],

        ["\xF1\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xAE"],
        ["\xE9\xAB\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xFB"],

        ["\xF1\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xB4"],
        ["\xE9\xAB\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xFC"],

        ["\xF1\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xB1"],
        ["\xE9\xAB\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xFD"],

        ["\xF1\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xB7"],
        ["\xE9\xAB\xB7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF1\xFE"],

        ["\xF2\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAB\xBB"],
        ["\xE9\xAB\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA1"],

        ["\xF2\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x86"],
        ["\xE9\xAC\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA2"],

        ["\xF2\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x98"],
        ["\xE9\xAC\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA3"],

        ["\xF2\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x9A"],
        ["\xE9\xAC\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA4"],

        ["\xF2\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\x9F"],
        ["\xE9\xAC\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA5"],

        ["\xF2\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA2"],
        ["\xE9\xAC\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA6"],

        ["\xF2\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA3"],
        ["\xE9\xAC\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA7"],

        ["\xF2\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA5"],
        ["\xE9\xAC\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA8"],

        ["\xF2\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA7"],
        ["\xE9\xAC\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xA9"],

        ["\xF2\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA8"],
        ["\xE9\xAC\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xAA"],

        ["\xF2\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xA9"],
        ["\xE9\xAC\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xAB"],

        ["\xF2\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xAA"],
        ["\xE9\xAC\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xAC"],

        ["\xF2\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xAE"],
        ["\xE9\xAC\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xAD"],

        ["\xF2\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xAF"],
        ["\xE9\xAC\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xAE"],

        ["\xF2\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAC\xB2"],
        ["\xE9\xAC\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xAF"],

        ["\xF2\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x84"],
        ["\xE9\xAD\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB0"],

        ["\xF2\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x83"],
        ["\xE9\xAD\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB1"],

        ["\xF2\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x8F"],
        ["\xE9\xAD\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB2"],

        ["\xF2\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x8D"],
        ["\xE9\xAD\x8D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB3"],

        ["\xF2\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x8E"],
        ["\xE9\xAD\x8E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB4"],

        ["\xF2\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x91"],
        ["\xE9\xAD\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB5"],

        ["\xF2\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\x98"],
        ["\xE9\xAD\x98",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB6"],

        ["\xF2\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAD\xB4"],
        ["\xE9\xAD\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB7"],

        ["\xF2\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x93"],
        ["\xE9\xAE\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB8"],

        ["\xF2\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x83"],
        ["\xE9\xAE\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xB9"],

        ["\xF2\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x91"],
        ["\xE9\xAE\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xBA"],

        ["\xF2\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x96"],
        ["\xE9\xAE\x96",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xBB"],

        ["\xF2\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x97"],
        ["\xE9\xAE\x97",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xBC"],

        ["\xF2\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\x9F"],
        ["\xE9\xAE\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xBD"],

        ["\xF2\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xA0"],
        ["\xE9\xAE\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xBE"],

        ["\xF2\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xA8"],
        ["\xE9\xAE\xA8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xBF"],

        ["\xF2\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xB4"],
        ["\xE9\xAE\xB4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC0"],

        ["\xF2\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x80"],
        ["\xE9\xAF\x80",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC1"],

        ["\xF2\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x8A"],
        ["\xE9\xAF\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC2"],

        ["\xF2\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAE\xB9"],
        ["\xE9\xAE\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC3"],

        ["\xF2\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x86"],
        ["\xE9\xAF\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC4"],

        ["\xF2\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x8F"],
        ["\xE9\xAF\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC5"],

        ["\xF2\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x91"],
        ["\xE9\xAF\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC6"],

        ["\xF2\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x92"],
        ["\xE9\xAF\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC7"],

        ["\xF2\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA3"],
        ["\xE9\xAF\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC8"],

        ["\xF2\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA2"],
        ["\xE9\xAF\xA2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xC9"],

        ["\xF2\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA4"],
        ["\xE9\xAF\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xCA"],

        ["\xF2\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\x94"],
        ["\xE9\xAF\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xCB"],

        ["\xF2\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xA1"],
        ["\xE9\xAF\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xCC"],

        ["\xB0\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xBA"],
        ["\xE9\xB0\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB0\xB3"],

        ["\xF2\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB2"],
        ["\xE9\xAF\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xCE"],

        ["\xF2\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB1"],
        ["\xE9\xAF\xB1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xCF"],

        ["\xF2\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xAF\xB0"],
        ["\xE9\xAF\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD0"],

        ["\xF2\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x95"],
        ["\xE9\xB0\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD1"],

        ["\xF2\xD2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x94"],
        ["\xE9\xB0\x94",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD2"],

        ["\xF2\xD3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x89"],
        ["\xE9\xB0\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD3"],

        ["\xF2\xD4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x93"],
        ["\xE9\xB0\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD4"],

        ["\xF2\xD5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x8C"],
        ["\xE9\xB0\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD5"],

        ["\xF2\xD6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x86"],
        ["\xE9\xB0\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD6"],

        ["\xF2\xD7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x88"],
        ["\xE9\xB0\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD7"],

        ["\xF2\xD8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x92"],
        ["\xE9\xB0\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD8"],

        ["\xF2\xD9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x8A"],
        ["\xE9\xB0\x8A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xD9"],

        ["\xF2\xDA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x84"],
        ["\xE9\xB0\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xDA"],

        ["\xF2\xDB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xAE"],
        ["\xE9\xB0\xAE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xDB"],

        ["\xF2\xDC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\x9B"],
        ["\xE9\xB0\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xDC"],

        ["\xF2\xDD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA5"],
        ["\xE9\xB0\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xDD"],

        ["\xF2\xDE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA4"],
        ["\xE9\xB0\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xDE"],

        ["\xF2\xDF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xA1"],
        ["\xE9\xB0\xA1",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xDF"],

        ["\xF2\xE0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB0"],
        ["\xE9\xB0\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE0"],

        ["\xF2\xE1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x87"],
        ["\xE9\xB1\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE1"],

        ["\xF2\xE2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xB2"],
        ["\xE9\xB0\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE2"],

        ["\xF2\xE3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x86"],
        ["\xE9\xB1\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE3"],

        ["\xF2\xE4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB0\xBE"],
        ["\xE9\xB0\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE4"],

        ["\xF2\xE5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\x9A"],
        ["\xE9\xB1\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE5"],

        ["\xF2\xE6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xA0"],
        ["\xE9\xB1\xA0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE6"],

        ["\xF2\xE7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xA7"],
        ["\xE9\xB1\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE7"],

        ["\xF2\xE8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB6"],
        ["\xE9\xB1\xB6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE8"],

        ["\xF2\xE9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB1\xB8"],
        ["\xE9\xB1\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xE9"],

        ["\xF2\xEA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xA7"],
        ["\xE9\xB3\xA7",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xEA"],

        ["\xF2\xEB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xAC"],
        ["\xE9\xB3\xAC",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xEB"],

        ["\xF2\xEC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xB0"],
        ["\xE9\xB3\xB0",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xEC"],

        ["\xF2\xED",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x89"],
        ["\xE9\xB4\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xED"],

        ["\xF2\xEE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x88"],
        ["\xE9\xB4\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xEE"],

        ["\xF2\xEF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB3\xAB"],
        ["\xE9\xB3\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xEF"],

        ["\xF2\xF0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x83"],
        ["\xE9\xB4\x83",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF0"],

        ["\xF2\xF1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x86"],
        ["\xE9\xB4\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF1"],

        ["\xF2\xF2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xAA"],
        ["\xE9\xB4\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF2"],

        ["\xF2\xF3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xA6"],
        ["\xE9\xB4\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF3"],

        ["\xB2\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xAF"],
        ["\xE9\xB6\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xB2\xA9"],

        ["\xF2\xF5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xA3"],
        ["\xE9\xB4\xA3",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF5"],

        ["\xF2\xF6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x9F"],
        ["\xE9\xB4\x9F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF6"],

        ["\xF2\xF7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x84"],
        ["\xE9\xB5\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF7"],

        ["\xF2\xF8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x95"],
        ["\xE9\xB4\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF8"],

        ["\xF2\xF9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\x92"],
        ["\xE9\xB4\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xF9"],

        ["\xF2\xFA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x81"],
        ["\xE9\xB5\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xFA"],

        ["\xF2\xFB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xBF"],
        ["\xE9\xB4\xBF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xFB"],

        ["\xF2\xFC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB4\xBE"],
        ["\xE9\xB4\xBE",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xFC"],

        ["\xF2\xFD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x86"],
        ["\xE9\xB5\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xFD"],

        ["\xF2\xFE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x88"],
        ["\xE9\xB5\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF2\xFE"],

        ["\xF3\xA1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x9D"],
        ["\xE9\xB5\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA1"],

        ["\xF3\xA2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x9E"],
        ["\xE9\xB5\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA2"],

        ["\xF3\xA3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xA4"],
        ["\xE9\xB5\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA3"],

        ["\xF3\xA4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x91"],
        ["\xE9\xB5\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA4"],

        ["\xF3\xA5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x90"],
        ["\xE9\xB5\x90",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA5"],

        ["\xF3\xA6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\x99"],
        ["\xE9\xB5\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA6"],

        ["\xF3\xA7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xB2"],
        ["\xE9\xB5\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA7"],

        ["\xF3\xA8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x89"],
        ["\xE9\xB6\x89",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA8"],

        ["\xF3\xA9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x87"],
        ["\xE9\xB6\x87",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xA9"],

        ["\xF3\xAA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xAB"],
        ["\xE9\xB6\xAB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xAA"],

        ["\xF3\xAB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xAF"],
        ["\xE9\xB5\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xAB"],

        ["\xF3\xAC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB5\xBA"],
        ["\xE9\xB5\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xAC"],

        ["\xF3\xAD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\x9A"],
        ["\xE9\xB6\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xAD"],

        ["\xF3\xAE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xA4"],
        ["\xE9\xB6\xA4",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xAE"],

        ["\xF3\xAF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xA9"],
        ["\xE9\xB6\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xAF"],

        ["\xF3\xB0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB2"],
        ["\xE9\xB6\xB2",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0"],

        ["\xF3\xB1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x84"],
        ["\xE9\xB7\x84",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1"],

        ["\xF3\xB2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x81"],
        ["\xE9\xB7\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2"],

        ["\xF3\xB3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xBB"],
        ["\xE9\xB6\xBB",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3"],

        ["\xF3\xB4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xB8"],
        ["\xE9\xB6\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4"],

        ["\xF3\xB5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB6\xBA"],
        ["\xE9\xB6\xBA",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5"],

        ["\xF3\xB6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x86"],
        ["\xE9\xB7\x86",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB6"],

        ["\xF3\xB7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x8F"],
        ["\xE9\xB7\x8F",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB7"],

        ["\xF3\xB8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x82"],
        ["\xE9\xB7\x82",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB8"],

        ["\xF3\xB9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x99"],
        ["\xE9\xB7\x99",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xB9"],

        ["\xF3\xBA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\x93"],
        ["\xE9\xB7\x93",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xBA"],

        ["\xF3\xBB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xB8"],
        ["\xE9\xB7\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xBB"],

        ["\xF3\xBC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xA6"],
        ["\xE9\xB7\xA6",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xBC"],

        ["\xF3\xBD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xAD"],
        ["\xE9\xB7\xAD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xBD"],

        ["\xF3\xBE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xAF"],
        ["\xE9\xB7\xAF",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xBE"],

        ["\xF3\xBF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB7\xBD"],
        ["\xE9\xB7\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xBF"],

        ["\xF3\xC0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9A"],
        ["\xE9\xB8\x9A",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC0"],

        ["\xF3\xC1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9B"],
        ["\xE9\xB8\x9B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC1"],

        ["\xF3\xC2",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB8\x9E"],
        ["\xE9\xB8\x9E",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC2"],

        ["\xF3\xC3",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xB5"],
        ["\xE9\xB9\xB5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC3"],

        ["\xF3\xC4",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xB9"],
        ["\xE9\xB9\xB9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC4"],

        ["\xF3\xC5",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xB9\xBD"],
        ["\xE9\xB9\xBD",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC5"],

        ["\xF3\xC6",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x81"],
        ["\xE9\xBA\x81",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC6"],

        ["\xF3\xC7",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x88"],
        ["\xE9\xBA\x88",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC7"],

        ["\xF3\xC8",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x8B"],
        ["\xE9\xBA\x8B",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC8"],

        ["\xF3\xC9",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x8C"],
        ["\xE9\xBA\x8C",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xC9"],

        ["\xF3\xCA",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x92"],
        ["\xE9\xBA\x92",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xCA"],

        ["\xF3\xCB",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x95"],
        ["\xE9\xBA\x95",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xCB"],

        ["\xF3\xCC",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x91"],
        ["\xE9\xBA\x91",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xCC"],

        ["\xF3\xCD",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\x9D"],
        ["\xE9\xBA\x9D",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xCD"],

        ["\xF3\xCE",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA5"],
        ["\xE9\xBA\xA5",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xCE"],

        ["\xF3\xCF",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xA9"],
        ["\xE9\xBA\xA9",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xCF"],

        ["\xF3\xD0",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xB8"],
        ["\xE9\xBA\xB8",'jef','utf8',{'INPUT_LAYOUT'=>'D'},"\xF3\xD0"],

        ["\xF3\xD1",'utf8','jef',{'INPUT_LAYOUT'=>'D'},"\xE9\xBA\xAA"],
        ["\xE9\xBA\xAA",'jef','utf8',{'INPUT_LAYOUT'=>'D'}