#############################################################
# This file was automatically generated on 2021-01-15.      #
#                                                           #
# Perl Bindings Version 2.1.29                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickIMU - Full fledged AHRS with 9 degrees of freedom

=cut

package Tinkerforge::BrickIMU;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a IMU Brick.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 16;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a IMU Brick.

=cut

use constant DEVICE_DISPLAY_NAME => 'IMU Brick';

=item CALLBACK_ACCELERATION

This constant is used with the register_callback() subroutine to specify
the CALLBACK_ACCELERATION callback.

=cut

use constant CALLBACK_ACCELERATION => 31;

=item CALLBACK_MAGNETIC_FIELD

This constant is used with the register_callback() subroutine to specify
the CALLBACK_MAGNETIC_FIELD callback.

=cut

use constant CALLBACK_MAGNETIC_FIELD => 32;

=item CALLBACK_ANGULAR_VELOCITY

This constant is used with the register_callback() subroutine to specify
the CALLBACK_ANGULAR_VELOCITY callback.

=cut

use constant CALLBACK_ANGULAR_VELOCITY => 33;

=item CALLBACK_ALL_DATA

This constant is used with the register_callback() subroutine to specify
the CALLBACK_ALL_DATA callback.

=cut

use constant CALLBACK_ALL_DATA => 34;

=item CALLBACK_ORIENTATION

This constant is used with the register_callback() subroutine to specify
the CALLBACK_ORIENTATION callback.

=cut

use constant CALLBACK_ORIENTATION => 35;

=item CALLBACK_QUATERNION

This constant is used with the register_callback() subroutine to specify
the CALLBACK_QUATERNION callback.

=cut

use constant CALLBACK_QUATERNION => 36;

=item FUNCTION_GET_ACCELERATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ACCELERATION => 1;

=item FUNCTION_GET_MAGNETIC_FIELD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_MAGNETIC_FIELD => 2;

=item FUNCTION_GET_ANGULAR_VELOCITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ANGULAR_VELOCITY => 3;

=item FUNCTION_GET_ALL_DATA

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ALL_DATA => 4;

=item FUNCTION_GET_ORIENTATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ORIENTATION => 5;

=item FUNCTION_GET_QUATERNION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_QUATERNION => 6;

=item FUNCTION_GET_IMU_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IMU_TEMPERATURE => 7;

=item FUNCTION_LEDS_ON

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_LEDS_ON => 8;

=item FUNCTION_LEDS_OFF

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_LEDS_OFF => 9;

=item FUNCTION_ARE_LEDS_ON

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_ARE_LEDS_ON => 10;

=item FUNCTION_SET_ACCELERATION_RANGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ACCELERATION_RANGE => 11;

=item FUNCTION_GET_ACCELERATION_RANGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ACCELERATION_RANGE => 12;

=item FUNCTION_SET_MAGNETOMETER_RANGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_MAGNETOMETER_RANGE => 13;

=item FUNCTION_GET_MAGNETOMETER_RANGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_MAGNETOMETER_RANGE => 14;

=item FUNCTION_SET_CONVERGENCE_SPEED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_CONVERGENCE_SPEED => 15;

=item FUNCTION_GET_CONVERGENCE_SPEED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CONVERGENCE_SPEED => 16;

=item FUNCTION_SET_CALIBRATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_CALIBRATION => 17;

=item FUNCTION_GET_CALIBRATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CALIBRATION => 18;

=item FUNCTION_SET_ACCELERATION_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ACCELERATION_PERIOD => 19;

=item FUNCTION_GET_ACCELERATION_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ACCELERATION_PERIOD => 20;

=item FUNCTION_SET_MAGNETIC_FIELD_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_MAGNETIC_FIELD_PERIOD => 21;

=item FUNCTION_GET_MAGNETIC_FIELD_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_MAGNETIC_FIELD_PERIOD => 22;

=item FUNCTION_SET_ANGULAR_VELOCITY_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ANGULAR_VELOCITY_PERIOD => 23;

=item FUNCTION_GET_ANGULAR_VELOCITY_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ANGULAR_VELOCITY_PERIOD => 24;

=item FUNCTION_SET_ALL_DATA_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ALL_DATA_PERIOD => 25;

=item FUNCTION_GET_ALL_DATA_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ALL_DATA_PERIOD => 26;

=item FUNCTION_SET_ORIENTATION_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ORIENTATION_PERIOD => 27;

=item FUNCTION_GET_ORIENTATION_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ORIENTATION_PERIOD => 28;

=item FUNCTION_SET_QUATERNION_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_QUATERNION_PERIOD => 29;

=item FUNCTION_GET_QUATERNION_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_QUATERNION_PERIOD => 30;

=item FUNCTION_ORIENTATION_CALCULATION_ON

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_ORIENTATION_CALCULATION_ON => 37;

=item FUNCTION_ORIENTATION_CALCULATION_OFF

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_ORIENTATION_CALCULATION_OFF => 38;

=item FUNCTION_IS_ORIENTATION_CALCULATION_ON

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_IS_ORIENTATION_CALCULATION_ON => 39;

=item FUNCTION_SET_SPITFP_BAUDRATE_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_SPITFP_BAUDRATE_CONFIG => 231;

=item FUNCTION_GET_SPITFP_BAUDRATE_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_BAUDRATE_CONFIG => 232;

=item FUNCTION_GET_SEND_TIMEOUT_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SEND_TIMEOUT_COUNT => 233;

=item FUNCTION_SET_SPITFP_BAUDRATE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_SPITFP_BAUDRATE => 234;

=item FUNCTION_GET_SPITFP_BAUDRATE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_BAUDRATE => 235;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 237;

=item FUNCTION_ENABLE_STATUS_LED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_ENABLE_STATUS_LED => 238;

=item FUNCTION_DISABLE_STATUS_LED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DISABLE_STATUS_LED => 239;

=item FUNCTION_IS_STATUS_LED_ENABLED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_IS_STATUS_LED_ENABLED => 240;

=item FUNCTION_GET_PROTOCOL1_BRICKLET_NAME

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_PROTOCOL1_BRICKLET_NAME => 241;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_WRITE_BRICKLET_PLUGIN

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_BRICKLET_PLUGIN => 246;

=item FUNCTION_READ_BRICKLET_PLUGIN

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_BRICKLET_PLUGIN => 247;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant CALIBRATION_TYPE_ACCELEROMETER_GAIN => 0;
use constant CALIBRATION_TYPE_ACCELEROMETER_BIAS => 1;
use constant CALIBRATION_TYPE_MAGNETOMETER_GAIN => 2;
use constant CALIBRATION_TYPE_MAGNETOMETER_BIAS => 3;
use constant CALIBRATION_TYPE_GYROSCOPE_GAIN => 4;
use constant CALIBRATION_TYPE_GYROSCOPE_BIAS => 5;
use constant COMMUNICATION_METHOD_NONE => 0;
use constant COMMUNICATION_METHOD_USB => 1;
use constant COMMUNICATION_METHOD_SPI_STACK => 2;
use constant COMMUNICATION_METHOD_CHIBI => 3;
use constant COMMUNICATION_METHOD_RS485 => 4;
use constant COMMUNICATION_METHOD_WIFI => 5;
use constant COMMUNICATION_METHOD_ETHERNET => 6;
use constant COMMUNICATION_METHOD_WIFI_V2 => 7;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 4], &DEVICE_IDENTIFIER, &DEVICE_DISPLAY_NAME);

	$self->{response_expected}->{&FUNCTION_GET_ACCELERATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_MAGNETIC_FIELD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ANGULAR_VELOCITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ALL_DATA} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ORIENTATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_QUATERNION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IMU_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_LEDS_ON} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_LEDS_OFF} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_ARE_LEDS_ON} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ACCELERATION_RANGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_ACCELERATION_RANGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_MAGNETOMETER_RANGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_MAGNETOMETER_RANGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_CONVERGENCE_SPEED} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_CONVERGENCE_SPEED} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_CALIBRATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_CALIBRATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ACCELERATION_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ACCELERATION_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_MAGNETIC_FIELD_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_MAGNETIC_FIELD_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ANGULAR_VELOCITY_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ANGULAR_VELOCITY_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ALL_DATA_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ALL_DATA_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ORIENTATION_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ORIENTATION_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_QUATERNION_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_QUATERNION_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_ORIENTATION_CALCULATION_ON} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_ORIENTATION_CALCULATION_OFF} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_IS_ORIENTATION_CALCULATION_ON} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_SPITFP_BAUDRATE_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_BAUDRATE_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SEND_TIMEOUT_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_SPITFP_BAUDRATE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_BAUDRATE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_ENABLE_STATUS_LED} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_DISABLE_STATUS_LED} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_IS_STATUS_LED_ENABLED} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_PROTOCOL1_BRICKLET_NAME} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_BRICKLET_PLUGIN} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_READ_BRICKLET_PLUGIN} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_ACCELERATION} = shared_clone([14, 's s s']);
	$self->{callback_formats}->{&CALLBACK_MAGNETIC_FIELD} = shared_clone([14, 's s s']);
	$self->{callback_formats}->{&CALLBACK_ANGULAR_VELOCITY} = shared_clone([14, 's s s']);
	$self->{callback_formats}->{&CALLBACK_ALL_DATA} = shared_clone([28, 's s s s s s s s s s']);
	$self->{callback_formats}->{&CALLBACK_ORIENTATION} = shared_clone([14, 's s s']);
	$self->{callback_formats}->{&CALLBACK_QUATERNION} = shared_clone([24, 'f f f f']);



	bless($self, $class);

	$ipcon->_add_device($self);

	return $self;
}


=item get_acceleration()

Returns the calibrated acceleration from the accelerometer for the
x, y and z axis.

If you want to get the acceleration periodically, it is recommended
to use the :cb:`Acceleration` callback and set the period with
:func:`Set Acceleration Period`.

=cut

sub get_acceleration
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ACCELERATION, [], '', 14, 's s s');
}

=item get_magnetic_field()

Returns the calibrated magnetic field from the magnetometer for the
x, y and z axis.

If you want to get the magnetic field periodically, it is recommended
to use the :cb:`Magnetic Field` callback and set the period with
:func:`Set Magnetic Field Period`.

=cut

sub get_magnetic_field
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_MAGNETIC_FIELD, [], '', 14, 's s s');
}

=item get_angular_velocity()

Returns the calibrated angular velocity from the gyroscope for the
x, y and z axis in °/14.375s (you have to divide by 14.375 to
get the value in °/s).

If you want to get the angular velocity periodically, it is recommended
to use the :cb:`Angular Velocity` callback and set the period with
:func:`Set Angular Velocity Period`.

=cut

sub get_angular_velocity
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ANGULAR_VELOCITY, [], '', 14, 's s s');
}

=item get_all_data()

Returns the data from :func:`Get Acceleration`, :func:`Get Magnetic Field`
and :func:`Get Angular Velocity` as well as the temperature of the IMU Brick.

If you want to get the data periodically, it is recommended
to use the :cb:`All Data` callback and set the period with
:func:`Set All Data Period`.

=cut

sub get_all_data
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ALL_DATA, [], '', 28, 's s s s s s s s s s');
}

=item get_orientation()

Returns the current orientation (roll, pitch, yaw) of the IMU Brick as Euler
angles. Note that Euler angles always experience a
`gimbal lock <https://en.wikipedia.org/wiki/Gimbal_lock>`__.

We recommend that you use quaternions instead.

The order to sequence in which the orientation values should be applied is
roll, yaw, pitch.

If you want to get the orientation periodically, it is recommended
to use the :cb:`Orientation` callback and set the period with
:func:`Set Orientation Period`.

=cut

sub get_orientation
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ORIENTATION, [], '', 14, 's s s');
}

=item get_quaternion()

Returns the current orientation (x, y, z, w) of the IMU as
`quaternions <https://en.wikipedia.org/wiki/Quaternions_and_spatial_rotation>`__.

You can go from quaternions to Euler angles with the following formula::

 xAngle = atan2(2*y*w - 2*x*z, 1 - 2*y*y - 2*z*z)
 yAngle = atan2(2*x*w - 2*y*z, 1 - 2*x*x - 2*z*z)
 zAngle =  asin(2*x*y + 2*z*w)

This process is not reversible, because of the
`gimbal lock <https://en.wikipedia.org/wiki/Gimbal_lock>`__.

It is also possible to calculate independent angles. You can calculate
yaw, pitch and roll in a right-handed vehicle coordinate system according to
DIN70000 with::

 yaw   =  atan2(2*x*y + 2*w*z, w*w + x*x - y*y - z*z)
 pitch = -asin(2*w*y - 2*x*z)
 roll  = -atan2(2*y*z + 2*w*x, -w*w + x*x + y*y - z*z))

Converting the quaternions to an OpenGL transformation matrix is
possible with the following formula::

 matrix = [[1 - 2*(y*y + z*z),     2*(x*y - w*z),     2*(x*z + w*y), 0],
           [    2*(x*y + w*z), 1 - 2*(x*x + z*z),     2*(y*z - w*x), 0],
           [    2*(x*z - w*y),     2*(y*z + w*x), 1 - 2*(x*x + y*y), 0],
           [                0,                 0,                 0, 1]]

If you want to get the quaternions periodically, it is recommended
to use the :cb:`Quaternion` callback and set the period with
:func:`Set Quaternion Period`.

=cut

sub get_quaternion
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_QUATERNION, [], '', 24, 'f f f f');
}

=item get_imu_temperature()

Returns the temperature of the IMU Brick.

=cut

sub get_imu_temperature
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_IMU_TEMPERATURE, [], '', 10, 's');
}

=item leds_on()

Turns the orientation and direction LEDs of the IMU Brick on.

=cut

sub leds_on
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_LEDS_ON, [], '', 0, '');
}

=item leds_off()

Turns the orientation and direction LEDs of the IMU Brick off.

=cut

sub leds_off
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_LEDS_OFF, [], '', 0, '');
}

=item are_leds_on()

Returns *true* if the orientation and direction LEDs of the IMU Brick
are on, *false* otherwise.

=cut

sub are_leds_on
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_ARE_LEDS_ON, [], '', 9, '?');
}

=item set_acceleration_range()

Not implemented yet.

=cut

sub set_acceleration_range
{
	my ($self, $range) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_ACCELERATION_RANGE, [$range], 'C', 0, '');
}

=item get_acceleration_range()

Not implemented yet.

=cut

sub get_acceleration_range
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ACCELERATION_RANGE, [], '', 9, 'C');
}

=item set_magnetometer_range()

Not implemented yet.

=cut

sub set_magnetometer_range
{
	my ($self, $range) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_MAGNETOMETER_RANGE, [$range], 'C', 0, '');
}

=item get_magnetometer_range()

Not implemented yet.

=cut

sub get_magnetometer_range
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_MAGNETOMETER_RANGE, [], '', 9, 'C');
}

=item set_convergence_speed()

Sets the convergence speed of the IMU Brick. The convergence speed
determines how the different sensor measurements are fused.

If the orientation of the IMU Brick is off by 10° and the convergence speed is
set to 20°/s, it will take 0.5s until the orientation is corrected. However,
if the correct orientation is reached and the convergence speed is too high,
the orientation will fluctuate with the fluctuations of the accelerometer and
the magnetometer.

If you set the convergence speed to 0, practically only the gyroscope is used
to calculate the orientation. This gives very smooth movements, but errors of the
gyroscope will not be corrected. If you set the convergence speed to something
above 500, practically only the magnetometer and the accelerometer are used to
calculate the orientation. In this case the movements are abrupt and the values
will fluctuate, but there won't be any errors that accumulate over time.

In an application with high angular velocities, we recommend a high convergence
speed, so the errors of the gyroscope can be corrected fast. In applications with
only slow movements we recommend a low convergence speed. You can change the
convergence speed on the fly. So it is possible (and recommended) to increase
the convergence speed before an abrupt movement and decrease it afterwards
again.

You might want to play around with the convergence speed in the Brick Viewer to
get a feeling for a good value for your application.

=cut

sub set_convergence_speed
{
	my ($self, $speed) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_CONVERGENCE_SPEED, [$speed], 'S', 0, '');
}

=item get_convergence_speed()

Returns the convergence speed as set by :func:`Set Convergence Speed`.

=cut

sub get_convergence_speed
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CONVERGENCE_SPEED, [], '', 10, 'S');
}

=item set_calibration()

There are several different types that can be calibrated:

.. csv-table::
 :header: "Type", "Description", "Values"
 :widths: 10, 30, 110

 "0",    "Accelerometer Gain", "``[mul x, mul y, mul z, div x, div y, div z, 0, 0, 0, 0]``"
 "1",    "Accelerometer Bias", "``[bias x, bias y, bias z, 0, 0, 0, 0, 0, 0, 0]``"
 "2",    "Magnetometer Gain",  "``[mul x, mul y, mul z, div x, div y, div z, 0, 0, 0, 0]``"
 "3",    "Magnetometer Bias",  "``[bias x, bias y, bias z, 0, 0, 0, 0, 0, 0, 0]``"
 "4",    "Gyroscope Gain",     "``[mul x, mul y, mul z, div x, div y, div z, 0, 0, 0, 0]``"
 "5",    "Gyroscope Bias",     "``[bias xl, bias yl, bias zl, temp l, bias xh, bias yh, bias zh, temp h, 0, 0]``"

The calibration via gain and bias is done with the following formula::

 new_value = (bias + orig_value) * gain_mul / gain_div

If you really want to write your own calibration software, please keep
in mind that you first have to undo the old calibration (set bias to 0 and
gain to 1/1) and that you have to average over several thousand values
to obtain a usable result in the end.

The gyroscope bias is highly dependent on the temperature, so you have to
calibrate the bias two times with different temperatures. The values ``xl``,
``yl``, ``zl`` and ``temp l`` are the bias for ``x``, ``y``, ``z`` and the
corresponding temperature for a low temperature. The values ``xh``, ``yh``,
``zh`` and ``temp h`` are the same for a high temperatures. The temperature
difference should be at least 5°C. If you have a temperature where the
IMU Brick is mostly used, you should use this temperature for one of the
sampling points.

.. note::
 We highly recommend that you use the Brick Viewer to calibrate your
 IMU Brick.

=cut

sub set_calibration
{
	my ($self, $typ, $data) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_CALIBRATION, [$typ, $data], 'C s10', 0, '');
}

=item get_calibration()

Returns the calibration for a given type as set by :func:`Set Calibration`.

=cut

sub get_calibration
{
	my ($self, $typ) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CALIBRATION, [$typ], 'C', 28, 's10');
}

=item set_acceleration_period()

Sets the period with which the :cb:`Acceleration` callback is triggered
periodically. A value of 0 turns the callback off.

=cut

sub set_acceleration_period
{
	my ($self, $period) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_ACCELERATION_PERIOD, [$period], 'L', 0, '');
}

=item get_acceleration_period()

Returns the period as set by :func:`Set Acceleration Period`.

=cut

sub get_acceleration_period
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ACCELERATION_PERIOD, [], '', 12, 'L');
}

=item set_magnetic_field_period()

Sets the period with which the :cb:`Magnetic Field` callback is
triggered periodically. A value of 0 turns the callback off.

=cut

sub set_magnetic_field_period
{
	my ($self, $period) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_MAGNETIC_FIELD_PERIOD, [$period], 'L', 0, '');
}

=item get_magnetic_field_period()

Returns the period as set by :func:`Set Magnetic Field Period`.

=cut

sub get_magnetic_field_period
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_MAGNETIC_FIELD_PERIOD, [], '', 12, 'L');
}

=item set_angular_velocity_period()

Sets the period with which the :cb:`Angular Velocity` callback is
triggered periodically. A value of 0 turns the callback off.

=cut

sub set_angular_velocity_period
{
	my ($self, $period) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_ANGULAR_VELOCITY_PERIOD, [$period], 'L', 0, '');
}

=item get_angular_velocity_period()

Returns the period as set by :func:`Set Angular Velocity Period`.

=cut

sub get_angular_velocity_period
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ANGULAR_VELOCITY_PERIOD, [], '', 12, 'L');
}

=item set_all_data_period()

Sets the period with which the :cb:`All Data` callback is triggered
periodically. A value of 0 turns the callback off.

=cut

sub set_all_data_period
{
	my ($self, $period) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_ALL_DATA_PERIOD, [$period], 'L', 0, '');
}

=item get_all_data_period()

Returns the period as set by :func:`Set All Data Period`.

=cut

sub get_all_data_period
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ALL_DATA_PERIOD, [], '', 12, 'L');
}

=item set_orientation_period()

Sets the period with which the :cb:`Orientation` callback is triggered
periodically. A value of 0 turns the callback off.

=cut

sub set_orientation_period
{
	my ($self, $period) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_ORIENTATION_PERIOD, [$period], 'L', 0, '');
}

=item get_orientation_period()

Returns the period as set by :func:`Set Orientation Period`.

=cut

sub get_orientation_period
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ORIENTATION_PERIOD, [], '', 12, 'L');
}

=item set_quaternion_period()

Sets the period with which the :cb:`Quaternion` callback is triggered
periodically. A value of 0 turns the callback off.

=cut

sub set_quaternion_period
{
	my ($self, $period) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_QUATERNION_PERIOD, [$period], 'L', 0, '');
}

=item get_quaternion_period()

Returns the period as set by :func:`Set Quaternion Period`.

=cut

sub get_quaternion_period
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_QUATERNION_PERIOD, [], '', 12, 'L');
}

=item orientation_calculation_on()

Turns the orientation calculation of the IMU Brick on.

As default the calculation is on.

.. versionadded:: 2.0.2$nbsp;(Firmware)

=cut

sub orientation_calculation_on
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_ORIENTATION_CALCULATION_ON, [], '', 0, '');
}

=item orientation_calculation_off()

Turns the orientation calculation of the IMU Brick off.

If the calculation is off, :func:`Get Orientation` will return
the last calculated value until the calculation is turned on again.

The trigonometric functions that are needed to calculate the orientation
are very expensive. We recommend to turn the orientation calculation
off if the orientation is not needed, to free calculation time for the
sensor fusion algorithm.

As default the calculation is on.

.. versionadded:: 2.0.2$nbsp;(Firmware)

=cut

sub orientation_calculation_off
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_ORIENTATION_CALCULATION_OFF, [], '', 0, '');
}

=item is_orientation_calculation_on()

Returns *true* if the orientation calculation of the IMU Brick
is on, *false* otherwise.

.. versionadded:: 2.0.2$nbsp;(Firmware)

=cut

sub is_orientation_calculation_on
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_IS_ORIENTATION_CALCULATION_ON, [], '', 9, '?');
}

=item set_spitfp_baudrate_config()

The SPITF protocol can be used with a dynamic baudrate. If the dynamic baudrate is
enabled, the Brick will try to adapt the baudrate for the communication
between Bricks and Bricklets according to the amount of data that is transferred.

The baudrate will be increased exponentially if lots of data is sent/received and
decreased linearly if little data is sent/received.

This lowers the baudrate in applications where little data is transferred (e.g.
a weather station) and increases the robustness. If there is lots of data to transfer
(e.g. Thermal Imaging Bricklet) it automatically increases the baudrate as needed.

In cases where some data has to transferred as fast as possible every few seconds
(e.g. RS485 Bricklet with a high baudrate but small payload) you may want to turn
the dynamic baudrate off to get the highest possible performance.

The maximum value of the baudrate can be set per port with the function
:func:`Set SPITFP Baudrate`. If the dynamic baudrate is disabled, the baudrate
as set by :func:`Set SPITFP Baudrate` will be used statically.

.. versionadded:: 2.3.5$nbsp;(Firmware)

=cut

sub set_spitfp_baudrate_config
{
	my ($self, $enable_dynamic_baudrate, $minimum_dynamic_baudrate) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_SPITFP_BAUDRATE_CONFIG, [$enable_dynamic_baudrate, $minimum_dynamic_baudrate], '? L', 0, '');
}

=item get_spitfp_baudrate_config()

Returns the baudrate config, see :func:`Set SPITFP Baudrate Config`.

.. versionadded:: 2.3.5$nbsp;(Firmware)

=cut

sub get_spitfp_baudrate_config
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SPITFP_BAUDRATE_CONFIG, [], '', 13, '? L');
}

=item get_send_timeout_count()

Returns the timeout count for the different communication methods.

The methods 0-2 are available for all Bricks, 3-7 only for Master Bricks.

This function is mostly used for debugging during development, in normal operation
the counters should nearly always stay at 0.

.. versionadded:: 2.3.3$nbsp;(Firmware)

=cut

sub get_send_timeout_count
{
	my ($self, $communication_method) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SEND_TIMEOUT_COUNT, [$communication_method], 'C', 12, 'L');
}

=item set_spitfp_baudrate()

Sets the baudrate for a specific Bricklet port.

If you want to increase the throughput of Bricklets you can increase
the baudrate. If you get a high error count because of high
interference (see :func:`Get SPITFP Error Count`) you can decrease the
baudrate.

If the dynamic baudrate feature is enabled, the baudrate set by this
function corresponds to the maximum baudrate (see :func:`Set SPITFP Baudrate Config`).

Regulatory testing is done with the default baudrate. If CE compatibility
or similar is necessary in your applications we recommend to not change
the baudrate.

.. versionadded:: 2.3.3$nbsp;(Firmware)

=cut

sub set_spitfp_baudrate
{
	my ($self, $bricklet_port, $baudrate) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_SPITFP_BAUDRATE, [$bricklet_port, $baudrate], 'a L', 0, '');
}

=item get_spitfp_baudrate()

Returns the baudrate for a given Bricklet port, see :func:`Set SPITFP Baudrate`.

.. versionadded:: 2.3.3$nbsp;(Firmware)

=cut

sub get_spitfp_baudrate
{
	my ($self, $bricklet_port) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SPITFP_BAUDRATE, [$bricklet_port], 'a', 12, 'L');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ACK checksum errors,
* message checksum errors,
* framing errors and
* overflow errors.

The errors counts are for errors that occur on the Brick side. All
Bricklets have a similar function that returns the errors on the Bricklet side.

.. versionadded:: 2.3.3$nbsp;(Firmware)

=cut

sub get_spitfp_error_count
{
	my ($self, $bricklet_port) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [$bricklet_port], 'a', 24, 'L L L L');
}

=item enable_status_led()

Enables the status LED.

The status LED is the blue LED next to the USB connector. If enabled is is
on and it flickers if data is transfered. If disabled it is always off.

The default state is enabled.

.. versionadded:: 2.3.1$nbsp;(Firmware)

=cut

sub enable_status_led
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_ENABLE_STATUS_LED, [], '', 0, '');
}

=item disable_status_led()

Disables the status LED.

The status LED is the blue LED next to the USB connector. If enabled is is
on and it flickers if data is transfered. If disabled it is always off.

The default state is enabled.

.. versionadded:: 2.3.1$nbsp;(Firmware)

=cut

sub disable_status_led
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_DISABLE_STATUS_LED, [], '', 0, '');
}

=item is_status_led_enabled()

Returns *true* if the status LED is enabled, *false* otherwise.

.. versionadded:: 2.3.1$nbsp;(Firmware)

=cut

sub is_status_led_enabled
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_IS_STATUS_LED_ENABLED, [], '', 9, '?');
}

=item get_protocol1_bricklet_name()

Returns the firmware and protocol version and the name of the Bricklet for a
given port.

This functions sole purpose is to allow automatic flashing of v1.x.y Bricklet
plugins.

=cut

sub get_protocol1_bricklet_name
{
	my ($self, $port) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_PROTOCOL1_BRICKLET_NAME, [$port], 'a', 52, 'C C3 Z40');
}

=item get_chip_temperature()

Returns the temperature as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has an
accuracy of ±15%. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 10, 's');
}

=item reset()

Calling this function will reset the Brick. Calling this function
on a Brick inside of a stack will reset the whole stack.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_RESET, [], '', 0, '');
}

=item write_bricklet_plugin()

Writes 32 bytes of firmware to the bricklet attached at the given port.
The bytes are written to the position offset * 32.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub write_bricklet_plugin
{
	my ($self, $port, $offset, $chunk) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_WRITE_BRICKLET_PLUGIN, [$port, $offset, $chunk], 'a C C32', 0, '');
}

=item read_bricklet_plugin()

Reads 32 bytes of firmware from the bricklet attached at the given port.
The bytes are read starting at the position offset * 32.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub read_bricklet_plugin
{
	my ($self, $port, $offset) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_READ_BRICKLET_PLUGIN, [$port, $offset], 'a C', 40, 'C32');
}

=item get_identity()

Returns the UID, the UID where the Brick is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position is the position in the stack from '0' (bottom) to '8' (top).

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 33, 'Z8 Z8 a C3 C3 S');
}

=back
=cut

1;
