#############################################################
# This file was automatically generated on 2022-05-11.      #
#                                                           #
# Perl Bindings Version 2.1.31                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletBarometer - Measures air pressure and altitude changes

=cut

package Tinkerforge::BrickletBarometer;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a Barometer Bricklet.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 221;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a Barometer Bricklet.

=cut

use constant DEVICE_DISPLAY_NAME => 'Barometer Bricklet';

=item CALLBACK_AIR_PRESSURE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_AIR_PRESSURE callback.

=cut

use constant CALLBACK_AIR_PRESSURE => 15;

=item CALLBACK_ALTITUDE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_ALTITUDE callback.

=cut

use constant CALLBACK_ALTITUDE => 16;

=item CALLBACK_AIR_PRESSURE_REACHED

This constant is used with the register_callback() subroutine to specify
the CALLBACK_AIR_PRESSURE_REACHED callback.

=cut

use constant CALLBACK_AIR_PRESSURE_REACHED => 17;

=item CALLBACK_ALTITUDE_REACHED

This constant is used with the register_callback() subroutine to specify
the CALLBACK_ALTITUDE_REACHED callback.

=cut

use constant CALLBACK_ALTITUDE_REACHED => 18;

=item FUNCTION_GET_AIR_PRESSURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_AIR_PRESSURE => 1;

=item FUNCTION_GET_ALTITUDE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ALTITUDE => 2;

=item FUNCTION_SET_AIR_PRESSURE_CALLBACK_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_AIR_PRESSURE_CALLBACK_PERIOD => 3;

=item FUNCTION_GET_AIR_PRESSURE_CALLBACK_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_AIR_PRESSURE_CALLBACK_PERIOD => 4;

=item FUNCTION_SET_ALTITUDE_CALLBACK_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ALTITUDE_CALLBACK_PERIOD => 5;

=item FUNCTION_GET_ALTITUDE_CALLBACK_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ALTITUDE_CALLBACK_PERIOD => 6;

=item FUNCTION_SET_AIR_PRESSURE_CALLBACK_THRESHOLD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_AIR_PRESSURE_CALLBACK_THRESHOLD => 7;

=item FUNCTION_GET_AIR_PRESSURE_CALLBACK_THRESHOLD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_AIR_PRESSURE_CALLBACK_THRESHOLD => 8;

=item FUNCTION_SET_ALTITUDE_CALLBACK_THRESHOLD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ALTITUDE_CALLBACK_THRESHOLD => 9;

=item FUNCTION_GET_ALTITUDE_CALLBACK_THRESHOLD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ALTITUDE_CALLBACK_THRESHOLD => 10;

=item FUNCTION_SET_DEBOUNCE_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_DEBOUNCE_PERIOD => 11;

=item FUNCTION_GET_DEBOUNCE_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_DEBOUNCE_PERIOD => 12;

=item FUNCTION_SET_REFERENCE_AIR_PRESSURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_REFERENCE_AIR_PRESSURE => 13;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 14;

=item FUNCTION_GET_REFERENCE_AIR_PRESSURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_REFERENCE_AIR_PRESSURE => 19;

=item FUNCTION_SET_AVERAGING

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_AVERAGING => 20;

=item FUNCTION_GET_AVERAGING

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_AVERAGING => 21;

=item FUNCTION_SET_I2C_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_I2C_MODE => 22;

=item FUNCTION_GET_I2C_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_I2C_MODE => 23;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant THRESHOLD_OPTION_OFF => 'x';
use constant THRESHOLD_OPTION_OUTSIDE => 'o';
use constant THRESHOLD_OPTION_INSIDE => 'i';
use constant THRESHOLD_OPTION_SMALLER => '<';
use constant THRESHOLD_OPTION_GREATER => '>';
use constant I2C_MODE_FAST => 0;
use constant I2C_MODE_SLOW => 1;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 2], &DEVICE_IDENTIFIER, &DEVICE_DISPLAY_NAME);

	$self->{response_expected}->{&FUNCTION_GET_AIR_PRESSURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ALTITUDE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_AIR_PRESSURE_CALLBACK_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_AIR_PRESSURE_CALLBACK_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ALTITUDE_CALLBACK_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ALTITUDE_CALLBACK_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_AIR_PRESSURE_CALLBACK_THRESHOLD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_AIR_PRESSURE_CALLBACK_THRESHOLD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ALTITUDE_CALLBACK_THRESHOLD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ALTITUDE_CALLBACK_THRESHOLD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_DEBOUNCE_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_DEBOUNCE_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_REFERENCE_AIR_PRESSURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_REFERENCE_AIR_PRESSURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_AVERAGING} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_AVERAGING} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_I2C_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_I2C_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_AIR_PRESSURE} = shared_clone([12, 'l']);
	$self->{callback_formats}->{&CALLBACK_ALTITUDE} = shared_clone([12, 'l']);
	$self->{callback_formats}->{&CALLBACK_AIR_PRESSURE_REACHED} = shared_clone([12, 'l']);
	$self->{callback_formats}->{&CALLBACK_ALTITUDE_REACHED} = shared_clone([12, 'l']);



	bless($self, $class);

	$ipcon->_add_device($self);

	return $self;
}


=item get_air_pressure()

Returns the air pressure of the air pressure sensor.

If you want to get the air pressure periodically, it is recommended to use the
:cb:`Air Pressure` callback and set the period with
:func:`Set Air Pressure Callback Period`.

=cut

sub get_air_pressure
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_AIR_PRESSURE, [], '', 12, 'l');
}

=item get_altitude()

Returns the relative altitude of the air pressure sensor. The value is
calculated based on the difference between the current air pressure
and the reference air pressure that can be set with :func:`Set Reference Air Pressure`.

If you want to get the altitude periodically, it is recommended to use the
:cb:`Altitude` callback and set the period with
:func:`Set Altitude Callback Period`.

=cut

sub get_altitude
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ALTITUDE, [], '', 12, 'l');
}

=item set_air_pressure_callback_period()

Sets the period with which the :cb:`Air Pressure` callback is triggered
periodically. A value of 0 turns the callback off.

The :cb:`Air Pressure` callback is only triggered if the air pressure has
changed since the last triggering.

=cut

sub set_air_pressure_callback_period
{
	my ($self, $period) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_AIR_PRESSURE_CALLBACK_PERIOD, [$period], 'L', 0, '');
}

=item get_air_pressure_callback_period()

Returns the period as set by :func:`Set Air Pressure Callback Period`.

=cut

sub get_air_pressure_callback_period
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_AIR_PRESSURE_CALLBACK_PERIOD, [], '', 12, 'L');
}

=item set_altitude_callback_period()

Sets the period with which the :cb:`Altitude` callback is triggered
periodically. A value of 0 turns the callback off.

The :cb:`Altitude` callback is only triggered if the altitude has changed since
the last triggering.

=cut

sub set_altitude_callback_period
{
	my ($self, $period) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_ALTITUDE_CALLBACK_PERIOD, [$period], 'L', 0, '');
}

=item get_altitude_callback_period()

Returns the period as set by :func:`Set Altitude Callback Period`.

=cut

sub get_altitude_callback_period
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ALTITUDE_CALLBACK_PERIOD, [], '', 12, 'L');
}

=item set_air_pressure_callback_threshold()

Sets the thresholds for the :cb:`Air Pressure Reached` callback.

The following options are possible:

.. csv-table::
 :header: "Option", "Description"
 :widths: 10, 100

 "'x'",    "Callback is turned off"
 "'o'",    "Callback is triggered when the air pressure is *outside* the min and max values"
 "'i'",    "Callback is triggered when the air pressure is *inside* the min and max values"
 "'<'",    "Callback is triggered when the air pressure is smaller than the min value (max is ignored)"
 "'>'",    "Callback is triggered when the air pressure is greater than the min value (max is ignored)"

=cut

sub set_air_pressure_callback_threshold
{
	my ($self, $option, $min, $max) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_AIR_PRESSURE_CALLBACK_THRESHOLD, [$option, $min, $max], 'a l l', 0, '');
}

=item get_air_pressure_callback_threshold()

Returns the threshold as set by :func:`Set Air Pressure Callback Threshold`.

=cut

sub get_air_pressure_callback_threshold
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_AIR_PRESSURE_CALLBACK_THRESHOLD, [], '', 17, 'a l l');
}

=item set_altitude_callback_threshold()

Sets the thresholds for the :cb:`Altitude Reached` callback.

The following options are possible:

.. csv-table::
 :header: "Option", "Description"
 :widths: 10, 100

 "'x'",    "Callback is turned off"
 "'o'",    "Callback is triggered when the altitude is *outside* the min and max values"
 "'i'",    "Callback is triggered when the altitude is *inside* the min and max values"
 "'<'",    "Callback is triggered when the altitude is smaller than the min value (max is ignored)"
 "'>'",    "Callback is triggered when the altitude is greater than the min value (max is ignored)"

=cut

sub set_altitude_callback_threshold
{
	my ($self, $option, $min, $max) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_ALTITUDE_CALLBACK_THRESHOLD, [$option, $min, $max], 'a l l', 0, '');
}

=item get_altitude_callback_threshold()

Returns the threshold as set by :func:`Set Altitude Callback Threshold`.

=cut

sub get_altitude_callback_threshold
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ALTITUDE_CALLBACK_THRESHOLD, [], '', 17, 'a l l');
}

=item set_debounce_period()

Sets the period with which the threshold callbacks

* :cb:`Air Pressure Reached`,
* :cb:`Altitude Reached`

are triggered, if the thresholds

* :func:`Set Air Pressure Callback Threshold`,
* :func:`Set Altitude Callback Threshold`

keep being reached.

=cut

sub set_debounce_period
{
	my ($self, $debounce) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_DEBOUNCE_PERIOD, [$debounce], 'L', 0, '');
}

=item get_debounce_period()

Returns the debounce period as set by :func:`Set Debounce Period`.

=cut

sub get_debounce_period
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_DEBOUNCE_PERIOD, [], '', 12, 'L');
}

=item set_reference_air_pressure()

Sets the reference air pressure for the altitude calculation.
Setting the reference to the current air pressure results in a calculated
altitude of 0cm. Passing 0 is a shortcut for passing the current air pressure as
reference.

Well known reference values are the Q codes
`QNH <https://en.wikipedia.org/wiki/QNH>`__ and
`QFE <https://en.wikipedia.org/wiki/Mean_sea_level_pressure#Mean_sea_level_pressure>`__
used in aviation.

=cut

sub set_reference_air_pressure
{
	my ($self, $air_pressure) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_REFERENCE_AIR_PRESSURE, [$air_pressure], 'l', 0, '');
}

=item get_chip_temperature()

Returns the temperature of the air pressure sensor.

This temperature is used internally for temperature compensation of the air
pressure measurement. It is not as accurate as the temperature measured by the
:ref:`temperature_bricklet` or the :ref:`temperature_ir_bricklet`.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 10, 's');
}

=item get_reference_air_pressure()

Returns the reference air pressure as set by :func:`Set Reference Air Pressure`.

=cut

sub get_reference_air_pressure
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_REFERENCE_AIR_PRESSURE, [], '', 12, 'l');
}

=item set_averaging()

Sets the different averaging parameters. It is possible to set
the length of a normal averaging for the temperature and pressure,
as well as an additional length of a
`moving average <https://en.wikipedia.org/wiki/Moving_average>`__
for the pressure. The moving average is calculated from the normal
averages.  There is no moving average for the temperature.

Setting the all three parameters to 0 will turn the averaging
completely off. If the averaging is off, there is lots of noise
on the data, but the data is without delay. Thus we recommend
to turn the averaging off if the Barometer Bricklet data is
to be used for sensor fusion with other sensors.

.. versionadded:: 2.0.1$nbsp;(Plugin)

=cut

sub set_averaging
{
	my ($self, $moving_average_pressure, $average_pressure, $average_temperature) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_AVERAGING, [$moving_average_pressure, $average_pressure, $average_temperature], 'C C C', 0, '');
}

=item get_averaging()

Returns the averaging configuration as set by :func:`Set Averaging`.

.. versionadded:: 2.0.1$nbsp;(Plugin)

=cut

sub get_averaging
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_AVERAGING, [], '', 11, 'C C C');
}

=item set_i2c_mode()

Sets the I2C mode. Possible modes are:

* 0: Fast (400kHz)
* 1: Slow (100kHz)

If you have problems with obvious outliers in the
Barometer Bricklet measurements, they may be caused by EMI issues.
In this case it may be helpful to lower the I2C speed.

It is however not recommended to lower the I2C speed in applications where
a high throughput needs to be achieved.

.. versionadded:: 2.0.3$nbsp;(Plugin)

=cut

sub set_i2c_mode
{
	my ($self, $mode) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_I2C_MODE, [$mode], 'C', 0, '');
}

=item get_i2c_mode()

Returns the I2C mode as set by :func:`Set I2C Mode`.

.. versionadded:: 2.0.3$nbsp;(Plugin)

=cut

sub get_i2c_mode
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_I2C_MODE, [], '', 9, 'C');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
A Bricklet connected to an :ref:`Isolator Bricklet <isolator_bricklet>` is always at
position 'z'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 33, 'Z8 Z8 a C3 C3 S');
}

=back
=cut

1;
