/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils;

import com.javonet.utils.CommandType;
import com.javonet.utils.RuntimeName;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;

public class Command {
    private final RuntimeName runtimeName;
    private final CommandType commandType;
    private Object[] payload = new Object[0];

    public Command(RuntimeName runtimeName, CommandType commandType, Object[] payload) {
        this.runtimeName = runtimeName;
        this.commandType = commandType;
        this.payload = payload;
    }

    public int getPayloadSize() {
        return this.payload.length;
    }

    public String payloadToString() {
        StringBuilder sb = new StringBuilder();
        for (Object payloadItem : this.payload) {
            sb.append((String)payloadItem);
            sb.append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    public String toString() {
        return (Object)((Object)this.runtimeName) + " " + (Object)((Object)this.commandType) + " " + Arrays.toString(this.payload);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Command that = (Command)o;
        return this.runtimeName == that.runtimeName && this.commandType == that.commandType && Arrays.equals(this.payload, that.payload);
    }

    public static Command createResponse(Object response, RuntimeName runtimeName) {
        return new Command(runtimeName, CommandType.VALUE, new Object[]{response});
    }

    public static Command createReference(Object response, RuntimeName runtimeName) {
        return new Command(runtimeName, CommandType.REFERENCE, new Object[]{response});
    }

    public static Command createArrayResponse(Object response, RuntimeName runtimeName) {
        return new Command(runtimeName, CommandType.ARRAY, new Object[]{response});
    }

    public int hashCode() {
        return 31 * (Objects.hash(new Object[]{this.runtimeName, this.commandType}) + Arrays.hashCode(this.getHashablePayload()));
    }

    private Object[] getHashablePayload() {
        switch (this.commandType) {
            case VALUE: 
            case LOAD_LIBRARY: 
            case CREATE_INSTANCE: 
            case GET_TYPE: {
                return new Object[]{this.payload[0]};
            }
            case GET_STATIC_FIELD: 
            case SET_STATIC_FIELD: 
            case GET_MODULE: 
            case INVOKE_STATIC_METHOD: 
            case INVOKE_INSTANCE_METHOD: {
                return new Object[]{this.payload[0], this.payload[1]};
            }
        }
        throw new RuntimeException((Object)((Object)this.commandType) + " payload size not implemented");
    }

    public RuntimeName getRuntimeName() {
        return this.runtimeName;
    }

    public CommandType getCommandType() {
        return this.commandType;
    }

    public Object[] getPayload() {
        return this.payload;
    }

    public void setPayload(Object obj, int i) {
        this.payload[i] = obj;
    }

    public Command dropFirstPayloadArg() {
        return new Command(this.runtimeName, this.commandType, Arrays.stream(this.payload).skip(1L).toArray());
    }

    public Command addArgToPayload(Object arg) {
        return new Command(this.runtimeName, this.commandType, Stream.concat(Arrays.stream(this.payload), Stream.of(arg)).toArray());
    }

    public Command appendArgumentToPayload(Object arg) {
        if (arg == null) {
            return new Command(this.runtimeName, this.commandType, this.payload);
        }
        return new Command(this.runtimeName, this.commandType, Stream.concat(Stream.of(arg), Arrays.stream(this.payload)).toArray());
    }
}

