use strict;
use warnings;
use lib 'lib';
use aliased 'Javonet::Core::Receiver::Receiver' => 'Receiver', qw(send_command);
use LWP::UserAgent;
use Test::More qw(no_plan);

my %PORTS = (
    'CLR' => 57992,
    'JVM' => 8080,
    'NETCORE' => 5000,
    'PYTHON' => 8000,
    'RUBY' => 4567,
    'Nodejs' => 5001
);

my $payload = '[1, 2, 3, 4]';
my $ua = LWP::UserAgent->new();

my @list = (4,1,1,33,67,58,92,74,65,86,50,48,92,74,65,86,50,48,92,115,114,99,92,112,101,114,108,92,100,97,116,97,95,115,101,101,100,1,18,68,97,116,97,83,101,101,100,58,58,68,97,116,97,83,101,101,100,1,11,68,97,116,97,83,101,101,100,46,112,109);

my @array_send_command_response =(4,0,1,26,76,105,98,114,97,114,121,32,108,111,97,100,101,100,32,115,117,99,99,101,115,102,117,108,108,121);


SKIP: {
    # cmp_ok(scalar Receiver->send_command(@list), '>=', 0, 'send command');
    skip "ws are not started", 1 eq 1;
    cmp_ok(Javonet::Core::Receiver::Receiver->send_command(@list), 'eq', @array_send_command_response, 'send command');
    cmp_ok(send_requests('CLR'), '>=', 0, 'send command CLR');
    cmp_ok(send_requests('JVM'), '>=', 0, 'send command JVM');
    cmp_ok(send_requests('NETCORE'), '>=', 0, 'send command NETCORE');
    cmp_ok(send_requests('PYTHON'), '>=', 0, 'send command PYTHON');
    cmp_ok(send_requests('RUBY'), '>=', 0, 'send command RUBY');
    cmp_ok(send_requests('Nodejs'), '>=', 0, 'send command Nodejs');
};


sub send_requests {
    my ($runtime) = @_;
    my $port = $PORTS{$runtime};
    my $url = "http://localhost:${port}/api/receiver/sendCommand";

    my %opts = (
        'Content-Type' => 'application/json',
        'Content-Length' => length($payload)
    );

    my $begin_time = time();

    for(1..250000) {
        my $res = $ua->post($url, %opts, Content => $payload);
        ok($res->is_success());
    }

    my $end_time = time();
    return $end_time - $begin_time;
}

1;
