/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.protocol;

import com.javonet.core.protocol.TypeDecoder;
import com.javonet.utils.Command;
import com.javonet.utils.CommandType;
import com.javonet.utils.RuntimeName;
import com.javonet.utils.StringEcodingMode;
import com.javonet.utils.Type;
import java.util.Arrays;

public class CommandDecoder {
    private final byte[] buffer;
    private int position;
    private Command command;

    public CommandDecoder(byte[] buffer) {
        this.buffer = buffer;
        this.command = new Command(RuntimeName.values()[buffer[0]], CommandType.values()[buffer[10]], new Object[0]);
        this.position = 11;
    }

    private boolean isAtEnd() {
        return this.position >= this.buffer.length;
    }

    public Command decode() {
        while (!this.isAtEnd()) {
            this.command = this.command.addArgToPayload(this.readObject(this.buffer[this.position]));
        }
        return this.command;
    }

    private byte[] copyFrom(byte[] bytes, int elementsToSkip) {
        int size = bytes.length - elementsToSkip;
        byte[] newByteArray = new byte[size];
        System.arraycopy(bytes, elementsToSkip, newByteArray, 0, size);
        return newByteArray;
    }

    private Object readObject(int typeNum) {
        Type type = Type.values()[typeNum];
        switch (type) {
            case COMMAND: {
                return this.readCommand();
            }
            case INTEGER: {
                return this.readInt32();
            }
            case STRING: {
                return this.readString();
            }
            case BOOLEAN: {
                return this.readBoolean();
            }
            case FLOAT: {
                return Float.valueOf(this.readFloat());
            }
            case BYTE: {
                return this.readByte();
            }
            case CHAR: {
                return Character.valueOf(this.readChar());
            }
            case LONG: {
                return this.readLong();
            }
            case DOUBLE: {
                return this.readDouble();
            }
        }
        throw new RuntimeException("Type not supported: " + typeNum);
    }

    protected Command readCommand() {
        int p = this.position;
        int numberOfElementsInPayload = TypeDecoder.decodeInt(Arrays.copyOfRange(this.buffer, p + 1, p + 5));
        byte runtime = this.buffer[p + 5];
        byte type = this.buffer[p + 6];
        this.position += 7;
        Command command = new Command(RuntimeName.values()[runtime], CommandType.values()[type], new Object[0]);
        return this.readCommandRecursively(numberOfElementsInPayload, command);
    }

    private Command readCommandRecursively(int numberOfElementsInPayloadLeft, Command command) {
        if (numberOfElementsInPayloadLeft == 0) {
            return command;
        }
        int p = this.position;
        int argSize = TypeDecoder.decodeInt(Arrays.copyOfRange(this.buffer, p + 1, p + 5));
        command = command.addArgToPayload(this.readObject(this.buffer[p]));
        return this.readCommandRecursively(numberOfElementsInPayloadLeft - 1, command);
    }

    private int readInt32() {
        int p = this.position += 2;
        this.position += 4;
        return TypeDecoder.decodeInt(Arrays.copyOfRange(this.buffer, p, p + 4));
    }

    private String readString() {
        int p = this.position;
        StringEcodingMode stringEncodingMode = StringEcodingMode.values()[this.buffer[p + 1]];
        int size = TypeDecoder.decodeInt(Arrays.copyOfRange(this.buffer, p + 2, p + 6));
        int firstCharIndex = p + 6;
        String stringValue = TypeDecoder.decodeString(stringEncodingMode, Arrays.copyOfRange(this.buffer, firstCharIndex, firstCharIndex + size));
        this.position += size + 6;
        return stringValue;
    }

    private boolean readBoolean() {
        int p = this.position;
        byte byteVal = this.buffer[p + 2];
        boolean boolValue = byteVal == 1;
        this.position += 3;
        return boolValue;
    }

    private float readFloat() {
        int p = this.position += 2;
        float floatValue = TypeDecoder.decodeFloat(Arrays.copyOfRange(this.buffer, p, p + 4));
        this.position += 4;
        return floatValue;
    }

    private byte readByte() {
        this.position += 2;
        int p = this.position++;
        byte byteValue = this.buffer[p];
        return byteValue;
    }

    private char readChar() {
        this.position += 2;
        int p = this.position++;
        char charValue = TypeDecoder.decodeChar(this.buffer[p]);
        return charValue;
    }

    private long readLong() {
        int p = this.position += 2;
        long longValue = TypeDecoder.decodeLong(Arrays.copyOfRange(this.buffer, p, p + 8));
        this.position += 8;
        return longValue;
    }

    private double readDouble() {
        int p = this.position += 2;
        double doubleValue = TypeDecoder.decodeDouble(Arrays.copyOfRange(this.buffer, p, p + 8));
        this.position += 8;
        return doubleValue;
    }
}

