use strict;
use warnings;
use Test::More qw(no_plan);
use Test::Exception;
use File::Spec;
use File::Basename;
use lib 'lib';

use aliased 'Javonet::Javonet' => 'Javonet', qw(in_memory tcp);

my $this_file_path = dirname(__FILE__);
my $test_file_path = "${this_file_path}/../../../../testResources/perl-package/TestClass.pm";
my $class_name = 'TestClass::TestClass';

sub Test_Perl_TestResources_LoadLibrary_LibraryPath_NoException {
    Javonet->in_memory()->perl()->load_library($test_file_path);
    return 0;
}

sub Test_Perl_TestResources_InvokeStaticMethod_MultiplyByTwo_25_50 {
    Javonet->in_memory()->perl()->load_library($test_file_path);
    my $perl_type = Javonet->in_memory()->perl()->get_type($class_name)->execute();
    my $response = $perl_type->invoke_static_method('multiply_by_two', 25)->execute();
    return $response->get_value();
}

sub Test_Perl_TestResources_GetStaticField_StaticValue_3 {
    Javonet->in_memory()->perl()->load_library($test_file_path);
    my $perl_type = Javonet->in_memory()->perl()->get_type($class_name)->execute();
    my $response = $perl_type->get_static_field('static_value')->execute();
    return $response->get_value();
}

sub Test_Perl_TestResources_SetStaticField_StaticValue_75 {
    Javonet->in_memory()->perl()->load_library($test_file_path);
    my $perl_type = Javonet->in_memory()->perl()->get_type($class_name)->execute();
    $perl_type->set_static_field('static_value', 75)->execute();
    my $response = $perl_type->get_static_field('static_value')->execute();
    $perl_type->set_static_field('static_value', 3)->execute();
    return $response->get_value();
}

sub Test_Perl_TestResources_InvokeInstanceMethod_MultiplyTwoNumbers_2_25_50 {
    Javonet->in_memory()->perl()->load_library($test_file_path);
    my $perl_type = Javonet->in_memory()->perl()->get_type($class_name)->execute();
    my $instance = $perl_type->create_instance()->execute();
    my $response = $instance->invoke_instance_method("multiply_two_numbers", 2, 25)->execute();
    return $response->get_value();
}

sub Test_Perl_TestResources_InvokeInstanceMethod_DivideTwoNumbers_2_0_throws_exception {
    Javonet->in_memory()->perl()->load_library($test_file_path);
    my $perl_type = Javonet->in_memory()->perl()->get_type($class_name)->execute();
    my $instance = $perl_type->create_instance()->execute();
    $instance->invoke_instance_method("divide_two_numbers", 2, 0)->execute();

}

sub Test_Perl_TestResources_GetInstanceField_PublicValue_1 {
    Javonet->in_memory()->perl()->load_library($test_file_path);
    my $perl_type = Javonet->in_memory()->perl()->get_type($class_name)->execute();
    my $instance = $perl_type->create_instance()->execute();
    my $response = $instance->get_instance_field("public_value")->execute();
    return $response->get_value();
}

sub Test_Perl_TestResources_1DArray_GetIndex_2_StringThree {
    Javonet->in_memory()->perl()->load_library($test_file_path);
    my $perl_type = Javonet->in_memory()->perl()->get_type($class_name)->execute();
    my $instance = $perl_type->create_instance()->execute();
    my $array_reference = $instance->invoke_instance_method("get_1d_array")->execute();
    my $response = $array_reference->get_index(2)->execute()->get_value();
    return $response;
}

sub Test_Perl_TestResources_1DArray_GetSize_5 {
    Javonet->in_memory()->perl()->load_library($test_file_path);
    my $perl_type = Javonet->in_memory()->perl()->get_type($class_name)->execute();
    my $instance = $perl_type->create_instance()->execute();
    my $array_reference = $instance->invoke_instance_method("get_1d_array")->execute();
    my $array_size = $array_reference->get_size()->execute()->get_value();
    return $array_size;
}

sub Test_Perl_TestResources_1DArray_SetIndex_4_StringSeven {
    Javonet->in_memory()->perl()->load_library($test_file_path);
    my $perl_type = Javonet->in_memory()->perl()->get_type($class_name)->execute();
    my $instance = $perl_type->create_instance()->execute();
    my $array_reference = $instance->invoke_instance_method("get_1d_array")->execute();
    my $response = $array_reference->get_index(4)->execute()->get_value();
    $response = $array_reference->get_index(4)->execute()->get_value();
    $array_reference->set_index("seven", 4)->execute()->get_value();
    $response = $array_reference->get_index(4)->execute()->get_value();
    $array_reference->set_index("five", 4)->execute()->get_value();
    return $response;
}



is(scalar Test_Perl_TestResources_LoadLibrary_LibraryPath_NoException(), 0,
    "Test_Perl_TestResources_LoadLibrary_LibraryPath_NoException");

is(scalar Test_Perl_TestResources_InvokeStaticMethod_MultiplyByTwo_25_50(), 50,
    "Test_Perl_TestResources_InvokeStaticMethod_MultiplyByTwo_25_50");

is(scalar Test_Perl_TestResources_GetStaticField_StaticValue_3(), 3,
    "Test_Perl_TestResources_GetStaticField_StaticValue_3");

is(scalar Test_Perl_TestResources_SetStaticField_StaticValue_75(), 75,
    "Test_Perl_TestResources_SetStaticField_StaticValue_75");

is(scalar Test_Perl_TestResources_InvokeInstanceMethod_MultiplyTwoNumbers_2_25_50(), 50,
    "Test_Perl_TestResources_InvokeInstanceMethod_MultiplyTwoNumbers_2_25_50");

dies_ok{Test_Perl_TestResources_InvokeInstanceMethod_DivideTwoNumbers_2_0_throws_exception()}
    "Test_Perl_TestResources_InvokeInstanceMethod_DivideTwoNumbers_2_0_throws_exception";

cmp_ok(scalar Test_Perl_TestResources_GetInstanceField_PublicValue_1(), '==', 1,
    "Test_Perl_TestResources_GetInstanceField_PublicValue_1");

is(scalar Test_Perl_TestResources_1DArray_GetIndex_2_StringThree(), "three",
    "Test_Perl_TestResources_1DArray_GetIndex_2_StringThree");

is(scalar Test_Perl_TestResources_1DArray_GetSize_5(), 5,
    "Test_Perl_TestResources_1DArray_GetSize_5");

is(scalar Test_Perl_TestResources_1DArray_SetIndex_4_StringSeven(), "seven",
    "Test_Perl_TestResources_1DArray_SetIndex_4_StringSeven");


done_testing();
