package Monitoring::GLPlugin::SNMP::MibsAndOids::CISCOSTACKWISEMIB;

$Monitoring::GLPlugin::SNMP::MibsAndOids::origin->{'CISCO-STACKWISE-MIB'} = {
  url => '',
  name => 'CISCO-STACKWISE-MIB',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::mib_ids->{'CISCO-STACKWISE-MIB'} =
    '1.3.6.1.4.1.9.9.500.1';

$Monitoring::GLPlugin::SNMP::MibsAndOids::mibs_and_oids->{'CISCO-STACKWISE-MIB'} = {
  ciscoStackWiseMIB => '1.3.6.1.4.1.9.9.500',
  ciscoStackWiseMIBNotifs => '1.3.6.1.4.1.9.9.500.0',
  cswMIBNotifications => '1.3.6.1.4.1.9.9.500.0.0',
  ciscoStackWiseMIBObjects => '1.3.6.1.4.1.9.9.500.1',
  cswGlobals => '1.3.6.1.4.1.9.9.500.1.1',
  cswMaxSwitchNum => '1.3.6.1.4.1.9.9.500.1.1.1',
  cswMaxSwitchConfigPriority => '1.3.6.1.4.1.9.9.500.1.1.2',
  cswRingRedundant => '1.3.6.1.4.1.9.9.500.1.1.3',
  cswRingRedundantDefinition => 'SNMPv2-TC-v1-MIB::TruthValue',
  cswEnableStackNotifications => '1.3.6.1.4.1.9.9.500.1.1.4',
  cswEnableIndividualStackNotifications => '1.3.6.1.4.1.9.9.500.1.1.5',
  cswStackInfo => '1.3.6.1.4.1.9.9.500.1.2',
  cswSwitchInfoTable => '1.3.6.1.4.1.9.9.500.1.2.1',
  cswSwitchInfoEntry => '1.3.6.1.4.1.9.9.500.1.2.1.1',
  cswSwitchNumCurrent => '1.3.6.1.4.1.9.9.500.1.2.1.1.1',
  cswSwitchNumNextReload => '1.3.6.1.4.1.9.9.500.1.2.1.1.2',
  cswSwitchRole => '1.3.6.1.4.1.9.9.500.1.2.1.1.3',
  cswSwitchRoleDefinition => 'CISCO-STACKWISE-MIB::cswSwitchRole',
  cswSwitchSwPriority => '1.3.6.1.4.1.9.9.500.1.2.1.1.4',
  cswSwitchHwPriority => '1.3.6.1.4.1.9.9.500.1.2.1.1.5',
  cswSwitchState => '1.3.6.1.4.1.9.9.500.1.2.1.1.6',
  cswSwitchStateDefinition => 'CISCO-STACKWISE-MIB::cswSwitchState',
  cswSwitchMacAddress => '1.3.6.1.4.1.9.9.500.1.2.1.1.7',
  cswSwitchSoftwareImage => '1.3.6.1.4.1.9.9.500.1.2.1.1.8',
  cswSwitchPowerBudget => '1.3.6.1.4.1.9.9.500.1.2.1.1.9',
  cswSwitchPowerCommited => '1.3.6.1.4.1.9.9.500.1.2.1.1.10',
  cswSwitchSystemPowerPriority => '1.3.6.1.4.1.9.9.500.1.2.1.1.11',
  cswSwitchPoeDevicesLowPriority => '1.3.6.1.4.1.9.9.500.1.2.1.1.12',
  cswSwitchPoeDevicesHighPriority => '1.3.6.1.4.1.9.9.500.1.2.1.1.13',
  cswStackPortInfoTable => '1.3.6.1.4.1.9.9.500.1.2.2',
  cswStackPortInfoEntry => '1.3.6.1.4.1.9.9.500.1.2.2.1',
  cswStackPortOperStatus => '1.3.6.1.4.1.9.9.500.1.2.2.1.1',
  cswStackPortOperStatusDefinition => 'CISCO-STACKWISE-MIB::cswStackPortOperStatus',
  cswStackPortNeighbor => '1.3.6.1.4.1.9.9.500.1.2.2.1.2',
  cswStackPowerInfo => '1.3.6.1.4.1.9.9.500.1.3',
  cswStackPowerInfoTable => '1.3.6.1.4.1.9.9.500.1.3.1',
  cswStackPowerInfoEntry => '1.3.6.1.4.1.9.9.500.1.3.1.1',
  cswStackPowerStackNumber => '1.3.6.1.4.1.9.9.500.1.3.1.1.1',
  cswStackPowerMode => '1.3.6.1.4.1.9.9.500.1.3.1.1.2',
  cswStackPowerModeDefinition => 'CISCO-STACKWISE-MIB::CswPowerStackMode',
  cswStackPowerMasterMacAddress => '1.3.6.1.4.1.9.9.500.1.3.1.1.3',
  cswStackPowerMasterSwitchNum => '1.3.6.1.4.1.9.9.500.1.3.1.1.4',
  cswStackPowerNumMembers => '1.3.6.1.4.1.9.9.500.1.3.1.1.5',
  cswStackPowerType => '1.3.6.1.4.1.9.9.500.1.3.1.1.6',
  cswStackPowerTypeDefinition => 'CISCO-STACKWISE-MIB::CswPowerStackType',
  cswStackPowerName => '1.3.6.1.4.1.9.9.500.1.3.1.1.7',
  cswStackPowerPortInfoTable => '1.3.6.1.4.1.9.9.500.1.3.2',
  cswStackPowerPortInfoEntry => '1.3.6.1.4.1.9.9.500.1.3.2.1',
  cswStackPowerPortIndex => '1.3.6.1.4.1.9.9.500.1.3.2.1.1',
  cswStackPowerPortOperStatus => '1.3.6.1.4.1.9.9.500.1.3.2.1.2',
  cswStackPowerPortOperStatusDefinition => 'CISCO-STACKWISE-MIB::cswStackPowerPortOperStatus',
  cswStackPowerPortNeighborMacAddress => '1.3.6.1.4.1.9.9.500.1.3.2.1.3',
  cswStackPowerPortNeighborSwitchNum => '1.3.6.1.4.1.9.9.500.1.3.2.1.4',
  cswStackPowerPortLinkStatus => '1.3.6.1.4.1.9.9.500.1.3.2.1.5',
  cswStackPowerPortLinkStatusDefinition => 'CISCO-STACKWISE-MIB::cswStackPowerPortLinkStatus',
  cswStackPowerPortOverCurrentThreshold => '1.3.6.1.4.1.9.9.500.1.3.2.1.6',
  cswStackPowerPortName => '1.3.6.1.4.1.9.9.500.1.3.2.1.7',
  ciscoStackWiseMIBConform => '1.3.6.1.4.1.9.9.500.2',
  cswStackWiseMIBCompliances => '1.3.6.1.4.1.9.9.500.2.1',
  cswStackWiseMIBGroups => '1.3.6.1.4.1.9.9.500.2.2',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::definitions->{'CISCO-STACKWISE-MIB'} = {
  cswStackPortOperStatus => {
    '1' => 'up',
    '2' => 'down',
    '3' => 'forcedDown',
  },
  CswPowerStackMode => {
    '1' => 'powerSharing',
    '2' => 'redundant',
    '3' => 'powerSharingStrict',
    '4' => 'redundantStrict',
  },
  CswPowerStackType => {
    '1' => 'ring',
    '2' => 'star',
  },
  cswStackPowerPortOperStatus => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  cswSwitchState => {
    '1' => 'waiting',
    '2' => 'progressing',
    '3' => 'added',
    '4' => 'ready',
    '5' => 'sdmMismatch',
    '6' => 'verMismatch',
    '7' => 'featureMismatch',
    '8' => 'newMasterInit',
    '9' => 'provisioned',
    '10' => 'invalid',
    '11' => 'removed',
  },
  cswSwitchRole => {
    '1' => 'master',
    '2' => 'member',
    '3' => 'notMember',
  },
  cswStackPowerPortLinkStatus => {
    '1' => 'up',
    '2' => 'down',
  },
};
