package Monitoring::GLPlugin::SNMP::MibsAndOids::OSPFMIB;

$Monitoring::GLPlugin::SNMP::MibsAndOids::origin->{'OSPF-MIB'} = {
  url => '',
  name => 'OSPF-MIB',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::requirements->{'OSPF-MIB'} = [
  'SNMPv2-TC-v1-MIB',
];

$Monitoring::GLPlugin::SNMP::MibsAndOids::mibs_and_oids->{'OSPF-MIB'} = {
  'ospf' => '1.3.6.1.2.1.14',
  'ospfGeneralGroup' => '1.3.6.1.2.1.14.1',
  'ospfRouterId' => '1.3.6.1.2.1.14.1.1',
  'ospfAdminStat' => '1.3.6.1.2.1.14.1.2',
  'ospfVersionNumber' => '1.3.6.1.2.1.14.1.3',
  'ospfVersionNumberDefinition' => 'OSPF-MIB::ospfVersionNumber',
  'ospfAreaBdrRtrStatus' => '1.3.6.1.2.1.14.1.4',
  'ospfASBdrRtrStatus' => '1.3.6.1.2.1.14.1.5',
  'ospfExternLsaCount' => '1.3.6.1.2.1.14.1.6',
  'ospfExternLsaCksumSum' => '1.3.6.1.2.1.14.1.7',
  'ospfTOSSupport' => '1.3.6.1.2.1.14.1.8',
  'ospfOriginateNewLsas' => '1.3.6.1.2.1.14.1.9',
  'ospfRxNewLsas' => '1.3.6.1.2.1.14.1.10',
  'ospfExtLsdbLimit' => '1.3.6.1.2.1.14.1.11',
  'ospfMulticastExtensions' => '1.3.6.1.2.1.14.1.12',
  'ospfExitOverflowInterval' => '1.3.6.1.2.1.14.1.13',
  'ospfDemandExtensions' => '1.3.6.1.2.1.14.1.14',
  'ospfRFC1583Compatibility' => '1.3.6.1.2.1.14.1.15',
  'ospfOpaqueLsaSupport' => '1.3.6.1.2.1.14.1.16',
  'ospfReferenceBandwidth' => '1.3.6.1.2.1.14.1.17',
  'ospfRestartSupport' => '1.3.6.1.2.1.14.1.18',
  'ospfRestartSupportDefinition' => 'OSPF-MIB::ospfRestartSupport',
  'ospfRestartInterval' => '1.3.6.1.2.1.14.1.19',
  'ospfRestartStrictLsaChecking' => '1.3.6.1.2.1.14.1.20',
  'ospfRestartStatus' => '1.3.6.1.2.1.14.1.21',
  'ospfRestartStatusDefinition' => 'OSPF-MIB::ospfRestartStatus',
  'ospfRestartAge' => '1.3.6.1.2.1.14.1.22',
  'ospfRestartExitReason' => '1.3.6.1.2.1.14.1.23',
  'ospfRestartExitReasonDefinition' => 'OSPF-MIB::ospfRestartExitReason',
  'ospfAsLsaCount' => '1.3.6.1.2.1.14.1.24',
  'ospfAsLsaCksumSum' => '1.3.6.1.2.1.14.1.25',
  'ospfStubRouterSupport' => '1.3.6.1.2.1.14.1.26',
  'ospfStubRouterAdvertisement' => '1.3.6.1.2.1.14.1.27',
  'ospfStubRouterAdvertisementDefinition' => 'OSPF-MIB::ospfStubRouterAdvertisement',
  'ospfDiscontinuityTime' => '1.3.6.1.2.1.14.1.28',
  'ospfAreaTable' => '1.3.6.1.2.1.14.2',
  'ospfAreaEntry' => '1.3.6.1.2.1.14.2.1',
  'ospfAreaId' => '1.3.6.1.2.1.14.2.1.1',
  'ospfAuthType' => '1.3.6.1.2.1.14.2.1.2',
  'ospfAuthTypeDefinition' => {
    '0' => 'none',
    '1' => 'simplePassword',
    '2' => 'md5',
  },
  'ospfImportAsExtern' => '1.3.6.1.2.1.14.2.1.3',
  'ospfImportAsExternDefinition' => 'OSPF-MIB::ospfImportAsExtern',
  'ospfSpfRuns' => '1.3.6.1.2.1.14.2.1.4',
  'ospfAreaBdrRtrCount' => '1.3.6.1.2.1.14.2.1.5',
  'ospfAsBdrRtrCount' => '1.3.6.1.2.1.14.2.1.6',
  'ospfAreaLsaCount' => '1.3.6.1.2.1.14.2.1.7',
  'ospfAreaLsaCksumSum' => '1.3.6.1.2.1.14.2.1.8',
  'ospfAreaSummary' => '1.3.6.1.2.1.14.2.1.9',
  'ospfAreaSummaryDefinition' => 'OSPF-MIB::ospfAreaSummary',
  'ospfAreaStatus' => '1.3.6.1.2.1.14.2.1.10',
  'ospfAreaStatusDefinition' => 'SNMPv2-TC-v1-MIB::RowStatus',
  'ospfAreaNssaTranslatorRole' => '1.3.6.1.2.1.14.2.1.11',
  'ospfAreaNssaTranslatorRoleDefinition' => 'OSPF-MIB::ospfAreaNssaTranslatorRole',
  'ospfAreaNssaTranslatorState' => '1.3.6.1.2.1.14.2.1.12',
  'ospfAreaNssaTranslatorStateDefinition' => 'OSPF-MIB::ospfAreaNssaTranslatorState',
  'ospfAreaNssaTranslatorStabilityInterval' => '1.3.6.1.2.1.14.2.1.13',
  'ospfAreaNssaTranslatorEvents' => '1.3.6.1.2.1.14.2.1.14',
  'ospfStubAreaTable' => '1.3.6.1.2.1.14.3',
  'ospfStubAreaEntry' => '1.3.6.1.2.1.14.3.1',
  'ospfStubAreaId' => '1.3.6.1.2.1.14.3.1.1',
  'ospfStubTOS' => '1.3.6.1.2.1.14.3.1.2',
  'ospfStubMetric' => '1.3.6.1.2.1.14.3.1.3',
  'ospfStubStatus' => '1.3.6.1.2.1.14.3.1.4',
  'ospfStubMetricType' => '1.3.6.1.2.1.14.3.1.5',
  'ospfStubMetricTypeDefinition' => 'OSPF-MIB::ospfStubMetricType',
  'ospfLsdbTable' => '1.3.6.1.2.1.14.4',
  'ospfLsdbEntry' => '1.3.6.1.2.1.14.4.1',
  'ospfLsdbAreaId' => '1.3.6.1.2.1.14.4.1.1',
  'ospfLsdbType' => '1.3.6.1.2.1.14.4.1.2',
  'ospfLsdbTypeDefinition' => 'OSPF-MIB::ospfLsdbType',
  'ospfLsdbLsid' => '1.3.6.1.2.1.14.4.1.3',
  'ospfLsdbRouterId' => '1.3.6.1.2.1.14.4.1.4',
  'ospfLsdbSequence' => '1.3.6.1.2.1.14.4.1.5',
  'ospfLsdbAge' => '1.3.6.1.2.1.14.4.1.6',
  'ospfLsdbChecksum' => '1.3.6.1.2.1.14.4.1.7',
  'ospfLsdbAdvertisement' => '1.3.6.1.2.1.14.4.1.8',
  'ospfAreaRangeTable' => '1.3.6.1.2.1.14.5',
  'ospfAreaRangeEntry' => '1.3.6.1.2.1.14.5.1',
  'ospfAreaRangeAreaId' => '1.3.6.1.2.1.14.5.1.1',
  'ospfAreaRangeNet' => '1.3.6.1.2.1.14.5.1.2',
  'ospfAreaRangeMask' => '1.3.6.1.2.1.14.5.1.3',
  'ospfAreaRangeStatus' => '1.3.6.1.2.1.14.5.1.4',
  'ospfAreaRangeEffect' => '1.3.6.1.2.1.14.5.1.5',
  'ospfAreaRangeEffectDefinition' => 'OSPF-MIB::ospfAreaRangeEffect',
  'ospfHostTable' => '1.3.6.1.2.1.14.6',
  'ospfHostEntry' => '1.3.6.1.2.1.14.6.1',
  'ospfHostIpAddress' => '1.3.6.1.2.1.14.6.1.1',
  'ospfHostTOS' => '1.3.6.1.2.1.14.6.1.2',
  'ospfHostMetric' => '1.3.6.1.2.1.14.6.1.3',
  'ospfHostStatus' => '1.3.6.1.2.1.14.6.1.4',
  'ospfHostStatusDefinition' => 'SNMPv2-TC-v1-MIB::RowStatus',
  'ospfHostAreaID' => '1.3.6.1.2.1.14.6.1.5',
  'ospfHostCfgAreaID' => '1.3.6.1.2.1.14.6.1.6',
  'ospfIfTable' => '1.3.6.1.2.1.14.7',
  'ospfIfEntry' => '1.3.6.1.2.1.14.7.1',
  'ospfIfIpAddress' => '1.3.6.1.2.1.14.7.1.1',
  'ospfAddressLessIf' => '1.3.6.1.2.1.14.7.1.2',
  'ospfIfAreaId' => '1.3.6.1.2.1.14.7.1.3',
  'ospfIfType' => '1.3.6.1.2.1.14.7.1.4',
  'ospfIfTypeDefinition' => 'OSPF-MIB::ospfIfType',
  'ospfIfAdminStat' => '1.3.6.1.2.1.14.7.1.5',
  'ospfIfAdminStatDefinition' => 'OSPF-MIB::Status',
  'ospfIfRtrPriority' => '1.3.6.1.2.1.14.7.1.6',
  'ospfIfTransitDelay' => '1.3.6.1.2.1.14.7.1.7',
  'ospfIfRetransInterval' => '1.3.6.1.2.1.14.7.1.8',
  'ospfIfHelloInterval' => '1.3.6.1.2.1.14.7.1.9',
  'ospfIfRtrDeadInterval' => '1.3.6.1.2.1.14.7.1.10',
  'ospfIfPollInterval' => '1.3.6.1.2.1.14.7.1.11',
  'ospfIfState' => '1.3.6.1.2.1.14.7.1.12',
  'ospfIfStateDefinition' => 'OSPF-MIB::ospfIfState',
  'ospfIfDesignatedRouter' => '1.3.6.1.2.1.14.7.1.13',
  'ospfIfBackupDesignatedRouter' => '1.3.6.1.2.1.14.7.1.14',
  'ospfIfEvents' => '1.3.6.1.2.1.14.7.1.15',
  'ospfIfAuthKey' => '1.3.6.1.2.1.14.7.1.16',
  'ospfIfStatus' => '1.3.6.1.2.1.14.7.1.17',
  'ospfIfStatusDefinition' => 'SNMPv2-TC-v1-MIB::RowStatus',
  'ospfIfMulticastForwarding' => '1.3.6.1.2.1.14.7.1.18',
  'ospfIfMulticastForwardingDefinition' => 'OSPF-MIB::ospfIfMulticastForwarding',
  'ospfIfDemand' => '1.3.6.1.2.1.14.7.1.19',
  'ospfIfDemandDefinition' => 'SNMPv2-TC-v1-MIB::TruthValue',
  'ospfIfAuthType' => '1.3.6.1.2.1.14.7.1.20',
  'ospfIfAuthTypeDefinition' => 'OSPF-MIB::AuType',
  'ospfIfLsaCount' => '1.3.6.1.2.1.14.7.1.21',
  'ospfIfLsaCksumSum' => '1.3.6.1.2.1.14.7.1.22',
  'ospfIfDesignatedRouterId' => '1.3.6.1.2.1.14.7.1.23',
  'ospfIfBackupDesignatedRouterId' => '1.3.6.1.2.1.14.7.1.24',
  'ospfIfMetricTable' => '1.3.6.1.2.1.14.8',
  'ospfIfMetricEntry' => '1.3.6.1.2.1.14.8.1',
  'ospfIfMetricIpAddress' => '1.3.6.1.2.1.14.8.1.1',
  'ospfIfMetricAddressLessIf' => '1.3.6.1.2.1.14.8.1.2',
  'ospfIfMetricTOS' => '1.3.6.1.2.1.14.8.1.3',
  'ospfIfMetricValue' => '1.3.6.1.2.1.14.8.1.4',
  'ospfIfMetricStatus' => '1.3.6.1.2.1.14.8.1.5',
  'ospfIfMetricStatusDefinition' => 'SNMPv2-TC-v1-MIB::RowStatus',
  'ospfVirtIfTable' => '1.3.6.1.2.1.14.9',
  'ospfVirtIfEntry' => '1.3.6.1.2.1.14.9.1',
  'ospfVirtIfAreaId' => '1.3.6.1.2.1.14.9.1.1',
  'ospfVirtIfNeighbor' => '1.3.6.1.2.1.14.9.1.2',
  'ospfVirtIfTransitDelay' => '1.3.6.1.2.1.14.9.1.3',
  'ospfVirtIfRetransInterval' => '1.3.6.1.2.1.14.9.1.4',
  'ospfVirtIfHelloInterval' => '1.3.6.1.2.1.14.9.1.5',
  'ospfVirtIfRtrDeadInterval' => '1.3.6.1.2.1.14.9.1.6',
  'ospfVirtIfState' => '1.3.6.1.2.1.14.9.1.7',
  'ospfVirtIfStateDefinition' => 'OSPF-MIB::ospfVirtIfState',
  'ospfVirtIfEvents' => '1.3.6.1.2.1.14.9.1.8',
  'ospfVirtIfAuthKey' => '1.3.6.1.2.1.14.9.1.9',
  'ospfVirtIfStatus' => '1.3.6.1.2.1.14.9.1.10',
  'ospfVirtIfAuthType' => '1.3.6.1.2.1.14.9.1.11',
  'ospfVirtIfLsaCount' => '1.3.6.1.2.1.14.9.1.12',
  'ospfVirtIfLsaCksumSum' => '1.3.6.1.2.1.14.9.1.13',
  'ospfNbrTable' => '1.3.6.1.2.1.14.10',
  'ospfNbrEntry' => '1.3.6.1.2.1.14.10.1',
  'ospfNbrIpAddr' => '1.3.6.1.2.1.14.10.1.1',
  'ospfNbrAddressLessIndex' => '1.3.6.1.2.1.14.10.1.2',
  'ospfNbrRtrId' => '1.3.6.1.2.1.14.10.1.3',
  'ospfNbrOptions' => '1.3.6.1.2.1.14.10.1.4',
  'ospfNbrPriority' => '1.3.6.1.2.1.14.10.1.5',
  'ospfNbrState' => '1.3.6.1.2.1.14.10.1.6',
  'ospfNbrStateDefinition' => 'OSPF-MIB::ospfNbrState',
  'ospfNbrEvents' => '1.3.6.1.2.1.14.10.1.7',
  'ospfNbrLsRetransQLen' => '1.3.6.1.2.1.14.10.1.8',
  'ospfNbmaNbrStatus' => '1.3.6.1.2.1.14.10.1.9',
  'ospfNbmaNbrStatusDefinition' => 'SNMPv2-TC-v1-MIB::RowStatus',
  'ospfNbmaNbrPermanence' => '1.3.6.1.2.1.14.10.1.10',
  'ospfNbmaNbrPermanenceDefinition' => 'OSPF-MIB::ospfNbmaNbrPermanence',
  'ospfNbrHelloSuppressed' => '1.3.6.1.2.1.14.10.1.11',
  'ospfNbrHelloSuppressedDefinition' => 'SNMPv2-TC-v1-MIB::TruthValue',
  'ospfNbrRestartHelperStatus' => '1.3.6.1.2.1.14.10.1.12',
  'ospfNbrRestartHelperStatusDefinition' => 'OSPF-MIB::ospfNbrRestartHelperStatus',
  'ospfNbrRestartHelperAge' => '1.3.6.1.2.1.14.10.1.13',
  'ospfNbrRestartHelperExitReason' => '1.3.6.1.2.1.14.10.1.14',
  'ospfNbrRestartHelperExitReasonDefinition' => 'OSPF-MIB::ospfNbrRestartHelperExitReason',
  'ospfVirtNbrTable' => '1.3.6.1.2.1.14.11',
  'ospfVirtNbrEntry' => '1.3.6.1.2.1.14.11.1',
  'ospfVirtNbrArea' => '1.3.6.1.2.1.14.11.1.1',
  'ospfVirtNbrRtrId' => '1.3.6.1.2.1.14.11.1.2',
  'ospfVirtNbrIpAddr' => '1.3.6.1.2.1.14.11.1.3',
  'ospfVirtNbrOptions' => '1.3.6.1.2.1.14.11.1.4',
  'ospfVirtNbrOptionsDefinition' => 'OSPF-MIB::ospfVirtNbrOptions',
  'ospfVirtNbrState' => '1.3.6.1.2.1.14.11.1.5',
  'ospfVirtNbrStateDefinition' => 'OSPF-MIB::ospfVirtNbrState',
  'ospfVirtNbrEvents' => '1.3.6.1.2.1.14.11.1.6',
  'ospfVirtNbrLsRetransQLen' => '1.3.6.1.2.1.14.11.1.7',
  'ospfVirtNbrHelloSuppressed' => '1.3.6.1.2.1.14.11.1.8',
  'ospfVirtNbrRestartHelperStatus' => '1.3.6.1.2.1.14.11.1.9',
  'ospfVirtNbrRestartHelperStatusDefinition' => 'OSPF-MIB::ospfVirtNbrRestartHelperStatus',
  'ospfVirtNbrRestartHelperAge' => '1.3.6.1.2.1.14.11.1.10',
  'ospfVirtNbrRestartHelperExitReason' => '1.3.6.1.2.1.14.11.1.11',
  'ospfVirtNbrRestartHelperExitReasonDefinition' => 'OSPF-MIB::ospfVirtNbrRestartHelperExitReason',
  'ospfExtLsdbTable' => '1.3.6.1.2.1.14.12',
  'ospfExtLsdbEntry' => '1.3.6.1.2.1.14.12.1',
  'ospfExtLsdbType' => '1.3.6.1.2.1.14.12.1.1',
  'ospfExtLsdbTypeDefinition' => 'OSPF-MIB::ospfExtLsdbType',
  'ospfExtLsdbLsid' => '1.3.6.1.2.1.14.12.1.2',
  'ospfExtLsdbRouterId' => '1.3.6.1.2.1.14.12.1.3',
  'ospfExtLsdbSequence' => '1.3.6.1.2.1.14.12.1.4',
  'ospfExtLsdbAge' => '1.3.6.1.2.1.14.12.1.5',
  'ospfExtLsdbChecksum' => '1.3.6.1.2.1.14.12.1.6',
  'ospfExtLsdbAdvertisement' => '1.3.6.1.2.1.14.12.1.7',
  'ospfRouteGroup' => '1.3.6.1.2.1.14.13',
  'ospfIntraArea' => '1.3.6.1.2.1.14.13.1',
  'ospfInterArea' => '1.3.6.1.2.1.14.13.2',
  'ospfExternalType1' => '1.3.6.1.2.1.14.13.3',
  'ospfExternalType2' => '1.3.6.1.2.1.14.13.4',
  'ospfAreaAggregateTable' => '1.3.6.1.2.1.14.14',
  'ospfAreaAggregateEntry' => '1.3.6.1.2.1.14.14.1',
  'ospfAreaAggregateAreaID' => '1.3.6.1.2.1.14.14.1.1',
  'ospfAreaAggregateLsdbType' => '1.3.6.1.2.1.14.14.1.2',
  'ospfAreaAggregateLsdbTypeDefinition' => 'OSPF-MIB::ospfAreaAggregateLsdbType',
  'ospfAreaAggregateNet' => '1.3.6.1.2.1.14.14.1.3',
  'ospfAreaAggregateMask' => '1.3.6.1.2.1.14.14.1.4',
  'ospfAreaAggregateStatus' => '1.3.6.1.2.1.14.14.1.5',
  'ospfAreaAggregateEffect' => '1.3.6.1.2.1.14.14.1.6',
  'ospfAreaAggregateEffectDefinition' => 'OSPF-MIB::ospfAreaAggregateEffect',
  'ospfAreaAggregateExtRouteTag' => '1.3.6.1.2.1.14.14.1.7',
  'ospfConformance' => '1.3.6.1.2.1.14.15',
  'ospfGroups' => '1.3.6.1.2.1.14.15.1',
  'ospfCompliances' => '1.3.6.1.2.1.14.15.2',
  'ospfLocalLsdbTable' => '1.3.6.1.2.1.14.17',
  'ospfLocalLsdbEntry' => '1.3.6.1.2.1.14.17.1',
  'ospfLocalLsdbIpAddress' => '1.3.6.1.2.1.14.17.1.1',
  'ospfLocalLsdbAddressLessIf' => '1.3.6.1.2.1.14.17.1.2',
  'ospfLocalLsdbType' => '1.3.6.1.2.1.14.17.1.3',
  'ospfLocalLsdbTypeDefinition' => 'OSPF-MIB::ospfLocalLsdbType',
  'ospfLocalLsdbLsid' => '1.3.6.1.2.1.14.17.1.4',
  'ospfLocalLsdbRouterId' => '1.3.6.1.2.1.14.17.1.5',
  'ospfLocalLsdbSequence' => '1.3.6.1.2.1.14.17.1.6',
  'ospfLocalLsdbAge' => '1.3.6.1.2.1.14.17.1.7',
  'ospfLocalLsdbChecksum' => '1.3.6.1.2.1.14.17.1.8',
  'ospfLocalLsdbAdvertisement' => '1.3.6.1.2.1.14.17.1.9',
  'ospfVirtLocalLsdbTable' => '1.3.6.1.2.1.14.18',
  'ospfVirtLocalLsdbEntry' => '1.3.6.1.2.1.14.18.1',
  'ospfVirtLocalLsdbTransitArea' => '1.3.6.1.2.1.14.18.1.1',
  'ospfVirtLocalLsdbNeighbor' => '1.3.6.1.2.1.14.18.1.2',
  'ospfVirtLocalLsdbType' => '1.3.6.1.2.1.14.18.1.3',
  'ospfVirtLocalLsdbTypeDefinition' => 'OSPF-MIB::ospfVirtLocalLsdbType',
  'ospfVirtLocalLsdbLsid' => '1.3.6.1.2.1.14.18.1.4',
  'ospfVirtLocalLsdbRouterId' => '1.3.6.1.2.1.14.18.1.5',
  'ospfVirtLocalLsdbSequence' => '1.3.6.1.2.1.14.18.1.6',
  'ospfVirtLocalLsdbAge' => '1.3.6.1.2.1.14.18.1.7',
  'ospfVirtLocalLsdbChecksum' => '1.3.6.1.2.1.14.18.1.8',
  'ospfVirtLocalLsdbAdvertisement' => '1.3.6.1.2.1.14.18.1.9',
  'ospfAsLsdbTable' => '1.3.6.1.2.1.14.19',
  'ospfAsLsdbEntry' => '1.3.6.1.2.1.14.19.1',
  'ospfAsLsdbType' => '1.3.6.1.2.1.14.19.1.1',
  'ospfAsLsdbTypeDefinition' => 'OSPF-MIB::ospfAsLsdbType',
  'ospfAsLsdbLsid' => '1.3.6.1.2.1.14.19.1.2',
  'ospfAsLsdbRouterId' => '1.3.6.1.2.1.14.19.1.3',
  'ospfAsLsdbSequence' => '1.3.6.1.2.1.14.19.1.4',
  'ospfAsLsdbAge' => '1.3.6.1.2.1.14.19.1.5',
  'ospfAsLsdbChecksum' => '1.3.6.1.2.1.14.19.1.6',
  'ospfAsLsdbAdvertisement' => '1.3.6.1.2.1.14.19.1.7',
  'ospfAreaLsaCountTable' => '1.3.6.1.2.1.14.20',
  'ospfAreaLsaCountEntry' => '1.3.6.1.2.1.14.20.1',
  'ospfAreaLsaCountAreaId' => '1.3.6.1.2.1.14.20.1.1',
  'ospfAreaLsaCountLsaType' => '1.3.6.1.2.1.14.20.1.2',
  'ospfAreaLsaCountLsaTypeDefinition' => 'OSPF-MIB::ospfAreaLsaCountLsaType',
  'ospfAreaLsaCountNumber' => '1.3.6.1.2.1.14.20.1.3',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::definitions->{'OSPF-MIB'} = {
  'ospfAreaAggregateEffect' => {
    '1' => 'advertiseMatching',
    '2' => 'doNotAdvertiseMatching',
  },
  'ospfLocalLsdbType' => {
    '9' => 'localOpaqueLink',
  },
  'ospfVirtNbrRestartHelperStatus' => {
    '1' => 'notHelping',
    '2' => 'helping',
  },
  'ospfImportAsExtern' => {
    '1' => 'importExternal',
    '2' => 'importNoExternal',
    '3' => 'importNssa',
  },
  'ospfStubMetricType' => {
    '1' => 'ospfMetric',
    '2' => 'comparableCost',
    '3' => 'nonComparable',
  },
  'ospfAreaNssaTranslatorRole' => {
    '1' => 'always',
    '2' => 'candidate',
  },
  'ospfNbrRestartHelperStatus' => {
    '1' => 'notHelping',
    '2' => 'helping',
  },
  'AuType' => {
    '0' => 'Null authentication',
    '1' => 'Simple password',
  },
  'ospfVersionNumber' => {
    '2' => 'version2',
  },
  'ospfAreaAggregateLsdbType' => {
    '3' => 'summaryLink',
    '7' => 'nssaExternalLink',
  },
  'ospfExtLsdbType' => {
    '5' => 'asExternalLink',
  },
  'ospfStubRouterAdvertisement' => {
    '1' => 'doNotAdvertise',
    '2' => 'advertise',
  },
  'ospfAreaNssaTranslatorState' => {
    '1' => 'enabled',
    '2' => 'elected',
    '3' => 'disabled',
  },
  'ospfNbrRestartHelperExitReason' => {
    '1' => 'none',
    '2' => 'inProgress',
    '3' => 'completed',
    '4' => 'timedOut',
    '5' => 'topologyChanged',
  },
  'ospfAreaLsaCountLsaType' => {
    '1' => 'routerLink',
    '2' => 'networkLink',
    '3' => 'summaryLink',
    '4' => 'asSummaryLink',
    '6' => 'multicastLink',
    '7' => 'nssaExternalLink',
    '10' => 'areaOpaqueLink',
  },
  'ospfIfState' => {
    '1' => 'down',
    '2' => 'loopback',
    '3' => 'waiting',
    '4' => 'pointToPoint',
    '5' => 'designatedRouter',
    '6' => 'backupDesignatedRouter',
    '7' => 'otherDesignatedRouter',
  },
  'ospfNbmaNbrPermanence' => {
    '1' => 'dynamic',
    '2' => 'permanent',
  },
  'ospfLsdbType' => {
    '1' => 'routerLink',
    '2' => 'networkLink',
    '3' => 'summaryLink',
    '4' => 'asSummaryLink',
    '5' => 'asExternalLink',
    '6' => 'multicastLink',
    '7' => 'nssaExternalLink',
    '10' => 'areaOpaqueLink',
  },
  'ospfVirtIfState' => {
    '1' => 'down',
    '4' => 'pointToPoint',
  },
  'ospfRestartStatus' => {
    '1' => 'notRestarting',
    '2' => 'plannedRestart',
    '3' => 'unplannedRestart',
  },
  'ospfAreaSummary' => {
    '1' => 'noAreaSummary',
    '2' => 'sendAreaSummary',
  },
  'ospfNbrState' => {
    '1' => 'down',
    '2' => 'attempt',
    '3' => 'init',
    '4' => 'twoWay',
    '5' => 'exchangeStart',
    '6' => 'exchange',
    '7' => 'loading',
    '8' => 'full',
  },
  'ospfVirtNbrRestartHelperExitReason' => {
    '1' => 'none',
    '2' => 'inProgress',
    '3' => 'completed',
    '4' => 'timedOut',
    '5' => 'topologyChanged',
  },
  'ospfRestartExitReason' => {
    '1' => 'none',
    '2' => 'inProgress',
    '3' => 'completed',
    '4' => 'timedOut',
    '5' => 'topologyChanged',
  },
  'ospfIfType' => {
    '1' => 'broadcast',
    '2' => 'nbma',
    '3' => 'pointToPoint',
    '5' => 'pointToMultipoint',
  },
  'Status' => {
    '1' => 'enabled',
    '2' => 'disabled',
  },
  'ospfVirtNbrState' => {
    '1' => 'down',
    '2' => 'attempt',
    '3' => 'init',
    '4' => 'twoWay',
    '5' => 'exchangeStart',
    '6' => 'exchange',
    '7' => 'loading',
    '8' => 'full',
  },
  'ospfAsLsdbType' => {
    '5' => 'asExternalLink',
    '11' => 'asOpaqueLink',
  },
  'ospfAreaRangeEffect' => {
    '1' => 'advertiseMatching',
    '2' => 'doNotAdvertiseMatching',
  },
  'ospfIfMulticastForwarding' => {
    '1' => 'blocked',
    '2' => 'multicast',
    '3' => 'unicast',
  },
  'ospfVirtNbrOptions' => 'REPAIRME',
  'ospfRestartSupport' => {
    '1' => 'none',
    '2' => 'plannedOnly',
    '3' => 'plannedAndUnplanned',
  },
  'ospfVirtLocalLsdbType' => {
    '9' => 'localOpaqueLink',
  },
};

1;

__END__
