# List of implemented endpoints

This list was generated by the `load-docs.p6` script that gets the data
from the [api-docs.json](https://matrix.org/docs/api/client-server/json/api-docs.json)
from matrix.org. This will give you an overview about what's implemented in the library.

## Application service room directory management

- [ ] PUT - /_matrix/client/r0/directory/list/appservice/{networkId}/{roomId}

## Capabilities

- [ ] GET - /_matrix/client/r0/capabilities

## Device management

- [ ] DELETE - /_matrix/client/r0/devices/{deviceId}
- [X] GET - /_matrix/client/r0/devices
- [X] GET - /_matrix/client/r0/devices/{deviceId}
- [ ] POST - /_matrix/client/r0/delete_devices
- [X] PUT - /_matrix/client/r0/devices/{deviceId}

## End-to-end encryption

- [ ] GET - /_matrix/client/r0/keys/changes
- [ ] POST - /_matrix/client/r0/keys/claim
- [ ] POST - /_matrix/client/r0/keys/query
- [ ] POST - /_matrix/client/r0/keys/upload

## Media

- [ ] GET - /_matrix/media/r0/config
- [ ] GET - /_matrix/media/r0/download/{serverName}/{mediaId}
- [ ] GET - /_matrix/media/r0/download/{serverName}/{mediaId}/{fileName}
- [ ] GET - /_matrix/media/r0/preview_url
- [ ] GET - /_matrix/media/r0/thumbnail/{serverName}/{mediaId}
- [X] POST - /_matrix/media/r0/upload

## OpenID

- [ ] POST - /_matrix/client/r0/user/{userId}/openid/request_token

## Presence

- [X] GET - /_matrix/client/r0/presence/{userId}/status
- [X] PUT - /_matrix/client/r0/presence/{userId}/status

## Push notifications

- [ ] DELETE - /_matrix/client/r0/pushrules/{scope}/{kind}/{ruleId}
- [ ] GET - /_matrix/client/r0/notifications
- [ ] GET - /_matrix/client/r0/pushers
- [ ] GET - /_matrix/client/r0/pushrules/
- [ ] GET - /_matrix/client/r0/pushrules/{scope}/{kind}/{ruleId}
- [ ] POST - /_matrix/client/r0/pushers/set
- [ ] PUT - /_matrix/client/r0/pushrules/{scope}/{kind}/{ruleId}
- [ ] PUT - /_matrix/client/r0/pushrules/{scope}/{kind}/{ruleId}/actions
- [ ] PUT - /_matrix/client/r0/pushrules/{scope}/{kind}/{ruleId}/enabled

## Read Markers

- [ ] POST - /_matrix/client/r0/rooms/{roomId}/read_markers

## Reporting content

- [ ] POST - /_matrix/client/r0/rooms/{roomId}/report/{eventId}

## Room creation

- [X] POST - /_matrix/client/r0/createRoom

## Room directory

- [X] DELETE - /_matrix/client/r0/directory/room/{roomAlias}
- [X] GET - /_matrix/client/r0/directory/room/{roomAlias}
- [X] PUT - /_matrix/client/r0/directory/room/{roomAlias}

## Room discovery

- [X] GET - /_matrix/client/r0/publicRooms
- [ ] POST - /_matrix/client/r0/publicRooms

## Room membership

- [X] GET - /_matrix/client/r0/joined_rooms
- [X] POST - /_matrix/client/r0/join/{roomIdOrAlias}
- [X] POST - /_matrix/client/r0/rooms/{roomId}/ban
- [X] POST - /_matrix/client/r0/rooms/{roomId}/forget
- [X] POST - /_matrix/client/r0/rooms/{roomId}/invite
- [ ] POST - /_matrix/client/r0/rooms/{roomId}/invite
- [ ] POST - /_matrix/client/r0/rooms/{roomId}/join
- [X] POST - /_matrix/client/r0/rooms/{roomId}/kick
- [X] POST - /_matrix/client/r0/rooms/{roomId}/leave
- [X] POST - /_matrix/client/r0/rooms/{roomId}/unban

## Room participation

- [ ] GET - /_matrix/client/r0/events
- [ ] GET - /_matrix/client/r0/events/{eventId}
- [ ] GET - /_matrix/client/r0/initialSync
- [ ] GET - /_matrix/client/r0/rooms/{roomId}/context/{eventId}
- [ ] GET - /_matrix/client/r0/rooms/{roomId}/event/{eventId}
- [ ] GET - /_matrix/client/r0/rooms/{roomId}/initialSync
- [X] GET - /_matrix/client/r0/rooms/{roomId}/joined_members
- [ ] GET - /_matrix/client/r0/rooms/{roomId}/members
- [X] GET - /_matrix/client/r0/rooms/{roomId}/messages
- [ ] GET - /_matrix/client/r0/rooms/{roomId}/state
- [ ] GET - /_matrix/client/r0/rooms/{roomId}/state/{eventType}/{stateKey}
- [ ] GET - /_matrix/client/r0/sync
- [ ] GET - /_matrix/client/r0/user/{userId}/filter/{filterId}
- [ ] POST - /_matrix/client/r0/rooms/{roomId}/receipt/{receiptType}/{eventId}
- [ ] POST - /_matrix/client/r0/user/{userId}/filter
- [ ] PUT - /_matrix/client/r0/rooms/{roomId}/redact/{eventId}/{txnId}
- [X] PUT - /_matrix/client/r0/rooms/{roomId}/send/{eventType}/{txnId}
- [X] PUT - /_matrix/client/r0/rooms/{roomId}/state/{eventType}/{stateKey}
- [ ] PUT - /_matrix/client/r0/rooms/{roomId}/typing/{userId}

## Room ugprades

- [ ] POST - /_matrix/client/r0/rooms/{roomId}/upgrade

## Search

- [ ] POST - /_matrix/client/r0/search

## Send-to-Device messaging

- [ ] PUT - /_matrix/client/r0/sendToDevice/{eventType}/{txnId}

## Server administration

- [ ] GET - /.well-known/matrix/client
- [ ] GET - /_matrix/client/r0/admin/whois/{userId}
- [ ] GET - /_matrix/client/versions

## Session management

- [ ] GET - /_matrix/client/r0/login
- [ ] POST - /_matrix/client/r0/login
- [X] POST - /_matrix/client/r0/logout
- [ ] POST - /_matrix/client/r0/logout/all

## User data

- [X] DELETE - /_matrix/client/r0/user/{userId}/rooms/{roomId}/tags/{tag}
- [ ] GET - /_matrix/client/r0/account/3pid
- [X] GET - /_matrix/client/r0/account/whoami
- [X] GET - /_matrix/client/r0/profile/{userId}
- [X] GET - /_matrix/client/r0/profile/{userId}/avatar_url
- [X] GET - /_matrix/client/r0/profile/{userId}/displayname
- [ ] GET - /_matrix/client/r0/register/available
- [ ] GET - /_matrix/client/r0/user/{userId}/account_data/{type}
- [ ] GET - /_matrix/client/r0/user/{userId}/rooms/{roomId}/account_data/{type}
- [ ] GET - /_matrix/client/r0/user/{userId}/rooms/{roomId}/tags
- [ ] POST - /_matrix/client/r0/account/3pid
- [ ] POST - /_matrix/client/r0/account/3pid/delete
- [ ] POST - /_matrix/client/r0/account/deactivate
- [ ] POST - /_matrix/client/r0/account/password
- [X] POST - /_matrix/client/r0/register
- [ ] POST - /_matrix/client/r0/user_directory/search
- [ ] PUT - /_matrix/client/r0/profile/{userId}/avatar_url
- [X] PUT - /_matrix/client/r0/profile/{userId}/displayname
- [ ] PUT - /_matrix/client/r0/user/{userId}/account_data/{type}
- [ ] PUT - /_matrix/client/r0/user/{userId}/rooms/{roomId}/account_data/{type}
- [ ] PUT - /_matrix/client/r0/user/{userId}/rooms/{roomId}/tags/{tag}

## VOIP

- [ ] GET - /_matrix/client/r0/voip/turnServer

