## -*- Mode: CPerl -*-
##
## File: DTA::CAB::Analyzer::Morph::Latin::FST.pm
## Author: Bryan Jurish <moocow@cpan.org>
## Description: morphological analysis via Gfsm automaton, 'mlatin'

##==============================================================================
## Package: Analyzer::Morph::Latin::FST
##==============================================================================
package DTA::CAB::Analyzer::Morph::Latin::FST;
use DTA::CAB::Analyzer::Morph;
use Carp;
use strict;
our @ISA = qw(DTA::CAB::Analyzer::Morph);

## $obj = CLASS_OR_OBJ->new(%args)
##  + object structure: see DTA::CAB::Analyzer::Automaton::Gfsm
sub new {
  my $that = shift;
  my $aut = $that->SUPER::new(
			      ##-- defaults
			      #analysisClass => 'DTA::CAB::Analyzer::Morph::Analysis',

			      ##-- analysis selection
			      label => 'mlatin',
			      wantAnalysisLo => 0,
                              tolower => 1,

			      ##-- user args
			      @_
			     );
  return $aut;
}

##==============================================================================
## Analysis Formatting
##==============================================================================


1; ##-- be happy

__END__
##========================================================================
## POD DOCUMENTATION, auto-generated by podextract.perl
=pod

=cut

##========================================================================
## NAME
=pod

=head1 NAME

DTA::CAB::Analyzer::Morph::Latin::FST - auxilliary morphological analysis via Gfsm automaton

=cut

##========================================================================
## SYNOPSIS
=pod

=head1 SYNOPSIS

 use DTA::CAB::Analyzer::Morph::Latin::FST;
 
 $morph = DTA::CAB::Analyzer::Morph::Latin::FST->new(%args);

=cut

##========================================================================
## DESCRIPTION
=pod

=head1 DESCRIPTION

DTA::CAB::Analyzer::Morph::Latin::FST
is a just a simplified wrapper for
L<DTA::CAB::Analyzer::Morph|DTA::CAB::Analyzer::Morph>
which sets the following default options:

 label => 'mlatin',
 wantAnalysisLo => 0,
 tolower => 1,

=cut

##========================================================================
## END POD DOCUMENTATION, auto-generated by podextract.perl

##======================================================================
## Footer
##======================================================================

=pod

=head1 AUTHOR

Bryan Jurish E<lt>moocow@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2009-2019 by Bryan Jurish

This package is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.24.1 or,
at your option, any later version of Perl 5 you may have available.

=cut
