#!/usr/bin/perl -w
#

use MIDI::Simple;
use MIDI::Tab;
new_score;
patch_change 1,34;
patch_change 2,24;
patch_change 3,49;
set_tempo 400000;

my %drums;
my %bass;
my %guitar;
my %strings;

$drums{0} = <<"EOF";

BD:  --------------------------------

EOF

$drums{1} = <<"EOF";

SS:  7-7-7-7-7-7-7-7-7-7-7-7-7-7-7-7-

EOF

# drums 1 + build
$drums{'1b'} = <<"EOF";

SS:  5-5-5-5-5-5-5-5-5-5-5-5-5-5-5-5-
SD:  +---+---+---+---+---+---24688888

EOF

$drums{2} = <<"EOF";

RID: 9-------------------------------
BD:  8-4---8-2-8-----8-4---8-2-8---8-
SD:  ----8-------8-------8-------8--8
HH:  66-666-666-666-666-666-666-666-6
OHH: --6---6---6---6---6---6---6---6-

EOF

# NOT CURRENTLY USED
$drums{'2b'} = <<"EOF";

RID: 9-------------------------------
BD:  8-4---8-2-8-----8-4---8-2-8---8-
SD:  ----8-------8-------8---88888888
HH:  66-666-666-666-666-666-666-666-6
OHH: --6---6---6---6---6---6---6---6-

EOF

$bass{0} = <<"EOF";
G3: --------------------------------
D3: --------------------------------
A2: --------------------------------
E2: --------------------------------

EOF

$bass{A} = <<"EOF";
G3: --------------------------------
D3: --------------------------------
A2: 0-0-0-0-0-------0-0-0-0-0-------
E2: --------------------------------

EOF

$bass{E} = <<"EOF";
G3: +---+---+---+---+---+---+---+---
D3: --------------------------------
A2: ----7---5---3---2-3-2-0-2-0-----
E2: 0-0---0---0---0-------------4-0-

EOF

$bass{C} = <<"EOF";
G3: ------5-------------------------
D3: --------------------------------
A2: 3-3-3---3-------3-3-3-5-7-------
E2: --------------------------------

EOF

$guitar{A} = <<"EOF";
E5: +---0-------0---+---0-----------
B4: --------3-------1-------0-------
G4: --------------------------2---2-
D4: --2---2---2---2---2---2-----2---
A3: 0-------------------------------
E3: --------------------------------

EOF

$guitar{E} = <<"EOF";
E5: +---0-------0---+---0-----------
B4: --------3-------1-------0-------
G4: --------------------------0---0-
D4: --2---2---2---2---2---2-----2---
A3: --------------------------------
E3: 0-------------------------------

EOF

$guitar{C} = <<"EOF";
E5: +---0-------0---+---0-----------
B4: --------3-------1-------0-------
G4: --------------------------0---0-
D4: --2---2---2---2---2---2-----2---
A3: 3-------------------------------
E3: --------------------------------

EOF

$strings{A} = <<"EOF";

A5: 11
A4: 11

EOF

$strings{E} = <<"EOF";

E5: 11
E4: 11

EOF

$strings{C} = <<"EOF";

C5: 11
C4: 11

EOF

my @chords = qw(A A A A A A A A E E A A C E A A C E A A A A E E A A C E A A C E A A
		C E A A C E A A A A E E A A C E A A C E A A C E A A C E A A C E A A C E A);
my @bchrds = qw(0 0 0 0 A A A A E E A A C E A A C E A A A A E E A A C E A A C E A A
		C E A A C E A A A A E E A A C E A A C E A A C E A A C E A A C E A A C E A);
my @drums  = qw(0   0   0   0   0   0   0   0   0   1   1   1   1   1   1   1   1b
		2   2   2   1   1   1   1b  2   2   2   2   2   2   2   2   2   2   2   0);

for(1..1) {
    synch(
	sub {
	    foreach my $pattern(@drums) {
                from_drum_tab($_[0], $drums{$pattern}, 'en');
	    }
	},
        sub {
	    foreach my $chord(@chords) {
		from_piano_tab($_[0], $strings{$chord}, 'wn', 'c3', 'V100');
	    }
        },
        sub {
	    foreach my $chord(@bchrds) {
		from_guitar_tab($_[0], $bass{$chord}, 'sn', 'c1', 'V100');
	    }
        },
        sub {
	    foreach my $chord(@chords) {
		from_guitar_tab($_[0], $guitar{$chord}, 'sn', 'c2');
	    }
        },
    )  
}

write_score('street_spirit.mid');
