1;
__END__

=pod

=encoding Shift_JIS

=head1 NAME

Sjis-JA - JAPANESE DOCUMENT

=head1 v

=head2 gpO

  #!/usr/bin/perl
  use utf8;
  use open IO => ":encoding(cp932)";
  binmode STDIN => ":encoding(cp932)";
  binmode STDOUT => ":encoding(cp932)";
  binmode STDERR => ":encoding(cp932)";
  use Encode;
  
  my $char_length = length("}`oCg"); # Ԃ
  use bytes; # -- don't use it. just forget about it.
  my $byte_length = bytes::length("}`oCg"); # oCgԂ

=head2 gp

XNvg ShiftJIS_script.pl ̒ɈȉLq...

  #!/usr/bin/perl
  use Sjis;
  
  my $byte_length = length("}`oCg"); # ܂ŒʂoCgԂ
  my $char_length = Sjis::length("}`oCg"); # V@\ƂĕԂ

R}hvvgňȉ̂悤Ɏs

  perl ShiftJIS_script.pl argv1 argv2 ...

Sjis\tgEFÁAShiftJIS ɂďꂽ Perl XNvgperlC^v^
̊ԂɈʒu~hEFAłB

Perl ́AeLXg90%AȊȌ10%ō\ɌčœK
ĂƌĂ܂BłeLXg ShiftJIS ܂܂ȂƂĂ
Perl3 ȍ~ł΃oCif[^̂ŁAShiftJIS f[^oCif[^
ĈƂ\łB

"use Sjis;" ɂāAXNvg ShiftJIS ŋLq邱Ƃł悤ɂȂA
K\͂߂Ƃ perl ̊e@\ ShiftJIS ɑΉ悤ɂȂ܂B
֐ length ̒Pʂ̓oCĝ܂܂ŁAUTF8tO͎gp܂B

=head1 ̕̕\L̂Ԃɂ

VtgJISɑ΂閼̂ɂāA̕ł ShiftJIS ƂVtgJIS
Ƃ Shift-JIS Ƃ肵Ă܂AӖ͓̂ƍlĂB
LqۂɎQƂꍇAT˂̂܂܂̕\LcĂ܂B
ύXȂق悢Ǝv߁A̕ŜƂĂ͓ꂳĂ܂
B炩߂B

=head1 ЂƂ̖(݂炢)

JPerl ͂ƂĂDꂽ\tgEFAłBƁAł JPerl ͓{Ήł
Perl ̂ƂŁAJava  JVM Ƃ͊֌W܂BꂽA҂ꂽ肷
̂̂ŁÃ\tgEFA Sjis ƂOɂ܂B̌Agbvx
̖O邽 Char::Sjis ƂOŃfBXgr[V쐬悤
܂AȂ CPAN eX^[܂ CPAN ^c֌W҂łȂ̂Ȃ炱܂łǂ
 Sjis.pm, Esjis.pm gĂB

ƂŁA JPerl ̓o[W 5.005_04 ȍ~AeiXĂ܂B

ώcOȂƂɁAJPerl̊Jsn  The Perl Confernce Japan
1998 ɂ

  "킽Ȃׂ͔ꂽ玟̐l낵"

ƂbZ[WcAPerl 痣ĂĂ܂܂B

XCh15 "jperl ̍"

ftp://ftp.oreilly.co.jp/pcjp98/watanabe/jperlconf.ppt

ƒNpŏĂ邾낤B
ȂǂƊ҂Ȃ10NԁA҂ԂɐE͈ႤւƐił̂łB

̃\tgEFA ShiftJIS ŏꂽ Perl XNvgGXP[v邽߂
\[XR[htB^łBGXP[vɂĕR[hω邱Ƃ͂
܂Bωꍇ́AoOł̂ŕ񍐒Ƃ肪łB

\tgEFAȉ̂Ƃwł̃\tgEFA͍쐬܂B

=over 2

=item * Perl4  Perl5 ̂悤ȏʌ݊

=item * jcode.pl ̂悤ȍő̈ڐA

=item * JPerl ̂悤UTF8tOg킸AShiftJIŜ܂܈APerl 1̌̂܂

=item * Encode W[̂悤 Perl 1̃C^v^̂܂

=item * Ruby ̂悤ɕWƗȎ@

=item * cpanminus ̂悤ɃmVbNȃXNvg

=item * Perl ĝ悤 TMTOWTDI(There's more than one way to do it)

=back

̃\tgEFAPerl̖ɂčlƋǂǂ܂B݂Ȃ񂾂
Ƃł傤H

=head1 {IȎdg

ŋ߁Aȉ̃[Ĕ܂B

[Tokyo.pm] jus Benkyoukai

http://mail.pm.org/pipermail/tokyo-pm/1999-September/001854.html

("SJIS.pm" Ƃt@CŕۑĂ̂Ƃ܂)

  package SJIS;
  use Filter::Util::Call;
  sub multibyte_filter {
      my $status;
      if (($status = filter_read()) > 0 ) {
          s/([\x81-\x9f\xe0-\xef])([\x40-\x7e\x80-\xfc])/
              sprintf("\\x%02x\\x%02x",ord($1),ord($2))
          /eg;
      }
      $status;
  }
  sub import {
      filter_add(\&multibyte_filter);
  }
  1;

{Iɂ́Ã\tgEFA͏L̂悤ȂƂs܂B
AFilter::Util::Call 𗘗pĂȂ_APerl ̍\͂ĕKvɉ
GXP[v_قȂ܂B

=head1 CXg[@(ȒPȕ@)

   CPAN  Sjis.pm  Esjis.pm _E[h Perl  lib fBNgɊi[܂B

=head1 CXg[@(makegꍇ)

   perl Makefile.PL
   make test
   make install

=head1 CXg[@(makegȂꍇ)

   perl pMakefile.pl          --- pMakefile.pl  pmake.bat 𐶐܂
   pmake.bat
   pmake.bat test
   pmake.bat install          --- ݎgp perl ɃCXg[܂
   pmake.bat dist             --- CPAN zzppbP[W܂
   pmake.bat ptar.bat         --- ptar.bat 쐬܂

=head1 \tgEFÄꗗ

   Sjis.pm               --- ShiftJIS \[XR[htB^
   Esjis.pm              --- Sjis.pm ̃^C[`
   Char/Sjis.pm          --- CPANeX^[ Sjis.pm
   Char/Esjis.pm         --- CPANeX^[ Esjis.pm

=head1 DOSVXeɂR}hC̃ChJ[hWJ

DOSVXe̕WVF(COMMAND.COM  cmd.exe)́ANvO֓n
p[^̃ChJ[hWJs܂B̑Ƃ Esjis.pm  import
֐ChJ[hWJs悤ɂȂĂ܂B

   Ql Esjis.pm 甲
   #
   # @ARGV wildcard globbing
   #
   sub import {

       if ($^O =~ /\A (?: MSWin32 | NetWare | symbian | dos ) \z/oxms) {
           my @argv = ();
           for (@ARGV) {

               # has space
               if (/\A (?:$q_char)*? [ ] /oxms) {
                   if (my @glob = Esjis::glob(qq{"$_"})) {
                       push @argv, @glob;
                   }
                   else {
                       push @argv, $_;
                   }
               }

               # has wildcard metachar
               elsif (/\A (?:$q_char)*? [*?] /oxms) {
                   if (my @glob = Esjis::glob($_)) {
                       push @argv, @glob;
                   }
                   else {
                       push @argv, $_;
                   }
               }

               # no wildcard globbing
               else {
                   push @argv, $_;
               }
           }
           @ARGV = @argv;
       }
   }

=head1 ߂ĂJPerl

   g(1)

    1. XNvg ShiftJIS_script.pl ̒Ɉȉ̂ꂩLq...

      use Sjis;
      use Sjis ver.sion;              --- Sjis.pm ̃o[W ver.sion ȏȂs
      use Sjis ver.sion.0;            --- Sjis.pm ̃o[W ver.sion łȂ die 
      use Sjis qw(ord reverse getc);  --- ord, reverse, getc ̊g@\gꍇ
      use Sjis ver.sion qw(ord reverse getc);
      use Sjis ver.sion.0 qw(ord reverse getc);

       no Sjis; ͗pł܂B

      use Sjis ver.sion.0; ` Sjis\tgEFÃo[W̏Ȇo
      wł܂Bs Sjis\tgEFALqo[WƂ҂蓯
      ȂȂ die ܂BႦ΁Ause Sjis 0.88.0; ƋLq Sjis\tgEFA
      ̃o[W 0.88 ł邱Ƃۏł܂B

    2. R}hvvgňȉ̂悤Ɏs

      perl  ShiftJIS_script.pl  wild*  *card  and  '*quote*'  on MSWin32

      ? * găChJ[h̎w肪ł܂
      ' ` ' găNH[g邱Ƃł܂

   g(2)

    R}hvvgňȉ̂悤Ɏs

      C:\>perl  Sjis.pm  ShiftJIS_script.pl  >  Escaped_script.pl.e
      C:\>perl  Escaped_script.pl.e

      ShiftJIS_script.pl  --- ShiftJIS ŏꂽXNvg
      Escaped_script.pl.e --- GXP[vꂽXNvg

   gTu[`Ɗ֐
      Sjis::ord(...);
      Sjis::reverse(...);
      Sjis::getc(...);
      Sjis::length(...);
      Sjis::substr(...);
      Sjis::index(...);
      Sjis::rindex(...);
      Sjis::eval(...);
      CORE::chop(...);
      CORE::ord(...);
      CORE::reverse(...);
      CORE::getc(...);
      CORE::index(...);
      CORE::rindex(...);

   ȉ̓_~[Tu[`ƂėpӂĂ
      utf8::upgrade(...);
      utf8::downgrade(...);
      utf8::encode(...);
      utf8::decode(...);
      utf8::is_utf8(...);
      utf8::valid(...);
      bytes::chr(...);
      bytes::index(...);
      bytes::length(...);
      bytes::ord(...);
      bytes::rindex(...);
      bytes::substr(...);

=head1 GXP[vɂʌ݊̊m

̃\tgEFA͉ߋ̂̂󂵂͂AɁuGXP[vvɂċ@\ǉ
Ă܂B獡܂ŉ\łƂs\ɂȂ邱Ƃ͂܂B̃Av
[`́AނċȂɗLłBȂAʌ݊̊mۂ̂߂ɁA
Perlg̔݊Ȋg菜Ƃ܂B

=head1 XNvg̃GXP[v

쐬XNvg 'use Sjis;' ƏKv܂B

  ---------------------
  ȉ̂悤ɏ܂
  ---------------------
  use Sjis;
  ---------------------

=head1 }`oCg̃GXP[v

̃\tgEFAɂāA}`oCg̑2oCg @  [  \  ]  ^  `  {  |  }
̒O chr(0x5c) }܂BΏۂ͈ȉ̉ӏłB

=over 2

=item * VONH[g̕ ('', q{}, <<'END' and qw{})

=item * _uNH[g̕ ("", qq{}, <<END, <<"END", ``, qx{} and <<`END`)

=item * VONH[g̐K\ (m'', s''', split(''), split(m'') and qr'')

=item * _uNH[g̐K\ (//, m//, ??, s///, split(//), split(m//) and qr//)

=item * tr/// ̒̕ (tr/// and y///)

=back

  : J^Jíu\vR[h "\x83\x5C"
  
                    _v
  -----------------------------------------
  source script   "`/"    [83 5c]
  -----------------------------------------
 
   use Sjis; s
                          _v
  -----------------------------------------
  escaped script  "`\/"   [83 [5c] 5c]
  -----------------------------------------
                    ^--- Sjis\tgEFAŃGXP[v
 
  Ql              _v
  -----------------------------------------
  your eye's      "`/\"   [83 5c] [5c]
  -----------------------------------------
  perl eye's      "`\/"   [83] \[5c]
  -----------------------------------------
 
                          _v
  -----------------------------------------
  in the perl     "`/"    [83] [5c]
  -----------------------------------------

=head1 K\ւ̃}`oCgAJ[O̒ǉ

Sjis\tgEFA͐K\̐擪Ƀ}`oCgAJ[Ot܂B

  --------------------------------------------------------------------------------
  O                  
  --------------------------------------------------------------------------------
  m/regexp/               m/${Esjis::anchor}(?:regexp).../
  --------------------------------------------------------------------------------

${Esjis::anchor} ̋̓IȓeɂĂ͕ʓruSjis\tgEFÃ}`oCgA
J[OvɋLqĂ܂B

=head1 2INebg̃GXP[v

Sjis\tgEFA͐K\̃}`oCg̑2INebgGXP[v܂B

  --------------------------------------------------------------------------------
  O                  
  --------------------------------------------------------------------------------
  m{...`/...}             m{...`/\...}
  --------------------------------------------------------------------------------

=head1 K\̃}`oCg̈ɂ

Sjis\tgEFA̓}`oCgւ̗ʎwqAу}`oCg̃JX^
NXNX^O܂B܂NbVbN Perl NXAPOSIX X^C
̕NX}`oCgΉłɏ܂B

  --------------------------------------------------------------------------------
  O                  
  --------------------------------------------------------------------------------
  m/...MULTIOCT+.../      m/...(?:MULTIOCT)+.../
  m/...[AN-EM].../        m/...(?:A[N-Z]|[B-D][A-Z]|E[A-M]).../
  m/...\D.../             m/...(?:${Esjis::eD}).../
  m/...[[:^digit:]].../   m/...(?:${Esjis::not_digit}).../
  --------------------------------------------------------------------------------

=head1 Esjis::ignorecase() ̌Ăяo

Sjis\tgEFA /i Cq̑ Esjis::ignorecase() ̌ďo܂B

  --------------------------------------------------------------------------------
  O                  
  --------------------------------------------------------------------------------
  m/...$var.../i          m/...@{[Esjis::ignorecase($var)]}.../
  --------------------------------------------------------------------------------

=head1 w̐K\

/b Cq̂ȂK\͕w̓܂B
܂A/./ (hbg)͕Ƀ}b`܂B

  --------------------------------------------------------------------------------
  O                  
  --------------------------------------------------------------------------------
  /regexp/                / LQ $Esjis::matched/
  m/regexp/               m/ LQ $Esjis::matched/
  ?regexp?                m? LQ $Esjis::matched?
  m?regexp?               m? LQ $Esjis::matched?
 
  $_ =~                   ($_ =~ m/ LQ $Esjis::matched/) ?
  s/regexp/replacement/   eval{ Esjis::s_matched(); local $^W=0; my $__r=qq/replacement/; $_="${1}$__r$'"; 1 } :
                          undef
 
  $_ !~                   ($_ !~ m/ LQ $Esjis::matched/) ?
  s/regexp/replacement/   1 :
                          eval{ Esjis::s_matched(); local $^W=0; my $__r=qq/replacement/; $_="${1}$__r$'"; undef }
 
  split(/regexp/)         Esjis::split(qr/regexp/)
  split(m/regexp/)        Esjis::split(qr/regexp/)
  split(qr/regexp/)       Esjis::split(qr/regexp/)
  qr/regexp/              qr/ LQ $Esjis::matched/
  --------------------------------------------------------------------------------

=head1 oCgw̐K\

/b CqtK\̓oCgw̓܂B
܂A/./ (hbg)̓oCgɃ}b`܂B

  --------------------------------------------------------------------------------
  O                  
  --------------------------------------------------------------------------------
  /regexp/b               /(?:regexp)$Esjis::matched/
  m/regexp/b              m/(?:regexp)$Esjis::matched/
  ?regexp?b               m?regexp$Esjis::matched?
  m?regexp?b              m?regexp$Esjis::matched?
 
  $_ =~                   ($_ =~ m/(\G[\x00-\xFF]*?)(?:regexp)$Esjis::matched/) ?
  s/regexp/replacement/b  eval{ Esjis::s_matched(); local $^W=0; my $__r=qq/replacement/; $_="${1}$__r$'"; 1 } :
                          undef
 
  $_ !~                   ($_ !~ m/(\G[\x00-\xFF]*?)(?:regexp)$Esjis::matched/) ?
  s/regexp/replacement/b  1 :
                          eval{ Esjis::s_matched(); local $^W=0; my $__r=qq/replacement/; $_="${1}$__r$'"; undef }
 
  split(/regexp/b)        split(qr/regexp/)
  split(m/regexp/b)       split(qr/regexp/)
  split(qr/regexp/b)      split(qr/regexp/)
  qr/regexp/b             qr/(?:regexp)$Esjis::matched/
  --------------------------------------------------------------------------------

=head1 NX̃GXP[v

ߋperlƂ̌݊ۂ߂ɕNX͈ȉ̂悤ɍĒ`Ă܂B

  ---------------------------------------------------------------
  escape        class
  ---------------------------------------------------------------
   .            ${Esjis::dot}
                ${Esjis::dot_s}    (/s Cq)
  \d            [0-9]
  \s            [\x09\x0A\x0B\x0C\x0D\x20]
  \w            [0-9A-Z_a-z]
  \D            ${Esjis::eD}
  \S            ${Esjis::eS}
  \W            ${Esjis::eW}
  \h            [\x09\x20]
  \v            [\x0A\x0B\x0C\x0D]
  \H            ${Esjis::eH}
  \V            ${Esjis::eV}
  \C            [\x00-\xFF]
  \X            X (̉pAX ł)
  \R            ${Esjis::eR}
  \N            ${Esjis::eN}
  ---------------------------------------------------------------

l POSIX X^C̕NXĒ`Ă܂B

  ---------------------------------------------------------------
  escape        class
  ---------------------------------------------------------------
  [:alnum:]     [\x30-\x39\x41-\x5A\x61-\x7A]
  [:alpha:]     [\x41-\x5A\x61-\x7A]
  [:ascii:]     [\x00-\x7F]
  [:blank:]     [\x09\x20]
  [:cntrl:]     [\x00-\x1F\x7F]
  [:digit:]     [\x30-\x39]
  [:graph:]     [\x21-\x7F]
  [:lower:]     [\x61-\x7A]
                [\x41-\x5A\x61-\x7A]     (/i Cq)
  [:print:]     [\x20-\x7F]
  [:punct:]     [\x21-\x2F\x3A-\x3F\x40\x5B-\x5F\x60\x7B-\x7E]
  [:space:]     [\s\x0B]
  [:upper:]     [\x41-\x5A]
                [\x41-\x5A\x61-\x7A]     (/i Cq)
  [:word:]      [\x30-\x39\x41-\x5A\x5F\x61-\x7A]
  [:xdigit:]    [\x30-\x39\x41-\x46\x61-\x66]
  [:^alnum:]    ${Esjis::not_alnum}
  [:^alpha:]    ${Esjis::not_alpha}
  [:^ascii:]    ${Esjis::not_ascii}
  [:^blank:]    ${Esjis::not_blank}
  [:^cntrl:]    ${Esjis::not_cntrl}
  [:^digit:]    ${Esjis::not_digit}
  [:^graph:]    ${Esjis::not_graph}
  [:^lower:]    ${Esjis::not_lower}
                ${Esjis::not_lower_i}    (/i Cq)
  [:^print:]    ${Esjis::not_print}
  [:^punct:]    ${Esjis::not_punct}
  [:^space:]    ${Esjis::not_space}
  [:^upper:]    ${Esjis::not_upper}
                ${Esjis::not_upper_i}    (/i Cq)
  [:^word:]     ${Esjis::not_word}
  [:^xdigit:]   ${Esjis::not_xdigit}
  ---------------------------------------------------------------

\b  \B ߋperlƂ̌݊ۂ߂ɍĒ`Ă܂B

  ---------------------------------------------------------------
  escape      class
  ---------------------------------------------------------------
  \b          ${Esjis::eb}
  \B          ${Esjis::eB}
  ---------------------------------------------------------------

L̒`́At@C Esjis.pm ̒ňȉ̂悤ɒ`Ă܂B

  ---------------------------------------------------------------------------------------------------------------------------------------------------------
  class                    Definition
  ---------------------------------------------------------------------------------------------------------------------------------------------------------
  ${Esjis::anchor}         qr{\G(?>[^\x81-\x9F\xE0-\xFC]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])*?}
                           32766INebg𒴂镶悤ɂ邽߁AActivePerl5.6ȍ~(5.10.0܂)A܂͂̑Perl5.10.1ȍ~̏ꍇ͈ȉ̂悤ɂȂ܂
                           qr{\G(?(?=.{0,32766}\z)\G(?>[^\x81-\x9F\xE0-\xFC]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])*?|(?(?=[$sbcs]+\z).*?|(?:.*?[$sbcs](?:[^$sbcs][^$sbcs])*?)))}oxms
  ${Esjis::dot}            qr{(?>[^\x81-\x9F\xE0-\xFC\x0A]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::dot_s}          qr{(?>[^\x81-\x9F\xE0-\xFC]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::eD}             qr{(?>[^\x81-\x9F\xE0-\xFC0-9]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::eS}             qr{(?>[^\x81-\x9F\xE0-\xFC\s]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::eW}             qr{(?>[^\x81-\x9F\xE0-\xFC0-9A-Z_a-z]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::eH}             qr{(?>[^\x81-\x9F\xE0-\xFC\x09\x20]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::eV}             qr{(?>[^\x81-\x9F\xE0-\xFC\x0A\x0B\x0C\x0D]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::eR}             qr{(?>\x0D\x0A|[\x0A\x0D])};
  ${Esjis::eN}             qr{(?>[^\x81-\x9F\xE0-\xFC\x0A]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::not_alnum}      qr{(?>[^\x81-\x9F\xE0-\xFC\x30-\x39\x41-\x5A\x61-\x7A]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::not_alpha}      qr{(?>[^\x81-\x9F\xE0-\xFC\x41-\x5A\x61-\x7A]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::not_ascii}      qr{(?>[^\x81-\x9F\xE0-\xFC\x00-\x7F]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::not_blank}      qr{(?>[^\x81-\x9F\xE0-\xFC\x09\x20]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::not_cntrl}      qr{(?>[^\x81-\x9F\xE0-\xFC\x00-\x1F\x7F]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::not_digit}      qr{(?>[^\x81-\x9F\xE0-\xFC\x30-\x39]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::not_graph}      qr{(?>[^\x81-\x9F\xE0-\xFC\x21-\x7F]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::not_lower}      qr{(?>[^\x81-\x9F\xE0-\xFC\x61-\x7A]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::not_lower_i}    qr{(?>[^\x81-\x9F\xE0-\xFC\x41-\x5A\x61-\x7A]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])}; # Perl 5.16 ݊
# ${Esjis::not_lower_i}    qr{(?>[^\x81-\x9F\xE0-\xFC]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};                   # ̂ Perl ̓
  ${Esjis::not_print}      qr{(?>[^\x81-\x9F\xE0-\xFC\x20-\x7F]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::not_punct}      qr{(?>[^\x81-\x9F\xE0-\xFC\x21-\x2F\x3A-\x3F\x40\x5B-\x5F\x60\x7B-\x7E]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::not_space}      qr{(?>[^\x81-\x9F\xE0-\xFC\s\x0B]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::not_upper}      qr{(?>[^\x81-\x9F\xE0-\xFC\x41-\x5A]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::not_upper_i}    qr{(?>[^\x81-\x9F\xE0-\xFC\x41-\x5A\x61-\x7A]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])}; # Perl 5.16 ݊
# ${Esjis::not_upper_i}    qr{(?>[^\x81-\x9F\xE0-\xFC]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};                   # ̂ Perl ̓
  ${Esjis::not_word}       qr{(?>[^\x81-\x9F\xE0-\xFC\x30-\x39\x41-\x5A\x5F\x61-\x7A]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  ${Esjis::not_xdigit}     qr{(?>[^\x81-\x9F\xE0-\xFC\x30-\x39\x41-\x46\x61-\x66]|[\x81-\x9F\xE0-\xFC][\x00-\xFF])};
  
  # ̕@͊͒̂ŁAǂ@mĂЂƂ͋Ă
  ${Esjis::eb}             qr{(?:\A(?=[0-9A-Z_a-z])|(?<=[\x00-\x2F\x40\x5B-\x5E\x60\x7B-\xFF])(?=[0-9A-Z_a-z])|(?<=[0-9A-Z_a-z])(?=[\x00-\x2F\x40\x5B-\x5E\x60\x7B-\xFF]|\z))};
  ${Esjis::eB}             qr{(?:(?<=[0-9A-Z_a-z])(?=[0-9A-Z_a-z])|(?<=[\x00-\x2F\x40\x5B-\x5E\x60\x7B-\xFF])(?=[\x00-\x2F\x40\x5B-\x5E\x60\x7B-\xFF]))};
  ---------------------------------------------------------------------------------------------------------------------------------------------------------

=head1 \b{}, \B{}, \N{}, \p{}, \P{}, \X  \ ̃AGXP[v

̃\tgEFAɂĉp̐K\^V{ \b{}, \B{}, \N{}, \p{}, \P{},
\X ̐擪 '\' 菜܂B̕@Œۉ㩂邱Ƃł܂B

AGXP[v "{" GXP[v悤ɂŔA
Deprecate literal unescaped "{" in regexes.
http://perl5.git.perl.org/perl.git/commit/2a53d3314d380af5ab5283758219417c6dfa36e9
ɂ̂łB

  ------------------------------------
  O           
  ------------------------------------
  \b{...}          b\{...}
  \B{...}          B\{...}
  \N{CHARNAME}     N\{CHARNAME}
  \p{L}            p\{L}
  \p{^L}           p\{^L}
  \p{\^L}          p\{\^L}
  \pL              pL
  \P{L}            P\{L}
  \P{^L}           P\{^L}
  \P{\^L}          P\{\^L}
  \PL              PL
  \X               X
  ------------------------------------

=head1 g݊֐̃GXP[v

̃\tgEFAɂĊ֐̐擪 'Esjis::' GXP[v܂B
Esjis::* Tu[` Esjis.pm 񋟂܂B

  --------------------------------------------
  O                  
  --------------------------------------------
  length      length            oCgw
  substr      substr            oCgw
  pos         pos               oCgw
  split       Esjis::split      w
  tr///       Esjis::tr         w
  tr///b      tr///             oCgw
  tr///B      tr///             oCgw
  y///        Esjis::tr         w
  y///b       tr///             oCgw
  y///B       tr///             oCgw
  chop        Esjis::chop       w
  index       Esjis::index      w
  rindex      Esjis::rindex     w
  lc          Esjis::lc         w
  lcfirst     Esjis::lcfirst    w
  uc          Esjis::uc         w
  ucfirst     Esjis::ucfirst    w
  fc          Esjis::fc         w
  chr         Esjis::chr        w
  glob        Esjis::glob       w
  lstat       Esjis::lstat      w
  opendir     Esjis::opendir    w
  stat        Esjis::stat       w
  unlink      Esjis::unlink     w
  chdir       Esjis::chdir      w
  do          Esjis::do         w
  require     Esjis::require    w
  --------------------------------------------

  ------------------------------------------------------------------------------------------------------------------------
  O                   
  ------------------------------------------------------------------------------------------------------------------------
  use Perl::Module;        BEGIN { Esjis::require 'Perl/Module.pm'; Perl::Module->import() if Perl::Module->can('import'); }
  use Perl::Module @list;  BEGIN { Esjis::require 'Perl/Module.pm'; Perl::Module->import(@list) if Perl::Module->can('import'); }
  use Perl::Module ();     BEGIN { Esjis::require 'Perl/Module.pm'; }
  no Perl::Module;         BEGIN { Esjis::require 'Perl/Module.pm'; Perl::Module->unimport() if Perl::Module->can('unimport'); }
  no Perl::Module @list;   BEGIN { Esjis::require 'Perl/Module.pm'; Perl::Module->unimport(@list) if Perl::Module->can('unimport'); }
  no Perl::Module ();      BEGIN { Esjis::require 'Perl/Module.pm'; }
  ------------------------------------------------------------------------------------------------------------------------

=head1 t@CeXgZq̃GXP[v

̃\tgEFAɂĉZq '-'  'Esjis::' ɏ܂B

  MSWin32, MacOS  UNIX̃VXeŗp\ȉZq
  -------------------------------------------------------------------------------
  O          
  -------------------------------------------------------------------------------
  -r        Esjis::r    t@CfBNg()[U܂̓O[vǂݏo\
  -w        Esjis::w    t@CfBNg()[U܂̓O[v珑݉\
  -e        Esjis::e    t@CfBNg݂
  -x        Esjis::x    t@CfBNg()[U܂̓O[vs\
  -z        Esjis::z    t@C݂Ăđ傫0ł(fBNgɑ΂Ă͏ɋUɂȂ)
  -f        Esjis::f    Gg͕ʂ̃t@Cł
  -d        Esjis::d    Gg̓fBNgł
  -t        -t          ̃t@CnhTTYł(isatty()VXe֐̌ʂŔ肷B
                        ̃eXg̓t@Cɂ͓KpłȂ)
  -T        Esjis::T    ̃t@ĆueLXgvt@Ĉ悤ł
  -B        Esjis::B    ̃t@ĆuoCivt@Ĉ悤ł
  -M        Esjis::M    ŌɕύXĂ̓
  -A        Esjis::A    ŌɃANZXĂ̓
  -C        Esjis::C    Ō im[h(inode) ύXĂ̓
  -s        Esjis::s    t@CfBNg݂Ăđ傫 0 łȂ
                        (oCgPʂŕ\킵t@C̑傫lɂȂ)
  -------------------------------------------------------------------------------
  
  MacOS  UNIX̃VXeŗp\ȉZq
  -------------------------------------------------------------------------------
  O          
  -------------------------------------------------------------------------------
  -R        Esjis::R    t@CfBNg̎[U܂̓O[vǂݏo\
  -W        Esjis::W    t@CfBNg̎[U܂̓O[v珑݉\
  -X        Esjis::X    t@CfBNg̎[U܂̓O[vs\
  -l        Esjis::l    Gg̓V{bNNł
  -S        Esjis::S    Gg̓\Pbgł
  -------------------------------------------------------------------------------
  
  MSWin32, MacOS ł͗poȂt@CeXgZq
  -------------------------------------------------------------------------------
  O          
  -------------------------------------------------------------------------------
  -o        Esjis::o    t@CfBNg()[ULĂ
  -O        Esjis::O    t@CfBNg̎[ULĂ
  -p        Esjis::p    Gg͖OtpCv(fifo)ł
  -b        Esjis::b    Gg̓ubNfoCXł(Ⴆ΁A}Eg\ȃfBXN)
  -c        Esjis::c    Gg̓LN^foCXł(Ⴆ΁AI/OfoCX)
  -u        Esjis::u    t@CfBNg setuid Ă
  -g        Esjis::g    t@CfBNg setgid Ă
  -k        Esjis::k    t@CfBNg sticky rbgZbgĂ
  -------------------------------------------------------------------------------

perl5.00503 gpĂꍇłt@CeXgZq́uςݏd˂vƂ
ł܂B

  if ( -w -r $file ) {
      print "The file is both readable and writable!\n";
  }

=head1 ֐̃GXP[v

w̃Tu[`gꍇ͈ȉ̂悤ɋLqKv܂B
ꂼ̋@\ɂẮuw̃Tu[`vQƂĂB

  ----------------------------------------------------
  ֐    w        
  ----------------------------------------------------
  ord       Sjis::ord
  reverse   Sjis::reverse
  getc      Sjis::getc
  length    Sjis::length
  substr    Sjis::substr
  index     Sjis::index     ȉ̋LqQƂ̂
  rindex    Sjis::rindex    ȉ̋LqQƂ̂
  ----------------------------------------------------

  index ̒Ԃ
  --------------------------------------------------------------
  ֐                  Ԓl         
  --------------------------------------------------------------
  index          w     oCgP   JPerlƓ
  Sjis::index    w     P     w̓
  CORE::index    oCgw   oCgP   oCgw̓
  --------------------------------------------------------------

  rindex ̒Ԃ
  --------------------------------------------------------------
  ֐                  Ԓl         
  --------------------------------------------------------------
  rindex         w     oCgP   JPerlƓ
  Sjis::rindex   w     P     w̓
  CORE::rindex   oCgw   oCgP   oCgw̓
  --------------------------------------------------------------

=head1 w̃Tu[`

=over 2

=item * Sjis::ord

    $ord = Sjis::ord($string);

    Sjis::ord($string)  $string ̐擪̕ ShiftJIS R[hlԂ܂
    (Unicode ł͂܂)B$string ȗꂽꍇ $_ ΏۂƂȂ܂B
    ̃Tu[`͏ɕȂ̒lԂ܂B

    "use Sjis qw(ord);" ɂăXNvgɋLq ord  Sjis::ord ɏ
    悤ɂȂ܂Bord  Sjis::ord ̓̂ JPerl Ɣ݊Ȃ
    ŖIɃC|[gꍇ̂ݏ܂B

=item * Sjis::reverse

    @reverse = Sjis::reverse(@list);
    $reverse = Sjis::reverse(@list);

    Sjis::reverse(@list) ̓XgReLXgł @list ̗vftɕׂ
    XglԂ܂B

    XJ[ReLXgł @list ׂ̂Ă̗vfAŁAShiftJIS 
    Pʂŋtɂ̂Ԃ܂B

    "use Sjis qw(reverse);" ɂăXNvgɋLq reverse 
    Sjis::reverse ɏ悤ɂȂ܂Breverse  Sjis::reverse ̓
    ̂ JPerl Ɣ݊Ȃ̂ŖIɃC|[gꍇ̂ݏ܂B

    ̃Tu[`mȂƂ͂܂B܂ŒʂÃTu
    [`

    $rev = join('', reverse(split(//, $jstring)));

    Ŏł܂B

    Ql:
    P.558 JPerl ({ΉPerl)
    t^C {ł̒ǉ
    ISBN 4-89052-384-7 PerlvO~O

=item * Sjis::getc

    $getc = Sjis::getc(FILEHANDLE);
    $getc = Sjis::getc($filehandle);
    $getc = Sjis::getc;

    FILEHANDLE Ɍтꂽ̓t@CA1ǂŕԂ܂B
    end-of-file(t@C̏I) ɂȂA邢 I/O G[ꍇ
    ́Aundef Ԃ܂BFILEHANDLE ȗƁASTDIN ͂܂B

    ̃Tu[`͏x̂́AL[{[h1͂ۂɕ֗ł
    -- L[{[h͂obt@OȂɐݒł΂łB̃Tu[`́A
    WI/OCuɑ΂āAobt@OȂœ͂悤ɗv܂BcO
    ƂɁAWI/OCúAIy[eBOVXeɑ΂ăobt@OȂ
    ŃL[{[h͂s悤ɗv邽߂́AڐÂipӂ܂łɂ́A
    WĂ܂Bɂ́AXmb𓭂āAIy[eBOVXe
    ŗL̂Kv܂BUnix ł́Â悤ɂ΂܂ł傤B

    if ($BSD_STYLE) {
        system "stty cbreak </dev/tty >/dev/tty 2>&1";
    }
    else {
        system "stty", "-icanon", "eol", "\001";
    }

    $key = Sjis::getc;

    if ($BSD_STYLE) {
        system "stty -cbreak </dev/tty >/dev/tty 2>&1";
    }
    else {
        system "stty", "icanon", "eol", "^@"; # ASCII NUL
    }
    print "\n";

    ̃R[h́A[玟Ƀ^Cvꂽϐ $key ɓ܂BȂ̃VXe
     stty vO cbreak IvVȂÃR[ĥA$BSD_STYLE
    ^̏ꍇ̃R[hgƗǂł傤BłȂ΁A$BSD_STYLE Ȕꍇ
    R[hg΂悢ł傤B

    "use Sjis qw(getc);" ɂăXNvgɋLq getc  Sjis::getc ɏ
    悤ɂȂ܂Bgetc  Sjis::getc ̓̂ JPerl Ɣ݊Ȃ
    ŖIɃC|[gꍇ̂ݏ܂B

=item * Sjis::length

    $length = Sjis::length($string);
    $length = Sjis::length();

    Sjis::length($string) ̓XJ[l $string ̒ ShiftJIS ̕(vO
    }猩镶)ŕԂ܂B$string ȗꍇ $_ ̕Ԃ
    B

    zAzz(nbV)̑傫m肽ꍇɂ́ASjis::length ͎g
    Bz̑傫mɂ scalar @arrayAAzzɓĂL[/l̃y
    Ǎmɂ scalar keys %hash Ƃ܂B

    ł͂ȂoCgPʂł̒𒲂ׂɂ́A܂܂Œʂ

    $bytes = length($string);

    ̂悤ɂ܂B

    ̃Tu[`mȂƂ͂܂B܂ŒʂÃTu[
    `

    $len = split(//, $jstring);

    Ŏł܂B

    Ql:
    P.558 JPerl ({ΉPerl)
    t^C {ł̒ǉ
    ISBN 4-89052-384-7 PerlvO~O

=item * Sjis::substr

    $substr = Sjis::substr($string,$offset,$length,$replacement);
    $substr = Sjis::substr($string,$offset,$length);
    $substr = Sjis::substr($string,$offset);

    Sjis::substr ́AShiftJIS  $string Ŏw肳ꂽ񂩂畔
    oĕԂ܂B́A̐擪琔 $offset ڂn܂A
    $length łBŏ̕ItZbg 0 ƂȂ܂B$offset ɕ̒lݒ
    ƁA$string ̏I肩̃ItZbgƂȂ܂B
    $length ȗƁA$string ̍Ō܂łׂĂԂ܂B$length ̒l
    ƁA̍Ōォw肳ꂽ菜܂BłȂ΁A$length
    ́AȂ҂悤ɁAo̒\Ă܂B

    my $s = "The black cat climbed the green tree";
    my $color  = Sjis::substr $s, 4, 5;      # black
    my $middle = Sjis::substr $s, 4, -11;    # black cat climbed the
    my $end    = Sjis::substr $s, 14;        # climbed the green tree
    my $tail   = Sjis::substr $s, -4;        # tree
    my $z      = Sjis::substr $s, -4, 2;     # tr

    o[W 5.14 ȍ~ Perl ł΁ASjis::substr() ӒlƂĎgp邱Ƃ
    \łB̏ꍇɂ́A$string gӒlłȂ΂Ȃ܂B$length Z
    ̂Ƃɂ́A$string ͒ZȂA$length 蒷̂Ƃɂ́A
    $string ͂ɍ킹ĐLт邱ƂɂȂ܂B$string ̒ɕۂ߂ɂ́A
    sprintf gāAl̒𒲐邱ƂAKvɂȂ邩܂B

    $offset  $length Ƃĕ̊O܂ނ悤ȕ񂪎w肳ƁA
    ̓̕Ԃ܂B񂪕̗[̊ȌꍇASjis::substr()
    ͖`lԂAxo͂܂BӒlƂĎgꍇÅSɊO
    ƂĎw肷ƗO܂Bȉ͋E̐U镑ł:

    my $name = 'fred';
    Sjis::substr($name, 4) = 'dy';         # $name is now 'freddy'
    my $null = Sjis::substr $name, 6, 2;   # returns "" (no warning)
    my $oops = Sjis::substr $name, 7;      # returns undef, with warning
    Sjis::substr($name, 7) = 'gap';        # raises an exception

    Sjis::substr() ӒlƂĎg̕@́Au镶 4 Ԗڂ̈
    Ďw肷邱ƂłBɂA$string ̈ꕔuAuOł
    ԂAƂƂ(splice() Ɠl) 1 ōs܂B

    my $s = "The black cat climbed the green tree";
    my $z = Sjis::substr $s, 14, 7, "jumped from";    # climbed
    # $s is now "The black cat jumped from the green tree"

    3  Sjis::substr() ɂĕԂꂽӒĺu@̒eہv̂悤ɐUƂ
    ӂĂ; ꂪ閈ɁÂ̕ǂ̕ύXꂽv
    o܂; Ⴆ:

    $x = '1234';
    for (Sjis::substr($x,1,2)) {
        $_ = 'a';   print $x,"\n";    # prints 1a4
        $_ = 'xyz'; print $x,"\n";    # prints 1xyz4
        $x = '56789';
        $_ = 'pq';  print $x,"\n";    # prints 5pq9
    }

    ̃ItZbg̏ꍇA^[Qbg񂪏CꂽƂɕ̖̈ʒu
    o܂:

    $x = '1234';
    for (Sjis::substr($x, -3, 2)) {
        $_ = 'a';   print $x,"\n";    # prints 1a4, as above
        $x = 'abcdefg';
        print $_,"\n";                # prints f
    }

    o[W 5.10 O Perl ł́A񍶕Ӓlgꍇ̌ʂ `łB
    5.16 Oł́ÃItZbǧʂ͖`łB

=item * Sjis::index

    $index = Sjis::index($string,$substring,$offset);
    $index = Sjis::index($string,$substring);

    Sjis::index ́AShiftJIS  $string ̒Ɋ܂܂A1 ShiftJIS 
     $substring T܂B$string ̒ŁA$substring ŏɏoʒu
    PʂŐĕԂ܂B$offset w肳ĂꍇA$string ̐擪 $offset
    ̕XLbvʒuA$substring Tn߂܂Bʒu 0 x[XƂ
    Đ܂B$substring Ȃ΁ASjis::index Tu[`̓x[X
    1 l -1 Ԃ܂BSjis::index gāAŜ𒲂ׂɂ́A
    悤ɂ܂B

    $pos = -1;
    while (($pos = Sjis::index($string, $lookfor, $pos)) > -1) {
        print "Found at $pos\n";
        $pos++;
    }

=item * Sjis::rindex

    $rindex = Sjis::rindex($string,$substring,$offset);
    $rindex = Sjis::rindex($string,$substring);

    Sjis::rindex  Sjis::index ƎĂ܂AShiftJIS  $string ̒ŁA
     $substring Ōɏoʒu𕶎PʂŐĕԂ܂(܂
    reverse Sjis::index ł)B$substring Ȃ΁A-1 Ԃ܂B
    $offset ɂāAlƂĕԂƂAłËʒuw肷邱
    ł܂BSjis::rindex gāAŜ𖖔擪ɌĒׂ
    ́Â悤ɂ܂B

    $pos = Sjis::length($string);
    while (($pos = Sjis::rindex($string, $lookfor, $pos)) >= 0) {
        print "Found at $pos\n";
        $pos--;
    }

=item * Sjis::eval

    $eval = Sjis::eval { block };
    $eval = Sjis::eval $expr;
    $eval = Sjis::eval;

    JPerl ɂẮASjis::eval L[[h́AƗĂ܂A֘Â2
    ̖ړIɎgpĂ܂B2̖ړIɍ킹āA2̌` Sjis::eval
    { block }  Sjis::eval $expr pӂĂ܂B1Ԗڂ̌` Sjis::eval
    { block } ́Â܂܂ł͒vIł悤ȎsO(G[)gbv
    ߂̂̂ŁAC++  Java  "tryubN" ɎĂ܂B2Ԗڂ̌`
    Sjis::eval $expr ́AsɃR[hRpCĎsƂƂɁA1Ԗڂ
    `Ɠ悤ɁAOgbv܂BASjis::eval $expr 
    ق Sjis::eval { block } ȂsxȂ܂BȂȂA
    Sjis::eval $expr ́A񕶎p[XȂ΂ȂȂłB̈ŁA
    Sjis::eval $expr ̂قėpȂ܂Bǂ̌`gɂA
    JPerl ɂẮAׂĂ̗Oɂ Sjis::eval 𗘗p邱Ƃ]܂
    łB

    ǂ̌` Sjis::eval łATu[`Ɠ悤ɁAŌɕ]
    l Sjis::eval ̒lƂĕԂ܂B܂lɁAreturn ZqgƂ
    āASjis::eval ̓rlԂƂł܂BSjis::eval ̖߂l
    鎮́ASjis::eval ̂̃ReLXgɉāAReLXgAXJ[
    ReLXgA܂̓XgReLXgŕ]܂B]sReL
    Xgm@ɂẮAwantarray QƂĂB

    gbv\ȃG[(die ZqŔG[܂)ƁA
    Sjis::eval  underf ԂAϐ $@ ɃG[bZ[W(܂̓IuWFNg)
    Zbg܂BG[Ȃ΁A$@ 󕶎ɂȂ邱Ƃۏ؂Ă
    ܂BASjis::eval ̌ $@ ̒l𒲂ׂ΁AG[̗Lmɔ
    邱Ƃł܂Bۂɂ́Â悤ȒPȃu[l̃eXgŏ\ł:

        Sjis::eval { ... }; # sG[gbv
        if ($@) { ... }     # G[s

    (Perl 5.16 ȑOł́AoOɂāAXgReLXgō\G[̎ɂ undef
    ԂĂ܂AsG[̎ɂ͕ԂĂ܂ł)B

    Sjis::eval { block } `́ARpCɍ\`FbNs߂ɁAɌ
    ǂȂ܂B(x Sjis::eval $expr `ɊĂĺA̓_ɂ
    Ă邱Ƃ悤łB) { block } ̃R[h́ÃR[hƓ
    RpĈŁǍ` Sjis::eval ł͍\G[gbv邱Ƃ
    ł܂B

    Sjis::eval $expr `́AsɃR[hp[X̂ŁA\G[gbv
    邱Ƃ\łB(p[XɎsƁAɂăG[bZ[W $@ 
    Zbg܂B) $expr ȗƁA$_ ]܂B

    \G[Ȃ΁A $expr ̒lA JPerl XNvĝ悤ɂĎs
    ܂B̂ƂR[h́A̎_ JPerl XNvg̃ReLXgŎs
    ܂BASjis::eval ŎsR[h́A͂ރXR[ṽL
    VJϐ邱ƂłA(Sjis::eval ̒ōs)񃍁[Jȕϐւ̑A
    Tu[`tH[}bg̒`́ASjis::eval ILłB
    Sjis::eval ̃R[h̓ubNƂĈ̂ŁASjis::eval Ő錾[J
    ȃXR[vϐ́ASjis::eval I܂ŗLłB(localmyQƂ
    ƁB)ubNɒuꂽR[h̏ꍇƓlɁAԍŌ̃Z~R͏ȂĂ
    \܂B

    Sjis::eval ͈ȉ̂悤ɃGXP[v܂:

    -------------------------------------------------
    O                  
    -------------------------------------------------
    Sjis::eval { block }    eval { block }
    Sjis::eval $expr        eval Sjis::escape $expr
    Sjis::eval              eval Sjis::escape
    -------------------------------------------------

    Sjis::eval ƂTu[`͎݂͑܂B݂ĂƂƁAmy
    Ő錾ꂽϐVONH[gň͂݁ASjis::eval ̃p[^ɂƂ
    邩łBSjis::escape  JPerl XNvg Perl XNvgɃGXP[v
    Tu[`łB

    Ɏ̂͊ȒP JPerl VF̗łBJPerl ̃R[h͂悤Ƀ[U
    ɑ΂ăvvg\āA͂ꂽRpCĂsāA
    G[\܂:

        #!/usr/bin/perl
        # jperlshell.pl - ȒP JPerl VF
        use Sjis;
        print "\nEnter some JPerl code: ";
        while (<STDIN>) {
            Sjis::eval;
            print $@;
            print "\nEnter some more JPerl code: ";
        }

    ̃XNvg rename.pl ́AJPerl ̎Ƃė^ꂽwɊÂāAʂ
    t@Cl[܂:

        #!/usr/bin/perl
        # rename.pl - t@C̖OύX
        use Sjis;
        $op = shift;
        for (@ARGV) {
            $was = $_;
            Sjis::eval $op;
            die if $@;
            # ̍s̓XNvg rename.pl ł͂ȂA
            # gݍ݊֐ rename Ăяo
            if ($was ne $_) {
                print STDERR "rename $was --> $_\n";
                rename($was,$_);
            }
        }

    ̃XNvǵAȉ̂悤ɂĎgp܂:

        C:\WINDOWS> perl rename.pl 's/\.orig$//' *.orig
        C:\WINDOWS> perl rename.pl 'y/A-Z/a-z/ unless /^Make/' *
        C:\WINDOWS> perl rename.pl '$_ .= ".bad"' *.f

    Sjis::eval g΁Â܂܂ł͒vIɂȂ悤ȃG[gbv邱Ƃ
    ł̂ŁA@\(Ⴆ fork  symlink)Ă邩ǂmF
    ̂ɕ֗łB

    Sjis::eval { block } `ł̓RpCɕ@`FbNŝŁAׂ
    @G[(Sjis::eval $expr `)ɔ܂BāAΏ
    ƂȂR[hsςŁASjis::eval $expr  Sjis::eval { block } ̂ǂ
    ̖ړIɓKĂꍇɂ́ASjis::eval { block } gƂ]܂܂B
    Ⴆ΁A̗Ă:

        # 0 ɂ鏜ZvIłȂ悤ɂ
        Sjis::eval { $answer = $a / $b; };
        warn $@ if $@;

        # ƂAsꍇɂ͌
        Sjis::eval '$answer = $a / $b';
        warn $@ if $@;

        # RpC̕@G[(gbvȂ)
        Sjis::eval { $answer = }; # 

        # s̕@G[
        Sjis::eval '$answer =';   # G[bZ[W $@ ɃZbg

    ŁARpC邽߂ɂ́A{ block } ̃R[h͐ JPerl R[
    hłȂ΂Ȃ܂B$expr ɓĂR[h͎s܂Ń`FbNȂ
    ̂ŁAsɂȂȂ΃G[͔܂B

    Sjis::eval { block } `Cu̗Oߑ邽߂ɎgƂɂ͖肪
    ܂B݂ __DIE__ tbN̏Ԃ͂قڊmɉĂƂRŁA[
    U[̃R[hݒ肵 __DIE__ tbNsȂ܂B̖ړI
    ɂ͈ȉ̗̂悤ɁAlocal $SIG{__DIE__} \g܂B

    # a private exception trap for divide-by-zero
    Sjis::eval { local $SIG{'__DIE__'}; $answer = $a / $b; };
    warn $@ if $@;

    ͓ɕ֗ł; ^ꂽ __DIE__ tbN die xĂяoƂ
    łAɂăG[bZ[Wςʂ܂:

    # __DIE__ hooks may modify error messages
    {
        local $SIG{'__DIE__'} =
            sub { (my $x = $_[0]) =~ s/foo/bar/g; die $x };
        Sjis::eval { die "foo lives here" };
        print $@ if $@; # prints "bar lives here"
    }

    ̗͋ꂽł邽߁A̒IłȂU镑͏̃[X
    ͏C邩܂B

    Sjis::eval ł́Aȉ̂悤ȏꍇɁAׂ邩ɓɒӂĂƂ
    Kvł:

    Sjis::eval $x;        # CASE 1
    Sjis::eval "$x";      # CASE 2

    Sjis::eval '$x';      # CASE 3
    Sjis::eval { $x };    # CASE 4

    Sjis::eval "\$$x++";  # CASE 5
    $$x++;                # CASE 6

    L CASE 1  CASE 2 ͓̓ŁAϐ $x  R[hs܂B(
    ACASE 2 ł́AKv̂Ȃ_uNH[gɂāAǂސlN邩
    邱Ƃł傤(N܂)B)l CASE 3  CASE 4 ̓A
    $x ̒lԂȊOɉȂ $x ƂR[hs܂(Ɍڂ̖
    ŁACASE 4 D܂܂AsłȂRpCɃRpCƂ
    _܂)BCASE 5 ̏ꍇ́Aʏ_uNH[ggp܂B̏󋵂
    ΁ACASE 6 ̂悤ɁAPɃV{bNt@XgΗǂł傤B

    Perl 5.14 Oł́A$@ ւ̑̓[Jꂽϐ̕ȂOɋN
    ŁAÂo[WŎsꍇ́ASĂł͂Ȃꕔ̃G[}XN
    ꍇɂ͈ꎞϐKvł:

    # alter $@ on nefarious repugnancy only
    {
        my $e;
        {
            local $@; # protect existing $@
            Sjis::eval { test_repugnancy() };
            # $@ =~ /nefarious/ and die $@; # Perl 5.14 and higher only
            $@ =~ /nefarious/ and $e = $@;
        }
        die $e if defined $e
    }

    Sjis::eval { block } ̃ubN̓[vƂ݂͂ȂȂ̂ŁA[v䕶
    nextAlastAredo gĔoĎs肷邱Ƃ͂ł܂B

=item * t@COrO

    @glob = glob($expr);
    $glob = glob($expr);
    @glob = glob;
    $glob = glob;
    @glob = <*>;
    $glob = <*>;

    ̉Zq Esjis::glob ɂĎĂ܂BEsjis::glob ̏ڍׂ͈ȉ
    ʂłB

    @glob = Esjis::glob($string);
    @glob = Esjis::glob_;

    ̃Tu[`́A$string̒lɑ΂āADOSVFƓ悤ȃt@CWJ
    sēꂽʂԂ܂B$string ȗꂽƂ͑ $_ g
    ܂B̃Tu[` Sjis\tgEFA <*>  glob Zq
    ĂTu[`łBMSWin32ɂ $string  chr(0x5c) ŏIĂꍇ
    ł삵܂B

    g₷邽߂ Esjis::glob ́AUNIXł͂ȂADOS̓WJs悤ɂȂ
    Ă܂BAX^XN("*")́ACӂ̕Cӌ(0ł悢)ׂ̂Ƀ}b`
    ܂BNGX`L("?")́ACӂ̕1܂0Ƀ}b`܂BeB
    f("~")̓z[fBNgɓWJ܂BႦ΁A"~/.*rc" ݂͌̃[U
    "rc" t@CׂĂɃ}b`邵A"~jane/Mail/*" Janẽ[t@Cׂ
    Ƀ}b`܂B

    ASCIỈp̑啶Ə͋ʂꂸÂƂĈ܂BobNXb
    VƃXbV͂ǂfBNgZp[^ƂĈ܂B_uNH[g
    ̒ŃobNXbV1(\)\킷߂ɂ2 \A(܂ \\ )Lq
    Kv܂B

    󔒕܂މ\̂t@COuꍇɂ́A$string_u
    NH[gň͂ޕKv܂BȂȂAEsjis::glob ́A󔒕ʈĕ
    ̃p^[̋؂(Ⴆ<*.c *.h>)Ɖ߂Ă܂łB
    Ⴆ΁A"e" ̌ɋ󔒕Ǎ "f" t@C̃OrOs
    ɂ͈ȉ̂悤ɋLq܂B

    @spacies = <"*e f*">;
    @spacies = Esjis::glob('"*e f*"');
    @spacies = Esjis::glob(q("*e f*"));

    ϐ𗘗pꍇ͈ȉ̂悤ɂ܂B

    @spacies = Esjis::glob("'*${var}e f*'");
    @spacies = Esjis::glob(qq("*${var}e f*"));

    XNvgDOSOSŎŝł΁A

    # ΃pXŎ擾ꍇ
    @relpath_file = split(/\n/,`dir /b wildcard\\here*.txt 2>NUL`);

    # ΃pXŎ擾ꍇ
    @abspath_file = split(/\n/,`dir /s /b wildcard\\here*.txt 2>NUL`);

    ƋLqĂ悢ł傤B

=back

=head1 oCgẘ֐

=over 2

=item * CORE::chop

    $byte = CORE::chop($string);
    $byte = CORE::chop(@list);
    $byte = CORE::chop;

    ϐ邢̓oCgϐ̍Ō̃oCg؂藎ƂÃoCglƂ
    Ԃ܂BCORE::chop Zq́Aɓ̓R[h̖s菜̂
    pAuZqg(s/\n$//)IłB肽Ƃꂾ
    Ȃ΁Achomp gقSłBȂȂACORE::chop ͖ɂoCg
    𖳏Ŏ菜̂ɑ΂āAchomp ͎菜̂IŎ菜łB

    e CORE::chop 邱Ƃ͂ł܂ --- CORE::chop ł͕̂ϐ
    B

    Ƃĕϐ̃Xg @list ^ƁAXg̊e̍Ō̃oCg؂
    Ƃ܂:

    @lines = `cat myfile`;
    CORE::chop @lines;

    ܂߁AӒlȂ΂ǂȂ̂ł CORE::chop 邱Ƃł܂:

    CORE::chop($cwd = `pwd`);
    CORE::chop($answer = <STDIN>);

    2śA̗Ƃ͈܂:

    $answer = CORE::chop($tmp = <STDIN>); # 

    ̃R[hł́ACORE::chop ́A($tmpɓĂ)cꂽł͂ȂA؂
    ƂoCgԂ̂ŁA$answer ɂ͉sZbgĂ܂܂BӐ}
    ʂ𓾂邽߂̕@1́Asubstr gƂł:

    $answer = substr <STDIN>, 0, -1;

    Â悤ɏ̂ʂł:

    CORE::chop($answer = <STDIN>);

    łʓIȃP[Xł́Asubstr gāACORE::chop 邱Ƃł܂:

    $last_byte = CORE::chop($var);
    $last_byte = substr($var, -1, 1, ""); # 

    炪ł邱Ƃ𗝉Ă܂΁A܂Ƃ߂ CORE::chop sƂł
    ܂B2ȏ̃oCg܂Ƃ߂Đ؂藎Ƃɂ́Asubstr ӒlƂĎgA
    󕶎܂B̃R[h $caravan ̍Ō5oCg菜܂:

    substr($caravan, -5) = "";

    ł substr ɕ̒l^邱ƂɂāA(擪ł͂Ȃ)̃I
    tZbgw肵Ă܂B폜oCgۑ΁A4 substr g
    5oCg CORE::chop ܂:

    $tail = substr($caravan, -5, 5, "");

    ȗƁAϐ $_ ΏۂƂȂ܂B

=item * CORE::ord

    $ord = CORE::ord($expr);

    CORE::ord($expr)  "use Sjis qw(ord);" ̋Lq̗LɊւ炸A $expr
    ̐擪̃oCglԂ܂B$expr ȗꂽꍇ $_ ΏۂƂȂ܂B
    ̊֐͏ɕȂ̒lԂ܂B

    t̒lKvł΁Aunpack('c',$expr) g܂B܂SẴoCgl
    XgƂĕKvł unpack('C*',$expr) Ɏg܂B

=item * CORE::reverse

    @reverse = CORE::reverse(@list);
    $reverse = CORE::reverse(@list);

    CORE::reverse(@list) ̓XgReLXgł @list ̗vftɕׂ
    XglԂ܂B

    XJ[ReLXgł "use Sjis qw(ord);" ̋Lq̗LɊւ炸A @list
    ׂ̂Ă̗vfAŁAoCgPʂŋtɂ̂Ԃ܂B

=item * CORE::getc

    $getc = CORE::getc(FILEHANDLE);
    $getc = CORE::getc($filehandle);
    $getc = CORE::getc;

    FILEHANDLE Ɍтꂽ̓t@CA1oCgǂŕԂ܂B
    end-of-file(t@C̏I) ɂȂA邢 I/O G[ꍇ
    ́Aundef Ԃ܂BFILEHANDLE ȗƁASTDIN ͂܂B

    ̊֐͏x̂́AL[{[h1oCg͂ۂɕ֗ł -- L[
    {[h͂obt@OȂɐݒł΂łB̊֐́AWI/OCu
    ɑ΂āAobt@OȂœ͂悤ɗv܂BcOȂƂɁAW
    I/OCúAIy[eBOVXeɑ΂ăobt@OȂŃL[{[h
    ͂s悤ɗv邽߂́AڐÂipӂ܂łɂ́AW
    Ă܂Bɂ́AXmb𓭂āAIy[eBOVXeɌŗL̂
    Kv܂BUnix ł́Â悤ɂ΂܂ł傤B

    if ($BSD_STYLE) {
        system "stty cbreak </dev/tty >/dev/tty 2>&1";
    }
    else {
        system "stty", "-icanon", "eol", "\001";
    }

    $key = CORE::getc;

    if ($BSD_STYLE) {
        system "stty -cbreak </dev/tty >/dev/tty 2>&1";
    }
    else {
        system "stty", "icanon", "eol", "^@"; # ASCII NUL
    }
    print "\n";

    ̃R[h́A[玟Ƀ^Cvꂽ1oCgϐ $key ɓ܂BȂ
    VXe stty vO cbreak IvVȂÃR[ĥA
    $BSD_STYLE ^̏ꍇ̃R[hgƗǂł傤BłȂ΁A$BSD_STYLE
    Ȕꍇ̃R[hg΂悢ł傤B

=item * CORE::index

    $index = CORE::index($string,$substring,$offset);
    $index = CORE::index($string,$substring);

    CORE::index ́AoCg $string ̒Ɋ܂܂A1̃oCg $substring
    T܂B$string ̒ŁA$substring ŏɏoʒuoCgPʂŐ
    Ԃ܂B$offset w肳ĂꍇA$string ̐擪 $offset oCgXLb
    vʒuA$substring Tn߂܂Bʒu 0 x[XɂĐ܂B
    $substring Ȃ΁ACORE::index ֐̓x[X 1 l -1
    Ԃ܂BCORE::index gāAoCgŜ𒲂ׂɂ́Â悤ɂ܂B

    $pos = -1;
    while (($pos = CORE::index($string, $lookfor, $pos)) > -1) {
        print "Found at $pos\n";
        $pos++;
    }

=item * CORE::rindex

    $rindex = CORE::rindex($string,$substring,$offset);
    $rindex = CORE::rindex($string,$substring);

    CORE::rindex  CORE::index ƎĂ܂AoCg $string ̒ŁAoCg
     $substring ŌɏoʒuoCgPʂŐĕԂ܂(܂
    reverse CORE::index ł)B$substring Ȃ΁A-1 Ԃ܂B
    $offset ɂāAlƂĕԂƂAłËʒuw肷邱
    ł܂BCORE::rindex gāAoCgŜ𖖔擪ɌĒׂ
    ɂ́Â悤ɂ܂B

    $pos = CORE::length($string);
    while (($pos = CORE::rindex($string, $lookfor, $pos)) >= 0) {
        print "Found at $pos\n";
        $pos--;
    }

=back

=head1 __Zq

    (... Ə) __Zq̓R[ĥ߂̃v[Xz_łBPerl ͂G
    [oƂȂp[X܂A__s悤ƂƁAUnimplemented
    ͂̕ƋɗO𔭐܂:

    sub unimplemented { ... }
    eval { unimplemented() };
    if ( $@ eq 'Unimplemented' ) {
        print "I found the yada yada!\n";
    }

    __͊Sȕ̑ɂ̂ݎg܂Bȉ̗̃__͓삵܂:

    { ... }
    sub foo { ... }
    ...;
    eval { ... };
    sub foo {
        my( $self ) = shift;
        ...;
    }
    do { my $n; ...; print 'Hurrah!' };

    ... ͔͈͉Zq("Range Operators" QƂĂ) 3 hbgłł̂ŁA
    傫ȕ̈ꕔ̎ƂĂ͎g܂Bȉ̗̃__͕@G[ɂȂ܂:

    print ...;
    open my($fh), '>', '/dev/passwd' or ...;
    if ( $condition && ... ) { print "Hello\n" };

    ƕƂ̈ႢɐłȂꍇ܂BႦ΁AubNƖnbV
    t@X̃RXgN^́APerl Ƀqg^钆ȂΓɌ
    B__ Perl  { ... } ubNƔfłȂꍇ͕@G[ƂȂ
    ܂B̏ꍇAł͂ȂƐ̂ŁA... ̓__Ƃ͔f܂:

    my @transformed = map { ... } @input; # syntax error

    { ... } ubNłāAnbVt@X̃RXgN^ł͂ȂƂ
    ߂ɃubN̒ ; g܂BŃ__͓삵܂:

    my @transformed = map {; ... } @input; # ; disambiguates
    my @transformed = map { ...; } @input; # ; disambiguates

=head1 bytes::* Tu[`̃AGXP[v

̃\tgEFAɂ bytes::* Tu[`̐擪 'bytes::' 菜܂B

  -----------------------------------------
  O               
  -----------------------------------------
  bytes::chr       chr       oCgw
  bytes::index     index     oCgw
  bytes::length    length    oCgw
  bytes::ord       ord       oCgw
  bytes::rindex    rindex    oCgw
  bytes::substr    substr    oCgw
  -----------------------------------------

=head1 vO}уW[

  -----------------------------------------------------------
  O                    
  -----------------------------------------------------------
  use strict;               use strict; no strict qw(refs);
  use 5.12.0;               use 5.12.0; no strict qw(refs);
  require utf8;             # require utf8;
  require bytes;            # require bytes;
  require charnames;        # require charnames;
  require I18N::Japanese;   # require I18N::Japanese;
  require I18N::Collate;    # require I18N::Collate;
  require I18N::JExt;       # require I18N::JExt;
  require File::DosGlob;    # require File::DosGlob;
  require Wild;             # require Wild;
  require Wildcard;         # require Wildcard;
  require Japanese;         # require Japanese;
  use utf8;                 # use utf8;
  use bytes;                # use bytes;
  use charnames;            # use charnames;
  use I18N::Japanese;       # use I18N::Japanese;
  use I18N::Collate;        # use I18N::Collate;
  use I18N::JExt;           # use I18N::JExt;
  use File::DosGlob;        # use File::DosGlob;
  use Wild;                 # use Wild;
  use Wildcard;             # use Wildcard;
  use Japanese;             # use Japanese;
  no utf8;                  # no utf8;
  no bytes;                 # no bytes;
  no charnames;             # no charnames;
  no I18N::Japanese;        # no I18N::Japanese;
  no I18N::Collate;         # no I18N::Collate;
  no I18N::JExt;            # no I18N::JExt;
  no File::DosGlob;         # no File::DosGlob;
  no Wild;                  # no Wild;
  no Wildcard;              # no Wildcard;
  no Japanese;              # no Japanese;
  -----------------------------------------------------------

  utf8 vO}Abytes vO}̓RgAEg܂Bt@CŒ񋟂
  Tu[`̑Ƃ Esjis.pm _~[Tu[`񋟂܂B

=over 2

=item * _~[̃Tu[` utf8::upgrade

  $num_octets = utf8::upgrade($string);

  $string ̃INebgԂ܂B

=item * _~[̃Tu[` utf8::downgrade

  $success = utf8::downgrade($string[, FAIL_OK]);

  ̃Tu[`͏ɐ^̒lԂ܂B

=item * _~[̃Tu[` utf8::encode

  utf8::encode($string);

  ̃Tu[`͉Ԃ܂B

=item * _~[̃Tu[` utf8::decode

  $success = utf8::decode($string);

  ̃Tu[`͏ɐ^̒lԂ܂B

=item * _~[̃Tu[` utf8::is_utf8

  $flag = utf8::is_utf8(STRING);

  ̃Tu[`͏ɋU̒lԂ܂B

=item * _~[̃Tu[` utf8::valid

  $flag = utf8::valid(STRING);

  ̃Tu[`͏ɐ^̒lԂ܂B

=item * _~[̃Tu[` bytes::chr

  oCgw̃Tu[` chr ƂĎĂ܂B

=item * _~[̃Tu[` bytes::index

  oCgw̃Tu[` index ƂĎĂ܂B

=item * _~[̃Tu[` bytes::length

  oCgw̃Tu[` length ƂĎĂ܂B

=item * _~[̃Tu[` bytes::ord

  oCgw̃Tu[` ord ƂĎĂ܂B

=item * _~[̃Tu[` bytes::rindex

  oCgw̃Tu[` rindex ƂĎĂ܂B

=item * _~[̃Tu[` bytes::substr

  oCgw̃Tu[` substr ƂĎĂ܂B

=back

=head1 Sjis\tgEFÃ}`oCgAJ[O

=over 2

=item * oCgƕ(CJKV؉z񏈗)

VtgJIŜ悤ȃ}`oCgƂɁu̍폜vȗ}vu
vK؂ɍs߂ɂ́A11oCgŕ\ƂŒϔOjȂ΂Ȃ
܂B

̂Ƃɂ

  CJKV؉z񏈗(ISBN 4-87311-108-0)
  http://www.oreilly.co.jp/books/4873111080/
  
  P.439 9.6 oCgƕ
    9.6.1 ̍폜
    9.6.2 ̑}
    9.6.3 ̌

ɏڂĂ܂B
܂ Perl vO~Oŉ邽߂̕@

  t^W Perl̃vO
    W.8 CJKṼev[g
      W.8.5 VtgJIS 
    W.9 }`oCgAJ[O
    W.10 }`oCg

ɌfڂĂ܂B

=item * OiɂVȉۑ

L̃}`oCgAJ[Õev[gpƁAVtgJIS̕𐳋K\
ŏł悤ɂȂ܂ȂOiɂĐVȕǂɓ˂܂B

  wcs_abe̕
  Perl t@CCǂ݌̐K\ɂ
  http://okwave.jp/qa/q6674287.html
  
  Perlňȉ̒ʂAhtmlt@CSēǂݍ񂾌ɐK\𓖂Ă̂łA܂
  ܂BkłAm̕Ⴂ܂狳Ē܂ł傤
  B܂Aɗǂ@܂狳ĒƍKłB
  PCwindows7, perl5.12łBɕs܂炲wEB
  
  -----
  #--test.html(͍̐s)
  000001 <dl>
  000002 <dt>aaa</dt>
  000003 <dd>12345</dd>
  000004 </dl>
  
  ij
  
  120001 <dl>
  120002 <dt>bbb</dt>
  120003 <dd>6789</dd>
  120004 </dl>
  
  #--test.pl
  open IN , "test.html";
  local $/ = undef;
  $data = <IN>;
  close IN;
  
  $data =~ s|<dt>bbb</dt>|<dt>ccc</dt>|;
  print "$data\n";
  -----
  
  t@C̎n߂̕Ɠ̂ɁA㔼ł͓܂B
  K\̑ΏۂƂđ傫ł傤EEEB
  
  $data =~ s|<dt>aaa</dt>|<dt>ccc</dt>|;
  ́A܂
  
  $data =~ s|<dt>bbb</dt>|<dt>ccc</dt>|;
  Ɠ܂B
  
  ǂ낵肢܂B
  
  ⑫
  L̎ł́A֘A͔ƎvċLڂȂłAhtmlt@C
  SjiseLXgŁASjis.pmgďsƂĂ܂B

̏ǏČŏ̃R[h

  # XNvg test2.pl
  for my $n (32767, 32768) {
      $_ = ('A' x $n) . 'B';
      if (/(\G(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC])*?)B/) {
          print "ok - ('A' x $n).'B' =~ /B/\n";
      }
      else {
          print "not ok - ('A' x $n).'B' =~ /B/\n";
      }
  }
  __END__

̂悤ɂȂAsʂ

  ok - ('A' x 32767).'B' =~ /B/
  not ok - ('A' x 32768).'B' =~ /B/

ƂȂ܂B'A'  32,767 'B' ͌Č̂ɁA32,768
'B' ͌ĂȂ̂łB

=item * Perl̐K\̗ʎwq̌E

̌ perl C^v^ɂ܂B

  ʎwq
  http://perldoc.jp/docs/perl/5.14.1/perlre.pod
  
  ȉ̕WIȗʎwqg܂:
    *           Match 0 or more times
    +           Match 1 or more times
    ?           Match 1 or 0 times
    {n}         Match exactly n times
    {n,}        Match at least n times
    {n,m}       Match at least n but not more than m times
  
  (O) "*" ʎwq {0,} ƁA"+" ʎwq {1,} ƁA "?" ʎwq {0,1} Ɠ
  łB n y m  perl rhƂɒ`̐菬Ȕ񕉐
  ܂B ͑̃vbgtH[ł 32766 ɂȂĂ܂B ۂ̐
  ͎̂悤ȃR[hsƐG[bZ[W 邱Ƃł܂:
  
    $_ **= $_ , / {$_} / for 2 .. 42;

=item * ǂzɂ

̌E@ƂāAAms񂪍lĂȉ̕@܂B

  2002-01-17: ɑ΂鐳K\
  http://homepage1.nifty.com/nomenclator/perl/shiftjis.htm#long
  
  # 񂾂}b`
  my $Apad = '(?:(?:\A|[\x00-\x80\xA0-\xDF])(?:[\x81-\x9F\xE0-\xFC]{2})*?)';
  my $str1 = ('' x 100000) . 'ACABC';
  $str1 =~ /$Apad([A-Z]+)/o;
  print "$1\n"; # "ABC" ƕ\B
  
  # O[o}b`
  my $Gpad = '(?:(?:\G|[\x00-\x80\xA0-\xDF])(?:[\x81-\x9F\xE0-\xFC]{2})*?)';
  my $str2 = '' x 100000 . 'ACABC'. '' x 100000 . 'XYZ';
  my @array = $str2 =~ /$Gpad([A-Z]+)/go;
  print "@array\n"; # "ABC XYZ" ƕ\B

\A  \G gĂ̂łA\G ͍ŏɎgƂ \A Ɠ悤ɋ@\
̂ŁAۂɂ \G ̕@ЂƂł悢ł傤B

  K\̃NH[g̉Zq
  http://perldoc.jp/docs/perl/5.16.1/perlop.pod#Regexp32Quote-Like32Operators
  
  \G assertion (\G AT[g)
  
  (O)ȑO /g }b`KpĂȂ^[Qbgɑ΂ /g Ȃ \G gƁA
  ̐擪Ƀ}b` \A AT[gĝ ƂɂȂ܂B(㗪)

=item * ƏcĂւ̑Ή

L̃y[Wɂ

  oCgAoCĝoCg [\x40-\x7E\x80\xA0-\xDF] ŏI
  AȂƂKȊԊuŁiɒBȂɁjo΁AG[ɂȂ炸ɏ
  邱Ƃł܂BimIȖł̂ŁASł͂܂Bj

ƂASoCg US-ASCII ō\Ăf[^̏ꍇ͂܂܂B
̂悤ȏꍇ̓AJ[O

  qr{\G.*?}s

ɂ邱ƂőΉ܂B

=item * ܂Ƃ߂

ȏ̑SĂlāAĂу}`oCgAJ[Olƈȉ̂悤ɂȂ܂B

  qr{\G(?(?=.{0,32766}\z)(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC])*?|(?(?=[\x00-\x80\xA0-\xDF\xFD-\xFF]+\z).*?|(?:.*?[\x00-\x80\xA0-\xDF\xFD-\xFF](?:[^\x00-\x80\xA0-\xDF\xFD-\xFF]{2})*?)))}oxms
  
  
  
  qr{\G  # \G AT[g \A AT[g˂
       (?(?=.{0,32766}\z)  # Ώە 32,766 INebgȉł
                         (?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC])*?  # ꂪ}`oCgAJ[OɎg
                                                                                    |  # 32,767 INebgȏŁAȂ
                                                                                     (?(?=[\x00-\x80\xA0-\xDF\xFD-\xFF]+\z)  # SoCgVOoCgR[hZbgō\ĂȂ
                                                                                                                           .*?  # ꂪAJ[OɎg
                                                                                                                              |  # ȊȌꍇ
                                                                                                                               (?:.*?[\x00-\x80\xA0-\xDF\xFD-\xFF](?:[^\x00-\x80\xA0-\xDF\xFD-\xFF]{2})*?)  # ꂪ}`oCgAJ[OɎg
                                                                                                                                                                                                          ))}oxms

MSWin32  ActivePerl ̃o[W 5.6 ȍ~(Perl5.10.0܂݂܂)A邢͂̑
 Perl ̃o[W 5.10.1 ȍ~̏ꍇɂ̃}`oCgAJ[Og܂B
ȊȌꍇ́A܂łǂ

  qr{\G(?:[\x81-\x9F\xE0-\xFC][\x00-\xFF]|[^\x81-\x9F\xE0-\xFC])*?}oxms

g܂B

=back

=head1 ϐ

 ̃\tgEFA͔r flock ֐gp܂Bt@Cǎ\ɂȂ܂
 邢͏݉\ɂȂ܂ŃvO̎s̓ubN܂B
 ϐ CHAR_NONBLOCK `邱ƂŃubNȂ悤ɂ邱Ƃł
 B

 :

   SET CHAR_NONBLOCK=1

 (l '1' ͈ӖȂ̂ŉł\܂)

=head1 MacJPerl ̋@\

 } Web ̏Qlɂ MacOS ɑΉĂ݂܂B@Ȃ߂ɃeXg
 łĂ܂B񍐁AoO񍐓ƂƂĂ肪łB
 
 sɂ͈ȉ̃\tgEFAKvłB
 1. MacPerl W[
 2. Mac::Files W[
 3. ToolServer
 4. MPW(Macintosh Programmer's Workshop)

=head1 oOƐƌ݊

̃\tgEFÁA̔\͂sāAeXgďƍ܂BłĂA
̐K\܂ރ\tgEFÁAx̃oOƂ܂ʂ邱Ƃł܂B
āAȂ̃XNvgł͂ȂāASjis\tgEFÃoO̂ȂA
ŏ̃eXgR[hɐ؂l߂ŁA҂܂ŕ񍐂ĒƏ܂B

邢͂ƗLpȃc[ɂ邽߂̂悢ACfBAȂAFƋLĒ
Ƃ肪łB

=over 2

=item * format

    IWi Perl Ƌ@\ł(ShiftJIS ɑΉĂ܂)B

=item * K\̃NCX^

    K\̃NCX^ (?s)  (?i) ͓ʁAȂł傤B
    NCX^ (?s)  /s Cq .(hbg)  \N őpł܂B
    NCX^ (?i)  \F ` \E ōHvċLqȂƂ܂B

=item * chdir

    perl5.005 łΏ chdir() 𐳏Ɏsł܂B

    DOS̃VXe($^O ̒l MSWin32, NetWare, symbian, dos ̂ꂩ
    ꍇ)́Aȉ̐܂B

    perl5.006 ܂ perl5.00800 ̏ꍇŕR[h(0x5C)ŏIfBNg
    w肵Ďsɂ jacode.pl CuKvłB

    perl5.008001ȍ~, perl5.010, perl5.012, perl5.014, perl5.016, perl5.018,
    perl5.020 ɂĕR[h(0x5C)ŏIfBNgw肵ĎsƂA
    COMMAND.COM 邢 cmd.exe ɂ 8dot3name `̒ZO擾ł
    ꍇ chdir() ܂BAchdir() ̃JgfBNg
    ŏĨTufBNg 8dot3name `̒ZOɂȂ܂B

    QlN
    Bug #81839
    chdir does not work with chr(0x5C) at end of path
    http://bugs.activestate.com/show_bug.cgi?id=81839

=item * ӒlƂĂ Sjis::substr

    o[W 5.14  Perl ̏ꍇASjis::substr  CORE::substr Ƃ͈قȂA
    ӒlƂĈƂł܂B̈ꕔύXꍇ́ASjis::substr
    4Ԗڂ̈ƂĒu̕w肵܂B
    
    Sjis::substr($string, 13, 4, "JPerl");

=item * ϐ $`  $& gƂ /( K\ŜLv` )/ Kv܂

    ȂȂ΁Aȉ̂悤ɕϊA$1 𗘗p邽߂łB
 
    -------------------------------------------------------------------------------------------
    O                         se
    -------------------------------------------------------------------------------------------
    $`              Esjis::PREMATCH()    CORE::substr($&,0,CORE::length($&)-CORE::length($1))
    ${`}            Esjis::PREMATCH()    CORE::substr($&,0,CORE::length($&)-CORE::length($1))
    $PREMATCH       Esjis::PREMATCH()    CORE::substr($&,0,CORE::length($&)-CORE::length($1))
    ${^PREMATCH}    Esjis::PREMATCH()    CORE::substr($&,0,CORE::length($&)-CORE::length($1))
    $&              Esjis::MATCH()       $1
    ${&}            Esjis::MATCH()       $1
    $MATCH          Esjis::MATCH()       $1
    ${^MATCH}       Esjis::MATCH()       $1
    $'              $'                   $'
    ${'}            ${'}                 $'
    $POSTMATCH      Esjis::POSTMATCH()   $'
    ${^POSTMATCH}   Esjis::POSTMATCH()   $'
    -------------------------------------------------------------------------------------------

=item * K\Kp镶̒̏

    Oq̂ƂAGXP[v̐K\ɂ̓}`oCgAJ[Ô
    ߂̋Lq ${Esjis::anchor} ǉ܂A̒Ɋ܂܂ \G ̐
    ܂BMSWin32łActivePerl5.6ȍ~(5.10.0܂݂܂)A邢͑Perl
    ꍇ5.10.1ȍ~łȂ΁A32,767oCg𒴂ʒuŃ}b`
    Ƃł܂B
 
    QlN
    
    In 5.10.0, the * quantifier in patterns was sometimes treated as {0,32767}
    http://perldoc.perl.org/perl5101delta.html
    
    [perl #116379] \G can't treat over 32767 octet
    http://www.nntp.perl.org/group/perl.perl5.porters/2013/01/msg197320.html
    
    perlre - Perl regular expressions
    http://perldoc.perl.org/perlre.html
    
    perlre length limit
    http://stackoverflow.com/questions/4592467/perlre-length-limit

=item * WJƋɂȂ鐳K\̕ϐ

    ̃eƂ͈قȂAK\ɓWJꂽϐ̒l󕶎ł
    ĂAOɐK\͎g܂B

=item * ??, m?? ̐

    ?? ܂ m?? ̓Ń}`oCgɑ΂ {n,m} {n,} {n} * + Ȃǂ̗ʎw
    qtꍇ́A̕ ( ) ň͂ŋLqKv܂B̌ʁA
    $1,$2,$3,... ͂Ă܂߁A̋LqCKv܂B
    Ȃ ?? ܂ m?? ̓f~^ ? Ȃ̂ŁA(?: ) ʎwq ? {n,m}? {n,}?
    {n}? ͋Lq邱Ƃł܂B

=item * ǂ݌

    ǂ݌(Ⴆ (?<=[A-Z]))O̓oCg̑oCgɌă}b`
    邱Ƃɂ͑ΏĂ܂B
    Ⴆ΁A'ACE' =~ /(?<=[A-Z])([ACE])/ sƃ}b` $1  'C'
    ɂȂ܂A͐܂B

=item * K\̏Cq /a /d /l /u

    ̃\tgEFÃRZvǵAЂƂ̃XNvg̃e␳K\
    ̃eɕ̕𗘗pȂ悤ɂ邱ƂłB]ďCq
    /a /d /l /u T|[g܂B
    \d ͐̂ [0-9] Ӗ܂B

=item * Ot

    Ⴆ΁A\N{GREEK SMALL LETTER EPSILON}A\N{greek:epsilon}A\N{epsilon} ̂悤
    ȖOt͗pł܂B

=item * K\Unicode

    K\Unicode͗p邱Ƃł܂BPerl5.18Œǉꂽ (?[])
    \pł܂B܂̂Ƃ낻T|[g\͂܂B

=item *  ${^WIN32_SLOPPY_STAT} ̒l

    Microsoft Windows  chr(0x5c) ŏIpXw肵ăt@CeXg(Zq)A
    邢 lstat()Astat() sƁA${^WIN32_SLOPPY_STAT} ɐ^̒lݒ肳
    Ăꍇł̃t@CI[vĒׂ܂B

=item * 񂨂ѐK\̃f~^

    qq//, q//, qw//, qx//, qr//, m//, s///, tr///, y/// ̃f~^ƂăChL
    N^gp邱Ƃ͂ł܂B

=item * K\ \b{...}

    Perl 5.22 œꂽAȉ̐K\ \b{..} ̓T|[gĂ܂B

    \b{gcb} or \b{g}   Unicode "Grapheme Cluster Boundary"
    \b{sb}             Unicode "Sentence Boundary"
    \b{wb}             Unicode "Word Boundary"
    \B{gcb} or \B{g}   Unicode "Grapheme Cluster Boundary" doesn't match
    \B{sb}             Unicode "Sentence Boundary" doesn't match
    \B{wb}             Unicode "Word Boundary" doesn't match

=back

=head1 

̃vWFNg t  ina@cpan.org ɂĎn܂܂B

=head1 쌠

̃\tgEFA̓t[\tgEFAłBȂ Perl ƓCZX
̌ōĔzzyѕύXsƂo܂Bڂ perlartistic QƂ
B

̃\tgEFA͗Lpł邱ƂĔЕz܂A*S̖ۏ* 
łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂
ߑS݂܂B

=head1 VtgJISR[hƂ({񏈗)

VtgJIŚA}CN\tgЂɂJꂽA{̃Rs[^ōł悭
p镄łBVtgJIŚuMS(Microsoft)vA܂́uSJIS
(ShiftJIS̗)vƂĂ΂Ă܂B

ē{̃Rs[^[U͔pЉgȂ߁A]Ƃ̌݊
ێړIŃVtgJISJ܂B

VtgJISɂẮA16i 0x81`0x9F ܂ 0xE0`0xEF ͈̔͂INebg
ɂ12INebg[hJn܂BẴINebǵAn܂
2INebg̑1INebgƂď܂B(2)INebǵA16i
0x40`0x7E ܂ 0x80`0xFC ͈̔͂lłȂ΂Ȃ܂B1INebg
͈͂͊gASCIIZbgA܂ŏʃrbgIɂȂ8rbgZbg͈̔
ɊSɎ܂Ă邱ƂɒڂĂB܂VtgJIŚApЉASCII/JIS
[}T|[gĂ܂B

ꕔ̃VtgJISdl(Ƀ[Jdl)ł́A[U`̃R[ḧAꍇɂ
͔pЉ󔒕̃R[hʒu`Ă܂B{iIȏ]ނ̂
΁Â悤ȃR[ḧR[hʒu͕ssłBƂ̂Â悤ȕ́A
ʂ̓{ꕄ(܂JISEUC)̃R[hʒuɕϊłȂ悤ɕĂ
܂łB

=head1 EBLyfBAɂuShift_JISv̒`

Shift_JIS (2011.10.27 00:00:00 JST). In Wikipedia: The Free Encyclopedia.
Retrieved from
http://ja.wikipedia.org/wiki/Shift_JIS

oT: t[SȎTwEBLyfBA(Wikipedia)x

Shift_JISiVtgWXj́Aݑ̃p\R̃t@Cœ{\
ɎgĂ镶R[hłBĂ̓x_[ɂƎg܂ޕR[h
Qɑ΂BȖ̂łA݂͕WJIS X 0208̕1ŋK肳
ĂBuShift_JISvIANAɂo^łB

Shift_JIS̒a

1980NAp\Rp16rbgCPU̕y܂āA≼\\ȃn[
hEFAp\RXƔꂽB̂߁A{\ł镶
͍ĂiShift_JISuVtgJISR[hvƌĂŕ
WiR[hj̖ʂ݂̂lc_邪Ał͕̖ʂ
œ_𓖂ĂjB

Shift_JIS̐݌v҂́AsĂ悭pĂJIS C 6220
i݂JIS X 0201j8rbgiȉupEpJivjƁAJIS C 6226
i݂JIS X 0208Aȉuvj̗W\悤ƂB܂At@
C̑傫⏈Ԃ̒Zk}邽߁AGXP[vV[PXȂō݉\
邱Ƃ}B

JIS C 6220JIS C 62262͂ƂɁAISO 2022ŕW؂ւėp
݌vBISO 2022ɊÂł́ApApJiA͂
A8rbgԂ̒GL/GRƂ̈1i2jgƂ
\łBpƊ2GXP[vV[PXȂō݂ȂA
pGLAGRɊ蓖Ă@BEUC-JṔA悻̂悤Ɏ
ĂB

Ap\Rł͂łɁAJIS X 02018rbgA܂GLɉpAGR1o
CgJ^JiipJ^Jij蓖ĂyĂBp1oCgJ
^Ji2𓮂Ƃ́ǍɂȂ邽ߔKvB
߁AISO 2022̘g̗̈Ɋ݂邱Ƃ͍B

1982NA̕ʒu𕡎GɈړiVtgjAԂ̌Ԃɉ
Shift JISaB邽߂ɂ́A1oCgڂƂāAISO 2022
ɂGRiA1(16)-FE(16)j̈31cĂgp̈ɉAISO 2022
ĔgpCRi80(16)-9F(16)j̈gp邱ƂƂBAGLi21(16)
-7E(16)j̈ɂẮAJIS X 0201̋Lɓ镔͋ɗ͔B2oC
gڂɂ́AISO 2022Ƃ͈قȂApEpJiɎgpς݂̗̈܂ށAGLA
CRAGRɂë̂قڑSĂgKvB

}CN\tgi{@lj̌Ð식ɂƁAShift_JIS̐ɂ́AAX
L[A}CN\tgiājAOHd@A}CN\tgEFAEA\VGCcAf
W^T[`iājւAɃAXL[̎RǑSƂȂč쐬
̂ƂBɑ΂ِƂāAsẅF́A}CN\
tgEFAEA\VGCcƎOHd@݂̂̋JƎ咣ĂAR{l
̔ɂ͎P񂷂锭ĂB܂ÂLife with UNIX
󏑁iISBN 4-7561-0783-4j́uUNIXlTv|ŉMip. 45jŁA[
OɁuMSR[h̍҂̈lvƂЉĂB

Shift_JIS̕W

Shift_JIŚAWƂ̗̕܂ތ̖
邽߂̋ZpłB䂦AJIS X 0208̕W𗘗pĂ͂̂́A
ISO 2022̕̕j͈̔͂̊OɂB

݂ł́AJIS X 0208:1997̕1ɁAuVtg\vƂO
dl`ĂB́Aft@NgX^_[hƂȂĂZpɂ
͏oƂAƂWĂ܂ƂӐ}{HƕW
 (JISC) ɂĂ̂ƂłB

JIS X 0208̊gKiłJIS X 0213ł́A2000N̏łŕ1Ƃ
Shift_JISX0213߂ꂽB2004N10ǉɔāAShift_JIS-2004
Ɩ̂ύXꂽB

IANAłuShift_JISvƂO蓖ĂĂB

_ƌ_

_
1. SpƁAJIS X 0201Œ`锼pJi𓯈̃R[ȟn
   \łB
2. {ɂẮAMS-DOSœ{pR[hƂč̗pĈȗAp\
   RɂĈ|IȕyxȂ̕ɔׂăf[^
   \B

_
1. pJî߂̗̈mۂ֌WAR[hV[NGX_ԍ́uv
   ̋؂ł͂ȂӏŕfĂB̂߁AR[hԍZŋ߂ۂ
   ώGȏKvłB
2. 2oCgڂ80(16)(ASCIĨR[ḧ)B̂߁A̋؂
   ɎԂBt@Cd̐擪當R[h̔ꍇ͂悢
   A납画悤ƂƁAň̏ꍇA擪܂łǂȂƂȂ
   Ƃ邽߁AvO̍ɍHvKvɂȂB܂Ä̗Ɋ܂
   ꕔ̈̂̕߁A}`oCgEUC-JPAUTF-8ȂǂɔׁAvO
   ~ÖiQƁjB
3. JIS⏕\łȂB⏕̕Shift_JIS̃R[ho^
   ܂ȂB
4. WɂĂ͎x_JIS X 0208ŋK肳ĂȂ@ˑ̊g
   {Ă邱ƂAgɊւĂ̓f[^\ႢB

2oCgڂ5CɂȂ肤邱Ƃɂ

Shift_JISł́Au\vu\vȂǈꕔ̎2oCgڂɁA5C(16)iShift_JISł́
LAASCIIȂǂł̓obNXbVjgpĂB̃vO~O
 (CAPerlABourne ShellȂǑ) ł́A5C(16)GXP[vƂĂB
āA\[XR[h╶f[^̏ɂShift_JISz肵ĂȂv
O~Oł͖肪NB̖́A悤2oCgڂ͈̔͂5C(16)
܂Big5AGBKȂǂ̕R[hłB

܂A5C(16)ȊOɂĂގ̖肪邱ƂBƂ΁AUnix
MS-DOSȂǂ̃VF7C(16) (Shift_JISASCIIł̓o[eBJo[) ܂ޕ
i|A|A|A|A|A|A|Accjt@CɎgp悤ƂƁApCv
LƔFAɃt@C쐬ȂAǂݍ݂sǂɂȂ
邱ƂB

݂łAVOoCgR[hΉ̃\tgEFAShift_JISŎgp
ƁAsȂǂ̓t@C̏Ȃǂɂ΂΂̖肪܂ƂB
sA2oCgڂ5C(16)͑ɁuߕvƌĂ΂A̒
́u\vu\vu\vu\vȂǈʂɎgppx̍܂܂B

̖`Iȕ@ƂāA\[XR[hŜEUCR[hUTF-8Ȃǂ
ϊĂRpCs肷@iFPerl encodingv
O}jB邢́u\vu\\v̂悤ɁA2oCgڂ̒O(uvƏĂ
͌ŁÁuOvBłȂ΁AߕGXP[v邱Ƃ
łȂB)ɃGXP[v5C(16)LqAuߕv𕶎ƂĐF
@iFPerlSjis\tgEFAjB邢͕܂͕Ƃ
킸Ώەѓ\`𐔒l̔zƂĕϊsA舵ۂɕ
ɕĈ@iFPerl EncodeW[jB



u\ȂvƂ񂪂̌f\tgŁuȂvƕ
pɂɌB

   \         
  8d5c 82ed 82c8 82a2
  obNXbVɂ5cƁA
  8d   82ed 82c8 82a2
             

uvƂ̂ƂŃfR[hē͐̕ɖ߂B܂l
Ɂu|\Evu|EvɉB 

   |    \   E
  8c7c 945c 8a45
  obNXbVɂ5cƁA
  8c7c 94   8a45
   |       E

  \ 2oCgڂ5C(16)ꗗ  (16i) ǂ݁EӖ 

  \   815C _bV
  \   835C Љ́uv
  \   845C L̃EB
  \/? 875C Windowsł̓[}9
            MacłGB(MKoCg)
  \   895C 킳B
  \   8A5C C
  \   8B5C ނB\
  \   8C5C BlB
  \   8D5C ܂B\
  \   8E5C JCRB{\
  \   8F5C 10B
  \   905C AB\
  \   915C AЁBu]v̈ẂíjB\
  \   925C B\y
  \   935C ͂B\t
  \   945C ̂B\
  \   955C 킷AЂ傤B\
  \   965C ΂AڂB\
  \   975C 炩߁AB\
  \   985C 낭B\
  \   995C ƁABuevّ̈̎
  \   9A5C B\
  \   9B5C B\a(ua̔񏑊)
  \   9C5C B퐶́uv̐
  \   9D5C B\
  \   9E5C Ȃ̕ʑ
  \   9F5C AA傤B
  \   E05C 炤AB
  \   E15C ӂAقB
  \   E25C ƂAւB
  \   E35C AB
  \   E45C łAB\
  \   E55C BaC\X
  \   E65C G̋
  \   E75C ̂̌Î
  \   E85C ΁B\()B
  \   E95C ܂B\
  \   EA5C oB̖B
  x   ED5C B
  x   EE5C 傭B
  \   FA5C 킽AB
  \   FB5C B

R[hԂɂ镶

Shift_JIS2oCgR[h̋Ԃ́A1oCg81(16)-9F(16)ȂтE0(16)-
FC(16)A2oCg40(16)-7E(16)Ȃт80(16)-FC(16)łBāA
60~188=11280A1oCgR[h158iXy[X܂݁ADEL͐j
ł邽߁Av11438ƂȂB

ȂAShift_JIS-2004ł́A2oCg11233A1oCg158̂߁A
v11391gpĂB

Shift_JISɂuVtgvƂ

Shift JIŚuVtgvƂ́A256~256̕ʂ̒ŕ𕡎G"炷"ƂӖ
́uVtgvłB

ISO-2022-JP͎wV[PXŊƃAt@xbg؂ւ镄łB
܂AEUC-JP͕⏕ƔpJ^JiVOVtgňꎞIɐ؂ւĎg
łB̕ōsĂAeW̖ʂVtgR[
hɂĐ؂ւ鑀uVtgvƌĂ΂邪AShift_JIŚuVtgv͂
Ƃ͈قȂӖłB܂rbg炷irbgVtgjƂقȂB

Shift_JISƋ_ԍ

Shift_JIS̑Ώۂɂ镶ẂAJIS X 0208łB̕W
ɂ́A_ԍƂTO݂B́A94~94̕\̍sƗ̔ԍ̑g
łB

Shift_JISł́A8140(16)-FCFC(16)Ƃ悤ɁAJIS X 0208Ƃ͂܂R[
ȟnł邪AJIS X 0208vZɂό`̂ł邽߁A_ԍp
̃R[h|CgwƂBeɂẮAJIS X 02081`94
ƓłBA@ˑł́AVtgJIS̕ԂtA94
ɂ120܂łgĂ邩̂悤ɈƂB95ȏ́A
ISO/IEC 2022ɑJIS X 0208̍\ł݂͑Ȃ̂ŁA{͂B
x_Ǝ̔ȊTOłBȂAJIS X 0213̋Kïꕔł
Shift_JISX0213\ɂẮA1oCgF0(16)ȍ~2ʂ̕Ɋ蓖Ă
ASƂ悤ȑ݂Ȃԍ͓oꂵȂB

ux-sjisvƁuMS_Kanjiv

ux-sjisvƁuMS_Kanjiv͂ƂɁAHTMLhLǵucharsetv̎w
uShift_JISv̕ʖƂĎgƂoB

ux-sjisvIANAɁuShift_JISvƂOo^OɁANetscape Navigator
2.0ɂĎgĂGR[fBO̎wqłBꕔHTML\tg
ł̎wqgݍŎgĂB̂ߔF\ȃuEU邪A
uShift_JISvɏ邱Ƃ𐄏ĂB

uMS_KanjivIANAɂuShift_JISv̕ʖƂĊ蓖ĂĂB


=head1 ̃\tgEFAł "ShiftJIS"

̃\tgEFAł "ShiftJIS" ͏ĹuR[hԂɂ镶v
11438ׂĂ邱ƂڎwĂ܂B̂߂ɃASY2g
Ă܂B

* ASY 1

    INebg̕т當oƂA1INebgR[h2INebgR[h
    ̋ʂ͑1INebgR[ĥ݂ōs܂B2INebg͍l܂B

    1INebgR[h:
      0x00-0x80, 0xA0-0xDF, 0xFD-0xFF

    2INebgR[h:
      1INebg  0x81-0x9F, 0xE0-0xEF, 0xF0-0xFC
      2INebg  0x00-0xFF (ׂ)

    s1INebgR[h:
      0x81-0x9F, 0xE0-0xFC
      * ̍ŏIINebg2INebgR[h̑1INebgƓꍇ

ȉɃR[h\fڂ܂B

        1INebgR[h\

   0 1 2 3 4 5 6 7 8 9 A B C D E F 
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 0|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x00-0x80
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 1|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 2|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 3|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 4|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 5|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 6|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 7|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 8|*| | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 9| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 A|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0xA0-0xDF
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 B|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 C|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 D|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 E| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 F| | | | | | | | | | | | | |*|*|*| 0xFD-0xFF
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

                                 2INebgR[h\
            1INebg                                    2INebg


   0 1 2 3 4 5 6 7 8 9 A B C D E F                 0 1 2 3 4 5 6 7 8 9 A B C D E F 
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 0| | | | | | | | | | | | | | | | |              0|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x00-0xFF
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 1| | | | | | | | | | | | | | | | |              1|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 2| | | | | | | | | | | | | | | | |              2|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 3| | | | | | | | | | | | | | | | |              3|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 4| | | | | | | | | | | | | | | | |              4|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 5| | | | | | | | | | | | | | | | |              5|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 6| | | | | | | | | | | | | | | | |              6|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 7| | | | | | | | | | | | | | | | |              7|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 8| |*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x81-0x9F    8|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 9|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|              9|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 A| | | | | | | | | | | | | | | | |              A|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 B| | | | | | | | | | | | | | | | |              B|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 C| | | | | | | | | | | | | | | | |              C|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 D| | | | | | | | | | | | | | | | |              D|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 E|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0xE0-0xFC    E|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 F|*|*|*|*|*|*|*|*|*|*|*|*|*| | | |              F|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


̍ŏIINebg2INebgR[h̑1INebgƓꍇ

słĂꂽAIɍ폜邱Ƃ͂܂B
Ⴆ΁AEsjis::chop ͂̃INebgԂ܂B

    *s* 1INebgR[h

   0 1 2 3 4 5 6 7 8 9 A B C D E F 
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 0| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 1| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 2| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 3| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 4| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 5| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 6| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 7| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 8| |M|M|M|M|M|M|M|M|M|M|M|M|M|M|M| 0x81-0x9F
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 9|M|M|M|M|M|M|M|M|M|M|M|M|M|M|M|M|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 A| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 B| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 C| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 D| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 E|M|M|M|M|M|M|M|M|M|M|M|M|M|M|M|M|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 F|M|M|M|M|M|M|M|M|M|M|M|M|M| | | |  0xE0-0xFC
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


=head1 x_ SJIS R[hꗗ

http://home.m05.itscom.net/numa/cde/sjis-euc/sjis.html

 DEC PC                         0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 DEC WS                         0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Fujitsu TrueType font (PC)     0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Fujitsu FontCity font (PC)     0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Hitachi PC                     0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Hitachi WS                     0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 IBM                            0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 NEC Windows (PC)               0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 NEC DOS (PC)                   0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 SONY NEWS-OS                   0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Sun Wabi                       0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Unisys PC                      0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 HP Japan Japanese HP-15        0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 AT&T Japan                     0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Mitsubishi Electric FONTRUNNER 0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Concurrent Japan               0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 Informix ASCII INFORMIX V6 ALS 0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC), (0xFD)(0xA1-0xFE)(0xA1-0xFE)
 Oracle Oracle7 (Release 7.1.3) 0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x00-0xFF)
 Sybase SQL Server, Open Server 0x00-0x7F, 0xA1-0xDF, (0x81-0x9F, 0xE0-0xFC)(0x40-0x7E, 0x80-0xFC)
 
 {񏈗(ISBN 4-89052-708-7)
 
 Hewlett-Packard HP-15          0x00-0x7F, 0xA1-0xDF, (0x80-0xA0, 0xE0-0xFE)(0x21-0x7E, 0x80-0xFF)


* ASY 2

    ASY 1 ɂւ炸Atr/// ɂ蕶͈̔͂w肳ꂽꍇ͈ȉ̕
    ݂̂LƂȂ܂B

    1INebgR[h:
      0x00-0x80, 0xA0-0xDF, 0xFD-0xFF

    2INebgR[h:
      1INebg  0x81-0x9F, 0xE0-0xEF, 0xF0-0xFC
      2INebg  0x40-0x7E, 0x80-0xFC

Ⴆ΁A[\x81\x00-\x82\xFF] Əꂽꍇ [\x81\x82][\x40-\x7E\x80-\xFC] 
Ӗ܂B

ȉɃR[h\fڂ܂B

        1INebgR[h\

   0 1 2 3 4 5 6 7 8 9 A B C D E F 
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 0|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x00-0x80
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 1|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 2|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 3|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 4|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 5|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 6|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 7|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 8|*| | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 9| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 A|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0xA0-0xDF
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 B|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 C|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 D|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 E| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 F| | | | | | | | | | | | | |*|*|*| 0xFD-0xFF
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


                                 2INebgR[h\
            1INebg                                    2INebg

   0 1 2 3 4 5 6 7 8 9 A B C D E F                 0 1 2 3 4 5 6 7 8 9 A B C D E F 
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 0| | | | | | | | | | | | | | | | |              0| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 1| | | | | | | | | | | | | | | | |              1| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 2| | | | | | | | | | | | | | | | |              2| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 3| | | | | | | | | | | | | | | | |              3| | | | | | | | | | | | | | | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 4| | | | | | | | | | | | | | | | |              4|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x40-0x7E
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 5| | | | | | | | | | | | | | | | |              5|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 6| | | | | | | | | | | | | | | | |              6|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 7| | | | | | | | | | | | | | | | |              7|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 8| |*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x81-0x9F    8|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0x80-0xFC
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 9|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|              9|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 A| | | | | | | | | | | | | | | | |              A|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 B| | | | | | | | | | | | | | | | |              B|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 C| | | | | | | | | | | | | | | | |              C|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 D| | | | | | | | | | | | | | | | |              D|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 E|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*| 0xE0-0xFC    E|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|*|
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
 F|*|*|*|*|*|*|*|*|*|*|*|*|*| | | |              F|*|*|*|*|*|*|*|*|*|*|*|*|*| | | |
  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+               +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


=head1 ڕWƂĂ

vO~O Perl 3 VOLUME 1 (ISBN 4-87311-096-3)
15 Unicode Q

Unicode T|[g perl ɓȑÓAeq Zq́A2̃XJ[ϐɂ
ĕ\ꂽoCgׂĂ܂Bperl5.8 ȍ~Aeq ́A2̃oCgׂ
Ɠ UTF8 tOl܂B

/* ȉ͖ɗ悤ƂȂƂ\ȂB */

  perl5.8 ȍ~̏񏈗f
 
    +----------------------+---------------------+
    |     Text strings     |                     |
    +----------+-----------|    Binary strings   |
    |  UTF-8   |  Latin-1  |                     |
    +----------+-----------+---------------------+
    | UTF8     |            Not UTF8             |
    | Flagged  |            Flagged              |
    +--------------------------------------------+
    http://perl-users.jp/articles/advent-calendar/2010/casual/4

Perl ̕񃂃f̍́uoCi(Binary strings)vƂ`ꂪ
Ǝv܂B
uoCi(Binary strings)v̈Ӗ
1. eLXg(Non-Text strings)
2. fW^INebg(Digital octet string)

̗pgāA̐}炽߂ďĂ݂܂傤B

    +----------------------+---------------------+
    |     Text strings     |                     |
    +----------+-----------|   Non-Text strings  |
    |  UTF-8   |  Latin-1  |                     |
    +----------+-----------+---------------------+
    | UTF8     |            Not UTF8             |
    | Flagged  |            Flagged              |
    +--------------------------------------------+
    |            Digital octet string            |
    +--------------------------------------------+

Perl5.8 Ŏ{ꂽuvƂẗӖ̕ύXA񑀍̃C^tF[X
̕ύXɂāA܂ȂRZTXĂ悤ɂ͎v܂BN̊Ԋu
 Perl 𗘗p命̃vO}ɑ΂āA̓s𗝉Ă炤
͖Ǝv܂B

ŁA̕@ɖ߂ƂɂĂǂ̂悤ɉ̂Aقɂ܂݂ꂽÂ
Programming Perl, 3rd ed. (M vO~OPerl 3) 402y[Wx
ЂƂĂ݂܂傤EEEB

  UNIX/CI perl3 ȍ~A邢͂̃\tgEFAɂ񏈗f
 
    +--------------------------------------------+
    |    Text string as Digital octet string     |
    |    Digital octet string as Text string     |
    +--------------------------------------------+
    |       Not UTF8 Flagged, No Mojibake        |
    +--------------------------------------------+

zIɂ́Aȉ5̃S[悤ƍlĂ܂B

=over 2

=item * S[1

    ̃oCgw̃XNvǵAȑOẴoCgw̃f[^ɑ΂
    āAȑOƓlɓ삷ׂłB

    ̖ڕW͂̃\tgEFAAutf8 vO}̂悤 perl ɑ΂ǉ@\
    邱ƂɂĒBĂ܂BtȂ perl ͂܂Œʂ̓
    ͂łB

=item * S[2

    ̃oCgw̃XNvǵAɁA(邱ƂK؂ł)
    Vw̃f[^ɑ΂Ă삷悤ɂȂׂłB

    g݊֐ length, substr, index, rindex, pos Ȃǂ̒̕ʒu
    ͍̂܂łǂ1INebg 1 Ɛ܂B̕ɂĉ͉
    ܂B2INebgR[h1 length  2 ɂȂ܂B

    AXNvg̐K\́A}`oCĝ߂̃AJ[O
    LqKv܂AȂɑẴ\tgEFAs܂B

    S[1ƃS[2̓e}܂B

                                   GOAL#1  GOAL#2
                            (a)     (b)     (c)     (d)     (e)
          +--------------+-------+-------+-------+-------+-------+
          | data         |  Old  |  Old  |  New  |  Old  |  New  |
          +--------------+-------+-------+-------+-------+-------+
          | script       |  Old  |      Old      |      New      |
          +--------------+-------+---------------+---------------+
          | interpreter  |  Old  |              New              |
          +--------------+-------+-------------------------------+
          Old --- ̃oCgw
          New --- Vw

    f[^AXNvgAC^v^̐VEɊւāA (a)  (e) ܂ł
    g܂B̕ꂽɑ݂Ȃ Encode W[
    ̃\tgEFAAё݂Ă JPerl Ă݂܂傤B

                            (a)     (b)     (c)     (d)     (e)
                                          JPerl,japerl    Encode,Sjis
          +--------------+-------+-------+-------+-------+-------+
          | data         |  Old  |  Old  |  New  |  Old  |  New  |
          +--------------+-------+-------+-------+-------+-------+
          | script       |  Old  |      Old      |      New      |
          +--------------+-------+---------------+---------------+
          | interpreter  |  Old  |              New              |
          +--------------+-------+-------------------------------+
          Old --- ̃oCgw
          New --- Vw

    JPerl ƂĂDĂ闝R (c) ̈ʒuɂ邩łBȂ킿{ꏈ
    s߂ɃXNvgɓʂȋLqsKv܂B
    (japerl ̖ڂp܂悤ɁI)

=item * S[3

    XNvǵAVw[hłAȑÕoCgw[hƓXs[
    hœ삷ׂłB

    ͖BāAȉ̎ԂKv́B

    (1) XNvgGXP[vāAoCgw Perl ň悤ɏ邽߂
     ԁBAꂽXNvg͕ۑł邽߁A񂩂͂̎ԂȂ
     Ƃ\łB

    (2) GXP[vꂽXNvg}`oCgAJ[OsȂA
     K\s鎞ԁB

    łɑ݂ ASCII f[^11INebgɃpbNĂ܂B
    f[^ƌ݊ۂȂ當𑝂₻ƂƁAISO-2022 ̂悤ɃGXP[
    vV[PXKvłAShiftJIS  UTF-8 ̂悤 "GXP[vrbg"
    KvɂȂ肵܂B̃GXP[v邽߁AȑOƓXs[
    hœ삷ׂłƂ͖̂ȖڕWƎv܂B

    ̓ Larry Wall ɂ̃S[̂Ƃu˂Ă݂ł(Gx[^[
    )B

=item * S[4

    Perl ́AoCgw Perl ƕw Perl Ɏ}ꂹɁA1̌
    葱ׂłB

    JPerl  Perl 𕪊򂳂Ȃ悤ɂ邽߂ɁAC^v^𕪊򂳂܂B
    ł Perl RA`[̓C^v^̕]łȂ̂ł傤BʓIɃS[
    4Ƃ͂͂Perlꂪ򂷂邱ƂɂȂAPerlR~jeB͏k܂B

    oCgw perl ͂łɃoCif[^Ƃł邽߁Aw
    perl ʗĂō쐬Kv͂܂B܂̃\tgEFÁAPȂAv
    P[VvOȂ̂ŁAPerl RA`[ɂ܂邱ƂȂł傤A
    USz܂B

    ɖ Perl XNvgŉ悤ƂȂAPerl R~jeB̃T|[g
    𓾂ł傤B

    Sjis\tgEFÁA1̌E1̃C^v^܂B

=item * S[5

    JPerl [U Perl  JPerl ێł悤ɂȂB

    JPerl Ȃ̂΂ɂ܂悤 ...

=back

Programming Perl, 3rd ed. ꂽɂ́AUTF8 tO͐܂Ă炸APerl 
ȒPȎdȒPɂł悤ɐ݌vĂ܂B̃\tgEFÂ͓悤
vO~O񋟂܂B

=head1 Perl̎咣

=head2 ߂ĂPerl xviii

  Rs[^Ȋw҂̒ɂ(ɊҌ`҂)ے肷҂̂A
 lԂƂ͕̂ς`̐SĂ̂Ȃ̂BŠ`͕Rł͂Ȃ
 ̂ŁAЂǂc߂邱ƂȂɂ͕ȖʂɎʑ邱Ƃ͂łȂBߋ
 20Nȏɂ킽āARs[^Ҍ`҂͒𐫂̐_a삫A
 オƁAނ̐M򂷂֗~IȐNƂȂĉB

  ނ̔M󂾂Ⴂ̊]́AN̐Sނ̎vllɍ悤ɍ
 ςāAN̎vlp^[̒z̕ɉ߂邱ƂB
 ʂɉ܂ƂƂ́A܂т̂Ȃ݂ɂȂĂ܂Ƃ
 B

=head2 ߂ĂPerl 6ł

  𓪒ɂ̎킾ƎvȂA̒ʂłBN̂悤ȏ󋵂D
 킯ł͂܂BłAPerl͓͂ƃGR[fBÖɊւāA
 xXgsĂ܂BjZbgĂ蒼̂ȂA̎ɂ
 Ȃɑ̌ƂȂ̂łB

=head2 pPerlvO~O 2ł

 Ƃ͂PerlUnicodef[^ۂɊoĂȂ΂ȂȂłdv
 Ƃ́AUnicodef[^gpȂꍇ(ǂ̃t@CUTF-8Ƃă}[N
 炸AUTF-8P[gpĂȂꍇ)AKPerl5.005_3hɂ
 ӂłƂƂłBUnicode@\𖾎IɎgpĂȂA
 Unicode@\Ȃ̃R[hW邱Ƃ͂܂BUnicodeȂ
 ̃oCgΉXNvgWQȂƂ2̖ڕWËĂƍ
 炷Ƃ܂AƂقčsAꂪPerl̕łAPerl̕
 jł܂B

=head1 Sjis\tgEFAâ͂Ȃ

 Perl3 ȍ~ Perl ̓oCif[^XNvgLqł܂B
 ͊ȒPɌ΁Aǂȃf[^łłƂƂłB
 
 f[^ƂƓ{ł́AƂ1981NCP/M-86̓pƂčl
 ꂽVtgJISApAɂ͏~ϗpƂčLg
 Ă܂BÃf[^XNvgVtgJISō쐬
 ͂RȑIłB
 
 łAcOȂƂ perl C^v^̓VtgJISPerlXNvĝ܂
 ł͎s邱ƂłȂ̂łB
 
 Ȃ(Ȃ̏) Perl XNvg̓f[^ł邱Ƃ͊ԈႢȂ
 ̂ŁA(ʂɗpӂ) Perl XNvgłAperl C^v^Ŏs
 łXNvgɕϊ邱ƂȂAł̂ł͂Ȃł傤H
 
 AC^v^AXNvgAꂼ̃eLXgAoCï̉ۂ
 x܂Ƃ߂Ă݂܂傤Bł̓VtgJISoCiɕނĂ܂B
 
 ---------------------------------------------------
                   Ώ        eLXg  oCi
 ---------------------------------------------------
 Perl          XNvg          
 perlC^v^  XNvg          s
 PerlXNvg    f[^              
 ---------------------------------------------------
 
 perl C^v^̓VtgJISŋLqꂽXNvgsłȂǁA
 Perl ɂ͖{Â悤Ȑ킯ł͂܂B
 
 v_͂S܂B
 
 PDXNvg̕
 
 ЂƂ̃XNvgɂQȏ̕ŃeLqꍇA
 ۂɎg͂P݂̂ƂAc16iGXP[vgċLq
 Ƃ悢ł傤B
 Iȉ^pEێlꍇA݂̕XNvg
 WłOɂ͂ł܂B
 
 QDo̓f[^̕
 
 R[hƂɁAtB[hƂɕقȂ݂̂A
 ͂̕ɖmƂ͌炸Af[^̂̂琄Ȃ
 ΂ȂȂAƂ̂̓[hEChEEFbu̕ɌĂ܂B
 ̍炩Perl͂̏ꍇ "" ƂĈĂ܂Ă̂ŁA
 EňʓIȁuPɕo͂vƂ悤ȂƂȂ
 ܂B
 ʓIȂ̂ʓIɈAOOƂĈƂ Perl {̌`ɖ
 ΁A"Easy jobs easy" ߂͂łB
 
 RDϐ̃f[^^
 
 Perl̕ϐ́Af[^^錾č蕪͂܂Bf[^^ӎ
 ʂł́AZqg܂B
 ̍@ɍ킹Ȃ΁AoCgƕ͍蕪̂ł͂ȂA֐
 gقꊴ܂B
 
 SDencode/decode  convert ̈Ⴂ
 
 encode/decode ͌ꏈn̓sɍ킹āAAvP[VvO}
 LqȂ΂Ȃ܂BvO}̓c[gꂩc[Ɏg
 闧ɂȂĂ܂܂BƂɁuOɏo͂łȂԂԁv
 ̂̓fobO܂B\[XvÕefR[hE
 GR[ĥ́Aꏈnŝ܂ł̏K킵ł͂Ȃł
 H
 ŁAjcode.pl  convert ̓vO}KvɉċLq̂łB
 convert ̃f[^ǂ߂̂ł΁ÁuvvOłB
 
 ЂƂǂ߂͕̂łA͂ЂƂǂ߂́AłBłȂ
 ƂɂȂƁÂ܂ɂ傫܂B̃\tgEFA
 ̂悤ȃACfBAAOAڕWɂčn߂܂B

=head1 QlAN

 PerlvO~O
 Larry Wall, Randal L.Schwartz, ߓ Ð 
 1993N2 s
 ISBN 4-89052-384-7
 http://www.context.co.jp/~cond/books/old-books.html

 vO~OPerl 
 By Larry Wall, Tom Christiansen, Randal L. Schwartz, ߓ Ð 
 1997N12 s
 759y[W
 ISBN 4-900900-48-6
 http://www.oreilly.co.jp/out/pperl/index.htm

 vO~OPerl 3 VOLUME 1
 By Larry Wall, Tom Christiansen, Jon Orwant, ߓ Ð 
 2002N09 s
 756y[W
 ISBN 4-87311-096-3
 http://www.oreilly.co.jp/books/4873110963/

 vO~OPerl 3 VOLUME 2
 By Larry Wall, Tom Christiansen, Jon Orwant, ߓ Ð 
 2002N09 s
 680y[W
 ISBN 4-87311-097-1
 http://www.oreilly.co.jp/books/4873110971/

 The Perl Language Reference Manual (for Perl version 5.12.1)
 by Larry Wall and others
 Paperback (6"x9"), 724 pages
 Retail Price: $39.95 (pound 29.95 in UK)
 ISBN 13: 978-1-906966-02-7
 http://www.network-theory.co.uk/perl/language/

 Perl Pocket Reference, 5th Edition
 By Johan Vromans
 Publisher: O'Reilly Media
 Released: July 2011
 Pages: 102
 http://shop.oreilly.com/product/0636920018476.do

 Programming Perl, 4th Edition
 By: Tom Christiansen, brian d foy, Larry Wall, Jon Orwant
 Publisher: O'Reilly Media
 Formats: Print, Ebook, Safari Books Online
 Released: March 2012
 Pages: 1130
 Print ISBN: 978-0-596-00492-7 | ISBN 10: 0-596-00492-3
 Ebook ISBN: 978-1-4493-9890-3 | ISBN 10: 1-4493-9890-1
 http://shop.oreilly.com/product/9780596004927.do

 PerlNbNubN 2 VOLUME 1
 By Tom Christiansen, Nathan Torkington, Shibuya Perl Mongers Ė, ЃhLgVXe 
 2004N09 s
 752y[W
 ISBN 4-87311-202-8
 http://www.oreilly.co.jp/books/4873112028/

 PerlNbNubN 2 VOLUME 2
 By Tom Christiansen, Nathan Torkington, Shibuya Perl Mongers Ė, ЃhLgVXe 
 2004N09 s
 464y[W
 ISBN 4-87311-203-6
 http://www.oreilly.co.jp/books/4873112036/

 PerlNCbNt@X
 By Stephen Spainhour, Ellen Siever, Nathan Patwardhan, ߓ Ð,  \ Ė
 2000N03 s
 784y[W
 ISBN 4-900900-72-9
 http://www.oreilly.co.jp/books/4900900729/

 ߂ĂPerl Win32VXe
 Randal L. Schwartz, Erik Olson, Tom Christiansen , Ln OY Ė, Ό q_ 
 1998N11 s
 348y[W
 ISBN 4-900900-79-6
 http://www.oreilly.co.jp/books/4900900796/

 ߂ĂPerl 5
 Randal L. Schwartz, Tom Phoenix, brian d foy 
 2009N1024 
 424y[W
 ISBN 978-4-87311-427-9
 http://www.oreilly.co.jp/books/9784873114279/

 ߂ĂPerl 6
 Randal L. Schwartz, brian d foy, Tom Phoenix , ߓ Ð 
 2012N07 s
 488y[W
 ISBN 978-4-87311-567-2
 http://www.oreilly.co.jp/books/9784873115672/

 p PerlvO~O 2
 Simon Cozens ,  Ǔ 
 2006N03 s
 320y[W
 ISBN 4-87311-280-X
 http://www.oreilly.co.jp/books/487311280X/

 Perl\[XLbg - UNIX
 Futato, Irving, Jepson, Patwardhan, Siever , CG[[x R{ _ 
 ISBN 4-900900-65-6
 http://www.oreilly.co.jp/out/presuni/

 Perl̍ւ悤
 OcO, RTi, ē, z{Ll 
 1993N41 s
 280y[W
 ISBN 4-7819-0697-4
 http://www.saiensu.co.jp/?page=book_details&ISBN=ISBN4-7819-0697-4
 
 VPerl̍ւ悤 Perl5Ή
 ē, RTi, OcO, z{Ll 
 1996N41 s
 368y[W
 ISBN 4-7819-0795-4
 http://www.saiensu.co.jp/?page=book_details&ISBN=ISBN4-7819-0795-4
 
 ܂邲Perl! Vol.1
 e, {BF, ɓ, 썇FT, M,  , Ί_, IR, ܂܂, r糒qm, ma.la, |ǔ, , mL, HR, vی, Vj, ̑a 
 2006N0825 
 232y[W
 ISBN 978-4-8443-2289-4
 http://www.impressjapan.jp/books/2289

 _Perl
 q㒘
 2009N0209
 344y[W
 ISBN 10: 4798119172 | ISBN 13: 978-4798119175
 http://www.seshop.com/product/detail/10250/

 WEB+DB PRESS Vol.70
 2012N0824 
 200y[W
 ISBN 978-4-7741-5190-8
 http://gihyo.jp/magazine/wdpress

 {񏈗
 Understanding Japanese Information Processing
 By Ken Lunde, t ,   
 1995N8 s
 496y[W
 ISBN 4-89052-708-7
 http://www.fukkan.com/vote.php3?no=4293

 CJKV؉z񏈗
 Chinese, Japanese, Korean & Vietnamese Computing
 By Ken Lunde,  , t  
 2002N12 s
 1172y[W
 ISBN 4-87311-108-0
 http://www.oreilly.co.jp/books/4873111080/

 ڐ K\ 2
 By Jeffrey E. F. Friedl, ca  
 2003N05 s
 464y[W
 ISBN 4-87311-130-7
 http://www.oreilly.co.jp/books/4873111307/

 ڐ K\ 3
 By Jeffrey E. F. Friedl, ЃOe[^ O 
 2008N04 s
 528y[W
 ISBN 978-4-87311-359-3
 http://www.oreilly.co.jp/books/9784873113593/

 K\NbNubN
 Jan Goyvaerts, Steven Levithan ,  O 
 2010N04 s
 552y[W
 ISBN 978-4-87311-450-7
 http://www.oreilly.co.jp/books/9784873114507/

 K\ Zp
 Vǖ, ؗE, c
 2015N0515 s
 335y[W
 ISBN 978-4-7741-7270-5
 http://gihyo.jp/book/2015/978-4-7741-7270-5

 JIST
 Ŗ ki Ғ
 1456 
 ISBN 4-542-20129-5
 http://www.webstore.jsa.or.jp/lib/lib.asp?fn=/manual/mnl01_12.htm

 C^[lbg̕R[h
  ,  F, ˑ N, O M 
 285 
 ISBN 4-320-12038-8
 http://www.kyoritsu-pub.co.jp/bookdetail/9784320120389

 ̗j\ĂƓ{ҁ\
  F,  fq 
 2006N210 s
 288y[W
 ISBN 4-320-12102-7
 http://www.kyoritsu-pub.co.jp/bookdetail/9784320121027

 ̗j AWA
 O M 
 2002N320 s
 377y[W
 ISBN 4-320-12040-X
 http://www.amazon.co.jp/gp/product/432012040X

 UnicodeW
 gj[EOn ,  au, CV O , ֌ T ďC
 2001N529 s
 455y[W
 ISBN 4-7981-0030-7
 http://www.seshop.com/product/detail/2276/

 UnicodeɂJIS X 0213
 c OY 
 2008N825 s
 200y[W
 ISBN 978-4-89100-608-2
 http://ec.nikkeibp.co.jp/item/books/A04500.html

 Unicode IVS/IVD
 c OY,   
 2013N0304 s
 336y[W
 ISBN 978-4-82229-483-0
 http://store.nikkeibp.co.jp/item/books/P94830.html

 ƃAt@xbg Zp猩{\L̎p
 ƕӏ 
 376y[W
 ISBN978-4-588-79601-1
 http://www.h-up.com/bd/isbn978-4-588-79601-2.html

 UNIX MAGAZINE
 1993N8
 172y[W
 T1008901080816 G08901-8
 http://ascii.asciimw.jp/books/books/detail/978-4-7561-5008-0.shtml

 LINUX{
 R`_, Stephen J. Turnbull, Craig c, Robert J. Bickel 
 2000N06 s
 376y[W
 ISBN 4-87311-016-5
 http://www.oreilly.co.jp/books/4873110165/

 MacPerl
 Vicki Brown, Chris Nandor , ()RXEvlbg 
 1999N03 s
 399y[W
 ISBN 4-7561-3068-2

 Macintoshf[^pp
 Γc L 
 1995N2 s
 230y[W
 ISBN 4-89563-408-6

 MPWvO~Ou
 Handmade Intelligence 
 1992N8 s
 346y[W
 ISBN 4-7561-0963-2

 ZLAWebvO~OTipsW
  qM 
 2008N3 s
 421y[W
 ISBN 10: 4883732568
 ISBN 13: 978-4883732562

 Windows NTVFXNvg
 Tim Hill , cG 
 1998N106 s
 448y[W
 ISBN 4-7973-0658-0
 http://books-support.sbcr.jp/isbn/macmillan/ntwrkshp/index.htm

 }CN\tg Microsoft Windows R}hCpKCh
 2004N1227 s
 500y[W
 ISBN 4-89100-438-X
 http://ec.nikkeibp.co.jp/item/books/587500.html

 Oc O, Perl̗j Perl 1,2,3,4
 http://www.slideshare.net/KaoruMaeda/perl-perl-1234

 , uvɂ
 http://d.hatena.ne.jp/nurse/20141107#1415355181

  טa, u𕶎̗Ƃ݂ȂPvĂǂƁH
 http://d.hatena.ne.jp/nishiohirokazu/20141107/1415286729

 , {EUC̗j 22:00
 http://d.hatena.ne.jp/nurse/20090308/1236517235

 Mike Whitaker, Perl And Unicode
 http://www.slideshare.net/Penfold/perl-and-unicode

 Ricardo Signes, Perl 5.14 for Pragmatists
 http://www.slideshare.net/rjbs/perl-514-8809465

 Ricardo Signes, What's New in Perl? v5.10 - v5.16
 http://www.slideshare.net/rjbs/whats-new-in-perl-v510-v516

 J E, ۉK\CuȂ
 http://lc.linux.or.jp/lc2001/papers/dfa-i18n-paper.pdf
 http://lc.linux.or.jp/lc2002/papers/hasegawa0918h.pdf
 http://lc.linux.or.jp/lc2002/papers/hasegawa0918p.pdf
 http://www.j-tokkyo.com/2003/G06F/JP2003-242179.shtml

 Oc א, }`oCgZbgpK\RpC\@yуvO 
 http://patent.astamuse.com/ja/published/JP/No/2007102744

 YAMAGAKI Norio, }`oCgƍpLI[g}gVXe
 http://www.wipo.int/pctdb/ja/wo.jsp?WO=2009116646&IA=JP2009055515

 Tokyo-pm ۑ
 http://mail.pm.org/pipermail/tokyo-pm/
 http://mail.pm.org/pipermail/tokyo-pm/1999-September/001844.html
 http://mail.pm.org/pipermail/tokyo-pm/1999-September/001854.html

 ruby-list
 http://blade.nagaokaut.ac.jp/ruby/ruby-list/index.shtml
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/2440
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/2446
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/2569
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/9427
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/9431
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/10500
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/10501
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/10502
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/12385
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/12392
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/12393
 http://blade.nagaokaut.ac.jp/cgi-bin/scat.rb/ruby/ruby-list/19156

 Object-oriented with Perl
 http://www.freeml.com/perl-oo/486
 http://www.freeml.com/perl-oo/487
 http://www.freeml.com/perl-oo/490
 http://www.freeml.com/perl-oo/491
 http://www.freeml.com/perl-oo/492
 http://www.freeml.com/perl-oo/494
 http://www.freeml.com/perl-oo/514

 CPAN Directory INABA Hitoshi
 http://search.cpan.org/~ina/

 BackPAN
 http://backpan.perl.org/authors/id/I/IN/INA/

 Recent Perl packages by "INABA Hitoshi"
 http://code.activestate.com/ppm/author:INABA-Hitoshi/

=head1 ӎ

cOȂAӂ邷ׂĂ̐lɏƂł܂BƂāA
𗝗RɂĈȉ̕Xւ̊ӂ͏ȗ킯ɂ͂Ȃł傤B

 R Ǒ, VtgJIS̃fUC̘b
 ttp://furukawablog.spaces.live.com/Blog/cns!1pmWgsL289nm7Shn7cS0jHzA!2225.entry (N؂)
 ttp://shino.tumblr.com/post/116166805/1981-us-jis
 (擪 'h' tăANZXĂ)
 http://www.wdic.org/w/WDIC/%E3%82%B7%E3%83%95%E3%83%88JIS
 
 {񏈗sہA܂ăVtgJISقǎpIȕ͂܂B
 ̗R3Ǝv܂B
 
 1. ̔pJ^Jĩf[^Ƃ̂܂܋łBߋ̎Y݂Ɍpł
   Ƃ́A݂̎Y𖢗֌pł邱ƂĂ܂B
 2. codepoint  grapheme ̒PʂvB̂ŃVXeЂƂƎgЂ
   ̊Ԃꗂ܂B
 3. ̐Lƕ\E󎚏̐LvB̍Hvʐ݌vA[݌vA
   ɃJ[\̈ړɖ𗧂܂B
 
 1981N̎_ŁA܂ōlĂR̓nbJ[ƌĂԂɂӂ킵ł傤B

 Larry Wall , Perl
 http://www.perl.org/
 
 Perl K\ɂăoCif[^邱ƂŁÃ\tgEFAĂ
 ܂Bo[WԂ̌݊̍ɂ܂BK\̃^eNH[
 g̃f~^́AׂΏۂłŁAۂ̎iƂĂ𗧂܂B
  Perl Ȃ΁A݂A܂тȂދȐl
 ƂłB
 
  Larry Wall ɂ͂ƂĂӂĂ܂I

 ̑ a, jcode.pl
 ftp://ftp.iij.ad.jp/pub/IIJ/dist/utashiro/perl/
 http://log.utashiro.com/pub/2006/07/jkondo_a580.html
 
 ŏ Perl ɏô͉̑コ̏ꂽ UNIX MAGAZINE ̋LłBt@C
 eXgZq -TA-B ̋@\R[h͋Lɏꂽ̂قڂ̂܂܎g
 ܂B܂{񏈗Mꂽ Ken Lunde ̐搶ł邵AJeffrey
 E. F. Friedl ̏ڐK\̊ĖĂāÃ\tgEFA̎͂ɂ͏
 ̑コ񂪓oꂵ܂B
 
 Tokyo.pm ̃[OXgł́AV@\邽߂ɐVɎꍇłA
 ߋɍꂽ\tgEFAƓ̃C^tF[XɂƂA悢ACfBA
 ܂B
 
 قǎ͂ƌ܂A͓͂R̂ƂŁÃ\tgEFA jcode.pl 
 \[XƂɂč쐬ꂽłB牽ǂlĂ̑コȂŁÃ\
 tgEFA܂邱Ƃ͂ȂƎv̂łB

 Jeffrey E. F. Friedl , ڐK\
 http://regex.info/
 
 ڐK\(2)͂߂ēǂ񂾂ƂAĂ̂SłAĂ
 pł𔃂Ă܂̂ł͂ȂƋ^قǂłBȂ P.340 Matching
 Nested Constructs with Embedded Code KvƂĂR[hƋCÂƂ
 ƂĂ̂oĂ܂(悭płł)B
 
 Ȃ킯ŃlXgʂł̂́A}(Fumie)̂łB
 (̊ӂ`܂悤...B)

 Ken Lunde , {񏈗ACJKV؉z񏈗
 http://www.fukkan.com/vote.php3?no=4293
 http://www.oreilly.co.jp/books/4873111080/
 
 u{񏈗vuCJKV؉z񏈗vǂŕWKiƕwсA
 ̌ɂė[܂܂B JPerl ̐̉ӏɂāu悢
 (optimal portability)vƂtAAvP[VvOƁA
 n̂ӂ̉𓯎ɉׂƂƂɋCÂĂ炢܂B
 
 Appendix W: Perl Code Examples ̒ CJKV Encoding TemplatesAMultiple-Byte
 AnchoringAMultiple-Byte Processing ƂĂQlɂȂ܂B
 
 ̂₩ȃnbNƂāA Jeffrey E. F. Friedl Ɋӂ܂B

 A ms, Shift-JISeLXg𐳂
 http://homepage1.nifty.com/nomenclator/perl/shiftjis.htm
 
 uShift-JISeLXg𐳂vŁAPerlShiftJISƂ̃mEnE
 A肪Ƃ܂B̃TCg̓eƂɁAXNvg̃e
 ́u\vu\\vɕϊtB^vOƂ납n߁AO
 ĂƂł̃\tgEFAĂ܂B
 
 uɑ΂鐳K\vɂĂɊƂł܂B
 ̃TCgȂ̂ȂASjis\tgEFAꂽǂ肩ł͂܂
 B

 ܂ 䂫Ђ낳, Ruby on Perl(s)
 http://www.rubyist.net/~matz/slides/yapc2006/
 
 YAPC::Asia 2006 Tokyo "Ruby on Perl(s)" ŁuCSI͕s\ȂvƂ𕪂₷
 Ă炢܂Bx Ruby ł邱ƂɂȂA낵肢܂B

  av, jperl[U[̂߂
 http://homepage1.nifty.com/kazuf/jperl.html
 
 ver.0.71 쐬ہAڗpłȂł̃eXĝ߂60̃[
 AJɃfobOɕtĒ܂B肪Ƃ܂B

 Bruce. , Unicode in Perl
 http://www.rakunet.org/tsnet/TSabc/18/546.html

 a G, WindowsPerl 5.8/5.10gȂ
 http://dl.dropbox.com/u/23756062/perlwin.html
 https://sites.google.com/site/hiroa63iz/perlwin

 ˖{ q, Perl/Windowsł̃t@CpX
 http://digit.que.ne.jp/work/wiki.cgi?Perl%E3%83%A1%E3%83%A2%2FWindows%E3%81%A7%E3%81%AE%E3%83%95%E3%82%A1%E3%82%A4%E3%83%AB%E3%83%91%E3%82%B9

 chaichanPaPa, VtgJIS̃t@CɃ}b`Ă݂
 http://d.hatena.ne.jp/chaichanPaPa/20080802/1217660826

  Iv, Jperl
 http://homepage2.nifty.com/kipp/perl/jperl/

 n , Jperl
 http://www.cpan.org/src/5.0/jperl/
 http://search.cpan.org/~watanabe/
 ftp://ftp.oreilly.co.jp/pcjp98/watanabe/jperlconf.ppt
 
 The Perl Confernce Japan (1998)JperlJ̌o܂𕷂Ă炢܂BJPerl 
 ́A{Ήł Perl ͂ǂ̂悤Ȃ̂g₷̂܂Btr///b 
 ord  reverse ݂ JPerl ̓^܂(ŃeXgvO܂
 炤Ƃł܂)B
 
 nӂ̂ƂƓN񂶂Ȃ()҂Ă킯łA
 ҂ĂԂ Perl Ńvg^CvĂ܂B҂̂͊yƂłB

 Chuck Houpt ,  qq, MacJPerl
 http://habilis.net/macjperl/index.j.html

 Ί_ ꂳ, Pod-PerldocJp, _Perl̐Eւ悤
 http://search.cpan.org/dist/Pod-PerldocJp/
 http://gihyo.jp/dev/serial/01/modern-perl/0031
 http://gihyo.jp/dev/serial/01/modern-perl/0032
 http://gihyo.jp/dev/serial/01/modern-perl/0033
 
 u_Perl̐Eւ悤v̘AڂƂĂQlɂȂ܂Bɑ31񂩂33
 JPerl Ɋ֘AeŁAZpIɂjIɂƂĂkȋLłB
 
 ̃\tgEFA_Perlւ̉˂ƂĖ𗧂Ă΍KłB

  Y, Perl Hackers Hub 16 Perl\̐[ɔ(2)
 http://gihyo.jp/dev/serial/01/perl-hackers-hub/001602

  e, Encode W[
 http://search.cpan.org/dist/Encode/
 http://www.archive.org/details/YAPCAsia2006TokyoPerl58andUnicodeMythsFactsandChanges ()
 http://yapc.g.hatena.ne.jp/jkondo/ ()
 
 YAPC::Asia 2006 Tokyo "Perl5.8 and Unicode: Myths, Facts and Changes"  Perl5.8
 ł̕ύX_ڂĂ炢܂BCPAN  face icon ͂̃XChɏoĂ
 Perl5.6 = a city without bridges ̉摜qg𓾂Ă܂B5.005VeB
 GXP[v邽߂̃ubW\킵Ă܂B

  , JPerl Wiki
 http://ja.jperl.wikia.com/wiki/JPerl_Wiki

 Juerd , Perl Unicode Advice
 http://juerd.nl/site.plp/perluniadvice

 daily dayflower , 2008-06-25 perluniadvice
 http://d.hatena.ne.jp/dayflower/20080625/1214374293

 Jesse Vincent , Compatibility is a virtue
 http://www.nntp.perl.org/group/perl.perl5.porters/2010/05/msg159825.html

=cut

