#include <ktablistbox.h>

suicidal virtual class KTabListBox : virtual KDNDWidget {
    enum ColumnType { TextColumn, PixmapColumn, MixedColumn };
    enum OrderMode { Ascending, Descending };
    enum OrderType { NoOrder, SimpleOrder, ComplexOrder };

    KTabListBox(QWidget * = 0, const char * = 0, int = 1, WFlags = 0);
    virtual ~KTabListBox();
    void appendItem(const char *);
    void appendStrList(const QStrList *);
    bool autoUpdate() const;
    int cellHeight(int);
    int cellWidth(int);
    virtual void changeItem(const char *, int);
    virtual void changeItemColor(const QColor &, int = -1);
    virtual void changeItemPart(const char *, int, int);
    void changeMode(int);
    virtual void clear();
    void clearAllNum();
    void clearTableFlags(uint = ~0);
    int colPosList(int);
    int columnWidth(int);
    bool colXPos(int, int *);
    uint count() const;
    int currentItem() const;
;    KTabListBoxDict &dict();
    QPixmap &dndPixmap();
    void enableKey();
    int findCol(int);
    int findItem(int) const;
    int findRow(int);
    virtual void insertItem(const char *, int = -1);
    virtual bool isMarked(int) const;
    int itemPosList(int);
    int lastColVisible() const;
    int lastRowVisible() const;
    int leftCell() const;
    virtual void markItem(int, int = -1);
    int numCols() const;
    int numRows() const;
    virtual void readConfig();
    virtual void removeItem(int);
    virtual void reorderRows();
    void repaint();
    bool rowYPos(int, int *);
    virtual char separator() const;
    void setAutoUpdate(bool);
;    virtual void setColumn(int, const char *, int = 0, KTabListBox::ColumnType = KTabListBox::TextColumn, KTabListBox::OrderType = KTabListBox::NoOrder, KTabListBox::OrderMode = KTabListBox::Descending, bool = false, pig_kde_KTabListBox_compar = 0L);
    virtual void setColumnWidth(int, int = 0);
    virtual void setCurrentItem(int, int = -1);
;    virtual void setDefaultColumnWidth(int, ...);    // Not gonna happen
    virtual void setNumCols(int);
    virtual void setNumRows(int);
    virtual void setSeparator(char);
    void setTableFlags(uint);
    void setTableFont(const QFont &);
    virtual void setTabWidth(int);
    void setTopItem(int);
    bool startDrag(int, int, const QPoint &);
    uint tableFlags();
    const QFont &tableFont() const;
    int tabWidth() const;
    bool testTableFlags(uint);
    const QString &text(int, int = -1) const;
    int topCell() const;
    int topItem() const;
    int totalHeight();
    int totalWidth();
    virtual void unmarkAll();
    virtual void unmarkItem(int);
    virtual void writeConfig();
protected:
    void adjustNumber(int);
    virtual void doMouseMoveCol(QMouseEvent *);
    virtual void doMouseResizeCol(QMouseEvent *);
    void flushKeys();
;    KTabListBoxItem *getItem(int);
    void headerClicked(int) signal;
    void highlighted(int, int) signal;
    void horSbValue(int) slot;
    void horSbSlidingDone() slot;
    bool itemVisible(int);
    virtual void keyPressEvent(QKeyEvent *);
    void midClick(int, int) signal;
    virtual void mouseMoveEvent(QMouseEvent *);
    virtual void mousePressEvent(QMouseEvent *);
    virtual void mouseReleaseEvent(QMouseEvent *);
    bool needsUpdate(int);
;    virtual KTabListBoxColumn *newKTabListBoxColumn();
    virtual void paintEvent(QPaintEvent *);
    void popupMenu(int, int) signal;
;    virtual bool prepareForDrag(int, int, char **, int *, int *);
;    bool recursiveSort(int, int, KTabListBoxColumn **, int *);
    virtual void resizeEvent(QResizeEvent *);
    virtual void resizeList(int = -1);
    void selected(int, int) signal;
    void setCItem(int);
    void updateItem(int, bool = TRUE);

} KDE::TabListBox;
