# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::GG;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230305170052;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '1481[25-9]\\d{5}',
                'geographic' => '1481[25-9]\\d{5}',
                'mobile' => '
          7(?:
            (?:
              781|
              839
            )\\d|
            911[17]
          )\\d{5}
        ',
                'pager' => '
          76(?:
            464|
            652
          )\\d{5}|
          76(?:
            0[0-28]|
            2[356]|
            34|
            4[01347]|
            5[49]|
            6[0-369]|
            77|
            8[14]|
            9[139]
          )\\d{6}
        ',
                'personal_number' => '70\\d{8}',
                'specialrate' => '(
          (?:
            8(?:
              4[2-5]|
              7[0-3]
            )|
            9(?:
              [01]\\d|
              8[0-3]
            )
          )\\d{7}|
          845464\\d
        )|(
          (?:
            3[0347]|
            55
          )\\d{8}
        )',
                'toll_free' => '
          80[08]\\d{7}|
          800\\d{6}|
          8001111
        ',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"441467", "Inverurie",
"442892", "Lisburn",
"441654", "Machynlleth",
"441833", "Barnard\ Castle",
"4414376", "Haverfordwest",
"441304", "Dover",
"4414300", "North\ Cave\/Market\ Weighton",
"441955", "Wick",
"441534", "Jersey",
"441869", "Bicester",
"441398", "Dulverton",
"441227", "Canterbury",
"441432", "Hereford",
"441777", "Retford",
"441565", "Knutsford",
"441355", "East\ Kilbride",
"4413390", "Aboyne\/Ballater",
"441904", "York",
"442843", "Newcastle\ \(Co\.\ Down\)",
"441722", "Salisbury",
"442889", "Fivemiletown",
"441397", "Fort\ William",
"441643", "Minehead",
"4414375", "Clynderwen\ \(Clunderwen\)",
"441228", "Carlisle",
"441349", "Dingwall",
"4415394", "Hawkshead",
"441383", "Dunfermline",
"4418908", "Coldstream",
"441726", "St\ Austell",
"441689", "Orpington",
"441824", "Ruthin",
"441481", "Guernsey",
"441436", "Helensburgh",
"441875", "Tranent",
"441579", "Liskeard",
"44118", "Reading",
"4418479", "Tongue",
"441200", "Clitheroe",
"4419752", "Alford\ \(Aberdeen\)",
"441983", "Isle\ of\ Wight",
"441276", "Camberley",
"441692", "North\ Walsham",
"441997", "Strathpeffer",
"442896", "Belfast",
"441440", "Haverhill",
"441778", "Bourne",
"441750", "Selkirk",
"441949", "Whatton",
"441968", "Penicuik",
"442837", "Armagh",
"441882", "Kinloch\ Rannoch",
"441981", "Wormbridge",
"44239", "Portsmouth",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"4418478", "Thurso",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"441340", "Craigellachie\ \(Aberlour\)",
"441449", "Stowmarket",
"441497", "Hay\-on\-Wye",
"441759", "Pocklington",
"441506", "Bathgate",
"441666", "Malmesbury",
"441638", "Newmarket",
"441483", "Guildford",
"441381", "Fortrose",
"441899", "Biggar",
"4418909", "Ayton",
"441209", "Redruth",
"4415075", "Spilsby\ \(Horncastle\)",
"441641", "Strathy",
"4414233", "Boroughbridge",
"441570", "Lampeter",
"441253", "Blackpool",
"441558", "Llandeilo",
"441368", "Dunbar",
"4416860", "Newtown\/Llanidloes",
"441332", "Derby",
"441745", "Rhyl",
"442841", "Rostrevor",
"441455", "Hinckley",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"442866", "Enniskillen",
"441502", "Lowestoft",
"442838", "Portadown",
"441967", "Strontian",
"441285", "Cirencester",
"442880", "Carrickmore",
"441557", "Kirkcudbright",
"4412292", "Barrow\-in\-Furness",
"441367", "Faringdon",
"441784", "Staines",
"441404", "Honiton",
"4414343", "Haltwhistle",
"441848", "Thornhill",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"441637", "Newquay",
"441244", "Chester",
"4415076", "Louth",
"441932", "Weybridge",
"441509", "Loughborough",
"441756", "Skipton",
"442890", "Belfast",
"4414372", "Clynderwen\ \(Clunderwen\)",
"441446", "Barry",
"4414308", "Market\ Weighton",
"441553", "Kings\ Lynn",
"441258", "Blandford",
"441794", "Romsey",
"441363", "Crediton",
"441669", "Rothbury",
"4414237", "Harrogate",
"441270", "Crewe",
"441206", "Colchester",
"441896", "Galashiels",
"441461", "Gretna",
"441708", "Romford",
"441488", "Hungerford",
"441854", "Ullapool",
"441633", "Newport",
"441939", "Wem",
"44283", "Northern\ Ireland",
"44116", "Leicester",
"4419755", "Alford\ \(Aberdeen\)",
"441963", "Wincanton",
"441720", "Isles\ of\ Scilly",
"4416869", "Newtown",
"441771", "Maud",
"4413398", "Aboyne",
"441295", "Banbury",
"442824", "Northern\ Ireland",
"441805", "Torrington",
"441487", "Warboys",
"441707", "Welwyn\ Garden\ City",
"4418900", "Coldstream\/Ayton",
"441675", "Coleshill",
"441493", "Great\ Yarmouth",
"441624", "Isle\ of\ Man",
"441544", "Kington",
"441257", "Coppull",
"441974", "Llanon",
"441914", "Tyneside",
"441889", "Rugeley",
"4414347", "Hexham",
"4418511", "Great\ Bernera\/Stornoway",
"441843", "Thanet",
"441925", "Warrington",
"441325", "Darlington",
"441202", "Bournemouth",
"44238", "Southampton",
"441892", "Tunbridge\ Wells",
"4419756", "Strathdon",
"441690", "Betws\-y\-Coed",
"441752", "Plymouth",
"441442", "Hemel\ Hempstead",
"441425", "Ringwood",
"442848", "Northern\ Ireland",
"441880", "Tarbert",
"441474", "Gravesend",
"4419641", "Hornsea\/Patrington",
"441993", "Witney",
"441342", "East\ Grinstead",
"441987", "Ebbsfleet",
"4418470", "Thurso\/Tongue",
"442886", "Cookstown",
"441841", "Newquay\ \(Padstow\)",
"441942", "Wigan",
"441387", "Dumfries",
"4412295", "Barrow\-in\-Furness",
"441234", "Bedford",
"4414344", "Bellingham",
"441527", "Redditch",
"441647", "Moretonhampstead",
"441764", "Crieff",
"441491", "Henley\-on\-Thames",
"441838", "Dalmally",
"441866", "Kilchrenan",
"441572", "Oakham",
"441330", "Banchory",
"441988", "Wigtown",
"4413399", "Ballater",
"441576", "Lockerbie",
"4416868", "Newtown",
"441862", "Tain",
"441773", "Ripley",
"441279", "Bishops\ Stortford",
"442847", "Northern\ Ireland",
"441946", "Whitehaven",
"442899", "Northern\ Ireland",
"441346", "Fraserburgh",
"4412296", "Barrow\-in\-Furness",
"441631", "Oban",
"442882", "Omagh",
"441837", "Okehampton",
"441729", "Settle",
"441463", "Inverness",
"441528", "Laggan",
"441223", "Cambridge",
"441361", "Duns",
"4414309", "Market\ Weighton",
"4415072", "Spilsby\ \(Horncastle\)",
"4414234", "Boroughbridge",
"441388", "Bishop\ Auckland",
"441439", "Helmsley",
"441603", "Norwich",
"441766", "Porthmadog",
"4413393", "Aboyne",
"441309", "Forres",
"441738", "Perth",
"441659", "Sanquhar",
"441563", "Kilmarnock",
"441268", "Basildon",
"441236", "Coatbridge",
"441353", "Ely",
"442845", "Northern\ Ireland",
"441428", "Haslemere",
"441451", "Stow\-on\-the\-Wold",
"441864", "Abington\ \(Crawford\)",
"4418477", "Tongue",
"441539", "Kendal",
"441835", "St\ Boswells",
"441476", "Grantham",
"4419642", "Hornsea",
"44115", "Nottingham",
"4418904", "Coldstream",
"441953", "Wymondham",
"442884", "Northern\ Ireland",
"441400", "Honington",
"44280", "Northern\ Ireland",
"441780", "Stamford",
"4414303", "North\ Cave",
"441909", "Worksop",
"441684", "Malvern",
"441427", "Gainsborough",
"441344", "Bracknell",
"441591", "Llanwrtyd\ Wells",
"441267", "Carmarthen",
"441985", "Warminster",
"44292", "Cardiff",
"441829", "Tarporley",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441472", "Grimsby",
"441737", "Redhill",
"441525", "Leighton\ Buzzard",
"441944", "West\ Heslerton",
"441873", "Abergavenny",
"441972", "Glenborrodale",
"441871", "Castlebay",
"441912", "Tyneside",
"441485", "Hunstanton",
"4414230", "Harrogate\/Boroughbridge",
"441677", "Bedale",
"442826", "Northern\ Ireland",
"441255", "Clacton\-on\-Sea",
"441622", "Maidstone",
"441542", "Keith",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441796", "Pitlochry",
"441754", "Skegness",
"441298", "Buxton",
"441593", "Lybster",
"441327", "Daventry",
"441444", "Haywards\ Heath",
"441808", "Tomatin",
"441856", "Orkney",
"441204", "Bolton",
"441372", "Esher",
"4413873", "Langholm",
"441376", "Braintree",
"4418907", "Ayton",
"441530", "Coalville",
"441928", "Runcorn",
"441852", "Kilmelford",
"441951", "Colonsay",
"442310", "Portsmouth",
"441650", "Cemmaes\ Road",
"441678", "Bala",
"441792", "Swansea",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"441300", "Cerne\ Abbas",
"441626", "Newton\ Abbot",
"441789", "Stratford\-upon\-Avon",
"441409", "Holsworthy",
"441546", "Lochgilphead",
"441900", "Workington",
"441453", "Dursley",
"441743", "Shrewsbury",
"4418474", "Thurso",
"442822", "Northern\ Ireland",
"441297", "Axminster",
"441328", "Fakenham",
"4416863", "Llanidloes",
"441561", "Laurencekirk",
"441249", "Chippenham",
"441807", "Ballindalloch",
"442877", "Limavady",
"441588", "Bishops\ Castle",
"441916", "Tyneside",
"441283", "Burton\-on\-Trent",
"4418512", "Stornoway",
"441664", "Melton\ Mowbray",
"441747", "Shaftesbury",
"441457", "Glossop",
"441799", "Saffron\ Walden",
"441859", "Harris",
"441334", "St\ Andrews",
"441287", "Guisborough",
"441803", "Torquay",
"441598", "Lynton",
"441293", "Crawley",
"441242", "Cheltenham",
"4419646", "Patrington",
"4414349", "Bellingham",
"441934", "Weston\-super\-Mare",
"441555", "Lanark",
"44161", "Manchester",
"442829", "Kilrea",
"441635", "Newbury",
"441782", "Stoke\-on\-Trent",
"441323", "Eastbourne",
"441261", "Banff",
"441549", "Lairg",
"4413394", "Ballater",
"4412291", "Barrow\-in\-Furness\/Millom",
"4416867", "Llanidloes",
"441629", "Matlock",
"441597", "Llandrindod\ Wells",
"441786", "Stirling",
"441406", "Holbeach",
"441583", "Carradale",
"441288", "Bude",
"441246", "Chesterfield",
"441884", "Tiverton",
"44287", "Northern\ Ireland",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"441748", "Richmond",
"44281", "Northern\ Ireland",
"4415242", "Hornby",
"441458", "Glastonbury",
"441919", "Durham",
"441673", "Market\ Rasen",
"441379", "Diss",
"4419645", "Hornsea",
"441495", "Pontypool",
"4419467", "Gosforth",
"4418903", "Coldstream",
"441760", "Swaffham",
"4414239", "Boroughbridge",
"441923", "Watford",
"4414304", "North\ Cave",
"441845", "Thirsk",
"441479", "Grantown\-on\-Spey",
"441822", "Tavistock",
"441970", "Aberystwyth",
"441910", "Tyneside\/Durham\/Sunderland",
"4414238", "Harrogate",
"441395", "Budleigh\ Salterton",
"4414307", "Market\ Weighton",
"441877", "Callander",
"441540", "Kingussie",
"441671", "Newton\ Stewart",
"441620", "North\ Berwick",
"441769", "South\ Molton",
"441306", "Dorking",
"441694", "Church\ Stretton",
"4418473", "Thurso",
"441239", "Cardigan",
"441656", "Bridgend",
"441995", "Garstang",
"4413397", "Ballater",
"441733", "Peterborough",
"4416864", "Llanidloes",
"441608", "Chipping\ Norton",
"441581", "New\ Luce",
"441263", "Cromer",
"441568", "Leominster",
"441536", "Kettering",
"441358", "Ellon",
"4418515", "Stornoway",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"441465", "Girvan",
"441878", "Lochboisdale",
"4414348", "Hexham",
"442894", "Antrim",
"441652", "Brigg",
"441225", "Bath",
"441302", "Doncaster",
"441274", "Bradford",
"441957", "Mid\ Yell",
"441790", "Spilsby",
"441567", "Killin",
"441357", "Strathaven",
"441902", "Wolverhampton",
"441291", "Chepstow",
"441724", "Scunthorpe",
"441775", "Spalding",
"442820", "Ballycastle",
"442871", "Londonderry",
"4418516", "Great\ Bernera",
"4419644", "Patrington",
"441545", "Llanarth",
"441625", "Macclesfield",
"441252", "Aldershot",
"441674", "Montrose",
"441924", "Wakefield",
"441702", "Southend\-on\-Sea",
"4414305", "North\ Cave",
"441482", "Kingston\-upon\-Hull",
"4418902", "Coldstream",
"441915", "Sunderland",
"441584", "Ludlow",
"4418517", "Stornoway",
"441375", "Grays\ Thurrock",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"4413395", "Aboyne",
"441324", "Falkirk",
"441757", "Selby",
"441499", "Inveraray",
"441883", "Caterham",
"441691", "Oswestry",
"4419758", "Strathdon",
"441207", "Consett",
"442891", "Bangor\ \(Co\.\ Down\)",
"441795", "Sittingbourne",
"441933", "Wellingborough",
"4412299", "Millom",
"441271", "Barnstaple",
"441460", "Chard",
"44286", "Northern\ Ireland",
"441855", "Ballachulish",
"4414306", "Market\ Weighton",
"441969", "Leyburn",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"44113", "Leeds",
"441431", "Helmsdale",
"441503", "Looe",
"441208", "Bodmin",
"4413396", "Ballater",
"441663", "New\ Mills",
"4417683", "Appleby",
"441369", "Dunoon",
"441706", "Rochdale",
"441559", "Llandysul",
"441770", "Isle\ of\ Arran",
"442825", "Ballymena",
"4414231", "Harrogate\/Boroughbridge",
"441294", "Ardrossan",
"441721", "Peebles",
"441758", "Pwllheli",
"441639", "Neath",
"441256", "Basingstoke",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"441646", "Milford\ Haven",
"441526", "Martin",
"441469", "Killingholme",
"441386", "Evesham",
"441723", "Scarborough",
"442842", "Kircubbin",
"441661", "Prudhoe",
"441348", "Fishguard",
"441433", "Hathersage",
"4416866", "Newtown",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"441501", "Harthill",
"441630", "Market\ Drayton",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441779", "Peterhead",
"441948", "Whitchurch",
"441273", "Brighton",
"441578", "Lauder",
"442887", "Dungannon",
"441986", "Bungay",
"441360", "Killearn",
"441550", "Llandovery",
"4412298", "Barrow\-in\-Furness",
"442893", "Ballyclare",
"441832", "Clopton",
"441931", "Shap",
"441475", "Greenock",
"4419759", "Alford\ \(Aberdeen\)",
"441687", "Mallaig",
"4418472", "Thurso",
"441982", "Builth\ Wells",
"441347", "Easingwold",
"441424", "Hastings",
"4413885", "Stanhope\ \(Eastgate\)",
"441264", "Andover",
"4418514", "Great\ Bernera",
"442830", "Newry",
"4416865", "Newtown",
"441765", "Ripon",
"441840", "Camelford",
"442888", "Northern\ Ireland",
"441235", "Abingdon",
"441577", "Kinross",
"4419647", "Patrington",
"441382", "Dundee",
"441947", "Whitby",
"441490", "Corwen",
"442846", "Northern\ Ireland",
"441642", "Middlesbrough",
"44121", "Birmingham",
"441522", "Lincoln",
"44114", "Sheffield",
"441250", "Blairgowrie",
"441573", "Kelso",
"441278", "Bridgwater",
"442898", "Belfast",
"441776", "Stranraer",
"441700", "Rothesay",
"441480", "Huntingdon",
"441874", "Brecon",
"441392", "Exeter",
"441989", "Ross\-on\-Wye",
"441943", "Guiseley",
"4418906", "Ayton",
"441825", "Uckfield",
"441529", "Sleaford",
"441697", "Brampton",
"441343", "Elgin",
"441683", "Moffat",
"4417684", "Pooley\ Bridge",
"441466", "Huntly",
"441389", "Dumbarton",
"441992", "Lea\ Valley",
"441438", "Stevenage",
"441226", "Barnsley",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"441728", "Saxmundham",
"441751", "Pickering",
"441305", "Dorchester",
"4419643", "Patrington",
"44151", "Liverpool",
"441655", "Maybole",
"442849", "Northern\ Ireland",
"441462", "Hitchin",
"442897", "Saintfield",
"4414302", "North\ Cave",
"4414378", "Haverfordwest",
"4415079", "Alford\ \(Lincs\)",
"4418905", "Ayton",
"442883", "Northern\ Ireland",
"441535", "Keighley",
"441954", "Madingley",
"441277", "Brentwood",
"441727", "St\ Albans",
"441354", "Chatteris",
"441564", "Lapworth",
"4413392", "Aboyne",
"441604", "Northampton",
"441863", "Ardgay",
"441772", "Preston",
"441698", "Motherwell",
"441905", "Worcester",
"441454", "Chipping\ Sodbury",
"4418475", "Thurso",
"441667", "Nairn",
"441744", "St\ Helens",
"441888", "Turriff",
"441962", "Winchester",
"442840", "Banbridge",
"441496", "Port\ Ellen",
"4413882", "Stanhope\ \(Eastgate\)",
"441284", "Bury\ St\ Edmunds",
"441337", "Ladybank",
"4418513", "Stornoway",
"4416862", "Llanidloes",
"441405", "Goole",
"441785", "Stafford",
"442881", "Newtownstewart",
"4415078", "Alford\ \(Lincs\)",
"442868", "Kesh",
"4414379", "Haverfordwest",
"441937", "Wetherby",
"441362", "Dereham",
"441245", "Chelmsford",
"441830", "Kirkwhelpington",
"4412290", "Barrow\-in\-Furness\/Millom",
"441594", "Lydney",
"441753", "Slough",
"441443", "Pontypridd",
"4418476", "Tongue",
"441366", "Downham\ Market",
"441556", "Castle\ Douglas",
"441489", "Bishops\ Waltham",
"441709", "Rotherham",
"441980", "Amesbury",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"441508", "Brooke",
"441341", "Barmouth",
"4417687", "Keswick",
"441259", "Alloa",
"441636", "Newark\-on\-Trent",
"441887", "Aberfeldy",
"441668", "Bamburgh",
"441842", "Thetford",
"441938", "Welshpool",
"441492", "Colwyn\ Bay",
"442867", "Lisnaskea",
"441380", "Devizes",
"441520", "Lochcarron",
"441571", "Lochinver",
"441373", "Frome",
"441260", "Congleton",
"441730", "Petersfield",
"441592", "Kirkcaldy",
"441885", "Pencombe",
"441420", "Alton",
"441929", "Wareham",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"441623", "Mansfield",
"441494", "High\ Wycombe",
"44117", "Bristol",
"441329", "Fareham",
"441543", "Cannock",
"441248", "Bangor\ \(Gwynedd\)",
"441456", "Glenurquhart",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441746", "Bridgnorth",
"441844", "Thame",
"441408", "Golspie",
"441788", "Rugby",
"441286", "Caernarfon",
"441913", "Durham",
"4416861", "Newtown\/Llanidloes",
"4412297", "Millom",
"441761", "Temple\ Cloud",
"4416973", "Wigton",
"441282", "Burnley",
"441505", "Johnstone",
"4419754", "Alford\ \(Aberdeen\)",
"44131", "Edinburgh",
"441665", "Alnwick",
"4418519", "Great\ Bernera",
"441452", "Gloucester",
"442823", "Northern\ Ireland",
"441335", "Ashbourne",
"441364", "Ashburton",
"441793", "Swindon",
"441554", "Llanelli",
"441935", "Yeovil",
"441787", "Sudbury",
"441407", "Holyhead",
"4414373", "Clynderwen\ \(Clunderwen\)",
"442879", "Magherafelt",
"441634", "Medway",
"441299", "Bewdley",
"4419648", "Hornsea",
"441809", "Tomdoun",
"4414346", "Hexham",
"441464", "Insch",
"4419649", "Hornsea",
"441307", "Forfar",
"441952", "Telford",
"441828", "Coupar\ Angus",
"441275", "Clevedon",
"4415073", "Louth",
"4414235", "Harrogate",
"441224", "Aberdeen",
"442895", "Belfast",
"441290", "Cumnock",
"442870", "Coleraine",
"441725", "Rockbourne",
"44141", "Glasgow",
"442821", "Martinstown",
"4418518", "Stornoway",
"441352", "Mold",
"441562", "Kidderminster",
"4419757", "Strathdon",
"441876", "Lochmaddy",
"441435", "Heathfield",
"441911", "Tyneside\/Durham\/Sunderland",
"441971", "Scourie",
"441429", "Hartlepool",
"4414345", "Haltwhistle",
"441872", "Truro",
"441606", "Northwich",
"441394", "Felixstowe",
"441920", "Ware",
"441763", "Royston",
"4412294", "Barrow\-in\-Furness",
"441356", "Brechin",
"441538", "Ipstones",
"441233", "Ashford\ \(Kent\)",
"4413391", "Aboyne\/Ballater",
"441566", "Launceston",
"4414236", "Harrogate",
"441308", "Bridport",
"441827", "Tamworth",
"441621", "Maldon",
"441670", "Morpeth",
"441269", "Ammanford",
"441473", "Ipswich",
"441695", "Skelmersdale",
"441908", "Milton\ Keynes",
"441580", "Cranbrook",
"4414301", "North\ Cave\/Market\ Weighton",
"441371", "Great\ Dunmow",
"441994", "St\ Clears",
"441320", "Fort\ Augustus",
"4419753", "Strathdon",
"441262", "Bridlington",
"441732", "Sevenoaks",
"441477", "Holmes\ Chapel",
"441685", "Merthyr\ Tydfil",
"441590", "Lymington",
"44291", "Cardiff",
"441984", "Watchet\ \(Williton\)",
"441879", "Scarinish",
"441422", "Halifax",
"441237", "Bideford",
"441575", "Kirriemuir",
"441384", "Dudley",
"4415077", "Louth",
"441644", "New\ Galloway",
"441767", "Sandy",
"441524", "Lancaster",
"4415395", "Grange\-over\-Sands",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441823", "Taunton",
"441945", "Wisbech",
"441280", "Buckingham",
"441959", "Westerham",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"441740", "Sedgefield",
"441450", "Hawick",
"441865", "Oxford",
"441903", "Worthing",
"442844", "Downpatrick",
"4418471", "Thurso\/Tongue",
"441303", "Folkestone",
"441609", "Northallerton",
"441359", "Pakenham",
"441241", "Arbroath",
"441569", "Stonehaven",
"441834", "Narberth",
"4415396", "Sedbergh",
"441653", "Malton",
"441736", "Penzance",
"4419640", "Hornsea\/Patrington",
"441768", "Penrith",
"4416974", "Raughton\ Head",
"442885", "Ballygawley",
"441531", "Ledbury",
"4414342", "Bellingham",
"441326", "Falmouth",
"441403", "Horsham",
"4420", "London",
"441950", "Sandwick",
"4412293", "Millom",
"441749", "Shepton\ Mallet",
"441797", "Rye",
"441918", "Tyneside",
"441586", "Campbeltown",
"441978", "Wrexham",
"441548", "Kingsbridge",
"441243", "Chichester",
"441628", "Maidenhead",
"441651", "Oldmeldrum",
"442311", "Southampton",
"441301", "Arrochar",
"441857", "Sanday",
"441289", "Berwick\-upon\-Tweed",
"441676", "Meriden",
"441292", "Ayr",
"4418510", "Great\ Bernera\/Stornoway",
"441350", "Dunkeld",
"441560", "Moscow",
"442827", "Ballymoney",
"441926", "Warwick",
"441600", "Monmouth",
"4418901", "Coldstream\/Ayton",
"441858", "Market\ Harborough",
"441922", "Walsall",
"441821", "Kinrossie",
"44241", "Coventry",
"441704", "Southport",
"441484", "Huddersfield",
"441870", "Isle\ of\ Benbecula",
"44247", "Coventry",
"441547", "Knighton",
"441599", "Kyle",
"4415074", "Alford\ \(Lincs\)",
"441917", "Sunderland",
"441798", "Pulborough",
"4414232", "Harrogate",
"441254", "Blackburn",
"441977", "Pontefract",
"441672", "Marlborough",
"441806", "Shetland",
"441296", "Aylesbury",
"4414377", "Haverfordwest",
"442828", "Larne",
"441445", "Gairloch",
"441377", "Driffield",
"441895", "Uxbridge",
"441582", "Luton",
"441205", "Boston",
"441322", "Dartford",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:([25-9]\d{5})$|0)//;
      $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;