use strict;
use ExtUtils::MakeMaker 6.17;

my $EUMM = eval( $ExtUtils::MakeMaker::VERSION );

my $meta = {
  "abstract"       => "demo of Mite",
  "author"         => ["Toby Inkster (TOBYINK) <tobyink\@cpan.org>"],
  "dynamic_config" => 1,
  "generated_by"   => "Dist::Inkt::Profile::TOBYINK version 0.024, CPAN::Meta::Converter version 2.150010",
  "keywords"       => [],
  "license"        => ["perl_5"],
  "meta-spec"      => {
                        url => "http://search.cpan.org/perldoc?CPAN::Meta::Spec",
                        version => 2,
                      },
  "name"           => "Acme-Mitey-Cards",
  "no_index"       => { directory => ["eg", "examples", "inc", "t", "xt"] },
  "prereqs"        => {
                        configure => { requires => { "ExtUtils::MakeMaker" => 6.17 } },
                        develop   => {
                                       recommends => { "Dist::Inkt" => 0.001 },
                                       requires   => { Mite => "0.011000" },
                                     },
                        runtime   => { requires => { perl => 5.008001 } },
                        test      => {
                                       recommends => { "Moose" => 2, "Type::Tiny" => 2 },
                                       requires   => { "Test::More" => 0.96, "Test::Requires" => 0 },
                                     },
                      },
  "provides"       => {
                        "Acme::Mitey::Cards"                        => { file => "lib/Acme/Mitey/Cards.pm", version => 0.016 },
                        "Acme::Mitey::Cards::Card"                  => { file => "lib/Acme/Mitey/Cards/Card.pm", version => 0.016 },
                        "Acme::Mitey::Cards::Card::Face"            => { file => "lib/Acme/Mitey/Cards/Card/Face.pm", version => 0.016 },
                        "Acme::Mitey::Cards::Card::Joker"           => { file => "lib/Acme/Mitey/Cards/Card/Joker.pm", version => 0.016 },
                        "Acme::Mitey::Cards::Card::Numeric"         => { file => "lib/Acme/Mitey/Cards/Card/Numeric.pm", version => 0.016 },
                        "Acme::Mitey::Cards::Deck"                  => { file => "lib/Acme/Mitey/Cards/Deck.pm", version => 0.016 },
                        "Acme::Mitey::Cards::Hand"                  => { file => "lib/Acme/Mitey/Cards/Hand.pm", version => 0.016 },
                        "Acme::Mitey::Cards::Mite"                  => { file => "lib/Acme/Mitey/Cards/Mite.pm" },
                        "Acme::Mitey::Cards::MOP"                   => { file => "lib/Acme/Mitey/Cards/MOP.pm" },
                        "Acme::Mitey::Cards::MOP::Meta::Class"      => { file => "lib/Acme/Mitey/Cards/MOP.pm" },
                        "Acme::Mitey::Cards::MOP::Meta::Role"       => { file => "lib/Acme/Mitey/Cards/MOP.pm" },
                        "Acme::Mitey::Cards::Set"                   => { file => "lib/Acme/Mitey/Cards/Set.pm", version => 0.016 },
                        "Acme::Mitey::Cards::Suit"                  => { file => "lib/Acme/Mitey/Cards/Suit.pm", version => 0.016 },
                        "Acme::Mitey::Cards::Types"                 => { file => "lib/Acme/Mitey/Cards/Types.pm" },
                        "Acme::Mitey::Cards::Types::Source"         => { file => "lib/Acme/Mitey/Cards/Types/Source.pm" },
                        "Acme::Mitey::Cards::Types::TypeConstraint" => { file => "lib/Acme/Mitey/Cards/Types.pm" },
                      },
  "release_status" => "stable",
  "resources"      => {
                        bugtracker   => { web => "https://github.com/tobyink/p5-mite/issues" },
                        homepage     => "https://metacpan.org/release/Acme-Mitey-Cards",
                        license      => ["http://dev.perl.org/licenses/"],
                        repository   => {
                                          type => "git",
                                          url  => "git://github.com/tobyink/p5-mite.git",
                                          web  => "https://github.com/tobyink/p5-mite",
                                        },
                        x_identifier => "http://purl.org/NET/cpan-uri/dist/Acme-Mitey-Cards/project",
                      },
  "version"        => 0.016,
};

my %dynamic_config;
do {
if ($] < 5.010000) {
	$meta->{prereqs}{runtime}{requires}{'MRO::Compat'} = 0;
}

if ($] < 5.014000) {
        $meta->{prereqs}{runtime}{requires}{'Devel::GlobalDestruction'} = 0;
}

};

my %WriteMakefileArgs = (
	ABSTRACT   => $meta->{abstract},
	AUTHOR     => ($EUMM >= 6.5702 ? $meta->{author} : $meta->{author}[0]),
	DISTNAME   => $meta->{name},
	VERSION    => $meta->{version},
	EXE_FILES  => [ map $_->{file}, values %{ $meta->{x_provides_scripts} || {} } ],
	NAME       => do { my $n = $meta->{name}; $n =~ s/-/::/g; $n },
	test       => { TESTS => "t/*.t" },
	%dynamic_config,
);

$WriteMakefileArgs{LICENSE} = $meta->{license}[0] if $EUMM >= 6.3001;

sub deps
{
	my %r;
	for my $stage (@_)
	{
		for my $dep (keys %{$meta->{prereqs}{$stage}{requires}})
		{
			next if $dep eq 'perl';
			my $ver = $meta->{prereqs}{$stage}{requires}{$dep};
			$r{$dep} = $ver if !exists($r{$dep}) || $ver >= $r{$dep};
		}
	}
	\%r;
}

my ($build_requires, $configure_requires, $runtime_requires, $test_requires);
if ($EUMM >= 6.6303)
{
	$WriteMakefileArgs{BUILD_REQUIRES}     ||= deps('build');
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{TEST_REQUIRES}      ||= deps('test');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime');
}
elsif ($EUMM >= 6.5503)
{
	$WriteMakefileArgs{BUILD_REQUIRES}     ||= deps('build', 'test');
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime');	
}
elsif ($EUMM >= 6.52)
{
	$WriteMakefileArgs{CONFIGURE_REQUIRES} ||= deps('configure');
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('runtime', 'build', 'test');	
}
else
{
	$WriteMakefileArgs{PREREQ_PM}          ||= deps('configure', 'build', 'test', 'runtime');	
}

{
	my ($minperl) = reverse sort(
		grep defined && /^[0-9]+(\.[0-9]+)?$/,
		map $meta->{prereqs}{$_}{requires}{perl},
		qw( configure build runtime )
	);
	
	if (defined($minperl))
	{
		die "Installing $meta->{name} requires Perl >= $minperl"
			unless $] >= $minperl;
		
		$WriteMakefileArgs{MIN_PERL_VERSION} ||= $minperl
			if $EUMM >= 6.48;
	}
}


my $mm = WriteMakefile(%WriteMakefileArgs);

exit(0);

