/* ------------------------------------------------------------------------
@NAME       : btparse.h
@DESCRIPTION: Declarations and types for users of the btparse library.
@GLOBALS    : 
@CALLS      : 
@CREATED    : 1997/01/19, Greg Ward
@MODIFIED   : 
@VERSION    : $Id: btparse.h,v 1.2 1997/02/28 04:09:00 greg Exp $
-------------------------------------------------------------------------- */
#ifndef BTPARSE_H
#define BTPARSE_H

#include <stdio.h>
#include "bibtex_ast.h"
#include "pccts/ast.h"

/* Parsing (and post-processing) options structure */

typedef struct 
{
   int    check_only;
   int    delete_quotes;
   int    expand_macros;
   int    paste_strings;
   int    collapse_whitespace;
} bt_options_t;

typedef enum 
{
   E_NOTIFY,                    /* notification about next action */
   E_CONTENT,                   /* warning about the content of a record */
   E_STRUCTURAL,                /* warning about the structure of a record */
   E_LEXWARN,                   /* warning in lexical analysis */
   E_LEXERR,                    /* error in lexical analysis */
   E_SYNTAX,                    /* error in parser */
   E_FATAL,                     /* bigger problem (but still user's fault) */
   E_INTERNAL                   /* my fault */
} errclass_t;

typedef unsigned char uchar;

#define NUM_ERRCLASSES ((int) E_INTERNAL + 1)


/* Function prototypes: */

/* init.c */
void  bt_initialize (void);
void  bt_cleanup (void);

/* input.c */
void  bt_set_filename (char *filename);
uchar bt_parse_entry_s (char         *entry_text, 
                        bt_options_t *options,
                        int           line,
                        AST         **top);
uchar bt_parse_entry   (FILE         *infile,
                        bt_options_t *options,
                        AST         **top);
uchar bt_parse_file    (char         *filename, 
                        bt_options_t *options,
                        AST         **top);

/* error.c */
void  reset_error_counts (void);
int   get_error_count (errclass_t errclass);
int  *get_error_counts (int *counts);
uchar error_status (int *saved_counts);

/* traversal.c */
char *bt_get_type (AST *top, nodetype_t *nodetype);
char *bt_get_key (AST *top);
AST  *bt_first_field (AST *top, char **name, AST **vals);
AST  *bt_next_field (AST *prev, char **name, AST **vals); 
AST  *bt_first_item (AST *head, nodetype_t *nodetype, char **text);
AST  *bt_next_item (AST *prev, nodetype_t *nodetype, char **text);
char *bt_value (AST *field);

#endif /* BTPARSE_H */
