use strict;
use FileHandle;
use Crypt::SHAVS;
use Digest::SHA qw(sha256);

my ($vectors, $check) = ("vec$$.tmp", "chk$$.tmp");
END { 1 while unlink ($vectors, $check) }

my $numtests = 0;
my $fh = FileHandle->new($vectors, "w");
while (<DATA>) { print $fh $_; $numtests++ if /^MD\s*=/ }  close($fh);

$fh = FileHandle->new($check, "w+");
my $stdout = select($fh);
Crypt::SHAVS->new(\&sha256)->check($vectors);
select($stdout);

my $testnum = 1;
print "1..$numtests\n";
$fh->seek(0, 0);
while (<$fh>) {
	print "not " unless /OK\s*$/;
	print "ok ", $testnum++, "\n";
}
close($fh);

__DATA__
#  CAVS 11.0
#  "SHA-256 LongMsg" information 
#  SHA-256 tests are configured for BYTE oriented implementations
#  Generated on Tue Mar 15 08:23:38 2011

[L = 32]

Len = 1304
Msg = 451101250ec6f26652249d59dc974b7361d571a8101cdfd36aba3b5854d3ae086b5fdd4597721b66e3c0dc5d8c606d9657d0e323283a5217d1f53f2f284f57b85c8a61ac8924711f895c5ed90ef17745ed2d728abd22a5f7a13479a462d71b56c19a74a40b655c58edfe0a188ad2cf46cbf30524f65d423c837dd1ff2bf462ac4198007345bb44dbb7b1c861298cdf61982a833afc728fae1eda2f87aa2c9480858bec
MD = 3c593aa539fdcdae516cdf2f15000f6634185c88f505b39775fb9ab137a10aa2

Len = 2096
Msg = 6b918fb1a5ad1f9c5e5dbdf10a93a9c8f6bca89f37e79c9fe12a57227941b173ac79d8d440cde8c64c4ebc84a4c803d198a296f3de060900cc427f58ca6ec373084f95dd6c7c427ecfbf781f68be572a88dbcbb188581ab200bfb99a3a816407e7dd6dd21003554d4f7a99c93ebfce5c302ff0e11f26f83fe669acefb0c1bbb8b1e909bd14aa48ba3445c88b0e1190eef765ad898ab8ca2fe507015f1578f10dce3c11a55fb9434ee6e9ad6cc0fdc4684447a9b3b156b908646360f24fec2d8fa69e2c93db78708fcd2eef743dcb9353819b8d667c48ed54cd436fb1476598c4a1d7028e6f2ff50751db36ab6bc32435152a00abd3d58d9a8770d9a3e52d5a3628ae3c9e0325
MD = 46500b6ae1ab40bde097ef168b0f3199049b55545a1588792d39d594f493dca7

Len = 2888
Msg = 82829690aa3733c62b90d3297886952fc1dc473d67bb7d6bb299e088c65fc95ed3ca0f368d111d9fdcc9476cd4065efce7c481be598537f3f53bbbb6ff67973a69837454499e31398b463288e3aafb8b0600fdba1a25af806b83e1425f384e9eac7570f0c823981ba2cd3d868fba94648759623991e30f997c3bfb33d019150f0467a914f1eb79cd8727106dbf7d5310d0975943a6067cc79029b09239511417d922c7c7ac3dfdd8a41c52455b3c5e164b8289e141d820910f17a9668129743d936f7312e1604bc35f73ab164a3fddfe5fe19b1a4a9f237f61cb8eb792e95d099a1455fb789d8d1622f6c5e976cef951737e36f7a9a4ad19ee0d068e53d9f60457d9148d5a3ce85a546b45c5c631d995f11f037e472fe4e81fa7b9f2ac4068b5308858cd6d8586165c9bd6b322afa755408da9b90a87f3735a5f50eb8568daa58ee7cbc59abf8fd2a44e1eba72928816c890d1b0dbf6004208ff7381c697755adac0137cca342b1693
MD = 5f4e16a72d6c9857da0ba009ccacd4f26d7f6bf6c1b78a2ed35e68fcb15b8e40

Len = 3680
Msg = 5f664be0c0f3d2fc9a1a7ed6b515ef9c52ad1c7fb3acf2c2de943e109f91cc12ccadd041cc4386f95ab616cf8762ba25fed322fc8c351809e00c600a8f26e25a5bcd0bc3b44170947f65b4f417b8ac769187c2ee4561978289cced04c036c37f942ec10f7fd4d7f6908e22ed6cfd0fb89330c2fde417b956643aaca53baab8a8ff38bdcd35e60547159b26618e1b29128a35ebd2733fc4adf6bf6796076b09fd2554c6a4df5e40ae97f389f986f843ad00000515f9c001aec9c4e47e2c60fea78de8a33c8423d1539dfe125c5b7ea4b17cf8d86e7f84b88264afec06b370dfcebf5e1d3e2c1f005faf248b321593964587852b830c7231504fe947d6a385f399441cfc52df3914fa55cdba25bd215f91a80fc8ffa872b34113dbbd9504868331a38c081fa659574b186169db590f48be67fe75885b6c877d37ec16ebde5ad7be6414084e88670f7b7f485efcf44599f44cbbfbc62e48f62b438319823aeb3767101ec6868e4c85b113ea623193ab9a5ae0ac226328ee4674bf0a90ff1f20eb542e110870bfee01165ab03c2240299319aa3ab1045247bf7f34e8410d96e13aae465597b42336cad2de00b67602a7cb5832cd7253b239ab752a85f452a6166e9de0523bf9c20c2a0c274396d5
MD = 044d823532092c22a4b48181cfb2c796e1f5b98bcd713a21f70b5afcceef1d73
