use 5.008;
use strict;
use warnings;

package Task::Tiny;

our $AUTHORITY = 'cpan:TOBYINK';
our $VERSION   = '0.002';

1;

__END__

=pod

=encoding utf-8

=head1 NAME

Task::Tiny - install a lightweight development environment

=head1 DESCRIPTION

Task::Tiny may be used to install a selection of tiny Pel extensions
from the CPAN.

=head2 Utilities

General utilities.

=over

=item *

L<Exporter::Tiny>

=item *

L<Try::Tiny>

=item *

L<Config::Tiny>

=back

=head2 Objects

Framework for OO programming.

=over

=item *

L<Class::Tiny>

=item *

L<Class::Tiny::Antlers>

=item *

L<Role::Tiny>

=item *

L<Class::Method::Modifiers>

=back

=head2 Types

Type constraint framework.

=over

=item *

L<Type::Tiny>

=item *

L<Types::Path::Tiny>

=back

=head2 Filesys

File system manipulation.

=over

=item *

L<Path::Tiny>

=item *

L<Types::Path::Tiny>

=back

=head2 HTTP

Web stuff.

=over

=item *

L<HTTP::Tiny>

=back

=head2 JSON

JSON stuff.

=over

=item *

L<JSON::Tiny>

=back

=head2 YAML

YAML stuff.

=over

=item *

L<YAML::Tiny>

=back

=head1 BUGS

Please report any bugs to
L<http://rt.cpan.org/Dist/Display.html?Queue=Task-Tiny>.

=head1 SEE ALSO

L<Task>.

=head1 AUTHOR

Toby Inkster E<lt>tobyink@cpan.orgE<gt>.

=head1 COPYRIGHT AND LICENCE

This software is copyright (c) 2013 by Toby Inkster.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.


=head1 DISCLAIMER OF WARRANTIES

THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

