# Generated by default/object.tt
package Paws::SageMaker::ProcessingJob;
  use Moose;
  has AppSpecification => (is => 'ro', isa => 'Paws::SageMaker::AppSpecification');
  has AutoMLJobArn => (is => 'ro', isa => 'Str');
  has CreationTime => (is => 'ro', isa => 'Str');
  has Environment => (is => 'ro', isa => 'Paws::SageMaker::ProcessingEnvironmentMap');
  has ExitMessage => (is => 'ro', isa => 'Str');
  has ExperimentConfig => (is => 'ro', isa => 'Paws::SageMaker::ExperimentConfig');
  has FailureReason => (is => 'ro', isa => 'Str');
  has LastModifiedTime => (is => 'ro', isa => 'Str');
  has MonitoringScheduleArn => (is => 'ro', isa => 'Str');
  has NetworkConfig => (is => 'ro', isa => 'Paws::SageMaker::NetworkConfig');
  has ProcessingEndTime => (is => 'ro', isa => 'Str');
  has ProcessingInputs => (is => 'ro', isa => 'ArrayRef[Paws::SageMaker::ProcessingInput]');
  has ProcessingJobArn => (is => 'ro', isa => 'Str');
  has ProcessingJobName => (is => 'ro', isa => 'Str');
  has ProcessingJobStatus => (is => 'ro', isa => 'Str');
  has ProcessingOutputConfig => (is => 'ro', isa => 'Paws::SageMaker::ProcessingOutputConfig');
  has ProcessingResources => (is => 'ro', isa => 'Paws::SageMaker::ProcessingResources');
  has ProcessingStartTime => (is => 'ro', isa => 'Str');
  has RoleArn => (is => 'ro', isa => 'Str');
  has StoppingCondition => (is => 'ro', isa => 'Paws::SageMaker::ProcessingStoppingCondition');
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::SageMaker::Tag]');
  has TrainingJobArn => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ProcessingJob

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ProcessingJob object:

  $service_obj->Method(Att1 => { AppSpecification => $value, ..., TrainingJobArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ProcessingJob object:

  $result = $service_obj->Method(...);
  $result->Att1->AppSpecification

=head1 DESCRIPTION

An Amazon SageMaker processing job that is used to analyze data and
evaluate models. For more information, see Process Data and Evaluate
Models
(https://docs.aws.amazon.com/sagemaker/latest/dg/processing-job.html).

=head1 ATTRIBUTES


=head2 AppSpecification => L<Paws::SageMaker::AppSpecification>




=head2 AutoMLJobArn => Str

The Amazon Resource Name (ARN) of the AutoML job associated with this
processing job.


=head2 CreationTime => Str

The time the processing job was created.


=head2 Environment => L<Paws::SageMaker::ProcessingEnvironmentMap>

Sets the environment variables in the Docker container.


=head2 ExitMessage => Str

A string, up to one KB in size, that contains metadata from the
processing container when the processing job exits.


=head2 ExperimentConfig => L<Paws::SageMaker::ExperimentConfig>




=head2 FailureReason => Str

A string, up to one KB in size, that contains the reason a processing
job failed, if it failed.


=head2 LastModifiedTime => Str

The time the processing job was last modified.


=head2 MonitoringScheduleArn => Str

The ARN of a monitoring schedule for an endpoint associated with this
processing job.


=head2 NetworkConfig => L<Paws::SageMaker::NetworkConfig>




=head2 ProcessingEndTime => Str

The time that the processing job ended.


=head2 ProcessingInputs => ArrayRef[L<Paws::SageMaker::ProcessingInput>]

List of input configurations for the processing job.


=head2 ProcessingJobArn => Str

The ARN of the processing job.


=head2 ProcessingJobName => Str

The name of the processing job.


=head2 ProcessingJobStatus => Str

The status of the processing job.


=head2 ProcessingOutputConfig => L<Paws::SageMaker::ProcessingOutputConfig>




=head2 ProcessingResources => L<Paws::SageMaker::ProcessingResources>




=head2 ProcessingStartTime => Str

The time that the processing job started.


=head2 RoleArn => Str

The ARN of the role used to create the processing job.


=head2 StoppingCondition => L<Paws::SageMaker::ProcessingStoppingCondition>




=head2 Tags => ArrayRef[L<Paws::SageMaker::Tag>]

An array of key-value pairs. For more information, see Using Cost
Allocation Tags
(https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-whatURL)
in the I<Amazon Web Services Billing and Cost Management User Guide>.


=head2 TrainingJobArn => Str

The ARN of the training job associated with this processing job.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

