/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.FixedAttribute;
import net.sf.saxon.expr.instruct.FixedElement;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.instruct.UseAttributeSet;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.DocumentImpl;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;

public class LiteralResultElement
extends StyleElement {
    private NodeName resultNodeName;
    private NodeName[] attributeNames;
    private Expression[] attributeValues;
    private int numberOfAttributes;
    private boolean toplevel;
    private List<NamespaceBinding> namespaceCodes = new ArrayList<NamespaceBinding>();
    private StructuredQName[] attributeSets;
    private SchemaType schemaType = null;
    private int validation = 4;
    private boolean inheritNamespaces = true;

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        int num = atts.getLength();
        if (num == 0) {
            this.numberOfAttributes = 0;
        } else {
            NamePool namePool = this.getNamePool();
            this.attributeNames = new NodeName[num];
            this.attributeValues = new Expression[num];
            this.numberOfAttributes = 0;
            for (int i = 0; i < num; ++i) {
                Expression exp;
                int fp = atts.getFingerprint(i);
                String attURI = namePool.getURI(fp);
                if (attURI.equals("http://www.w3.org/1999/XSL/Transform")) {
                    if (fp == 236 || fp == 228 || fp == 229 || fp == 230 || fp == 233 || fp == 231 || fp == 232 || fp == 239 || fp == 240 || fp == 235 || fp == 237 || fp == 238) continue;
                    if (fp == 234) {
                        this.inheritNamespaces = this.processBooleanAttribute("xsl:inherit-namespaces", atts.getValue(i));
                        continue;
                    }
                    if (this.forwardsCompatibleModeIsEnabled()) continue;
                    this.compileError("Unknown XSLT attribute " + atts.getNodeName(i).getDisplayName(), "XTSE0805");
                    continue;
                }
                this.attributeNames[this.numberOfAttributes] = new FingerprintedQName(atts.getPrefix(i), atts.getURI(i), atts.getLocalName(i), fp);
                this.attributeValues[this.numberOfAttributes] = exp = this.makeAttributeValueTemplate(atts.getValue(i), i);
                ++this.numberOfAttributes;
            }
            if (this.numberOfAttributes < this.attributeNames.length) {
                this.attributeNames = Arrays.copyOf(this.attributeNames, this.numberOfAttributes);
                this.attributeValues = Arrays.copyOf(this.attributeValues, this.numberOfAttributes);
            }
        }
        this.resultNodeName = this.getNodeName();
    }

    public void validate(ComponentDeclaration decl) throws XPathException {
        this.toplevel = this.getParent() instanceof XSLStylesheet;
        this.resultNodeName = this.getNodeName();
        String elementURI = this.getURI();
        if (this.toplevel) {
            if (elementURI.isEmpty()) {
                this.compileError("Top level elements must have a non-null namespace URI", "XTSE0130");
            }
        } else {
            String validate;
            String useAttSets;
            Iterator<NamespaceBinding> inscope = NamespaceIterator.iterateNamespaces(this);
            while (inscope.hasNext()) {
                this.namespaceCodes.add(inscope.next());
            }
            PrincipalStylesheetModule sheet = this.getPrincipalStylesheetModule();
            if (sheet.hasNamespaceAliases()) {
                for (int i = 0; i < this.namespaceCodes.size(); ++i) {
                    String suri = this.namespaceCodes.get(i).getURI();
                    NamespaceBinding ncode = sheet.getNamespaceAlias(suri);
                    if (ncode == null || ncode.getURI().equals(suri)) continue;
                    this.namespaceCodes.set(i, ncode);
                }
                NamespaceBinding elementAlias = sheet.getNamespaceAlias(elementURI);
                if (elementAlias != null && !elementAlias.getURI().equals(elementURI)) {
                    this.resultNodeName = new FingerprintedQName(elementAlias.getPrefix(), elementAlias.getURI(), this.getLocalPart());
                }
            }
            if ((useAttSets = this.getAttributeValue("http://www.w3.org/1999/XSL/Transform", "use-attribute-sets")) != null) {
                this.attributeSets = this.getUsedAttributeSets(useAttSets);
            }
            this.validation = this.getDefaultValidation();
            String type = this.getAttributeValue("http://www.w3.org/1999/XSL/Transform", "type");
            if (type != null) {
                if (!this.isSchemaAware()) {
                    this.compileError("The xsl:type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
                }
                this.schemaType = this.getSchemaType(type);
                this.validation = 8;
            }
            if ((validate = this.getAttributeValue("http://www.w3.org/1999/XSL/Transform", "validation")) != null) {
                this.validation = this.validateValidationAttribute(validate);
                if (this.schemaType != null) {
                    this.compileError("The attributes xsl:type and xsl:validation are mutually exclusive", "XTSE1505");
                }
            }
            if (this.numberOfAttributes > 0) {
                for (int i = 0; i < this.numberOfAttributes; ++i) {
                    NamespaceBinding newBinding;
                    NodeName anameCode;
                    NodeName alias = anameCode = this.attributeNames[i];
                    String attURI = anameCode.getURI();
                    if (attURI.length() != 0 && (newBinding = sheet.getNamespaceAlias(attURI)) != null && !newBinding.getURI().equals(attURI)) {
                        alias = new FingerprintedQName(newBinding.getPrefix(), newBinding.getURI(), this.getAttributeList().getLocalName(i));
                    }
                    this.attributeNames[i] = alias;
                    this.attributeValues[i] = this.typeCheck(alias.getDisplayName(), this.attributeValues[i]);
                }
            }
            for (int n = this.namespaceCodes.size() - 1; n >= 0; --n) {
                String uri = this.namespaceCodes.get(n).getURI();
                if (!this.isExcludedNamespace(uri) || sheet.isAliasResultNamespace(uri)) continue;
                this.namespaceCodes.remove(n);
            }
        }
    }

    protected void validateChildren(ComponentDeclaration decl, boolean excludeStylesheet) throws XPathException {
        if (!this.toplevel) {
            super.validateChildren(decl, excludeStylesheet);
        }
    }

    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        if (this.toplevel) {
            return null;
        }
        NamespaceBinding[] bindings = this.namespaceCodes.toArray(new NamespaceBinding[this.namespaceCodes.size()]);
        FixedElement inst = new FixedElement(this.resultNodeName, bindings, this.inheritNamespaces, true, this.schemaType, this.validation);
        Expression content = this.compileSequenceConstructor(exec, decl, true);
        if (this.numberOfAttributes > 0) {
            for (int i = this.attributeNames.length - 1; i >= 0; --i) {
                FixedAttribute att = new FixedAttribute(this.attributeNames[i], 4, null);
                att.setRetainedStaticContext(this.makeRetainedStaticContext());
                att.setSelect(this.attributeValues[i]);
                att.setLocation(this.allocateLocation());
                Instruction exp = att;
                if (this.getConfiguration().isCompileWithTracing()) {
                    TraceExpression trace = new TraceExpression(exp);
                    trace.setNamespaceResolver(this.getNamespaceResolver());
                    trace.setConstructType(2007);
                    trace.setLocation(this.allocateLocation());
                    trace.setObjectName(this.attributeNames[i].getStructuredQName());
                    exp = trace;
                }
                if (content == null) {
                    content = exp;
                    continue;
                }
                content = Block.makeBlock(exp, content);
                content.setLocation(this.allocateLocation());
            }
        }
        if (this.attributeSets != null) {
            Expression use = UseAttributeSet.makeUseAttributeSets(this.attributeSets, this);
            if (content == null) {
                content = use;
            } else {
                content = Block.makeBlock(use, content);
                content.setLocation(this.allocateLocation());
            }
        }
        if (content == null) {
            content = Literal.makeEmptySequence();
        }
        inst.setContentExpression(content);
        inst.setRetainedStaticContext(this.makeRetainedStaticContext());
        return inst;
    }

    public DocumentImpl makeStylesheet(boolean topLevel) throws XPathException {
        StyleNodeFactory nodeFactory = this.getCompilation().getStyleNodeFactory(topLevel);
        if (!this.isInScopeNamespace("http://www.w3.org/1999/XSL/Transform")) {
            String message = this.getLocalPart().equals("stylesheet") || this.getLocalPart().equals("transform") ? "Namespace for stylesheet element should be http://www.w3.org/1999/XSL/Transform" : "The supplied file does not appear to be a stylesheet";
            XPathException err = new XPathException(message);
            err.setLocation(this.allocateLocation());
            err.setErrorCode("XTSE0150");
            err.setIsStaticError(true);
            this.compileError(err);
            throw err;
        }
        String version = this.getAttributeValue("http://www.w3.org/1999/XSL/Transform", "version");
        if (version == null) {
            XPathException err = new XPathException("Simplified stylesheet: xsl:version attribute is missing");
            err.setErrorCode("XTSE0150");
            err.setIsStaticError(true);
            err.setLocation(this.allocateLocation());
            this.compileError(err);
            throw err;
        }
        try {
            DocumentImpl oldRoot = (DocumentImpl)this.getRoot();
            LinkedTreeBuilder builder = new LinkedTreeBuilder(this.getConfiguration().makePipelineConfiguration());
            builder.setNodeFactory(nodeFactory);
            builder.setSystemId(this.getSystemId());
            builder.open();
            builder.startDocument(0);
            int st = 199;
            ExplicitLocation loc = ExplicitLocation.UNKNOWN_LOCATION;
            builder.startElement(new CodedName(st, "xsl", this.getNamePool()), Untyped.getInstance(), loc, 0);
            builder.namespace(new NamespaceBinding("xsl", "http://www.w3.org/1999/XSL/Transform"), 0);
            builder.attribute(new NoNamespaceName("version"), BuiltInAtomicType.UNTYPED_ATOMIC, version, loc, 0);
            builder.startContent();
            int te = 200;
            builder.startElement(new CodedName(te, "xsl", this.getNamePool()), Untyped.getInstance(), loc, 0);
            builder.attribute(new NoNamespaceName("match"), BuiltInAtomicType.UNTYPED_ATOMIC, "/", loc, 0);
            builder.startContent();
            builder.graftElement(this);
            builder.endElement();
            builder.endElement();
            builder.endDocument();
            builder.close();
            DocumentImpl newRoot = (DocumentImpl)builder.getCurrentRoot();
            newRoot.graftLocationMap(oldRoot);
            return newRoot;
        }
        catch (XPathException err) {
            err.setLocation(this.allocateLocation());
            throw err;
        }
    }

    public int getConstructType() {
        return 2006;
    }

    public StructuredQName getObjectName() {
        return new StructuredQName(this.getPrefix(), this.getURI(), this.getLocalPart());
    }

    public Object getProperty(String name) {
        if (name.equals("name")) {
            return this.getDisplayName();
        }
        return null;
    }
}

