#include "spvm_native.h"

#include <assert.h>

#ifdef _WIN32
# include <ws2tcpip.h>
# include <io.h>
#else
#include <sys/socket.h>
#include <sys/un.h>
#endif

const char* FILE_NAME = "Sys/Socket/Sockaddr/Un.c";

int32_t SPVM__Sys__Socket__Sockaddr__Un__new(SPVM_ENV* env, SPVM_VALUE* stack) {
#ifdef _WIN32
  env->die(env, stack, "The \"new\" method in the class \"Sys::Socket::Sockaddr::Un\" is not supported on this system", FILE_NAME, __LINE__);
  return SPVM_NATIVE_C_CLASS_ID_ERROR_NOT_SUPPORTED;
#else
  
  int32_t e = 0;
  
  struct sockaddr_un* socket_address = env->new_memory_stack(env, stack, sizeof(struct sockaddr_un));

  void* obj_socket_address = env->new_pointer_by_name(env, stack, "Sys::Socket::Sockaddr::Un", socket_address, &e, FILE_NAME, __LINE__);
  if (e) { return e; }
  
  stack[0].oval = obj_socket_address;
  
  return 0;
#endif
}

int32_t SPVM__Sys__Socket__Sockaddr__Un__DESTROY(SPVM_ENV* env, SPVM_VALUE* stack) {
#ifdef _WIN32
  env->die(env, stack, "The \"DESTROY\" method in the class \"Sys::Socket::Sockaddr::Un\" is not supported on this system", FILE_NAME, __LINE__);
  return SPVM_NATIVE_C_CLASS_ID_ERROR_NOT_SUPPORTED;
#else
  
  void* obj_socket_address = stack[0].oval;
  
  struct sockaddr_un* socket_address = env->get_pointer(env, stack, obj_socket_address);
  
  assert(socket_address);
  
  env->free_memory_stack(env, stack, socket_address);
  env->set_pointer(env, stack, obj_socket_address, NULL);
  
  return 0;
#endif
}

int32_t SPVM__Sys__Socket__Sockaddr__Un__sun_family(SPVM_ENV* env, SPVM_VALUE* stack) {
#ifdef _WIN32
  env->die(env, stack, "The \"sun_family\" method in the class \"Sys::Socket::Sockaddr::Un\" is not supported on this system", FILE_NAME, __LINE__);
  return SPVM_NATIVE_C_CLASS_ID_ERROR_NOT_SUPPORTED;
#else
  
  void* obj_self = stack[0].oval;
  
  struct sockaddr_un* socket_address = env->get_pointer(env, stack, obj_self);
  
  stack[0].bval = socket_address->sun_family;
  
  return 0;
#endif
}

int32_t SPVM__Sys__Socket__Sockaddr__Un__set_sun_family(SPVM_ENV* env, SPVM_VALUE* stack) {
#ifdef _WIN32
  env->die(env, stack, "The \"set_sun_family\" method in the class \"Sys::Socket::Sockaddr::Un\" is not supported on this system", FILE_NAME, __LINE__);
  return SPVM_NATIVE_C_CLASS_ID_ERROR_NOT_SUPPORTED;
#else
  
  void* obj_self = stack[0].oval;
  
  struct sockaddr_un* socket_address = env->get_pointer(env, stack, obj_self);
  
  socket_address->sun_family = stack[1].bval;
  
  return 0;
#endif
}

int32_t SPVM__Sys__Socket__Sockaddr__Un__sun_path(SPVM_ENV* env, SPVM_VALUE* stack) {
#ifdef _WIN32
  env->die(env, stack, "The \"sun_path\" method in the class \"Sys::Socket::Sockaddr::Un\" is not supported on this system", FILE_NAME, __LINE__);
  return SPVM_NATIVE_C_CLASS_ID_ERROR_NOT_SUPPORTED;
#else
  
  void* obj_self = stack[0].oval;
  
  struct sockaddr_un* socket_address = env->get_pointer(env, stack, obj_self);
  
  void* obj_path;
  if (socket_address->sun_path) {
    obj_path = env->new_string(env, stack, socket_address->sun_path, strlen(socket_address->sun_path));
  }
  else {
    obj_path = NULL;
  };
  
  stack[0].oval = obj_path;
  
  return 0;
#endif
}

int32_t SPVM__Sys__Socket__Sockaddr__Un__set_sun_path(SPVM_ENV* env, SPVM_VALUE* stack) {
#ifdef _WIN32
  env->die(env, stack, "The \"set_sun_path\" method in the class \"Sys::Socket::Sockaddr::Un\" is not supported on this system", FILE_NAME, __LINE__);
  return SPVM_NATIVE_C_CLASS_ID_ERROR_NOT_SUPPORTED;
#else
  
  void* obj_self = stack[0].oval;
  
  struct sockaddr_un* socket_address = env->get_pointer(env, stack, obj_self);
  
  void* obj_path = stack[1].oval;
  
  const char* path = env->get_chars(env, stack, obj_path);
  int32_t path_length = env->length(env, stack, obj_path);
  
  memset(socket_address->sun_path, 0, strlen(socket_address->sun_path));
  memcpy(socket_address->sun_path, path, path_length);
  
  return 0;
#endif
}

int32_t SPVM__Sys__Socket__Sockaddr__Un__sizeof(SPVM_ENV* env, SPVM_VALUE* stack) {
#ifdef _WIN32
  env->die(env, stack, "The \"sizeof\" method in the class \"Sys::Socket::Sockaddr::Un\" is not supported on this system", FILE_NAME, __LINE__);
  return SPVM_NATIVE_C_CLASS_ID_ERROR_NOT_SUPPORTED;
#else
  
  void* obj_self = stack[0].oval;
  
  stack[0].ival = sizeof(struct sockaddr_un);
  
  return 0;
#endif
}
