######################################################################
#
# JISX0208GL_by_CP932.pl
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib $FindBin::Bin;

require 'JIS/not_JIS78.pl';

my %JISX0208GL_by_CP932 = (
    '00' => {qw( 40   0 41   1 42   2 43   3 44   4 45   5 46   6 47   7 48   8 49   9 4A  10 4B  11 4C  12 4D  13 4E  14 4F  15 50  16 51  17 52  18 53  19 54  20 55  21 56  22 57  23 58  24 59  25 5A  26 5B  27 5C  28 5D  29 5E  30 5F  31 60  32 61  33 62  34 63  35 64  36 65  37 66  38 67  39 68  40 69  41 6A  42 6B  43 6C  44 6D  45 6E  46 6F  47 70  48 71  49 72  50 73  51 74  52 75  53 76  54 77  55 78  56 79  57 7A  58 7B  59 7C  60 7D  61 7E  62 80  63 81  64 82  65 83  66 84  67 85  68 86  69 87  70 88  71 89  72 8A  73 8B  74 8C  75 8D  76 8E  77 8F  78 90  79 91  80 92  81 93  82 94  83 95  84 96  85 97  86 98  87 99  88 9A  89 9B  90 9C  91 9D  92 9E  93 9F  94 A0  95 A1  96 A2  97 A3  98 A4  99 A5 100 A6 101 A7 102 A8 103 A9 104 AA 105 AB 106 AC 107 AD 108 AE 109 AF 110 B0 111 B1 112 B2 113 B3 114 B4 115 B5 116 B6 117 B7 118 B8 119 B9 120 BA 121 BB 122 BC 123 BD 124 BE 125 BF 126 C0 127 C1 128 C2 129 C3 130 C4 131 C5 132 C6 133 C7 134 C8 135 C9 136 CA 137 CB 138 CC 139 CD 140 CE 141 CF 142 D0 143 D1 144 D2 145 D3 146 D4 147 D5 148 D6 149 D7 150 D8 151 D9 152 DA 153 DB 154 DC 155 DD 156 DE 157 DF 158 E0 159 E1 160 E2 161 E3 162 E4 163 E5 164 E6 165 E7 166 E8 167 E9 168 EA 169 EB 170 EC 171 ED 172 EE 173 EF 174 F0 175 F1 176 F2 177 F3 178 F4 179 F5 180 F6 181 F7 182 F8 183 F9 184 FA 185 FB 186 FC 187 )},
    '81' => [qw( 2121   2122   2123   2124   2125   2126   2127   2128   2129   212A   212B   212C   212D   212E   212F   2130   2131   2132   2133   2134   2135   2136   2137   2138   2139   213A   213B   213C   213D   213E   213F   2140   2141   2142   2143   2144   2145   2146   2147   2148   2149   214A   214B   214C   214D   214E   214F   2150   2151   2152   2153   2154   2155   2156   2157   2158   2159   215A   215B   215C   215D   215E   215F   2160   2161   2162   2163   2164   2165   2166   2167   2168   2169   216A   216B   216C   216D   216E   216F   2170   2171   2172   2173   2174   2175   2176   2177   2178   2179   217A   217B   217C   217D   217E   2221   2222   2223   2224   2225   2226   2227   2228   2229   222A   222B   222C   222D   222E   222F   2230   2231   2232   2233   2234   2235   2236   2237   2238   2239   223A   223B   223C   223D   223E   223F   2240   2241   2242   2243   2244   2245   2246   2247   2248   2249   224A   224B   224C   224D   224E   224F   2250   2251   2252   2253   2254   2255   2256   2257   2258   2259   225A   225B   225C   225D   225E   225F   2260   2261   2262   2263   2264   2265   2266   2267   2268   2269   226A   226B   226C   226D   226E   226F   2270   2271   2272   2273   2274   2275   2276   2277   2278   2279   227A   227B   227C   227D   227E   )],
    '82' => [qw( 2321   2322   2323   2324   2325   2326   2327   2328   2329   232A   232B   232C   232D   232E   232F   2330   2331   2332   2333   2334   2335   2336   2337   2338   2339   233A   233B   233C   233D   233E   233F   2340   2341   2342   2343   2344   2345   2346   2347   2348   2349   234A   234B   234C   234D   234E   234F   2350   2351   2352   2353   2354   2355   2356   2357   2358   2359   235A   235B   235C   235D   235E   235F   2360   2361   2362   2363   2364   2365   2366   2367   2368   2369   236A   236B   236C   236D   236E   236F   2370   2371   2372   2373   2374   2375   2376   2377   2378   2379   237A   237B   237C   237D   237E   2421   2422   2423   2424   2425   2426   2427   2428   2429   242A   242B   242C   242D   242E   242F   2430   2431   2432   2433   2434   2435   2436   2437   2438   2439   243A   243B   243C   243D   243E   243F   2440   2441   2442   2443   2444   2445   2446   2447   2448   2449   244A   244B   244C   244D   244E   244F   2450   2451   2452   2453   2454   2455   2456   2457   2458   2459   245A   245B   245C   245D   245E   245F   2460   2461   2462   2463   2464   2465   2466   2467   2468   2469   246A   246B   246C   246D   246E   246F   2470   2471   2472   2473   2474   2475   2476   2477   2478   2479   247A   247B   247C   247D   247E   )],
    '83' => [qw( 2521   2522   2523   2524   2525   2526   2527   2528   2529   252A   252B   252C   252D   252E   252F   2530   2531   2532   2533   2534   2535   2536   2537   2538   2539   253A   253B   253C   253D   253E   253F   2540   2541   2542   2543   2544   2545   2546   2547   2548   2549   254A   254B   254C   254D   254E   254F   2550   2551   2552   2553   2554   2555   2556   2557   2558   2559   255A   255B   255C   255D   255E   255F   2560   2561   2562   2563   2564   2565   2566   2567   2568   2569   256A   256B   256C   256D   256E   256F   2570   2571   2572   2573   2574   2575   2576   2577   2578   2579   257A   257B   257C   257D   257E   2621   2622   2623   2624   2625   2626   2627   2628   2629   262A   262B   262C   262D   262E   262F   2630   2631   2632   2633   2634   2635   2636   2637   2638   2639   263A   263B   263C   263D   263E   263F   2640   2641   2642   2643   2644   2645   2646   2647   2648   2649   264A   264B   264C   264D   264E   264F   2650   2651   2652   2653   2654   2655   2656   2657   2658   2659   265A   265B   265C   265D   265E   265F   2660   2661   2662   2663   2664   2665   2666   2667   2668   2669   266A   266B   266C   266D   266E   266F   2670   2671   2672   2673   2674   2675   2676   2677   2678   2679   267A   267B   267C   267D   267E   )],
    '84' => [qw( 2721   2722   2723   2724   2725   2726   2727   2728   2729   272A   272B   272C   272D   272E   272F   2730   2731   2732   2733   2734   2735   2736   2737   2738   2739   273A   273B   273C   273D   273E   273F   2740   2741   2742   2743   2744   2745   2746   2747   2748   2749   274A   274B   274C   274D   274E   274F   2750   2751   2752   2753   2754   2755   2756   2757   2758   2759   275A   275B   275C   275D   275E   275F   2760   2761   2762   2763   2764   2765   2766   2767   2768   2769   276A   276B   276C   276D   276E   276F   2770   2771   2772   2773   2774   2775   2776   2777   2778   2779   277A   277B   277C   277D   277E   2821   2822   2823   2824   2825   2826   2827   2828   2829   282A   282B   282C   282D   282E   282F   2830   2831   2832   2833   2834   2835   2836   2837   2838   2839   283A   283B   283C   283D   283E   283F   2840   2841   2842   2843   2844   2845   2846   2847   2848   2849   284A   284B   284C   284D   284E   284F   2850   2851   2852   2853   2854   2855   2856   2857   2858   2859   285A   285B   285C   285D   285E   285F   2860   2861   2862   2863   2864   2865   2866   2867   2868   2869   286A   286B   286C   286D   286E   286F   2870   2871   2872   2873   2874   2875   2876   2877   2878   2879   287A   287B   287C   287D   287E   )],
    '85' => [qw( 2921   2922   2923   2924   2925   2926   2927   2928   2929   292A   292B   292C   292D   292E   292F   2930   2931   2932   2933   2934   2935   2936   2937   2938   2939   293A   293B   293C   293D   293E   293F   2940   2941   2942   2943   2944   2945   2946   2947   2948   2949   294A   294B   294C   294D   294E   294F   2950   2951   2952   2953   2954   2955   2956   2957   2958   2959   295A   295B   295C   295D   295E   295F   2960   2961   2962   2963   2964   2965   2966   2967   2968   2969   296A   296B   296C   296D   296E   296F   2970   2971   2972   2973   2974   2975   2976   2977   2978   2979   297A   297B   297C   297D   297E   2A21   2A22   2A23   2A24   2A25   2A26   2A27   2A28   2A29   2A2A   2A2B   2A2C   2A2D   2A2E   2A2F   2A30   2A31   2A32   2A33   2A34   2A35   2A36   2A37   2A38   2A39   2A3A   2A3B   2A3C   2A3D   2A3E   2A3F   2A40   2A41   2A42   2A43   2A44   2A45   2A46   2A47   2A48   2A49   2A4A   2A4B   2A4C   2A4D   2A4E   2A4F   2A50   2A51   2A52   2A53   2A54   2A55   2A56   2A57   2A58   2A59   2A5A   2A5B   2A5C   2A5D   2A5E   2A5F   2A60   2A61   2A62   2A63   2A64   2A65   2A66   2A67   2A68   2A69   2A6A   2A6B   2A6C   2A6D   2A6E   2A6F   2A70   2A71   2A72   2A73   2A74   2A75   2A76   2A77   2A78   2A79   2A7A   2A7B   2A7C   2A7D   2A7E   )],
    '86' => [qw( 2B21   2B22   2B23   2B24   2B25   2B26   2B27   2B28   2B29   2B2A   2B2B   2B2C   2B2D   2B2E   2B2F   2B30   2B31   2B32   2B33   2B34   2B35   2B36   2B37   2B38   2B39   2B3A   2B3B   2B3C   2B3D   2B3E   2B3F   2B40   2B41   2B42   2B43   2B44   2B45   2B46   2B47   2B48   2B49   2B4A   2B4B   2B4C   2B4D   2B4E   2B4F   2B50   2B51   2B52   2B53   2B54   2B55   2B56   2B57   2B58   2B59   2B5A   2B5B   2B5C   2B5D   2B5E   2B5F   2B60   2B61   2B62   2B63   2B64   2B65   2B66   2B67   2B68   2B69   2B6A   2B6B   2B6C   2B6D   2B6E   2B6F   2B70   2B71   2B72   2B73   2B74   2B75   2B76   2B77   2B78   2B79   2B7A   2B7B   2B7C   2B7D   2B7E   2C21   2C22   2C23   2C24   2C25   2C26   2C27   2C28   2C29   2C2A   2C2B   2C2C   2C2D   2C2E   2C2F   2C30   2C31   2C32   2C33   2C34   2C35   2C36   2C37   2C38   2C39   2C3A   2C3B   2C3C   2C3D   2C3E   2C3F   2C40   2C41   2C42   2C43   2C44   2C45   2C46   2C47   2C48   2C49   2C4A   2C4B   2C4C   2C4D   2C4E   2C4F   2C50   2C51   2C52   2C53   2C54   2C55   2C56   2C57   2C58   2C59   2C5A   2C5B   2C5C   2C5D   2C5E   2C5F   2C60   2C61   2C62   2C63   2C64   2C65   2C66   2C67   2C68   2C69   2C6A   2C6B   2C6C   2C6D   2C6E   2C6F   2C70   2C71   2C72   2C73   2C74   2C75   2C76   2C77   2C78   2C79   2C7A   2C7B   2C7C   2C7D   2C7E   )],
    '87' => [qw( 2D21   2D22   2D23   2D24   2D25   2D26   2D27   2D28   2D29   2D2A   2D2B   2D2C   2D2D   2D2E   2D2F   2D30   2D31   2D32   2D33   2D34   2D35   2D36   2D37   2D38   2D39   2D3A   2D3B   2D3C   2D3D   2D3E   2D3F   2D40   2D41   2D42   2D43   2D44   2D45   2D46   2D47   2D48   2D49   2D4A   2D4B   2D4C   2D4D   2D4E   2D4F   2D50   2D51   2D52   2D53   2D54   2D55   2D56   2D57   2D58   2D59   2D5A   2D5B   2D5C   2D5D   2D5E   2D5F   2D60   2D61   2D62   2D63   2D64   2D65   2D66   2D67   2D68   2D69   2D6A   2D6B   2D6C   2D6D   2D6E   2D6F   2D70   2D71   2D72   2D73   2D74   2D75   2D76   2D77   2D78   2D79   2D7A   2D7B   2D7C   2D7D   2D7E   2E21   2E22   2E23   2E24   2E25   2E26   2E27   2E28   2E29   2E2A   2E2B   2E2C   2E2D   2E2E   2E2F   2E30   2E31   2E32   2E33   2E34   2E35   2E36   2E37   2E38   2E39   2E3A   2E3B   2E3C   2E3D   2E3E   2E3F   2E40   2E41   2E42   2E43   2E44   2E45   2E46   2E47   2E48   2E49   2E4A   2E4B   2E4C   2E4D   2E4E   2E4F   2E50   2E51   2E52   2E53   2E54   2E55   2E56   2E57   2E58   2E59   2E5A   2E5B   2E5C   2E5D   2E5E   2E5F   2E60   2E61   2E62   2E63   2E64   2E65   2E66   2E67   2E68   2E69   2E6A   2E6B   2E6C   2E6D   2E6E   2E6F   2E70   2E71   2E72   2E73   2E74   2E75   2E76   2E77   2E78   2E79   2E7A   2E7B   2E7C   2E7D   2E7E   )],
    '88' => [qw( 2F21   2F22   2F23   2F24   2F25   2F26   2F27   2F28   2F29   2F2A   2F2B   2F2C   2F2D   2F2E   2F2F   2F30   2F31   2F32   2F33   2F34   2F35   2F36   2F37   2F38   2F39   2F3A   2F3B   2F3C   2F3D   2F3E   2F3F   2F40   2F41   2F42   2F43   2F44   2F45   2F46   2F47   2F48   2F49   2F4A   2F4B   2F4C   2F4D   2F4E   2F4F   2F50   2F51   2F52   2F53   2F54   2F55   2F56   2F57   2F58   2F59   2F5A   2F5B   2F5C   2F5D   2F5E   2F5F   2F60   2F61   2F62   2F63   2F64   2F65   2F66   2F67   2F68   2F69   2F6A   2F6B   2F6C   2F6D   2F6E   2F6F   2F70   2F71   2F72   2F73   2F74   2F75   2F76   2F77   2F78   2F79   2F7A   2F7B   2F7C   2F7D   2F7E   3021   3022   3023   3024   3025   3026   3027   3028   3029   302A   302B   302C   302D   302E   302F   3030   3031   3032   3033   3034   3035   3036   3037   3038   3039   303A   303B   303C   303D   303E   303F   3040   3041   3042   3043   3044   3045   3046   3047   3048   3049   304A   304B   304C   304D   304E   304F   3050   3051   3052   3053   3054   3055   3056   3057   3058   3059   305A   305B   305C   305D   305E   305F   3060   3061   3062   3063   3064   3065   3066   3067   3068   3069   306A   306B   306C   306D   306E   306F   3070   3071   3072   3073   3074   3075   3076   3077   3078   3079   307A   307B   307C   307D   307E   )],
    '89' => [qw( 3121   3122   3123   3124   3125   3126   3127   3128   3129   312A   312B   312C   312D   312E   312F   3130   3131   3132   3133   3134   3135   3136   3137   3138   3139   313A   313B   313C   313D   313E   313F   3140   3141   3142   3143   3144   3145   3146   3147   3148   3149   314A   314B   314C   314D   314E   314F   3150   3151   3152   3153   3154   3155   3156   3157   3158   3159   315A   315B   315C   315D   315E   315F   3160   3161   3162   3163   3164   3165   3166   3167   3168   3169   316A   316B   316C   316D   316E   316F   3170   3171   3172   3173   3174   3175   3176   3177   3178   3179   317A   317B   317C   317D   317E   3221   3222   3223   3224   3225   3226   3227   3228   3229   322A   322B   322C   322D   322E   322F   3230   3231   3232   3233   3234   3235   3236   3237   3238   3239   323A   323B   323C   323D   323E   323F   3240   3241   3242   3243   3244   3245   3246   3247   3248   3249   324A   324B   324C   324D   324E   324F   3250   3251   3252   3253   3254   3255   3256   3257   3258   3259   325A   325B   325C   325D   325E   325F   3260   3261   3262   3263   3264   3265   3266   3267   3268   3269   326A   326B   326C   326D   326E   326F   3270   3271   3272   3273   3274   3275   3276   3277   3278   3279   327A   327B   327C   327D   327E   )],
    '8A' => [qw( 3321   3322   3323   3324   3325   3326   3327   3328   3329   332A   332B   332C   332D   332E   332F   3330   3331   3332   3333   3334   3335   3336   3337   3338   3339   333A   333B   333C   333D   333E   333F   3340   3341   3342   3343   3344   3345   3346   3347   3348   3349   334A   334B   334C   334D   334E   334F   3350   3351   3352   3353   3354   3355   3356   3357   3358   3359   335A   335B   335C   335D   335E   335F   3360   3361   3362   3363   3364   3365   3366   3367   3368   3369   336A   336B   336C   336D   336E   336F   3370   3371   3372   3373   3374   3375   3376   3377   3378   3379   337A   337B   337C   337D   337E   3421   3422   3423   3424   3425   3426   3427   3428   3429   342A   342B   342C   342D   342E   342F   3430   3431   3432   3433   3434   3435   3436   3437   3438   3439   343A   343B   343C   343D   343E   343F   3440   3441   3442   3443   3444   3445   3446   3447   3448   3449   344A   344B   344C   344D   344E   344F   3450   3451   3452   3453   3454   3455   3456   3457   3458   3459   345A   345B   345C   345D   345E   345F   3460   3461   3462   3463   3464   3465   3466   3467   3468   3469   346A   346B   346C   346D   346E   346F   3470   3471   3472   3473   3474   3475   3476   3477   3478   3479   347A   347B   347C   347D   347E   )],
    '8B' => [qw( 3521   3522   3523   3524   3525   3526   3527   3528   3529   352A   352B   352C   352D   352E   352F   3530   3531   3532   3533   3534   3535   3536   3537   3538   3539   353A   353B   353C   353D   353E   353F   3540   3541   3542   3543   3544   3545   3546   3547   3548   3549   354A   354B   354C   354D   354E   354F   3550   3551   3552   3553   3554   3555   3556   3557   3558   3559   355A   355B   355C   355D   355E   355F   3560   3561   3562   3563   3564   3565   3566   3567   3568   3569   356A   356B   356C   356D   356E   356F   3570   3571   3572   3573   3574   3575   3576   3577   3578   3579   357A   357B   357C   357D   357E   3621   3622   3623   3624   3625   3626   3627   3628   3629   362A   362B   362C   362D   362E   362F   3630   3631   3632   3633   3634   3635   3636   3637   3638   3639   363A   363B   363C   363D   363E   363F   3640   3641   3642   3643   3644   3645   3646   3647   3648   3649   364A   364B   364C   364D   364E   364F   3650   3651   3652   3653   3654   3655   3656   3657   3658   3659   365A   365B   365C   365D   365E   365F   3660   3661   3662   3663   3664   3665   3666   3667   3668   3669   366A   366B   366C   366D   366E   366F   3670   3671   3672   3673   3674   3675   3676   3677   3678   3679   367A   367B   367C   367D   367E   )],
    '8C' => [qw( 3721   3722   3723   3724   3725   3726   3727   3728   3729   372A   372B   372C   372D   372E   372F   3730   3731   3732   3733   3734   3735   3736   3737   3738   3739   373A   373B   373C   373D   373E   373F   3740   3741   3742   3743   3744   3745   3746   3747   3748   3749   374A   374B   374C   374D   374E   374F   3750   3751   3752   3753   3754   3755   3756   3757   3758   3759   375A   375B   375C   375D   375E   375F   3760   3761   3762   3763   3764   3765   3766   3767   3768   3769   376A   376B   376C   376D   376E   376F   3770   3771   3772   3773   3774   3775   3776   3777   3778   3779   377A   377B   377C   377D   377E   3821   3822   3823   3824   3825   3826   3827   3828   3829   382A   382B   382C   382D   382E   382F   3830   3831   3832   3833   3834   3835   3836   3837   3838   3839   383A   383B   383C   383D   383E   383F   3840   3841   3842   3843   3844   3845   3846   3847   3848   3849   384A   384B   384C   384D   384E   384F   3850   3851   3852   3853   3854   3855   3856   3857   3858   3859   385A   385B   385C   385D   385E   385F   3860   3861   3862   3863   3864   3865   3866   3867   3868   3869   386A   386B   386C   386D   386E   386F   3870   3871   3872   3873   3874   3875   3876   3877   3878   3879   387A   387B   387C   387D   387E   )],
    '8D' => [qw( 3921   3922   3923   3924   3925   3926   3927   3928   3929   392A   392B   392C   392D   392E   392F   3930   3931   3932   3933   3934   3935   3936   3937   3938   3939   393A   393B   393C   393D   393E   393F   3940   3941   3942   3943   3944   3945   3946   3947   3948   3949   394A   394B   394C   394D   394E   394F   3950   3951   3952   3953   3954   3955   3956   3957   3958   3959   395A   395B   395C   395D   395E   395F   3960   3961   3962   3963   3964   3965   3966   3967   3968   3969   396A   396B   396C   396D   396E   396F   3970   3971   3972   3973   3974   3975   3976   3977   3978   3979   397A   397B   397C   397D   397E   3A21   3A22   3A23   3A24   3A25   3A26   3A27   3A28   3A29   3A2A   3A2B   3A2C   3A2D   3A2E   3A2F   3A30   3A31   3A32   3A33   3A34   3A35   3A36   3A37   3A38   3A39   3A3A   3A3B   3A3C   3A3D   3A3E   3A3F   3A40   3A41   3A42   3A43   3A44   3A45   3A46   3A47   3A48   3A49   3A4A   3A4B   3A4C   3A4D   3A4E   3A4F   3A50   3A51   3A52   3A53   3A54   3A55   3A56   3A57   3A58   3A59   3A5A   3A5B   3A5C   3A5D   3A5E   3A5F   3A60   3A61   3A62   3A63   3A64   3A65   3A66   3A67   3A68   3A69   3A6A   3A6B   3A6C   3A6D   3A6E   3A6F   3A70   3A71   3A72   3A73   3A74   3A75   3A76   3A77   3A78   3A79   3A7A   3A7B   3A7C   3A7D   3A7E   )],
    '8E' => [qw( 3B21   3B22   3B23   3B24   3B25   3B26   3B27   3B28   3B29   3B2A   3B2B   3B2C   3B2D   3B2E   3B2F   3B30   3B31   3B32   3B33   3B34   3B35   3B36   3B37   3B38   3B39   3B3A   3B3B   3B3C   3B3D   3B3E   3B3F   3B40   3B41   3B42   3B43   3B44   3B45   3B46   3B47   3B48   3B49   3B4A   3B4B   3B4C   3B4D   3B4E   3B4F   3B50   3B51   3B52   3B53   3B54   3B55   3B56   3B57   3B58   3B59   3B5A   3B5B   3B5C   3B5D   3B5E   3B5F   3B60   3B61   3B62   3B63   3B64   3B65   3B66   3B67   3B68   3B69   3B6A   3B6B   3B6C   3B6D   3B6E   3B6F   3B70   3B71   3B72   3B73   3B74   3B75   3B76   3B77   3B78   3B79   3B7A   3B7B   3B7C   3B7D   3B7E   3C21   3C22   3C23   3C24   3C25   3C26   3C27   3C28   3C29   3C2A   3C2B   3C2C   3C2D   3C2E   3C2F   3C30   3C31   3C32   3C33   3C34   3C35   3C36   3C37   3C38   3C39   3C3A   3C3B   3C3C   3C3D   3C3E   3C3F   3C40   3C41   3C42   3C43   3C44   3C45   3C46   3C47   3C48   3C49   3C4A   3C4B   3C4C   3C4D   3C4E   3C4F   3C50   3C51   3C52   3C53   3C54   3C55   3C56   3C57   3C58   3C59   3C5A   3C5B   3C5C   3C5D   3C5E   3C5F   3C60   3C61   3C62   3C63   3C64   3C65   3C66   3C67   3C68   3C69   3C6A   3C6B   3C6C   3C6D   3C6E   3C6F   3C70   3C71   3C72   3C73   3C74   3C75   3C76   3C77   3C78   3C79   3C7A   3C7B   3C7C   3C7D   3C7E   )],
    '8F' => [qw( 3D21   3D22   3D23   3D24   3D25   3D26   3D27   3D28   3D29   3D2A   3D2B   3D2C   3D2D   3D2E   3D2F   3D30   3D31   3D32   3D33   3D34   3D35   3D36   3D37   3D38   3D39   3D3A   3D3B   3D3C   3D3D   3D3E   3D3F   3D40   3D41   3D42   3D43   3D44   3D45   3D46   3D47   3D48   3D49   3D4A   3D4B   3D4C   3D4D   3D4E   3D4F   3D50   3D51   3D52   3D53   3D54   3D55   3D56   3D57   3D58   3D59   3D5A   3D5B   3D5C   3D5D   3D5E   3D5F   3D60   3D61   3D62   3D63   3D64   3D65   3D66   3D67   3D68   3D69   3D6A   3D6B   3D6C   3D6D   3D6E   3D6F   3D70   3D71   3D72   3D73   3D74   3D75   3D76   3D77   3D78   3D79   3D7A   3D7B   3D7C   3D7D   3D7E   3E21   3E22   3E23   3E24   3E25   3E26   3E27   3E28   3E29   3E2A   3E2B   3E2C   3E2D   3E2E   3E2F   3E30   3E31   3E32   3E33   3E34   3E35   3E36   3E37   3E38   3E39   3E3A   3E3B   3E3C   3E3D   3E3E   3E3F   3E40   3E41   3E42   3E43   3E44   3E45   3E46   3E47   3E48   3E49   3E4A   3E4B   3E4C   3E4D   3E4E   3E4F   3E50   3E51   3E52   3E53   3E54   3E55   3E56   3E57   3E58   3E59   3E5A   3E5B   3E5C   3E5D   3E5E   3E5F   3E60   3E61   3E62   3E63   3E64   3E65   3E66   3E67   3E68   3E69   3E6A   3E6B   3E6C   3E6D   3E6E   3E6F   3E70   3E71   3E72   3E73   3E74   3E75   3E76   3E77   3E78   3E79   3E7A   3E7B   3E7C   3E7D   3E7E   )],
    '90' => [qw( 3F21   3F22   3F23   3F24   3F25   3F26   3F27   3F28   3F29   3F2A   3F2B   3F2C   3F2D   3F2E   3F2F   3F30   3F31   3F32   3F33   3F34   3F35   3F36   3F37   3F38   3F39   3F3A   3F3B   3F3C   3F3D   3F3E   3F3F   3F40   3F41   3F42   3F43   3F44   3F45   3F46   3F47   3F48   3F49   3F4A   3F4B   3F4C   3F4D   3F4E   3F4F   3F50   3F51   3F52   3F53   3F54   3F55   3F56   3F57   3F58   3F59   3F5A   3F5B   3F5C   3F5D   3F5E   3F5F   3F60   3F61   3F62   3F63   3F64   3F65   3F66   3F67   3F68   3F69   3F6A   3F6B   3F6C   3F6D   3F6E   3F6F   3F70   3F71   3F72   3F73   3F74   3F75   3F76   3F77   3F78   3F79   3F7A   3F7B   3F7C   3F7D   3F7E   4021   4022   4023   4024   4025   4026   4027   4028   4029   402A   402B   402C   402D   402E   402F   4030   4031   4032   4033   4034   4035   4036   4037   4038   4039   403A   403B   403C   403D   403E   403F   4040   4041   4042   4043   4044   4045   4046   4047   4048   4049   404A   404B   404C   404D   404E   404F   4050   4051   4052   4053   4054   4055   4056   4057   4058   4059   405A   405B   405C   405D   405E   405F   4060   4061   4062   4063   4064   4065   4066   4067   4068   4069   406A   406B   406C   406D   406E   406F   4070   4071   4072   4073   4074   4075   4076   4077   4078   4079   407A   407B   407C   407D   407E   )],
    '91' => [qw( 4121   4122   4123   4124   4125   4126   4127   4128   4129   412A   412B   412C   412D   412E   412F   4130   4131   4132   4133   4134   4135   4136   4137   4138   4139   413A   413B   413C   413D   413E   413F   4140   4141   4142   4143   4144   4145   4146   4147   4148   4149   414A   414B   414C   414D   414E   414F   4150   4151   4152   4153   4154   4155   4156   4157   4158   4159   415A   415B   415C   415D   415E   415F   4160   4161   4162   4163   4164   4165   4166   4167   4168   4169   416A   416B   416C   416D   416E   416F   4170   4171   4172   4173   4174   4175   4176   4177   4178   4179   417A   417B   417C   417D   417E   4221   4222   4223   4224   4225   4226   4227   4228   4229   422A   422B   422C   422D   422E   422F   4230   4231   4232   4233   4234   4235   4236   4237   4238   4239   423A   423B   423C   423D   423E   423F   4240   4241   4242   4243   4244   4245   4246   4247   4248   4249   424A   424B   424C   424D   424E   424F   4250   4251   4252   4253   4254   4255   4256   4257   4258   4259   425A   425B   425C   425D   425E   425F   4260   4261   4262   4263   4264   4265   4266   4267   4268   4269   426A   426B   426C   426D   426E   426F   4270   4271   4272   4273   4274   4275   4276   4277   4278   4279   427A   427B   427C   427D   427E   )],
    '92' => [qw( 4321   4322   4323   4324   4325   4326   4327   4328   4329   432A   432B   432C   432D   432E   432F   4330   4331   4332   4333   4334   4335   4336   4337   4338   4339   433A   433B   433C   433D   433E   433F   4340   4341   4342   4343   4344   4345   4346   4347   4348   4349   434A   434B   434C   434D   434E   434F   4350   4351   4352   4353   4354   4355   4356   4357   4358   4359   435A   435B   435C   435D   435E   435F   4360   4361   4362   4363   4364   4365   4366   4367   4368   4369   436A   436B   436C   436D   436E   436F   4370   4371   4372   4373   4374   4375   4376   4377   4378   4379   437A   437B   437C   437D   437E   4421   4422   4423   4424   4425   4426   4427   4428   4429   442A   442B   442C   442D   442E   442F   4430   4431   4432   4433   4434   4435   4436   4437   4438   4439   443A   443B   443C   443D   443E   443F   4440   4441   4442   4443   4444   4445   4446   4447   4448   4449   444A   444B   444C   444D   444E   444F   4450   4451   4452   4453   4454   4455   4456   4457   4458   4459   445A   445B   445C   445D   445E   445F   4460   4461   4462   4463   4464   4465   4466   4467   4468   4469   446A   446B   446C   446D   446E   446F   4470   4471   4472   4473   4474   4475   4476   4477   4478   4479   447A   447B   447C   447D   447E   )],
    '93' => [qw( 4521   4522   4523   4524   4525   4526   4527   4528   4529   452A   452B   452C   452D   452E   452F   4530   4531   4532   4533   4534   4535   4536   4537   4538   4539   453A   453B   453C   453D   453E   453F   4540   4541   4542   4543   4544   4545   4546   4547   4548   4549   454A   454B   454C   454D   454E   454F   4550   4551   4552   4553   4554   4555   4556   4557   4558   4559   455A   455B   455C   455D   455E   455F   4560   4561   4562   4563   4564   4565   4566   4567   4568   4569   456A   456B   456C   456D   456E   456F   4570   4571   4572   4573   4574   4575   4576   4577   4578   4579   457A   457B   457C   457D   457E   4621   4622   4623   4624   4625   4626   4627   4628   4629   462A   462B   462C   462D   462E   462F   4630   4631   4632   4633   4634   4635   4636   4637   4638   4639   463A   463B   463C   463D   463E   463F   4640   4641   4642   4643   4644   4645   4646   4647   4648   4649   464A   464B   464C   464D   464E   464F   4650   4651   4652   4653   4654   4655   4656   4657   4658   4659   465A   465B   465C   465D   465E   465F   4660   4661   4662   4663   4664   4665   4666   4667   4668   4669   466A   466B   466C   466D   466E   466F   4670   4671   4672   4673   4674   4675   4676   4677   4678   4679   467A   467B   467C   467D   467E   )],
    '94' => [qw( 4721   4722   4723   4724   4725   4726   4727   4728   4729   472A   472B   472C   472D   472E   472F   4730   4731   4732   4733   4734   4735   4736   4737   4738   4739   473A   473B   473C   473D   473E   473F   4740   4741   4742   4743   4744   4745   4746   4747   4748   4749   474A   474B   474C   474D   474E   474F   4750   4751   4752   4753   4754   4755   4756   4757   4758   4759   475A   475B   475C   475D   475E   475F   4760   4761   4762   4763   4764   4765   4766   4767   4768   4769   476A   476B   476C   476D   476E   476F   4770   4771   4772   4773   4774   4775   4776   4777   4778   4779   477A   477B   477C   477D   477E   4821   4822   4823   4824   4825   4826   4827   4828   4829   482A   482B   482C   482D   482E   482F   4830   4831   4832   4833   4834   4835   4836   4837   4838   4839   483A   483B   483C   483D   483E   483F   4840   4841   4842   4843   4844   4845   4846   4847   4848   4849   484A   484B   484C   484D   484E   484F   4850   4851   4852   4853   4854   4855   4856   4857   4858   4859   485A   485B   485C   485D   485E   485F   4860   4861   4862   4863   4864   4865   4866   4867   4868   4869   486A   486B   486C   486D   486E   486F   4870   4871   4872   4873   4874   4875   4876   4877   4878   4879   487A   487B   487C   487D   487E   )],
    '95' => [qw( 4921   4922   4923   4924   4925   4926   4927   4928   4929   492A   492B   492C   492D   492E   492F   4930   4931   4932   4933   4934   4935   4936   4937   4938   4939   493A   493B   493C   493D   493E   493F   4940   4941   4942   4943   4944   4945   4946   4947   4948   4949   494A   494B   494C   494D   494E   494F   4950   4951   4952   4953   4954   4955   4956   4957   4958   4959   495A   495B   495C   495D   495E   495F   4960   4961   4962   4963   4964   4965   4966   4967   4968   4969   496A   496B   496C   496D   496E   496F   4970   4971   4972   4973   4974   4975   4976   4977   4978   4979   497A   497B   497C   497D   497E   4A21   4A22   4A23   4A24   4A25   4A26   4A27   4A28   4A29   4A2A   4A2B   4A2C   4A2D   4A2E   4A2F   4A30   4A31   4A32   4A33   4A34   4A35   4A36   4A37   4A38   4A39   4A3A   4A3B   4A3C   4A3D   4A3E   4A3F   4A40   4A41   4A42   4A43   4A44   4A45   4A46   4A47   4A48   4A49   4A4A   4A4B   4A4C   4A4D   4A4E   4A4F   4A50   4A51   4A52   4A53   4A54   4A55   4A56   4A57   4A58   4A59   4A5A   4A5B   4A5C   4A5D   4A5E   4A5F   4A60   4A61   4A62   4A63   4A64   4A65   4A66   4A67   4A68   4A69   4A6A   4A6B   4A6C   4A6D   4A6E   4A6F   4A70   4A71   4A72   4A73   4A74   4A75   4A76   4A77   4A78   4A79   4A7A   4A7B   4A7C   4A7D   4A7E   )],
    '96' => [qw( 4B21   4B22   4B23   4B24   4B25   4B26   4B27   4B28   4B29   4B2A   4B2B   4B2C   4B2D   4B2E   4B2F   4B30   4B31   4B32   4B33   4B34   4B35   4B36   4B37   4B38   4B39   4B3A   4B3B   4B3C   4B3D   4B3E   4B3F   4B40   4B41   4B42   4B43   4B44   4B45   4B46   4B47   4B48   4B49   4B4A   4B4B   4B4C   4B4D   4B4E   4B4F   4B50   4B51   4B52   4B53   4B54   4B55   4B56   4B57   4B58   4B59   4B5A   4B5B   4B5C   4B5D   4B5E   4B5F   4B60   4B61   4B62   4B63   4B64   4B65   4B66   4B67   4B68   4B69   4B6A   4B6B   4B6C   4B6D   4B6E   4B6F   4B70   4B71   4B72   4B73   4B74   4B75   4B76   4B77   4B78   4B79   4B7A   4B7B   4B7C   4B7D   4B7E   4C21   4C22   4C23   4C24   4C25   4C26   4C27   4C28   4C29   4C2A   4C2B   4C2C   4C2D   4C2E   4C2F   4C30   4C31   4C32   4C33   4C34   4C35   4C36   4C37   4C38   4C39   4C3A   4C3B   4C3C   4C3D   4C3E   4C3F   4C40   4C41   4C42   4C43   4C44   4C45   4C46   4C47   4C48   4C49   4C4A   4C4B   4C4C   4C4D   4C4E   4C4F   4C50   4C51   4C52   4C53   4C54   4C55   4C56   4C57   4C58   4C59   4C5A   4C5B   4C5C   4C5D   4C5E   4C5F   4C60   4C61   4C62   4C63   4C64   4C65   4C66   4C67   4C68   4C69   4C6A   4C6B   4C6C   4C6D   4C6E   4C6F   4C70   4C71   4C72   4C73   4C74   4C75   4C76   4C77   4C78   4C79   4C7A   4C7B   4C7C   4C7D   4C7E   )],
    '97' => [qw( 4D21   4D22   4D23   4D24   4D25   4D26   4D27   4D28   4D29   4D2A   4D2B   4D2C   4D2D   4D2E   4D2F   4D30   4D31   4D32   4D33   4D34   4D35   4D36   4D37   4D38   4D39   4D3A   4D3B   4D3C   4D3D   4D3E   4D3F   4D40   4D41   4D42   4D43   4D44   4D45   4D46   4D47   4D48   4D49   4D4A   4D4B   4D4C   4D4D   4D4E   4D4F   4D50   4D51   4D52   4D53   4D54   4D55   4D56   4D57   4D58   4D59   4D5A   4D5B   4D5C   4D5D   4D5E   4D5F   4D60   4D61   4D62   4D63   4D64   4D65   4D66   4D67   4D68   4D69   4D6A   4D6B   4D6C   4D6D   4D6E   4D6F   4D70   4D71   4D72   4D73   4D74   4D75   4D76   4D77   4D78   4D79   4D7A   4D7B   4D7C   4D7D   4D7E   4E21   4E22   4E23   4E24   4E25   4E26   4E27   4E28   4E29   4E2A   4E2B   4E2C   4E2D   4E2E   4E2F   4E30   4E31   4E32   4E33   4E34   4E35   4E36   4E37   4E38   4E39   4E3A   4E3B   4E3C   4E3D   4E3E   4E3F   4E40   4E41   4E42   4E43   4E44   4E45   4E46   4E47   4E48   4E49   4E4A   4E4B   4E4C   4E4D   4E4E   4E4F   4E50   4E51   4E52   4E53   4E54   4E55   4E56   4E57   4E58   4E59   4E5A   4E5B   4E5C   4E5D   4E5E   4E5F   4E60   4E61   4E62   4E63   4E64   4E65   4E66   4E67   4E68   4E69   4E6A   4E6B   4E6C   4E6D   4E6E   4E6F   4E70   4E71   4E72   4E73   4E74   4E75   4E76   4E77   4E78   4E79   4E7A   4E7B   4E7C   4E7D   4E7E   )],
    '98' => [qw( 4F21   4F22   4F23   4F24   4F25   4F26   4F27   4F28   4F29   4F2A   4F2B   4F2C   4F2D   4F2E   4F2F   4F30   4F31   4F32   4F33   4F34   4F35   4F36   4F37   4F38   4F39   4F3A   4F3B   4F3C   4F3D   4F3E   4F3F   4F40   4F41   4F42   4F43   4F44   4F45   4F46   4F47   4F48   4F49   4F4A   4F4B   4F4C   4F4D   4F4E   4F4F   4F50   4F51   4F52   4F53   4F54   4F55   4F56   4F57   4F58   4F59   4F5A   4F5B   4F5C   4F5D   4F5E   4F5F   4F60   4F61   4F62   4F63   4F64   4F65   4F66   4F67   4F68   4F69   4F6A   4F6B   4F6C   4F6D   4F6E   4F6F   4F70   4F71   4F72   4F73   4F74   4F75   4F76   4F77   4F78   4F79   4F7A   4F7B   4F7C   4F7D   4F7E   5021   5022   5023   5024   5025   5026   5027   5028   5029   502A   502B   502C   502D   502E   502F   5030   5031   5032   5033   5034   5035   5036   5037   5038   5039   503A   503B   503C   503D   503E   503F   5040   5041   5042   5043   5044   5045   5046   5047   5048   5049   504A   504B   504C   504D   504E   504F   5050   5051   5052   5053   5054   5055   5056   5057   5058   5059   505A   505B   505C   505D   505E   505F   5060   5061   5062   5063   5064   5065   5066   5067   5068   5069   506A   506B   506C   506D   506E   506F   5070   5071   5072   5073   5074   5075   5076   5077   5078   5079   507A   507B   507C   507D   507E   )],
    '99' => [qw( 5121   5122   5123   5124   5125   5126   5127   5128   5129   512A   512B   512C   512D   512E   512F   5130   5131   5132   5133   5134   5135   5136   5137   5138   5139   513A   513B   513C   513D   513E   513F   5140   5141   5142   5143   5144   5145   5146   5147   5148   5149   514A   514B   514C   514D   514E   514F   5150   5151   5152   5153   5154   5155   5156   5157   5158   5159   515A   515B   515C   515D   515E   515F   5160   5161   5162   5163   5164   5165   5166   5167   5168   5169   516A   516B   516C   516D   516E   516F   5170   5171   5172   5173   5174   5175   5176   5177   5178   5179   517A   517B   517C   517D   517E   5221   5222   5223   5224   5225   5226   5227   5228   5229   522A   522B   522C   522D   522E   522F   5230   5231   5232   5233   5234   5235   5236   5237   5238   5239   523A   523B   523C   523D   523E   523F   5240   5241   5242   5243   5244   5245   5246   5247   5248   5249   524A   524B   524C   524D   524E   524F   5250   5251   5252   5253   5254   5255   5256   5257   5258   5259   525A   525B   525C   525D   525E   525F   5260   5261   5262   5263   5264   5265   5266   5267   5268   5269   526A   526B   526C   526D   526E   526F   5270   5271   5272   5273   5274   5275   5276   5277   5278   5279   527A   527B   527C   527D   527E   )],
    '9A' => [qw( 5321   5322   5323   5324   5325   5326   5327   5328   5329   532A   532B   532C   532D   532E   532F   5330   5331   5332   5333   5334   5335   5336   5337   5338   5339   533A   533B   533C   533D   533E   533F   5340   5341   5342   5343   5344   5345   5346   5347   5348   5349   534A   534B   534C   534D   534E   534F   5350   5351   5352   5353   5354   5355   5356   5357   5358   5359   535A   535B   535C   535D   535E   535F   5360   5361   5362   5363   5364   5365   5366   5367   5368   5369   536A   536B   536C   536D   536E   536F   5370   5371   5372   5373   5374   5375   5376   5377   5378   5379   537A   537B   537C   537D   537E   5421   5422   5423   5424   5425   5426   5427   5428   5429   542A   542B   542C   542D   542E   542F   5430   5431   5432   5433   5434   5435   5436   5437   5438   5439   543A   543B   543C   543D   543E   543F   5440   5441   5442   5443   5444   5445   5446   5447   5448   5449   544A   544B   544C   544D   544E   544F   5450   5451   5452   5453   5454   5455   5456   5457   5458   5459   545A   545B   545C   545D   545E   545F   5460   5461   5462   5463   5464   5465   5466   5467   5468   5469   546A   546B   546C   546D   546E   546F   5470   5471   5472   5473   5474   5475   5476   5477   5478   5479   547A   547B   547C   547D   547E   )],
    '9B' => [qw( 5521   5522   5523   5524   5525   5526   5527   5528   5529   552A   552B   552C   552D   552E   552F   5530   5531   5532   5533   5534   5535   5536   5537   5538   5539   553A   553B   553C   553D   553E   553F   5540   5541   5542   5543   5544   5545   5546   5547   5548   5549   554A   554B   554C   554D   554E   554F   5550   5551   5552   5553   5554   5555   5556   5557   5558   5559   555A   555B   555C   555D   555E   555F   5560   5561   5562   5563   5564   5565   5566   5567   5568   5569   556A   556B   556C   556D   556E   556F   5570   5571   5572   5573   5574   5575   5576   5577   5578   5579   557A   557B   557C   557D   557E   5621   5622   5623   5624   5625   5626   5627   5628   5629   562A   562B   562C   562D   562E   562F   5630   5631   5632   5633   5634   5635   5636   5637   5638   5639   563A   563B   563C   563D   563E   563F   5640   5641   5642   5643   5644   5645   5646   5647   5648   5649   564A   564B   564C   564D   564E   564F   5650   5651   5652   5653   5654   5655   5656   5657   5658   5659   565A   565B   565C   565D   565E   565F   5660   5661   5662   5663   5664   5665   5666   5667   5668   5669   566A   566B   566C   566D   566E   566F   5670   5671   5672   5673   5674   5675   5676   5677   5678   5679   567A   567B   567C   567D   567E   )],
    '9C' => [qw( 5721   5722   5723   5724   5725   5726   5727   5728   5729   572A   572B   572C   572D   572E   572F   5730   5731   5732   5733   5734   5735   5736   5737   5738   5739   573A   573B   573C   573D   573E   573F   5740   5741   5742   5743   5744   5745   5746   5747   5748   5749   574A   574B   574C   574D   574E   574F   5750   5751   5752   5753   5754   5755   5756   5757   5758   5759   575A   575B   575C   575D   575E   575F   5760   5761   5762   5763   5764   5765   5766   5767   5768   5769   576A   576B   576C   576D   576E   576F   5770   5771   5772   5773   5774   5775   5776   5777   5778   5779   577A   577B   577C   577D   577E   5821   5822   5823   5824   5825   5826   5827   5828   5829   582A   582B   582C   582D   582E   582F   5830   5831   5832   5833   5834   5835   5836   5837   5838   5839   583A   583B   583C   583D   583E   583F   5840   5841   5842   5843   5844   5845   5846   5847   5848   5849   584A   584B   584C   584D   584E   584F   5850   5851   5852   5853   5854   5855   5856   5857   5858   5859   585A   585B   585C   585D   585E   585F   5860   5861   5862   5863   5864   5865   5866   5867   5868   5869   586A   586B   586C   586D   586E   586F   5870   5871   5872   5873   5874   5875   5876   5877   5878   5879   587A   587B   587C   587D   587E   )],
    '9D' => [qw( 5921   5922   5923   5924   5925   5926   5927   5928   5929   592A   592B   592C   592D   592E   592F   5930   5931   5932   5933   5934   5935   5936   5937   5938   5939   593A   593B   593C   593D   593E   593F   5940   5941   5942   5943   5944   5945   5946   5947   5948   5949   594A   594B   594C   594D   594E   594F   5950   5951   5952   5953   5954   5955   5956   5957   5958   5959   595A   595B   595C   595D   595E   595F   5960   5961   5962   5963   5964   5965   5966   5967   5968   5969   596A   596B   596C   596D   596E   596F   5970   5971   5972   5973   5974   5975   5976   5977   5978   5979   597A   597B   597C   597D   597E   5A21   5A22   5A23   5A24   5A25   5A26   5A27   5A28   5A29   5A2A   5A2B   5A2C   5A2D   5A2E   5A2F   5A30   5A31   5A32   5A33   5A34   5A35   5A36   5A37   5A38   5A39   5A3A   5A3B   5A3C   5A3D   5A3E   5A3F   5A40   5A41   5A42   5A43   5A44   5A45   5A46   5A47   5A48   5A49   5A4A   5A4B   5A4C   5A4D   5A4E   5A4F   5A50   5A51   5A52   5A53   5A54   5A55   5A56   5A57   5A58   5A59   5A5A   5A5B   5A5C   5A5D   5A5E   5A5F   5A60   5A61   5A62   5A63   5A64   5A65   5A66   5A67   5A68   5A69   5A6A   5A6B   5A6C   5A6D   5A6E   5A6F   5A70   5A71   5A72   5A73   5A74   5A75   5A76   5A77   5A78   5A79   5A7A   5A7B   5A7C   5A7D   5A7E   )],
    '9E' => [qw( 5B21   5B22   5B23   5B24   5B25   5B26   5B27   5B28   5B29   5B2A   5B2B   5B2C   5B2D   5B2E   5B2F   5B30   5B31   5B32   5B33   5B34   5B35   5B36   5B37   5B38   5B39   5B3A   5B3B   5B3C   5B3D   5B3E   5B3F   5B40   5B41   5B42   5B43   5B44   5B45   5B46   5B47   5B48   5B49   5B4A   5B4B   5B4C   5B4D   5B4E   5B4F   5B50   5B51   5B52   5B53   5B54   5B55   5B56   5B57   5B58   5B59   5B5A   5B5B   5B5C   5B5D   5B5E   5B5F   5B60   5B61   5B62   5B63   5B64   5B65   5B66   5B67   5B68   5B69   5B6A   5B6B   5B6C   5B6D   5B6E   5B6F   5B70   5B71   5B72   5B73   5B74   5B75   5B76   5B77   5B78   5B79   5B7A   5B7B   5B7C   5B7D   5B7E   5C21   5C22   5C23   5C24   5C25   5C26   5C27   5C28   5C29   5C2A   5C2B   5C2C   5C2D   5C2E   5C2F   5C30   5C31   5C32   5C33   5C34   5C35   5C36   5C37   5C38   5C39   5C3A   5C3B   5C3C   5C3D   5C3E   5C3F   5C40   5C41   5C42   5C43   5C44   5C45   5C46   5C47   5C48   5C49   5C4A   5C4B   5C4C   5C4D   5C4E   5C4F   5C50   5C51   5C52   5C53   5C54   5C55   5C56   5C57   5C58   5C59   5C5A   5C5B   5C5C   5C5D   5C5E   5C5F   5C60   5C61   5C62   5C63   5C64   5C65   5C66   5C67   5C68   5C69   5C6A   5C6B   5C6C   5C6D   5C6E   5C6F   5C70   5C71   5C72   5C73   5C74   5C75   5C76   5C77   5C78   5C79   5C7A   5C7B   5C7C   5C7D   5C7E   )],
    '9F' => [qw( 5D21   5D22   5D23   5D24   5D25   5D26   5D27   5D28   5D29   5D2A   5D2B   5D2C   5D2D   5D2E   5D2F   5D30   5D31   5D32   5D33   5D34   5D35   5D36   5D37   5D38   5D39   5D3A   5D3B   5D3C   5D3D   5D3E   5D3F   5D40   5D41   5D42   5D43   5D44   5D45   5D46   5D47   5D48   5D49   5D4A   5D4B   5D4C   5D4D   5D4E   5D4F   5D50   5D51   5D52   5D53   5D54   5D55   5D56   5D57   5D58   5D59   5D5A   5D5B   5D5C   5D5D   5D5E   5D5F   5D60   5D61   5D62   5D63   5D64   5D65   5D66   5D67   5D68   5D69   5D6A   5D6B   5D6C   5D6D   5D6E   5D6F   5D70   5D71   5D72   5D73   5D74   5D75   5D76   5D77   5D78   5D79   5D7A   5D7B   5D7C   5D7D   5D7E   5E21   5E22   5E23   5E24   5E25   5E26   5E27   5E28   5E29   5E2A   5E2B   5E2C   5E2D   5E2E   5E2F   5E30   5E31   5E32   5E33   5E34   5E35   5E36   5E37   5E38   5E39   5E3A   5E3B   5E3C   5E3D   5E3E   5E3F   5E40   5E41   5E42   5E43   5E44   5E45   5E46   5E47   5E48   5E49   5E4A   5E4B   5E4C   5E4D   5E4E   5E4F   5E50   5E51   5E52   5E53   5E54   5E55   5E56   5E57   5E58   5E59   5E5A   5E5B   5E5C   5E5D   5E5E   5E5F   5E60   5E61   5E62   5E63   5E64   5E65   5E66   5E67   5E68   5E69   5E6A   5E6B   5E6C   5E6D   5E6E   5E6F   5E70   5E71   5E72   5E73   5E74   5E75   5E76   5E77   5E78   5E79   5E7A   5E7B   5E7C   5E7D   5E7E   )],
    'E0' => [qw( 5F21   5F22   5F23   5F24   5F25   5F26   5F27   5F28   5F29   5F2A   5F2B   5F2C   5F2D   5F2E   5F2F   5F30   5F31   5F32   5F33   5F34   5F35   5F36   5F37   5F38   5F39   5F3A   5F3B   5F3C   5F3D   5F3E   5F3F   5F40   5F41   5F42   5F43   5F44   5F45   5F46   5F47   5F48   5F49   5F4A   5F4B   5F4C   5F4D   5F4E   5F4F   5F50   5F51   5F52   5F53   5F54   5F55   5F56   5F57   5F58   5F59   5F5A   5F5B   5F5C   5F5D   5F5E   5F5F   5F60   5F61   5F62   5F63   5F64   5F65   5F66   5F67   5F68   5F69   5F6A   5F6B   5F6C   5F6D   5F6E   5F6F   5F70   5F71   5F72   5F73   5F74   5F75   5F76   5F77   5F78   5F79   5F7A   5F7B   5F7C   5F7D   5F7E   6021   6022   6023   6024   6025   6026   6027   6028   6029   602A   602B   602C   602D   602E   602F   6030   6031   6032   6033   6034   6035   6036   6037   6038   6039   603A   603B   603C   603D   603E   603F   6040   6041   6042   6043   6044   6045   6046   6047   6048   6049   604A   604B   604C   604D   604E   604F   6050   6051   6052   6053   6054   6055   6056   6057   6058   6059   605A   605B   605C   605D   605E   605F   6060   6061   6062   6063   6064   6065   6066   6067   6068   6069   606A   606B   606C   606D   606E   606F   6070   6071   6072   6073   6074   6075   6076   6077   6078   6079   607A   607B   607C   607D   607E   )],
    'E1' => [qw( 6121   6122   6123   6124   6125   6126   6127   6128   6129   612A   612B   612C   612D   612E   612F   6130   6131   6132   6133   6134   6135   6136   6137   6138   6139   613A   613B   613C   613D   613E   613F   6140   6141   6142   6143   6144   6145   6146   6147   6148   6149   614A   614B   614C   614D   614E   614F   6150   6151   6152   6153   6154   6155   6156   6157   6158   6159   615A   615B   615C   615D   615E   615F   6160   6161   6162   6163   6164   6165   6166   6167   6168   6169   616A   616B   616C   616D   616E   616F   6170   6171   6172   6173   6174   6175   6176   6177   6178   6179   617A   617B   617C   617D   617E   6221   6222   6223   6224   6225   6226   6227   6228   6229   622A   622B   622C   622D   622E   622F   6230   6231   6232   6233   6234   6235   6236   6237   6238   6239   623A   623B   623C   623D   623E   623F   6240   6241   6242   6243   6244   6245   6246   6247   6248   6249   624A   624B   624C   624D   624E   624F   6250   6251   6252   6253   6254   6255   6256   6257   6258   6259   625A   625B   625C   625D   625E   625F   6260   6261   6262   6263   6264   6265   6266   6267   6268   6269   626A   626B   626C   626D   626E   626F   6270   6271   6272   6273   6274   6275   6276   6277   6278   6279   627A   627B   627C   627D   627E   )],
    'E2' => [qw( 6321   6322   6323   6324   6325   6326   6327   6328   6329   632A   632B   632C   632D   632E   632F   6330   6331   6332   6333   6334   6335   6336   6337   6338   6339   633A   633B   633C   633D   633E   633F   6340   6341   6342   6343   6344   6345   6346   6347   6348   6349   634A   634B   634C   634D   634E   634F   6350   6351   6352   6353   6354   6355   6356   6357   6358   6359   635A   635B   635C   635D   635E   635F   6360   6361   6362   6363   6364   6365   6366   6367   6368   6369   636A   636B   636C   636D   636E   636F   6370   6371   6372   6373   6374   6375   6376   6377   6378   6379   637A   637B   637C   637D   637E   6421   6422   6423   6424   6425   6426   6427   6428   6429   642A   642B   642C   642D   642E   642F   6430   6431   6432   6433   6434   6435   6436   6437   6438   6439   643A   643B   643C   643D   643E   643F   6440   6441   6442   6443   6444   6445   6446   6447   6448   6449   644A   644B   644C   644D   644E   644F   6450   6451   6452   6453   6454   6455   6456   6457   6458   6459   645A   645B   645C   645D   645E   645F   6460   6461   6462   6463   6464   6465   6466   6467   6468   6469   646A   646B   646C   646D   646E   646F   6470   6471   6472   6473   6474   6475   6476   6477   6478   6479   647A   647B   647C   647D   647E   )],
    'E3' => [qw( 6521   6522   6523   6524   6525   6526   6527   6528   6529   652A   652B   652C   652D   652E   652F   6530   6531   6532   6533   6534   6535   6536   6537   6538   6539   653A   653B   653C   653D   653E   653F   6540   6541   6542   6543   6544   6545   6546   6547   6548   6549   654A   654B   654C   654D   654E   654F   6550   6551   6552   6553   6554   6555   6556   6557   6558   6559   655A   655B   655C   655D   655E   655F   6560   6561   6562   6563   6564   6565   6566   6567   6568   6569   656A   656B   656C   656D   656E   656F   6570   6571   6572   6573   6574   6575   6576   6577   6578   6579   657A   657B   657C   657D   657E   6621   6622   6623   6624   6625   6626   6627   6628   6629   662A   662B   662C   662D   662E   662F   6630   6631   6632   6633   6634   6635   6636   6637   6638   6639   663A   663B   663C   663D   663E   663F   6640   6641   6642   6643   6644   6645   6646   6647   6648   6649   664A   664B   664C   664D   664E   664F   6650   6651   6652   6653   6654   6655   6656   6657   6658   6659   665A   665B   665C   665D   665E   665F   6660   6661   6662   6663   6664   6665   6666   6667   6668   6669   666A   666B   666C   666D   666E   666F   6670   6671   6672   6673   6674   6675   6676   6677   6678   6679   667A   667B   667C   667D   667E   )],
    'E4' => [qw( 6721   6722   6723   6724   6725   6726   6727   6728   6729   672A   672B   672C   672D   672E   672F   6730   6731   6732   6733   6734   6735   6736   6737   6738   6739   673A   673B   673C   673D   673E   673F   6740   6741   6742   6743   6744   6745   6746   6747   6748   6749   674A   674B   674C   674D   674E   674F   6750   6751   6752   6753   6754   6755   6756   6757   6758   6759   675A   675B   675C   675D   675E   675F   6760   6761   6762   6763   6764   6765   6766   6767   6768   6769   676A   676B   676C   676D   676E   676F   6770   6771   6772   6773   6774   6775   6776   6777   6778   6779   677A   677B   677C   677D   677E   6821   6822   6823   6824   6825   6826   6827   6828   6829   682A   682B   682C   682D   682E   682F   6830   6831   6832   6833   6834   6835   6836   6837   6838   6839   683A   683B   683C   683D   683E   683F   6840   6841   6842   6843   6844   6845   6846   6847   6848   6849   684A   684B   684C   684D   684E   684F   6850   6851   6852   6853   6854   6855   6856   6857   6858   6859   685A   685B   685C   685D   685E   685F   6860   6861   6862   6863   6864   6865   6866   6867   6868   6869   686A   686B   686C   686D   686E   686F   6870   6871   6872   6873   6874   6875   6876   6877   6878   6879   687A   687B   687C   687D   687E   )],
    'E5' => [qw( 6921   6922   6923   6924   6925   6926   6927   6928   6929   692A   692B   692C   692D   692E   692F   6930   6931   6932   6933   6934   6935   6936   6937   6938   6939   693A   693B   693C   693D   693E   693F   6940   6941   6942   6943   6944   6945   6946   6947   6948   6949   694A   694B   694C   694D   694E   694F   6950   6951   6952   6953   6954   6955   6956   6957   6958   6959   695A   695B   695C   695D   695E   695F   6960   6961   6962   6963   6964   6965   6966   6967   6968   6969   696A   696B   696C   696D   696E   696F   6970   6971   6972   6973   6974   6975   6976   6977   6978   6979   697A   697B   697C   697D   697E   6A21   6A22   6A23   6A24   6A25   6A26   6A27   6A28   6A29   6A2A   6A2B   6A2C   6A2D   6A2E   6A2F   6A30   6A31   6A32   6A33   6A34   6A35   6A36   6A37   6A38   6A39   6A3A   6A3B   6A3C   6A3D   6A3E   6A3F   6A40   6A41   6A42   6A43   6A44   6A45   6A46   6A47   6A48   6A49   6A4A   6A4B   6A4C   6A4D   6A4E   6A4F   6A50   6A51   6A52   6A53   6A54   6A55   6A56   6A57   6A58   6A59   6A5A   6A5B   6A5C   6A5D   6A5E   6A5F   6A60   6A61   6A62   6A63   6A64   6A65   6A66   6A67   6A68   6A69   6A6A   6A6B   6A6C   6A6D   6A6E   6A6F   6A70   6A71   6A72   6A73   6A74   6A75   6A76   6A77   6A78   6A79   6A7A   6A7B   6A7C   6A7D   6A7E   )],
    'E6' => [qw( 6B21   6B22   6B23   6B24   6B25   6B26   6B27   6B28   6B29   6B2A   6B2B   6B2C   6B2D   6B2E   6B2F   6B30   6B31   6B32   6B33   6B34   6B35   6B36   6B37   6B38   6B39   6B3A   6B3B   6B3C   6B3D   6B3E   6B3F   6B40   6B41   6B42   6B43   6B44   6B45   6B46   6B47   6B48   6B49   6B4A   6B4B   6B4C   6B4D   6B4E   6B4F   6B50   6B51   6B52   6B53   6B54   6B55   6B56   6B57   6B58   6B59   6B5A   6B5B   6B5C   6B5D   6B5E   6B5F   6B60   6B61   6B62   6B63   6B64   6B65   6B66   6B67   6B68   6B69   6B6A   6B6B   6B6C   6B6D   6B6E   6B6F   6B70   6B71   6B72   6B73   6B74   6B75   6B76   6B77   6B78   6B79   6B7A   6B7B   6B7C   6B7D   6B7E   6C21   6C22   6C23   6C24   6C25   6C26   6C27   6C28   6C29   6C2A   6C2B   6C2C   6C2D   6C2E   6C2F   6C30   6C31   6C32   6C33   6C34   6C35   6C36   6C37   6C38   6C39   6C3A   6C3B   6C3C   6C3D   6C3E   6C3F   6C40   6C41   6C42   6C43   6C44   6C45   6C46   6C47   6C48   6C49   6C4A   6C4B   6C4C   6C4D   6C4E   6C4F   6C50   6C51   6C52   6C53   6C54   6C55   6C56   6C57   6C58   6C59   6C5A   6C5B   6C5C   6C5D   6C5E   6C5F   6C60   6C61   6C62   6C63   6C64   6C65   6C66   6C67   6C68   6C69   6C6A   6C6B   6C6C   6C6D   6C6E   6C6F   6C70   6C71   6C72   6C73   6C74   6C75   6C76   6C77   6C78   6C79   6C7A   6C7B   6C7C   6C7D   6C7E   )],
    'E7' => [qw( 6D21   6D22   6D23   6D24   6D25   6D26   6D27   6D28   6D29   6D2A   6D2B   6D2C   6D2D   6D2E   6D2F   6D30   6D31   6D32   6D33   6D34   6D35   6D36   6D37   6D38   6D39   6D3A   6D3B   6D3C   6D3D   6D3E   6D3F   6D40   6D41   6D42   6D43   6D44   6D45   6D46   6D47   6D48   6D49   6D4A   6D4B   6D4C   6D4D   6D4E   6D4F   6D50   6D51   6D52   6D53   6D54   6D55   6D56   6D57   6D58   6D59   6D5A   6D5B   6D5C   6D5D   6D5E   6D5F   6D60   6D61   6D62   6D63   6D64   6D65   6D66   6D67   6D68   6D69   6D6A   6D6B   6D6C   6D6D   6D6E   6D6F   6D70   6D71   6D72   6D73   6D74   6D75   6D76   6D77   6D78   6D79   6D7A   6D7B   6D7C   6D7D   6D7E   6E21   6E22   6E23   6E24   6E25   6E26   6E27   6E28   6E29   6E2A   6E2B   6E2C   6E2D   6E2E   6E2F   6E30   6E31   6E32   6E33   6E34   6E35   6E36   6E37   6E38   6E39   6E3A   6E3B   6E3C   6E3D   6E3E   6E3F   6E40   6E41   6E42   6E43   6E44   6E45   6E46   6E47   6E48   6E49   6E4A   6E4B   6E4C   6E4D   6E4E   6E4F   6E50   6E51   6E52   6E53   6E54   6E55   6E56   6E57   6E58   6E59   6E5A   6E5B   6E5C   6E5D   6E5E   6E5F   6E60   6E61   6E62   6E63   6E64   6E65   6E66   6E67   6E68   6E69   6E6A   6E6B   6E6C   6E6D   6E6E   6E6F   6E70   6E71   6E72   6E73   6E74   6E75   6E76   6E77   6E78   6E79   6E7A   6E7B   6E7C   6E7D   6E7E   )],
    'E8' => [qw( 6F21   6F22   6F23   6F24   6F25   6F26   6F27   6F28   6F29   6F2A   6F2B   6F2C   6F2D   6F2E   6F2F   6F30   6F31   6F32   6F33   6F34   6F35   6F36   6F37   6F38   6F39   6F3A   6F3B   6F3C   6F3D   6F3E   6F3F   6F40   6F41   6F42   6F43   6F44   6F45   6F46   6F47   6F48   6F49   6F4A   6F4B   6F4C   6F4D   6F4E   6F4F   6F50   6F51   6F52   6F53   6F54   6F55   6F56   6F57   6F58   6F59   6F5A   6F5B   6F5C   6F5D   6F5E   6F5F   6F60   6F61   6F62   6F63   6F64   6F65   6F66   6F67   6F68   6F69   6F6A   6F6B   6F6C   6F6D   6F6E   6F6F   6F70   6F71   6F72   6F73   6F74   6F75   6F76   6F77   6F78   6F79   6F7A   6F7B   6F7C   6F7D   6F7E   7021   7022   7023   7024   7025   7026   7027   7028   7029   702A   702B   702C   702D   702E   702F   7030   7031   7032   7033   7034   7035   7036   7037   7038   7039   703A   703B   703C   703D   703E   703F   7040   7041   7042   7043   7044   7045   7046   7047   7048   7049   704A   704B   704C   704D   704E   704F   7050   7051   7052   7053   7054   7055   7056   7057   7058   7059   705A   705B   705C   705D   705E   705F   7060   7061   7062   7063   7064   7065   7066   7067   7068   7069   706A   706B   706C   706D   706E   706F   7070   7071   7072   7073   7074   7075   7076   7077   7078   7079   707A   707B   707C   707D   707E   )],
    'E9' => [qw( 7121   7122   7123   7124   7125   7126   7127   7128   7129   712A   712B   712C   712D   712E   712F   7130   7131   7132   7133   7134   7135   7136   7137   7138   7139   713A   713B   713C   713D   713E   713F   7140   7141   7142   7143   7144   7145   7146   7147   7148   7149   714A   714B   714C   714D   714E   714F   7150   7151   7152   7153   7154   7155   7156   7157   7158   7159   715A   715B   715C   715D   715E   715F   7160   7161   7162   7163   7164   7165   7166   7167   7168   7169   716A   716B   716C   716D   716E   716F   7170   7171   7172   7173   7174   7175   7176   7177   7178   7179   717A   717B   717C   717D   717E   7221   7222   7223   7224   7225   7226   7227   7228   7229   722A   722B   722C   722D   722E   722F   7230   7231   7232   7233   7234   7235   7236   7237   7238   7239   723A   723B   723C   723D   723E   723F   7240   7241   7242   7243   7244   7245   7246   7247   7248   7249   724A   724B   724C   724D   724E   724F   7250   7251   7252   7253   7254   7255   7256   7257   7258   7259   725A   725B   725C   725D   725E   725F   7260   7261   7262   7263   7264   7265   7266   7267   7268   7269   726A   726B   726C   726D   726E   726F   7270   7271   7272   7273   7274   7275   7276   7277   7278   7279   727A   727B   727C   727D   727E   )],
    'EA' => [qw( 7321   7322   7323   7324   7325   7326   7327   7328   7329   732A   732B   732C   732D   732E   732F   7330   7331   7332   7333   7334   7335   7336   7337   7338   7339   733A   733B   733C   733D   733E   733F   7340   7341   7342   7343   7344   7345   7346   7347   7348   7349   734A   734B   734C   734D   734E   734F   7350   7351   7352   7353   7354   7355   7356   7357   7358   7359   735A   735B   735C   735D   735E   735F   7360   7361   7362   7363   7364   7365   7366   7367   7368   7369   736A   736B   736C   736D   736E   736F   7370   7371   7372   7373   7374   7375   7376   7377   7378   7379   737A   737B   737C   737D   737E   7421   7422   7423   7424   7425   7426   7427   7428   7429   742A   742B   742C   742D   742E   742F   7430   7431   7432   7433   7434   7435   7436   7437   7438   7439   743A   743B   743C   743D   743E   743F   7440   7441   7442   7443   7444   7445   7446   7447   7448   7449   744A   744B   744C   744D   744E   744F   7450   7451   7452   7453   7454   7455   7456   7457   7458   7459   745A   745B   745C   745D   745E   745F   7460   7461   7462   7463   7464   7465   7466   7467   7468   7469   746A   746B   746C   746D   746E   746F   7470   7471   7472   7473   7474   7475   7476   7477   7478   7479   747A   747B   747C   747D   747E   )],
    'EB' => [qw( 7521   7522   7523   7524   7525   7526   7527   7528   7529   752A   752B   752C   752D   752E   752F   7530   7531   7532   7533   7534   7535   7536   7537   7538   7539   753A   753B   753C   753D   753E   753F   7540   7541   7542   7543   7544   7545   7546   7547   7548   7549   754A   754B   754C   754D   754E   754F   7550   7551   7552   7553   7554   7555   7556   7557   7558   7559   755A   755B   755C   755D   755E   755F   7560   7561   7562   7563   7564   7565   7566   7567   7568   7569   756A   756B   756C   756D   756E   756F   7570   7571   7572   7573   7574   7575   7576   7577   7578   7579   757A   757B   757C   757D   757E   7621   7622   7623   7624   7625   7626   7627   7628   7629   762A   762B   762C   762D   762E   762F   7630   7631   7632   7633   7634   7635   7636   7637   7638   7639   763A   763B   763C   763D   763E   763F   7640   7641   7642   7643   7644   7645   7646   7647   7648   7649   764A   764B   764C   764D   764E   764F   7650   7651   7652   7653   7654   7655   7656   7657   7658   7659   765A   765B   765C   765D   765E   765F   7660   7661   7662   7663   7664   7665   7666   7667   7668   7669   766A   766B   766C   766D   766E   766F   7670   7671   7672   7673   7674   7675   7676   7677   7678   7679   767A   767B   767C   767D   767E   )],
    'EC' => [qw( 7721   7722   7723   7724   7725   7726   7727   7728   7729   772A   772B   772C   772D   772E   772F   7730   7731   7732   7733   7734   7735   7736   7737   7738   7739   773A   773B   773C   773D   773E   773F   7740   7741   7742   7743   7744   7745   7746   7747   7748   7749   774A   774B   774C   774D   774E   774F   7750   7751   7752   7753   7754   7755   7756   7757   7758   7759   775A   775B   775C   775D   775E   775F   7760   7761   7762   7763   7764   7765   7766   7767   7768   7769   776A   776B   776C   776D   776E   776F   7770   7771   7772   7773   7774   7775   7776   7777   7778   7779   777A   777B   777C   777D   777E   7821   7822   7823   7824   7825   7826   7827   7828   7829   782A   782B   782C   782D   782E   782F   7830   7831   7832   7833   7834   7835   7836   7837   7838   7839   783A   783B   783C   783D   783E   783F   7840   7841   7842   7843   7844   7845   7846   7847   7848   7849   784A   784B   784C   784D   784E   784F   7850   7851   7852   7853   7854   7855   7856   7857   7858   7859   785A   785B   785C   785D   785E   785F   7860   7861   7862   7863   7864   7865   7866   7867   7868   7869   786A   786B   786C   786D   786E   786F   7870   7871   7872   7873   7874   7875   7876   7877   7878   7879   787A   787B   787C   787D   787E   )],
    'ED' => [qw( 7921   7922   7923   7924   7925   7926   7927   7928   7929   792A   792B   792C   792D   792E   792F   7930   7931   7932   7933   7934   7935   7936   7937   7938   7939   793A   793B   793C   793D   793E   793F   7940   7941   7942   7943   7944   7945   7946   7947   7948   7949   794A   794B   794C   794D   794E   794F   7950   7951   7952   7953   7954   7955   7956   7957   7958   7959   795A   795B   795C   795D   795E   795F   7960   7961   7962   7963   7964   7965   7966   7967   7968   7969   796A   796B   796C   796D   796E   796F   7970   7971   7972   7973   7974   7975   7976   7977   7978   7979   797A   797B   797C   797D   797E   7A21   7A22   7A23   7A24   7A25   7A26   7A27   7A28   7A29   7A2A   7A2B   7A2C   7A2D   7A2E   7A2F   7A30   7A31   7A32   7A33   7A34   7A35   7A36   7A37   7A38   7A39   7A3A   7A3B   7A3C   7A3D   7A3E   7A3F   7A40   7A41   7A42   7A43   7A44   7A45   7A46   7A47   7A48   7A49   7A4A   7A4B   7A4C   7A4D   7A4E   7A4F   7A50   7A51   7A52   7A53   7A54   7A55   7A56   7A57   7A58   7A59   7A5A   7A5B   7A5C   7A5D   7A5E   7A5F   7A60   7A61   7A62   7A63   7A64   7A65   7A66   7A67   7A68   7A69   7A6A   7A6B   7A6C   7A6D   7A6E   7A6F   7A70   7A71   7A72   7A73   7A74   7A75   7A76   7A77   7A78   7A79   7A7A   7A7B   7A7C   7A7D   7A7E   )],
    'EE' => [qw( 7B21   7B22   7B23   7B24   7B25   7B26   7B27   7B28   7B29   7B2A   7B2B   7B2C   7B2D   7B2E   7B2F   7B30   7B31   7B32   7B33   7B34   7B35   7B36   7B37   7B38   7B39   7B3A   7B3B   7B3C   7B3D   7B3E   7B3F   7B40   7B41   7B42   7B43   7B44   7B45   7B46   7B47   7B48   7B49   7B4A   7B4B   7B4C   7B4D   7B4E   7B4F   7B50   7B51   7B52   7B53   7B54   7B55   7B56   7B57   7B58   7B59   7B5A   7B5B   7B5C   7B5D   7B5E   7B5F   7B60   7B61   7B62   7B63   7B64   7B65   7B66   7B67   7B68   7B69   7B6A   7B6B   7B6C   7B6D   7B6E   7B6F   7B70   7B71   7B72   7B73   7B74   7B75   7B76   7B77   7B78   7B79   7B7A   7B7B   7B7C   7B7D   7B7E   7C21   7C22   7C23   7C24   7C25   7C26   7C27   7C28   7C29   7C2A   7C2B   7C2C   7C2D   7C2E   7C2F   7C30   7C31   7C32   7C33   7C34   7C35   7C36   7C37   7C38   7C39   7C3A   7C3B   7C3C   7C3D   7C3E   7C3F   7C40   7C41   7C42   7C43   7C44   7C45   7C46   7C47   7C48   7C49   7C4A   7C4B   7C4C   7C4D   7C4E   7C4F   7C50   7C51   7C52   7C53   7C54   7C55   7C56   7C57   7C58   7C59   7C5A   7C5B   7C5C   7C5D   7C5E   7C5F   7C60   7C61   7C62   7C63   7C64   7C65   7C66   7C67   7C68   7C69   7C6A   7C6B   7C6C   7C6D   7C6E   7C6F   7C70   7C71   7C72   7C73   7C74   7C75   7C76   7C77   7C78   7C79   7C7A   7C7B   7C7C   7C7D   7C7E   )],
    'EF' => [qw( 7D21   7D22   7D23   7D24   7D25   7D26   7D27   7D28   7D29   7D2A   7D2B   7D2C   7D2D   7D2E   7D2F   7D30   7D31   7D32   7D33   7D34   7D35   7D36   7D37   7D38   7D39   7D3A   7D3B   7D3C   7D3D   7D3E   7D3F   7D40   7D41   7D42   7D43   7D44   7D45   7D46   7D47   7D48   7D49   7D4A   7D4B   7D4C   7D4D   7D4E   7D4F   7D50   7D51   7D52   7D53   7D54   7D55   7D56   7D57   7D58   7D59   7D5A   7D5B   7D5C   7D5D   7D5E   7D5F   7D60   7D61   7D62   7D63   7D64   7D65   7D66   7D67   7D68   7D69   7D6A   7D6B   7D6C   7D6D   7D6E   7D6F   7D70   7D71   7D72   7D73   7D74   7D75   7D76   7D77   7D78   7D79   7D7A   7D7B   7D7C   7D7D   7D7E   7E21   7E22   7E23   7E24   7E25   7E26   7E27   7E28   7E29   7E2A   7E2B   7E2C   7E2D   7E2E   7E2F   7E30   7E31   7E32   7E33   7E34   7E35   7E36   7E37   7E38   7E39   7E3A   7E3B   7E3C   7E3D   7E3E   7E3F   7E40   7E41   7E42   7E43   7E44   7E45   7E46   7E47   7E48   7E49   7E4A   7E4B   7E4C   7E4D   7E4E   7E4F   7E50   7E51   7E52   7E53   7E54   7E55   7E56   7E57   7E58   7E59   7E5A   7E5B   7E5C   7E5D   7E5E   7E5F   7E60   7E61   7E62   7E63   7E64   7E65   7E66   7E67   7E68   7E69   7E6A   7E6B   7E6C   7E6D   7E6E   7E6F   7E70   7E71   7E72   7E73   7E74   7E75   7E76   7E77   7E78   7E79   7E7A   7E7B   7E7C   7E7D   7E7E   )],
    'F0' => [qw( 7F21   7F22   7F23   7F24   7F25   7F26   7F27   7F28   7F29   7F2A   7F2B   7F2C   7F2D   7F2E   7F2F   7F30   7F31   7F32   7F33   7F34   7F35   7F36   7F37   7F38   7F39   7F3A   7F3B   7F3C   7F3D   7F3E   7F3F   7F40   7F41   7F42   7F43   7F44   7F45   7F46   7F47   7F48   7F49   7F4A   7F4B   7F4C   7F4D   7F4E   7F4F   7F50   7F51   7F52   7F53   7F54   7F55   7F56   7F57   7F58   7F59   7F5A   7F5B   7F5C   7F5D   7F5E   7F5F   7F60   7F61   7F62   7F63   7F64   7F65   7F66   7F67   7F68   7F69   7F6A   7F6B   7F6C   7F6D   7F6E   7F6F   7F70   7F71   7F72   7F73   7F74   7F75   7F76   7F77   7F78   7F79   7F7A   7F7B   7F7C   7F7D   7F7E   8021   8022   8023   8024   8025   8026   8027   8028   8029   802A   802B   802C   802D   802E   802F   8030   8031   8032   8033   8034   8035   8036   8037   8038   8039   803A   803B   803C   803D   803E   803F   8040   8041   8042   8043   8044   8045   8046   8047   8048   8049   804A   804B   804C   804D   804E   804F   8050   8051   8052   8053   8054   8055   8056   8057   8058   8059   805A   805B   805C   805D   805E   805F   8060   8061   8062   8063   8064   8065   8066   8067   8068   8069   806A   806B   806C   806D   806E   806F   8070   8071   8072   8073   8074   8075   8076   8077   8078   8079   807A   807B   807C   807D   807E   )],
    'F1' => [qw( 8121   8122   8123   8124   8125   8126   8127   8128   8129   812A   812B   812C   812D   812E   812F   8130   8131   8132   8133   8134   8135   8136   8137   8138   8139   813A   813B   813C   813D   813E   813F   8140   8141   8142   8143   8144   8145   8146   8147   8148   8149   814A   814B   814C   814D   814E   814F   8150   8151   8152   8153   8154   8155   8156   8157   8158   8159   815A   815B   815C   815D   815E   815F   8160   8161   8162   8163   8164   8165   8166   8167   8168   8169   816A   816B   816C   816D   816E   816F   8170   8171   8172   8173   8174   8175   8176   8177   8178   8179   817A   817B   817C   817D   817E   8221   8222   8223   8224   8225   8226   8227   8228   8229   822A   822B   822C   822D   822E   822F   8230   8231   8232   8233   8234   8235   8236   8237   8238   8239   823A   823B   823C   823D   823E   823F   8240   8241   8242   8243   8244   8245   8246   8247   8248   8249   824A   824B   824C   824D   824E   824F   8250   8251   8252   8253   8254   8255   8256   8257   8258   8259   825A   825B   825C   825D   825E   825F   8260   8261   8262   8263   8264   8265   8266   8267   8268   8269   826A   826B   826C   826D   826E   826F   8270   8271   8272   8273   8274   8275   8276   8277   8278   8279   827A   827B   827C   827D   827E   )],
    'F2' => [qw( 8321   8322   8323   8324   8325   8326   8327   8328   8329   832A   832B   832C   832D   832E   832F   8330   8331   8332   8333   8334   8335   8336   8337   8338   8339   833A   833B   833C   833D   833E   833F   8340   8341   8342   8343   8344   8345   8346   8347   8348   8349   834A   834B   834C   834D   834E   834F   8350   8351   8352   8353   8354   8355   8356   8357   8358   8359   835A   835B   835C   835D   835E   835F   8360   8361   8362   8363   8364   8365   8366   8367   8368   8369   836A   836B   836C   836D   836E   836F   8370   8371   8372   8373   8374   8375   8376   8377   8378   8379   837A   837B   837C   837D   837E   8421   8422   8423   8424   8425   8426   8427   8428   8429   842A   842B   842C   842D   842E   842F   8430   8431   8432   8433   8434   8435   8436   8437   8438   8439   843A   843B   843C   843D   843E   843F   8440   8441   8442   8443   8444   8445   8446   8447   8448   8449   844A   844B   844C   844D   844E   844F   8450   8451   8452   8453   8454   8455   8456   8457   8458   8459   845A   845B   845C   845D   845E   845F   8460   8461   8462   8463   8464   8465   8466   8467   8468   8469   846A   846B   846C   846D   846E   846F   8470   8471   8472   8473   8474   8475   8476   8477   8478   8479   847A   847B   847C   847D   847E   )],
    'F3' => [qw( 8521   8522   8523   8524   8525   8526   8527   8528   8529   852A   852B   852C   852D   852E   852F   8530   8531   8532   8533   8534   8535   8536   8537   8538   8539   853A   853B   853C   853D   853E   853F   8540   8541   8542   8543   8544   8545   8546   8547   8548   8549   854A   854B   854C   854D   854E   854F   8550   8551   8552   8553   8554   8555   8556   8557   8558   8559   855A   855B   855C   855D   855E   855F   8560   8561   8562   8563   8564   8565   8566   8567   8568   8569   856A   856B   856C   856D   856E   856F   8570   8571   8572   8573   8574   8575   8576   8577   8578   8579   857A   857B   857C   857D   857E   8621   8622   8623   8624   8625   8626   8627   8628   8629   862A   862B   862C   862D   862E   862F   8630   8631   8632   8633   8634   8635   8636   8637   8638   8639   863A   863B   863C   863D   863E   863F   8640   8641   8642   8643   8644   8645   8646   8647   8648   8649   864A   864B   864C   864D   864E   864F   8650   8651   8652   8653   8654   8655   8656   8657   8658   8659   865A   865B   865C   865D   865E   865F   8660   8661   8662   8663   8664   8665   8666   8667   8668   8669   866A   866B   866C   866D   866E   866F   8670   8671   8672   8673   8674   8675   8676   8677   8678   8679   867A   867B   867C   867D   867E   )],
    'F4' => [qw( 8721   8722   8723   8724   8725   8726   8727   8728   8729   872A   872B   872C   872D   872E   872F   8730   8731   8732   8733   8734   8735   8736   8737   8738   8739   873A   873B   873C   873D   873E   873F   8740   8741   8742   8743   8744   8745   8746   8747   8748   8749   874A   874B   874C   874D   874E   874F   8750   8751   8752   8753   8754   8755   8756   8757   8758   8759   875A   875B   875C   875D   875E   875F   8760   8761   8762   8763   8764   8765   8766   8767   8768   8769   876A   876B   876C   876D   876E   876F   8770   8771   8772   8773   8774   8775   8776   8777   8778   8779   877A   877B   877C   877D   877E   8821   8822   8823   8824   8825   8826   8827   8828   8829   882A   882B   882C   882D   882E   882F   8830   8831   8832   8833   8834   8835   8836   8837   8838   8839   883A   883B   883C   883D   883E   883F   8840   8841   8842   8843   8844   8845   8846   8847   8848   8849   884A   884B   884C   884D   884E   884F   8850   8851   8852   8853   8854   8855   8856   8857   8858   8859   885A   885B   885C   885D   885E   885F   8860   8861   8862   8863   8864   8865   8866   8867   8868   8869   886A   886B   886C   886D   886E   886F   8870   8871   8872   8873   8874   8875   8876   8877   8878   8879   887A   887B   887C   887D   887E   )],
    'F5' => [qw( 8921   8922   8923   8924   8925   8926   8927   8928   8929   892A   892B   892C   892D   892E   892F   8930   8931   8932   8933   8934   8935   8936   8937   8938   8939   893A   893B   893C   893D   893E   893F   8940   8941   8942   8943   8944   8945   8946   8947   8948   8949   894A   894B   894C   894D   894E   894F   8950   8951   8952   8953   8954   8955   8956   8957   8958   8959   895A   895B   895C   895D   895E   895F   8960   8961   8962   8963   8964   8965   8966   8967   8968   8969   896A   896B   896C   896D   896E   896F   8970   8971   8972   8973   8974   8975   8976   8977   8978   8979   897A   897B   897C   897D   897E   8A21   8A22   8A23   8A24   8A25   8A26   8A27   8A28   8A29   8A2A   8A2B   8A2C   8A2D   8A2E   8A2F   8A30   8A31   8A32   8A33   8A34   8A35   8A36   8A37   8A38   8A39   8A3A   8A3B   8A3C   8A3D   8A3E   8A3F   8A40   8A41   8A42   8A43   8A44   8A45   8A46   8A47   8A48   8A49   8A4A   8A4B   8A4C   8A4D   8A4E   8A4F   8A50   8A51   8A52   8A53   8A54   8A55   8A56   8A57   8A58   8A59   8A5A   8A5B   8A5C   8A5D   8A5E   8A5F   8A60   8A61   8A62   8A63   8A64   8A65   8A66   8A67   8A68   8A69   8A6A   8A6B   8A6C   8A6D   8A6E   8A6F   8A70   8A71   8A72   8A73   8A74   8A75   8A76   8A77   8A78   8A79   8A7A   8A7B   8A7C   8A7D   8A7E   )],
    'F6' => [qw( 8B21   8B22   8B23   8B24   8B25   8B26   8B27   8B28   8B29   8B2A   8B2B   8B2C   8B2D   8B2E   8B2F   8B30   8B31   8B32   8B33   8B34   8B35   8B36   8B37   8B38   8B39   8B3A   8B3B   8B3C   8B3D   8B3E   8B3F   8B40   8B41   8B42   8B43   8B44   8B45   8B46   8B47   8B48   8B49   8B4A   8B4B   8B4C   8B4D   8B4E   8B4F   8B50   8B51   8B52   8B53   8B54   8B55   8B56   8B57   8B58   8B59   8B5A   8B5B   8B5C   8B5D   8B5E   8B5F   8B60   8B61   8B62   8B63   8B64   8B65   8B66   8B67   8B68   8B69   8B6A   8B6B   8B6C   8B6D   8B6E   8B6F   8B70   8B71   8B72   8B73   8B74   8B75   8B76   8B77   8B78   8B79   8B7A   8B7B   8B7C   8B7D   8B7E   8C21   8C22   8C23   8C24   8C25   8C26   8C27   8C28   8C29   8C2A   8C2B   8C2C   8C2D   8C2E   8C2F   8C30   8C31   8C32   8C33   8C34   8C35   8C36   8C37   8C38   8C39   8C3A   8C3B   8C3C   8C3D   8C3E   8C3F   8C40   8C41   8C42   8C43   8C44   8C45   8C46   8C47   8C48   8C49   8C4A   8C4B   8C4C   8C4D   8C4E   8C4F   8C50   8C51   8C52   8C53   8C54   8C55   8C56   8C57   8C58   8C59   8C5A   8C5B   8C5C   8C5D   8C5E   8C5F   8C60   8C61   8C62   8C63   8C64   8C65   8C66   8C67   8C68   8C69   8C6A   8C6B   8C6C   8C6D   8C6E   8C6F   8C70   8C71   8C72   8C73   8C74   8C75   8C76   8C77   8C78   8C79   8C7A   8C7B   8C7C   8C7D   8C7E   )],
    'F7' => [qw( 8D21   8D22   8D23   8D24   8D25   8D26   8D27   8D28   8D29   8D2A   8D2B   8D2C   8D2D   8D2E   8D2F   8D30   8D31   8D32   8D33   8D34   8D35   8D36   8D37   8D38   8D39   8D3A   8D3B   8D3C   8D3D   8D3E   8D3F   8D40   8D41   8D42   8D43   8D44   8D45   8D46   8D47   8D48   8D49   8D4A   8D4B   8D4C   8D4D   8D4E   8D4F   8D50   8D51   8D52   8D53   8D54   8D55   8D56   8D57   8D58   8D59   8D5A   8D5B   8D5C   8D5D   8D5E   8D5F   8D60   8D61   8D62   8D63   8D64   8D65   8D66   8D67   8D68   8D69   8D6A   8D6B   8D6C   8D6D   8D6E   8D6F   8D70   8D71   8D72   8D73   8D74   8D75   8D76   8D77   8D78   8D79   8D7A   8D7B   8D7C   8D7D   8D7E   8E21   8E22   8E23   8E24   8E25   8E26   8E27   8E28   8E29   8E2A   8E2B   8E2C   8E2D   8E2E   8E2F   8E30   8E31   8E32   8E33   8E34   8E35   8E36   8E37   8E38   8E39   8E3A   8E3B   8E3C   8E3D   8E3E   8E3F   8E40   8E41   8E42   8E43   8E44   8E45   8E46   8E47   8E48   8E49   8E4A   8E4B   8E4C   8E4D   8E4E   8E4F   8E50   8E51   8E52   8E53   8E54   8E55   8E56   8E57   8E58   8E59   8E5A   8E5B   8E5C   8E5D   8E5E   8E5F   8E60   8E61   8E62   8E63   8E64   8E65   8E66   8E67   8E68   8E69   8E6A   8E6B   8E6C   8E6D   8E6E   8E6F   8E70   8E71   8E72   8E73   8E74   8E75   8E76   8E77   8E78   8E79   8E7A   8E7B   8E7C   8E7D   8E7E   )],
    'F8' => [qw( 8F21   8F22   8F23   8F24   8F25   8F26   8F27   8F28   8F29   8F2A   8F2B   8F2C   8F2D   8F2E   8F2F   8F30   8F31   8F32   8F33   8F34   8F35   8F36   8F37   8F38   8F39   8F3A   8F3B   8F3C   8F3D   8F3E   8F3F   8F40   8F41   8F42   8F43   8F44   8F45   8F46   8F47   8F48   8F49   8F4A   8F4B   8F4C   8F4D   8F4E   8F4F   8F50   8F51   8F52   8F53   8F54   8F55   8F56   8F57   8F58   8F59   8F5A   8F5B   8F5C   8F5D   8F5E   8F5F   8F60   8F61   8F62   8F63   8F64   8F65   8F66   8F67   8F68   8F69   8F6A   8F6B   8F6C   8F6D   8F6E   8F6F   8F70   8F71   8F72   8F73   8F74   8F75   8F76   8F77   8F78   8F79   8F7A   8F7B   8F7C   8F7D   8F7E   9021   9022   9023   9024   9025   9026   9027   9028   9029   902A   902B   902C   902D   902E   902F   9030   9031   9032   9033   9034   9035   9036   9037   9038   9039   903A   903B   903C   903D   903E   903F   9040   9041   9042   9043   9044   9045   9046   9047   9048   9049   904A   904B   904C   904D   904E   904F   9050   9051   9052   9053   9054   9055   9056   9057   9058   9059   905A   905B   905C   905D   905E   905F   9060   9061   9062   9063   9064   9065   9066   9067   9068   9069   906A   906B   906C   906D   906E   906F   9070   9071   9072   9073   9074   9075   9076   9077   9078   9079   907A   907B   907C   907D   907E   )],
    'F9' => [qw( 9121   9122   9123   9124   9125   9126   9127   9128   9129   912A   912B   912C   912D   912E   912F   9130   9131   9132   9133   9134   9135   9136   9137   9138   9139   913A   913B   913C   913D   913E   913F   9140   9141   9142   9143   9144   9145   9146   9147   9148   9149   914A   914B   914C   914D   914E   914F   9150   9151   9152   9153   9154   9155   9156   9157   9158   9159   915A   915B   915C   915D   915E   915F   9160   9161   9162   9163   9164   9165   9166   9167   9168   9169   916A   916B   916C   916D   916E   916F   9170   9171   9172   9173   9174   9175   9176   9177   9178   9179   917A   917B   917C   917D   917E   9221   9222   9223   9224   9225   9226   9227   9228   9229   922A   922B   922C   922D   922E   922F   9230   9231   9232   9233   9234   9235   9236   9237   9238   9239   923A   923B   923C   923D   923E   923F   9240   9241   9242   9243   9244   9245   9246   9247   9248   9249   924A   924B   924C   924D   924E   924F   9250   9251   9252   9253   9254   9255   9256   9257   9258   9259   925A   925B   925C   925D   925E   925F   9260   9261   9262   9263   9264   9265   9266   9267   9268   9269   926A   926B   926C   926D   926E   926F   9270   9271   9272   9273   9274   9275   9276   9277   9278   9279   927A   927B   927C   927D   927E   )],
    'FA' => [qw( 9321   9322   9323   9324   9325   9326   9327   9328   9329   932A   932B   932C   932D   932E   932F   9330   9331   9332   9333   9334   9335   9336   9337   9338   9339   933A   933B   933C   933D   933E   933F   9340   9341   9342   9343   9344   9345   9346   9347   9348   9349   934A   934B   934C   934D   934E   934F   9350   9351   9352   9353   9354   9355   9356   9357   9358   9359   935A   935B   935C   935D   935E   935F   9360   9361   9362   9363   9364   9365   9366   9367   9368   9369   936A   936B   936C   936D   936E   936F   9370   9371   9372   9373   9374   9375   9376   9377   9378   9379   937A   937B   937C   937D   937E   9421   9422   9423   9424   9425   9426   9427   9428   9429   942A   942B   942C   942D   942E   942F   9430   9431   9432   9433   9434   9435   9436   9437   9438   9439   943A   943B   943C   943D   943E   943F   9440   9441   9442   9443   9444   9445   9446   9447   9448   9449   944A   944B   944C   944D   944E   944F   9450   9451   9452   9453   9454   9455   9456   9457   9458   9459   945A   945B   945C   945D   945E   945F   9460   9461   9462   9463   9464   9465   9466   9467   9468   9469   946A   946B   946C   946D   946E   946F   9470   9471   9472   9473   9474   9475   9476   9477   9478   9479   947A   947B   947C   947D   947E   )],
    'FB' => [qw( 9521   9522   9523   9524   9525   9526   9527   9528   9529   952A   952B   952C   952D   952E   952F   9530   9531   9532   9533   9534   9535   9536   9537   9538   9539   953A   953B   953C   953D   953E   953F   9540   9541   9542   9543   9544   9545   9546   9547   9548   9549   954A   954B   954C   954D   954E   954F   9550   9551   9552   9553   9554   9555   9556   9557   9558   9559   955A   955B   955C   955D   955E   955F   9560   9561   9562   9563   9564   9565   9566   9567   9568   9569   956A   956B   956C   956D   956E   956F   9570   9571   9572   9573   9574   9575   9576   9577   9578   9579   957A   957B   957C   957D   957E   9621   9622   9623   9624   9625   9626   9627   9628   9629   962A   962B   962C   962D   962E   962F   9630   9631   9632   9633   9634   9635   9636   9637   9638   9639   963A   963B   963C   963D   963E   963F   9640   9641   9642   9643   9644   9645   9646   9647   9648   9649   964A   964B   964C   964D   964E   964F   9650   9651   9652   9653   9654   9655   9656   9657   9658   9659   965A   965B   965C   965D   965E   965F   9660   9661   9662   9663   9664   9665   9666   9667   9668   9669   966A   966B   966C   966D   966E   966F   9670   9671   9672   9673   9674   9675   9676   9677   9678   9679   967A   967B   967C   967D   967E   )],
    'FC' => [qw( 9721   9722   9723   9724   9725   9726   9727   9728   9729   972A   972B   972C   972D   972E   972F   9730   9731   9732   9733   9734   9735   9736   9737   9738   9739   973A   973B   973C   973D   973E   973F   9740   9741   9742   9743   9744   9745   9746   9747   9748   9749   974A   974B   974C   974D   974E   974F   9750   9751   9752   9753   9754   9755   9756   9757   9758   9759   975A   975B   975C   975D   975E   975F   9760   9761   9762   9763   9764   9765   9766   9767   9768   9769   976A   976B   976C   976D   976E   976F   9770   9771   9772   9773   9774   9775   9776   9777   9778   9779   977A   977B   977C   977D   977E   9821   9822   9823   9824   9825   9826   9827   9828   9829   982A   982B   982C   982D   982E   982F   9830   9831   9832   9833   9834   9835   9836   9837   9838   9839   983A   983B   983C   983D   983E   983F   9840   9841   9842   9843   9844   9845   9846   9847   9848   9849   984A   984B   984C   984D   984E   984F   9850   9851   9852   9853   9854   9855   9856   9857   9858   9859   985A   985B   985C   985D   985E   985F   9860   9861   9862   9863   9864   9865   9866   9867   9868   9869   986A   986B   986C   986D   986E   986F   9870   9871   9872   9873   9874   9875   9876   9877   9878   9879   987A   987B   987C   987D   987E   )],
);

sub JISX0208GL_by_CP932 {
    my($cp932) = @_;

    if (my($hex1,$hex2) = $cp932 =~ /^([0123456789ABCDEF]{2})([0123456789ABCDEF]{2})$/) {
        if (defined $JISX0208GL_by_CP932{$hex1}[ $JISX0208GL_by_CP932{'00'}{$hex2} ]) {
            my $jis = $JISX0208GL_by_CP932{$hex1}[ $JISX0208GL_by_CP932{'00'}{$hex2} ];
            if (not_JIS78($jis)) {
                return '';
            }
            else {
                return $jis;
            }
        }
        else {
            return '';
        }
    }
    else {
        return '';
    }
}

1;

__END__
