/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.cli;

import com.beust.jcommander.IStringConverter;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.listeners.Prioritizer;
import org.openqa.grid.internal.utils.CapabilityMatcher;

abstract class StringToClassConverter<E> {
    StringToClassConverter() {
    }

    public E convert(String clazz) {
        try {
            return (E)Class.forName(clazz).newInstance();
        }
        catch (Throwable e) {
            throw new GridConfigurationException("Error creating class with " + clazz + " : " + e.getMessage(), e);
        }
    }

    static class PrioritizerStringConverter
    extends StringToClassConverter<Prioritizer>
    implements IStringConverter<Prioritizer> {
        PrioritizerStringConverter() {
        }
    }

    static class CapabilityMatcherStringConverter
    extends StringToClassConverter<CapabilityMatcher>
    implements IStringConverter<CapabilityMatcher> {
        CapabilityMatcherStringConverter() {
        }
    }
}

