/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.selenium.node;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;

public class FirefoxMutator
implements Function<Capabilities, Capabilities> {
    private static final String CONFIG_UUID_CAPABILITY = "server:CONFIG_UUID";
    private final Capabilities config;

    public FirefoxMutator(Capabilities config) {
        this.config = "firefox".equals(config.getBrowserName()) ? config : null;
    }

    @Override
    public Capabilities apply(Capabilities capabilities) {
        if (this.config == null || !"firefox".equals(capabilities.getBrowserName())) {
            return capabilities;
        }
        if (!Objects.equals(this.config.getCapability(CONFIG_UUID_CAPABILITY), capabilities.getCapability(CONFIG_UUID_CAPABILITY))) {
            return capabilities;
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (capabilities.getCapability("moz:firefoxOptions") instanceof Map) {
            Map originalOptions = (Map)capabilities.getCapability("moz:firefoxOptions");
            options.putAll(originalOptions);
        }
        HashMap<String, Object> toReturn = new HashMap<String, Object>(capabilities.asMap());
        if (this.config.getCapability("firefox_binary") != null) {
            if (!(capabilities.getCapability("firefox_binary") instanceof String)) {
                toReturn.put("firefox_binary", this.config.getCapability("firefox_binary"));
            }
            if (!(options.get("binary") instanceof String)) {
                options.put("binary", this.config.getCapability("firefox_binary"));
            }
        }
        if (this.config.getCapability("marionette") != null) {
            toReturn.put("marionette", this.config.getCapability("marionette"));
        }
        if (!options.isEmpty()) {
            toReturn.put("moz:firefoxOptions", options);
        }
        return new ImmutableCapabilities(toReturn);
    }
}

