/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.json;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.CharBuffer;
import java.util.Objects;

class Input {
    public static final char EOF = '\uffff';
    private final Readable source;
    private boolean read;
    private char peekedChar;
    private char[] lastRead = new char[128];
    private int insertAt = 0;
    private boolean filled = false;

    public Input(Readable source) {
        this.source = Objects.requireNonNull(source);
    }

    public char peek() {
        this.init();
        return this.peekedChar;
    }

    public char read() {
        this.init();
        this.read = false;
        this.append();
        return this.peekedChar;
    }

    public String toString() {
        String preamble = "Last " + (this.filled ? this.lastRead.length : this.insertAt) + " characters read: ";
        if (!this.filled) {
            return preamble + new String(this.lastRead, 0, this.insertAt);
        }
        char[] buf = new char[this.lastRead.length];
        int lengthToRead = this.lastRead.length - this.insertAt;
        System.arraycopy(this.lastRead, this.insertAt, buf, 0, lengthToRead);
        System.arraycopy(this.lastRead, 0, buf, lengthToRead, this.insertAt);
        return preamble + new String(buf);
    }

    private void init() {
        int charsRead;
        if (this.read) {
            return;
        }
        CharBuffer buf = CharBuffer.allocate(1);
        try {
            charsRead = this.source.read(buf);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
        this.peekedChar = charsRead != 1 ? (char)65535 : buf.array()[0];
        this.read = true;
    }

    private void append() {
        if (this.peekedChar == '\uffff') {
            return;
        }
        this.lastRead[this.insertAt] = this.peekedChar;
        ++this.insertAt;
        this.insertAt %= this.lastRead.length;
        if (this.insertAt == 0) {
            this.filled = true;
        }
    }
}

