/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.opera;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;

public class OperaOptions
extends MutableCapabilities {
    public static final String CAPABILITY = "operaOptions";
    private String binary;
    private List<String> args = new ArrayList<String>();
    private List<File> extensionFiles = new ArrayList<File>();
    private List<String> extensions = new ArrayList<String>();
    private Map<String, Object> experimentalOptions = new HashMap<String, Object>();

    public OperaOptions() {
        this.setCapability("browserName", "operablink");
    }

    @Override
    public OperaOptions merge(Capabilities extraCapabilities) {
        super.merge(extraCapabilities);
        return this;
    }

    public OperaOptions setBinary(File path) {
        this.binary = Preconditions.checkNotNull(path).getPath();
        return this;
    }

    public OperaOptions setBinary(String path) {
        this.binary = Preconditions.checkNotNull(path);
        return this;
    }

    public OperaOptions addArguments(String ... arguments) {
        this.addArguments(ImmutableList.copyOf(arguments));
        return this;
    }

    public OperaOptions addArguments(List<String> arguments) {
        this.args.addAll(arguments);
        return this;
    }

    public OperaOptions addExtensions(File ... paths) {
        this.addExtensions(ImmutableList.copyOf(paths));
        return this;
    }

    public OperaOptions addExtensions(List<File> paths) {
        for (File path : paths) {
            Preconditions.checkNotNull(path);
            Preconditions.checkArgument(path.exists(), "%s does not exist", (Object)path.getAbsolutePath());
            Preconditions.checkArgument(!path.isDirectory(), "%s is a directory", (Object)path.getAbsolutePath());
        }
        this.extensionFiles.addAll(paths);
        return this;
    }

    public OperaOptions addEncodedExtensions(String ... encoded) {
        this.addEncodedExtensions(ImmutableList.copyOf(encoded));
        return this;
    }

    public OperaOptions addEncodedExtensions(List<String> encoded) {
        for (String extension : encoded) {
            Preconditions.checkNotNull(extension);
        }
        this.extensions.addAll(encoded);
        return this;
    }

    public OperaOptions setExperimentalOption(String name, Object value) {
        this.experimentalOptions.put(Preconditions.checkNotNull(name), value);
        return this;
    }

    public Object getExperimentalOption(String name) {
        return this.experimentalOptions.get(Preconditions.checkNotNull(name));
    }

    public OperaOptions setProxy(Proxy proxy) {
        this.setCapability("proxy", proxy);
        return this;
    }

    @Override
    public Map<String, Object> asMap() {
        TreeMap toReturn = new TreeMap(super.asMap());
        TreeMap<String, Object> options = new TreeMap<String, Object>();
        for (String key : this.experimentalOptions.keySet()) {
            options.put(key, this.experimentalOptions.get(key));
        }
        if (this.binary != null) {
            options.put("binary", this.binary);
        }
        options.put("args", ImmutableList.copyOf(this.args));
        ArrayList<String> encoded_extensions = new ArrayList<String>(this.extensionFiles.size() + this.extensions.size());
        for (File path : this.extensionFiles) {
            try {
                String encoded = Base64.getEncoder().encodeToString(Files.toByteArray(path));
                encoded_extensions.add(encoded);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
        encoded_extensions.addAll(this.extensions);
        options.put("extensions", encoded_extensions);
        toReturn.put(CAPABILITY, options);
        return Collections.unmodifiableMap(toReturn);
    }
}

