/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import java.io.IOException;
import java.util.Objects;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.ActiveSession;

public class ActiveSessionCommandExecutor
implements CommandExecutor {
    private final ActiveSession session;
    private boolean active;

    public ActiveSessionCommandExecutor(ActiveSession session) {
        this.session = Objects.requireNonNull(session, "Session must not be null");
    }

    @Override
    public Response execute(Command command) throws IOException {
        if ("newSession".equals(command.getName())) {
            if (this.active) {
                throw new WebDriverException("Cannot start session twice! " + this.session);
            }
            this.active = true;
            Response response = new Response(this.session.getId());
            response.setValue(this.session.getCapabilities());
            return response;
        }
        HttpRequest request = this.session.getUpstreamDialect().getCommandCodec().encode(command);
        HttpResponse httpResponse = new HttpResponse();
        this.session.execute(request, httpResponse);
        return this.session.getDownstreamDialect().getResponseCodec().decode(httpResponse);
    }
}

