# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::UA;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20221202211028;

my $formatters = [
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            6[12][29]|
            (?:
              35|
              4[1378]|
              5[12457]|
              6[49]
            )2|
            (?:
              56|
              65
            )[24]|
            (?:
              3[1-46-8]|
              46
            )2[013-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[1-8]|
            4(?:
              [1367]|
              [45][6-9]|
              8[4-6]
            )|
            5(?:
              [1-5]|
              6(?:
                [015689]|
                3[02389]
              )|
              7[4-6]
            )|
            6(?:
              [12][3-7]|
              [459]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [3-7]|
            89|
            9[1-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[89]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3,4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            3[1-8]|
            4[13-8]|
            5[1-7]|
            6[12459]
          )\\d{7}
        ',
                'geographic' => '
          (?:
            3[1-8]|
            4[13-8]|
            5[1-7]|
            6[12459]
          )\\d{7}
        ',
                'mobile' => '
          (?:
            39|
            50|
            6[36-8]|
            7[1-3]|
            9[1-9]
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(900[239]\\d{5,6})',
                'toll_free' => '800[1-8]\\d{5,6}',
                'voip' => '89[1-579]\\d{6}'
              };
my %areanames = ();
$areanames{en} = {"3804840", "Reni\,\ Odesa",
"3804854", "Ivanivka\,\ Odesa",
"3804857", "Nikolaevka\,\ Odesa",
"3803856", "Derazhnya\,\ Khmelnytskyi",
"3805533", "Novovorontsovka\,\ Kherson",
"3805366", "Kremenchug\,\ Poltava",
"3806260", "Kramatorsk\/Slavyansk\,\ Donetsk",
"3804633", "Ichnya\,\ Chernihiv",
"3803436", "Tysmenytsia\,\ Ivano\-Frankivsk",
"3804578", "Makarov\,\ Kyiv",
"380622", "Donetsk",
"3806451", "Lisichansk\,\ Luhansk",
"3804343", "Ladyzhin\/Trostyanets\,\ Vinnytsia",
"3803233", "Lviv",
"3806252", "Yenakievo\,\ Donetsk",
"3803659", "Mlyniv\,\ Rivne",
"3803635", "Rokitne\,\ Rivne",
"3804561", "Boguslav\,\ Kyiv",
"3803543", "Podvolochisk\,\ Ternopil",
"3805693", "Novomoskovsk\,\ Dnipro",
"3805542", "Tsyurupinsk\,\ Kherson",
"3803264", "Busk\,\ Lviv",
"3806178", "Tokmak\,\ Zaporizhzhia",
"3805446", "Tomatoes\,\ Sumy",
"3803267", "Lviv",
"3805755", "Kegichivka\,\ Kharkiv",
"3804642", "Sedimentary\,\ Chernihiv",
"3806145", "Gulyaypole\,\ Zaporizhzhia",
"3805661", "Nikopol\,\ Dnipro",
"3805359", "Hrebinka\,\ Poltava",
"3803242", "Lviv",
"3804332", "Brailiv\/Zhmerinka\,\ Vinnytsia",
"380647", "Luhansk",
"3806132", "Mikhailivka\,\ Zaporizhzhia",
"3803235", "Lviv",
"3804345", "Illintsi\,\ Vinnytsia",
"3806270", "Artemivsk\,\ Donetsk",
"3804139", "Chudniv\,\ Zhytomyr",
"3805152", "Domanivka\,\ Mykolayiv",
"3804635", "Baturin\/Bahmach\,\ Chernihiv",
"3804749", "Lysyanka\,\ Cherkasy",
"3804568", "Skvyra\,\ Kyiv",
"3805447", "Konotop\,\ Sumy",
"3805535", "Vysokoplylya\,\ Kherson",
"3803266", "Brody\,\ Lviv",
"3805668", "Tomakivka\,\ Dnipro",
"3805444", "Glukhov\,\ Sumy",
"380623", "Krasnoarmeysk\/Makeyevka\,\ Donetsk",
"3806249", "Debaltsevo\,\ Donetsk",
"3803475", "Delyatin\/Nadvirna\,\ Ivano\-Frankivsk",
"3806430", "Luhansk",
"3806143", "Vilnyansk\,\ Zaporizhzhia",
"3804856", "Berezivka\,\ Odesa",
"3803857", "Letychiv\/Medzhybizh\,\ Khmelnytskyi",
"380621", "Donetsk",
"3803854", "Starokostiantyniv\,\ Khmelnytskyi",
"3804595", "Borispol\,\ Kyiv",
"3805753", "Valki\,\ Kharkiv",
"3803840", "Shepetovka\,\ Khmelnytskyi",
"3804659", "Semenivka\,\ Chernihiv",
"3804571", "Vasilkov\/Glevaha\/Grebinky\/Kalinovka\,\ Kyiv",
"3805367", "Kremenchug\,\ Poltava",
"3805632", "Pavlograd\,\ Dnipro",
"3805364", "Mashivka\,\ Poltava",
"3803368", "Rozhysche\,\ Volyn",
"3806458", "Luhansk",
"3803437", "Bolechov\,\ Ivano\-Frankivsk",
"3803259", "Yavoriv\,\ Lviv",
"3805342", "Kozelshchina\,\ Poltava",
"3803633", "Radivilov\,\ Rivne",
"3803434", "Vorokhta\/Yaremche\,\ Ivano\-Frankivsk",
"3804358", "Lipovets\,\ Vinnytsia",
"3806262", "Svyatogorsk\/Slavyansk\,\ Donetsk",
"3805449", "Shostka\,\ Sumy",
"3806461", "Starobilsk\,\ Luhansk",
"3806250", "Kirovske\,\ Donetsk",
"3805356", "Lokhvytsia\,\ Poltava",
"38035", "Ternopil",
"3806244", "Volnovaha\,\ Donetsk",
"3806247", "Dzerzhinsk\,\ Donetsk",
"3803136", "Volovets\,\ Zakarpattia",
"3806296", "Novoazovsk\,\ Donetsk",
"3805741", "Vovchansk\,\ Kharkiv",
"3804747", "Zhashkiv\,\ Cherkasy",
"3804864", "Lyubashevka\,\ Odesa",
"3804134", "Chernyakhov\,\ Zhytomyr",
"38052", "Kirovohrad",
"3804867", "Kodima\,\ Odesa",
"3804744", "Uman\,\ Cherkasy",
"3804137", "Popilnya\,\ Zhytomyr",
"3805131", "Bratsk\,\ Mykolayiv",
"3804654", "Shchors\,\ Chernihiv",
"3804657", "Koryukivka\,\ Chernihiv",
"3805651", "Dnipropetrovsk\/Dnipro",
"3805369", "Kremenchug\,\ Poltava",
"3804330", "Oratov\,\ Vinnytsia",
"3803656", "Dubno\,\ Rivne",
"3803240", "Lviv",
"3805258", "Malaya\ Vyska\,\ Kirovohrad",
"3803254", "Kamyanka\-Buzka\,\ Lviv",
"3805765", "Pechenegi\,\ Kharkiv",
"3803257", "Sokal\,\ Lviv",
"38043", "Vinnytsia",
"3804148", "Ovruch\,\ Zhytomyr",
"3806445", "Novoyadar\,\ Luhansk",
"3803141", "Berehove\,\ Zakarpattia",
"3804738", "Drabiv\,\ Cherkasy",
"3805540", "Lower\ Sirogozy\,\ Kherson",
"3803558", "Shumsk\,\ Ternopil",
"3803859", "Chemerivtsi\,\ Khmelnytskyi",
"3805251", "Novoukrainka\,\ Kirovohrad",
"380328", "Lviv",
"3805452", "Lipova\ Dolina\,\ Sumy",
"3804656", "Carp\,\ Chernihiv",
"3806432", "Krasnyi\ Luch\,\ Luhansk",
"3803657", "Kostopil\,\ Rivne",
"3805658", "Verhnedneprovsk\,\ Dnipro",
"3803654", "Ostrog\,\ Rivne",
"38061", "Zaporizhzhia",
"3803256", "Novoyavorivsk\,\ Lviv",
"3806272", "Kostiantynivka\,\ Donetsk",
"3804859", "Velikaya\ Mikhailovka\,\ Odesa",
"3803551", "Terebovlya\,\ Ternopil",
"3805162", "Snigurovka\,\ Mykolayiv",
"3806471", "Swatov\,\ Luhansk",
"3803738", "Putila\,\ Chernivtsi",
"3804141", "Novograd\-Volynsky\,\ Zhytomyr",
"3804731", "Talne\,\ Cherkasy",
"38033", "Volyn",
"3803269", "Turka\,\ Lviv",
"38045", "Kyiv",
"3805630", "Mezhova\,\ Dnipro",
"3806443", "Bryanka\,\ Luhansk",
"3805357", "Orzhitsa\,\ Poltava",
"3804351", "Chechelnyk\,\ Vinnytsia",
"3806468", "Luhansk",
"3805340", "Chornukhi\,\ Poltava",
"3805354", "Gadyach\,\ Poltava",
"3806246", "Volodarske\,\ Donetsk",
"3805748", "Pervomaysk\,\ Kharkiv",
"3806297", "Mangosh\/Yalta\,\ Donetsk",
"3803134", "Solotvyno\/Tyachiv\,\ Zakarpattia",
"3805763", "Carriers\,\ Kharkiv",
"3803842", "Netishyn\/Slavuta\,\ Khmelnytskyi",
"3804746", "Monastyrysche\,\ Cherkasy",
"380567", "Dnipropetrovsk\/Dnipro",
"3804866", "Balta\,\ Odesa",
"3804136", "Andrushivka\,\ Zhytomyr",
"3805663", "Sinelnikovo\,\ Dnipro",
"3803650", "Goshcha\,\ Rivne",
"3803246", "Lviv",
"3804336", "Yampil\,\ Vinnytsia",
"3805241", "Novgorodka\,\ Kirovohrad",
"3804591", "Ivankiv\,\ Kyiv",
"3806269", "Aleksandrovka\,\ Donetsk",
"38057", "Kharkiv",
"3805442", "Putivl\,\ Sumy",
"3804646", "Desna\/Kozelets\/Oster\,\ Chernihiv",
"3805691", "Magdalenivka\,\ Dnipro",
"3805546", "Berislav\,\ Kherson",
"3805154", "Ochakiv\,\ Mykolayiv",
"3804575", "Yagotin\,\ Kyiv",
"3806137", "Primorsk\,\ Zaporizhzhia",
"3803541", "Borschiv\,\ Ternopil",
"3804849", "Belgorod\-Dniester\/Zatoka\/Sergievka\,\ Odesa",
"3804563", "Belaya\ Tserkov\/Uzin\,\ Kyiv",
"380640", "Luhansk",
"3803432", "Verkhovyna\,\ Ivano\-Frankivsk",
"3803363", "Turiysk\,\ Volyn",
"3806453", "Rubizhne\,\ Luhansk",
"3804341", "Bar\,\ Vinnytsia",
"3805347", "Chutovoye\,\ Poltava",
"3803231", "Gorodok\,\ Lviv",
"3805350", "Kotelva\,\ Poltava",
"3806256", "Snizhne\,\ Donetsk",
"38031", "Zakarpattia",
"3805344", "New\ Sanzhary\,\ Poltava",
"3805362", "Khorol\,\ Poltava",
"380628", "Donetsk",
"3805637", "Pavlograd\,\ Dnipro",
"3804631", "Nizhyn\,\ Chernihiv",
"3805236", "Svetlovodsk\,\ Kirovohrad",
"3805634", "Petrykivka\,\ Dnipro",
"3803852", "Iziaslav\,\ Khmelnytskyi",
"3805531", "Ivanivka\,\ Kherson",
"3803740", "Hertz\,\ Chernivtsi",
"380649", "Luhansk",
"3803471", "Bogorodchany\,\ Ivano\-Frankivsk",
"3805758", "Bogodukhiv\,\ Kharkiv",
"3806175", "Vasilivka\/Dneprorudne\,\ Zaporizhzhia",
"3806240", "Gorlovka\,\ Donetsk",
"3806254", "Torez\,\ Donetsk",
"3804565", "Fastov\,\ Kyiv",
"3805346", "Karlovka\,\ Poltava",
"3806257", "Ilovajsk\/Khartsyzsk\,\ Donetsk",
"3806439", "Luhansk",
"3804348", "Tomashpil\,\ Vinnytsia",
"38041", "Zhytomyr",
"3805234", "Dolinska\,\ Kirovohrad",
"3803238", "Old\ Sambir\,\ Lviv",
"3805636", "Ternivka\,\ Dnipro",
"3805237", "Petrov\,\ Kirovohrad",
"3805459", "Krasnopolye\,\ Sumy",
"3804573", "Kagarlyk\/Rzhyshchiv\,\ Kyiv",
"3805751", "Shevchenkovo\,\ Kharkiv",
"3804130", "Korostyshiv\,\ Zhytomyr",
"3803478", "Kosiv\,\ Ivano\-Frankivsk",
"3804860", "Frunzivka\,\ Odesa",
"3804740", "Vatutina\/Zvenigorodka\,\ Cherkasy",
"3805538", "Askania\-Nova\/Chaplinka\,\ Kherson",
"3805665", "Manganese\,\ Dnipro",
"3806141", "Orychiv\,\ Zaporizhzhia",
"3806279", "Telmanov\,\ Donetsk",
"3804852", "Belyaevka\,\ Odesa",
"3803250", "Lviv",
"3804598", "Boyarka\/Vishnevoe\,\ Kyiv",
"3803244", "Drogobych\,\ Lviv",
"3804334", "Haysin\,\ Vinnytsia",
"38065", "Crimea",
"3804337", "Mogilev\-Podolsky\,\ Vinnytsia",
"3803247", "Truskavets\,\ Lviv",
"3806165", "Childbirth\,\ Zaporizhzhia",
"3804644", "Mena\,\ Chernihiv",
"3803262", "Lviv",
"3805544", "Gornostaevka\,\ Kherson",
"3803548", "Berezhany\,\ Ternopil",
"3805547", "Belozerka\,\ Kherson",
"3803849", "Kamyanets\-Podilskyi\,\ Khmelnytskyi",
"3803365", "Kivertsi\/Tsuman\,\ Volyn",
"3806136", "Веселе\,\ Zaporizhzhia",
"3806455", "Pervomaisk\,\ Luhansk",
"380569", "Dneprodzerzhinsk\/Novomoskovsk\,\ Dnipro",
"380321", "Lviv",
"3805167", "New\ Odesa\,\ Mykolayiv",
"3804161", "Luginy\,\ Zhytomyr",
"3806277", "Dobropolia\,\ Donetsk",
"3803143", "Vinogradov\,\ Zakarpattia",
"3806274", "Artemivsk\/Siversk\,\ Donetsk",
"3803733", "Novoselytsia\,\ Chernivtsi",
"3804355", "Hnivan\/Tyvriv\,\ Vinnytsia",
"3805164", "Kazanka\,\ Mykolayiv",
"3806437", "Luhansk",
"3806259", "Amvrosievka\,\ Donetsk",
"3803652", "Zdolbunov\,\ Rivne",
"3806434", "Sverdlovsk\,\ Luhansk",
"3805653", "Volnogirsk\,\ Dnipro",
"380560", "Dnipropetrovsk\/Dnipro",
"3805457", "Great\ Pisarivka\,\ Sumy",
"3805239", "Ustinovka\,\ Kirovohrad",
"3805454", "Burin\,\ Sumy",
"3805133", "Creve\ Lake\,\ Mykolayiv",
"3805549", "New\ Kakhovka\,\ Kherson",
"3803847", "New\ Ushitsa\,\ Khmelnytskyi",
"3803844", "Theophyll\,\ Khmelnytskyi",
"3803850", "Old\ Sinyava\,\ Khmelnytskyi",
"3805743", "Izyum\,\ Kharkiv",
"3805255", "Novorangels\'k\,\ Kirovohrad",
"3803132", "Rakhiv\,\ Zakarpattia",
"3806153", "Berdyansk\,\ Zaporizhzhia",
"3804846", "Bolgrad\,\ Odesa",
"38034", "Ivano\-Frankivsk",
"3803249", "Chervonograd\,\ Lviv",
"3805352", "Shishaki\,\ Poltava",
"380619", "Melitopol\,\ Zaporizhzhia",
"3803430", "Gorodenka\,\ Ivano\-Frankivsk",
"3803555", "Monastery\,\ Ternopil",
"3806463", "Novopskov\,\ Luhansk",
"3804735", "Korsun\-Shevchenkivsky\,\ Cherkasy",
"3806266", "Kramatorsk\/Slavyansk\,\ Donetsk",
"3804145", "Volodarsk\-Volynsky\,\ Zhytomyr",
"3806448", "Luhansk",
"3805360", "Kremenchug\,\ Poltava",
"3803846", "Vinkivtsi\,\ Khmelnytskyi",
"3805655", "Dnipropetrovsk\/Dnipro",
"38044", "Kyiv\ city",
"3804742", "Katerinopil\,\ Cherkasy",
"3805159", "Elanets\,\ Mykolayiv",
"3804862", "Kotovsk\,\ Odesa",
"3804132", "Radomyshl\,\ Zhytomyr",
"3804850", "Teplodar\,\ Odesa",
"3804844", "Tatarbunary\,\ Odesa",
"3805761", "Zachepilivka\,\ Kharkiv",
"3806139", "Energodar\,\ Zaporizhzhia",
"3804847", "Tarutino\,\ Odesa",
"3803145", "Perechyn\,\ Zakarpattia",
"3806441", "Perevalsk\,\ Luhansk",
"3804353", "Teplik\,\ Vinnytsia",
"3803735", "Storozhynets\,\ Chernivtsi",
"3806242", "Gorlovka\,\ Donetsk",
"3806264", "Kramatorsk\,\ Donetsk",
"3806267", "Druzhkovka\,\ Donetsk",
"3806465", "Milow\,\ Luhansk",
"3803355", "Shatsk\,\ Volyn",
"3804733", "Smila\,\ Cherkasy",
"3804143", "Berdychiv\,\ Zhytomyr",
"3806276", "Artemivsk\,\ Donetsk",
"3803122", "Uzhhorod\,\ Zakarpattia",
"3806473", "Slavyanoserbsk\,\ Luhansk",
"3806436", "Lutugin\,\ Luhansk",
"380322", "Bryukhovichi\/Lviv\,\ Lviv",
"3803252", "Zhovkva\,\ Lviv",
"3805135", "Vradievka\,\ Mykolayiv",
"3805456", "Yampil\,\ Sumy",
"3803260", "Morshin\,\ Lviv",
"380564", "Krivoy\ Rog\,\ Dnipro",
"3805639", "Vasylkivka\,\ Dnipro",
"3805253", "Dobrovelichkovka\,\ Kirovohrad",
"3805745", "Lozova\,\ Kharkiv",
"3805153", "Berezanka\,\ Mykolayiv",
"3803376", "Manevichi\,\ Volyn",
"3805235", "Alexandria\,\ Kirovohrad",
"38069", "Sevastopol\ city",
"3806133", "Priazovskoe\,\ Zaporizhzhia",
"3804567", "Pereyaslav\-Khmelnitsky\,\ Kyiv",
"380312", "Uzhgorod\/Chop\,\ Zakarpattia",
"3804564", "Stavyshche\,\ Kyiv",
"3806255", "Shakhtarsk\,\ Donetsk",
"3805667", "Ordzhonikidze\,\ Dnipro",
"3805664", "Nikopol\,\ Dnipro",
"3805448", "Romny\,\ Sumy",
"3803261", "Novy\ Rozdol\,\ Lviv",
"38038", "Khmelnytskyi",
"3804149", "Emilchine\,\ Zhytomyr",
"380572", "Merefa\/Kharkiv\,\ Kharkiv",
"3804739", "Chernobyl\,\ Cherkasy",
"3805752", "Great\ Burluk\,\ Kharkiv",
"3804645", "Gorodnya\,\ Chernihiv",
"3804851", "Ovidiopol\,\ Odesa",
"3803858", "Dunaevtsi\,\ Khmelnytskyi",
"3804335", "Tulchin\,\ Vinnytsia",
"3803245", "Stryi\,\ Lviv",
"3803632", "Zarechnaya\,\ Rivne",
"3806457", "Luhansk",
"3806239", "Krasnoarmeysk\,\ Donetsk",
"3805343", "Kobelyaky\,\ Poltava",
"3806440", "Luhansk",
"3805368", "Kremenchug\,\ Poltava",
"3806454", "Kremenna\,\ Luhansk",
"3805259", "Ulyanovka\,\ Kirovohrad",
"3803342", "Volodymyr\-Volynsky\,\ Volyn",
"3805633", "Pershotravensk\,\ Dnipro",
"3803438", "Burshtyn\,\ Ivano\-Frankivsk",
"3804576", "Baryshevka\/Berezan\,\ Kyiv",
"3805545", "Upper\ Rogachik\,\ Kherson",
"3804858", "Shiryaevoe\,\ Odesa",
"3805532", "Great\ Aleksandrovka\,\ Kherson",
"3803851", "Gorodok\/Sataniv\,\ Khmelnytskyi",
"3803739", "Sokyryany\,\ Chernivtsi",
"3803472", "Kalush\,\ Ivano\-Frankivsk",
"380629", "Mariupol\,\ Donetsk",
"3803366", "Ratne\,\ Volyn",
"3806456", "Trinity\ Church\,\ Luhansk",
"380620", "Donetsk",
"3804342", "Kozatin\,\ Vinnytsia",
"3803232", "Lviv",
"3806253", "Starobesheve\,\ Donetsk",
"3803431", "Halych\,\ Ivano\-Frankivsk",
"3804574", "Myronivka\,\ Kyiv",
"3805233", "Znamenka\,\ Kirovohrad",
"380648", "Luhansk",
"3804632", "Bobrovitsa\,\ Chernihiv",
"3805361", "Lubny\,\ Poltava",
"3804577", "Borodyanka\/Klavdievo\-Tarasovo\/Nemishaive\,\ Kyiv",
"3805659", "Dnipropetrovsk\/Dnipro",
"3805749", "Balaklia\,\ Kharkiv",
"3803374", "Lokachi\,\ Volyn",
"3805635", "Yurievka\,\ Dnipro",
"3805692", "Dneprodzerzhinsk\,\ Dnipro",
"3803377", "Lyuboml\,\ Volyn",
"3805543", "Great\ Lipetyha\,\ Kherson",
"38037312", "Khotin\,\ Chernivtsi",
"3804566", "Tarashcha\,\ Kyiv",
"3805345", "Big\ Bagachka\,\ Poltava",
"3803542", "Pidhaytsi\,\ Ternopil",
"3803268", "Lviv",
"3805666", "Nikopol\,\ Dnipro",
"38048", "Odesa",
"3803243", "Lviv",
"3804333", "Kalinovka\,\ Vinnytsia",
"3804643", "Kulikivka\,\ Chernihiv",
"3805242", "Aleksandrovka\,\ Kirovohrad",
"3806469", "Luhansk",
"3806433", "Rovenky\,\ Luhansk",
"3803251", "Skole\/Slavske\,\ Lviv",
"3806236", "Yasinovata\,\ Donetsk",
"3804845", "Artsis\,\ Odesa",
"3805657", "Broad\,\ Dnipro",
"3804579", "Slavutych\,\ Kyiv",
"3805453", "Krolevets\,\ Sumy",
"3805654", "Krynychky\,\ Dnipro",
"3803658", "Dubrovitsa\,\ Rivne",
"3805256", "Novomirgorod\,\ Kirovohrad",
"3804736", "Kaniv\,\ Cherkasy",
"3804146", "Dzerzhinsk\,\ Zhytomyr",
"3806265", "Kramatorsk\/Slavyansk\,\ Donetsk",
"3806273", "Vugledar\,\ Donetsk",
"3803734", "Deep\,\ Chernivtsi",
"3805163", "Veselinove\,\ Mykolayiv",
"3803737", "Zastavna\,\ Chernivtsi",
"38053", "Poltava",
"3803144", "Irshava\,\ Zakarpattia",
"3806241", "Gorlovka\,\ Donetsk",
"3806442", "Alchevsk\,\ Luhansk",
"3804356", "Murovani\ Kurylivtsi\,\ Vinnytsia",
"3806467", "Luhansk",
"3803357", "Kamin\-Kashirsky\,\ Volyn",
"3806464", "Markovka\,\ Luhansk",
"3805358", "Pyriatyn\,\ Poltava",
"3803843", "Polonne\,\ Khmelnytskyi",
"3805750", "Two\ years\ old\,\ Kharkiv",
"3804131", "Chervonoarmiysk\,\ Zhytomyr",
"3805744", "Krasnograd\,\ Kharkiv",
"3803379", "Gorokhov\,\ Volyn",
"3804861", "Red\ Windows\,\ Odesa",
"3805134", "Voznesensk\,\ Mykolayiv",
"3805747", "Snakes\,\ Kharkiv",
"3804741", "Shpola\,\ Cherkasy",
"38036", "Rivne",
"3806140", "Chernigovka\,\ Zaporizhzhia",
"3805762", "Sakhnovshchyna\,\ Kharkiv",
"3806275", "Dokuchaevsk\,\ Donetsk",
"3803230", "Pustomyty\,\ Lviv",
"3804340", "Kryzhopil\,\ Vinnytsia",
"3805351", "Dikanka\,\ Poltava",
"3805669", "Salt\,\ Dnipro",
"3806466", "Belovodsk\,\ Luhansk",
"3806248", "Gorlovka\,\ Donetsk",
"38055", "Kherson",
"3806263", "Kramatorsk\/Slavyansk\,\ Donetsk",
"3805136", "Yuzhnoukrainsk\,\ Mykolayiv",
"3805530", "Kalanchak\,\ Kherson",
"38046", "Chernihiv",
"3805455", "Nedrigailov\,\ Sumy",
"3805746", "Chuguev\,\ Kharkiv",
"3806435", "Krasnodon\,\ Luhansk",
"3803741", "Novodnistrovsk\,\ Chernivtsi",
"3804868", "Illichivsk\,\ Odesa",
"3804138", "Ruzhin\,\ Zhytomyr",
"3806156", "Big\ Belozerka\,\ Zaporizhzhia",
"3804748", "Mankivka\,\ Cherkasy",
"380327", "Lviv",
"3804569", "Volodarka\,\ Kyiv",
"3804843", "Wilkow\/Kielia\,\ Odesa",
"3803131", "Mukacheve\,\ Zakarpattia",
"3804658", "Novgorod\-Seversky\,\ Chernihiv",
"3806459", "Luhansk",
"3806237", "Selidus\,\ Donetsk",
"380568", "Dnipropetrovsk\/Dnipro",
"3803651", "Korets\,\ Rivne",
"3805240", "Kompaniyivka\,\ Kirovohrad",
"3805656", "Apostolove\,\ Dnipro",
"3803845", "Volochysk\,\ Khmelnytskyi",
"3805254", "Haivoron\,\ Kirovohrad",
"3803258", "Lviv",
"3805257", "Bobrinets\,\ Kirovohrad",
"3804144", "Baranivka\,\ Zhytomyr",
"3804737", "Zolotonosha\,\ Cherkasy",
"3805690", "Tsarichanka\,\ Dnipro",
"3804147", "Lyubar\,\ Zhytomyr",
"3804734", "Chernigov\ region",
"3806474", "Popasna\,\ Luhansk",
"3803540", "Meeting\,\ Ternopil",
"3803554", "Zalishchiki\,\ Ternopil",
"3803146", "Mizhhirya\,\ Zakarpattia",
"3803736", "Kitsman\,\ Chernivtsi",
"3804162", "Brusilov\,\ Zhytomyr",
"3803557", "Gusyatin\,\ Ternopil",
"3804634", "Talalayevka\,\ Chernihiv",
"3803346", "Old\ Vyzhivka\,\ Volyn",
"3806258", "Donetsk",
"3805631", "Petropavlovka\,\ Dnipro",
"3804637", "Priluki\,\ Chernihiv",
"3804572", "Kozin\/Obukhiv\/Ukrainka\,\ Kyiv",
"3805238", "Onufryevka\,\ Kirovohrad",
"3804344", "Shargorod\,\ Vinnytsia",
"3803234", "Mostyska\,\ Lviv",
"3804350", "Vapnarka\,\ Vinnytsia",
"3803636", "Kuznetsovsk\,\ Rivne",
"3803237", "Lviv",
"3805341", "Semenivka\,\ Poltava",
"3804347", "Litin\,\ Vinnytsia",
"3803474", "Rozhnyatov\,\ Ivano\-Frankivsk",
"3803477", "Valley\,\ Ivano\-Frankivsk",
"3804853", "Limanske\/Rozdilna\,\ Odesa",
"380641", "Luhansk",
"3805534", "Genichesk\,\ Kherson",
"3805445", "Lebedin\,\ Sumy",
"3805537", "Lazurne\/Skadovsk\,\ Kherson",
"3805756", "Krasnokutsk\,\ Kharkiv",
"3803855", "Krasilov\,\ Khmelnytskyi",
"3804594", "Brovary\/Kalita\,\ Kyiv",
"3805250", "Vilshanka\,\ Kirovohrad",
"3803248", "Boryslav\/Skhidnytsya\,\ Lviv",
"3804338", "Khmilnyk\,\ Vinnytsia",
"38047", "Cherkasy",
"3803263", "Peremyshlyany\,\ Lviv",
"3804597", "Bucha\/Vorzel\/Gostomel\/Irpen\/Kotsyubinskoe\,\ Kyiv",
"3806449", "Luhansk",
"3803435", "Rohatyn\,\ Ivano\-Frankivsk",
"3803550", "Zbarazh\,\ Ternopil",
"3805548", "Novotroitsk\,\ Kherson",
"3803544", "Buchach\,\ Ternopil",
"3803547", "Kozlov\/Kozova\,\ Ternopil",
"3806131", "Yakimivka\,\ Zaporizhzhia",
"3805365", "Globin\,\ Poltava",
"3804140", "Natives\,\ Zhytomyr",
"3805151", "Novy\ Buh\,\ Mykolayiv",
"3803372", "Ivanychi\,\ Volyn",
"3804730", "Chigirin\,\ Cherkasy",
"3804641", "Rivers\,\ Chernihiv",
"3805443", "Belopoly\,\ Sumy",
"3804596", "Vyshgorod\/Dimer\/Pirnove\,\ Kyiv",
"3805650", "Sofiyivka\,\ Dnipro",
"3803241", "Nikolaev\,\ Lviv",
"3804331", "Bratslav\/Nemyriv\,\ Vinnytsia",
"38037", "Chernivtsi",
"3805662", "Nikopol\,\ Dnipro",
"3804855", "Kominternovskoe\,\ Odesa",
"3804562", "Rokitne\,\ Kyiv",
"3803730", "Vyzhnytsia\,\ Chernivtsi",
"3805158", "Bashtanka\,\ Mykolayiv",
"3803546", "Kremenets\/Pochayiv\,\ Ternopil",
"3806138", "Kamyanets\'\-Dniprovs\'ka\,\ Zaporizhzhia",
"3805363", "Reshetilivka\,\ Poltava",
"3804636", "Varva\,\ Chernihiv",
"3803344", "Novovolynsk\,\ Volyn",
"3806460", "Luhansk",
"38051", "Mykolayiv",
"3805348", "Komsomolsk\,\ Poltava",
"3806251", "Donetsk",
"3803362", "Lubeshiv\,\ Volyn",
"3803433", "Kolomyia\,\ Ivano\-Frankivsk",
"3806452", "Severodonetsk\,\ Luhansk",
"3803637", "Demidivka\,\ Rivne",
"3804346", "Pogrebishche\,\ Vinnytsia",
"3803236", "Sambir\,\ Lviv",
"3805638", "Pokrovskoe\,\ Dnipro",
"380642", "Luhansk\/Oleksandrivsk\,\ Luhansk",
"3803634", "Volodymyrets\,\ Rivne",
"3806147", "Kuybyshev\,\ Zaporizhzhia",
"3803476", "Zabolotov\/Sniatyn\,\ Ivano\-Frankivsk",
"3806144", "Novomikolaevka\,\ Zaporizhzhia",
"3806162", "Rozvku\,\ Zaporizhzhia",
"3803853", "Yarmolintsy\,\ Khmelnytskyi",
"3805740", "New\ Waterlog\,\ Kharkiv",
"3805754", "Gemini\,\ Kharkiv",
"3803265", "Zolochiv\,\ Lviv",
"3805536", "Kakhovka\,\ Kherson",
"3805757", "Barvinkov\,\ Kharkiv",
"3803655", "Sarny\,\ Rivne",
"3805766", "Kolomak\,\ Kharkiv",
"3804848", "Saratov\,\ Odesa",
"3804863", "Ananev\,\ Odesa",
"3803841", "Belogorsk\,\ Khmelnytskyi",
"3804133", "Malin\,\ Zhytomyr",
"3804570", "Zgurovka\,\ Kyiv",
"3806268", "Kramatorsk\/Slavyansk\,\ Donetsk",
"3806446", "Kirovsk\,\ Luhansk",
"3804352", "Bershad\,\ Vinnytsia",
"3806243", "Great\ Novosilka\,\ Donetsk",
"380561", "Dnipropetrovsk\/Dnipro",
"3805355", "Mirgorod\,\ Poltava",
"3806472", "Stanitsa\ Luhansk\,\ Luhansk",
"3806271", "Artemivsk\,\ Donetsk",
"3803552", "Chortkiv\,\ Ternopil",
"3805161", "Pervomaysk\,\ Mykolayiv",
"380329", "Lviv",
"3805759", "Borova\,\ Kharkiv",
"3804732", "Kamyanets\,\ Cherkasy",
"3804142", "Korosten\,\ Zhytomyr",
"380522", "Kropyvnytskyi\,\ Kirovohrad",
"3805451", "Mid\-Buda\,\ Sumy",
"3805252", "Golovanovsk\,\ Kirovohrad",
"3804653", "Borzna\,\ Chernihiv",
"3803135", "Great\ Berezny\,\ Zakarpattia",
"3806232", "Makeevka\,\ Donetsk",
"380320", "Lviv",
"3806431", "Anthracite\,\ Luhansk",
"3803253", "Lviv",
"3803479", "Tlumach\,\ Ivano\-Frankivsk",
"3803142", "Hust\,\ Zakarpattia",
"3803732", "Kelmentsi\,\ Chernivtsi",
"3804560", "Tetiev\,\ Kyiv",
"3806245", "Gorlovka\,\ Donetsk",
"3805539", "Gola\ Prystan\,\ Kherson",
"3806278", "Marinka\,\ Donetsk",
"3805168", "Bereznegovate\,\ Mykolayiv",
"3805652", "Yellow\ Waters\,\ Dnipro",
"3804745", "Khrystynivka\,\ Cherkasy",
"3804639", "Silver\,\ Chernihiv",
"3804865", "Savran\,\ Odesa",
"3806438", "Luhansk",
"380562", "Dnipropetrovsk\/Dnipro",
"3804135", "Olevsk\,\ Zhytomyr",
"3803653", "Berezne\,\ Rivne",
"3803239", "Zhidachiv\,\ Lviv",
"3804349", "Pishchanka\,\ Vinnytsia",
"3805660", "Nikopol\,\ Dnipro",
"3805458", "Trostyanets\,\ Sumy",
"3804841", "Izmail\,\ Odesa",
"3803133", "Svalyava\,\ Zakarpattia",
"3803549", "Lanovtsi\,\ Ternopil",
"3805764", "Zolochiv\,\ Kharkiv",
"3803255", "Radehiv\,\ Lviv",
"380612", "Zaporozhye\,\ Zaporizhzhia",
"3805132", "Arbuzinka\,\ Mykolayiv",
"38054", "Sumy",
"3805742", "Kupyansk\,\ Kharkiv",
"3804655", "Sosnitsa\,\ Chernihiv",
"3806462", "Belokurakine\,\ Luhansk",
"3806261", "Krasny\ Liman\,\ Donetsk",
"3803352", "Kovel\,\ Volyn",
"380332", "Lutsk\,\ Volyn",
"3806447", "Luhansk",
"3805353", "Zinkiv\,\ Poltava",
"3806450", "Luhansk",
"3806444", "Stakhanov\,\ Luhansk",};
$areanames{uk} = {"3805540", "Нижні\ Сірогози\,\ Херсон",
"3803558", "Шумське\,\ Тернопіль",
"3803859", "Чемерівці\,\ Хмельницький",
"3804148", "Овруч\,\ Житомир",
"38043", "Вінниця",
"3806445", "Новоайдар\,\ Луганськ",
"3803141", "Берегове\,\ Закарпатська",
"3804738", "Драбів\,\ Черкаси",
"3803656", "Дубно\,\ Рівне",
"3803240", "Львів\/Львівська",
"3804330", "Оратів\,\ Вінниця",
"3803254", "Камʼянка\-Бузька\,\ Львівська",
"3805258", "Мала\ Виска\,\ Кіровоград",
"3805765", "Печеніги\,\ Харків",
"3803257", "Сокаль\,\ Львівська",
"3804654", "Щорс\,\ Чернігів",
"3805369", "Кременчук\,\ Полтава",
"3804657", "Корюківка\,\ Чернігів",
"3805651", "Дніпропетро́вськ\/Дніпро",
"3804864", "Любашівка\,\ Одеса",
"3805741", "Вовчанськ\,\ Харків",
"3804747", "Жашків\,\ Черкаси",
"3804134", "Черняхів\,\ Житомир",
"38052", "Кіровоград",
"3804744", "Умань\,\ Черкаси",
"3804867", "Кодима\,\ Одеса",
"3805131", "Братське\,\ Миколаїв",
"3804137", "Попільня\,\ Житомир",
"3803136", "Воловець\,\ Закарпатська",
"3806296", "Новоазовськ\,\ Донецьк",
"3806250", "Кіровське\,\ Донецьк",
"3806244", "Волноваха\,\ Донецьк",
"3805356", "Лохвиця\,\ Полтава",
"38035", "Тернопіль",
"3806247", "Дзержинськ\,\ Донецьк",
"3804358", "Липовець\,\ Вінниця",
"3805449", "Шостка\,\ Суми",
"3806262", "Святогірськ\/Словʼянськ\,\ Донецьк",
"3806461", "Старобільськ\,\ Луганськ",
"3804746", "Монастирище\,\ Черкаси",
"3803842", "Нетішин\/Славута\,\ Хмельницький",
"380567", "Дніпропетро́вськ\/Дніпро",
"3804866", "Балта\,\ Одеса",
"3804136", "Андрушівка\,\ Житомир",
"3806297", "Мангуш\/Ялта\,\ Донецьк",
"3805748", "Первомайський\,\ Харків",
"3805763", "Дергачі\,\ Харків",
"3803134", "Солотвино\/Тячів\,\ Закарпатська",
"3806443", "Брянка\,\ Луганськ",
"3805357", "Оржиця\,\ Полтава",
"3804351", "Чечельник\,\ Вінниця",
"3806468", "Луганськ",
"3805340", "Чорнухи\,\ Полтава",
"3806246", "Володарське\,\ Донецьк",
"3805354", "Гадяч\,\ Полтава",
"3803269", "Турка\,\ Львівська",
"3805630", "Межова\,\ Дніпро",
"38045", "Київ",
"3803738", "Путила\,\ Чернівці",
"3804141", "Новоград\-Волинський\,\ Житомир",
"3804731", "Тальне\,\ Черкаси",
"38033", "Волинська",
"3805162", "Снігурівка\,\ Миколаїв",
"3806272", "Костянтинівка\,\ Донецьк",
"3804859", "Велика\ Михайлівка\,\ Одеса",
"3803551", "Теребовля\,\ Тернопіль",
"3806471", "Сватове\,\ Луганськ",
"3803657", "Костопіль\,\ Рівне",
"3806432", "Красний\ Луч\,\ Луганськ",
"3803654", "Острог\,\ Рівне",
"3805658", "Верхньодніпровськ\,\ Дніпро",
"38061", "Запоріжжя\/Запорізька",
"3803256", "Новояворівськ\,\ Львівська",
"380328", "Львів\/Львівська",
"3805251", "Новоукраїнка\,\ Кіровоград",
"3805452", "Липова\ Долина\,\ Суми",
"3804656", "Короп\,\ Чернігів",
"3806145", "Гуляйполе\,\ Запорізька",
"3805359", "Гребінка\,\ Полтава",
"3805661", "Нікополь\,\ Дніпро",
"3804332", "Браїлів\/Жмеринка\,\ Вінниця",
"3803242", "Львів\/Львівська",
"3803264", "Буськ\,\ Львівська",
"3806178", "Токмак\,\ Запорізька",
"3805446", "Охтирка\,\ Суми",
"3803267", "Львів\/Львівська",
"3804642", "Носівка\,\ Чернігів",
"3805755", "Кегичівка\,\ Харків",
"3805693", "Новомосковськ\,\ Дніпро",
"3805542", "Цюрупинськ\,\ Херсон",
"3803635", "Рокитне\,\ Рівне",
"3804561", "Богуслав\,\ Київ",
"3803543", "Підволочиськ\,\ Тернопіль",
"3803436", "Тисмениця\,\ Івано\-Франківська",
"380622", "Донецьк",
"3804578", "Макарів\,\ Київ",
"3803233", "Львів\/Львівська",
"3806451", "Лисичанськ\,\ Луганськ",
"3804343", "Ладижин\/Тростянець\,\ Вінниця",
"3803659", "Млинів\,\ Рівне",
"3806252", "Єнакієве\,\ Донецьк",
"3805366", "Кременчук\,\ Полтава",
"3806260", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3804633", "Ічня\,\ Чернігів",
"3803856", "Деражня\,\ Хмельницький",
"3805533", "Нововоронцовка\,\ Херсон",
"3804840", "Рені\,\ Одеса",
"3804854", "Іванівка\,\ Одеса",
"3804857", "Миколаївка\,\ Одеса",
"3803437", "Болехів\,\ Івано\-Франківська",
"3803259", "Яворів\,\ Львівська",
"3803633", "Радивилів\,\ Рівне",
"3805342", "Козельщина\,\ Полтава",
"3803434", "Ворохта\/Яремче\,\ Івано\-Франківська",
"3805367", "Кременчук\,\ Полтава",
"3804571", "Васильків\/Глеваха\/Гребінки\/Калинівка\,\ Київ",
"3804659", "Семенівка\,\ Чернігів",
"3805632", "Павлоград\,\ Дніпро",
"3803368", "Рожище\,\ Волинська",
"3805364", "Машівка\,\ Полтава",
"3806458", "Луганськ",
"3803857", "Летичів\/Меджибіж\,\ Хмельницький",
"3803854", "Старокостянтинів\,\ Хмельницький",
"3804595", "Бориспіль\,\ Київ",
"380621", "Донецьк",
"3805753", "Валки\,\ Харків",
"3803840", "Шепетівка\,\ Хмельницький",
"3806143", "Вільнянськ\,\ Запорізька",
"3804856", "Березівка\,\ Одеса",
"380623", "Красноармійськ\/Макіївка\,\ Донецьк",
"3806249", "Дебальцеве\,\ Донецьк",
"3803475", "Делятин\/Надвірна\,\ Івано\-Франківська",
"3806430", "Луганськ",
"3805447", "Конотоп\,\ Суми",
"3803266", "Броди\,\ Львівська",
"3805535", "Високопілля\,\ Херсон",
"3805444", "Глухів\,\ Суми",
"3805668", "Томаківка\,\ Дніпро",
"3804139", "Чуднів\,\ Житомир",
"3805152", "Доманівка\,\ Миколаїв",
"3804635", "Батурин\/Бахмач\,\ Чернігів",
"3804749", "Лисянка\,\ Черкаси",
"3804568", "Сквира\,\ Київ",
"3806132", "Михайлівка\,\ Запорізька",
"380647", "Луганськ",
"3804345", "Іллінці\,\ Вінниця",
"3803235", "Львів\/Львівська",
"3806270", "Артемівськ\,\ Донецьк",
"3806463", "Новопсков\,\ Луганськ",
"3804735", "Корсунь\-Шевченківський\,\ Черкаси",
"3806266", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3804145", "Володарськ\-Волинський\,\ Житомир",
"3805360", "Кременчук\,\ Полтава",
"3806448", "Луганськ",
"3803249", "Червоноград\,\ Львівська",
"380619", "Мелітополь\,\ Запорізька",
"3805352", "Шишаки\,\ Полтава",
"3803555", "Монастириська\,\ Тернопіль",
"3803430", "Городенка\,\ Івано\-Франківська",
"3803132", "Рахів\,\ Закарпатська",
"3806153", "Бердянськ\,\ Запорізька",
"38034", "Івано\-Франківська",
"3804846", "Болград\,\ Одеса",
"3805549", "Нова\ Каховка\,\ Херсон",
"3803847", "Нова\ Ушиця\,\ Хмельницький",
"3805133", "Криве\ Озеро\,\ Миколаїв",
"3803844", "Теофіполь\,\ Хмельницький",
"3805255", "Новоархангельськ\,\ Кіровоград",
"3805743", "Ізюм\,\ Харків",
"3803850", "Стара\ Синява\,\ Хмельницький",
"3805653", "Вільногірськ\,\ Дніпро",
"3805239", "Устинівка\,\ Кіровоград",
"3805457", "Велика\ Писарівка\,\ Суми",
"380560", "Дніпропетро́вськ\/Дніпро",
"3805454", "Буринь\,\ Суми",
"3806437", "Луганськ",
"3806259", "Амвросіївка\,\ Донецьк",
"3803652", "Здолбунів\,\ Рівне",
"3806434", "Свердловськ\,\ Луганськ",
"3806277", "Добропілля\,\ Донецьк",
"3804161", "Лугини\,\ Житомир",
"3805167", "Нова\ Одеса\,\ Миколаїв",
"3803143", "Виноградів\,\ Закарпатська",
"3805164", "Казанка\,\ Миколаїв",
"3804355", "Гнівань\/Тиврів\,\ Вінниця",
"3806274", "Артемівськ\/Сіверськ\,\ Донецьк",
"3803733", "Новоселиця\,\ Чернівці",
"380569", "Дніпродзержинськ\/Новомосковськ\,\ Дніпро",
"380321", "Львів\/Львівська",
"3805135", "Врадіївка\,\ Миколаїв",
"3805456", "Ямпіль\,\ Суми",
"3803260", "Моршин\,\ Львівська",
"3805639", "Васильківка\,\ Дніпро",
"380564", "Кривий\ Ріг\,\ Дніпро",
"3805745", "Лозова\,\ Харків",
"3805253", "Добровеличківка\,\ Кіровоград",
"3806436", "Лутугине\,\ Луганськ",
"380322", "Брюховичі\/Львів\,\ Львівська",
"3803252", "Жовква\,\ Львівська",
"3806276", "Артемівськ\,\ Донецьк",
"3803122", "Ужгород\,\ Закарпатська",
"3806473", "Словʼяносербськ\,\ Луганськ",
"3806465", "Мілове\,\ Луганськ",
"3803355", "Шацьк\,\ Волинська",
"3804733", "Сміла\,\ Черкаси",
"3804143", "Бердичів\,\ Житомир",
"3806264", "Краматорськ\,\ Донецьк",
"3806267", "Дружківка\,\ Донецьк",
"3803145", "Перечин\,\ Закарпатська",
"3803735", "Сторожинець\,\ Чернівці",
"3806441", "Перевальськ\,\ Луганськ",
"3804353", "Теплик\,\ Вінниця",
"3806242", "Горлівка\,\ Донецьк",
"3804850", "Теплодар\,\ Одеса",
"3805761", "Зачепилівка\,\ Харків",
"3804844", "Татарбунари\,\ Одеса",
"3804847", "Тарутине\,\ Одеса",
"3806139", "Енергодар\,\ Запорізька",
"3805655", "Дніпропетро́вськ\/Дніпро",
"38044", "м\.\ Київ",
"3804742", "Катеринопіль\,\ Черкаси",
"3803846", "Віньківці\,\ Хмельницький",
"3804862", "Котовськ\,\ Одеса",
"3805159", "Єланець\,\ Миколаїв",
"3804132", "Радомишль\,\ Житомир",
"3803740", "Герца\,\ Чернівці",
"3805758", "Богодухів\,\ Харків",
"3803471", "Богородчани\,\ Івано\-Франківська",
"380649", "Луганськ",
"3806175", "Василівка\/Дніпрорудне\,\ Запорізька",
"3803852", "Ізяслав\,\ Хмельницький",
"3805531", "Іванівка\,\ Херсон",
"380628", "Донецьк",
"3805362", "Хорол\,\ Полтава",
"3804631", "Ніжин\,\ Чернігів",
"3805637", "Павлоград\,\ Дніпро",
"3805236", "Світловодськ\,\ Кіровоград",
"3805634", "Петриківка\,\ Дніпро",
"3803432", "Верховина\,\ Івано\-Франківська",
"3803363", "Турійськ\,\ Волинська",
"380640", "Луганськ",
"3803231", "Городок\,\ Львівська",
"3806453", "Рубіжне\,\ Луганськ",
"3805347", "Чутове\,\ Полтава",
"3804341", "Бар\,\ Вінниця",
"3805350", "Котельва\,\ Полтава",
"3805344", "Нові\ Санжари\,\ Полтава",
"3806256", "Сніжне\,\ Донецьк",
"38031", "Закарпатська",
"3803541", "Борщів\,\ Тернопіль",
"3804849", "Білгород\-Дністровський\/Затока\/Сергіївка\,\ Одеса",
"3806137", "Приморськ\,\ Запорізька",
"3804563", "Біла\ Церква\/Узин\,\ Київ",
"3805691", "Магдалинівка\,\ Дніпро",
"3805154", "Очаків\,\ Миколаїв",
"3804575", "Яготин\,\ Київ",
"3805546", "Берислав\,\ Херсон",
"3805241", "Новгородка\,\ Кіровоград",
"3805442", "Путивль\,\ Суми",
"3806269", "Олександрівка\,\ Донецьк",
"38057", "Харків",
"3804591", "Іванків\,\ Київ",
"3804646", "Десна\/Козелець\/Остер\,\ Чернігів",
"3805663", "Синельникове\,\ Дніпро",
"3804336", "Ямпіль\,\ Вінниця",
"3803246", "Львів\/Львівська",
"3803650", "Гоща\,\ Рівне",
"3806136", "Веселе\,\ Запорізька",
"3803365", "Ківерці\/Цумань\,\ Волинська",
"3806455", "Первомайськ\,\ Луганськ",
"3803548", "Бережани\,\ Тернопіль",
"3805544", "Горностаївка\,\ Херсон",
"3803849", "Камʼянець\-Подільський\,\ Хмельницький",
"3805547", "Білозерка\,\ Херсон",
"3806165", "Пологи\,\ Запорізька",
"3804644", "Мена\,\ Чернігів",
"3803262", "Львів\/Львівська",
"3803250", "Львів\/Львівська",
"3804598", "Боярка\/Вишневе\,\ Київ",
"3804334", "Гайсин\,\ Вінниця",
"38065", "Крим",
"3803244", "Дрогобич\,\ Львівська",
"3803247", "Трускавець\,\ Львівська",
"3804337", "Могилів\-Подільський\,\ Вінниця",
"3805538", "Асканія\-Нова\/Чаплинка\,\ Херсон",
"3805665", "Марганець\,\ Дніпро",
"3806141", "Оріхів\,\ Запорізька",
"3804852", "Біляївка\,\ Одеса",
"3806279", "Тельманове\,\ Донецьк",
"3804130", "Коростишів\,\ Житомир",
"3805751", "Шевченкове\,\ Харків",
"3803478", "Косів\,\ Івано\-Франківська",
"3804860", "Фрунзівка\,\ Одеса",
"3804740", "Ватутіне\/Звенигородка\,\ Черкаси",
"3803238", "Старий\ Самбір\,\ Львівська",
"3804348", "Томашпіль\,\ Вінниця",
"38041", "Житомир",
"3805234", "Долинська\,\ Кіровоград",
"3805636", "Тернівка\,\ Дніпро",
"3805459", "Краснопілля\,\ Суми",
"3805237", "Петрове\,\ Кіровоград",
"3804573", "Кагарлик\/Ржищів\,\ Київ",
"3806240", "Горлівка\,\ Донецьк",
"3805346", "Карлівка\,\ Полтава",
"3804565", "Фастів\,\ Київ",
"3806254", "Торез\,\ Донецьк",
"3806257", "Іловайськ\/Харцизьк\,\ Донецьк",
"3806439", "Луганськ",
"3806140", "Чернігівка\,\ Запорізька",
"3805762", "Сахновщина\,\ Харків",
"38036", "Рівне",
"3804131", "Червоноармійськ\,\ Житомир",
"3805750", "Дворічна\,\ Харків",
"3803843", "Полонне\,\ Хмельницький",
"3804861", "Красні\ Окни\,\ Одеса",
"3803379", "Горохів\,\ Волинська",
"3805744", "Красноград\,\ Харків",
"3805134", "Вознесенськ\,\ Миколаїв",
"3805747", "Зміїв\,\ Харків",
"3804741", "Шпола\,\ Черкаси",
"3806467", "Луганськ",
"3803357", "Камінь\-Каширський\,\ Волинська",
"3806464", "Марківка\,\ Луганськ",
"3805358", "Пирятин\,\ Полтава",
"3806241", "Горлівка\,\ Донецьк",
"3806442", "Алчевськ\,\ Луганськ",
"3804356", "Муровані\ Курилівці\,\ Вінниця",
"3805163", "Веселинове\,\ Миколаїв",
"3803734", "Глибока\,\ Чернівці",
"3806273", "Вугледар\,\ Донецьк",
"3803737", "Заставна\,\ Чернівці",
"3803144", "Іршава\,\ Закарпатська",
"38053", "Полтава",
"3804736", "Канів\,\ Черкаси",
"3806265", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3804146", "Дзержинськ\,\ Житомир",
"3805657", "Широке\,\ Дніпро",
"3804579", "Славутич\,\ Київ",
"3805453", "Кролевець\,\ Суми",
"3803658", "Дубровиця\,\ Рівне",
"3805654", "Кринички\,\ Дніпро",
"3805256", "Новомиргород\,\ Кіровоград",
"3803251", "Сколе\/Славське\,\ Львівська",
"3806433", "Ровеньки\,\ Луганськ",
"3806236", "Ясинувата\,\ Донецьк",
"3804845", "Арциз\,\ Одеса",
"3803540", "Зборів\,\ Тернопіль",
"3806474", "Попасна\,\ Луганськ",
"3803146", "Міжгірʼя\,\ Закарпатська",
"3803554", "Заліщики\,\ Тернопіль",
"3803736", "Кіцмань\,\ Чернівці",
"3803557", "Гусятин\,\ Тернопіль",
"3804162", "Брусилів\,\ Житомир",
"3804144", "Баранівка\,\ Житомир",
"3804737", "Золотоноша\,\ Черкаси",
"3805690", "Царичанка\,\ Дніпро",
"3804147", "Любар\,\ Житомир",
"3804734", "Городище\,\ Черкаси",
"3803845", "Волочиськ\,\ Хмельницький",
"3805656", "Апостолове\,\ Дніпро",
"3805240", "Компаніївка\,\ Кіровоград",
"3803258", "Львів\/Львівська",
"3805254", "Гайворон\,\ Кіровоград",
"3805257", "Бобринець\,\ Кіровоград",
"3804658", "Новгород\-Сіверський\,\ Чернігів",
"3806237", "Селидове\,\ Донецьк",
"3806459", "Луганськ",
"3803651", "Корець\,\ Рівне",
"380568", "Дніпропетро́вськ\/Дніпро",
"3806435", "Краснодон\,\ Луганськ",
"3804868", "Іллічівськ\,\ Одеса",
"3803741", "Новодністровськ\,\ Чернівці",
"3806156", "Велика\ Білозерка\,\ Запорізька",
"3804138", "Ружин\,\ Житомир",
"380327", "Львів\/Львівська",
"3804748", "Маньківка\,\ Черкаси",
"3804569", "Володарка\,\ Київ",
"3804843", "Вилкове\/Кілія\,\ Одеса",
"3803131", "Мукачеве\,\ Закарпатська",
"3805136", "Південноукраїнськ\,\ Миколаїв",
"38046", "Чернігів",
"3805455", "Недригайлів\,\ Суми",
"3805530", "Каланчак\,\ Херсон",
"3805746", "Чугуїв\,\ Харків",
"3806466", "Біловодськ\,\ Луганськ",
"38055", "Херсон",
"3806248", "Горлівка\,\ Донецьк",
"3806263", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3806275", "Докучаєвськ\,\ Донецьк",
"3804340", "Крижопіль\,\ Вінниця",
"3803230", "Пустомити\,\ Львівська",
"3805669", "Солоне\,\ Дніпро",
"3805351", "Диканька\,\ Полтава",
"3805259", "Ульянівка\,\ Кіровоград",
"3805633", "Першотравенськ\,\ Дніпро",
"3803342", "Володимир\-Волинський\,\ Волинська",
"3803438", "Бурштин\,\ Івано\-Франківська",
"3805545", "Верхній\ Рогачик\,\ Херсон",
"3804576", "Баришівка\/Березань\,\ Київ",
"3806239", "Красноармійськ\,\ Донецьк",
"3806457", "Луганськ",
"3805343", "Кобеляки\,\ Полтава",
"3803632", "Зарічне\,\ Рівне",
"3806440", "Луганськ",
"3805368", "Кременчук\,\ Полтава",
"3806454", "Кремінна\,\ Луганськ",
"3804851", "Овідіополь\,\ Одеса",
"3803858", "Дунаївці\,\ Хмельницький",
"3803245", "Стрий\,\ Львівська",
"3804335", "Тульчин\,\ Вінниця",
"380572", "Мерефа\/Харків\,\ Харків",
"3804149", "Ємільчине\,\ Житомир",
"3804739", "Чорнобай\,\ Черкаси",
"3804645", "Городня\,\ Чернігів",
"3805752", "Великий\ Бурлук\,\ Харків",
"3803261", "Новий\ Роздол\,\ Львівська",
"38038", "Хмельницький",
"3805667", "Орджонікідзе\,\ Дніпро",
"3805448", "Ромни\,\ Суми",
"3805664", "Нікополь\,\ Дніпро",
"3806133", "Приазовське\,\ Запорізька",
"3804567", "Переяслав\-Хмельницький\,\ Київ",
"3806255", "Шахтарськ\,\ Донецьк",
"380312", "Ужгород\/Чоп\,\ Закарпатська",
"3804564", "Ставище\,\ Київ",
"3805153", "Березанка\,\ Миколаїв",
"3803376", "Маневичі\,\ Волинська",
"3805235", "Олександрія\,\ Кіровоград",
"38069", "Севастополь",
"3806469", "Луганськ",
"3805242", "Олександрівка\,\ Кіровоград",
"3804643", "Куликівка\,\ Чернігів",
"3803268", "Львів\/Львівська",
"38048", "Одеса",
"3805666", "Нікополь\,\ Дніпро",
"3804333", "Калинівка\,\ Вінниця",
"3803243", "Львів\/Львівська",
"3804566", "Тараща\,\ Київ",
"3805345", "Велика\ Багачка\,\ Полтава",
"3803542", "Підгайці\,\ Тернопіль",
"3805749", "Балаклія\,\ Харків",
"3803374", "Локачі\,\ Волинська",
"3805635", "Юрʼївка\,\ Дніпро",
"3805692", "Дніпродзержинськ\,\ Дніпро",
"3803377", "Любомль\,\ Волинська",
"38037312", "Хотин\,\ Чернівці",
"3805543", "Велика\ Лепетиха\,\ Херсон",
"3804574", "Миронівка\,\ Київ",
"3804632", "Бобровиця\,\ Чернігів",
"380648", "Луганськ",
"3805233", "Знамʼянка\,\ Кіровоград",
"3805659", "Дніпропетро́вськ\/Дніпро",
"3804577", "Бородянка\/Клавдієво\-Тарасове\/Немішаєве\,\ Київ",
"3805361", "Лубни\,\ Полтава",
"3803366", "Ратне\,\ Волинська",
"3806456", "Троїцьке\,\ Луганськ",
"3803232", "Львів\/Львівська",
"3804342", "Козятин\,\ Вінниця",
"380620", "Донецьк",
"3803431", "Галич\,\ Івано\-Франківська",
"3806253", "Старобешеве\,\ Донецьк",
"3803739", "Сокиряни\,\ Чернівці",
"3803472", "Калуш\,\ Івано\-Франківська",
"380629", "Маріуполь\,\ Донецьк",
"3804858", "Ширяєве\,\ Одеса",
"3805532", "Велика\ Олександрівка\,\ Херсон",
"3803851", "Городок\/Сатанів\,\ Хмельницький",
"3803135", "Великий\ Березний\,\ Закарпатська",
"380320", "Львів\/Львівська",
"3806232", "Макіївка\,\ Донецьк",
"3803253", "Львів\/Львівська",
"3806431", "Антрацит\,\ Луганськ",
"380522", "Кропивницький\,\ Кіровоград",
"3805451", "Середина\-Буда\,\ Суми",
"3804653", "Борзна\,\ Чернігів",
"3805252", "Голованівськ\,\ Кіровоград",
"3805759", "Борова\,\ Харків",
"3804732", "Камʼянка\,\ Черкаси",
"3804142", "Коростень\,\ Житомир",
"3805355", "Миргород\,\ Полтава",
"380561", "Дніпропетро́вськ\/Дніпро",
"3806472", "Станиця\ Луганськ\,\ Луганськ",
"3805161", "Первомайськ\,\ Миколаїв",
"380329", "Львів\/Львівська",
"3806271", "Артемівськ\,\ Донецьк",
"3803552", "Чортків\,\ Тернопіль",
"3806268", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3806446", "Кіровськ\,\ Луганськ",
"3804352", "Бершадь\,\ Вінниця",
"3806243", "Велика\ Новосілка\,\ Донецьк",
"3804570", "Згурівка\,\ Київ",
"3804848", "Сарата\,\ Одеса",
"3804863", "Ананьїв\,\ Одеса",
"3803841", "Білогірʼя\,\ Хмельницький",
"3804133", "Малин\,\ Житомир",
"3803655", "Сарни\,\ Рівне",
"3805766", "Коломак\,\ Харків",
"3805353", "Зіньків\,\ Полтава",
"3806447", "Луганськ",
"3806450", "Луганськ",
"3806444", "Стаханов\,\ Луганськ",
"3806462", "Білокуракине\,\ Луганськ",
"3803352", "Ковель\,\ Волинська",
"3806261", "Красний\ Лиман\,\ Донецьк",
"380332", "Луцьк\,\ Волинська",
"3805132", "Арбузинка\,\ Миколаїв",
"38054", "Суми",
"3805742", "Купʼянськ\,\ Харків",
"3804655", "Сосниця\,\ Чернігів",
"3805764", "Золочів\,\ Харків",
"3804841", "Ізмаїл\,\ Одеса",
"3803133", "Свалява\,\ Закарпатська",
"3803549", "Ланівці\,\ Тернопіль",
"380612", "Запоріжжя\,\ Запорізька",
"3803255", "Радехів\,\ Львівська",
"3803653", "Березне\,\ Рівне",
"3804349", "Піщанка\,\ Вінниця",
"3803239", "Жидачів\,\ Львівська",
"3805660", "Нікополь\,\ Дніпро",
"3805458", "Тростянець\,\ Суми",
"3805652", "Жовті\ Води\,\ Дніпро",
"3804745", "Христинівка\,\ Черкаси",
"3804639", "Срібне\,\ Чернігів",
"3806438", "Луганськ",
"380562", "Дніпропетровськ\,\ Дніпро",
"3804865", "Саврань\,\ Одеса",
"3804135", "Олевськ\,\ Житомир",
"3805539", "Гола\ Пристань\,\ Херсон",
"3805168", "Березнегувате\,\ Миколаїв",
"3806278", "Марʼїнка\,\ Донецьк",
"3803142", "Хуст\,\ Закарпатська",
"3803479", "Тлумач\,\ Івано\-Франківська",
"3804560", "Тетіїв\,\ Київ",
"3803732", "Кельменці\,\ Чернівці",
"3806245", "Горлівка\,\ Донецьк",
"3805365", "Глобине\,\ Полтава",
"3804140", "Народичі\,\ Житомир",
"3803372", "Іваничі\,\ Волинська",
"3805151", "Новий\ Буг\,\ Миколаїв",
"3804730", "Чигирин\,\ Черкаси",
"3803550", "Збараж\,\ Тернопіль",
"3803435", "Рогатин\,\ Івано\-Франківська",
"3803544", "Бучач\,\ Тернопіль",
"3805548", "Новотроїцьке\,\ Херсон",
"3806131", "Якимівка\,\ Запорізька",
"3803547", "Козлів\/Козова\,\ Тернопіль",
"3806449", "Луганськ",
"3805250", "Вільшанка\,\ Кіровоград",
"3804594", "Бровари\/Калита\,\ Київ",
"3803855", "Красилів\,\ Хмельницький",
"3804338", "Хмільник\,\ Вінниця",
"3803248", "Борислав\/Східниця\,\ Львівська",
"3803263", "Перемишляни\,\ Львівська",
"3804597", "Буча\/Ворзель\/Гостомель\/Ірпінь\/Коцюбинське\,\ Київ",
"38047", "Черкаси",
"3805534", "Генічеськ\,\ Херсон",
"380641", "Луганськ",
"3805445", "Лебедин\,\ Суми",
"3805537", "Лазурне\/Скадовськ\,\ Херсон",
"3805756", "Краснокутськ\,\ Харків",
"3803474", "Рожнятів\,\ Івано\-Франківська",
"3803477", "Долина\,\ Івано\-Франківська",
"3804853", "Лиманське\/Роздільна\,\ Одеса",
"3803234", "Мостиська\,\ Львівська",
"3805238", "Онуфріївка\,\ Кіровоград",
"3804344", "Шаргород\,\ Вінниця",
"3803636", "Кузнецовськ\,\ Рівне",
"3804350", "Вапнярка\,\ Вінниця",
"3804347", "Літин\,\ Вінниця",
"3805341", "Семенівка\,\ Полтава",
"3803237", "Львів\/Львівська",
"3804634", "Талалаївка\,\ Чернігів",
"3803346", "Стара\ Вижівка\,\ Волинська",
"3806258", "Донецьк",
"3804637", "Прилуки\,\ Чернігів",
"3805631", "Петропавлівка\,\ Дніпро",
"3804572", "Козин\/Обухів\/Українка\,\ Київ",
"3803853", "Ярмолинці\,\ Хмельницький",
"3806162", "Розівка\,\ Запорізька",
"3805740", "Нова\ Водолага\,\ Харків",
"3805754", "Близнюки\,\ Харків",
"3805536", "Каховка\,\ Херсон",
"3803265", "Золочів\,\ Львівська",
"3805757", "Барвінкове\,\ Харків",
"3806147", "Куйбишеве\,\ Запорізька",
"3803476", "Заболотів\/Снятин\,\ Івано\-Франківська",
"3806144", "Новомиколаївка\,\ Запорізька",
"3803433", "Коломия\,\ Івано\-Франківська",
"3803362", "Любешів\,\ Волинська",
"3806251", "Донецьк",
"3803637", "Демидівка\,\ Рівне",
"3806452", "Сєвєродонецьк\,\ Луганськ",
"3803236", "Самбір\,\ Львівська",
"3804346", "Погребище\,\ Вінниця",
"3803634", "Володимирець\,\ Рівне",
"3805638", "Покровське\,\ Дніпро",
"380642", "Луганськ\/Олександрівськ\,\ Луганськ",
"3805363", "Решетилівка\,\ Полтава",
"3804636", "Варва\,\ Чернігів",
"38051", "Миколаїв",
"3806460", "Луганськ",
"3805348", "Комсомольськ\,\ Полтава",
"3803344", "Нововолинськ\,\ Волинська",
"3806138", "Камʼянка\-Дніпровська\,\ Запорізька",
"3803730", "Вижниця\,\ Чернівці",
"3804562", "Рокитне\,\ Київ",
"3803546", "Кременець\/Почаїв\,\ Тернопіль",
"3805158", "Баштанка\,\ Миколаїв",
"3804331", "Брацлав\/Немирів\,\ Вінниця",
"3803241", "Миколаїв\,\ Львівська",
"3805662", "Нікополь\,\ Дніпро",
"38037", "Чернівці",
"3804855", "Комінтернівське\,\ Одеса",
"3804641", "Ріпки\,\ Чернігів",
"3805443", "Білопілля\,\ Суми",
"3804596", "Вишгород\/Димер\/Пірнове\,\ Київ",
"3805650", "Софіївка\,\ Дніпро",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+380|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;