# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230305170052;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '1534[0-24-8]\\d{5}',
                'geographic' => '1534[0-24-8]\\d{5}',
                'mobile' => '
          7(?:
            (?:
              (?:
                50|
                82
              )9|
              937
            )\\d|
            7(?:
              00[378]|
              97[7-9]
            )
          )\\d{5}
        ',
                'pager' => '
          76(?:
            464|
            652
          )\\d{5}|
          76(?:
            0[0-28]|
            2[356]|
            34|
            4[01347]|
            5[49]|
            6[0-369]|
            77|
            8[14]|
            9[139]
          )\\d{6}
        ',
                'personal_number' => '701511\\d{4}',
                'specialrate' => '(
          (?:
            8(?:
              4(?:
                4(?:
                  4(?:
                    05|
                    42|
                    69
                  )|
                  703
                )|
                5(?:
                  041|
                  800
                )
              )|
              7(?:
                0002|
                1206
              )
            )|
            90(?:
              066[59]|
              1810|
              71(?:
                07|
                55
              )
            )
          )\\d{4}
        )|(
          (?:
            3(?:
              0(?:
                07(?:
                  35|
                  81
                )|
                8901
              )|
              3\\d{4}|
              4(?:
                4(?:
                  4(?:
                    05|
                    42|
                    69
                  )|
                  703
                )|
                5(?:
                  041|
                  800
                )
              )|
              7(?:
                0002|
                1206
              )
            )|
            55\\d{4}
          )\\d{4}
        )',
                'toll_free' => '
          80(?:
            07(?:
              35|
              81
            )|
            8901
          )\\d{4}
        ',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"4415077", "Louth",
"441384", "Dudley",
"441237", "Bideford",
"441575", "Kirriemuir",
"441644", "New\ Galloway",
"441767", "Sandy",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441524", "Lancaster",
"4415395", "Grange\-over\-Sands",
"441823", "Taunton",
"441945", "Wisbech",
"441262", "Bridlington",
"4419753", "Strathdon",
"441477", "Holmes\ Chapel",
"441732", "Sevenoaks",
"441685", "Merthyr\ Tydfil",
"441590", "Lymington",
"441984", "Watchet\ \(Williton\)",
"44291", "Cardiff",
"441422", "Halifax",
"441879", "Scarinish",
"441303", "Folkestone",
"4418471", "Thurso\/Tongue",
"441609", "Northallerton",
"441569", "Stonehaven",
"441241", "Arbroath",
"441359", "Pakenham",
"441653", "Malton",
"4415396", "Sedbergh",
"441834", "Narberth",
"441768", "Penrith",
"4419640", "Hornsea\/Patrington",
"441736", "Penzance",
"442885", "Ballygawley",
"4416974", "Raughton\ Head",
"441280", "Buckingham",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"441740", "Sedgefield",
"441959", "Westerham",
"441865", "Oxford",
"441450", "Hawick",
"441903", "Worthing",
"442844", "Downpatrick",
"441676", "Meriden",
"4418510", "Great\ Bernera\/Stornoway",
"441292", "Ayr",
"441560", "Moscow",
"441350", "Dunkeld",
"441926", "Warwick",
"442827", "Ballymoney",
"441600", "Monmouth",
"4418901", "Coldstream\/Ayton",
"441326", "Falmouth",
"4414342", "Bellingham",
"441531", "Ledbury",
"4420", "London",
"441403", "Horsham",
"4412293", "Millom",
"441749", "Shepton\ Mallet",
"441950", "Sandwick",
"441978", "Wrexham",
"441586", "Campbeltown",
"441918", "Tyneside",
"441797", "Rye",
"441548", "Kingsbridge",
"441243", "Chichester",
"442311", "Southampton",
"441651", "Oldmeldrum",
"441628", "Maidenhead",
"441301", "Arrochar",
"441857", "Sanday",
"441289", "Berwick\-upon\-Tweed",
"441445", "Gairloch",
"442828", "Larne",
"441377", "Driffield",
"441895", "Uxbridge",
"441205", "Boston",
"441582", "Luton",
"441322", "Dartford",
"441821", "Kinrossie",
"441922", "Walsall",
"441858", "Market\ Harborough",
"441870", "Isle\ of\ Benbecula",
"44247", "Coventry",
"441484", "Huddersfield",
"441704", "Southport",
"44241", "Coventry",
"441547", "Knighton",
"441599", "Kyle",
"4415074", "Alford\ \(Lincs\)",
"441254", "Blackburn",
"441977", "Pontefract",
"441798", "Pulborough",
"4414232", "Harrogate",
"441917", "Sunderland",
"441806", "Shetland",
"441672", "Marlborough",
"4414377", "Haverfordwest",
"441296", "Aylesbury",
"44117", "Bristol",
"441494", "High\ Wycombe",
"441623", "Mansfield",
"441543", "Cannock",
"441248", "Bangor\ \(Gwynedd\)",
"441329", "Fareham",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441456", "Glenurquhart",
"441746", "Bridgnorth",
"441788", "Rugby",
"441408", "Golspie",
"441844", "Thame",
"441913", "Durham",
"441286", "Caernarfon",
"4416973", "Wigton",
"441761", "Temple\ Cloud",
"4416861", "Newtown\/Llanidloes",
"4412297", "Millom",
"441373", "Frome",
"441260", "Congleton",
"441730", "Petersfield",
"441592", "Kirkcaldy",
"441885", "Pencombe",
"441420", "Alton",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"441929", "Wareham",
"441935", "Yeovil",
"441554", "Llanelli",
"441793", "Swindon",
"441364", "Ashburton",
"4414373", "Clynderwen\ \(Clunderwen\)",
"441407", "Holyhead",
"441787", "Sudbury",
"442879", "Magherafelt",
"441634", "Medway",
"4419648", "Hornsea",
"441299", "Bewdley",
"441809", "Tomdoun",
"441505", "Johnstone",
"441282", "Burnley",
"4419754", "Alford\ \(Aberdeen\)",
"441665", "Alnwick",
"44131", "Edinburgh",
"4418519", "Great\ Bernera",
"441452", "Gloucester",
"442823", "Northern\ Ireland",
"441335", "Ashbourne",
"441290", "Cumnock",
"44141", "Glasgow",
"441725", "Rockbourne",
"442870", "Coleraine",
"4418518", "Stornoway",
"442821", "Martinstown",
"4419757", "Strathdon",
"441562", "Kidderminster",
"441352", "Mold",
"441876", "Lochmaddy",
"441435", "Heathfield",
"4414346", "Hexham",
"4419649", "Hornsea",
"441464", "Insch",
"441828", "Coupar\ Angus",
"441952", "Telford",
"441307", "Forfar",
"4414235", "Harrogate",
"4415073", "Louth",
"441275", "Clevedon",
"441224", "Aberdeen",
"442895", "Belfast",
"441473", "Ipswich",
"441695", "Skelmersdale",
"441908", "Milton\ Keynes",
"4414301", "North\ Cave\/Market\ Weighton",
"441580", "Cranbrook",
"441371", "Great\ Dunmow",
"441320", "Fort\ Augustus",
"441994", "St\ Clears",
"441606", "Northwich",
"441872", "Truro",
"4414345", "Haltwhistle",
"441971", "Scourie",
"441429", "Hartlepool",
"441911", "Tyneside\/Durham\/Sunderland",
"441763", "Royston",
"441394", "Felixstowe",
"441920", "Ware",
"441566", "Launceston",
"4413391", "Aboyne\/Ballater",
"441233", "Ashford\ \(Kent\)",
"441356", "Brechin",
"441538", "Ipstones",
"4412294", "Barrow\-in\-Furness",
"441827", "Tamworth",
"441308", "Bridport",
"4414236", "Harrogate",
"441621", "Maldon",
"441269", "Ammanford",
"441670", "Morpeth",
"441343", "Elgin",
"441529", "Sleaford",
"441697", "Brampton",
"4417684", "Pooley\ Bridge",
"441683", "Moffat",
"441992", "Lea\ Valley",
"441438", "Stevenage",
"441389", "Dumbarton",
"441466", "Huntly",
"441226", "Barnsley",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"441751", "Pickering",
"441728", "Saxmundham",
"441250", "Blairgowrie",
"44114", "Sheffield",
"441573", "Kelso",
"441278", "Bridgwater",
"441776", "Stranraer",
"442898", "Belfast",
"441874", "Brecon",
"441480", "Huntingdon",
"441700", "Rothesay",
"441392", "Exeter",
"441989", "Ross\-on\-Wye",
"4418906", "Ayton",
"441943", "Guiseley",
"441825", "Uckfield",
"441727", "St\ Albans",
"441564", "Lapworth",
"441354", "Chatteris",
"441604", "Northampton",
"4413392", "Aboyne",
"441863", "Ardgay",
"441772", "Preston",
"441698", "Motherwell",
"441905", "Worcester",
"4419643", "Patrington",
"441305", "Dorchester",
"441655", "Maybole",
"44151", "Liverpool",
"442849", "Northern\ Ireland",
"4415079", "Alford\ \(Lincs\)",
"442897", "Saintfield",
"4414378", "Haverfordwest",
"4414302", "North\ Cave",
"441462", "Hitchin",
"4418905", "Ayton",
"441954", "Madingley",
"441535", "Keighley",
"441277", "Brentwood",
"442883", "Northern\ Ireland",
"441785", "Stafford",
"441405", "Goole",
"442881", "Newtownstewart",
"441937", "Wetherby",
"4414379", "Haverfordwest",
"442868", "Kesh",
"4415078", "Alford\ \(Lincs\)",
"441362", "Dereham",
"441245", "Chelmsford",
"441830", "Kirkwhelpington",
"4412290", "Barrow\-in\-Furness\/Millom",
"441454", "Chipping\ Sodbury",
"441888", "Turriff",
"441667", "Nairn",
"441744", "St\ Helens",
"4418475", "Thurso",
"441496", "Port\ Ellen",
"442840", "Banbridge",
"441962", "Winchester",
"4413882", "Stanhope\ \(Eastgate\)",
"4418513", "Stornoway",
"441337", "Ladybank",
"441284", "Bury\ St\ Edmunds",
"4416862", "Llanidloes",
"441842", "Thetford",
"442867", "Lisnaskea",
"441938", "Welshpool",
"441492", "Colwyn\ Bay",
"441380", "Devizes",
"441520", "Lochcarron",
"441571", "Lochinver",
"441753", "Slough",
"441594", "Lydney",
"4418476", "Tongue",
"441443", "Pontypridd",
"441489", "Bishops\ Waltham",
"441556", "Castle\ Douglas",
"441709", "Rotherham",
"441366", "Downham\ Market",
"441980", "Amesbury",
"441508", "Brooke",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"441259", "Alloa",
"4417687", "Keswick",
"441341", "Barmouth",
"441668", "Bamburgh",
"441887", "Aberfeldy",
"441636", "Newark\-on\-Trent",
"441375", "Grays\ Thurrock",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"4418517", "Stornoway",
"441584", "Ludlow",
"441324", "Falkirk",
"4413395", "Aboyne",
"441499", "Inveraray",
"441757", "Selby",
"441883", "Caterham",
"441691", "Oswestry",
"441207", "Consett",
"4419758", "Strathdon",
"441545", "Llanarth",
"4419644", "Patrington",
"441252", "Aldershot",
"441625", "Macclesfield",
"441674", "Montrose",
"441924", "Wakefield",
"441482", "Kingston\-upon\-Hull",
"4414305", "North\ Cave",
"441702", "Southend\-on\-Sea",
"4418902", "Coldstream",
"441915", "Sunderland",
"441431", "Helmsdale",
"441503", "Looe",
"441208", "Bodmin",
"441663", "New\ Mills",
"4413396", "Ballater",
"441559", "Llandysul",
"441706", "Rochdale",
"441369", "Dunoon",
"4417683", "Appleby",
"4414231", "Harrogate\/Boroughbridge",
"442825", "Ballymena",
"441770", "Isle\ of\ Arran",
"441758", "Pwllheli",
"441721", "Peebles",
"441294", "Ardrossan",
"441639", "Neath",
"441256", "Basingstoke",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"442891", "Bangor\ \(Co\.\ Down\)",
"441933", "Wellingborough",
"441795", "Sittingbourne",
"441271", "Barnstaple",
"4412299", "Millom",
"441855", "Ballachulish",
"44286", "Northern\ Ireland",
"441460", "Chard",
"4414306", "Market\ Weighton",
"441969", "Leyburn",
"44113", "Leeds",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441630", "Market\ Drayton",
"441779", "Peterhead",
"441948", "Whitchurch",
"441986", "Bungay",
"442887", "Dungannon",
"441273", "Brighton",
"441578", "Lauder",
"4412298", "Barrow\-in\-Furness",
"441550", "Llandovery",
"441360", "Killearn",
"442893", "Ballyclare",
"441931", "Shap",
"441832", "Clopton",
"441646", "Milford\ Haven",
"441526", "Martin",
"441386", "Evesham",
"441469", "Killingholme",
"442842", "Kircubbin",
"441723", "Scarborough",
"441661", "Prudhoe",
"441348", "Fishguard",
"4416866", "Newtown",
"441433", "Hathersage",
"441501", "Harthill",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"441765", "Ripon",
"441840", "Camelford",
"441235", "Abingdon",
"441577", "Kinross",
"442888", "Northern\ Ireland",
"441382", "Dundee",
"4419647", "Patrington",
"442846", "Northern\ Ireland",
"441490", "Corwen",
"441947", "Whitby",
"441642", "Middlesbrough",
"441522", "Lincoln",
"44121", "Birmingham",
"4419759", "Alford\ \(Aberdeen\)",
"441475", "Greenock",
"4418472", "Thurso",
"441687", "Mallaig",
"441982", "Builth\ Wells",
"4413885", "Stanhope\ \(Eastgate\)",
"441424", "Hastings",
"441347", "Easingwold",
"441264", "Andover",
"442830", "Newry",
"4418514", "Great\ Bernera",
"4416865", "Newtown",
"4419646", "Patrington",
"441242", "Cheltenham",
"44161", "Manchester",
"441934", "Weston\-super\-Mare",
"441555", "Lanark",
"4414349", "Bellingham",
"442829", "Kilrea",
"441635", "Newbury",
"441782", "Stoke\-on\-Trent",
"441747", "Shaftesbury",
"441664", "Melton\ Mowbray",
"441799", "Saffron\ Walden",
"441457", "Glossop",
"441859", "Harris",
"441287", "Guisborough",
"441334", "St\ Andrews",
"441803", "Torquay",
"441598", "Lynton",
"441293", "Crawley",
"441673", "Market\ Rasen",
"441379", "Diss",
"4419645", "Hornsea",
"441495", "Pontypool",
"4419467", "Gosforth",
"4418903", "Coldstream",
"441923", "Watford",
"441760", "Swaffham",
"4414239", "Boroughbridge",
"441845", "Thirsk",
"4414304", "North\ Cave",
"4412291", "Barrow\-in\-Furness\/Millom",
"4416867", "Llanidloes",
"441549", "Lairg",
"4413394", "Ballater",
"441323", "Eastbourne",
"441261", "Banff",
"441786", "Stirling",
"441406", "Holbeach",
"441629", "Matlock",
"441597", "Llandrindod\ Wells",
"441583", "Carradale",
"441288", "Bude",
"441246", "Chesterfield",
"44281", "Northern\ Ireland",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"44287", "Northern\ Ireland",
"441748", "Richmond",
"441884", "Tiverton",
"441458", "Glastonbury",
"441919", "Durham",
"4415242", "Hornby",
"441306", "Dorking",
"441769", "South\ Molton",
"441694", "Church\ Stretton",
"441239", "Cardigan",
"4418473", "Thurso",
"441656", "Bridgend",
"441733", "Peterborough",
"4416864", "Llanidloes",
"4413397", "Ballater",
"441995", "Garstang",
"441581", "New\ Luce",
"441608", "Chipping\ Norton",
"441358", "Ellon",
"441536", "Kettering",
"441568", "Leominster",
"441263", "Cromer",
"4418515", "Stornoway",
"441822", "Tavistock",
"441479", "Grantown\-on\-Spey",
"4414238", "Harrogate",
"441910", "Tyneside\/Durham\/Sunderland",
"441970", "Aberystwyth",
"441395", "Budleigh\ Salterton",
"4414307", "Market\ Weighton",
"441877", "Callander",
"441671", "Newton\ Stewart",
"441540", "Kingussie",
"441620", "North\ Berwick",
"441902", "Wolverhampton",
"441357", "Strathaven",
"441567", "Killin",
"441724", "Scunthorpe",
"441291", "Chepstow",
"441775", "Spalding",
"442820", "Ballycastle",
"442871", "Londonderry",
"4418516", "Great\ Bernera",
"441465", "Girvan",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"441878", "Lochboisdale",
"4414348", "Hexham",
"442894", "Antrim",
"441225", "Bath",
"441652", "Brigg",
"441274", "Bradford",
"441957", "Mid\ Yell",
"441302", "Doncaster",
"441790", "Spilsby",
"441835", "St\ Boswells",
"441476", "Grantham",
"4419642", "Hornsea",
"44115", "Nottingham",
"4418904", "Coldstream",
"442884", "Northern\ Ireland",
"441953", "Wymondham",
"4414303", "North\ Cave",
"44280", "Northern\ Ireland",
"441780", "Stamford",
"441400", "Honington",
"441909", "Worksop",
"441603", "Norwich",
"441738", "Perth",
"441309", "Forres",
"4413393", "Aboyne",
"441766", "Porthmadog",
"441659", "Sanquhar",
"441236", "Coatbridge",
"441353", "Ely",
"441268", "Basildon",
"441563", "Kilmarnock",
"441451", "Stow\-on\-the\-Wold",
"441428", "Haslemere",
"442845", "Northern\ Ireland",
"441864", "Abington\ \(Crawford\)",
"4418477", "Tongue",
"441539", "Kendal",
"441525", "Leighton\ Buzzard",
"441944", "West\ Heslerton",
"441873", "Abergavenny",
"441684", "Malvern",
"441344", "Bracknell",
"441427", "Gainsborough",
"441591", "Llanwrtyd\ Wells",
"441267", "Carmarthen",
"441985", "Warminster",
"44292", "Cardiff",
"441737", "Redhill",
"441472", "Grimsby",
"441829", "Tarporley",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441796", "Pitlochry",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441298", "Buxton",
"441593", "Lybster",
"441754", "Skegness",
"441808", "Tomatin",
"441444", "Haywards\ Heath",
"441327", "Daventry",
"441856", "Orkney",
"4413873", "Langholm",
"441372", "Esher",
"441204", "Bolton",
"441912", "Tyneside",
"441871", "Castlebay",
"441972", "Glenborrodale",
"441485", "Hunstanton",
"441677", "Bedale",
"4414230", "Harrogate\/Boroughbridge",
"442826", "Northern\ Ireland",
"441622", "Maidstone",
"441255", "Clacton\-on\-Sea",
"441542", "Keith",
"441409", "Holsworthy",
"441789", "Stratford\-upon\-Avon",
"441626", "Newton\ Abbot",
"441900", "Workington",
"441546", "Lochgilphead",
"441453", "Dursley",
"442822", "Northern\ Ireland",
"4418474", "Thurso",
"441743", "Shrewsbury",
"441297", "Axminster",
"441807", "Ballindalloch",
"441249", "Chippenham",
"4416863", "Llanidloes",
"441328", "Fakenham",
"441561", "Laurencekirk",
"441916", "Tyneside",
"441588", "Bishops\ Castle",
"441283", "Burton\-on\-Trent",
"442877", "Limavady",
"4418512", "Stornoway",
"4418907", "Ayton",
"441376", "Braintree",
"441530", "Coalville",
"441951", "Colonsay",
"441852", "Kilmelford",
"441928", "Runcorn",
"441650", "Cemmaes\ Road",
"442310", "Portsmouth",
"441678", "Bala",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"441792", "Swansea",
"441300", "Cerne\ Abbas",
"441939", "Wem",
"44283", "Northern\ Ireland",
"44116", "Leicester",
"4419755", "Alford\ \(Aberdeen\)",
"441720", "Isles\ of\ Scilly",
"441963", "Wincanton",
"4416869", "Newtown",
"441771", "Maud",
"441295", "Banbury",
"4413398", "Aboyne",
"441805", "Torrington",
"442824", "Northern\ Ireland",
"441509", "Loughborough",
"441756", "Skipton",
"441446", "Barry",
"442890", "Belfast",
"4414372", "Clynderwen\ \(Clunderwen\)",
"4414308", "Market\ Weighton",
"441363", "Crediton",
"441794", "Romsey",
"441553", "Kings\ Lynn",
"441258", "Blandford",
"441270", "Crewe",
"441669", "Rothbury",
"4414237", "Harrogate",
"441206", "Colchester",
"441461", "Gretna",
"441896", "Galashiels",
"441488", "Hungerford",
"441708", "Romford",
"441633", "Newport",
"441854", "Ullapool",
"441325", "Darlington",
"44238", "Southampton",
"441202", "Bournemouth",
"4419756", "Strathdon",
"441892", "Tunbridge\ Wells",
"441690", "Betws\-y\-Coed",
"441752", "Plymouth",
"441442", "Hemel\ Hempstead",
"4418900", "Coldstream\/Ayton",
"441487", "Warboys",
"441707", "Welwyn\ Garden\ City",
"441675", "Coleshill",
"441624", "Isle\ of\ Man",
"441493", "Great\ Yarmouth",
"441544", "Kington",
"441914", "Tyneside",
"441974", "Llanon",
"441257", "Coppull",
"441889", "Rugeley",
"441843", "Thanet",
"4418511", "Great\ Bernera\/Stornoway",
"4414347", "Hexham",
"441925", "Warrington",
"441942", "Wigan",
"441841", "Newquay\ \(Padstow\)",
"441234", "Bedford",
"4412295", "Barrow\-in\-Furness",
"441387", "Dumfries",
"441527", "Redditch",
"4414344", "Bellingham",
"441764", "Crieff",
"441647", "Moretonhampstead",
"441866", "Kilchrenan",
"441838", "Dalmally",
"441491", "Henley\-on\-Thames",
"441572", "Oakham",
"442848", "Northern\ Ireland",
"441425", "Ringwood",
"4419641", "Hornsea\/Patrington",
"441474", "Gravesend",
"441880", "Tarbert",
"441993", "Witney",
"441342", "East\ Grinstead",
"442886", "Cookstown",
"441987", "Ebbsfleet",
"4418470", "Thurso\/Tongue",
"441346", "Fraserburgh",
"442882", "Omagh",
"441631", "Oban",
"4412296", "Barrow\-in\-Furness",
"441729", "Settle",
"441837", "Okehampton",
"441463", "Inverness",
"441528", "Laggan",
"441361", "Duns",
"441223", "Cambridge",
"4415072", "Spilsby\ \(Horncastle\)",
"4414309", "Market\ Weighton",
"441439", "Helmsley",
"441388", "Bishop\ Auckland",
"4414234", "Boroughbridge",
"441330", "Banchory",
"441576", "Lockerbie",
"4413399", "Ballater",
"441988", "Wigtown",
"441862", "Tain",
"4416868", "Newtown",
"441773", "Ripley",
"441279", "Bishops\ Stortford",
"441946", "Whitehaven",
"442847", "Northern\ Ireland",
"442899", "Northern\ Ireland",
"441777", "Retford",
"441432", "Hereford",
"441355", "East\ Kilbride",
"441565", "Knutsford",
"441904", "York",
"4413390", "Aboyne\/Ballater",
"441722", "Salisbury",
"442843", "Newcastle\ \(Co\.\ Down\)",
"442889", "Fivemiletown",
"442892", "Lisburn",
"441467", "Inverurie",
"4414376", "Haverfordwest",
"441833", "Barnard\ Castle",
"441654", "Machynlleth",
"441304", "Dover",
"4414300", "North\ Cave\/Market\ Weighton",
"441534", "Jersey",
"441955", "Wick",
"441869", "Bicester",
"441398", "Dulverton",
"441227", "Canterbury",
"441579", "Liskeard",
"4418479", "Tongue",
"44118", "Reading",
"4419752", "Alford\ \(Aberdeen\)",
"441200", "Clitheroe",
"441276", "Camberley",
"441983", "Isle\ of\ Wight",
"441692", "North\ Walsham",
"442896", "Belfast",
"441778", "Bourne",
"441440", "Haverhill",
"441997", "Strathpeffer",
"441949", "Whatton",
"441750", "Selkirk",
"441643", "Minehead",
"441397", "Fort\ William",
"4415394", "Hawkshead",
"441349", "Dingwall",
"441228", "Carlisle",
"4414375", "Clynderwen\ \(Clunderwen\)",
"4418908", "Coldstream",
"441383", "Dunfermline",
"441689", "Orpington",
"441726", "St\ Austell",
"441824", "Ruthin",
"441481", "Guernsey",
"441436", "Helensburgh",
"441875", "Tranent",
"441449", "Stowmarket",
"441759", "Pocklington",
"441506", "Bathgate",
"441497", "Hay\-on\-Wye",
"441638", "Newmarket",
"441666", "Malmesbury",
"441483", "Guildford",
"441899", "Biggar",
"441381", "Fortrose",
"441209", "Redruth",
"4418909", "Ayton",
"441570", "Lampeter",
"4414233", "Boroughbridge",
"4415075", "Spilsby\ \(Horncastle\)",
"441641", "Strathy",
"441368", "Dunbar",
"441253", "Blackpool",
"441558", "Llandeilo",
"442837", "Armagh",
"441968", "Penicuik",
"441981", "Wormbridge",
"441882", "Kinloch\ Rannoch",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"44239", "Portsmouth",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"4418478", "Thurso",
"441340", "Craigellachie\ \(Aberlour\)",
"442880", "Carrickmore",
"441367", "Faringdon",
"4412292", "Barrow\-in\-Furness",
"441557", "Kirkcudbright",
"441848", "Thornhill",
"4414343", "Haltwhistle",
"441784", "Staines",
"441404", "Honiton",
"441637", "Newquay",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"4415076", "Louth",
"441244", "Chester",
"441932", "Weybridge",
"4416860", "Newtown\/Llanidloes",
"441332", "Derby",
"441745", "Rhyl",
"441455", "Hinckley",
"442841", "Rostrevor",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441285", "Cirencester",
"441967", "Strontian",
"442838", "Portadown",
"442866", "Enniskillen",
"441502", "Lowestoft",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:([0-24-8]\d{5})$|0)//;
      $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;