#!/usr/bin/perl

package eBay::API::XML::DataType::BiddingDetailsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BiddingDetailsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::BiddingDetailsType

=head1 DESCRIPTION

Contains detailed information about a bid.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::BiddingDetailsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;


my @gaProperties = ( [ 'BidAssistant', 'xs:boolean', '', '', '' ]
	, [ 'ConvertedMaxBid', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'MaxBid', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'QuantityBid', 'xs:int', '', '', '' ]
	, [ 'QuantityWon', 'xs:int', '', '', '' ]
	, [ 'Winning', 'xs:boolean', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBidAssistant()

Indicates whether the current bid was placed by BidAssistant. 
Only returns if true.

#    Argument: 'xs:boolean'

=cut

sub setBidAssistant {
  my $self = shift;
  $self->{'BidAssistant'} = shift
}

=head2 isBidAssistant()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           LostList
           WonList
           DeletedFromWonList
           DeletedFromLostList
           WatchList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList

#    Returns: 'xs:boolean'

=cut

sub isBidAssistant {
  my $self = shift;
  return $self->{'BidAssistant'};
}


=head2 setConvertedMaxBid()

Converted value of the amount in MaxBidAmount, in the currency 
indicated by SiteCurrency.
For active items, refresh the listing's data every 24 hours to 
pick up the current conversion rates. Under conditions where this 
value would be N/A on the eBay site, this element is not returned 
at all.

#    Argument: 'ns:AmountType'

=cut

sub setConvertedMaxBid {
  my $self = shift;
  $self->{'ConvertedMaxBid'} = shift
}

=head2 getConvertedMaxBid()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           LostList
           WonList
           DeletedFromWonList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList

#    Returns: 'ns:AmountType'

=cut

sub getConvertedMaxBid {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ConvertedMaxBid'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setMaxBid()

Indicates the maximum amount the user has agreed to pay for the item when the
user last submitted a bid. Under conditions where this value would be
N/A on the eBay site, this element is not returned at all.

#    Argument: 'ns:AmountType'

=cut

sub setMaxBid {
  my $self = shift;
  $self->{'MaxBid'} = shift
}

=head2 getMaxBid()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           LostList
           WonList
           DeletedFromWonList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList

#    Returns: 'ns:AmountType'

=cut

sub getMaxBid {
  my $self = shift;
  return $self->_getDataTypeInstance( 'MaxBid'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setQuantityBid()

Number of items from the listing the user agreed to
purchase with a bid. For single-item listings, always 1.
For multi-item listings, will be between 1 and the number of items offered in the auction.
Number of items purchased so far.

#    Argument: 'xs:int'

=cut

sub setQuantityBid {
  my $self = shift;
  $self->{'QuantityBid'} = shift
}

=head2 getQuantityBid()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           LostList
           WonList
           DeletedFromWonList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList

#    Returns: 'xs:int'

=cut

sub getQuantityBid {
  my $self = shift;
  return $self->{'QuantityBid'};
}


=head2 setQuantityWon()

Used mainly for Dutch auction. For an active listing,
number of items the user stands to win if the user is a current winning bidder.
For an ended listing, number of items the user actually won.
In both cases, the number may be less than that returned in
QuantityBid as the lowest winning bidder in a Dutch auction might not win
the number of items the user has bid on.

#    Argument: 'xs:int'

=cut

sub setQuantityWon {
  my $self = shift;
  $self->{'QuantityWon'} = shift
}

=head2 getQuantityWon()

  Calls: GetMyeBayBuying
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList
           LostList
           WonList
           DeletedFromWonList
           DeletedFromLostList

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: BidList

#    Returns: 'xs:int'

=cut

sub getQuantityWon {
  my $self = shift;
  return $self->{'QuantityWon'};
}


=head2 setWinning()

(GetMyeBay only) Indicates whether the user is the current
high bidder in a currently active listing.

#    Argument: 'xs:boolean'

=cut

sub setWinning {
  my $self = shift;
  $self->{'Winning'} = shift
}

=head2 isWinning()

#    Returns: 'xs:boolean'

=cut

sub isWinning {
  my $self = shift;
  return $self->{'Winning'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
