#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::StoreSearchCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. StoreSearchCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::StoreSearchCodeType

=head1 DESCRIPTION

Identifies the StoreSearch codes (e.g., for GetSearchResults requests).



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 AllItemsInTheStore

(in) Within a single store for all items (specify store in
SearchStoreFilterType.StoreName).



=cut


use constant AllItemsInTheStore => scalar('AllItemsInTheStore');


=head2 AuctionItemsInTheStore

(in) Within a single store for auction items (specify store in
SearchStoreFilterType.StoreName).



=cut


use constant AuctionItemsInTheStore => scalar('AuctionItemsInTheStore');


=head2 BuyItNowItemsInTheStore

(in) Within a single store for basic fixed price items, Store Inventory format items,
and auction items with Buy It Now. (Specify store in SearchStoreFilterType.StoreName).



=cut


use constant BuyItNowItemsInTheStore => scalar('BuyItNowItemsInTheStore');


=head2 BuyItNowItemsInAllStores

(in) Across all stores for basic fixed price items, Store Inventory format items,
and auction items with Buy It Now.



=cut


use constant BuyItNowItemsInAllStores => scalar('BuyItNowItemsInAllStores');


=head2 CustomCode

(out) Reserved for internal or future use.



=cut


use constant CustomCode => scalar('CustomCode');







1;   
