#!/usr/bin/perl

package eBay::API::XML::DataType::SearchLocationFilterType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SearchLocationFilterType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SearchLocationFilterType

=head1 DESCRIPTION

One of the data filters used when searching for items using GetSearchResults. 
Allows filtering based on an item's location (where the seller would be shipping 
the item from) or an item's availability (which eBay sites the item can be 
purchased from).



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SearchLocationFilterType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::SearchLocationType;
use eBay::API::XML::DataType::Enum::CountryCodeType;
use eBay::API::XML::DataType::Enum::CurrencyCodeType;
use eBay::API::XML::DataType::Enum::ItemLocationCodeType;


my @gaProperties = ( [ 'CountryCode', 'ns:CountryCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CountryCodeType', '' ]
	, [ 'Currency', 'ns:CurrencyCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CurrencyCodeType', '' ]
	, [ 'ItemLocation', 'ns:ItemLocationCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ItemLocationCodeType', '' ]
	, [ 'SearchLocation', 'ns:SearchLocationType', ''
	     ,'eBay::API::XML::DataType::SearchLocationType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCountryCode()

Country the item is either located in or available to (depending on the 
value specified in ItemLocation).

  Calls: GetSearchResults
  RequiredInput: No

#    Argument: 'ns:CountryCodeType'

=cut

sub setCountryCode {
  my $self = shift;
  $self->{'CountryCode'} = shift
}

=head2 getCountryCode()

#    Returns: 'ns:CountryCodeType'

=cut

sub getCountryCode {
  my $self = shift;
  return $self->{'CountryCode'};
}


=head2 setCurrency()

Limits the result set to just those items with a specified currency.

  Calls: GetSearchResults
  RequiredInput: No

#    Argument: 'ns:CurrencyCodeType'

=cut

sub setCurrency {
  my $self = shift;
  $self->{'Currency'} = shift
}

=head2 getCurrency()

#    Returns: 'ns:CurrencyCodeType'

=cut

sub getCurrency {
  my $self = shift;
  return $self->{'Currency'};
}


=head2 setItemLocation()

Specifies whether the filter should be for items located in the country 
specified in Country or available to that country.

  Calls: GetSearchResults
  RequiredInput: No

#    Argument: 'ns:ItemLocationCodeType'

=cut

sub setItemLocation {
  my $self = shift;
  $self->{'ItemLocation'} = shift
}

=head2 getItemLocation()

#    Returns: 'ns:ItemLocationCodeType'

=cut

sub getItemLocation {
  my $self = shift;
  return $self->{'ItemLocation'};
}


=head2 setSearchLocation()

Specifies filtering based on the location of the item or its availability 
relative to an eBay site. Or, allows for filtering based on regional listing.

  Calls: GetSearchResults
  RequiredInput: No

#    Argument: 'ns:SearchLocationType'

=cut

sub setSearchLocation {
  my $self = shift;
  $self->{'SearchLocation'} = shift
}

=head2 getSearchLocation()

#    Returns: 'ns:SearchLocationType'

=cut

sub getSearchLocation {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SearchLocation'
		,'eBay::API::XML::DataType::SearchLocationType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
