#!/usr/bin/perl

use strict;
use lib 't/lib';
use utf8;

use Test::More;
use Test::Deep qw(cmp_deeply);

use FusionInventory::Agent::SNMP::Mock;
use FusionInventory::Agent::Tools::Hardware;

my %tests = (
    'juniper/ex2200.01.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Juniper',
            MODEL        => 'EX2200',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-c-12p-2g internet router, kernel JUNOS 11.3R1.7 #0: 2011-08-30 11:49:21 UTC     builder@dagmath.juniper.net:/volume/build/junos/11.3/release/11.3R1.7/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2011-08-30 11:32:01',

            SNMPHOSTNAME => 'AB-B404-23-ex2200',
            UPTIME       => '(1896073543) 219 days, 10:52:15.43',
            IPS          => {
                IP => [
                    '128.0.0.1',
                    '128.0.0.127',
                    '128.0.0.16',
                    '128.0.0.32',
                    '192.168.1.23',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Juniper',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-c-12p-2g internet router, kernel JUNOS 11.3R1.7 #0: 2011-08-30 11:49:21 UTC     builder@dagmath.juniper.net:/volume/build/junos/11.3/release/11.3R1.7/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2011-08-30 11:32:01',
                NAME         => 'AB-B404-23-ex2200',
                UPTIME       => '(1896073543) 219 days, 10:52:15.43',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.1.23',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210618496) 24 days, 9:03:04.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651137) 24 days, 9:08:31.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651144) 24 days, 9:08:31.44',
                        IFINOCTETS       => '3847149791',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3847149791',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651150) 24 days, 9:08:31.50',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651140) 24 days, 9:08:31.40',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651143) 24 days, 9:08:31.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651130) 24 days, 9:08:31.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651132) 24 days, 9:08:31.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651149) 24 days, 9:08:31.49',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:3f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651147) 24 days, 9:08:31.47',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651124) 24 days, 9:08:31.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1660461977',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651153) 24 days, 9:08:31.53',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'jsrv',
                        IFDESCR          => 'jsrv',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:df:20:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(795719864) 92 days, 2:19:58.64',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'jsrv.1',
                        IFDESCR          => 'jsrv.1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '128.0.0.127',
                        MAC              => '78:fe:3d:df:20:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(795719864) 92 days, 2:19:58.64',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:df:20:01',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651161) 24 days, 9:08:31.61',
                        IFINOCTETS       => '2169597684',
                        IFINERRORS       => '22',
                        IFOUTOCTETS      => '378679611',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:03',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080979263) 240 days, 20:29:52.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '54996177',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3775595507',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:04',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081029863) 240 days, 20:38:18.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '42701777',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8617260',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:05',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080957353) 240 days, 20:26:13.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '276103333',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1776301481',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:06',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081042643) 240 days, 20:40:26.43',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '743174854',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1617417859',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:07',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081034223) 240 days, 20:39:02.23',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '65424546',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '729029155',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:08',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081071652) 240 days, 20:45:16.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '121426929',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '786124744',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:09',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081053722) 240 days, 20:42:17.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '310326639',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1458885492',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651201) 24 days, 9:08:32.01',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651203) 24 days, 9:08:32.03',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:03',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080979263) 240 days, 20:29:52.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '12422938',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5825457',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080931282) 240 days, 20:21:52.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '703703523',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1577399105',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651209) 24 days, 9:08:32.09',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:04',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081029863) 240 days, 20:38:18.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '12416987',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5824725',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080999052) 240 days, 20:33:10.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '242475284',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1017324509',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:05',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080957353) 240 days, 20:26:13.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '37828621',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '127953081',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:06',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081042643) 240 days, 20:40:26.43',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '37862757',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '128037429',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:07',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081034223) 240 days, 20:39:02.23',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '18172757',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '33823397',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:08',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081071652) 240 days, 20:45:16.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '35637120',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '117501872',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:09',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2081053722) 240 days, 20:42:17.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '38298814',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '130188996',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651217) 24 days, 9:08:32.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0b',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651220) 24 days, 9:08:32.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080931282) 240 days, 20:21:52.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '37907646',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '128195994',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651225) 24 days, 9:08:32.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2080999052) 240 days, 20:33:10.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '33695673',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '108809558',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/1/0',
                        IFDESCR          => 'ge-0/1/0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651230) 24 days, 9:08:32.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/1/0.0',
                        IFDESCR          => 'ge-0/1/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:0f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651234) 24 days, 9:08:32.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/1/1',
                        IFDESCR          => 'ge-0/1/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651853) 24 days, 9:08:38.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1984754089',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2897992952',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/1/1.0',
                        IFDESCR          => 'ge-0/1/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:df:20:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651853) 24 days, 9:08:38.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3925538024',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '515351797',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.23',
                        MAC              => '78:fe:3d:df:20:01',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210651853) 24 days, 9:08:38.53',
                        IFINOCTETS       => '2169600207',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '344650884',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'juniper/ex2200.02.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Juniper',
            MODEL        => 'EX2200',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-c-12p-2g internet router, kernel JUNOS 11.4R1.6 #0: 2011-11-15 10:11:59 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R1.6/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2011-11-15 09:57:14',

            SNMPHOSTNAME => 'C005-236b-ex2200',
            UPTIME       => '(1539344336) 178 days, 3:57:23.36',
            IPS          => {
                IP => [
                    '128.0.0.1',
                    '128.0.0.127',
                    '128.0.0.16',
                    '128.0.0.32',
                    '192.168.1.236',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Juniper',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-c-12p-2g internet router, kernel JUNOS 11.4R1.6 #0: 2011-11-15 10:11:59 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R1.6/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2011-11-15 09:57:14',
                NAME         => 'C005-236b-ex2200',
                UPTIME       => '(1539344336) 178 days, 3:57:23.36',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.1.236',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1328) 0:00:13.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1356) 0:00:13.56',
                        IFINOCTETS       => '1205099385',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1205099385',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1371) 0:00:13.71',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1336) 0:00:13.36',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1352) 0:00:13.52',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1271) 0:00:12.71',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1274) 0:00:12.74',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1363) 0:00:13.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:ff',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1358) 0:00:13.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1268) 0:00:12.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '534363148',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1377) 0:00:13.77',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'jsrv',
                        IFDESCR          => 'jsrv',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '64:87:88:b0:39:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1288) 0:00:12.88',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'jsrv.1',
                        IFDESCR          => 'jsrv.1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '128.0.0.127',
                        MAC              => '64:87:88:b0:39:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1292) 0:00:12.92',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '64:87:88:b0:39:c1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1391) 0:00:13.91',
                        IFINOCTETS       => '1895692302',
                        IFINERRORS       => '18',
                        IFOUTOCTETS      => '350482164',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1404) 0:00:14.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1407) 0:00:14.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519198217) 175 days, 19:59:42.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '671285559',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1344808667',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519198217) 175 days, 19:59:42.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '19465116',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5704',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1428) 0:00:14.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1441) 0:00:14.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519237117) 175 days, 20:06:11.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1801889333',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2786297666',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519237117) 175 days, 20:06:11.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '30642324',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6670',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519160047) 175 days, 19:53:20.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '749044509',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1606606341',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519160047) 175 days, 19:53:20.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '24091394',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6578',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1520147727) 175 days, 22:37:57.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1460221696',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2680801766',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1520147727) 175 days, 22:37:57.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '24573648',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '7636',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519144687) 175 days, 19:50:46.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1204472549',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2280812113',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:c9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519144687) 175 days, 19:50:46.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '25579766',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4784',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:ca',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(276784128) 32 days, 0:50:41.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1884',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '538',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:ca',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(276784128) 32 days, 0:50:41.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '826',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '92',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519114587) 175 days, 19:45:45.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1293235433',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2255802556',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(276799604) 32 days, 0:53:16.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1998',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '576',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507) 0:00:15.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1519114587) 175 days, 19:45:45.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '31177451',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6532',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:ce',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1512) 0:00:15.12',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cc',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(276799604) 32 days, 0:53:16.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1420',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '92',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cd',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1541) 0:00:15.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:ce',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1554) 0:00:15.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/1/0',
                        IFDESCR          => 'ge-0/1/0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cf',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1550) 0:00:15.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/1/0.0',
                        IFDESCR          => 'ge-0/1/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:cf',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1572) 0:00:15.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/1/1',
                        IFDESCR          => 'ge-0/1/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(28667) 0:04:46.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3750278254',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3165078235',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/1/1.0',
                        IFDESCR          => 'ge-0/1/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '64:87:88:b0:39:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(28667) 0:04:46.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2510254288',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '361557089',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.236',
                        MAC              => '64:87:88:b0:39:c1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(28671) 0:04:46.71',
                        IFINOCTETS       => '1895694825',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '315971005',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'juniper/ex2200.03.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Juniper',
            MODEL        => 'EX2200',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-24t-4g internet router, kernel JUNOS 11.1R3.5 #0: 2011-06-25 00:35:00 UTC     builder@briath.juniper.net:/volume/build/junos/11.1/release/11.1R3.5/obj-arm/bsd/kernels/JUNIPER-EX/kernel Build date: 2011-06-25 00:31:37 UTC Cop',

            SNMPHOSTNAME => 'INTERUFR-219-ex2200-24',
            LOCATION     => 'CB',
            CONTACT      => 'cricesr@dauphine.fr',
            SERIAL       => 'CW0211513175',
            UPTIME       => '(9174471) 1 day, 1:29:04.71',
            MEMORY       => '0',
            MAC          => '78:fe:3d:d5:0e:c0',
            IPS          => {
                IP => [
                    '128.0.0.1',
                    '128.0.0.127',
                    '128.0.0.16',
                    '128.0.0.32',
                    '192.168.1.219',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Juniper',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-24t-4g internet router, kernel JUNOS 11.1R3.5 #0: 2011-06-25 00:35:00 UTC     builder@briath.juniper.net:/volume/build/junos/11.1/release/11.1R3.5/obj-arm/bsd/kernels/JUNIPER-EX/kernel Build date: 2011-06-25 00:31:37 UTC Cop',
                NAME         => 'INTERUFR-219-ex2200-24',
                LOCATION     => 'CB',
                CONTACT      => 'cricesr@dauphine.fr',
                SERIAL       => 'CW0211513175',
                UPTIME       => '(9174471) 1 day, 1:29:04.71',
                MEMORY       => '0',
                MAC          => '78:fe:3d:d5:0e:c0',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.1.219',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4298) 0:00:42.98',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4128) 0:00:41.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4295) 0:00:42.95',
                        IFINOCTETS       => '131885047',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '131885047',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4311) 0:00:43.11',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4282) 0:00:42.82',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4288) 0:00:42.88',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4309) 0:00:43.09',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4307) 0:00:43.07',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4304) 0:00:43.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:ff',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4300) 0:00:43.00',
                        IFINOCTETS       => '14638812',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => 'me0.0',
                        IFDESCR          => 'me0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.219',
                        MAC              => '78:fe:3d:d5:0e:ff',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4302) 0:00:43.02',
                        IFINOCTETS       => '14638898',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3954144',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4123) 0:00:41.23',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '13256588',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4125) 0:00:41.25',
                        IFINOCTETS       => '3337783',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4130) 0:00:41.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c0',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4131) 0:00:41.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4134) 0:00:41.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c1',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4136) 0:00:41.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:ca',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4172) 0:00:41.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:ca',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4172) 0:00:41.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cb',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4264) 0:00:42.64',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cb',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4264) 0:00:42.64',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/12',
                        IFDESCR          => 'ge-0/0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4332) 0:00:43.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/12.0',
                        IFDESCR          => 'ge-0/0/12.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cc',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4332) 0:00:43.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/13',
                        IFDESCR          => 'ge-0/0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/13.0',
                        IFDESCR          => 'ge-0/0/13.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cd',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4357) 0:00:43.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/14',
                        IFDESCR          => 'ge-0/0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:ce',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4383) 0:00:43.83',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/14.0',
                        IFDESCR          => 'ge-0/0/14.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:ce',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4383) 0:00:43.83',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/15',
                        IFDESCR          => 'ge-0/0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cf',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4418) 0:00:44.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/15.0',
                        IFDESCR          => 'ge-0/0/15.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:cf',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4418) 0:00:44.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/16',
                        IFDESCR          => 'ge-0/0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4450) 0:00:44.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/16.0',
                        IFDESCR          => 'ge-0/0/16.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d0',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4450) 0:00:44.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/17',
                        IFDESCR          => 'ge-0/0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4479) 0:00:44.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/17.0',
                        IFDESCR          => 'ge-0/0/17.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d1',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4479) 0:00:44.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/18',
                        IFDESCR          => 'ge-0/0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4511) 0:00:45.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/18.0',
                        IFDESCR          => 'ge-0/0/18.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d2',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4511) 0:00:45.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/19',
                        IFDESCR          => 'ge-0/0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4536) 0:00:45.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/19.0',
                        IFDESCR          => 'ge-0/0/19.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4536) 0:00:45.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4211) 0:00:42.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c2',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4213) 0:00:42.13',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/20',
                        IFDESCR          => 'ge-0/0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4557) 0:00:45.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/0/20.0',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d4',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4557) 0:00:45.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/0/21',
                        IFDESCR          => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4567) 0:00:45.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/0/21.0',
                        IFDESCR          => 'ge-0/0/21.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4567) 0:00:45.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/0/22',
                        IFDESCR          => 'ge-0/0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4587) 0:00:45.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'ge-0/0/22.0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d6',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4587) 0:00:45.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '533',
                        IFNAME           => 'ge-0/0/23',
                        IFDESCR          => 'ge-0/0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4618) 0:00:46.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '534',
                        IFNAME           => 'ge-0/0/23.0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d7',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4618) 0:00:46.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '535',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4236) 0:00:42.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '536',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4238) 0:00:42.38',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '537',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4239) 0:00:42.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '538',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c4',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4240) 0:00:42.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '539',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4242) 0:00:42.42',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '540',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4245) 0:00:42.45',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '541',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4247) 0:00:42.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '542',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c6',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4250) 0:00:42.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '543',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4254) 0:00:42.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '544',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c7',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4257) 0:00:42.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '545',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4260) 0:00:42.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '546',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c8',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4266) 0:00:42.66',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '547',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4269) 0:00:42.69',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '548',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:c9',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4271) 0:00:42.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '549',
                        IFNAME           => 'ge-0/1/0',
                        IFDESCR          => 'ge-0/1/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4627) 0:00:46.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2760591156',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '742321097',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '550',
                        IFNAME           => 'ge-0/1/0.0',
                        IFDESCR          => 'ge-0/1/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:d8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4627) 0:00:46.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1518484',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6487435',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:10:5a:13:a5:47',
                                    '00:10:5a:1b:c5:be',
                                    '00:d0:b7:45:80:30',
                                    '00:18:f3:f0:0c:0e',
                                    '00:19:d1:82:ab:f6',
                                    '00:1b:2f:b3:c0:d5',
                                    '00:1b:2f:b3:c0:d7',
                                    '00:1c:c0:bd:d2:82',
                                    '00:1c:c0:bd:d7:79',
                                    '00:1c:c0:bd:d7:54',
                                    '00:1c:c0:bd:d9:1b',
                                    '00:1c:c0:bd:d9:3f',
                                    '00:1c:c0:dc:69:5a',
                                    '00:1c:c0:dc:6b:fa',
                                    '00:1c:c0:dc:6d:47',
                                    '00:1c:c0:dc:7a:ea',
                                    '00:1c:c0:dc:7b:17',
                                    '00:1c:c0:dc:7d:7f',
                                    '00:1c:c0:df:39:ee',
                                    '00:1c:c0:df:39:f6',
                                    '00:1c:c0:df:3a:8a',
                                    '00:1c:c0:df:3a:8b',
                                    '00:1c:c0:df:3a:1f',
                                    '00:1c:c0:df:3a:55',
                                    '00:03:22:01:9b:19',
                                    '00:27:0e:2d:f8:64',
                                    '00:27:0e:2d:f9:60',
                                    '00:40:0d:8a:8b:47',
                                    '00:50:da:7c:51:52',
                                    '00:50:da:7c:63:4c',
                                    '00:50:da:d8:4e:47',
                                    '00:50:04:82:ce:89',
                                    '00:50:04:a9:60:39',
                                    '00:50:04:50:54:e8',
                                    '00:60:08:64:12:81',
                                    '00:60:08:64:15:f0',
                                    '00:60:08:64:16:8c',
                                    '00:60:08:64:16:11',
                                    '00:60:08:64:16:3f',
                                    '00:60:08:64:16:46',
                                    '00:60:08:64:16:4c',
                                    '00:60:08:64:23:e5',
                                    '00:60:08:72:78:cb',
                                    '00:60:08:0c:01:7d',
                                    '00:60:08:9f:35:83',
                                    '00:60:08:63:fa:63',
                                    '78:e7:d1:a9:3c:2b',
                                    '8c:89:a5:3a:ba:20',
                                    'b4:b5:2f:54:c9:30',
                                    'bc:ae:c5:43:da:70',
                                    'c8:9c:dc:f3:e7:71',
                                    'f8:0f:41:36:13:75',
                                    'f8:0f:41:36:13:63',
                                    'f8:0f:41:36:49:6b',
                                    'f8:0f:41:36:49:03',
                                    'f8:0f:41:3b:13:6f',
                                    'f8:0f:41:3d:1e:e6',
                                    'f8:0f:41:3d:38:66',
                                    'f8:0f:41:3d:38:a0',
                                    'f8:0f:41:3d:38:d7',
                                    'f8:0f:41:3d:38:da',
                                    'f8:0f:41:3d:38:26',
                                    'f8:0f:41:3d:39:85',
                                    'f8:0f:41:3d:39:32',
                                    'f8:0f:41:3d:39:35',
                                    'f8:0f:41:3d:43:64',
                                    'f8:0f:41:3d:43:69',
                                    'f8:0f:41:3d:43:8b',
                                    'f8:0f:41:3d:47:00',
                                    'f8:0f:41:3d:48:95',
                                    'f8:0f:41:3d:48:c4',
                                    'f8:0f:41:3d:48:ca',
                                    'f8:0f:41:3d:48:59',
                                    'f8:0f:41:3e:0a:d1',
                                    'f8:0f:41:3e:0a:29',
                                    'f8:0f:41:3e:0b:c5',
                                    'f8:0f:41:3e:0b:d2',
                                    'f8:0f:41:3e:0c:bd',
                                    'f8:0f:41:3e:0c:33',
                                    'f8:0f:41:3e:07:37',
                                    'f8:0f:41:3e:09:2e',
                                    '20:cf:30:f0:82:d8',
                                    '20:cf:30:f0:82:e6',
                                    'f8:0f:41:3d:49:2a',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '555',
                        IFNAME           => 'ge-0/1/3',
                        IFDESCR          => 'ge-0/1/3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:db',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4674) 0:00:46.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '738384759',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2761755337',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '556',
                        IFNAME           => 'jsrv',
                        IFDESCR          => 'jsrv',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:d5:0e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4290) 0:00:42.90',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '557',
                        IFNAME           => 'jsrv.1',
                        IFDESCR          => 'jsrv.1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '128.0.0.127',
                        MAC              => '78:fe:3d:d5:0e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4293) 0:00:42.93',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '558',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:d5:0e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4316) 0:00:43.16',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '559',
                        IFNAME           => 'ge-0/1/3.0',
                        IFDESCR          => 'ge-0/1/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:d5:0e:db',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4674) 0:00:46.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '796377',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6009138',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:11:85:69:2f:08',
                                    '00:11:85:69:2f:09',
                                    '00:12:79:39:3c:6e',
                                    '00:12:79:39:3c:30',
                                    '00:15:60:a8:9a:31',
                                    '00:15:60:a8:9a:32',
                                    '00:15:60:a8:c8:a5',
                                    '00:15:60:a8:c8:a6',
                                    '00:24:81:a5:8c:99',
                                    '00:24:81:a5:8c:9a',
                                    '00:24:81:a5:ad:82',
                                    '00:24:81:a5:ad:84',
                                    '00:25:b3:aa:d6:b6',
                                    '00:50:56:b7:0b:86',
                                    '00:50:56:b7:20:69',
                                    '78:e3:b5:12:97:d8',
                                    '78:e3:b5:12:97:da',
                                    '78:e3:b5:12:a7:0a',
                                    '78:e3:b5:12:a7:08',
                                    '9c:8e:99:14:8a:9c',
                                    '9c:8e:99:14:8a:9e',
                                    '9c:8e:99:14:8a:a4',
                                    '9c:8e:99:14:8a:a6',
                                    'b4:99:ba:c0:eb:a4',
                                    'b4:99:ba:c0:eb:a6',
                                    'b4:99:ba:c0:eb:a8',
                                    'b4:99:ba:c0:eb:aa',
                                    'e4:11:5b:b0:29:fe',
                                    'e4:11:5b:b0:2a:02',
                                    'e4:11:5b:b0:2a:04',
                                    '18:33:9d:e7:15:1a',
                                ],
                            }
                        }
                    },
                ]
            },
        },
    ],
    'juniper/ex2200.04.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Juniper',
            MODEL        => 'EX2200',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.1R3.5 #0: 2011-06-25 00:35:00 UTC     builder@briath.juniper.net:/volume/build/junos/11.1/release/11.1R3.5/obj-arm/bsd/kernels/JUNIPER-EX/kernel Build date: 2011-06-25 00:31:37 UTC Cop',

            SNMPHOSTNAME => 'AB-BU6-132-ex2200-48',
            LOCATION     => 'AB-BU6',
            CONTACT      => 'cricesr@dauphine.fr',
            SERIAL       => 'CU0211450517',
            UPTIME       => '(1514669572) 175 days, 7:24:55.72',
            MEMORY       => '0',
            MAC          => '78:fe:3d:37:5e:c0',
            IPS          => {
                IP => [
                    '128.0.0.1',
                    '128.0.0.127',
                    '128.0.0.16',
                    '128.0.0.32',
                    '192.168.1.132',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Juniper',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.1R3.5 #0: 2011-06-25 00:35:00 UTC     builder@briath.juniper.net:/volume/build/junos/11.1/release/11.1R3.5/obj-arm/bsd/kernels/JUNIPER-EX/kernel Build date: 2011-06-25 00:31:37 UTC Cop',
                NAME         => 'AB-BU6-132-ex2200-48',
                LOCATION     => 'AB-BU6',
                CONTACT      => 'cricesr@dauphine.fr',
                SERIAL       => 'CU0211450517',
                UPTIME       => '(1514669572) 175 days, 7:24:55.72',
                MEMORY       => '0',
                MAC          => '78:fe:3d:37:5e:c0',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.1.132',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3055) 0:00:30.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3012) 0:00:30.12',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3019) 0:00:30.19',
                        IFINOCTETS       => '4148021786',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4148591022',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3066) 0:00:30.66',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3014) 0:00:30.14',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3015) 0:00:30.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3065) 0:00:30.65',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3063) 0:00:30.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3060) 0:00:30.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ff',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3058) 0:00:30.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3010) 0:00:30.10',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '901896814',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3011) 0:00:30.11',
                        IFINOCTETS       => '2267152155',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1513913595) 175 days, 5:18:55.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '62430575',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2121260600',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1513913595) 175 days, 5:18:55.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '614461',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '323610',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:24:be:b6:4c:20',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507307600) 174 days, 10:57:56.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '147698220',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '886946729',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c1',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507307600) 174 days, 10:57:56.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1758171',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '754660',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ca',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1202418760) 139 days, 4:03:07.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '33040562',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '919887004',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ca',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1202418760) 139 days, 4:03:07.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '260404',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '113845',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cb',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1204402388) 139 days, 9:33:43.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '23866591',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '573739283',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cb',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1204402388) 139 days, 9:33:43.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '687393',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '75969',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/12',
                        IFDESCR          => 'ge-0/0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1454505788) 168 days, 8:17:37.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '65490962',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3128608219',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/12.0',
                        IFDESCR          => 'ge-0/0/12.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cc',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1454505788) 168 days, 8:17:37.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1205122',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '668789',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/13',
                        IFDESCR          => 'ge-0/0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1383988034) 160 days, 4:24:40.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '50434211',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2070139092',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/13.0',
                        IFDESCR          => 'ge-0/0/13.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cd',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1383988034) 160 days, 4:24:40.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '390894',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '131871',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/14',
                        IFDESCR          => 'ge-0/0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ce',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1392608516) 161 days, 4:21:25.16',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '73541065',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2042948528',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/14.0',
                        IFDESCR          => 'ge-0/0/14.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ce',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1392608516) 161 days, 4:21:25.16',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '247639',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '142940',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/15',
                        IFDESCR          => 'ge-0/0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cf',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1383987392) 160 days, 4:24:33.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '10291556',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '920149549',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/15.0',
                        IFDESCR          => 'ge-0/0/15.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:cf',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1383987392) 160 days, 4:24:33.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '624396',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '193755',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/16',
                        IFDESCR          => 'ge-0/0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1402988034) 162 days, 9:11:20.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '144694897',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '373175314',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/16.0',
                        IFDESCR          => 'ge-0/0/16.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d0',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1402988034) 162 days, 9:11:20.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4168655',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '800961',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/17',
                        IFDESCR          => 'ge-0/0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1505111362) 174 days, 4:51:53.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '112282597',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3622860141',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/17.0',
                        IFDESCR          => 'ge-0/0/17.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d1',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1505111362) 174 days, 4:51:53.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3263756',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '388748',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/18',
                        IFDESCR          => 'ge-0/0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1143701810) 132 days, 8:56:58.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '69571870',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2110991844',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/18.0',
                        IFDESCR          => 'ge-0/0/18.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d2',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1143701810) 132 days, 8:56:58.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2358039',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '498770',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/19',
                        IFDESCR          => 'ge-0/0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1143887182) 132 days, 9:27:51.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '54665076',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1198628365',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/19.0',
                        IFDESCR          => 'ge-0/0/19.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1143887182) 132 days, 9:27:51.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '844445',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '84168',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1514274855) 175 days, 6:19:08.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '71549018',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2214237751',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1514274855) 175 days, 6:19:08.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1344926',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '216986',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:26:b0:f1:25:3e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/20',
                        IFDESCR          => 'ge-0/0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1031918668) 119 days, 10:26:26.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '101162940',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3191603905',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/0/20.0',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d4',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1031918668) 119 days, 10:26:26.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '287186',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '331734',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/0/21',
                        IFDESCR          => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1452971670) 168 days, 4:01:56.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '45333984',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1112146726',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/0/21.0',
                        IFDESCR          => 'ge-0/0/21.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1452971670) 168 days, 4:01:56.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2170170',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '118187',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/0/22',
                        IFDESCR          => 'ge-0/0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507744280) 174 days, 12:10:42.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '349227121',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2349516312',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'ge-0/0/22.0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d6',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507744280) 174 days, 12:10:42.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '7875686',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '837854',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '533',
                        IFNAME           => 'ge-0/0/23',
                        IFDESCR          => 'ge-0/0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384857878) 160 days, 6:49:38.78',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '63700153',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3770626360',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '534',
                        IFNAME           => 'ge-0/0/23.0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d7',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384857878) 160 days, 6:49:38.78',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1953525',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '505220',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '535',
                        IFNAME           => 'ge-0/0/24',
                        IFDESCR          => 'ge-0/0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1506337000) 174 days, 8:16:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '24341650',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1675279409',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '536',
                        IFNAME           => 'ge-0/0/24.0',
                        IFDESCR          => 'ge-0/0/24.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d8',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1506337000) 174 days, 8:16:10.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '299238',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '215960',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '537',
                        IFNAME           => 'ge-0/0/25',
                        IFDESCR          => 'ge-0/0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1506965500) 174 days, 10:00:55.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '149804990',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '958374164',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '538',
                        IFNAME           => 'ge-0/0/25.0',
                        IFDESCR          => 'ge-0/0/25.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:d9',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1506965500) 174 days, 10:00:55.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3824745',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '429062',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '539',
                        IFNAME           => 'ge-0/0/26',
                        IFDESCR          => 'ge-0/0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:da',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1030566650) 119 days, 6:41:06.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '8707382',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '314497846',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '540',
                        IFNAME           => 'ge-0/0/26.0',
                        IFDESCR          => 'ge-0/0/26.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:da',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1030566650) 119 days, 6:41:06.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '250977',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6710',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '541',
                        IFNAME           => 'ge-0/0/27',
                        IFDESCR          => 'ge-0/0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:db',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507221140) 174 days, 10:43:31.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '59953469',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2945748283',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '542',
                        IFNAME           => 'ge-0/0/27.0',
                        IFDESCR          => 'ge-0/0/27.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:db',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1507221140) 174 days, 10:43:31.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '424630',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '118141',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '543',
                        IFNAME           => 'ge-0/0/28',
                        IFDESCR          => 'ge-0/0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:dc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(850490968) 98 days, 10:28:29.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '35974557',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '801954910',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '544',
                        IFNAME           => 'ge-0/0/28.0',
                        IFDESCR          => 'ge-0/0/28.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:dc',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(850490968) 98 days, 10:28:29.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1732098',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '460',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '545',
                        IFNAME           => 'ge-0/0/29',
                        IFDESCR          => 'ge-0/0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:dd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1470728810) 170 days, 5:21:28.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '62331862',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2935236434',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '546',
                        IFNAME           => 'ge-0/0/29.0',
                        IFDESCR          => 'ge-0/0/29.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:dd',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1470728810) 170 days, 5:21:28.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1758447',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '265039',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '547',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1092023384) 126 days, 9:23:53.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '63492350',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3428946165',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '548',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1092023384) 126 days, 9:23:53.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '671676',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '309544',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '549',
                        IFNAME           => 'ge-0/0/30',
                        IFDESCR          => 'ge-0/0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:de',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1470404984) 170 days, 4:27:29.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '7460415',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '490225744',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '550',
                        IFNAME           => 'ge-0/0/30.0',
                        IFDESCR          => 'ge-0/0/30.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:de',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1470404984) 170 days, 4:27:29.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '350036',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '115652',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '551',
                        IFNAME           => 'ge-0/0/31',
                        IFDESCR          => 'ge-0/0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:df',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1110357572) 128 days, 12:19:35.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '125852225',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1174250796',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '552',
                        IFNAME           => 'ge-0/0/31.0',
                        IFDESCR          => 'ge-0/0/31.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:df',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1110357572) 128 days, 12:19:35.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3504165',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '647546',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '553',
                        IFNAME           => 'ge-0/0/32',
                        IFDESCR          => 'ge-0/0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384810132) 160 days, 6:41:41.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '124837521',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3504587939',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '554',
                        IFNAME           => 'ge-0/0/32.0',
                        IFDESCR          => 'ge-0/0/32.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e0',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384810132) 160 days, 6:41:41.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3993337',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '566590',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '555',
                        IFNAME           => 'ge-0/0/33',
                        IFDESCR          => 'ge-0/0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1143565972) 132 days, 8:34:19.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '96592127',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2598548649',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '556',
                        IFNAME           => 'ge-0/0/33.0',
                        IFDESCR          => 'ge-0/0/33.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e1',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1143565972) 132 days, 8:34:19.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2466593',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '356779',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '557',
                        IFNAME           => 'ge-0/0/34',
                        IFDESCR          => 'ge-0/0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384542134) 160 days, 5:57:01.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '16553538',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '550813130',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '558',
                        IFNAME           => 'ge-0/0/35',
                        IFDESCR          => 'ge-0/0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1118850195) 129 days, 11:55:01.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '33379366',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1447930462',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '559',
                        IFNAME           => 'ge-0/0/36',
                        IFDESCR          => 'ge-0/0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1410733362) 163 days, 6:42:13.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '23981022',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '713660693',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '560',
                        IFNAME           => 'ge-0/0/37',
                        IFDESCR          => 'ge-0/0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1211950856) 140 days, 6:31:48.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '152170123',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3016135548',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '561',
                        IFNAME           => 'ge-0/0/38',
                        IFDESCR          => 'ge-0/0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1455360768) 168 days, 10:40:07.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '76749283',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3017918010',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '562',
                        IFNAME           => 'ge-0/0/39',
                        IFDESCR          => 'ge-0/0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1505307478) 174 days, 5:24:34.78',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '203771803',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2659142896',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '563',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1099914508) 127 days, 7:19:05.08',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '38057500',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1007329801',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '564',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c4',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1099914508) 127 days, 7:19:05.08',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3524662',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '145026',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '565',
                        IFNAME           => 'ge-0/0/40',
                        IFDESCR          => 'ge-0/0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5428) 0:00:54.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '566',
                        IFNAME           => 'ge-0/0/41',
                        IFDESCR          => 'ge-0/0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5434) 0:00:54.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '567',
                        IFNAME           => 'ge-0/0/42',
                        IFDESCR          => 'ge-0/0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ea',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5441) 0:00:54.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '568',
                        IFNAME           => 'ge-0/0/43',
                        IFDESCR          => 'ge-0/0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:eb',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5448) 0:00:54.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '569',
                        IFNAME           => 'ge-0/0/44',
                        IFDESCR          => 'ge-0/0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ec',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5458) 0:00:54.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '570',
                        IFNAME           => 'ge-0/0/45',
                        IFDESCR          => 'ge-0/0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ed',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5466) 0:00:54.66',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '571',
                        IFNAME           => 'ge-0/0/46',
                        IFDESCR          => 'ge-0/0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ee',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5473) 0:00:54.73',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '572',
                        IFNAME           => 'ge-0/0/47',
                        IFDESCR          => 'ge-0/0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ef',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(6575) 0:01:05.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3459942395',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '759695086',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '573',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(848117844) 98 days, 3:52:58.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '13515708',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '817163343',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '574',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(848117844) 98 days, 3:52:58.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '74580',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '460',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '575',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1401432020) 162 days, 4:52:00.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '19677539',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '560323704',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '576',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c6',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1401432020) 162 days, 4:52:00.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1654420',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '85644',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '577',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1098601452) 127 days, 3:40:14.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '28825938',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1046046635',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '578',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c7',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1098601452) 127 days, 3:40:14.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '149457',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '75874',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '579',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1030139372) 119 days, 5:29:53.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '69584990',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4092848179',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '580',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c8',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1030139372) 119 days, 5:29:53.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '644434',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '656200',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '581',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1453646644) 168 days, 5:54:26.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1575617312',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3989857445',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '582',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:c9',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1453646644) 168 days, 5:54:26.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1953950',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '601344',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '583',
                        IFNAME           => 'jsrv',
                        IFDESCR          => 'jsrv',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:37:5e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3017) 0:00:30.17',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '584',
                        IFNAME           => 'jsrv.1',
                        IFDESCR          => 'jsrv.1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '128.0.0.127',
                        MAC              => '78:fe:3d:37:5e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3839) 0:00:38.39',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '585',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:37:5e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4134) 0:00:41.34',
                        IFINOCTETS       => '1771188614',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '507220467',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '586',
                        IFNAME           => 'ge-0/0/34.0',
                        IFDESCR          => 'ge-0/0/34.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e2',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384542134) 160 days, 5:57:01.34',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1127322',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '154281',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '587',
                        IFNAME           => 'ge-0/0/35.0',
                        IFDESCR          => 'ge-0/0/35.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1118850195) 129 days, 11:55:01.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '223310',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '225632',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '588',
                        IFNAME           => 'ge-0/0/36.0',
                        IFDESCR          => 'ge-0/0/36.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e4',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1410733362) 163 days, 6:42:13.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '503203',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '48493',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '589',
                        IFNAME           => 'ge-0/0/37.0',
                        IFDESCR          => 'ge-0/0/37.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1211950856) 140 days, 6:31:48.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '376559',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '165325',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '590',
                        IFNAME           => 'ge-0/0/38.0',
                        IFDESCR          => 'ge-0/0/38.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e6',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1455360768) 168 days, 10:40:07.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1999894',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '393988',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '591',
                        IFNAME           => 'ge-0/0/39.0',
                        IFDESCR          => 'ge-0/0/39.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e7',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1505307478) 174 days, 5:24:34.78',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3498450',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '810980',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '592',
                        IFNAME           => 'ge-0/0/40.0',
                        IFDESCR          => 'ge-0/0/40.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e8',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5431) 0:00:54.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '593',
                        IFNAME           => 'ge-0/0/41.0',
                        IFDESCR          => 'ge-0/0/41.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:e9',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5438) 0:00:54.38',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '594',
                        IFNAME           => 'ge-0/0/42.0',
                        IFDESCR          => 'ge-0/0/42.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ea',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5445) 0:00:54.45',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '595',
                        IFNAME           => 'ge-0/0/43.0',
                        IFDESCR          => 'ge-0/0/43.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:eb',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5453) 0:00:54.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '596',
                        IFNAME           => 'ge-0/0/44.0',
                        IFDESCR          => 'ge-0/0/44.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ec',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5462) 0:00:54.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '597',
                        IFNAME           => 'ge-0/0/45.0',
                        IFDESCR          => 'ge-0/0/45.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ed',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5470) 0:00:54.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '598',
                        IFNAME           => 'ge-0/0/46.0',
                        IFDESCR          => 'ge-0/0/46.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ee',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5477) 0:00:54.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '599',
                        IFNAME           => 'ge-0/0/47.0',
                        IFDESCR          => 'ge-0/0/47.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:37:5e:ef',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(6575) 0:01:05.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '85681745',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '593871581',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0b:fd:15:bb:ee',
                                    '00:0b:5f:cc:d8:80',
                                    '00:19:d1:92:0c:4c',
                                    '00:09:43:09:04:18',
                                    'e8:e7:32:27:63:f4',
                                    'e8:e7:32:2a:e0:9e',
                                    'e8:e7:32:2a:e8:a4',
                                    'e8:e7:32:2b:c1:e2',
                                    'e8:e7:32:4b:7b:b4',
                                    'e8:e7:32:4b:8a:cc',
                                    '00:01:2e:2b:c1:82',
                                    '00:80:91:6c:d0:58',
                                    '00:19:d1:8b:25:86',
                                    '00:1c:c0:86:c3:a9',
                                    '00:1c:c0:a5:07:6a',
                                    '00:1c:c0:a5:07:4a',
                                    '00:1c:c0:a5:07:4b',
                                    '00:1c:c0:2c:d4:c5',
                                    '00:1c:c0:2c:d4:2e',
                                    '00:22:68:64:59:b9',
                                    '00:22:19:ba:3a:9f',
                                    '00:22:4d:47:f3:d1',
                                    '8c:89:a5:3b:2f:bb',
                                    '8c:89:a5:3b:32:79',
                                    '8c:89:a5:3b:32:7f',
                                    '8c:89:a5:3b:32:8d',
                                    '8c:89:a5:3b:32:e4',
                                    '8c:89:a5:3b:32:f2',
                                    '8c:89:a5:3b:32:4b',
                                    '8c:89:a5:3b:32:4c',
                                    'd0:27:88:54:76:6a',
                                    'f8:0f:41:35:e4:b5',
                                    '52:54:00:fe:d5:26',
                                    '00:50:ba:23:24:63',
                                    '1c:c1:de:c9:3d:6d',
                                    '00:14:6a:d6:b1:b8',
                                    '00:14:6a:d6:b1:d8',
                                    '00:14:6a:d6:b2:b8',
                                    '00:14:6a:d6:b2:ba',
                                    '00:14:6a:d6:b2:c0',
                                    '00:14:6a:d6:b2:f4',
                                    '00:14:6a:d6:b3:14',
                                    '00:15:f2:d5:b3:f6',
                                    '00:17:c4:ae:c8:b8',
                                    '00:18:de:e1:43:bf',
                                    '00:1b:77:df:5d:e1',
                                    '00:1b:a9:a2:a8:8e',
                                    '00:1b:b1:4c:10:34',
                                    '00:1b:63:cb:45:98',
                                    '00:1c:b3:bc:b5:f0',
                                    '00:1e:64:0a:41:ae',
                                    '00:1e:64:8e:40:0e',
                                    '00:1e:64:35:1c:38',
                                    '00:1e:64:3c:e3:80',
                                    '00:1e:64:53:d8:c4',
                                    '00:1e:65:2c:6c:aa',
                                    '00:1e:c2:ae:f4:c5',
                                    '00:1e:4c:13:ce:44',
                                    '00:1e:52:6f:aa:33',
                                    '00:1e:52:c8:8f:81',
                                    '00:1f:3c:a5:cc:ef',
                                    '00:1f:3c:e1:9a:87',
                                    '00:1f:5b:b4:0c:1f',
                                    '00:1f:5b:d7:41:1f',
                                    '00:21:00:30:65:1c',
                                    '00:21:6a:0f:10:68',
                                    '00:21:6a:b6:86:96',
                                    '00:21:6b:c7:95:50',
                                    '00:21:6b:31:e5:88',
                                    '00:21:e9:db:c8:5c',
                                    '00:21:5d:08:76:58',
                                    '00:22:fa:31:cd:40',
                                    '00:22:41:f6:e1:0f',
                                    '00:22:43:70:ac:5f',
                                    '00:22:43:25:f8:02',
                                    '00:22:4d:47:f6:65',
                                    '00:22:5f:b4:e2:c8',
                                    '00:23:6c:7a:2d:67',
                                    '00:23:6c:82:7a:e6',
                                    '00:23:6c:89:6f:5e',
                                    '00:23:6c:8a:00:b0',
                                    '00:23:6c:8b:88:6c',
                                    '00:23:6c:94:c6:40',
                                    '00:23:6c:99:48:86',
                                    '00:23:6c:09:bb:50',
                                    '00:23:12:0d:33:dc',
                                    '00:23:12:c3:d9:f5',
                                    '00:23:12:54:7f:d7',
                                    '00:23:12:57:99:6e',
                                    '00:23:14:1b:a7:d0',
                                    '00:23:14:3e:a1:2c',
                                    '00:23:14:56:47:d8',
                                    '00:23:4d:4f:93:97',
                                    '00:24:d2:bf:78:ed',
                                    '00:24:d6:0a:d1:94',
                                    '00:24:d6:98:03:5a',
                                    '00:24:d6:06:e2:64',
                                    '00:25:00:3d:c4:72',
                                    '00:25:00:3f:7c:c5',
                                    '00:25:00:3f:1d:f0',
                                    '00:25:00:4f:12:88',
                                    '00:25:d3:79:55:24',
                                    '00:25:d3:d4:3e:20',
                                    '00:25:d3:d4:52:d1',
                                    '00:25:d3:3f:65:6b',
                                    '00:25:d3:45:a7:ec',
                                    '00:25:4b:71:76:ec',
                                    '00:25:4b:85:a6:4f',
                                    '00:25:4b:8f:61:cb',
                                    '00:26:82:73:62:85',
                                    '00:26:82:86:b0:c7',
                                    '00:26:82:a0:97:b6',
                                    '00:26:82:f7:38:b8',
                                    '00:26:b0:be:84:a0',
                                    '00:26:b6:c3:a6:c5',
                                    '00:26:b6:53:ad:c3',
                                    '00:26:bb:0e:ad:6e',
                                    '00:26:bb:15:dd:9f',
                                    '00:26:bb:18:80:63',
                                    '00:26:bb:18:b3:2b',
                                    '00:26:bb:1b:ad:65',
                                    '00:26:bb:03:a5:36',
                                    '00:26:c7:a7:38:9a',
                                    '00:26:c7:c1:70:1e',
                                    '00:26:4d:43:92:01',
                                    '00:26:08:e6:73:9a',
                                    '00:26:08:e7:21:bf',
                                    '00:26:08:ec:e3:96',
                                    '00:26:08:f5:87:fb',
                                    '00:27:10:f2:a3:18',
                                    '00:27:10:42:50:14',
                                    '00:08:ca:e6:b3:26',
                                    '00:08:ca:e7:7e:29',
                                    '00:08:ca:e7:2f:6b',
                                    '00:08:ca:21:42:9d',
                                    '00:08:ca:46:9b:a1',
                                    '00:50:56:b7:2c:4e',
                                    '68:a3:c4:85:93:fc',
                                    '68:a3:c4:85:97:53',
                                    '68:a3:c4:db:f2:5e',
                                    '68:a3:c4:dd:e6:21',
                                    '68:a3:c4:dd:e9:2d',
                                    '68:a3:c4:e2:5e:03',
                                    '68:a3:c4:25:2f:4d',
                                    '68:a3:c4:37:e4:6a',
                                    '68:a3:c4:4c:b1:89',
                                    '68:a8:6d:10:ea:2e',
                                    '68:a8:6d:25:c9:0c',
                                    '68:a8:6d:04:a4:5e',
                                    '68:a8:6d:2a:55:cc',
                                    '68:a8:6d:37:37:f2',
                                    '68:a8:6d:42:5e:84',
                                    '68:a8:6d:45:c1:1e',
                                    '68:a8:6d:45:1f:2a',
                                    '68:a8:6d:4a:f8:a0',
                                    '68:a8:6d:4a:63:3c',
                                    '68:a8:6d:56:12:22',
                                    '68:ed:43:df:f7:9d',
                                    '68:09:27:f1:c9:b9',
                                    '70:f1:a1:89:2a:2b',
                                    '70:f1:a1:da:a6:9e',
                                    '70:f1:a1:ed:42:b7',
                                    '70:f3:95:36:76:93',
                                    '70:1a:04:34:27:90',
                                    '70:1a:04:36:f0:b2',
                                    '70:56:81:88:75:19',
                                    '70:56:81:89:b9:17',
                                    '70:56:81:8d:ca:91',
                                    '70:56:81:8f:79:69',
                                    '70:56:81:92:9e:31',
                                    '70:56:81:9c:e7:d9',
                                    '70:56:81:9c:ef:ef',
                                    '70:56:81:aa:68:11',
                                    '70:56:81:aa:bf:85',
                                    '70:56:81:ac:22:8b',
                                    '70:56:81:ac:33:81',
                                    '70:56:81:b6:2e:8d',
                                    '70:56:81:b8:55:93',
                                    '74:de:2b:9d:1c:45',
                                    '74:de:2b:c4:ea:49',
                                    '74:de:2b:f3:5c:74',
                                    '74:de:2b:25:dd:18',
                                    '74:e5:43:a4:1a:43',
                                    '74:e5:43:bb:6b:70',
                                    '74:f0:6d:30:05:d2',
                                    '74:f0:6d:07:97:5e',
                                    '74:f0:6d:50:ce:ce',
                                    '74:f0:6d:53:3f:c2',
                                    '74:f0:6d:09:69:1b',
                                    '74:2f:68:cd:75:49',
                                    '74:2f:68:29:fd:9c',
                                    '74:2f:68:30:de:80',
                                    '74:2f:68:31:5a:c5',
                                    '74:2f:68:32:a3:59',
                                    '74:2f:68:33:dd:f7',
                                    '74:2f:68:33:eb:50',
                                    '0c:74:c2:4f:7c:34',
                                    '0c:74:c2:61:bd:fe',
                                    '0c:d2:92:03:0d:7c',
                                    '0c:60:76:44:92:09',
                                    '0c:60:76:59:62:d0',
                                    '78:92:9c:29:8f:62',
                                    '78:92:9c:06:fd:a2',
                                    '78:ca:39:ae:65:df',
                                    '78:ca:39:ae:9e:d0',
                                    '78:ca:39:b0:1f:f1',
                                    '78:ca:39:b1:19:54',
                                    '78:ca:39:b1:34:d9',
                                    '78:ca:39:b3:f3:79',
                                    '78:ca:39:b4:59:1a',
                                    '78:ca:39:b8:3d:cb',
                                    '78:ca:39:b8:5c:e1',
                                    '78:ca:39:ba:57:d3',
                                    '78:ca:39:bb:24:e3',
                                    '78:ca:39:bc:d1:44',
                                    '78:ca:39:bd:55:20',
                                    '78:ca:39:19:6f:a4',
                                    '78:ca:39:34:b2:b6',
                                    '78:ca:39:35:8c:56',
                                    '78:ca:39:5b:db:36',
                                    '78:dd:08:d4:b1:d2',
                                    '78:dd:08:e1:36:9d',
                                    '78:dd:08:f6:36:47',
                                    '78:e4:00:9f:7f:56',
                                    '78:e4:00:04:a9:7f',
                                    '7c:d1:c3:70:ef:8e',
                                    '7c:d1:c3:72:e3:ea',
                                    '7c:d1:c3:75:a7:84',
                                    '7c:d1:c3:83:52:6c',
                                    '7c:d1:c3:88:a2:d6',
                                    '7c:d1:c3:88:df:76',
                                    '7c:d1:c3:89:ae:f2',
                                    '7c:d1:c3:95:46:b6',
                                    '7c:d1:c3:98:70:e2',
                                    '7c:d1:c3:9a:80:60',
                                    '7c:d1:c3:9a:84:7a',
                                    '7c:d1:c3:9c:3f:24',
                                    '7c:d1:c3:ec:1a:cb',
                                    '7c:d1:c3:ec:09:ff',
                                    '7c:d1:c3:f1:bc:35',
                                    '7c:d1:c3:f1:f4:79',
                                    '7c:d1:c3:f5:17:51',
                                    '7c:d1:c3:f6:dc:15',
                                    '7c:d1:c3:f7:d7:c3',
                                    '7c:e9:d3:6d:8c:d2',
                                    '7c:61:93:f5:37:96',
                                    '84:a6:c8:0d:d4:f5',
                                    '84:a6:c8:5d:b1:e1',
                                    '84:4b:f5:b6:73:09',
                                    '84:4b:f5:c2:6e:59',
                                    '84:4b:f5:ca:b4:7d',
                                    '84:4b:f5:cf:d0:eb',
                                    '84:4b:f5:26:b7:86',
                                    '84:4b:f5:4c:34:8b',
                                    '84:4b:f5:54:9f:03',
                                    '88:9f:fa:69:d8:51',
                                    '88:9f:fa:03:fa:4c',
                                    '88:53:2e:b2:e0:6c',
                                    '8c:7b:9d:d5:c5:82',
                                    '8c:7b:9d:d5:e8:55',
                                    '8c:a9:82:14:56:c6',
                                    '8c:2d:aa:65:ef:51',
                                    '90:00:4e:61:24:43',
                                    '90:84:0d:78:95:d2',
                                    '90:a4:de:c1:fe:0e',
                                    '90:a4:de:28:75:16',
                                    '90:fb:a6:9e:ac:91',
                                    '90:27:e4:eb:6f:dc',
                                    '90:27:e4:ed:4a:3a',
                                    '90:27:e4:f2:2d:90',
                                    '90:27:e4:f3:97:2f',
                                    '90:27:e4:f5:4d:6b',
                                    '90:27:e4:f7:31:30',
                                    '90:27:e4:fd:40:fc',
                                    '94:db:c9:44:d6:ff',
                                    '94:39:e5:b0:54:4f',
                                    '98:0c:82:cc:01:2c',
                                    '98:fe:94:3f:c8:94',
                                    '98:fe:94:41:65:d4',
                                    '98:fe:94:47:36:3e',
                                    '98:fe:94:4a:bf:8e',
                                    '9c:b7:0d:7b:2f:a3',
                                    '9c:b7:0d:d2:c1:a9',
                                    '9c:4e:36:53:76:74',
                                    '9c:4e:36:58:d0:94',
                                    '10:93:e9:00:c7:94',
                                    '10:93:e9:04:e0:c6',
                                    '10:93:e9:5d:4a:43',
                                    '10:93:e9:5e:37:5e',
                                    '10:9a:dd:a7:e0:92',
                                    '10:9a:dd:b2:fb:61',
                                    '10:9a:dd:c2:42:39',
                                    '10:9a:dd:c5:9e:76',
                                    '10:40:f3:7b:bc:78',
                                    '10:40:f3:80:06:34',
                                    '10:40:f3:86:39:6e',
                                    '10:40:f3:8d:83:0c',
                                    '10:40:f3:8d:85:32',
                                    '10:40:f3:8f:25:38',
                                    '10:40:f3:93:99:7c',
                                    '10:40:f3:99:50:8e',
                                    '10:40:f3:9c:35:ac',
                                    '10:40:f3:a5:45:30',
                                    '10:40:f3:a7:42:56',
                                    '10:40:f3:ef:ba:be',
                                    'a4:d1:d2:82:1a:a7',
                                    'a4:d1:d2:ac:32:1b',
                                    'a8:16:b2:67:31:2a',
                                    'a8:26:d9:e9:d6:63',
                                    'ac:81:12:8c:a2:10',
                                    'ac:81:12:47:d1:a5',
                                    'b0:65:bd:01:f6:c9',
                                    'b0:65:bd:60:60:17',
                                    '12:41:9b:00:62:fa',
                                    'b4:74:9f:7c:55:ec',
                                    'b8:8d:12:0c:3f:3a',
                                    'b8:8d:12:0d:49:64',
                                    'b8:8d:12:10:4b:3a',
                                    'b8:8d:12:12:f6:e8',
                                    'b8:8d:12:16:e3:7c',
                                    'b8:8d:12:1a:e9:6a',
                                    'b8:8d:12:1b:dc:1a',
                                    'b8:8d:12:1c:58:a6',
                                    'b8:8d:12:1e:21:1e',
                                    'b8:8d:12:20:04:78',
                                    'b8:8d:12:22:fc:e2',
                                    'b8:8d:12:22:37:3a',
                                    'b8:8d:12:22:5c:76',
                                    'b8:8d:12:24:35:c2',
                                    'b8:8d:12:05:12:56',
                                    'b8:8d:12:34:99:32',
                                    'b8:8d:12:34:b1:84',
                                    'b8:8d:12:38:fa:6a',
                                    'b8:8d:12:39:d7:e4',
                                    'b8:8d:12:39:f9:e4',
                                    'b8:8d:12:06:d5:74',
                                    'b8:8d:12:40:21:ae',
                                    'b8:8d:12:07:fc:32',
                                    'bc:67:78:9a:d9:82',
                                    'bc:67:78:17:6c:ec',
                                    'c0:9f:42:52:9a:5e',
                                    'c0:cb:38:01:35:18',
                                    'c0:f8:da:a7:e9:fe',
                                    'c4:85:08:69:9c:18',
                                    'c4:85:08:6a:0b:c6',
                                    'c4:85:08:22:d6:93',
                                    'c4:85:08:22:ff:74',
                                    'c4:85:08:34:39:74',
                                    'c4:85:08:37:c7:38',
                                    'c4:85:08:41:97:e5',
                                    'c4:85:08:56:d8:d5',
                                    'c4:85:08:57:0c:c4',
                                    'c4:17:fe:b5:48:8a',
                                    'c4:17:fe:55:91:75',
                                    'c4:17:fe:5c:24:68',
                                    'c4:2c:03:00:e7:8c',
                                    'c4:46:19:5f:74:ef',
                                    '14:74:11:ec:5e:a2',
                                    '14:8f:c6:5b:80:fe',
                                    '14:10:9f:f1:0e:a2',
                                    '14:10:9f:f1:99:a6',
                                    '14:10:9f:f1:9b:5a',
                                    'c8:bc:c8:bc:e7:28',
                                    'c8:bc:c8:cc:9a:b6',
                                    'c8:bc:c8:ce:3e:88',
                                    'c8:bc:c8:d5:ff:25',
                                    'c8:bc:c8:d9:92:35',
                                    'c8:bc:c8:dd:b7:01',
                                    'c8:bc:c8:dd:e5:56',
                                    'c8:bc:c8:ea:0c:60',
                                    'c8:f7:33:20:a6:89',
                                    'cc:af:78:73:a6:a0',
                                    'cc:af:78:15:18:89',
                                    'cc:af:78:2a:02:7c',
                                    'cc:af:78:08:7b:7c',
                                    'd0:df:9a:81:09:37',
                                    'd0:df:9a:e3:3d:ee',
                                    'd0:df:9a:21:f2:97',
                                    'd0:df:9a:04:4e:4a',
                                    'd4:9a:20:65:3a:98',
                                    'd4:9a:20:66:51:4d',
                                    'd4:9a:20:68:04:29',
                                    'd4:9a:20:6e:1c:23',
                                    'd4:9a:20:71:d6:db',
                                    'd4:9a:20:71:2d:a5',
                                    'd4:9a:20:72:81:66',
                                    'd4:9a:20:72:b8:1e',
                                    'd4:9a:20:72:ba:28',
                                    'd4:9a:20:72:d6:83',
                                    'd4:9a:20:72:e4:7e',
                                    'd8:a2:5e:8c:88:79',
                                    'd8:a2:5e:8e:ff:28',
                                    'd8:a2:5e:8e:48:c4',
                                    'd8:a2:5e:91:93:0e',
                                    'd8:a2:5e:91:9e:e5',
                                    'd8:a2:5e:91:a1:34',
                                    'd8:a2:5e:91:36:12',
                                    'd8:a2:5e:97:f7:91',
                                    'd8:30:62:81:6e:9f',
                                    'dc:85:de:69:44:24',
                                    'dc:85:de:13:b1:7a',
                                    'dc:85:de:15:d1:21',
                                    'e0:b9:a5:80:12:73',
                                    'e0:b9:a5:83:1b:d5',
                                    'e0:b9:a5:9d:00:f8',
                                    'e0:b9:a5:ae:01:43',
                                    'e0:b9:a5:c5:e8:12',
                                    'e0:b9:ba:87:f0:31',
                                    'e0:b9:ba:2b:eb:f0',
                                    'e0:ca:94:77:e2:76',
                                    'e0:ca:94:1d:15:ae',
                                    'e0:ca:94:24:ec:6f',
                                    'e0:f8:47:12:76:ea',
                                    'e0:f8:47:13:02:b4',
                                    'e0:f8:47:1b:f9:00',
                                    'e0:f8:47:03:e0:e8',
                                    'e0:f8:47:2b:8b:44',
                                    'e0:f8:47:35:7b:f6',
                                    'e0:f8:47:39:8f:2c',
                                    'e0:f8:47:39:c4:9c',
                                    'e0:f8:47:39:e3:0e',
                                    'e0:f8:47:43:cc:74',
                                    'e0:f8:47:09:95:0a',
                                    'e0:06:e6:6a:6c:0e',
                                    'e0:06:e6:93:5b:21',
                                    'e0:06:e6:96:d4:a1',
                                    'e0:06:e6:11:70:b7',
                                    'e0:06:e6:41:d7:d7',
                                    'e0:06:e6:43:24:17',
                                    'e4:ce:8f:0f:1c:64',
                                    'e4:ce:8f:0f:04:58',
                                    'e4:ce:8f:2d:07:f4',
                                    'e4:ce:8f:35:bb:f2',
                                    'e4:ce:8f:36:00:ee',
                                    'e4:ce:8f:4a:bd:8e',
                                    'e4:ce:8f:4b:21:16',
                                    'e4:ce:8f:50:71:0c',
                                    'e8:03:9a:8b:6d:12',
                                    'e8:39:df:6c:b3:07',
                                    'e8:39:df:84:76:cc',
                                    'e8:39:df:3f:05:c5',
                                    '18:a9:05:e3:0c:f5',
                                    '18:34:51:17:ff:78',
                                    'f0:7b:cb:01:a5:2c',
                                    'f0:7b:cb:18:ce:2a',
                                    'f0:b4:79:13:51:14',
                                    'f0:b4:79:14:aa:e7',
                                    'f0:b4:79:14:af:78',
                                    'f0:b4:79:14:b2:c6',
                                    'f0:b4:79:14:d5:04',
                                    'f0:b4:79:18:e4:4f',
                                    'f0:b4:79:19:71:e2',
                                    'f0:b4:79:1b:e4:5b',
                                    'f0:b4:79:1c:00:c4',
                                    'f0:b4:79:1c:12:90',
                                    'f0:b4:79:1c:4f:99',
                                    'f0:b4:79:1f:5b:76',
                                    'f0:b4:79:23:a1:ee',
                                    'f0:cb:a1:ca:da:f7',
                                    'f0:dc:e2:6b:35:48',
                                    'f0:e7:7e:51:28:f4',
                                    'f8:1e:df:d9:9f:79',
                                    'f8:1e:df:e9:69:37',
                                    'f8:1e:df:eb:11:47',
                                    'f8:1e:df:ed:3e:da',
                                    'f8:1e:df:f2:63:c8',
                                    'f8:1e:df:26:b4:55',
                                    '1c:4b:d6:80:6c:00',
                                    '1c:4b:d6:b9:19:c3',
                                    '1c:4b:d6:f2:d2:b8',
                                    '1c:4b:d6:1f:d4:05',
                                    '20:68:9d:bb:fd:17',
                                    '20:7c:8f:6b:79:0f',
                                    '20:02:af:55:ba:56',
                                    '20:c9:d0:7c:fc:3d',
                                    '20:c9:d0:80:c8:f5',
                                    '20:c9:d0:c3:10:f9',
                                    '20:c9:d0:c9:25:37',
                                    '20:c9:d0:d0:42:e9',
                                    '20:c9:d0:d1:45:05',
                                    '20:c9:d0:d1:56:0d',
                                    '20:c9:d0:d4:c8:ad',
                                    '20:c9:d0:d6:75:03',
                                    '20:c9:d0:da:82:61',
                                    '20:c9:d0:da:b2:81',
                                    '20:c9:d0:dd:c0:bd',
                                    '20:c9:d0:dd:d1:fb',
                                    '20:c9:d0:e0:83:db',
                                    '20:c9:d0:e4:2f:85',
                                    '20:c9:d0:44:8c:cb',
                                    '24:77:03:e2:30:74',
                                    '24:ab:81:06:f4:d4',
                                    '24:ec:99:23:1c:c6',
                                    '04:0c:ce:d0:a6:d2',
                                    '04:0c:ce:d3:ed:18',
                                    '04:0c:ce:d5:9f:a8',
                                    '04:0c:ce:d5:19:da',
                                    '04:0c:ce:d5:1c:4e',
                                    '04:0c:ce:dc:82:50',
                                    '04:0c:ce:dc:c3:40',
                                    '04:0c:ce:de:70:90',
                                    '04:0c:ce:e4:62:42',
                                    '04:0c:ce:20:b9:aa',
                                    '04:f7:e4:39:b1:57',
                                    '04:fe:31:99:65:bf',
                                    '04:1e:64:73:d2:b3',
                                    '04:1e:64:f8:5a:bd',
                                    '04:46:65:60:b2:7f',
                                    '04:54:53:06:bc:95',
                                    '28:94:0f:c1:1d:90',
                                    '28:cf:da:d6:81:fc',
                                    '28:cf:da:df:c4:50',
                                    '28:cf:da:e0:f1:1e',
                                    '28:cf:da:e7:68:26',
                                    '28:cf:da:e7:16:84',
                                    '28:cf:da:ec:03:d2',
                                    '28:e7:cf:08:ab:76',
                                    '28:37:37:24:94:1a',
                                    '28:37:37:25:c1:52',
                                    '28:37:37:25:dd:1e',
                                    '2c:81:58:fd:18:17',
                                    '2c:44:01:b4:87:f2',
                                    '30:39:26:e5:84:84',
                                    '34:c0:59:5f:ca:0f',
                                    '34:15:9e:8d:d4:71',
                                    '34:15:9e:91:f8:f0',
                                    '34:15:9e:94:10:71',
                                    '34:15:9e:95:e1:1a',
                                    '38:59:f9:44:5f:b2',
                                    '3c:07:54:11:e3:0f',
                                    '40:30:04:21:bc:bb',
                                    '44:6d:57:0d:03:2a',
                                    '44:6d:57:87:be:af',
                                    '44:6d:57:03:11:09',
                                    '44:2a:60:f2:f1:10',
                                    '48:5d:60:10:5a:39',
                                    '48:5d:60:b0:8c:ac',
                                    '48:5d:60:f5:96:80',
                                    '48:5d:60:5a:24:f8',
                                    '4c:0f:6e:e1:0d:bf',
                                    '4c:0f:6e:fa:2b:fd',
                                    '4c:0f:6e:fe:e9:78',
                                    '4c:bc:a5:ad:bf:6c',
                                    '4c:eb:42:98:9a:81',
                                    '4c:ed:de:65:5e:8e',
                                    '4c:ed:de:1c:60:a6',
                                    '08:ed:b9:9c:4e:2f',
                                    '08:ed:b9:f8:57:07',
                                    '08:ed:b9:34:c2:f4',
                                    '08:ed:b9:06:23:a2',
                                    '08:3e:8e:b2:c5:e1',
                                    '50:cc:f8:21:c2:58',
                                    '50:46:5d:29:77:c3',
                                    '54:04:a6:96:01:e1',
                                    '54:04:a6:07:54:9d',
                                    '58:94:6b:d2:d4:e4',
                                    '58:b0:35:66:11:6e',
                                    '58:b0:35:6c:f7:e4',
                                    '58:b0:35:75:f3:93',
                                    '58:b0:35:7e:cf:d3',
                                    '58:b0:35:80:a8:93',
                                    '58:b0:35:fc:6b:30',
                                    '58:b0:35:5c:95:64',
                                    '58:1f:aa:c8:62:d9',
                                    '58:55:ca:f6:86:6f',
                                    '58:55:ca:f8:15:4d',
                                    '5c:96:9d:76:2a:7f',
                                    '5c:96:9d:7a:9c:fb',
                                    '5c:96:9d:7c:71:c9',
                                    '5c:96:9d:7c:5a:15',
                                    '5c:96:9d:7d:1b:63',
                                    '5c:96:9d:8a:96:2f',
                                    '5c:96:9d:8b:05:db',
                                    '5c:59:48:a9:f0:37',
                                    '60:c5:47:0a:cb:34',
                                    '60:c5:47:8c:75:e0',
                                    '60:c5:47:8d:a6:7e',
                                    '60:c5:47:8d:b3:00',
                                    '60:c5:47:96:c3:26',
                                    '60:c5:47:07:6d:90',
                                    '60:d8:19:65:c4:df',
                                    '60:d8:19:08:a2:92',
                                    '60:33:4b:01:c7:d8',
                                    '60:33:4b:01:dd:f5',
                                    '60:33:4b:23:62:e2',
                                    '60:33:4b:26:8b:b7',
                                    '60:33:4b:26:bc:8f',
                                    '60:45:bd:24:de:76',
                                    '00:00:5e:00:01:02',
                                    '00:80:9f:ba:8d:d5',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '600',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.132',
                        MAC              => '78:fe:3d:37:5e:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(6577) 0:01:05.77',
                        IFINOCTETS       => '1771189919',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '447506369',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'juniper/ex2200.05.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Juniper',
            MODEL        => 'EX2200',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',

            SNMPHOSTNAME => 'jtc407-01',
            LOCATION     => 'PMF 4 n° 407',
            UPTIME       => '(690838738) 79 days, 22:59:47.38',
            IPS          => {
                IP => [
                    '128.0.0.1',
                    '128.0.0.16',
                    '128.0.0.32',
                    '192.168.100.65',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Juniper',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
                NAME         => 'jtc407-01',
                LOCATION     => 'PMF 4 n° 407',
                UPTIME       => '(690838738) 79 days, 22:59:47.38',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.100.65',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3199) 0:00:31.99',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3203) 0:00:32.03',
                        IFINOCTETS       => '3299710309',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3300277085',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3204) 0:00:32.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3201) 0:00:32.01',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3202) 0:00:32.02',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3208) 0:00:32.08',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3209) 0:00:32.09',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3211) 0:00:32.11',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:3f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3210) 0:00:32.10',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3198) 0:00:31.98',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2715463516',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3213) 0:00:32.13',
                        IFINOCTETS       => '901244274',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7247) 0:01:12.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3654820112',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1776131026',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'ge-0/0/46.0',
                        IFDESCR          => 'ge-0/0/46.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3891) 0:00:38.91',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:04',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7247) 0:01:12.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '99911270',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3838463887',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:04',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7247) 0:01:12.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '188602',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '465720827',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3345) 0:00:33.45',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3347) 0:00:33.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3356) 0:00:33.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3359) 0:00:33.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/12',
                        IFDESCR          => 'ge-0/0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3367) 0:00:33.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/12.0',
                        IFDESCR          => 'ge-0/0/12.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3371) 0:00:33.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/13',
                        IFDESCR          => 'ge-0/0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(577843267) 66 days, 21:07:12.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3030652257',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3013626698',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/13.0',
                        IFDESCR          => 'ge-0/0/13.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(577843267) 66 days, 21:07:12.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '33585640',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '465476805',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/14',
                        IFDESCR          => 'ge-0/0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:11',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(654577277) 75 days, 18:16:12.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3319962578',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1283149072',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/14.0',
                        IFDESCR          => 'ge-0/0/14.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:11',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(654577277) 75 days, 18:16:12.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '8379249',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '465486252',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/15',
                        IFDESCR          => 'ge-0/0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:12',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3405) 0:00:34.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/15.0',
                        IFDESCR          => 'ge-0/0/15.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:12',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3407) 0:00:34.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/16',
                        IFDESCR          => 'ge-0/0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:13',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3414) 0:00:34.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/16.0',
                        IFDESCR          => 'ge-0/0/16.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:13',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3418) 0:00:34.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/17',
                        IFDESCR          => 'ge-0/0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:14',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3424) 0:00:34.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/17.0',
                        IFDESCR          => 'ge-0/0/17.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:14',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3435) 0:00:34.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/18',
                        IFDESCR          => 'ge-0/0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:15',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3426) 0:00:34.26',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/18.0',
                        IFDESCR          => 'ge-0/0/18.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:15',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3446) 0:00:34.46',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/19',
                        IFDESCR          => 'ge-0/0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:16',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3442) 0:00:34.42',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/19.0',
                        IFDESCR          => 'ge-0/0/19.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:16',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3454) 0:00:34.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:05',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3248) 0:00:32.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:05',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3250) 0:00:32.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/20',
                        IFDESCR          => 'ge-0/0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:17',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3449) 0:00:34.49',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/0/20.0',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:17',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3460) 0:00:34.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/0/21',
                        IFDESCR          => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:18',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3456) 0:00:34.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/0/21.0',
                        IFDESCR          => 'ge-0/0/21.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:18',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3474) 0:00:34.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/0/22',
                        IFDESCR          => 'ge-0/0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:19',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3462) 0:00:34.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'ge-0/0/22.0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:19',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3501) 0:00:35.01',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '533',
                        IFNAME           => 'ge-0/0/23',
                        IFDESCR          => 'ge-0/0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3467) 0:00:34.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '534',
                        IFNAME           => 'ge-0/0/23.0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3519) 0:00:35.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '535',
                        IFNAME           => 'ge-0/0/24',
                        IFDESCR          => 'ge-0/0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3471) 0:00:34.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '536',
                        IFNAME           => 'ge-0/0/24.0',
                        IFDESCR          => 'ge-0/0/24.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1b',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3532) 0:00:35.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '537',
                        IFNAME           => 'ge-0/0/25',
                        IFDESCR          => 'ge-0/0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7370) 0:01:13.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '995965943',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3951591485',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '538',
                        IFNAME           => 'ge-0/0/25.0',
                        IFDESCR          => 'ge-0/0/25.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7370) 0:01:13.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5187440',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '466471737',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '539',
                        IFNAME           => 'ge-0/0/26',
                        IFDESCR          => 'ge-0/0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3487) 0:00:34.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '540',
                        IFNAME           => 'ge-0/0/26.0',
                        IFDESCR          => 'ge-0/0/26.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3589) 0:00:35.89',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '541',
                        IFNAME           => 'ge-0/0/27',
                        IFDESCR          => 'ge-0/0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3493) 0:00:34.93',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '542',
                        IFNAME           => 'ge-0/0/27.0',
                        IFDESCR          => 'ge-0/0/27.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3605) 0:00:36.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '543',
                        IFNAME           => 'ge-0/0/28',
                        IFDESCR          => 'ge-0/0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3496) 0:00:34.96',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '544',
                        IFNAME           => 'ge-0/0/28.0',
                        IFDESCR          => 'ge-0/0/28.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:1f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3630) 0:00:36.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '545',
                        IFNAME           => 'ge-0/0/29',
                        IFDESCR          => 'ge-0/0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:20',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3505) 0:00:35.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '546',
                        IFNAME           => 'ge-0/0/29.0',
                        IFDESCR          => 'ge-0/0/29.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:20',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3641) 0:00:36.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '547',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:06',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3252) 0:00:32.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '548',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:06',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3253) 0:00:32.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '549',
                        IFNAME           => 'ge-0/0/30',
                        IFDESCR          => 'ge-0/0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:21',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3508) 0:00:35.08',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '550',
                        IFNAME           => 'ge-0/0/30.0',
                        IFDESCR          => 'ge-0/0/30.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:21',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3645) 0:00:36.45',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '551',
                        IFNAME           => 'ge-0/0/31',
                        IFDESCR          => 'ge-0/0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:22',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(688688737) 79 days, 17:01:27.37',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '141635944',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3460900081',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '552',
                        IFNAME           => 'ge-0/0/31.0',
                        IFDESCR          => 'ge-0/0/31.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:22',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(688688737) 79 days, 17:01:27.37',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '500773',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '421381483',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '553',
                        IFNAME           => 'ge-0/0/32',
                        IFDESCR          => 'ge-0/0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:23',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(689602367) 79 days, 19:33:43.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '86562173',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1295216410',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '554',
                        IFNAME           => 'ge-0/0/32.0',
                        IFDESCR          => 'ge-0/0/32.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:23',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(689602367) 79 days, 19:33:43.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '694827',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '61338038',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '555',
                        IFNAME           => 'ge-0/0/33',
                        IFDESCR          => 'ge-0/0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:24',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7371) 0:01:13.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4011077581',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3301180591',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '556',
                        IFNAME           => 'ge-0/0/33.0',
                        IFDESCR          => 'ge-0/0/33.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:24',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7371) 0:01:13.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '7570937',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '449527190',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '557',
                        IFNAME           => 'ge-0/0/34',
                        IFDESCR          => 'ge-0/0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:25',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(605122587) 70 days, 0:53:45.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1188771734',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3796981610',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '558',
                        IFNAME           => 'ge-0/0/34.0',
                        IFDESCR          => 'ge-0/0/34.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:25',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(605122587) 70 days, 0:53:45.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5660368',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '464675284',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '559',
                        IFNAME           => 'ge-0/0/35',
                        IFDESCR          => 'ge-0/0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:26',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(603753039) 69 days, 21:05:30.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '717085133',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1859341136',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '560',
                        IFNAME           => 'ge-0/0/35.0',
                        IFDESCR          => 'ge-0/0/35.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:26',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(603753039) 69 days, 21:05:30.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '6150747',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '407661671',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '561',
                        IFNAME           => 'ge-0/0/36',
                        IFDESCR          => 'ge-0/0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:27',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(630152097) 72 days, 22:25:20.97',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2150647287',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3123063969',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '562',
                        IFNAME           => 'ge-0/0/36.0',
                        IFDESCR          => 'ge-0/0/36.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:27',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(630152097) 72 days, 22:25:20.97',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '210659779',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '76952215',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '563',
                        IFNAME           => 'ge-0/0/37',
                        IFDESCR          => 'ge-0/0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:28',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(672589657) 77 days, 20:18:16.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2139115923',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '713610076',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '564',
                        IFNAME           => 'ge-0/0/37.0',
                        IFDESCR          => 'ge-0/0/37.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:28',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(672589657) 77 days, 20:18:16.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2007812',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '449518210',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '565',
                        IFNAME           => 'ge-0/0/38',
                        IFDESCR          => 'ge-0/0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:29',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(671864217) 77 days, 18:17:22.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2276628107',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3562479292',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '566',
                        IFNAME           => 'ge-0/0/38.0',
                        IFDESCR          => 'ge-0/0/38.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:29',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(671864217) 77 days, 18:17:22.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3779632',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '449506711',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '567',
                        IFNAME           => 'ge-0/0/39',
                        IFDESCR          => 'ge-0/0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3579) 0:00:35.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '568',
                        IFNAME           => 'ge-0/0/39.0',
                        IFDESCR          => 'ge-0/0/39.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3785) 0:00:37.85',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '569',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:07',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3256) 0:00:32.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '570',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:07',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3258) 0:00:32.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '571',
                        IFNAME           => 'ge-0/0/40',
                        IFDESCR          => 'ge-0/0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(623010977) 72 days, 2:35:09.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3533234512',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2633122441',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '572',
                        IFNAME           => 'ge-0/0/40.0',
                        IFDESCR          => 'ge-0/0/40.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(623010977) 72 days, 2:35:09.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3134933',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '449446120',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '573',
                        IFNAME           => 'ge-0/0/41',
                        IFDESCR          => 'ge-0/0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(380811077) 44 days, 1:48:30.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3363359789',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1143757502',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '574',
                        IFNAME           => 'ge-0/0/41.0',
                        IFDESCR          => 'ge-0/0/41.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(380811077) 44 days, 1:48:30.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '6930628',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '449497792',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '575',
                        IFNAME           => 'ge-0/0/42',
                        IFDESCR          => 'ge-0/0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(626710427) 72 days, 12:51:44.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '360348982',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1936465493',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '576',
                        IFNAME           => 'ge-0/0/42.0',
                        IFDESCR          => 'ge-0/0/42.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(626710427) 72 days, 12:51:44.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '928054',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '93754257',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '577',
                        IFNAME           => 'ge-0/0/43',
                        IFDESCR          => 'ge-0/0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3616) 0:00:36.16',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '578',
                        IFNAME           => 'ge-0/0/43.0',
                        IFDESCR          => 'ge-0/0/43.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3833) 0:00:38.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '579',
                        IFNAME           => 'ge-0/0/44',
                        IFDESCR          => 'ge-0/0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(654832517) 75 days, 18:58:45.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3158408642',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4246970219',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '580',
                        IFNAME           => 'ge-0/0/44.0',
                        IFDESCR          => 'ge-0/0/44.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:2f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(654832517) 75 days, 18:58:45.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '41406521',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '449536917',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '0x001A1ECDBB02',
                                IFDESCR  => 'eth0',
                                SYSNAME  => 'PMF-sap-c407',
                                SYSDESCR => 'ArubaOS (MODEL: 125), Version 6.2.1.2 (38711)',
                                SYSMAC   => '00:1a:1e:cd:bb:02',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '581',
                        IFNAME           => 'ge-0/0/45',
                        IFDESCR          => 'ge-0/0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:30',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(561606847) 65 days, 0:01:08.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3458219972',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '244487005',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '582',
                        IFNAME           => 'ge-0/0/45.0',
                        IFDESCR          => 'ge-0/0/45.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:30',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(561606847) 65 days, 0:01:08.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '16584800',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '465451921',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '583',
                        IFNAME           => 'ge-0/0/46',
                        IFDESCR          => 'ge-0/0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3635) 0:00:36.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '584',
                        IFNAME           => 'ge-0/0/47.0',
                        IFDESCR          => 'ge-0/0/47.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3903) 0:00:39.03',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '585',
                        IFNAME           => 'ge-0/0/47',
                        IFDESCR          => 'ge-0/0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3638) 0:00:36.38',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '586',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7247) 0:01:12.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3030702800',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '171078177',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '587',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:08',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3259) 0:00:32.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '588',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:08',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3261) 0:00:32.61',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '589',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:09',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3301) 0:00:33.01',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '590',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:09',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3304) 0:00:33.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '591',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3311) 0:00:33.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '592',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3314) 0:00:33.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '593',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3328) 0:00:33.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '594',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0b',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3333) 0:00:33.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '595',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3338) 0:00:33.38',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '596',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:0c',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3340) 0:00:33.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '599',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:36:f7:01',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3224) 0:00:32.24',
                        IFINOCTETS       => '1782820774',
                        IFINERRORS       => '18',
                        IFOUTOCTETS      => '68750026',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '600',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.100.65',
                        MAC              => '78:fe:3d:36:f7:01',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7309) 0:01:13.09',
                        IFINOCTETS       => '1782820862',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '64824825',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '609',
                        IFNAME           => 'ae0',
                        IFDESCR          => 'ae0',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3215) 0:00:32.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '610',
                        IFNAME           => 'ae1',
                        IFDESCR          => 'ae1',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:04',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3216) 0:00:32.16',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '611',
                        IFNAME           => 'ae2',
                        IFDESCR          => 'ae2',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:05',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3218) 0:00:32.18',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '612',
                        IFNAME           => 'ae3',
                        IFDESCR          => 'ae3',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:06',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3219) 0:00:32.19',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '613',
                        IFNAME           => 'ae4',
                        IFDESCR          => 'ae4',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:07',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3221) 0:00:32.21',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '614',
                        IFNAME           => 'ae0.0',
                        IFDESCR          => 'ae0.0',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:36:f7:03',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3222) 0:00:32.22',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'juniper/ex2200.06.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Juniper',
            MODEL        => 'EX2200',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',

            SNMPHOSTNAME => 'jtc407-01',
            LOCATION     => 'PMF 4 n° 407',
            UPTIME       => '(690835636) 79 days, 22:59:16.36',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Juniper',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-48t-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
                NAME         => 'jtc407-01',
                LOCATION     => 'PMF 4 n° 407',
                UPTIME       => '(690835636) 79 days, 22:59:16.36',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFMTU            => '2147483647',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFMTU            => '1576',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFMTU            => '1562',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'ge-0/0/46.0',
                        IFDESCR          => 'ge-0/0/46.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/12',
                        IFDESCR          => 'ge-0/0/12',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/12.0',
                        IFDESCR          => 'ge-0/0/12.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/13',
                        IFDESCR          => 'ge-0/0/13',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/13.0',
                        IFDESCR          => 'ge-0/0/13.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/14',
                        IFDESCR          => 'ge-0/0/14',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/14.0',
                        IFDESCR          => 'ge-0/0/14.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/15',
                        IFDESCR          => 'ge-0/0/15',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/15.0',
                        IFDESCR          => 'ge-0/0/15.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/16',
                        IFDESCR          => 'ge-0/0/16',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/16.0',
                        IFDESCR          => 'ge-0/0/16.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/17',
                        IFDESCR          => 'ge-0/0/17',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/17.0',
                        IFDESCR          => 'ge-0/0/17.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/18',
                        IFDESCR          => 'ge-0/0/18',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/18.0',
                        IFDESCR          => 'ge-0/0/18.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/19',
                        IFDESCR          => 'ge-0/0/19',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/19.0',
                        IFDESCR          => 'ge-0/0/19.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/20',
                        IFDESCR          => 'ge-0/0/20',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/0/20.0',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/0/21',
                        IFDESCR          => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/0/21.0',
                        IFDESCR          => 'ge-0/0/21.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/0/22',
                        IFDESCR          => 'ge-0/0/22',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'ge-0/0/22.0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '533',
                        IFNAME           => 'ge-0/0/23',
                        IFDESCR          => 'ge-0/0/23',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '534',
                        IFNAME           => 'ge-0/0/23.0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '535',
                        IFNAME           => 'ge-0/0/24',
                        IFDESCR          => 'ge-0/0/24',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '536',
                        IFNAME           => 'ge-0/0/24.0',
                        IFDESCR          => 'ge-0/0/24.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '537',
                        IFNAME           => 'ge-0/0/25',
                        IFDESCR          => 'ge-0/0/25',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '538',
                        IFNAME           => 'ge-0/0/25.0',
                        IFDESCR          => 'ge-0/0/25.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '539',
                        IFNAME           => 'ge-0/0/26',
                        IFDESCR          => 'ge-0/0/26',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '540',
                        IFNAME           => 'ge-0/0/26.0',
                        IFDESCR          => 'ge-0/0/26.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '541',
                        IFNAME           => 'ge-0/0/27',
                        IFDESCR          => 'ge-0/0/27',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '542',
                        IFNAME           => 'ge-0/0/27.0',
                        IFDESCR          => 'ge-0/0/27.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '543',
                        IFNAME           => 'ge-0/0/28',
                        IFDESCR          => 'ge-0/0/28',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '544',
                        IFNAME           => 'ge-0/0/28.0',
                        IFDESCR          => 'ge-0/0/28.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '545',
                        IFNAME           => 'ge-0/0/29',
                        IFDESCR          => 'ge-0/0/29',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '546',
                        IFNAME           => 'ge-0/0/29.0',
                        IFDESCR          => 'ge-0/0/29.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '547',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '548',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '549',
                        IFNAME           => 'ge-0/0/30',
                        IFDESCR          => 'ge-0/0/30',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '550',
                        IFNAME           => 'ge-0/0/30.0',
                        IFDESCR          => 'ge-0/0/30.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '551',
                        IFNAME           => 'ge-0/0/31',
                        IFDESCR          => 'ge-0/0/31',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '552',
                        IFNAME           => 'ge-0/0/31.0',
                        IFDESCR          => 'ge-0/0/31.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '553',
                        IFNAME           => 'ge-0/0/32',
                        IFDESCR          => 'ge-0/0/32',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '554',
                        IFNAME           => 'ge-0/0/32.0',
                        IFDESCR          => 'ge-0/0/32.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '555',
                        IFNAME           => 'ge-0/0/33',
                        IFDESCR          => 'ge-0/0/33',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '556',
                        IFNAME           => 'ge-0/0/33.0',
                        IFDESCR          => 'ge-0/0/33.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '557',
                        IFNAME           => 'ge-0/0/34',
                        IFDESCR          => 'ge-0/0/34',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '558',
                        IFNAME           => 'ge-0/0/34.0',
                        IFDESCR          => 'ge-0/0/34.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '559',
                        IFNAME           => 'ge-0/0/35',
                        IFDESCR          => 'ge-0/0/35',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '560',
                        IFNAME           => 'ge-0/0/35.0',
                        IFDESCR          => 'ge-0/0/35.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '561',
                        IFNAME           => 'ge-0/0/36',
                        IFDESCR          => 'ge-0/0/36',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '562',
                        IFNAME           => 'ge-0/0/36.0',
                        IFDESCR          => 'ge-0/0/36.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '563',
                        IFNAME           => 'ge-0/0/37',
                        IFDESCR          => 'ge-0/0/37',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '564',
                        IFNAME           => 'ge-0/0/37.0',
                        IFDESCR          => 'ge-0/0/37.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '565',
                        IFNAME           => 'ge-0/0/38',
                        IFDESCR          => 'ge-0/0/38',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '566',
                        IFNAME           => 'ge-0/0/38.0',
                        IFDESCR          => 'ge-0/0/38.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '567',
                        IFNAME           => 'ge-0/0/39',
                        IFDESCR          => 'ge-0/0/39',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '568',
                        IFNAME           => 'ge-0/0/39.0',
                        IFDESCR          => 'ge-0/0/39.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '569',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '570',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '571',
                        IFNAME           => 'ge-0/0/40',
                        IFDESCR          => 'ge-0/0/40',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '572',
                        IFNAME           => 'ge-0/0/40.0',
                        IFDESCR          => 'ge-0/0/40.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '573',
                        IFNAME           => 'ge-0/0/41',
                        IFDESCR          => 'ge-0/0/41',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '574',
                        IFNAME           => 'ge-0/0/41.0',
                        IFDESCR          => 'ge-0/0/41.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '575',
                        IFNAME           => 'ge-0/0/42',
                        IFDESCR          => 'ge-0/0/42',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '576',
                        IFNAME           => 'ge-0/0/42.0',
                        IFDESCR          => 'ge-0/0/42.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '577',
                        IFNAME           => 'ge-0/0/43',
                        IFDESCR          => 'ge-0/0/43',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '578',
                        IFNAME           => 'ge-0/0/43.0',
                        IFDESCR          => 'ge-0/0/43.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '579',
                        IFNAME           => 'ge-0/0/44',
                        IFDESCR          => 'ge-0/0/44',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '580',
                        IFNAME           => 'ge-0/0/44.0',
                        IFDESCR          => 'ge-0/0/44.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '0x001A1ECDBB02',
                                IFDESCR  => 'eth0',
                                SYSNAME  => 'PMF-sap-c407',
                                SYSDESCR => 'ArubaOS (MODEL: 125), Version 6.2.1.2 (38711)',
                                SYSMAC   => '00:1a:1e:cd:bb:02',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '581',
                        IFNAME           => 'ge-0/0/45',
                        IFDESCR          => 'ge-0/0/45',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '582',
                        IFNAME           => 'ge-0/0/45.0',
                        IFDESCR          => 'ge-0/0/45.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '583',
                        IFNAME           => 'ge-0/0/46',
                        IFDESCR          => 'ge-0/0/46',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '584',
                        IFNAME           => 'ge-0/0/47.0',
                        IFDESCR          => 'ge-0/0/47.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '585',
                        IFNAME           => 'ge-0/0/47',
                        IFDESCR          => 'ge-0/0/47',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '586',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '587',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '588',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '589',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '590',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '591',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '592',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '593',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '594',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '595',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '596',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '599',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFMTU            => '1518',
                    },
                    {
                        IFNUMBER         => '600',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFMTU            => '1500',
                    },
                    {
                        IFNUMBER         => '609',
                        IFNAME           => 'ae0',
                        IFDESCR          => 'ae0',
                        IFTYPE           => '161',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '610',
                        IFNAME           => 'ae1',
                        IFDESCR          => 'ae1',
                        IFTYPE           => '161',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '611',
                        IFNAME           => 'ae2',
                        IFDESCR          => 'ae2',
                        IFTYPE           => '161',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '612',
                        IFNAME           => 'ae3',
                        IFDESCR          => 'ae3',
                        IFTYPE           => '161',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '613',
                        IFNAME           => 'ae4',
                        IFDESCR          => 'ae4',
                        IFTYPE           => '161',
                        IFMTU            => '1514',
                    },
                    {
                        IFNUMBER         => '614',
                        IFNAME           => 'ae0.0',
                        IFDESCR          => 'ae0.0',
                        IFTYPE           => '161',
                        IFMTU            => '1514',
                    },
                ]
            },
        },
    ],
    'juniper/ex2200.07.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Juniper',
            MODEL        => 'EX2200',
            DESCRIPTION  => 'Juniper Networks, Inc. ex2200-48p-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',

            SNMPHOSTNAME => 'jtc13-03',
            LOCATION     => 'PMF 13eme',
            SERIAL       => 'CT0211454290',
            UPTIME       => '(499476755) 57 days, 19:26:07.55',
            MEMORY       => '0',
            MAC          => '78:fe:3d:35:14:41',
            IPS          => {
                IP => [
                    '128.0.0.1',
                    '128.0.0.16',
                    '128.0.0.32',
                    '192.168.100.140',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Juniper',
                MODEL        => 'EX2200',
                COMMENTS     => 'Juniper Networks, Inc. ex2200-48p-4g internet router, kernel JUNOS 11.4R5.5 #0: 2012-08-25 05:21:13 UTC     builder@evenath.juniper.net:/volume/build/junos/11.4/release/11.4R5.5/obj-arm/bsd/kernels/JUNIPER-EX-2200/kernel Build date: 2012-08-25 04:48:47 U',
                NAME         => 'jtc13-03',
                LOCATION     => 'PMF 13eme',
                SERIAL       => 'CT0211454290',
                UPTIME       => '(499476755) 57 days, 19:26:07.55',
                MEMORY       => '0',
                MAC          => '78:fe:3d:35:14:41',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.100.140',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2310) 0:00:23.10',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2330) 0:00:23.30',
                        IFINOCTETS       => '2891947405',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2892532185',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2337) 0:00:23.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2317) 0:00:23.17',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2324) 0:00:23.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2343) 0:00:23.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2346) 0:00:23.46',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2391) 0:00:23.91',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:7f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2357) 0:00:23.57',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => 'me0.0',
                        IFDESCR          => 'me0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '78:fe:3d:35:14:7f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2373) 0:00:23.73',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2302) 0:00:23.02',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2324005029',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2394) 0:00:23.94',
                        IFINOCTETS       => '112538765',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:43',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(83323040) 9 days, 15:27:10.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1744384224',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '338781511',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:43',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(83323040) 9 days, 15:27:10.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2557466',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '56896598',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '20:3a:07:ee:e1:60',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:44',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(490874463) 56 days, 19:32:24.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '81139766',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '650360168',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:44',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(490874463) 56 days, 19:32:24.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '212731',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '287926476',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472291924) 54 days, 15:55:19.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '35529',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '39114',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472291924) 54 days, 15:55:19.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '6838',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '22750',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(492159839) 56 days, 23:06:38.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '674968419',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1597370852',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(492159839) 56 days, 23:06:38.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2239067',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '12578934',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/12',
                        IFDESCR          => 'ge-0/0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2728) 0:00:27.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/12.0',
                        IFDESCR          => 'ge-0/0/12.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2733) 0:00:27.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/13',
                        IFDESCR          => 'ge-0/0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:50',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474504079) 54 days, 22:04:00.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '305790865',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '335531496',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/13.0',
                        IFDESCR          => 'ge-0/0/13.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:50',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474504079) 54 days, 22:04:00.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '814511',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6868262',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/14',
                        IFDESCR          => 'ge-0/0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:51',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472607150) 54 days, 16:47:51.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '706240582',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1981564306',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/14.0',
                        IFDESCR          => 'ge-0/0/14.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:51',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472607150) 54 days, 16:47:51.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2684663',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '305745401',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '88:ae:1d:ce:12:4e',
                                    'b8:8d:12:53:6a:7f',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/15',
                        IFDESCR          => 'ge-0/0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:52',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(58579375) 6 days, 18:43:13.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '7474192',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '28526957',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/15.0',
                        IFDESCR          => 'ge-0/0/15.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:52',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(58579375) 6 days, 18:43:13.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '58650',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '296261',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/16',
                        IFDESCR          => 'ge-0/0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:53',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(58586022) 6 days, 18:44:20.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2444780',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '50242056',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/16.0',
                        IFDESCR          => 'ge-0/0/16.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:53',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(58586022) 6 days, 18:44:20.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '9576',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '38422452',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/17',
                        IFDESCR          => 'ge-0/0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:54',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2776) 0:00:27.76',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/17.0',
                        IFDESCR          => 'ge-0/0/17.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:54',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2780) 0:00:27.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/18',
                        IFDESCR          => 'ge-0/0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:55',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(491424998) 56 days, 21:04:09.98',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '738137413',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '34484781',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/18.0',
                        IFDESCR          => 'ge-0/0/18.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:55',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(491424998) 56 days, 21:04:09.98',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '227863',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '17397782',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/19',
                        IFDESCR          => 'ge-0/0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:56',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474866627) 54 days, 23:04:26.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1235150564',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '854199719',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/19.0',
                        IFDESCR          => 'ge-0/0/19.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:56',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474866627) 54 days, 23:04:26.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1689222',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '40410472',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:45',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5910) 0:00:59.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1286810852',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '625722619',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:45',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5910) 0:00:59.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2927955',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327508850',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/20',
                        IFDESCR          => 'ge-0/0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:57',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2803) 0:00:28.03',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/0/20.0',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:57',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2814) 0:00:28.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/0/21',
                        IFDESCR          => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:58',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2810) 0:00:28.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/0/21.0',
                        IFDESCR          => 'ge-0/0/21.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:58',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2819) 0:00:28.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/0/22',
                        IFDESCR          => 'ge-0/0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:59',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482826811) 55 days, 21:11:08.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '931159501',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2326041633',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'ge-0/0/22.0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:59',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482826811) 55 days, 21:11:08.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1428463',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6920069',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '533',
                        IFNAME           => 'ge-0/0/23',
                        IFDESCR          => 'ge-0/0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2825) 0:00:28.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '534',
                        IFNAME           => 'ge-0/0/23.0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2849) 0:00:28.49',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '535',
                        IFNAME           => 'ge-0/0/24',
                        IFDESCR          => 'ge-0/0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(410512310) 47 days, 12:18:43.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3299641',
                        IFINERRORS       => '21',
                        IFOUTOCTETS      => '558181286',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '536',
                        IFNAME           => 'ge-0/0/24.0',
                        IFDESCR          => 'ge-0/0/24.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(410512310) 47 days, 12:18:43.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2047',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327656344',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '537',
                        IFNAME           => 'ge-0/0/25',
                        IFDESCR          => 'ge-0/0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482930025) 55 days, 21:28:20.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '282999027',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3232568305',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '538',
                        IFNAME           => 'ge-0/0/25.0',
                        IFDESCR          => 'ge-0/0/25.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5c',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482930025) 55 days, 21:28:20.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '421384',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '19049883',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '539',
                        IFNAME           => 'ge-0/0/26',
                        IFDESCR          => 'ge-0/0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(480571640) 55 days, 14:55:16.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '433766676',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1449823136',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '540',
                        IFNAME           => 'ge-0/0/26.0',
                        IFDESCR          => 'ge-0/0/26.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(480571640) 55 days, 14:55:16.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '553601',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '12043513',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '541',
                        IFNAME           => 'ge-0/0/27',
                        IFDESCR          => 'ge-0/0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(498384383) 57 days, 16:24:03.83',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '709592546',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2039323682',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '542',
                        IFNAME           => 'ge-0/0/27.0',
                        IFDESCR          => 'ge-0/0/27.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(498384383) 57 days, 16:24:03.83',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '536134',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '284310206',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '543',
                        IFNAME           => 'ge-0/0/28',
                        IFDESCR          => 'ge-0/0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2853) 0:00:28.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '544',
                        IFNAME           => 'ge-0/0/28.0',
                        IFDESCR          => 'ge-0/0/28.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:5f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2926) 0:00:29.26',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '545',
                        IFNAME           => 'ge-0/0/29',
                        IFDESCR          => 'ge-0/0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:60',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481571980) 55 days, 17:41:59.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5303509',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '476264161',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '546',
                        IFNAME           => 'ge-0/0/29.0',
                        IFDESCR          => 'ge-0/0/29.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:60',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481571980) 55 days, 17:41:59.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5400',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327586683',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '547',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:46',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2560) 0:00:25.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '548',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:46',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2574) 0:00:25.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '549',
                        IFNAME           => 'ge-0/0/30',
                        IFDESCR          => 'ge-0/0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(498168960) 57 days, 15:48:09.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3168553434',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1575972079',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '550',
                        IFNAME           => 'ge-0/0/30.0',
                        IFDESCR          => 'ge-0/0/30.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:61',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(498168960) 57 days, 15:48:09.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '357238',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '330356904',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '54:53:ed:7f:cc:fb',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '551',
                        IFNAME           => 'ge-0/0/31',
                        IFDESCR          => 'ge-0/0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:62',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5820) 0:00:58.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2168289414',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2998024565',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '552',
                        IFNAME           => 'ge-0/0/31.0',
                        IFDESCR          => 'ge-0/0/31.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:62',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5820) 0:00:58.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '276480',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '328409671',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '54:53:ed:7f:cc:13',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '553',
                        IFNAME           => 'ge-0/0/32',
                        IFDESCR          => 'ge-0/0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:63',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(498885870) 57 days, 17:47:38.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '227158483',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1931125831',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '554',
                        IFNAME           => 'ge-0/0/32.0',
                        IFDESCR          => 'ge-0/0/32.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:63',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(498885870) 57 days, 17:47:38.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '827296',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '13180849',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '84:8f:69:d0:ab:90',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '555',
                        IFNAME           => 'ge-0/0/33',
                        IFDESCR          => 'ge-0/0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:64',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(496811760) 57 days, 12:01:57.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1446896777',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '135042718',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '556',
                        IFNAME           => 'ge-0/0/33.0',
                        IFDESCR          => 'ge-0/0/33.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:64',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(496811760) 57 days, 12:01:57.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5714913',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '32163624',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '3c:07:54:38:e0:33',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '557',
                        IFNAME           => 'ge-0/0/34',
                        IFDESCR          => 'ge-0/0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:65',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482370940) 55 days, 19:55:09.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '26151636',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1568180907',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '558',
                        IFNAME           => 'ge-0/0/34.0',
                        IFDESCR          => 'ge-0/0/34.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:65',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482370940) 55 days, 19:55:09.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '177506',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1151895',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '559',
                        IFNAME           => 'ge-0/0/35',
                        IFDESCR          => 'ge-0/0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:66',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(497161860) 57 days, 13:00:18.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '197802341',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1067397285',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '560',
                        IFNAME           => 'ge-0/0/35.0',
                        IFDESCR          => 'ge-0/0/35.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:66',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(497161860) 57 days, 13:00:18.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '55838',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '260824305',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '561',
                        IFNAME           => 'ge-0/0/36',
                        IFDESCR          => 'ge-0/0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:67',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472444770) 54 days, 16:20:47.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '58569',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '322841413',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '562',
                        IFNAME           => 'ge-0/0/36.0',
                        IFDESCR          => 'ge-0/0/36.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:67',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472444770) 54 days, 16:20:47.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4369',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '226777070',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '563',
                        IFNAME           => 'ge-0/0/37',
                        IFDESCR          => 'ge-0/0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:68',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(483202680) 55 days, 22:13:46.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '664',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '57194403',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '564',
                        IFNAME           => 'ge-0/0/37.0',
                        IFDESCR          => 'ge-0/0/37.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:68',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(483202680) 55 days, 22:13:46.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42744530',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '565',
                        IFNAME           => 'ge-0/0/38',
                        IFDESCR          => 'ge-0/0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:69',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481989430) 55 days, 18:51:34.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '37857253',
                        IFINERRORS       => '16',
                        IFOUTOCTETS      => '1175000865',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '566',
                        IFNAME           => 'ge-0/0/38.0',
                        IFDESCR          => 'ge-0/0/38.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:69',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481989430) 55 days, 18:51:34.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '107050',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327690167',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '567',
                        IFNAME           => 'ge-0/0/39',
                        IFDESCR          => 'ge-0/0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(83675374) 9 days, 16:25:53.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '52422417',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '568',
                        IFNAME           => 'ge-0/0/39.0',
                        IFDESCR          => 'ge-0/0/39.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(83675374) 9 days, 16:25:53.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '54789340',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '569',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:47',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(185623970) 21 days, 11:37:19.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '429906244',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '570',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:47',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(185623970) 21 days, 11:37:19.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327367176',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '571',
                        IFNAME           => 'ge-0/0/40',
                        IFDESCR          => 'ge-0/0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(488988670) 56 days, 14:18:06.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '56742623',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '675050738',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '572',
                        IFNAME           => 'ge-0/0/40.0',
                        IFDESCR          => 'ge-0/0/40.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(488988670) 56 days, 14:18:06.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '59814',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '15085956',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '84:2b:2b:ad:58:65',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '573',
                        IFNAME           => 'ge-0/0/41',
                        IFDESCR          => 'ge-0/0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5873) 0:00:58.73',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2126678145',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2508127997',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '574',
                        IFNAME           => 'ge-0/0/41.0',
                        IFDESCR          => 'ge-0/0/41.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5873) 0:00:58.73',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '343650',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '329796027',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '54:53:ed:7f:cc:ff',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '575',
                        IFNAME           => 'ge-0/0/42',
                        IFDESCR          => 'ge-0/0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(496841100) 57 days, 12:06:51.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '136854405',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2940766281',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '576',
                        IFNAME           => 'ge-0/0/42.0',
                        IFDESCR          => 'ge-0/0/42.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(496841100) 57 days, 12:06:51.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '438278',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '327882746',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:6f:65:0e:51:dd',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '577',
                        IFNAME           => 'ge-0/0/43',
                        IFDESCR          => 'ge-0/0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2937) 0:00:29.37',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '578',
                        IFNAME           => 'ge-0/0/43.0',
                        IFDESCR          => 'ge-0/0/43.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3054) 0:00:30.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '579',
                        IFNAME           => 'ge-0/0/44',
                        IFDESCR          => 'ge-0/0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(249013790) 28 days, 19:42:17.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '424387114',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '651547347',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '580',
                        IFNAME           => 'ge-0/0/44.0',
                        IFDESCR          => 'ge-0/0/44.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:6f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(249013790) 28 days, 19:42:17.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '318728',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '328402257',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '54:53:ed:7f:cc:fd',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '581',
                        IFNAME           => 'ge-0/0/45',
                        IFDESCR          => 'ge-0/0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:70',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(430521590) 49 days, 19:53:35.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '140623101',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '383297325',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '582',
                        IFNAME           => 'ge-0/0/45.0',
                        IFDESCR          => 'ge-0/0/45.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:70',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(430521590) 49 days, 19:53:35.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '379324',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '328414005',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '54:53:ed:7f:cc:fe',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '583',
                        IFNAME           => 'ge-0/0/46',
                        IFDESCR          => 'ge-0/0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:71',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481266820) 55 days, 16:51:08.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '88355',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '56337',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '584',
                        IFNAME           => 'ge-0/0/46.0',
                        IFDESCR          => 'ge-0/0/46.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:71',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481266820) 55 days, 16:51:08.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '21424',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '29827',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '585',
                        IFNAME           => 'ge-0/0/47',
                        IFDESCR          => 'ge-0/0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:72',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482462235) 55 days, 20:10:22.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '522060',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '338107',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '586',
                        IFNAME           => 'ge-0/0/47.0',
                        IFDESCR          => 'ge-0/0/47.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:72',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(482462235) 55 days, 20:10:22.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '90347',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '142213',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '587',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:48',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2623) 0:00:26.23',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '588',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:48',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2629) 0:00:26.29',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '589',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:49',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481761753) 55 days, 18:13:37.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '486790886',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '362600196',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '590',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:49',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(481761753) 55 days, 18:13:37.53',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '144582',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '208995379',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '591',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(489621221) 56 days, 16:03:32.21',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '719813169',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1043360413',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '592',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(489621221) 56 days, 16:03:32.21',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '488108',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '14646662',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '593',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2663) 0:00:26.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '594',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4b',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2671) 0:00:26.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '595',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(488302009) 56 days, 12:23:40.09',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3268629629',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1002264684',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '596',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:4c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(488302009) 56 days, 12:23:40.09',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3844613',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '338671560',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '2c:36:f8:4b:66:00',
                                    '00:19:d1:17:ae:6a',
                                    '44:37:e6:bb:a3:bf',
                                    '44:37:e6:bb:a3:ca',
                                    '44:37:e6:bb:a3:d0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '599',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '78:fe:3d:35:14:41',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2443) 0:00:24.43',
                        IFINOCTETS       => '1417841504',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '60361330',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '600',
                        IFNAME           => 'ge-0/1/0',
                        IFDESCR          => 'ge-0/1/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:73',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5680) 0:00:56.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3462021619',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '763621010',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '601',
                        IFNAME           => 'ge-0/1/1',
                        IFDESCR          => 'ge-0/1/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:74',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5981) 0:00:59.81',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1756608694',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '188016786',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '604',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '78:fe:3d:35:14:41',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2451) 0:00:24.51',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '605',
                        IFNAME           => 'ge-0/1/0.0',
                        IFDESCR          => 'ge-0/1/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:73',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5680) 0:00:56.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2462905321',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '117830992',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '651',
                                IFDESCR  => 'ge-1/0/6.0',
                                SYSNAME  => 'jte4-00',
                                SYSDESCR => 'Juniper Networks, Inc. ex4500-40f , version 11.4R2.14 Build date: 2012-03-17 17:46:53 UTC ',
                                SYSMAC   => '78:fe:3d:df:c1:80',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '606',
                        IFNAME           => 'ge-0/1/1.0',
                        IFDESCR          => 'ge-0/1/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:74',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5981) 0:00:59.81',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '152003984',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '335449643',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '602',
                                IFDESCR  => 'ge-0/1/0.0',
                                SYSNAME  => 'jtc13-04',
                                SYSDESCR => 'Juniper Networks, Inc. ex2200-48p-4g , version 11.4R5.7 Build date: 2013-01-05 12:28:58 UTC ',
                                SYSMAC   => 'b0:a8:6e:9a:55:c0',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '609',
                        IFNAME           => 'vlan.1',
                        IFDESCR          => 'vlan.1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.100.140',
                        MAC              => '78:fe:3d:35:14:41',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5696) 0:00:56.96',
                        IFINOCTETS       => '1417842056',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '55958584',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '610',
                        IFNAME           => 'ae0',
                        IFDESCR          => 'ae0',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:43',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2417) 0:00:24.17',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '611',
                        IFNAME           => 'ae1',
                        IFDESCR          => 'ae1',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:44',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2421) 0:00:24.21',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '612',
                        IFNAME           => 'ae2',
                        IFDESCR          => 'ae2',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:45',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2425) 0:00:24.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '613',
                        IFNAME           => 'ae3',
                        IFDESCR          => 'ae3',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:46',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2430) 0:00:24.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '614',
                        IFNAME           => 'ae4',
                        IFDESCR          => 'ae4',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '78:fe:3d:35:14:47',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2438) 0:00:24.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'juniper/ex3200.01.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Juniper',
            MODEL        => 'EX3200-24t',
            DESCRIPTION  => 'Juniper Networks, Inc. ex3200-48p internet router, kernel JUNOS 11.4R5.7 #0: 2013-01-05 14:23:01 UTC     builder@queth.juniper.net:/volume/build/junos/11.4/release/11.4R5.7/obj-powerpc/bsd/kernels/JUNIPER-EX/kernel Build date: 2013-01-05 14:01:19 UTC Cop',

            SNMPHOSTNAME => 'jmsea3-10',
            LOCATION     => 'MSE Bat.A 3eme',
            SERIAL       => 'BL0211085719',
            UPTIME       => '(502367524) 58 days, 3:27:55.24',
            MEMORY       => '0',
            MAC          => '5c:5e:ab:6a:3b:81',
            IPS          => {
                IP => [
                    '128.0.0.1',
                    '128.0.0.16',
                    '128.0.0.32',
                    '172.21.10.250',
                    '172.21.10.251',
                    '172.21.12.251',
                    '192.168.100.55',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Juniper',
                MODEL        => 'EX3200-24t',
                COMMENTS     => 'Juniper Networks, Inc. ex3200-48p internet router, kernel JUNOS 11.4R5.7 #0: 2013-01-05 14:23:01 UTC     builder@queth.juniper.net:/volume/build/junos/11.4/release/11.4R5.7/obj-powerpc/bsd/kernels/JUNIPER-EX/kernel Build date: 2013-01-05 14:01:19 UTC Cop',
                NAME         => 'jmsea3-10',
                LOCATION     => 'MSE Bat.A 3eme',
                SERIAL       => 'BL0211085719',
                UPTIME       => '(502367524) 58 days, 3:27:55.24',
                MEMORY       => '0',
                MAC          => '5c:5e:ab:6a:3b:81',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.16',
                        '128.0.0.32',
                        '172.21.10.250',
                        '172.21.10.251',
                        '172.21.12.251',
                        '192.168.100.55',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(727) 0:00:07.27',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(734) 0:00:07.34',
                        IFINOCTETS       => '1670941135',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1671236103',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(751) 0:00:07.51',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(729) 0:00:07.29',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(733) 0:00:07.33',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(697) 0:00:06.97',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(703) 0:00:07.03',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(744) 0:00:07.44',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:ff',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(712) 0:00:07.12',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => 'me0.0',
                        IFDESCR          => 'me0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '5c:5e:ab:6a:3b:ff',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(719) 0:00:07.19',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(696) 0:00:06.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '184063134',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(721) 0:00:07.21',
                        IFINOCTETS       => '1790026646',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:83',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(492827293) 57 days, 0:57:52.93',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '246519',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '10138622',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:83',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(492827293) 57 days, 0:57:52.93',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '10320',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '282201',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:84',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(477688824) 55 days, 6:54:48.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '45971733',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '203486701',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:84',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(477688824) 55 days, 6:54:48.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '33128',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2126195',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:8d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(501368552) 58 days, 0:41:25.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '270172930',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1844438574',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:8d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(501368552) 58 days, 0:41:25.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '800120',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '13952517',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:8e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(449694202) 52 days, 1:09:02.02',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2307654152',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1421090198',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:8e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(449694202) 52 days, 1:09:02.02',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1170082',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '37154679',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/12',
                        IFDESCR          => 'ge-0/0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:8f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(501585675) 58 days, 1:17:36.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '151307165',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '500897188',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/12.0',
                        IFDESCR          => 'ge-0/0/12.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:8f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(501585675) 58 days, 1:17:36.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '246231',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '306919010',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:6f:c8:b0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/13',
                        IFDESCR          => 'ge-0/0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:90',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(972) 0:00:09.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/13.0',
                        IFDESCR          => 'ge-0/0/13.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:90',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(980) 0:00:09.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/14',
                        IFDESCR          => 'ge-0/0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:91',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(985) 0:00:09.85',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/14.0',
                        IFDESCR          => 'ge-0/0/14.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:91',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(991) 0:00:09.91',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/15',
                        IFDESCR          => 'ge-0/0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:92',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(998) 0:00:09.98',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/15.0',
                        IFDESCR          => 'ge-0/0/15.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:92',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1002) 0:00:10.02',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/16',
                        IFDESCR          => 'ge-0/0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:93',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(243406802) 28 days, 4:07:48.02',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '273492030',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '907272775',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/16.0',
                        IFDESCR          => 'ge-0/0/16.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:93',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(243406802) 28 days, 4:07:48.02',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1303739',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '11482948',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/17',
                        IFDESCR          => 'ge-0/0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:94',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(501393666) 58 days, 0:45:36.66',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '26470611',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '161931299',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/17.0',
                        IFDESCR          => 'ge-0/0/17.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:94',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(501393666) 58 days, 0:45:36.66',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '147245',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1976217',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/18',
                        IFDESCR          => 'ge-0/0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:95',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(502094365) 58 days, 2:42:23.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2934604904',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '712190856',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/18.0',
                        IFDESCR          => 'ge-0/0/18.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:95',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(502094365) 58 days, 2:42:23.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '663672',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '325217408',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0f:fe:f7:46:37',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/19',
                        IFDESCR          => 'ge-0/0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(501262435) 58 days, 0:23:44.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3942071796',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2239896034',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/19.0',
                        IFDESCR          => 'ge-0/0/19.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:96',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(501262435) 58 days, 0:23:44.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '975321',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '329159030',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:85:64:b3:5d:f2',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:85',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(847) 0:00:08.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:85',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(850) 0:00:08.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/20',
                        IFDESCR          => 'ge-0/0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:97',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1985) 0:00:19.85',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/0/21',
                        IFDESCR          => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:98',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(489642565) 56 days, 16:07:05.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '920709452',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '654099821',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/0/22',
                        IFDESCR          => 'ge-0/0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:99',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(485155235) 56 days, 3:39:12.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '173454217',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2084960452',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/0/23',
                        IFDESCR          => 'ge-0/0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:9a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(502360558) 58 days, 3:26:45.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1839646193',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '873849043',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/0/24',
                        IFDESCR          => 'ge-0/0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:9b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(502132988) 58 days, 2:48:49.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '197941728',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '664274824',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'ge-0/0/25',
                        IFDESCR          => 'ge-0/0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:9c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(476374946) 55 days, 3:15:49.46',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '39438945',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '874573435',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '533',
                        IFNAME           => 'ge-0/0/26',
                        IFDESCR          => 'ge-0/0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:9d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(88742086) 10 days, 6:30:20.86',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '19433754',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '102855597',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '534',
                        IFNAME           => 'ge-0/0/27',
                        IFDESCR          => 'ge-0/0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:9e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(293675818) 33 days, 23:45:58.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5344',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '20131',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '535',
                        IFNAME           => 'ge-0/0/28',
                        IFDESCR          => 'ge-0/0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:9f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2002) 0:00:20.02',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '536',
                        IFNAME           => 'ge-0/0/29',
                        IFDESCR          => 'ge-0/0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(434401888) 50 days, 6:40:18.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '45038439',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '506215047',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '537',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:86',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(852) 0:00:08.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '538',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:86',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(854) 0:00:08.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '539',
                        IFNAME           => 'ge-0/0/30',
                        IFDESCR          => 'ge-0/0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(486281260) 56 days, 6:46:52.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '39832006',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1266427988',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '540',
                        IFNAME           => 'ge-0/0/31',
                        IFDESCR          => 'ge-0/0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(502211469) 58 days, 3:01:54.69',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '705976519',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2903037237',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '541',
                        IFNAME           => 'ge-0/0/32',
                        IFDESCR          => 'ge-0/0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303327646) 35 days, 2:34:36.46',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '33953382',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '66708891',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '542',
                        IFNAME           => 'ge-0/0/33',
                        IFDESCR          => 'ge-0/0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2015) 0:00:20.15',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '543',
                        IFNAME           => 'ge-0/0/34',
                        IFDESCR          => 'ge-0/0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500473278) 57 days, 22:12:12.78',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '618719067',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '158394497',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '544',
                        IFNAME           => 'ge-0/0/35',
                        IFDESCR          => 'ge-0/0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2021) 0:00:20.21',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '545',
                        IFNAME           => 'ge-0/0/36',
                        IFDESCR          => 'ge-0/0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2023) 0:00:20.23',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '546',
                        IFNAME           => 'ge-0/0/37',
                        IFDESCR          => 'ge-0/0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(502359755) 58 days, 3:26:37.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1960930767',
                        IFINERRORS       => '90',
                        IFOUTOCTETS      => '2041708704',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '547',
                        IFNAME           => 'ge-0/0/38',
                        IFDESCR          => 'ge-0/0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(501869385) 58 days, 2:04:53.85',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1529884146',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2194553032',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '548',
                        IFNAME           => 'ge-0/0/39',
                        IFDESCR          => 'ge-0/0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:aa',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(501850865) 58 days, 2:01:48.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '890508579',
                        IFINERRORS       => '2320',
                        IFOUTOCTETS      => '3540729963',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '549',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:87',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500131365) 57 days, 21:15:13.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3924273711',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '336951765',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '550',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:87',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500131365) 57 days, 21:15:13.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1846346',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126729274',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1b:63:a1:b7:3f',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '551',
                        IFNAME           => 'ge-0/0/40',
                        IFDESCR          => 'ge-0/0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:ab',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(450298295) 52 days, 2:49:42.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '355808091',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3187920484',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '552',
                        IFNAME           => 'ge-0/0/41',
                        IFDESCR          => 'ge-0/0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:ac',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(494573682) 57 days, 5:48:56.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '64013107',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '385956305',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '553',
                        IFNAME           => 'ge-0/0/42',
                        IFDESCR          => 'ge-0/0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:ad',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2033) 0:00:20.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '554',
                        IFNAME           => 'ge-0/0/43',
                        IFDESCR          => 'ge-0/0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:ae',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(475141828) 54 days, 23:50:18.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '756337312',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '180066856',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '555',
                        IFNAME           => 'ge-0/0/44',
                        IFDESCR          => 'ge-0/0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:af',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3485) 0:00:34.85',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '299556285',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3378018137',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '556',
                        IFNAME           => 'ge-0/0/45',
                        IFDESCR          => 'ge-0/0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:b0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(494262375) 57 days, 4:57:03.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2793185087',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1047954877',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '557',
                        IFNAME           => 'ge-0/0/46',
                        IFDESCR          => 'ge-0/0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:83',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27545575) 3 days, 4:30:55.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1784328962',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2576332072',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '558',
                        IFNAME           => 'ge-0/0/47',
                        IFDESCR          => 'ge-0/0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:83',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27545935) 3 days, 4:30:59.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4163400289',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1949303753',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '559',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:88',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(441301615) 51 days, 1:50:16.15',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '19775821',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1054882336',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '560',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:88',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(441301615) 51 days, 1:50:16.15',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '15742',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '57698310',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '561',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:89',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500084615) 57 days, 21:07:26.15',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '932913942',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3045558475',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '562',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:89',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500084615) 57 days, 21:07:26.15',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1923937',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '35968159',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:11:11:63:36:6d',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '563',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:8a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(450567846) 52 days, 3:34:38.46',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '33928625',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '123229715',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '564',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:8a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(450567846) 52 days, 3:34:38.46',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '80048',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1615054',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '565',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:8b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(502183765) 58 days, 2:57:17.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '240667725',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2007003312',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '566',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:8b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(502183765) 58 days, 2:57:17.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '423086',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '28885020',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'c8:0a:a9:3a:a5:43',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '567',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:8c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(947) 0:00:09.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '568',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:8c',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(950) 0:00:09.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '571',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '5c:5e:ab:6a:3b:81',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(787) 0:00:07.87',
                        IFINOCTETS       => '2065441240',
                        IFINERRORS       => '242',
                        IFOUTOCTETS      => '376754111',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '574',
                        IFNAME           => 'ge-0/0/20.0',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:97',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1986) 0:00:19.86',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '575',
                        IFNAME           => 'ge-0/0/21.0',
                        IFDESCR          => 'ge-0/0/21.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:98',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(489642565) 56 days, 16:07:05.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1157859',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '155347400',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1e:c9:2c:7d:c3',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '576',
                        IFNAME           => 'ge-0/0/22.0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:99',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(485155235) 56 days, 3:39:12.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '326462',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '91836193',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '577',
                        IFNAME           => 'ge-0/0/23.0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:9a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(502360558) 58 days, 3:26:45.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '606818',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '28092285',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '578',
                        IFNAME           => 'ge-0/0/24.0',
                        IFDESCR          => 'ge-0/0/24.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:9b',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(502132988) 58 days, 2:48:49.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '880723',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '13708517',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '579',
                        IFNAME           => 'ge-0/0/25.0',
                        IFDESCR          => 'ge-0/0/25.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:9c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(476374946) 55 days, 3:15:49.46',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '25626',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '51497346',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '580',
                        IFNAME           => 'ge-0/0/26.0',
                        IFDESCR          => 'ge-0/0/26.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:9d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(88742086) 10 days, 6:30:20.86',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '427395',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '611054',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '581',
                        IFNAME           => 'ge-0/0/27.0',
                        IFDESCR          => 'ge-0/0/27.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:9e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(293675818) 33 days, 23:45:58.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2105',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2198',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '582',
                        IFNAME           => 'ge-0/0/38.0',
                        IFDESCR          => 'ge-0/0/38.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(501869385) 58 days, 2:04:53.85',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '201546',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '30932570',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:24:e8:d0:be:86',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '583',
                        IFNAME           => 'ge-0/0/39.0',
                        IFDESCR          => 'ge-0/0/39.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:aa',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(501850865) 58 days, 2:01:48.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '6659780',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '117016530',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:6f:65:0f:e2:08',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '584',
                        IFNAME           => 'ge-0/0/28.0',
                        IFDESCR          => 'ge-0/0/28.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:9f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2005) 0:00:20.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '585',
                        IFNAME           => 'ge-0/0/29.0',
                        IFDESCR          => 'ge-0/0/29.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a0',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(434401888) 50 days, 6:40:18.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '731957',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1829027',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '586',
                        IFNAME           => 'ge-0/0/30.0',
                        IFDESCR          => 'ge-0/0/30.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a1',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(486281260) 56 days, 6:46:52.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '161370',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '75889201',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '587',
                        IFNAME           => 'ge-0/0/31.0',
                        IFDESCR          => 'ge-0/0/31.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a2',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(502211469) 58 days, 3:01:54.69',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '314104',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '32640988',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '588',
                        IFNAME           => 'ge-0/0/32.0',
                        IFDESCR          => 'ge-0/0/32.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(303327646) 35 days, 2:34:36.46',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1360813',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1388364',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '589',
                        IFNAME           => 'ge-0/0/33.0',
                        IFDESCR          => 'ge-0/0/33.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a4',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2020) 0:00:20.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '590',
                        IFNAME           => 'ge-0/0/34.0',
                        IFDESCR          => 'ge-0/0/34.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(500473278) 57 days, 22:12:12.78',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '393628',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3559823',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '591',
                        IFNAME           => 'ge-0/0/35.0',
                        IFDESCR          => 'ge-0/0/35.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a6',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2030) 0:00:20.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '592',
                        IFNAME           => 'ge-0/0/36.0',
                        IFDESCR          => 'ge-0/0/36.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a7',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2036) 0:00:20.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '593',
                        IFNAME           => 'ge-0/0/37.0',
                        IFDESCR          => 'ge-0/0/37.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:a8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(502359755) 58 days, 3:26:37.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '601714',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '329345598',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '78:ac:c0:b8:69:80',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '594',
                        IFNAME           => 'ge-0/0/40.0',
                        IFDESCR          => 'ge-0/0/40.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:ab',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(450298295) 52 days, 2:49:42.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '63393',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '301234445',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '595',
                        IFNAME           => 'ge-0/0/41.0',
                        IFDESCR          => 'ge-0/0/41.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:ac',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(494573682) 57 days, 5:48:56.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '170600',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2929897',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '596',
                        IFNAME           => 'ge-0/0/42.0',
                        IFDESCR          => 'ge-0/0/42.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:ad',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2050) 0:00:20.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '597',
                        IFNAME           => 'ge-0/0/43.0',
                        IFDESCR          => 'ge-0/0/43.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:ae',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(475141828) 54 days, 23:50:18.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '253289',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '287202426',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '598',
                        IFNAME           => 'ge-0/0/44.0',
                        IFDESCR          => 'ge-0/0/44.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:af',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3485) 0:00:34.85',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '185515',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '329365567',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'f0:92:1c:5a:5b:23',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '599',
                        IFNAME           => 'ge-0/0/45.0',
                        IFDESCR          => 'ge-0/0/45.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:b0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(494262375) 57 days, 4:57:03.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '35361721',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '329362919',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'a0:b3:cc:f7:26:3d',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '600',
                        IFNAME           => 'ge-0/0/46.0',
                        IFDESCR          => 'ge-0/0/46.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:83',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27545575) 3 days, 4:30:55.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '55258732',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '458540929',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '1048',
                                IFDESCR  => 'ge-2/0/0.0',
                                SYSNAME  => 'jmse-01',
                                SYSDESCR => 'Juniper Networks, Inc. ex4200-48p , version 10.4R3.4 Build date: 2011-03-19 22:17:08 UTC ',
                                SYSMAC   => '5c:5e:ab:66:60:80',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '601',
                        IFNAME           => 'ge-0/0/47.0',
                        IFDESCR          => 'ge-0/0/47.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:83',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27545935) 3 days, 4:30:59.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '55091283',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '58718811',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '952',
                                IFDESCR  => 'ge-3/0/0.0',
                                SYSNAME  => 'jmse-01',
                                SYSDESCR => 'Juniper Networks, Inc. ex4200-48p , version 10.4R3.4 Build date: 2011-03-19 22:17:08 UTC ',
                                SYSMAC   => '5c:5e:ab:66:60:80',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '604',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.100.55',
                        MAC              => '5c:5e:ab:6a:3b:81',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27545806) 3 days, 4:30:58.06',
                        IFINOCTETS       => '3540839640',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '29780586',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '605',
                        IFNAME           => 'ae0',
                        IFDESCR          => 'ae0',
                        IFTYPE           => '161',
                        IFSPEED          => '2000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:83',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27545802) 3 days, 4:30:58.02',
                        IFINOCTETS       => '1652781314',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '230681227',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '606',
                        IFNAME           => 'ae1',
                        IFDESCR          => 'ae1',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:84',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(761) 0:00:07.61',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '607',
                        IFNAME           => 'ae2',
                        IFDESCR          => 'ae2',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:85',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(768) 0:00:07.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '608',
                        IFNAME           => 'ae3',
                        IFDESCR          => 'ae3',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:86',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(774) 0:00:07.74',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '609',
                        IFNAME           => 'ae4',
                        IFDESCR          => 'ae4',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:87',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(780) 0:00:07.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '610',
                        IFNAME           => 'ae0.0',
                        IFDESCR          => 'ae0.0',
                        IFTYPE           => '161',
                        IFSPEED          => '2000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:3b:83',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27545802) 3 days, 4:30:58.02',
                        IFINOCTETS       => '1493589753',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '399817511',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:01:30:12:80:80',
                                    '00:01:30:12:91:80',
                                    '00:01:30:12:a6:c0',
                                    '00:01:30:12:a6:d0',
                                    '00:01:30:12:a8:30',
                                    '00:0b:60:b0:b0:1b',
                                    '00:0f:34:aa:ee:1b',
                                    '00:10:db:ff:10:02',
                                    '00:02:b3:31:fa:f9',
                                    '00:e0:86:12:d9:6f',
                                    '00:e0:2b:00:00:01',
                                    '00:19:d1:17:e7:3e',
                                    '00:1b:ec:00:04:09',
                                    '00:1e:c9:da:3b:fc',
                                    '00:1e:c9:f2:ca:8d',
                                    '00:1e:4f:1f:3c:44',
                                    '00:1e:4f:1f:57:4b',
                                    '00:1e:4f:31:a9:a0',
                                    '00:1e:4f:31:ab:88',
                                    '00:1e:4f:31:ab:ab',
                                    '00:1e:4f:32:e1:d3',
                                    '00:1e:4f:32:e4:69',
                                    '00:1e:4f:33:07:e1',
                                    '00:1e:4f:41:d0:a4',
                                    '00:1e:4f:41:dc:7e',
                                    '00:1e:4f:41:dd:53',
                                    '00:20:4a:0b:24:06',
                                    '00:20:4a:08:72:d2',
                                    '00:20:4a:08:ac:f6',
                                    '00:20:4a:08:ac:56',
                                    '00:20:4a:08:e1:6d',
                                    '00:20:4a:08:60:c6',
                                    '00:22:19:7b:be:11',
                                    '00:22:19:7b:be:da',
                                    '00:22:19:7b:bf:e6',
                                    '00:22:19:85:d9:70',
                                    '00:23:ae:fb:fd:89',
                                    '00:23:ae:fb:fd:b0',
                                    '00:23:ae:fc:00:cd',
                                    '00:23:ae:fc:00:d3',
                                    '00:23:ae:fc:00:d8',
                                    '00:04:96:18:6e:93',
                                    '00:04:96:18:5b:61',
                                    '00:04:96:1c:6f:f0',
                                    '00:04:96:1c:71:00',
                                    '00:04:96:1f:8f:0f',
                                    '00:04:96:1f:91:50',
                                    '00:04:96:27:93:f9',
                                    '00:04:96:04:58:20',
                                    '00:04:96:34:69:ab',
                                    '00:04:96:34:69:b1',
                                    '00:04:96:34:69:40',
                                    '00:04:96:34:89:5c',
                                    '00:04:96:34:8b:82',
                                    '00:04:96:34:8b:f8',
                                    '00:04:96:34:8c:10',
                                    '00:04:96:34:8c:11',
                                    '00:04:96:34:92:82',
                                    '00:04:96:34:92:31',
                                    '00:04:96:34:92:47',
                                    '00:04:96:35:77:14',
                                    '00:04:96:35:90:4d',
                                    '00:04:96:35:93:b9',
                                    '00:04:96:35:ad:e4',
                                    '00:04:96:35:c8:14',
                                    '00:04:96:35:c8:1f',
                                    '00:04:96:35:fa:ae',
                                    '00:04:96:35:fa:b1',
                                    '00:04:96:08:1e:70',
                                    '00:04:96:09:07:00',
                                    '00:05:1e:08:f8:20',
                                    '00:05:1e:08:f9:12',
                                    '00:05:33:54:16:aa',
                                    '00:50:56:bc:31:8a',
                                    '00:50:56:50:38:30',
                                    '00:50:56:50:38:32',
                                    '00:50:56:51:4d:58',
                                    '00:50:56:51:4d:5a',
                                    '00:60:16:1e:68:23',
                                    '78:fe:3d:df:c1:82',
                                    '78:fe:3d:df:cc:41',
                                    '78:fe:3d:3f:7f:c0',
                                    '84:18:88:ae:73:00',
                                    '84:18:88:ae:83:00',
                                    '84:18:88:ae:be:00',
                                    '84:2b:2b:71:30:f3',
                                    '10:8c:cf:cb:9b:5f',
                                    'ac:4b:c8:23:3d:41',
                                    'b0:a8:6e:85:f8:81',
                                    'b0:a8:6e:9a:2d:41',
                                    'b0:a8:6e:9a:2f:81',
                                    'b0:a8:6e:9a:52:01',
                                    '02:04:96:35:f9:24',
                                    'd0:d0:fd:b2:ad:35',
                                    'd0:d0:fd:45:e8:b5',
                                    'e4:1f:13:76:ca:35',
                                    'e4:1f:13:76:cd:e9',
                                    '18:03:73:0a:29:c2',
                                    '18:03:73:09:ae:8c',
                                    'f0:4d:a2:6e:cf:89',
                                    'f0:4d:a2:6e:d3:e6',
                                    'f0:4d:a2:6e:d4:96',
                                    'f0:4d:a2:6e:d4:1c',
                                    'f0:4d:a2:6f:03:39',
                                    'f0:4d:a2:6f:03:5b',
                                    'f0:4d:a2:d9:bc:3f',
                                    '20:3a:07:ee:e1:4a',
                                    '20:3a:07:ee:e1:54',
                                    '20:3a:07:ee:e2:40',
                                    '2c:6b:f5:9a:7e:80',
                                    '2c:36:f8:4b:66:00',
                                    '2c:36:f8:4b:6a:4a',
                                    '2c:36:f8:4b:6e:e6',
                                    '3c:4a:92:b4:f5:0d',
                                    '58:35:d9:94:e2:8d',
                                    '5c:5e:ab:65:4a:81',
                                    '5c:5e:ab:66:60:80',
                                    '5c:5e:ab:66:60:84',
                                    '5c:5e:ab:6b:ec:01',
                                    '5c:5e:ab:78:1c:80',
                                    '5c:5e:ab:78:25:00',
                                    '00:00:5e:00:01:01',
                                    '00:0c:29:0d:55:85',
                                    '00:0f:fe:ce:b0:6c',
                                    '00:0f:fe:fc:8d:a2',
                                    '00:11:11:ee:ae:b7',
                                    '00:11:43:7d:c6:da',
                                    '00:13:72:1a:72:ba',
                                    '00:13:72:2a:02:8f',
                                    '00:13:72:39:f1:22',
                                    '00:13:20:2d:75:b4',
                                    '00:d0:b8:0c:f4:e8',
                                    '00:15:17:2b:0f:64',
                                    '00:19:b9:19:31:36',
                                    '00:19:d1:aa:78:42',
                                    '00:1a:a0:c1:8c:36',
                                    '00:1a:a0:ea:93:d8',
                                    '00:1a:a0:ea:94:19',
                                    '00:1a:a0:28:3a:7d',
                                    '00:1c:c0:c0:a5:bb',
                                    '00:1c:c0:ed:8f:6a',
                                    '00:1c:c0:f1:f6:4c',
                                    '00:1c:c0:f8:19:e0',
                                    '00:1c:c0:fc:49:8e',
                                    '00:1f:f3:8b:18:39',
                                    '00:21:9b:7a:75:78',
                                    '00:22:19:16:a7:73',
                                    '00:22:19:16:a8:fe',
                                    '00:22:19:16:53:ec',
                                    '00:22:19:dc:cd:34',
                                    '00:22:19:1c:1c:c0',
                                    '00:22:19:1d:53:bc',
                                    '00:22:19:1e:18:84',
                                    '00:22:19:07:23:a2',
                                    '00:26:b9:e5:05:e5',
                                    '00:08:9b:d2:5f:2e',
                                    '00:50:b6:57:59:74',
                                    '64:31:50:3a:8f:84',
                                    '68:5b:35:7d:5b:88',
                                    '6c:3b:e5:2b:0e:9a',
                                    '6c:3b:e5:2c:08:b8',
                                    '6c:3b:e5:36:09:92',
                                    '70:5a:b6:3c:93:fe',
                                    '78:ac:c0:a0:ab:63',
                                    '78:ac:c0:a0:bb:bb',
                                    '78:ac:c0:a1:ad:14',
                                    '78:e3:b5:6f:04:3d',
                                    '78:e7:d1:c2:31:ff',
                                    '80:c1:6e:e6:bc:2f',
                                    '80:c1:6e:ec:96:4e',
                                    '80:c1:6e:fd:13:e1',
                                    '80:ee:73:41:a4:2d',
                                    '84:2b:2b:9e:f4:fb',
                                    '9c:eb:e8:00:96:2e',
                                    '10:60:4b:68:0a:ce',
                                    '10:60:4b:85:4e:d8',
                                    'ac:16:2d:46:3a:b5',
                                    'b4:b5:2f:af:86:46',
                                    'b4:b5:2f:bd:b2:bd',
                                    'b4:b5:2f:cc:91:17',
                                    'b4:b5:2f:cc:91:19',
                                    'b8:8d:12:53:3c:06',
                                    'b8:ca:3a:a0:1b:e3',
                                    'b8:ca:3a:a0:1c:0e',
                                    'b8:ca:3a:a2:95:bd',
                                    'c4:2c:03:28:c1:b3',
                                    '14:da:e9:ce:36:4b',
                                    'c8:2a:14:0f:96:16',
                                    'cc:52:af:4a:5c:4a',
                                    'cc:52:af:4c:27:57',
                                    'd4:85:64:b8:c1:c6',
                                    'd4:85:64:b8:c5:b2',
                                    'd4:85:64:b8:c5:e2',
                                    'd4:85:64:b8:c5:53',
                                    'd4:3d:7e:1f:c3:0e',
                                    'd4:3d:7e:1f:c4:d3',
                                    'e0:18:77:01:9a:74',
                                    'e8:03:9a:f7:f2:b6',
                                    'e8:39:35:3e:af:88',
                                    'f0:4d:a2:28:50:ae',
                                    'f0:4d:a2:28:51:a4',
                                    'f0:4d:a2:28:51:d2',
                                    'f0:4d:a2:38:21:8d',
                                    'f0:4d:a2:38:25:63',
                                    'f8:b1:56:9b:b0:fc',
                                    'fc:4d:d4:3d:6a:a5',
                                    '1c:6f:65:0e:51:e2',
                                    '1c:6f:65:09:58:9a',
                                    '24:be:05:0f:65:97',
                                    '24:be:05:0f:65:9d',
                                    '24:be:05:27:32:86',
                                    '24:be:05:27:3b:a6',
                                    '28:d2:44:14:03:53',
                                    '2c:27:d7:35:cf:01',
                                    '2c:27:d7:35:d2:de',
                                    '2c:27:d7:35:d3:26',
                                    '2c:41:38:93:aa:d3',
                                    '2c:41:38:ab:f9:76',
                                    '2c:41:38:b5:c0:8c',
                                    '2c:44:fd:66:1c:98',
                                    '34:15:9e:21:45:fa',
                                    '3c:d9:2b:79:8b:3a',
                                    '3c:d9:2b:5a:ec:d6',
                                    '3c:07:54:2d:a8:95',
                                    '40:6c:8f:53:e7:26',
                                    '08:2e:5f:29:26:88',
                                    '08:2e:5f:31:e7:d7',
                                    '50:46:5d:3a:0c:ed',
                                    '54:53:ed:1b:f9:d8',
                                    '5c:26:0a:74:26:30',
                                    '5c:26:0a:19:dd:8a',
                                    '5c:26:0a:2e:06:ef',
                                    '00:0c:29:86:0c:c0',
                                    '00:0c:29:94:f8:bc',
                                    '00:0c:29:b9:6d:7d',
                                    '00:0c:29:ca:32:91',
                                    '00:0c:29:2b:12:ce',
                                    '00:0c:29:56:6b:7a',
                                    '00:13:20:e4:0a:53',
                                    '00:19:d1:7a:5d:7b',
                                    '00:19:d1:ae:27:a6',
                                    '00:19:d1:17:af:cc',
                                    '00:19:d1:17:b0:2c',
                                    '00:1a:a0:65:6c:c0',
                                    '00:1c:c0:7f:3c:dd',
                                    '00:1c:c0:7f:3d:0e',
                                    '00:1c:c0:7f:3d:03',
                                    '00:1c:c0:8f:2b:f1',
                                    '00:1c:c0:8f:45:0c',
                                    '00:1c:c0:8f:46:69',
                                    '00:1c:c0:8f:46:72',
                                    '00:1c:c0:8f:46:75',
                                    '00:1c:c0:8f:46:14',
                                    '00:1c:c0:9b:30:f6',
                                    '00:1c:c0:ed:15:8c',
                                    '00:1c:c0:f1:f7:ae',
                                    '00:1c:c0:f8:1d:a7',
                                    '00:1c:c0:f8:1d:c6',
                                    '00:1c:c0:1b:04:a3',
                                    '00:1e:4f:bf:c8:8b',
                                    '00:1e:4f:32:ea:9a',
                                    '00:23:ae:92:f7:90',
                                    '00:23:ae:93:2d:e6',
                                    '00:25:64:94:49:b1',
                                    '00:25:64:a0:39:0b',
                                    '00:25:64:bd:f1:a0',
                                    '00:27:0e:00:9a:d2',
                                    '00:27:0e:01:25:64',
                                    '00:27:0e:01:25:67',
                                    '00:27:0e:01:25:6e',
                                    '00:27:0e:01:28:fc',
                                    '00:27:0e:01:28:57',
                                    '00:27:0e:01:28:5e',
                                    '00:27:0e:02:64:91',
                                    '00:27:0e:02:56:22',
                                    '00:27:0e:02:56:57',
                                    '00:50:56:bc:00:48',
                                    '00:50:56:50:30:a0',
                                    '00:50:56:50:30:a2',
                                    '00:50:56:50:30:b8',
                                    '00:50:56:50:30:ba',
                                    '70:f3:95:13:d5:a2',
                                    '70:f3:95:13:d6:54',
                                    '70:f3:95:19:1c:47',
                                    '70:f3:95:19:2a:3a',
                                    '78:2b:cb:7e:63:a7',
                                    '84:2b:2b:9d:79:cc',
                                    '84:2b:2b:9d:8a:df',
                                    '10:78:d2:c3:db:b7',
                                    '10:78:d2:c3:df:fc',
                                    '10:78:d2:c3:e1:c0',
                                    'f0:4d:a2:0e:2c:5f',
                                    '1c:6f:65:0a:68:d1',
                                    '1c:6f:65:0b:cf:c8',
                                    '1c:6f:65:0d:e0:b3',
                                    '1c:6f:65:0d:ed:6c',
                                    '1c:6f:65:0f:e1:2e',
                                    '1c:6f:65:0f:fd:21',
                                    '44:37:e6:87:65:ed',
                                    '44:37:e6:62:26:f7',
                                    '44:37:e6:63:4c:e1',
                                    '00:0c:f1:e2:78:ed',
                                    '00:0c:f1:e2:79:3f',
                                    '00:0c:f1:e2:7a:aa',
                                    '00:0c:f1:e2:7a:4a',
                                    '00:0c:f1:e8:b9:65',
                                    '00:0c:f1:e8:b9:80',
                                    '00:0c:f1:e8:bc:31',
                                    '00:13:20:4a:d7:3f',
                                    '00:13:20:4a:d7:44',
                                    '00:16:76:86:6a:24',
                                    '00:11:43:a2:83:c1',
                                    'c8:cb:b8:2b:47:63',
                                    'c8:cb:b8:2b:4c:38',
                                    '00:60:ef:04:7b:a9',
                                    '00:1c:c0:7f:3f:46',
                                    '00:1c:c0:fc:f8:fb',
                                    '00:1c:c0:fc:f9:93',
                                    '00:1c:c0:fc:fa:09',
                                    '84:2b:2b:b2:74:db',
                                    '84:2b:2b:b9:3d:90',
                                    '00:60:16:1e:57:3d',
                                    '00:0c:29:ca:32:9b',
                                    '00:50:56:50:30:a0',
                                    '00:50:56:50:30:a2',
                                    '00:0c:29:ca:32:af',
                                    '00:19:d1:b1:fa:10',
                                    '00:19:d1:04:c2:29',
                                    '00:21:9b:60:d0:4e',
                                    '00:25:64:a0:3c:09',
                                    '00:50:56:bc:02:49',
                                    '00:50:56:bc:1c:83',
                                    '00:50:56:bc:29:c6',
                                    '00:50:56:50:30:a0',
                                    '00:50:56:50:30:a2',
                                    '00:50:56:50:30:b8',
                                    '00:50:56:50:30:ba',
                                    '70:f3:95:19:28:a7',
                                    '70:f3:95:19:29:7f',
                                    '70:f3:95:19:32:39',
                                    '70:f3:95:19:36:1e',
                                    '70:f3:95:1b:84:bc',
                                    '70:f3:95:1b:87:3d',
                                    '70:f3:95:1b:87:45',
                                    '70:f3:95:1b:87:50',
                                    '70:f3:95:1b:87:54',
                                    '88:f0:77:59:d9:ae',
                                    '14:fe:b5:b8:c2:03',
                                    'c8:2a:14:42:4b:e0',
                                    'cc:52:af:4a:4b:98',
                                    'cc:52:af:4c:23:23',
                                    'e8:9a:8f:6d:c9:80',
                                    'e8:11:32:61:38:ef',
                                    'f0:de:f1:b0:72:97',
                                    '1c:6f:65:0b:cf:67',
                                    '40:6c:8f:51:ac:bd',
                                    '40:2c:f4:eb:d1:2d',
                                    '40:2c:f4:eb:d8:6c',
                                    '40:2c:f4:eb:d8:97',
                                    '40:2c:f4:ec:01:8a',
                                    '44:37:e6:92:3a:ae',
                                    '44:37:e6:bb:a3:c9',
                                    '08:00:27:2d:5d:16',
                                    '08:00:27:41:88:d9',
                                    '5c:f9:dd:41:55:a1',
                                    '14:da:e9:0d:7e:d9',
                                    '50:46:5d:ea:cb:91',
                                    '00:13:20:32:81:47',
                                    '00:16:76:0d:37:22',
                                    '00:16:cb:aa:6d:75',
                                    '00:16:cb:ae:3d:f1',
                                    '00:e0:db:0c:ef:43',
                                    '00:e0:db:08:14:ef',
                                    '00:18:51:c7:ad:5f',
                                    '00:19:b9:fe:c1:52',
                                    '00:1a:a0:ba:e2:a6',
                                    '00:1a:a0:36:6d:b3',
                                    '00:1a:a0:36:ac:4d',
                                    '00:1c:c0:9b:30:e9',
                                    '00:1c:c0:9b:31:e2',
                                    '00:1c:c0:9b:58:fd',
                                    '00:1d:09:ff:83:c0',
                                    '00:1e:4f:f4:2d:4a',
                                    '00:1e:4f:f4:31:2d',
                                    '00:22:19:63:0f:4d',
                                    '00:25:64:92:7d:88',
                                    '00:25:64:bd:e6:e7',
                                    '00:25:64:bd:f1:fb',
                                    '00:25:64:bd:f1:5f',
                                    '00:25:64:be:2b:6d',
                                    '00:04:00:c3:15:26',
                                    '64:b9:e8:bc:71:c2',
                                    '64:b9:e8:c0:af:d8',
                                    '68:a8:6d:57:2f:5e',
                                    '70:cd:60:f1:fb:d0',
                                    '78:92:9c:12:3f:1c',
                                    '78:2b:cb:7e:62:9e',
                                    '7c:6d:62:8c:ed:22',
                                    '84:2b:2b:ab:ee:ad',
                                    '84:2b:2b:ab:ef:b4',
                                    'a8:20:66:03:64:2c',
                                    'bc:30:5b:ab:ff:5e',
                                    'c4:2c:03:21:ca:b2',
                                    '14:10:9f:dc:8d:dd',
                                    'cc:52:af:41:38:5e',
                                    'cc:52:af:4c:27:44',
                                    'd4:9a:20:07:10:be',
                                    'f0:4d:a2:0e:2c:38',
                                    '1c:6f:65:0d:ed:2a',
                                    '1c:6f:65:0d:f0:52',
                                    '1c:6f:65:0d:f1:e8',
                                    '1c:6f:65:0d:f2:9f',
                                    '1c:6f:65:0e:4f:b9',
                                    '1c:6f:65:0e:4f:de',
                                    '1c:6f:65:0e:4f:e2',
                                    '1c:6f:65:0e:50:e5',
                                    '1c:6f:65:0e:51:02',
                                    '1c:6f:65:0e:51:06',
                                    '20:c9:d0:29:d8:47',
                                    '3c:97:0e:70:0b:73',
                                    '3c:97:0e:7b:e8:4a',
                                    '3c:97:0e:48:cd:86',
                                    '3c:d0:f8:af:22:93',
                                    '3c:07:54:35:11:7a',
                                    '3c:07:54:35:22:51',
                                    '40:6c:8f:bb:dc:e2',
                                    '44:37:e6:6f:30:d8',
                                    '44:37:e6:6f:34:68',
                                    '44:37:e6:79:b2:84',
                                    '44:37:e6:79:b9:61',
                                    '44:37:e6:87:65:d2',
                                    '44:37:e6:87:65:d7',
                                    '44:37:e6:87:65:36',
                                    '44:37:e6:87:65:55',
                                    '44:37:e6:87:60:7f',
                                    '44:37:e6:63:4c:f7',
                                    '5c:26:0a:12:2e:62',
                                    '5c:26:0a:63:7c:f2',
                                    '00:0c:29:cf:f4:09',
                                    '00:0c:29:d4:b1:ab',
                                    '00:0c:29:f1:eb:69',
                                    '00:18:51:72:8e:eb',
                                    '00:18:51:7d:14:84',
                                    '00:18:51:91:7b:7c',
                                    '00:18:51:1c:b8:09',
                                    '00:1e:c9:f2:c0:81',
                                    '00:1e:4f:32:f7:9e',
                                    '00:1e:4f:33:14:d1',
                                    '00:1e:4f:41:d8:69',
                                    '00:1e:4f:41:e2:8c',
                                    '00:22:19:85:d5:3d',
                                    '00:22:19:63:0f:4d',
                                    '00:23:ae:fe:9c:e0',
                                    '00:23:ae:fe:9d:7c',
                                    '00:23:ae:fe:a9:c8',
                                    '00:23:ae:fe:a9:e0',
                                    '00:30:8c:1a:4b:4c',
                                    '00:50:56:bc:00:27',
                                    '00:50:56:bc:00:2f',
                                    '00:50:56:bc:57:2f',
                                    '00:50:56:bc:5d:6b',
                                    '00:50:56:50:30:a0',
                                    '00:50:56:50:30:a2',
                                    '00:50:56:50:30:b8',
                                    '00:50:56:50:30:ba',
                                    '00:1e:c9:f2:c0:81',
                                    '00:1e:4f:32:f7:9e',
                                    '00:1e:4f:33:14:d1',
                                    '00:1e:4f:41:d8:69',
                                    '00:1e:4f:41:e2:84',
                                    '00:1e:4f:41:e2:8c',
                                    '00:22:19:85:d5:3d',
                                    '00:23:ae:fe:9c:e0',
                                    '00:23:ae:fe:9d:7c',
                                    '00:23:ae:fe:a9:c8',
                                    '00:23:ae:fe:a9:e0',
                                    '00:50:56:bc:03:4b',
                                    '00:50:56:bc:57:30',
                                    '00:50:56:50:30:a0',
                                    '00:50:56:50:30:a2',
                                    '00:50:56:50:30:b8',
                                    '00:50:56:50:30:ba',
                                    '00:80:9f:53:3d:f7',
                                    '00:10:5a:c7:8d:62',
                                    '00:50:04:54:86:6f',
                                    '0c:77:1a:21:98:47',
                                    '84:a6:c8:ab:d3:c1',
                                    '88:53:2e:d7:07:85',
                                    'c4:85:08:7d:77:c9',
                                    'c4:85:08:05:2b:e3',
                                    'c8:f7:33:89:ba:61',
                                    '24:77:03:d2:eb:18',
                                    '4c:80:93:68:01:41',
                                    '4c:eb:42:95:f5:88',
                                    '58:91:cf:07:bd:9a',
                                    '00:0b:86:0a:f8:a0',
                                    '00:0c:29:27:f8:57',
                                    '00:11:11:3a:83:e7',
                                    '00:16:76:ce:7c:0a',
                                    '00:17:f2:94:41:c4',
                                    '00:18:51:00:00:54',
                                    '00:18:51:00:41:ec',
                                    '00:18:51:6a:b1:c9',
                                    '00:18:51:6b:ef:ef',
                                    '00:18:51:91:62:38',
                                    '00:18:51:94:15:c6',
                                    '00:18:51:99:f9:a1',
                                    '00:18:51:a6:4b:5c',
                                    '00:18:51:a9:ad:1b',
                                    '00:18:51:11:12:86',
                                    '00:18:51:b7:73:e0',
                                    '00:18:51:bd:01:02',
                                    '00:18:51:c7:06:38',
                                    '00:18:51:ec:1e:3b',
                                    '00:18:51:18:85:31',
                                    '00:18:51:fb:8c:ef',
                                    '00:18:51:1d:af:93',
                                    '00:18:51:24:40:88',
                                    '00:18:51:04:2d:18',
                                    '00:18:51:37:05:fa',
                                    '00:18:51:44:08:78',
                                    '00:18:51:47:8c:c5',
                                    '00:18:51:4b:1a:a2',
                                    '00:18:51:51:f1:8d',
                                    '00:18:51:5c:d2:3b',
                                    '00:18:51:5e:18:6c',
                                    '00:18:51:5e:25:c8',
                                    '00:1c:c0:22:f4:d4',
                                    '00:20:4a:d7:39:5a',
                                    '00:22:19:63:0f:4d',
                                    '00:24:36:f4:02:3e',
                                    '00:26:b9:77:17:f6',
                                    '00:30:48:76:ab:88',
                                    '00:30:48:82:e7:72',
                                    '00:50:56:bc:00:00',
                                    '00:50:56:bc:00:01',
                                    '00:50:56:bc:00:09',
                                    '00:50:56:bc:28:f1',
                                    '00:50:56:bc:29:c3',
                                    '00:50:56:bc:31:94',
                                    '00:50:56:bc:35:da',
                                    '00:50:56:50:30:a0',
                                    '00:50:56:50:30:a2',
                                    '00:50:56:50:30:b8',
                                    '00:50:56:50:30:ba',
                                    '00:1c:c0:9b:31:d1',
                                    '00:27:0e:01:25:fa',
                                    '70:f3:95:1b:85:4c',
                                    '00:0c:29:ca:32:a5',
                                    '00:13:20:6c:ab:be',
                                    '00:19:d1:17:af:ad',
                                    '00:19:d1:17:b0:7e',
                                    '00:19:d1:17:b0:93',
                                    '00:19:d1:17:b0:99',
                                    '00:19:d1:17:b0:14',
                                    '00:19:d1:17:b0:1b',
                                    '00:19:d1:17:b0:1c',
                                    '00:19:d1:17:b0:27',
                                    '00:19:d1:17:b0:35',
                                    '00:19:d1:05:a6:73',
                                    '00:1c:c0:7f:3c:d6',
                                    '00:1c:c0:8f:30:26',
                                    '00:23:7d:1d:d7:de',
                                    '00:23:7d:1d:fe:cb',
                                    '00:26:b9:ed:20:53',
                                    '00:27:0e:01:25:4a',
                                    '00:50:56:50:30:a0',
                                    '00:50:56:50:30:a2',
                                    '70:f3:95:1b:84:96',
                                    '70:f3:95:1b:85:37',
                                    '84:2b:2b:9d:8a:f9',
                                    '84:2b:2b:9d:8c:20',
                                    '84:2b:2b:9d:8c:32',
                                    '84:2b:2b:a0:44:4e',
                                    '1c:6f:65:0d:f7:3d',
                                    '44:37:e6:bb:a3:cc',
                                    '00:80:91:74:98:a2',
                                    '00:80:91:74:98:c8',
                                    '00:80:91:74:98:3f',
                                    '00:80:91:74:a3:4c',
                                    '00:20:4a:b1:3d:da',
                                    '00:23:24:60:6d:11',
                                    '00:22:19:1c:53:77',
                                    '00:22:19:1c:53:b3',
                                    '00:22:19:1c:55:8d',
                                    '00:22:19:1c:55:b9',
                                    '00:22:19:1c:56:01',
                                    '00:22:19:1d:d5:d8',
                                    '00:0d:7c:00:73:ae',
                                    '00:1e:67:03:93:04',
                                    '00:50:56:bc:00:24',
                                    '00:50:60:05:61:43',
                                    '00:12:3f:76:69:ab',
                                    '00:12:3f:76:b6:91',
                                    '00:12:3f:76:b6:ae',
                                    '00:13:20:38:f6:3e',
                                    '00:16:cb:99:5a:94',
                                    '00:19:d1:b1:ce:50',
                                    '00:24:e8:46:17:8e',
                                    '68:b5:99:90:64:4d',
                                    '70:f3:95:13:af:0d',
                                    '70:f3:95:1b:84:fc',
                                    '70:f3:95:1b:85:ac',
                                    'b8:ac:6f:2e:cb:13',
                                    'c8:bc:c8:92:76:53',
                                    'd4:85:64:a9:96:94',
                                    'd4:85:64:b8:c5:af',
                                    '1c:6f:65:0e:90:39',
                                    '24:be:05:0d:a0:96',
                                    '24:be:05:0d:b3:28',
                                    '24:be:05:0f:58:2f',
                                    '2c:27:d7:2d:9f:7c',
                                    '00:24:e8:46:17:aa',
                                    '00:24:e8:46:17:b8',
                                    '00:24:e8:46:25:ba',
                                    '00:24:e8:46:26:10',
                                    '00:24:e8:46:27:5b',
                                    '00:14:38:a2:c7:95',
                                    '00:21:5a:7b:0b:c9',
                                    '00:21:5a:81:95:36',
                                    '00:23:7d:77:5c:42',
                                    '6c:3b:e5:02:c1:a4',
                                    '78:ac:c0:91:d0:b5',
                                    '98:4b:e1:3b:ea:d4',
                                    '10:60:4b:14:9c:07',
                                    '10:60:4b:14:ac:23',
                                    '10:60:4b:14:17:ac',
                                    'b4:b5:2f:f5:d6:73',
                                    'd4:85:64:3c:0b:56',
                                    'd4:85:64:3c:2b:af',
                                    '3c:d9:2b:9f:e2:64',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '611',
                        IFNAME           => 'vlan.1114',
                        IFDESCR          => 'vlan.1114',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '172.21.10.251',
                        MAC              => '5c:5e:ab:6a:3b:81',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27545808) 3 days, 4:30:58.08',
                        IFINOCTETS       => '1070904092',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '343849980',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '612',
                        IFNAME           => 'vlan.1116',
                        IFDESCR          => 'vlan.1116',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '172.21.12.251',
                        MAC              => '5c:5e:ab:6a:3b:81',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(27545809) 3 days, 4:30:58.09',
                        IFINOCTETS       => '936738386',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '21522',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'juniper/ex3200.02.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Juniper',
            MODEL        => 'EX3200-24t',
            DESCRIPTION  => 'Juniper Networks, Inc. ex3200-48p internet router, kernel JUNOS 10.4R3.4 #0: 2011-03-19 22:06:32 UTC     builder@warth.juniper.net:/volume/build/junos/10.4/release/10.4R3.4/obj-powerpc/bsd/sys/compile/JUNIPER-EX Build date: 2011-03-19 21:51:24 UTC Copyri',
            SNMPHOSTNAME => 'jmsea3-11',
            LOCATION     => 'MSE Bat.A 3eme',
            SERIAL       => 'BL0211118777',
            UPTIME       => '(474858650) 54 days, 23:03:06.50',
            MEMORY       => '0',
            IPS          => {
                IP => [
                    '128.0.0.1',
                    '128.0.0.127',
                    '128.0.0.16',
                    '128.0.0.32',
                    '172.21.10.252',
                    '172.21.12.250',
                    '172.21.12.252',
                    '192.168.100.56',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Juniper',
                MODEL        => 'EX3200-24t',
                COMMENTS     => 'Juniper Networks, Inc. ex3200-48p internet router, kernel JUNOS 10.4R3.4 #0: 2011-03-19 22:06:32 UTC     builder@warth.juniper.net:/volume/build/junos/10.4/release/10.4R3.4/obj-powerpc/bsd/sys/compile/JUNIPER-EX Build date: 2011-03-19 21:51:24 UTC Copyri',
                NAME         => 'jmsea3-11',
                LOCATION     => 'MSE Bat.A 3eme',
                SERIAL       => 'BL0211118777',
                UPTIME       => '(474858650) 54 days, 23:03:06.50',
                MEMORY       => '0',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '172.21.10.252',
                        '172.21.12.250',
                        '172.21.12.252',
                        '192.168.100.56',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1274) 0:00:12.74',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1272) 0:00:12.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1274) 0:00:12.74',
                        IFINOCTETS       => '2508732132',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2508732132',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1276) 0:00:12.76',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1272) 0:00:12.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1272) 0:00:12.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1276) 0:00:12.76',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1276) 0:00:12.76',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1275) 0:00:12.75',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:ff',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1275) 0:00:12.75',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => 'me0.0',
                        IFDESCR          => 'me0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '5c:5e:ab:6a:2a:ff',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1275) 0:00:12.75',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1271) 0:00:12.71',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1785427684',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1271) 0:00:12.71',
                        IFINOCTETS       => '1738384031',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(447510701) 51 days, 19:05:07.01',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '14886930',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2088716720',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(447510701) 51 days, 19:05:07.01',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '551410',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '290498861',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:81',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(466665331) 54 days, 0:17:33.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '601042193',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3516529619',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:82',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2593) 0:00:25.93',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:83',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(473765341) 54 days, 20:00:53.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '771262090',
                        IFINERRORS       => '3',
                        IFOUTOCTETS      => '3851782501',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:84',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474817601) 54 days, 22:56:16.01',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '32894071',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3088883923',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'jsrv',
                        IFDESCR          => 'jsrv',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '5c:5e:ab:6a:2a:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1273) 0:00:12.73',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'jsrv.1',
                        IFDESCR          => 'jsrv.1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '128.0.0.127',
                        MAC              => '5c:5e:ab:6a:2a:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2195) 0:00:21.95',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '5c:5e:ab:6a:2a:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1277) 0:00:12.77',
                        IFINOCTETS       => '1941246604',
                        IFINERRORS       => '194',
                        IFOUTOCTETS      => '344927255',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:81',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(466665331) 54 days, 0:17:33.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '121062',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '304609915',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:82',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2594) 0:00:25.94',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:83',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(473765341) 54 days, 20:00:53.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3314717',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '26864487',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:84',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474817601) 54 days, 22:56:16.01',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '235971',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '307847984',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:85',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2598) 0:00:25.98',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:85',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2599) 0:00:25.99',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:86',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(473224181) 54 days, 18:30:41.81',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1081420155',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3064383349',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:86',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(473224181) 54 days, 18:30:41.81',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '16460',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '296795332',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:87',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(473422983) 54 days, 19:03:49.83',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '730460325',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3754870149',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:87',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(473422983) 54 days, 19:03:49.83',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '496699',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '54295427',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:88',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(471981381) 54 days, 15:03:33.81',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1833035239',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3313914163',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:88',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(471981381) 54 days, 15:03:33.81',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '186142',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '34341515',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:89',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2606) 0:00:26.06',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:89',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2606) 0:00:26.06',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:8a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2607) 0:00:26.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:8a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2608) 0:00:26.08',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:8b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2609) 0:00:26.09',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:8b',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2610) 0:00:26.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/0/12',
                        IFDESCR          => 'ge-0/0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:8c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(464082731) 53 days, 17:07:07.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3016626552',
                        IFINERRORS       => '23',
                        IFOUTOCTETS      => '794285937',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/0/12.0',
                        IFDESCR          => 'ge-0/0/12.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:8c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(464082731) 53 days, 17:07:07.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '14343542',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '308033408',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/0/13',
                        IFDESCR          => 'ge-0/0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:8d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2613) 0:00:26.13',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/0/13.0',
                        IFDESCR          => 'ge-0/0/13.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:8d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2614) 0:00:26.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'ge-0/0/14',
                        IFDESCR          => 'ge-0/0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:8e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(401656041) 46 days, 11:42:40.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4060424',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '603143102',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '533',
                        IFNAME           => 'ge-0/0/14.0',
                        IFDESCR          => 'ge-0/0/14.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:8e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(401656041) 46 days, 11:42:40.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1571357',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '50320347',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '534',
                        IFNAME           => 'ge-0/0/15',
                        IFDESCR          => 'ge-0/0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:8f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2616) 0:00:26.16',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '535',
                        IFNAME           => 'ge-0/0/15.0',
                        IFDESCR          => 'ge-0/0/15.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:8f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2617) 0:00:26.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '536',
                        IFNAME           => 'ge-0/0/16',
                        IFDESCR          => 'ge-0/0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:90',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2618) 0:00:26.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '537',
                        IFNAME           => 'ge-0/0/16.0',
                        IFDESCR          => 'ge-0/0/16.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:90',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2619) 0:00:26.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '538',
                        IFNAME           => 'ge-0/0/17',
                        IFDESCR          => 'ge-0/0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:91',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474571629) 54 days, 22:15:16.29',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '200952724',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '586411337',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '539',
                        IFNAME           => 'ge-0/0/17.0',
                        IFDESCR          => 'ge-0/0/17.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:91',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474571629) 54 days, 22:15:16.29',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '397720',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '13299334',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '540',
                        IFNAME           => 'ge-0/0/18',
                        IFDESCR          => 'ge-0/0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:92',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474806931) 54 days, 22:54:29.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2413734880',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4043599409',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '541',
                        IFNAME           => 'ge-0/0/18.0',
                        IFDESCR          => 'ge-0/0/18.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:92',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474806931) 54 days, 22:54:29.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '815785',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '32444373',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '542',
                        IFNAME           => 'ge-0/0/19',
                        IFDESCR          => 'ge-0/0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:93',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2623) 0:00:26.23',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '543',
                        IFNAME           => 'ge-0/0/19.0',
                        IFDESCR          => 'ge-0/0/19.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:93',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2624) 0:00:26.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '544',
                        IFNAME           => 'ge-0/0/20',
                        IFDESCR          => 'ge-0/0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:94',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(328099523) 37 days, 23:23:15.23',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '9593090',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '122546996',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '545',
                        IFNAME           => 'ge-0/0/20.0',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:94',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(328099523) 37 days, 23:23:15.23',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '158982',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1941658',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '546',
                        IFNAME           => 'ge-0/0/21',
                        IFDESCR          => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:95',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(473786149) 54 days, 20:04:21.49',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '910143171',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3292994931',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '547',
                        IFNAME           => 'ge-0/0/21.0',
                        IFDESCR          => 'ge-0/0/21.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:95',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(473786149) 54 days, 20:04:21.49',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2444044',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42155232',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '548',
                        IFNAME           => 'ge-0/0/22',
                        IFDESCR          => 'ge-0/0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:96',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474666851) 54 days, 22:31:08.51',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '216122988',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2000485885',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '549',
                        IFNAME           => 'ge-0/0/22.0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:96',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474666851) 54 days, 22:31:08.51',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1641680',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '10861331',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '550',
                        IFNAME           => 'ge-0/0/23',
                        IFDESCR          => 'ge-0/0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:97',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(449070911) 51 days, 23:25:09.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '666544062',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1571272994',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '551',
                        IFNAME           => 'ge-0/0/23.0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:97',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(449070911) 51 days, 23:25:09.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '40043',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '7808014',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '552',
                        IFNAME           => 'ge-0/0/24',
                        IFDESCR          => 'ge-0/0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:98',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474699291) 54 days, 22:36:32.91',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1058614693',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1622927813',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '553',
                        IFNAME           => 'ge-0/0/24.0',
                        IFDESCR          => 'ge-0/0/24.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:98',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474699291) 54 days, 22:36:32.91',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '296591',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '308007181',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '554',
                        IFNAME           => 'ge-0/0/25',
                        IFDESCR          => 'ge-0/0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:99',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2881) 0:00:28.81',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '528263847',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1279432526',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '555',
                        IFNAME           => 'ge-0/0/25.0',
                        IFDESCR          => 'ge-0/0/25.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:99',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2881) 0:00:28.81',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '143161',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '308037572',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '556',
                        IFNAME           => 'ge-0/0/26',
                        IFDESCR          => 'ge-0/0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:9a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474818413) 54 days, 22:56:24.13',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '545505781',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3766544875',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '557',
                        IFNAME           => 'ge-0/0/26.0',
                        IFDESCR          => 'ge-0/0/26.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:9a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474818413) 54 days, 22:56:24.13',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '961240',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '23693862',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '558',
                        IFNAME           => 'ge-0/0/27',
                        IFDESCR          => 'ge-0/0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:9b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474471131) 54 days, 21:58:31.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1666756622',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1417421358',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '559',
                        IFNAME           => 'ge-0/0/27.0',
                        IFDESCR          => 'ge-0/0/27.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:9b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474471131) 54 days, 21:58:31.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '352430',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '308017345',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '560',
                        IFNAME           => 'ge-0/0/28',
                        IFDESCR          => 'ge-0/0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:9c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(466228065) 53 days, 23:04:40.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '50598995',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '352981116',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '561',
                        IFNAME           => 'ge-0/0/28.0',
                        IFDESCR          => 'ge-0/0/28.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:9c',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(466228065) 53 days, 23:04:40.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '77642',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1874420',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '562',
                        IFNAME           => 'ge-0/0/29',
                        IFDESCR          => 'ge-0/0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:9d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2640) 0:00:26.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '563',
                        IFNAME           => 'ge-0/0/29.0',
                        IFDESCR          => 'ge-0/0/29.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:9d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2641) 0:00:26.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '564',
                        IFNAME           => 'ge-0/0/30',
                        IFDESCR          => 'ge-0/0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:9e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474724931) 54 days, 22:40:49.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '71493516',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2860500344',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '565',
                        IFNAME           => 'ge-0/0/30.0',
                        IFDESCR          => 'ge-0/0/30.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:9e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474724931) 54 days, 22:40:49.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '39546',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '276415302',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '566',
                        IFNAME           => 'ge-0/0/31',
                        IFDESCR          => 'ge-0/0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:9f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(386442931) 44 days, 17:27:09.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1373339167',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1480696221',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '567',
                        IFNAME           => 'ge-0/0/31.0',
                        IFDESCR          => 'ge-0/0/31.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:9f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(386442931) 44 days, 17:27:09.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '249068',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '308032688',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '568',
                        IFNAME           => 'ge-0/0/32',
                        IFDESCR          => 'ge-0/0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474803051) 54 days, 22:53:50.51',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '968879',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '439333937',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '569',
                        IFNAME           => 'ge-0/0/32.0',
                        IFDESCR          => 'ge-0/0/32.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474803051) 54 days, 22:53:50.51',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '821367',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '307779041',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '570',
                        IFNAME           => 'ge-0/0/33',
                        IFDESCR          => 'ge-0/0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2648) 0:00:26.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '571',
                        IFNAME           => 'ge-0/0/33.0',
                        IFDESCR          => 'ge-0/0/33.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a1',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2649) 0:00:26.49',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '572',
                        IFNAME           => 'ge-0/0/34',
                        IFDESCR          => 'ge-0/0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474779731) 54 days, 22:49:57.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3776487528',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '308100617',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '573',
                        IFNAME           => 'ge-0/0/34.0',
                        IFDESCR          => 'ge-0/0/34.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(474779731) 54 days, 22:49:57.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1127518',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '296932693',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '574',
                        IFNAME           => 'ge-0/0/35',
                        IFDESCR          => 'ge-0/0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(473621355) 54 days, 19:36:53.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '177826879',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4200369213',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '575',
                        IFNAME           => 'ge-0/0/35.0',
                        IFDESCR          => 'ge-0/0/35.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a3',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(473621355) 54 days, 19:36:53.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '427371',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '215447078',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '576',
                        IFNAME           => 'ge-0/0/36',
                        IFDESCR          => 'ge-0/0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472891711) 54 days, 17:35:17.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '627849190',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3532210109',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '577',
                        IFNAME           => 'ge-0/0/36.0',
                        IFDESCR          => 'ge-0/0/36.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(472891711) 54 days, 17:35:17.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '145978',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '304763529',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '578',
                        IFNAME           => 'ge-0/0/37',
                        IFDESCR          => 'ge-0/0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(457382961) 52 days, 22:30:29.61',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2759011',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '216762972',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '579',
                        IFNAME           => 'ge-0/0/37.0',
                        IFDESCR          => 'ge-0/0/37.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(457382961) 52 days, 22:30:29.61',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1057803',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '11561523',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '580',
                        IFNAME           => 'ge-0/0/38',
                        IFDESCR          => 'ge-0/0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(448152515) 51 days, 20:52:05.15',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1327042861',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '321449166',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '581',
                        IFNAME           => 'ge-0/0/38.0',
                        IFDESCR          => 'ge-0/0/38.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a6',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(448152515) 51 days, 20:52:05.15',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '240627',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2639044',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '582',
                        IFNAME           => 'ge-0/0/39',
                        IFDESCR          => 'ge-0/0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2662) 0:00:26.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '583',
                        IFNAME           => 'ge-0/0/39.0',
                        IFDESCR          => 'ge-0/0/39.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a7',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2663) 0:00:26.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '584',
                        IFNAME           => 'ge-0/0/40',
                        IFDESCR          => 'ge-0/0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(471983661) 54 days, 15:03:56.61',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2168703795',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '4219083410',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '585',
                        IFNAME           => 'ge-0/0/40.0',
                        IFDESCR          => 'ge-0/0/40.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(471983661) 54 days, 15:03:56.61',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '743164',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '308013381',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '586',
                        IFNAME           => 'ge-0/0/41',
                        IFDESCR          => 'ge-0/0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2666) 0:00:26.66',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '587',
                        IFNAME           => 'ge-0/0/41.0',
                        IFDESCR          => 'ge-0/0/41.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:a9',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2667) 0:00:26.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '588',
                        IFNAME           => 'ge-0/0/42',
                        IFDESCR          => 'ge-0/0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:aa',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(344169975) 39 days, 20:01:39.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '509474',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5672787',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '589',
                        IFNAME           => 'ge-0/0/42.0',
                        IFDESCR          => 'ge-0/0/42.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:aa',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(344169975) 39 days, 20:01:39.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5643',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '17516',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '590',
                        IFNAME           => 'ge-0/0/43',
                        IFDESCR          => 'ge-0/0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:ab',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2670) 0:00:26.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '591',
                        IFNAME           => 'ge-0/0/43.0',
                        IFDESCR          => 'ge-0/0/43.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:ab',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2671) 0:00:26.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '592',
                        IFNAME           => 'ge-0/0/44',
                        IFDESCR          => 'ge-0/0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:ac',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(457276321) 52 days, 22:12:43.21',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '16253803',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2003256603',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '593',
                        IFNAME           => 'ge-0/0/44.0',
                        IFDESCR          => 'ge-0/0/44.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:ac',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(457276321) 52 days, 22:12:43.21',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '57156',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '304452124',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '594',
                        IFNAME           => 'ge-0/0/45',
                        IFDESCR          => 'ge-0/0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:ad',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(473664981) 54 days, 19:44:09.81',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '925998916',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2796870118',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '595',
                        IFNAME           => 'ge-0/0/45.0',
                        IFDESCR          => 'ge-0/0/45.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:ad',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(473664981) 54 days, 19:44:09.81',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '682000',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '33355715',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '596',
                        IFNAME           => 'ge-0/0/46',
                        IFDESCR          => 'ge-0/0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4121) 0:00:41.21',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1094192709',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2345397936',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '597',
                        IFNAME           => 'ge-0/0/46.0',
                        IFDESCR          => 'ge-0/0/46.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4121) 0:00:41.21',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '52234794',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '418748502',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '1050',
                                IFDESCR  => 'ge-2/0/1.0',
                                SYSNAME  => 'jmse-01',
                                SYSDESCR => 'Juniper Networks, Inc. ex4200-48p , version 10.4R3.4 Build date: 2011-03-19 22:17:08 UTC ',
                                SYSMAC   => '5c:5e:ab:66:60:80',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '598',
                        IFNAME           => 'ge-0/0/47',
                        IFDESCR          => 'ge-0/0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4141) 0:00:41.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '302235082',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '741470555',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '599',
                        IFNAME           => 'ge-0/0/47.0',
                        IFDESCR          => 'ge-0/0/47.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4141) 0:00:41.41',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '52076509',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '52076076',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '954',
                                IFDESCR  => 'ge-3/0/1.0',
                                SYSNAME  => 'jmse-01',
                                SYSDESCR => 'Juniper Networks, Inc. ex4200-48p , version 10.4R3.4 Build date: 2011-03-19 22:17:08 UTC ',
                                SYSMAC   => '5c:5e:ab:66:60:80',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '604',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.100.56',
                        MAC              => '5c:5e:ab:6a:2a:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4329) 0:00:43.29',
                        IFINOCTETS       => '1234212430',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '18289848',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '605',
                        IFNAME           => 'ae0',
                        IFDESCR          => 'ae0',
                        IFTYPE           => '161',
                        IFSPEED          => '2000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4324) 0:00:43.24',
                        IFINOCTETS       => '1396427791',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3086868491',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '606',
                        IFNAME           => 'ae1',
                        IFDESCR          => 'ae1',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:81',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1269) 0:00:12.69',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '607',
                        IFNAME           => 'ae2',
                        IFDESCR          => 'ae2',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:82',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1270) 0:00:12.70',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '608',
                        IFNAME           => 'ae3',
                        IFDESCR          => 'ae3',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:83',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1270) 0:00:12.70',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '609',
                        IFNAME           => 'ae4',
                        IFDESCR          => 'ae4',
                        IFTYPE           => '161',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:84',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1271) 0:00:12.71',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '610',
                        IFNAME           => 'ae0.0',
                        IFDESCR          => 'ae0.0',
                        IFTYPE           => '161',
                        IFSPEED          => '2000000000',
                        IFMTU            => '1514',
                        MAC              => '5c:5e:ab:6a:2a:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4324) 0:00:43.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '366673242',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '611',
                        IFNAME           => 'vlan.1114',
                        IFDESCR          => 'vlan.1114',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '172.21.10.252',
                        MAC              => '5c:5e:ab:6a:2a:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4327) 0:00:43.27',
                        IFINOCTETS       => '707041490',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '144426',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '612',
                        IFNAME           => 'vlan.1116',
                        IFDESCR          => 'vlan.1116',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '172.21.12.252',
                        MAC              => '5c:5e:ab:6a:2a:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4331) 0:00:43.31',
                        IFINOCTETS       => '1872',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '325004856',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'juniper/ex3200.03.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Juniper',
            MODEL        => 'EX3200-24t',
            DESCRIPTION  => 'Juniper Networks, Inc. ex3200-48p internet router, kernel JUNOS 10.4R2.6 #0: 2011-02-06 23:48:13 UTC     builder@warth.juniper.net:/volume/build/junos/10.4/release/10.4R2.6/obj-powerpc/bsd/sys/compile/JUNIPER-EX Build date: 2011-02-06 23:17:05 UTC Copyri',

            SNMPHOSTNAME => 'jtc20-03',
            LOCATION     => 'repartiteur PMF 20eme',
            SERIAL       => 'BL0210129540',
            UPTIME       => '(690611103) 79 days, 22:21:51.03',
            MEMORY       => '0',
            MAC          => '2c:6b:f5:9a:7e:80',
            IPS          => {
                IP => [
                    '128.0.0.1',
                    '128.0.0.127',
                    '128.0.0.16',
                    '128.0.0.32',
                    '192.168.100.44',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Juniper',
                MODEL        => 'EX3200-24t',
                COMMENTS     => 'Juniper Networks, Inc. ex3200-48p internet router, kernel JUNOS 10.4R2.6 #0: 2011-02-06 23:48:13 UTC     builder@warth.juniper.net:/volume/build/junos/10.4/release/10.4R2.6/obj-powerpc/bsd/sys/compile/JUNIPER-EX Build date: 2011-02-06 23:17:05 UTC Copyri',
                NAME         => 'jtc20-03',
                LOCATION     => 'repartiteur PMF 20eme',
                SERIAL       => 'BL0210129540',
                UPTIME       => '(690611103) 79 days, 22:21:51.03',
                MEMORY       => '0',
                MAC          => '2c:6b:f5:9a:7e:80',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.100.44',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2161453172',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2161453172',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:ff',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => 'me0.0',
                        IFDESCR          => 'me0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '2c:6b:f5:9a:7e:ff',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4291428678',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3718526292',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '126',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(494) 0:00:04.94',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2034641916',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3894747062',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(494) 0:00:04.94',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '101494486',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '105772066',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:01:30:12:91:80',
                                    '00:01:30:12:a6:c0',
                                    '00:01:30:12:a6:d0',
                                    '00:01:30:12:a8:30',
                                    '00:01:30:fd:05:f0',
                                    '00:0b:60:b0:b0:1b',
                                    '00:0f:34:aa:ee:1b',
                                    '00:10:db:ff:10:02',
                                    '00:02:b3:31:fa:f9',
                                    '00:e0:86:11:1a:27',
                                    '00:e0:86:11:1d:b0',
                                    '00:e0:86:12:d9:6f',
                                    '00:1b:ec:00:04:09',
                                    '00:1d:09:68:40:c8',
                                    '00:1e:c9:da:3b:fc',
                                    '00:1e:c9:f2:c0:81',
                                    '00:1e:c9:f2:ca:8d',
                                    '00:1e:4f:1f:3c:44',
                                    '00:1e:4f:1f:57:4b',
                                    '00:1e:4f:31:a9:a0',
                                    '00:1e:4f:31:ab:88',
                                    '00:1e:4f:31:ab:ab',
                                    '00:1e:4f:32:e1:d3',
                                    '00:1e:4f:32:e4:69',
                                    '00:1e:4f:32:f7:9e',
                                    '00:1e:4f:33:14:d1',
                                    '00:1e:4f:33:07:e1',
                                    '00:1e:4f:41:d0:a4',
                                    '00:1e:4f:41:d8:69',
                                    '00:1e:4f:41:dc:7e',
                                    '00:1e:4f:41:dd:53',
                                    '00:1e:4f:41:e2:8c',
                                    '00:1e:4f:08:e5:ca',
                                    '00:1e:4f:08:e6:62',
                                    '00:20:4a:0b:24:06',
                                    '00:20:4a:b1:3d:da',
                                    '00:20:4a:08:72:d2',
                                    '00:20:4a:08:73:01',
                                    '00:20:4a:08:ac:f6',
                                    '00:20:4a:08:ac:56',
                                    '00:20:4a:08:e1:6d',
                                    '00:20:4a:08:60:c6',
                                    '00:22:19:7b:be:11',
                                    '00:22:19:7b:be:da',
                                    '00:22:19:7b:bf:e6',
                                    '00:22:19:85:d9:70',
                                    '00:22:19:63:0f:55',
                                    '00:23:ae:fb:fd:89',
                                    '00:23:ae:fb:fd:b0',
                                    '00:23:ae:fc:00:cd',
                                    '00:23:ae:fc:00:d3',
                                    '00:23:ae:fc:00:d8',
                                    '00:23:ae:fe:9c:e0',
                                    '00:23:ae:fe:a9:e0',
                                    '00:04:96:18:6e:93',
                                    '00:04:96:18:5b:61',
                                    '00:04:96:1c:6f:f0',
                                    '00:04:96:1c:71:00',
                                    '00:04:96:1f:8f:0f',
                                    '00:04:96:1f:91:50',
                                    '00:04:96:27:93:f9',
                                    '00:04:96:34:69:ab',
                                    '00:04:96:34:69:b1',
                                    '00:04:96:34:89:5c',
                                    '00:04:96:34:8b:82',
                                    '00:04:96:34:8b:f8',
                                    '00:04:96:34:8c:10',
                                    '00:04:96:34:8c:11',
                                    '00:04:96:34:92:82',
                                    '00:04:96:34:92:31',
                                    '00:04:96:34:92:47',
                                    '00:04:96:34:af:ae',
                                    '00:04:96:35:77:14',
                                    '00:04:96:35:77:16',
                                    '00:04:96:35:90:67',
                                    '00:04:96:35:90:4d',
                                    '00:04:96:35:93:b9',
                                    '00:04:96:35:ad:e4',
                                    '00:04:96:35:c8:14',
                                    '00:04:96:35:c8:1f',
                                    '00:04:96:35:fa:ae',
                                    '00:04:96:35:fa:b1',
                                    '00:04:96:08:1e:70',
                                    '00:05:1e:08:f8:20',
                                    '00:05:1e:08:f9:12',
                                    '00:05:1e:09:21:2d',
                                    '00:05:1e:09:21:50',
                                    '00:05:33:f4:d9:df',
                                    '00:05:33:43:78:2d',
                                    '00:05:33:54:16:aa',
                                    '00:50:56:bc:31:8a',
                                    '00:50:56:50:30:a0',
                                    '00:50:56:50:30:a2',
                                    '00:50:56:50:38:30',
                                    '00:50:56:50:38:32',
                                    '00:60:16:1e:64:79',
                                    '00:60:16:1e:68:23',
                                    '00:60:16:1e:56:f6',
                                    '00:60:16:1e:57:3d',
                                    '64:87:88:b7:a5:c1',
                                    '64:87:88:b7:b6:41',
                                    '64:b9:e8:c0:b7:04',
                                    '78:fe:3d:3f:84:00',
                                    '78:fe:3d:45:28:01',
                                    '84:18:88:a6:06:33',
                                    '84:2b:2b:71:30:f3',
                                    '10:8c:cf:cb:85:5d',
                                    '10:8c:cf:cb:9e:92',
                                    '10:8c:cf:cb:bc:71',
                                    'ac:4b:c8:22:b8:41',
                                    'ac:4b:c8:23:1d:81',
                                    'ac:4b:c8:23:4d:81',
                                    'b0:a8:6e:9a:39:41',
                                    '02:04:96:35:f9:24',
                                    'd0:d0:fd:ab:1a:b6',
                                    'd0:d0:fd:ac:ae:b6',
                                    'd0:57:4c:74:16:01',
                                    'd0:57:4c:86:cd:00',
                                    '18:03:73:0a:29:c2',
                                    '18:03:73:09:ae:8c',
                                    'f0:4d:a2:6e:cf:89',
                                    'f0:4d:a2:6e:d3:e6',
                                    'f0:4d:a2:6e:d4:96',
                                    'f0:4d:a2:6e:d4:1c',
                                    'f0:4d:a2:6f:03:39',
                                    'f0:4d:a2:6f:03:5b',
                                    'f0:4d:a2:d9:bc:3f',
                                    '28:c0:da:3e:36:6f',
                                    '2c:36:f8:4b:6a:4a',
                                    '2c:36:f8:4b:6b:4c',
                                    '58:35:d9:94:d3:1a',
                                    '5c:26:0a:a5:b9:93',
                                    '5c:5e:ab:65:4a:81',
                                    '5c:5e:ab:66:60:80',
                                    '5c:5e:ab:78:0e:80',
                                    '00:19:d1:79:ff:9d',
                                    '00:80:77:ec:d6:f9',
                                    '00:9c:02:07:8d:ed',
                                    '00:17:08:91:da:f1',
                                    '00:03:81:82:3e:45',
                                    '00:03:2d:1c:e3:8b',
                                    '00:03:2d:1c:e3:de',
                                    '00:03:2d:1c:e4:51',
                                    '00:1f:29:20:1e:5c',
                                    '00:1f:29:31:8f:02',
                                    '00:20:6b:7a:68:84',
                                    '00:20:6b:7a:88:78',
                                    '00:20:6b:7a:88:7b',
                                    '00:20:6b:7a:8a:e0',
                                    '00:20:6b:7a:d0:06',
                                    '00:20:6b:7a:d1:00',
                                    '00:20:6b:7a:d1:71',
                                    '00:20:6b:7a:d1:3c',
                                    '00:20:6b:7a:d2:76',
                                    '00:20:6b:7a:d2:9e',
                                    '00:20:6b:7a:d2:4b',
                                    '00:20:6b:7a:61:f1',
                                    '00:20:6b:7c:c3:24',
                                    '00:20:6b:7c:df:6b',
                                    '00:20:6b:7c:f8:09',
                                    '00:20:6b:7e:e5:a8',
                                    '00:20:4a:66:3e:02',
                                    '00:21:5a:8a:d9:79',
                                    '00:23:7d:70:d9:75',
                                    '00:23:7d:7d:e0:d6',
                                    '00:23:7d:7d:2c:4b',
                                    '00:23:7d:81:77:61',
                                    '00:23:7d:85:a4:41',
                                    '00:25:b3:ea:7d:11',
                                    '00:25:b3:ea:7d:ff',
                                    '00:25:b3:fa:d3:49',
                                    '00:04:00:b9:55:01',
                                    '00:04:00:2d:25:fd',
                                    '78:e3:b5:f7:f0:ca',
                                    '78:e7:d1:a3:1f:6f',
                                    'ac:16:2d:39:c4:3a',
                                    'c8:cb:b8:60:89:fb',
                                    'd4:85:64:1b:72:a1',
                                    'd4:85:64:1b:2e:9b',
                                    'd4:85:64:1f:4c:49',
                                    'd4:85:64:41:60:52',
                                    'f4:ce:46:3c:72:b6',
                                    '1c:6f:65:0b:cf:8d',
                                    '1c:c1:de:82:2a:e3',
                                    '1c:c1:de:82:3a:75',
                                    '1c:c1:de:83:7e:ab',
                                    '2c:76:8a:3f:b6:bf',
                                    '2c:76:8a:40:ff:fc',
                                    '00:1c:c0:8e:71:05',
                                    '00:1c:c0:ed:15:0b',
                                    '00:27:0e:01:2b:bd',
                                    '70:f3:95:1b:84:d8',
                                    '70:f3:95:1b:85:2b',
                                    '70:f3:95:1b:85:43',
                                    '70:f3:95:1b:86:16',
                                    '70:f3:95:1b:87:3b',
                                    '78:2b:cb:7e:64:f2',
                                    '84:2b:2b:9d:8a:ef',
                                    'a8:20:66:52:44:97',
                                    'cc:52:af:4a:5d:1f',
                                    'cc:52:af:4c:22:32',
                                    'cc:52:af:4c:27:69',
                                    'cc:52:af:4c:28:bf',
                                    '1c:6f:65:0b:cf:da',
                                    '1c:6f:65:0b:d0:02',
                                    '1c:6f:65:0e:51:6b',
                                    '3c:97:0e:46:7d:53',
                                    '3c:07:54:38:e0:33',
                                    '44:37:e6:bb:a4:4a',
                                    '44:37:e6:63:50:86',
                                    '00:13:d4:b8:17:a9',
                                    '00:15:c5:7b:ba:74',
                                    '00:1c:c0:90:d8:be',
                                    '00:1c:c0:5e:11:af',
                                    '00:1d:09:36:51:dd',
                                    '00:25:64:49:ce:3e',
                                    '10:78:d2:c3:e1:6b',
                                    'f0:4d:a2:bc:35:18',
                                    '1c:6f:65:00:cc:e3',
                                    '1c:6f:65:07:55:2d',
                                    '20:c9:d0:29:d8:21',
                                    '2c:41:38:02:a5:75',
                                    '3c:97:0e:54:44:37',
                                    '44:37:e6:62:27:35',
                                    '58:55:ca:25:35:d5',
                                    '00:13:20:32:81:47',
                                    '00:16:cb:ae:3d:f1',
                                    '00:e0:db:0c:ef:43',
                                    '00:1a:a0:ba:a1:2c',
                                    '00:1a:a0:ba:e1:35',
                                    '00:1a:a0:ba:e2:a6',
                                    '00:1c:c0:7f:3e:ca',
                                    '00:1c:c0:9b:30:e9',
                                    '00:1c:c0:9b:31:e2',
                                    '00:1c:c0:9b:58:fd',
                                    '00:1c:c0:e3:6f:13',
                                    '00:1e:4f:f4:2c:d6',
                                    '00:1e:4f:f4:2d:4a',
                                    '00:1e:4f:f4:31:2d',
                                    '00:1f:f3:fc:79:e8',
                                    '00:21:70:bf:28:64',
                                    '00:22:19:63:0f:4d',
                                    '00:23:32:2e:80:5d',
                                    '00:25:64:92:7d:88',
                                    '00:25:64:bd:f1:fb',
                                    '00:25:64:bd:f1:5f',
                                    '00:27:0e:02:f9:9d',
                                    '00:08:9b:80:83:38',
                                    '64:b9:e8:bc:71:c2',
                                    '84:2b:2b:ab:ef:b4',
                                    '84:2b:2b:bc:56:04',
                                    'a8:20:66:03:64:2c',
                                    'c4:2c:03:21:ca:b2',
                                    'cc:52:af:41:38:5e',
                                    'f8:d1:11:3d:56:1d',
                                    '1c:6f:65:0d:f0:52',
                                    '1c:6f:65:0e:4f:b9',
                                    '1c:6f:65:0e:4f:e2',
                                    '1c:6f:65:0e:50:e5',
                                    '1c:6f:65:0e:51:02',
                                    '1c:6f:65:0e:51:06',
                                    '3c:07:54:35:11:7a',
                                    '3c:07:54:35:22:51',
                                    '40:6c:8f:bb:d2:fa',
                                    '44:37:e6:6f:30:d8',
                                    '44:37:e6:87:65:e6',
                                    '44:37:e6:63:4c:f7',
                                    '5c:26:0a:12:2e:62',
                                    '5c:26:0a:2e:02:69',
                                    '00:19:d1:ae:3e:36',
                                    '00:19:d1:df:7f:3f',
                                    '00:26:b9:ed:20:53',
                                    '00:27:0e:01:25:4a',
                                    '70:f3:95:13:86:cc',
                                    '70:f3:95:1b:84:96',
                                    '70:f3:95:1b:85:37',
                                    '84:2b:2b:9d:8b:73',
                                    '84:2b:2b:9d:8c:20',
                                    '84:2b:2b:9d:8c:32',
                                    '84:2b:2b:a0:44:4e',
                                    '00:0c:29:86:0c:c0',
                                    '00:0c:29:94:f8:bc',
                                    '00:0c:29:b9:6d:7d',
                                    '00:0c:29:ca:32:91',
                                    '00:0c:29:2b:12:ce',
                                    '00:0c:29:56:6b:7a',
                                    '00:13:20:e4:0a:53',
                                    '00:17:08:87:8e:28',
                                    '00:19:d1:7a:5d:68',
                                    '00:19:d1:7a:5d:52',
                                    '00:19:d1:ae:27:a6',
                                    '00:19:d1:17:b0:2c',
                                    '00:1c:c0:7f:3c:67',
                                    '00:1c:c0:7f:3d:03',
                                    '00:1c:c0:8f:2b:f1',
                                    '00:1c:c0:8f:44:f4',
                                    '00:1c:c0:8f:45:0c',
                                    '00:1c:c0:8f:46:67',
                                    '00:1c:c0:8f:46:69',
                                    '00:1c:c0:8f:46:74',
                                    '00:1c:c0:8f:46:75',
                                    '00:1c:c0:8f:46:14',
                                    '00:1c:c0:ed:15:0d',
                                    '00:1c:c0:ed:15:8c',
                                    '00:1c:c0:f0:88:19',
                                    '00:1c:c0:f1:f7:ae',
                                    '00:1c:c0:f8:1d:a7',
                                    '00:1c:c0:f8:1d:c6',
                                    '00:1c:c0:1b:04:a3',
                                    '00:1e:4f:c0:59:04',
                                    '00:1e:4f:32:ea:9a',
                                    '00:23:ae:92:f7:90',
                                    '00:23:ae:93:2d:65',
                                    '00:23:ae:93:2d:e6',
                                    '00:25:64:94:49:b1',
                                    '00:25:64:bd:f1:a0',
                                    '00:27:0e:00:9a:d2',
                                    '00:27:0e:01:25:67',
                                    '00:27:0e:01:25:75',
                                    '00:27:0e:01:25:7a',
                                    '00:27:0e:01:25:84',
                                    '00:27:0e:01:28:5a',
                                    '00:27:0e:01:29:2d',
                                    '00:27:0e:02:64:91',
                                    '00:27:0e:02:56:0d',
                                    '00:27:0e:02:56:22',
                                    '00:27:0e:02:56:40',
                                    '00:27:0e:02:56:57',
                                    '00:50:56:bc:00:48',
                                    '00:50:56:bc:31:89',
                                    '00:50:56:50:30:b8',
                                    '00:50:56:50:30:ba',
                                    '00:50:56:51:4d:58',
                                    '00:50:56:51:4d:5a',
                                    '70:f3:95:13:d5:a2',
                                    '70:f3:95:13:d6:54',
                                    '70:f3:95:19:1c:47',
                                    '70:f3:95:19:2a:3a',
                                    '84:2b:2b:9d:8a:df',
                                    '84:2b:2b:ad:56:26',
                                    '10:78:d2:c3:df:fc',
                                    'ac:16:2d:37:1b:c0',
                                    'cc:52:af:41:26:63',
                                    'cc:52:af:41:34:5f',
                                    'f0:4d:a2:0e:72:20',
                                    'f0:4d:a2:0e:2c:5f',
                                    '1c:6f:65:0b:cc:d9',
                                    '1c:6f:65:0d:ed:6c',
                                    '1c:6f:65:0d:f0:06',
                                    '1c:6f:65:0d:f8:10',
                                    '1c:6f:65:0d:fc:b2',
                                    '1c:6f:65:0e:90:4d',
                                    '1c:6f:65:0f:e1:2e',
                                    '1c:6f:65:09:57:46',
                                    '2c:36:f8:4b:6f:3f',
                                    '44:37:e6:62:26:f7',
                                    '44:37:e6:63:4c:e1',
                                    '44:37:e6:63:4c:e9',
                                    '44:37:e6:63:4c:eb',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:81',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(665916869) 77 days, 1:46:08.69',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3013356695',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2048911018',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:8a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(399) 0:00:03.99',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:8b',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/12',
                        IFDESCR          => 'ge-0/0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:8c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(689446000) 79 days, 19:07:40.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1571184393',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1999701488',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/13',
                        IFDESCR          => 'ge-0/0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:8d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690118870) 79 days, 20:59:48.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1444043283',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '932766504',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/14',
                        IFDESCR          => 'ge-0/0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:8e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(406) 0:00:04.06',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/15',
                        IFDESCR          => 'ge-0/0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:8f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(680552839) 78 days, 18:25:28.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '473789460',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3632242426',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/16',
                        IFDESCR          => 'ge-0/0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:90',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(682689929) 79 days, 0:21:39.29',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2486916912',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2403893481',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/17',
                        IFDESCR          => 'ge-0/0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:91',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(77140369) 8 days, 22:16:43.69',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '108183',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '384425',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/18',
                        IFDESCR          => 'ge-0/0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:92',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(327809860) 37 days, 22:34:58.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1778337716',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1325429110',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/19',
                        IFDESCR          => 'ge-0/0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:93',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(339) 0:00:03.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:82',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(424349950) 49 days, 2:44:59.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1902005570',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1584758679',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/20',
                        IFDESCR          => 'ge-0/0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:94',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(340) 0:00:03.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/21',
                        IFDESCR          => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:95',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690152520) 79 days, 21:05:25.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1206753935',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4210758575',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/22',
                        IFDESCR          => 'ge-0/0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:96',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(671751825) 77 days, 17:58:38.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '215929658',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2000058785',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/23',
                        IFDESCR          => 'ge-0/0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:97',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690069390) 79 days, 20:51:33.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '188865545',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3090429957',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/24',
                        IFDESCR          => 'ge-0/0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:98',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(409) 0:00:04.09',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/25',
                        IFDESCR          => 'ge-0/0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:99',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(411) 0:00:04.11',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/26',
                        IFDESCR          => 'ge-0/0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:9a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(414) 0:00:04.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/27',
                        IFDESCR          => 'ge-0/0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:9b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(654852400) 75 days, 19:02:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3287311125',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3349027873',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/28',
                        IFDESCR          => 'ge-0/0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:9c',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(682860119) 79 days, 0:50:01.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '762667247',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1750605592',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/29',
                        IFDESCR          => 'ge-0/0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:9d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(425) 0:00:04.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:83',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690200000) 79 days, 21:13:20.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3546212557',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3594306636',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/30',
                        IFDESCR          => 'ge-0/0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:9e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(681550555) 78 days, 21:11:45.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '136129037',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1849272137',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/31',
                        IFDESCR          => 'ge-0/0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:9f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690560437) 79 days, 22:13:24.37',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '93466915',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '201306124',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/0/32',
                        IFDESCR          => 'ge-0/0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(386) 0:00:03.86',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/0/33',
                        IFDESCR          => 'ge-0/0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(387) 0:00:03.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/0/34',
                        IFDESCR          => 'ge-0/0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(59567179) 6 days, 21:27:51.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '53211885',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '539220717',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/0/35',
                        IFDESCR          => 'ge-0/0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a3',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690486680) 79 days, 22:01:06.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '118822572',
                        IFINERRORS       => '102',
                        IFOUTOCTETS      => '2447844600',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'ge-0/0/36',
                        IFDESCR          => 'ge-0/0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(208327439) 24 days, 2:41:14.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '8076917',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '438379336',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '533',
                        IFNAME           => 'ge-0/0/37',
                        IFDESCR          => 'ge-0/0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(533708490) 61 days, 18:31:24.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2685287865',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3049509646',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '534',
                        IFNAME           => 'ge-0/0/38',
                        IFDESCR          => 'ge-0/0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(682821860) 79 days, 0:43:38.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1241053012',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3840965297',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '535',
                        IFNAME           => 'ge-0/0/39',
                        IFDESCR          => 'ge-0/0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690387400) 79 days, 21:44:34.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1030838465',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4181007764',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '536',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:84',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(672589500) 77 days, 20:18:15.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '354731055',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3768060268',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '537',
                        IFNAME           => 'ge-0/0/40',
                        IFDESCR          => 'ge-0/0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(689500550) 79 days, 19:16:45.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1165890653',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2069283093',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '538',
                        IFNAME           => 'ge-0/0/41',
                        IFDESCR          => 'ge-0/0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(148050739) 17 days, 3:15:07.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '81453084',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1543143617',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '539',
                        IFNAME           => 'ge-0/0/42',
                        IFDESCR          => 'ge-0/0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:aa',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(682354629) 78 days, 23:25:46.29',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1552651383',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2351683718',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '540',
                        IFNAME           => 'ge-0/0/43',
                        IFDESCR          => 'ge-0/0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:ab',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(595918169) 68 days, 23:19:41.69',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '829983992',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3925839742',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '541',
                        IFNAME           => 'ge-0/0/44',
                        IFDESCR          => 'ge-0/0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:ac',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690512280) 79 days, 22:05:22.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1704785039',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2373360839',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '542',
                        IFNAME           => 'ge-0/0/45',
                        IFDESCR          => 'ge-0/0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:ad',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(672157520) 77 days, 19:06:15.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1721208124',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3695657617',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '543',
                        IFNAME           => 'ge-0/0/46',
                        IFDESCR          => 'ge-0/0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:ae',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(595611380) 68 days, 22:28:33.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1256689629',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '740549357',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '544',
                        IFNAME           => 'ge-0/0/47',
                        IFDESCR          => 'ge-0/0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:af',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(595611051) 68 days, 22:28:30.51',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2956582641',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '348225454',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '545',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:85',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(683883700) 79 days, 3:40:37.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '894824395',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3675464067',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '546',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:86',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(681483205) 78 days, 21:00:32.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2506833587',
                        IFINERRORS       => '4',
                        IFOUTOCTETS      => '2081076951',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '547',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:87',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(394) 0:00:03.94',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '548',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:88',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1166) 0:00:11.66',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2234030194',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2009640690',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '549',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:89',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(683567821) 79 days, 2:47:58.21',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1130591759',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1128824234',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '550',
                        IFNAME           => 'vlan',
                        IFDESCR          => 'vlan',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '2c:6b:f5:9a:7e:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(245) 0:00:02.45',
                        IFINOCTETS       => '1805109523',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '30471514',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '553',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:81',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(665916869) 77 days, 1:46:08.69',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5857',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '416395996',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '554',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:8a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '555',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:8b',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(401) 0:00:04.01',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '556',
                        IFNAME           => 'ge-0/0/12.0',
                        IFDESCR          => 'ge-0/0/12.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:8c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(689446000) 79 days, 19:07:40.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2214652',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '69695210',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:26:b9:02:f8:16',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '557',
                        IFNAME           => 'ge-0/0/13.0',
                        IFDESCR          => 'ge-0/0/13.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:8d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690118870) 79 days, 20:59:48.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1047225',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '72149489',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:19:d1:ae:24:94',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '558',
                        IFNAME           => 'ge-0/0/14.0',
                        IFDESCR          => 'ge-0/0/14.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:8e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(407) 0:00:04.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '559',
                        IFNAME           => 'ge-0/0/15.0',
                        IFDESCR          => 'ge-0/0/15.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:8f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(680552839) 78 days, 18:25:28.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1447979',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '15965923',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '560',
                        IFNAME           => 'ge-0/0/16.0',
                        IFDESCR          => 'ge-0/0/16.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:90',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(682689929) 79 days, 0:21:39.29',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1618691',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '442853532',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '561',
                        IFNAME           => 'ge-0/0/17.0',
                        IFDESCR          => 'ge-0/0/17.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:91',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(77140369) 8 days, 22:16:43.69',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '22941',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '23702',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '562',
                        IFNAME           => 'ge-0/0/18.0',
                        IFDESCR          => 'ge-0/0/18.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:92',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(327809860) 37 days, 22:34:58.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '223721',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '441314897',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:27:0e:02:d5:23',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '563',
                        IFNAME           => 'ge-0/0/19.0',
                        IFDESCR          => 'ge-0/0/19.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:93',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(662) 0:00:06.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '564',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:82',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(424349950) 49 days, 2:44:59.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '469097',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '446847194',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1f:29:1e:42:1b',
                                    '00:27:0e:02:d5:73',
                                    '00:27:0e:02:d5:ee',
                                    '00:27:0e:02:ec:f3',
                                    '00:27:0e:02:f9:73',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '565',
                        IFNAME           => 'ge-0/0/20.0',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:94',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(687) 0:00:06.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '566',
                        IFNAME           => 'ge-0/0/21.0',
                        IFDESCR          => 'ge-0/0/21.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:95',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690152520) 79 days, 21:05:25.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '173239',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '447475036',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'cc:52:af:41:34:21',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '567',
                        IFNAME           => 'ge-0/0/22.0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:96',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(671751825) 77 days, 17:58:38.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '350154',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '79929851',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '568',
                        IFNAME           => 'ge-0/0/23.0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:97',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690069390) 79 days, 20:51:33.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '44505',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '447678496',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'cc:52:af:41:34:ea',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '569',
                        IFNAME           => 'ge-0/0/24.0',
                        IFDESCR          => 'ge-0/0/24.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:98',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(410) 0:00:04.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '570',
                        IFNAME           => 'ge-0/0/25.0',
                        IFDESCR          => 'ge-0/0/25.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:99',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(413) 0:00:04.13',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '571',
                        IFNAME           => 'ge-0/0/26.0',
                        IFDESCR          => 'ge-0/0/26.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:9a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(416) 0:00:04.16',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '572',
                        IFNAME           => 'ge-0/0/27.0',
                        IFDESCR          => 'ge-0/0/27.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:9b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(654852400) 75 days, 19:02:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '10178',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '448228334',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1a:1e:c5:a7:4a',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '573',
                        IFNAME           => 'ge-0/0/28.0',
                        IFDESCR          => 'ge-0/0/28.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:9c',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(682860119) 79 days, 0:50:01.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2685687',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '16975010',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '574',
                        IFNAME           => 'ge-0/0/29.0',
                        IFDESCR          => 'ge-0/0/29.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:9d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(426) 0:00:04.26',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '575',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:83',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690200000) 79 days, 21:13:20.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2303780',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '256970338',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:26:b9:ed:1f:71',
                                    'd4:3d:7e:1f:c4:2a',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '576',
                        IFNAME           => 'ge-0/0/30.0',
                        IFDESCR          => 'ge-0/0/30.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:9e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(681550555) 78 days, 21:11:45.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '24694',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '385335962',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '577',
                        IFNAME           => 'ge-0/0/31.0',
                        IFDESCR          => 'ge-0/0/31.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:9f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690560437) 79 days, 22:13:24.37',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '50282',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3882652',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '578',
                        IFNAME           => 'ge-0/0/32.0',
                        IFDESCR          => 'ge-0/0/32.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a0',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(643) 0:00:06.43',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '579',
                        IFNAME           => 'ge-0/0/33.0',
                        IFDESCR          => 'ge-0/0/33.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a1',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(665) 0:00:06.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '580',
                        IFNAME           => 'ge-0/0/34.0',
                        IFDESCR          => 'ge-0/0/34.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a2',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(59567179) 6 days, 21:27:51.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '147975',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '7302800',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '581',
                        IFNAME           => 'ge-0/0/35.0',
                        IFDESCR          => 'ge-0/0/35.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a3',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690486680) 79 days, 22:01:06.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '137977',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '447041540',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '582',
                        IFNAME           => 'ge-0/0/36.0',
                        IFDESCR          => 'ge-0/0/36.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a4',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(208327439) 24 days, 2:41:14.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '156339',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '93089646',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '583',
                        IFNAME           => 'ge-0/0/37.0',
                        IFDESCR          => 'ge-0/0/37.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(533708490) 61 days, 18:31:24.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3263553',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '279079429',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1c:c0:ee:80:4b',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '584',
                        IFNAME           => 'ge-0/0/38.0',
                        IFDESCR          => 'ge-0/0/38.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(682821860) 79 days, 0:43:38.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1911627',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '447293405',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:14:38:5a:1d:d0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '585',
                        IFNAME           => 'ge-0/0/39.0',
                        IFDESCR          => 'ge-0/0/39.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690387400) 79 days, 21:44:34.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3365162',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '83617872',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '5c:26:0a:63:7c:f2',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '586',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:84',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(672589500) 77 days, 20:18:15.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '439264',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '447533137',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '587',
                        IFNAME           => 'ge-0/0/40.0',
                        IFDESCR          => 'ge-0/0/40.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(689500550) 79 days, 19:16:45.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '11338164',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '81215246',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '24:b6:fd:18:21:f4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '588',
                        IFNAME           => 'ge-0/0/41.0',
                        IFDESCR          => 'ge-0/0/41.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:a9',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(148050739) 17 days, 3:15:07.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '215806',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2041083',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '589',
                        IFNAME           => 'ge-0/0/42.0',
                        IFDESCR          => 'ge-0/0/42.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:aa',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(682354629) 78 days, 23:25:46.29',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '76619276',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '442621726',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '590',
                        IFNAME           => 'ge-0/0/43.0',
                        IFDESCR          => 'ge-0/0/43.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:ab',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(595918169) 68 days, 23:19:41.69',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3425509',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '49542723',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '591',
                        IFNAME           => 'ge-0/0/44.0',
                        IFDESCR          => 'ge-0/0/44.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:ac',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(690512280) 79 days, 22:05:22.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4537101',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '102760044',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:26:b9:05:c3:7a',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '592',
                        IFNAME           => 'ge-0/0/45.0',
                        IFDESCR          => 'ge-0/0/45.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:ad',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(672157520) 77 days, 19:06:15.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '76592',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '354018094',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '593',
                        IFNAME           => 'ge-0/0/46.0',
                        IFDESCR          => 'ge-0/0/46.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:ae',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(595611380) 68 days, 22:28:33.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '952616',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '61630220',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:26:b0:e8:dd:1e',
                                    'cc:52:af:41:25:f2',
                                    '44:37:e6:87:63:68',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '594',
                        IFNAME           => 'ge-0/0/47.0',
                        IFDESCR          => 'ge-0/0/47.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:af',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(595611051) 68 days, 22:28:30.51',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4911565',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '285952935',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '595',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:85',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(683883700) 79 days, 3:40:37.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2655317',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '447689671',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '596',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:86',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(681483205) 78 days, 21:00:32.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '340907',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '88449606',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '597',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:87',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(395) 0:00:03.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '598',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:88',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1166) 0:00:11.66',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '8463015',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '447755052',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '40:6c:8f:49:66:30',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '599',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9a:7e:89',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(683567821) 79 days, 2:47:58.21',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2799490',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '46465074',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '602',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.100.44',
                        MAC              => '2c:6b:f5:9a:7e:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(497) 0:00:04.97',
                        IFINOCTETS       => '1805113747',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '28643566',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '603',
                        IFNAME           => 'jsrv',
                        IFDESCR          => 'jsrv',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '2c:6b:f5:9a:7e:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '604',
                        IFNAME           => 'jsrv.1',
                        IFDESCR          => 'jsrv.1',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '128.0.0.127',
                        MAC              => '2c:6b:f5:9a:7e:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'juniper/ex4200.01.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Juniper',
            MODEL        => 'EX4200-24t',
            DESCRIPTION  => 'Juniper Networks, Inc. ex4200-48p internet router, kernel JUNOS 10.4R3.4 #0: 2011-03-19 22:06:32 UTC     builder@warth.juniper.net:/volume/build/junos/10.4/release/10.4R3.4/obj-powerpc/bsd/sys/compile/JUNIPER-EX Build date: 2011-03-19 21:51:24 UTC Copyri',

            SNMPHOSTNAME => 'jte4-01',
            LOCATION     => 'Salle informatique E4 PMF',
            SERIAL       => 'BQ0210122093',
            UPTIME       => '(1579491875) 182 days, 19:28:38.75',
            MEMORY       => '0',
            MAC          => '2c:6b:f5:9b:48:80',
            IPS          => {
                IP => [
                    '128.0.0.1',
                    '128.0.0.127',
                    '128.0.0.16',
                    '128.0.0.32',
                    '192.168.100.31',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Juniper',
                MODEL        => 'EX4200-24t',
                COMMENTS     => 'Juniper Networks, Inc. ex4200-48p internet router, kernel JUNOS 10.4R3.4 #0: 2011-03-19 22:06:32 UTC     builder@warth.juniper.net:/volume/build/junos/10.4/release/10.4R3.4/obj-powerpc/bsd/sys/compile/JUNIPER-EX Build date: 2011-03-19 21:51:24 UTC Copyri',
                NAME         => 'jte4-01',
                LOCATION     => 'Salle informatique E4 PMF',
                SERIAL       => 'BQ0210122093',
                UPTIME       => '(1579491875) 182 days, 19:28:38.75',
                MEMORY       => '0',
                MAC          => '2c:6b:f5:9b:48:80',
                IPS          => {
                    IP => [
                        '128.0.0.1',
                        '128.0.0.127',
                        '128.0.0.16',
                        '128.0.0.32',
                        '192.168.100.31',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'lsi',
                        IFDESCR          => 'lsi',
                        IFTYPE           => '150',
                        IFSPEED          => '0',
                        IFMTU            => '1496',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'dsc',
                        IFDESCR          => 'dsc',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5840) 0:00:58.40',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5842) 0:00:58.42',
                        IFINOCTETS       => '628200578',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '630161982',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'tap',
                        IFDESCR          => 'tap',
                        IFTYPE           => '1',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5845) 0:00:58.45',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'gre',
                        IFDESCR          => 'gre',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5840) 0:00:58.40',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'ipip',
                        IFDESCR          => 'ipip',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5841) 0:00:58.41',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'pime',
                        IFDESCR          => 'pime',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5844) 0:00:58.44',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'pimd',
                        IFDESCR          => 'pimd',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5844) 0:00:58.44',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'mtun',
                        IFDESCR          => 'mtun',
                        IFTYPE           => '131',
                        IFSPEED          => '0',
                        IFMTU            => '2147483647',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'me0',
                        IFDESCR          => 'me0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:81',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => 'me0.0',
                        IFDESCR          => 'me0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:81',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1634) 0:00:16.34',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => 'vme',
                        IFDESCR          => 'vme',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '2c:6b:f5:9b:48:81',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'bme0',
                        IFDESCR          => 'bme0',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3190556671',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'bme0.32768',
                        IFDESCR          => 'bme0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1562',
                        IP               => '128.0.0.32',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1267757312',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2909561371',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => 'bme0.32770',
                        IFDESCR          => 'bme0.32770',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(717450037) 83 days, 0:55:00.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => 'bme0.32771',
                        IFDESCR          => 'bme0.32771',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(889645996) 102 days, 23:14:19.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => 'bme0.32772',
                        IFDESCR          => 'bme0.32772',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(889646000) 102 days, 23:14:20.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => 'bme0.32773',
                        IFDESCR          => 'bme0.32773',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1071466411) 124 days, 0:17:44.11',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => 'bme0.32774',
                        IFDESCR          => 'bme0.32774',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1576',
                        MAC              => '00:0b:ca:fe:00:00',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(1071466415) 124 days, 0:17:44.15',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '49',
                        IFNAME           => 'vcp-0',
                        IFDESCR          => 'vcp-0',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1514',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(717449455) 83 days, 0:54:54.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '50',
                        IFNAME           => 'vcp-0.32768',
                        IFDESCR          => 'vcp-0.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '4294967295',
                        IFMTU            => '0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(717449455) 83 days, 0:54:54.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '51',
                        IFNAME           => 'vcp-1',
                        IFDESCR          => 'vcp-1',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1514',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(717449456) 83 days, 0:54:54.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '52',
                        IFNAME           => 'vcp-1.32768',
                        IFDESCR          => 'vcp-1.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '4294967295',
                        IFMTU            => '0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(717449456) 83 days, 0:54:54.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '105',
                        IFNAME           => 'vcp-255/1/2',
                        IFDESCR          => 'vcp-255/1/2',
                        IFTYPE           => '1',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1514',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(889641113) 102 days, 23:13:31.13',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '106',
                        IFNAME           => 'vcp-255/1/2.32768',
                        IFDESCR          => 'vcp-255/1/2.32768',
                        IFTYPE           => '53',
                        IFSPEED          => '4294967295',
                        IFMTU            => '0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(889641113) 102 days, 23:13:31.13',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '501',
                        IFNAME           => 'jsrv',
                        IFDESCR          => 'jsrv',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1518',
                        MAC              => '2c:6b:f5:9b:05:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(665) 0:00:06.65',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '502',
                        IFNAME           => 'ge-0/0/0',
                        IFDESCR          => 'ge-0/0/0',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:81',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2877542534',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1218507182',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '503',
                        IFNAME           => 'ge-0/0/0.0',
                        IFDESCR          => 'ge-0/0/0.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:81',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '173229412',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '173363747',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFNUMBER => '502',
                                IFDESCR  => 'ge-0/0/0.0',
                                SYSNAME  => 'jte4-02',
                                SYSDESCR => 'Juniper Networks, Inc. ex3200-48p , version 10.3R1.9 Build date: 2010-08-13 12:56:38 UTC ',
                                SYSMAC   => '2c:6b:f5:99:7c:00',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '504',
                        IFNAME           => 'ge-0/0/1',
                        IFDESCR          => 'ge-0/0/1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:81',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '505',
                        IFNAME           => 'ge-0/0/1.0',
                        IFDESCR          => 'ge-0/0/1.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:81',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '506',
                        IFNAME           => 'ge-0/0/2',
                        IFDESCR          => 'ge-0/0/2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:82',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1501251026) 173 days, 18:08:30.26',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '329254826',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4242153267',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '507',
                        IFNAME           => 'ge-0/0/2.0',
                        IFDESCR          => 'ge-0/0/2.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:82',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1501251026) 173 days, 18:08:30.26',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '766023',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '13561778',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '508',
                        IFNAME           => 'ge-0/0/3',
                        IFDESCR          => 'ge-0/0/3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:83',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1485512394) 171 days, 22:25:23.94',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3333121183',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '846561719',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '509',
                        IFNAME           => 'ge-0/0/3.0',
                        IFDESCR          => 'ge-0/0/3.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:83',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1485512394) 171 days, 22:25:23.94',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '31352',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '667472987',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:50:60:05:61:43',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '510',
                        IFNAME           => 'ge-0/0/4',
                        IFDESCR          => 'ge-0/0/4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:84',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1547843164) 179 days, 3:33:51.64',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2623698044',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4057307380',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '511',
                        IFNAME           => 'ge-0/0/4.0',
                        IFDESCR          => 'ge-0/0/4.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:84',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1547843164) 179 days, 3:33:51.64',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2085494',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '40748111',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '512',
                        IFNAME           => 'ge-0/0/5',
                        IFDESCR          => 'ge-0/0/5',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:85',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '513',
                        IFNAME           => 'ge-0/0/5.0',
                        IFDESCR          => 'ge-0/0/5.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:85',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '514',
                        IFNAME           => 'ge-0/0/6',
                        IFDESCR          => 'ge-0/0/6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:86',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(250446944) 28 days, 23:41:09.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '620574',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '10228408',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '515',
                        IFNAME           => 'ge-0/0/6.0',
                        IFDESCR          => 'ge-0/0/6.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:86',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(250446944) 28 days, 23:41:09.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '75363',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '384364',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '516',
                        IFNAME           => 'ge-0/0/7',
                        IFDESCR          => 'ge-0/0/7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:87',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(251603028) 29 days, 2:53:50.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '12346184',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '67868236',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '517',
                        IFNAME           => 'ge-0/0/7.0',
                        IFDESCR          => 'ge-0/0/7.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:87',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(251603028) 29 days, 2:53:50.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '50345',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1308607',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '518',
                        IFNAME           => 'ge-0/0/8',
                        IFDESCR          => 'ge-0/0/8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:88',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1578982254) 182 days, 18:03:42.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2086798177',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '865615864',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '519',
                        IFNAME           => 'ge-0/0/8.0',
                        IFDESCR          => 'ge-0/0/8.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:88',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1578982254) 182 days, 18:03:42.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5801536',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '576687990',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'cc:52:af:4a:4b:98',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '520',
                        IFNAME           => 'ge-0/0/9',
                        IFDESCR          => 'ge-0/0/9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:89',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '521',
                        IFNAME           => 'ge-0/0/9.0',
                        IFDESCR          => 'ge-0/0/9.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:89',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '522',
                        IFNAME           => 'ge-0/0/10',
                        IFDESCR          => 'ge-0/0/10',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:8a',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '523',
                        IFNAME           => 'ge-0/0/10.0',
                        IFDESCR          => 'ge-0/0/10.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:8a',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '524',
                        IFNAME           => 'ge-0/0/11',
                        IFDESCR          => 'ge-0/0/11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:8b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1424310274) 164 days, 20:25:02.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '245249012',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2689590785',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '525',
                        IFNAME           => 'ge-0/0/11.0',
                        IFDESCR          => 'ge-0/0/11.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:8b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1424310274) 164 days, 20:25:02.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3345796',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1022331172',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:14:38:db:4a:fb',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '526',
                        IFNAME           => 'ge-0/0/12',
                        IFDESCR          => 'ge-0/0/12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:8c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1441359724) 166 days, 19:46:37.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1891728511',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6496905',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '527',
                        IFNAME           => 'ge-0/0/12.0',
                        IFDESCR          => 'ge-0/0/12.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:8c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1441359724) 166 days, 19:46:37.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '7133205',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1022495546',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:20:6b:7a:d0:12',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '528',
                        IFNAME           => 'ge-0/0/13',
                        IFDESCR          => 'ge-0/0/13',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:8d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '529',
                        IFNAME           => 'ge-0/0/13.0',
                        IFDESCR          => 'ge-0/0/13.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:8d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '530',
                        IFNAME           => 'ge-0/0/14',
                        IFDESCR          => 'ge-0/0/14',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:8e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '531',
                        IFNAME           => 'ge-0/0/14.0',
                        IFDESCR          => 'ge-0/0/14.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:8e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '532',
                        IFNAME           => 'ge-0/0/15',
                        IFDESCR          => 'ge-0/0/15',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:8f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1578486224) 182 days, 16:41:02.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2031804275',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3490600419',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '533',
                        IFNAME           => 'ge-0/0/15.0',
                        IFDESCR          => 'ge-0/0/15.0',
                        IFTYPE           => '53',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:8f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1578486224) 182 days, 16:41:02.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5712789',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '723121448',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '70:f3:95:19:32:39',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '534',
                        IFNAME           => 'ge-0/0/16',
                        IFDESCR          => 'ge-0/0/16',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:90',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '535',
                        IFNAME           => 'ge-0/0/16.0',
                        IFDESCR          => 'ge-0/0/16.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:90',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '536',
                        IFNAME           => 'ge-0/0/17',
                        IFDESCR          => 'ge-0/0/17',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:91',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1544196424) 178 days, 17:26:04.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '514989432',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2004357564',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '537',
                        IFNAME           => 'ge-0/0/17.0',
                        IFDESCR          => 'ge-0/0/17.0',
                        IFTYPE           => '53',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:91',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1544196424) 178 days, 17:26:04.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '12390212',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1024363386',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '70:f3:95:1b:84:bc',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '538',
                        IFNAME           => 'ge-0/0/18',
                        IFDESCR          => 'ge-0/0/18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:92',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(958677754) 110 days, 22:59:37.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1493202',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '559200749',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '539',
                        IFNAME           => 'ge-0/0/18.0',
                        IFDESCR          => 'ge-0/0/18.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:92',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(958677754) 110 days, 22:59:37.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '435817132',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '540',
                        IFNAME           => 'ge-0/0/19',
                        IFDESCR          => 'ge-0/0/19',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:93',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '541',
                        IFNAME           => 'ge-0/0/19.0',
                        IFDESCR          => 'ge-0/0/19.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:93',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '542',
                        IFNAME           => 'ge-0/0/20',
                        IFDESCR          => 'ge-0/0/20',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:94',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1578927064) 182 days, 17:54:30.64',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '951730651',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3733951690',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '543',
                        IFNAME           => 'ge-0/0/20.0',
                        IFDESCR          => 'ge-0/0/20.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:94',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1578927064) 182 days, 17:54:30.64',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2249453',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '952648962',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '70:f3:95:19:29:db',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '544',
                        IFNAME           => 'ge-0/0/21',
                        IFDESCR          => 'ge-0/0/21',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:95',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1578418614) 182 days, 16:29:46.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '630699913',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4030961043',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '545',
                        IFNAME           => 'ge-0/0/21.0',
                        IFDESCR          => 'ge-0/0/21.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:95',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1578418614) 182 days, 16:29:46.14',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '114948',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '151247500',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:19:d1:79:ac:5b',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '546',
                        IFNAME           => 'ge-0/0/22',
                        IFDESCR          => 'ge-0/0/22',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:96',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '547',
                        IFNAME           => 'ge-0/0/22.0',
                        IFDESCR          => 'ge-0/0/22.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:96',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '548',
                        IFNAME           => 'ge-0/0/23',
                        IFDESCR          => 'ge-0/0/23',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:97',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '549',
                        IFNAME           => 'ge-0/0/23.0',
                        IFDESCR          => 'ge-0/0/23.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:97',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '550',
                        IFNAME           => 'ge-0/0/24',
                        IFDESCR          => 'ge-0/0/24',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:98',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '551',
                        IFNAME           => 'ge-0/0/24.0',
                        IFDESCR          => 'ge-0/0/24.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:98',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '552',
                        IFNAME           => 'ge-0/0/25',
                        IFDESCR          => 'ge-0/0/25',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:99',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '553',
                        IFNAME           => 'ge-0/0/25.0',
                        IFDESCR          => 'ge-0/0/25.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:99',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '554',
                        IFNAME           => 'ge-0/0/26',
                        IFDESCR          => 'ge-0/0/26',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:9a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1579124494) 182 days, 18:27:24.94',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2253413489',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '580268911',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '555',
                        IFNAME           => 'ge-0/0/26.0',
                        IFDESCR          => 'ge-0/0/26.0',
                        IFTYPE           => '53',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:9a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1579124494) 182 days, 18:27:24.94',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3686909',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '263400955',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:19:d1:01:98:ae',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '556',
                        IFNAME           => 'ge-0/0/27',
                        IFDESCR          => 'ge-0/0/27',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:9b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1579123944) 182 days, 18:27:19.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3044249961',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3810217102',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '557',
                        IFNAME           => 'ge-0/0/27.0',
                        IFDESCR          => 'ge-0/0/27.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:9b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1579123944) 182 days, 18:27:19.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '13839122',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '206015125',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '70:f3:95:1b:87:3d',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '558',
                        IFNAME           => 'ge-0/0/28',
                        IFDESCR          => 'ge-0/0/28',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:9c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1570984464) 181 days, 19:50:44.64',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '285662439',
                        IFINERRORS       => '10',
                        IFOUTOCTETS      => '3058559542',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '559',
                        IFNAME           => 'ge-0/0/28.0',
                        IFDESCR          => 'ge-0/0/28.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:9c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1570984464) 181 days, 19:50:44.64',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '25800',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '201670561',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1c:c0:5d:56:5f',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '560',
                        IFNAME           => 'ge-0/0/29',
                        IFDESCR          => 'ge-0/0/29',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:9d',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '561',
                        IFNAME           => 'ge-0/0/29.0',
                        IFDESCR          => 'ge-0/0/29.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:9d',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '562',
                        IFNAME           => 'ge-0/0/30',
                        IFDESCR          => 'ge-0/0/30',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:9e',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '563',
                        IFNAME           => 'ge-0/0/30.0',
                        IFDESCR          => 'ge-0/0/30.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:9e',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '564',
                        IFNAME           => 'ge-0/0/31',
                        IFDESCR          => 'ge-0/0/31',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:9f',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '565',
                        IFNAME           => 'ge-0/0/31.0',
                        IFDESCR          => 'ge-0/0/31.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:9f',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '566',
                        IFNAME           => 'ge-0/0/32',
                        IFDESCR          => 'ge-0/0/32',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '567',
                        IFNAME           => 'ge-0/0/32.0',
                        IFDESCR          => 'ge-0/0/32.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a0',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '568',
                        IFNAME           => 'ge-0/0/33',
                        IFDESCR          => 'ge-0/0/33',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1579011084) 182 days, 18:08:30.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2905938019',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2493025772',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '569',
                        IFNAME           => 'ge-0/0/33.0',
                        IFDESCR          => 'ge-0/0/33.0',
                        IFTYPE           => '53',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1579011084) 182 days, 18:08:30.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '9569516',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '564930997',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '1c:6f:65:0b:cf:67',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '570',
                        IFNAME           => 'ge-0/0/34',
                        IFDESCR          => 'ge-0/0/34',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '571',
                        IFNAME           => 'ge-0/0/34.0',
                        IFDESCR          => 'ge-0/0/34.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a2',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '572',
                        IFNAME           => 'ge-0/0/35',
                        IFDESCR          => 'ge-0/0/35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a3',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1390704494) 160 days, 23:04:04.94',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '5504522',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '666800395',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '573',
                        IFNAME           => 'ge-0/0/35.0',
                        IFDESCR          => 'ge-0/0/35.0',
                        IFTYPE           => '53',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a3',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1390704494) 160 days, 23:04:04.94',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '105099',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1021799248',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '574',
                        IFNAME           => 'ge-0/0/36',
                        IFDESCR          => 'ge-0/0/36',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '575',
                        IFNAME           => 'ge-0/0/36.0',
                        IFDESCR          => 'ge-0/0/36.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a4',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '576',
                        IFNAME           => 'ge-0/0/37',
                        IFDESCR          => 'ge-0/0/37',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1442498948) 166 days, 22:56:29.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '28250947',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '485268381',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '577',
                        IFNAME           => 'ge-0/0/37.0',
                        IFDESCR          => 'ge-0/0/37.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a5',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1442498948) 166 days, 22:56:29.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '129766',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1742789',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '578',
                        IFNAME           => 'ge-0/0/38',
                        IFDESCR          => 'ge-0/0/38',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1086769174) 125 days, 18:48:11.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '47896873',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '771874861',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '579',
                        IFNAME           => 'ge-0/0/38.0',
                        IFDESCR          => 'ge-0/0/38.0',
                        IFTYPE           => '53',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a6',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1086769174) 125 days, 18:48:11.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '153752',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '207932553',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '580',
                        IFNAME           => 'ge-0/0/39',
                        IFDESCR          => 'ge-0/0/39',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1207397316) 139 days, 17:52:53.16',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2340866',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3301053918',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '581',
                        IFNAME           => 'ge-0/0/39.0',
                        IFDESCR          => 'ge-0/0/39.0',
                        IFTYPE           => '53',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a7',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1207397316) 139 days, 17:52:53.16',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '36715',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '756967915',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '582',
                        IFNAME           => 'ge-0/0/40',
                        IFDESCR          => 'ge-0/0/40',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '583',
                        IFNAME           => 'ge-0/0/40.0',
                        IFDESCR          => 'ge-0/0/40.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a8',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '584',
                        IFNAME           => 'ge-0/0/41',
                        IFDESCR          => 'ge-0/0/41',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '585',
                        IFNAME           => 'ge-0/0/41.0',
                        IFDESCR          => 'ge-0/0/41.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:a9',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '586',
                        IFNAME           => 'ge-0/0/42',
                        IFDESCR          => 'ge-0/0/42',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:aa',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '587',
                        IFNAME           => 'ge-0/0/42.0',
                        IFDESCR          => 'ge-0/0/42.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:aa',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '588',
                        IFNAME           => 'ge-0/0/43',
                        IFDESCR          => 'ge-0/0/43',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:ab',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '589',
                        IFNAME           => 'ge-0/0/43.0',
                        IFDESCR          => 'ge-0/0/43.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:ab',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '590',
                        IFNAME           => 'ge-0/0/44',
                        IFDESCR          => 'ge-0/0/44',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:ac',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '591',
                        IFNAME           => 'ge-0/0/44.0',
                        IFDESCR          => 'ge-0/0/44.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:ac',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '592',
                        IFNAME           => 'ge-0/0/45',
                        IFDESCR          => 'ge-0/0/45',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:ad',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1574449874) 182 days, 5:28:18.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2047226430',
                        IFINERRORS       => '4',
                        IFOUTOCTETS      => '3415014528',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '593',
                        IFNAME           => 'ge-0/0/45.0',
                        IFDESCR          => 'ge-0/0/45.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:ad',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1574449874) 182 days, 5:28:18.74',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '386668',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '14671618',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '594',
                        IFNAME           => 'ge-0/0/46',
                        IFDESCR          => 'ge-0/0/46',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:ae',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1554279644) 179 days, 21:26:36.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4080782095',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '961673912',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '595',
                        IFNAME           => 'ge-0/0/46.0',
                        IFDESCR          => 'ge-0/0/46.0',
                        IFTYPE           => '53',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:ae',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1554279644) 179 days, 21:26:36.44',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '7598296',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1023840701',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:19:d1:04:c2:29',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '596',
                        IFNAME           => 'ge-0/0/47',
                        IFDESCR          => 'ge-0/0/47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:af',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1512743176) 175 days, 2:03:51.76',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2316772724',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3200792434',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '597',
                        IFNAME           => 'ge-0/0/47.0',
                        IFDESCR          => 'ge-0/0/47.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '2c:6b:f5:9b:48:af',
                        IFSTATUS         => '7',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1512743176) 175 days, 2:03:51.76',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1781000',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '60956226',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '598',
                        IFNAME           => 'vlan.0',
                        IFDESCR          => 'vlan.0',
                        IFTYPE           => '53',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        IP               => '192.168.100.31',
                        MAC              => '2c:6b:f5:9b:48:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(668) 0:00:06.68',
                        IFINOCTETS       => '593793507',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '762086845',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '599',
                        IFNAME           => 'ge-1/0/0',
                        IFDESCR          => 'ge-1/0/0',
                        IF