#!perl

# Name: Test the base64 encoding function from the MIME::Base64 module
# Require: 5
# Desc:
#

sub encode_base64
{
    my $res = "";
    my $eol = $_[1];
    $eol = "\n" unless defined $eol;
    pos($_[0]) = 0;                          # ensure start at the beginning
    while ($_[0] =~ /(.{1,45})/gs) {
	$res .= substr(pack('u', $1), 1);
	chop($res);
    }
    $res =~ tr|` -_|AA-Za-z0-9+/|;               # `# help emacs
    # fix padding at the end
    my $padding = (3 - length($_[0]) % 3) % 3;
    $res =~ s/.{$padding}$/'=' x $padding/e if $padding;
    # break encoded string into lines of no more than 76 characters each
    if (length $eol) {
	$res =~ s/(.{1,76})/$1$eol/g;
    }
    $res;
}

$plain = "abcd" x 200;

require 'benchlib.pl';

&runtest(0.4, <<'ENDTEST');

   $base64 = encode_base64($plain);

ENDTEST

#print $base64;
