package Bundle::CPAN::Reporter::Smoker::Tests;
use strict;
use warnings;

our $VERSION = '0.005'; # VERSION

=pod

=head1 NAME

Bundle::CPAN::Reporter::Smoker::Tests - bundles several test modules that might be used by a smoker

=head1 DESCRIPTION

This bundle includes several distributions related to automated testing in Perl.

It is intented to provide a easier way to include those tests that have a good
chance to be required or used by a L<CPAN::Reporter::Smoker> instance.

=head1 CONTENTS 

    Test::Most [0.33]
    Test::MockObject [1.20140408]
    Test::NoWarnings [1.04]
    Test::Output [1.03]
    Test::Perl::Critic [1.02]
    Test::Pod [1.48]
    Test::Pod::Coverage [1.10]
    Test::Warn [0.30]
    Test::Strict [0.23]
    Test::Distribution [2.00]
    Test::Inline [2.213]
    Test::Snapshots [0.02]
    Test::Kwalitee [1.19]
    Test::DatabaseRow [2.04]
    Test::Differences [0.62]
    Test::Memory::Cycle [1.04]
    Test::Taint [1.06]
    Test::Class [0.46]
    Test::Class::Moose [0.54]
    Test::FailWarnings [0.008]
    Test::Warnings [0.016]
    Test::Fatal [0.013]
    Test::File [1.36]
    Test::LongString [0.15]
    Test::XPath [0.16]
    Test::Compile [1.3.0]
    Devel::Cover [1.15]
    Devel::NYTProf [5.06]
    Text::Diff [1.41]
    DBD::Mock [1.45]
    Test::Expect [0.31]
    Test::Class [0.46]
    Test::Mock::Simple [0.04]
    Test::MockTime [0.12]
    Test::Class::Moose [0.54]
    Test::HTML::Tidy [1.00]
    Test::Simple [1.302019]
    Test::Reporter::Transport::Socket [0.32]

=head1 SEE ALSO

=over

=item *

L<CPAN::Reporter::Smoker>

=item *

L<http://wiki.cpantesters.org/>

=back

=head1 AUTHOR

Alceu Rodrigues de Freitas Junior, E<lt>arfreitas@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 of Alceu Rodrigues de Freitas Junior, E<lt>arfreitas@cpan.orgE<gt>

This file is part of Bundle CPAN Reporter Smoker Tests.

Siebel Monitoring Tools is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Siebel Monitoring Tools is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Siebel Monitoring Tools.  If not, see L<http://www.gnu.org/licenses/>.

=cut

1;
