# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AT;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230112200223;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '14',
                  'pattern' => '(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              11|
              [2-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '517',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '5[079]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,5})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '[18]',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              31|
              4
            )6|
            51|
            6(?:
              5[0-3579]|
              [6-9]
            )|
            7(?:
              20|
              32|
              8
            )|
            [89]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [2-467]|
            5[2-6]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3,9})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'geographic' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'mobile' => '
          6(?:
            5[0-3579]|
            6[013-9]|
            [7-9]\\d
          )\\d{4,10}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          8(?:
            10|
            2[018]
          )\\d{6,10}|
          828\\d{5}
        )|(
          (?:
            8[69][2-68]|
            9(?:
              0[01]|
              3[019]
            )
          )\\d{6,10}
        )',
                'toll_free' => '800\\d{6,10}',
                'voip' => '
          5(?:
            0[1-9]|
            17|
            [79]\\d
          )\\d{2,10}|
          7[28]0\\d{6,10}
        '
              };
my %areanames = ();
$areanames{en} = {"437445", "Hollenstein\ an\ der\ Ybbs",
"437480", "Langau\,\ Gaming",
"435522", "Feldkirch",
"432636", "Puchberg\ am\ Schneeberg",
"437216", "Helfenberg",
"432718", "Lichtenau\ im\ Waldviertel",
"436274", "Lamprechtshausen",
"435275", "Trins",
"432555", "Herrnbaumgarten",
"432167", "Neusiedl\ am\ See",
"434874", "Virgen",
"432637", "Grünbach\ am\ Schneeberg",
"433183", "St\.\ Georgen\ an\ der\ Stiefing",
"437217", "St\.\ Veit\ im\ Mühlkreis",
"432166", "Parndorf",
"435264", "Mieming",
"432985", "Gars\ am\ Kamp",
"434282", "Hermagor",
"436234", "Zell\ am\ Moos",
"433153", "Riegersburg",
"433336", "Waldbach",
"433337", "Vorau",
"434252", "Wernberg",
"432955", "Grossweikersdorf",
"432245", "Wolkersdorf\ im\ Weinviertel",
"434767", "Rothenthurn",
"432824", "Allentsteig",
"433638", "Palfau",
"434766", "Millstatt",
"435515", "Au",
"432534", "Niedersulz",
"433359", "Loipersdorf\-Kitzladen",
"434855", "Assling",
"436477", "St\.\ Michael\ im\ Lungau",
"437414", "Weins\-Isperdorf",
"432842", "Waidhofen\ an\ der\ Thaya",
"435254", "Sölden",
"432689", "Hornstein",
"432574", "Gaweinstal",
"436476", "St\.\ Margarethen\ im\ Lungau",
"433844", "Kammern\ im\ Liesingtal",
"433572", "Judenburg",
"432713", "Spitz",
"437712", "Schärding",
"436221", "Koppl",
"433532", "Murau",
"432214", "Kopfstetten",
"433158", "St\.\ Anna\ am\ Aigen",
"437249", "Bad\ Schallerbach",
"437665", "Unterach\ am\ Attersee",
"437674", "Attnang\-Puchheim",
"436240", "Krispl",
"436545", "Bruck\ an\ der\ Grossglocknerstrasse",
"433633", "Landl",
"4314", "Vienna",
"435284", "Gerlos",
"434262", "Treibach",
"437751", "St\.\ Martin\ im\ Innkreis",
"432813", "Arbesbach",
"433611", "Johnsbach",
"43662", "Salzburg",
"43512", "Innsbruck",
"432684", "Schützen\ am\ Gebirge",
"436547", "Kaprun",
"436546", "Fusch\ an\ der\ Grossglocknerstrasse",
"433354", "Bernstein",
"433682", "Stainach",
"433849", "Vordernberg",
"437743", "Maria\ Schmolln",
"437727", "Ach",
"437666", "Attersee",
"432742", "St\.\ Pölten",
"437667", "St\.\ Georgen\ im\ Attergau",
"437353", "Gaflenz",
"437244", "Sattledt",
"432731", "Idolsberg",
"437954", "St\.\ Georgen\ am\ Walde",
"437584", "Molln",
"434785", "Ausserfragant",
"434350", "Bad\ St\.\ Leonhard\ im\ Lavanttal",
"436475", "Ramingstein",
"434278", "Gnesau",
"435474", "Pfunds",
"433583", "Unzmarkt",
"434238", "Eisenkappel\-Vellach",
"435289", "Häusling",
"435516", "Doren",
"435517", "Riezlern",
"437564", "Hinterstoder",
"433141", "Hirschegg",
"437230", "Altenberg\ bei\ Linz",
"434734", "Rennweg",
"432610", "Horitschon",
"432246", "Gerasdorf\ bei\ Wien",
"437748", "Eggelsberg",
"434879", "St\.\ Veit\ in\ Defereggen",
"432956", "Ziersdorf",
"432247", "Deutsch\-Wagram",
"432957", "Hohenwarth",
"436484", "Lessach",
"433364", "Hannersdorf",
"433335", "Pöllau",
"435236", "Gries\ im\ Sellrain",
"432987", "St\.\ Leonhard\ am\ Hornerwald",
"432724", "Schwarzenbach\ an\ der\ Pielach",
"432174", "Wallern\ im\ Burgenland",
"432986", "Irnfritz",
"432557", "Bernhardsthal",
"432165", "Hainburg\ a\.d\.\ Donau",
"432664", "Semmering",
"435276", "Gschnitz",
"432556", "Grosskrut",
"436454", "Mandling",
"437215", "Hellmonsödt",
"432635", "Neunkirchen",
"433132", "Kumberg",
"432829", "Schweiggers",
"434273", "Reifnitz",
"434233", "Griffen",
"433172", "Weiz",
"433588", "Katsch\ an\ der\ Mur",
"435333", "Söll",
"432841", "Vitis",
"436564", "Krimml",
"435449", "Fliess",
"434717", "Steinfeld",
"433118", "Sinabelkirchen",
"432783", "Traismauer",
"432944", "Haugsdorf",
"435373", "Ebbs",
"434716", "Lesachtal",
"432254", "Ebreichsdorf",
"435574", "Bregenz",
"433328", "Kukmirn",
"434822", "Winklern",
"437711", "Suben",
"432619", "Lackendorf",
"437239", "Lichtenberg",
"437484", "Göstling\ an\ der\ Ybbs",
"437279", "Haibach\ ob\ der\ Donau",
"433571", "Möderbrugg",
"433468", "St\.\ Oswald\ ob\ Eibiswald",
"433834", "Wald\ am\ Schoberpass",
"436215", "Strasswalchen",
"435214", "Leutasch",
"432628", "Felixdorf",
"433865", "Kindberg",
"432768", "St\.\ Aegyd\ am\ Neuwalde",
"437266", "Bad\ Kreuzen",
"437267", "Mönchdorf",
"433453", "Ehrenhausen",
"432872", "Ottenschlag",
"437752", "Ried\ im\ Innkreis",
"432284", "Oberweiden",
"432753", "Gansbach",
"432915", "Drosendorf\-Zissersdorf",
"433885", "Greith",
"435338", "Kundl",
"434212", "St\.\ Veit\ an\ der\ Glan",
"437286", "Lembach\ im\ Mühlkreis",
"432522", "Laa\ an\ der\ Thaya",
"433113", "Pischelsdorf\ in\ der\ Steiermark",
"437287", "Peilstein\ im\ Mühlviertel",
"432275", "Atzenbrugg",
"436136", "Gosau",
"433323", "Eberau",
"436137", "Strobl",
"432264", "Rückersdorf\,\ Harmannsdorf",
"435677", "Vils",
"432235", "Maria\-Lanzendorf",
"437615", "Scharnstein",
"435676", "Jungholz",
"437762", "Raab",
"432646", "Kirchschlag\ in\ der\ Buckligen\ Welt",
"432623", "Pottendorf",
"436584", "Maria\ Alm\ am\ Steinernen\ Meer",
"435280", "Hochfügen",
"432647", "Krumbach\,\ Lower\ Austria",
"433463", "Stainz",
"435585", "Dalaas",
"436244", "Golling\ an\ der\ Salzach",
"435245", "Hinterriss",
"432763", "St\.\ Veit\ an\ der\ Gölsen",
"434225", "Grafenstein",
"437435", "St\.\ Valentin",
"434359", "Reichenfels",
"433855", "Krieglach",
"437947", "Kefermarkt",
"435417", "Roppen",
"437257", "Grünburg",
"432758", "Pöggstall",
"437475", "Hausmening\,\ Neuhofen\ an\ der\ Ybbs",
"437946", "Gutau",
"437256", "Ternberg",
"437255", "Losenstein",
"436414", "Grossarl",
"433142", "Voitsberg",
"437945", "St\.\ Oswald\ bei\ Freistadt",
"437476", "Aschbach\-Markt",
"437477", "St\.\ Peter\ in\ der\ Au",
"433857", "Neuberg\ an\ der\ Mürz",
"434243", "Bodensdorf",
"434227", "Ferlach",
"433856", "Veitsch",
"434226", "St\.\ Margareten\ im\ Rosental",
"437221", "Hörsching",
"435246", "Achenkirch",
"435223", "Hall\ in\ Tirol",
"432680", "St\.\ Margarethen\ im\ Burgenland",
"432144", "Deutsch\ Jahrndorf",
"432269", "Niederfellabrunn",
"432645", "Wiesmath",
"435675", "Tannheim",
"436589", "Unken",
"437616", "Grünau\ im\ Almtal",
"432236", "Mödling",
"437617", "Traunkirchen",
"432237", "Gaaden",
"432858", "Moorbad\ Harbach",
"432277", "Zwentendorf",
"435557", "St\.\ Gallenkirch",
"436135", "Bad\ Goisern",
"435635", "Elmen",
"432276", "Reidling",
"435556", "Schruns",
"433171", "Gasen",
"437285", "Hofkirchen\ im\ Mühlkreis",
"434354", "Preitenegg",
"432863", "Eggern",
"433886", "Weichselboden",
"437240", "Sipbachzell",
"432916", "Riegersburg\,\ Hardegg",
"4315", "Vienna",
"432259", "Münchendorf",
"435579", "Alberschwende",
"432949", "Niederfladnitz",
"433612", "Liezen",
"434248", "Treffen",
"435444", "Ischgl",
"437234", "Ottensheim",
"437489", "Purgstall\ an\ der\ Erlauf",
"435352", "St\.\ Johann\ in\ Tirol",
"432741", "Flinsbach",
"432614", "Kleinwarasdorf",
"437265", "Pabneukirchen",
"433866", "Breitenau\ am\ Hochlantsch",
"436217", "Mattsee",
"433867", "Pernegg\ an\ der\ Mur",
"436216", "Neumarkt\ am\ Wallersee",
"437274", "Alkoven",
"433513", "Bischoffeld",
"432772", "Neulengbach",
"437733", "Neumarkt\ im\ Hausruckkreis",
"432732", "Krems\ an\ der\ Donau",
"433472", "Mureck",
"432853", "Schrems",
"434715", "Kötschach\-Mauthen",
"4319", "Vienna",
"433124", "Gratkorn",
"432289", "Matzen",
"432757", "Pöchlarn",
"432756", "St\.\ Leonhard\ am\ Forst",
"433149", "Geistthal",
"437948", "Hirschbach\ im\ Mühlkreis",
"435418", "Schönwies",
"434214", "Brückl",
"437258", "Bad\ Hall",
"433457", "Gleinstätten",
"432524", "Kautendorf",
"433456", "Fresing",
"437263", "Bad\ Zell",
"432262", "Korneuburg",
"432648", "Hochneukirchen",
"437764", "Riedau",
"433515", "St\.\ Lorenzen\ bei\ Knittelfeld",
"436582", "Saalfelden\ am\ Steinernen\ Meer",
"437735", "Gaspoltshofen",
"435678", "Weissenbach\ am\ Lech",
"43732", "Linz",
"434842", "Sillian",
"436138", "St\.\ Wolfgang\ im\ Salzkammergut",
"436242", "Russbach\ am\ Pass\ Gschütt",
"432855", "Waldenstein",
"437288", "Ulrichsberg",
"435376", "Thiersee",
"434713", "Techendorf",
"432786", "Oberwölbling",
"433623", "Bad\ Mitterndorf",
"435337", "Brixlegg",
"435336", "Alpbach",
"437253", "Wolfern",
"435413", "St\.\ Leonhard\ im\ Pitztal",
"437943", "Windhaag\ bei\ Freistadt",
"436562", "Mittersill",
"434245", "Feistritz\ an\ der\ Drau",
"433619", "Oppenberg",
"432942", "Retz",
"435572", "Dornbirn",
"432252", "Baden",
"432766", "Kleinzell",
"434824", "Heiligenblut",
"437268", "Grein",
"435225", "Fulpmes",
"435359", "Hochfilzen",
"432767", "Hohenberg",
"437482", "Scheibbs",
"436224", "Hintersee",
"433466", "Eibiswald",
"432626", "Mattersburg",
"432643", "Lichtenegg",
"433467", "Schwanberg",
"432627", "Pitten",
"435673", "Ehrwald",
"433832", "Kraubath\ an\ der\ Mur",
"435212", "Seefeld\ in\ Tirol",
"433326", "Stegersbach",
"435633", "Hägerau",
"436133", "Ebensee",
"433327", "St\.\ Michael\ im\ Burgenland",
"432739", "Tiefenfucha",
"433116", "Kirchbach\ in\ Steiermark",
"432874", "Martinsberg",
"437754", "Waldzell",
"434718", "Dellach",
"433117", "Eggersdorf\ bei\ Graz",
"437283", "Sarleinsbach",
"432865", "Litschau",
"432282", "Gänserndorf",
"432913", "Hötzelsdorf",
"433883", "Terz",
"433115", "Studenzen",
"433614", "Rottenmann",
"435442", "Landeck",
"432273", "Tulbing",
"435553", "Raggal",
"437232", "St\.\ Martin\ im\ Mühlkreis",
"436229", "Hof\ bei\ Salzburg",
"435354", "Fieberbrunn",
"432612", "Oberpullendorf",
"433325", "Heiligenkreuz\ im\ Lafnitztal",
"432233", "Pressbaum",
"437613", "Laakirchen",
"437272", "Eferding",
"433868", "Tragöss",
"433170", "Fischbach",
"432625", "Bad\ Sauerbrunn",
"432774", "Innermanzing",
"433465", "Pölfing\-Brunn",
"435583", "Lech",
"437241", "Steinerkirchen\ an\ der\ Traun",
"432734", "Langenlois",
"435226", "Neustift\ im\ Stubaital",
"433474", "Deutsch\ Goritz",
"435243", "Maurach",
"432765", "Kaumberg",
"434223", "Maria\ Saal",
"437433", "Wallsee",
"436461", "Dienten\ am\ Hochkönig",
"437759", "Antiesenhofen",
"434247", "Afritz",
"433853", "Spital\ am\ Semmering",
"434246", "Radenthein",
"437473", "Blindenmarkt",
"436412", "St\.\ Johann\ im\ Pongau",
"435335", "Hopfgarten\ im\ Brixental",
"433144", "Köflach",
"433680", "Donnersbachwald",
"435375", "Kössen",
"432856", "Weitra",
"432857", "Bad\ Grosspertholz",
"432278", "Absdorf",
"435558", "Gaschurn",
"437736", "Pram",
"437618", "Neukirchen\,\ Altmünster",
"432238", "Kaltenleutgeben",
"432142", "Gattendorf",
"433516", "Kleinlobming",
"436213", "Oberhofen\ am\ Irrsee",
"433863", "Turnau",
"435248", "Steinberg\ am\ Rofan",
"433455", "Arnfels",
"433858", "Mitterdorf\ im\ Mürztal",
"434228", "Feistritz\ im\ Rosental",
"434352", "Wolfsberg",
"432755", "Mank",
"437478", "Oed\-Oehling",
"432532", "Zistersdorf",
"437412", "Ybbs\ an\ der\ Donau",
"435252", "Oetz",
"432572", "Mistelbach",
"432844", "Karlstein\ an\ der\ Thaya",
"433842", "Leoben",
"433689", "St\.\ Nikolai\ im\ Sölktal",
"433574", "Pusterwald",
"433157", "Kapfenstein",
"437714", "Esternberg",
"432749", "Prinzersdorf",
"433333", "Sebersdorf",
"433534", "Stadl\ an\ der\ Mur",
"432212", "Orth\ an\ der\ Donau",
"432673", "Altenmarkt\ an\ der\ Triesting",
"432163", "Petronell\-Carnuntum",
"437672", "Vöcklabruck",
"437213", "Bad\ Leonfelden",
"4317", "Vienna",
"432633", "Markt\ Piesting",
"436478", "Zederhaus",
"434275", "Ebene\ Reichenau",
"435282", "Zell\ am\ Ziller",
"434235", "Bleiburg",
"434264", "Klein\ St\.\ Paul",
"432815", "Grossschönau",
"435524", "Satteins",
"433637", "Gams\ bei\ Hieflau",
"433636", "Wildalpen",
"434768", "Kleblach\-Lind",
"436272", "Oberndorf\ bei\ Salzburg",
"434872", "Huben",
"437745", "Lochen",
"435262", "Telfs",
"433338", "Lafnitz",
"437355", "Weyer",
"437229", "Traun",
"434284", "Kirchbach",
"436232", "Mondsee",
"436241", "St\.\ Koloman",
"432638", "Winzendorf\-Muthmannsdorf",
"437750", "Andrichsfurt",
"434254", "Faak\ am\ See",
"437218", "Grosstraberg",
"432716", "Gföhl",
"434783", "Reisseck",
"432717", "Unter\-Meisling",
"432168", "Mannersdorf\ am\ Leithagebirge",
"436473", "Mariapfarr",
"432822", "Zwettl\,\ Lower\ Austria",
"433585", "St\.\ Lambrecht",
"433179", "Passail",
"436433", "Dorfgastein",
"433587", "Schönberg\-Lachtal",
"437448", "Kematen\ an\ der\ Ybbs",
"433586", "Mühlen",
"437562", "Windischgarsten",
"4346", "Klagenfurt",
"434853", "Ainet",
"434732", "Gmünd\ in\ Kärnten",
"435278", "Navis",
"432715", "Weissenkirchen\ in\ der\ Wachau",
"435238", "Zirl",
"437224", "St\.\ Florian",
"433362", "Grosspetersdorf",
"432988", "Neupölla",
"432172", "Frauenkirchen",
"432722", "Kirchberg\ an\ der\ Pielach",
"437357", "Kleinreifling",
"437663", "Steinbach\ am\ Attersee",
"432248", "Markgrafneusiedl",
"432662", "Gloggnitz",
"437746", "Friedburg",
"432958", "Maissau",
"437723", "Altheim",
"436452", "Radstadt",
"437747", "Kirchberg\ bei\ Mattighofen",
"433134", "Heiligenkreuz\ am\ Waasen",
"436543", "Taxenbach",
"433635", "Radmer",
"435518", "Mellau",
"433174", "Birkfeld",
"432816", "Karlstift",
"434237", "Miklauzhof",
"437443", "Ybbsitz",
"437683", "Frankenburg\ am\ Hausruck",
"434236", "Eberndorf",
"435441", "See",
"434276", "Feldkirchen\ in\ Kärnten",
"432849", "Schwarzenau",
"432682", "Eisenstadt",
"434277", "Glanegg",
"434858", "Nikolsdorf",
"433352", "Oberwart",
"435273", "Matrei\ am\ Brenner",
"433684", "St\.\ Martin\ am\ Grimming",
"433579", "Pöls",
"433185", "Preding",
"437231", "Herzogsdorf",
"432611", "Mannersdorf\ an\ der\ Rabnitz",
"432744", "Kasten\ bei\ Böheimkirchen",
"432983", "Sigmundsherberg",
"437719", "Taufkirchen\ an\ der\ Pram",
"433140", "St\.\ Martin\ am\ Wöllmissberg",
"437242", "Wels",
"433155", "Fehring",
"437952", "Weitersfelden",
"437582", "Kirchdorf\ an\ der\ Krems",
"437728", "Schwand\ im\ Innkreis",
"432953", "Nappersdorf",
"432243", "Klosterneuburg",
"435472", "Prutz",
"436548", "Niedernsill",
"4318", "Vienna",
"433382", "Fürstenfeld",
"434269", "Flattnitz",
"436462", "Bischofshofen",
"435513", "Hittisau",
"435287", "Tux",
"435286", "Ginzling",
"432685", "Rust",
"432848", "Pfaffenschlag\ bei\ Waidhofen",
"435523", "Götzis",
"433355", "Stadtschlaining",
"437676", "Ottnang\ am\ Hausruck",
"433182", "Wildon",
"433578", "Obdach",
"432216", "Leopoldsdorf\ im\ Marchfelde",
"434283", "St\.\ Stefan\ im\ Gailtal",
"437718", "Waldkirchen\ am\ Wesen",
"437250", "Maria\ Neustift",
"433152", "Feldbach",
"437955", "Königswiesen",
"437245", "Lambach",
"434784", "Mallnitz",
"437729", "Neukirchen\ an\ der\ Enknach",
"437280", "Schwarzenberg\ am\ Böhmerwald",
"437585", "Klaus\ an\ der\ Pyhrnbahn",
"434253", "St\.\ Jakob\ im\ Rosental",
"433847", "Trofaiach",
"433461", "Trahütten",
"433846", "Kalwang",
"432621", "Sieggraben",
"437416", "Wieselburg",
"435256", "Untergurgl",
"432576", "Ernstbrunn",
"435475", "Feichten",
"436474", "Tamsweg",
"432577", "Asparn\ an\ der\ Zaya",
"436549", "Piesendorf",
"434268", "Friesach",
"433385", "Ilz",
"432536", "Drösing",
"436434", "Bad\ Gastein",
"432826", "Rastenfeld",
"437565", "St\.\ Pankraz",
"435331", "Brandenberg",
"437260", "Waldhausen",
"432827", "Schönbach",
"434735", "Kremsbrücke",
"432843", "Dobersberg",
"433573", "Fohnsdorf",
"432712", "Aggsbach",
"435279", "St\.\ Jodok\ am\ Brenner",
"437713", "Schardenberg",
"4312", "Vienna",
"433365", "Deutsch\ Schützen\-Eisenberg",
"43316", "Graz",
"435239", "Kühtai",
"433533", "Turrach",
"432989", "Brunn\ an\ der\ Wild",
"433334", "Kaindorf",
"432674", "Weissenbach\ an\ der\ Triesting",
"432725", "Frankenfels",
"432175", "Apetlon",
"435266", "Ötztal\-Bahnhof",
"434876", "Kals\ am\ Grossglockner",
"432959", "Sitzendorf\ an\ der\ Schmida",
"432249", "Gross\-Enzersdorf",
"436277", "St\.\ Pantaleon",
"432665", "Prein\ an\ der\ Rax",
"432164", "Rohrau",
"432634", "Gutenstein",
"434877", "Prägraten\ am\ Grossvenediger",
"437214", "Reichenthal",
"434258", "Gummern",
"436455", "Untertauern",
"434710", "Oberdrauburg",
"436276", "Nussdorf\ am\ Haunsberg",
"433632", "St\.\ Gallen",
"435519", "Schröcken",
"434263", "Hüttenberg",
"432812", "Gross\ Gerungs",
"437444", "Opponitz",
"437684", "Frankenmarkt",
"434769", "Möllbrücke",
"435274", "Gries\ am\ Brenner",
"432554", "Stützenhofen",
"432667", "Schwarzau\ im\ Gebirge",
"436456", "Obertauern",
"432666", "Reichenau",
"437742", "Mattighofen",
"436457", "Flachau",
"433683", "Donnersbach",
"434875", "Matrei\ in\ Osttirol",
"432743", "Böheimkirchen",
"433339", "Friedberg",
"432984", "Eggenburg",
"435265", "Nassereith",
"432177", "Podersdorf\ am\ See",
"435234", "Axams",
"436235", "Thalgau",
"437228", "Kematen\ an\ der\ Krems",
"432726", "Puchenstuben",
"432176", "Tadten",
"433366", "Kohfidisch",
"437219", "Vorderweissenbach",
"432639", "Bad\ Fischau",
"432169", "Trautmannsdorf\ an\ der\ Leitha",
"432244", "Langenzersdorf",
"432954", "Göllersdorf",
"434736", "Innerkrems",
"437566", "Rosenau\ am\ Hengstpass",
"432825", "Göpfritz\ an\ der\ Wild",
"433178", "St\.\ Ruprecht\ an\ der\ Raab",
"433582", "Scheifling",
"435514", "Bezau",
"433387", "Söchau",
"436467", "Mühlbach\ am\ Hochkönig",
"432535", "Hohenau\ an\ der\ March",
"432230", "Schwadorf",
"433386", "Grosssteinbach",
"436466", "Werfenweng",
"435477", "Tösens",
"435476", "Serfaus",
"435255", "Umhausen",
"432575", "Ladendorf",
"437415", "Altenmarkt\,\ Yspertal",
"435550", "Thüringen",
"433845", "Mautern\ in\ Steiermark",
"433688", "Tauplitz",
"437587", "Wartberg\ an\ der\ Krems",
"437586", "Pettenbach",
"437247", "Kematen\ am\ Innbach",
"437223", "Enns",
"437246", "Gunskirchen",
"437956", "Unterweissenbach",
"432748", "Kilb",
"432215", "Probstdorf",
"437664", "Weyregg\ am\ Attersee",
"437675", "Ampflwang\ im\ Hausruckwald",
"434220", "Köttmannsdorf",
"437724", "Mauerkirchen",
"436544", "Rauris",
"432687", "Siegendorf",
"433356", "Markt\ Allhau",
"433133", "Nestelbach",
"434272", "Pörtschach\ am\ Wörther\ See",
"436479", "Muhr",
"432686", "Drassburg",
"433357", "Pinkafeld",
"434232", "Völkermarkt",
"435285", "Mayrhofen",
"433173", "Ratten",
"437944", "Sandl",
"435332", "Wörgl",
"435414", "Wenns",
"436415", "Schwarzach\ im\ Pongau",
"437254", "Grossraming",
"435372", "Kufstein",
"432782", "Herzogenburg",
"436246", "Grödig",
"434823", "Tresdorf\,\ Rangersdorf",
"434847", "Obertilliach",
"435559", "Brand",
"436247", "Grossgmain",
"432279", "Kirchberg\ am\ Wagram",
"436223", "Anthering",
"434846", "Abfaltersbach",
"432239", "Breitenfurt\ bei\ Wien",
"437619", "Kirchham",
"432644", "Grimmenstein",
"432711", "Dürnstein",
"432145", "Prellenkirchen",
"432267", "Sierndorf",
"435674", "Bichlbach",
"432266", "Stockerau",
"436134", "Hallstatt",
"436470", "Atzmannsdorf",
"435634", "Elbigenalp",
"432873", "Kottes",
"433452", "Leibnitz",
"434229", "Krumpendorf\ am\ Wörther\ See",
"437284", "Oberkappel",
"434355", "Gemmersdorf",
"437753", "Eberschwang",
"433859", "Mürzsteg",
"437479", "Ardagger",
"432752", "Melk",
"433631", "Unterlaussa",
"432287", "Strasshof\ an\ der\ Nordbahn",
"434213", "Launsdorf",
"432286", "Obersiebenbrunn",
"432523", "Kirchstetten\,\ Neudorf\ bei\ Staatz",
"435445", "Kappl",
"433112", "Gleisdorf",
"432615", "Lutzmannsburg",
"436228", "Faistenau",
"437235", "Gallneukirchen",
"433322", "Güssing",
"437264", "Windhaag\ bei\ Perg",
"437763", "Kopfing\ im\ Innkreis",
"433869", "St\.\ Katharein\ an\ der\ Laming",
"433462", "Deutschlandsberg",
"436219", "Obertrum\ am\ See",
"432622", "Wiener\ Neustadt",
"437486", "Lunz\ am\ See",
"433151", "Gnas",
"432762", "Lilienfeld",
"437487", "Gresten",
"432630", "Ternitz",
"432946", "Pulkau",
"434714", "Dellach\ im\ Drautal",
"437758", "Obernberg\ am\ Inn",
"432256", "Leobersdorf",
"435576", "Hohenems",
"432947", "Theras",
"435577", "Lustenau",
"432257", "Klausen\-Leopoldsdorf",
"432160", "Jois",
"432878", "Traunstein",
"433125", "Übelbach",
"433624", "Pichl\-Kainisch",
"436566", "Bramberg\ am\ Wildkogel",
"435230", "Sellrain",
"433143", "Krottendorf",
"433127", "Peggau",
"436565", "Neukirchen\ am\ Grossvenediger",
"433126", "Frohnleiten",
"433618", "Hohentauern",
"434242", "Villach",
"432255", "Deutsch\ Brodersdorf",
"435575", "Langen\ bei\ Bregenz",
"432945", "Zellerndorf",
"437269", "Baumgartenberg",
"437485", "Gaming",
"435358", "Ellmau",
"436214", "Henndorf\ am\ Wallersee",
"435510", "Damüls",
"437276", "Peuerbach",
"433864", "St\.\ Marein\ im\ Mürztal",
"437277", "Waizenkirchen",
"437237", "St\.\ Georgen\ an\ der\ Gusen",
"432617", "Drassmarkt",
"432738", "Fels\ am\ Wagram",
"437236", "Pregarten",
"432616", "Lockenhaus",
"434231", "Mittertrixen",
"435446", "St\.\ Anton\ am\ Arlberg",
"435447", "Flirsch",
"432285", "Marchegg",
"432862", "Heidenreichstein",
"434271", "Steuerberg",
"432914", "Japons",
"437259", "Sierning",
"437949", "Rainbach\ im\ Mühlkreis",
"433148", "Kainach\ bei\ Voitsberg",
"433884", "Wegscheid",
"434356", "Lavamünd",
"433613", "Admont",
"434357", "St\.\ Paul\ im\ Lavanttal",
"435353", "Waidring",
"432274", "Sieghartskirchen",
"435554", "Sonntag",
"432265", "Hausleiten",
"432649", "Mönichkirchen",
"437614", "Vorchdorf",
"432234", "Gramatneusiedl",
"432146", "Nickelsdorf",
"433512", "Knittelfeld",
"437732", "Haag\ am\ Hausruck",
"432147", "Zurndorf",
"432773", "Eichgraben",
"4316", "Vienna",
"432733", "Schönberg\ am\ Kamp",
"432852", "Gmünd",
"435244", "Jenbach",
"433473", "Straden",
"436245", "Hallein",
"433854", "Langenwang",
"433581", "Oberwölz",
"434224", "Pischeldorf",
"437434", "Haag",
"437289", "Rohrbach\ in\ Oberösterreich",
"436417", "Hüttschlag",
"436416", "Lend",
"437474", "Euratsfeld",
"432948", "Weitersfeld",
"432258", "Alland",
"435578", "Höchst",
"432877", "Grainbrunn",
"437757", "Gurten",
"433615", "Trieben",
"433114", "Markt\ Hartmannsdorf",
"432876", "Els",
"435355", "Jochberg",
"437488", "Steinakirchen\ am\ Forst",
"433324", "Strem",
"437262", "Perg",
"432263", "Grossrussbach",
"436583", "Leogang",
"433464", "Gross\ St\.\ Florian",
"432624", "Ebenfurth",
"434843", "Ausservillgraten",
"436226", "Fuschl\ am\ See",
"432735", "Hadersdorf\ am\ Kamp",
"432764", "Hainfeld",
"436227", "St\.\ Gilgen",
"433475", "Hürth",
"436243", "Abtenau",
"434826", "Mörtschach",
"434712", "Greifenburg",
"433622", "Bad\ Aussee",
"436471", "Tweng",
"432288", "Auersthal",
"433145", "Edelschrott",
"437942", "Freistadt",
"435334", "Westendorf",
"435412", "Imst",
"434761", "Stockenboi",
"437252", "Steyr",
"436563", "Uttendorf",
"432253", "Oberwaltersdorf",
"435573", "Hörbranz",
"435374", "Walchsee",
"432943", "Obritz",
"432784", "Perschling",
"437483", "Oberndorf\ an\ der\ Melk",
"433331", "St\.\ Lorenzen\ am\ Wechsel",
"437767", "Eggerding",
"437766", "Andorf",
"432642", "Aspangberg\-St\.\ Peter",
"432268", "Grossmugl",
"435213", "Scharnitz",
"436588", "Lofer",
"433833", "Traboch",
"435672", "Reutte",
"432631", "Pöttsching",
"437211", "Reichenau\ im\ Mühlkreis",
"432859", "Brand\-Nagelberg",
"434848", "Kartitsch",
"435632", "Stanzach",
"436132", "Bad\ Ischl",
"433454", "Leutschach",
"432527", "Wulzeshofen",
"437282", "Neufelden",
"432526", "Stronsdorf",
"432754", "Loosdorf",
"432283", "Angern\ an\ der\ March",
"433150", "Paldau",
"432912", "Geras",
"436418", "Kleinarl",
"434215", "Liebenfels",
"435339", "Wildschönau",
"433882", "Mariazell",
"4313", "Vienna",
"432525", "Gnadendorf",
"435443", "Galtür",
"432613", "Deutschkreutz",
"437233", "Feldkirchen\ an\ der\ Donau",
"432272", "Tulln\ an\ der\ Donau",
"435552", "Bludenz",
"437273", "Aschach\ an\ der\ Donau",
"437612", "Gmunden",
"432232", "Fischamend",
"433514", "Seckau",
"437765", "Lambrechten",
"435582", "Klösterle",
"437734", "Hofkirchen\ an\ der\ Trattnach",
"434230", "Globasnitz",
"432951", "Guntersdorf",
"432854", "Kirchberg\ am\ Walde",
"435242", "Schwaz",
"433852", "Mürzzuschlag",
"434358", "St\.\ Andrä",
"437432", "Strengberg",
"433123", "St\.\ Oswald\ bei\ Plankenwarth",
"433147", "Salla",
"433146", "Modriach",
"437472", "Amstetten",
"436413", "Wagrain",
"433119", "St\.\ Marein\ bei\ Graz",
"434244", "Bad\ Bleiberg",
"435448", "Pettneu\ am\ Arlberg",
"434825", "Grosskirchheim",
"433476", "Bad\ Radkersburg",
"433329", "Jennersdorf",
"433477", "St\.\ Peter\ am\ Ottersbach",
"432736", "Paudorf",
"437238", "Mauthausen",
"436225", "Eugendorf",
"432618", "Markt\ St\.\ Martin",
"435224", "Wattens",
"437278", "Neukirchen\ am\ Walde",
"432143", "Kittsee",
"432629", "Warth\,\ Lower\ Austria",
"436212", "Seekirchen\ am\ Wallersee",
"433469", "St\.\ Oswald\ im\ Freiland",
"433862", "Bruck\ an\ der\ Mur",
"432769", "Türnitz",
"435357", "Kirchberg\ in\ Tirol",
"435356", "Kitzbühel",
"432875", "Grafenschlag",
"433616", "Selzthal",
"434353", "Prebl",
"433617", "Gaishorn\ am\ See",
"437755", "Mettmach",
"432864", "Kautzen",
"436541", "Saalbach",
"432533", "Neusiedl\ an\ der\ Zaya",
"437941", "Neumarkt\ im\ Mühlkreis",
"434762", "Spittal\ an\ der\ Drau",
"437251", "Schiedlberg",
"432573", "Wilfersdorf",
"435253", "Längenfeld",
"437413", "Marbach\ an\ der\ Donau",
"433843", "St\.\ Michael\ in\ Obersteiermark",
"434257", "Fürnitz",
"434256", "Nötsch\ im\ Gailtal",
"432714", "Rossatz",
"436278", "Ostermiething",
"432641", "Kirchberg\ am\ Wechsel",
"437225", "Hargelsberg",
"433332", "Hartberg",
"432672", "Berndorf",
"434286", "Weissbriach",
"432213", "Lassee",
"436131", "Obertraun",
"432162", "Bruck\ an\ der\ Leitha",
"432632", "Pernitz",
"437212", "Zwettl\ an\ der\ Rodl",
"437673", "Schwanenstadt",
"432828", "Rappottenstein",
"433634", "Hieflau",
"433135", "Kalsdorf\ bei\ Graz",
"435526", "Laterns",
"433460", "Soboth",
"435283", "Kaltenbach",
"432620", "Willendorf",
"437281", "Aigen\ im\ Mühlkreis",
"433175", "Anger",
"434266", "Strassburg",
"434267", "Metnitz",
"432538", "Velm\-Götzendorf",
"433184", "Wolfsberg\ im\ Schwarzautal",
"434873", "St\.\ Jakob\ in\ Defereggen",
"433685", "Gröbming",
"433848", "Eisenerz",
"432745", "Pyhra",
"435263", "Silz",
"436233", "Oberwang",
"437261", "Schönau\ im\ Mühlkreis",
"433536", "St\.\ Peter\ am\ Kammersberg",
"437717", "St\.\ Aegidi",
"433537", "St\.\ Georgen\ ob\ Murau",
"437716", "Münzkirchen",
"434782", "Obervellach",
"433577", "Zeltweg",
"433576", "Bretstein",
"432846", "Raabs\ an\ der\ Thaya",
"434279", "Sirnitz",
"436472", "Mauterndorf",
"432847", "Gross\-Siegharts",
"432823", "Grossglobnitz",
"435288", "Fügen",
"436432", "Bad\ Hofgastein",
"434239", "St\.\ Kanzian\ am\ Klopeiner\ See",
"434852", "Lienz",
"433358", "Litzelsdorf",
"437563", "Spital\ am\ Pyhrn",
"434733", "Malta",
"432688", "Steinbrunn",
"432845", "Weikertschlag\ an\ der\ Thaya",
"433575", "St\.\ Johann\ am\ Tauern",
"433363", "Rechnitz",
"436483", "Göriach",
"433535", "Krakaudorf",
"432173", "Gols",
"432723", "Rabenstein\ an\ der\ Pielach",
"432747", "Ober\-Grafendorf",
"437662", "Seewalchen\ am\ Attersee",
"437248", "Grieskirchen",
"433159", "Bad\ Gleichenberg",
"432746", "Wilhelmsburg",
"433686", "Haus",
"432663", "Schottwien",
"433861", "Aflenz",
"433687", "Schladming",
"436453", "Filzmoos",
"437588", "Ried\ im\ Traunkreis",
"437722", "Braunau\ am\ Inn",
"436542", "Zell\ am\ See",
"434274", "Velden\ am\ Wörther\ See",
"434234", "Ruden",
"436468", "Werfen",
"434265", "Weitensfeld\ im\ Gurktal",
"432814", "Langschlag",
"433176", "Stubenberg",
"437442", "Waidhofen\ an\ der\ Ybbs",
"433177", "Puch\ bei\ Weiz",
"437682", "Vöcklamarkt",
"433137", "Söding",
"432683", "Purbach\ am\ Neusiedler\ See",
"435525", "Nenzing",
"433136", "Dobl",
"433353", "Oberschützen",
"432552", "Poysdorf",
"435272", "Steinach\ am\ Brenner",
"432719", "Dross",
"434240", "Bad\ Kleinkirchheim",
"437744", "Munderfing",
"432231", "Purkersdorf",
"432982", "Horn",
"432271", "Ried\ am\ Riederberg",
"435232", "Kematen\ in\ Tirol",
"434285", "Tröpolach",
"437227", "Neuhofen\ an\ der\ Krems",
"437953", "Liebenau",
"437243", "Marchtrenk",
"437226", "Wilhering",
"432728", "Wienerbruck",
"437583", "Kremsmünster",
"434255", "Arnoldstein",
"436458", "Hüttau",
"432242", "St\.\ Andrä\-Wördern",
"432952", "Hollabrunn",
"435473", "Nauders",
"437471", "Neustadtl\ an\ der\ Donau",
"436463", "Annaberg\-Lungötz",
"433584", "Neumarkt\ in\ Steiermark",
"433383", "Burgau",
"434221", "Gallizien",
"435512", "Egg",};
$areanames{de} = {"433869", "Sankt\ Katharein\ an\ der\ Laming",
"437254", "Großraming",
"436247", "Großgmain",
"434357", "Sankt\ Paul\ im\ Lavanttal",
"4316", "Wien",
"436565", "Neukirchen\ am\ Großvenediger",
"433864", "Sankt\ Marein\ im\ Mürztal",
"437237", "Sankt\ Georgen\ an\ der\ Gusen",
"432617", "Draßmarkt",
"435446", "Sankt\ Anton\ am\ Arlberg",
"437565", "Sankt\ Pankraz",
"435279", "Sankt\ Jodok\ am\ Brenner",
"4312", "Wien",
"432674", "Weißenbach\ an\ der\ Triesting",
"436276", "Nußdorf\ am\ Haunsberg",
"434877", "Prägraten\ am\ Großvenediger",
"436277", "Sankt\ Pantaleon",
"432249", "Groß\-Enzersdorf",
"434876", "Kals\ am\ Großglockner",
"433632", "Sankt\ Gallen",
"434283", "Sankt\ Stefan\ im\ Gailtal",
"434253", "Sankt\ Jakob\ im\ Rosental",
"433386", "Großsteinbach",
"437956", "Unterweißenbach",
"432686", "Draßburg",
"432812", "Groß\ Gerungs",
"437219", "Vorderweißenbach",
"437566", "Rosenau\ am\ Hengstpaß",
"433178", "Sankt\ Ruprecht\ an\ der\ Raab",
"434266", "Straßburg",
"434873", "Sankt\ Jakob\ in\ Defereggen",
"433537", "Sankt\ Georgen\ ob\ Murau",
"433536", "Sankt\ Peter\ am\ Kammersberg",
"437717", "Sankt\ Aegidi",
"432823", "Großglobnitz",
"432847", "Groß\-Siegharts",
"434239", "Sankt\ Kanzian\ am\ Klopeiner\ See",
"433843", "Sankt\ Michael\ in\ Obersteiermark",
"434286", "Weißbriach",
"432719", "Droß",
"432242", "Sankt\ Andrä\-Wördern",
"433575", "Sankt\ Johann\ am\ Tauern",
"433331", "Sankt\ Lorenzen\ am\ Wechsel",
"432642", "Aspangberg\-Sankt\ Peter",
"432268", "Großmugl",
"432263", "Großrußbach",
"433464", "Groß\ Sankt\ Florian",
"436227", "Sankt\ Gilgen",
"434843", "Außervillgraten",
"433119", "Sankt\ Marein\ bei\ Graz",
"432618", "Markt\ Sankt\ Martin",
"433477", "Sankt\ Peter\ am\ Ottersbach",
"434825", "Großkirchheim",
"433469", "Sankt\ Oswald\ im\ Freiland",
"432629", "Warth\,\ Niederösterreich",
"4313", "Wien",
"434358", "Sankt\ Andrä",
"433123", "Sankt\ Oswald\ bei\ Plankenwarth",
"434212", "Sankt\ Veit\ an\ der\ Glan",
"432647", "Krumbach\,\ Niederösterreich",
"432763", "Sankt\ Veit\ an\ der\ Gölsen",
"435245", "Hinterriß",
"437435", "Sankt\ Valentin",
"435449", "Fließ",
"436215", "Straßwalchen",
"433468", "Sankt\ Oswald\ ob\ Eibiswald",
"433834", "Wald\ am\ Schoberpaß",
"432768", "Sankt\ Aegyd\ am\ Neuwalde",
"4315", "Wien",
"435352", "Sankt\ Johann\ in\ Tirol",
"4319", "Wien",
"437477", "Sankt\ Peter\ in\ der\ Au",
"437945", "Sankt\ Oswald\ bei\ Freistadt",
"436414", "Großarl",
"434226", "Sankt\ Margareten\ im\ Rosental",
"432680", "Sankt\ Margarethen\ im\ Burgenland",
"435557", "Sankt\ Gallenkirch",
"436476", "Sankt\ Margarethen\ im\ Lungau",
"436477", "Sankt\ Michael\ im\ Lungau",
"433158", "Sankt\ Anna\ am\ Aigen",
"436545", "Bruck\ an\ der\ Großglocknerstraße",
"437751", "Sankt\ Martin\ im\ Innkreis",
"4314", "Wien",
"437217", "Sankt\ Veit\ im\ Mühlkreis",
"433183", "Sankt\ Georgen\ an\ der\ Stiefing",
"432955", "Großweikersdorf",
"434879", "Sankt\ Veit\ in\ Defereggen",
"432987", "Sankt\ Leonhard\ am\ Hornerwald",
"432556", "Großkrut",
"436546", "Fusch\ an\ der\ Großglocknerstraße",
"437667", "Sankt\ Georgen\ im\ Attergau",
"432742", "Sankt\ Pölten",
"437954", "Sankt\ Georgen\ am\ Walde",
"434350", "Bad\ Sankt\ Leonhard\ im\ Lavanttal",
"434785", "Außerfragant",
"432815", "Großschönau",
"436241", "Sankt\ Koloman",
"434783", "Reißeck",
"437218", "Großtraberg",
"432822", "Zwettl\-Niederösterreich",
"433585", "Sankt\ Lambrecht",
"433689", "Sankt\ Nikolai\ im\ Sölktal",
"4317", "Wien",
"434264", "Klein\ Sankt\ Paul",
"433684", "Sankt\ Martin\ am\ Grimming",
"433140", "Sankt\ Martin\ am\ Wöllmißberg",
"4318", "Wien",
"432715", "Weißenkirchen\ in\ der\ Wachau",
"433362", "Großpetersdorf",
"437224", "Sankt\ Florian",
"435413", "Sankt\ Leonhard\ im\ Pitztal",
"433327", "Sankt\ Michael\ im\ Burgenland",
"432756", "Sankt\ Leonhard\ am\ Forst",
"435678", "Weißenbach\ am\ Lech",
"433515", "Sankt\ Lorenzen\ bei\ Knittelfeld",
"436242", "Rußbach\ am\ Paß\ Gschütt",
"436138", "Sankt\ Wolfgang\ im\ Salzkammergut",
"436412", "Sankt\ Johann\ im\ Pongau",
"432857", "Bad\ Großpertholz",
"437232", "Sankt\ Martin\ im\ Mühlkreis",
"432233", "Preßbaum",
"433868", "Tragöß",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+43|\D)//g;
      my $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;