######################################################################
#
# makealldists.pl - make all dists
#
# Copyright (c) 2010, 2011, 2012, 2013, 2015 INABA Hitoshi <ina@cpan.org>
#
######################################################################

use strict;
use File::Copy;

my @dist = (
    'Sjis',
    'USASCII',
    'UTF2',
    'GB18030',
    'EUCJP',
    'EUCTW',
    'HP15',
    'INFORMIXV6ALS',
    'Big5HKSCS',
    'Big5Plus',
    'UHC',
    'KPS9566',
    'GBK',
    'OldUTF8',
    'Latin1',
    'Latin2',
    'Latin3',
    'Latin4',
    'Cyrillic',
    'Arabic',
    'Greek',
    'Hebrew',
    'Latin5',
    'Latin6',
    'TIS620',
    'Latin7',
    'Latin8',
    'Latin9',
    'Latin10',
    'JIS8',
    'KOI8R',
    'KOI8U',
    'Windows1252',
    'Windows1258',
);

for my $dist (@dist) {
    sleep(1);
    mkdir($dist,0777);

    open(TEST,">test.pl") || die "Can't open file: test.pl, q(;_;)bad!!\n";
    binmode TEST;
    print TEST <<END;
# encoding: $dist;
use Char;

\$| = 1;
print "1..1\\n";
print "ok - 1\\n";
exit;
END
    close(TEST);
    mysystem(q{perl test.pl});

    open(TEST,">test.pl") || die "Can't open file: test.pl, q(;_;)bad!!\n";
    binmode TEST;
    print TEST <<END;
use $dist;

\$| = 1;
print "1..1\\n";
print "ok - 1\\n";
exit;
END
    close(TEST);
    mysystem(q{perl test.pl});

    for my $file (
        "$dist.pm",
        "E\L$dist\E.pm",
        'test.pl',
        'Changes',
        'pMakefile.PL',
    ){
        mycopy($file, "$dist/$file");
    }

    for my $file (
        'README',
        'META.yml',
        'Makefile.PL',
    ) {
        open(FILE1,$file) || die "Can't open file: $file, q(;_;)bad!!\n";
        binmode FILE1;
        open(FILE2,">$dist/$file") || die "Can't open file: $dist/$file, q(;_;)bad!!\n";
        binmode FILE2;
        while (<FILE1>) {
            s!Character Oriented Perl by Magic Comment!Source code filter to escape $dist script!;
            s!# encoding: [^ \n]+!# encoding: $dist!;
            s!\bChar\b!$dist!g;
            s! \s* 'test' \s* => \s* \{ \s* 'TESTS' \s* => \s* 't/\*/\*\.t' \s* \} \s* , \s* $!!x;
            print FILE2 $_;
        }
        close(FILE1);
        close(FILE2);
    }

    mycopy("README2ND/README2ND.$dist","$dist/README2ND");

    mkdir("$dist/Char",0777);
    open(FILE,">$dist/Char/$dist.pm") || die "Can't open file: $dist/Char/$dist.pm, q(;_;)bad!!\n";
    binmode FILE;
    print FILE <<END;
# This is a dummy file to implement CPAN naming goals.
package Char::$dist;

# On The Naming of Modules/NAMES TO AVOID/Top-level namespaces
# https://pause.perl.org/pause/query?ACTION=pause_namingmodules#Top_level_namespaces

1;

__END__
END
    close(FILE);

    open(MANIFEST,">$dist/MANIFEST") || die "Can't open file: $dist/MANIFEST, q(;_;)bad!!\n";
    binmode MANIFEST;
    for my $file (
        "Char/$dist.pm",
        "$dist.pm",
        "E\L$dist\E.pm",
        'README',
        'Changes',
        'META.yml',
        'Makefile.PL',
        'pMakefile.PL',
        'test.pl',
        'README2ND',
        'MANIFEST',
    ) {
        check_usascii("$dist/$file");
        print MANIFEST $file, "\n";
    }
    close(MANIFEST);

    mychdir($dist);
    mysystem(q{perl pMakefile.PL});
    if ($^O eq 'MSWin32') {
        mysystem(q{pmake.bat dist});
    }
    else {
        mysystem(q{./pmake dist});
    }
    mysystem(q{perl test.pl});
    mychdir('..');
}

print STDERR "\nALL OK, d('o')good!!\n";
exit 0;

sub mysystem {
    if (system($_[0]) != 0) {
        die "error at system($_[0]), q(;_;)bad!!\n";
    }
}

sub mychdir {
    if (chdir($_[0]) == 0) {
        die "error at chdir($_[0]), q(;_;)bad!!\n";
    }
}

sub mycopy {
    if (copy($_[0],$_[1]) == 0) {
        die qq{error at copy("$_[0]","$_[1]"), q(;_;)bad!!\n};
    }
}

sub check_usascii {
    my($file) = @_;
    if (open(FILE,$file)) {
        while (<FILE>) {
            if (not /^[\x0A\x20-\x7E]+$/) {
                die "error not US-ASCII: $file, q(;_;)bad!!\n";
            }
        }
        close(FILE);
    }
    else {
        die "error open: $file, q(;_;)bad!!\n";
    }
}

__END__
