package Locales::DB::Territory::dz;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::dz::VERSION = '0.09';

$Locales::DB::Territory::dz::cldr_version = '2.0';

%Locales::DB::Territory::dz::code_to_name = (
    '001' => 'World',
    '002' => 'Africa',
    '003' => "North\ America",
    '005' => "South\ America",
    '009' => 'Oceania',
    '011' => "Western\ Africa",
    '013' => "Central\ America",
    '014' => "Eastern\ Africa",
    '015' => "Northern\ Africa",
    '017' => "Middle\ Africa",
    '018' => "Southern\ Africa",
    '019' => 'Americas',
    '021' => "Northern\ America",
    '029' => 'Caribbean',
    '030' => "Eastern\ Asia",
    '034' => "Southern\ Asia",
    '035' => "South\-Eastern\ Asia",
    '039' => "Southern\ Europe",
    '053' => "Australia\ and\ New\ Zealand",
    '054' => 'Melanesia',
    '057' => "Micronesian\ Region",
    '061' => 'Polynesia',
    '062' => "South\-Central\ Asia",
    142   => 'Asia',
    143   => "Central\ Asia",
    145   => "Western\ Asia",
    150   => 'Europe',
    151   => "Eastern\ Europe",
    154   => "Northern\ Europe",
    155   => "Western\ Europe",
    172   => "Commonwealth\ of\ Independent\ States",
    200   => 'Czechoslovakia',
    419   => "Latin\ America",
    830   => "Channel\ Islands",
    'ac'  => "Ascension\ Island",
    'ad'  => 'Andorra',
    'ae'  => "ཡུ་ནའི་ཊེཊ་ཨ་ར\ བ་ཨེ་མི་རེཊསི",
    'af'  => 'ཨཕ་ག་ནིསི་ཏཱན',
    'ag'  => "Antigua\ and\ Barbuda",
    'ai'  => 'Anguilla',
    'al'  => 'Albania',
    'am'  => 'Armenia',
    'an'  => "Netherlands\ Antilles",
    'ao'  => 'Angola',
    'aq'  => 'ཨེན་ཊཱག་ཊི་ཀ',
    'ar'  => 'ཨར་ཇེན་ཊི་ན',
    'as'  => "American\ Samoa",
    'at'  => 'ཨས་ཊི་ཡ',
    'au'  => 'ཨས་ཊེཡེ་ལི་ཡ',
    'aw'  => 'Aruba',
    'ax'  => "\Ã\land\ Islands",
    'az'  => 'Azerbaijan',
    'ba'  => "Bosnia\ and\ Herzegovina",
    'bb'  => 'Barbados',
    'bd'  => 'བངྒ་ལ་དེཤ',
    'be'  => 'བེལ་ཇིཡམ',
    'bf'  => "Burkina\ Faso",
    'bg'  => 'Bulgaria',
    'bh'  => 'བཧ་རེན',
    'bi'  => 'Burundi',
    'bj'  => 'Benin',
    'bl'  => "Saint\ Barth\Ã\©lemy",
    'bm'  => 'Bermuda',
    'bn'  => 'Brunei',
    'bo'  => 'Bolivia',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'བཱརཱ་ཛིལ',
    'bs'  => 'Bahamas',
    'bt'  => 'འབྲུག',
    'bv'  => "Bouvet\ Island",
    'bw'  => 'Botswana',
    'by'  => 'Belarus',
    'bz'  => 'Belize',
    'ca'  => 'ཀེ་ན་ཌ',
    'cc'  => "Cocos\ \[Keeling\]\ Islands",
    'cd'  => "Congo\ \[DRC\]",
    'cf'  => "Central\ African\ Republic",
    'cg'  => "Congo\ \[Republic\]",
    'ch'  => 'སུའིཊ་ཛར་ལེན',
    'ci'  => "Ivory\ Coast",
    'ck'  => "Cook\ Islands",
    'cl'  => 'Chile',
    'cm'  => 'Cameroon',
    'cn'  => 'རྒྱ་མི',
    'co'  => 'Colombia',
    'cp'  => "Clipperton\ Island",
    'cr'  => "Costa\ Rica",
    'cs'  => "Serbia\ and\ Montenegro",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'ཀིའུ་སྦ',
    'cv'  => "Cape\ Verde",
    'cx'  => "Christmas\ Island",
    'cy'  => 'Cyprus',
    'cz'  => 'ཅེཀ་རི་པབ་ལིཀ',
    'dd'  => "East\ Germany",
    'de'  => 'ཇཱར་མ་ནི',
    'dg'  => "Diego\ Garcia",
    'dj'  => 'Djibouti',
    'dk'  => 'ཌེན་མཱཀ',
    'dm'  => 'Dominica',
    'do'  => "Dominican\ Republic",
    'dz'  => 'Algeria',
    'ea'  => "Ceuta\ and\ Melilla",
    'ec'  => 'Ecuador',
    'ee'  => 'Estonia',
    'eg'  => 'ཨི་ཇིཔཊ',
    'eh'  => "Western\ Sahara",
    'er'  => 'Eritrea',
    'es'  => 'སིཔཱེན',
    'et'  => 'Ethiopia',
    'eu'  => "European\ Union",
    'fi'  => 'ཕིན་ལེནཌ',
    'fj'  => 'Fiji',
    'fk'  => "Falkland\ Islands\ \[Islas\ Malvinas\]",
    'fm'  => 'Micronesia',
    'fo'  => "Faroe\ Islands",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'ཕརཱནསི',
    'fx'  => "Metropolitan\ France",
    'ga'  => 'Gabon',
    'gb'  => 'ཡུ་ནའི་ཊེཊ་ཀིང་ཌམ',
    'gd'  => 'Grenada',
    'ge'  => 'Georgia',
    'gf'  => "French\ Guiana",
    'gg'  => 'Guernsey',
    'gh'  => 'Ghana',
    'gi'  => 'Gibraltar',
    'gl'  => 'Greenland',
    'gm'  => 'Gambia',
    'gn'  => 'Guinea',
    'gp'  => 'Guadeloupe',
    'gq'  => "Equatorial\ Guinea",
    'gr'  => 'གིརིསི',
    'gs'  => "South\ Georgia\ and\ the\ South\ Sandwich\ Islands",
    'gt'  => 'Guatemala',
    'gu'  => 'Guam',
    'gw'  => "Guinea\-Bissau",
    'gy'  => 'Guyana',
    'hk'  => 'ཧོང་ཀོང',
    'hm'  => "Heard\ Island\ and\ McDonald\ Islands",
    'hn'  => 'Honduras',
    'hr'  => 'Croatia',
    'ht'  => 'Haiti',
    'hu'  => 'Hungary',
    'ic'  => "Canary\ Islands",
    'id'  => 'Indonesia',
    'ie'  => 'ཨའིརི་ལེནཌ',
    'il'  => 'ཨིཛ་རཱེལ',
    'im'  => "Isle\ of\ Man",
    'in'  => 'རྒྱ་གར',
    'io'  => "British\ Indian\ Ocean\ Territory",
    'iq'  => 'ཨི་རཀ',
    'ir'  => 'ཨི་རཱན',
    'is'  => 'ཨའིསི་ལེནཌ',
    'it'  => 'ཨྀཊ་ལི',
    'je'  => 'Jersey',
    'jm'  => 'ཇ་མའི་ཀ',
    'jo'  => 'Jordan',
    'jp'  => 'ཇ་པཱན',
    'jt'  => "Johnston\ Island",
    'ke'  => 'ཀེ་ནི་ཡ',
    'kg'  => 'Kyrgyzstan',
    'kh'  => 'ཀམ་བོ་ཌི་ཡ',
    'ki'  => 'Kiribati',
    'km'  => 'Comoros',
    'kn'  => "Saint\ Kitts\ and\ Nevis",
    'kp'  => 'བྱང་ཀོ་རི་ཡ',
    'kr'  => 'ལྷོ་ཀོ་རི་ཡ',
    'kw'  => 'ཀུ་ཝེཊ',
    'ky'  => "Cayman\ Islands",
    'kz'  => 'Kazakhstan',
    'la'  => 'ལ་འོསུ',
    'lb'  => 'ལེ་བཱ་ནཱོན',
    'lc'  => "Saint\ Lucia",
    'li'  => 'Liechtenstein',
    'lk'  => 'ཤྲཱྀ་ལངཀ',
    'lr'  => 'Liberia',
    'ls'  => 'Lesotho',
    'lt'  => 'Lithuania',
    'lu'  => 'Luxembourg',
    'lv'  => 'Latvia',
    'ly'  => 'Libya',
    'ma'  => 'Morocco',
    'mc'  => 'Monaco',
    'md'  => 'Moldova',
    'me'  => 'Montenegro',
    'mf'  => "Saint\ Martin",
    'mg'  => 'Madagascar',
    'mh'  => "Marshall\ Islands",
    'mi'  => "Midway\ Islands",
    'mk'  => "Macedonia\ \[FYROM\]",
    'ml'  => 'Mali',
    'mm'  => 'མེ་མར',
    'mn'  => 'སོག་པོ',
    'mo'  => 'Macau',
    'mp'  => "Northern\ Mariana\ Islands",
    'mq'  => 'Martinique',
    'mr'  => 'Mauritania',
    'ms'  => 'མོན་ས་རཊི',
    'mt'  => 'Malta',
    'mu'  => 'མོ་རི་ཤིཡསི',
    'mv'  => 'མཱལ་ཌིབས',
    'mw'  => 'Malawi',
    'mx'  => 'མེཀསི་ཀོ',
    'my'  => 'མ་ལེ་ཤི་ཡ',
    'mz'  => 'Mozambique',
    'na'  => 'Namibia',
    'nc'  => "New\ Caledonia",
    'ne'  => 'Niger',
    'nf'  => "Norfolk\ Island",
    'ng'  => 'Nigeria',
    'ni'  => 'Nicaragua',
    'nl'  => 'ནེ་དར་ལེནཌསི',
    'no'  => 'ནོ་ཝེ',
    'np'  => 'བལ་ཡུལ',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Nauru',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Niue',
    'nz'  => 'ནིའུ་ཛི་ལེནཌ',
    'om'  => 'Oman',
    'pa'  => 'པ་ན་མཱ',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'Peru',
    'pf'  => "French\ Polynesia",
    'pg'  => "Papua\ New\ Guinea",
    'ph'  => 'Philippines',
    'pk'  => 'པ་ཀིསི་ཏཱན',
    'pl'  => 'Poland',
    'pm'  => "Saint\ Pierre\ and\ Miquelon",
    'pn'  => "Pitcairn\ Islands",
    'pr'  => "Puerto\ Rico",
    'ps'  => "པེ་ལིསི་ཊི་ནིཡ\ ན་ཊེ་རི་ངོ་རི",
    'pt'  => 'པོར་ཅུ་གལ',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Palau',
    'py'  => 'Paraguay',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'ཀ་ཏར',
    'qo'  => "Outlying\ Oceania",
    're'  => "R\Ã\©union",
    'ro'  => 'Romania',
    'rs'  => 'Serbia',
    'ru'  => 'Russia',
    'rw'  => 'Rwanda',
    'sa'  => 'སའུ་དི་ཨེ་ར་སྦི་ཡ',
    'sb'  => "Solomon\ Islands",
    'sc'  => 'Seychelles',
    'sd'  => 'Sudan',
    'se'  => 'སུའི་ཌན',
    'sg'  => 'Singapore',
    'sh'  => "Saint\ Helena",
    'si'  => 'སིལོ་བེ་ནི་ཡ',
    'sj'  => "Svalbard\ and\ Jan\ Mayen",
    'sk'  => 'Slovakia',
    'sl'  => "Sierra\ Leone",
    'sm'  => "San\ Marino",
    'sn'  => 'Senegal',
    'so'  => 'Somalia',
    'sr'  => 'Suriname',
    'st'  => "S\Ã\£o\ Tom\Ã\©\ and\ Pr\Ã\­ncipe",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => "El\ Salvador",
    'sy'  => 'Syria',
    'sz'  => 'Swaziland',
    'ta'  => "Tristan\ da\ Cunha",
    'tc'  => "Turks\ and\ Caicos\ Islands",
    'td'  => 'Chad',
    'tf'  => "French\ Southern\ Territories",
    'tg'  => 'Togo',
    'th'  => 'ཐཱའི་ལེནཌ',
    'tj'  => 'ཏ་ཇག་ཀིསི་ཏཱན',
    'tk'  => 'Tokelau',
    'tl'  => "East\ Timor",
    'tm'  => 'Turkmenistan',
    'tn'  => 'Tunisia',
    'to'  => 'Tonga',
    'tr'  => 'Turkey',
    'tt'  => "Trinidad\ and\ Tobago",
    'tv'  => 'Tuvalu',
    'tw'  => 'ཏའི་ཝཱན',
    'tz'  => 'Tanzania',
    'ua'  => 'Ukraine',
    'ug'  => 'Uganda',
    'um'  => "U\.S\.\ Minor\ Outlying\ Islands",
    'us'  => 'ཡུ་ནའིཊེཊ་སི་ཊེསི',
    'uy'  => 'Uruguay',
    'uz'  => 'ཨུཛ་བེ་ཀིསི་ཏཱན',
    'va'  => "Vatican\ City",
    'vc'  => "Saint\ Vincent\ and\ the\ Grenadines",
    'vd'  => "North\ Vietnam",
    've'  => 'Venezuela',
    'vg'  => "British\ Virgin\ Islands",
    'vi'  => "U\.S\.\ Virgin\ Islands",
    'vn'  => 'བེཊ་ནཱམ',
    'vu'  => 'Vanuatu',
    'wf'  => "Wallis\ and\ Futuna",
    'wk'  => "Wake\ Island",
    'ws'  => 'Samoa',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'Yemen',
    'yt'  => 'Mayotte',
    'za'  => 'སའུཐ་ཨཕ་རི་ཀ',
    'zm'  => 'ཛམ་བི་ཡ',
    'zw'  => 'ཛིམ་བབ་ཝེ',
    'zz'  => "Unknown\ Region",
);

%Locales::DB::Territory::dz::name_to_code = (
    'africa'                                                                            => '002',
    'albania'                                                                           => 'al',
    'algeria'                                                                           => 'dz',
    'americansamoa'                                                                     => 'as',
    'americas'                                                                          => '019',
    'andorra'                                                                           => 'ad',
    'angola'                                                                            => 'ao',
    'anguilla'                                                                          => 'ai',
    'antiguaandbarbuda'                                                                 => 'ag',
    'armenia'                                                                           => 'am',
    'aruba'                                                                             => 'aw',
    'ascensionisland'                                                                   => 'ac',
    'asia'                                                                              => 142,
    'australiaandnewzealand'                                                            => '053',
    'azerbaijan'                                                                        => 'az',
    'bahamas'                                                                           => 'bs',
    'barbados'                                                                          => 'bb',
    'belarus'                                                                           => 'by',
    'belize'                                                                            => 'bz',
    'benin'                                                                             => 'bj',
    'bermuda'                                                                           => 'bm',
    'bolivia'                                                                           => 'bo',
    'bosniaandherzegovina'                                                              => 'ba',
    'botswana'                                                                          => 'bw',
    'bouvetisland'                                                                      => 'bv',
    'britishantarcticterritory'                                                         => 'bq',
    'britishindianoceanterritory'                                                       => 'io',
    'britishvirginislands'                                                              => 'vg',
    'brunei'                                                                            => 'bn',
    'bulgaria'                                                                          => 'bg',
    'burkinafaso'                                                                       => 'bf',
    'burundi'                                                                           => 'bi',
    'cameroon'                                                                          => 'cm',
    'canaryislands'                                                                     => 'ic',
    'cantonandenderburyislands'                                                         => 'ct',
    'capeverde'                                                                         => 'cv',
    'caribbean'                                                                         => '029',
    'caymanislands'                                                                     => 'ky',
    'centralafricanrepublic'                                                            => 'cf',
    'centralamerica'                                                                    => '013',
    'centralasia'                                                                       => 143,
    'ceutaandmelilla'                                                                   => 'ea',
    'chad'                                                                              => 'td',
    'channelislands'                                                                    => 830,
    'chile'                                                                             => 'cl',
    'christmasisland'                                                                   => 'cx',
    'clippertonisland'                                                                  => 'cp',
    'cocoskeelingislands'                                                               => 'cc',
    'colombia'                                                                          => 'co',
    'commonwealthofindependentstates'                                                   => 172,
    'comoros'                                                                           => 'km',
    'congodrc'                                                                          => 'cd',
    'congorepublic'                                                                     => 'cg',
    'cookislands'                                                                       => 'ck',
    'costarica'                                                                         => 'cr',
    'croatia'                                                                           => 'hr',
    'cyprus'                                                                            => 'cy',
    'czechoslovakia'                                                                    => 200,
    'diegogarcia'                                                                       => 'dg',
    'djibouti'                                                                          => 'dj',
    'dominica'                                                                          => 'dm',
    'dominicanrepublic'                                                                 => 'do',
    'dronningmaudland'                                                                  => 'nq',
    'easternafrica'                                                                     => '014',
    'easternasia'                                                                       => '030',
    'easterneurope'                                                                     => 151,
    'eastgermany'                                                                       => 'dd',
    'easttimor'                                                                         => 'tl',
    'ecuador'                                                                           => 'ec',
    'elsalvador'                                                                        => 'sv',
    'equatorialguinea'                                                                  => 'gq',
    'eritrea'                                                                           => 'er',
    'estonia'                                                                           => 'ee',
    'ethiopia'                                                                          => 'et',
    'europe'                                                                            => 150,
    'europeanunion'                                                                     => 'eu',
    'falklandislandsislasmalvinas'                                                      => 'fk',
    'faroeislands'                                                                      => 'fo',
    'fiji'                                                                              => 'fj',
    'frenchguiana'                                                                      => 'gf',
    'frenchpolynesia'                                                                   => 'pf',
    'frenchsouthernandantarcticterritories'                                             => 'fq',
    'frenchsouthernterritories'                                                         => 'tf',
    'gabon'                                                                             => 'ga',
    'gambia'                                                                            => 'gm',
    'georgia'                                                                           => 'ge',
    'ghana'                                                                             => 'gh',
    'gibraltar'                                                                         => 'gi',
    'greenland'                                                                         => 'gl',
    'grenada'                                                                           => 'gd',
    'guadeloupe'                                                                        => 'gp',
    'guam'                                                                              => 'gu',
    'guatemala'                                                                         => 'gt',
    'guernsey'                                                                          => 'gg',
    'guinea'                                                                            => 'gn',
    'guineabissau'                                                                      => 'gw',
    'guyana'                                                                            => 'gy',
    'haiti'                                                                             => 'ht',
    'heardislandandmcdonaldislands'                                                     => 'hm',
    'honduras'                                                                          => 'hn',
    'hungary'                                                                           => 'hu',
    'indonesia'                                                                         => 'id',
    'isleofman'                                                                         => 'im',
    'ivorycoast'                                                                        => 'ci',
    'jersey'                                                                            => 'je',
    'johnstonisland'                                                                    => 'jt',
    'jordan'                                                                            => 'jo',
    'kazakhstan'                                                                        => 'kz',
    'kiribati'                                                                          => 'ki',
    'kyrgyzstan'                                                                        => 'kg',
    'latinamerica'                                                                      => 419,
    'latvia'                                                                            => 'lv',
    'lesotho'                                                                           => 'ls',
    'liberia'                                                                           => 'lr',
    'libya'                                                                             => 'ly',
    'liechtenstein'                                                                     => 'li',
    'lithuania'                                                                         => 'lt',
    'luxembourg'                                                                        => 'lu',
    'macau'                                                                             => 'mo',
    'macedoniafyrom'                                                                    => 'mk',
    'madagascar'                                                                        => 'mg',
    'malawi'                                                                            => 'mw',
    'mali'                                                                              => 'ml',
    'malta'                                                                             => 'mt',
    'marshallislands'                                                                   => 'mh',
    'martinique'                                                                        => 'mq',
    'mauritania'                                                                        => 'mr',
    'mayotte'                                                                           => 'yt',
    'melanesia'                                                                         => '054',
    'metropolitanfrance'                                                                => 'fx',
    'micronesia'                                                                        => 'fm',
    'micronesianregion'                                                                 => '057',
    'middleafrica'                                                                      => '017',
    'midwayislands'                                                                     => 'mi',
    'moldova'                                                                           => 'md',
    'monaco'                                                                            => 'mc',
    'montenegro'                                                                        => 'me',
    'morocco'                                                                           => 'ma',
    'mozambique'                                                                        => 'mz',
    'namibia'                                                                           => 'na',
    'nauru'                                                                             => 'nr',
    'netherlandsantilles'                                                               => 'an',
    'neutralzone'                                                                       => 'nt',
    'newcaledonia'                                                                      => 'nc',
    'nicaragua'                                                                         => 'ni',
    'niger'                                                                             => 'ne',
    'nigeria'                                                                           => 'ng',
    'niue'                                                                              => 'nu',
    'norfolkisland'                                                                     => 'nf',
    'northamerica'                                                                      => '003',
    'northernafrica'                                                                    => '015',
    'northernamerica'                                                                   => '021',
    'northerneurope'                                                                    => 154,
    'northernmarianaislands'                                                            => 'mp',
    'northvietnam'                                                                      => 'vd',
    'oceania'                                                                           => '009',
    'oman'                                                                              => 'om',
    'outlyingoceania'                                                                   => 'qo',
    'pacificislandstrustterritory'                                                      => 'pc',
    'palau'                                                                             => 'pw',
    'panamacanalzone'                                                                   => 'pz',
    'papuanewguinea'                                                                    => 'pg',
    'paraguay'                                                                          => 'py',
    "people\â\\sdemocraticrepublicofyemen"                                         => 'yd',
    'peru'                                                                              => 'pe',
    'philippines'                                                                       => 'ph',
    'pitcairnislands'                                                                   => 'pn',
    'poland'                                                                            => 'pl',
    'polynesia'                                                                         => '061',
    'puertorico'                                                                        => 'pr',
    'romania'                                                                           => 'ro',
    'russia'                                                                            => 'ru',
    'rwanda'                                                                            => 'rw',
    "r\Ã\©union"                                                                      => 're',
    "saintbarth\Ã\©lemy"                                                              => 'bl',
    'sainthelena'                                                                       => 'sh',
    'saintkittsandnevis'                                                                => 'kn',
    'saintlucia'                                                                        => 'lc',
    'saintmartin'                                                                       => 'mf',
    'saintpierreandmiquelon'                                                            => 'pm',
    'saintvincentandthegrenadines'                                                      => 'vc',
    'samoa'                                                                             => 'ws',
    'sanmarino'                                                                         => 'sm',
    'senegal'                                                                           => 'sn',
    'serbia'                                                                            => 'rs',
    'serbiaandmontenegro'                                                               => 'cs',
    'seychelles'                                                                        => 'sc',
    'sierraleone'                                                                       => 'sl',
    'singapore'                                                                         => 'sg',
    'slovakia'                                                                          => 'sk',
    'solomonislands'                                                                    => 'sb',
    'somalia'                                                                           => 'so',
    'southamerica'                                                                      => '005',
    'southcentralasia'                                                                  => '062',
    'southeasternasia'                                                                  => '035',
    'southernafrica'                                                                    => '018',
    'southernasia'                                                                      => '034',
    'southerneurope'                                                                    => '039',
    'southgeorgiaandthesouthsandwichislands'                                            => 'gs',
    'sudan'                                                                             => 'sd',
    'suriname'                                                                          => 'sr',
    'svalbardandjanmayen'                                                               => 'sj',
    'swaziland'                                                                         => 'sz',
    'syria'                                                                             => 'sy',
    "s\Ã\£otom\Ã\©andpr\Ã\­ncipe"                                                 => 'st',
    'tanzania'                                                                          => 'tz',
    'togo'                                                                              => 'tg',
    'tokelau'                                                                           => 'tk',
    'tonga'                                                                             => 'to',
    'trinidadandtobago'                                                                 => 'tt',
    'tristandacunha'                                                                    => 'ta',
    'tunisia'                                                                           => 'tn',
    'turkey'                                                                            => 'tr',
    'turkmenistan'                                                                      => 'tm',
    'turksandcaicosislands'                                                             => 'tc',
    'tuvalu'                                                                            => 'tv',
    "u\.s\.minoroutlyingislands"                                                        => 'um',
    "u\.s\.miscellaneouspacificislands"                                                 => 'pu',
    "u\.s\.virginislands"                                                               => 'vi',
    'uganda'                                                                            => 'ug',
    'ukraine'                                                                           => 'ua',
    'unionofsovietsocialistrepublics'                                                   => 'su',
    'unknownregion'                                                                     => 'zz',
    'uruguay'                                                                           => 'uy',
    'vanuatu'                                                                           => 'vu',
    'vaticancity'                                                                       => 'va',
    'venezuela'                                                                         => 've',
    'wakeisland'                                                                        => 'wk',
    'wallisandfutuna'                                                                   => 'wf',
    'westernafrica'                                                                     => '011',
    'westernasia'                                                                       => 145,
    'westerneurope'                                                                     => 155,
    'westernsahara'                                                                     => 'eh',
    'world'                                                                             => '001',
    'yemen'                                                                             => 'ye',
    "\Ã\landislands"                                                                 => 'ax',
    'ཀ་ཏར'                                                                      => 'qa',
    'ཀམ་བོ་ཌི་ཡ'                                                    => 'kh',
    'ཀིའུ་སྦ'                                                             => 'cu',
    'ཀུ་ཝེཊ'                                                                => 'kw',
    'ཀེ་ན་ཌ'                                                                => 'ca',
    'ཀེ་ནི་ཡ'                                                             => 'ke',
    'གིརིསི'                                                                => 'gr',
    'ཅེཀ་རི་པབ་ལིཀ'                                           => 'cz',
    'ཇ་པཱན'                                                                   => 'jp',
    'ཇ་མའི་ཀ'                                                             => 'jm',
    'ཇཱར་མ་ནི'                                                          => 'de',
    'ཌེན་མཱཀ'                                                             => 'dk',
    'ཏ་ཇག་ཀིསི་ཏཱན'                                           => 'tj',
    'ཏའི་ཝཱན'                                                             => 'tw',
    'ཐཱའི་ལེནཌ'                                                       => 'th',
    'ནིའུ་ཛི་ལེནཌ'                                              => 'nz',
    'ནེ་དར་ལེནཌསི'                                              => 'nl',
    'ནོ་ཝེ'                                                                   => 'no',
    'པ་ཀིསི་ཏཱན'                                                    => 'pk',
    'པ་ན་མཱ'                                                                => 'pa',
    'པེ་ལིསི་ཊི་ནིཡན་ཊེ་རི་ངོ་རི' => 'ps',
    'པོར་ཅུ་གལ'                                                       => 'pt',
    'ཕརཱནསི'                                                                => 'fr',
    'ཕིན་ལེནཌ'                                                          => 'fi',
    'བངྒ་ལ་དེཤ'                                                       => 'bd',
    'བལ་ཡུལ'                                                                => 'np',
    'བཧ་རེན'                                                                => 'bh',
    'བཱརཱ་ཛིལ'                                                          => 'br',
    'བེཊ་ནཱམ'                                                             => 'vn',
    'བེལ་ཇིཡམ'                                                          => 'be',
    'བྱང་ཀོ་རི་ཡ'                                                 => 'kp',
    'མ་ལེ་ཤི་ཡ'                                                       => 'my',
    'མཱལ་ཌིབས'                                                          => 'mv',
    'མེ་མར'                                                                   => 'mm',
    'མེཀསི་ཀོ'                                                          => 'mx',
    'མོ་རི་ཤིཡསི'                                                 => 'mu',
    'མོན་ས་རཊི'                                                       => 'ms',
    'ཛམ་བི་ཡ'                                                             => 'zm',
    'ཛིམ་བབ་ཝེ'                                                       => 'zw',
    'འབྲུག'                                                                   => 'bt',
    'ཡུ་ནའི་ཊེཊ་ཀིང་ཌམ'                               => 'gb',
    'ཡུ་ནའི་ཊེཊ་ཨ་རབ་ཨེ་མི་རེཊསི' => 'ae',
    'ཡུ་ནའིཊེཊ་སི་ཊེསི'                               => 'us',
    'རྒྱ་གར'                                                                => 'in',
    'རྒྱ་མི'                                                                => 'cn',
    'ལ་འོསུ'                                                                => 'la',
    'ལེ་བཱ་ནཱོན'                                                    => 'lb',
    'ལྷོ་ཀོ་རི་ཡ'                                                 => 'kr',
    'ཤྲཱྀ་ལངཀ'                                                          => 'lk',
    'སའུ་དི་ཨེ་ར་སྦི་ཡ'                               => 'sa',
    'སའུཐ་ཨཕ་རི་ཀ'                                              => 'za',
    'སིཔཱེན'                                                                => 'es',
    'སིལོ་བེ་ནི་ཡ'                                              => 'si',
    'སུའི་ཌན'                                                             => 'se',
    'སུའིཊ་ཛར་ལེན'                                              => 'ch',
    'སོག་པོ'                                                                => 'mn',
    'ཧོང་ཀོང'                                                             => 'hk',
    'ཨཕ་ག་ནིསི་ཏཱན'                                           => 'af',
    'ཨའིརི་ལེནཌ'                                                    => 'ie',
    'ཨའིསི་ལེནཌ'                                                    => 'is',
    'ཨར་ཇེན་ཊི་ན'                                                 => 'ar',
    'ཨས་ཊི་ཡ'                                                             => 'at',
    'ཨས་ཊེཡེ་ལི་ཡ'                                              => 'au',
    'ཨི་ཇིཔཊ'                                                             => 'eg',
    'ཨི་རཀ'                                                                   => 'iq',
    'ཨི་རཱན'                                                                => 'ir',
    'ཨིཛ་རཱེལ'                                                          => 'il',
    'ཨུཛ་བེ་ཀིསི་ཏཱན'                                     => 'uz',
    'ཨེན་ཊཱག་ཊི་ཀ'                                              => 'aq',
    'ཨྀཊ་ལི'                                                                => 'it',
);

1;

