# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::UA;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20220903144943;

my $formatters = [
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            6[12][29]|
            (?:
              35|
              4[1378]|
              5[12457]|
              6[49]
            )2|
            (?:
              56|
              65
            )[24]|
            (?:
              3[1-46-8]|
              46
            )2[013-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[1-8]|
            4(?:
              [1367]|
              [45][6-9]|
              8[4-6]
            )|
            5(?:
              [1-5]|
              6(?:
                [015689]|
                3[02389]
              )|
              7[4-6]
            )|
            6(?:
              [12][3-7]|
              [459]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [3-7]|
            89|
            9[1-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[89]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3,4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            3[1-8]|
            4[13-8]|
            5[1-7]|
            6[12459]
          )\\d{7}
        ',
                'geographic' => '
          (?:
            3[1-8]|
            4[13-8]|
            5[1-7]|
            6[12459]
          )\\d{7}
        ',
                'mobile' => '
          (?:
            39|
            50|
            6[36-8]|
            7[1-3]|
            9[1-9]
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(900[239]\\d{5,6})',
                'toll_free' => '800[1-8]\\d{5,6}',
                'voip' => '89[1-579]\\d{6}'
              };
my %areanames = ();
$areanames{en} = {"380329", "Lviv",
"3804656", "Carp\,\ Chernihiv",
"3803133", "Svalyava\,\ Zakarpattia",
"3806278", "Marinka\,\ Donetsk",
"3803247", "Truskavets\,\ Lviv",
"3804864", "Lyubashevka\,\ Odesa",
"3805341", "Semenivka\,\ Poltava",
"38048", "Odesa",
"3805233", "Znamenka\,\ Kirovohrad",
"3804591", "Ivankiv\,\ Kyiv",
"3805746", "Chuguev\,\ Kharkiv",
"3805631", "Petropavlovka\,\ Dnipro",
"3806138", "Kamyanets\'\-Dniprovs\'ka\,\ Zaporizhzhia",
"3805240", "Kompaniyivka\,\ Kirovohrad",
"3804744", "Uman\,\ Cherkasy",
"3804358", "Lipovets\,\ Vinnytsia",
"3803847", "New\ Ushitsa\,\ Khmelnytskyi",
"3806267", "Druzhkovka\,\ Donetsk",
"3805235", "Alexandria\,\ Kirovohrad",
"3805532", "Great\ Aleksandrovka\,\ Kherson",
"3805654", "Krynychky\,\ Dnipro",
"3803135", "Great\ Berezny\,\ Zakarpattia",
"3806459", "Luhansk",
"3804748", "Mankivka\,\ Cherkasy",
"3804137", "Popilnya\,\ Zhytomyr",
"3803550", "Zbarazh\,\ Ternopil",
"3803269", "Turka\,\ Lviv",
"3804736", "Kaniv\,\ Cherkasy",
"3805658", "Verhnedneprovsk\,\ Dnipro",
"3804331", "Bratslav\/Nemyriv\,\ Vinnytsia",
"3804845", "Artsis\,\ Odesa",
"380312", "Uzhgorod\/Chop\,\ Zakarpattia",
"3804843", "Wilkow\/Kielia\,\ Odesa",
"3804641", "Rivers\,\ Chernihiv",
"3805751", "Shevchenkovo\,\ Kharkiv",
"3803432", "Verkhovyna\,\ Ivano\-Frankivsk",
"3806249", "Debaltsevo\,\ Donetsk",
"3805356", "Lokhvytsia\,\ Poltava",
"380522", "Kropyvnytskyi\,\ Kirovohrad",
"3806274", "Artemivsk\/Siversk\,\ Donetsk",
"3804868", "Illichivsk\,\ Odesa",
"3804338", "Khmilnyk\,\ Vinnytsia",
"3805443", "Belopoly\,\ Sumy",
"3804575", "Yagotin\,\ Kyiv",
"3805255", "Novorangels\'k\,\ Kirovohrad",
"3805651", "Dnipropetrovsk\/Dnipro",
"3803437", "Bolechov\,\ Ivano\-Frankivsk",
"3805634", "Petrykivka\,\ Dnipro",
"3804741", "Shpola\,\ Cherkasy",
"3804346", "Pogrebishche\,\ Vinnytsia",
"3804861", "Red\ Windows\,\ Odesa",
"3805344", "New\ Sanzhary\,\ Poltava",
"3804636", "Varva\,\ Chernihiv",
"3805758", "Bogodukhiv\,\ Kharkiv",
"3804594", "Brovary\/Kalita\,\ Kyiv",
"38035", "Ternopil",
"3805445", "Lebedin\,\ Sumy",
"3804573", "Kagarlyk\/Rzhyshchiv\,\ Kyiv",
"3804132", "Radomyshl\,\ Zhytomyr",
"3805253", "Dobrovelichkovka\,\ Kirovohrad",
"3805754", "Gemini\,\ Kharkiv",
"3804598", "Boyarka\/Vishnevoe\,\ Kyiv",
"3804569", "Volodarka\,\ Kyiv",
"3806271", "Artemivsk\,\ Donetsk",
"3805348", "Komsomolsk\,\ Poltava",
"3806262", "Svyatogorsk\/Slavyansk\,\ Donetsk",
"3805537", "Lazurne\/Skadovsk\,\ Kherson",
"3805660", "Nikopol\,\ Dnipro",
"3803842", "Netishyn\/Slavuta\,\ Khmelnytskyi",
"380628", "Donetsk",
"3803543", "Podvolochisk\,\ Ternopil",
"3805363", "Reshetilivka\,\ Poltava",
"3804644", "Mena\,\ Chernihiv",
"3805365", "Globin\,\ Poltava",
"3804334", "Haysin\,\ Vinnytsia",
"3806439", "Luhansk",
"3803242", "Lviv",
"38054", "Sumy",
"3804351", "Chechelnyk\,\ Vinnytsia",
"3803376", "Manevichi\,\ Volyn",
"3804850", "Teplodar\,\ Odesa",
"3805638", "Pokrovskoe\,\ Dnipro",
"3806131", "Yakimivka\,\ Zaporizhzhia",
"3803122", "Uzhhorod\,\ Zakarpattia",
"3806132", "Mikhailivka\,\ Zaporizhzhia",
"3804352", "Bershad\,\ Vinnytsia",
"3805538", "Askania\-Nova\/Chaplinka\,\ Kherson",
"3805546", "Berislav\,\ Kherson",
"3805347", "Chutovoye\,\ Poltava",
"3805449", "Shostka\,\ Sumy",
"3803241", "Nikolaev\,\ Lviv",
"3803366", "Ratne\,\ Volyn",
"380642", "Luhansk\/Oleksandrivsk\,\ Luhansk",
"3804597", "Bucha\/Vorzel\/Gostomel\/Irpen\/Kotsyubinskoe\,\ Kyiv",
"3804579", "Slavutych\,\ Kyiv",
"3805259", "Ulyanovka\,\ Kirovohrad",
"3805637", "Pavlograd\,\ Dnipro",
"3806261", "Krasny\ Liman\,\ Donetsk",
"3803841", "Belogorsk\,\ Khmelnytskyi",
"3806272", "Kostiantynivka\,\ Donetsk",
"3803434", "Vorokhta\/Yaremche\,\ Ivano\-Frankivsk",
"3803856", "Derazhnya\,\ Khmelnytskyi",
"3806440", "Luhansk",
"3803549", "Lanovtsi\,\ Ternopil",
"3806435", "Krasnodon\,\ Luhansk",
"3804131", "Chervonoarmiysk\,\ Zhytomyr",
"3805369", "Kremenchug\,\ Poltava",
"3803438", "Burshtyn\,\ Ivano\-Frankivsk",
"3804563", "Belaya\ Tserkov\/Uzin\,\ Kyiv",
"38036", "Rivne",
"3804862", "Kotovsk\,\ Odesa",
"3804337", "Mogilev\-Podolsky\,\ Vinnytsia",
"3804565", "Fastov\,\ Kyiv",
"3805534", "Genichesk\,\ Kherson",
"3804742", "Katerinopil\,\ Cherkasy",
"3806466", "Belovodsk\,\ Luhansk",
"3805652", "Yellow\ Waters\,\ Dnipro",
"3805757", "Barvinkov\,\ Kharkiv",
"3806250", "Kirovske\,\ Donetsk",
"380332", "Lutsk\,\ Volyn",
"3803256", "Novoyavorivsk\,\ Lviv",
"3806433", "Rovenky\,\ Luhansk",
"3803355", "Shatsk\,\ Volyn",
"3805752", "Great\ Burluk\,\ Kharkiv",
"3805239", "Ustinovka\,\ Kirovohrad",
"3803431", "Halych\,\ Ivano\-Frankivsk",
"3805657", "Broad\,\ Dnipro",
"3804146", "Dzerzhinsk\,\ Zhytomyr",
"3804747", "Zhashkiv\,\ Cherkasy",
"3804138", "Ruzhin\,\ Zhytomyr",
"3804642", "Sedimentary\,\ Chernihiv",
"3806264", "Kramatorsk\,\ Donetsk",
"3803844", "Theophyll\,\ Khmelnytskyi",
"3804867", "Kodima\,\ Odesa",
"3804332", "Brailiv\/Zhmerinka\,\ Vinnytsia",
"38037", "Chernivtsi",
"3803244", "Drogobych\,\ Lviv",
"3803650", "Goshcha\,\ Rivne",
"3805136", "Yuzhnoukrainsk\,\ Mykolayiv",
"3805163", "Veselinove\,\ Mykolayiv",
"380320", "Lviv",
"3803248", "Boryslav\/Skhidnytsya\,\ Lviv",
"3806277", "Dobropolia\,\ Donetsk",
"3803236", "Sambir\,\ Lviv",
"3806453", "Rubizhne\,\ Luhansk",
"3806245", "Gorlovka\,\ Donetsk",
"3805531", "Ivanivka\,\ Kherson",
"3805632", "Pavlograd\,\ Dnipro",
"3803263", "Peremyshlyany\,\ Lviv",
"3806455", "Pervomaisk\,\ Luhansk",
"3806243", "Great\ Novosilka\,\ Donetsk",
"3803730", "Vyzhnytsia\,\ Chernivtsi",
"380561", "Dnipropetrovsk\/Dnipro",
"3803265", "Zolochiv\,\ Lviv",
"3805342", "Kozelshchina\,\ Poltava",
"3806268", "Kramatorsk\/Slavyansk\,\ Donetsk",
"3804134", "Chernyakhov\,\ Zhytomyr",
"3806137", "Primorsk\,\ Zaporizhzhia",
"3804849", "Belgorod\-Dniester\/Zatoka\/Sergievka\,\ Odesa",
"3803633", "Radivilov\,\ Rivne",
"3805742", "Kupyansk\,\ Kharkiv",
"3803377", "Lyuboml\,\ Volyn",
"380569", "Dneprodzerzhinsk\/Novomoskovsk\,\ Dnipro",
"3803854", "Starokostiantyniv\,\ Khmelnytskyi",
"3803479", "Tlumach\,\ Ivano\-Frankivsk",
"3805548", "Novotroitsk\,\ Kherson",
"3803254", "Kamyanka\-Buzka\,\ Lviv",
"3803368", "Rozhysche\,\ Volyn",
"3806464", "Markovka\,\ Luhansk",
"3805131", "Bratsk\,\ Mykolayiv",
"3805154", "Ochakiv\,\ Mykolayiv",
"3803635", "Rokitne\,\ Rivne",
"3803231", "Gorodok\,\ Lviv",
"3805536", "Kakhovka\,\ Kherson",
"38033", "Volyn",
"3806468", "Luhansk",
"3804560", "Tetiev\,\ Kyiv",
"3804732", "Kamyanets\,\ Cherkasy",
"3804637", "Priluki\,\ Chernihiv",
"3803258", "Lviv",
"3805544", "Gornostaevka\,\ Kherson",
"3806443", "Bryanka\,\ Luhansk",
"3806255", "Shakhtarsk\,\ Donetsk",
"3805669", "Salt\,\ Dnipro",
"3805158", "Bashtanka\,\ Mykolayiv",
"3803436", "Tysmenytsia\,\ Ivano\-Frankivsk",
"3804141", "Novograd\-Volynsky\,\ Zhytomyr",
"3806445", "Novoyadar\,\ Luhansk",
"3806253", "Starobesheve\,\ Donetsk",
"3805352", "Shishaki\,\ Poltava",
"3806430", "Luhansk",
"3803858", "Dunaevtsi\,\ Khmelnytskyi",
"3804347", "Litin\,\ Vinnytsia",
"3804859", "Velikaya\ Mikhailovka\,\ Odesa",
"3806472", "Stanitsa\ Luhansk\,\ Luhansk",
"3805151", "Novy\ Buh\,\ Mykolayiv",
"3803234", "Mostyska\,\ Lviv",
"3804342", "Kozatin\,\ Vinnytsia",
"3805691", "Magdalenivka\,\ Dnipro",
"3803251", "Skole\/Slavske\,\ Lviv",
"3805459", "Krasnopolye\,\ Sumy",
"3805357", "Orzhitsa\,\ Poltava",
"3805134", "Voznesensk\,\ Mykolayiv",
"3806461", "Starobilsk\,\ Luhansk",
"3803655", "Sarny\,\ Rivne",
"3804136", "Andrushivka\,\ Zhytomyr",
"3803653", "Berezne\,\ Rivne",
"3803851", "Gorodok\/Sataniv\,\ Khmelnytskyi",
"380622", "Donetsk",
"3804632", "Bobrovitsa\,\ Chernihiv",
"3804737", "Zolotonosha\,\ Cherkasy",
"3804148", "Ovruch\,\ Zhytomyr",
"3806266", "Kramatorsk\/Slavyansk\,\ Donetsk",
"3803740", "Hertz\,\ Chernivtsi",
"3803846", "Vinkivtsi\,\ Khmelnytskyi",
"380619", "Melitopol\,\ Zaporizhzhia",
"3806450", "Luhansk",
"3803260", "Morshin\,\ Lviv",
"3803735", "Storozhynets\,\ Chernivtsi",
"3806175", "Vasilivka\/Dneprorudne\,\ Zaporizhzhia",
"3804144", "Baranivka\,\ Zhytomyr",
"3806147", "Kuybyshev\,\ Zaporizhzhia",
"3803238", "Old\ Sambir\,\ Lviv",
"3803372", "Ivanychi\,\ Volyn",
"3804657", "Koryukivka\,\ Chernihiv",
"3805747", "Snakes\,\ Kharkiv",
"3806240", "Gorlovka\,\ Donetsk",
"3803733", "Novoselytsia\,\ Chernivtsi",
"3803246", "Lviv",
"3805453", "Krolevets\,\ Sumy",
"3805542", "Tsyurupinsk\,\ Kherson",
"3803362", "Lubeshiv\,\ Volyn",
"3804734", "Chernigov\ region",
"3805765", "Pechenegi\,\ Kharkiv",
"3803145", "Perechyn\,\ Zakarpattia",
"3806136", "Веселе\,\ Zaporizhzhia",
"3804356", "Murovani\ Kurylivtsi\,\ Vinnytsia",
"3806276", "Artemivsk\,\ Donetsk",
"3805354", "Gadyach\,\ Poltava",
"3803143", "Vinogradov\,\ Zakarpattia",
"3806165", "Childbirth\,\ Zaporizhzhia",
"3805748", "Pervomaysk\,\ Kharkiv",
"3804658", "Novgorod\-Seversky\,\ Chernihiv",
"3805455", "Nedrigailov\,\ Sumy",
"3803659", "Mlyniv\,\ Rivne",
"3803237", "Lviv",
"3805763", "Carriers\,\ Kharkiv",
"38052", "Kirovohrad",
"3804631", "Nizhyn\,\ Chernihiv",
"3805744", "Krasnograd\,\ Kharkiv",
"3805358", "Pyriatyn\,\ Poltava",
"38037312", "Khotin\,\ Chernivtsi",
"3804866", "Balta\,\ Odesa",
"38031", "Zakarpattia",
"3803852", "Iziaslav\,\ Khmelnytskyi",
"3804654", "Shchors\,\ Chernihiv",
"3806239", "Krasnoarmeysk\,\ Donetsk",
"3804147", "Lyubar\,\ Zhytomyr",
"3804738", "Drabiv\,\ Cherkasy",
"3806144", "Novomikolaevka\,\ Zaporizhzhia",
"3806462", "Belokurakine\,\ Luhansk",
"3805656", "Apostolove\,\ Dnipro",
"3803252", "Zhovkva\,\ Lviv",
"3803555", "Monastery\,\ Ternopil",
"380648", "Luhansk",
"3803739", "Sokyryany\,\ Chernivtsi",
"3804341", "Bar\,\ Vinnytsia",
"3805692", "Dneprodzerzhinsk\,\ Dnipro",
"3806471", "Swatov\,\ Luhansk",
"3805152", "Domanivka\,\ Mykolayiv",
"3804746", "Monastyrysche\,\ Cherkasy",
"3804840", "Reni\,\ Odesa",
"3804646", "Desna\/Kozelets\/Oster\,\ Chernihiv",
"38044", "Kyiv\ city",
"3805351", "Dikanka\,\ Poltava",
"3803257", "Sokal\,\ Lviv",
"3805756", "Krasnokutsk\,\ Kharkiv",
"380564", "Krivoy\ Rog\,\ Dnipro",
"3804142", "Korosten\,\ Zhytomyr",
"3806467", "Luhansk",
"3805250", "Vilshanka\,\ Kirovohrad",
"3804570", "Zgurovka\,\ Kyiv",
"3803374", "Lokachi\,\ Volyn",
"3803857", "Letychiv\/Medzhybizh\,\ Khmelnytskyi",
"3804348", "Tomashpil\,\ Vinnytsia",
"3804336", "Yampil\,\ Vinnytsia",
"3803475", "Delyatin\/Nadvirna\,\ Ivano\-Frankivsk",
"3804731", "Talne\,\ Cherkasy",
"3806156", "Big\ Belozerka\,\ Zaporizhzhia",
"3803232", "Lviv",
"3806449", "Luhansk",
"3804344", "Shargorod\,\ Vinnytsia",
"3805663", "Sinelnikovo\,\ Dnipro",
"3806474", "Popasna\,\ Luhansk",
"3805636", "Ternivka\,\ Dnipro",
"3803540", "Meeting\,\ Ternopil",
"3805360", "Kremenchug\,\ Poltava",
"3806141", "Orychiv\,\ Zaporizhzhia",
"3805132", "Arbuzinka\,\ Mykolayiv",
"380560", "Dnipropetrovsk\/Dnipro",
"3804855", "Kominternovskoe\,\ Odesa",
"3804853", "Limanske\/Rozdilna\,\ Odesa",
"380647", "Luhansk",
"380321", "Lviv",
"3804596", "Vyshgorod\/Dimer\/Pirnove\,\ Kyiv",
"3805665", "Manganese\,\ Dnipro",
"3804634", "Talalayevka\,\ Chernihiv",
"3805741", "Vovchansk\,\ Kharkiv",
"3806259", "Amvrosievka\,\ Donetsk",
"3805346", "Karlovka\,\ Poltava",
"3805547", "Belozerka\,\ Kherson",
"3804659", "Semenivka\,\ Chernihiv",
"3803472", "Kalush\,\ Ivano\-Frankivsk",
"3803658", "Dubrovitsa\,\ Rivne",
"3805749", "Balaklia\,\ Kharkiv",
"3804143", "Berdychiv\,\ Zhytomyr",
"3806251", "Donetsk",
"3803557", "Gusyatin\,\ Ternopil",
"380623", "Krasnoarmeysk\/Makeyevka\,\ Donetsk",
"380322", "Bryukhovichi\/Lviv\,\ Lviv",
"3804130", "Korostyshiv\,\ Zhytomyr",
"3806441", "Perevalsk\,\ Luhansk",
"3804145", "Volodarsk\-Volynsky\,\ Zhytomyr",
"3803734", "Deep\,\ Chernivtsi",
"3803840", "Shepetovka\,\ Khmelnytskyi",
"3806456", "Trinity\ Church\,\ Luhansk",
"3805662", "Nikopol\,\ Dnipro",
"3803233", "Lviv",
"3806260", "Kramatorsk\/Slavyansk\,\ Donetsk",
"3803266", "Brody\,\ Lviv",
"380568", "Dnipropetrovsk\/Dnipro",
"3805133", "Creve\ Lake\,\ Mykolayiv",
"3804739", "Chernobyl\,\ Cherkasy",
"3806178", "Tokmak\,\ Zaporizhzhia",
"3803738", "Putila\,\ Chernivtsi",
"3805135", "Vradievka\,\ Mykolayiv",
"3803654", "Ostrog\,\ Rivne",
"38041", "Zhytomyr",
"3804852", "Belyaevka\,\ Odesa",
"3803235", "Lviv",
"3806246", "Volodarske\,\ Donetsk",
"3805457", "Great\ Pisarivka\,\ Sumy",
"3803240", "Lviv",
"3805359", "Hrebinka\,\ Poltava",
"3803363", "Turiysk\,\ Volyn",
"3805452", "Lipova\ Dolina\,\ Sumy",
"3805543", "Great\ Lipetyha\,\ Kherson",
"3804857", "Nikolaevka\,\ Odesa",
"3804349", "Pishchanka\,\ Vinnytsia",
"3806162", "Rozvku\,\ Zaporizhzhia",
"3806444", "Stakhanov\,\ Luhansk",
"3803142", "Hust\,\ Zakarpattia",
"3806254", "Torez\,\ Donetsk",
"38034", "Ivano\-Frankivsk",
"3804639", "Silver\,\ Chernihiv",
"3805545", "Upper\ Rogachik\,\ Kherson",
"3805242", "Aleksandrovka\,\ Kirovohrad",
"3803365", "Kivertsi\/Tsuman\,\ Volyn",
"3805530", "Kalanchak\,\ Kherson",
"3805762", "Sakhnovshchyna\,\ Kharkiv",
"3805667", "Ordzhonikidze\,\ Dnipro",
"3806258", "Donetsk",
"3804566", "Tarashcha\,\ Kyiv",
"3803634", "Volodymyrets\,\ Rivne",
"380567", "Dnipropetrovsk\/Dnipro",
"3806465", "Milow\,\ Luhansk",
"3804161", "Luginy\,\ Zhytomyr",
"3803853", "Yarmolintsy\,\ Khmelnytskyi",
"3803651", "Korets\,\ Rivne",
"3803552", "Chortkiv\,\ Ternopil",
"3803255", "Radehiv\,\ Lviv",
"3803855", "Krasilov\,\ Khmelnytskyi",
"3803430", "Gorodenka\,\ Ivano\-Frankivsk",
"3806463", "Novopskov\,\ Luhansk",
"3806436", "Lutugin\,\ Luhansk",
"3803253", "Lviv",
"3803379", "Gorokhov\,\ Volyn",
"3805693", "Novomoskovsk\,\ Dnipro",
"38055", "Kherson",
"380640", "Luhansk",
"3806448", "Luhansk",
"3803477", "Valley\,\ Ivano\-Frankivsk",
"3803344", "Novovolynsk\,\ Volyn",
"3805153", "Berezanka\,\ Mykolayiv",
"3806473", "Slavyanoserbsk\,\ Luhansk",
"3804343", "Ladyzhin\/Trostyanets\,\ Vinnytsia",
"3805664", "Nikopol\,\ Dnipro",
"3804635", "Baturin\/Bahmach\,\ Chernihiv",
"3805446", "Tomatoes\,\ Sumy",
"3805549", "New\ Kakhovka\,\ Kherson",
"3806257", "Ilovajsk\/Khartsyzsk\,\ Donetsk",
"3805750", "Two\ years\ old\,\ Kharkiv",
"3803551", "Terebovlya\,\ Ternopil",
"3805256", "Novomirgorod\,\ Kirovohrad",
"3804854", "Ivanivka\,\ Odesa",
"3804576", "Baryshevka\/Berezan\,\ Kyiv",
"3803478", "Kosiv\,\ Ivano\-Frankivsk",
"3806447", "Luhansk",
"3804162", "Brusilov\,\ Zhytomyr",
"3803652", "Zdolbunov\,\ Rivne",
"3804330", "Oratov\,\ Vinnytsia",
"380649", "Luhansk",
"3804345", "Illintsi\,\ Vinnytsia",
"3804633", "Ichnya\,\ Chernihiv",
"3805761", "Zachepilivka\,\ Kharkiv",
"3803474", "Rozhnyatov\,\ Ivano\-Frankivsk",
"3803859", "Chemerivtsi\,\ Khmelnytskyi",
"3806232", "Makeevka\,\ Donetsk",
"3805241", "Novgorodka\,\ Kirovohrad",
"3805366", "Kremenchug\,\ Poltava",
"3804858", "Shiryaevoe\,\ Odesa",
"3803546", "Kremenets\/Pochayiv\,\ Ternopil",
"3805630", "Mezhova\,\ Dnipro",
"3803141", "Berehove\,\ Zakarpattia",
"3805668", "Tomakivka\,\ Dnipro",
"3805159", "Elanets\,\ Mykolayiv",
"3806469", "Luhansk",
"3805340", "Chornukhi\,\ Poltava",
"3803637", "Demidivka\,\ Rivne",
"380621", "Donetsk",
"3805451", "Mid\-Buda\,\ Sumy",
"3803259", "Yavoriv\,\ Lviv",
"38043", "Vinnytsia",
"3803732", "Kelmentsi\,\ Chernivtsi",
"3803737", "Zastavna\,\ Chernivtsi",
"3803632", "Zarechnaya\,\ Rivne",
"3805743", "Izyum\,\ Kharkiv",
"3804149", "Emilchine\,\ Zhytomyr",
"3805236", "Svetlovodsk\,\ Kirovohrad",
"3803554", "Zalishchiki\,\ Ternopil",
"3804653", "Borzna\,\ Chernihiv",
"3804851", "Ovidiopol\,\ Odesa",
"3806145", "Gulyaypole\,\ Zaporizhzhia",
"3804350", "Vapnarka\,\ Vinnytsia",
"3803136", "Volovets\,\ Zakarpattia",
"3804655", "Sosnitsa\,\ Chernihiv",
"3806270", "Artemivsk\,\ Donetsk",
"3805458", "Trostyanets\,\ Sumy",
"3806143", "Vilnyansk\,\ Zaporizhzhia",
"3803342", "Volodymyr\-Volynsky\,\ Volyn",
"3806237", "Selidus\,\ Donetsk",
"3805661", "Nikopol\,\ Dnipro",
"3805745", "Lozova\,\ Kharkiv",
"3804733", "Smila\,\ Cherkasy",
"3804860", "Frunzivka\,\ Odesa",
"3805454", "Burin\,\ Sumy",
"3803657", "Kostopil\,\ Rivne",
"3806442", "Alchevsk\,\ Luhansk",
"3803239", "Zhidachiv\,\ Lviv",
"3805355", "Mirgorod\,\ Poltava",
"38061", "Zaporizhzhia",
"3806252", "Yenakievo\,\ Donetsk",
"3805650", "Sofiyivka\,\ Dnipro",
"3803144", "Irshava\,\ Zakarpattia",
"3805353", "Zinkiv\,\ Poltava",
"3803471", "Bogorodchany\,\ Ivano\-Frankivsk",
"3805764", "Zolochiv\,\ Kharkiv",
"3804735", "Korsun\-Shevchenkivsky\,\ Cherkasy",
"3806296", "Novoazovsk\,\ Donetsk",
"3804846", "Bolgrad\,\ Odesa",
"3804740", "Vatutina\/Zvenigorodka\,\ Cherkasy",
"3803558", "Shumsk\,\ Ternopil",
"38057", "Kharkiv",
"3806437", "Luhansk",
"3805753", "Valki\,\ Kharkiv",
"3805364", "Mashivka\,\ Poltava",
"3804335", "Tulchin\,\ Vinnytsia",
"3804841", "Izmail\,\ Odesa",
"3804643", "Kulikivka\,\ Chernihiv",
"3803544", "Buchach\,\ Ternopil",
"3805258", "Malaya\ Vyska\,\ Kirovohrad",
"3804578", "Makarov\,\ Kyiv",
"3803476", "Zabolotov\/Sniatyn\,\ Ivano\-Frankivsk",
"3804340", "Kryzhopil\,\ Vinnytsia",
"38053", "Poltava",
"3805448", "Romny\,\ Sumy",
"3804333", "Kalinovka\,\ Vinnytsia",
"3804645", "Gorodnya\,\ Chernihiv",
"38065", "Crimea",
"3806153", "Berdyansk\,\ Zaporizhzhia",
"3804567", "Pereyaslav\-Khmelnitsky\,\ Kyiv",
"3803352", "Kovel\,\ Volyn",
"3805755", "Kegichivka\,\ Kharkiv",
"3805539", "Gola\ Prystan\,\ Kherson",
"380562", "Dnipropetrovsk\/Dnipro",
"3805444", "Glukhov\,\ Sumy",
"3805162", "Snigurovka\,\ Mykolayiv",
"3806452", "Severodonetsk\,\ Luhansk",
"3805666", "Nikopol\,\ Dnipro",
"380328", "Lviv",
"3804595", "Borispol\,\ Kyiv",
"3803262", "Lviv",
"3805633", "Pershotravensk\,\ Dnipro",
"3805345", "Big\ Bagachka\,\ Poltava",
"3806242", "Gorlovka\,\ Donetsk",
"38046", "Chernihiv",
"3805635", "Yurievka\,\ Dnipro",
"3805343", "Kobelyaky\,\ Poltava",
"3803131", "Mukacheve\,\ Zakarpattia",
"3805368", "Kremenchug\,\ Poltava",
"3804574", "Myronivka\,\ Kyiv",
"3804856", "Berezivka\,\ Odesa",
"3803548", "Berezhany\,\ Ternopil",
"3805254", "Haivoron\,\ Kirovohrad",
"3806133", "Priazovskoe\,\ Zaporizhzhia",
"3806275", "Dokuchaevsk\,\ Donetsk",
"380629", "Mariupol\,\ Donetsk",
"3804353", "Teplik\,\ Vinnytsia",
"3805456", "Yampil\,\ Sumy",
"3805740", "New\ Waterlog\,\ Kharkiv",
"3806247", "Dzerzhinsk\,\ Donetsk",
"38047", "Cherkasy",
"3805361", "Lubny\,\ Poltava",
"3804844", "Tatarbunary\,\ Odesa",
"3804139", "Chudniv\,\ Zhytomyr",
"3803541", "Borschiv\,\ Ternopil",
"3803267", "Lviv",
"3805766", "Kolomak\,\ Kharkiv",
"3806457", "Luhansk",
"3803146", "Mizhhirya\,\ Zakarpattia",
"3805167", "New\ Odesa\,\ Mykolayiv",
"3806273", "Vugledar\,\ Donetsk",
"3804355", "Hnivan\/Tyvriv\,\ Vinnytsia",
"3806140", "Chernigovka\,\ Zaporizhzhia",
"3805238", "Onufryevka\,\ Kirovohrad",
"3805655", "Dnipropetrovsk\/Dnipro",
"3803849", "Kamyanets\-Podilskyi\,\ Khmelnytskyi",
"380572", "Merefa\/Kharkiv\,\ Kharkiv",
"3806269", "Aleksandrovka\,\ Donetsk",
"3803134", "Solotvyno\/Tyachiv\,\ Zakarpattia",
"3804848", "Saratov\,\ Odesa",
"380641", "Luhansk",
"3803357", "Kamin\-Kashirsky\,\ Volyn",
"3804571", "Vasilkov\/Glevaha\/Grebinky\/Kalinovka\,\ Kyiv",
"3805251", "Novoukrainka\,\ Kirovohrad",
"3804730", "Chigirin\,\ Cherkasy",
"3804562", "Rokitne\,\ Kyiv",
"380327", "Lviv",
"3805234", "Dolinska\,\ Kirovohrad",
"3804863", "Ananev\,\ Odesa",
"3804745", "Khrystynivka\,\ Cherkasy",
"380612", "Zaporozhye\,\ Zaporizhzhia",
"3804865", "Savran\,\ Odesa",
"3805653", "Volnogirsk\,\ Dnipro",
"3803249", "Chervonograd\,\ Lviv",
"3806432", "Krasnyi\ Luch\,\ Luhansk",
"3805350", "Kotelva\,\ Poltava",
"3805164", "Kazanka\,\ Mykolayiv",
"3806431", "Anthracite\,\ Luhansk",
"3805442", "Putivl\,\ Sumy",
"3804135", "Olevsk\,\ Zhytomyr",
"3804140", "Natives\,\ Zhytomyr",
"38051", "Mykolayiv",
"3806139", "Energodar\,\ Zaporizhzhia",
"3803264", "Busk\,\ Lviv",
"3804847", "Tarutino\,\ Odesa",
"3806297", "Mangosh\/Yalta\,\ Donetsk",
"3806454", "Kremenna\,\ Luhansk",
"38069", "Sevastopol\ city",
"38038", "Khmelnytskyi",
"3806279", "Telmanov\,\ Donetsk",
"3804561", "Boguslav\,\ Kyiv",
"3806244", "Volnovaha\,\ Donetsk",
"3804133", "Malin\,\ Zhytomyr",
"3804572", "Kozin\/Obukhiv\/Ukrainka\,\ Kyiv",
"3805252", "Golovanovsk\,\ Kirovohrad",
"3803656", "Dubno\,\ Rivne",
"3806248", "Gorlovka\,\ Donetsk",
"380620", "Donetsk",
"3803843", "Polonne\,\ Khmelnytskyi",
"3806263", "Kramatorsk\/Slavyansk\,\ Donetsk",
"3803230", "Pustomyty\,\ Lviv",
"3806236", "Yasinovata\,\ Donetsk",
"3805362", "Khorol\,\ Poltava",
"3803245", "Stryi\,\ Lviv",
"3803542", "Pidhaytsi\,\ Ternopil",
"3806265", "Kramatorsk\/Slavyansk\,\ Donetsk",
"3805237", "Petrov\,\ Kirovohrad",
"3805659", "Dnipropetrovsk\/Dnipro",
"3803845", "Volochysk\,\ Khmelnytskyi",
"3803243", "Lviv",
"3805168", "Bereznegovate\,\ Mykolayiv",
"3803736", "Kitsman\,\ Chernivtsi",
"3806458", "Luhansk",
"3803268", "Lviv",
"3804749", "Lysyanka\,\ Cherkasy",
"3803132", "Rakhiv\,\ Zakarpattia",
"38045", "Kyiv",
"3803636", "Kuznetsovsk\,\ Rivne",
"3805540", "Lower\ Sirogozy\,\ Kherson",
"3805759", "Borova\,\ Kharkiv",
"3805535", "Vysokoplylya\,\ Kherson",
"3806241", "Gorlovka\,\ Donetsk",
"3804564", "Stavyshche\,\ Kyiv",
"3803547", "Kozlov\/Kozova\,\ Ternopil",
"3803346", "Old\ Vyzhivka\,\ Volyn",
"3803261", "Novy\ Rozdol\,\ Lviv",
"3805367", "Kremenchug\,\ Poltava",
"3806451", "Lisichansk\,\ Luhansk",
"3803741", "Novodnistrovsk\,\ Chernivtsi",
"3805533", "Novovorontsovka\,\ Kherson",
"3805161", "Pervomaysk\,\ Mykolayiv",
"3806434", "Sverdlovsk\,\ Luhansk",
"3803435", "Rohatyn\,\ Ivano\-Frankivsk",
"3803850", "Old\ Sinyava\,\ Khmelnytskyi",
"3806446", "Kirovsk\,\ Luhansk",
"3804577", "Borodyanka\/Klavdievo\-Tarasovo\/Nemishaive\,\ Kyiv",
"3805257", "Bobrinets\,\ Kirovohrad",
"3805639", "Vasylkivka\,\ Dnipro",
"3806438", "Luhansk",
"3805690", "Tsarichanka\,\ Dnipro",
"3806256", "Snizhne\,\ Donetsk",
"3806460", "Luhansk",
"3804568", "Skvyra\,\ Kyiv",
"3803433", "Kolomyia\,\ Ivano\-Frankivsk",
"3805447", "Konotop\,\ Sumy",
"3803250", "Lviv",};
$areanames{uk} = {"3805746", "Чугуїв\,\ Харків",
"3805233", "Знамʼянка\,\ Кіровоград",
"3804591", "Іванків\,\ Київ",
"38048", "Одеса",
"3804864", "Любашівка\,\ Одеса",
"3805341", "Семенівка\,\ Полтава",
"3803247", "Трускавець\,\ Львівська",
"3806278", "Марʼїнка\,\ Донецьк",
"3803133", "Свалява\,\ Закарпатська",
"3804656", "Короп\,\ Чернігів",
"380329", "Львів\/Львівська",
"3803135", "Великий\ Березний\,\ Закарпатська",
"3805654", "Кринички\,\ Дніпро",
"3806267", "Дружківка\,\ Донецьк",
"3805235", "Олександрія\,\ Кіровоград",
"3805532", "Велика\ Олександрівка\,\ Херсон",
"3803847", "Нова\ Ушиця\,\ Хмельницький",
"3804358", "Липовець\,\ Вінниця",
"3806138", "Камʼянка\-Дніпровська\,\ Запорізька",
"3805240", "Компаніївка\,\ Кіровоград",
"3804744", "Умань\,\ Черкаси",
"3805631", "Петропавлівка\,\ Дніпро",
"3804331", "Брацлав\/Немирів\,\ Вінниця",
"3804845", "Арциз\,\ Одеса",
"3804736", "Канів\,\ Черкаси",
"3805658", "Верхньодніпровськ\,\ Дніпро",
"3804137", "Попільня\,\ Житомир",
"3804748", "Маньківка\,\ Черкаси",
"3803269", "Турка\,\ Львівська",
"3803550", "Збараж\,\ Тернопіль",
"3806459", "Луганськ",
"3804868", "Іллічівськ\,\ Одеса",
"3805356", "Лохвиця\,\ Полтава",
"3806274", "Артемівськ\/Сіверськ\,\ Донецьк",
"380522", "Кропивницький\,\ Кіровоград",
"3805751", "Шевченкове\,\ Харків",
"3803432", "Верховина\,\ Івано\-Франківська",
"3806249", "Дебальцеве\,\ Донецьк",
"3804641", "Ріпки\,\ Чернігів",
"3804843", "Вилкове\/Кілія\,\ Одеса",
"380312", "Ужгород\/Чоп\,\ Закарпатська",
"3804346", "Погребище\,\ Вінниця",
"3804741", "Шпола\,\ Черкаси",
"3805634", "Петриківка\,\ Дніпро",
"3803437", "Болехів\,\ Івано\-Франківська",
"3805651", "Дніпропетро́вськ\/Дніпро",
"3804575", "Яготин\,\ Київ",
"3805443", "Білопілля\,\ Суми",
"3805255", "Новоархангельськ\,\ Кіровоград",
"3804338", "Хмільник\,\ Вінниця",
"3804132", "Радомишль\,\ Житомир",
"3805445", "Лебедин\,\ Суми",
"3804573", "Кагарлик\/Ржищів\,\ Київ",
"3805253", "Добровеличківка\,\ Кіровоград",
"38035", "Тернопіль",
"3804636", "Варва\,\ Чернігів",
"3805758", "Богодухів\,\ Харків",
"3804594", "Бровари\/Калита\,\ Київ",
"3804861", "Красні\ Окни\,\ Одеса",
"3805344", "Нові\ Санжари\,\ Полтава",
"3805363", "Решетилівка\,\ Полтава",
"3804644", "Мена\,\ Чернігів",
"380628", "Донецьк",
"3803543", "Підволочиськ\,\ Тернопіль",
"3805660", "Нікополь\,\ Дніпро",
"3803842", "Нетішин\/Славута\,\ Хмельницький",
"3806262", "Святогірськ\/Словʼянськ\,\ Донецьк",
"3805537", "Лазурне\/Скадовськ\,\ Херсон",
"3805348", "Комсомольськ\,\ Полтава",
"3806271", "Артемівськ\,\ Донецьк",
"3805754", "Близнюки\,\ Харків",
"3804598", "Боярка\/Вишневе\,\ Київ",
"3804569", "Володарка\,\ Київ",
"3806131", "Якимівка\,\ Запорізька",
"3804850", "Теплодар\,\ Одеса",
"3805638", "Покровське\,\ Дніпро",
"3803376", "Маневичі\,\ Волинська",
"38054", "Суми",
"3804351", "Чечельник\,\ Вінниця",
"3803242", "Львів\/Львівська",
"3806439", "Луганськ",
"3805365", "Глобине\,\ Полтава",
"3804334", "Гайсин\,\ Вінниця",
"380642", "Луганськ\/Олександрівськ\,\ Луганськ",
"3804597", "Буча\/Ворзель\/Гостомель\/Ірпінь\/Коцюбинське\,\ Київ",
"3805449", "Шостка\,\ Суми",
"3803241", "Миколаїв\,\ Львівська",
"3803366", "Ратне\,\ Волинська",
"3805546", "Берислав\,\ Херсон",
"3805347", "Чутове\,\ Полтава",
"3805538", "Асканія\-Нова\/Чаплинка\,\ Херсон",
"3804352", "Бершадь\,\ Вінниця",
"3806132", "Михайлівка\,\ Запорізька",
"3803122", "Ужгород\,\ Закарпатська",
"3803434", "Ворохта\/Яремче\,\ Івано\-Франківська",
"3806272", "Костянтинівка\,\ Донецьк",
"3803841", "Білогірʼя\,\ Хмельницький",
"3806261", "Красний\ Лиман\,\ Донецьк",
"3805637", "Павлоград\,\ Дніпро",
"3804579", "Славутич\,\ Київ",
"3805259", "Ульянівка\,\ Кіровоград",
"3804862", "Котовськ\,\ Одеса",
"3804337", "Могилів\-Подільський\,\ Вінниця",
"38036", "Рівне",
"3803438", "Бурштин\,\ Івано\-Франківська",
"3804563", "Біла\ Церква\/Узин\,\ Київ",
"3805369", "Кременчук\,\ Полтава",
"3806435", "Краснодон\,\ Луганськ",
"3804131", "Червоноармійськ\,\ Житомир",
"3803549", "Ланівці\,\ Тернопіль",
"3803856", "Деражня\,\ Хмельницький",
"3806440", "Луганськ",
"3806433", "Ровеньки\,\ Луганськ",
"380332", "Луцьк\,\ Волинська",
"3803256", "Новояворівськ\,\ Львівська",
"3806250", "Кіровське\,\ Донецьк",
"3805757", "Барвінкове\,\ Харків",
"3806466", "Біловодськ\,\ Луганськ",
"3805652", "Жовті\ Води\,\ Дніпро",
"3804742", "Катеринопіль\,\ Черкаси",
"3804565", "Фастів\,\ Київ",
"3805534", "Генічеськ\,\ Херсон",
"3803844", "Теофіполь\,\ Хмельницький",
"3806264", "Краматорськ\,\ Донецьк",
"3804642", "Носівка\,\ Чернігів",
"3804747", "Жашків\,\ Черкаси",
"3804138", "Ружин\,\ Житомир",
"3805657", "Широке\,\ Дніпро",
"3804146", "Дзержинськ\,\ Житомир",
"3805752", "Великий\ Бурлук\,\ Харків",
"3805239", "Устинівка\,\ Кіровоград",
"3803431", "Галич\,\ Івано\-Франківська",
"3803355", "Шацьк\,\ Волинська",
"3803650", "Гоща\,\ Рівне",
"3803244", "Дрогобич\,\ Львівська",
"3804867", "Кодима\,\ Одеса",
"3804332", "Браїлів\/Жмеринка\,\ Вінниця",
"38037", "Чернівці",
"3803263", "Перемишляни\,\ Львівська",
"3805632", "Павлоград\,\ Дніпро",
"3806453", "Рубіжне\,\ Луганськ",
"3806245", "Горлівка\,\ Донецьк",
"3805531", "Іванівка\,\ Херсон",
"3803236", "Самбір\,\ Львівська",
"380320", "Львів\/Львівська",
"3805163", "Веселинове\,\ Миколаїв",
"3806277", "Добропілля\,\ Донецьк",
"3803248", "Борислав\/Східниця\,\ Львівська",
"3805136", "Південноукраїнськ\,\ Миколаїв",
"3804849", "Білгород\-Дністровський\/Затока\/Сергіївка\,\ Одеса",
"3804134", "Черняхів\,\ Житомир",
"3806137", "Приморськ\,\ Запорізька",
"3806268", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3805342", "Козельщина\,\ Полтава",
"3803730", "Вижниця\,\ Чернівці",
"380561", "Дніпропетро́вськ\/Дніпро",
"3803265", "Золочів\,\ Львівська",
"3806455", "Первомайськ\,\ Луганськ",
"3806243", "Велика\ Новосілка\,\ Донецьк",
"3803479", "Тлумач\,\ Івано\-Франківська",
"3803377", "Любомль\,\ Волинська",
"380569", "Дніпродзержинськ\/Новомосковськ\,\ Дніпро",
"3803854", "Старокостянтинів\,\ Хмельницький",
"3805742", "Купʼянськ\,\ Харків",
"3803633", "Радивилів\,\ Рівне",
"3805536", "Каховка\,\ Херсон",
"3803231", "Городок\,\ Львівська",
"3803635", "Рокитне\,\ Рівне",
"3805154", "Очаків\,\ Миколаїв",
"3806464", "Марківка\,\ Луганськ",
"3805131", "Братське\,\ Миколаїв",
"3803368", "Рожище\,\ Волинська",
"3805548", "Новотроїцьке\,\ Херсон",
"3803254", "Камʼянка\-Бузька\,\ Львівська",
"3805158", "Баштанка\,\ Миколаїв",
"3805669", "Солоне\,\ Дніпро",
"3806443", "Брянка\,\ Луганськ",
"3806255", "Шахтарськ\,\ Донецьк",
"3805544", "Горностаївка\,\ Херсон",
"3803258", "Львів\/Львівська",
"3804637", "Прилуки\,\ Чернігів",
"38033", "Волинська",
"3806468", "Луганськ",
"3804560", "Тетіїв\,\ Київ",
"3804732", "Камʼянка\,\ Черкаси",
"3804859", "Велика\ Михайлівка\,\ Одеса",
"3804347", "Літин\,\ Вінниця",
"3803858", "Дунаївці\,\ Хмельницький",
"3806430", "Луганськ",
"3805352", "Шишаки\,\ Полтава",
"3806445", "Новоайдар\,\ Луганськ",
"3804141", "Новоград\-Волинський\,\ Житомир",
"3806253", "Старобешеве\,\ Донецьк",
"3803436", "Тисмениця\,\ Івано\-Франківська",
"3803655", "Сарни\,\ Рівне",
"3806461", "Старобільськ\,\ Луганськ",
"3805134", "Вознесенськ\,\ Миколаїв",
"3805357", "Оржиця\,\ Полтава",
"3803251", "Сколе\/Славське\,\ Львівська",
"3805459", "Краснопілля\,\ Суми",
"3804342", "Козятин\,\ Вінниця",
"3805691", "Магдалинівка\,\ Дніпро",
"3803234", "Мостиська\,\ Львівська",
"3806472", "Станиця\ Луганськ\,\ Луганськ",
"3805151", "Новий\ Буг\,\ Миколаїв",
"3804148", "Овруч\,\ Житомир",
"3804737", "Золотоноша\,\ Черкаси",
"3804632", "Бобровиця\,\ Чернігів",
"380622", "Донецьк",
"3803653", "Березне\,\ Рівне",
"3803851", "Городок\/Сатанів\,\ Хмельницький",
"3804136", "Андрушівка\,\ Житомир",
"3804144", "Баранівка\,\ Житомир",
"3806147", "Куйбишеве\,\ Запорізька",
"3803260", "Моршин\,\ Львівська",
"3803735", "Сторожинець\,\ Чернівці",
"3806175", "Василівка\/Дніпрорудне\,\ Запорізька",
"3803740", "Герца\,\ Чернівці",
"3803846", "Віньківці\,\ Хмельницький",
"3806450", "Луганськ",
"380619", "Мелітополь\,\ Запорізька",
"3806266", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3803246", "Львів\/Львівська",
"3803733", "Новоселиця\,\ Чернівці",
"3806240", "Горлівка\,\ Донецьк",
"3805747", "Зміїв\,\ Харків",
"3804657", "Корюківка\,\ Чернігів",
"3803372", "Іваничі\,\ Волинська",
"3803238", "Старий\ Самбір\,\ Львівська",
"3804356", "Муровані\ Курилівці\,\ Вінниця",
"3806136", "Веселе\,\ Запорізька",
"3803145", "Перечин\,\ Закарпатська",
"3805765", "Печеніги\,\ Харків",
"3804734", "Городище\,\ Черкаси",
"3803362", "Любешів\,\ Волинська",
"3805453", "Кролевець\,\ Суми",
"3805542", "Цюрупинськ\,\ Херсон",
"3803237", "Львів\/Львівська",
"3805763", "Дергачі\,\ Харків",
"3803659", "Млинів\,\ Рівне",
"3805455", "Недригайлів\,\ Суми",
"3804658", "Новгород\-Сіверський\,\ Чернігів",
"3806165", "Пологи\,\ Запорізька",
"3805748", "Первомайський\,\ Харків",
"3803143", "Виноградів\,\ Закарпатська",
"3806276", "Артемівськ\,\ Донецьк",
"3805354", "Гадяч\,\ Полтава",
"3806239", "Красноармійськ\,\ Донецьк",
"3804654", "Щорс\,\ Чернігів",
"38031", "Закарпатська",
"3803852", "Ізяслав\,\ Хмельницький",
"3804866", "Балта\,\ Одеса",
"3805358", "Пирятин\,\ Полтава",
"38037312", "Хотин\,\ Чернівці",
"3805744", "Красноград\,\ Харків",
"38052", "Кіровоград",
"3804631", "Ніжин\,\ Чернігів",
"3804746", "Монастирище\,\ Черкаси",
"3804840", "Рені\,\ Одеса",
"3806471", "Сватове\,\ Луганськ",
"3805152", "Доманівка\,\ Миколаїв",
"3804341", "Бар\,\ Вінниця",
"3805692", "Дніпродзержинськ\,\ Дніпро",
"3803555", "Монастириська\,\ Тернопіль",
"3803252", "Жовква\,\ Львівська",
"380648", "Луганськ",
"3803739", "Сокиряни\,\ Чернівці",
"3804147", "Любар\,\ Житомир",
"3804738", "Драбів\,\ Черкаси",
"3806462", "Білокуракине\,\ Луганськ",
"3805656", "Апостолове\,\ Дніпро",
"3806144", "Новомиколаївка\,\ Запорізька",
"3804142", "Коростень\,\ Житомир",
"3806467", "Луганськ",
"3805756", "Краснокутськ\,\ Харків",
"380564", "Кривий\ Ріг\,\ Дніпро",
"3803257", "Сокаль\,\ Львівська",
"38044", "м\.\ Київ",
"3805351", "Диканька\,\ Полтава",
"3804646", "Десна\/Козелець\/Остер\,\ Чернігів",
"3806156", "Велика\ Білозерка\,\ Запорізька",
"3804731", "Тальне\,\ Черкаси",
"3803475", "Делятин\/Надвірна\,\ Івано\-Франківська",
"3804336", "Ямпіль\,\ Вінниця",
"3803374", "Локачі\,\ Волинська",
"3804348", "Томашпіль\,\ Вінниця",
"3803857", "Летичів\/Меджибіж\,\ Хмельницький",
"3805250", "Вільшанка\,\ Кіровоград",
"3804570", "Згурівка\,\ Київ",
"3804855", "Комінтернівське\,\ Одеса",
"380560", "Дніпропетро́вськ\/Дніпро",
"3805132", "Арбузинка\,\ Миколаїв",
"3806141", "Оріхів\,\ Запорізька",
"3805360", "Кременчук\,\ Полтава",
"3806474", "Попасна\,\ Луганськ",
"3805636", "Тернівка\,\ Дніпро",
"3803540", "Зборів\,\ Тернопіль",
"3804344", "Шаргород\,\ Вінниця",
"3805663", "Синельникове\,\ Дніпро",
"3806449", "Луганськ",
"3803232", "Львів\/Львівська",
"3805346", "Карлівка\,\ Полтава",
"3805547", "Білозерка\,\ Херсон",
"3805741", "Вовчанськ\,\ Харків",
"3806259", "Амвросіївка\,\ Донецьк",
"3804596", "Вишгород\/Димер\/Пірнове\,\ Київ",
"380321", "Львів\/Львівська",
"3804634", "Талалаївка\,\ Чернігів",
"3805665", "Марганець\,\ Дніпро",
"380647", "Луганськ",
"3804853", "Лиманське\/Роздільна\,\ Одеса",
"3805749", "Балаклія\,\ Харків",
"3804143", "Бердичів\,\ Житомир",
"3806251", "Донецьк",
"3803658", "Дубровиця\,\ Рівне",
"3803472", "Калуш\,\ Івано\-Франківська",
"3804659", "Семенівка\,\ Чернігів",
"3803734", "Глибока\,\ Чернівці",
"3806441", "Перевальськ\,\ Луганськ",
"3804145", "Володарськ\-Волинський\,\ Житомир",
"380623", "Красноармійськ\/Макіївка\,\ Донецьк",
"3803557", "Гусятин\,\ Тернопіль",
"380322", "Брюховичі\/Львів\,\ Львівська",
"3804130", "Коростишів\,\ Житомир",
"3806178", "Токмак\,\ Запорізька",
"3803738", "Путила\,\ Чернівці",
"3805133", "Криве\ Озеро\,\ Миколаїв",
"3804739", "Чорнобай\,\ Черкаси",
"3803266", "Броди\,\ Львівська",
"380568", "Дніпропетро́вськ\/Дніпро",
"3803233", "Львів\/Львівська",
"3806260", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3803840", "Шепетівка\,\ Хмельницький",
"3805662", "Нікополь\,\ Дніпро",
"3806456", "Троїцьке\,\ Луганськ",
"3805359", "Гребінка\,\ Полтава",
"3805457", "Велика\ Писарівка\,\ Суми",
"3803240", "Львів\/Львівська",
"3806246", "Володарське\,\ Донецьк",
"3803235", "Львів\/Львівська",
"38041", "Житомир",
"3804852", "Біляївка\,\ Одеса",
"3803654", "Острог\,\ Рівне",
"3805135", "Врадіївка\,\ Миколаїв",
"3806162", "Розівка\,\ Запорізька",
"3806444", "Стаханов\,\ Луганськ",
"3804349", "Піщанка\,\ Вінниця",
"3804857", "Миколаївка\,\ Одеса",
"3805452", "Липова\ Долина\,\ Суми",
"3805543", "Велика\ Лепетиха\,\ Херсон",
"3803363", "Турійськ\,\ Волинська",
"3805667", "Орджонікідзе\,\ Дніпро",
"3805530", "Каланчак\,\ Херсон",
"3805762", "Сахновщина\,\ Харків",
"3803365", "Ківерці\/Цумань\,\ Волинська",
"3805545", "Верхній\ Рогачик\,\ Херсон",
"3805242", "Олександрівка\,\ Кіровоград",
"3804639", "Срібне\,\ Чернігів",
"38034", "Івано\-Франківська",
"3806254", "Торез\,\ Донецьк",
"3803142", "Хуст\,\ Закарпатська",
"3803255", "Радехів\,\ Львівська",
"3803552", "Чортків\,\ Тернопіль",
"3803853", "Ярмолинці\,\ Хмельницький",
"3803651", "Корець\,\ Рівне",
"3804161", "Лугини\,\ Житомир",
"3806465", "Мілове\,\ Луганськ",
"380567", "Дніпропетро́вськ\/Дніпро",
"3803634", "Володимирець\,\ Рівне",
"3804566", "Тараща\,\ Київ",
"3806258", "Донецьк",
"3805153", "Березанка\,\ Миколаїв",
"3803344", "Нововолинськ\,\ Волинська",
"380640", "Луганськ",
"3803477", "Долина\,\ Івано\-Франківська",
"3806448", "Луганськ",
"3803379", "Горохів\,\ Волинська",
"38055", "Херсон",
"3805693", "Новомосковськ\,\ Дніпро",
"3803253", "Львів\/Львівська",
"3806436", "Лутугине\,\ Луганськ",
"3803430", "Городенка\,\ Івано\-Франківська",
"3806463", "Новопсков\,\ Луганськ",
"3803855", "Красилів\,\ Хмельницький",
"3805750", "Дворічна\,\ Харків",
"3806257", "Іловайськ\/Харцизьк\,\ Донецьк",
"3805549", "Нова\ Каховка\,\ Херсон",
"3805446", "Охтирка\,\ Суми",
"3804343", "Ладижин\/Тростянець\,\ Вінниця",
"3805664", "Нікополь\,\ Дніпро",
"3804635", "Батурин\/Бахмач\,\ Чернігів",
"3806473", "Словʼяносербськ\,\ Луганськ",
"3804345", "Іллінці\,\ Вінниця",
"3804633", "Ічня\,\ Чернігів",
"380649", "Луганськ",
"3804330", "Оратів\,\ Вінниця",
"3803652", "Здолбунів\,\ Рівне",
"3803478", "Косів\,\ Івано\-Франківська",
"3806447", "Луганськ",
"3804162", "Брусилів\,\ Житомир",
"3805256", "Новомиргород\,\ Кіровоград",
"3804576", "Баришівка\/Березань\,\ Київ",
"3804854", "Іванівка\,\ Одеса",
"3803551", "Теребовля\,\ Тернопіль",
"3803141", "Берегове\,\ Закарпатська",
"3804858", "Ширяєве\,\ Одеса",
"3805630", "Межова\,\ Дніпро",
"3803546", "Кременець\/Почаїв\,\ Тернопіль",
"3806232", "Макіївка\,\ Донецьк",
"3805366", "Кременчук\,\ Полтава",
"3805241", "Новгородка\,\ Кіровоград",
"3803859", "Чемерівці\,\ Хмельницький",
"3805761", "Зачепилівка\,\ Харків",
"3803474", "Рожнятів\,\ Івано\-Франківська",
"38043", "Вінниця",
"3805451", "Середина\-Буда\,\ Суми",
"3803259", "Яворів\,\ Львівська",
"3803732", "Кельменці\,\ Чернівці",
"3805340", "Чорнухи\,\ Полтава",
"3803637", "Демидівка\,\ Рівне",
"380621", "Донецьк",
"3806469", "Луганськ",
"3805159", "Єланець\,\ Миколаїв",
"3805668", "Томаківка\,\ Дніпро",
"3803136", "Воловець\,\ Закарпатська",
"3804350", "Вапнярка\,\ Вінниця",
"3806145", "Гуляйполе\,\ Запорізька",
"3804851", "Овідіополь\,\ Одеса",
"3804653", "Борзна\,\ Чернігів",
"3803554", "Заліщики\,\ Тернопіль",
"3805236", "Світловодськ\,\ Кіровоград",
"3805743", "Ізюм\,\ Харків",
"3804149", "Ємільчине\,\ Житомир",
"3803632", "Зарічне\,\ Рівне",
"3803737", "Заставна\,\ Чернівці",
"3805745", "Лозова\,\ Харків",
"3805661", "Нікополь\,\ Дніпро",
"3806237", "Селидове\,\ Донецьк",
"3803342", "Володимир\-Волинський\,\ Волинська",
"3806143", "Вільнянськ\,\ Запорізька",
"3806270", "Артемівськ\,\ Донецьк",
"3805458", "Тростянець\,\ Суми",
"3804655", "Сосниця\,\ Чернігів",
"38061", "Запоріжжя\/Запорізька",
"3805355", "Миргород\,\ Полтава",
"3803239", "Жидачів\,\ Львівська",
"3806442", "Алчевськ\,\ Луганськ",
"3803657", "Костопіль\,\ Рівне",
"3805454", "Буринь\,\ Суми",
"3804860", "Фрунзівка\,\ Одеса",
"3804733", "Сміла\,\ Черкаси",
"38057", "Харків",
"3804740", "Ватутіне\/Звенигородка\,\ Черкаси",
"3804846", "Болград\,\ Одеса",
"3803558", "Шумське\,\ Тернопіль",
"3806296", "Новоазовськ\,\ Донецьк",
"3803471", "Богородчани\,\ Івано\-Франківська",
"3805764", "Золочів\,\ Харків",
"3804735", "Корсунь\-Шевченківський\,\ Черкаси",
"3805353", "Зіньків\,\ Полтава",
"3803144", "Іршава\,\ Закарпатська",
"3805650", "Софіївка\,\ Дніпро",
"3806252", "Єнакієве\,\ Донецьк",
"38053", "Полтава",
"3803476", "Заболотів\/Снятин\,\ Івано\-Франківська",
"3804340", "Крижопіль\,\ Вінниця",
"3803544", "Бучач\,\ Тернопіль",
"3805258", "Мала\ Виска\,\ Кіровоград",
"3804578", "Макарів\,\ Київ",
"3805364", "Машівка\,\ Полтава",
"3804335", "Тульчин\,\ Вінниця",
"3804841", "Ізмаїл\,\ Одеса",
"3804643", "Куликівка\,\ Чернігів",
"3805753", "Валки\,\ Харків",
"3806437", "Луганськ",
"380562", "Дніпропетровськ\,\ Дніпро",
"3805755", "Кегичівка\,\ Харків",
"3805539", "Гола\ Пристань\,\ Херсон",
"3803352", "Ковель\,\ Волинська",
"3804567", "Переяслав\-Хмельницький\,\ Київ",
"3806153", "Бердянськ\,\ Запорізька",
"3804333", "Калинівка\,\ Вінниця",
"3804645", "Городня\,\ Чернігів",
"38065", "Крим",
"3805448", "Ромни\,\ Суми",
"3805633", "Першотравенськ\,\ Дніпро",
"3805345", "Велика\ Багачка\,\ Полтава",
"3803262", "Львів\/Львівська",
"3805666", "Нікополь\,\ Дніпро",
"3806452", "Сєвєродонецьк\,\ Луганськ",
"3804595", "Бориспіль\,\ Київ",
"380328", "Львів\/Львівська",
"3805162", "Снігурівка\,\ Миколаїв",
"3805444", "Глухів\,\ Суми",
"3804856", "Березівка\,\ Одеса",
"3804574", "Миронівка\,\ Київ",
"3805254", "Гайворон\,\ Кіровоград",
"3803548", "Бережани\,\ Тернопіль",
"3805368", "Кременчук\,\ Полтава",
"3803131", "Мукачеве\,\ Закарпатська",
"3805635", "Юрʼївка\,\ Дніпро",
"3805343", "Кобеляки\,\ Полтава",
"3806242", "Горлівка\,\ Донецьк",
"38046", "Чернігів",
"38047", "Черкаси",
"3806247", "Дзержинськ\,\ Донецьк",
"3805740", "Нова\ Водолага\,\ Харків",
"3805456", "Ямпіль\,\ Суми",
"3804353", "Теплик\,\ Вінниця",
"380629", "Маріуполь\,\ Донецьк",
"3806275", "Докучаєвськ\,\ Донецьк",
"3806133", "Приазовське\,\ Запорізька",
"3806140", "Чернігівка\,\ Запорізька",
"3805238", "Онуфріївка\,\ Кіровоград",
"3804355", "Гнівань\/Тиврів\,\ Вінниця",
"3805167", "Нова\ Одеса\,\ Миколаїв",
"3806273", "Вугледар\,\ Донецьк",
"3803146", "Міжгірʼя\,\ Закарпатська",
"3806457", "Луганськ",
"3805766", "Коломак\,\ Харків",
"3804139", "Чуднів\,\ Житомир",
"3803541", "Борщів\,\ Тернопіль",
"3803267", "Львів\/Львівська",
"3805361", "Лубни\,\ Полтава",
"3804844", "Татарбунари\,\ Одеса",
"3804745", "Христинівка\,\ Черкаси",
"3804863", "Ананьїв\,\ Одеса",
"3804730", "Чигирин\,\ Черкаси",
"3805234", "Долинська\,\ Кіровоград",
"3804562", "Рокитне\,\ Київ",
"380327", "Львів\/Львівська",
"3804571", "Васильків\/Глеваха\/Гребінки\/Калинівка\,\ Київ",
"3805251", "Новоукраїнка\,\ Кіровоград",
"3803357", "Камінь\-Каширський\,\ Волинська",
"380641", "Луганськ",
"3804848", "Сарата\,\ Одеса",
"3806269", "Олександрівка\,\ Донецьк",
"3803134", "Солотвино\/Тячів\,\ Закарпатська",
"380572", "Мерефа\/Харків\,\ Харків",
"3805655", "Дніпропетро́вськ\/Дніпро",
"3803849", "Камʼянець\-Подільський\,\ Хмельницький",
"3805350", "Котельва\,\ Полтава",
"3806432", "Красний\ Луч\,\ Луганськ",
"3803249", "Червоноград\,\ Львівська",
"3805653", "Вільногірськ\,\ Дніпро",
"3804865", "Саврань\,\ Одеса",
"380612", "Запоріжжя\,\ Запорізька",
"38069", "Севастополь",
"3806297", "Мангуш\/Ялта\,\ Донецьк",
"3806454", "Кремінна\,\ Луганськ",
"3804847", "Тарутине\,\ Одеса",
"3803264", "Буськ\,\ Львівська",
"3806139", "Енергодар\,\ Запорізька",
"38051", "Миколаїв",
"3804140", "Народичі\,\ Житомир",
"3805164", "Казанка\,\ Миколаїв",
"3806431", "Антрацит\,\ Луганськ",
"3805442", "Путивль\,\ Суми",
"3804135", "Олевськ\,\ Житомир",
"3803656", "Дубно\,\ Рівне",
"3804572", "Козин\/Обухів\/Українка\,\ Київ",
"3804133", "Малин\,\ Житомир",
"3805252", "Голованівськ\,\ Кіровоград",
"3806244", "Волноваха\,\ Донецьк",
"3804561", "Богуслав\,\ Київ",
"3806279", "Тельманове\,\ Донецьк",
"38038", "Хмельницький",
"3803245", "Стрий\,\ Львівська",
"3803542", "Підгайці\,\ Тернопіль",
"3805362", "Хорол\,\ Полтава",
"3806236", "Ясинувата\,\ Донецьк",
"3806263", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3803230", "Пустомити\,\ Львівська",
"3803843", "Полонне\,\ Хмельницький",
"3806248", "Горлівка\,\ Донецьк",
"380620", "Донецьк",
"3803268", "Львів\/Львівська",
"3804749", "Лисянка\,\ Черкаси",
"3806458", "Луганськ",
"3803736", "Кіцмань\,\ Чернівці",
"3803243", "Львів\/Львівська",
"3805168", "Березнегувате\,\ Миколаїв",
"3805659", "Дніпропетро́вськ\/Дніпро",
"3803845", "Волочиськ\,\ Хмельницький",
"3806265", "Краматорськ\/Словʼянськ\,\ Донецьк",
"3805237", "Петрове\,\ Кіровоград",
"3805759", "Борова\,\ Харків",
"3804564", "Ставище\,\ Київ",
"3806241", "Горлівка\,\ Донецьк",
"3805535", "Високопілля\,\ Херсон",
"3803636", "Кузнецовськ\,\ Рівне",
"3805540", "Нижні\ Сірогози\,\ Херсон",
"38045", "Київ",
"3803132", "Рахів\,\ Закарпатська",
"3805161", "Первомайськ\,\ Миколаїв",
"3806434", "Свердловськ\,\ Луганськ",
"3806451", "Лисичанськ\,\ Луганськ",
"3805533", "Нововоронцовка\,\ Херсон",
"3803741", "Новодністровськ\,\ Чернівці",
"3805367", "Кременчук\,\ Полтава",
"3803547", "Козлів\/Козова\,\ Тернопіль",
"3803261", "Новий\ Роздол\,\ Львівська",
"3803346", "Стара\ Вижівка\,\ Волинська",
"3806438", "Луганськ",
"3805639", "Васильківка\,\ Дніпро",
"3804577", "Бородянка\/Клавдієво\-Тарасове\/Немішаєве\,\ Київ",
"3805257", "Бобринець\,\ Кіровоград",
"3803850", "Стара\ Синява\,\ Хмельницький",
"3806446", "Кіровськ\,\ Луганськ",
"3803435", "Рогатин\,\ Івано\-Франківська",
"3805447", "Конотоп\,\ Суми",
"3803250", "Львів\/Львівська",
"3804568", "Сквира\,\ Київ",
"3806460", "Луганськ",
"3803433", "Коломия\,\ Івано\-Франківська",
"3806256", "Сніжне\,\ Донецьк",
"3805690", "Царичанка\,\ Дніпро",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+380|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;