package Data::Object::Autobox;

use 5.014;

use strict;
use warnings;

use base 'autobox';

require Data::Object::Any::Autobox;
require Data::Object::Array::Autobox;
require Data::Object::Code::Autobox;
require Data::Object::Float::Autobox;
require Data::Object::Hash::Autobox;
require Data::Object::Integer::Autobox;
require Data::Object::Number::Autobox;
require Data::Object::Scalar::Autobox;
require Data::Object::String::Autobox;
require Data::Object::Undef::Autobox;

our $VERSION = '1.07'; # VERSION

sub import {
  my ($class) = @_;

  $class->SUPER::import(
    ARRAY     => 'Data::Object::Array::Autobox',
    CODE      => 'Data::Object::Code::Autobox',
    FLOAT     => 'Data::Object::Float::Autobox',
    HASH      => 'Data::Object::Hash::Autobox',
    INTEGER   => 'Data::Object::Integer::Autobox',
    NUMBER    => 'Data::Object::Number::Autobox',
    SCALAR    => 'Data::Object::Scalar::Autobox',
    STRING    => 'Data::Object::String::Autobox',
    UNDEF     => 'Data::Object::Undef::Autobox',
    UNIVERSAL => 'Data::Object::Any::Autobox'
  );

  return $class;
}

1;

=encoding utf8

=head1 NAME

Data::Object::Autobox

=cut

=head1 ABSTRACT

Data-Object Autoboxing

=cut

=head1 SYNOPSIS

  use Data::Object::Autobox;

  my $input  = [1,1,1,1,3,3,2,1,5,6,7,8,9];
  my $output = $input->grep(sub{$_[0] < 5})->unique->sort; # [1,2,3]

  $output->join(',')->print; # 1,2,3

  $object->isa('Data::Object::Array');

=cut

=head1 DESCRIPTION

This package implements autoboxing via L<autobox> to provide
L<boxing|http://en.wikipedia.org/wiki/Object_type_(object-oriented_programming)>
for native Perl 5 data types.

=cut

=head1 AUTHOR

Al Newkirk, C<awncorp@cpan.org>

=head1 LICENSE

Copyright (C) 2011-2019, Al Newkirk, et al.

This is free software; you can redistribute it and/or modify it under the same
terms as the Perl 5 programming language system itself.

=head1 PROJECT

L<On GitHub|https://github.com/iamalnewkirk/do>

L<Initiatives|https://github.com/iamalnewkirk/do/projects>

L<Contributing|https://github.com/iamalnewkirk/do/blob/master/CONTRIBUTE.mkdn>

L<Reporting|https://github.com/iamalnewkirk/do/issues>

=head1 SEE ALSO

To get the most out of this distribution, consider reading the following:

L<Data::Object::Class>

L<Data::Object::Role>

L<Data::Object::Rule>

L<Data::Object::Library>

L<Data::Object::Signatures>

=cut