/*
 *  Generate the normalization table for the quantized unit
 *  vector unpacking algorithm.
 *
 *  To make your own table compile this file and run it:
 *  $ gcc geniltab.c -o geniltab -lm
 *  $ ./geniltab
 *
 *  The table is written to "iltab.gen.c" in the current directory.
 *
 */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "constants.h"

static double t[ILTAB_SIZE];

static void gentab(void) {
  unsigned p, xb, yb;
  double x, y, z;
  for (p = 0; p < ILTAB_SIZE; p++) {
    xb = p >> 7;
    yb = p & BOTTOM_MASK;
    if (xb + yb >= 127) { 
      xb = 127 - xb;
      yb = 127 - yb; 
    }
    x = xb;
    y = yb;
    z = 126.0 - xb - yb;
    t[p] = 1.0 / sqrt(y*y + z*z + x*x);
  }
}

int main(int argc, char **argv) {
  FILE *f;
  int i;
  if (!(f = fopen("iltab.gen.c", "w"))) {
    perror("fopen");
    exit(1);
  }
  gentab();
  fprintf(f, "/* Automatically generated by %s */\n", argv[0]);
  fprintf(f, "static float iltab[] = {\n");
  for (i = 0; i < ILTAB_SIZE - 4; i += 4)
    fprintf(f, "%.12ff, %.12ff, %.12ff, %.12ff,\n", t[i], t[i+1], t[i+2], t[i+3]);
  fprintf(f, "%.12ff, %.12ff, %.12ff, %.12ff\n", t[i], t[i+1], t[i+2], t[i+3]);
  fprintf(f, "};\n");
  fclose(f);
  return 0;
}
