#!/usr/bin/perl -w
#
#    normalizer.pl
#
#    $Id: normalizer.pl,v 1.6 2001/06/26 05:53:00 mrperl Exp $
#
#    Copyright (c) 2000 Brian Stell and James
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

require 5.6.0;
use strict;

use POSIX qw(locale_h errno);
#use utf8;

use ExtUtils::testlib;
use ICU qw( U_ZERO_ERROR );
use ICU::Normalizer qw( :EMode :EModeBit :EStatus :EOption );

   print "Normalizer class sample program\n\n";

   print "ignore_hangul = ", IGNORE_HANGUL;

   my $status = 0;

   my $input = "a\x{0300} biento\x{0302}t garc\x{0327}on," . "\x{00e0} bient\x{00f4}t gar\x{00e7}on.";
   print "input string : $input\n";

   $status = U_ZERO_ERROR;
   print "composition: ", ICU::Normalizer::compose($input, DECOMP_BIT, IGNORE_HANGUL, \$status), ", status = $status\n";

   $status = U_ZERO_ERROR;
   print "decomposition : ", ICU::Normalizer::decompose($input, COMPAT_BIT, IGNORE_HANGUL, \$status), ", status = $status\n";

   $status = U_ZERO_ERROR;
   print "normalization with decomposition (D): ", ICU::Normalizer::normalize($input, DECOMP, IGNORE_HANGUL, \$status), ", status = $status\n";

   $status = U_ZERO_ERROR;
   print "normalization with composition (C): ", ICU::Normalizer::normalize($input, COMPOSE, IGNORE_HANGUL, \$status), ", status = $status\n";

